var $__imu_get_bigimage = function(shared_variables) {
	var _nir_debug_ = shared_variables['_nir_debug_'];
	var nir_debug = shared_variables['nir_debug'];
	var Math_floor = shared_variables['Math_floor'];
	var Math_round = shared_variables['Math_round'];
	var Math_random = shared_variables['Math_random'];
	var Math_max = shared_variables['Math_max'];
	var Math_min = shared_variables['Math_min'];
	var Math_abs = shared_variables['Math_abs'];
	var Math_pow = shared_variables['Math_pow'];
	var get_random_text = shared_variables['get_random_text'];
	var console_log = shared_variables['console_log'];
	var console_error = shared_variables['console_error'];
	var console_warn = shared_variables['console_warn'];
	var console_trace = shared_variables['console_trace'];
	var JSON_stringify = shared_variables['JSON_stringify'];
	var JSON_parse = shared_variables['JSON_parse'];
	var base64_decode = shared_variables['base64_decode'];
	var base64_decode_urlsafe = shared_variables['base64_decode_urlsafe'];
	var base64_encode = shared_variables['base64_encode'];
	var is_array = shared_variables['is_array'];
	var array_indexof = shared_variables['array_indexof'];
	var string_indexof = shared_variables['string_indexof'];
	var string_fromcharcode = shared_variables['string_fromcharcode'];
	var string_charat = shared_variables['string_charat'];
	var array_extend = shared_variables['array_extend'];
	var array_foreach = shared_variables['array_foreach'];
	var array_map = shared_variables['array_map'];
	var array_or_null = shared_variables['array_or_null'];
	var array_upush = shared_variables['array_upush'];
	var string_replaceall = shared_variables['string_replaceall'];
	var match_all = shared_variables['match_all'];
	var obj_foreach = shared_variables['obj_foreach'];
	var obj_extend = shared_variables['obj_extend'];
	var shallowcopy = shared_variables['shallowcopy'];
	var deepcopy = shared_variables['deepcopy'];
	var _ = shared_variables['_'];
	var settings = shared_variables['settings'];
	var new_map = shared_variables['new_map'];
	var map_set = shared_variables['map_set'];
	var map_get = shared_variables['map_get'];
	var map_has = shared_variables['map_has'];
	var map_remove = shared_variables['map_remove'];
	var map_foreach = shared_variables['map_foreach'];
	var map_size = shared_variables['map_size'];
	var new_set = shared_variables['new_set'];
	var set_add = shared_variables['set_add'];
	var set_has = shared_variables['set_has'];
	var set_remove = shared_variables['set_remove'];
	var real_api_cache = shared_variables['real_api_cache'];
	var real_api_query = shared_variables['real_api_query'];
	var real_website_query = shared_variables['real_website_query'];
	var is_invalid_url = shared_variables['is_invalid_url'];
	var mod = shared_variables['mod'];
	var norm_url = shared_variables['norm_url'];
	var urljoin = shared_variables['urljoin'];
	var fillobj = shared_variables['fillobj'];
	var fillobj_urls = shared_variables['fillobj_urls'];
	var add_full_extensions = shared_variables['add_full_extensions'];
	var add_full_extensions2 = shared_variables['add_full_extensions2'];
	var add_extensions = shared_variables['add_extensions'];
	var add_extensions_jpeg = shared_variables['add_extensions_jpeg'];
	var add_extensions_with_jpeg = shared_variables['add_extensions_with_jpeg'];
	var add_extensions_gif = shared_variables['add_extensions_gif'];
	var add_extensions_upper = shared_variables['add_extensions_upper'];
	var add_extensions_upper_jpeg = shared_variables['add_extensions_upper_jpeg'];
	var add_extensions_from_webp = shared_variables['add_extensions_from_webp'];
	var add_http = shared_variables['add_http'];
	var force_https = shared_variables['force_https'];
	var decodeuri_ifneeded = shared_variables['decodeuri_ifneeded'];
	var encodeuri_ifneeded = shared_variables['encodeuri_ifneeded'];
	var replace_sizes = shared_variables['replace_sizes'];
	var zpadnum = shared_variables['zpadnum'];
	var hex_to_ascii = shared_variables['hex_to_ascii'];
	var hex_to_numberarray = shared_variables['hex_to_numberarray'];
	var numberarray_to_hex = shared_variables['numberarray_to_hex'];
	var reverse_str = shared_variables['reverse_str'];
	var decode_entities = shared_variables['decode_entities'];
	var encode_entities = shared_variables['encode_entities'];
	var encode_regex = shared_variables['encode_regex'];
	var get_queries = shared_variables['get_queries'];
	var stringify_queries = shared_variables['stringify_queries'];
	var remove_queries = shared_variables['remove_queries'];
	var keep_queries = shared_variables['keep_queries'];
	var add_queries = shared_variables['add_queries'];
	var fuzzify_text = shared_variables['fuzzify_text'];
	var fuzzy_date_compare = shared_variables['fuzzy_date_compare'];
	var parse_headers = shared_variables['parse_headers'];
	var headers_list_to_dict = shared_variables['headers_list_to_dict'];
	var headers_dict_to_list = shared_variables['headers_dict_to_list'];
	var get_resp_finalurl = shared_variables['get_resp_finalurl'];
	var get_ext_from_contenttype = shared_variables['get_ext_from_contenttype'];
	var get_library = shared_variables['get_library'];
	var normalize_whitespace = shared_variables['normalize_whitespace'];
	var strip_whitespace = shared_variables['strip_whitespace'];
	var get_image_size = shared_variables['get_image_size'];
	var sort_by_key = shared_variables['sort_by_key'];
	var sort_by_array = shared_variables['sort_by_array'];
	var parse_tag_def = shared_variables['parse_tag_def'];
	var get_meta = shared_variables['get_meta'];
	var fixup_js_obj = shared_variables['fixup_js_obj'];
	var fixup_js_obj_proper = shared_variables['fixup_js_obj_proper'];
	var common_functions = shared_variables['common_functions'];
	var get_domain_from_url = shared_variables['get_domain_from_url'];
	var get_domain_nosub = shared_variables['get_domain_nosub'];
	var looks_like_valid_link = shared_variables['looks_like_valid_link'];
	var IMUCache = shared_variables['IMUCache'];
	var url_basename = shared_variables['url_basename'];
	var parse_int = shared_variables['parse_int'];
	var get_localstorage = shared_variables['get_localstorage'];

	return {
		bigimage: function(src, options) {
			// for element_ok with elements without sources (src == null)
			// function too large for analysis
			// @ts-expect-error
			if (!src) {
				src = "data:";
				//return src;
			}
			if (!src.match(/^(?:https?|x-raw-image):\/\//) && !src.match(/^(?:data|blob):/))
				return src;
			var origsrc = src;
			src = norm_url(src);
			var protocol;
			var domain;
			var port;
			if (!src.match(/^(?:data|x-raw-image|blob):/)) {
				// to prevent infinite loops
				if (src.length >= 65535)
					return src;
				var protocol_split = src.split("://");
				protocol = protocol_split[0];
				var splitted = protocol_split[1].split("/");
				domain = splitted[0];
				port = domain.replace(/.*:([0-9]+)$/, "$1");
				if (port === domain)
					port = "";
				domain = domain.replace(/(.*):[0-9]+$/, "$1");
			} else {
				//protocol = src.replace(/^([-a-z]+):.*/, "$1");
				protocol = "data";
				domain = "";
				src = ""; // FIXME: this isn't great
			}
			var domain_nowww = domain.replace(/^www\./, "");
			var domain_nosub = get_domain_nosub(domain);
			var amazon_container = null;
			if (string_indexof(domain, ".amazonaws.com") >= 0) {
				// https://timely-api-public.s3.us-west-2.amazonaws.com/116743_phpg7Ixww_small.JPG
				// https://pixls-discuss.s3.dualstack.us-east-1.amazonaws.com/optimized/3X/0/5/0530ef1424b7bace746cd10d2bc26b5cd58d5e27_2_690x388.png
				// http://stezor-img-res.s3-website.eu-central-1.amazonaws.com/600x0/0eefab17-aa8b-4f8e-9017-7b9442d1ee9e
				if (domain.match(/^s3(?:-website)?(?:\.dualstack)?(?:[-.][-a-z0-9]+)?\.amazonaws\.com/))
					amazon_container = src.replace(/^[a-z]*:\/\/[^/]*\/+([^/]*)\/.*/, "$1");
				else if (domain.match(/[^/]*\.s3(?:-website)?(?:\.dualstack)?(?:[-.][-a-z0-9]+)?\.amazonaws\.com/))
					amazon_container = src.replace(/^[a-z]*:\/\/([^/]*)\.s3(?:-website)?(?:\.dualstack)?(?:[-.][-a-z0-9]+)?\.amazonaws\.com\/.*/, "$1");
			}
			var googleapis_container = null;
			if (string_indexof(domain, ".googleapis.com") >= 0) {
				googleapis_container = src.replace(/^[a-z]*:\/\/[^/]*\/([^/]*)\/.*/, "$1");
			}
			var googlestorage_container = null;
			if (domain_nosub === "googleapis.com" &&
				(domain === "storage.googleapis.com" ||
					domain.match(/\.storage\.googleapis\.com$/) ||
					domain === "commondatastorage.googleapis.com" ||
					domain.match(/\.commondatastorage\.googleapis\.com$/))) {
				if (domain.match(/\.[a-z]+\.googleapis\.com$/)) {
					googlestorage_container = src.replace(/^[a-z]*:\/\/([^/]*)\.[a-z]+\.googleapis\.com\/.*/, "$1");
				} else {
					googlestorage_container = src.replace(/^[a-z]*:\/\/[^/]*\/([^/]*)\/.*/, "$1");
				}
			}
			var digitalocean_container = null;
			if (domain_nosub === "digitaloceanspaces.com") {
				// https://sfo2.digitaloceanspaces.com/btrtoday/uploads/20190611114017/ft.Cyberpunk2077.jpg
				// https://btrtoday.sfo2.digitaloceanspaces.com/uploads/20190611114017/ft.Cyberpunk2077.jpg
				// https://movieassetsdigital.sgp1.cdn.digitaloceanspaces.com/thumb/ca584e585152f32d7eeb9fb1837732ea5566d431
				if (/^[a-z]{3}[0-9]+\.(?:cdn\.)?digitaloceanspaces\./.test(domain)) {
					digitalocean_container = src.replace(/^[a-z]*:\/\/[^/]*\/+([^/]*)\/.*/, "$1");
				} else {
					digitalocean_container = domain.replace(/^([^/.]+)\..*/, "$1");
				}
			}
			var host_domain = "";
			var host_domain_nowww = "";
			var host_domain_nosub = "";
			if (options.host_url) {
				host_domain = options.host_url.replace(/^[a-z]+:\/\/([^/]*?)(?::[0-9]+)?(?:\/.*)?$/, "$1");
				host_domain_nowww = host_domain.replace(/^www\./, "");
				host_domain_nosub = host_domain.replace(/^.*\.([^.]*\.[^.]*)$/, "$1");
				if (host_domain_nosub.match(/^co\.[a-z]{2}$/)) {
					host_domain_nosub = host_domain.replace(/^.*\.([^.]*\.[^.]*\.[^.]*)$/, "$1");
				}
			}
			try {
				if (options.document)
					document = options.document;
				if (options.window)
					window = options.window;
			} catch (e) {
				//console_warn("Failed to set document/window", e);
			}
			var problem_excluded = function(problem) {
				if (!options.exclude_problems)
					return false;
				if (typeof options.exclude_problems === "string" && options.exclude_problems === problem)
					return true;
				if (!is_array(options.exclude_problems))
					return false;
				return array_indexof(options.exclude_problems, problem) >= 0;
			};
			var api_cache = real_api_cache;
			if (options.use_api_cache === false) {
				api_cache = new IMUCache();
			}
			if (!options.api_cache) {
				options.api_cache = api_cache;
			}
			var api_query = function(key, request, cb, process) {
				return real_api_query(api_cache, options.do_request, key, request, cb, process);
			};
			var website_query = function(_options) {
				_options.do_request = options.do_request;
				_options.api_cache = api_cache;
				if (!_options.cb)
					_options.cb = options.cb;
				if (!_options.url)
					_options.url = src;
				return real_website_query(_options);
			};
			var newsrc, i, id, size, origsize, regex, match;
			// instart logic morpheus
			// test urls:
			// char - 5
			// https://c-6rtwjumjzx7877x24nrlncx2ewfspjwx2ehtr.g00.ranker.com/g00/3_c-6bbb.wfspjw.htr_/c-6RTWJUMJZX77x24myyux78x3ax2fx2fnrlnc.wfspjw.htrx2fzx78jw_stij_nrlx2f94x2f415044x2ftwnlnsfqx2fjzs-on-bts-wjhtwinsl-fwynx78yx78-fsi-lwtzux78-umtyt-z6x3fbx3d105x26vx3d05x26krx3doulx26knyx3dhwtux26hwtux3dkfhjx78x26n65h.rfwp.nrflj.yduj_$/$/$/$/$/$
			//   https://imgix.ranker.com/user_node_img/49/960599/original/eun-ji-won-recording-artists-and-groups-photo-u1?w=650&q=50&fm=jpg&fit=crop&crop=faces
			// https://c-6rtwjumjzx7877x24nrlncx2ewfspjwx2ehtr.g00.ranker.com/g00/3_c-6bbb.wfspjw.htr_/c-6RTWJUMJZX77x24myyux78x3ax2fx2fnrlnc.wfspjw.htrx2fzx78jw_stij_nrlx2f03x2f6698837x2ftwnlnsfqx2fmjj-hmzq-umtyt-z4x3fbx3d105x26vx3d05x26krx3doulx26knyx3dhwtux26hwtux3dkfhjx78x26n65h.rfwp.nrflj.yduj_$/$/$/$/$/$
			//   https://imgix.ranker.com/user_node_img/58/1143382/original/hee-chul-photo-u9?w=650&q=50&fm=jpg&fit=crop&crop=faces
			// https://c-6rtwjumjzx7877x24nrlncx2ewfspjwx2ehtr.g00.ranker.com/g00/3_c-6bbb.wfspjw.htr_/c-6RTWJUMJZX77x24myyux78x3ax2fx2fnrlnc.wfspjw.htrx2fzx78jw_stij_nrlx2f16x2f6757374x2ftwnlnsfqx2fmdzs-dtzsl-z7x3fbx3d105x26vx3d05x26krx3doulx26knyx3dhwtux26hwtux3dkfhjx78x26n65h.rfwp.nrflj.yduj_$/$/$/$/$/$
			//   https://imgix.ranker.com/user_node_img/61/1202829/original/hyun-young-u2?w=650&q=50&fm=jpg&fit=crop&crop=faces
			// https://c-7npsfqifvt0x24jnh-t-nto-dpnx2eblbnbjafex2eofu.g01.msn.com/g00/3_c-7x78x78x78.nto.dpn_/c-7NPSFQIFVT0x24iuuqtx3ax2fx2fjnh-t-nto-dpn.blbnbjafe.ofux2fufoboux2fbnqx2ffoujuzjex2fBBFFIbi.jnhx3fix3d2191x26x78x3d2031x26nx3d7x26rx3d71x26px3dgx26mx3dgx26yx3d665x26zx3d341x26j21d.nbslx3djnbhf_$/$/$/$/$
			//   https://img-s-msn-com.akamaized.net/tenant/amp/entityid/AAEEHah.img
			//
			// http://c-6rtwjumjzx7877x24bbbx2esfstanx78twx2ent.g00.tomshardware.com/g00/3_c-6bbb.ytrx78mfwibfwj.htr_/c-6RTWJUMJZX77x24myyux78x3ax2fx2fbbb.sfstanx78tw.ntx2fx40u6x2fHfhmjfgqjHXXx3fywfhpx26n65h.rfwp.qnsp.yduj_$/$/$
			//   https://www.nanovisor.io/@p1/CacheableCSS?track
			//
			// char - 8
			// https://c-5uwzmx78pmca09x24quoqfx2ezivsmzx2ekwu.g00.ranker.com/g00/3_c-5eee.zivsmz.kwu_/c-5UWZMXPMCA09x24pbbx78ax3ax2fx2fquoqf.zivsmz.kwux2fcamz_vwlm_quox2f25x2f716313x2fwzqoqvitx2fmuui-eibawv-x78mwx78tm-qv-bd-x78pwbw-c01x3fex3d903x26px3d903x26nqbx3dkzwx78x26kzwx78x3dnikmax26yx3d48x26nux3drx78ox26q98k.uizs.quiom.bgx78m_$/$/$/$/$/$
			//   https://imgix.ranker.com/user_node_img/47/938535/original/emma-watson-people-in-tv-photo-u23?w=125&h=125&fit=crop&crop=faces&q=60&fm=jpg
			//
			// http://c-6rtwjumjzx7877x24zlh-56x2ehfkjrtrx78yfynhx2ehtr.g00.cafemom.com/g00/3_c-6ymjx78ynw.hfkjrtr.htr_/c-6RTWJUMJZX77x24myyux78x3ax2fx2fzlh-56.hfkjrtrx78yfynh.htrx2fljsx2fhwtux2f705x2f695x2f25x2f7563x2f57x2f56x2f65x2f82x2fibx2futpmy32vnt27.uslx3fn65h.rfwpx3dnrflj_$/$/$/$/$/$/$/$/$/$/$/$/$
			//   https://ugc-01.cafemomstatic.com/gen/crop/250/140/70/2018/02/01/10/37/dw/pokht87qio72.png
			if (string_indexof(src, "/g00/") >= 0 && /\.g0[0-9]\./.test(domain)) {
				var str = "";
				//var i;
				// decode x[0-9][0-9] to \x[0-9][0-9]
				for (i = 0; i < src.length; i++) {
					if (src[i] == 'x') {
						var char = parseInt(src[i + 1] + src[i + 2], 16);
						str += string_fromcharcode(char);
						i += 2;
					} else {
						str += src[i];
					}
				}
				str = str.split("/").slice(5).join("/").split("$").slice(1).join("$");
				if (str && string_indexof(str, "://") < 10 && str[1] == str[2]) {
					var diff = mod(str.charCodeAt(0) - 'h'.charCodeAt(0), 26);
					// char - diff
					var str1 = "";
					for (i = 0; i < str.length; i++) {
						var code = str.charCodeAt(i);
						if (code > 47 && code < 58) {
							/* number */
							code = (mod((code - 48 - diff), 10) + 48);
						} else if (code > 64 && code < 91) {
							/* uppercase */
							code = (mod((code - 65 - diff), 26) + 65);
						} else if (code > 96 && code < 123) {
							/* lowercase */
							code = (mod((code - 97 - diff), 26) + 97);
						}
						str1 += string_fromcharcode(code);
					}
					var urlparts = str1;
					if (urlparts && string_indexof(urlparts, "http") === 0) {
						var $s = urlparts.replace(/.*?([$/]*)$/, "$1");
						if ($s !== urlparts && $s) {
							var count = $s.split("$").length - 1;
							if (count > 0) {
								// + 2 for http://
								var newurl = urlparts.split("/").slice(0, count + 2).join("/");
								// https://ugc-01.cafemomstatic.com/gen/crop/250/140/70/2018/02/01/10/37/dw/pokht87qio72.png?i10c.mark=image_$
								//newurl = newurl.split("&").slice(0,-1).join("&"); // remove &i10c.mark.link.type_...
								newurl = newurl.replace(/[?&]i10c\.mark[^/]*$/, "");
								if (newurl)
									return newurl;
							}
						}
					} else {
						console_log(urlparts);
					}
				}
			}
			// -- start bigimage --
			if ((host_domain_nowww === "google.com" ||
				domain_nowww === "google.com") && /^[a-z]+:\/\/[^/]+\/+recaptcha\//.test(options.host_url)) {
				return {
					url: origsrc,
					bad: "mask"
				};
			}
			if (host_domain === "assets.hcaptcha.com" || domain === "assets.hcaptcha.com" || domain === "imgs.hcaptcha.com") {
				return {
					url: origsrc,
					bad: "mask"
				};
			}
			if (domain === "img.hankyung.com" ||
				domain === "img.tenasia.hankyung.com") {
				newsrc = src.replace(/(\/photo\/+[0-9]{6}\/+[0-9A-Z]{2}\.[0-9]+\.[0-9]+)-[0-9]*x[0-9]*(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
				if (newsrc !== src)
					return newsrc;
				if (src.match(/\.[0-9](\.[^/.]*)(?:[?#].*)?$/)) {
					newsrc = src.replace(/[?#].*$/, "");
					if (newsrc !== src)
						return newsrc;
					return [
						src.replace(/\.[0-9](\.[^/.]*)$/, ".4$1"),
						src.replace(/\.[0-9](\.[^/.]*)$/, ".1$1")
					];
				}
			}
			if (domain_nosub === "naver.net" ||
				domain_nosub === "pstatic.net") {
				if (string_indexof(domain, "gfmarket.") >= 0) {
					return src;
				}
				if (/\/img\.tvcast\/+pc\/+img\/+/.test(src) ||
					/\/static\/+m\/+vlive\/+pc\/+[0-9]{4}\/+(?:[0-9]{2}\/+){2}profile_noimg_[a-z]+\./.test(src) ||
					/\/static\.post\/+image\/+im\/+/.test(src)) {
					return {
						url: src,
						bad: "mask"
					};
				}
				if (domain.match(/tv[0-9]*\.search\.naver\.net/) ||
					domain.match(/tv[0-9]*\.pstatic\.net/)) {
					return src.replace(/.*\/thm\?.*?q=/, "");
				}
				if (src.match(/[?&]src=/)) {
					return decodeURIComponent(src.replace(/.*src=*([^&]*).*/, "$1")).replace(/^"*/, '').replace(/"$/, '');
				}
				if (domain.search(/^[-a-z0-9]*cafe[-a-z0-9]*\./) < 0 &&
					domain.search(/^img-pholar[-a-z0-9]*\./) < 0 &&
					domain.search(/^shopping-phinf[-a-z0-9]*\./) < 0 &&
					domain.search(/^dic.phinf.naver.net/) < 0 &&
					domain.search(/^musicmeta.phinf.naver.net/) < 0 && false)
					src = src.replace(/\?type=[^/]*$/, "?type=w1");
				else
					src = src.replace(/\?type=[^/]*$/, "");
				src = src.replace(/#[^/]*$/, "");
				if (domain.search(/^[-a-z0-9]*blog[-a-z0-9]*\./) < 0 &&
					domain.search(/^[-a-z0-9]*cafe[-a-z0-9]*\./) < 0 &&
					domain.search(/^[-a-z0-9]*news[-a-z0-9]*\./) < 0 &&
					domain.search(/^[-a-z0-9]*post[-a-z0-9]*\./) < 0 &&
					domain.search(/^[-a-z0-9]*v.phinf[-a-z0-9]*\./) < 0 &&
					domain.search(/^[-a-z0-9]*shopping.phinf[-a-z0-9]*\./) < 0 &&
					domain.search(/^[-a-z0-9]*musicmeta.phinf[-a-z0-9]*\./) < 0) {
					return src;
				}
				newsrc = src
					.replace(/postfiles[^/.]*\./, "blogfiles.")
					.replace(/m?blogthumb[^./]*/, "blogfiles")
					.replace(/blogfiles[^/.]*\./, "blogfiles.")
					.replace(/postfiles[^/.]*\./, "blogfiles.")
					.replace(/cafeptthumb[^./]*/, "cafefiles")
					.replace(/cafeskthumb[^./]*/, "cafefiles")
					.replace(/m?cafethumb[^./]*/, "cafefiles")
					.replace(/cafefiles[^/.]*\./, "cafefiles.")
					.replace(/mimgnews[^./]*/, "imgnews")
					.replace(/v\.phinf\./, "v-phinf.")
					.replace(/musicmeta\.phinf\./, "musicmeta-phinf.")
					.replace(/shopping\.phinf\./, "shopping-phinf.")
					.replace(/blogpfthumb\.phinf\./, "blogpfthumb-phinf.")
					.replace(/(:\/\/blogfiles\.)pstatic\.net\/+/, "$1naver.net/")
					.replace(/^https?(:\/\/[^/.]*(?:phinf|files)\.naver\.net\/)/, "http$1");
				if (newsrc !== src)
					return newsrc;
				return {
					url: src,
					headers: {
						Referer: ""
					},
					referer_ok: {
						same_domain_nosub: true
					},
					head_wrong_contenttype: true // no content-type
				};
			}
			if ((domain_nosub === "daumcdn.net" ||
				domain_nosub === "kakaocdn.net") &&
				string_indexof(src, "/thumb/") >= 0) {
				return decodeURIComponent(src.replace(/.*fname=([^&]*).*/, "$1"));
			}
			if (domain_nosub === "daumcdn.net" && /^(?:t|img)[0-9]*\./.test(domain)) {
				if (/\/cafe_image\/+fancafe\/+[0-9]+\/+fancafe-cheer-color-bg\./.test(src) ||
					/\/tistory_admin\/+lib\/+lightbox\//.test(src) ||
					/\/kakaotv\/+[0-9]+\/+(?:pw|player\/+web)\/+(?:(?:new|pc)\/+)?(?:slider_mask|bg_box|img_back(?:logo|cover))/.test(src)) {
					return {
						url: src,
						bad: "mask"
					};
				}
			}
			if ((domain_nosub === "tistory.com" ||
				domain_nosub === "daum.net") &&
				(domain.match(/\.uf\.[a-z]+\.[a-z]+$/) ||
					domain.match(/^cfs[0-9]*\./))) {
				return src
					.replace("/attach/", "/original/")
					.replace("/media/", "/original/")
					.replace("/image/", "/original/")
					.replace(/\/[RTC][0-9]*x[0-9]*\//, "/original/");
			}
			if (domain_nosub === "daumcdn.net" &&
				domain.match(/^t[0-9]*\.daumcdn\.net/)) {
				return src.replace(/(\/cfile\/(?:tistory\/)?[0-9A-F]+)(?:\\?.*)$/, "$1?original");
			}
			if (domain_nosub === "daumcdn.net" &&
				domain.match(/^i[0-9]*\.media\./)) {
				return src.replace(/\/uf\/image\//, "/uf/original/");
			}
			if (domain_nosub === "daumcdn.net" &&
				domain.match(/^[mi][0-9]*\.daumcdn\.net/)) {
				return src.replace(/:\/\/[^/]*\/(cfile[0-9]+)\//, "://$1.uf.daum.net/");
			}
			if (domain_nosub === "daumcdn.net" && /^i[0-9]*\.tvpot\./.test(domain)) {
				return src.replace(/(\/thumb\.[a-z0-9]+)\.mini(?:[?#].*)?$/, "$1");
			}
			if (domain === "image.news1.kr" ||
				domain === "i2n.news1.kr") {
				newsrc = src.replace(/\/+dims\/.*/, "");
				if (newsrc !== src)
					return newsrc;
				newsrc = src
					.replace(/\/thumbnails\/(.*)\/thumb_[0-9]+x(?:[0-9]+)?(\.[^/.]*)$/, "/$1/original$2")
					.replace(/main_thumb\.jpg/, "original.jpg")
					.replace(/article.jpg/, "original.jpg")
					.replace(/no_water.jpg/, "original.jpg")
					.replace(/photo_sub_thumb.jpg/, "original.jpg")
					.replace(/section_top\.jpg/, "original.jpg")
					.replace(/high\.jpg/, "original.jpg");
				var filename = src.replace(/.*\/photos\/+[0-9]{4}\/+(?:[0-9]{1,2}\/+){2}([0-9]+)\/+.*$/, "$1");
				if (filename !== src) {
					return {
						url: newsrc,
						filename: filename,
						extra: {
							page: "http://news1.kr/photos/view/?" + filename
						},
						can_head: false // hangs, thanks to f2005 on discord for reporting
					};
				}
				return newsrc;
			}
			if (string_indexof(domain, ".joins.com") >= 0) {
				newsrc = src.replace(/\.tn_[0-9]*\..*/, "");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "ir.joins.com" ||
				domain === "loki.zhibotie.net") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/.*?[?&]u=([^&]*).*$/, "$1");
				if (newsrc !== src)
					return decodeuri_ifneeded(newsrc);
			}
			if (domain_nosub === "koreadaily.com" &&
				domain.match(/^thumb[0-9]*\./)) {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/tn\.dll.*?[?&]url=([^&]*).*?$/, "$1");
				if (newsrc !== src)
					return decodeURIComponent(newsrc);
			}
			if (domain === "uhd.img.topstarnews.net") {
				return src
					.replace("/file_attach_thumb/", "/file_attach/")
					.replace(/_[^/]*[0-9]*x[0-9]*_[^/]*(\.[^/]*)$/, "-org$1")
					.replace(/(-[0-9]*)(\.[^/]*)$/, "$1-org$2");
			}
			if (domain_nowww === "topstarnews.net" ||
				domain === "cdn.topstarnews.net" ||
				domain === "cds.topstarnews.net") {
				newsrc = src.replace(/:\/\/[^/]*\/(.*\/photo\/.*_[0-9]+)(\.[^/.]*)\/.*$/, "://www.topstarnews.net/$1_org$2");
				if (newsrc !== src)
					return newsrc;
				return src
					.replace(/_v[0-9]+(\.[^/.]*)$/, "_org$1")
					.replace(/(_[0-9]+)(\.[^/.]*)$/, "$1_org$2")
					.replace("/thumbnail/", "/photo/");
			}
			if (domain === "thumb.mt.co.kr" ||
				domain === "thumb.mtstarnews.com") {
				newsrc = src.replace(/\/+dims\/.*/, "");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/^[a-z]+:\/\/thumb\.([^/]*)\/+([^/]*\/+)?[0-9]{2}\/+([0-9]{4}\/+[0-9]{2}\/+[0-9]{8,}_[0-9]+\.)/, "http://image.$1/$2$3");
				if (newsrc !== src)
					return newsrc;
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+star_realdisp\.php\?(?:.*&)?ImageID=([0-9]+_[0-9]+\.[a-z]+)(?:[&#].*)?$/,
					run: function(cb, match) {
						var url = match[1];
						var urlmatch = url.match(/^([0-9]{4})([0-9]{2})/);
						cb("https://thumb.mtstarnews.com/06/" + urlmatch[1] + "/" + urlmatch[2] + "/" + url);
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain === "menu.mt.co.kr" ||
				domain === "img.koreatimes.co.kr" ||
				domain_nosub === "myskcdn.com") {
				if (/\/images\/+bg_[a-z]+[0-9]+\.png(?:[?#].*)?$/.test(src))
					return {
						url: src,
						bad: "mask"
					};
				var obj = src.match(/\/thumb\/+(?:[0-9]+\/+){2,3}([0-9]+)\/[0-9]{10,}_/);
				if (obj && obj[1] !== "00") {
					var obj1_str = src.replace(/.*\/thumb\/+([0-9]+\/+[0-9]+\/+[0-9]+\/).*/, "$1").replace(/\//g, "");
					var obj1 = parseInt(obj1_str);
					var num = "00";
					if (obj1 < 20170526)
						num = "06";
					src = src.replace(/(\/thumb\/+(?:[0-9]+\/+){2,3})[0-9]+(\/+[0-9]{10,}_)/, "$1" + num + "$2");
				}
				return src
					.replace(/\/dims\/.*/, "");
			}
			if (domain === "tkfile.yes24.com") return src.replace(/(\/upload2\/.*?)\/dims\/+.*/, "$1");
			if (domain === "cdn.music-flo.com") return src.replace(/(\/image\/.*?)(?:[?#].*)?$/, "$1");
			if (domain === "static.discovery-expedition.com") return src.replace(/(\/images\/.*)\/dims\/.*/, "$1");
			if (domain === "image.genie.co.kr") {
				return src.replace(/(\/image\/.*)\/dims\/.*/i, "$1");
			}
			if (domain === "img.enews24.cjenm.skcdn.com") {
				return src
					.replace(/\/News\/NewsThumbnail(\/[0-9]+\/)(?:[0-9]+_)?([0-9]+\.[^/.]*)$/, "/News/Contents$1$2")
					.replace(/(\/Photo\/Contents\/[0-9]+\/)[0-9]+_([0-9]+\.[^/.]*)$/, "$1$2");
			}
			if (domain_nosub === "stardailynews.co.kr" ||
				domain_nosub === "liveen.co.kr" ||
				domain_nosub === "ilyoseoul.co.kr" ||
				domain_nosub === "sportsq.co.kr" ||
				domain_nosub === "zenithnews.com" ||
				domain_nowww === "munhwanews.com" ||
				domain_nowww === "mhns.co.kr" ||
				domain_nowww === "ccdailynews.com" ||
				domain === "ph.kyeonggi.com" ||
				domain_nowww === "jemin.com" ||
				domain_nowww === "domin.co.kr" ||
				domain === "cdn.jejudomin.co.kr" ||
				domain === "ph.incheonilbo.com" ||
				domain_nowww === "hidomin.com" ||
				domain_nowww === "newsfreezone.co.kr" ||
				domain === "cdn.newsfreezone.co.kr" ||
				domain_nowww === "newsinside.kr" ||
				domain === "cdn.newsinside.kr" ||
				domain_nowww === "greenpostkorea.co.kr" ||
				domain_nowww === "egn.kr" ||
				domain_nowww === "whitepaper.co.kr" ||
				domain_nowww === "outdoornews.co.kr" ||
				domain_nowww === "shinailbo.co.kr" ||
				domain_nowww === "ngtv.tv" ||
				domain_nowww === "rnx.kr" ||
				domain_nowww === "intronews.net" ||
				domain_nowww === "hg-times.com" ||
				domain_nowww === "iemn.kr" ||
				domain_nosub === "newscj.com" ||
				domain_nowww === "ggilbo.com" ||
				domain_nowww === "bstoday.kr" ||
				domain === "interfootball.heraldcorp.com" ||
				domain_nowww === "ilyosisa.co.kr" ||
				domain_nowww === "ynnews.kr" ||
				domain_nowww === "starilbo.com" ||
				domain_nowww === "autoherald.co.kr" ||
				domain_nowww === "00news.co.kr" ||
				domain_nowww === "kstarfashion.com" ||
				domain_nowww === "inewspeople.co.kr" ||
				domain_nowww === "wonnews.co.kr" ||
				domain_nosub === "gukjenews.com" ||
				domain_nowww === "lunarglobalstar.com" ||
				domain_nowww === "sundayjournal.kr" ||
				domain_nowww === "stnsports.co.kr" ||
				domain_nowww === "thekpm.com" ||
				domain === "chunchu.yonsei.ac.kr" ||
				domain_nowww === "e2news.com" ||
				domain === "ph.spotvnews.co.kr" ||
				domain_nowww === "sisunnews.co.kr" ||
				domain_nowww === "kpinews.co.kr" ||
				domain_nowww === "4th.kr" ||
				domain === "cds.topdaily.kr" ||
				domain_nowww === "kntimes.co.kr" ||
				domain_nowww === "senmedia.kr" ||
				domain_nowww === "siminilbo.co.kr" ||
				domain_nowww === "sisafocus.co.kr" ||
				domain_nowww === "futurekorea.co.kr" ||
				domain_nowww === "dailygrid.net" ||
				domain_nowww === "datanet.co.kr" ||
				domain_nowww === "slist.kr" ||
				domain_nowww === "secondmirror.co.kr" ||
				domain_nowww === "ntoday.co.kr" ||
				domain_nowww === "seoulilbo.com" ||
				domain_nowww === "lecturernews.com" ||
				domain_nowww === "youthdaily.co.kr" ||
				domain_nowww === "mdaily.net" ||
				domain_nowww === "cctoday.co.kr" ||
				domain_nowww === "gnmaeil.com" ||
				domain_nosub === "mhnew.com" ||
				domain_nowww === "mediadale.com" ||
				domain === "viewers.heraldcorp.com" ||
				domain_nowww === "biztribune.co.kr" ||
				domain_nowww === "obsnews.co.kr" ||
				domain_nowww === "kyeonggi.com" ||
				domain_nowww === "iloveorganic.co.kr" ||
				domain_nowww === "newslock.co.kr" ||
				domain_nowww === "news33.net" ||
				domain_nowww === "mainnews.kr" ||
				domain_nowww === "ilemonde.com" ||
				domain_nowww === "canews.kr" ||
				domain_nowww === "newsflix.co.kr" ||
				domain_nowww === "gokorea.kr" ||
				domain_nowww === "womaneconomy.kr" ||
				domain_nowww === "apsk.co.kr" ||
				domain_nowww === "sporbiz.co.kr" ||
				domain_nowww === "lovesbeauty.co.kr" ||
				domain_nowww === "ikoreadaily.co.kr" ||
				domain_nowww === "interview365.com" ||
				domain_nowww === "newsa.co.kr" ||
				domain_nowww === "newstown.co.kr" ||
				src.match(/^[a-z]+:\/\/[^/]+\/+news\/+thumbnail\/+[0-9]{6}\/+[0-9]+_[0-9]+_[0-9]+_v?150\.[^/.]*(?:[?#].*)?$/)) {
				newsrc = src.replace(/\/thumbnail\/+([0-9]{6}\/+(?:[^/.]*_)?[0-9]+_[0-9]+_[0-9]+)(?:_orgBig)?_v?150(\.[^/.]*)(?:[?#].*)?$/, "/photo/$1$2");
				if (newsrc !== src)
					return add_extensions_upper_jpeg(newsrc);
			}
			if (domain === "shop.newsen.com") return src.replace(/:\/\/[^/]*\/+data\/+thumb\/+[0-9]+_[0-9]+_([0-9][0-9][0-9][0-9])([0-9][0-9])([0-9][0-9])([^/]*)$/, "://photo.newsen.com/news_photo/$1/$2/$3/$1$2$3$4");
			if (domain === "cdn.newsen.com" ||
				domain === "photo.newsen.com") {
				newsrc = src.replace(/_ts\.[^/._]*$/, ".jpg").replace("/mphoto/", "/news_photo/");
				if (newsrc !== src)
					return newsrc;
				if (string_indexof(src, "/main_photo/") >= 0) {
					newsrc = src.replace(/\/main_photo\/+(?:mobile\/+)?[^/]*_([0-9][0-9][0-9][0-9])([0-9][0-9])([0-9][0-9])([^/]*)$/, "/news_photo/$1/$2/$3/$1$2$3$4");
					if (newsrc !== src)
						return newsrc;
				}
				newsrc = src.replace(/\/resize\/+[-0-9]+x[-0-9]+\/+/, "/news_photo/");
				if (newsrc !== src)
					return newsrc;
				var extra = {};
				match = src.match(/cdn\.newsen\.com\/+newsen\/+news_photo\/+[0-9]{4}\/+(?:[0-9]{2}\/+){2}([0-9]{10,})_[0-9]+\.[^/.]*(?:[?#].*)?$/);
				var pageid = null;
				if (match ||
					(match = src.match(/photo\.newsen\.com\/+news_photo\/+[0-9]{4}\/+(?:[0-9]{2}\/+){2}([0-9]{10,})_[0-9]+\.[^/.]*(?:[?#].*)?$/))) {
					pageid = match[1];
					extra.page = "http://www.newsen.com/news_view.php?uid=" + match[1];
				}
				obj = {
					url: src,
					headers: {
						Referer: "http://www.newsen.com/"
					},
					referer_ok: {
						same_domain_nosub: true
					},
					extra: extra
				};
				if (extra.page && options && options.cb && options.allow_thirdparty && options.do_request) {
					var get_imageid = function(url) {
						if (!url)
							return url;
						var match = url.match(/\/[0-9]{4}\/+(?:[0-9]{2}\/+){2}([0-9]{10,}_[0-9]+)\.[^/.]*(?:[?#].*)?$/);
						if (!match)
							return null;
						if (_nir_debug_)
							console_log("Image ID for " + url + ":", match[1]);
						return match[1];
					};
					var get_newsen_pageinfo = function(page, pageid, cb) {
						api_cache.fetch("newsen_pageinfo:" + pageid, cb, function(done) {
							options.do_request({
								method: "GET",
								url: extra.page,
								overrideMimeType: "text/html; charset=euc-kr",
								onload: function(result) {
									if (result.readyState !== 4)
										return;
									if (result.status !== 200) {
										return done(null, false);
									}
									var match = result.responseText.match(/<meta\s+property=["']og:title["']\s+content=["']([^'"]+)["']/);
									if (!match) {
										console_warn("Newsen title not found", result);
										return done(null, false);
									}
									var title = strip_whitespace(match[1]);
									console_log("Title: ", title);
									match = result.responseText.match(/<img\s+id=["']artImg["']\s+src=["'](?:https?:)?\/\/[a-z]+\.newsen\.com\/.*?["']/g);
									if (!match) {
										console_warn("Newsen images not found", result);
										return done(null, false);
									}
									return done({
										page: result.finalUrl,
										title: title,
										images: match
									}, 6 * 60 * 60);
								}
							});
						});
					};
					var get_imagenum_from_newsen_pageinfo = function(image, pageinfo) {
						var imageid = get_imageid(image);
						if (!imageid)
							return null;
						var imagenum;
						for (imagenum = 0; imagenum < pageinfo.images.length; imagenum++) {
							var i_imageid = get_imageid(pageinfo.images[imagenum]);
							if (!i_imageid)
								continue;
							if (i_imageid === imageid)
								break;
						}
						if (imagenum === pageinfo.images.length) {
							return null;
						}
						return imagenum;
					};
					var get_daum_search_results = function(title, cb) {
						api_cache.fetch("newsen_daum_search:" + title, cb, function(done) {
							var searchurl = "https://m.search.daum.net/search?w=news&q=" + encodeURIComponent(title) + "&enc=utf8";
							options.do_request({
								method: "GET",
								url: searchurl,
								onload: function(result) {
									if (result.readyState !== 4) {
										return;
									}
									if (result.status !== 200) {
										return done(null, false);
									}
									var entry_regex = /<a\s+class=["']info_item["']\s+href=["']((?:https?:)\/\/v\.media\.daum\.net\/+.*?)["'][^>]*?>\s*<strong\s+class=["']tit-g[^'"]*["']\s*>\s*([\s\S]*?)\s*<\/strong>/g;
									var nonglobal_regex = new RegExp(entry_regex, "");
									var entries_match = result.responseText.match(entry_regex);
									if (!entries_match) {
										console_error("No search entries found for", result);
										return done(null, false);
									}
									var search_entries = [];
									for (var entry_i = 0; entry_i < entries_match.length; entry_i++) {
										var match = entries_match[entry_i].match(nonglobal_regex);
										if (!match) {
											console_error("Unable to match non-global regex (this shouldn't happen)");
											continue;
										}
										search_entries.push({
											title: decode_entities(match[2].replace(/<([a-z]+)(?:\s+.*?)?>(.*?)<\/\1>/g, "$2")),
											url: urljoin(result.finalUrl, match[1].replace(/[?#].*/, ""), true)
										});
									}
									if (search_entries.length === 0) {
										console_error("Zero search entries found", searchurl);
									}
									done(search_entries, 2 * 60 * 60);
								}
							});
						});
					};
					var get_daum_url_from_results = function(real_title, real_pageid, results) {
						if (!results)
							return null;
						var real_fuzzy = fuzzify_text(real_title).substr(0, 35);
						for (var i = 0; i < results.length; i++) {
							if (real_fuzzy !== fuzzify_text(results[i].title).substr(0, 35)) {
								continue;
							}
							var pageid = results[i].url.replace(/.*\/v\/([0-9]+)$/, "$1");
							if (pageid === results[i].url) {
								console_error("Unhandled URL: " + results[i].url);
								continue;
							}
							if (!fuzzy_date_compare(pageid.substr(0, 8), real_pageid.substr(0, 8))) {
								if (_nir_debug_) {
									console_log("Skipping:", pageid, real_pageid);
								}
								continue;
							}
							return results[i].url;
						}
						console_error("Unable to find result from search", real_title, results);
						return null;
					};
					var get_daum_pageinfo = function(daumurl, cb) {
						api_cache.fetch("newsen_daum_pageinfo:" + daumurl, cb, function(done) {
							options.do_request({
								method: "GET",
								url: daumurl,
								onload: function(result) {
									if (result.readyState !== 4)
										return;
									if (result.status !== 200) {
										return done(null, false);
									}
									var image_regex = /<img[^>]+dmcf-mtype=["']image["'][^>]+src=["']((?:https?:)\/\/[^/]+\.daumcdn\.net\/.*?)["']/g;
									var nonglobal_regex = new RegExp(image_regex, "");
									var obj = {
										url: result.finalUrl,
										images: []
									};
									var images_match = result.responseText.match(image_regex);
									if (!images_match) {
										return done(obj, 60 * 60);
									}
									for (var i = 0; i < images_match.length; i++) {
										var image_match = images_match[i].match(nonglobal_regex);
										if (!image_match)
											continue;
										obj.images.push(urljoin(result.finalUrl, image_match[1], true));
									}
									done(obj, 6 * 60 * 60);
								}
							});
						});
					};
					get_newsen_pageinfo(extra.page, pageid, function(pageinfo) {
						if (!pageinfo) {
							return options.cb(obj);
						}
						var title = pageinfo.title;
						var total_images = pageinfo.images.length;
						var imagenum = get_imagenum_from_newsen_pageinfo(src, pageinfo);
						if (imagenum === null) {
							return options.cb(obj);
						}
						get_daum_search_results(title, function(results) {
							var daumurl = get_daum_url_from_results(title, pageid, results);
							if (!daumurl)
								return options.cb(obj);
							console_log("Daum article URL:", daumurl);
							get_daum_pageinfo(daumurl, function(daum_pageinfo) {
								if (!daum_pageinfo)
									return options.cb(obj);
								if (daum_pageinfo.images.length !== total_images) {
									console_error("Image number mismatch");
									return options.cb(obj);
								}
								obj.url = daum_pageinfo.images[imagenum];
								obj.extra.page = daum_pageinfo.url;
								delete obj.headers.Referer;
								return options.cb(obj);
							});
						});
					});
					return {
						waiting: true
					};
				}
				return obj;
			}
			if (domain === "sccdn.chosun.com") return src.replace(/\/([0-9]*_)(?:scr_)?([^._/]*)(?:_t)?(\.[^/.]*)$/, "/$1$2$3");
			if (domain_nosub === "chosun.com" ||
				domain_nowww === "the-star.co.kr" ||
				domain === "digitalchosun.dizzo.com" ||
				domain_nosub === "chosunonline.com") {
				newsrc = src
					.replace("/simg_thumb/", "/simg_org/")
					.replace(/\/thumb_dir\/(.*)_thumb(\.[^/.]*)$/, "/img_dir/$1$2")
					.replace(/\/thumbnail\/(.*?)(?:_thumb)?(\.[^/.]*)$/, "/image/$1$2");
				if (newsrc !== src)
					return add_full_extensions(newsrc);
				id = src.match(/\/site\/+data\/+img_dir\/+([0-9]{4}\/+(?:[0-9]{2}\/+){2})([0-9]{10,})_[0-9]+\./);
				if (false && id) {
					var id_plus_one = parseInt(id[2]) + 1; // doesn't always work
					return {
						url: src,
						extra: {
							page: src.replace(/\/site\/+data\/+img_dir\/+.*/, "/site/data/html_dir/" + id[1] + (id_plus_one) + ".html")
						}
					};
				}
			}
			if (domain === "photo.hankooki.com") {
				newsrc = src.replace("/arch/photo/", "/arch/original/")
					.replace("/arch/thumbs/", "/arch/original/")
					.replace(/(\/newsphoto\/[^/]*\/)thumbs\//, "$1");
				if (newsrc !== src) {
					return newsrc.replace(/(.*\/)t_?([^/]*)$/, "$1$2");
				} else {
					return src;
				}
			}
			if (domain === "thumb.hankooki.com") return src.replace(/:\/\/[^/]*\/+(.*\/+)[0-9]+x[0-9]+x[^/]*@([^/]*)(?:[?#].*)?$/, "://photo.hankooki.com/$1$2");
			if (domain_nosub === "ettoday.net") {
				return {
					url: src
						.replace(/\/[a-z]+([0-9]*\.[^/]*)(?:[?#].*)?$/, "/$1")
						.replace(/:\/\/cdn[0-9]*\./, "://static."),
					head_wrong_contenttype: true
				};
			}
			if (domain === "img.mbn.co.kr") return src.replace(/_s[0-9]+x[0-9]+(\.[^/]*)$/, "$1");
			if (domain === "imgmmw.mbn.co.kr") return src.replace(/(\/storage\/+news\/+[0-9]{4}\/+(?:[0-9]{2}\/+){2}[-0-9A-F]{30,})_[0-9]+(\.[^/.]*)*(?:[?#].*)?$/, "$1$2");
			if (domain === "image-gd.inews24.com") return src.replace(/:\/\/[^/]*\/image[0-9]*\.php\?u=([^&]*).*/, "://image3.inews24.com$1");
			if ((domain_nosub === "inews24.com" && /^img\.(?:lb|xml|[0-9]+)\./.test(domain)) ||
				(domain_nosub === "inews24.com" && /^image[0-9]*\./.test(domain)) ||
				(domain_nosub === "iwinv.net" && /^inews24\.(?:ext[0-9]+\.)?cache\./.test(domain))) {
				return src
					.replace(/(:\/\/[^/]+\/)(?:face\/+)?(?:[0-9]+dpi\/+){0,}(?:[0-9]*x[0-9]*\/+){0,}image_joy\//, "$1image_joy/")
					.replace(/\/image_joy\/+thumbnail\//, "/image_joy/");
			}
			if (domain_nosub === "wowkorea.jp" &&
				(string_indexof(src, ".wowkorea.jp/img") >= 0 ||
					string_indexof(src, ".wowkorea.jp/upload") >= 0)) {
				newsrc = src.replace(/(\/upload\/+photoSpecial\/+[0-9]+\/+)re_([^/]*\.[^/.]*)(?:[?#].*)?$/, "$1$2");
				if (newsrc !== src)
					return newsrc;
				if (string_indexof(src, "/img/album/") < 0 &&
					!src.match(/\/upload\/news\/+[0-9]+\//)) {
					return src.replace(/([^/]*_)[a-z0-9]*(\.[^/.]*)$/, "$1l$2");
				}
				newsrc = src.replace(/_(?:[a-z0-9]|ss)(\.[^/.]*)$/, "$1");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nosub === "saostar.vn" &&
				domain.match(/img[0-9]*\.saostar\.vn/)) {
				newsrc = src
					.replace(/saostar.vn\/fb[0-9]+[^/]*(\/.*\.[^/.]*)\/[^/]*$/, "saostar.vn$1")
					.replace(/saostar.vn\/[a-z][0-9]+\//, "saostar.vn/")
					.replace(/saostar.vn\/[0-9]+x[0-9]+\//, "saostar.vn/");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nosub.match(/^google\./) &&
				src.match(/\/www\.google\.(?:[a-z]+\.)?[a-z]*\/url\?/)) {
				newsrc = src.replace(/.*url=([^&]*).*/, "$1");
				if (newsrc !== src && /^https?/.test(newsrc))
					return decodeURIComponent(newsrc);
			}
			if ((domain_nowww === "lipstickalley.com" ||
				domain_nowww === "stephenking.com" ||
				domain === "forums.audioholics.com" ||
				domain_nowww === "ambercutie.com" ||
				domain_nowww === "overlandbound.com" ||
				string_indexof(domain, "forum.purseblog.com") >= 0) &&
				string_indexof(src, "/proxy.php?") >= 0) {
				newsrc = src.replace(/.*image=([^&]*).*/, "$1");
				if (newsrc !== src)
					return decodeuri_ifneeded(newsrc);
			}
			if (domain === "images.askmen.com") {
				return {
					url: src,
					head_wrong_contentlength: true
				};
			}
			if ((domain_nosub === "127.net" && string_indexof(domain, "nosdn.127.net") >= 0) ||
				(domain_nosub === "lf127.net" && /^imglf[0-9]+\./.test(domain)) ||
				domain === "pic-bucket.ws.126.net") { //lofter
				return src.replace(/\?.*$/, "");
			}
			if (domain === "board.makeshop.co.kr") return src.replace(/\/[a-z]*::/, "/");
			if (domain_nosub === "naver.jp" &&
				domain.match(/^rr\.img[0-9]*\.naver\./)) {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/mig.*?[?&]src=([^&]*).*?$/, "$1");
				if (newsrc !== src)
					return decodeURIComponent(newsrc);
			}
			if (domain === "imgcc.naver.jp") {
				return src
					.replace(/\/thumb(\/[0-9]+x[0-9]+x[0-9a-f]+)_[0-9]+_[0-9]+(\.[^/.]*)$/, "$1$2")
					.replace(/\/[0-9]+\/[0-9]+\/*(?:[?&].*)?$/, "");
			}
			if (domain === "dimg.donga.com") {
				return src
					.replace(/\/[ca]\/(?:[0-9]+\/){4}/, "/")
					.replace(/\/i\/[0-9]+\/[0-9]+\/[0-9]+\//, "/");
			}
			if (domain === "imgpark.donga.com" && string_indexof(src, "/fileUpload/") >= 0) {
				return {
					url: src,
					headers: {
						Referer: "http://mlbpark.donga.com/"
					}
				};
			}
			if ((domain_nosub === "marishe.com" &&
				domain.match(/s[0-9]\.marishe\.com/)) ||
				(domain_nowww === "klik.gr" && string_indexof(src, "/uploads_image/") >= 0) ||
				(domain_nowww === "ug-ts.ru" && /\/content\/+pics\//.test(src)) ||
				(domain_nowww === "eroticasearch.net" && string_indexof(src, "/content/pics/") >= 0) ||
				domain === "resource.breakingnews.mn") {
				newsrc = src.replace(/(\/[^/]*)_[0-9]+(\.[^/.]*)$/, "$1$2");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nowww === "klik.gr") {
				return {
					url: src,
					can_head: false
				};
			}
			if (domain === "cdn.hk01.com") {
				newsrc = src.replace(/\?.*/, "");
				if (newsrc !== src)
					return newsrc;
				return src.replace(/(\/media\/+images\/+[0-9]+\/+)[^/]+\//, "$1org/");
			}
			if (domain_nosub === "sinaimg.cn") {
				if (src.match(/:\/\/[^/]*\/+max(?:width|height)\.[0-9]+\//)) {
					return {
						url: src.replace(/(:\/\/[^/]*\/+)[^/]*\//, "$1original/"),
						can_head: false
					};
				}
				if (domain.match(/^ss/)) {
					src = src.replace(/\.sinaimg\.cn\/+[^/]*\/+([^/]*)\/*$/, ".sinaimg.cn/orignal/$1");
				} else {
					src = src.replace(/\.sinaimg\.cn\/+[^/]*\/+([^/]*)\/*$/, ".sinaimg.cn/large/$1");
				}
				if (domain.match(/^n\./)) {
					newsrc = src.replace(/(\/ent\/+[0-9]+_)img(\/+upload\/)/, "$1ori$2");
					if (newsrc !== src)
						return newsrc;
				}
				newsrc = src.replace(/(\/autoimg\/+serial\/+[0-9]{2}\/+[0-9]{2}\/+[0-9]+)_[0-9]+(\.[^/.]+)(?:[?#].*)?$/, "$1_src$2");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/\/slidenews\/+([^/_]*)_[^/_]*\//, "/slidenews/$1_img/"); // there's also _ori, but it seems to be smaller?
				if (newsrc !== src)
					return newsrc;
				return {
					url: src,
					headers: {
						Referer: "https://weibo.com/"
					},
					referer_ok: {
						same_domain: true
					}
				};
			}
			if (domain_nosub === "sina.com.cn" && domain.match(/^static[0-9]\.photo\.sina\.com\.cn/)) {
				return src.replace(/:\/\/static([0-9]*)\.photo\.sina\.com\.cn\//, "://ss$1.sinaimg.cn/");
			}
			if (domain === "sinaimg.acgsoso.com") return src.replace(/:\/\/[^/]+\/+/, "://wx4.sinaimg.cn/");
			if (domain === "thumbnail.egloos.net" ||
				domain === "thumb.egloos.net") {
				return src.replace(/^[a-z]+:\/\/thumb(?:nail)?\.egloos\.net\/[^/]*\/*/, "");
			}
			if (domain === "k.kakaocdn.net") return src.replace(/\/img_[a-z]*\.([^./]*)$/, "/img.$1");
			if (domain === "images.sportskhan.net" ||
				domain === "images.khan.co.kr" ||
				domain === "img.khan.co.kr") {
				newsrc = src
					.replace(/\/r\/[0-9]+x[0-9]+\//, "/")
					.replace(/\/[a-z]*_([0-9]+\.[a-z0-9A-Z]*)$/, "/$1")
					.replace(/\/c\/[0-9]*x[0-9]*\//, "/")
					.replace(/(\/news\/[0-9]{4}\/[0-9]{2}\/[0-9]{2}\/[0-9]{8}\.[0-9]+\.[0-9]+)[A-Z](\.[^/.]*)$/, "$1L$2")
					.replace(/(\/news-p\.v[0-9]+\.[0-9]{8}\.[0-9a-f]{20,})_[A-Z][0-9]+(\.[^/.]*)$/, "$1$2")
					.replace(/\/photodb\//, "/PhotoDB/");
				return {
					url: newsrc,
					head_wrong_contentlength: true
				};
			}
			if (domain_nosub === "sbs.co.kr" &&
				domain.match(/^img[0-9]*\.sbs\.co\.kr/)) {
				newsrc = src.replace(/(\/[0-9]+)_[0-9v]+\.([a-z0-9A-Z]*)$/, "$1.$2");
				if (newsrc !== src)
					return newsrc;
				return src.replace(/(\/[^_]*)_[^/.]*(\.[^/.]*)$/, "$1_ori$2");
			}
			if (domain === "image.board.sbs.co.kr") return src.replace(/-[0-9]+(\.[^/.]*)$/, "$1");
			if (domain === "photocloud.sbs.co.kr") return src.replace(/(:\/\/[^/]+\/+)([^/]+\/+)thumb\/+([0-9a-f]{10,})-(?:[0-9]+|c[0-9]+x[0-9]+)\./, "$1origin/edit/$2$3-p.");
			if (domain === "board.sbs.co.kr") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]+\/+popup\/+pc\/+imageView\?(?:.*&)?imageUrl=([^&]+)(?:[&#].*)?$/, "$1");
				if (newsrc !== src)
					return decodeuri_ifneeded(newsrc);
			}
			if (domain_nosub === "edaily.co.kr" &&
				string_indexof(domain, "image.edaily.co.kr") >= 0 ||
				string_indexof(domain, "img.edaily.co.kr") >= 0) {
				return src
					.replace(/\/[a-z]_([A-Z0-9]+)\.([a-z0-9A-Z]*)$/, "/$1.$2")
					.replace(/(\/[A-Z0-9]+)[a-z]\.([a-z0-9A-Z]*)$/, "$1.$2");
			}
			if (domain === "media.glamour.com" ||
				domain === "assets.teenvogue.com" ||
				domain === "assets.vogue.com" ||
				domain === "media.vanityfair.com" ||
				domain === "media.gq.com" ||
				domain === "media.wmagazine.com" ||
				domain === "media.self.com" ||
				domain === "media.pitchfork.com" ||
				domain === "media.wired.com" ||
				domain === "media.golfdigest.com" ||
				domain === "media.architecturaldigest.com" ||
				domain === "media.cntraveler.com" ||
				domain === "media.allure.com" ||
				src.match(/:\/\/[^/]*\/photos\/[0-9a-f]{24}\/[^/]*\/[^/]*\/[^/]*$/)) {
				newsrc = src.replace(/\/[^/]*\/[^/]*\/([^/]*)$/, "/original/original/$1");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nosub === "cloudinary.com" ||
				domain === "images.playmates.com" ||
				domain === "images.playboy.com" ||
				(domain_nosub === "engoo.com" && domain.match(/^transcode[0-9]*\.app\./)) ||
				domain === "images.thehollywoodgossip.com" ||
				domain === "cdn.apartmenttherapy.info" ||
				domain === "image.thestartmagazine.com" ||
				domain === "cdn.substack.com" ||
				domain === "c.bellesa.co" ||
				domain === "images.haarets.co.il" ||
				domain === "assets.mocha.global" ||
				domain === "tbn.bidorbuy.co.za" ||
				domain === "resources.sonyliv.com" ||
				domain === "cdn.allbirds.com" ||
				(domain_nosub === "minutemediacdn.com" && /^images[0-9]*\./.test(domain)) ||
				domain === "imagecache.365scores.com" ||
				domain === "images.taboola.com" ||
				domain === "c.neevacdn.net" ||
				domain === "substackcdn.com" ||
				/\/image\/+fetch\/+.*?\/+https?(?::|%3A)(?:\/\/|%2F%2F)/.test(src)) {
				if (src.search(/:\/\/[^/]*\/(?:[^/]*\/+)?(?:image\/+)?fetch\//) >= 0) {
					newsrc = src.replace(/(.*?:\/\/[^/]*\/(?:[^/]*\/)?(?:image\/+)?fetch\/+)(?:.*?\/)?(https?(?::|%3A)(?:\/|%2F).*)/, "$1c_limit/$2");
					if (newsrc !== src)
						return {
							url: newsrc,
							head_wrong_contenttype: true
						};
					newsrc = src.replace(/.*?:\/\/[^/]*\/(?:[^/]*\/)?(?:image\/+)?fetch\/(?:.*?(?:\/|%2F))?([^/%]*(?::|%3A)(?:\/|%2F).*)/, "$1");
					newsrc = newsrc.replace(/\?savepath=[^&#?]+$/, "");
					if (/^[^/:]*%3A/.test(newsrc) ||
						(string_indexof(newsrc, "?") < 0 && string_indexof(newsrc, "%3F") >= 0))
						newsrc = decodeURIComponent(newsrc);
					return newsrc;
				}
				newsrc = src.replace(/(\/iu\/[^/]*)\/.*?(\/v[0-9]*\/)/, "$1$2");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nosub === "jpimedia.uk" && domain.match(/^images(?:-[a-z])?\./)) {
				return src.replace(/^[a-z]+:\/\/[^/]*\/+imagefetch\/+.*?\/(https?:\/\/)/, "$1");
			}
			if ((domain_nosub === "cloudinary.com" && /res(?:-[0-9]+)?\./.test(domain)) ||
				domain === "i.kinja-img.com") {
				newsrc = src
					.replace(/\/image\/+upload\/+/, "/image/upload/")
					.replace(/\/image\/upload\/s\-\-[^/]*\-\-\//, "/image/upload/")
					.replace(/\/iu\/s\-\-[^/]*\-\-\//, "/iu/")
					.replace(/\/image\/upload\/[^/]*_[^/]*\//, "/image/upload/")
					.replace(/\/image\/upload\/v[0-9]+\//, "/image/upload/")
					.replace(/(\/private_images\/+)(?:c_limit\/+)?[chwxyfq]_[^/]*\//, "$1c_limit/")
					.replace(/(\/image\/private\/)[^s][^-][^/]*\//, "$1c_limit/")
					.replace(/(:\/\/[^/]*\/)[^/]*\/(ch\/images\/[0-9]+\/[^/]*$)/, "$1$2");
				if (newsrc !== src) {
					return {
						url: newsrc,
						head_wrong_contentlength: true
					};
				}
			}
			if (domain === "fiverr-res.cloudinary.com" ||
				domain === "assets.lybrate.com") {
				return src.replace(/(:\/\/[^/]*\/+(?:images\/+)?)[a-z]_[^/]*\//, "$1");
			}
			if (domain === "images.complex.com") return src.replace(/\/(images|image\/upload)\/[^/]*_[^/]*\//, "/$1/");
			if (domain === "images.spot.im" ||
				domain_nowww === "fashionista.com" ||
				domain === "images.pigeonsandplanes.com" ||
				domain === "images.sftcdn.net" ||
				domain === "cdn.primedia.co.za" ||
				domain_nowww === "maxim.com" ||
				domain === "img.thedailybeast.com" ||
				domain === "alibaba.kumpar.com" ||
				domain === "5b0988e595225.cdn.sohucs.com" ||
				domain === "images-cdn.moviepilot.com" ||
				domain === "img.playbuzz.com" ||
				domain === "images.discerningassets.com" ||
				domain === "images.radio-canada.ca" ||
				domain === "img.wcdn.co.il" ||
				domain === "images.haarets.co.il" ||
				domain === "images.cdn.yle.fi" ||
				(domain_nowww === "sol.no" && string_indexof(src, "/img/") >= 0) ||
				(domain === "prof.prepics-cdn.com" && string_indexof(src, "/image/upload/") >= 0) ||
				domain === "images.ezvid.com" ||
				domain === "img.peerspace.com" ||
				domain === "dhgywazgeek0d.cloudfront.net" ||
				domain === "assets.nuuvem.com" ||
				domain === "images.lanouvellerepublique.fr" ||
				domain === "images.fastcompany.net" ||
				domain === "dwgyu36up6iuz.cloudfront.net" ||
				(domain_nosub === "minutemediacdn.com" && domain.match(/^images[0-9]*\./)) ||
				(domain_nosub === "cloudinary.com" && string_indexof(domain, "res.cloudinary.com") >= 0 && string_indexof(src, "/images/") >= 0) ||
				domain === "media.stubhubstatic.com" ||
				domain === "img.promipool.de" ||
				domain === "blue.kumparan.com" ||
				(domain_nosub === "answcdn.com" && domain.match(/^file[0-9]*\./)) ||
				domain === "res.fashionsnap.com" ||
				domain === "user-images.strikinglycdn.com" ||
				domain === "custom-images.strikinglycdn.com" ||
				domain === "novel-img.prepics-cdn.com" ||
				domain === "cdn.apartmenttherapy.info" ||
				domain === "cdn.domestika.org" ||
				(domain === "assets.charmboard.com" && string_indexof(src, "/images/") >= 0) ||
				domain === "image.spreadshirtmedia.com" ||
				domain === "c.bellesa.co" ||
				domain === "img.ssensemedia.com" ||
				domain === "images.jpost.com" ||
				domain === "img.hellofresh.com" ||
				domain === "assets.petco.com" ||
				domain === "img.redbull.com" ||
				domain === "images.tou.tv" ||
				domain === "assets.nintendo.com" ||
				domain === "assets.myntassets.com" ||
				domain === "static.nike.com" ||
				domain === "assets.myntassets.com" ||
				domain === "img.sndimg.com" ||
				domain === "assets.adidas.com" ||
				domain === "images.moviepilot.com" ||
				domain === "media.bleacherreport.com" ||
				domain === "img.olympicchannel.com" ||
				domain === "resource.logitech.com" ||
				domain == "media-cldnry.s-nbcnews.com" ||
				domain === "derivates.kicker.de" ||
				domain === "media.istra24.hr" ||
				(domain_nosub === "itc.cn" && /^p[0-9]*\./.test(domain) && /\/images[0-9]+\//.test(src)) ||
				domain === "assets.simpleviewinc.com" ||
				domain === "img.guess.com" ||
				domain === "media.niftygateway.com" ||
				(domain_nosub === "hotstarext.com" && /^img[0-9]*\./.test(domain)) ||
				domain === "res.garmin.com" ||
				domain === "media-cdn.grubhub.com" ||
				domain === "media.bauerradio.com" ||
				(domain_nowww === "wine.com" && /\/product\/+images\//.test(src)) ||
				domain === "puls-img.chanel.com" ||
				domain === "resources.finalsite.net" ||
				domain === "c.static-nike.com" ||
				domain === "resources.mynewsdesk.com" ||
				domain === "brand.assets.adidas.com" ||
				domain === "images.tennis.com" ||
				domain === "resource.logitechg.com") {
				newsrc = src
					.replace(/%2C/g, ",")
					.replace(/\/[a-z]+_[^/_,]+(?:,[^/]*)?\//, "/")
					.replace(/\/fl_any_format\.[^/]*\//, "/")
					.replace(/\/fl_keep_iptc[^/]*\//, "/")
					.replace("/t_mp_quality/", "/")
					.replace(/\/t_PDP_[0-9]+_v1\//, "/") // static.nike.com, number seems to be the width
					.replace(/\/t_image_size_[^/]+\//, "/") // resources.finalsite.net
					.replace(/\/private\/+t_[-0-9_]+\//, "/private/f_png/") // img.olympicchannel.com
					.replace(/\/v[0-9]{10}\//, "/")
					.replace(/\/image\/+upload\/+t_[^/]*\//, "/image/upload/");
				if (newsrc !== src)
					return newsrc;
				newsrc = src
					.replace(/\/v[0-9]+\//, "/");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/\.webp(?:[?#].*)?$/, ".png");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "image.kkday.com") return src.replace(/\/image\/+get\/+[^/]*(?:%2C|,)[^/]*\//, "/image/get/");
			if (domain === "cdn.skim.gs") {
				return src
					.replace(/\/image\/upload\/[^/]*_[^/]*\//, "/image/upload/")
					.replace(/\/images\/[^/]*_[^/]*\//, "/images/");
			}
			if (domain === "www-konga-com-res.cloudinary.com") return src.replace(/(:\/\/[^/]+\/+).*?\/+media\//, "$1media/");
			if (((domain_nosub === "biography.com" ||
				domain_nowww === "guitarworld.com" ||
				domain_nowww === "guitaraficionado.com" ||
				domain_nowww === "psneurope.com") &&
				string_indexof(src, "/.image/") >= 0) ||
				src.match(/:\/\/[^/]*\/\.image\/[^/]*_[^/]*\/[A-Za-z-0-9]{24}\/[^/]*$/)) {
				newsrc = src.replace(/(\/.image)\/[^/]*(\/[^/]*\/[^/]*)$/, "$1$2");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "resources.mynewsdesk.com") return src.replace(/(\/image\/+upload\/+)t_[^/]+\/+/, "$1");
			if (domain_nosub === "bridestory.com") return src.replace(/^[a-z]+:\/\/[^/]+\/+images\/+.*?\/+assets\/+([^/]+)\/+[^/]+(?:[?#].*)?$/, "https://images.bridestory.com/image/upload/assets/$1.jpg");
			if (domain_nowww === "chanel.com" ||
				domain === "img.olympics.com") {
				return src.replace(/(\/images\/+(?:image\/+private\/+)?)(?:(?:q|fl?|dpr|w|h|t)_[^/]+\/+)+/, "$1c_limit/");
			}
			if (domain === "cloudinary-cdn.ffm.to") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]+\/+.*?\/+(https?.*)$/, "$1");
				if (newsrc !== src)
					return decodeuri_ifneeded(newsrc);
			}
			if (domain_nosub === "popsugar-assets.com" ||
				domain_nosub === "onsugar.com") {
				if (string_indexof(src, "/thumbor/") >= 0) {
					newsrc = src.replace(/\/thumbor\/.*/, "/" + common_functions["get_thumbor_url"](src.replace(/.*?\/thumbor\//, "/")));
					if (newsrc !== src)
						return newsrc;
				}
				newsrc = src.replace(/\.(?:preview_)?(?:[a-z]*|_original)(?:_(?:[0-9x]+|wm))?(\/i\/[^/]*)$/, "$1");
				if (newsrc !== src)
					return newsrc;
				return src.replace(/\.(?:preview|x*large)(?:_(?:[0-9x]+|wm))?(\.[^/.]*)$/, "$1");
			}
			if (domain_nosub === "ceros.com" && domain.match(/^media[-.]/)) {
				newsrc = src.replace(/\?.*/, "");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "elleuk.cdnds.net") {
				newsrc = src.replace(/:\/\/.*\/[^/]*assets-elleuk-com-gallery-([0-9]*)-([^/]*)-([^-/.]*)\.[^-/.]*$/, "://assets.elleuk.com/gallery/$1/$2.$3");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nosub === "cdnds.net" &&
				!src.match(/\/[0-9]*x[0-9]*-[^/]*$/)) {
				newsrc = src
					.replace(/\/[0-9]+x[0-9]+\/gallery_/, "/")
					.replace(/\/[0-9]+x[0-9]+\/([^/]*)$/, "/$1")
					.replace(/\/[ML]\/([^/]*)$/, "/$1")
					.replace(/\/(?:landscape|hd-aspect|gallery)-([^/]*)$/, "/$1")
					.replace(/(\/[^/]*)\?[^/]*$/, "$1");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "redonline.cdnds.net") return src.replace(/__[a-z]+(\.[^/.]*)$/, "$1");
			if (domain === "img.usmagazine.com") return src.replace(/(.*?[^:])\/[0-9]*-[^/]*\//, "$1/");
			if (domain_nosub === "gannett-cdn.com" &&
				string_indexof(src, "/-mm-/") >= 0) {
				newsrc = src.replace(/.*?\/-mm-\/[0-9a-f]*\/[^/]*\/(http[^/]*)\/(.*)$/, "$1://$2");
				if (newsrc !== src)
					return newsrc;
				return src.replace(/\/-mm-\/.*?\/-\//, "/");
			}
			if (domain_nowww === "usatoday.com") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]+\/+gcdn\/+/, "https://www.gannett-cdn.com/");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nosub === "aolcdn.com") {
				var regex1 = /.*image_uri=([^&]*).*/;
				if (src.match(regex1)) {
					newsrc = decodeURIComponent(src.replace(/.*image_uri=([^&]*).*/, "$1"));
				} else if (src.match(/.*o\.aolcdn\.com\/images\//)) {
					newsrc = decodeURIComponent(src).replace(/.*o\.aolcdn\.com\/images\/[^:]*\/([^:/]*:.*)/, "$1");
				} else if (src.match(/^[a-z]+:\/\/[^/]*\/hss\/storage\/midas\//)) {
					return src.replace(/\/[0-9]+_([^/]*)$/, "/$1");
				}
				if (newsrc && newsrc !== src)
					return newsrc;
			}
			if (domain === "imagesvc.timeincapp.com") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/v3\/+[a-z]+\/+image\/?.*?[?&]url=(http[^&]*).*/, "$1");
				if (newsrc !== src)
					return decodeuri_ifneeded(newsrc);
			}
			if (domain === "g.foolcdn.com") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]+\/+image\/+\?(?:.*&)?url=([^&]+).*?$/, "$1");
				if (newsrc !== src)
					return decodeURIComponent(newsrc);
			}
			if (domain_nosub === "photoshelter.com") {
				if (/\/img\/+photoshelter_unavailable\./.test(src)) {
					return {
						url: src,
						bad: true
					};
				}
				return src
					.replace(/\/img-get2\/([^/]*)\/(?:[a-z]+=[^/]*\/)*([^/]*)$/, "/img-get2/$1/fit=99999999999/$2")
					.replace(/\/img-get\/([^/]*)(?:\/[ts]\/[0-9]+\/(?:[0-9]+\/)?)?([^/]*)$/, "/img-get2/$1/fit=99999999999/$2")
					.replace(/\/+fit=[0-9x]+\/+fit=[0-9x]+/, "/fit=99999999999");
			}
			if (domain_nowww === "marcusgetta.photography" ||
				domain_nowww === "schreyer-photo.com" ||
				domain_nowww === "stellapictures.co.uk" ||
				domain_nowww === "mgpstockphotos.com") {
				return src.replace(/^[a-z]+:\/\/[^/]+\/+(img-get2\/)/, "https://ssl.c.photoshelter.com/$1");
			}
			if (domain_nowww === "celebzz.com" &&
				string_indexof(src, "/wp-content/uploads/") >= 0) {
				newsrc = src.replace(/_thumbnail(\.[^/.]*)$/, "$1");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nosub === "images-amazon.com" ||
				domain_nosub === "ssl-images-amazon.com" ||
				domain_nosub === "media-amazon.com" ||
				domain_nosub === "media-imdb.com" ||
				domain === "in.in3w.info" ||
				domain_nowww === "amazon.co.jp" ||
				domain === "i.gr-assets.com") {
				if (/^[a-z]+:\/\/[^/]+\/+images\/+[A-Z]\/+[0-9]+\/+apparel\/+rcxgs\/+tile\.(?:[^/?#]+\.)?gif(?:[?#].*)?$/.test(src))
					return {
						url: src,
						bad: "mask"
					};
				var parse_directives = function(url) {
					var match = url.match(/((?:\.+_*(?:0_)?(?:[A-Z][A-Z0-9]|V_)[^/.]*)+)\.+[^/.]+(?:[?#].*)?$/);
					if (!match)
						return null;
					var raw_directives = match[1].replace(/\./g, "_").replace(/_+/g, "_").split("_");
					var directives = [];
					for (var _i = 0, raw_directives_1 = raw_directives; _i < raw_directives_1.length; _i++) {
						var directive = raw_directives_1[_i];
						if (!directive || !directive.length)
							continue;
						var dmatch = directive.match(/^([A-Z][A-Z0-9]|V|0)(.*)?$/);
						if (!dmatch) {
							console_warn("Invalid directive", directive, "for URL", url);
							return null;
						}
						directives.push({ key: dmatch[1], value: dmatch[2] || null });
					}
					return directives;
				};
				var stringify_directives = function(url, directives) {
					var stringified_arr = [];
					for (var _i = 0, directives_1 = directives; _i < directives_1.length; _i++) {
						var directive = directives_1[_i];
						var str_1 = [directive.key];
						if (directive.value)
							str_1.push(directive.value);
						stringified_arr.push(str_1.join(""));
					}
					var stringified = "._" + stringified_arr.join("_") + "_";
					if (!stringified_arr.length)
						stringified = "";
					var urlmatch = url.match(/^(.*\/[^/]+?)(?:\.+_*(?:0_)?(?:[A-Z][A-Z0-9]|V_)[^/.]*)*\.*(\.[^/.]+(?:[?#].*)?)$/);
					if (!urlmatch) {
						console_warn("Unable to find URL match for", url);
						return url;
					}
					return urlmatch[1] + stringified + urlmatch[2];
				};
				var parsed_directives = parse_directives(src);
				if (parsed_directives) {
					var new_directives = [];
					for (var _i = 0, parsed_directives_1 = parsed_directives; _i < parsed_directives_1.length; _i++) {
						var directive = parsed_directives_1[_i];
						if (directive.key === "V1" ||
							directive.key === "UX" ||
							directive.key === "UY" ||
							directive.key === "US" ||
							directive.key === "CR" ||
							directive.key === "AC" ||
							directive.key === "AL" ||
							directive.key === "AA" ||
							directive.key === "SL" ||
							directive.key === "SS" ||
							directive.key === "SR" ||
							directive.key === "SX" ||
							directive.key === "SY" ||
							directive.key === "V" ||
							directive.key === "BG" || // background color
							directive.key === "0" ||
							directive.key === "CB") {
							continue;
						}
						new_directives.push(directive);
					}
					newsrc = stringify_directives(src, new_directives);
					if (newsrc !== src) {
						return {
							url: newsrc,
							can_head: false
						};
					}
				}
				if (/\/images\/+P\//.test(src)) {
					return {
						url: src.replace(/(\/P\/+[A-Z0-9]+)(?:\.[0-9]+)?(?:\.[^/]+)?(\.[^/.?#]+)(?:[?#].*)?$/, "$1.01._SCRM_$2"),
						can_head: false
					};
				}
				return {
					url: src
						.replace(/(\.[^/.]*)(?:\.[^/.]*_){1,}\1(?:[?#].*)?$/, "$1") // is this needed?
						.replace(/(?:\.+_*[A-Z][A-Z0-9][^/.]*)+\.([^./]*(?:[?#].*)?)$/, ".$1"), // for now this seems to work for all images
					is_original: true,
					can_head: false
				};
			}
			if (domain_nosub === "otapol.jp") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/img\/amazon\/size[0-9]+\/([^/]*)$/, "https://images-na.ssl-images-amazon.com/images/I/$1");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nowww === "movpins.com") return src.replace(/^[a-z]+:\/\/[^/]*\/[a-z]+\/+(.)([a-zA-Z0-9]+(?:@+)?)(?:\.[^/]*)?\/[^/]*(\.[^/.]*)$/, "https://ia.media-imdb.com/images/$1/$1$2$3");
			if (domain === "cdn.cafehulu.com") return src.replace(/^[a-z]+:\/\/[^/]+\/+(.)([a-zA-Z0-9]{40,}(?:@+)?)(\.[^/?#]+)(?:[?#].*)?$/, "https://ia.media-imdb.com/images/$1/$1$2$3");
			if (domain_nowww === "imdb.com") {
				newsrc = website_query({
					website_regex: /\/video(?:player)?\/+(?:embed\/+)?vi([0-9]+)\/*(?:[?#].*)?$/,
					query_for_id: "https://www.imdb.com/video/vi${id}",
					process: function(done, resp, cache_key) {
						var match = resp.responseText.match(/<script id="__NEXT_DATA__" type="application\/json">({.*?})<\/script>/);
						if (!match) {
							console_error(cache_key, "Unable to find match for", resp);
							return done(null, false);
						}
						var json = JSON.parse(match[1]);
						var video = json.props.pageProps.videoPlaybackData.video;
						var baseobj = {
							extra: {
								caption: video.name.value || video.description.value
							}
						};
						var urls = [];
						for (var i = 0; i < video.playbackURLs.length; i++) {
							var our_obj = video.playbackURLs[i];
							var our_url = {
								url: our_obj.url
							};
							if (our_obj.mimeType === "video/mp4") {
								our_url.video = true;
							} else if (our_obj.mimeType === "application/x-mpegurl") {
								our_url.video = "hls";
							} else {
								console_warn("Unsupported mime type", our_obj.mimeType);
								continue;
							}
							urls.push(our_url);
						}
						urls.push(video.thumbnail.url); // TODO: remove ._???_.
						return done(fillobj_urls(urls, baseobj), 6 * 60 * 60); // urls expire in 23 hours
					}
				});
				if (newsrc)
					return newsrc;
			}

			if (domain_nowww === "cinema.de") {
				return src
					.replace(/.*\/files\/+sync\/([^/]+\.cinema\.de\/)/, "http://$1")
					.replace(/\/styles\/+.*?\/+(?:public|private)\/(.*\.jpeg)\.jpg(?:[?#].*)?$/, "/$1");
			}
			if (domain_nowww === "gamersnexus.net") {
				newsrc = src.replace(/(\/styles\/+[^/]+\/+public\/+[^/]+\/+[^/]+\.[a-z]+)\.webp(?:[?#].*)?$/, "$1");
				if (newsrc !== src)
					return newsrc;
				return src.replace(/\/styles\/+card_teaser(\/+public\/+[^/]+\/+[^/]+)(?:[?#].*)?$/, "/styles/large_responsive_no_watermark_$1");
			}
			if (domain === "cdn-img.instyle.com" ||
				domain === "static.independent.co.uk" ||
				domain === "static.standard.co.uk" ||
				/*domain.indexOf("www.billboard.com") >= 0 ||
				  string_indexof(domain, "www.harpersbazaararabia.com") >= 0 ||
				  string_indexof(domain, "www.etonline.com") >= 0 ||*/
				domain === "o.oystermag.com" ||
				/*domain.indexOf("www.metro.us") >= 0 ||
				  string_indexof(domain, "www.mtv.co.uk") >= 0 ||
				  string_indexof(domain, "www.grammy.com") >= 0 ||*/
				(domain_nosub === "thr.com" && domain.match(/cdn[0-9]*\.thr\.com/)) ||
				domain.match(/s[0-9]*\.ibtimes\.com/) ||
				src.match(/\/s3fs-public\/styles\/[^/]*\/public\//) ||
				domain === "media.pri.org" ||
				domain_nowww === "wwe.com" ||
				domain === "akm-img-a-in.tosshub.com" ||
				domain === "cdn.9razia.de" ||
				domain_nowww === "bravo.de" ||
				domain === "static.reservationvacances.com" ||
				domain === "cdn.okmag.de" ||
				domain_nowww === "soganhaber.com" ||
				domain_nowww === "favera.ru" ||
				domain === "cdn.businessinsider.es" ||
				(domain_nowww === "ru-24.ru" && string_indexof(src, "/_files/") >= 0) ||
				(domain_nowww === "selenagomez.com" && string_indexof(src, "/sites/") >= 0) ||
				(domain_nowww === "zizki.com" && string_indexof(src, "/styles/") >= 0) ||
				(domain_nowww === "rcf.fr" && string_indexof(src, "/sites/") >= 0) ||
				domain === "images.pagina12.com.ar" ||
				domain_nowww === "wasliestdu.de" ||
				(domain === "projects.balmain.com" && string_indexof(src, "/assets/") >= 0) ||
				domain_nosub === "sportkp.ru" ||
				domain === "cdn-live.foreignaffairs.com" ||
				domain_nowww === "negrusty.pro" ||
				src.match(/\/sites\/[^/]*\/files2?\/styles\/[^/]*/) ||
				src.match(/\/sites\/[^/]*\/files2?\/[^/]*\/styles\/[^/]*/) ||
				src.match(/(?:(?:\/sites\/+[^/]*)?\/files\/+|\/sites\/+[^/]*\/+)imagecache\/+[^/]*|\/sites\/+[^/]*\/+public\/+styles\/+/) ||
				src.search(/\/files\/styles\/[^/]*\/(?:public|private)\//) >= 0 ||
				src.search(/\/files\/[^/]*\/styles\/[^/]*\/(?:public|private)\//) >= 0) {
				newsrc = src
					.replace(/\/styles\/+.*?\/+(?:public|private)\//, "/")
					.replace(/\/imagecache\/+[^/]*\/+(?:files\/)?/, "/");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/(\.jpe?g)\.webp([?#].*)?$/i, "$1$2");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/\.webp([?#].*)?$/, ".jpg$1");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/\?.*$/, "");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "cdn-img.instyle.com") {
				newsrc = src.replace(/(\/images\/+[0-9]{4}\/+[0-9]{2}\/+[0-9]+-[^/]+)_0(\.[^/.]+)(?:[?#].*)?$/, "$1$2");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nowww === "etonline.com" && /\/sites\/+default\/+files\//.test(src)) {
				return {
					url: src.replace(/\?.*/, ""),
					head_wrong_contentlength: true
				};
			}
			if (domain === "cdn.okmag.de" ||
				domain === "cdn.9razia.de") {
				return src.replace(/(:\/\/[^/]*\/)s\/[^/]*\/public\/(media\/)/, "$1$2");
			}
			if (domain === "img.elcomercio.pe" ||
				domain === "img.peru21.pe" ||
				domain_nowww === "elpais.com.co") {
				return src.replace(/\/files\/[^/]*\/uploads\//, "/uploads/");
			}
			if (domain === "media.voltron.voanews.com") return src.replace(/\/styles\/+[^/]*\/+s3\/+/, "/");
			if (domain_nowww === "schweizer-illustrierte.ch") return src.replace(/\/fp\/+(?:[0-9]+\/+){4}(sites\/+)/, "/$1");
			if (domain_nowww === "trbimg.com") return src.replace(/(\/img-[0-9a-f]+\/+[^/]+\/+[^/]+\/+)[0-9]+(?:\/+[0-9]+x[0-9]+\/*)?(?:[?#],*)?$/, "$1");
			if (domain_nosub === "ggpht.com" && /^geo[0-9]*\./.test(domain) && /:\/\/[^/]+\/+(?:cbk|maps\/+photothumb\/+fd\/+v1)\?/.test(src)) {
				queries = get_queries(src);
				if (queries.panoid || queries.bpb) {
					var w = parse_int(queries.w) || 0;
					var h = parse_int(queries.h) || 0;
					if (!w && !h) {
						w = 2000;
						h = 1200;
					}
					var largest = Math_max(w, h);
					var smallest = Math_min(w, h);
					var ratio;
					if (!smallest || !largest) {
						ratio = 1;
					} else {
						ratio = largest / smallest;
					}
					var mostlarge = 9999;
					if (!queries.panoid && queries.bpb)
						mostlarge = 2048;
					if (largest < mostlarge) {
						largest = mostlarge;
						smallest = parse_int(largest / ratio);
						if (w > h) {
							queries.w = largest;
							queries.h = smallest;
						} else {
							queries.h = largest;
							queries.w = smallest;
						}
						return add_queries(src, queries);
					}
				}
			}
			if ((/^google\./.test(domain_nosub) || domain_nosub === "googleapis.com") &&
				(/:\/\/[^/]+\/+maps\/+vt\//.test(src) || (/^mts[0-9]*\./.test(domain) && /:\/\/[^/]+\/+vt\//.test(src)))) {
				var queries = get_queries(src.replace(/^[a-z]+:\/\/[^/]+\/+(?:maps\/+)?vt\/+/, "?").replace(/(\?.*)\?/, "$1&"));
				if (queries.data) {
					queries.w = 1024;
					queries.h = 1024;
					newsrc = src.replace(/^([a-z]+:\/\/[^/]+\/+(?:maps\/+)?vt\/+).*/, "$1") + stringify_queries(queries);
					return newsrc;
				}
			}
			if ((domain_nosub === "blogspot.com" && string_indexof(domain, ".bp.blogspot.com") >= 0) ||
				((domain_nosub === "googleusercontent.com" ||
					domain_nosub.match(/^google\./)) &&
					(/^(?:yt|ci|lh|gp)[0-9](?:-[a-z]{2})?\./.test(domain) ||
						/^play-lh\./.test(domain))) ||
				domain === "d2yal1mtmg1ts6.cloudfront.net" ||
				domain === "blogger.googleusercontent.com" ||
				domain === "d2jcw5q7j4vmo4.cloudfront.net" ||
				(domain_nosub === "blogger.com" && domain.match(/^bp[0-9]*\.blogger\.com/)) ||
				domain === "drive.fife.usercontent.google.com" ||
				domain_nosub === "ggpht.com") {
				newsrc = src;
				if (!(/^[a-z]+:\/\/[^/]+\/+[^/?#=]{30,}=x[0-9]+-y[0-9]+-z[0-9]+-t[^-/?#]{23,}(?:[?#].*)?$/.test(src))) {
					newsrc = src
						.replace(/#.*$/, "")
						.replace(/\?.*$/, "")
						.replace(/\/[swh][0-9]*(-[^/]*]*)?\/([^/]*)$/, "/s0/$2")
						.replace(/(=[^/]*)?$/, "=s0?imgmax=0");
				}
				return {
					url: newsrc,
					can_head: false // 404
				};
			}
			if (domain === "ssl.gstatic.com") {
				if (/\/docs\/+common\/+[^/]+\.svg(?:[?#].*)?$/.test(src)) {
					return {
						url: src,
						bad: "mask"
					};
				}
			}
			if (/^google\./.test(domain_nosub) && /^books\./.test(domain)) {
				if (/\/books\/+(?:publisher\/+)?content\?/.test(src)) {
					var urls_1 = [];
					newsrc = remove_queries(add_queries(src, { w: "99999" }), ["h", "imgtk", "edge"]);
					if (newsrc !== src) {
						urls_1.push({
							url: newsrc,
							problems: {
								possibly_upscaled: true
							}
						});
					}
					if (!/[?&]sig=/.test(src)) {
						urls_1.unshift(remove_queries(add_queries(src, { img: "0", zoom: "0" }), ["w", "h", "imgtk", "edge"]));
					}
					if (urls_1.length)
						return urls_1;
				}
			}
			if (host_domain === "docs.google.com" && options.element) {
				if (options.element.tagName.toUpperCase() === "SVG" && options.element.classList.contains("kix-embeddedobject-image")) {
					var images = options.element.getElementsByTagName("image");
					if (images.length === 1) {
						newsrc = images[0].getAttribute("xlink:href");
						if (newsrc && newsrc !== src)
							return newsrc;
					}
				}
			}
			if (domain === "gimg.quizlet.com") return src.replace(/^[a-z]+:\/\/[^/]+\/+((?:a-|-[-A-Za-z0-9]+)\/.*)/, "https://lh3.googleusercontent.com/$1");
			if (domain_nowww === "star-tool.ru") return src.replace(/^[a-z]+:\/\/[^/]+\/+([^/]+\/+[^/]+\/+[^/]+\/+[^/]+\/+[swh][0-9]*(?:-[^/]*]*)?\/+)/, "https://lh3.googleusercontent.com/$1");
			if (domain_nowww === "thehackernews.com") return src.replace(/^[a-z]+:\/\/[^/]+\/+images\/+((?:[^/]+\/+){4}[^/]+\/+[^/]+)(?:[?#].*)?$/, "https://1.bp.blogspot.com/$1");
			if (domain_nosub === "googleusercontent.com" &&
				string_indexof(domain, "opensocial.googleusercontent.com") >= 0) {
				return decodeURIComponent(src.replace(/^[a-z]+:\/\/[^/]*\/gadgets\/proxy.*?[?&]url=([^&]*).*?$/, "$1"));
			}
			if (domain === "cdn.narcity.com" ||
				domain_nowww === "narcity.com") {
				return src.replace(/(\/[^/.]*\.[^/._]+)_(?:facebook|[0-9]+x[0-9]+)\.[^/.]*(?:[?#].*)?$/, "$1");
			}
			if (domain === "images.vanityfair.it" ||
				domain === "images.glamour.it") {
				return src.replace(/(\/gallery\/[0-9]*\/)[^/]*\//, "$1Original/");
			}
			if (domain_nosub === "r29static.com" ||
				(domain_nosub === "refinery29.com" && domain.match(/^static[0-9]*\./))) {
				return src.replace(/(\/bin\/(?:entry|public|author)\/[^/]*)\/(?:[0-9]+,[0-9]+,[0-9]+,[0-9]+\/)?[^/]*(?:,[^/]*)?\/([^,]*)$/, "$1/x,100/$2");
			}
			if (domain === "img.huffingtonpost.com") {
				return src
					.replace(/\/asset\/[^/]*\/([^/.]*\.[^/.]*)$/, "/asset/$1")
					.replace(/\?[^/]*$/, "");
			}
			if (domain === "images.huffingtonpost.com" ||
				(domain_nowww === "kisax.com" && string_indexof(src, "/images/") >= 0) ||
				(domain_nosub === "nicepik.com" && domain.match(/^i[0-9]*\./) && string_indexof(src, "/files/") >= 0) ||
				(domain_nosub === "uihere.com" && domain.match(/^c[0-9]*\./) && string_indexof(src, "/files/") >= 0) ||
				(domain_nowww === "babylonbee.com" && /\/img\/+articles\//.test(src)) ||
				(domain_nowww === "womansdiary.gr" && src.match(/\/articles\/[0-9]+\/[-0-9a-f]+-thumb/))) {
				return src.replace(/-thumb(\.[^/.]*)$/, "$1");
			}
			if (domain === "i.huffpost.com" ||
				domain === "s-i.huffpost.com") {
				return src
					.replace(/(\/gadgets\/slideshows\/[0-9]*\/slide_[^/]*_)[a-z]*(\.[^/.]*)$/, "$1original$2")
					.replace(/(\/gen\/[0-9]*\/).*(\.[^/.?]*)(?:\?[^/]*)?$/, "$1original$2");
			}
			if (domain_nosub === "washingtonpost.com") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]+\/+pbox\.php\?(?:.*&)?url=([^&]+).*$/, "$1");
				if (newsrc !== src)
					return decodeuri_ifneeded(newsrc);
				newsrc = src.replace(/^[a-z]+:\/\/[^/]+\/+wp-apps\/+imrs\.php\?(?:.*&)?src=([^&]+).*/, "$1");
				if (newsrc !== src)
					return decodeuri_ifneeded(newsrc);
				newsrc = src.replace(/^[a-z]+:\/\/[^/]+\/+resizer\/+[^/]+=\/+(?:.*\/)?(arc-anglerfish-washpost-prod-washpost)\/+/, "https://$1.s3.amazonaws.com/");
				if (newsrc !== src)
					return newsrc;
			}
			if (amazon_container === "arc-anglerfish-washpost-prod-washpost") {
				return src.replace(/_size-normalized(\.[^/.]+)(?:[?#].*)?$/, "$1");
			}
			if ((domain_nosub === "washingtonpost.com" ||
				domain_nowww === "statesman.com" ||
				domain_nowww === "myajc.com" ||
				domain_nowww === "ajc.com" ||
				domain_nowww === "lastampa.it" ||
				domain_nowww === "whio.com" ||
				domain_nowww === "daytondailynews.com" ||
				domain_nowww === "livemint.com" ||
				domain === "c.o0bg.com" ||
				domain_nosub === "bostonglobe.com" ||
				domain_nosub === "hindustantimes.com") &&
				string_indexof(src, "/rf/") >= 0 ||
				src.match(/^[a-z]+:\/\/[^/]*\/rf\/+image_[^/]*\/+(?:[0-9]{4}-[0-9]{4}\/+)?(?:Pub|Wires|HT)\/+(?:[wp][0-9]+|Online|Web)\/+/)) {
				newsrc = src
					.replace(/(.*?:\/\/[^/]*\/)rf\/[^/]*\/(.*)$/, "$1rw/$2")
					.replace(/[?&].*$/, "")
					.replace(/\.r(\.[^/.]*)$/, "$1");
				if (newsrc !== src) {
					return newsrc;
				}
			}
			if (domain_nosub === "foxnews.com" &&
				domain.match(/^a[0-9]*\.foxnews\.com/)) {
				if (src.replace(/.*\/a[0-9]*\.foxnews\.com\/([^/]*).*/, "$1") !== "images.foxnews.com") {
					return src.replace(/.*\/a[0-9]*\.foxnews\.com\/(.*)\/[0-9]+\/[0-9]+\/([^/]*)$/, "http://$1/$2");
				}
				return src.replace(/(\/a[0-9]*\.foxnews\.com\/.*)\/[0-9]+\/[0-9]+\/([^/?]*)(?:\?.*)?$/, "$1/0/0/$2");
			}
			if (domain === "cdn.cliqueinc.com" ||
				domain_nosub === "cliqueimg.com") {
				return src
					.replace(/(\/[^/]*)\.[0-9]*x[0-9]*[^/.]*\.([^./]*)$/, "$1.$2")
					.replace(/\/cache\/posts\//, "/posts/");
			}
			if (domain_nosub === "hubstatic.com") {
				newsrc = src.replace(/(\/[0-9]+)_f[0-9]+(\.[^/.]*)$/, "$1$2");
				if (newsrc !== src)
					return add_extensions(newsrc);
			}
			if (domain === "cdn.cms-twdigitalassets.com") return src.replace(/(\.[a-z]+)\.twimg\.[0-9]+\.[a-z]+(?:[?#].*)?$/, "$1");
			if (domain === "pbs.twimg.com" ||
				(domain === "ton.twitter.com" && string_indexof(src, "/ton/data/dm/") >= 0)) {
				newsrc = common_functions["get_largest_twimg"](src, options);
				if (newsrc)
					return newsrc;
			}
			if (domain_nowww === "twitter.com" ||
				domain_nowww === "x.com") {
				var _query_twitter_webapi = function(url, cookies, cb) {
					if (!cookies || !cookies.ct0) {
						console_warn("Cookies are needed for Twitter API calls", cookies);
						return cb(null);
					}
					var headers = {
						Accept: "*/*",
						Authorization: base64_decode("YWJjZEJlYXJlciBBQUFBQUFBQUFBQUFBQUFBQUFBQUFOUklMZ0FBQUFBQW5Od0l6VWVqUkNPdUg1RTZJOHhuWno0cHVUcyUzRDFadjd0dGZrOExGODFJVXExNmNIamhMVHZKdTRGQTMzQUdXV2pDcFRuQQ==").substr(4),
						Referer: "https://twitter.com/",
						"sec-fetch-dest": "empty",
						"sec-fetch-mode": "cors",
						"sec-fetch-site": "same-origin",
						"x-csrf-token": cookies.ct0,
						"x-twitter-client-language": cookies.lang || "en",
						"x-twitter-active-user": "yes"
					};
					if (cookies.twid) { // don't use auth_token, it doesn't exist on non-httponly-side
						headers["x-twitter-auth-type"] = "OAuth2Session";
					} else {
						if (cookies.gt) {
							headers["x-guest-token"] = cookies.gt;
						} else {
							console_warn("Guest token not found");
							return cb(null);
						}
					}
					api_query("twitter_api:" + url, {
						url: url,
						method: "GET",
						imu_mode: "xhr",
						headers: headers,
						json: true
					}, cb, function(done, resp, cache_key) {
						done(resp, 60 * 60);
					});
				};
				var query_twitter_webapi = function(url, cb) {
					if (options.get_cookies) {
						options.get_cookies("https://www.x.com/", function(cookies) {
							if (cookies)
								cookies = headers_list_to_dict(cookies);
							_query_twitter_webapi(url, cookies, cb);
						});
					} else {
						_query_twitter_webapi(url, null, cb);
					}
				};
				var query_tweet = function(tweet_id, cb) {
					var url = "https://twitter.com/i/api/2/timeline/conversation/" + tweet_id + ".json";
					var queries = {
						include_profile_interstitial_type: "1",
						include_blocking: "1", // u
						include_blocked_by: "1", // u
						include_followed_by: "1", // u
						include_want_retweets: "1", // u
						include_mute_edge: "1", // u
						include_can_dm: "1", // u
						include_can_media_tag: "1", // u
						skip_status: "1",
						cards_platform: "Web-12",
						include_cards: "1",
						include_ext_alt_text: "true",
						include_quote_count: "true", // u
						include_reply_count: "1", // u
						tweet_mode: "extended",
						include_entities: "true",
						include_user_entities: "true",
						include_ext_media_color: "true",
						include_ext_media_availability: "true",
						send_error_codes: "true",
						simple_quoted_tweet: "true",
						count: "20", // u
						include_ext_has_birdwatch_notes: "false",
						ext: "mediaStats%2ChighlightedLabel"
					};
					url = add_queries(url, queries);
					query_twitter_webapi(url, function(data) {
						if (!data)
							return cb(null);
						try {
							var tweet_data = data.globalObjects.tweets[tweet_id];
							data.globalObjects.tweet = tweet_data;
							cb(data.globalObjects);
						} catch (e) {
							console_error(e, data);
							cb(null);
						}
					});
				};
				var get_baseobj_from_tweet = function(tweet, users) {
					var obj = {
						can_head: false, // returns 503 sometimes
						extra: {}
					};
					if (tweet.created_at) {
						obj.extra.created_date = new Date(tweet.created_at).getTime();
					}
					if (users && tweet.id_str && tweet.user_id_str) {
						var username = users[tweet.user_id_str].screen_name;
						obj.extra.author_username = username;
						obj.extra.page = "https://x.com/" + username + "/status/" + tweet.id_str;
					}
					if (tweet.full_text) {
						obj.extra.caption = tweet.full_text;
					}
					return obj;
				};
				var get_single_media_obj = function(media) {
					var urls = [];
					if (array_indexof(["photo", "animated_gif", "video"], media.type) < 0) {
						console_warn("Unknown media type", media);
						return null;
					}
					if (media.video_info && media.video_info.variants) {
						var added_mimes = new_set();
						media.video_info.variants.sort(function(a, b) {
							if (a.content_type === "application/x-mpegURL")
								return -1;
							if (b.content_type === "application/x-mpegURL")
								return 1;
							if (a.bitrate && b.bitrate)
								return b.bitrate - a.bitrate;
							return 0;
						});
						array_foreach(media.video_info.variants, function(variant) {
							if (set_has(added_mimes, variant.content_type))
								return;
							set_add(added_mimes, variant.content_type);
							var unshift = false;
							var video = true;
							if (variant.content_type === "video/mp4") {
								video = true;
							} else if (variant.content_type === "application/x-mpegURL") {
								video = "hls";
								unshift = true;
							} else {
								console_warn("Unknown content type", variant, media);
								return;
							}
							var obj = {
								url: variant.url,
								video: video
							};
							urls.push(obj);
						});
					}
					var media_url = media.media_url_https;
					if (false && media.type === "photo") {
						var largest_size = null;
						var largest_size_br = 0;
						obj_foreach(media.sizes, function(key, size) {
							var our_br = size.w * size.h;
							if (our_br > largest_size_br) {
								largest_size = key;
								largest_size_br = our_br;
							}
						});
						if (largest_size) {
							media_url += "?name=" + largest_size;
						}
						if (largest_size !== "orig") {
							urls.push(media_url.replace(/\?.*$/, "?name=orig"));
						}
					}
					var larger_media = common_functions["get_largest_twimg"](media_url, options);
					if (larger_media) {
						array_extend(urls, larger_media);
					} else {
						urls.push(media_url);
					}
					return urls;
				};
				newsrc = website_query({
					website_regex: [
						/^[a-z]+:\/\/[^/]+\/+[^/]+\/+status\/+([0-9]+)(?:\/.*)?(?:[?#].*)?$/,
						/^[a-z]+:\/\/[^/]+\/+i\/+web\/+status\/+([0-9]+)(?:[?#].*)?$/
					],
					run: function(cb, match) {
						var id = match[1];
						query_tweet(id, function(data) {
							if (!data) {
								return cb(null);
							}
							var tweet = data.tweet;
							var obj = get_baseobj_from_tweet(tweet, data.users);
							var media_id = 0;
							var media_id_match = src.match(/#imu-media-id=([0-9]+)$/);
							if (media_id_match)
								media_id = media_id_match[1];
							var imu_url_id = null;
							var imu_url_match = src.match(/#imu-url=(.*)$/);
							if (imu_url_match) {
								var imu_url = imu_url_match[1];
								imu_url_match = imu_url.match(/.*\/([^/.?#]+)(?:\.[^/]+)?(?:[?#].*)?$/);
								if (imu_url_match) {
									imu_url_id = imu_url_match[1];
								}
							}
							var medias = [];
							var currenturls = [];
							var album_links = [];
							if (tweet.extended_entities && tweet.extended_entities.media) {
								array_foreach(tweet.extended_entities.media, function(media, i) {
									var singleobj = get_single_media_obj(media);
									if (!singleobj)
										return;
									var is_current = i == media_id;
									if (imu_url_id) {
										array_foreach(singleobj, function(ourobj) {
											var url = ourobj.url || ourobj;
											var our_id = url.match(/.*\/([^/.?#]+)(?:\.[^/]+)?(?:[?#].*)?$/)[1];
											is_current = our_id === imu_url_id;
											if (is_current)
												return;
										});
									}
									album_links.push({
										url: obj.extra.page + "#imu-media-id=" + i,
										is_current: is_current
									});
									medias[i] = singleobj;
									if (is_current)
										currenturls = singleobj;
								});
								if (album_links.length > 1) {
									obj.album_info = {
										type: "links",
										links: album_links
									};
								}
							}
							if (tweet.card && !currenturls.length) {
								var card = tweet.card;
								var card_url = card.url;
								var card_image = null;
								if (card.binding_values) {
									if (card.binding_values.player_url) {
										card_url = card.binding_values.player_url.string_value;
									}
									if (card.binding_values.player_image) {
										card_image = card.binding_values.player_image.image_value.url;
									}
								}
								currenturls.push({
									url: card_url,
									is_pagelink: true
								});
								if (card_image)
									currenturls.push(card_image);
							}
							if (tweet.quoted_status_permalink && !currenturls.length) {
								return cb({
									url: tweet.quoted_status_permalink.expanded,
									is_pagelink: true
								});
							}
							return cb(fillobj_urls(currenturls, obj));
						});
					}
				});
				if (newsrc)
					return newsrc;
			}
			if ((host_domain_nowww === "twitter.com" || host_domain_nowww === "x.com") && options.element) {
				var tweet_link = common_functions["get_twitter_tweet_link"](options.element);
				page_nullobj = null;
				if (tweet_link) {
					page_nullobj = {
						url: tweet_link,
						is_pagelink: true
					};
					if (src) {
						page_nullobj.url += "#imu-url=" + src;
					} else {
						return page_nullobj;
					}
				}
				var caption = common_functions["get_twitter_caption"](options.element);
				if (caption) {
					var newobj = {
						url: src,
						extra: {
							caption: caption
						}
					};
					if (page_nullobj) {
						return [page_nullobj, newobj];
					} else {
						return newobj;
					}
				} else if (page_nullobj) {
					return page_nullobj;
				}
			}
			if ((domain_nowww === "nitter.net" ||
				// https://github.com/zedeus/nitter/wiki/Instances
				// sorting same as instance list in case we need to add new ones from it
				domain === "nitter.lacontrevoie.fr" ||
				domain === "nitter.nixnet.services" ||
				domain === "nitter.fdn.fr" ||
				domain === "nitter.1d4.us" ||
				domain === "nitter.kavin.rocks" ||
				domain === "nitter.unixfox.eu" ||
				domain === "nitter.domain.glass" ||
				domain === "birdsite.xanny.family" ||
				domain === "nitter.moomoo.me" ||
				domain === "bird.trom.tf" ||
				domain === "nitter.it" ||
				domain === "nitter.weiler.rocks" ||
				domain === "nitter.sethforprivacy.com" ||
				domain === "nitter.nl" ||
				domain === "nitter.mint.lgbt" ||
				domain === "nitter.esmailelbob.xyz" ||
				domain === "tw.artemislena.eu" ||
				domain === "nitter.tiekoetter.com" ||
				domain === "nitter.privacy.com.de" ||
				domain === "nitter.bird.froth.zone" ||
				domain === "nitter.cz" ||
				domain === "nitter.privacydev.net" ||
				domain === "tweet.lambda.dance" ||
				domain === "nitter.kylrth.com" ||
				domain === "unofficialbird.com" ||
				domain === "nitter.projectsegfau.lt" ||
				domain === "nitter.eu.projectsegfau.lt" ||
				domain === "nitter.in.projectsegfau.lt" ||
				domain === "singapore.unofficialbird.com" ||
				domain === "canada.unofficialbird.com" ||
				domain === "india.unofficialbird.com" ||
				domain === "nederland.unofficialbird.com" ||
				domain === "uk.unofficialbird.com" ||
				domain === "nitter.soopy.moe" ||
				domain === "nitter.qwik.space" ||
				domain === "read.whatever.social" ||
				domain === "nitter.rawbit.ninja" ||
				domain === "nt.vern.cc" ||
				domain === "n.sneed.network" ||
				domain === "nitter.smnz.de" ||
				domain === "nitter.twei.space" ||
				domain === "nitter.inpt.fr" ||
				domain === "nitter.d420.de" ||
				domain === "nitter.caioalonso.com" ||
				domain === "nitter.at" ||
				domain === "nitter.nicfab.eu" ||
				domain === "bird.habedieeh.re" ||
				domain === "nitter.hostux.net" ||
				domain === "nitter.adminforge.de" ||
				domain === "nitter.platypush.tech" ||
				domain === "nitter.us.projectsegfau.lt" ||
				domain === "t.com.sb" ||
				domain === "nitter.kling.gg" ||
				domain === "nitter.riverside.rocks" ||
				domain === "nitter.lunar.icu" ||
				domain === "twitter.moe.ngo" ||
				domain === "nitter.freedit.eu" ||
				domain === "n.opnxng.com" ||
				domain === "nitter.tux.pizza" ||
				domain === "nitter.altgr.xyz" ||
				domain === "jote.lile.cl" ||
				domain === "nitter.one" ||
				domain === "nitter.io.lol" ||
				domain === "nitter.no-logs.com" ||
				domain === "tweet.whateveritworks.org" ||
				domain === "nitter.fediflix.org" ||
				domain === "nitter.nohost.network" ||
				domain === "nitter.simpleprivacy.fr" ||
				domain === "nitter.onthescent.xyz" ||
				domain === "nitter.x86-64-unknown-linux-gnu.zip" ||
				domain === "nitter.private.coffee" ||
				domain === "nitter.oksocial.net" ||
				domain === "nitter.services.woodland.cafe" ||
				domain === "nitter.dafriser.be" ||
				domain === "nitter.catsarch.com" ||
				//domain === "nitter.13ad.de" ||
				//domain === "tw.openalgeria.org" ||
				domain === "nitter.42l.fr" ||
				domain === "nitter.pussthecat.org" ||
				//domain === "nitter.mastodont.cat" ||
				domain === "nitter.tedomum.net" ||
				domain === "nitter-home.kavin.rocks" ||
				domain === "nitter.cc" ||
				domain === "nitter.vxempire.xyz" ||
				domain === "nitter.eu" ||
				domain === "nitter.ethibox.fr" ||
				domain === "nitter.namazso.eu" ||
				domain === "nitter.mailstation.de" ||
				domain === "nitter.actionsack.com" ||
				domain === "nitter.cattube.org" ||
				domain === "nitter.40two.app" ||
				domain === "nitter.skrep.in" ||
				domain === "nitter.hu" ||
				domain === "nitter.database.red" ||
				domain === "nitter.exonip.de" ||
				domain === "twitr.gq" ||
				domain === "nitter.koyu.space" ||
				domain === "nitter.dark.fail" ||
				//domain === "t.maisputain.ovh" ||
				//domain === "nitter.weaponizedhumiliation.com" ||
				domain === "nitter.snopyta.org")
				&& string_indexof(src, "/pic/") >= 0) {
				match = src.match(/\/pic\/+enc\/(bWVka[^/?#.]+)(?:[?#].*)?$/);
				if (match) {
					try {
						newsrc = base64_decode(match[1]);
						return "https://pbs.twimg.com/" + newsrc;
					} catch (e) {
						console_error(e);
					}
				}
				newsrc = src.replace(/^[a-z]+:\/\/[^/]+\/+pic\/+(.*)$/, "$1");
				if (newsrc !== src) {
					newsrc = decodeURIComponent(newsrc);
					if (string_indexof(newsrc, "video.twimg.com") === 0) {
					} else {
						var urls = common_functions["get_largest_twimg"](urljoin("https://pbs.twimg.com/", "/" + decodeURIComponent(newsrc), true));
						if (urls) {
							if (!is_array(urls))
								urls = [urls];
							array_foreach(urls, function(url) {
								var queries = get_queries(url.url);
								if (!url.filename) {
									url.filename = url_basename(url.url);
								}
								url.url = encodeURIComponent(url.url.replace(/^[a-z]+:\/\/[^/]+\/+/, ""));
								url.url = "https://" + domain + "/pic/" + url.url;
								if (queries.format && /\/(?:profile_images|media)/.test(url.url)) {
									url.url = url.url.replace(/(.*%2F[^.%]+)(?:\..*)?(%.*)?$/, "$1." + queries.format + "$2");
								}
							});
							return urls;
						} else {
							return {
								url: src,
								filename: url_basename(newsrc)
							};
						}
					}
				}
			}
			if (options.element &&
				(host_domain_nowww === "nitter.net" ||
				// https://github.com/zedeus/nitter/wiki/Instances
				// sorting same as instance list in case we need to add new ones from it
				host_domain === "nitter.lacontrevoie.fr" ||
				host_domain === "nitter.nixnet.services" ||
				host_domain === "nitter.fdn.fr" ||
				host_domain === "nitter.1d4.us" ||
				host_domain === "nitter.kavin.rocks" ||
				host_domain === "nitter.unixfox.eu" ||
				host_domain === "nitter.domain.glass" ||
				host_domain === "birdsite.xanny.family" ||
				host_domain === "nitter.moomoo.me" ||
				host_domain === "bird.trom.tf" ||
				host_domain === "nitter.it" ||
				host_domain === "nitter.weiler.rocks" ||
				host_domain === "nitter.sethforprivacy.com" ||
				host_domain === "nitter.nl" ||
				host_domain === "nitter.mint.lgbt" ||
				host_domain === "nitter.esmailelbob.xyz" ||
				host_domain === "tw.artemislena.eu" ||
				host_domain === "nitter.tiekoetter.com" ||
				host_domain === "nitter.privacy.com.de" ||
				host_domain === "nitter.bird.froth.zone" ||
				host_domain === "nitter.cz" ||
				host_domain === "nitter.privacydev.net" ||
				host_domain === "tweet.lambda.dance" ||
				host_domain === "nitter.kylrth.com" ||
				host_domain === "unofficialbird.com" ||
				host_domain === "nitter.projectsegfau.lt" ||
				host_domain === "nitter.eu.projectsegfau.lt" ||
				host_domain === "nitter.in.projectsegfau.lt" ||
				host_domain === "singapore.unofficialbird.com" ||
				host_domain === "canada.unofficialbird.com" ||
				host_domain === "india.unofficialbird.com" ||
				host_domain === "nederland.unofficialbird.com" ||
				host_domain === "uk.unofficialbird.com" ||
				host_domain === "nitter.soopy.moe" ||
				host_domain === "nitter.qwik.space" ||
				host_domain === "read.whatever.social" ||
				host_domain === "nitter.rawbit.ninja" ||
				host_domain === "nt.vern.cc" ||
				host_domain === "n.sneed.network" ||
				host_domain === "nitter.smnz.de" ||
				host_domain === "nitter.twei.space" ||
				host_domain === "nitter.inpt.fr" ||
				host_domain === "nitter.d420.de" ||
				host_domain === "nitter.caioalonso.com" ||
				host_domain === "nitter.at" ||
				host_domain === "nitter.nicfab.eu" ||
				host_domain === "bird.habedieeh.re" ||
				host_domain === "nitter.hostux.net" ||
				host_domain === "nitter.adminforge.de" ||
				host_domain === "nitter.platypush.tech" ||
				host_domain === "nitter.us.projectsegfau.lt" ||
				host_domain === "t.com.sb" ||
				host_domain === "nitter.kling.gg" ||
				host_domain === "nitter.riverside.rocks" ||
				host_domain === "nitter.lunar.icu" ||
				host_domain === "twitter.moe.ngo" ||
				host_domain === "nitter.freedit.eu" ||
				host_domain === "n.opnxng.com" ||
				host_domain === "nitter.tux.pizza" ||
				host_domain === "nitter.altgr.xyz" ||
				host_domain === "jote.lile.cl" ||
				host_domain === "nitter.one" ||
				host_domain === "nitter.io.lol" ||
				host_domain === "nitter.no-logs.com" ||
				host_domain === "tweet.whateveritworks.org" ||
				host_domain === "nitter.fediflix.org" ||
				host_domain === "nitter.nohost.network" ||
				host_domain === "nitter.simpleprivacy.fr" ||
				host_domain === "nitter.onthescent.xyz" ||
				host_domain === "nitter.x86-64-unknown-linux-gnu.zip" ||
				host_domain === "nitter.private.coffee" ||
				host_domain === "nitter.oksocial.net" ||
				host_domain === "nitter.services.woodland.cafe" ||
				host_domain === "nitter.dafriser.be" ||
				host_domain === "nitter.catsarch.com" ||
				//host_domain === "nitter.13ad.de" ||
				//host_domain === "tw.openalgeria.org" ||
				host_domain === "nitter.42l.fr" ||
				host_domain === "nitter.pussthecat.org" ||
				//host_domain === "nitter.mastodont.cat" ||
				host_domain === "nitter.tedomum.net" ||
				host_domain === "nitter-home.kavin.rocks" ||
				host_domain === "nitter.cc" ||
				host_domain === "nitter.vxempire.xyz" ||
				host_domain === "nitter.eu" ||
				host_domain === "nitter.ethibox.fr" ||
				host_domain === "nitter.namazso.eu" ||
				host_domain === "nitter.mailstation.de" ||
				host_domain === "nitter.actionsack.com" ||
				host_domain === "nitter.cattube.org" ||
				host_domain === "nitter.40two.app" ||
				host_domain === "nitter.skrep.in" ||
				host_domain === "nitter.hu" ||
				host_domain === "nitter.database.red" ||
				host_domain === "nitter.exonip.de" ||
				host_domain === "twitr.gq" ||
				host_domain === "nitter.koyu.space" ||
				host_domain === "nitter.dark.fail" ||
				//host_domain === "t.maisputain.ovh" ||
				//host_domain === "nitter.weaponizedhumiliation.com" ||
				host_domain === "nitter.snopyta.org")) {
				if (options.element.tagName === "VIDEO" && !src) {
					newsrc = options.element.getAttribute("data-url");
					if (newsrc) {
						return {
							url: urljoin(options.host_url, newsrc, true),
							media_info: {
								type: "video",
								delivery: "hls",
								need_custom_xhr: true // in order to override head requests
							},
							can_head: false // 404
						};
					}
				}
			}
			if (host_domain_nosub === "youtube.com" && options.element) {
				if (options.element.tagName.toLowerCase() === "svg") {
					var parent_tagname = options.element.parentElement.tagName.toLowerCase();
					if (parent_tagname === "yt-icon" || parent_tagname === "button")
						return {
							url: origsrc,
							bad: "mask"
						};
				}
				if (options.element.tagName === "DIV" && options.element.classList.contains("ytp-gradient-bottom")) {
					return {
						url: origsrc,
						bad: "mask"
					};
				}
				if (!src) {
					newsrc = common_functions["get_host_el_matching"](options.element, options.host_url, function(x) {
						return x.tagName === "VIDEO" && x.classList.contains("html5-main-video");
					});
					if (newsrc)
						return newsrc;
				}
			}
			if (domain_nosub === "youtube.com" || domain === "m.youtube.com" || domain_nowww === "youtu.be") {
				match = src.match(/^[a-z]+:\/\/(?:(?:www|m(?:usic)?)\.)?youtube\.com\/+watch\?(?:.*&)?v=([^&#]*)/);
				if (!match) {
					match = src.match(/^[a-z]+:\/\/(?:www\.)?youtu\.be\/+([^?&#]*)/);
				}
				if (!match) {
					match = src.match(/^[a-z]+:\/\/(?:(?:www|m)\.)?youtube\.com\/+(?:embed|shorts)\/+([^?#/]+)\/*(?:[?#].*)?$/);
				}
				if (match) {
					return "https://i.ytimg.com/vi/" + match[1] + "/mqdefault.jpg";
				}
			}
			if (domain === "ytimg.googleusercontent.com" ||
				(domain_nosub === "ytimg.com" && domain.match(/^i[0-9]*\./)) ||
				domain === "img.youtube.com") {
				obj = {
					problems: {
						possibly_different: false
					}
				};
				match = src.match(/\/(?:vi|an)(?:_webp)?\/+([^/]+)\/+[^/]+\.[^/.]+(?:[?#].*)?$/);
				id = null;
				if (match) {
					obj.extra = { page: "https://www.youtube.com/watch?v=" + match[1] };
					id = match[1];
				}
				newsrc = src.replace(/^([a-z]+:\/\/)i[0-9]+(\.ytimg\.com\/vi(?:_webp)?\/+[^/]+\/+[a-z]+\.)/, "$1i$2");
				if (newsrc !== src) {
					obj.url = newsrc;
					return obj;
				}
				regex = /^(.+\/+(?:vi|an)(?:_webp)?\/+[^/]*\/+)[a-z]*(default|[0-9]+)(?:_(?:live|[0-9]+s))?(\.[^/.?#]*)(?:[?#].*)?$/;
				if (regex.test(src) /*&& !problem_excluded("possibly_different")*/) {
					var sizes = [
						"maxres",
						"sd",
						"hq",
						"mq"
					];
					src = src.replace(/\/an(_webp)?\/+/, "/vi$1/");
					var urls = [];
					array_foreach(sizes, function(size) {
						var match = src.match(regex);
						var number = match[2];
						if (number.length > 1 || number === "0") {
							number = "default";
						}
						var newsrc = match[1] + size + number + match[3];
						if (newsrc !== src) {
							urls.push(newsrc);
						} else {
							return false;
						}
					});
					if (urls.length > 0)
						return fillobj_urls(urls, obj);
				}
				if (id && options && options.do_request && options.cb) {
					var parse_player_response = function(player_response) {
						if (!player_response) {
							return options.cb(null);
						}
						console_log(player_response);
						obj.url = src;
						obj.problems.possibly_different = false;
						var videoid = null;
						if (player_response.videoDetails && player_response.videoDetails.title && player_response.videoDetails.videoId) {
							videoid = player_response.videoDetails.videoId;
							obj.extra = {
								page: "https://www.youtube.com/watch?v=" + videoid,
								caption: player_response.videoDetails.title,
								id: videoid
							};
						}
						var maxbitrate = 0;
						var maxobj = null;
						var duration = 0;
						var available_formats = [];
						var has_sig = false;
						var add_formats = function(formats, is_adaptive) {
							for (var i = 0; i < formats.length; i++) {
								var our_format = formats[i];
								available_formats.push(our_format);
								our_format.imu_video_id = videoid;
								if (is_adaptive) {
									our_format.imu_is_adaptive = true;
								}
								if (our_format.approxDurationMs) {
									var ms = parseFloat(our_format.approxDurationMs);
									ms /= 1000;
									if (ms > duration)
										duration = ms;
								}
								our_format.imu_has_sig = our_format.cipher || our_format.signatureCipher;
								if (our_format.imu_has_sig) {
									has_sig = true;
								}
							}
						};
						var get_n_replacer = function(cb) {
							if (!options.rule_specific.youtube_replace_n) {
								console_warn("Youtube n replacing is disabled, expect slow speeds.");
								return cb(null);
							}
							api_cache.fetch("youtube:n_replacer", cb, function(done) {
								common_functions["youtube_fetch_asset"](api_cache, options, videoid, "js", function(asset) {
									var match = asset.match(/b=([a-zA-Z0-9]{3})\[0\]\(b\),a\.set\("n",b\)/);
									if (!match) {
										console_error("Unable to find n match in", { asset: asset });
										return done(null, 6 * 60 * 60);
									}
									var match2 = asset.match(new RegExp("var " + match[1] + "=\\[([a-zA-Z0-9]{3})\\]"));
									if (!match2) {
										console_error("Unable to find n sub-match in", { asset: asset, match: match });
										return done(null, 6 * 60 * 60);
									}
									var match3 = asset.match(new RegExp("\n" + match2[1] + "=function\\(a\\){([\\s\\S]*?join\\(\"\"\\);?)};\n"));
									if (!match3) {
										console_error("Unable to find n function match in", { asset: asset, match: match, match2: match2 });
										return done(null, 6 * 60 * 60);
									}
									var sanitized = match3[1];
									var sanitize = function(code) {
										return code
											.replace(/new Date\("([^"]+)"\)/, function(_, x) {
											return new Date(x).getTime();
										})
											.replace(/Math.pow\(([0-9]+),([0-9]+)\)/, function(_, x, y) {
											return Math_pow(x, y);
										});
									};
									while (true) {
										var new_sanitized = sanitize(sanitized);
										if (new_sanitized === sanitized)
											break;
										sanitized = new_sanitized;
									}
									get_library("JSInterpreter", options, options.do_request, function(JSInterpreter) {
										if (!JSInterpreter) {
											console_error(cache_key, "Unable to fetch JSInterpreter");
											return done(null, false);
										}
										var source = "var replacer = function(a) {" + sanitized + "}; replacer(a);";
										var cache = {};
										var replacer_wrap = function(n) {
											if (n in cache)
												return cache[n];
											var source = "var a = \"" + n + "\";var replacer = function(a) {" + sanitized + "}; replacer(a);";
											var interp = new JSInterpreter(source);
											var globalObject = interp.getGlobalScope().object;
											interp.run();
											cache[n] = interp.value;
											return interp.value;
										};
										return done(replacer_wrap, 60 * 60);
									});
								});
							});
						};
						var replace_n = function(n, cb) {
							api_cache.fetch("youtube_n:" + n, cb, function(done) {
								get_n_replacer(function(replacer) {
									if (!replacer)
										return done(n, false);
									done(replacer(n), 60 * 60);
								});
							});
						};
						if (player_response.streamingData) {
							if (player_response.streamingData.formats) {
								add_formats(player_response.streamingData.formats, false);
							}
							if (player_response.streamingData.adaptiveFormats) {
								add_formats(player_response.streamingData.adaptiveFormats, true);
							}
						}
						if (player_response.streamingData && player_response.streamingData.formats) {
							var formats = player_response.streamingData.formats;
							for (var j = 0; j < formats.length; j++) {
								var our_format = formats[j];
								if (our_format.bitrate > maxbitrate) {
									maxbitrate = our_format.bitrate;
									maxobj = our_format;
								}
							}
						}
						var subtitles = [];
						if (player_response.captions && player_response.captions.playerCaptionsTracklistRenderer &&
							player_response.captions.playerCaptionsTracklistRenderer.captionTracks) {
							var captionTracks = player_response.captions.playerCaptionsTracklistRenderer.captionTracks;
							for (var _i = 0, captionTracks_1 = captionTracks; _i < captionTracks_1.length; _i++) {
								var track = captionTracks_1[_i];
								var subtitle = {};
								subtitle.language_code = track.languageCode;
								if (track.name)
									subtitle.title = track.name.simpleText;
								subtitle.url = track.baseUrl + "&fmt=vtt";
								subtitle.mime = "text/vtt";
								subtitles.push(subtitle);
							}
						}
						var final = function() {
							if (available_formats.length === 0) {
								console_error("Unable to find any formats", player_response);
								return options.cb(obj);
							}
							var dashdata = {
								mimes: {}
							};
							var has_adaptive = false;
							var maxbitrate = 0;
							var maxobj = null;
							var baseobj = deepcopy(obj);
							baseobj.is_private = true;
							baseobj.headers = {
								Origin: "https://www.youtube.com",
								Referer: "https://www.youtube.com/"
							};
							for (var i = 0; i < available_formats.length; i++) {
								var our_format = available_formats[i];
								if (!our_format.url) {
									continue;
								}
								if (our_format.imu_is_adaptive) {
									var formatdash = {
										url: our_format.url,
										width: our_format.width,
										height: our_format.height,
										bandwidth: our_format.bitrate,
										id: our_format.itag,
										init_range: our_format.initRange,
										index_range: our_format.indexRange
									};
									var mime_match = our_format.mimeType.match(/^((?:video|audio)\/[^ /;]+);\s*codecs="([^"]+)"$/);
									if (!mime_match) {
										console_error("Unable to parse mime type", our_format.mimeType);
										continue;
									}
									formatdash.mime = mime_match[1];
									formatdash.codecs = mime_match[2];
									if (!formatdash.init_range) {
										continue;
									}
									if (/^av[0-9]+\./.test(formatdash.codecs))
										continue;
									if (!(formatdash.mime in dashdata.mimes))
										dashdata.mimes[formatdash.mime] = [];
									dashdata.mimes[formatdash.mime].push(formatdash);
								} else {
									if (our_format.bitrate > maxbitrate) {
										maxbitrate = our_format.bitrate;
										maxobj = our_format;
									}
								}
							}
							var urls = [];
							if (Object.keys(dashdata.mimes).length > 0) {
								dashdata.duration = duration;
								var dash = common_functions["create_dash_stream"](dashdata);
								var dashurl = "data:application/dash+xml," + encodeURIComponent(dash);
								urls.push({
									url: dashurl,
									video: {
										type: "dash",
										need_custom_xhr: true
									}
								});
							}
							if (maxobj && maxobj.url) {
								urls.push({
									url: maxobj.url,
									video: true
								});
							}
							if (subtitles.length) {
								for (var _i = 0, urls_2 = urls; _i < urls_2.length; _i++) {
									var url_1 = urls_2[_i];
									url_1.subtitles = subtitles;
								}
							}
							if (urls.length === 0) {
								if (has_sig) {
									console_warn("Encrypted/ciphered videos aren't supported");
								} else {
									console_error("Unknown streamingData object", maxobj);
								}
								return options.cb(obj);
							}
							return options.cb(fillobj_urls(urls, baseobj));
						};
						if (!maxobj) {
							console_error("Unable to find any formats", player_response);
							return options.cb(obj);
						}
						if (!videoid || !available_formats.length) {
							return final( /*maxobj*/);
						}
						common_functions["process_formats"](api_cache, options, available_formats, function() {
							get_n_replacer(function(replacer) {
								if (replacer) {
									for (var _i = 0, available_formats_1 = available_formats; _i < available_formats_1.length; _i++) {
										var format = available_formats_1[_i];
										if (!format.url)
											continue;
										if (/[?&]n=/.test(format.url)) {
											format.url = format.url.replace(/([?&]n=)([^&#]+)/, function(_, pre, n) {
												return pre + replacer(n);
											});
										}
									}
								}
								return final(maxobj);
							});
						});
					};
					common_functions["youtube_fetch_embed"](api_cache, options, id, function(data) {
						if (!data || !data.playabilityStatus || data.playabilityStatus.status === "UNPLAYABLE") {
							common_functions["youtube_fetch_watchpage"](api_cache, options, id, parse_player_response);
						} else {
							parse_player_response(data);
						}
					});
					return {
						waiting: true
					};
				}
			}
			if (domain === "images.attvideo.com") {
				match = src.match(/^[a-z]+:\/\/[^/]*\/+image\/+([^/]+)\/+[^/]*(?:[?#].*)?$/);
				if (match) {
					return "https://i.ytimg.com/vi/" + match[1] + "/mqdefault.jpg";
				}
			}
			if (domain_nowww === "phim24h.vn") {
				newsrc = src.replace(/\/5yphoto\/+thumb-[0-9]+\/+/, "/5yphoto/");
				if (newsrc !== src)
					return newsrc;
				match = src.match(/^[a-z]+:\/\/[^/]*\/+5yphoto\/+([^/]+)\/+[^/]+\.[^/.]+(?:[?#].*)?$/);
				if (match) {
					return "https://i.ytimg.com/vi/" + match[1] + "/mqdefault.jpg";
				}
			}
			if (domain === "zeroinger.herokuapp.com" ||
				domain_nowww === "you2php.me") {
				if (/^[a-z]+:\/\/[^/]*\/+thumbnail\.php\?/.test(src)) {
					var queries = get_queries(src);
					var type = queries.type || "mqdefault";
					return "https://i.ytimg.com/vi/" + queries.vid + "/" + type + ".jpg";
				}
			}
			if (domain_nowww === "wapinda.in") return src.replace(/.*\/vimg\.php\?(?:.*?&)?v=([^&]*).*?$/, "https://i.ytimg.com/vi/$1/mqdefault.jpg");
			if (domain_nowww === "invidio.us" ||
				domain === "dev.invidio.us" ||
				domain === "yewtu.be" ||
				domain === "vid.puffyan.us" ||
				domain === "yt.artemislena.eu" ||
				domain === "invidious.flokinet.to" ||
				domain === "invidious.projectsegfau.lt" ||
				domain === "invidious.slipfox.xyz" ||
				domain === "invidious.privacydev.net" ||
				domain === "iv.melmac.space" ||
				domain === "iv.ggtyler.dev" ||
				domain === "invidious.lunar.icu" ||
				domain === "inv.nadeko.net" ||
				domain === "inv.tux.pizza" ||
				domain === "invidious.protokolla.fi" ||
				domain === "iv.nboeck.de" ||
				domain === "invidious.private.coffee" ||
				domain === "yt.drgnz.club" ||
				domain === "iv.datura.network" ||
				domain === "invidious.fdn.fr" ||
				domain === "invidious.perennialte.ch" ||
				domain === "yt.cdaut.de" ||
				domain === "invidious.drgns.space" ||
				domain === "inv.us.projectsegfau.lt" ||
				domain === "invidious.einfachzocken.eu" ||
				domain === "invidious.nerdvpn.de" ||
				domain === "inv.n8pjl.ca" ||
				domain === "youtube.owacon.moe" ||
				domain === "invidious.jing.rocks" ||
				domain === "vid.lilay.dev" ||
				domain === "inv.oikei.net" ||
				domain === "invidious.privacyredirect.com") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]+\/+(vi\/+.*?)(?:[?#].*)?$/, "https://i.ytimg.com/$1");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/^[a-z]+:\/\/[^/]+\/+ggpht\/+(.*?)(?:[?#].*)?$/, "https://lh4.ggpht.com/$1");
				if (newsrc !== src)
					return newsrc;
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+watch\?(?:.*&)?v=([^&]+)(?:[&#].*)?$/,
					query_for_id: "https://" + domain + "/watch?v=${id}",
					process: function(done, resp, cache_key) {
						var obj = common_functions["get_videotag_obj"](resp);
						if (!obj)
							return done(null, false);
						return done(fillobj_urls(obj, {
							headers: {
								Referer: resp.finalUrl
							}
						}), 60 * 60);
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain === "image.bugsm.co.kr") {
				return src.replace(/\/images\/[0-9]*\//, "/images/original/").replace(/\?.*$/, "");
			}
			if (domain_nosub === "wp.com" &&
				domain.match(/i[0-9]\.wp\.com/)) {
				newsrc = remove_queries(src, ["w", "h", "resize", "zoom", "quality", "strip"]);
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/^[a-z]+:\/\/i[0-9]*\.wp\.com\/(.*?)(?:\?.*)?$/, "$1");
				if (newsrc !== src) {
					if (src.match(/[?&]ssl=1(?:&.*)?$/))
						return "https://" + newsrc;
					else
						return "http://" + newsrc;
				}
			}
			if (domain_nosub === "pmdstatic.net") {
				var base = src.replace(/^[a-z]+:\/\/[^/]+\/+(?:fit|scale)\/+(https?\.3A[^/]+)\/.*/, "$1");
				if (base !== src) {
					base = base.replace(/\./g, "%");
					base = decodeURIComponent(base);
					return base;
				}
				match = src.match(/^[a-z]+:\/\/[^/]+\/+[a-z]+\/+~1~(voi)~([0-9]{4})~([0-9]{2})~([0-9]{2})~([-0-9a-f]+\.[a-z]+)\//);
				if (match) {
					return "https://i.pmdstatic.net/" + match[1] + "/" + match[2] + "/" + match[3] + "/" + match[4] + "/" + match[5];
				}
			}
			if (domain_nosub === "pmdstatic.net" && domain.match(/img\..*?pmdstatic\.net$/)) {
				newsrc = src.replace(/.*?\.pmdstatic\.net\/fit\/([^/]*).*/, "$1").replace(/\./g, "%");
				if (newsrc !== src)
					return decodeURIComponent(newsrc);
			}
			if (domain_nowww === "gala.fr") return src.replace(/^[a-z]+:\/\/[^/]+\/+imgre\//, "https://gal.img.pmdstatic.net/");
			if (domain_nowww === "programme.tv") {
				match = src.match(/\/imgre\/+(?:fit|scale)\/+~1~(tls|tel|gal)~([0-9]{4})~([0-9]{2})~([0-9]{2})~([-0-9a-f]{10,}\.[a-z]+)\//);
				if (match) {
					return "https://i.pmdstatic.net/" + match[1] + "/" + match[2] + "/" + match[3] + "/" + match[4] + "/" + match[5];
				}
				match = src.match(/\/imgre\/+(?:fit|scale)\/+(https?\.3A\.2F\.2F[^/]+)\//);
				if (match) {
					return src.replace(/^[a-z]+:\/\/[^/]+\/+imgre\/+/, "https://img.voi.pmdstatic.net/");
				}
			}
			if (domain === "dynaimage.cdn.cnn.com") {
				return decodeURIComponent(src.replace(/.*\/cnn\/[^/]*\//, ""));
			}
			if (domain === "wcmimages.ottawasun.com" ||
				domain === "wcmimages.torontosun.com" ||
				domain === "wcmimages.winnipegsun.com" ||
				domain === "wcmimages.edmontonjournal.com" ||
				src.match(/^[a-z]+:\/\/wcmimages\.[^/]*\/images\?url=http/)) {
				newsrc = decodeURIComponent(src.replace(/^[a-z]+:\/\/[^/]*\/images.*?[?&]url=([^&]*).*/, "$1"));
				if (newsrc !== src)
					return newsrc;
			}
			if (host_domain_nosub === "yahoo.com" && string_indexof(host_domain, "search.") >= 0 && options.element) {
				if (options.element.parentElement && options.element.parentElement.tagName === "A") {
					match = options.element.parentElement.href.match(/^[a-z]+:\/\/[^/]*images\.search\.[^/]+\/+(?:search\/+images|images\/+view)(?:;.*?)\?(?:.*&)?imgurl=([^&]+)/);
					if (match) {
						newsrc = add_http(decodeURIComponent(match[1]));
						if (newsrc !== src)
							return newsrc;
					}
				}
			}
			if ((domain_nosub === "yimg.com" && domain.match(/^(?:[sl]|ct)[0-9]*\.yimg\.com/)) ||
				domain_nosub === "yahoo.com.tw") {
				newsrc = src
					.replace(/.*\/+..\/+api\/+res\/+1\.2\/+[^/]*\/[^/]*\/(https?:)\/{1,2}(.*?)(?:\.cf\.(?:jpg|webp))?$/, "$1//$2")
					.replace(/^http:\/\/l\.yimg\.com\//, "https://l.yimg.com/")
					.replace(/^([a-z]*:\/)([^/])/, "$1/$2")
					.replace(/(:\/\/[^/]*\/)x\/+r\/+[wh][0-9]+\/+i\/+/, "$1i/");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "image.iol.co.za" ||
				domain === "image.tfgmedia.co.za") {
				newsrc = src.replace(/.*\/process\/.*\?.*source=([^&]*).*/, "$1");
				if (newsrc !== src)
					return decodeuri_ifneeded(newsrc);
			}
			if (domain === "image-prod.iol.co.za") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]+\/+(?:[0-9]+x[0-9]+|resize)\/+[0-9]+(?:x[0-9]+)?(?:\/+[^/]*)?\?(?:.*&)?source=([^&]+).*?$/, "$1");
				if (newsrc !== src) {
					newsrc = decodeuri_ifneeded(newsrc);
					if (!/:\/\/xlibris\.[^/]+\.infomaker\.io:/.test(newsrc)) {
						return newsrc;
					}
				}
			}
			if (domain_nosub === "squarespace.com" &&
				domain.match(/^static[0-9]*\.squarespace\.com/)) {
				newsrc = src.replace(/(?:\?.*)?$/, "?format=original");
				if (newsrc !== src)
					return {
						url: newsrc,
						head_wrong_contentlength: true
					};
			}
			if (domain === "images.squarespace-cdn.com") {
				var contenttype = get_queries(src)["content-type"];
				var queries_1 = {};
				if (contenttype)
					queries_1["content-type"] = contenttype;
				newsrc = src
					.replace(/\?.*/, "")
					.replace(/\/+[0-9]+w$/, "");
				var urls = [];
				queries_1.format = "original";
				urls.push(add_queries(newsrc, queries_1));
				queries_1.format = "2500w";
				urls.push(add_queries(newsrc, queries_1));
				delete queries_1.format;
				urls.push(add_queries(newsrc, queries_1));
				return urls;
			}
			if (domain_nosub === "sqspcdn.com") {
				if (/\/static\/+p\/+[0-9]+\/+[0-9]+\/+[0-9]+\//.test(src)) {
					return keep_queries(src, ["token"]);
				}
			}
			if (domain === "static.onecms.io") {
				newsrc = src.replace(/(\/wp-content\/+uploads\/+sites\/+[0-9]+\/+[0-9]{4}\/+(?:[0-9]{2}\/+){2}[^/]+)-2000(\.[^/.]+)(?:[?#].*)?$/, "$1$2");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nowww === "watchdust.com") {
				if (/\/wp-content\/+uploads\/+[0-9]{4}\/+[0-9]{2}\/+EXPLORE-FEATURED-CONTENT_v2\./.test(src)) {
					return {
						url: src,
						bad: "mask"
					};
				}
			}
			if ((domain_nosub === "wordpress.com" && string_indexof(domain, ".files.wordpress.com") >= 0) ||
				((domain_nosub === "imgix.net" ||
					domain === "imgix.bustle.com" ||
					domain === "imgix.ovp.tv2.dk" ||
					domain === "imgix.elitedaily.com" ||
					domain === "imgix.thezoereport.com" ||
					domain === "cdn-imgix-open.headout.com" ||
					domain === "images.assettype.com" ||
					domain === "media.assettype.com" ||
					domain === "images.seoghoer.dk" ||
					(domain === "static.camp-fire.jp" && string_indexof(src, "/uploads/") >= 0) ||
					domain === "media.popculture.com" ||
					(domain === "img.urbania.ca" && string_indexof(src, "/media/") >= 0) ||
					(domain === "images.thefacecdn.com" && string_indexof(src, "/images/") >= 0) ||
					(domain_nosub === "thenewslens.com" && /^image[0-9]*\./.test(domain)) ||
					domain === "imgix.kotaku.com.au" ||
					domain === "imgix.billedbladet.dk" ||
					domain === "imgix.elle.dk" ||
					domain === "imgix.romper.com") &&
					!src.match(/[?&]s=[^/]*$/)) ||
				domain === "stream-cloud-uploads.imgix.net" ||
				amazon_container === "hmg-prod" ||
				domain === "blogs-images.forbes.com" ||
				domain === "images-production.global.ssl.fastly.net" ||
				domain === "images-production.freetls.fastly.net" ||
				(domain_nowww === "fastly.com" && string_indexof(src, "/cimages/") >= 0) ||
				domain_nosub === "cdnds.net" ||
				/*domain.indexOf("hbz.h-cdn.co") >= 0 ||
				  string_indexof(domain, "cos.h-cdn.co") >= 0 ||*/
				domain_nosub === "h-cdn.co" ||
				domain === "cdn.newsapi.com.au" ||
				domain === "images.indianexpress.com" ||
				domain === "images.contentful.com" ||
				domain === "d.ibtimes.co.uk" ||
				domain === "akns-images.eonline.com" ||
				/*domain.indexOf("www.telegraph.co.uk") >= 0 ||
				domain === "subscriber.telegraph.co.uk" ||
				string_indexof(domain, "aws.telegraph.co.uk") >= 0 ||*/
				(domain_nosub === "telegraph.co.uk" && /\/(?:content\/+dam|multimedia\/+archive)\//.test(src)) ||
				domain === "img.buzzfeed.com" ||
				(domain_nosub === "126.net" && domain.match(/^p[0-9]*\.music\.126\.net/)) ||
				domain === "stat.profile.ameba.jp" ||
				domain === "stat.blogskin.ameba.jp" ||
				domain === "stat.ameba.jp" ||
				domain === "image.uczzd.cn" ||
				domain === "img.danawa.com" ||
				domain === "img-www.tf-cdn.com" ||
				domain_nosub === "viki.io" ||
				(domain_nosub === "githubusercontent.com" && domain.match(/^avatars[0-9]*\./)) ||
				(domain_nosub === "townnews.com" && domain.match(/bloximages\..*vip\.townnews\.com/)) ||
				domain === "steamuserimages-a.akamaihd.net" ||
				(domain_nosub === "pressassociation.io" && domain.match(/\.assets\.pressassociation\.io$/)) ||
				domain === "media.immediate.co.uk" ||
				domain === "images.immediate.co.uk" ||
				domain === "media.npr.org" ||
				domain === "assets.teamrock.com" ||
				(domain_nosub === "woopic.com" && domain.match(/^media[0-9]\.woopic\.com/)) ||
				(domain_nosub === "libe.com" && domain.match(/^md[0-9]\.libe\.com/)) ||
				domain === "medias.liberation.fr" ||
				domain === "regmedia.co.uk" ||
				domain === "imageservice.nordjyske.dk" ||
				(domain === "cms.algoafm.co.za" && string_indexof(src, "/img/") >= 0) ||
				(domain_nowww === "gosoutheast.com" && string_indexof(src, "/images/") >= 0) ||
				(domain_nosub === "nikkeibp.co.jp" && src.toLowerCase().match(/\.(?:jpg|png)/)) ||
				(domain_nosub === "best.gg" && domain.match(/s-a[0-9]*\.best\.gg/)) ||
				(domain_nosub === "walmartimages.com" && domain.match(/i[0-9]*\.walmartimages\.com/)) ||
				domain === "nails.newsela.com" ||
				domain === "ojsfile.ohmynews.com" ||
				domain === "lumiere-a.akamaihd.net" ||
				domain === "img.lum.dolimg.com" ||
				domain_nowww === "xxlmag.com" ||
				domain === "image.insider.com" ||
				domain === "i.insider.com" ||
				domain === "image.businessinsider.com" ||
				(domain_nosub === "vice.com" && domain.match(/images\.vice\.com$/)) ||
				((domain === "i.imgur.com" || domain === "i.imgur.io") && !src.match(/\?[0-9]+$/)) ||
				domain === "images.discordapp.net" ||
				domain === "images.theconversation.com" ||
				(domain_nowww === "rspb.org.uk" && string_indexof(src, "/globalassets/") >= 0) ||
				(domain === "media.beliefnet.com" && (/\/media\//i).test(src)) ||
				(domain_nowww === "ramblers.org.uk" && (/\/media\//i).test(src)) ||
				(domain === "warnerbrosuk.azureedge.net" && (/\/media\//i).test(src)) ||
				(domain_nowww === "warnerbros.co.uk" && (/\/media\//i).test(src)) ||
				(domain_nosub === "vietnamnet.vn" && /^(?:[^/]*\.)?img(?:\.cdn[0-9]*|s)\./.test(domain)) ||
				domain === "i.gadgets360cdn.com" ||
				domain_nosub === "ndtvimg.com" ||
				domain === "d3lp4xedbqa8a5.cloudfront.net" ||
				(domain_nowww === "brnow.org" && string_indexof(src, "/getattachment/") >= 0) ||
				(domain_nosub === "btime.com" && domain.match(/p[0-9]*\.(?:ssl\.)?cdn\.btime\.com/)) ||
				domain === "images.twistmagazine.com" ||
				domain === "sites.google.com" ||
				domain === "images.pexels.com" ||
				domain === "images.unsplash.com" ||
				domain_nosub === "r10s.com" ||
				domain_nosub === "r10s.jp" ||
				domain === "static.netlife.vn" ||
				domain === "rs.phunuonline.com.vn" ||
				domain === "images.nbcolympics.com" ||
				(domain === "dist.joshinweb.jp" && string_indexof(src, "/img/") >= 0) ||
				domain === "live-production.wcms.abc-cdn.net.au" ||
				domain === "compote.slate.com" ||
				domain_nosub === "gannett-cdn.com" ||
				(domain_nowww === "rdfm-radio.fr" && string_indexof(src, "/medias/") >= 0) ||
				(domain === "salleobscure.e-monsite.com" && string_indexof(src, "/medias/") >= 0) ||
				domain === "image-api.nrj.fr" ||
				domain === "api.hdwallpapers5k.com" ||
				(domain_nosub === "koreaportal.com" && domain.match(/images\.[^.]*\.koreaportal\.com/)) ||
				(domain_nowww === "officialcharts.com" && string_indexof(src, "/media/") >= 0) ||
				(domain_nowww === "citywonders.com" && string_indexof(src, "/media/") >= 0) ||
				(domain_nowww === "fee.org" && string_indexof(src, "/media/") >= 0) ||
				(domain_nosub === "agoda.net" && domain.match(/pix[0-9]*\.agoda\.net/)) ||
				domain === "images.pottermore.com" ||
				(domain_nowww === "google.com" && src.match(/\/photos\/public\/[^/]*$/)) ||
				domain === "images.streamable.com" ||
				domain === "cdn.amebaowndme.com" ||
				(domain_nowww === "kaixian.tv" && string_indexof(src, "/file/") >= 0) ||
				(domain === "sumo.cdn.tv2.no" && string_indexof(src, "/imageapi/") >= 0) ||
				(domain_nowww === "bzqzsj.com" && string_indexof(src, "/uploads/") >= 0) ||
				domain === "media.missguided.com" ||
				domain === "photo.venus.com" ||
				domain === "cdn-images.prettylittlething.com" ||
				(domain_nowww === "sephora.com" && string_indexof(src, "/productimages/") >= 0) ||
				(domain_nowww === "popcrush.com" && string_indexof(src, "/files/") >= 0) ||
				(domain_nowww === "screencrush.com" && string_indexof(src, "/files/") >= 0) ||
				(domain_nosub === "nineentertainment.com.au" && domain.match(/assets\.[^.]*\.nineentertainment\.com\.au/)) ||
				(domain_nowww === "thenational.ae" && string_indexof(src, "/image/") >= 0) ||
				(domain_nowww === "dagsavisen.no" && string_indexof(src, "/image/") >= 0) ||
				(domain_nosub === "kh1.co" && domain.match(/s[0-9]*\.kh1\.co/)) ||
				domain === "uploads.disquscdn.com" ||
				(domain_nowww === "voidu.com" && string_indexof(src, "/gallery/") >= 0) ||
				(domain === "store.playstation.com" && string_indexof(src, "/image?") >= 0) ||
				(domain_nosub === "playstation.com" && /^blog\./.test(domain)) ||
				(domain_nowww === "snopes.com" && string_indexof(src, "/tachyon/") >= 0) ||
				domain === "images.interactives.dk" ||
				domain === "toyo-arhxo0vh6d1oh9i0c.stackpathdns.com" ||
				(domain_nowww === "zmonline.com" && string_indexof(src, "/media/") >= 0) ||
				domain === "cdn.instructables.com" ||
				domain === "images.performgroup.com" ||
				domain === "media.playmobil.com" ||
				domain === "img.crocdn.co.uk" ||
				(domain_nowww === "calgaryherald.com" && string_indexof(src, "/cms/") >= 0) ||
				(domain_nowww === "montrealgazette.com" && string_indexof(src, "/cms/") >= 0) ||
				(domain_nosub === "ikea.com" && string_indexof(src, "/images/") >= 0) ||
				(domain_nowww === "colorwallpaper.net" && string_indexof(src, "/img/") >= 0) ||
				domain === "img.cache.vevo.com" ||
				(domain === "drop.ndtv.com" && string_indexof(src, "/albums/") >= 0) ||
				(domain_nosub === "christiandaily.com" && string_indexof(domain, "images.christianitydaily.com") >= 0) ||
				domain === "cdn.christianitydaily.com" ||
				(domain_nosub === "christiandaily.co.kr" && string_indexof(domain, "images.christiandaily.co.kr") >= 0) ||
				domain === "images.christiantoday.co.kr" ||
				domain === "blogimg.goo.ne.jp" ||
				domain === "cdn.clien.net" ||
				(domain_nosub === "imgs.cc" && domain.match(/s[0-9]*\.imgs\.cc/)) ||
				(domain_nosub === "amebame.com" && string_indexof(domain, "stat.amebame.com") >= 0) ||
				domain === "cdn-hit.scadigital.io" ||
				(domain_nosub === "picsart.com" && domain.match(/cdn[0-9]*\.picsart\.com/)) ||
				domain === "cdn.ndtv.com" ||
				(domain_nosub === "kompasiana.com" && domain.match(/assets(?:-[a-z][0-9])?\.kompasiana\.com/)) ||
				domain === "images.popbuzz.com" ||
				(domain_nosub === "adis.ws" && domain.match(/i[0-9]*\.adis\.ws/)) ||
				(domain_nosub === "9c9media.com" && domain.match(/^images[0-9]*\.9c9media\.com/)) ||
				(domain_nosub === "newser.com" && domain.match(/img[0-9]*(?:-[a-z]+)?\.newser\.com/)) ||
				domain === "images.m-magazine.com" ||
				(domain_nowww === "zoom.co.uk" && src.match(/\/assets\/+images\/+/)) ||
				domain === "ctd-thechristianpost.netdna-ssl.com" ||
				domain === "img.vidible.tv" ||
				(domain_nosub === "j-14.com" && domain.match(/images\.(?:[a-z]+\.)?j-14\.com/)) ||
				domain === "cdn.abcotvs.com" ||
				(domain_nowww === "tasteofcountry.com" && string_indexof(src, "/files/") >= 0) ||
				domain === "images.thewest.com.au" ||
				(domain_nosub === "ntv.com.tr" && domain.match(/cdn[0-9]*\.ntv\.com\.tr/)) ||
				(domain_nosub === "hotnessrater.com" && domain.match(/img[0-9]*\.hotnessrater\.com/)) ||
				domain_nowww === "starcrush.com" ||
				(domain_nowww === "chrichri.dk" && string_indexof(src, "/media/") >= 0) ||
				(domain_nowww === "rightstufanime.com" && string_indexof(src, "/images/") >= 0) ||
				(domain_nosub === "teeshirtpalace.com" && /^images[0-9]*\./.test(domain)) ||
				domain === "assets.bigcartel.com" ||
				domain === "binaryapi.ap.org" ||
				domain === "images.8tracks.com" ||
				domain === "d2ykdu8745rm9t.cloudfront.net" ||
				(domain_nosub === "spoilercat.com" && domain.match(/cdn[0-9]*\.spoilercat\.com/)) ||
				(domain_nowww === "mumbailive.com" && string_indexof(src, "/images/") >= 0) ||
				domain === "static.juksy.com" ||
				domain === "img.reblog.hu" ||
				(domain_nowww === "thefw.com" && string_indexof(src, "/files/") >= 0) ||
				domain === "img.csfd.cz" ||
				(domain_nosub === "timesnownews.com" && /^img/.test(domain)) ||
				domain === "img.siksinhot.com" ||
				domain === "mp-seoul-image-production-s3.mangoplate.com" ||
				domain === "api.theweek.com" ||
				domain === "i.smalljoys.me" ||
				(domain_nosub === "huanqiu.cn" && domain.match(/t[0-9]*\.huanqiu.cn/)) ||
				(domain_nowww === "hypebeast.com" && string_indexof(src, "/image/") >= 0) ||
				(domain_nowww === "dramaguru.net" && string_indexof(src, "/images/") >= 0) ||
				domain === "sos.vfan.vlive.tv" ||
				(domain_nosub === "journalmedia.ie" && domain.match(/^img[0-9]*\./)) ||
				(domain_nosub === "thejournal.ie" && domain.match(/^img[0-9]*\./)) ||
				(domain === "external.polskieradio.pl" && string_indexof(src, "/files/") >= 0) ||
				domain === "thumb.netz.id" ||
				(domain_nosub === "tchyn.io" && string_indexof(src, "/snopes-production/uploads/") >= 0) ||
				domain === "img.diply.com" ||
				domain === "cdn-assets.ziniopro.com" ||
				domain === "netherlands-grlk5lagedl.stackpathdns.com" ||
				(domain_nosub === "stackpathdns.com" && string_indexof(domain, "-grlk5lagedl.stackpathdns.com") >= 0) ||
				(domain_nowww === "beautycrew.com.au" && string_indexof(src, "/media/") >= 0) ||
				(domain === "dsx.weather.com" && string_indexof(src, "/util/image/") >= 0) ||
				domain === "img.r7.com" ||
				domain === "cdn-images.rtp.pt" ||
				domain === "media.ouest-france.fr" ||
				domain === "images.pluto.tv" ||
				(domain_nowww === "rbsdirect.com.br" && string_indexof(src, "/imagesrc/") >= 0) ||
				((domain_nowww === "newfoundlandlabrador.com" ||
					domain_nowww === "mccormick.com" ||
					domain === "d1e3z2jco40k3v.cloudfront.net") && string_indexof(src, "/-/media/") >= 0) ||
				domain === "images.businessoffashion.com" ||
				(domain_nosub === "pg0.cn" && domain.match(/cmsfile\.pg0\.cn/)) ||
				domain === "api.ning.com" ||
				(domain_nosub === "mpinteractiv.ro" && domain.match(/^storage[0-9]*\./) && string_indexof(src, "/media/") >= 0) ||
				(domain_nosub === "muscache.com" && src.match(/\/im\/pictures\/[-0-9a-f]+\./)) ||
				(domain_nowww === "wedd.today" && string_indexof(src, "/wallpaper/") >= 0) ||
				(domain_nowww === "looklive.at" && src.match(/\/media\/[0-9]+\//)) ||
				domain === "t.tudocdn.net" ||
				(domain === "me.phununet.com" && string_indexof(src, "/resources/img/") >= 0) ||
				(domain === "cdn.diario26.com.ar" && string_indexof(src, "/media/image/") >= 0) ||
				(domain_nowww === "discovermagazine.com" && string_indexof(src, "/media/Images/") >= 0) ||
				domain === "steamusercontent-a.akamaihd.net" ||
				(domain_nowww === "qfeast.com" && string_indexof(src, "/imret/") >= 0) ||
				(domain === "statis.gamen.vn" && string_indexof(src, "/images/upload/") >= 0) ||
				domain === "img.anikore.jp" ||
				(domain_nosub === "newsplex.pt" && domain.match(/^cdn[0-9]*\./)) ||
				(domain === "static.origos.hu" && string_indexof(src, "/img/") >= 0) ||
				(domain === "cdn.nwmgroups.hu" && string_indexof(src, "/img/") >= 0) ||
				(domain_nowww === "robertocavada.com" && string_indexof(src, "/Images/") >= 0) ||
				domain === "images.mncdn.pl" ||
				(domain_nowww === "imgsearches.com" && string_indexof(src, "/i/") >= 0) ||
				(domain_nowww === "thetimesnews.com" && (string_indexof(src, "/storyimage/") >= 0 ||
					string_indexof(src, "/galleryimage/") >= 0)) ||
				domain === "static.fthis.gr" ||
				(domain === "img.pixelz.com" && string_indexof(src, "/blog/") >= 0) ||
				(domain_nosub === "hellomagazine.com" && (string_indexof(src, "/imagenes/") >= 0 || string_indexof(src, "/images/") >= 0)) ||
				domain === "images.hellomagazine.com" ||
				(domain_nosub === "1616.ro" && domain.match(/^i[0-9]*\./)) ||
				domain === "images.lifeandstylemag.com" ||
				(domain_nosub === "fonwall.ru" && domain.match(/^img[0-9]*\./)) ||
				(domain_nowww === "wonderwall.com" && string_indexof(src, "/photos/") >= 0) ||
				(domain_nowww === "thestar.com.my" && string_indexof(src, "/~/media/online/") >= 0) ||
				(domain_nowww === "vancouversun.com" && string_indexof(src, "/cms/") >= 0) ||
				(domain === "image.lag.vn" && string_indexof(src, "/upload/") >= 0) ||
				(domain_nowww === "booktrust.org.uk" && string_indexof(src, "/globalassets/images/") >= 0) ||
				(domain_nosub === "ccio.co" && domain.match(/^ind[0-9]*\./)) ||
				(domain_nosub === "cpcache.com" && domain.match(/^i[0-9]*\./)) ||
				domain === "i.rocdn.com" ||
				(domain === "resource.globenewswire.com" && string_indexof(src, "/Resource/Download/") >= 0) ||
				(domain_nowww === "townsquare.media" && src.match(/\/+site\/+[0-9]+\/+files\/+/)) ||
				domain === "images.reference.com" ||
				domain === "assets.pcmag.com" ||
				domain === "images.jg-cdn.com" ||
				(domain_nosub === "qingstor.com" && string_indexof(src, "/images/articles/") >= 0) ||
				domain === "img.ibxk.com.br" ||
				(domain === "image.biccamera.com" && string_indexof(src, "/img/") >= 0) ||
				(domain_nosub === "mu-mo.net" && string_indexof(src, "/image/") >= 0) ||
				(domain_nowww === "g-mark.org" && string_indexof(src, "/media/") >= 0) ||
				((domain === "kubrick.htvapps.com" || amazon_container === "htv-prod-media") && string_indexof(src, "/images/") >= 0) ||
				domain === "images.france.fr" ||
				(domain === "az877327.vo.msecnd.net" && string_indexof(src, "/media/images/") >= 0) ||
				(domain_nosub === "hoteljardinlebrea.com" && string_indexof(src, "/usermedia/") >= 0) ||
				(domain_nosub === "veltra.com" && domain.match(/^cdn[0-9]*\./)) ||
				(domain === "img.letgo.com" && string_indexof(src, "/images/") >= 0) ||
				(domain === "images.musement.com" && string_indexof(src, "/cover/") >= 0) ||
				domain === "i.playground.ru" ||
				(domain_nowww === "treeoftheyear.org" && string_indexof(src, "/getmedia/") >= 0) ||
				(domain_nowww === "dukeupress.edu" && string_indexof(src, "/getmedia/") >= 0) ||
				(domain_nowww === "canadashistory.ca" && string_indexof(src, "/getmedia/") >= 0) ||
				(domain === "cdn.indicium.nu" && string_indexof(src, "/source/grazia/") >= 0) ||
				domain === "news-img.51y5.net" ||
				(domain === "st.automobilemag.com" && string_indexof(src, "/uploads/sites/") >= 0) ||
				(domain === "styles.redditmedia.com" && string_indexof(src, "/styles/") >= 0) ||
				domain === "img.webmd.com" ||
				domain === "embedwistia-a.akamaihd.net" ||
				amazon_container === "ame-prod-redonline-assets" ||
				(domain_nowww === "noted.co.nz" && string_indexof(src, "/media/") >= 0) ||
				domain === "image.cnbcfm.com" ||
				domain === "images.newrepublic.com" ||
				(domain_nowww === "madametussauds.com" && string_indexof(src, "/media/") >= 0) ||
				(domain_nowww === "tirolerin.at" && string_indexof(src, "/media/") >= 0) ||
				(domain === "media.deseretdigital.com" && string_indexof(src, "/file/") >= 0) ||
				domain === "assets.audiomack.com" ||
				domain === "pic.rutube.ru" ||
				(domain === "cdn.marketplaceimages.windowsphone.com" && string_indexof(src, "/images/") >= 0) ||
				((domain === "dsocdn.akamaized.net" ||
					domain === "nbocdn.akamaized.net" ||
					domain === "avecdn.akamaized.net" ||
					domain === "static.hbvl.be" ||
					domain === "static.standaard.be" ||
					domain === "limnlcdn.akamaized.net") && /\/Assets\/+Images_Upload\//i.test(src)) ||
				(domain === "netstorage-nur.akamaized.net" && string_indexof(src, "/images/") >= 0) ||
				domain === "images.moviebuff.com" ||
				domain === "static-ugc-media.hk01.com" ||
				(domain_nowww === "warwick.film" && string_indexof(src, "/image/") >= 0) ||
				(domain_nowww === "quizizz.com" && src.match(/\/media\/+resource\/+/)) ||
				(domain_nowww === "eroce.com" && string_indexof(src, "/img/") >= 0) ||
				(domain === "img-cdn.hipertextual.com" && string_indexof(src, "/files/") >= 0) ||
				(domain === "img.ponparemall.net" && string_indexof(src, "/imgmgr/") >= 0) ||
				(domain === "smart.usen.com" && string_indexof(src, "/data/") >= 0) ||
				domain === "img.digitaldjpool.com" ||
				(domain_nosub === "szn.cz" && domain.match(/\.sdn\./) && string_indexof(src, "_img_") >= 0) ||
				(domain_nowww === "banana1015.com" && string_indexof(src, "/files/") >= 0) ||
				(domain_nowww === "mix106radio.com" && string_indexof(src, "/files/") >= 0) ||
				(domain === "static-cdn.sr.se" && string_indexof(src, "/images/") >= 0) ||
				(domain === "cdn.kaumo.jp" && string_indexof(src, "/element/") >= 0) ||
				(domain === "d12swbtw719y4s.cloudfront.net" && string_indexof(src, "/images/") >= 0) ||
				(domain_nowww === "saplinghr.com" && string_indexof(src, "/hubfs/") >= 0) ||
				(domain === "telefe-static2.akamaized.net" && string_indexof(src, "/media/") >= 0) ||
				domain_nowww === "10daily.com.au" ||
				(domain === "spark.adobe.com" && string_indexof(src, "/page/") >= 0) ||
				(domain === "blog.adobe.com" && /:\/\/[^/]+\/+(?:[a-z]+_)?[0-9a-f]{20,}\./.test(src)) ||
				(domain === "s.w-x.co" && string_indexof(src, "/image/") >= 0) ||
				domain === "img.monocle.com" ||
				(domain === "bildix.mmcloud.se" && /\/bildix\/+api\/+images\/+/.test(src)) ||
				(domain === "media.cinedb.com.tr" && /\/Upload\//i.test(src)) ||
				(domain_nowww === "newidea.com.au" && string_indexof(src, "/media/") >= 0) ||
				(domain_nowww === "essexstudent.com" && /\/asset\//i.test(src)) ||
				(domain === "d.newsweek.com" && string_indexof(src, "/full/") >= 0) ||
				(domain === "images.techtimes.com" && /\/data\/+images\/+/.test(src)) ||
				domain === "oyster.ignimgs.com" ||
				(domain_nowww === "marieclaire.com.au" && string_indexof(src, "/media/") >= 0) ||
				(domain_nowww === "stylist.co.uk" && /\/images\/+app\/+uploads\/+/.test(src)) ||
				(domain_nowww === "britishfashioncouncil.co.uk" && string_indexof(src, "/uploads/") >= 0) ||
				(domain === "static.fptplay.net" && string_indexof(src, "/img/") >= 0) ||
				domain === "images-mega.mdstrm.com" ||
				(domain_nowww === "girlfriend.com.au" && string_indexof(src, "/media/") >= 0) ||
				domain === "imgs.ngaotruyen.com" ||
				(domain === "d1ywb8dvwodsnl.cloudfront.net" && /\/files\.fuzoku\.jp\/+img\//.test(src)) ||
				(domain_nowww === "menshealth.com.au" && string_indexof(src, "/media/") >= 0) ||
				(domain === "2sao.vietnamnetjsc.vn" && string_indexof(src, "/images/") >= 0) ||
				(domain === "images.jkn.co.kr" && string_indexof(src, "/images/") >= 0) ||
				(domain_nowww === "instylemag.com.au" && string_indexof(src, "/media/") >= 0) ||
				(domain_nowww === "who.com.au" && /\/media\/+[0-9]+\//.test(src)) ||
				domain === "i.eurosport.com" ||
				(domain === "blog.wirelessanalytics.com" && string_indexof(src, "/hubfs/") >= 0) ||
				(domain_nosub === "zmtcdn.com" && string_indexof(src, "/data/") >= 0) ||
				(domain === "images.mubi.com" && string_indexof(src, "/images/") >= 0) ||
				domain === "i.obozrevatel.com" ||
				(domain_nosub === "paytm.com" && /^assetscdn[0-9]*\./.test(domain)) ||
				domain === "images.perthnow.com.au" ||
				(domain === "netstorage-yen.akamaized.net" && string_indexof(src, "/images/") >= 0) ||
				domain === "static.nexilia.it" ||
				(domain_nosub === "eldia.com" && /^cdn[0-9]*\./.test(domain)) ||
				(domain_nowww === "esquire.com.gr" && /\/Content\/+ImagesDatabase\//i.test(src)) ||
				domain === "akmedia.hollywoodlife.com" ||
				(domain_nowww === "refinery29.com" && string_indexof(src, "/images/") >= 0) ||
				(domain === "images.radio.com" && string_indexof(src, "/aiu-media/") >= 0) ||
				(domain_nowww === "casseycds.net" && string_indexof(src, "/uploads/") >= 0) ||
				(domain_nowww === "youmekorea.com" && /[?&]thumb=/.test(src)) ||
				(domain_nosub === "tower.jp" && /\/~\/+media\//.test(src)) ||
				domain === "images.boosty.to" ||
				domain === "media.nbcnewyork.com" ||
				domain_nosub === "sdn.cz" ||
				(domain_nosub === "unrealengine.com" && /^cdn[0-9]*\./.test(domain)) ||
				(domain === "cdn.repub.ch" && string_indexof(src, "/republik-assets/") >= 0) ||
				(domain_nowww === "smarthomebeginner.com" && string_indexof(src, "/images/") >= 0) ||
				domain === "images.ask.com" ||
				(domain === "i.vimeocdn.com" && /\/(?:video|custom_asset)\//.test(src)) ||
				domain === "artwork.jaxsta.com" ||
				(domain_nowww === "tisamipo.co.il" && string_indexof(src, "/CMSGALLERY/") >= 0) ||
				(domain === "images.shakespearesglobe.com" && string_indexof(src, "/uploads/") >= 0) ||
				domain === "cdn.hashnode.com" ||
				domain === "d31wcbk3iidrjq.cloudfront.net" ||
				domain === "marketplace-screenshots.githubusercontent.com" ||
				domain === "stmedia.stimg.co" ||
				(domain_nosub === "coppel.com" && /^cdn[0-9]*\./.test(domain) && /\/images\//.test(src)) ||
				(domain === "dynamicmedia.livenationinternational.com" && /:\/\/[^/]+\/+media\//i.test(src)) ||
				(domain === "cdn.sanity.io" && string_indexof(src, "/images/") >= 0) ||
				(domain_nowww === "e-outdoor.co.uk" && string_indexof(src, "/pi/") >= 0) ||
				(domain_nosub === "disco-api.com" && /images\./.test(domain)) ||
				(domain_nowww === "devold.com" && /\/globalassets\/+catalog-images\//.test(src)) ||
				domain === "contents.mediadecathlon.com" ||
				domain === "ubiservices.cdn.ubi.com" ||
				domain === "feeds.abplive.com" ||
				domain === "images.thequint.com" ||
				domain === "images.prismic.io" ||
				(domain === "files.vierlive.io" && string_indexof(src, "/images/") >= 0) ||
				domain === "assets.isu.pub" ||
				(domain === "img.nbc.com" && /\/files\/+images\//.test(src)) ||
				(domain === "kake.images.worldnow.com" && string_indexof(src, "/images/") >= 0) ||
				domain_nowww === "datocms-assets.com" ||
				domain === "cdn.amomama.com" ||
				domain === "images.ardmediathek.de" ||
				(domain === "api.ardmediathek.de" && /\/image-service\/+images\//.test(src)) ||
				domain === "i.weltbild.de" ||
				domain === "images-static.nykaa.com" ||
				((domain_nowww === "familyvideo.com" ||
					domain_nosub === "coca-cola.com" ||
					(domain_nosub === "asus.com" && /store\./.test(domain)) ||
					domain === "doa.robinson.co.th")
					&& /\/media\/+catalog\//.test(src)) ||
				domain === "media.littlewoodsireland.ie" ||
				domain === "media.littlewoods.com" ||
				domain === "media.very.co.uk" ||
				(domain_nowww === "prodirectrunning.com" && string_indexof(src, "/ProductImages/") >= 0) ||
				(domain_nowww === "studywalker.jp" && string_indexof(src, "/images/") >= 0) ||
				(domain === "repo.packix.com" && /\/api\/+Packages\/+[0-9a-f]{10,}\/+icon\//.test(src)) ||
				domain === "new.static.tv.nu" ||
				domain === "cdn.royalcanin-weshare-online.io" ||
				domain === "images.stockx.com" ||
				(domain === "img.paravi.jp" && string_indexof(src, "/files/") >= 0) ||
				domain === "runningbare-cdn.global.ssl.fastly.net" ||
				domain_nosub === "ostkcdn.com" ||
				domain === "media.dior.com" ||
				(domain === "netstorage-legit.akamaized.net" && string_indexof(src, "/images/") >= 0) ||
				domain === "images.dn.no" ||
				(domain === "cash-images-f.squarecdn.com" && /\/apps\/+imgs\//.test(src)) ||
				(domain === "blog.hubspot.com" && /\/hubfs\//.test(src)) ||
				domain === "cdn.waplog.com" ||
				(domain === "wiki.lycanitesmobs.com" && /\/_media\//.test(src)) ||
				domain === "image.pbs.org" ||
				domain === "fyre.cdn.sewest.net" ||
				domain === "image.uniqlo.com" ||
				domain === "imgc.nxtv.jp" ||
				domain === "vcdn.polarismedia.no" ||
				domain === "thumbnails.cbc.ca" ||
				domain === "media.nbcchicago.com" ||
				(domain === "cdn.mopo.de" && /\/uploads\//.test(src)) ||
				domain === "images.nordbayern.de" ||
				(domain_nowww === "sportsbusinessjournal.com" && /\/-\/+media\/+Images\//i.test(src)) ||
				(domain_nowww === "newschainonline.com" && /\/bsp-static\//.test(src)) ||
				domain === "images.berliner-kurier.de" ||
				(domain === "cdn.nba.com" && /\/manage\//.test(src)) ||
				domain_nowww === "sportal365images.com" ||
				(domain === "cdn.unitycms.io" && /\/images\//.test(src)) ||
				domain === "img.nzz.ch" ||
				domain === "media.necn.com" ||
				(domain_nowww === "nzxt.com" && /\/assets\/+cms\//.test(src)) ||
				(domain_nowww === "eposaudio.com" && /\/globalassets\/+__pim\//.test(src)) ||
				domain === "static.okko.tv" ||
				(domain === "news.leicester.gov.uk" && /\/media\//.test(src)) ||
				domain === "chorus.stimg.co" ||
				(domain_nowww === "fssochi.ru" && /\/content\/+cms\/+files\//.test(src)) ||
				(domain === "i.gremicdn.pl" && /\/image\/+free\//.test(src)) ||
				domain === "images.getbento.com" ||
				(domain_nowww === "christies.com" && string_indexof(src, "/img/") >= 0) ||
				domain === "bmg-images.forward-publishing.io" ||
				(domain === "image-via.katsomo.fi" && /\/api\/+v2\/+img\//.test(src)) ||
				(domain === "img.plasmic.app" && /\/img-optimizer\/+v1\//.test(src)) ||
				domain === "d2kq0urxkarztv.cloudfront.net" ||
				(domain_nowww === "peacocktv.com" && /\/dam\/+[^/]+\/+assets\//.test(src)) ||
				(domain === "m.hng.io" && /\/catalog\/+product\//.test(src)) ||
				domain === "uploads.dailydot.com" ||
				domain === "images.audacy2-prod.ext.audacy.com" ||
				domain === "phinf.wevpstatic.net" ||
				domain === "prod-images.tcm.com" ||
				domain === "media.redbullmusicacademy.com" ||
				(domain === "s3media.247sports.com" && string_indexof(src, "/Uploads/") >= 0) ||
				(domain_nowww === "eva.ru" && string_indexof(src, "/imgix/") >= 0) ||
				domain === "assets.goal.com" ||
				(domain === "imgs.casasbahia.com.br" && /:\/\/[^/]+\/+[0-9]+\/+[0-9]+[a-z]+\./.test(src)) ||
				domain === "imgr.starmag.com" ||
				(domain === "cdn.thewirecutter.com" && /\/wp-content\/+media\//.test(src)) ||
				(domain === "files.ekmcdn.com" && string_indexof(src, "/images/") >= 0) ||
				(domain_nowww === "highsnobiety.com" && string_indexof(src, "/static-assets/") >= 0) ||
				(domain === "cdn.kodansha.us" && string_indexof(src, "/statics/") >= 0) ||
				domain === "assetsio.reedpopcdn.com" ||
				(domain_nowww === "sony.com" && /\/image\/+[0-9a-f]{5,}\?/.test(src)) ||
				domain === "ugc.production.linktr.ee" ||
				(domain === "s13emagst.akamaized.net" && /\/products\/+[0-9]+\/+[0-9]+\/+images\//.test(src)) ||
				(domain === "content.api.news" && /\/v3\/+images\/+bin\/+[0-9a-f]{10,}/.test(src)) ||
				(domain_nowww === "panasonic.com" && /\/content\/+dam\//.test(src)) ||
				domain === "images.komi.io" ||
				(domain_nosub === "mi-img.com" && /\.api\./.test(domain)) ||
				(domain === "groundnews.b-cdn.net" && /\/assets\/+web\/+images\//.test(src)) ||
				domain === "images.pangobooks.com" ||
				domain === "assets.mmsrg.com" ||
				domain === "images.moviesanywhere.com" ||
				(domain === "d1kq2dqeox7x40.cloudfront.net" && /\/images\//.test(src)) ||
				domain_nowww === "nouwcdn.com" ||
				domain === "eh96lnrmau.user-space.cdn.idcfcloud.net" ||
				(domain_nowww === "lego.com" && /\/cdn\/+.*\/assets\//.test(src)) ||
				(domain === "images.delfi.ee" && /\/media-api-image-cropper\//.test(src)) ||
				domain === "img.br.de" ||
				domain === "images.prod.hjholdings.tv" ||
				domain === "img.haarets.co.il" ||
				(domain_nowww === "wnoz.de" && /\/imgs\//.test(src)) ||
				domain === "assets.steadyhq.com" ||
				((domain === "eu-images.contentstack.com" ||
					domain === "images.blz-contentstack.com")
					&& /\/v3\/+assets\//.test(src)) ||
				domain === "img.projektn.sk" ||
				(domain === "images.daznservices.com" && /\/di\/+library\//.test(src)) ||
				domain_nowww === "thetv.jp" ||
				(domain === "metac.nxtv.jp" && /\/img\//.test(src)) ||
				(domain === "media.victorinox.com" && string_indexof(src, "/transform/") >= 0) ||
				domain === "image.heavenly.tv" ||
				domain === "images.footballfanatics.com" ||
				domain === "stat.dokusho-ojikan.jp" ||
				(domain_nowww === "savannahnow.com" && string_indexof(src, "/gcdn/") >= 0) ||
				(domain === "cdn.leonardo.ai" && /\/generations\//.test(src)) ||
				(domain_nosub === "sozcucdn.com" && /^sozcu[0-9]*\./.test(domain) && /\/uploads\/+images\//.test(src)) ||
				domain === "prcdn.freetls.fastly.net" ||
				(domain_nowww === "filmfest-muenchen.de" && string_indexof(src, "/Pictures/") >= 0) ||
				domain === "cdn.hobbyconsolas.com" ||
				(domain_nowww === "nottingham.ac.uk" && /\/images\//i.test(src)) ||
				(domain_nowww === "catholicnewsagency.com" && /\/storage\/+image\//.test(src)) ||
				(domain === "cdn.ferrari.com" && /\/media\/+img\//.test(src)) ||
				(domain_nowww === "otempo.com.br" && /\/dynamicmedia\/+deliver\//.test(src)) ||
				domain === "assetsio.gnwcdn.com" ||
				(domain_nowww === "azcentral.com" && /\/gcdn\//.test(src)) ||
				domain === "images.kerrangcdn.com" ||
				(domain_nowww === "cso.org" && /\/media\//.test(src)) ||
				src.match(/\/demandware\.static\//) ||
				src.match(/\?i10c=[^/]*$/) ||
				/^[a-z]+:\/\/[^?]*\/wp(?:-content\/+(?:uploads|blogs.dir)|\/+uploads)\//.test(src)
			/*src.indexOf("/wp-content/blogs.dir/") >= 0 ||
			string_indexof(src, "/wp-content/uploads/") >= 0 ||
			string_indexof(src, "/wp/uploads/") >= 0*/ ) {
				src = src.replace(/\?.*$/, "");
			}
			if (domain === "cdn.odigo.net" ||
				domain === "wangsuimg.fanshuapp.com" ||
				domain === "img.aiji66.com" ||
				domain === "imgs.aixifan.com" ||
				domain === "imgcdn.thecover.cn" ||
				domain === "img.shelive.net" ||
				domain === "img.qdaily.com" ||
				domain === "qimage.owhat.cn" ||
				domain === "cdn.ruguoapp.com" ||
				(domain === "user-assets.sxlcdn.com" && string_indexof(src, "/images/") >= 0) ||
				domain === "img.ksl.com" ||
				(domain_nosub === "tapimg.com" && domain.match(/^img[0-9]*\./)) ||
				domain === "7xka0y.com1.z0.glb.clouddn.com" ||
				(domain_nosub === "mafengwo.net" && domain.match(/^[a-z][0-9]*(?:-[a-z])?\./)) ||
				(domain_nosub === "myqcloud.com" && domain.match(/image\.myqcloud\.com/)) ||
				domain === "ci.xiaohongshu.com" ||
				domain === "pic.qianye88.com" ||
				(domain_nosub === "yohobuy.com" && domain.match(/^img[a-z]*[0-9]*\.yohobuy\.com$/)) ||
				(domain_nosub === "715083.com" && domain.match(/^i-[0-9]*-yxdown\./)) ||
				(domain_nosub === "yxdown.com" && domain.match(/^i-[0-9]*\./)) ||
				(domain === "jkcdn.pajk.com.cn" && string_indexof(src, "/image/") >= 0) ||
				(domain_nosub === "hola.com" && string_indexof(src, "/imagenes/") >= 0) ||
				(domain === "static.leiphone.com" && string_indexof(src, "/uploads/") >= 0) ||
				domain === "static-movie.a.88cdn.com" ||
				(domain === "image.qianye88.com" && string_indexof(src, "/pic/") >= 0) ||
				domain === "pc.wangpan.xycdn.n0808.com" ||
				domain === "resource.meihua.info" ||
				domain === "i.ezbuy.sg" ||
				domain === "i.guancha.cn" ||
				domain === "pic.xcarimg.com" ||
				domain === "upload-images.jianshu.io" ||
				domain === "mz.eastday.com" ||
				domain === "s.isanook.com" ||
				domain_nosub === "fengimg.com") {
				src = src.replace(/\?.*$/, "");
			}
			if ((domain_nosub === "tradesy.com" && domain.match(/^item[0-9]*\.tradesy/) && string_indexof(src, "/images/") >= 0) ||
				(domain_nowww === "birminghamworld.uk" && /\/jpim-static\/+image\//.test(src)) ||
				(domain_nowww === "nationalworld.com" && /\/jpim-static\/+image\//.test(src)) ||
				(domain === "digitalcontent.api.tesco.com" && /\/v2\/+media\//.test(src)) ||
				(domain === "gitlab.winehq.org" && /\/uploads\/+/.test(src)) ||
				domain === "cdn.hfashionmall.com" ||
				(domain === "steamcommunity-a.akamaihd.net" && string_indexof(src, "/image/") >= 0) ||
				domain === "media-assets.grailed.com" ||
				(domain_nosub === "ztat.net" && /^img[0-9]*\./.test(domain))) {
				return {
					url: src.replace(/\?.*$/, ""),
					can_head: false
				};
			}
			if (domain === "img-static.tradesy.com") return src.replace(/:\/\/[^/]+\/+item\/+([0-9]+)\/+([^/]+)(-[0-9]+-[0-9]+)-[0-9]+-[0-9]+(\.[^/.?]+)(?:[?#].*)?$/, "://item4.tradesy.com/images/$2-$1$3$4");
			if (domain === "store-images.microsoft.com" ||
				domain === "store-images.s-microsoft.com") {
				return {
					url: src.replace(/\?.*$/, ""),
					head_wrong_contenttype: true
				};
			}
			if (domain_nowww === "dailyherald.com") {
				newsrc = src.replace(/[?&].*$/, "");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nosub === "billboard.com" && /static\./.test(domain)) {
				newsrc = src
					.replace(/(\/img\/+[0-9]{4}\/+[0-9]{2}\/+[^/]+-)240x240\./, "$1480x480.")
					.replace(/(\/img\/+[0-9]{4}\/+[0-9]{2}\/+[^/]+-)155x155\./, "$1240x240.");
				if (newsrc !== src)
					return newsrc;
			}
			if ((domain_nowww === "elindependiente.com" ||
				domain_nowww === "stadtlandmama.de" ||
				domain_nowww === "5min.at" ||
				domain_nowww === "fantasytopics.com") && /\/wp-content\/+uploads\//.test(src) ||
				(domain_nowww === "mmerevise.co.uk" && /\/app\/+uploads\//.test(src))) {
				return src
					.replace(/(\.[a-z]+)\.webp([?#].*)?$/, "$1$2")
					.replace(/-[0-9]+x[0-9]+(\.[^/.]+(?:[?#].*)?)$/, "$1");
			}
			if (domain_nowww === "collectivegen.com" && /\/wp-content\/+uploads\//.test(src)) {
				return src.replace(/-[0-9]+x[0-9]+(?:@[0-9]+x)?(\.[^/.]+(?:[?#].*)?)$/, "$1");
			}
			if (domain_nosub === "imimg.com" ||
				domain === "blogs-images.forbes.com" ||
				domain === "static.thesuperficial.com" ||
				domain === "static.celebuzz.com" ||
				domain === "img.vogue.co.kr" ||
				domain === "static.spin.com" ||
				domain_nowww === "zrockr.com" ||
				domain_nowww === "electricegg.co.uk" ||
				(domain_nowww === "iphone7wallpapers.co" && /\/media\/+uploads\//.test(src)) ||
				(domain_nowww === "androidhdwallpapers.com" && /\/media\/+uploads\//.test(src)) ||
				(domain_nosub === "hw-static.com" && domain.match(/www\.media[0-9]*\.hw-static\.com/)) ||
				(domain_nosub === "turner.com" && /^i[0-9]*\.cdn\./.test(domain)) ||
				domain_nowww === "k99.com" ||
				domain_nowww === "97rockonline.com" ||
				domain_nowww === "wfgr.com" ||
				domain_nowww === "wblk.com" ||
				domain_nowww === "fun107.com" ||
				domain_nowww === "965viki.com" ||
				domain_nowww === "1079ishot.com" ||
				domain === "edge.alluremedia.com.au" ||
				(amazon_container === "blogs-prod-media" && string_indexof(src, "/uploads/") >= 0) ||
				domain === "d36tnp772eyphs.cloudfront.net" ||
				domain === "img.allurekorea.com" ||
				domain_nowww === "psu.com" ||
				domain === "media.popculture.com" ||
				domain_nowww === "rap-up.com" ||
				(domain_nowww === "funweek.it" && string_indexof(src, "/uploads/") >= 0) ||
				(domain_nosub === "hankyung.com" && domain.match(/img\..*?\.hankyung\.com$/)) ||
				domain_nowww === "traveltipy.com" ||
				domain_nowww === "coveteur.com" ||
				amazon_container === "gaffa-prod" ||
				(domain_nosub === "ehow.com" && string_indexof(domain, ".blog.ehow.com") >= 0) ||
				(domain_nosub === "theheartysoul.com" && domain.match(/cdn[0-9]*\.theheartysoul\.com/)) ||
				domain_nowww === "bandt.com.au" ||
				(domain_nosub === "theepochtimes.com" && src.match(/\/assets\/+uploads\/+/)) ||
				(domain_nosub === "gamme.com.tw" && /^images[0-9]*\./.test(domain)) ||
				domain === "images.gamme.com.cn" ||
				domain === "cdn.hoahoctro.vn" ||
				domain === "vnn-imgs-f.vgcloud.vn" ||
				domain === "static.vibe.com" ||
				(domain_nowww === "rightsinfo.org" && string_indexof(src, "/uploads/") >= 0) ||
				(domain_nowww === "spotted.tv" && string_indexof(src, "/uploads/") >= 0) ||
				(domain_nowww === "tokyopopline.com" && string_indexof(src, "/images/") >= 0) ||
				domain === "px1img.getnews.jp" ||
				domain === "media.thetab.com" ||
				domain === "assets.rockpapershotgun.com" ||
				(domain_nosub === "vietnamnet.vn" && /^(?:[^/]*\.)?img(?:\.cdn[0-9]*|s)\./.test(domain)) ||
				domain === "sloanreview.mit.edu" ||
				(domain_nosub === "inquirer.net" && string_indexof(src, "/files/") >= 0) ||
				domain === "static.thefrisky.com" ||
				domain === "hobby.dengeki.com" ||
				domain === "cdn-blog.adafruit.com" ||
				(domain_nosub === "uuhy.com" && domain.match(/s?img\.uuhy\.com/)) ||
				domain === "img.butongshe.com" ||
				(domain_nowww === "myreco.asia" && string_indexof(src, "/uploads/") >= 0) ||
				(domain === "d3p157427w54jq.cloudfront.net" && string_indexof(src, "/uploads/") >= 0) ||
				domain === "cdn.harpersbazaar.com.sg" ||
				domain === "media.harpersbazaar.com.sg" ||
				domain_nosub === "myconfinedspace.com" ||
				amazon_container === "hiphopdx-production" ||
				domain === "assets.wonderlandmagazine.com" ||
				(domain_nosub === "akamaized.net" && domain.match(/^am[0-9]*\./) && /\/tms\/+cnt\/+uploads\//.test(src)) ||
				(domain_nosub === "pressassociation.io" && string_indexof(domain, "static.pressassociation.io") >= 0) ||
				domain === "assets.vg247.com" ||
				(domain_nowww === "theblemish.com" && string_indexof(src, "/images/") >= 0) ||
				(domain_nowww === "dailyxtra.com" && /\/content\/+uploads\//.test(src)) ||
				domain === "media.metrolatam.com" ||
				domain === "media.comicbook.com" ||
				domain_nowww === "grazia.it" ||
				domain === "img.kpopmap.com" ||
				domain === "s.nbst.gr" ||
				domain === "assets.metrolatam.com" ||
				domain_nosub === "mthai.com" ||
				domain === "cdn.webnoviny.sk" ||
				domain === "bloggar.expressen.se" ||
				(domain_nosub === "saostar.vn" && domain.match(/img[0-9]*\.saostar\.vn/)) ||
				(domain_nosub === "gossipcop.com" && domain.match(/s[0-9]*\.gossipcop\.com/)) ||
				(domain_nowww === "petapixel.com" && string_indexof(src, "/uploads/") >= 0) ||
				domain === "d3i6fh83elv35t.cloudfront.net" ||
				domain === "d17fnq9dkz9hgj.cloudfront.net" ||
				domain === "images.everyeye.it" ||
				googlestorage_container === "koreaboo-cdn" ||
				(domain_nowww === "behindzscene.net" && string_indexof(src, "/file/") >= 0) ||
				(domain_nowww === "hipertextual.com" && string_indexof(src, "/files/") >= 0) ||
				(domain_nowww === "geeksofdoom.com" && string_indexof(src, "/img/") >= 0) ||
				domain === "newsimages.fashionmodeldirectory.com" ||
				domain === "img.blogtamsu.vn" ||
				(domain_nosub === "starsdaily.net" && domain.match(/cdn[0-9]+\.starsdaily\.net/)) ||
				(domain_nowww === "nextnature.net" && string_indexof(src, "/uploads/") >= 0) ||
				(domain_nowww === "vooks.net" && string_indexof(src, "/img/") >= 0) ||
				domain === "i.ido.bi" ||
				domain === "cdn.techgyd.com" ||
				(domain_nowww === "4girls.co.il" && string_indexof(src, "/uploads/") >= 0) ||
				(domain_nowww === "gceleb.com" && string_indexof(src, "/photo/") >= 0) ||
				(domain_nowww === "seriouseats.com" && string_indexof(src, "/images/") >= 0) ||
				domain === "i.epochtimes.com" ||
				domain === "cdn.thammysen.vn" ||
				domain === "d1lofqbqbj927c.cloudfront.net" ||
				(domain_nowww === "180grados.com.mx" && string_indexof(src, "/img/") >= 0) ||
				domain === "photo.tin8.co" ||
				(domain_nosub === "whatculture.com" && domain.match(/^cdn[0-9]*\.whatculture\.com/) && string_indexof(src, "/images/") >= 0) ||
				(domain_nowww === "electronicbeats.net" && string_indexof(src, "/uploads/") >= 0) ||
				domain === "media.iconsingapore.com" ||
				domain === "p.cosmopolitan.bg" ||
				domain === "cache.pakistantoday.com.pk" ||
				domain === "media.breitbart.com" ||
				domain === "s.rozali.com" ||
				domain === "s.sdgcdn.com" ||
				(domain === "ticket.heraldtribune.com" && string_indexof(src, "/files/") >= 0) ||
				domain === "blog.hola.com" ||
				(domain_nowww === "therussiantimes.com" && string_indexof(src, "/uploads/") >= 0) ||
				domain === "static.idolator.com" ||
				domain === "images.saloona.co.il" ||
				(domain_nowww === "bellezaenvena.com" && string_indexof(src, "/my_uploads/") >= 0) ||
				(domain_nosub === "thejournal.ie" && string_indexof(src, "/media/") >= 0) ||
				domain_nowww === "tvperson.ru" ||
				domain_nowww === "iwantpix.com" ||
				domain_nowww === "nudemodelpics.com" ||
				(domain === "images.chr.bg" && string_indexof(src, "/uploads/") >= 0) ||
				(domain_nowww === "woman.ua" && string_indexof(src, "/file/images/") >= 0) ||
				domain === "gdsit.cdn-immedia.net" ||
				domain_nowww === "cseditors.com" ||
				(domain_nowww === "imcdn.org" && string_indexof(src, "/uploads/") >= 0) ||
				domain === "t.a4vn.com" ||
				domain_nowww === "dodskypict.com" ||
				domain === "files.dals.media" ||
				domain === "cdn.crhoy.net" ||
				domain_nowww === "longwallpapers.com" ||
				domain === "files.greatermedia.com" ||
				(domain_nowww === "tsundora.com" && string_indexof(src, "/image/") >= 0) ||
				(domain_nosub === "twitch.tv" && domain.match(/^clips-media-assets[0-9]*\./) && src.match(/-preview-[0-9]+x[0-9]+\.[^/.]*$/)) ||
				(domain === "file.immo.vlan.be" && string_indexof(src, "/Image/Wordpress/") >= 0) ||
				domain === "media.trud.bg" ||
				(domain_nowww === "rotativo.com.mx" && string_indexof(src, "/assets/") >= 0) ||
				(domain_nowww === "chfi.com" && string_indexof(src, "/wp-content/") >= 0) ||
				googlestorage_container === "sin-cdn" ||
				domain === "cdn.appleigeek.com" ||
				domain === "media.cnnchile.com" ||
				(domain_nowww === "festivalteen.com.br" && string_indexof(src, "/uploads/") >= 0) ||
				(amazon_container === "rhodiesworld" && string_indexof(src, "/uploads/") >= 0) ||
				(domain_nowww === "ntdtv.kr" && string_indexof(src, "/assets/") >= 0) ||
				domain === "xdn.tf.rs" ||
				domain === "static.acg12.com" ||
				domain === "img.zone5.ru" ||
				(domain_nosub === "bssl.es" && domain.match(/^i[0-9]*\./)) ||
				domain === "images.virgula.com.br" ||
				(domain_nowww === "rotana.net" && string_indexof(src, "/assets/uploads/") >= 0) ||
				(domain === "elle.unitedinfluencers.org" && string_indexof(src, "/content/uploads/") >= 0) ||
				(domain_nowww === "notredamedeparis.fr" && string_indexof(src, "/content/uploads/") >= 0) ||
				(domain === "zenska.hudo.com" && string_indexof(src, "/files/") >= 0) ||
				(amazon_container === "seenitblog" && string_indexof(src, "/uploads/") >= 0) ||
				(domain_nowww === "marieclaire.hu" && string_indexof(src, "/uploads/") >= 0) ||
				(domain_nowww === "infinitymemories.com" && string_indexof(src, "/files/") >= 0) ||
				(domain_nowww === "tuxboard.com" && string_indexof(src, "/photos/") >= 0) ||
				(domain_nosub === "mundotkm.com" && domain.match(/^arcdn[0-9]*\./)) ||
				(domain_nosub === "game4v.com" && domain.match(/^cdn[0-9]*\./)) ||
				(domain_nosub === "cosplaytime.pl" && string_indexof(src, "/uploads/") >= 0) ||
				domain === "img.wkorea.com" ||
				(domain === "i.mdel.net" && string_indexof(src, "/newfaces/i/") >= 0) ||
				domain === "media.celebmasta.com" ||
				domain === "media.korea25.com" ||
				(domain_nowww === "sexyfandom.com" && string_indexof(src, "/images/") >= 0) ||
				domain === "i.dmarge.com" ||
				domain === "assets.boundingintocomics.com" ||
				domain === "media.profootballfocus.com" ||
				(domain_nowww === "redu.pl" && string_indexof(src, "/img/") >= 0) ||
				(domain === "multifiles.pressherald.com" && string_indexof(src, "/uploads/") >= 0) ||
				domain === "img.time2draw.com" ||
				(domain === "ffw.uol.com.br" && string_indexof(src, "/app/uploads/") >= 0) ||
				domain === "images.harianjogja.com" ||
				domain === "images.hamodia.com" ||
				(domain_nowww === "bz-berlin.de" && string_indexof(src, "/data/uploads/multimedia/") >= 0) ||
				(domain_nowww === "luxury-inside.vn" && src.match(/\/data\/+uploads\//)) ||
				domain_nowww === "worldcupgirls.net" ||
				(domain_nosub === "playstationlifestyle.net" && domain.match(/^cdn[0-9]*-www\./) && string_indexof(src, "/assets/uploads/") >= 0) ||
				(domain_nosub === "aving.net" && domain.match(/^image[0-9]*\./)) ||
				domain === "ss-images.catscdn.vn" ||
				(domain === "blogs.gnome.org" && string_indexof(src, "/files/") >= 0) ||
				(domain_nosub === "zoomit.ir" && domain.match(/^cdn[0-9]*\./)) ||
				domain === "img.myfirstshow.com" ||
				(domain_nosub === "musicfeeds.com.au" && domain.match(/^cdn[0-9]*/) && string_indexof(src, "/assets/uploads/") >= 0) ||
				(domain === "d13vpcwfpcq1p8.cloudfront.net" && string_indexof(src, "/contents/") >= 0) ||
				(domain_nosub === "paperblog.fr" && domain.match(/^media[0-9]*\./)) ||
				(domain_nosub === "paperblog.com" && domain.match(/^m[0-9]*\./)) ||
				(domain === "bikini.sbgefree.org" && string_indexof(src, "/files/") >= 0) ||
				(domain_nowww === "redbust.com" && string_indexof(src, "/stuff/") >= 0) ||
				domain === "img.providr.com" ||
				domain === "static.hiphopdx.com" ||
				amazon_container === "queerty-prodweb" ||
				domain === "static.timesofisrael.com" ||
				(domain_nowww === "hairstylesweekly.com" && string_indexof(src, "/images/") >= 0) ||
				(domain_nowww === "famousbirthsdeaths.com" && string_indexof(src, "/fbd-uploads/") >= 0) ||
				domain === "img.leaksx.com" ||
				(domain_nowww === "top10films.co.uk" && string_indexof(src, "/img/") >= 0) ||
				domain_nowww === "hotel-aramis.com" ||
				(domain === "dvfmubv4tjrqd.cloudfront.net" && string_indexof(src, "/uploads/") >= 0) ||
				amazon_container === "assets.whatson.cityofsydney.nsw.gov.au" ||
				domain === "static.hasselblad.com" ||
				(domain_nowww === "saywho.fr" && string_indexof(src, "/app/uploads/") >= 0) ||
				(domain_nowww === "talentandpartner.com" && string_indexof(src, "/data/uploads/") >= 0) ||
				domain === "files.vividscreen.info" ||
				(amazon_container === "lilianpacce" && string_indexof(src, "/media/") >= 0) ||
				(amazon_container === "chl-network" && string_indexof(src, "/uploads/") >= 0) ||
				(domain_nowww === "starkbros.com" && string_indexof(src, "/images/dynamic/") >= 0) ||
				domain === "m.actve.net" ||
				(domain === "d279m997dpfwgl.cloudfront.net" && string_indexof(src, "/wp/") >= 0) ||
				(domain_nowww === "telegraf.com.ua" && string_indexof(src, "/files/") >= 0) ||
				domain === "media.womanista.com" ||
				(domain_nowww === "jenny.gr" && string_indexof(src, "/storage/photos/") >= 0) ||
				(domain === "static.infomusic.ro" && string_indexof(src, "/media/") >= 0) ||
				(domain_nowww === "csiete.net" && string_indexof(src, "/contenido/imagenes/") >= 0) ||
				(domain_nowww === "wallpaper4rest.com" && string_indexof(src, "/wallpaper/") >= 0) ||
				(domain_nowww === "ichip.ru" && string_indexof(src, "/blobimgs/uploads/") >= 0) ||
				(domain_nowww === "pophaircuts.com" && string_indexof(src, "/images/") >= 0) ||
				(domain_nowww === "she12.com" && string_indexof(src, "/uploads/") >= 0) ||
				(domain === "cdn.stylefrizz.com" && string_indexof(src, "/img/") >= 0) ||
				(domain_nosub === "windows7themes.net" && string_indexof(src, "/wp-content/files/") >= 0) ||
				(domain === "quotes.whyfame.com" && string_indexof(src, "/files/") >= 0) ||
				(domain_nosub === "mozilla.org" && src.match(/:\/\/[^/]*\/files\/+[0-9]{4}\/+[0-9]{2}\/+/)) ||
				(amazon_container === "pas-wordpress-media" && string_indexof(src, "/uploads/") >= 0) ||
				(domain === "news.artnet.com" && string_indexof(src, "/news-upload/") >= 0) ||
				(domain === "edmhunters-563e.kxcdn.com" && string_indexof(src, "/mediafiles/") >= 0) ||
				(amazon_container === "bkt-respaldomtonline" && string_indexof(src, "/uploads/") >= 0) ||
				domain === "img.emao.net" ||
				domain === "p.potv.bg" ||
				domain === "media.yadbegir.com" ||
				(domain_nosub === "llnwd.net" && src.match(/\/site\/+uploads\/+/)) ||
				(domain_nowww === "cinemio.it" && string_indexof(src, "/upload/") >= 0) ||
				(domain_nowww === "flavourmag.co.uk" && string_indexof(src, "/files/") >= 0) ||
				domain === "img.ananweb.jp" ||
				(domain_nowww === "filmz.dk" && string_indexof(src, "/files/") >= 0) ||
				domain_nowww === "mit24h.com" ||
				domain === "dimwhp0w2rs83.cloudfront.net" ||
				(domain === "cdn.macrumors.com" && string_indexof(src, "/article-new/") >= 0) ||
				(domain_nosub === "xcdnpro.com" && domain.match(/images\./)) ||
				(domain_nowww === "lifezette.com" && string_indexof(src, "/files/") >= 0) ||
				(domain === "cdn.junglecreations.com" && string_indexof(src, "/wp/") >= 0) ||
				(domain_nowww === "rip-youth.jp" && string_indexof(src, "/images/") >= 0) ||
				(domain_nowww === "asian-sirens.net" && string_indexof(src, "/uploads/") >= 0) ||
				(domain_nosub === "comingsoon.net" && src.match(/\/assets\/+uploads\//)) ||
				domain === "cdn.zoomg.ir" ||
				(domain_nowww === "wikiofthrones.com" && src.match(/\/static\/+uploads\//)) ||
				(domain_nowww === "hitc.com" && src.match(/\/static\/+uploads\//)) ||
				(domain === "files.theblemish.com" && string_indexof(src, "/images/") >= 0) ||
				(domain_nosub === "esmas.com" && domain.match(/^i[0-9]*\./)) ||
				(domain_nowww === "mortalfm.es" && string_indexof(src, "/archivos/") >= 0) ||
				(domain === "d2yoo3qu6vrk5d.cloudfront.net" && string_indexof(src, "/images/") >= 0) ||
				(domain_nowww === "courrier.jp" && string_indexof(src, "/media/") >= 0) ||
				(domain === "dieta.pourfemme.it" && string_indexof(src, "/img/") >= 0) ||
				(domain === "static.atmag.co.il" && string_indexof(src, "/uploads/") >= 0) ||
				(domain_nowww === "xtra.works" && string_indexof(src, "/uploads/") >= 0) ||
				(domain_nowww === "myce.com" && string_indexof(src, "/images_posts/") >= 0) ||
				(domain_nowww === "unison.org.uk" && string_indexof(src, "/content/uploads/") >= 0) ||
				(domain_nowww === "businessinsider.fr" && string_indexof(src, "/content/uploads/") >= 0) ||
				(digitalocean_container === "btrtoday" && string_indexof(src, "/uploads/") >= 0) ||
				domain === "m8q3v4v6.stackpathcdn.com" ||
				(domain_nowww === "linda.nl" && string_indexof(src, "/uploads/") >= 0) ||
				(domain === "ww1.sites-telechargement.com" && string_indexof(src, "/affiche/") >= 0) ||
				(domain === "d3n2u7gfnpd084.cloudfront.net" && src.match(/\/(?:[0-9a-f]{2}\/+){4}/)) ||
				(domain_nowww === "journal-farandole.com" && src.match(/\/content\/+uploads\/+/)) ||
				(domain_nowww === "dpstreaming.live" && string_indexof(src, "/upload/") >= 0) ||
				domain === "cdn.videos.rollcall.com" ||
				(domain_nowww === "rawkblog.com" && string_indexof(src, "/uploads/") >= 0) ||
				(domain === "cdn.stereo.vn" && string_indexof(src, "/uploads/") >= 0) ||
				(domain_nowww === "dailybruin.com" && string_indexof(src, "/images/") >= 0) ||
				domain_nowww === "razorpics.net" ||
				(domain_nowww === "1in.am" && string_indexof(src, "/assets/") >= 0) ||
				(domain === "cdn.entertainmentfuse.com" && string_indexof(src, "/media/") >= 0) ||
				(domain_nowww === "n3rdabl3.com" && /\/wp-content\/+images\/+uploads\/+/.test(src)) ||
				(domain_nowww === "kizsalsorunlar.com" && string_indexof(src, "/uploads/") >= 0) ||
				domain_nowww === "neskaties.lv" ||
				domain === "img.eroero-gazou.net" ||
				domain === "media.sistemampa.com.br" ||
				(domain_nosub === "looper.com" && /^img[0-9]*\./.test(domain) && string_indexof(src, "/uploads/") >= 0) ||
				(domain_nosub === "dtslb.com" && /^i[0-9]*\./.test(domain)) ||
				domain === "static.otvfoco.com.br" ||
				(domain_nosub === "diariouno.com.ar" && /^static[0-9]*\./.test(domain) && string_indexof(src, "/media/") >= 0) ||
				(domain_nowww === "thugarmada.com" && string_indexof(src, "/ta-files/") >= 0) ||
				(domain_nowww === "flipwallpapers.com" && string_indexof(src, "/wallpapers/") >= 0) ||
				(domain_nowww === "hanamaru-photo.com" && /\/common\/+images\//.test(src)) ||
				domain === "p.elle.bg" ||
				(domain_nowww === "illustrationwest.org" && string_indexof(src, "/files/") >= 0) ||
				(domain_nowww === "myjane.ru" && /\/data\/+cache\//.test(src)) ||
				(domain_nowww === "chickradar.net" && /\/content\/+uploads\//.test(src)) ||
				(domain_nowww === "creepmachine.com" && string_indexof(src, "/images/") >= 0) ||
				(domain_nowww === "theinspirationgrid.com" && /\/app\/+uploads\//.test(src)) ||
				(domain === "static-koimoi.akamaized.net" && string_indexof(src, "/new-galleries/") >= 0) ||
				(domain_nosub === "elperiodico.com" && /^img[0-9]*\./.test(domain)) ||
				domain_nosub === "cdn-immedia.net" ||
				(domain_nowww === "mmglobalmovies.com" && /\/wp-content\/+upload_folders\//.test(src)) ||
				(domain === "images.in.com" && string_indexof(src, "/uploads/") >= 0) ||
				domain === "staticuestudio.blob.core.windows.net" ||
				domain === "cdn.imvges.com" ||
				domain === "media.pamper.my" ||
				(domain_nowww === "rnbjunk.com" && string_indexof(src, "/foto/") >= 0) ||
				(domain === "cdn.xpicsxx.com" && string_indexof(src, "/uploads/") >= 0) ||
				(domain_nowww === "zokatv.net" && string_indexof(src, "/media/") >= 0) ||
				(domain_nowww === "magazin.lufthansa.com" && /\/content\/+uploads\//.test(src)) ||
				(domain_nowww === "nexofin.com" && string_indexof(src, "/archivos/") >= 0) ||
				domain === "gallery.southindianactress.in" ||
				(domain === "ffp4g1ylyit3jdyti1hqcvtb-wpengine.netdna-ssl.com" && /\/addons\/+files\//.test(src)) ||
				(domain === "medinaa.archolda.com" && string_indexof(src, "/ime/") >= 0) ||
				(domain_nowww === "londonsvenskar.com" && string_indexof(src, "/files/") >= 0) ||
				(domain === "ia.eferrit.com" && string_indexof(src, "/ia/") >= 0) ||
				(domain_nowww === "dokkaebi.tv" && string_indexof(src, "/file/") >= 0) ||
				(domain_nowww === "porncomix.one" && string_indexof(src, "/gallery/") >= 0) ||
				(domain_nowww === "porncomix.info" && string_indexof(src, "/images/") >= 0) ||
				(domain === "celebsfake.adultcase.com" && string_indexof(src, "/files/") >= 0) ||
				(domain_nowww === "theonemilano.com" && string_indexof(src, "/the-one-milano-uploads/") >= 0) ||
				domain === "public.flashingjungle.com" ||
				(domain === "static.pr.ricmais.com.br" && string_indexof(src, "/uploads/") >= 0) ||
				(domain_nowww === "smarthomebeginner.com" && string_indexof(src, "/images/") >= 0) ||
				(domain_nowww === "inspirationde.com" && string_indexof(src, "/media/") >= 0) ||
				domain === "cache.escapistmagazine.com" ||
				(domain_nowww === "stickboybkk.com" && string_indexof(src, "/images/") >= 0) ||
				(domain_nowww === "fitolsam.com" && string_indexof(src, "/uploads/") >= 0) ||
				(domain_nowww === "sevelina.ru" && /\/images\/+uploads\//.test(src)) ||
				(domain_nowww === "cdprojekt.com" && string_indexof(src, "/wp-content/") >= 0) ||
				(domain_nowww === "bilgimanya.com" && string_indexof(src, "/resimler/") >= 0) ||
				googlestorage_container === "unlimitedcnd.appspot.com" ||
				domain === "cdn.newlineporn.com" ||
				(domain === "galleries.xxxasianpussy.com" && /\/thumbs\//.test(src)) ||
				(domain_nowww === "okdiario.com" && string_indexof(src, "/img/") >= 0) ||
				(amazon_container === "static-spin-com" && string_indexof(src, "/files/") >= 0) ||
				(domain_nowww === "lapisrelights.com" && /\/assets\/+img\/+uploads\//.test(src)) ||
				((domain_nowww === "wbbjtv.com" ||
					domain_nowww === "channel3000.com" ||
					domain_nowww === "9and10news.com" ||
					(domain_nosub === "tn-cloud.net" && /^wpcdn\./.test(domain)) ||
					domain_nowww === "kxly.com") && /\/content\/+uploads\//.test(src)) ||
				(domain === "static.acgsoso.com" && string_indexof(src, "/uploads/") >= 0) ||
				(domain_nosub === "billboard.com" && /static\./.test(domain)) ||
				(domain === "images.fastcompany.net" && /\/wp-cms\/+uploads\//.test(src)) ||
				(domain_nowww === "gamerevolution.com" && /\/assets\/+uploads\//.test(src)) ||
				(domain_nowww === "inglam.ru" && /\/img\/+[0-9]{4}\/+/.test(src)) ||
				(domain === "media.spiked-online.com" && string_indexof(src, "/images/") >= 0) ||
				(domain_nowww === "unicef.ie" && /\/app\/+uploads\//.test(src)) ||
				domain === "cdn.downriversundaytimes.com" ||
				(domain === "media.hotpress.com" && string_indexof(src, "/uploads/") >= 0) ||
				domain === "images.thedigitalfix.com" ||
				domain === "d2r55xnwy6nx47.cloudfront.net" ||
				domain === "cdn.entameclip.com" ||
				(domain_nowww === "generalarcade.com" && /\/content\/+uploads\//.test(src)) ||
				(domain === "news.r18.com" && /\/assets\/+[0-9]{4}\/+[0-9]{2}\/+/.test(src)) ||
				(domain_nowww === "stylebook.de" && /\/data\/+uploads\//.test(src)) ||
				(domain === "cdn.kastatic.org" && string_indexof(src, "/images/") >= 0) ||
				(domain === "cdn.theathletic.com" && /\/app\/+uploads\//.test(src)) ||
				digitalocean_container === "cgaxisimages" ||
				(domain_nowww === "pockettactics.com" && /\/wp-content\//.test(src)) ||
				amazon_container === "ogden_images" ||
				(domain_nowww === "lapersonne.com" && /\/app\/+uploads\//.test(src)) ||
				(domain_nowww === "ipcc.ch" && /\/assets\/+uploads\//.test(src)) ||
				(domain === "lindenstaub.b-cdn.net" && /\/app\/+uploads\//.test(src)) ||
				(domain === "blogs.stlawu.edu" && string_indexof(src, "/files/") >= 0) ||
				domain === "static.nexilia.it" ||
				(domain_nowww === "fractal-design.com" && /\/app\/+uploads\//.test(src)) ||
				domain === "static.purple.fr" ||
				(domain_nowww === "voguehk.com" && /\/media\//.test(src)) ||
				domain === "cdn.anime-planet.com" ||
				(domain_nowww === "inglam.club" && /\/img\//.test(src)) ||
				(domain_nowww === "d23.com" && /\/app\/+uploads\//.test(src)) ||
				(domain_nosub === "sunderlandafc.news" && /^cdn[0-9]*\./.test(domain) && /\/uploads\//.test(src)) ||
				domain === "wp-assets.futurism.com") {
				src = src.replace(/-[0-9]+x[0-9]+\.([^/]*(?:[?#].*)?)$/, ".$1");
			}
			if ((domain === "store.pinseyun.com" && string_indexof(src, "/uploads/") >= 0) ||
				(domain === "s3.manualzz.com" && /\/store\/+data\//.test(src)) ||
				(domain === "media.coindesk.com" && string_indexof(src, "/uploads/") >= 0)) {
				return {
					url: src.replace(/-[0-9]*x[0-9]*\.([^/.]*)$/, ".$1"),
					can_head: false
				};
			}
			if (domain === "cdn.fashionmagazine.com") return src.replace(/(\/+wp-content\/+uploads\/+[0-9]{4}\/+[0-9]{2}\/+[^/]*)-[0-9]+x[0-9]+-c-[a-z]+(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain === "cdn.heatworld.com" ||
				domain_nowww === "sohobluesgallery.com" ||
				domain === "media.indiatimes.in" ||
				domain_nowww === "bangkokpost.com" ||
				(domain_nosub === "mensxp.com" && domain.match(/media[0-9]*\./) && string_indexof(src, "/media/") >= 0) ||
				domain === "221.132.38.109" ||
				(domain_nowww === "jpcoast.com" && string_indexof(src, "/img/") >= 0) ||
				domain === "pics.prcm.jp" ||
				(domain_nosub === "lprs1.fr" && domain.match(/s[0-9]*\.lprs1\.fr/)) ||
				domain === "m.wsj.net" ||
				domain === "img.lifestyler.co.kr" ||
				domain === "fototo.blox.pl" ||
				domain === "media.nvyouj.com" ||
				(domain === "cl.buscafs.com" && string_indexof(src, "/www.tomatazos.com/") >= 0) ||
				(domain === "tomatazos.buscafs.com" && string_indexof(src, "/uploads/images/") >= 0) ||
				(domain === "nisfeldunia.ahram.org.eg" && string_indexof(src, "/Media/") >= 0) ||
				domain === "d2t7cq5f1ua57i.cloudfront.net" ||
				domain === "socdn.smtown.com" ||
				(domain_nowww === "lecturas.com" && string_indexof(src, "/medio/") >= 0) ||
				(domain_nowww === "clara.es" && string_indexof(src, "/medio/") >= 0) ||
				domain === "images.anandtech.com" ||
				domain === "cdn.popbela.com" ||
				(domain_nosub === "lizhi.fm" && domain.match(/^cdnimg[0-9]*\./)) ||
				domain === "img.cf.47news.jp" ||
				domain === "static.filmin.es" ||
				(domain_nosub === "ropose.com" && domain.match(/^img[0-9]*\./)) ||
				domain === "resource.info.mn" ||
				(domain_nosub === "thegioitre.vn" && domain.match(/^image[0-9]*\./)) ||
				domain === "img.uduba.com" ||
				domain === "img.51ztzj.com" ||
				(domain === "mediaresources.idiva.com" && string_indexof(src, "/media/") >= 0) ||
				domain === "static.bangkokpost.com" ||
				((domain_nowww === "lepoint.fr" || domain === "static.lpnt.fr") && string_indexof(src, "/images/") >= 0) ||
				(domain_nosub === "sdpnoticias.com" && domain.match(/^i[0-9]*\./)) ||
				(domain === "s.thestreet.com" && string_indexof(src, "/files/") >= 0) ||
				(domain_nowww === "cosmopolitan.com.hk" && src.match(/\/storage\/+nodejs\/+(?:legacy\/+images|files)\//)) ||
				(domain_nosub === "bbwc.cn" && domain.match(/^s[0-9]*\.cdn\./)) ||
				(domain === "d4zcrs0v202ys.cloudfront.net" && string_indexof(src, "/images/") >= 0) ||
				(domain_nosub === "sornamag.com" && src.match(/\/files\/+images\//)) ||
				(domain === "arhiva.nacional.hr" && string_indexof(src, "/img/") >= 0) ||
				(domain === "img.myvideo.net.tw" && string_indexof(src, "/images/") >= 0) ||
				(domain === "image.apost.com" && string_indexof(src, "/media/") >= 0) ||
				(domain === "im.indiatimes.in" && string_indexof(src, "/content/") >= 0) ||
				(domain === "admin.alo.rs" && /\/resources\/+images\//.test(src)) ||
				(domain === "img.pcauto.com.cn" && /\/images\/+upload\//.test(src)) ||
				(domain === "cdn.sportrebel.pl" && string_indexof(src, "/photos/") >= 0) ||
				domain === "cdn.sweatband.com" ||
				domain === "images.cinefil.com" ||
				(domain_nowww === "palmaresadisq.ca" && string_indexof(src, "/uploads/") >= 0) ||
				domain === "image.b2bmilestone.com" ||
				domain === "music-bandlink.s3.yandex.net") {
				newsrc = src.replace(/_[0-9]+x[0-9]+(\.[^/.]*)$/, "$1");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nowww === "mediaonlinevn.com" ||
				(domain_nowww === "delas.pt" && string_indexof(src, "/files/") >= 0) ||
				(domain_nowww === "xda-developers.com" && string_indexof(src, "/files/") >= 0) ||
				domain_nowww === "onthemoveworld.com" ||
				/^[a-z]+:\/\/[^?]+\/wp(?:-content\/+(?:uploads|images|photos|blogs.dir)|\/+uploads)\/[^?]+-[0-9]+x[0-9]+(?:_c)?\./.test(src)
			) {
				newsrc = src.replace(/(?:-uai)?-[0-9]+x[0-9]+(?:_c)?(\.[^/.]*(?:\.webp)?)(?:[?#].*)?$/, "$1");
				if (newsrc !== src)
					return newsrc;
			}
			if (string_indexof(src, "/wp-content/uploads/") >= 0 ||
				string_indexof(src, "/wp/uploads/") >= 0) {
				src = src.replace(/\(pp_w[0-9]+_h[0-9]+\)(\.[^/.]*)$/, "$1");
			}
			if (
			string_indexof(src, "/wp-content/uploads/") >= 0 ||
				string_indexof(src, "/wp/uploads/") >= 0) {
				src = src.replace(/__[0-9]{2,}(\.[^/.]*)$/, "$1");
			}
			if (string_indexof(src, "/wp-content/uploads/") >= 0 ||
				string_indexof(src, "/wp/uploads/") >= 0) {
				src = src.replace(/-[0-9]+x[0-9]+-c-default(\.[^/.]*)$/, "$1");
			}
			if (domain === "pictures.ozy.com" ||
				domain_nowww === "retail-jeweller.com" ||
				domain === "d1nslcd7m2225b.cloudfront.net") {
				return src.replace(/(\/[Pp]ictures\/)[0-9any]+x[0-9any]+(?:[a-z]+)?\//, "$199999999x99999999/");
			}
			if (domain === "static.gofugyourself.com" ||
				(domain_nowww === "kencarson.xyz" && string_indexof(src, "/files/") >= 0) ||
				domain === "static.stereogum.com") {
				return src.replace(/-(?:[0-9]+x[0-9]+|compressed)(\.[^/.]*)(?:[?#].*)?$/, "$1");
			}
			if (domain === "hips.hearstapps.com") {
				newsrc = src.replace(/.*hips\.hearstapps\.com\/([^/]+\.[^/]+)/, "http://$1");
				if (newsrc !== src)
					return newsrc;
				return src.replace(/\?[^/]*$/, "");
			}
			if (domain === "img.wennermedia.com") return src.replace(/:\/\/img\.wennermedia\.com\/[^?#]*\/([^/]*)$/, "://img.wennermedia.com/$1");
			if (domain_nosub === "forbesimg.com" ||
				domain === "imageio.forbes.com") {
				return {
					url: src
						.replace(/(\/imageserve\/+[0-9a-f]{10,}\/+(?:[^/]+\/+)?)[0-9]+x[0-9]+(\.[^/.?#]+)$/, "$10x0$2")
						.replace(/(\/imageserve\/+[0-9a-f]{10,}\/+(?:[^/]+\/+)?[0-9]+x[0-9]+\.[^/.?#]+)(?:[?#].*)?$/, "$1"),
					head_wrong_contentlength: true
				};
				/*return {
					url: src.replace(/\/[0-9]*x[0-9]*\.([^/.?]*)(\?.*)?/, "/0x0.$1"),
					head_wrong_contentlength: true
				};*/
			}
			if (domain === "pixel.nymag.com") {
				return src
					.replace(/\/([^/.]*)(\.[^/]*)?\.([^/.]*)$/, "/$1.$3")
					.replace(/(\/slideshows\/.*\/[^/]*)\.[a-z](\.[^/.]*)\/[^/]*(?:[?#].*)?$/, "$1$2");
			}
			if (domain === "pyxis.nymag.com") return src.replace(/(\/v1\/+imgs\/+[0-9a-f]{3}\/+[0-9a-f]{3}\/+[0-9a-f]{10,}[^/.?#]*\.)(?:(?:r(?:deep-)?(?:square|horizontal|vertical|social)(?:-[a-z]+)?|[wh][0-9]+|[0-9]+x)\.){0,}([a-z]+)(?:[?#].*)?$/, "$1$2");
			if (domain === "assets.nydailynews.com" ||
				(domain_nosub === "nydailynews.com" && domain.match(/^static[0-9]*\./)) ||
				domain === "i.cbc.ca" ||
				domain === "cdn.newsday.com" ||
				domain_nowww === "stripes.com" ||
				domain_nowww === "irishtimes.com" ||
				domain_nowww === "ctvnews.ca" ||
				domain_nowww === "lancashirelife.co.uk" ||
				domain === "images.archant.co.uk" ||
				domain === "images.glaciermedia.ca" ||
				domain === "static.gulfnews.com" ||
				domain === "www.cp24.com" ||
				domain_nosub === "anandabazar.com" ||
				domain_nowww === "islingtongazette.co.uk" ||
				domain_nowww === "vrak.tv" ||
				domain === "images.haaretz.co.il" ||
				domain_nowww === "ltu.se" ||
				domain_nowww === "lanuovasardegna.it" ||
				domain_nowww === "huntspost.co.uk" ||
				domain == "rdsimages.cookieless.ca" ||
				domain_nowww === "edp24.co.uk") {
				newsrc = src
					.replace(/(\/[^/.]*\.[^_/.]*)_gen\/+derivatives\/+[^/]*\/+/, "/")
					.replace(/\/image\.[^_/]*_gen\/+derivatives\/+[^/]*\//, "/")
					.replace(/\/image\/+[^_/]*_gen\/+derivatives\/+[^/]*\//, "/image/");
				if (newsrc !== src) {
					return newsrc.replace(/\?.*/, "");
				}
			}
			if (domain === "static.gulfnews.com") {
				return {
					url: src,
					head_wrong_contenttype: true
				};
			}
			if (domain_nowww === "tsn.ca") {
				newsrc = src.replace(/(\/images\/+[0-9]{4}\/+(?:[0-9]{1,2}\/+){2}[^/]+)\/+jcr:.*/, "$1");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "www.tsn.ca") return src.replace(/(\/image\.[^_/]*_gen\/+derivatives\/+)[^/]*\//, "$1default/");
			if ((domain_nosub === "bbci.co.uk" ||
				domain_nosub === "bbc.co.uk") && domain.match(/^ichef(?:-[0-9]*)?\./)) {
				newsrc = src.replace(/\.jpg\.webp([?#].*)?$/, ".jpg$1");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/\/[0-9]+_[0-9]+\//, "/original/");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/(\.[^/.]*)\/[0-9]+$/, "$1/0");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/(:\/\/[^/]*)\/images\/ic\/[0-9n]+x[0-9n]+(?:_[a-z])?\//, "$1/images/ic/raw/");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/.*\.bbci\.co\.uk\/news\/[0-9]*\/(?:[^/]*\/)?media\//, "http://news.bbcimg.co.uk/media/");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/:\/\/[^/]*\/food\/ic\/[^/]*\//, "://food-images.files.bbci.co.uk/food/");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/\/images\/ic\/credit(\/[0-9]+x[0-9]+\/)/, "/images/ic$1");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/.*\/cpsprodpb\//, "https://c.files.bbci.co.uk/");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/news\/[0-9]+\/[^/]*\//, "https://c.files.bbci.co.uk/");
				if (newsrc !== src)
					return newsrc;
				/*var origsize = src.match(/\.bbci\.co\.uk\/[^/]*\/([0-9]*)\//);
				if (origsize && false) { // scales up
					var size = parseInt(origsize[1], 10);
					if (size < 2048) {
						return src.replace(/(\.bbci\.co\.uk\/[^/]*)\/[0-9]*\//, "$1/2048/");
					}
				}*/
			}
			if (domain === "ychef.files.bbci.co.uk") return src.replace(/(:\/\/[^/]+\/+)[0-9]+x[0-9]+\/+/, "$1original/");
			if (domain_nowww === "bbc.co.uk") {
				match = src.match(/\/rd\/+images\/+dynamic\/+([^/.]{50,})\/+/);
				if (match) {
					var decoded = base64_decode(match[1]);
					var parsed = JSON_parse(decoded);
					for (var i_1 = 0; i_1 < parsed.length; i_1++) {
						if (!parsed[i_1].length)
							continue;
						if (parsed[i_1][0] === "ff") {
							var internal_filename = parsed[i_1][1];
							if (string_indexof(internal_filename, "public/") === 0) {
								return "https://www.bbc.co.uk/" + internal_filename.substr(7);
							} else {
								break;
							}
						}
					}
					console_error("Unhandled URL", parsed);
				}
			}
			if (domain === "amp.thisisinsider.com" ||
				domain === "amp.insider.com" ||
				domain === "amp.businessinsider.com") {
				return src.replace(/^[a-z]+:\/\/amp\.([^/]*)\/images\/([a-f0-9]+)-[0-9]+(?:-[0-9]+)?(\.[^/.]*)$/, "https://static2.$1/image/$2/");
			}
			if ((domain_nosub === "businessinsider.com" ||
				domain_nosub === "insider.com" ||
				domain_nosub === "thisisinsider.com") &&
				domain.match(/^static[0-9]*\./)) {
				return src.replace(/(\/image\/[0-9a-f]+)(?:-[^/]*|\.[^/]*)?(?:\/.*)?$/, "$1/");
			}
			if (domain === "media.nbcwashington.com" ||
				domain === "media.nbcnewyork.com" ||
				domain === "media.graytvinc.com" ||
				domain === "media.telemundochicago.com" ||
				domain === "media.nbcdfw.com" ||
				domain === "media.nbcphiladelphia.com" ||
				domain === "media.nbcsandiego.com" ||
				domain === "media.heartlandtv.com" ||
				domain === "media.nbcmiami.com" ||
				domain === "media.nbcconnecticut.com" ||
				domain === "media.nbclosangeles.com" ||
				domain === "media.nbcboston.com" ||
				domain === "media.nbcbayarea.com" ||
				domain === "media.winnipegfreepress.com" ||
				domain === "media.brandonsun.com" ||
				domain === "media.necn.com" ||
				domain === "media.telemundoareadelabahia.com" ||
				domain === "media.nbcchicago.com") {
				return src.replace(/\/images\/+[0-9]+\*[0-9]+\//, "/images/");
			}
			if (domain_nowww === "bet.com") {
				return src
					.replace(/\/(_jcr_content.*?\/[^/]*)\.custom[0-9]+fx[0-9]+fx[0-9]+xcrop\.([^/]*)\//, "/$1.custom0fx0fx0xcrop.$2/")
					.replace(/\/(_jcr_content.*?\/[^/]*)\.custom[0-9]+x[0-9]+\.([^/]*)\//, "/$1.custom0fx0fx0xcrop.$2/")
					.replace(/\/(_jcr_content.*?\/[^/]*)\.featured[0-9]+x[0-9]+\.([^/]*)\//, "/$1.custom0fx0fx0xcrop.$2/")
					.replace(/\/(_jcr_content.*?\/[^/]*)\.featuredlist\.([^/]*)\//, "/$1.custom0fx0fx0xcrop.$2/")
					.replace(/\/(_jcr_content.*?\/[^/]*)\.ampheroimage\.([^/]*)\//, "/$1.custom0fx0fx0xcrop.$2/")
					.replace(/\/(_jcr_content.*?\/[^/]*)\.feedcontainer\.([^/]*)\//, "/$1.custom0fx0fx0xcrop.$2/")
					.replace(/\/(_jcr_content.*?\/[^/]*)\.[^/.]*\.([^/]*)\//, "/$1.custom0fx0fx0xcrop.$2/")
					.replace(/\/(_jcr_content.*?\/[^/]*)\.relatedinline[0-9]+x[0-9]+\.([^/]*)\//, "/$1.custom0fx0fx0xcrop.$2/");
			}
			if (domain_nosub === "cbsistatic.com" && /^gamefaqs[0-9]*\./.test(domain)) {
				newsrc = src.replace(/(:\/\/[^/]+\/+)screen\/+thumb\/+/, "$1screen/full/");
				if (newsrc !== src)
					return {
						url: newsrc,
						head_wrong_contentlength: true
					};
			}
			if (domain_nosub === "cbsistatic.com" && /cnet[0-9]*\./.test(domain)) {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]+\/+img\/+([^/]+=\/+)/, "/$1");
				if (newsrc !== src) {
					return urljoin("https://" + domain + "/img/", common_functions["get_thumbor_url"](newsrc), true);
				}
			}
			if (domain_nosub === "cbsistatic.com" ||
				domain_nosub === "cbsnewsstatic.com" ||
				domain === "cimg.tvgcdn.net") {
				newsrc = src
					.replace(/\/resize\/[0-9a-z]*x[0-9a-z]*\//, "/")
					.replace(/\/crop\/[^/]*\//, "/")
					.replace(/\/thumbnail\/[^/]*\//, "/");
				if (newsrc !== src) {
					return {
						url: newsrc,
						head_wrong_contentlength: true
					};
				}
			}
			if ((domain_nosub === "cbsstatic.com" &&
				domain.match(/wwwimage[0-9]*(?:-secure)?\.cbsstatic\.com/)) ||
				(domain_nosub === "pplusstatic.com" &&
					domain.match(/wwwimage[0-9]*(?:-(?:secure|us))?\.pplusstatic\.com/))) {
				return src
					.replace(/\/thumbnails\/([^/]*)\/[-a-z0-9:]*\//, "/thumbnails/$1/files/")
					.replace("/thumbnails/photos/files/", "/base/files/");
			}
			if (domain === "api.fidji.lefigaro.fr") {
				return src.replace("://api.fidji.lefigaro.fr/", "://i.f1g.fr/");
			}
			if (domain === "i.f1g.fr") {
				newsrc = src.replace(/.*i\.f1g\.fr\/media\/ext\/[^/]*\//, "http://");
				var newdomain = newsrc.replace(/^http:\/\/([^/]*)\/.*/, "$1");
				if (newsrc !== src &&
					newdomain !== "img.tvmag.lefigaro.fr")
					return newsrc;
				return src.replace(/\/media\/([a-z]*)\/[^/]*\//, "/media/$1/orig/");
			}
			if ((domain_nosub === "h-cdn.co" ||
				(domain_nosub === "cosmopolitan.nl" && domain.match(/h\.cdn\.cosmopolitan\./))) &&
				string_indexof(src, "/assets/") >= 0) {
				return src
					.replace(/\/[0-9]*x[0-9]*\//, "/")
					.replace(/\/(?:landscape|[a-z]+-aspect)[-_]((?:nrm_)?[0-9]{5,}[^/]*)(?:[?#].*)?$/, "/$1");
			}
			if (domain === "imgix.ranker.com") return src.replace(/\?.*$/, "?fm=png");
			if (domain_nosub === "rnkr-static.com" &&
				domain.match(/^img[0-9]*\./)) {
				return src.replace(/^[a-z]+:\/\/[^/]*\/+((?:user_)?node_img\/+[0-9]+\/+[0-9]+)\/+[^/]*\/+([^/]*)\.[^/.]*(?:[?#].*)?$/, "https://imgix.ranker.com/$1/original/$2?fm=png");
			}
			if (domain_nosub === "imgix.net") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]+\.imgix\.net\/(https?%3A[^?]+).*?$/, "$1");
				if (newsrc !== src)
					return decodeURIComponent(newsrc);
			}
			if (domain === "data.whicdn.com") {
				match = src.match(/^([a-z]+:\/\/[^/]+\/+images\/+([0-9]+)\/+)[^/.]*\.([^/.]*)$/);
				if (match) {
					return {
						url: match[1] + "original." + match[3],
						extra: {
							page: "https://weheartit.com/entry/" + match[2]
						}
					};
				}
			}
			if (domain_nosub === "whicdn.com" && domain.match(/^data[0-9]*\./)) {
				return src.replace(/:\/\/data[0-9]*\./, "://data.");
			}
			if (host_domain_nowww === "weheartit.com" && options.element) {
				if (domain === "assets.whicdn.com" && /\/assets\/+whi-[^/]+\/+entry_stub\/+entry_stub_unsafe-/.test(src)) {
					if (options.element.parentElement && options.element.parentElement.tagName === "A") {
						var href = options.element.parentElement.href;
						match = href.match(/\/entry\/+([0-9]+)\/*(?:[?#].*)?$/);
						if (match) {
							return "https://data.whicdn.com/images/" + match[1] + "/original.jpg";
						}
					}
				}
			}
			if (domain === "cdn.empireonline.com") return src.replace(/cdn\.empireonline\.com\/(?:jpg|png|gif)\/(?:[^/.]+\/){12}/, "cdn.empireonline.com/");
			if (domain_nosub === "celebmafia.com" ||
				domain_nosub === "hawtcelebs.com") {
				return src.replace(/\/([^/]*)_thumbnail\.([^/.]*)$/, "/$1.$2");
			}
			if ((domain_nosub === "pixhost.org" ||
				domain_nosub === "pixhost.to") &&
				domain.match(/^[a-z]*[0-9]*\./)) {
				return src
					.replace(/(:\/\/[^/]*\.)pixhost\.org\//, "$1pixhost.to/")
					.replace(/\/t([0-9]*\.pixhost\.[a-z]*)\/thumbs\//, "/img$1/images/");
			}
			if (domain_nosub === "ulximg.com" ||
				domain_nowww === "hotnewhiphop.com") {
				return src
					.replace(/\/image\/[0-9a-z]*x[0-9a-z]*\//, "/image/full/");
			}
			if (domain === "fm.cnbc.com") return src.replace(/\.[0-9]+x[0-9]+\.([^/.]*)$/, ".$1");
			if (domain === "images.bwwstatic.com" ||
				domain === "cloudimages.broadwayworld.com" ||
				domain === "newimages.bwwstatic.com") {
				return src
					.replace(/\/tn-[0-9]+_([^/]*)$/, "/$1")
					.replace(/\/(?:[0-9]+)?x(?:[0-9]*)(?:x[0-9]+)?([^/]*)\.pagespeed\.[^/]*(?:[?#].*)?$/, "/$1");
			}
			if (domain_nowww === "broadwayworld.com") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]+\/+ezoimgfmt\/+([^/]+\.[^/]+\/[^?#]+)(?:[?#].*)?$/, "$1");
				if (newsrc !== src)
					return add_http(newsrc);
			}
			if (common_functions["is_pinterest_domain"](domain)) {
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+pin\/+([0-9]+)\/*(?:[?#].*)?$/,
					query_for_id: "https://www.pinterest.com/pin/${id}/",
					process: function(done, resp, cache_key, website_match) {
						var match = resp.responseText.match(/<script id="initial-state" type="application\/json">({.*?})<\/script>/);
						if (!match) {
							console_error(cache_key, "Unable to find initial state for", resp);
							return done(null, false);
						}
						var initial_state = JSON_parse(match[1]);
						var id = website_match[1];
						var responses = initial_state.resourceResponses;
						var response = null;
						for (var i = 0; i < responses.length; i++) {
							if (responses[i].options.id !== id)
								continue;
							response = responses[i];
							break;
						}
						if (!response) {
							console_error(cache_key, "Unable to find response for id", id, " in", resp, initial_state);
							return done(null, false);
						}
						response = response.response.data;
						var urls = [];
						var baseobj = {
							extra: {
								page: resp.finalUrl
							}
						};
						if (response.title) {
							baseobj.extra.caption = response.title;
						}
						if (response.videos) {
							var videolist = [];
							var deduplicated_urls = {};
							for (var video_id in response.videos.video_list) {
								var video = response.videos.video_list[video_id];
								if (video.url in deduplicated_urls)
									continue;
								video.id = video_id;
								deduplicated_urls[video.url] = video;
								videolist.push(video);
							}
							videolist.sort(function(a, b) {
								var a_wh = a.width * a.height;
								var b_wh = b.width * b.height;
								if (a_wh !== b_wh) {
									return b_wh - a_wh;
								}
								var a_id = a.id.replace(/^V_/, "");
								var b_id = b.id.replace(/^V_/, "");
								var a_hls = string_indexof(a_id, "HLS") === 0;
								var b_hls = string_indexof(b_id, "HLS") === 0;
								if (a_hls) {
									if (b_hls) {
										return 0;
									} else {
										return -1;
									}
								} else {
									if (b_hls) {
										return 1;
									} else {
										return parseInt(b_id) - parseInt(a_id);
									}
								}
							});
							var videourls = [];
							for (var i = 0; i < videolist.length; i++) {
								var video = videolist[i];
								var video_hls = string_indexof(video.id, "V_HLS") === 0;
								videourls.push({
									url: video.url,
									video: video_hls ? "hls" : true
								});
							}
							array_extend(urls, videourls);
						}
						if (response.images) {
							urls.push(response.images.orig);
						}
						var obj = fillobj_urls(urls, baseobj);
						if (response.link) {
							obj.unshift({
								url: response.link,
								is_pagelink: true
							});
						}
						return done(obj, 6 * 60 * 60);
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (common_functions["is_pinterest_domain"](host_domain) && options.element) {
				var current = options.element;
				do {
					if (current.tagName === "A" && /^[a-z]+:\/\/[^/]+\/+pin\/+[0-9]{5,}/.test(current.href)) {
						return {
							url: current.href,
							is_pagelink: true
						};
					}
					if (current.tagName === "DIV" && current.getAttribute("data-test-id") === "pin-closeup-image") {
						var script = current.querySelector("script[type=\"application/ld+json\"]");
						if (!script)
							continue;
						try {
							var parsed = JSON_parse(script.innerHTML);
							if (parsed["@id"]) {
								return {
									url: parsed["@id"],
									is_pagelink: true
								};
							}
						} catch (e) {
							console_error(e);
						}
					}
				} while (current = current.parentElement);
			}
			if (domain === "i.pinimg.com" ||
				(domain_nosub === "pinimg.com" && domain.match(/^(?:i|(?:s-)?media-cache)-[^.]*\.pinimg/)) ||
				amazon_container === "media.pinterest.com") {
				src = src.replace(/[?#].*$/, "");
				if (src.match(/:\/\/[^/]*\/media\.pinterest\.com\//))
					newsrc = src.replace(/(:\/\/[^/]*\/media\.pinterest\.com\/)[^/]*(\/.*\/[^/]*\.[^/.]*)$/, "$1originals$2");
				else
					newsrc = src.replace(/(:\/\/[^/]*\/)[^/]*(\/.*\/[^/]*\.[^/.]*)$/, "$1originals$2");
				if (newsrc !== src) {
					return add_extensions_gif({
						url: newsrc,
						is_original: true
					});
				}
			}
			if (domain_nosub === "condecdn.net" && string_indexof(domain, "images.condecdn.net") >= 0) {
				obj = { url: src };
				match = src.match(/\/image\/+([a-zA-Z0-9]+)\//);
				if (match) {
					obj.filename = match[1];
				}
				newsrc = src.replace(/(\/image\/[^/]*\/).*/, "$1original/");
				if (newsrc !== src)
					obj.url = newsrc;
				return obj;
			}
			if (domain === "media.fromthegrapevine.com" ||
				(domain_nowww === "gretschpages.com" && string_indexof(src, "/media/img/") >= 0) ||
				(domain_nowww === "pornstars.me" && string_indexof(src, "/media/") >= 0) ||
				(domain === "jz.img0.cz" && string_indexof(src, "/media/") >= 0) ||
				domain_nowww === "mediavillage.com") {
				return src.replace(/\/([^/.]*\.[^/.]*)\.[^/.]*\.[^/.]*$/, "/$1");
			}
			if (domain_nosub === "acsta.net" && domain.search(/img[0-9]*\.acsta\.net/) >= 0) {
				newsrc = src.replace(/acsta\.net\/[^/]*\/pictures\//, "acsta.net/pictures/");
				if (newsrc !== src)
					return newsrc;
				return src.replace(/\/[rc]_[0-9]+_[0-9]+\//, "/");
			}
			if (domain === "em.wattpad.com") {
				return src.replace(/.*\.wattpad\.com\/[a-f0-9]*\/([a-f0-9]*).*/, "$1").replace(/([0-9A-Fa-f]{2})/g, function() {
					return string_fromcharcode(parseInt(arguments[1], 16));
				});
			}
			if (domain === "camo.githubusercontent.com") {
				match = src.match(/^[a-z]+:\/\/[^/]+\/+[0-9a-f]+\/+(68747470[0-9a-f]+)(?:[?#].*)?$/);
				if (match) {
					var hex = match[1];
					return hex.replace(/[0-9a-f]{2}/g, function(x) {
						return string_fromcharcode(parseInt(x, 16));
					});
				}
			}
			if (host_domain_nosub === "fandom.com" && options.element) {
				if (src.length < 10 && options.element.hasAttribute("data-src")) {
					return options.element.getAttribute("data-src");
				}
				if (options.element.hasAttribute("data-video-key") && options.do_request && options.cb) {
					var query_wikia_video = function(key, cb) {
						api_query("wikia:" + key, {
							url: urljoin(options.host_url, "/wikia.php?controller=Lightbox&method=getMediaDetail&fileTitle=" + key + "&format=json", true),
							headers: {
								"x-requested-with": "XMLHttpRequest"
							}
						}, cb, function(done, resp, cache_key) {
							try {
								var json = JSON_parse(resp.responseText);
								if (json.videoEmbedCode.provider === "youtube") {
									return done("https://i.ytimg.com/vi/" + json.videoEmbedCode.jsParams.videoId + "/mqdefault.jpg", 24 * 60 * 60);
								}
							} catch (e) {
								console_error(e);
							}
							return done(null, false);
						});
					};
					query_wikia_video(options.element.getAttribute("data-video-key"), options.cb);
					return {
						waiting: true
					};
				}
			}
			if (domain_nosub === "nocookie.net" &&
				domain.match(/^(?:vignette|static|img)[0-9]*\.wikia\./)) {
				obj = {
					url: src
				};
				match = src.match(/\/images\/+[0-9a-f]\/+[0-9a-f]{2}\/+([^/]+)\/+revision\//);
				if (match) {
					obj.filename = match[1];
				}
				newsrc = src.replace(/(:\/\/[^/]+\/+[-a-f0-9]{10,})\/+.*$/, "$1");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/(\/revision\/[^/?#]+\/*)(?:[?#].*)?$/, "$1?format=original");
				if (newsrc !== src) {
					obj.url = newsrc;
					return obj;
				}
				newsrc = src.replace(/(:\/\/[^/]+\/+)__cb[0-9]{5,}\/+/, "$1");
				if (newsrc !== src) {
					obj.url = newsrc;
					return obj;
				}
				newsrc = src
					.replace(/\/revision\/([^/]*)\/.*?(\?.*)?$/, "/revision/$1/$2")
					.replace(/^http:\/\//, "https://");
				if (newsrc !== src)
					obj.url = newsrc;
				return obj;
			}
			if (domain === "static.asiachan.com") {
				return src
					.replace(/(\/[^/]*\.)[0-9]*(\.[0-9]*\.[^/.]*$)/, "$1full$2")
					.replace(/(:\/\/[^/]*\/)[0-9]+(\/[0-9]+\/[0-9]+\/[0-9]+\.[^/.]*)$/, "$1full$2");
			}
			if (domain === "pic.xiami.net" ||
				domain === "club-img.kdslife.com" ||
				(domain_nosub === "meituan.net" && /^p[0-9]*\./.test(domain)) ||
				(domain === "piccn.ihuaben.com" && string_indexof(src, "/pic/") >= 0) ||
				(domain_nosub === "lanlanlife.com" && /^oss[0-9]*\./.test(domain)) ||
				domain === "img.zcool.cn" ||
				(domain_nosub === "hdslb.com" && /^i[0-9]*\./.test(domain)) ||
				domain === "album.biliimg.com" ||
				domain === "pic-bstarstatic.akamaized.net" ||
				domain === "img.sdxapp.com") {
				newsrc = src.replace(/(?:@|%40)[^/]*$/, "");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "oss.tan8.com") return src.replace(/(\/resource\/+attachment\/+[0-9]{4}\/+[0-9]{6}\/+[0-9a-f]{20,})_thumb(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain_nowww === "ultimate-guitar.com") return src.replace(/(\/images\/+(?:[0-9a-f]\/+){2}[0-9a-f]+\.[^/.]*?)@[0-9]+(?:[?#].*)?$/, "$1");
			if ((domain_nosub === "yinyuetai.com" && domain.match(/^img[0-9]*\.c\.yinyuetai\.com/)) ||
				(domain_nosub === "yytcdn.com" && domain.match(/^img[0-9]*\./))) {
				return src.replace(/[0-9]+x[0-9]+(\.[^/.]*)$/, "0x0$1");
			}
			if (domain.search(/mp[0-9]*\.qiyipic\.com/) >= 0 && string_indexof(src, "/passport/") < 0) {
				return src.replace(/[0-9]*_[0-9]*(\.[^/.]*)$/, "0_0$1");
			}
			if (domain_nosub === "duitang.com" || domain_nosub === "dtstatic.com") {
				return src
					.replace(/(\.[a-z]+)_webp(?:[?#].*)?$/, "$1")
					.replace(/(\/uploads\/+[^/]+\/+.*)\.thumb\.[0-9]+_[0-9]+(?:_c)?\./, "$1.");
			}
			if (domain_nosub === "vcimg.com" &&
				domain.match(/i-[0-9]\.vcimg.com/)) {
				return src.replace(/\/(?:crop|trim)\//, "/").replace(/(\/[0-9a-f]+)(?:\(|%28)[0-9]+x(?:[0-9]+)?(?:\)|%29)\//, "$1/");
			}
			if (domain_nosub === "zhimg.com" &&
				domain.match(/pic[0-9a-z]\.zhimg\.com/)) {
				return {
					url: src.replace(/\/((?:v[0-9]*-)?[0-9a-f]+)(?:_[^/._]*)?(\.[^/.]*)$/, "/$1_r$2"),
					headers: {
						Referer: ""
					},
					referer_ok: {
						same_domain: true
					}
				};
			}
			if (domain === "img.hb.aicdn.com" ||
				domain === "hbimg.huabanimg.com" ||
				domain === "gd-hbimg.huaban.com" ||
				domain_nosub === "upaiyun.com") {
				return {
					url: src.replace(/_[^/_]*$/, ""),
					headers: {
						Referer: ""
					}
				};
			}
			if (domain === "imagev2.xmcdn.com") {
				return src.replace(/![^/]*$/, "").replace(/(\/[^/]*?)(?:_[a-z_]+)?(\.[^/.]*)$/, "$1$2");
			}
			if ((domain_nosub === "bdimg.com" || domain_nosub === "baidu.com") &&
				(domain.match(/timg.*?\.bdimg\.com/) ||
					domain.match(/timg.*?\.baidu\.com/))) {
				newsrc = decodeURIComponent(src.replace(/.*\/[^/]*[?&]src=([^&]*).*/, "$1"));
				if (newsrc !== src)
					return newsrc;
			}
			if ((domain_nosub === "bdstatic.com" ||
				domain_nosub === "baidu.com") &&
				domain.match(/gss[0-9]*\./)) {
				if (string_indexof(src, "/timg?") >= 0) {
					return {
						url: decodeURIComponent(src.replace(/.*?\/timg.*?[?&]src=([^&]*).*/, "$1")),
						head_wrong_contenttype: true
					};
				}
				if (string_indexof(src, "/sign=") >= 0 ||
					string_indexof(src, "/pic/item/") >= 0) {
					return {
						url: src.replace(/:\/\/[^/]*\/[^/]*\//, "://imgsrc.baidu.com/"),
						head_wrong_contenttype: true
					};
				}
			}
			if (domain === "imgsrc.baidu.com" ||
				domain === "tiebapic.baidu.com" ||
				(domain_nosub === "baidu.com" && domain.match(/^(?:[a-z]\.)?hiphotos\./)) ||
				domain === "imgsa.baidu.com") {
				newsrc = decodeURIComponent(src.replace(/.*\/[^/]*[?&]src=([^&]*).*/, "$1"));
				if (newsrc !== src)
					return newsrc;
				newsrc = src
					.replace("/abpic/item/", "/pic/item/")
					.replace(/\/[^/]*(?:=|%3D)[^/]*\/sign=[^/]*\//, "/pic/item/");
				if (newsrc !== src)
					return {
						url: newsrc,
						head_wrong_contenttype: true
					};
				if (domain !== "imgsrc.baidu.com") {
					return remove_queries(src.replace(/:\/\/[^/]+\/+/, "://imgsrc.baidu.com/"), ["tbpicau"]);
				}
				return {
					url: newsrc,
					head_wrong_contenttype: true
				};
			}
			if (domain_nosub === "baidu.com" && string_indexof(domain, "himg.baidu.com") >= 0) {
				return src.replace(/\/sys\/[^/]*\/item\//, "/sys/original/item/");
			}
			if (domain_nosub === "baidu.com" && /^img[0-9]*\./.test(domain)) {
				if (/\/it\/+u=/.test(src)) {
					var fm = src.match(/[?&](fm=[0-9]+)(?:[&#].*)?$/);
					if (fm) {
						return src.replace(/[?&#].*/, "&" + fm[1]);
					}
				}
			}
			if (domain_nosub === "baidu.com" && /^pics[0-9]*\./.test(domain)) {
				return src.replace(/(\/feed\/+[0-9a-f]{5,}(?:\.[a-z]+)?)@.*/, "$1");
			}
			if (domain_nosub === "doubanio.com" &&
				domain.match(/^img[0-9]*\./)) {
				baseobj = {
					url: src,
					head_wrong_contentlength: true
				};
				newsrc = src.replace(/\/img\/+trailer\/+small\/+/, "/img/trailer/medium/");
				if (newsrc !== src) {
					baseobj.url = newsrc;
					return baseobj;
				}
				newsrc = src
					.replace(/\/[a-z]+(\/public\/[a-f0-9]+\.[^/.]*)$/, "/raw$1")
					.replace(/\/(?:small|medium)\//, "/large/")
					.replace(/\/[a-z]pic\//, "/opic/")
					.replace(/\/+img\/+([^/]*)\/+o\/+([0-9]+[^/]*)(?:[?#].*)?$/, "/view/$1/raw/public/p$2")
					.replace(/\/+img\/+([^/]*)\/+[^/]*\/+([0-9]+[^/]*)(?:[?#].*)?$/, "/img/$1/o/$2");
				if (newsrc !== src) {
					baseobj.url = newsrc;
					return baseobj;
				}
				newsrc = src.replace(/\/view\/+subject\/+[a-z]+\/+/, "/view/subject/raw/");
				if (newsrc !== src) {
					baseobj.url = newsrc;
					return baseobj;
				}
				if (src.match(/\/+view\/+([^/]*)\/+[^/]*\/+/)) {
					newsrc = src.replace(/(\/+view\/+[^/]+\/+[^/]+\/+.*?)\.webp(?:[?#].*)?$/, "$1.jpg");
					if (newsrc !== src) {
						baseobj.url = newsrc;
						return baseobj;
					}
					newsrc = src.replace(/(\/+view\/+[^/]+\/+)o\/+/, "$1raw/");
					if (newsrc !== src) {
						baseobj.url = newsrc;
						return baseobj;
					}
					if (!/\/view\/+[^/]+\/+raw\//.test(src)) {
						newsrc = src.replace(/(\/+view\/+[^/]+\/+)[^/]+\/+/, "$1o/");
						if (newsrc !== src) {
							baseobj.url = newsrc;
							return baseobj;
						}
					}
					newsrc = src.replace(/\/+view\/+([^/]*)\/+[^/]*\/+/, "/pview/$1/raw/");
					if (newsrc !== src) {
						return fillobj_urls(add_extensions(newsrc.replace(/\.webp(?:[?#].*)?$/, ".jpg")), baseobj);
					}
				}
				return baseobj;
			}
			if (domain === "img.idol001.com") {
				return src
					.replace(/(:\/\/[^/]*\/+)thumbnail\/+/, "$1origin/")
					.replace(/(\/[0-9a-f]+)_watermark(\.[^/.]*)$/, "$1$2");
			}
			if (domain === "star-img.idol001.com") return src.replace(/(\/images\/+[0-9]{4}\/+(?:[0-9]{1,2}\/+){2}[^/]+\.[^/.]+)\/+[^/]*(?:[?#].*)?$/, "$1");
			if (domain === "image-api.nrj.fr") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/(https?)\/([^/?&#]*).*?$/, "$1://$2");
				if (newsrc !== src)
					return decodeURIComponent(newsrc);
			}
			if (domain_nowww === "norwalkreflector.com" &&
				string_indexof(src, "/image/") >= 0) {
				return src.replace(/(\/image\/[0-9]*\/[0-9]*\/[0-9]*\/)[^/]*\/([^/]+)$/, "$1$2");
			}
			if (domain === "assets.bwbx.io") return src.replace(/\/[-0-9]*x[-0-9]*(\.[^/]*)$/, "/-1x-1$1");
			if (domain === "file.osen.co.kr") {
				newsrc = src.replace(/\/article_thumb\/+([0-9]{4}\/+[0-9]{2}\/+[0-9]{2}\/+[0-9]+(?:_[^/._]*)?)_[0-9]+x(?:[0-9]+)?(\.[^/.]*)(?:[?#].*)?$/, "/article/$1$2");
				if (newsrc !== src)
					return newsrc;
				return src
					.replace("/article_thumb/", "/article/")
					.replace(/\/article\/+([0-9]{4})\//, "/article/original/$1/")
					.replace(/_[0-9]+x(?:[0-9]+)?(\.[^/.]*)$/, "$1");
			}
			if (domain === "thumbnews.nateimg.co.kr") {
				return src.replace(/.*\/(?:view|m?news)[0-9]*\//, "");
			}
			if (domain === "thumb.pann.com") {
				return src.replace(/^[a-z]+:\/\/[^/]*\/[^/]*\//, "");
			}
			if (domain_nosub === "nate.com" && string_indexof(domain, ".video.nate.com") >= 0) {
				return src.replace(/\/img\/thumb\/[0-9]+[^/]*\//, "/img/");
			}
			if (domain === "newsimg.sedaily.com") {
				newsrc = src.replace(/(\/[0-9]{4}\/+(?:[0-9]{2}\/+){2}[^/_]+_[0-9]+)_[a-z](\.[^/.]*)(?:[?#].*)?$/, "$1$2");
				if (newsrc !== src)
					return newsrc;
				var extra = {};
				match = src.match(/\/[0-9]{4}\/+(?:[0-9]{2}\/+){2}([^/_]+)_[0-9]+(?:_[a-z])?\.[^/.]*(?:[?#].*)?$/);
				if (match) {
					extra.page = "https://www.sedaily.com/NewsView/" + match[1];
				}
				return {
					url: src,
					extra: extra
				};
			}
			if (domain === "stat.ameba.jp" ||
				domain === "stat.profile.ameba.jp") {
				return src.replace(/\/t[0-9]*_([^/]*)$/, "/o$1");
			}
			if (domain_nosub === "blogimg.jp" ||
				domain === "image.news.livedoor.com") {
				return src.replace(/(\/[^/.]*)-[sm](\.[^/.]*)/, "$1$2");
			}
			if (domain === "cdn.livedoor.jp") return src.replace(/(\/[0-9a-f]{10,}\.[^/.]+)\/+r\.[0-9]+x[0-9]+(?:[?#].*)?$/, "$1");
			if (domain === "image.cine21.com") {
				return src
					.replace("/resize/", "/")
					.replace(/\/(?:small|medium)(\/[^/]*)$/, "/large$1")
					.replace(/\?.*$/, "")
					.replace(/\[[WH][-0-9]*\](\.[^/.]*)$/, "$1")
					.replace(/\[[XF][0-9]+,[0-9]+\](\.[^/.]*)$/, "$1");
			}
			if (domain === "cdnimg.melon.co.kr" ||
				domain === "image.melon.co.kr" ||
				domain === "kakaoimg.melon.co.kr" ||
				domain === "cdnticket.melon.co.kr" ||
				domain === "cmtimg.melon.co.kr" /* &&
			(string_indexof(src, "/images/") >= 0 ||
			 string_indexof(src, "/image/") >= 0 ||
			 string_indexof(src, "/user_images/") >= 0)*/) {
				if (/\/resource\/+image\/+web\/+(?:artist|main)\/+/.test(src) ||
					/\/resource\/+image\/+(?:cmt\/+)?web\/+common\/+bg_(?:album_)?frame/.test(src)) {
					return {
						url: src,
						bad: "mask"
					};
				}
				newsrc = src.replace(/(\.[a-zA-Z]+)\/melon\/.*/, "$1");
				if (newsrc !== src)
					return newsrc;
				if (string_indexof(src, "/images/main/") >= 0) {
					newsrc = src.replace(/(images\/.*\/[^/_]*)((_[^/.]*)_)?(_?[^/._]*)?(\.[^/.?]*)(?:[?/].*)?$/, "$1$3$5");
				} else {
					newsrc = src.replace(/(images\/.*\/[^/_]*)((_[^/.]*)_)?(_?[^/._]*)?(\.[^/.?]*)(?:[?/].*)?$/, "$1$3_org$5");
				}
				if (newsrc !== src)
					return newsrc;
				match = src.match(/\/cm[0-9]*\/+mv\/+images\/+.*\/([0-9]+)_[0-9]+_(?:[0-9]+|org)\.[^/.]+(?:[?#].*)?$/);
				if (match) {
					return {
						url: "https://www.melon.com/video/player.htm?mvId=" + match[1],
						is_pagelink: true
					};
				}
			}
			if (domain === "cdnticket.melon.co.kr") {
				if (/\/resource\/+image\/+web\/+common\//.test(src)) {
					return {
						url: src,
						bad: "mask"
					};
				}
			}
			if (domain_nowww === "melon.com") {
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+video\/+(?:player|detail2)\.htm\?(?:.*&)?mvId=([0-9]+)/,
					run: function(cb, match) {
						var id = match[1];
						var cache_key = "melon_video:" + id;
						api_query(cache_key, {
							url: "https://www.melon.com/delivery/streamingInfo.json?contsId=" + id + "&contsType=VIDEO&bitrate=HD&stRight=N&_=" + Date.now(),
							imu_mode: "xhr",
							headers: {
								Referer: "https://www.melon.com/video/player.htm?mvId=" + id,
								"X-Requested-With": "XMLHttpRequest",
								"Content-Type": "application/json",
								"Accept": "application/json, text/javascript, */*; q=0.01"
							},
							json: true
						}, cb, function(done, resp, cache_key) {
							var videourl = resp.streamingInfo.encUrl;
							if (!videourl) {
								console_error(cache_key, "Unable to find video url in", resp);
								return done(null, false);
							}
							if (!/\.m3u8\?/.test(videourl)) {
								console_error(cache_key, "Unknown video url type", { videourl: videourl, json: resp });
								return done(null, false);
							}
							videourl = force_https(videourl);
							return done({
								url: videourl,
								video: "hls"
							}, 60 * 60);
						});
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain_nosub === "mzstatic.com" && domain.match(/is[0-9](-ssl)?\.mzstatic\.com/) &&
				string_indexof(src, "/image/thumb/") >= 0) {
				obj = {
					can_head: false // GET can return 502, but HEAD is ok
				};
				match = src.match(/\/([-0-9a-f]{20,}(?:_[^/]+)?)\/+source\/+[^/]+(?:[?#].*)?$/);
				if (!match)
					match = src.match(/\/[-0-9a-f]{20,}\/+([^/]+)\.[^/.]+\/+[^/]+(?:[?#].*)?$/);
				if (match)
					obj.filename = match[1];
				obj.url = src.replace(/\/[0-9]*x[0-9]*[a-z]*(?:-[0-9]+)?(\.[^/.]*)$/, "/999999999x0w-999$1");
				if (obj.url !== src)
					return obj;
				obj.url = src.replace(/(_file)_cropped(\.[a-z]+\/+999999999x0w[^/]+)$/, "$1$2");
				if (obj.url !== src)
					return obj;
				if (/\.png(?:[?#].*)?$/i.test(obj.url)) {
					match = src.match(/image\/+thumb\/+(.*?\/+(?:[a-f0-9]{2}\/+){3}(?:[-0-9a-f]{20,}\/)?[^/]+)\//);
					if (match) {
						obj.url = "https://a1.mzstatic.com/us/r1000/063/" + match[1];
						return obj;
					}
				}
				return fillobj_urls(add_full_extensions(obj.url, ["png", "jpg"], true), obj);
			}
			if (domain_nosub === "mzstatic.com" && /^[as][0-9]+\./.test(domain)) {
				return src.replace(/(\/v4\/+(?:[a-f0-9]{2}\/+){3}[-0-9a-f]{20,}\/+)[^/]+(?:[?#].*)?$/, "$1source");
			}
			if (domain === "images.moviesrankings.com") return src.replace(/^[a-z]+:\/\/[^/]+\/+/, "https://is3-ssl.mzstatic.com/");
			if (domain === "img-tmdetail.alicdn.com") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]+\/+bao\/+uploaded\/+([^/]+\.[^/]+\/+)/, "$1");
				if (newsrc !== src)
					return add_http(newsrc);
			}
			if (domain_nosub === "alicdn.com" ||
				domain_nosub === "aliexpress-media.com") {
				return src
					.replace(/\.[0-9]+x[0-9]+(\.[^/.]*)(?:[?#].*)?$/, "$1")
					.replace(/(\.[^/._?#]+)_(?:[0-9z]+x[0-9z]+(?:x[0-9z]+)?)?(?:[qQ][0-9]+)?\.[^/.]+$/, "$1")
					.replace(/(\.[^/._?#]+)_\.webp(?:[?#].*)?$/, "$1")
					.replace(/\?.*/, "");
			}
			if (domain_nosub === "1818lao.com" &&
				domain.match(/^i[0-9]*\./)) {
				return src.replace(/:\/\/[^/]*\/aliexpress[0-9]*(\/kf\/)/, "://ae01.alicdn.com$1");
			}
			if (domain === "lastfm-img2.akamaized.net" ||
				domain === "lastfm.freetls.fastly.net" ||
				domain_nosub === "lst.fm") {
				return src.replace(/\/i\/+u\/+(?:avatar)?(?:[0-9]+x[0-9]+|[0-9]+s|ar(?:X?L|[0-9]))\//, "/i/u/");
			}
			if (domain_nosub === "myspacecdn.com" &&
				domain.match(/a[0-9](?:\...)?-images\.myspacecdn\.com/)) {
				return src.replace(/\/[^/.]*(\.[^/.]*)$/, "/full$1");
			}
			if (domain === "geo-media.beatport.com") {
				return {
					url: src.replace(/\/image_size\/+[0-9]*x[0-9]*\//, "/image_size/0x0/"),
					can_head: false // 400
				};
			}
			if (domain_nosub === "tumblr.com" &&
				string_indexof(domain, "media.tumblr.com") >= 0) {
				obj = {
					headers: {
						"Accept": "*/*" // otherwise it can return an HTML
					},
					problems: {
						possibly_broken: false
					}
				};
				if (false && src.match(/_[0-9]*\.gif$/)) {
					obj.problems.possibly_broken = true;
				}
				newsrc = src
					.replace(/\.pnj(\?.*)?$/, ".png$1")
					.replace(/\.gifv(\?.*)?$/, ".gif$1");
				if (newsrc !== src) {
					obj.url = newsrc;
					return obj;
				}
				if (src.match(/\/avatar_[0-9a-f]+_(?:16|64|128)\./))
					return src.replace(/_[0-9]+(\.[^/.]*)(?:[?#].*)?$/, "_512$1");
				newsrc = src.replace(/(\/(?:tumblr(?:_(?:static|inline))?_)?[0-9a-zA-Z]+(?:_og)?(?:_r[0-9]*)?)_[0-9]+(?:sq)?(\.[^/.]*)$/, "$1_1280$2");
				if (newsrc !== src) {
					obj.url = newsrc;
					return obj;
				}
				newsrc = src.replace(/^[a-z]+:\/\/[^/]+\/+(?:previews\/+)?(tumblr_[^/_.]+)_(?:filmstrip|(?:frame|smart)1)\.jpg(?:[?#].*)?$/, "https://ve.media.tumblr.com/$1.mp4");
				if (newsrc !== src) {
					obj.url = newsrc;
					return obj;
				}
				if (false) {
					newsrc = src.replace(/^[a-z]+:\/\/[0-9]+\.media\./, "https://media.");
					if (newsrc !== src) {
						obj.url = newsrc;
						return obj;
					}
				}
				if (options.do_request && options.cb && /:\/\/[^/]+\/+[0-9a-f]{32}\/+[0-9a-f]{16}-[0-9a-f]{2}\/+s[0-9]+x[0-9]+u?(?:_[fc][0-9]+)?\/+[0-9a-f]{20,}\./.test(src)) {
					var get_initialstate_from_text = function(text) {
						var match = text.match(/window\['___INITIAL_STATE___'\]\s*=\s*({.*?"ImageUrlPage":.*?})\s*;\s*(?:<\/script>[\s\S]*)?$/);
						if (!match) {
							match = text.match(/___INITIAL_STATE___">\s*({.*?})\s*<\/script/);
						}
						if (match) {
							var json = match[1].replace(/(\"\s*:)\s*(?:\/.*?\/|undefined|new RegExp\(.*?\))\s*([,}])/g, "$1null$2");
							try {
								var parsed = JSON_parse(json);
								return parsed;
							} catch (e) {
								console_error(e, {
									match: match,
									text: text,
									json: json
								});
							}
							return null;
						}
						return null;
					};
					var url_to_tumblr_imageinfo = function(url) {
						var match = url.match(/:\/\/[^/]+\/+([0-9a-f]{32})\/+([0-9a-f]{16}-[0-9a-f]{2})\/+s([0-9]+)x([0-9]+)u?(?:_[a-z][0-9]+)?\/+[0-9a-f]{20,}\.([^/.?#]+)(?:[?#].*)?$/);
						if (match) {
							return {
								mediaKey: match[1] + ":" + match[2],
								url: url,
								width: match[3],
								height: match[4]
							};
						} else {
							return null;
						}
					};
					var query_tumblr_original = function(url, cb) {
						url = url
							.replace(/\/s[0-9]+x[0-9]+u?(?:_c[0-9]+)?\/+([0-9a-f]{20,}\.)/, "/s999999999x999999999/$1")
							.replace(/:\/\/media\./, "://66.media.");
						var cache_key = "tumblr_image_page:" + url;
						api_cache.fetch(cache_key, cb, function(done) {
							options.do_request({
								url: url,
								headers: {
									Referer: "",
									"sec-fetch-mode": "navigate",
									"sec-fetch-dest": "document",
									"sec-fetch-site": "none",
									"if-none-match": "",
									"accept": "text/html" // This appears to be the important line
								},
								method: "GET",
								onload: function(resp) {
									if (resp.status !== 200) {
										console_error(cache_key, resp);
										return done(null, false);
									}
									var initialstate = get_initialstate_from_text(resp.responseText);
									if (!initialstate) {
										console_warn(cache_key, "Unable to get initial state from", resp);
										return done(null, false);
									}
									try {
										var imageresponse_raw = deepcopy(initialstate.ImageUrlPage.photo.imageResponse);
										var imageresponse = [];
										for (var i = 0; i < imageresponse_raw.length; i++) {
											if (!imageresponse_raw[i])
												continue;
											imageresponse.push(imageresponse_raw[i]);
										}
										var request_imageinfo;
										if (initialstate.ImageUrlPage.requestedImage) {
											request_imageinfo = url_to_tumblr_imageinfo(initialstate.ImageUrlPage.requestedImage);
											if (request_imageinfo)
												imageresponse.push(request_imageinfo);
										}
										var page = null;
										if (initialstate.ImageUrlPage.post) {
											page = initialstate.ImageUrlPage.post.postUrl;
										}
										return done({
											images: imageresponse,
											page: page
										});
									} catch (e) {
										console_error(e, initialstate);
									}
									return done(null, false);
								}
							});
						});
					};
					var find_largest_from_media = function(media) {
						var pixels = 0;
						var obj = null;
						for (var i = 0; i < media.length; i++) {
							var ourobj = media[i];
							var ourpixels = ourobj.width * ourobj.height;
							if (ourpixels > pixels) {
								obj = ourobj;
								pixels = ourpixels;
							}
						}
						return obj;
					};
					var get_obj_from_imageinfo = function(imageinfo) {
						var largest = find_largest_from_media(imageinfo.images);
						if (!largest)
							return;
						var obj = {
							url: largest.url, //.replace(/^[a-z]+:\/\/[0-9]+\.media\./, "https://media."),
							headers: {
								"Accept": "*/*" // otherwise it can return an HTML
							},
							is_original: largest.hasOriginalDimensions
						};
						if (imageinfo.page) {
							obj.extra = { page: imageinfo.page };
						}
						return obj;
					};
					query_tumblr_original(src, function(imageinfo) {
						if (!imageinfo) {
							return options.cb(null);
						}
						var newobj = get_obj_from_imageinfo(imageinfo);
						newobj = fillobj(newobj, obj);
						return options.cb(newobj);
					});
					return {
						waiting: true
					};
				}
			}
			if (domain_nosub === "tumblr.com" && /media\.tumblr\.com$/.test(domain) && options && options.element &&
				options.do_request && options.cb) {
				var apikey = null;
				if (options.rule_specific && options.rule_specific.tumblr_api_key)
					apikey = options.rule_specific.tumblr_api_key;
				var get_initialstate_from_text = function(text) {
					var match = text.match(/window\['___INITIAL_STATE___'\]\s*=\s*({.*?"tumblelog":.*?})\s*;\s*(?:<\/script>[\s\S]*)?$/);
					if (match) {
						var json = match[1].replace(/(\"\s*:)\s*\/.*?\/\s*([,}])/g, "$1null$2");
						try {
							var parsed = JSON_parse(json);
							return parsed;
						} catch (e) {
							console_error(e);
						}
						return null;
					}
					return null;
				};
				var get_initialstate = function() {
					var scripts = document.getElementsByTagName("script");
					for (var i = 0; i < scripts.length; i++) {
						var text = scripts[i].innerText;
						if (text.length < 100)
							continue;
						var initialstate = get_initialstate_from_text(text);
						if (initialstate)
							return initialstate;
					}
					return null;
				};
				var get_apikey_from_initialstate = function(initialstate) {
					if (initialstate && initialstate.apiFetchStore && "API_TOKEN" in initialstate.apiFetchStore) {
						return initialstate.apiFetchStore.API_TOKEN;
					}
					return null;
				};
				var initialstate = get_initialstate();
				var initialstate_api_key = get_apikey_from_initialstate(initialstate);
				var get_beta_api_key = function(cb) {
					api_cache.fetch("tumblr_api_key", cb, function(done) {
						if (initialstate_api_key) {
							return done(initialstate_api_key, 24 * 60 * 60);
						}
						options.do_request({
							method: "GET",
							url: "https://support.tumblr.com/archive",
							headers: {
								Referer: ""
							},
							onload: function(resp) {
								if (resp.readyState !== 4)
									return;
								if (resp.status !== 200) {
									console_error(resp);
									return done(null, false);
								}
								var initialstate = get_initialstate_from_text(resp.responseText);
								if (initialstate) {
									var apikey = get_apikey_from_initialstate(initialstate);
									if (apikey) {
										return done(apikey, 24 * 60 * 60);
									}
								}
								return done(null, false);
							}
						});
					});
				};
				var do_tumblr_api_call = function(path, params, cb) {
					var request_obj = {
						url: "https://api.tumblr.com/v2" + path + "?api_key=" + apikey + "&" + params,
						method: "GET",
						onload: function(resp) {
							if (resp.readyState !== 4)
								return;
							if (resp.status !== 200) {
								console_error(resp);
								return cb(null);
							}
							return cb(resp.responseText);
						}
					};
					if (!apikey) {
						get_beta_api_key(function(apikey) {
							request_obj.headers = {
								"Authorization": "Bearer " + apikey,
								"X-Version": "redpop/3/0//redpop/"
							};
							request_obj.url = request_obj.url.replace(/\?api_key=.*?&/, "?");
							options.do_request(request_obj);
						});
					} else {
						options.do_request(request_obj);
					}
				};
				var get_post_api = function(blogname, postid, cb) {
					var cache_key = "tumblr_api_blog:" + blogname + ":post:" + postid;
					api_cache.fetch(cache_key, cb, function(done) {
						do_tumblr_api_call("/blog/" + blogname + "/posts", "id=" + postid + "&npf=true", function(data) {
							if (!data) {
								return done(null, false);
							}
							try {
								var json = JSON_parse(data);
								var post = json.response.posts[0];
								var content = post.content;
								if (post.trail) {
									for (var i = 0; i < post.trail.length; i++) {
										array_extend(content, post.trail[i].content);
									}
								}
								return done(content, 6 * 60 * 60);
							} catch (e) {
								console_error(e, data);
								return done(null, false);
							}
						});
					});
				};
				var get_post_http = function(blogname, postid, cb) {
					var cache_key = "tumblr_blog_image:" + blogname + ":post:" + postid;
					api_cache.fetch(cache_key, cb, function(done) {
						options.do_request({
							url: "https://" + blogname + ".tumblr.com/image/" + postid + "/",
							method: "GET",
							onload: function(resp) {
								if (resp.readyState !== 4)
									return;
								if (resp.status !== 200) {
									console_error(resp);
									return done(null, false);
								}
								var match = resp.responseText.match(/window\['___INITIAL_STATE___'\]\s*=\s*({.*?});\s*<\/script>/);
								if (!match) {
									console_warn("Unable to find match", resp);
									return done(null, false);
								}
								var jsontxt = match[1].replace(/,\"[^"]+?\":\/.*?,\"/, ",\"");
								try {
									var json = JSON_parse(jsontxt);
									var imageresponse = json.ImagePage.photo.imageResponse;
									var firstimage = { media: [] };
									for (var i = 0; i < imageresponse.length; i++) {
										imageresponse[i].media_key = imageresponse[i].mediaKey;
										imageresponse[i].has_original_dimensions = imageresponse[i].hasOriginalDimensions;
										firstimage.media.push(imageresponse[i]);
									}
									return done([firstimage], 6 * 60 * 60);
								} catch (e) {
									console_error(e);
									return done(null, false);
								}
							}
						});
					});
				};
				var get_post = function(blogname, postid, cb) {
					if (apikey || initialstate_api_key) {
						return get_post_api(blogname, postid, cb);
					} else {
						get_beta_api_key(function(apikey) {
							if (apikey) {
								return get_post_api(blogname, postid, cb);
							} else {
								return get_post_http(blogname, postid, cb);
							}
						});
					}
				};
				var find_largest_from_media = function(media) {
					var pixels = 0;
					var obj = null;
					for (var i = 0; i < media.length; i++) {
						var ourobj = media[i];
						var ourpixels = ourobj.width * ourobj.height;
						if (ourpixels > pixels) {
							obj = ourobj;
							pixels = ourpixels;
						}
					}
					return obj;
				};
				var find_mediakey_from_url = function(url) {
					var match = url.match(/^[a-z]+:\/\/[^/]+\/+([0-9a-f]{32})\/+([0-9a-f]{16}-[0-9a-f]{2})\/+/);
					if (match) {
						return match[1] + ":" + match[2];
					}
					return null;
				};
				var find_media_from_post_mediakey = function(post, mediakey) {
					for (var i = 0; i < post.length; i++) {
						if (!post[i].media)
							continue;
						if (post[i].media[0].media_key === mediakey) {
							return post[i].media;
						}
					}
					return null;
				};
				var find_blogname_from_url = function(url) {
					match = url.match(/^[a-z]+:\/\/([^/.]+)\.tumblr\.com\//);
					if (match) {
						if (match[1] !== "www" && match[1] !== "support")
							return match[1];
					}
					return null;
				};
				var find_blogname_id_from_url = function(url) {
					match = url.match(/^[a-z]+:\/\/([^/.]+)\.tumblr\.com\/+post\/+([0-9]+)\//);
					if (match) {
						return {
							blogname: match[1],
							postid: match[2]
						};
					}
					return null;
				};
				var find_blogname_from_head = function() {
					if (!options.document)
						return null;
					var links = options.document.getElementsByTagName("link");
					for (var i = 0; i < links.length; i++) {
						var href = links[i].href;
						if (!href)
							continue;
						var match = href.match(/^android-app:\/\/com\.tumblr\/tumblr\/x-callback-url\/blog\?blogName=(.*?)(?:[&%].*)?$/);
						if (match) {
							return match[1];
						}
					}
					return null;
				};
				var find_blogname_from_initialstate = function() {
					if (initialstate && "tumblelog" in initialstate && "name" in initialstate.tumblelog) {
						return initialstate.tumblelog.name;
					}
					return null;
				};
				var find_postid_from_el = function(el) {
					var currentel = el;
					while ((currentel = currentel.parentElement)) {
						if (currentel.tagName === "ARTICLE" && currentel.hasAttribute("data-id")) {
							var id = currentel.getAttribute("data-id");
							if (/^[0-9]+$/.test(id)) {
								return id;
							}
						}
						var id = currentel.getAttribute("id");
						if (id) {
							var match = id.match(/^photoset_([0-9]+)$/);
							if (match) {
								return match[1];
							}
							if (currentel.tagName === "ARTICLE") {
								return id;
							}
						}
						if (currentel.tagName === "A") {
							var match = currentel.href.match(/:\/\/[^/]+\/+image\/+([0-9]{8,})\/*(?:[?#].*)?$/);
							if (match) {
								return match[1];
							}
						}
						if (currentel.tagName === "FIGURE") {
							try {
								var as = currentel.parentElement.parentElement.getElementsByTagName("a");
								for (var i = 0; i < as.length; i++) {
									var match = as[i].href.match(/:\/\/[^/]+\/+(?:image|post)\/+([0-9]{8,})\/*(?:[?#].*)?$/);
									if (match) {
										return match[1];
									}
								}
							} catch (e) {
								console_error(e);
							}
						}
					}
					return null;
				};
				var el_has_mediakey = function(el, mediakey) {
					if (el.tagName === "IMG") {
						return find_mediakey_from_url(el.src) === mediakey;
					} else if (el.tagName === "IFRAME" && /\/post\/+[0-9]+\/+/.test(el.src)) {
						try {
							var images = el.contentDocument.querySelectorAll("img");
							for (var i = 0; i < images.length; i++) {
								if (el_has_mediakey(images[i], mediakey))
									return true;
							}
						} catch (e) {
							console_error(e, el);
							return false;
						}
					}
					return false;
				};
				var try_finding_postid_from_url = function(url) {
					if (!options.document)
						return null;
					var mediakey = find_mediakey_from_url(url);
					if (!mediakey)
						return null;
					var cache_key = "tumblr_url_postid:" + mediakey;
					if (api_cache.has(cache_key)) {
						return api_cache.get(cache_key);
					}
					var els = options.document.querySelectorAll("article img, article iframe");
					for (var i = 0; i < els.length; i++) {
						if (el_has_mediakey(els[i], mediakey)) {
							var postid = find_postid_from_el(els[i]);
							if (postid) {
								api_cache.set(cache_key, postid);
							}
							return postid;
						}
					}
					return null;
				};
				var try_finding_info = function() {
					var info = find_blogname_id_from_url(options.host_url);
					if (info)
						return info;
					var blogname = find_blogname_from_url(options.host_url);
					if (!blogname) {
						blogname = find_blogname_from_head();
					}
					if (!blogname) {
						blogname = find_blogname_from_initialstate();
					}
					if (blogname) {
						var obj = {
							blogname: blogname
						};
						var postid = find_postid_from_el(options.element);
						if (!postid) {
							postid = try_finding_postid_from_url(src);
						}
						if (postid) {
							obj.postid = postid;
							return obj;
						}
					} else if (host_domain_nowww === "tumblr.com") {
						var currentel = options.element;
						while ((currentel = currentel.parentElement)) {
							if ((currentel.tagName === "DIV" || currentel.tagName === "ARTICLE") && currentel.getAttribute("data-json")) {
								var jsondata = currentel.getAttribute("data-json");
								try {
									var json = JSON_parse(jsondata);
									return {
										blogname: json.tumblelog,
										postid: json["post-id"]
									};
								} catch (e) {
									console_error(e);
								}
								return null;
							}
						}
					}
					return null;
				};
				var mediakey = find_mediakey_from_url(src);
				if (mediakey) {
					var info = try_finding_info();
					if (info) {
						get_post(info.blogname, info.postid, function(data) {
							if (!data) {
								console_warn("Unable to get post data from API", info);
								return options.cb(null);
							}
							var media = find_media_from_post_mediakey(data, mediakey);
							if (!media) {
								console_warn("Unable to find media from post and mediakey", data, mediakey);
								return options.cb(null);
							}
							var largest = find_largest_from_media(media);
							var obj = { url: largest.url };
							if (largest.has_original_dimensions)
								obj.is_original = true;
							return options.cb(obj);
						});
						return {
							waiting: true
						};
					}
				}
			}
			if (domain === "wc-ahba9see.c.sakurastorage.jp" ||
				domain === "cdn.worldcosplay.net") {
				newsrc = src;
				if (string_indexof(src, "/max-1200/") >= 0) {
					newsrc = src.replace(/-[0-9a-z]+(\.[^/.]*)$/, "-1200$1");
				} else {
					newsrc = src.replace(/-[0-9]+(?:x[0-9]+)?(\.[^/.]*)$/, "-3000$1");
				}
				return {
					url: newsrc,
					can_head: false,
					headers: {
						Referer: ""
					},
					referer_ok: {
						same_domain: true
					}
				};
			}
			if (domain_nowww === "nautiljon.com" && src.match(/\/images[a-z]*\//)) {
				return src
					.replace(/\/imagesmin\//, "/images/")
					.replace(/\/images\/[0-9]+x[0-9]+\//, "/images/")
					.replace(/\/mini\/([^/]*)$/, "/$1")
					.replace(/(\/[0-9]+\/[0-9]+\/)[a-z]+\/([^/]*)$/, "$1$2");
			}
			if (domain === "art.wsj.net") {
				if (string_indexof(src, "/api/photos/gams-files/") >= 0) {
					return src.replace(/\/gams-files\/[^-_/.]*-[^-_/.]*_([^/_.]*)_.*$/, "/gams-id:$1");
				}
				if (string_indexof(src, "/api/photos/gams-id:") >= 0) {
					return src.replace(/(\/gams-id:[^/]*)\/.*$/, "$1");
				}
			}
			if (domain_nosub === "fanpop.com" &&
				domain.match(/images[0-9]*\.fanpop\.com/)) {
				return src
					.replace(/([0-9]+)-[0-9]+-[0-9]+(\.[^/.]*)$/, "$1$2")
					.replace(/([0-9]+)_[0-9]+_[0-9]+(\.[^/.]*)$/, "$1$2");
			}
			if (domain === "image.jimcdn.com") return src.replace(/(\/app\/cms\/image\/transf\/)[^/]*\//, "$1none/");
			if ((domain_nosub === "ladmedia.fr" ||
				domain_nosub === "lanmedia.fr") &&
				domain.match(/(?:resize|cdn)[0-9]*-[a-z]*\./)) {
				return {
					url: src
						.replace(/:\/\/resize[0-9]*-([a-z]+[^/]*?)\/+img\/var\//, "://cdn-$1/var/")
						.replace(/\/(?:[rf]|crop|rcrop)\/[^/]*\//, "/")
						.replace(/_(?:original|portrait)_[a-z0-9_]+(\.[^/.]*)$/, "$1"),
					can_head: true
				};
			}
			if (domain === "resize.elle.fr") {
				return src
					.replace(/:\/\/[^/]+\/+original\/+(var\/.*)$/, "://cdn-elle.ladmedia.fr/$1")
					.replace(/(:\/\/[^/]+\/+)[^/]+\/+var\/+/, "$1original/var/");
			}
			if (domain_nowww === "parismatch.com") return src.replace(/^[a-z]+:\/\/[^/]+\/+lmnr\/+/, "https://resize-parismatch.lanmedia.fr/");
			if (domain_nosub === "imgbox.com" &&
				(domain.match(/^thumbs[0-9]*\./) ||
					domain.match(/images[0-9]*\./))) {
				var obj_1 = {
					url: src
				};
				var match_1 = src.match(/\/(?:[0-9a-f]{2}\/+){2}([^/_.]+)_([a-z])\./);
				if (match_1) {
					if (match_1[2] === "o")
						obj_1.is_original = true;
					obj_1.extra = {
						page: "https://imgbox.com/" + match_1[1]
					};
				}
				newsrc = src
					.replace(/\/thumbs([0-9]*)\.imgbox\.com\//, "/images$1.imgbox.com/")
					.replace(/_[a-z](\.[^/.]*)/, "_o$1");
				if (newsrc !== src) {
					obj_1.url = newsrc;
					return obj_1;
				}
				return obj_1;
			}
			if (domain_nosub === "imgbox.com" && /^(?:[0-9]+[-.])?t\./.test(domain) && options.do_request && options.cb) {
				newsrc = src.replace(/^[a-z]+:\/\/(?:[0-9]+[-.])?t\./, "https://t.");
				api_query("imgbox_redirect:" + newsrc, {
					url: newsrc
				}, options.cb, function(done, resp, cache_key) {
					done(resp.finalUrl, 6 * 60 * 60);
				});
				return {
					waiting: true
				};
			}
			if (domain_nowww === "imgbox.com") {
				if (/\/images\/+background-body\./.test(src))
					return {
						url: src,
						bad: "mask"
					};
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+([0-9a-zA-Z]+)(?:[?#].*)?$/,
					run: function(cb, match) {
						return cb("https://t.imgbox.com/" + match[1] + ".jpg");
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain === "community.akamai.steamstatic.com") {
				if (/\/public\/+images\/+sharedfiles\/+game_highlight_activethumb/.test(src))
					return {
						url: src,
						bad: "mask"
					};
				newsrc = src.replace(/(\/economy\/+image\/+[^/]+\/+)[0-9]+x[0-9]+([?#].*)?$/, "$1$2");
				if (newsrc !== src)
					return {
						url: newsrc,
						head_wrong_contentlength: true
					};
			}
			if ((domain_nosub === "steamstatic.com" && domain.match(/(?:cdn|shared)\.[^.]*\.steamstatic\.com/)) ||
				(domain_nosub === "akamaihd.net" && domain.match(/steamcdn(?:-[a-z]*)?\.akamaihd\.net/))) {
				newsrc = src.replace(/(\/steam\/+apps\/+[0-9]+\/+movie)[0-9]+(?:_vp9)?(\.[^/.]+)(?:[?#].*)?$/, "$1_max$2");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/(\/steam\/+apps\/+[0-9]+\/+movie)\.(?:jpg|JPG|jpeg|JPEG|png|PNG)(?:[?#].*)?$/, "$1_max.webm");
				if (newsrc !== src)
					return {
						url: newsrc,
						video: true
					};
				newsrc = src.replace(/(\/steamcommunity\/+public\/+images\/+clans\/+[0-9]+\/+[0-9a-f]{20,})_[0-9]+x[0-9]+(\.[^/.]+)(?:[?#].*)?$/, "$1$2");
				if (newsrc !== src)
					return newsrc;
				if (string_indexof(src, "/public/images/avatars/") >= 0) {
					src = src.replace(/(?:_[^/.]*)?(\.[^/.]*)$/, "_full$1");
				}
				newsrc = src.replace(/(\/steam\/+apps\/+[0-9]+\/+library_[0-9]+x[0-9]+)\./, "$1_2x.");
				if (newsrc !== src)
					return newsrc;
				return src.replace(/\.[0-9]+x[0-9]+(\.[^/]*)$/, "$1");
			}
			if (domain === "steamstore-a.akamaihd.net") {
				if (/\/public\/+images\/+v[0-9]*\/+(?:app\/+game_page|(?:(?:ico_)?game_|arrows\.)).*/.test(src))
					return {
						url: src,
						bad: "mask"
					};
			}
			if (domain_nosub === "steamstatic.com" && /^avatars\./.test(domain)) {
				return src.replace(/(:\/\/[^/]+\/+[0-9a-f]{10,})(?:_medium)?\./, "$1_full.");
			}
			if (domain_nosub === "nutaku.com" && /^cdn[0-9]*-images\./.test(domain)) {
				return src.replace(/(\/images\/.*)-thumb(\.[^/.]+)(?:[?#].*)?$/, "$1$2");
			}
			if (domain_nosub === "medium.com" &&
				(domain.match(/cdn-images-[0-9]*\.medium\.com/) ||
					domain === "miro.medium.com")) {
				return src.replace(/(:\/\/[^/]*\/+(?:v2\/+)?).*?\/([^/]*)$/, "$1$2");
			}
			if ((domain_nosub === "zimbio.com" ||
				domain_nosub === "stylebistro.com" ||
				domain_nosub === "livingly.com") &&
				domain.match(/www[0-9]*\.pictures\.(.*\.)?[a-z]+\.com/)) {
				return src.replace(/[a-z](\.[^/.]*)$/, "x$1");
			}
			if (domain_nowww === "theplace2.ru" ||
				domain_nowww === "theplace.ru" ||
				domain === "image.chaojimote.com" ||
				domain === "moviepic.manmankan.com" ||
				domain === "img.star.iecity.com") {
				newsrc = src.replace(/_[a-z](\.[^/.]*)$/, "$1");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nowww === "theplace2.ru" ||
				domain_nowww === "theplace.ru" ||
				domain_nowww === "theplace-2.com") {
				return src.replace(/(:\/\/[^/]*\/)cache\/(.*?)-g[^/.]*(\.[^/.]*)/, "$1$2$3");
			}
			if ((domain_nosub === "craveonline.com" && domain.match(/cdn[0-9]*-www\.craveonline\.com/)) ||
				domain_nowww === "legswiki.com" ||
				(domain_nosub === "mandatory.com" && domain.match(/^cdn[0-9]*-www\./)) ||
				domain_nowww === "indiancinemagallery.com" ||
				(domain_nowww === "allwomensites.com" && string_indexof(src, "/gallery/") >= 0) ||
				domain_nowww === "zemanceleblegs.com" ||
				domain === "blog.chron.com" ||
				(domain_nosub === "comingsoon.net" && domain.match(/cdn[0-9]*-www\./)) ||
				(domain_nowww === "porngirlserotica.com" && /\/wp-content\/+blogs\.dir\/+[0-9]+\/+files\/+/.test(src)) ||
				(domain_nosub === "dogtime.com" && domain.match(/cdn[0-9]*-www\./))) {
				newsrc = src.replace("/thumbs/thumbs_", "/");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/-[0-9]+x[0-9]+(\.[^/.]*)(?:[?#].*)?$/, "$1");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "static.tvgcdn.net") {
				return src
					.replace("/smallcrops/", "/")
					.replace("/thumbs/", "/")
					.replace(/sm(\.[^/.]*)$/, "$1")
					.replace(/_[0-9]+x[0-9]+(\.[^/.]*)$/, "$1");
			}
			if (domain_nosub === "blogcdn.com") {
				return src
					.replace(/(\/S[0-9]+\/)[a-z](\.[^/.]*)$/, "$1l$2")
					.replace(/\/slug\/[a-z]\//, "/slug/l/");
			}
			if (domain === "photos.imageevent.com") return src.replace(/\/(?:small|large|huge|giant|icons)\/([^/]*)$/, "/$1");
			if (domain === "image.ajunews.com") return src.replace(/_[0-9]*_[0-9]*(\.[^/.]*)$/, "$1");
			if (domain_nosub === "telegraph.co.uk" &&
				(domain_nowww === "telegraph.co.uk" ||
					string_indexof(domain, "aws.telegraph.co.uk") >= 0 ||
					domain === "subscriber.telegraph.co.uk")) {
				return src.replace(/-(?:x*(?:large|medium|small))(_[^/]*)?(\.[^/.]*$)$/, "$1$2");
			}
			if (domain === "image.munhwa.com") {
				return src.replace("/gen_thumb/", "/gen_news/").replace(/_[^/._]*(\.[^/.]*$)/, "_b$1");
			}
			if (domain_nosub === "dspmedia.co.kr") return src.replace(/(\/file\/[^/]*\/)thumb_[0-9]*x[0-9]*[^/]*\//, "$1");
			if (domain_nosub === "wixmp.com" &&
				options && options.do_request && options.cb && (!options._internal_info || !options._internal_info.deviantart_page)) {
				match = src.match(/^[a-z]+:\/\/(?:images-)?wixmp-[0-9a-f]+\.wixmp\.com\/+(?:intermediary\/+)?[^/]*\/+[-0-9a-f]+\/+([0-9a-z]+)-[-0-9a-f]+\.[^/.]+(?:\/+v[0-9]*\/.*?)?(?:[?#].*)?$/);
				if (match) {
					id = match[1];
					common_functions["deviantart_page_from_id"](options.do_request, api_cache, id, function(result) {
						options._internal_info.deviantart_page = (result && result.finalUrl) || true;
						if (!result) {
							return options.cb({
								url: null,
								waiting: false
							});
						}
						common_functions["deviantart_fullimage"](options, api_cache, src, id, function(obj) {
							if (!obj) {
								obj = {
									url: src,
									extra: {
										page: result.finalUrl
									}
								};
							}
							if (!is_array(obj))
								obj = [obj];
							var normalize_da = function(url) { return url
								.replace(/([?&])(?:token|ts)=[^&]+/g, "$1")
								.replace(/[?&]+$/, ""); };
							array_foreach(obj, function(sobj) {
								if (sobj.url) {
									var simplesrc = normalize_da(src);
									var simplenewsrc = normalize_da(sobj.url);
									if (simplesrc === simplenewsrc)
										sobj.url = src;
								}
								sobj.forcerecurse = true;
								if (!sobj.extra) {
									sobj.extra = {
										page: result.finalUrl
									};
								}
							});
							return options.cb(obj);
						});
					});
					return {
						waiting: true
					};
				}
			}
			if (domain === "static.wixstatic.com" ||
				domain_nosub === "wixmp.com") {
				if (/^[a-z]+:\/\/[^/]+\/+media\/+0da768_361994b0f154464682a0aaf9724471cc\./.test(src)) {
					return {
						url: src,
						bad: "mask"
					};
				}
				obj = {};
				if (options._internal_info && options._internal_info.deviantart_page && typeof options._internal_info.deviantart_page === "string") {
					obj.extra = { page: options._internal_info.deviantart_page };
				} else {
					obj._copy_old_props = ["extra"];
				}
				newsrc = common_functions["_wix_bigimage_inner"](src);
				if (newsrc) {
					obj.url = newsrc;
					var normalize_da = function(url) { return url
						.replace(/([?&])(?:token|ts)=[^&]+/g, "$1")
						.replace(/[?&]+$/, ""); };
					if (normalize_da(src) === normalize_da(newsrc))
						obj.url = src;
				}
				return obj;
			}
			if (domain_nosub === "kukinews.com" ||
				domain_nowww === "inews365.com" ||
				domain_nowww === "newsinstar.com" ||
				domain_nowww === "artkoreatv.com" ||
				domain_nowww === "cnbnews.com" ||
				domain_nowww === "newsgg.net" ||
				domain_nowww === "newsam.co.kr" ||
				domain_nowww === "fetv.co.kr" ||
				domain_nowww === "ddaily.co.kr") {
				return src
					.replace(/\/data\/+cache\/+public\//, "/data/")
					.replace(/_[0-9]+x[0-9]+(?:_c[0-9]*)?\.([^/.]*)/, ".$1");
			}
			if (domain === "cdn.emetro.co.kr") {
				return src
					.replace(/\/image_view\.php.*?[?&]f=([^&]*).*/, "/image_view_maxw.php?f=$1&x=9999999999&ds=9999999999")
					.replace(/\/imagebank\/[0-9]*\/[0-9]*\/[0-9]*\/[0-9]*\/([^/]*)$/, "/html/image_view_maxw.php?f=$1&x=9999999999&ds=9999999999")
					.replace(/\/image_view_maxw.php.*?[?&]f=([^&]*).*/, "/image_view_maxw.php?f=$1&x=9999999999&ds=9999999999");
				/*origsize = src.match(/\/([0-9]*)\/[^/]*$/);
				if (origsize) {
					size = parseInt(origsize[1], 10);
					if (size < 1024) {
						return src.replace(/\/[0-9]*(\/[^/]*)$/, "/1024$1");
					}
				}*/
			}
			if (domain === "50.7.164.242:8182" ||
				domain_nosub === "imgspice.com" ||
				domain_nosub === "imageporter.com" ||
				domain_nosub === "imagedunk.com" ||
				domain === "main.imgclick.net" ||
				domain_nosub === "imagedax.net" ||
				domain_nosub === "piclambo.net" ||
				domain_nosub === "picturedip.com" ||
				domain_nosub === "pixroute.com") {
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+([a-z0-9]{5,})(?:(?:\/+[^/?#]*)?\.html)?(?:[?#].*)?$/,
					query_for_id: "https://" + domain + "/${id}/.html",
					process: function(done, resp, cache_key) {
						var match = resp.responseText.match(/<img id="imgpreview" src="(https?:\/\/[^/]+\/+i\/+[^"]+)"/);
						if (!match) {
							console_error(cache_key, "Unable to find match for", resp);
							return done(null, false);
						}
						return done(decode_entities(match[1]), 6 * 60 * 60);
					}
				});
				if (newsrc)
					return newsrc;
				newsrc = src.replace(/(\/i\/+(?:[0-9]+\/+)?[0-9]+\/+[a-z0-9]{5,})_t(\.[^/.]*)$/, "$1$2");
				obj = {
					url: src,
					headers: {
						Referer: ""
					},
					bad_if: [
						{
							headers: {
								"content-length": "40275",
								"content-type": "image/jpeg"
							}
						}
					]
				};
				if (newsrc !== src) {
					return fillobj_urls(add_extensions_jpeg(newsrc), obj);
				} else {
					return obj;
				}
			}
			if (domain_nosub === "imagetwist.com" && src.match(/:\/\/[^/]*\/+error\.[^/.]*(?:[?#].*)?$/)) {
				return {
					url: src,
					bad: true
				};
			}
			if (domain_nosub === "imagetwist.com" ||
				domain_nosub === "imagexport.com" ||
				domain_nosub === "imagenpic.com" ||
				domain_nosub === "vipr.im" ||
				domain_nosub === "picshick.com") {
				var bad_if_1 = [
					{
						headers: {
							"Last-Modified": "Fri, 28 May 2010 08:58:40 GMT",
							"Content-Length": "8183"
						}
					}
				];
				var is_picdomain = false;
				var request_domain;
				match = domain.match(/^[uis](?:mg)?[0-9]+([a-z]+)?\./);
				if (match) {
					is_picdomain = true;
					request_domain = domain_nosub;
					if (match[1]) {
						request_domain = match[1] + "." + request_domain;
					}
				}
				if (!is_picdomain) {
					newsrc = website_query({
						website_regex: {
							regex: /^[a-z]+:\/\/([^/]+)\/+([0-9a-z]{8,})\/+[^/.?#]*(\.[^/.]+)(?:[?#].*)?$/,
							groups: ["domain", "id", "ext"]
						},
						query_for_id: "https://${domain}/${id}/${ext}",
						process: function(done, resp, cache_key) {
							var match = resp.responseText.match(/<a\s+href=["'](https?:\/\/[ius](?:mg)?[0-9]*(?:[a-z]+)?\.[^/]+\/+i\/+.*?)["'][^>]*\sdownload/);
							if (!match) {
								match = resp.responseText.match(/<p[^>]*>\s*<img\s+src=["'](https?:\/\/[ius](?:mg)?[0-9]*(?:[a-z]+)?\.[^/]+\/+i\/+[^"']+)["'][^>]*\sclass="[^"]*pic[^"]*"/);
							}
							if (!match) {
								console_error(cache_key, "Unable to find match for", resp);
								return done(null, false);
							}
							done({
								url: decode_entities(match[1]),
								headers: {
									Referer: src.replace(/:\/\/(?:[^/]*\.)?([^/.]*\.[^/.]*)\/.*/, "://$1/"),
									Origin: src.replace(/:\/\/(?:[^/]*\.)?([^/.]*\.[^/.]*)\/.*/, "://$1/"),
									"Sec-Metadata": "destination=image, site=same-site"
								},
								bad_if: bad_if_1,
								is_original: true
							}, 60 * 60);
						}
					});
					if (newsrc)
						return newsrc;
				} else {
					newsrc = src.replace(/^([a-z]+:\/\/)[^/]+\/+th\/+[0-9]+\/+([0-9a-z]+)(\.[^/.]*)?$/, "$1" + request_domain + "/$2/$3");
					if (newsrc !== src) {
						return [
							{
								url: newsrc,
								is_pagelink: true
							},
							{
								url: src.replace(/\/th\//, "/i/"),
								headers: {
									Referer: src.replace(/:\/\/(?:[^/]*\.)?([^/.]*\.[^/.]*)\/.*/, "://$1/"),
									Origin: src.replace(/:\/\/(?:[^/]*\.)?([^/.]*\.[^/.]*)\/.*/, "://$1/"),
									"Sec-Metadata": "destination=image, site=same-site"
								},
								bad_if: bad_if_1
							}
						];
					}
				}
			}
			if (domain_nosub === "fappic.com") {
				if (domain_nosub === domain_nowww) {
					newsrc = website_query({
						website_regex: {
							regex: /^[a-z]+:\/\/([^/]+)\/+([0-9a-z]{8,})\/+[^/.?#]*(\.[^/.]+)(?:[?#].*)?$/,
							groups: ["domain", "id", "ext"]
						},
						query_for_id: "https://${domain}/${id}/${ext}",
						process: function(done, resp, cache_key) {
							var match = resp.responseText.match(/<img\s+src=["'](https?:\/\/[^/]+\/+img\/+.*?)["'][^>]*\s+class=['"]pic["']/);
							if (!match) {
								console_error(cache_key, "Unable to find match for", resp);
								return done(null, false);
							}
							done({
								url: decode_entities(match[1]),
								headers: {
									Referer: src.replace(/:\/\/(?:[^/]*\.)?([^/.]*\.[^/.]*)\/.*/, "://$1/"),
									Origin: src.replace(/:\/\/(?:[^/]*\.)?([^/.]*\.[^/.]*)\/.*/, "://$1/"),
									"Sec-Metadata": "destination=image, site=same-site"
								},
								is_private: true, // linked to ip
								is_original: true
							}, 60 * 60);
						}
					});
					if (newsrc)
						return newsrc;
				}
				newsrc = src.replace(/^([a-z]+:\/\/)(?:[^/.]*\.)?([^/.]+\.[^/.]+\/+)(?:th|i)\/+[0-9]+\/+([0-9a-z]+)(?:_t)?(\.[^/.]*)?$/, "$1$2$3/$4");
				if (newsrc !== src) {
					return [
						{
							url: newsrc,
							is_pagelink: true
						},
						{
							url: src,
							headers: {
								Referer: src.replace(/:\/\/(?:[^/]*\.)?([^/.]*\.[^/.]*)\/.*/, "://$1/"),
								Origin: src.replace(/:\/\/(?:[^/]*\.)?([^/.]*\.[^/.]*)\/.*/, "://$1/"),
								"Sec-Metadata": "destination=image, site=same-site"
							}
						}
					];
				}
			}
			if (domain_nowww === "imgflare.com") {
				var get_form_inputs = function(text) {
					var matches = match_all(text, /<input\s+(?:id=\S+\s+)?type="hidden"\s+name="([^"]+)" value="([^"]+)"/);
					if (!matches || !matches.length)
						return null;
					var data = {};
					array_foreach(matches, function(match) {
						data[decode_entities(match[1])] = decode_entities(match[2]);
					});
					return data;
				};
				var get_img_from_imgflare = function(resp) {
					var match = resp.responseText.match(/<img[^>]*src="(https?:\/\/i\.imgflare\.com\/+i\.php\?[^"]+)"/);
					if (!match)
						return null;
					return {
						url: decode_entities(match[1]),
						headers: {
							Referer: resp.finalUrl,
							Origin: "https://www.imgflare.com"
						},
						is_private: true // linked to ip
					};
				};
				var query_imgflare = function(url, cb, inputs, times) {
					if (!times)
						times = 0;
					if (times >= 5) {
						console_error("Unable to find image for", url, "(tried too many times)");
						return cb(null);
					}
					var req = {
						url: url,
						imu_mode: "document",
						headers: {
							Referer: "https://www.imgflare.com/",
							Origin: "https://www.imgflare.com"
						}
					};
					if (inputs) {
						req.method = "POST",
							req.data = stringify_queries(inputs);
						req.headers["Content-Type"] = "application/x-www-form-urlencoded";
					}
					api_query("imgflare:" + url, req, function(data) {
						if (!data)
							return cb(null);
						if (data.img)
							return cb(data.img);
						if (data.inputs) {
							return setTimeout(function() {
								query_imgflare(url, cb, data.inputs, times + 1);
							}, 3 * 1000);
						}
					}, function(done, resp, cache_key) {
						var img = get_img_from_imgflare(resp);
						if (img) {
							return done({
								img: img
							}, 60 * 60);
						}
						var inputs = get_form_inputs(resp.responseText);
						if (!inputs) {
							console_error(cache_key, "Unable to find form inputs for", resp, "(is captcha solved?)");
							return done(null, false);
						}
						return done({
							inputs: inputs
						}, false);
					});
				};
				newsrc = website_query({
					website_regex: [
						/^[a-z]+:\/\/[^/]+\/+([0-9a-z]{5,})\/+[^/]*\.html(?:[?#].*)?$/, // old style
						/^[a-z]+:\/\/[^/]+\/+f\/+([0-9a-z]{5,})(?:[?#].*)?$/
					],
					run: function(cb, match) {
						var id = match[1];
						var url = "https://www.imgflare.com/f/" + id;
						query_imgflare(url, cb);
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain === "i.imgflare.com") {
				match = src.match(/\/i\/+[0-9]+\/+([0-9a-z]{5,})_t\./);
				if (match)
					return {
						url: "https://www.imgflare.com/f/" + match[1],
						is_pagelink: true
					};
			}
			if (domain_nosub === "tezzpic.com" ||
				domain_nosub === "piczhq.com" ||
				domain_nosub === "crownimg.com" ||
				domain_nosub === "outletpic.com" ||
				domain_nosub === "imgoutlet.com" ||
				domain_nosub === "pictwn.com" ||
				domain_nosub === "trypicz.com" ||
				domain_nosub === "imgtown.net" ||
				domain_nosub === "dewimg.com" ||
				domain_nosub === "imgdew.com" ||
				domain_nosub === "imgmaze.com" ||
				domain_nosub === "meetimgz.com" ||
				domain_nosub === "imgview.net" ||
				domain_nosub === "picyield.com" ||
				domain_nosub === "usefto.com") {
				var img_domain_1 = domain_nosub;
				if (img_domain_1 === "piczhq.com")
					img_domain_1 = "tezzpic.com";
				if (img_domain_1 === "usefto.com" ||
					img_domain_1 === "imgoutlet.com")
					img_domain_1 = "outletpic.com";
				if (img_domain_1 === "trypicz.com" ||
					img_domain_1 === "imgtown.net")
					img_domain_1 = "pictwn.com";
				if (img_domain_1 === "imgdew.com")
					img_domain_1 = "dewimg.com";
				if (img_domain_1 === "imgmaze.com")
					img_domain_1 = "meetimgz.com";
				if (img_domain_1 === "imgview.net")
					img_domain_1 = "picyield.com";
				var query_tezzpic_img_1 = function(url, id, token, cb) {
					api_query(img_domain_1 + ":" + id + ":" + token, {
						url: url,
						imu_mode: "document",
						method: "POST",
						headers: {
							origin: "https://" + img_domain_1,
							referer: url,
							"content-type": "application/x-www-form-urlencoded"
						},
						data: "op=view&id=" + id + "&pre=1&" + token + "=1"
					}, cb, function(done, resp, cache_key) {
						var match = resp.responseText.match(/<img src="(https?:\/\/[^"]+)" class="pic(?:view)?"/);
						if (!match) {
							console_error(cache_key, "Unable to find img match for", {
								resp: resp,
								url: url,
								id: id,
								token: token
							});
							return done(null, false);
						}
						return done(match[1], 60 * 60);
					});
				};
				var check_captcha_1 = function(responseText) {
					if (/Completing the CAPTCHA proves you are a human and gives you access to/.test(responseText)) {
						return true;
					}
					return false;
				};
				var advise_captcha_1 = function(responseText) {
					if (check_captcha_1(responseText)) {
						console_error("You may need to solve a CAPTCHA");
					}
				};
				var process_final_tezzpic_1 = function(done, resp, cache_key, match, options) {
					var section_match = resp.responseText.match(/(?:\$\(document\)\['\\x6f\\x6e'\]\(|'\\x70\\x72\\x65\\x76\\x65\\x6e\\x74\\x44\\x65\\x66\\x61\\x75\\x6c\\x74'|'\\x62\\x75\\x74\\x74\\x6f\\x6e\\x5b\\x6e\\x61\\x6d\\x65\\x3d\\x22\\x6e\\x65\\x78\\x74\\x22\\x5d').*?(?:'\\x6f\\x72\\x69\\x67\\x69\\x6e\\x61\\x6c\\x45\\x76\\x65\\x6e\\x74'|'\\x69\\x73\\x54\\x72\\x75\\x73\\x74\\x65\\x64'|'\\x73\\x65\\x74\\x41\\x74\\x74\\x72\\x69\\x62\\x75\\x74\\x65').*?,((?:_0x[0-9a-f]+\s*(?:\+\s*)?)+)\);\s*}?else/);
					if (!section_match) {
						console_error(cache_key, "Unable to find section match for", resp);
						advise_captcha_1(resp.responseText);
						return done(null, false);
					}
					var section_text = section_match[0];
					var id = null;
					var url_id_match = options.url.match(/:\/\/[^/]+\/+([0-9a-z]+)\/+[^/]*\.html/);
					if (url_id_match) {
						id = url_id_match[1];
					} else {
						var id_match = resp.responseText.match(/(?:'|0x[0-9a-f]+\))\s*\+\s*'([0-9a-z]+)'\s*\+\s*(?:'[^']+'|_0x[0-9a-f]+\(0x[0-9a-f]+\))\s*\+\s*'[0-9a-f]{32}'/);
						if (!id_match) {
							console_error(cache_key, "Unable to find image ID match for", resp);
							return done(null, false);
						}
						id = id_match[1];
					}
					var args_text = section_match[1];
					var args = args_text.match(/(_0x[0-9a-f]+)/g);
					var values = [];
					for (var _i = 0, args_1 = args; _i < args_1.length; _i++) {
						var arg = args_1[_i];
						var argval_match = section_text.match(new RegExp(arg + "='([^']*)'"));
						if (!argval_match) {
							console_error("Unable to find value for arg", arg, {
								section_text: section_text,
								args: args,
								args_text: args_text,
								resp: resp
							});
							return done(null, false);
						}
						values.push(argval_match[1]);
					}
					var token = values.join("");
					query_tezzpic_img_1(options.url, id, token, function(url) {
						if (!url) {
							return done(null, false);
						}
						return done({
							url: url,
							headers: {
								Referer: "https://" + domain + "/"
							}
						}, 60 * 60);
					});
				};
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+([-_0-9a-zA-Z]{20,})\.php(?:[?#].*)?$/,
					query_for_id: "https://" + img_domain_1 + "/${id}.php",
					process: process_final_tezzpic_1
				});
				if (newsrc)
					return newsrc;
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+([0-9a-z]+)\/+[^/]*\.html(?:[?#].*)?$/,
					query_for_id: "https://" + img_domain_1 + "/${id}/.html",
					process: function(done, resp, cache_key, match, options) {
						if (domain_nosub === "crownimg.com") {
							return process_final_tezzpic_1(done, resp, cache_key, match, options);
						}
						var vars_string_match = resp.responseText.match(/((?:_0x[0-9a-f]+\s*=\s*(?:(?:'[^']*'|(?:_0x[0-9a-f]+\s*(?:\+\s*)?)+),\s*))+_0x[0-9a-f]+=atob\([^)]+\);)/);
						if (!vars_string_match) {
							console_error(cache_key, "Unable to find vars match for", resp);
							advise_captcha_1(resp.responseText);
							return done(null, false);
						}
						var vars_parsed = match_all(vars_string_match[1], /(_0x[0-9a-f]+)\s*=\s*([^,]+)\s*[;,]/);
						var vars_obj = {};
						var final_var = null;
						for (var _i = 0, vars_parsed_1 = vars_parsed; _i < vars_parsed_1.length; _i++) {
							var parsed_1 = vars_parsed_1[_i];
							var varname = parsed_1[1];
							var varvalue = parsed_1[2];
							if (varvalue[0] === "'") {
								varvalue = varvalue.replace(/^'(.*)'$/, "$1");
							} else {
								var refs = varvalue.match(/(_0x[0-9a-f]+)/g);
								var varvalues = [];
								for (var _a = 0, refs_1 = refs; _a < refs_1.length; _a++) {
									var ref = refs_1[_a];
									varvalues.push(vars_obj[ref]);
								}
								var new_varvalue = varvalues.join("");
								if (/^atob/.test(varvalue)) {
									varvalue = base64_decode(new_varvalue);
									final_var = varname;
								} else {
									varvalue = new_varvalue;
								}
							}
							vars_obj[varname] = varvalue;
						}
						if (!final_var || !/^https?:\/\//.test(vars_obj[final_var])) {
							console_error(cache_key, "Unable to find final var for", resp, vars_obj);
							return done(null, false);
						}
						done({
							url: vars_obj[final_var],
							is_pagelink: true
						}, 10 * 60);
					}
				});
				if (newsrc)
					return newsrc;
				match = src.match(/\/i\/+[0-9]+\/+([0-9a-z]+)(?:_t)?\./);
				if (match) {
					return {
						url: "https://" + img_domain_1 + "/" + match[1] + "/.html",
						is_pagelink: true
					};
				}
			}
			if (domain === "www.theactuary.com") return src.replace(/getresource\.axd\?.*(AssetID=[0-9]*).*/, "getresource.axd?$1");
			if (domain === "static.new-magazine.co.uk" ||
				amazon_container === "star-magazine.co.uk") {
				return src.replace(/(\/prod\/media\/images\/)[^/]*\//, "$1original/");
			}
			if (domain_nowww === "irishexaminer.com" ||
				domain_nowww === "breakingnews.ie" ||
				domain === "ip.index.hr" ||
				domain === "images.radiotimes.com" ||
				domain_nowww === "mffashion.com" ||
				domain === "download.iask.ca" ||
				domain === "ip.trueachievements.com") {
				newsrc = src.replace(/.*:\/\/[^/]*\/remote\/([^?]*).*/, "$1");
				if (newsrc !== src)
					return "http://" + decodeURIComponent(newsrc);
			}
			if (domain === "images.radiotimes.com") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/namedimage\/[^?]*.*?[?&]url=([^&]*).*?$/, "$1");
				if (newsrc !== src)
					return urljoin(src, newsrc, true);
			}
			if (domain === "images.radiotimes.com" ||
				domain_nowww === "radiotimes.com") {
				return src.replace(/(\/uploads\/+images\/+[a-zA-Z]+\/+[0-9]+(?:\.[-0-9a-f]+)?\.[^/.?]*)(?:[?#].*)?$/, "$1");
			}
			if ((domain === "tellymix-spykawebgroup.netdna-ssl.com" ||
				domain_nosub === "tellymixcdn.com") &&
				src.match(/:\/\/[^/]*\/+ts\//)) {
				return src.replace(/^[a-z]+:\/\/[^/]*\/+ts\/+[0-9]*\/+[0-9]*\/+/, "http://");
			}
			if (domain === "assets.goodhousekeeping.co.uk") return src.replace(/(\/(?:embedded|galleries)\/+(?:[0-9]*\/+)[^/]*)__[^/.]*(\.[^/]*)$/, "$1$2");
			if (domain === "img.buzzfeed.com") {
				return src
					.replace(/_big(\.[^/.]*)$/, "_dblbig$1")
					.replace(/_wide(\.[^/.]*)$/, "_dblbig$1")
					.replace(/_dblwide(\.[^/.]*)$/, "_dblbig$1");
			}
			if (domain_nowww === "thegenealogist.co.uk") return src.replace(/\/images\/+featuredarticles\/+header_sm\//, "/images/featuredarticles/header_lg/");
			if (domain === "251d2191a60056d6ba74-1671eccf3a0275494885881efb0852a4.ssl.cf1.rackcdn.com" ||
				domain === "8583b52b4a309671f69d-b436b898353c7dc300b5887446a26466.ssl.cf1.rackcdn.com" ||
				domain === "2e0a24317f4a9294563f-26c3b154822345d9dde0204930c49e9c.ssl.cf1.rackcdn.com" ||
				domain === "7f9c61237bd6e732e57e-5fa18836a2ae6b5e7c49abcc89b20237.ssl.cf1.rackcdn.com" ||
				domain === "b6c18f286245704fe3e9-05e2055f4cd9122af02914269431c9f6.ssl.cf1.rackcdn.com" ||
				domain === "41dcdfcd4dea0e5aba20-931851ca4d0d7cdafe33022cf8264a37.ssl.cf1.rackcdn.com" ||
				domain === "575717b777ff8d928c6b-704c46a8034042e4fc898baf7b3e75d9.ssl.cf1.rackcdn.com" ||
				domain === "598d5fcf392acad97538-395e64798090ee0a3a571e8c148d44f2.ssl.cf1.rackcdn.com") {
				return src.replace(/(\/[^/.]*)_[a-z](\.[^/.?]*)(?:\?[^/]*)?$/, "$1$2");
			}
			if (domain === "be35832fa5168a30acd6-5c7e0f2623ae37b4a933167fe83d71b5.ssl.cf3.rackcdn.com") return src.replace(/__hero(\.[^/.]*)(?:[?#].*)?$/, "$1");
			if (domain === "7e7781e2f767494a7128-d0458b7f69ca26f2871554faadb4939e.ssl.cf5.rackcdn.com") {
				if (/\/wp-content\/+themes\/+photolux\/+images\//.test(src))
					return {
						url: src,
						bad: "mask"
					};
			}
			if ((domain_nosub === "shopify.com" && /^cdn[0-9]*\./.test(domain)) ||
				((domain_nowww === "fellowproducts.com" ||
					domain === "store.mossyoak.com" ||
					domain_nosub === "ecoflow.com" ||
					domain_nowww === "levitation.fm" ||
					domain_nowww === "mariahcarey.store" ||
					domain_nowww === "trueself2020.com" ||
					domain_nowww === "theoldmapshop.com" ||
					domain_nowww === "ballyrobertgardens.coM" ||
					domain_nowww === "herb-era.com" ||
					domain_nowww === "deltagoodrem.com" ||
					domain === "partners.spigen.com" ||
					domain_nowww === "cosmicbackground.io" ||
					domain_nowww === "roguewavecoffee.ca") && /\/cdn\/+shop\//.test(src)) ||
				/^[a-z]+:\/\/[^/]+\/+cdn\/+shop\/+(?:products|collections|files|articles)\/+[^/.?#]+(?:\.progressive)?\.[a-zA-Z]+(?:[?#].*)?$/.test(src)) {
				if (/\/assets\/+product-highlight-color-hover\.svg(?:[?#].*)?$/.test(src)) {
					return {
						url: src,
						bad: "mask"
					};
				}
				newsrc = src.replace(/_(?:large|medium|small|grande|compact|[0-9]+x(?:[0-9]+)?|x[0-9]+)(?:@[0-9]+x)?(?:_crop_[a-z]+)?(?:\.progressive)?(\.[^/.]*)(?:[?#].*)?$/, "$1");
				return remove_queries(newsrc, ["width", "height"]);
			}
			if (domain === "cdn.itv.com") return src.replace(/\/[a-z]*_([^/_]*)$/, "/$1");
			if (domain === "thumbnailer.mixcloud.com") return src.replace(/\/unsafe\/[0-9]+x[0-9]+\//, "/unsafe/0x0/");
			if (domain === "d3mkh5naggjddw.cloudfront.net" ||
				domain === "img.blvds.com" ||
				domain === "resizer.mundotkm.com" ||
				domain === "d2isyty7gbnm74.cloudfront.net" ||
				domain === "thumb.connect360.vn" ||
				domain === "img.movietimes.com" ||
				domain === "t.t2online.co.in" ||
				domain === "thum.buzzni.com" ||
				domain === "resizer.mundotkm.com" ||
				domain === "quicksilver.scoopwhoop.com" ||
				domain_nosub === "telegraphindia.com" ||
				domain === "mediacdn.libertatea.ro" ||
				domain === "imgresizer.eurosport.com" ||
				domain === "gdn.printerval.com" ||
				(domain_nosub === "genius.com" && domain.match(/t[0-9]*\.genius\.com/))) {
				return add_http(decodeURIComponent(src
					.replace(/.*\/unsafe\/(?:fit-in\/)?(?:[0-9]+x[0-9]+\/)?smart\/(?:filters:[^/]*\/)?/, "")
					.replace(/.*\/unsafe\/(?:fit-in\/)?(?:[0-9]+x[0-9]+\/)?filters:[^/]*\//, "")
					.replace(/.*\/unsafe\/fit-in\/smart\//, "")
					.replace(/.*\/unsafe\/(?:fit-in\/)?(?:[0-9]*x[0-9]*\/)?(?:center\/)?(?:smart\/)?/, "")));
			}
			if (domain === "cdn.uwants.com" ||
				domain === "cdn.discuss.com.hk") {
				return src.replace(/^[a-z]+:\/\/[^/]*\/+t\/+[0-9a-f]+\/+f\/+[0-9]+x[0-9]+\/+(?:filters:[^/]*\/+)?(https?:)/, "$1");
			}
			if (domain === "elsewhere.scdn3.secure.raxcdn.com") return src.replace(/\/images\/[sv][0-9]+\/articles\//, "/images/downloads/articles/");
			if (domain === "japantoday-asset.scdn3.secure.raxcdn.com") return src.replace(/(\/+img\/+store\/+[0-9a-f]{2}\/+[0-9a-f]{2}\/+[0-9a-f]+\/+[^/]*)(?:\/+_[wh][0-9]+)?(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain === "static01.nyt.com" ||
				(domain_nosub === "nytimes.com" && domain.match(/^graphics[0-9]*\./)) ||
				domain === "cdn1.nyt.com") {
				newsrc = src.replace(/[?#].*$/, "");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/(\/images\/.*)_[0-9]+h(\.[a-z]+)$/, "$1_large$2");
				if (newsrc !== src)
					return newsrc;
				var matched = src.match(/-([^-_/.]*?)(?:-v[0-9]*)?\.[^/.]*$/);
				if (matched) {
					if (matched[1] === "jumbo" ||
						matched[1] === "thumbStandard" ||
						matched[1] === "facebookJumbo" ||
						matched[1] === "articleInline" ||
						matched[1] === "articleLarge" ||
						matched[1] === "sfSpan" ||
						matched[1] === "videoSmall" ||
						matched[1] === "videoLarge" ||
						matched[1] === "thumbLarge" ||
						matched[1] === "tmagArticle" ||
						matched[1].match(/^videoSixteenByNine(?:Jumbo)?(?:[0-9]{0,3}|[01][0-9]{3}|20[0-4][0-9])?$/) ||
						matched[1].match(/^mediumThreeByTwo[0-9]*/) ||
						matched[1].match(/^threeByTwo(?:Small|Medium)(?:At[0-9]+X)/) ||
						matched[1].match(/^watch[0-9]*$/) ||
						matched[1].slice(0, 6) === "master" ||
						matched[1].slice(0, 6) === "square" ||
						matched[1].slice(0, 4) === "blog") {
						newsrc = src.replace(/-[^-_/.]*(-v[0-9]*)?(\.[^/.]*)$/, "-superJumbo$1$2");
						if (newsrc !== src) {
							if (newsrc.match(/-v[0-9]*\.[^/.]*$/)) {
								return [
									newsrc,
									newsrc.replace(/-v[0-9]*(\.[^/.]*)$/, "$1")
								];
							} else {
								return [
									newsrc,
									newsrc.replace(/-superJumbo(\.[^/.]*)$/, "-jumbo$1")
								];
							}
						}
					}
				}
			}
			if (domain === "render.fineartamerica.com") {
				newsrc = src.replace(/render\.fineartamerica\.com\/images\/rendered\/search\/print\/[^/]*(-[0-9]*)\/([^/]*)$/, "images.fineartamerica.com/images-medium-large$1/$2");
				if (newsrc !== src)
					return newsrc;
				if (/\/previewhighresolutionimage\.php\?/.test(src)) {
					return add_queries(src, { domainUrl: "++++++++++" });
				}
			}
			if (domain === "media.npr.org") {
				return {
					url: src
						.replace(/(\/[^/]*)-[sc][0-9]*(?:-[sc][0-9]*)?(\.[^/.]*)/, "$1$2")
						.replace(/(_custom)?(?:_[a-z]+)?-([a-f0-9]{30,})(\.[^/.]*)$/, "$1-$2$3")
						.replace(/\.webp([?#].*)?$/, ".jpg$1"),
					head_wrong_contentlength: true
				};
			}
			if (domain_nosub === "pbsrc.com" && domain.match(/rs[0-9]*\.pbsrc\.com/)) {
				return src
					.replace(/rs([0-9]*)\.pbsrc\.com/, "i$1.photobucket.com")
					.replace(/\?.*/, "")
					.replace(/(?:~[^/.]*)?$/, "~original");
			}
			if (domain_nosub === "photobucket.com" && /^i(?:[0-9]+|mg)\./.test(domain)) {
				newsrc = src.replace(/\?.*/, "");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/(?:~[^/.]*)?(?:[?#].*)?$/, "~original");
				if (newsrc !== src)
					return newsrc;
				return src.replace(/:\/\/i((?:[0-9]+|mg)\..*?)(?:~original)?(?:[?#].*)?$/, "://oi$1");
			}
			if (domain_nosub === "photobucket.com" && /^o?i(?:[0-9]*|mg)\./.test(domain)) {
				match = src.match(/^[a-z]+:\/\/[a-z]*([0-9]+)?\.[^/]*\/+albums\/+[a-z]{1,2}[0-9]+\/+([^/]+)\/+([^/]+\.[^/.~]*?)(?:~[^/.]*)?(?:[?#].*)?$/);
				if (match) {
					var pbdomain = "www";
					if (match[1])
						pbdomain = "s" + match[1];
					var page = "http://" + pbdomain + ".photobucket.com/user/" + match[2] + "/media/" + match[3] + ".html";
					return {
						url: src,
						headers: {
							Referer: page
						},
						extra: {
							page: page
						}
					};
				}
			}
			if (domain === "www.welt.de" ||
				domain === "img.welt.de") {
				return src.replace(/-c[^-/]+-w[0-9]*(\/[^/]*)$/, "-coriginal-w0$1");
			}
			if (domain === "cdn.baeblemusic.com" && string_indexof(src, "/images/") >= 0) {
				return src.replace(/-[0-9]*(\.[^/.]*)$/, "$1");
			}
			if (domain_nosub === "deviantart.net" && domain.match(/^t[0-9]*\./)) {
				return src.replace(/:\/\/.*?\.deviantart\.net\/.*?\/[0-9]*x[0-9]*\/[^/]*\/([^/]*)\/(.*)/, "://$1\.deviantart\.net/$2");
			}
			if (domain_nosub === "grazia.fr" && domain.match(/img[0-9]*\.grazia\.fr/) ||
				domain_nowww === "glamour.de" ||
				domain === "asia.nikkei.com" ||
				domain_nosub === "elle.co.jp" ||
				domain_nowww === "harpersbazaar.jp" ||
				domain_nowww === "fotogramas.es" ||
				domain_nosub === "ellegirl.jp" ||
				domain_nosub === "esquire.jp" ||
				domain === "img.25ans.jp" ||
				domain_nowww === "cosmopolitan.com.hk" ||
				domain_nowww === "elle.com.hk" ||
				domain_nosub === "vogue.de" ||
				(domain_nosub === "telestar.fr" && domain.match(/img[0-9]*\.telestar\.fr/)) ||
				domain_nowww === "haz.de" ||
				domain_nowww === "connexionfrance.com" ||
				domain_nowww === "novilist.hr" ||
				domain_nowww === "ville-wasquehal.fr" ||
				domain_nowww === "gq-magazin.de" ||
				domain_nowww === "esa.int" ||
				domain_nowww === "quejadore.com" ||
				(domain_nosub === "grazia.fr" && /^file[0-9]*\./.test(domain)) ||
				domain_nosub === "esquirehk.com" ||
				domain === "gfx.elle.ci" ||
				(domain_nosub === "closermag.fr" && domain.match(/(?:img|file)[0-9]*\.closermag\.fr/))) {
				return src
					.replace(/(:\/\/[^/]*\/var\/+(?:[^/]*\/+)?storage\/+images\/+.*\/[^/]+?)(?:_[a-z][^-/._]*(?:_[0-9]+){0,})?(\.[^/.?]*)(?:[?#].*)?$/, "$1$2")
					.replace(/\/storage\/+images\/+_aliases\/+[^/]*\/+/, "/storage/images/");
			}
			if ((domain_nosub === "purepeople.com" ||
				domain_nosub === "purepeople.com.br" ||
				domain_nosub === "purebreak.com" ||
				domain_nosub === "purebreak.com.br" ||
				domain_nosub === "get-the-look.ca" ||
				domain_nosub === "hairstyle.com" ||
				domain_nosub === "puretrend.com") &&
				domain.match(/^static[0-9]*\./)) {
				return src.replace(/([-_])[0-9]+(?:x[0-9]+)?(-[0-9]\.[^/.]*)/, "$1999999999x0$2");
			}
			if (domain_nosub === "belezaextraordinaria.com.br" && domain.match(/^static[0-9]*\./)) {
				return src.replace(/([-_])(?:[0-9]+(?:x[0-9]+)?|(?:article|opengraph)_[^-/.]+)(-[0-9]\.[^/.]*)/, "$1article_news$2");
			}
			if (domain === "medias.unifrance.org") return src.replace(/(\/medias\/+.*\/+)format_(?:web|affiche|page)\/+/, "$1format_hd/");
			if (domain === "lthumb.lisimg.com") {
				newsrc = src.replace(/\?.*/, "");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/^[a-z]+:\/\/[^/]+\/+[0-9]+\/+([0-9]+)\..*/, "https://ilarge.lisimg.com/image/$1/0full.jpg");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nosub === "lisimg.com" ||
				domain_nosub === "listal.com") {
				obj = {
					url: src
				};
				id = src.match(/^[a-z]+:\/\/[^/]+\/+(?:image\/+)?([0-9]+)\/+[0-9]+/);
				if (id) {
					id = id[1];
					obj.extra = { page: "https://www.listal.com/viewimage/" + id };
				}
				obj.url = src
					.replace(/:\/\/[^\./]*\.lisimg\.com\//, "://ilarge.lisimg.com/")
					.replace(/(:\/\/[^/]+\/+(?:image\/+)?[0-9]+)\/+[0-9]+(?:full)?([^/]*?(?:\/[^/]*)?(?:[?#].*)?)$/, "$1/99999999999full$2");
				return obj;
			}
			if (domain_nosub === "lesinrocks.com") return src.replace(/\/width-[0-9]*-height-[0-9]*/, "/width-0-height-0");
			if (domain === "media.senscritique.com") return src.replace(/(\/media\/+[0-9]{8,}\/+)[0-9]+(?:[_x][0-9]+)?\/+([^/]*\.[^/.]*)(?:[?#].*)?$/, "$10/$2");
			if (domain_nowww === "franceinter.fr" ||
				domain === "cdn.radiofrance.fr") {
				return src.replace(/\/[0-9]+(?:x[0-9]+)?_([^/]*\.[^/.]+)(?:[?#].*)?$/, "/$1");
			}
			if (domain === "1645110239.rsc.cdn77.org" ||
				domain_nowww === "cinenews.be") {
				newsrc = src
					.replace(/\/image\/[a-z][0-9]+\//, "/image/") // to be repeated
					.replace(/\/image\/x[0-9]+x[0-9]+\//, "/image/")
					.replace(/\/([^/.]*)\.[0-9]+(\.[^/.]*)$/, "/$1$2");
				return {
					url: newsrc,
					head_wrong_contentlength: true
				};
			}
			if (domain_nowww === "diymag.com" && string_indexof(src, "/media/img") >= 0) {
				return src.replace(/(\/media\/img\/.*\/)_[^/]*\/([^/]*)$/, "$1$2");
			}
			if (domain_nowww === "kerry-brown.com") return src.replace(/(\/assets\/+[^/]+\/+)_[^/]+\/+/, "$1");
			if (domain_nowww === "semainedelacritique.com" && string_indexof(src, "/ttimg-rsz") >= 0) {
				newsrc = src.replace(/.*\/ttimg-rsz\?(?:.*&)?src=([^&]*).*/, "$1");
				if (newsrc !== src)
					return urljoin(src, newsrc, true);
			}
			if (domain === "photo.gala.fr") {
				return {
					url: src,
					head_wrong_contentlength: true
				};
			}
			if (domain === "cdn.cnn.com" ||
				(domain_nosub === "turner.com" && domain.match(/^(?:i[0-9]*\.)?cdn\.turner\.com/))) {
				return {
					url: src.replace(/-(?:small|medium|large|exlarge|super|full|overlay|alt|tease|story-top|horizontal)(?:-(?:small|medium|large|exlarge|super|full|overlay|alt|tease|plus))?(?:-(?:[0-9]+|gallery))?(\.[^/.]*)$/, "$1"),
					can_head: false
				};
			}
			if (domain === "media.cnn.com") return src.replace(/(\/api\/+v1\/+images\/[^?#]+)(?:[?#].*)?$/, "$1?c=original");
			if (domain === "ugc.kn3.net" /* &&
				string_indexof(src, "/i/origin/") >= 0*/) {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/i\/(?:c_)?[0-9a-z]+\//, "");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "media.shoko.fr" ||
				domain === "media.fan2.fr" ||
				domain === "media.melty.it" ||
				domain === "media.virginradio.fr" ||
				domain === "media.melty.mx" ||
				domain === "media.melty.fr") {
				return src
					.replace(/(:\/\/[^/]*)\/([^/]*?)-[^-/]*((?:-f[^/]*)?\.[^/.]*)$/, "$1/$2-redim$3")
					.replace(/(:\/\/[^/]*)\/([^/-]*?-[0-9]*-)[^/-]*(-f[^/]*)?\//, "$1/$2redim$3/");
			}
			if (domain_nosub === "vogue.fr" ||
				domain_nowww === "glamourparis.com" ||
				domain_nowww === "gqmagazine.fr") {
				src = src.replace(/\/images\/+thumbs\//, "/images/");
				newsrc = src.replace(/(\.[^/._]*)_[^/]*$/, "$1");
				if (newsrc !== src)
					return newsrc;
				return src.replace(/_north_[0-9]*x(?:[0-9]+)?_(?:white|transparent)(\.[^/.]*)$/, "$1");
			}
			if (domain === "img.culturacolectiva.com") {
				newsrc = src.replace(/-(?:high|medium|low)(\.[^/.]*)$/, "$1");
				if (newsrc !== src)
					return newsrc;
			}
			if ((domain_nosub === "reveliststatic.com" ||
				domain_nosub === "cafemom.com" ||
				domain_nosub === "cafemomstatic.com") &&
				domain.match(/^(?:cdn-)?ugc(?:-[0-9]*)?\./)) {
				return src.replace(/\/gen\/(?:constrain|crop|resize|min)\/[0-9]*\/[0-9]*\/[0-9]*\//, "/gen/full/");
			}
			if (domain === "images.shazam.com") return src.replace(/_s[0-9]+(\.[^/.]*)$/, "_s0$1");
			if (domain_nosub === "ebayimg.com") {
				obj = {
					url: src,
					can_head: false, // fixme: does it hang here too?
					bad_if: [{
							headers: {
								"x-ebay-c-extension": "responsecode=404,responsemessage=Not Found"
							}
						}]
				};
				newsrc = src.replace(/\/t\/.*?(\/[0-9]+\/s\/)/, "$1");
				if (newsrc !== src) {
					return fillobj_urls([newsrc, src], obj);
				}
				newsrc = src.replace(/\/[0-9]+\/[a-z]+\/[^/]*\/[a-z]+\/([^/]+)\/[^/.]*(\.[^/.]*)$/, "/images/g/$1/s-l9999$2");
				if (newsrc !== src) {
					newsrc = newsrc.replace(/(.*\.)[^/.]*$/, "$1") + newsrc.replace(/.*\.([^/.]*)$/, "$1").toLowerCase();
					return fillobj_urls([newsrc, src], obj);
				}
				newsrc = src
					.replace(/\/thumbs\/images\//, "/images/")
					.replace(/-l[0-9]+(\.[^/.]*)$/, "-l9999$1");
				if (newsrc !== src) {
					return fillobj_urls([newsrc, src], obj);
				}
				return obj;
			}
			if ((domain_nosub === "ebaystatic.com" && domain.match(/thumbs[0-9]*\.ebaystatic\.com/)) ||
				domain === "securethumbs.ebay.com") {
				newsrc = src
					.replace(/^[a-z]*:\/\/[^/]*\/(.*?)\/[0-9]+(\.[^/.]*)$/, "https://ssli.ebayimg.com/images/$1/s-l9999$2")
					.replace(/^[a-z]*:\/\/[^/]*\/d\/l[0-9]+\/([a-z]\/[^/]*)(\.[^/.]*)$/, "https://ssli.ebayimg.com/images/$1/s-l9999$2");
				if (newsrc !== src) {
					return newsrc;
				}
				newsrc = src.replace(/\/d\/[a-z][0-9]+\/pict\//, "/d/l9999/pict/");
				if (newsrc !== src) {
					return newsrc;
				}
				return {
					url: src,
					can_head: false, // it just hangs
					bad_if: [{
							headers: {
								"x-ebay-c-extension": "responsecode=404,responsemessage=Not Found"
							}
						}]
				};
			}
			if (domain === "q.ebaystatic.com") {
				if (/\/pics\/+cmp\/+ui\/+imgzoomregionmask/.test(src)) {
					return {
						url: src,
						bad: "mask"
					};
				}
			}
			if (domain_nowww === "picclickimg.com") {
				return src
					.replace(/:\/\/www.picclickimg.com\/d\//, "://thumbs.ebaystatic.com/d/")
					.replace(/:\/\/www.picclickimg.com(\/[0-9]+\/s\/)/, "://i.ebayimg.com$1");
			}
			if (domain_nowww === "ezcorporateembroidery.com") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/packs\/images[a-z]+\/(https?:\/\/)/, "$1");
				if (newsrc !== src)
					return newsrc;
				return src.replace(/^[a-z]+:\/\/[^/]*\/images\/scale\/([a-z][0-9]+\/)/, "https://securethumbs.ebay.com/d/$1");
			}
			if (domain_nowww === "dealsanimg.com") return src.replace(/^[a-z]+:\/\/[^/]*\/+d\//, "https://securethumbs.ebay.com/d/");
			if (domain === "i.slkimg.com") {
				return src
					.replace(/\/fill\/[0-9]+,[0-9]+\//, "/")
					.replace(/[0-9]+(\.[^/.]*)$/, "999999999$1");
			}
			if (domain === "i.vimeocdn.com" && string_indexof(src, "/filter/overlay") >= 0) {
				return decodeURIComponent(src.replace(/.*\/overlay\?.*?src0=([^&]*).*/, "$1"));
			}
			if (domain === "i.vimeocdn.com") {
				newsrc = src.replace(/(:\/\/[^/]+\/+(?:video|portrait|vod_poster)\/+[0-9]+(?:-[0-9a-f]{20,}-d)?)_[0-9]+x[0-9]+(\.[^/.?#]+)?(?:[?#].*)?$/, "$1$2");
				if (newsrc !== src) {
					return newsrc;
				}
			}
			if (host_domain_nowww === "vimeo.com" && options.element) {
				newsrc = common_functions["get_pagelink_el_matching"](options.element, /^[a-z]+:\/\/(?:www\.)?vimeo\.com\/+([0-9]+)(?:[?#].*)?$/);
				if (newsrc)
					return newsrc;
			}
			if (domain_nowww === "vimeo.com") {
				match = src.match(/^[a-z]+:\/\/[^/]+\/+([0-9]+)(?:[?#].*)?$/);
				if (match) {
					id = match[1];
					var query_vimeo_clippageconfig = function(id, cb) {
						api_query("vimeo:" + id, {
							url: "https://vimeo.com/" + id,
							headers: {
								Referer: ""
							}
						}, cb, function(done, resp, cache_key) {
							var match = resp.responseText.match(/window\.vimeo\.clip_page_config\s*=\s*({.*?});\s*\n/);
							if (!match) {
								console_warn(cache_key, "Unable to find match for", resp);
								return done(null, false);
							}
							try {
								var json = JSON_parse(match[1]);
								return done(json, 60 * 60);
							} catch (e) {
								console_error(cache_key, e);
								return done(null, false);
							}
						});
					};
					var get_id_from_vimeo_playerconfig_url = function(url) {
						var match = url.match(/^[a-z]+:\/\/player\.vimeo\.com\/+video\/+([0-9]+)\/+config/);
						if (match)
							return match[1];
						return null;
					};
					var query_vimeo_playerconfig = function(url, cb) {
						var id = get_id_from_vimeo_playerconfig_url(url);
						if (!id)
							return cb(null);
						api_query("vimeo_playerconfig:" + id, {
							url: url,
							headers: {
								Origin: "https://vimeo.com",
								Referer: "https://vimeo.com/" + id
							}
						}, cb, function(done, resp, cache_key) {
							try {
								var json = JSON_parse(resp.responseText);
								return done(json, json.request.expires || 60 * 60);
							} catch (e) {
								console_error(cache_key, e);
								return done(null, false);
							}
						});
					};
					var page_nullobj = {
						url: src,
						is_pagelink: true
					};
					var get_obj_from_vimeo_playerconfig = function(data) {
						if (!data || !data.request || !data.video)
							return page_nullobj;
						var obj = { extra: {} };
						var urls = [];
						if (data.video.title) {
							obj.extra.caption = data.video.title;
						}
						if (data.video.share_url) {
							obj.extra.page = data.video.share_url;
						}
						try {
							var files = data.request.files;
							var progressive = files.progressive;
							var max = 0;
							var maxobj = null;
							for (var i = 0; i < progressive.length; i++) {
								var ourobj = progressive[i];
								if (!ourobj.url)
									continue;
								var oursize = ourobj.width * ourobj.height;
								if (oursize > max) {
									max = oursize;
									maxobj = ourobj;
								}
							}
							if (maxobj) {
								urls.push({
									url: maxobj.url,
									video: true
								});
							}
							urls.push(data.video.thumbs.base);
						} catch (e) {
							console_error(e);
						}
						urls.push(page_nullobj);
						return fillobj_urls(urls, obj);
					};
					var query_vimeo_for_obj = function(id, cb) {
						query_vimeo_clippageconfig(id, function(data) {
							if (!data || !data.player || !data.player.config_url)
								return cb(page_nullobj);
							query_vimeo_playerconfig(data.player.config_url, function(data) {
								cb(get_obj_from_vimeo_playerconfig(data));
							});
						});
					};
					if (options.do_request && options.cb) {
						query_vimeo_for_obj(id, options.cb);
						return {
							waiting: true
						};
					} else {
						return page_nullobj;
					}
				}
			}
			if (domain === "imagelab.nownews.com") {
				return decodeURIComponent(src.replace(/.*[/?&]src=(.*)$/, "$1"));
			}
			if (host_domain_nowww === "discord.com" && options.element) {
				var has_discord_class_1 = function(el, cl) {
					var regex = new RegExp("^" + cl + "_+[0-9a-f]+$");
					for (var _i = 0, _a = el.classList; _i < _a.length; _i++) {
						var c = _a[_i];
						if (regex.test(c))
							return true;
					}
					return false;
				};
				if (options.element.tagName === "IMG" && has_discord_class_1(options.element, "lazyImg")) {
					var el_1 = common_functions["get_parent_el_matching"](options.element, function(x) {
						return has_discord_class_1(x, "imageWrapper");
					});
					if (el_1) {
						var ael_1 = el_1.querySelector('a[data-role="img"]');
						return ael_1.href;
					}
				}
			}
			if (domain === "cdn.discordapp.com") {
				return src
					.replace(/(\/emojis\/+[0-9]+\.[^/.?#]+)(?:[?#].*)?$/, "$1?size=4096")
					.replace(/(\/[-a-z]+\/+[0-9]{5,}\/+(?:users\/+[0-9]+\/+avatars\/+)?[^/]+\.[^/.?#]+)(?:[?#].*)?$/, "$1?size=4096");
			}
			if (domain === "media.discordapp.net") {
				newsrc = src.replace(/(\/stickers\/+[0-9]{5,}\.[^/.?#]+)(?:[?#].*)?$/, "$1?size=4096");
				if (newsrc !== src)
					return newsrc;
				if (/\/attachments\/+[0-9]+\/+/.test(src)) {
					return keep_queries(src, ["ex", "is", "hm"]);
				}
			}
			if (domain_nosub === "discordapp.net" && domain.match(/images-ext-[0-9]*\.discordapp\.net/)) {
				return decodeURIComponent(src.replace(/.*\/external\/[^/]*\/(?:([^/]*)\/)?(https?)\/(.*?)(?:\?[^/]*)?$/, "$2://$3$1"));
			}
			if (domain_nowww === "hot-korea.net") return src.replace(/\/uploads\/+([^/]*\/+)thumbs\//, "/uploads/$1");
			if (domain_nosub === "sndcdn.com" && domain.match(/i[0-9]*\.sndcdn\.com/)) {
				newsrc = src.replace(/-[^-/.]*(\.[^/.]*)$/, "-original$1");
				if (newsrc !== src)
					return add_extensions(newsrc);
			}
			if (domain_nowww === "soundcloud.com") {
				var soundcloud_get_clientid_from_js_resp = function(resp) {
					var match = resp.responseText.match(/[{,]client_id:("[^"]{20,}"),/);
					if (!match) {
						console_error("Unable to find text from", resp);
						return null;
					}
					return JSON_parse(match[1]);
				};
				var soundcloud_fetch_clientid_from_js = function(jsfile, cb) {
					api_query("soundcloud:clientid:js:" + jsfile, {
						url: jsfile,
						headers: {
							Referer: "https://soundcloud.com/",
							Origin: "https://soundcloud.com"
						}
					}, cb, function(done, resp, cache_key) {
						var clientid = soundcloud_get_clientid_from_js_resp(resp);
						return done(clientid, clientid ? 2 * 60 * 60 : false);
					});
				};
				var soundcloud_fetch_clientid_js_from_resp = function(resp, cb) {
					var match = match_all(resp.responseText, /<script crossorigin src="(https?:\/\/[^/]+\.sndcdn\.com\/+assets\/+1-[0-9a-f]+(?:-[0-9]+)?\.js)"><\/script>/);
					if (!match || !match.length) {
						console_error("Unable to find clientjs match from", resp);
						return cb(null);
					}
					var lastmatch = match[match.length - 1];
					var url = lastmatch[1];
					soundcloud_fetch_clientid_from_js(url, cb);
				};
				var query_soundcloud = function(clientid, url, cb) {
					api_query("soundcloud_api:" + url, {
						url: url + "?client_id=" + clientid,
						imu_mode: "xhr",
						headers: {
							Accept: "*/*",
							Origin: "https://soundcloud.com",
							Referer: " https://soundcloud.com/",
							"Sec-Fetch-Dest": "empty",
							"Sec-Fetch-Mode": "cors",
							"Sec-Fetch-Site": "same-site"
						},
						json: true
					}, cb, function(done, resp, cache_key) {
						return done(resp, 60 * 60);
					});
				};
				newsrc = website_query({
					website_regex: {
						regex: /^[a-z]+:\/\/[^/]+\/+([^/]+)\/+([^/]+)\/*(?:[?#].*)?$/,
						groups: ["author", "permalink_id"]
					},
					query_for_id: "https://soundcloud.com/${author}/${permalink_id}",
					id: "${author}/${permalink_id}",
					process: function(done, resp, cache_key) {
						var match = resp.responseText.match(/,(\[{"id":[0-9]+,"chunks":\[[0-9]+\],"data":.*?}\])\);<\/script/);
						if (!match) {
							match = resp.responseText.match(/__sc_hydration\s*=\s*(\[.*?\]);<\/script/);
						}
						if (!match) {
							console_error(cache_key, "Unable to find match for", resp);
							return done(null, false);
						}
						var json = JSON_parse(match[1]);
						var author_data, track_data;
						array_foreach(json, function(data) {
							var kind = null;
							if (!data.hydratable) {
								if (!data.data || data.data.length !== 1)
									return;
								data = data.data[0];
								kind = data.kind;
							} else {
								kind = data.hydratable;
								data = data.data;
							}
							if (kind === "user") {
							} else if (kind === "track" || kind === "sound") {
								track_data = data;
							}
						});
						if (!track_data) {
							console_error(cache_key, "Unable to find track data from", resp);
							return done(null, false);
						}
						if (false && !author_data) {
							console_warn(cache_key, "Unable to find author data from", resp);
						}
						var obj = {
							extra: {
								page: track_data.permalink_url,
								id: track_data.id,
								created_date: new Date(track_data.created_at).getTime(),
								updated_date: new Date(track_data.last_modified).getTime(),
								caption: track_data.title || track_data.description,
								author_username: track_data.user.username,
							}
						};
						var waiting = false;
						var urls = [];
						if (!track_data.media || !track_data.media.transcodings || !track_data.media.transcodings.length) {
							console_warn(cache_key, "Unable to find audio from", track_data, resp);
						} else {
							soundcloud_fetch_clientid_js_from_resp(resp, function(clientid) {
								var backup = fillobj_urls(urls, obj);
								if (!clientid)
									return done(backup, 60 * 60);
								var progressive = null;
								array_foreach(track_data.media.transcodings, function(media) {
									if (media.format.protocol !== "progressive") {
										return;
									}
									progressive = media.url;
									return false;
								});
								if (!progressive) {
									console_error(cache_key, "Unable to find progressive track from", track_data);
									return done(backup, 60 * 60);
								}
								query_soundcloud(clientid, progressive, function(data) {
									if (!data || !data.url) {
										console_error(cache_key, "Unable to fetch progressive track url", track_data, resp);
										return done(backup, 60 * 60);
									}
									urls.unshift({
										url: data.url,
										headers: {
											Referer: "https://soundcloud.com/"
										},
										media_info: {
											type: "audio"
										}
									});
									return done(fillobj_urls(urls, obj), 60 * 60);
								});
							});
							waiting = true;
						}
						urls.push(track_data.artwork_url.replace(/-[^-/.]*(\.[^/.]*)$/, "-original$1"));
						urls.push(track_data.artwork_url);
						if (!waiting)
							return done(fillobj_urls(urls, obj), 60 * 60);
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain_nosub === "licdn.com" && /^media(?:-[^.]+)?\./.test(domain)) {
				return src.replace(/\/shrinknp_[0-9]+_[0-9]+\//, "/");
			}
			if ((domain_nosub === "townnews.com" && domain.match(/bloximages\..*vip\.townnews\.com/)) ||
				amazon_container === "syd.cdn.coreweb.com.au") {
				return src.replace(/^(.*?:\/\/)[^/]*\//, "http://");
			}
			if (domain_nosub === "psbin.com" && domain.match(/cdn[^.]*\.psbin\.com/)) {
				return {
					url: src.replace(/\/img\/[^/]*=[^/]*\//, "/img/"), // repeated
					head_wrong_contentlength: true
				};
			}
			if (domain === "wac.450f.edgecastcdn.net") return src.replace(/^(.*?:\/\/)[^/]*\/80450F\/(.*?)$/, "http://$2");
			if (domain === "gp1.wac.edgecastcdn.net") {
				return src.replace(/(\/images\/[0-9]*\/[^/]*\/)[^/]*:[^/]*\//, "$1"); // repeated
			}
			if (domain === "r.fashionunited.com") {
				newsrc = src.replace(/.*?\/(aHR0c.*?)(?:[?#].*)?$/, "$1");
				if (newsrc !== src)
					return base64_decode(newsrc);
			}
			if (domain === "cdn.tag-walk.com" ||
				domain === "d2r7w2ky9n5k2b.cloudfront.net") {
				return {
					url: src.replace(/\/(?:webp|jpeg)\/+[^/]+\/+/, "/webp/custom,fit_cover/"),
					can_head: false // 403
				};
			}
			if (domain_nowww === "century21.com") return src.replace(/.*?\/photo\/[0-9a-z]*x[0-9a-z]*\//, "https://");
			if (domain === "cdn.instructables.com") return src.replace(/(:\/\/[^/]*\/)(.*)\.[^/.]*(\.[^/.]*)$/, "$1ORIG/$2$3");
			if (domain_nosub === "pressreader.com" && domain.match(/cdn[0-9]*-img\.pressreader\.com/)) {
				return src.replace(/getimage\.aspx[^/]*[?&](regionKey=[^&]*).*$/, "getimage.aspx?$1");
			}
			if (domain_nowww === "layfielddesign.com") return src.replace(/\/uploads\/+([^/]*)\/+_[^/]*\//, "/uploads/$1/");
			if (googlestorage_container === "mediaslide-europe") {
				return src.replace(/\/[a-z]*-([^/]*)$/, "/$1");
			}
			if (domain_nosub === "netinfo.bg" && domain.match(/m[^.]*\.netinfo\.bg/)) {
				return src.replace(/([/=]media\/images\/[0-9]*\/[0-9]*\/)(?:r-)?[^-/.]*-[^-/.]*/, "$1orig-orig");
			}
			if (domain_nowww === "imgur.com") {
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+(?:a|gallery)\/+([a-zA-Z0-9]+)(?:[?#].*)?$/,
					run: function(cb, match) {
						common_functions["imgur_fetch_album_media"](options, api_cache, "album", match[1], function(data) {
							if (!data)
								return cb(null);
							if (!data.media || data.media.length === 0) {
								console_error("Unable to find images in", data);
								return cb(null);
							}
							var imageobjs = [];
							array_foreach(data.media, function(image) {
								var baseobj = { extra: {} };
								var obj = common_functions["imgur_image_to_obj"](options, baseobj, image);
								imageobjs.push(fillobj_urls(obj, baseobj));
							});
							var obj = {
								extra: {
									page: data.url,
									caption: data.title || null
								}
							};
							if (data.created_at) {
								obj.extra.created_date = new Date(data.created_at).getTime();
							}
							if (data.media.length > 1) {
								obj.album_info = {
									type: "links",
									links: []
								};
								array_foreach(imageobjs, function(imageobj, i) {
									obj.album_info.links.push({
										url: imageobj[0].extra.page,
										is_current: i === 0
									});
								});
							}
							var newobj = fillobj_urls(imageobjs[0], obj);
							return cb(newobj);
						});
					}
				});
				if (newsrc)
					return newsrc;
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+([a-zA-Z0-9]+)(?:[?#].*)?$/,
					run: function(cb, match) {
						common_functions["imgur_fetch_album_media"](options, api_cache, "image", match[1], function(data) {
							if (!data)
								return cb(null);
							var baseobj = {
								extra: {
									page: data.url,
									caption: data.title || null
								}
							};
							if (data.created_at) {
								baseobj.extra.created_date = new Date(data.created_at).getTime();
							}
							var media = data;
							if (media.media && media.media[0])
								media = media.media[0];
							var obj = common_functions["imgur_image_to_obj"](options, baseobj, media);
							if (!obj) {
								console_error("Unable to parse obj from", data);
								return cb(null);
							}
							return cb(obj);
						});
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain === "i.imgur.com" ||
				domain === "i.imgur.io") {
				if (src.match(/\/removed\.[a-zA-Z]+(?:[?#].*)?$/))
					return {
						url: src,
						bad: true
					};
				var baseobj = {
					url: src.replace(/\?.*/, ""),
					headers: {
						Referer: null
					},
					referer_ok: {
						same_domain_nosub: true
					}
				};
				var idregex = /^[a-z]+:\/\/[^/]+\/+([a-zA-Z0-9]{7})\./;
				newsrc = src.replace(/\/([a-zA-Z0-9]{7})(?:[hrlgmtbs]|_d)(\.[^/.?]*)$/, "/$1$2");
				if (newsrc !== src) {
					baseobj.url = newsrc;
					match = newsrc.match(idregex);
					if (match) {
						baseobj.extra = { page: "https://imgur.com/" + match[1] };
					}
					return baseobj;
				}
				match = src.match(idregex);
				var idhash;
				if (match) {
					idhash = match[1];
					baseobj.extra = { page: "https://imgur.com/" + idhash };
					return [
						{ url: baseobj.extra.page, is_pagelink: true },
						baseobj
					];
				}
				return baseobj;
			}
			if (domain === "imgur.dcard.tw" ||
				domain === "i.wgirlz.us") {
				return src.replace(/:\/\/[^/]*\//, "://i.imgur.com/");
			}
			if (domain_nowww === "siamzone.com") {
				return src
					.replace(/^[a-z]+:\/\/[^/]*\/board\/+(?:imgur\.php\?|imgur\/+.\/+)([^/]*)$/, "https://i.imgur.com/$1");
			}
			if (domain_nosub === "disp.cc" && /^i[0-9]*\./.test(domain)) {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]+\/+imgur\/+([^/?#]+)(?:[?#].*)?$/, "https://i.imgur.com/$1");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "i.stack.imgur.com") {
				return src.replace(/\?.*/, "");
			}
			if (domain_nowww === "vidble.com" ||
				domain === "i.vidble.com") {
				return src.replace(/_[^/._]*(\.[^/.]*)$/, "$1");
			}
			if (domain === "itpro.nikkeibp.co.jp") return src.replace(/\/thumb_[0-9]+_([^/]*)$/, "/$1");
			if (domain === "media-cdn.tripadvisor.com") return src.replace(/\/media\/photo-[a-z]\//, "/media/photo-o/");
			if (domain === "dynamic-media-cdn.tripadvisor.com") return src.replace(/:\/\/dynamic-([^?#]*)\?.*$/, "://$1");
			if (domain_nowww === "traveller.com.au" ||
				domain === "resources.stuff.co.nz" ||
				domain_nowww === "fairfaxstatic.com.au" ||
				domain_nowww === "smh.com.au" ||
				domain_nowww === "dailylife.com.au" ||
				domain_nowww === "essentialbaby.com.au") {
				return src.replace(/(\/images\/+(?:[0-9a-z]\/+){4,}image\.).*$/, "$1");
			}
			if (domain_nowww === "getwallpapers.com" ||
				domain_nowww === "hintergrundbild.org" ||
				domain_nowww === "wallpapertag.com") {
				return src.replace(/\/wallpaper\/+[^/]*\/+((?:[0-9a-f]\/+){3})/, "/wallpaper/full/$1");
			}
			if (domain === "ideascdn.lego.com") {
				return src
					.replace(/-thumbnail[^/.]*(\.[^/.]*)$/, "$1")
					.replace(/-square[^/.]*(\.[^/.]*)$/, "$1");
			}
			if (domain === "images.newindianexpress.com" ||
				domain === "images.indulgexpress.com") {
				return src.replace(/\/[wh][0-9]+X[0-9]*\//, "/original/");
			}
			if (domain_nosub === "blastingcdn.com" && domain.match(/staticr[0-9]*\.blastingcdn\.com/)) {
				return src
					.replace(/\/b_[auto0-9]+x[auto0-9]+\/([^/]*)$/, "/$1")
					.replace(/\/[0-9]+x[0-9]+\/([^/]*)$/, "/main/$1");
			}
			if (domain_nowww === "gjdream.com") return src.replace(/_tmb(\.[^/.]*)$/, "$1");
			if (domain === "www.imaeil.com") return src.replace(/\/m_wiz\/imgsrc[0-9]\.php.*?[?&]src=([^&]*).*/, "/$1");
			if (domain_nowww === "kwnews.co.kr") return src.replace(/\/kwnews_view\.asp?.*?kwurl=([0-9]{4})([0-9]{2})[0-9]*-([0-9]*)-[0-9]*(\.[^/.]*)$/, "/newsphoto/$1/$2/$3$4");
			if (domain_nowww === "yeongnam.com") return src.replace(/\/mnt\/+(?:thum|file_[a-z])\/+/, "/mnt/file/");
			if (domain === "db.kookje.co.kr") {
				match = src.match(/\/[A-Z]?([0-9]{8}\.[0-9]+)i[0-9]+\.[^/.]*(?:[?#].*)?$/);
				var extra = {};
				if (match) {
					extra.page = "http://www.kookje.co.kr/news2011/asp/newsbody.asp?key=" + match[1];
				}
				return {
					url: src.replace(/\/[A-Z]([0-9]{8}\.[0-9]+i[0-9]+\.[^/.]*)(?:[?#].*)?$/, "/L$1"),
					extra: extra
				};
			}
			if (domain_nowww === "kookje.co.kr") {
				return src
					.replace("/thumb/", "/")
					.replace(/.*\/[0-9]+_[0-9]+_([0-9]{4})([0-9]{4})([^/]*)$/, "http://db.kookje.co.kr/news2000/photo/$1/$2/L$1$2$3");
			}
			if (domain_nowww === "joongdo.co.kr" ||
				domain_nowww === "viva100.com") {
				return src.replace(/\/webdata\/+content\/+([0-9]{4}y\/+[0-9]{2}m\/+[0-9]{2}d\/+)crop([0-9]+\.[^/.]+)(?:[?#].*)?$/, "/file/$1$2");
			}
			if (domain === "img.asiatoday.co.kr") {
				newsrc = src.replace(/(\/file\/+.*\/+[0-9]{10,}_)[0-9]+\./, "$11.");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "img.asiatoday.co.kr") {
				match = src.match(/\/[0-9]{4}y\/+[0-9]{2}m\/+[0-9]{2}d\/+([0-9]{15,})_[0-9]+(?:_[0-9]+)?\./);
				if (match) {
					return {
						url: src,
						extra: {
							page: "http://www.asiatoday.co.kr/view.php?key=" + match[1]
						}
					};
				}
			}
			if (domain === "jmagazine.joins.com" ||
				(domain_nowww === "urbanbug.net" && string_indexof(src, "/uploads/") >= 0) ||
				(domain_nowww === "shobiddak.com" && /\/uploads\/+picture\//.test(src)) ||
				(domain_nowww === "celebs-news.ru" && string_indexof(src, "/images/") >= 0)) {
				return src.replace(/\/thumb_([^/]*)$/, "/$1");
			}
			if (domain === "cdn.ppomppu.co.kr" ||
				domain_nowww === "popco.net") {
				return src.replace(/(\/zboard\/+data[0-9]*\/+(?:[^/]*\/+)?[0-9]{4}\/+[0-9]{2}\/*[0-9]{2}\/+)(?:thumb|m)_/, "$1");
			}
			if (domain === "media.codeweavers.com") return src.replace(/\/thumb_([0-9a-f]+\.[^/.]*)(?:[?#].*)?$/, "/$1");
			if (domain === "img.tvreport.co.kr" ||
				domain === "img.tvreportcdn.de") {
				return src.replace(/_[0-9]*(\.[^/.]*)$/, "_0$1");
			}
			if (domain === "ojsfile.ohmynews.com") {
				newsrc = src.replace(/\/STD(_IMG_FILE\/+.*?)_STD(\.[^/.]*)(?:[?#].*)?$/, "/PHT$1_PHT$2");
				if (newsrc !== src)
					return newsrc;
				return src
					.replace(/\/CT_T_IMG\/(.*?)\/([^/]*)_[A-Z]+(\.[^/.]*?)(?:\?.*)?$/, "/ORG_IMG_FILE/$1/$2_ORG$3")
					.replace(/\/[A-Z]*_IMG_FILE\/(.*?)\/([^/]*)_[A-Z]*(\.[^/.]*)(?:\?.*)?$/, "/ORG_IMG_FILE/$1/$2_ORG$3");
			}
			if (domain === "cmsimg.mnet.com" ||
				domain === "cmsimg.global.mnet.com") {
				regex = /(\/clipimage\/.*?[^0-9]\/)[0-9]+\/([0-9]+\/[0-9]+\/[0-9]+\.[^/.]*)$/;
				return [
					src.replace(regex, "$1$2"),
					src.replace(regex, "$11024/$2")
				];
			}
			if (domain === "image.cloud.sbs.co.kr") return src.replace(/_[0-9]*(\.[^/.]*)$/, "$1");
			if ((domain_nosub === "st-hatena.com" && /^cdn-ak-scissors\./.test(domain)) ||
				domain === "cdn-scissors.gigaviewer.com" ||
				domain === "cdn.image.st-hatena.com") {
				newsrc = src.replace(/.*?\/image\/(?:scale|square)\/[^/]*\/[^/]*\/(.*)$/, "$1");
				if (newsrc !== src)
					return decodeURIComponent(newsrc);
			}
			if (domain_nosub === "st-hatena.com" && domain.match(/cdn(?:-[a-z]+)\.[a-z]\.st-hatena\.com/)) {
				return src.replace(/_(?:[0-9]+|m)(\.[^/.]*)$/, "$1");
			}
			if (domain === "nimage.newsway.kr") {
				if (src.match(/[?&]simg=[%/]/)) {
					return decodeURIComponent(src.replace(/\/phpwas\/restmb_idxmake\.php.*?simg=([^&]*).*?$/, "$1"));
				}
			}
			if (domain === "imgsrv.piclick.me") {
				newsrc = src.replace(/\/publish\.php\?(?:.*&)?pid=([0-9]+)(?:[?#].*)?$/, "/cimg/$1.jpg");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/\/cimg\/+[0-9]+x[0-9]+x/, "/cimg/");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/\/cimg\/+N_/, "/cimg/");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nowww === "slate.com") return src.replace(/(\/[^/.]*\.[^/.]*)\.[^/]*$/, "$1");
			if (domain === "img.cinemablend.com" ||
				domain === "img.minq.com") {
				return src.replace(/(:\/\/[^/]*\/)filter:[^/]*\/(.*?)(?:\?[^/]*)?$/, "$1$2");
			}
			if (domain_nowww === "cinemablend.com") {
				if (/\/static\/+images\/+icons\/+/.test(src))
					return {
						url: origsrc,
						bad: "mask"
					};
			}
			if (((domain_nosub === "abcimg.es" && domain.match(/r[0-9]*\.abcimg\.es/)) ||
				domain === "resizer.lasprovincias.es" ||
				domain === "resizer.abc.es" ||
				domain === "resizer.elcorreo.com") &&
				string_indexof(src, "/resizer.php") >= 0) {
				newsrc = src.replace(/.*\/resizer\.php.*?[?&]imagen=([^&]*).*$/, "$1");
				if (newsrc !== src)
					return decodeuri_ifneeded(newsrc);
			}
			if (domain === "resizer.elnortedecastilla.es" ||
				domain === "resizer.ideal.es" ||
				domain === "resizer.nortecastilla.es") {
				if (false) {
					return {
						url: src.replace(/\/+resizer\.php.*?[?&](imagen=[^&]*).*/, "/resizer.php?$1"),
						head_wrong_contentlength: true
					};
				} else {
					return src
						.replace(/:\/\/[^/]*\/+resizer\/+resizer\.php.*?[?&]imagen=\/+deliverty\/+[^/]*\/resources\/+([^&]*).*/, "://foto-cache.elnortedecastilla.es/$1")
						.replace(/^[a-z]+:\/\/[^/]*\/+resizer\/+resizer\.php.*?[?&]imagen=(http[^&]*).*/, "$1");
				}
			}
			if (domain === "vz.cnwimg.com") return src.replace(/\/thumb[a-z]*-[0-9]+x[0-9]+\//, "/");
			if (domain_nowww === "coleman-rayner.com" &&
				string_indexof(src, "/watermark/insertwm.php?") >= 0) {
				return {
					can_head: false,
					url: decodeURIComponent(src.replace(/.*\/watermark\/insertwm\.php.*?[?&]src=([^&]*).*$/, "$1"))
				};
			}
			if (domain === "media.guestofaguest.com") return src.replace(/(:\/\/[^/]*\/)[^/]*\/(wp-content|gofg-media)\//, "$1$2/");
			if (domain === "d3wo5wojvuv7l.cloudfront.net") {
				return src
					.replace(/^[a-z]+:\/\/[^/]+\/+(images\.spreaker\.com\/)/, "http://$1")
					.replace(/(:\/\/[^/]+\/+)t_[^/.]+\/+/, "$1");
			}
			if (domain_nosub === "heartyhosting.com" &&
				domain.match(/i[0-9]*\.heartyhosting\.com/)) {
				return src.replace(/.*?:\/\/[^/]*\//, "http://");
			}
			if (domain === "images.contactmusic.com") {
				newsrc = src.replace(/-cm(\.[^/.]*)$/, "$1");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nowww === "contactmusic.com") {
				var retarray = [];
				newsrc = src.replace(/\/pics\/[a-z]([a-z]?\/)/, "/pics/s$1");
				if (newsrc !== src)
					retarray.push({
						url: newsrc,
						problems: {
							smaller: true
						}
					});
				newsrc = src.replace(/\/pics\/[a-z]([a-z]?\/)/, "/pics/l$1");
				if (newsrc !== src)
					retarray.push({
						url: newsrc,
						problems: {
							watermark: true
						}
					});
				if (retarray.length > 0)
					return retarray;
			}
			if (domain === "d15mj6e6qmt1na.cloudfront.net") return src.replace(/(\/i\/[0-9]*)\/.*/, "$1");
			if (domain === "th.bing.com") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]+\/+th\/+id\/+R\.?[a-f0-9]{30,}\?(?:.*&)?riu=(http[^&]+).*/, "$1");
				if (newsrc !== src)
					return decodeuri_ifneeded(newsrc);
			}
			if ((domain_nosub === "bing.net" && domain.match(/tse[0-9]*\.(?:mm|explicit)\.bing\.net/)) ||
				domain_nosub === "bing.com") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/th[^/]*[?&]rurl=([^&]*).*?$/, "$1");
				if (newsrc !== src)
					return decodeURIComponent(newsrc);
				newsrc = src.replace(/(:\/\/[^/]*)\/th[^/]*[?&]id=([^&]*)&[^/]*$/, "$1/th?id=$2");
				if (newsrc !== src)
					return newsrc;
				if (/\/th\/+id\//.test(src)) {
					newsrc = remove_queries(src, ["w", "h", "rs", "qlt"]);
					if (newsrc !== src)
						return newsrc;
				}
			}
			if (domain === "cdn.4archive.org") return src.replace(/(\/img\/[^/.]{7})m(\.[^/.]*)$/, "$1$2");
			if (domain === "i.4cdn.org" ||
				domain === "i.4pcdn.org") {
				return fillobj_urls(add_extensions(src.replace(/(\/[0-9]*)s(\.[^/.]*)$/, "$1$2")), {
					headers: {
						Referer: ""
					},
					referer_ok: {
						same_domain_nosub: true
					}
				});
			}
			if (domain === "img.4plebs.org" ||
				domain === "img.fireden.net" ||
				domain === "img-lb.fireden.net" ||
				domain === "torako.wakarimasen.moe" ||
				domain_nowww === "thebarchive.com" ||
				domain_nosub === "desu-usergeneratedcontent.xyz" ||
				(domain_nosub === "nyafuu.org" && /^archive-media/.test(domain)) ||
				domain_nowww === "archiveofsins.com") {
				var baseobj_1 = {};
				if (domain_nowww === "thebarchive.com" ||
					domain_nowww === "archiveofsins.com") {
					baseobj_1 = {
						headers: {
							Referer: "https://" + domain + "/"
						}
					};
				}
				newsrc = src.replace(/\/thumb(\/+[0-9]{4}\/+[0-9]{2}\/+[0-9]+)s(\.[^/.]*)(?:[?#].*)?$/, "/image$1$2");
				if (newsrc !== src)
					return fillobj_urls(add_full_extensions(newsrc), baseobj_1);
				baseobj_1.url = src;
				return baseobj_1;
			}
			if (domain === "arch.b4k.co") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]+\/+files\/+([^/]+)\/+thumb\/+[0-9]+\/+[0-9]+\/+([0-9]+s\.[^/.]*)$/, "https://i.4cdn.org/$1/$2");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/^[a-z]+:\/\/[^/]+\/+media\/+([^/]+)\/+thumb\/+[0-9]+\/+[0-9]+\/+([0-9]+)s(\.[^/.]*)$/, "https://arch-img.b4k.co/$1/$2$3");
				if (newsrc !== src)
					return add_full_extensions(newsrc);
			}
			if (domain === "i.warosu.org") return src.replace(/\/thumb\/([0-9]+\/[0-9]+\/[0-9]+)s?(\.[^/.]*)$/, "/img/$1$2");
			if (domain === "ii.yakuji.moe" ||
				domain_nowww === "iichan.hk" ||
				domain_nosub === "2chan.net" ||
				domain_nowww === "kurisa.ch" ||
				domain_nowww === "niuchan.org" ||
				domain_nowww === "nowere.net" ||
				domain_nowww === "ponyach.ru" ||
				domain_nowww === "02ch.su" ||
				domain_nowww === "410chan.org" ||
				domain_nowww === "desuchan.net" ||
				domain_nowww === "ernstchan.xyz" ||
				domain_nowww === "neochan.net" ||
				domain === "gaia.komica1.org" ||
				domain === "aqua.komica.org") {
				newsrc = src.replace(/\/thumb\/([0-9]{5,}(?:-[0-9]+)?)s?(\.[^/.]*)$/, "/src/$1$2");
				if (newsrc !== src)
					return add_full_extensions(newsrc, ["mp4", "webm", "png", "jpg", "jpeg"]);
			}
			if (domain_nowww === "crystal.cafe" ||
				domain === "cdn.syn-ch.com" ||
				domain === "cdn.syn-ch.org" ||
				domain_nowww === "alphachan.org" ||
				(domain_nowww === "zonadelta.net" && string_indexof(src, "/deltachan/") >= 0) ||
				domain_nowww === "wikieat.club" ||
				domain_nowww === "kropyva.ch" ||
				domain_nowww === "lainchan.org" ||
				domain_nowww === "ponychan.net" ||
				domain_nowww === "2-ch.su" ||
				domain_nowww === "2--ch.ru" ||
				domain_nowww === "55chan.org" ||
				domain_nowww === "leftychan.net" ||
				domain_nowww === "anonimageboards.com" ||
				domain_nowww === "lolcow.farm") {
				newsrc = src.replace(/\/thumb\//, "/src/");
				if (newsrc !== src)
					return add_full_extensions(newsrc, ["mp4", "webm", "png", "jpg", "jpeg"]);
			}
			if (domain_nowww === "2ch.hk" ||
				domain_nowww === "2ch.pm" ||
				domain_nowww === "2channel.moe" ||
				domain_nowww === "2ch.rip" ||
				domain_nowww === "dva-ch.net" ||
				domain_nowww === "shisharc.com") {
				return add_extensions(src.replace(/\/thumb\/([0-9]+\/[0-9]+)s(\.[^/.]*)$/, "/src/$1$2"));
			}
			if (domain_nowww === "m2ch.hk") return src.replace(/\/big\/thumb(\/[0-9]+\/[0-9]+)s(\.[^/.]*)$/, "/src/$1$2");
			if (domain_nowww === "neochan.ru") {
				newsrc = src.replace(/:\/\/(?:www\.)?([^/]+\/+[^/]+\/+)thumb\/+/, ":\/\/s.$1");
				if (newsrc !== src) {
					obj = add_extensions_gif(newsrc);
					array_extend(obj, add_extensions_gif(src.replace(/\/thumb\//, "/src/")));
					return obj;
				}
			}
			if (domain_nowww === "soyjak.party") return src.replace(/\/thumb\//, "/src/");
			if (domain === "file.tinnhac.com" ||
				domain === "file.tintuckpop.net" ||
				domain === "media.bongda.com.vn" ||
				domain_nosub === "404content.com" ||
				domain === "image.vtcns.com" ||
				domain === "media.cungcau.vn" ||
				domain === "cdn-storage-tass.cdnvideo.ru" ||
				domain === "cdn-storage-media.tass.ru" ||
				domain === "image.vtc.vn") {
				return src
					.replace(/\/crop\/+[-0-9]+x[-0-9]+\//, "/")
					.replace(/\/resize\/+[-0-9]+x[-0-9]+\//, "/");
			}
			if (domain === "cdn-media.tass.ru") return src.replace(/(:\/\/[^/]+\/+)width\/+[0-9]+_[0-9a-f]+\/+/, "$1");
			if ((domain_nosub === "zadn.vn" && domain.match(/^photo-resize-/)) ||
				domain === "org.photo-resize.mp3.zdn.vn") {
				newsrc = src.replace(/(:\/\/[^/]*\/+)w[0-9]+h[0-9]+(?:_[a-z]+)?\/+/, "$1");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "image.mp3.zdn.vn") return src.replace(/\/thumb\/+[0-9]+_[0-9]+\/+/, "/");
			if (domain_nosub === "zadn.vn" ||
				(domain_nosub === "vov.vn" && domain.match(/images?\.(?:[^/.]*\.)?vov\.vn/)) ||
				domain === "ss-images.catscdn.vn" ||
				domain_nosub === "zdn.vn" ||
				domain === "media.stylenews.vn" ||
				domain === "img.vietnamplus.vn" ||
				domain === "cdnimg.vietnamplus.vn" ||
				(domain_nosub === "baonghean.vn" && domain.match(/^image[0-9]*\./)) ||
				domain === "image.baophapluat.vn" ||
				domain === "image.giaoducthoidai.vn" ||
				domain === "image.laodong.com.vn" ||
				domain === "cdn-images.saostar.vn" ||
				(domain_nosub === "tienphong.vn" && domain.match(/image[0-9]*\.tienphong\.vn/)) ||
				(domain_nosub === "infonet.vn" && /^img[0-9]*/.test(domain)) ||
				domain === "img.giaoduc.net.vn" ||
				domain === "media.laodong.vn") {
				newsrc = src
					.replace(/(:\/\/[^/]*)\/+[wht]p?m?[0-9]+x?(?:_[^/]*)?(?:[0-9]+)?\//, "$1/")
					.replace(/(:\/\/[^/]*)\/+[-0-9]+x[-0-9]+\//, "$1/")
					.replace(/(?:\.ashx)?\?.*$/, "");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "cdn.tuoitre.vn" ||
				domain_nowww === "dantricdn.com" ||
				domain_nowww === "afamilycdn.com" ||
				domain_nosub === "cafebizcdn.vn" ||
				domain_nosub === "sohacdn.com" ||
				domain_nosub === "kenh14cdn.com" ||
				domain === "cafebiz.cafebizcdn.vn" ||
				domain_nosub === "vcmedia.vn" ||
				domain_nosub === "genkcdn.vn" ||
				domain === "icdn.dantri.com.vn" ||
				domain_nosub === "mediacdn.vn") {
				return src
					.replace(/\/zoom\/[^/]*\//, "/")
					.replace(/-[0-9]+-[0-9]+-[0-9]+-[0-9]+-crop-[0-9]+(\.[^/.]*)$/, "$1")
					.replace(/-crop-[0-9]{13,}(\.[^/.]*)$/, "$1")
					.replace(/(:\/\/[^/]*)\/thumb_[a-z]\/[0-9]+\//, "$1/");
			}
			if (domain_nosub === "24hstatic.com" ||
				domain_nosub === "24h.com.vn" ||
				(domain_nosub === "danviet.vn" && domain.match(/^streaming[0-9]*\./)) ||
				(domain_nosub === "eva.vn" && domain.match(/^image(?:-[a-z]+)?\./)) ||
				domain === "anh.eva.vn") {
				if (src.match(/\/upload\/+[0-9]+-[0-9]{4}\/+images\//)) {
					return src
						.replace(/(\/images\/.*)_[0-9]+_[0-9]+(\.[^/.]*)$/, "$1$2")
						.replace(/-watermark(\.[^/.]*)$/, "$1")
						.replace(/-auto-crop-[0-9]+x[0-9]+(\.[^/.]*)$/, "$1")
						.replace(/(\/images\/[0-9]*-[0-9]*-[0-9]*\/)[^/]*\/([^/]*)$/, "$1$2");
				}
			}
			if ((domain_nosub === "yan.vn" && domain.match(/static[0-9]*\.yan\.vn/)) ||
				(domain_nowww === "myzutv.ro" && string_indexof(src, "/uploads/") >= 0) ||
				(domain_nowww === "rainews.it" && string_indexof(src, "/img/") >= 0) ||
				(domain === "a.jeu.cc" && string_indexof(src, "/images/") >= 0) ||
				(domain_nowww === "soyuz.ru" && /\/uploads\/+files\//.test(src)) ||
				(domain_nowww === "mjuznews.com" && string_indexof(src, "/photos/") >= 0)) {
				return src.replace(/\/[0-9]+x[0-9]+_([^/]*)$/, "/$1");
			}
			if (domain_nowww === "raiplay.it") return src.replace(/\/cropgd\/+[0-9]+x[0-9]+\/+/, "/");
			if (domain_nosub === "autoimg.cn") return src.replace(/\/(?:[0-9]+x[0-9]+_(?:[0-9]+_)?|[0-9]+_)([^/]+)(?:[?#].*)?$/, "/$1");
			if (domain_nowww === "xperienceunited.com") {
				return src
					.replace(/(\/userphotos\/+[0-9a-f]+-[0-9]+)-thumbnail([?#].*)?$/, "$1.webp$2")
					.replace(/(\/userphotos\/+[0-9a-f]+-[0-9]+)-[0-9]+\./, "$1.");
			}
			if (domain === "image.thanhnien.vn") {
				return {
					url: src
						.replace(/\?.*/, "")
						.replace(/(:\/\/[^/]*)\/+(?:[0-9]+|c[0-9]+x[0-9]+\/+[0-9]+(?:,[0-9]+){3})\/+(uploaded\/)/i, "$1/$2"),
					can_head: false // hangs?
				};
			}
			if (domain === "images2.thanhnien.vn") {
				return src
					.replace(/(:\/\/[^/]+\/+[0-9]{5,}\/+[0-9]{4}\/+(?:[0-9]{1,2}\/+){2}[^/.]+?)-(?:[0-9]+-){4}crop-[0-9]+\./, "$1.")
					.replace(/(:\/\/[^/]+\/+)(?:zoom\/+[0-9]+_[0-9]+|thumb_[wh]\/+[0-9]+)\/+/, "$1");
			}
			if (domain === "media-local.phunu365.net" ||
				domain === "media-local.mywow.vn") {
				return src.replace(/.*?\/api[0-9]+x[0-9]+\/res\/ext\/[0-9]+x[0-9]+\/[^/]*\//, "http://");
			}
			if ((domain_nosub === "nguoiduatin.vn" && domain.match(/.*media[0-9]*\.nguoiduatin\.vn/)) ||
				domain === "media.doisongphapluat.com" ||
				domain === "media.vietq.vn" ||
				domain_nowww === "baouc.com" ||
				domain === "media.hay.tv" ||
				domain === "media.hotbirthdays.com") {
				return src.replace(/(:\/\/[^/]*)\/[^/]*x[0-9]+x(?:[0-9]+)?\//, "$1/");
			}
			if (domain_nowww === "wowkorea.live" ||
				(domain_nowww === "fotofap.net" && string_indexof(src, "/img/") >= 0) ||
				domain === "images.vfl.ru") {
				return src.replace(/(\/[0-9]*)_[a-z](\.[^/.]*)$/, "$1$2");
			}
			if (domain === "content.erooups.com") return src.replace(/(\/img[0-9]*\/+[0-9]{8}\/+[0-9]+\/+[^/]*)_(?:m|thumb)(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain_nosub === "seoul.co.kr" && domain.match(/img[^.]*\.seoul\.co\.kr/)) {
				return src.replace(/_[A-Z](?:[0-9]){0,2}(\.[^/.]*)$/, "$1");
			}
			if (domain === "img.yonhapnews.co.kr" ||
				domain === "vmg.yonhapnews.co.kr" ||
				(domain_nosub === "yna.co.kr" && domain.match(/^img[0-9]*\./))) {
				var extra = {};
				match = src.match(/\/(PYH[0-9]{17})[0-9]{2}[_.][^/]*(?:[?#].*)?$/);
				if (match) {
					extra.page = "https://www.yna.co.kr/view/" + match[1];
				}
				return {
					url: src
						.replace(/(\/PYH[^/_.]*)_[^/.]*(\.[^/.]*)$/, "$1_P4$2")
						.replace(/(\/A(?:KR|JP|CK|EN)[^/_.]*_[0-9]+_i)_[^/.]*(\.[^/.]*)$/, "$1$2"),
					can_head: false, // 400
					extra: extra
				};
			}
			if (domain_nosub === "yonhapnews.co.kr" && domain.match(/big[0-9]*\.yonhapnews\.co\.kr/)) {
				return src.replace(/.*:\/\/[^/]*\/gate\/[^/]*\//, "http://");
			}
			if (domain_nosub === "bunjang.net") {
				return {
					url: src.replace(/_[wh][0-9]*(\.[^/.]*)$/, "$1"),
					can_head: false // 404
				};
			}
			if (domain === "betanews.heraldcorp.com" ||
				domain_nowww === "betanews.net") {
				return src
					.replace(/(\/imagedb\/(:?[^/]*\/)?)(?:first|thumb)\//, "$1orig/");
			}
			if (domain === "img.smlounge.co.kr") return src.replace(/\/thumb\/([^/.]*)-sample[^/.-]*(\.[^/.]*)$/, "/$1$2");
			if (domain === "img.etoday.co.kr") return src.replace(/(\/pto_db\/+[0-9]{4}\/+[0-9]{2}\/+)[0-9]+\/+([0-9]+_[0-9]+[^/]*)(?:[?#].*)?$/, "$1$2");
			if (domain === "image.tving.com" &&
				string_indexof(src, "tving.com/resize.php") >= 0) {
				return src.replace(/.*:\/\/[^/]*\/resize\.php.*?[?&]u=([^&]*).*/, "$1");
			}
			if (domain === "cdn.pastemagazine.com") {
				return src
					.replace(/(\/[^/]*\/)assets_[^/]*\/[0-9]*\/[0-9]*\/([^-]*)-.*(\.[^/.]*)$/, "$1$2$3")
					.replace(/(\/www\/+system\/+images\/+.*\/)[a-z]+\/+([^/]*)(?:[?#].*)?$/, "$1original/$2");
			}
			if (domain_nowww === "beauty-co.jp") return src.replace(/\/news\/+assets_[^/]*\/+[0-9]{4}\/+[0-9]{2}\/+([^-]*)-.*(\.[^/.]*)$/, "/news/img/$1$2");
			if (domain_nowww === "seichimap.jp") {
				newsrc = src.replace(/(\/[^/]*\/)assets_[^/]*\/+[0-9]{4}\/+[0-9]{2}\/+([^-]*)-.*(\.[^/.]*)$/, "$1pht/$2$3");
				if (newsrc !== src) {
					return add_extensions_upper(newsrc);
				}
			}
			if (domain === "community.pia.jp") return src.replace(/(\/stage_pia)\/+assets_[^/]*\/+[0-9]{4}\/+[0-9]{2}\/+([^-/]*)-.*(\.[^/.]*)$/, "$1/img/$2$3");
			if (domain === "lp.p.pia.jp") return src.replace(/(\/shared\/+materials\/+[-0-9a-f]{10,}\/+)thumbnail(?:[?#].*)?$/, "$1origin.jpg");
			if (domain === "cdn.fashionsnap.com" ||
				domain_nowww === "fashionsnap.com") {
				return src.replace(/:\/\/[^/]*\/collection\/+assets_c\/+([0-9]{4}\/+[0-9]{2}\/+[^/]*)-thumb-[auto0-9]+x[auto0-9]+-[0-9]+(\.[^/.]*)(?:[?#].*)?$/, "://res.fashionsnap.com/image/upload/media2/$1$2");
			}
			if (domain_nowww === "joqr.co.jp") {
				newsrc = src.replace(/(:\/\/[^/]*\/agson\/+)assets_c\/+[0-9]{4}\/+[0-9]{2}\/+([^/]*)-thumb-[auto0-9]+x[auto0-9]+-[0-9]+(\.[^/.]*)(?:[?#].*)?$/, "$1$2$3");
				if (newsrc !== src)
					return add_extensions_upper(newsrc);
			}
			if (domain === "sportiva.shueisha.co.jp") return src.replace(/(:\/\/[^/]+\/+contents\/+entertainment\/+[0-9]{4}\/+)assets_c\/+[0-9]{4}\/+[0-9]{2}\/+([^/]*)-thumb-[auto0-9]+x[auto0-9]+-[0-9]+(\.[^/.]*)(?:[?#].*)?$/, "$1images/$2$3");
			if (domain_nowww === "rooftop1976.com") return src.replace(/(\/news)\/+assets_[^/]*\/+[0-9]{4}\/+[0-9]{2}\/+([^-/]*)-.*(\.[^/.]*)$/, "$1/$2$3");
			if (domain_nowww === "agencyteo.com") {
				return src
					.replace(/-[0-9]*[wh]*(\.[^/.]*)$/, "$1")
					.replace(/(\/download\/[0-9]*\/)[wh]\/[0-9]*\//, "$1");
			}
			if (domain_nosub === "riotpixels.net" && domain.match(/s[0-9]*\.riotpixels\.net/)) {
				return src.replace(/(\/data\/[a-f0-9]*\/[a-f0-9]*\/[^./]*\.[^/.]*)[./].*$/, "$1");
			}
			if ((domain_nosub === "ignimgs.com" ||
				domain_nosub === "ign.com") &&
				(domain.match(/^assets[0-9]*(?:-prd)?\./) ||
					domain.match(/^[^.]*media\./))) {
				newsrc = src.replace(/[?#].*$/, "");
				if (newsrc !== src)
					return newsrc;
				return src.replace(/_(?:[0-9]+[hw]|medium|grande)(\.[^/.]*)$/, "$1");
			}
			if (domain === "i.neoseeker.com" &&
				src.match(/\/size\/[0-9]+x[0-9]+\//)) {
				return src.replace(/\/size\/[0-9]+x[0-9]+\//, "/size/0x0/");
			}
			if (domain === "i.neoseeker.com" &&
				src.match(/\/p\/[0-9]*\/[0-9]*\//)) {
				return src.replace(/_thumb_([^/]*$)/, "_image_$1");
			}
			if (domain === "resource.supercheats.com") return src.replace(/\/library\/(?:(?:[0-9]*[wh])|thumbs)\//, "/library/");
			if (amazon_container === "intergi-phoenix") {
				return src.replace(/\/images\/thumb_large_([^/]*)$/, "/images/$1");
			}
			if (domain_nowww === "primagames.com" ||
				domain_nosub === "rockpapershotgun.com" ||
				domain === "assets.cosplaycentral.com" ||
				domain === "images.eurogamer.net" ||
				domain === "assets.rockpapershotgun.com") {
				return src.replace(/(\/[^/]*\.[^/.]*)\/[A-Z0-9]+\/(?:resize|format|crop|quality)?\/.*$/, "$1");
			}
			if (amazon_container === "assets.primagames.com") {
				return src.replace(/\/_resized\/+(images\/.*\.[^/._?#]+)_[0-9]+x[0-9]+_\.[^/.]+(?:[?#].*)?$/, "/$1");
			}
			if ((domain_nosub === "ixquick.com" ||
				domain_nosub === "startpage.com") &&
				domain.match(/s[0-9]*-[^.]*\./)) {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/+cgi-bin\/+serveimage.*?[?&]url=([^&]*).*?$/, "$1");
				if (newsrc !== src)
					return decodeURIComponent(newsrc);
			}
			if (domain_nowww === "startpage.com") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]+\/+av\/+proxy-image\?(?:.*&)?piurl=([^&]+).*?$/, "$1");
				if (newsrc !== src)
					return decodeuri_ifneeded(newsrc);
			}
			if (host_domain_nowww === "startpage.com" && /\/sp\/+search/.test(options.host_url) && options.element) {
				if (options.element.parentElement && options.element.parentElement.tagName === "DIV") {
					if (options.element.parentElement.classList.contains("image-container")) {
						var imgurl = options.element.parentElement.getAttribute("data-img-click-url");
						if (imgurl !== src)
							return imgurl;
					}
				}
			}
			if (domain === "beta.ems.ladbiblegroup.com") return src.replace(/\/s3\/content\/[0-9]+x[0-9]+\//, "/s3/content/");
			if (domain === "gaia.adage.com") return src.replace(/\/images\/bin\/image\/[^/]*\//, "/images/bin/image/");
			if (domain === "t-eska.cdn.smcloud.net") return src.replace(/\/[^/]*?n-([^/]*)$/, "/n-$1");
			if (domain === "cdn.wegow.com") return src.replace(/\.[-0-9]*x[-0-9]*(\.[^/.]*)$/, "$1");
			if (domain_nowww === "ecestaticos.com") return src.replace(/\/clipping\/[0-9]*\//, "/clipping/0/");
			if (domain_nowww === "sonarreykjavik.com" ||
				domain_nowww === "gamer.ru" ||
				domain_nosub === "linode.com" ||
				domain === "img.noritter.com" ||
				domain_nowww === "esportivo.net" ||
				domain_nowww === "pvgroup.ru" ||
				domain_nowww === "leit.is" ||
				domain_nowww === "rovina-project.eu" ||
				domain_nowww === "mmorpg.org.pl" ||
				domain_nowww === "girlspolish.jp" ||
				domain_nowww === "joah-girls.com" ||
				domain === "listas.eleconomista.es" ||
				domain_nowww === "gonintendo.com" ||
				(domain_nowww === "gozzip.id" && /\/BlogBody\/+photos\//.test(src)) ||
				domain_nowww === "greasyfork.org" ||
				domain === "static.themezy.com" ||
				domain === "static.vecteezy.com" ||
				domain_nowww === "hairhapi.com" ||
				domain_nowww === "babyfashion.me" ||
				domain === "cdn-learn.adafruit.com" ||
				domain_nowww === "advocate-art.com" ||
				domain === "d34gglw95p9zsk.cloudfront.net" ||
				domain_nowww === "sonar.es") {
				return src
					.replace(/(\/attached_images\/+[0-9]+\/+)[a-z]+\/+/, "$1original/")
					.replace(/(\/system\/+resources\/+)thumbnails\/+/, "$1previews/")
					.replace(/(\/(?:(?:system|images)\/+)?(?:(?:attached|item)_images|App\/+BlogBody|post_pictures|events|posts|items|articles|file_uploads|screenshots|resources|pictures|guides|Image|item_cocreco_images)\/+(?:(?:images|photos|files|assets|pictures|posters|uploads|screenshots|previews|imgs|cropped_images)\/+)?(?:[0-9]{3}\/+){3})[a-z_0-9]+\/+/, "$1original/");
			}
			if (domain === "pgw.udn.com.tw") return src.replace(/.*\/photo\.php.*?[?&]u=([^&]*).*/, "$1");
			if (domain === "uc.udn.com.tw") {
				return {
					url: src,
					can_head: false
				};
			}
			if ((domain_nosub === "hdslb.com" && domain.match(/i[0-9]*\.hdslb\.com/)) ||
				domain === "img.xiaohongshu.com" ||
				(domain_nosub === "xiaoka.tv" && domain.match(/alcdn\.img\.xiaoka\.tv/))) {
				if (/:\/\/[^/]+\/+bfs\/+videoshot\/+[0-9]+\.[^/]+(?:[?#].*)?$/.test(src)) {
					return {
						url: src,
						bad: "mask"
					};
				}
				return src
					.replace(/(:\/\/[^/]*\/)[0-9]+_[0-9]+\//, "$1")
					.replace(/(\.[^/.]*)@[_0-9a-zQ]*(?:\.[^/.]*)?$/, "$1")
					.replace(/(\/[0-9a-f]{20,}\.[^/._]+)_[0-9]+x[0-9]+\.[^/]+(?:[?#].*)?$/, "$1");
			}
			if (domain === "d.ifengimg.com") return src.replace(/.*?\/[a-z]+[0-9]*(?:_[whq][0-9]*)?\//, "http://");
			if (domain_nowww === "nationalgeographic.com") return src.replace(/\.[^/]*(\.[^/.]*)$/, "$1");
			if (domain === "media.mnn.com" ||
				domain_nowww === "alljapantours.com" ||
				domain === "shows.gqimg.com.cn" ||
				domain === "shows.vogueimg.com.cn" ||
				(domain_nosub === "webcollage.net" && string_indexof(domain, "media.webcollage.net") >= 0) ||
				domain_nowww === "metronews.ca" ||
				domain === "images.meredith.com" ||
				domain === "img-cdn.jg.jugem.jp" ||
				domain_nowww === "anime-thai.net" ||
				domain_nowww === "mymypic.net" ||
				domain_nowww === "styleyen.com" ||
				domain_nowww === "nbstr.org" ||
				(domain_nosub === "forbiddenplanet.com" && domain.match(/^dyn[0-9]*\.media\.forbiddenplanet\.com/)) ||
				domain === "media.treehugger.com" ||
				(domain_nowww === "attitude.co.uk" && string_indexof(src, "/media/images/") >= 0) ||
				domain === "media.allyou.net" ||
				domain === "image.pbs.org" ||
				(domain_nowww === "plasticsurgerystar.com" && string_indexof(src, "/images/") >= 0) ||
				(domain_nowww === "peoplite.com" && string_indexof(src, "/public/album_photo/") >= 0) ||
				(domain === "cdn.admireme.vip" && string_indexof(src, "/media/") >= 0) ||
				(domain_nosub === "globo.com" && string_indexof(src, "/fotos/") >= 0) ||
				domain === "d26oc3sg82pgk3.cloudfront.net" ||
				(domain_nowww === "memberme.net" && string_indexof(src, "/media/") >= 0) ||
				(domain_nowww === "funasia.net" && string_indexof(src, "/site_media/") >= 0) ||
				domain === "image.photocnc.com" ||
				domain === "d53l9d6fqlxs2.cloudfront.net") {
				newsrc = src.replace(/(\/[^/.]*\.[^/.]*)\.[^/]*$/, "$1");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "media.contentapi.ea.com") {
				newsrc = src.replace(/(\/[^/.]*\.[^/.]*)\.[^/]*$/, "$1");
				if (newsrc !== src)
					return {
						url: newsrc,
						can_head: false
					};
			}
			if (domain === "img.bleacherreport.net") {
				return src
					.replace(/\/crop_exact_([^/]*)$/, "/$1")
					.replace(/\?.*$/, "?w=999999999999&h=999999999999");
			}
			if (domain === "images.gr-assets.com") {
				return src
					.replace(/(\/(?:authors|users)\/[0-9]*p)[0-9]\//, "$18/")
					.replace(/(\/books\/[0-9]*)[a-z]\//, "$1l/");
			}
			if (domain === "dynamic.indigoimages.ca") return src.replace(/(\?.*)?$/, "?width=999999999");
			if (domain === "cdn.mos.cms.futurecdn.net") return src.replace(/-[0-9]+-[0-9]+(\.[^/.]*(?:\.webp)?)(?:[?#].*)?$/, "$1");
			if (domain === "www.allkpop.com") return src.replace(/\/af\/([0-9]*\/[^/]*)$/, "/af_org/$1");
			if (domain === "cwcontent.asiae.co.kr") {
				return src
					.replace(/^(.*?:\/\/).*\/[^/]*resize\/[0-9]*\/([^/]*)$/, "$1cphoto.asiae.co.kr/listimglink/4/$2");
			}
			if (domain === "cphoto.asiae.co.kr") {
				return src
					.replace(/\/listimglink\/[0-9]*\//, "/listimglink/4/")
					.replace(/\/resizeimglink\/[0-9]*\//, "/listimglink/4/")
					.replace(/\/listimg_link\.php.*?[?&]no=([^&]*).*?$/, "/listimg_link.php?idx=4&no=$1");
			}
			if (domain === "thumbs-prod.si-cdn.com") return src.replace(/.*\/(https?:\/\/)/, "$1");
			if (domain === "assets.atlasobscura.com") return src.replace(/\/article_images\/[0-9]*x\//, "/article_images/");
			if (domain_nowww === "wonderopolis.org" && string_indexof(src, "/_img") >= 0) {
				newsrc = src.replace(/\/_img\?(?:.*&)?(img=[^&]*).*/, "/_img?$1");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/+_img\?img=([^&]*).*?$/, "$1");
				if (newsrc !== src)
					return urljoin(src, newsrc, true);
			}
			if (domain_nowww === "thehindu.com" ||
				domain_nowww === "gloria.hr" ||
				((domain_nosub === "mirror.co.uk" ||
					domain_nosub === "birminghammail.co.uk" ||
					domain_nosub === "dailypost.co.uk" ||
					domain_nosub === "bristolpost.co.uk" ||
					domain_nosub === "irishmirror.ie" ||
					domain_nosub === "coventrytelegraph.net" ||
					domain_nosub === "dublinlive.ie") &&
					domain.match(/i[0-9]*(?:-prod)?\./)) ||
				domain_nowww === "mirror.co.uk" ||
				domain === "beta.images.theglobeandmail.com" ||
				domain_nowww === "globalblue.com" ||
				(domain_nosub === "belfasttelegraph.co.uk" && domain.match(/^(?:cdn(-[0-9]+)?|www)\./)) ||
				domain_nowww === "ladylike.gr" ||
				domain_nowww === "24horas.cl" ||
				domain_nowww === "jyllands-posten.dk" ||
				domain_nowww === "svtstatic.se" ||
				domain_nowww === "adressa.no" ||
				domain_nowww === "miamiherald.com" ||
				domain_nowww === "filmweb.no" ||
				domain_nowww === "kansascity.com" ||
				domain_nowww === "sanluisobispo.com" ||
				domain_nowww === "star-telegram.com" ||
				domain_nosub === "jutarnji.hr" ||
				domain_nowww === "oneman.gr" ||
				domain_nowww === "th.thgim.com" ||
				domain_nowww === "thehindubusinessline.com" ||
				domain === "d30fl32nd2baj9.cloudfront.net" ||
				domain_nowww === "elsoldepuebla.com.mx" ||
				domain_nowww === "svensktnaringsliv.se" ||
				(domain_nosub === "jyllands-posten.dk" && /\/pictures\/+image\/+[0-9]+\//.test(src)) ||
				src.match(/\/(?:article[0-9]+\.(?:ece|svt)|[0-9a-z]+\/+picture[0-9]{4,})\/+(?:[^/]*\/)?alternates\//i) ||
				src.match(/:\/\/i[0-9]*(?:-prod)?\..*\/article[^/]*\.(?:ece|svt)\//i)
			) {
				newsrc = src.replace(/(?:alternates|autocrop|binary)\/+[^/]*\/+([^/]*)$/i, "BINARY/$1");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/\/representations\/+[^/]*\/+([^/]*)(?:[?#].*)?$/i, "/BINARY/$1");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nowww === "ekstrabladet.dk") return src.replace(/\/IMAGE_ALTERNATES\/+[^/]*\/+/, "/IMAGE_BINARY/original/");
			if (domain_nowww === "tvn.pl") return src.replace(/\/alternates\/+[A-Z]+_[0-9]+(\/.*)?$/, "/BINARY$1");
			if (domain === "images.fandango.com" ||
				domain_nowww === "statf.com") {
				newsrc = src.replace(/\/ImageRenderer\/.*?\/images\//, "/images/");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "images.fandango.com") return src.replace(/_[0-9]+x[0-9]+(\.[^/.]*)(?:[?#].*)?$/, "$1");
			if (amazon_container === "assets.forward.com") {
				return src.replace(/.*:\/\/[^/]*\//, "http://");
			}
			if (domain === "assets.forward.com" ||
				domain === "assets.forwardcdn.com") {
				return src.replace(/\/images\/cropped\//, "/images/");
			}
			if (domain_nowww === "thejewelleryeditor.com") return src.replace(/\/images_thumbnails\/+[^/]*_thumbnails\/+([^/]*\/+[0-9]*\/+[^/.]*\.[^_/.]*)__[^/]*(?:[?#].*)?$/, "/images/$1");
			if (domain_nowww === "sass.com.ua" ||
				domain === "media.globalcitizen.org" ||
				(domain_nowww === "kexp.org" && /:\/\/[^/]+\/+media\//.test(src)) ||
				domain === "bento.cdn.pbs.org") {
				return src.replace(/\/(?:filer_)?(?:public_)?thumbnails\/+(.*\/[^/]*?\.[a-z]+)__[^/]*(?:[?#].*)?$/, "/$1");
			}
			if (domain === "files.sharenator.com") return src.replace(/(:\/\/[^/]*\/)[^/.]+-s[0-9]+x[0-9]+-([0-9]{4,})(?:-[0-9]*)?(\.[^/.]*)$/, "$1$2$3");
			if (domain === "cdn.jolie.de" ||
				domain === "cdn.maedchen.de") {
				return src.replace(/\/image[0-9]*[wh]\//, "/original/");
			}
			if (domain === "img.mp.itc.cn" ||
				(domain_nowww === "wallpapercraze.com" && string_indexof(src, "/images/wallpapers/") >= 0) ||
				domain === "img.mp.sohu.com") {
				return src.replace(/_th(\.[^/.]*)$/, "$1");
			}
			if (domain_nosub === "qpic.cn" ||
				domain === "wx.qlogo.cn") {
				if (src.match(/\/mblogpic\//))
					return {
						url: src.replace(/\/[0-9]*(?:\.[^/.]*)?(?:\?.*)?$/, "/2000"),
						headers: {
							Referer: "" // if not, it redirects to t100.qpic.cn, which doesn't work
						}
					};
				return src.replace(/\/[0-9]*(?:\.[^/.]*)?(?:\?.*)?$/, "/0");
			}
			if ((domain_nosub === "49qmz.com" ||
				domain_nosub === "ii77.com" ||
				domain_nosub === "vhaor.com")
				&& domain.match(/^img[0-9]*\./)) {
				return src.replace(/:\/\/[^/]*\/mmbiz_jpg\//, "://mmbiz.qpic.cn/mmbiz_jpg/");
			}
			if (domain_nowww === "vod.lu" && /\/media\/+cache\//.test(src)) {
				return src.replace(/\/media\/+cache\/+(?:resolve\/+)?[0-9]+x[0-9]+\/+/, "/media/");
			}
			if (domain_nowww === "vogue.ua") {
				return src
					.replace(/\/media\/+cache\/+resolve\//, "/cache/")
					.replace(/\/cache\/+[^/]+\/+(uploads?)\//, "/$1/");
			}
			if (domain_nosub === "blogspot.es") return src.replace(/(?:\/media)?\/+cache\/+(?:resolve\/+)?media\/+files\//, "/files/");
			if (domain === "csn.naekranie.pl") return src.replace(/\/media\/+cache\/+(?:resolve\/+)?[^/]*\/+([0-9]{4}\/+[0-9]{2}\/+)/, "/wp-content/uploads/$1");
			if (domain === "imagesvc.timeincuk.net" ||
				domain === "imagesvc.meredithcorp.io") {
				return decodeuri_ifneeded(src.replace(/^[a-z]+:\/\/[^/]*\/v3\/+[a-z]+\/+image.*?[?&]url=([^&]*).*/, "$1"));
			}
			if (domain === "img.timeinc.net") return src.replace(/\/[0-9]+_([^/_]+_[0-9]+(?:_[^/]*)?\.[^/.]*)$/, "/$1");
			if (domain === "i.ksd-i.com") return src.replace(/^[a-z]+:\/\/[^/]*\/+s\/+[0-9]+_[0-9]+_[0-9a-f]+\/+/, "http://");
			if (domain === "a.ksd-i.com") return src.replace(/.*:\/\/[^/]*\/s\/[^/]*\//, "http://");
			if (domain === "static.koreastardaily.com") return src.replace(/.*:\/\/[^/]*\/([0-9]+-[0-9]+-[0-9]+\/[0-9]+-[0-9]+\.[^/.]*)$/, "https://a.ksd-i.com/a/$1");
			if (domain === "pic.pimg.tw") {
				return src
					.replace(/\/[a-z]+_([0-9a-f]+\.[^/.]*)(?:[?#].*)?$/, "/$1")
					.replace(/_w?[a-z](\.[^/]*)$/, "$1");
			}
			if (domain === "imageproxy.pimg.tw") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/+(?:zoomcrop|resize)\?(?:.*?&)?url=([^&]*).*?$/, "$1");
				if (newsrc !== src)
					return decodeuri_ifneeded(newsrc);
			}
			if (domain === "images.sidearmdev.com") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/+resize\?(?:.*?&)?url=([^&]*).*?$/, "$1");
				if (newsrc !== src)
					return decodeuri_ifneeded(newsrc);
			}
			if (domain_nowww === "helloidol.com" &&
				string_indexof(src, "/script/get_pic.php") >= 0) {
				return src.replace(/.*\/script\/get_pic\.php.*?[?&]src=([^&]*).*?$/, "$1");
			}
			if (domain === "yams.akamaized.net" &&
				string_indexof(src, "/Assets/") >= 0) {
				return src.replace(/\/(?:[^/._]*_)?([^/_]*)$/, "/l_$1");
			}
			if (domain_nosub === "pixpo.net" && domain.match(/img[0-9]\.pixpo\.net/)) {
				return src.replace(/_t[0-9]+x[0-9]+(\.[^/.]*)$/, "$1");
			}
			if (domain === "www.mirrormedia.mg" &&
				string_indexof(src, "/assets/images/") >= 0) {
				return src.replace(/-desktop(\.[^/.]*)$/, "$1");
			}
			if (domain_nosub === "kknews.cc" && domain.match(/i[0-9]*\.kknews\.cc/)) {
				return src.replace(/_[a-z]*(\.[^/.]*)$/, "$1");
			}
			if (domain === "resource.holyshare.com.tw") return src.replace(/\/article\/[0-9]*x[0-9]*\//, "/article/");
			if (domain_nowww === "kyeongin.com") {
				var extra = {};
				match = src.match(/^[a-z]+:\/\/[^/]+\/+mnt\/+[^/]+\/+[0-9]{6}\/+([0-9]{17})(?:_[0-9]+)?\.[^/.]+(?:[?#].*)?$/);
				if (match) {
					extra.page = "http://www.kyeongin.com/main/view.php?key=" + match[1];
				}
				regex = /\/mnt\/+(?:thum|file(?:_[a-z]+)?)\/+/;
				if (regex.test(src)) {
					return [
						{
							url: src.replace(regex, "/mnt/org/"),
							extra: deepcopy(extra)
						},
						{
							url: src.replace(regex, "/mnt/file/"),
							extra: deepcopy(extra)
						}
					];
				} else {
					return {
						url: src,
						extra: extra
					};
				}
			}
			if (domain_nowww === "wallpaperup.com") return src.replace(/-[0-9]+(\.[^/.]*)$/, "$1");
			if ((domain_nosub === "wallhere.com" ||
				domain_nosub === "pxhere.com") &&
				domain.match(/^[a-z]*\./)) {
				return src
					.replace(/[a-z]*\.wallhere\.com/, "get.wallhere.com")
					.replace(/[a-z]*\.pxhere\.com/, "get.pxhere.com")
					.replace(/\/(?:photos|images)\/[0-9a-f]*\/[0-9a-f]*\/([^/.]*\.[^/.!]*).*?$/, "/photo/$1")
					.replace(/\/[0-9]+x[0-9]+-px-([^/]*)$/, "/$1")
					.replace(/-[0-9]+x[0-9]+-px-([0-9]+\.[^/.]*)$/, "-$1");
			}
			if (domain === "img.grouponcdn.com") {
				return src.replace(/\/v[0-9]+\/[^/]*$/, "");
			}
			if ((domain_nosub === "goodfon.com" ||
				domain_nosub === "goodfon.ru" ||
				domain_nosub === "badfon.ru") &&
				domain.match(/^img[0-9]*\./)) {
				newsrc = src.replace(/(:\/\/[^/]*\/)[^/]*\/[^/]*\//, "$1wallpaper/original/");
				if (newsrc !== src)
					return newsrc;
				if (/\.webp(?:[?#].*)?$/.test(src))
					return src.replace(/\.webp(?:[?#].*)?$/, ".jpg");
			}
			if (domain_nosub === "greatfon.com" && domain.match(/^cdn[0-9]*\./)) {
				return src.replace(/(\/uploads\/+picture\/.*\/)thumbs_([^/]*)(?:[?#].*)?$/, "$1$2");
			}
			if ((domain_nosub === "yimg.jp" && string_indexof(domain, ".c.yimg.jp") >= 0) &&
				src.match(/:\/\/[^/]*\/im_/)) {
				return src.replace(/(:\/\/[^/]*\/)im_[^/]*\//, "$1");
			}
			if ((domain_nosub === "yimg.jp" && string_indexof(domain, ".c.yimg.jp") >= 0) &&
				src.match(/:\/\/[^/]*\/sim\?/)) {
				return src.replace(/.*:\/\/[^/]*\/sim.*?[?&]furl=([^&]*).*/, "http://$1");
			}
			if ((domain_nosub === "yimg.jp" && string_indexof(domain, ".c.yimg.jp") >= 0) &&
				src.match(/\/Images\/(?:[a-z]_)?[0-9]+(\.[^/]*)$/)) {
				return src.replace(/\/Images\/(?:[a-z]_)?([0-9]+\.[^/.]*)$/, "/Images/f_$1");
			}
			if (domain_nosub === "yimg.jp" && string_indexof(domain, ".c.yimg.jp") >= 0 &&
				src.match(/:\/\/[^/]*\/yjimage\?/)) {
				return keep_queries(src, ["q", "sig"]);
			}
			if (domain_nosub === "yimg.jp" && string_indexof(domain, ".c.yimg.jp") >= 0) {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]+\/+i\/+([^/]+\.yimg\.jp\/+[^?#]+)(?:[?#].*)?$/, "https://$1");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nosub === "yimg.jp" && string_indexof(domain, ".c.yimg.jp") >= 0 &&
				(/:\/\/[^/]*\/r\/+iwiz-amd\//.test(src) || /:\/\/[^/]+\/+i\/+/.test(src))) {
				return {
					url: src.replace(/\?.*$/, ""),
					can_head: false // 404
				};
			}
			if (domain === "av.watch.impress.co.jp") return src.replace(/(\/[0-9]+)_s(\.[^/.]*)$/, "$1_o$2");
			if (domain === "internet.watch.impress.co.jp" ||
				domain === "pc.watch.impress.co.jp") {
				return src.replace(/(\/[0-9]+)_s(\.[^/.]*)$/, "$1$2");
			}
			if (domain === "media.image.infoseek.co.jp") return src.replace(/-[a-z]*(\.[^/.]*)$/, "$1");
			if (domain === "bundles.sfd.pl") return src.replace(/(\/SFD\/+[0-9]{4}\/+[0-9]+\/+[0-9]+\/+[0-9a-f]{10,})-small(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain === "s.eximg.jp") return src.replace(/(_[0-9]+)_s(\.[^/.]*)$/, "$1$2");
			if (domain === "imgc.eximg.jp") {
				newsrc = src.replace(/.*?\/i=([^,&]*).*?$/, "$1");
				if (newsrc !== src)
					return decodeuri_ifneeded(newsrc);
				newsrc = src.replace(/.*?\/cv\/+(?:resize|trim)\?i=([^&]*).*?$/, "$1");
				if (newsrc !== src)
					return decodeuri_ifneeded(newsrc);
			}
			if (domain === "image.itmedia.co.jp" &&
				!src.match(/\/l_[^/]*$/) &&
				!src.match(/\/[0-9]+_[^/]*$/)) {
				return src.replace(/\/([^/]*)$/, "/l_$1");
			}
			if (domain_nosub === "bigcommerce.com" && domain.match(/cdn[0-9]*\.bigcommerce\.com/)) {
				newsrc = src.replace(/\/images\/+stencil\/+[0-9]+(?:x[0-9]+|w)\//, "/images/stencil/original/");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/\/products\/+([0-9]+)\/+images\/+([0-9]+)\/+(.*\.[0-9]{8,})(?:\.[0-9]+\.[0-9]+)?(\.[^/.]*)(?:[?#].*)?$/, "/images/stencil/original/products/$1/$2/$3$4");
				if (newsrc !== src)
					return newsrc;
				return {
					url: src,
					head_wrong_contentlength: true
				};
			}
			if (domain_nosub === "behance.net") {
				return [
					{
						url: src.replace(/(\/project(?:_modules|s)\/+)[^/]*\//, "$1source/"),
						is_original: true
					},
					src.replace(/(\/project(?:_modules|s)\/+)[^/]*\//, "$1fs/")
				];
			}
			if (domain === "www.worldatlas.com") return src.replace(/(:\/\/[^/]*\/)r\/[^/]*\/(upload\/)/, "$1$2");
			if (domain_nosub === "thrillist.com" && domain.match(/assets[0-9]*\.thrillist\.com/)) {
				return src.replace(/(:\/\/[^/]+\/+v1\/+image\/+[0-9]+)(?:\/.*)?(?:[?#].*)?$/, "$1");
			}
			if (domain_nowww === "vacationidea.com" &&
				string_indexof(src, "/pix/") >= 0) {
				return src.replace(/_mobi(\.[^/.]*)$/, "$1");
			}
			if (domain_nosub === "quoracdn.net") {
				return src
					.replace(/(\/main-)thumb-([0-9]+-)[0-9]+-([a-z]{10,}\.)/, "$1raw-$2$3")
					.replace(/(\/main-qimg-[0-9a-f]{10,})-(?:[a-z]|(?:pj)?lq)$/, "$1");
			}
			if (domain_nosub === "haibao.cn" && domain.match(/c[0-9]*\.haibao\.cn/)) {
				newsrc = src.replace(/:\/\/[^/]*\/(.*)\/+imagecut\/+[0-9]+_[0-9]+\/+/, "://c3.haibao.cn/$1/");
				if (newsrc !== src) {
					return {
						url: newsrc,
						can_head: false
					};
				}
			}
			if (domain.match(/c[0-9]*\.haibao\.cn/)) {
				newsrc = src.replace(/:\/\/[^/]*\/img\/+[0-9]+(?:_[0-9]+){3}\//, "://c4.haibao.cn/img/0_0_0_0/");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nosub === "hbimg.cn" && domain.match(/cdn[0-9]*\.hbimg\.cn/)) {
				return {
					url: src.replace(/\/(?:thumbs|tuku|snsthumbs)\/[0-9]+(?:_[0-9]+)\//, "/wm/"),
					problems: {
						watermark: true
					}
				};
			}
			if (domain_nowww === "wallpaperset.com") return src.replace(/(:\/\/[^/]*\/w\/)[^/]*\//, "$1full/");
			if (domain_nosub === "wallpapermania.eu") {
				newsrc = src
					.replace("://static.wallpapermania.eu/", "://www.wallpapermania.eu/")
					.replace(/\/images\/[a-z]?thumbs\//, "/images/data/")
					.replace(/\/download\/([^/]*)\/([0-9]*)\/([^/.]*)_[0-9]+x[0-9]+(\.[^/.]*)$/, "/images/data/$1/$2_$3$4");
				if (newsrc !== src) {
					var referer = newsrc.replace(/.*\/[0-9]+_([^/.]*)(?:_[0-9]+x[0-9]+)?\.[^/.]*$/, "http://www.wallpapermania.eu/wallpaper/$1");
					return {
						url: newsrc,
						headers: {
							"Referer": referer
						}
					};
				}
			}
			if (domain === "img-aws.ehowcdn.com" ||
				domain === "img.aws.ehowcdn.com" ||
				domain === "img.aws.livestrongcdn.com" ||
				domain === "img-aws.livestrongcdn.com") {
				/*newsrc = src.replace(/.*?:\/\/[^/]*\/[0-9]+x[0-9]+p\//, "http://")
				if (newsrc !== src) {
					return newsrc;
				}*/
				newsrc = src
					.replace(/(:\/\/[^/]*\/)[^/]*\//, "$1default/");
				if (newsrc !== src) {
					return newsrc;
				}
				newsrc = src.replace(/.*?:\/\/[^/]*\/.*?\/(photos\.demandstudios\.com\/)/, "http://$1");
				if (newsrc !== src) {
					return newsrc;
				}
				newsrc = src.replace(/.*?:\/\/[^/]*\/[^/]*\/ehow-([^-/.]*)-blog-([^/.]*)\//, "http://$1-ehow-com.blog.ehow.com/");
				if (newsrc !== src) {
					return newsrc;
				}
				newsrc = src.replace(/.*?:\/\/[^/]*\/.*?\/www_ehow_com\/([^/.]*\.[^/]*)\//, "http://$1/");
				if (newsrc !== src) {
					return newsrc;
				}
				newsrc = src.replace(/.*?:\/\/[^/]*\/[^/]*\/s3\.amazonaws\.com\//, "https://s3.amazonaws.com/");
				if (newsrc !== src) {
					return newsrc;
				}
			}
			if (amazon_container === "cme_public_images") {
				newsrc = src.replace(/.*?:\/\/[^/]*\/.*?\/(photos\.demandstudios\.com\/)/, "http://$1");
				if (newsrc !== src) {
					return newsrc;
				}
			}
			if (domain === "imageproxy.themaven.net") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]+\/+(?:[0-9]+x[0-9]+\/+)?(http)/, "$1");
				if (newsrc !== src) {
					return decodeURIComponent(newsrc.replace(/\?.*/, ""));
				}
			}
			if ((domain_nosub === "demandstudios.com" && domain.match(/photos[0-9]*\.demandstudios\.com/)) &&
				string_indexof(src, "/dm-resize/") >= 0) {
				return decodeURIComponent(src.replace(/.*?\/dm-resize\/([^/?]*).*/, "http://$1"));
			}
			if (domain_nosub === "demandstudios.com" && domain.match(/photos[0-9]*\.demandstudios\.com/)) {
				return src.replace(/(\/[0-9]+)_XS(\.[^/.]*)$/, "$1$2");
			}
			if (domain_nosub === "abcnews.com") return src.replace(/_[0-9]+x[0-9]+[a-z]?_[0-9]+(\.[^/.]*)$/, "$1");
			if (domain_nowww === "nationmultimedia.com") return src.replace(/-[^/.]*(\.[^/.]*)$/, "$1");
			if (domain_nosub === "indiatimes.com" ||
				domain === "img.etimg.com" ||
				domain === "etimg.etb2bimg.com" ||
				domain === "telugu.samayam.com" ||
				domain === "static.langimg.com" ||
				domain_nosub === "timesofindia.com" ||
				domain_nosub === "vijaykarnataka.com" ||
				domain_nowww === "businessinsider.in" ||
				domain === "static.toiimg.com") {
				obj = {
					url: src,
					head_wrong_contentlength: true
				};
				newsrc = src.replace(/(:\/\/[^/]*\/)thumb\//, "$1photo/");
				if (newsrc !== src) {
					obj.url = newsrc;
					return obj;
				}
				newsrc = src.replace(/\/(?:thumb|photo)\/[^/]*msid-([0-9]*)[,/].*$/, "/photo/$1.cms");
				if (newsrc !== src) {
					obj.url = newsrc;
					return obj;
				}
				newsrc = src.replace(/\/(?:thumb|photo)\/(?:[^/]*\/)?([0-9]*)\.[^/.]*$/, "/photo/$1.cms");
				if (newsrc !== src) {
					obj.url = newsrc;
					return obj;
				}
			}
			if (domain === "opt.toiimg.com") return src.replace(/\/recuperator\/+img\/+toi\/+m-([0-9]+)(?:,[^/]*)\/+.*/, "/recuperator/img/toi/$1.cms");
			if (domain_nowww === "jawapos.com") return src.replace(/\/thumbs\/+[^/]*\//, "/uploads/");
			if (domain_nowww === "tnnthailand.com") return src.replace(/\/media\/+[^/]+\/+([^/]+)(?:[?#].*)?$/, "/media/$1");
			if ((domain_nosub === "ibtimes.co.in" ||
				domain_nosub === "ibtimes.sg") &&
				domain.match(/data[0-9]*\.ibtimes\./)) {
				return src
					.replace(/(:\/\/[^/]*\/)cache-img-[0-9]*-[0-9]*(?:-photo)?\//, "$1")
					.replace(/\/[a-z]*(\/[0-9]+\/[^/]*)$/, "/full$1")
					.replace(/\?.*$/, "");
			}
			if (amazon_container === "astro-image-resizer" ||
				domain_nosub === "astro.com.my") {
				return src
					.replace(/:\/\/(?:astro-image-resizer\.([^.]*\.)?amazonaws\.com|static[0-9]*\.astro\.com\.my)\/+/, "://astrokentico.s3.amazonaws.com/")
					.replace(/(:\/\/s3[^/.]*\.amazonaws\.com\/+)astro-image-resizer\//, "://astrokentico.s3.amazonaws.com/")
					.replace(/(:\/\/[^/]*)\/[0-9]*\/+resize\//, "$1/")
					.replace(/\/[0-9]+x[0-9]+_/, "/");
			}
			if ((amazon_container && string_indexof(amazon_container, "nxs-wkrgtv-media") >= 0) ||
				(domain_nosub === "win4000.com" && domain.match(/^pic[0-9]*\.win4000\.com/)) ||
				domain === "media.fox29.com" ||
				domain === "media.foxla.com" ||
				domain === "sharedmedia.grahamdigital.com" ||
				(domain === "pic.sucaibar.com" && src.match(/\/pic\/+[0-9]{6}\/+/)) ||
				domain === "mediaassets.wxyz.com") {
				newsrc = src.replace(/_[0-9]+_[0-9]+(\.[^/.]*)$/, "$1");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nosub === "win4000.com" && domain.match(/^pic[0-9]*\./)) {
				return src.replace(/\?down$/, ""); // removes forced downloading
			}
			if (domain === "bobcat.grahamdigital.com") return src.replace(/^[a-z]+:\/\/[^/]*\/image\/+upload\/+view.*?[?&]url=([^&]*).*?$/, "$1");
			if ((domain === "image.photohito.k-img.com" ||
				domain === "photohito.k-img.com") &&
				string_indexof(src, "/uploads/") >= 0) {
				return src.replace(/_[a-z]*(\.[^/]*)/, "_o$1");
			}
			if (domain === "eiga.k-img.com") {
				return src
					.replace(/(\/images\/+movie\/+[0-9]+\/+gallery\/+[0-9]+)\./, "$1_large.")
					.replace(/(\/images\/+[a-z]+\/+(?:[a-z]+\/+)?[0-9]+\/)[0-9]+x(?:[0-9]+)?(\.[^/.]*)$/, "$1original$2")
					.replace(/(\/images\/+[a-z_]+\/+(?:[a-z]+\/+)?[0-9]+\/(?:[a-z]+\/)?[0-9a-f]+)\/[0-9]+(\.[^/.]*)$/, "$1$2");
			}
			if (domain === "akiba-souken.k-img.com" ||
				domain === "image.akiba-souken.k-img.com") {
				return src
					.replace(/\/thumbnail\/+images\/+/, "/assets/images/")
					.replace(/(\/images\/+[^/]+\/+(?:(?:[0-9]{3}\/+){2}|[0-9a-f]{2}\/+))(?:t[0-9]+_)?([^/]+?)(?:[?#].*)?$/, "$1$2");
			}
			if (domain === "image.yes24.com") {
				return src.replace(/(:\/\/[^/]*\/goods\/[0-9]+)(?:\/S)?$/i, "$1/L");
			}
			if (domain_nowww === "phileweb.com") {
				newsrc = src.replace(/(\/photo\/+[0-9]{6}\/+[0-9]+)\./, "$1_big.");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "img.danawa.com" ||
				domain_nowww === "wallpoper.com" ||
				domain === "cdn.maximsfinest.com" ||
				domain_nowww === "phileweb.com" ||
				(domain_nowww === "imgpic.org" && string_indexof(src, "/upload/images/") >= 0) ||
				(domain_nosub === "imgdino.com" && domain.match(/img[0-9]*\.imgdino\.com/) && string_indexof(src, "/images/") >= 0) ||
				(domain_nowww === "foto-pic.net" && /\/images\/+[0-9]{10,}_thumb\./.test(src)) ||
				(domain === "storage.cobak.co" && string_indexof(src, "/uploads/") >= 0) ||
				(domain_nowww === "mycotopia.net" && string_indexof(src, "/uploads/") >= 0) ||
				(domain === "static.becomegorgeous.com" && string_indexof(src, "/img/") >= 0) ||
				domain === "i.imagepow.com" ||
				(domain_nosub === "techadvisor.co.uk" && domain.match(/^cdn[0-9]*\./)) ||
				domain === "images.macworld.co.uk" ||
				(domain_nowww === "funtasticecards.com" && string_indexof(src, "/images/") >= 0) ||
				(domain_nowww === "hockey-live.sk" && string_indexof(src, "/images/") >= 0) ||
				(domain_nowww === "khaandaniha.ir" && src.match(/\/Upload\/+Public\/+Content\/+Images\/+/)) ||
				(domain_nowww === "mediavida.com" && string_indexof(src, "/imagenes/") >= 0) ||
				(domain === "img.twitrer.com" && string_indexof(src, "/upload/") >= 0) ||
				(domain === "img.beevar.com" && string_indexof(src, "/upload/") >= 0) ||
				(domain === "adobe-abid.waphall.com" && string_indexof(src, "/images/") >= 0) ||
				(domain_nosub === "cdnme.se" && string_indexof(src, "/images/") >= 0) ||
				(domain_nosub === "zadn.vn" && src.match(/\/uploaded\//i)) ||
				(domain_nowww === "tv-tokyo.co.jp" && /\/photo\/+img\//.test(src)) ||
				domain === "ecdnimg.toranoana.jp" ||
				domain_nowww === "bellazon.com") {
				newsrc = src.replace(/_thumb(\.[^/.]*)(?:[?#].*)?$/, "$1");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nosub === "pcgames.com.cn" && domain.match(/^img[0-9]*\./)) {
				return src.replace(/_(?:thumb|small|medium)(\.[^/.]*)$/, "$1");
			}
			if (domain_nowww === "mosaicon.hu" && string_indexof(src, "/wallpapers/") >= 0) {
				return src.replace(/_(?:large)?thumb(\.[^/.]*)$/, "$1");
			}
			if (domain_nosub === "imagecurl.com") return src.replace(/(\/images\/+[0-9]{5,})_(?:thumb|medium)(\.[^/.]*)$/, "$1$2");
			if (domain === "item.ssgcdn.com") return src.replace(/(\/item\/[^/]*)_[0-9]+(\.[^/.]*)$/, "$1$2");
			if (domain_nosub === "coupangcdn.com" && domain.match(/thumbnail[0-9]*\.coupangcdn\.com/)) {
				return src
					.replace(/thumbnail([0-9]*\.coupangcdn\.com)/, "image$1")
					.replace(/\/thumbnails\/remote\/[^/]*\//, "/");
			}
			if (domain === "image.notepet.co.kr") return src.replace(/\/resize\/[^/]*\//, "/");
			if (domain_nowww === "koreamg.com" ||
				domain_nowww === "yufit.co.kr" ||
				domain_nowww === "lovelanc.com" ||
				domain_nowww === "mimibabi.com" ||
				domain === "akamai.poxo.com" ||
				domain_nowww === "getbarrel.com" ||
				domain_nowww === "sexypet.co.kr" ||
				domain_nowww === "withdrama.net" ||
				domain === "cafe24img.poxo.com" ||
				domain_nowww === "dunststudio.com" ||
				domain_nowww === "fncstore.com") {
				newsrc = src.replace(/(\/web\/+product\/+(?:extra\/+)?)(?:tiny|small|medium)\//, "$1big/");
				if (newsrc !== src) {
					return [newsrc, newsrc.replace(/0(\.[^/.]*)(?:[?#].*)?$/, "00$1")];
				}
			}
			if (domain_nosub === "mynavi.jp") {
				return src
					.replace(/\/index_images\/[^/]*(?:\/[^/]*)?$/, "/images/001l.jpg")
					.replace(/\/images\/([0-9]+)(\.[^/.]*)$/, "/images/$1l$2")
					.replace(/(\/images\/+[0-9]+l?\.[^/.]+)\/+webp(?:[?#].*)?$/, "$1");
			}
			if (domain === "cdn.deview.co.jp") return src.replace(/\/imgs\/news_image\.img\.php.*?am_file=([^&])([^&])([^&])([^&]*).*/, "/imgs/news/$1/$2/$3/$1$2$3$4");
			if (domain === "imgcache.dealmoon.com") return src.replace(/.*?:\/\/[^/]*\/(.*?)(\.[^/._]*)_[^/]*?$/, "http://$1$2");
			if (domain === "www.usmall.us" ||
				domain === "www.sofiehouse.co" ||
				domain === "www.thecelebritydresses.com" ||
				domain === "www.celebredcarpetdresses.com" ||
				domain === "www.minimal.co.id" ||
				domain === "www.bridesmaidca.ca" || // doesn't work
				domain === "www.sisley-paris.com" ||
				domain === "d2ovdo5ynwfl3w.cloudfront.net" ||
				domain === "d1cizyvjjqnss7.cloudfront.net" ||
				domain_nowww === "executiveponies.com" ||
				domain_nowww === "trendygowns.com" ||
				domain === "www.lizandliz.com" ||
				domain === "cdn.sportshop.com" ||
				(domain_nosub === "cdp.pl" && domain.match(/^cdn-[0-9]+\./)) ||
				src.match(/(?:\/media)?\/catalog\/product\/cache\/(?:[0-9]*\/[^/]*\/)?(?:[0-9]+x(?:[0-9]+)?\/)?[0-9a-f]{32}\//)) {
				/*return src
					.replace(/(\/cache\/[0-9]*\/)small_image\//, "$1/image/")
					.replace(/\/(thumbnail|image)\/[0-9]+x[0-9]+\//, "/$1/");*/
				newsrc = src.replace(/\/+cache\/+(?:(?:[0-9]+|stores)\/+[^/]*\/+)?(?:[0-9]*x[0-9]*\/+)?[0-9a-f]{32}\/+((?:.\/+.\/+)|(?:[^/]*\/+))([^/]*)$/, "/$1$2");
				if (newsrc !== src)
					return newsrc;
				/*newsrc = src.replace(/(\/+cache\/+[0-9]+\/+)thumbnail\/+[0-9]+x[0-9]+\/+/, "$1image/");
				if (newsrc !== src)
					return newsrc;*/
			}
			if (domain === "cdn.okdress.co.nz" ||
				(domain_nowww === "promshopau.com" && false)) {
				return src.replace(/(\/media\/catalog\/product\/)cache\/[0-9]*\/[^/]*\/[0-9]+x[0-9]+\//, "$1");
			}
			if (domain === "img.nextmag.com.tw") return src.replace(/\/[0-9]+x(?:[0-9]+)?_([^/]*)$/, "/$1");
			if (domain_nosub === "meitudata.com") {
				return src.replace(/![^/]*$/, "");
			}
			if (domain === "www.shogakukan.co.jp") return src.replace(/\/thumbnail\/books\//, "/thumbnail/snsbooks/");
			if (domain === "images.sysapi.mtg.now.com") return src.replace(/\/[a-z]\/([^/]*)_[a-z](\.[^/.]*)$/, "/o/$1_o$2");
			if (domain_nosub === "lst.fm" && domain.match(/img[0-9]*[^.]*\.lst\.fm/)) {
				return src.replace(/(\/i\/[a-z]\/)(?:avatar)?[0-9]+s\//, "$1");
			}
			if (domain === "www.hdwallpapers.in" ||
				domain_nowww === "bhmpics.com" ||
				domain_nowww === "freshwallpapers.in") {
				return src
					.replace(/\/(?:download|thumbs)\//, "/walls/")
					.replace(/-[^-_/.]*(\.[^/.]*)$/, "-wide$1");
			}
			if (domain_nowww === "superwallpapers.in") return src.replace(/(\/hdwallpapers\/+[^/]+)_[0-9]+_[0-9]+_[0-9]+_[0-9a-f]{2}(\.[^/.]+)(?:[?#].*)?$/, "$1$2");
			if ((domain_nosub === "deezer.com" || domain_nosub === "dzcdn.net") && /images\./.test(domain)) {
				newsrc = src.replace(/(\/[0-9a-f]{32}\/+[0-9]+x[0-9]+)(?:(?:-[0-9]+){4})?(\.[^/.]+)(?:[?#].*)?$/, "$1-000000-100-0-0$2");
				if (newsrc !== src)
					return newsrc;
				match = src.match(/\/([0-9a-f]{32})\/+([0-9]+)x([0-9]+)/);
				if (match) {
					id = match[1];
					var current_x = parseInt(match[2]);
					var current_y = parseInt(match[3]);
					if (current_x < 1200 && current_y < 1200 && !problem_excluded("possibly_upscaled")) {
						return {
							url: src.replace(/(\/[0-9a-f]{32}\/+)[0-9]+x[0-9]+/, "$11200x0"),
							problems: {
								possibly_upscaled: true
							}
						};
					} else if (get_image_size && options.cb && !problem_excluded("bruteforce")) {
						var mingood = 1200;
						var minbad = null;
						var firstrun = true;
						var currentsrc = src;
						var get_deezer_image_url = function(origsrc, newsize, newquality) {
							return origsrc.replace(/(\/[0-9a-f]{32}\/+)[0-9]+x[0-9]+(?:(?:-[0-9]+){4})?(\.[^/.]+)(?:[?#].*)?$/, "$1" + newsize + "-000000-" + newquality + "-0-0$2");
						};
						if (current_x <= 1200) {
							currentsrc = get_deezer_image_url(currentsrc, "1201x0", 1);
							firstrun = false;
						}
						var cache_key = "deezer:" + id;
						var fetch_image_size = function(src, cb) {
							api_cache.fetch("deezer:" + src, cb, function(done) {
								get_image_size(src, function(x, y) {
									done([x, y], 60 * 60);
								});
							});
						};
						var try_new_image = function() {
							fetch_image_size(currentsrc, function(xy) {
								if (window.do_stop)
									return;
								var x = xy[0];
								var y = xy[1];
								if (!x || !y) {
									if (!minbad || current_x < minbad) {
										minbad = current_x;
									}
								} else {
									var largest = Math_max(x, y);
									if (x === 1200 || y === 1200) {
										if (!minbad || current_x < minbad) {
											minbad = current_x;
										}
									} else {
										if (current_x > mingood) {
											mingood = current_x;
										}
									}
								}
								if (!minbad) {
									if (firstrun && current_x < 4000) {
										current_x++;
									} else if (current_x < 1920) {
										current_x = 1921;
									} else if (current_x < 4000) {
										current_x *= 2;
										if (current_x < 4000)
											current_x = 4000;
									}
								} else if ((minbad - mingood) > 1) {
									current_x = (mingood + Math_floor((minbad - mingood) / 2)) | 0;
								}
								var goodsrc = get_deezer_image_url(currentsrc, mingood + "x0", 100);
								if (current_x !== mingood) {
									var newsrc = get_deezer_image_url(currentsrc, current_x + "x0", 1);
									if (newsrc !== currentsrc) {
										currentsrc = newsrc;
										firstrun = false;
										try_new_image();
									} else {
										options.cb(goodsrc);
									}
								} else {
									options.cb(goodsrc);
								}
							});
						};
						if (get_image_size && options.cb) {
							try_new_image();
							return {
								waiting: true
							};
						}
					} else if (current_x < 1920 && current_y < 1920) {
						return {
							url: src.replace(/(\/[0-9a-f]{32}\/+)[0-9]+x[0-9]+/, "$11920x0"),
							problems: {
								possibly_upscaled: true
							}
						};
					}
				}
			}
			if (domain === "cdn.wallpaper.com") {
				regex = /\/main\/styles\/[^/]*\/[^/]*\/(.*\/)?(?:l-)?([^/]*)/;
				return [src.replace(regex, "/main/$2"), src.replace(regex, "/main/$1$2")];
			}
			if (domain === "cdn.wallpaper.com") return src.replace(/\/main\/styles\/[^/]*\/[^/]*\//, "/");
			if (domain === "static.warthunder.com") return src.replace(/\/_thumbs\/[0-9]+x(?:[0-9]+)?\//, "/");
			if (domain === "cdn.wallpaperdirect.com") return src.replace(/(\/[0-9]*)_[^/.]*(\.[^/.]*)$/, "$1orig$2");
			if (domain_nosub === "bamcontent.com" ||
				domain_nosub === "bamgrid.com") {
				return src.replace(/(\/images\/photos\/[0-9]*\/)[0-9]+x[0-9]+\/[^/.]*(\.[^/.]*)$/, "$1raw$2");
			}
			if (domain_nosub === "mail.ru" &&
				domain.match(/filed.*\.mail\.ru$/) &&
				src.match(/:\/\/[^/]*\/pic/)) {
				return decodeURIComponent(src.replace(/.*\/pic.*?[?&]url=([^&]*).*?$/, "$1"));
			}
			if (domain_nosub === "mail.ru" && /^content-[0-9]+\.foto\.my\./.test(domain)) {
				return {
					url: src.replace(/(\/community\/+[^/]+\/+_groupsphoto\/+)i(-[0-9]+\.[^/.?#]+)(?:[?#].*)?$/, "$1b$2"),
					can_head: false // 400
				};
			}
			if (domain_nosub === "mail.ru" &&
				domain.match(/^avt.*\.foto\.mail\.ru/)) {
				return src.replace(/\/_avatar[0-9]*(?:[?#].*)?$/, "/_avatarbig");
			}
			if (domain === "games.mail.ru") {
				return src
					.replace(/\/pre_(?:[0-9]+x[0-9]+|[a-z]+)_(?:resize|crop)\/+(pic|hotbox)\/+/, "/$1/")
					.replace(/\?quality.*/, "");
			}
			if (domain === "my.mail.ru") {
				var query_mailru_videometa_1 = function(vidid, cb) {
					var cache_key = "mailru_video:" + vidid;
					api_query(cache_key, {
						url: "https://my.mail.ru/+/video/meta/" + vidid,
						imu_mode: "xhr",
						headers: {
							Referer: "https://my.mail.ru/",
							Accept: "application/json, text/javascript, */*; q=0.01"
						},
						json: true
					}, cb, function(done, resp, cache_key) {
						done(resp, 60 * 60);
					});
				};
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+(fb\/+[0-9]+\/+video\/+_myvideo\/+[0-9]+)\.html(?:[?#].*)?$/,
					query_for_id: "https://my.mail.ru/${id}.html",
					process: function(done, resp, cache_key) {
						var match = resp.responseText.match(/<script type="text\/plain" class="sp-video__page-config">\s*({.*})\s*<\/script>/);
						if (!match) {
							console_error(cache_key, "Unable to find video page config for", resp);
							return done(null, false);
						}
						var json = JSON_parse(match[1]);
						var vidid = json.itemId;
						if (!vidid) {
							console_error(cache_key, "Unable to find video id for", resp, json);
							return done(null, false);
						}
						query_mailru_videometa_1(vidid, function(meta) {
							if (!meta) {
								return done(null, false);
							}
							var baseobj = {
								extra: {
									caption: meta.meta.title,
									created_at: meta.meta.timestamp * 1000
								}
							};
							var urls = [];
							for (var _i = 0, _a = meta.videos; _i < _a.length; _i++) {
								var video = _a[_i];
								urls.push({
									url: urljoin(resp.finalUrl, meta.videos[0].url, true),
									headers: {
										Referer: resp.finalUrl
									},
									video: true,
									is_private: true
								});
							}
							urls.push(urljoin(resp.finalUrl, meta.meta.poster, true));
							return done(fillobj_urls(urls, baseobj), 60 * 60);
						});
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain === "mg.soupingguo.com") return src.replace(/(\/attchment[^/]*\/[^/]*Img\/)[0-9]+x[0-9]+\//, "$10x0/");
			if (domain === "img.yaplog.jp") return src.replace(/(\/img\/[^/]*\/)mo\//, "$1pc/");
			if (domain === "www.hochi.co.jp") return src.replace(/-[A-Z](\.[^/.]*)$/, "-L$1");
			if (domain_nosub === "wikispaces.com") return src.replace(/(\/view\/[^/]*\.[^/]*)\/.*?$/, "$1");
			if (domain === "img-mdpr.freetls.fastly.net") return src.replace(/(?:\?.*)?$/, "?quality=100");
			if (domain_nowww === "sponichi.co.jp") {
				return {
					url: src.replace(/_thum(\.[^/.]*)$/, "_view$1"),
					can_head: false
				};
			}
			if (domain === "thumbnail.image.rakuten.co.jp") return src.replace(/.*?:\/\/[^/]*\/@[^/]*\/([^?]*).*?$/, "http://shop.r10s.jp/$1");
			if (domain === "tshop.r10s.com") return src.replace(/:\/\/[^/]*\/(.*?)(?:[?#].*)?$/, "://shop.r10s.com/$1");
			if (domain_nowww === "billboard-japan.com" ||
				domain === "fotos.jornaldacidadeonline.com.br") {
				return src.replace(/\/(?:[0-9]+)?x(?:[0-9]+)?_([^/]*)$/, "/$1");
			}
			if (domain_nosub === "tsite.jp" &&
				string_indexof(domain, "top.tsite.jp") >= 0 &&
				string_indexof(src, "/contents_image/") >= 0) {
				return src.replace(/(\/[0-9]+)_[0-9]+(?:_[^/.]+)?(\.[^/.]*)$/, "$1_0$2");
			}
			if (domain === "www.sanspo.com") {
				newsrc = src.replace(/(\/images\/[0-9]*\/[^/]*-)[a-z]([0-9]+\.[^/.]*)$/, "$1p$2");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "www.sonymusicshop.jp") return src.replace(/__[0-9]+_[0-9]+_[0-9]+_([a-z]+\.[a-z]*)(?:\?.*)?$/, "_$1");
			if (domain_nowww === "prtimes.jp") {
				if (/\/api\/+file\.php\?/.test(src)) {
					var queries = get_queries(src);
					return "https://prtimes.jp/i/" + queries.c + "/" + queries.r + "/original/" + queries.f;
				}
				return src
					.replace(/\/thumb\/+(?:[0-9]+x[0-9]+\/+)?(d[0-9]+-)/, "/original/$1")
					.replace(/\/resize\/+([^/]*)$/, "/original/$1");
			}
			if (domain_nosub === "vietbao.vn") {
				return src
					.replace(/:\/\/img\.vietbao\.vn\/images\/[0-9]+\//, "://a9.vietbao.vn/images/");
			}
			if (domain === "media.tinnong.net.vn") return src.replace(/\/Images\/[^/]*\//, "/Images/Original/");
			if (domain === "images.kienthuc.net.vn" ||
				domain === "images.khoeplus24h.vn") {
				return src.replace(/\/zoom[a-z]\/[0-9]*\//, "/");
			}
			if (domain === "rez.cdn.kul.vn" ||
				domain_nowww === "glamour.pl" ||
				domain_nowww === "al3arabi.com" ||
				domain_nowww === "starwars-holocron.net" ||
				domain_nowww === "elle.pl" ||
				domain_nowww === "gala.pl" ||
				domain === "i.moveek.com" ||
				domain_nowww === "mainstyles.ru" ||
				domain === "programme-tv.leparisien.fr" ||
				domain_nowww === "longtake.it" ||
				src.match(/^[a-z]+:\/\/[^/]*\/+media\/+cache\/+[^/]*\/+uploads\/+media\//)) {
				return src
					.replace(/\/media\/+cache\/+.*\/+uploads\/+/, "/uploads/")
					.replace(/\/media\/+cache\/+[^/]*\//, "/");
			}
			if (domain_nowww === "themebeta.com") return src.replace(/\/media\/+cache\/+[0-9]+x[0-9]+\/+files\//, "/files/");
			if (domain === "static.kstyle.com") {
				return src.replace(/\/r\.[0-9]+x[0-9]+$/, "");
			}
			if (amazon_container === "lifesite-cache" ||
				domain_nowww === "golocalprov.com" ||
				(domain === "d1lfxha3ugu3d4.cloudfront.net" && /\/assets\/+system-images\/+remote\/+http/.test(src)) ||
				amazon_container === "ee-harpers-bazaar" ||
				domain === "assets.lifesitenews.com" ||
				(domain_nosub === "thelineofbestfit.com" && domain.match(/^cdn[0-9]*\.thelineofbestfit\.com/))) {
				return src
					.replace(/.*\/(?:(?:system-)?images|made)\/+remote\/+(https?)_(.*?)(?:(?:_[0-9]+)?_[0-9]+_[0-9]+(?:_[a-z]_[a-z][0-9])?)?(\.[^/.]*)$/, "$1://$2$3");
			}
			if (domain === "d1lfxha3ugu3d4.cloudfront.net") return src.replace(/(\/exhibitions\/+images\/+[^/]+)_[0-9]+w(\.[^/.]+)(?:[?#].*)?$/, "$1$2");
			if (domain === "mosaic.tnaflix.com" ||
				domain === "img.empstatic.com" ||
				domain === "img.moviefap.com") {
				newsrc = src.replace(/(\/a[0-9]+):[0-9a-z]+(\/|\.[^/.]*)/, "$1$2");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nosub === "tnastatic.com" && domain.match(/^img[0-9]*\./)) {
				newsrc = src.replace(/(:\/\/[^/]*\/)[^/]*\/(pics|thumbs)\//, "$1q100/$2/");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nowww === "tnaflix.com") {
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+[^/]+\/+[^/]+\/+video([0-9]+)(?:[?#].*)?$/,
					query_for_id: function(id) {
						return {
							url: "https://www." + domain_nosub + "/ajax/video-player/" + id,
							headers: {
								Accept: "*/*",
								Referer: "https://" + domain + "/"
							},
							imu_mode: "xhr",
							json: true
						};
					},
					process: function(done, resp, cache_key) {
						if (!resp.html) {
							console_error(cache_key, "Unable to find html from", resp);
							return done(null, false);
						}
						var fakeresp = {
							responseText: resp.html,
							finalUrl: "https://www.tnaflix.com/"
						};
						var obj = common_functions["get_videotag_obj"](fakeresp);
						if (!obj)
							return done(null, false);
						return done(fillobj_urls(obj, {
							headers: {
								Referer: fakeresp.finalUrl
							}
						}), 60 * 60);
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain_nosub === "tnaflix.com" || domain_nosub === "tnastatic.com" ||
				domain_nosub === "empflix.com" || domain_nosub === "empstatic.com") {
				var is_pagelink = true;
				var is_vkey = false;
				match = src.match(/^[a-z]+:\/\/[^/]+\/+[^/]+\/+[^/]+\/+video([0-9]+)(?:[?#].*)?$/);
				if (!match) {
					match = src.match(/^[a-z]+:\/\/[^/]+\/+view_video\.php\?(?:.*&)?viewkey=([0-9a-f]+)/);
					if (match)
						is_vkey = true;
				}
				if (!match) {
					is_pagelink = false;
					match = src.match(/^[a-z]+:\/\/img[0-9]*\.[^/]+\/+[^/]+\/+thumbs\/+[0-9a-f]{2}\/+[0-9a-f]{1,2}_([0-9]+)l\./);
				}
				if (!match) {
					is_pagelink = false;
					match = src.match(/^[a-z]+:\/\/img[0-9]*\.[^/]+\/+[^/]+\/+thumbs\/+[0-9a-f]{2}\/+([0-9]+)-[0-9]+l\./);
				}
				if (!match) {
					is_pagelink = false;
					match = src.match(/^[a-z]+:\/\/mosaic\.[^/]+\/+([0-9]+)\/+a[0-9]+(?::[^/]+)?\/+/);
				}
				if (!match) {
					is_pagelink = false;
					match = src.match(/\/trailer\/+empflix\/+(?:[0-9a-f]\/+){3}([0-9a-f]+)\./);
					if (match)
						is_vkey = true;
				}
				var base_domain = domain_nosub.replace(/static\./, "flix.");
				var base_domain_noext = base_domain.replace(/\..*/, "");
				var vid_suffix = "";
				if (base_domain_noext === "empflix") {
					vid_suffix = "-1";
				}
				if (match) {
					id = match[1];
					page_nullobj = {
						url: src,
						is_pagelink: true
					};
					if (!is_pagelink)
						page_nullobj = null;
					var query_tnaflix_api = function(data, cb) {
						if (!data || !data.vkey || !data.nkey || !data.VID || !("thumb" in data) || !data.finalUrl) {
							console_error("Invalid parameters", data);
							return cb(null);
						}
						var url = "https://cdn-fck." + base_domain + "/" + base_domain_noext + "/" + data.vkey + vid_suffix + ".fid?key=" + data.nkey + "&VID=" + data.VID + "&startThumb=" + data.thumb + "&nomp4=1&catID=0&rollover=1&embed=0&utm_source=0&multiview=0&premium=1&country=0user=0&vip=1&cd=0&ref=0&alpha";
						api_query(base_domain + "_api:" + data.VID, {
							url: url,
							headers: {
								origin: "https://www." + base_domain,
								Referer: data.finalUrl
							}
						}, cb, function(done, resp, cache_key) {
							var urls = common_functions.parse_flixv2(resp, cache_key);
							if (!urls || urls.length === 0) {
								urls = [];
							}
							if (page_nullobj)
								urls.push(page_nullobj);
							if (!urls.length) {
								return done(null, false);
							} else {
								for (var i = 0; i < urls.length; i++) {
									urls[i].url = urljoin("https://www." + base_domain + "/", urls[i].url, true);
								}
								var baseobj = {
									headers: {
										Referer: "https://www." + base_domain + "/",
										"Sec-Fetch-Dest": "video"
									}
								};
								if (page_nullobj)
									urls.push(page_nullobj);
								return done(fillobj_urls(urls, baseobj), 60 * 60);
							}
						});
					};
					var process_tnaflix_site = function(done, resp, cache_key) {
						var regex = /<input id="(VID|vkey|nkey|thumb)" type="hidden" value="([^"]+)"/;
						var global_regex = new RegExp(regex, "g");
						var match = resp.responseText.match(global_regex);
						if (!match) {
							console_error(cache_key, "Unable to find match for", resp);
							return done(null, false);
						}
						var values = {};
						for (var i = 0; i < match.length; i++) {
							var smatch = match[i].match(regex);
							var key = smatch[1];
							var value = smatch[2];
							values[key] = value;
						}
						values["finalUrl"] = resp.finalUrl;
						done(values, 60 * 60);
					};
					var query_tnaflix_site_by_vid = function(vid, cb) {
						api_query(base_domain + "_site_vid:" + vid, {
							url: "https://www." + base_domain + "/a/a/video" + vid
						}, cb, process_tnaflix_site);
					};
					var query_tnaflix_site_by_vkey = function(vkey, cb) {
						api_query(base_domain + "_site_vkey:" + vkey, {
							url: "https://www." + base_domain + "/view_video.php?viewkey=" + vkey
						}, cb, process_tnaflix_site);
					};
					if (options.do_request && options.cb) {
						var final = function(data) {
							query_tnaflix_api(data, options.cb);
						};
						if (!is_vkey) {
							query_tnaflix_site_by_vid(id, final);
						} else {
							query_tnaflix_site_by_vkey(id, final);
						}
						return {
							waiting: true
						};
					}
				}
			}
			if (domain_nowww === "imagefap.com") {
				var query_imagefap_photo = function(id, cb) {
					api_query("imagefap_photo:" + id, {
						url: "https://www.imagefap.com/photo/" + id + "/"
					}, cb, function(done, resp, cache_key) {
						var link_regex = /<a href="(https?:\/\/[a-z]+\.imagefap\.com\/+images\/+full[^"]+)"[^>]+?imageid="([0-9]+)"/;
						var links = resp.responseText.match(new RegExp(link_regex, "g"));
						if (!links) {
							console_error(cache_key, "Unable to find image links for", resp);
							return done(null, false);
						}
						var url = null;
						array_foreach(links, function(link) {
							var submatch = link.match(link_regex);
							var our_url = decode_entities(submatch[1]);
							var our_id = submatch[2];
							if (our_id != id) {
								api_cache.set("imagefap_photo:" + our_id, our_url, 60 * 60);
							} else {
								url = our_url;
							}
						});
						if (!url) {
							console_error("Unable to find", id, "in", links, resp);
							return done(null, false);
						}
						return done(url, 60 * 60);
					});
				};
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+photo\/+([0-9]+)\/*(?:[?#].*)?$/,
					run: function(done, match) {
						var id = match[1];
						query_imagefap_photo(id, function(url) {
							if (!url) {
								return done(null, false);
							} else {
								return done({
									url: url,
									extra: {
										page: "https://www.imagefap.com/photo/" + id + "/"
									}
								}, 60 * 60);
							}
						});
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain_nowww === "imagefap.com" ||
				domain_nowww === "moviefap.com") {
				var query_moviefap_flv = function(flvurl, cb) {
					api_query("moviefap_flv:" + flvurl, {
						url: flvurl,
						headers: {
							Origin: "https://www.imagefap.com",
							Referer: "https://cdn-fck.moviefap.com/",
							"Content-Type": "application/x-www-form-urlencoded"
						}
					}, cb, function(done, resp, cache_key) {
						var urls = common_functions.parse_flixv2(resp, cache_key);
						if (!urls || urls.length === 0) {
							urls = [];
						}
						if (page_nullobj)
							urls.push(page_nullobj);
						if (!urls.length) {
							return done(null, false);
						} else {
							var baseobj = {
								headers: {
									Referer: "https://www.imagefap.com/",
									"Sec-Fetch-Dest": "video"
								}
							};
							if (page_nullobj)
								urls.push(page_nullobj);
							return done(fillobj_urls(urls, baseobj), 60 * 60);
						}
					});
				};
				var get_flvurl = null;
				match = src.match(/:\/\/[^/]*imagefap\.com\/+video\.php\?(?:.*?&)?vid=([0-9]+)/);
				if (match) {
					id = match[1];
					var query_imagefap_flvurl = function(vid, cb) {
						api_query("imagefap_flvurl:" + vid, {
							url: "https://www.imagefap.com/video.php?vid=" + vid
						}, cb, function(done, resp, cache_key) {
							var match = resp.responseText.match(/url: '(https?:\/\/cdn-fck\.moviefap.com\/+moviefap\/+[0-9a-f]{10,}\.flv\?(?:.*&)?VID=.*?)',/);
							if (!match) {
								console_error(cache_key, "Unable to find info flv URL for", resp);
								return done(null, false);
							}
							return done(match[1], 60 * 60);
						});
					};
					get_flvurl = function(cb) {
						query_imagefap_flvurl(id, cb);
					};
				} else {
					match = src.match(/:\/\/[^/]+\/+videos\/+([0-9a-f]{10,})\/+[^/]*\.html(?:[?#].*)?$/);
					if (match) {
						id = match[1];
						var query_moviefap_flvurl = function(vid, cb) {
							api_query("moviefap_flvurl:" + vid, {
								url: "https://www.moviefap.com/videos/" + vid + "/a.html"
							}, cb, function(done, resp, cache_key) {
								var match = resp.responseText.match(/<input type="hidden" id="config1" name="config1" value="(https?:\/\/cdn-fck\.moviefap.com\/+moviefap\/+[0-9a-f]{10,}\.flv\?(?:.*(?:&|%26))?VID=.*?)" \/>/);
								if (!match) {
									console_error(cache_key, "Unable to find info flv URL for", resp);
									return done(null, false);
								}
								return done(match[1], 60 * 60);
							});
						};
						get_flvurl = function(cb) {
							query_moviefap_flvurl(id, cb);
						};
					}
				}
				if (get_flvurl) {
					page_nullobj = {
						url: src,
						is_pagelink: true
					};
					if (options.do_request && options.cb) {
						get_flvurl(function(flvurl) {
							if (!flvurl) {
								return options.cb(page_nullobj);
							}
							query_moviefap_flv(flvurl, options.cb);
						});
						return {
							waiting: true
						};
					} else {
						return page_nullobj;
					}
				}
			}
			if (domain === "img.moviefap.com") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]+\/+[^/]+\/+thumbs\/+[0-9a-f]{2}\/+([0-9]+)-[0-9]+l\.[^/.]+/, "https://www.imagefap.com/video.php?vid=$1");
				if (newsrc !== src)
					return {
						url: newsrc,
						is_pagelink: true
					};
			}
			if (domain_nowww === "imagefap.com" ||
				(domain_nosub === "imagefap.com" && /^(?:cdn[ch]?|images)\./.test(domain)) ||
				domain_nosub === "fap.to") {
				match = src.match(/^[a-z]+:\/\/[^/]+\/+(?:[a-z][a-z0-9.]+\/+)?images\/+(?:mini|thumb)\/+[0-9]+\/+[0-9]+\/+([0-9]+)\./);
				if (match) {
					return {
						url: "https://www.imagefap.com/photo/" + match[1] + "/",
						is_pagelink: true
					};
				}
			}
			if (domain_nosub === "imagefapusercontent.com" && /^x[0-9]*\./.test(domain)) {
				match = src.match(/^[a-z]+:\/\/[^/]+\/+u\/+[^/]+\/+[0-9]+\/+([0-9]+)\/+[^/]+\./);
				if (match) {
					return {
						url: "https://www.imagefap.com/photo/" + match[1] + "/",
						is_pagelink: true
					};
				}
			}
			if (domain === "www.gannett-cdn.com" &&
				string_indexof(src, "/-ip-/") >= 0) {
				return src.replace(/.*?\/-ip-\//, "");
			}
			if (domain === "cdn.mainichi.jp") return src.replace(/\/[0-9]+(\.[^/.]*)$/, "/9$1");
			if (domain === "img.evbuc.com" ||
				domain === "cdn.mall.adeptmind.ai") {
				return decodeURIComponent(src.replace(/.*:\/\/[^/]*\/([^?]*).*/, "$1"));
			}
			if (domain === "img.cdandlp.com") {
				return src.replace("/imgS/", "/imgL/").replace("/imgM/", "/imgL/");
			}
			if (domain === "walter.trakt.tv") {
				return src
					.replace(/\/(posters|fanarts|avatars)\/(?:thumb|medium|large|full)\/([^/]*?)(\.webp)?$/, "/$1/original/$2");
			}
			if (domain === "cdn.apk-cloud.com" ||
				domain_nowww === "apk-dl.com") {
				return src
					.replace(/(?:=[a-z][0-9]*)?(\.[^/.]*)$/, "=h0$1");
			}
			if (domain_nosub === "polyvoreimg.com") {
				var cginame = src.replace(/.*\/cgi\/([^/]*)\/.*/, "$1");
				var paramsbase = src.replace(/.*\/cgi\/[^/]*/, "");
				var params = paramsbase.replace(/\/([^/]*)\/([^/]*)/g, "$1=$2&");
				params = params
					.replace(/(.*)\.([^/.&]*)&$/, ".out=$2&$1");
				return "https://www.polyvore.com/cgi/" + cginame + "?" + params;
			}
			if (domain === "www.polyvore.com" &&
				string_indexof(src, "/cgi/") >= 0) {
				return src
					.replace(/\/img-set(.*?)&size=[^&]*/, "/img-set$1&size=c99999x99999");
			}
			if (domain === "aliyun-cdn.hypebeast.cn" &&
				string_indexof(src, "/hypebeast.com/") >= 0) {
				return src.replace(/.*:\/\/[^/]*\//, "http://");
			}
			if (domain_nowww === "girlscene.nl" ||
				domain_nowww === "beautyscene.nl" ||
				domain_nowww === "trendalert.nl") {
				return src.replace(/\/thumb\/+[0-9]+x[0-9]+\/+ckfinder\/+/, "/ckfinder/");
			}
			if (domain_nowww === "hdfullfilmizle.com" ||
				domain_nowww === "hdfilmcix.net" ||
				domain_nowww === "fullhdfilmizletio.com" ||
				domain_nowww === "sinefun.com" ||
				domain_nowww === "1080hdfilmizle.com" ||
				domain_nowww === "sinemagecesi.com" ||
				domain_nowww === "fullfilmburada.com" ||
				domain_nowww === "evrenselfilmizle.net" ||
				domain_nowww === "vizyonfilmlerizle.com" ||
				domain_nowww === "sinemangoo.org" ||
				/^[a-z]+:\/\/[^/]+\/+thumb\/+[0-9]+x[0-9]+\/+uploads\/+(?:film|oyuncu)\/+[0-9]{4}\/+(?:[0-9]{2}\/+[^/]+-[0-9]{3}|[0-9]{2}[^/]+)\.[^/.]+(?:[?#].*)?$/.test(src)) {
				return src.replace(/\/thumb\/+[0-9]+x[0-9]+\/+uploads\//, "/uploads/");
			}
			if (domain_nowww === "hairstyleinsider.com" ||
				domain === "sites.eveyo.com" ||
				domain_nowww === "24sata.info" ||
				domain_nowww === "alankabout.com" ||
				domain_nowww === "cosmopolitan.rs" ||
				domain_nowww === "elle.rs") {
				return src.replace(/\/(?:thumbnail|files).php.*?file=([^&]*).*/, "/files/$1");
			}
			if (domain_nowww === "zkpm.net" ||
				domain_nowww === "zyzpes.com" ||
				domain_nowww === "yoptel.ru" ||
				domain === "img.viyuedu.com") {
				return src.replace(/.*\/img\.php.*?url=(.*)/, "$1");
			}
			if (domain_nowww === "aidu360.com") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/+img\.php\?(?:.*?&)?u=([^&]*).*?$/, "$1");
				if (newsrc !== src)
					return decodeuri_ifneeded(newsrc);
			}
			if (domain === "img.xiaohuazu.com") {
				return src.replace(/.*?[?&]url=(.*)/, "$1").replace(/z-z/g, ".").replace(/^/, "http://");
			}
			if (domain_nowww === "viewsofia.com") {
				return src.replace("/fck_editor_thumb/", "/fck_editor/");
			}
			if (domain_nosub === "condenast.ru" && string_indexof(domain, ".static.media.condenast.ru") >= 0) {
				return src.replace(/\/[a-z][0-9]*(?:x[0-9]+)?$/, "/w99999999");
			}
			if (domain_nowww === "vogue.co.jp") return src.replace(/(\/uploads\/+media\/+[0-9]{4}\/+(?:[0-9]{2}\/+){2}[^/]+)-[0-9]+-[0-9]+(\.[^/.]*)$/, "$1$2");
			if (domain_nosub === "vogue.mx" ||
				domain_nosub === "glamour.mx" ||
				domain_nosub === "glamour.es" ||
				domain === "cdn.gq.com.mx" ||
				domain === "cdn.revistavanityfair.es" ||
				domain_nosub === "vogue.es") {
				newsrc = src
					.replace(/\/uploads\/+images\/+thumbs(?:(\/+(?:mx|es)\/+(?:vog|glam|gq|vf)\/+)[0-9]*\/+([a-z]))?(\/+(?:[0-9]{4}\/+[0-9]+|[0-9]{4,})\/+[^/]*)_[0-9]+x(?:[0-9]+)?(\.[^/.]*)(?:[?#].*)?$/, "/uploads/images$1$2$3$4");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nosub === "ykt.ru" ||
				domain_nosub === "ykt2.ru") {
				newsrc = src.replace(/\/thumb\/([^/]*)$/, "/$1");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "i.guim.co.uk") return src.replace(/:\/\/[^/]*\/img\/([^/]*)\/([^?]*).*?$/, "://$1.guim.co.uk/$2");
			if (domain === "media.guim.co.uk") {
				return src
					.replace(/\/((?:[0-9]*_){3}[0-9]*)\/[^/]*\/([0-9]*\.[^/.]*)$/, "/$1/$2")
					.replace(/(\/[0-9]+_[0-9]+_([0-9]+)_[0-9]+\/)[0-9]+(\.[^/.]*)$/, "$1$2$3");
			}
			if (domain_nowww === "g2d.co.in") return src.replace(/(\/img\/+Photo\/+[0-9]+\/+)(?:sml|med)_([^/]*\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain === "vogue.gjstatic.nl" ||
				domain === "glamour.gjstatic.nl") {
				return src
					.replace(/\/teaserFileUpload\//, "/fileUpload/") // doesn't work on all
					.replace(/\/fileUpload\/[^/]*\//, "/fileUpload/big/");
			}
			if (domain_nosub === "favim.com" && domain.match(/^s[0-9]*\./)) {
				return src.replace(/(:\/\/[^/]*\/)[^/]*\//, "$1orig/");
			}
			if (domain_nowww === "derpibooru.org" ||
				domain_nowww === "furbooru.org") {
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+(?:images\/+)?([0-9]+)\/*(?:[?#].*)?$/,
					query_for_id: function(id) {
						return {
							url: "https://" + domain_nosub + "/" + id
						};
					},
					process: function(done, resp, cache_key) {
						var ogimage = resp.responseText.match(/<meta content="([^"]+)" property="og:image">/);
						if (!ogimage) {
							console_error(cache_key, "Unable to find og:image match for", resp);
							return done(null, false);
						}
						return done(decode_entities(ogimage[1]), 6 * 60 * 60);
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (host_domain_nowww === "derpibooru.org" ||
				host_domain_nowww === "furbooru.org") {
				var link = common_functions["get_link_el_matching"](options.element, function(a) {
					return /^[a-z]+:\/\/[^/]+\/+(?:images\/+)?([0-9]+)\/*(?:[?#].*)?$/.test(a.href);
				});
				if (link) {
					return {
						url: link.href,
						is_pagelink: true
					};
				}
			}
			if (domain_nowww === "derpicdn.net" ||
				domain_nowww === "furrycdn.org") {
				newsrc = src.replace(/\/(?:thumb|large)(\.[^/.]*)$/, "/full$1");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/(\/img\/+)([0-9]{4}\/+[0-9]{1,2}\/+[0-9]{1,2}\/+[0-9]+)\/+[^/.]+(\.[^/.]+)(?:[?#].*)?$/, "$1view/$2$3");
				if (newsrc !== src)
					return newsrc;
				var basedomain = "derpibooru.org";
				if (domain_nosub === "furrycdn.org")
					basedomain = "furbooru.org";
				match = src.match(/\/img\/+(?:view\/+)?[0-9]{4}\/+(?:[0-9]{1,2}\/+){2}([0-9]+)[./]/);
				if (match) {
					return {
						url: src,
						extra: { page: "https://" + basedomain + "/" + match[1] }
					};
				}
			}
			if (domain_nosub === "iimg.me") {
				newsrc = src.replace(/.*\/[a-z]*\.php.*?[?&]url=([^&]*).*?$/, "$1");
				if (newsrc !== src && string_indexof(newsrc, "http") === 0) {
					return decodeURIComponent(newsrc);
				}
			}
			if (domain === "pix.avaxnews.com" ||
				domain === "pix.avax.news" ||
				domain_nowww === "pixhost.icu" ||
				domain_nowww === "pxhst.co") {
				return src.replace(/_[^/]*(\.[^/.]*)$/, "$1");
			}
			if (domain_nosub === "hurimg.com" ||
				domain === "img.posta.com.tr" ||
				domain === "icdn.pstimg.com" ||
				domain === "img.fanatik.com.tr" ||
				domain === "assets.dogannet.tv" ||
				domain_nosub === "fanatik.com.tr" ||
				((domain_nosub === "pstimaj.com" ||
					domain_nosub === "milimaj.com" ||
					domain_nosub === "cnnturk.com") && /^i[0-9]*\./.test(domain))) {
				return src.replace(/\/[0-9]+\/[0-9]+x[0-9]+\/([0-9a-f]+(?:\.[^/.]*)?)([?#].*)?$/, "/100/0x0/$1");
			}
			if (domain === "image.gazetevatan.com" ||
				domain === "image.posta.com.tr") {
				return src.replace(/(\/i\/+[^/]+\/+)[0-9]+\/+[0-9]+x[0-9]+\/+/, "$1100/0x0/");
			}
			if (domain === "www.kurtkomaromi.com" ||
				domain_nosub === "typepad.com" ||
				domain === "blogs.elpais.com" ||
				domain === "www.summerofdan.net" ||
				domain_nowww === "thequeenofstyle.com" ||
				domain_nowww === "thequestforit.com" ||
				domain_nosub === "blogs.com" ||
				domain === "latimesblogs.latimes.com" ||
				domain === "www.weeklystorybook.com") {
				return src.replace(/^([a-z]+:\/\/[^/]+\/+\.a\/+[0-9a-f]{10,})-[^/]*(?:[?#].*)?$/, "$1");
			}
			if (domain_nowww === "bathingnews.com") {
				return {
					can_head: false,
					url: src.replace(/(\/\.a\/[^-/]*)-[^/]*$/, "$1")
				};
			}
			if (domain_nowww === "fmyokohama.jp") return src.replace(/\/thumbnail\/+([^/]*)-[0-9]+wi(\.[^/.]*)(?:[?#].*)?$/, "/$1$2");
			if (domain === "gd.image-qoo10.jp") return src.replace(/\.[^/.]*(\.[^/.]*)$/, "$1");
			if (domain === "img.jakpost.net") {
				return [
					src.replace(/\.[^/.]*(\.[^/.]*)$/, "$1"),
					src.replace(/\._[a-z]+(\.[^/.]*)$/, "._large$1")
				];
			}
			if (domain === "r.ddmcdn.com") return src.replace(/:\/\/[^/]*\/(?:[^/_]*_[^/_]*\/)*/, "://static.ddmcdn.com/");
			if ((domain_nosub === "newegg.com" && /images[0-9]*\./.test(domain)) ||
				domain_nosub === "neweggimages.com") {
				return src
					.replace(/(:\/\/[^/]*\/)(?:NeweggImage\/)?(?:ProductImage|productimage)[^/]*\//, "$1ProductImageOriginal/")
					.replace(/\/itemreivewimages\/+reviewimg[0-9]+\/+/, "/itemreivewimages/original/");
			}
			if (domain === "images.costco-static.com" ||
				domain === "images.costcobusinesscentre.ca") {
				return src
					.replace(/([?&])recipeName=[^&]*/, "$1")
					.replace(/&$/, "");
			}
			if (amazon_container === "emerge-tech") {
				return src.replace(/\/[a-z]*\/([0-9]*_[a-z]*_)[a-z]*(\.[^/.]*)$/, "/full/$1full$2");
			}
			if (domain_nosub === "wfcdn.com" && domain.match(/img[0-9]*(?:-[^.]*)?\.wfcdn\.com/) ||
				domain === "assets.wfcdn.com") {
				return src
					.replace(/\/im\/+[0-9]+\/+compr-r85\/+([0-9]+\/+[0-9]+\/+)/, "/lf/unprocessed/hash/$11/")
					.replace(/(\/lf\/+)[a-z]+(\/+hash\/)/, "$1unprocessed$2")
					.replace(/(\/im\/[0-9]+\/)[^/]*\//, "$1compr-r85/");
			}
			if (domain_nosub === "hdnux.com") return src.replace(/(\/photos\/+(?:[0-9]{2}\/+){3,4}[0-9]+\/+[0-9]+\/+)[^/.?#]+(\.[^/.]*)(?:[?#].*)?$/, "$1rawImage$2");
			if (domain_nosub === "busan.com" && domain.match(/^news[0-9]*\./)) {
				return src.replace(/(\/content\/+image\/+[0-9]{4}\/+(?:[0-9]{2}\/+){2}[0-9]+)_t(\.[^/.]*)$/, "$1_0$2");
			}
			if (domain_nowww === "busan.com") return src.replace(/(\/wcms\/+wcms_data\/+photos\/+[0-9]{4}\/+(?:[0-9]{2}\/+){2}[0-9]+)_[sm](\.[^/.]*)(?:[?#].*)?$/, "$1_l$2");
			if (amazon_container === "bucket.scribblelive.com" ||
				domain === "images.scribblelive.com") {
				return src.replace(/_[0-9]+(\.[^/.]*)$/, "$1");
			}
			if (domain === "www.dhresource.com" ||
				domain === "image.dhgate.com") {
				return src
					.replace(/(:\/\/[^/]*\/albu_[0-9]+_[0-9]+[-/].*?)[0-9]+x[0-9]+/, "$10x0")
					.replace(/(:\/\/[^/]*\/)[0-9]+x[0-9]+/, "$10x0")
					.replace(/(:\/\/[^/]*\/)[^/]*\/[^/]*\/[0-9]+x[0-9]+\//, "$10x0/");
			}
			if (domain_nowww === "storify.com" && /\/services\/+proxy\//.test(src)) {
				return src.replace(/.*\/services\/proxy\/[0-9]+\/[^/]*\/([a-z]+)\/(.*)$/, "$1://$2");
			}
			if (domain_nowww === "mbcsportsplus.com" ||
				domain === "m.mbcsportsplus.com") {
				var outdir = null;
				if (src.match(/[?&]type=m[^a-z0-9A-Z]/))
					outdir = "/data/home/data/msplMain";
				else if (src.match(/[?&]type=a[^a-z0-9A-Z]/))
					outdir = "/data/board/attach";
				if (outdir)
					return src.replace(/\/images\/+img\.php\?(?:.*&)?src=([^&]*).*/, outdir + "$1");
			}
			if (domain_nosub === "joomag.com" && domain.match(/s[0-9]*cdn\.joomag\.com/)) {
				return src.replace(/(\/mobile\/.*\/[0-9]+_)[0-9]+(-[0-9]*\.[^/]*)$/, "$10$2");
			}
			if (domain === "i.pximg.net" ||
				domain === "pixiv.pximg.net" ||
				domain === "i.pixiv.re" ||
				(domain_nosub === "techorus-cdn.com" && /^tc-pximg[0-9]*\./.test(domain))) {
				newsrc = src
					.replace(/(\/user-profile\/+img\/.*\/[0-9]+_[0-9a-f]{20,})_[0-9]+(\.[^/.]+)(?:[?#].*)?$/, "$1$2")
					.replace(/\/c\/[0-9]+x[0-9]+(?:_[0-9]+)?(?:_[ag][0-9]+)*\//, "/")
					.replace(/\/(?:img-master|custom-thumb)\//, "/img-original/")
					.replace(/(\/[0-9]+_p[0-9]+)_[^/]*(\.[^/.]*)$/, "$1$2");
				var referer_url = "https://www.pixiv.net/";
				if (domain === "pixiv.pximg.net" || domain_nosub === "pixiv.re") {
					referer_url = null;
				}
				match = src.match(/\/([0-9]+)_p([0-9]+)(?:_[^/.]+)?\.[^/.]+$/);
				if (!match) {
					id = null;
				} else {
					id = match[1];
					referer_url = "https://www.pixiv.net/artworks/" + id;
				}
				obj = {};
				if (referer_url && domain_nosub !== "pixiv.re") {
					obj.headers = {
						Referer: referer_url
					};
				}
				if (id) {
					obj.extra = {
						page: referer_url
					};
				}
				var urls = [src];
				if (newsrc !== src) {
					urls = add_extensions(newsrc);
				}
				var retobj = fillobj_urls(urls, obj);
				if (id && options && options.force_page && options.cb && options.do_request) {
					retobj.unshift({
						url: referer_url + "#imu-page=" + match[2],
						is_pagelink: true
					});
				}
				return retobj;
			}
			if (domain_nowww === "pixiv.net") {
				var query_pixiv_page = function(id, page, cb) {
					var url = "https://www.pixiv.net/artworks/" + id;
					api_query("pixiv_page:" + id, {
						url: url
					}, function(obj) {
						if (!obj)
							return cb(null);
						if (obj[0].album_info) {
							var links = obj[0].album_info.links;
							for (var i = 0; i < links.length; i++) {
								if (i != page) {
									links[i].is_current = false;
									continue;
								}
								links[i].is_current = true;
								obj[0].url = links[i].url;
							}
						}
						return cb(obj);
					}, function(done, resp, cache_key) {
						var match = resp.responseText.match(/<meta\s+name=\"preload-data\"\s+id=\"meta-preload-data\"\s+content='(.*?)'>/);
						if (!match) {
							console_error(cache_key, "Unable to find match", resp);
							return done(null, false);
						}
						var json = JSON_parse(decode_entities(match[1]));
						var illust = json.illust[id];
						var obj = {
							extra: {
								page: resp.finalUrl
							},
							headers: {
								Referer: resp.finalUrl
							}
						};
						if (illust.illustTitle) {
							obj.extra.caption = illust.illustTitle;
						}
						var urls = [];
						var urltypes = ["original", "regular", "small", "thumb", "mini"];
						var unsorted_urls = [];
						for (var type in illust.urls) {
							unsorted_urls.push({
								type: type,
								url: illust.urls[type]
							});
						}
						unsorted_urls.sort(function(a, b) {
							var a_index = array_indexof(urltypes, a.type);
							var b_index = array_indexof(urltypes, b.type);
							if (a_index < 0)
								return 1;
							if (b_index < 0)
								return -1;
							return a_index - b_index;
						});
						for (var i = 0; i < unsorted_urls.length; i++) {
							if (array_indexof(urltypes, unsorted_urls[i].type) >= 0)
								urls.push(unsorted_urls[i].url);
						}
						if (urls.length === 0) {
							console_error(cache_key, "Unable to find valid urls from", json, illust);
							return done(null, false);
						}
						var url = urls[0];
						if (illust.pageCount && illust.pageCount > 1) {
							obj.album_info = {
								type: "links",
								links: []
							};
							for (var i = 0; i < illust.pageCount; i++) {
								obj.album_info.links.push({
									url: url.replace(/(_p)[0-9]+(_[^/.]+)?(\.[^/.]+)$/, "$1" + i + "$2$3")
								});
							}
						}
						return done(fillobj_urls([urls[0]], obj), 60 * 60);
					});
				};
				newsrc = website_query({
					website_regex: [
						/^[a-z]+:\/\/[^/]+\/+(?:[^/]+\/+)?artworks\/+([0-9]+)\/*(?:[?#].*)?$/,
						/^[a-z]+:\/\/[^/]+\/+member_illust\.php\?(?:.*&)?illust_id=([0-9]+)/
					],
					run: function(cb, match, website_options) {
						var page = 0;
						var pagematch = website_options.url.match(/#imu-page=([0-9]+)/);
						if (pagematch)
							page = pagematch[1];
						query_pixiv_page(match[1], page, cb);
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain_nosub === "booth.pm" && domain.match(/s[0-9]*\.booth\.pm/) ||
				domain === "booth.pximg.net") {
				newsrc = src
					.replace(/\/c\/[a-z]_[0-9]+\//, "/")
					.replace(/_c_[0-9]+x[0-9]+(\.[^/.]*)$/, "$1");
				if (newsrc !== src) {
					return add_full_extensions(newsrc);
				}
				newsrc = src.replace(/(:\/\/[^/]*\/)c\/[0-9]+x[0-9]+(?:_[^/]*)?\//, "$1");
				if (newsrc !== src)
					return add_full_extensions(newsrc);
				newsrc = src.replace(/(\/[-0-9a-f]+)_[^/.]*(\.[^/.]*)$/, "$1$2");
				if (newsrc !== src)
					return add_full_extensions(newsrc);
			}
			if (domain === "downloads.fanbox.cc") {
				var page_1 = null;
				match = src.match(/\/images\/+post\/+([0-9]+)\/+/);
				if (match) {
					page_1 = "https://a.fanbox.cc/posts/" + match[1];
				}
				obj = {
					url: src,
					extra: { page: page_1 }
				};
				newsrc = src.replace(/(\/images\/+post\/+[0-9]+\/+)w\/+[0-9]+\/+/, "$1");
				if (newsrc !== src) {
					obj.url = newsrc;
					return fillobj_urls(add_extensions_with_jpeg(newsrc), obj);
				}
				return obj;
			}
			if (domain === "cache-graphicslib.viator.com") {
				return {
					url: src.replace(/([-_][0-9]+)-[^-_/.]*(\.[^/.]*)$/, "$1-raw$2"),
					head_wrong_contentlength: true
				};
			}
			if (domain_nosub === "4sqi.net") return src.replace(/\/img\/+general\/+[0-9]+x[0-9]+\//, "/img/general/original/");
			if (domain === "static.panoramio.com" ||
				googlestorage_container === "static.panoramio.com") {
				return src.replace(/\/photos\/[^/]*\//, "/photos/original/");
			}
			if (domain_nosub === "myportfolio.com" && domain.match(/.*cdn.*\.myportfolio\.com$/)) {
				return src.replace(/_(?:rw_[0-9]+|rwc_[0-9]+(?:x[0-9]+){4})(\.[^/.?]*)(?:\?.*)?$/, "$1");
			}
			if (domain === "i.dell.com") return src.replace(/(\/(?:[0-9a-f]+-){4}[0-9a-f]+\/[0-9]+\/)LargePNG/, "$1originalpng");
			if (domain === "thumb.zumst.com") {
				return src.replace(/.*:\/\/[^/]*\/[0-9]+[^/]*\//, "");
			}
			if (domain === "imgp.golos.io") return src.replace(/^[a-z]+:\/\/[^/]*\/+[0-9]+x[0-9]+\/+(https?:)/, "$1");
			if (domain === "images.underskog.no") return src.replace(/^[a-z]+:\/\/[^/]+\/+[0-9]*x[0-9]*\/+(https?:\/\/)/, "$1");
			if ((domain_nosub === "zumst.com" ||
				domain_nosub === "zum.com") &&
				domain.match(/^static\./)) {
				return src
					.replace(/\/images\/+thumb\/+/, "/images/")
					.replace(/\/([0-9a-f]+)_[0-9]+x[0-9]+[a-z]?(\.[^/.]*)(?:[?#].*)?$/, "/$1$2");
			}
			if (domain === "file.mk.co.kr" ||
				domain_nosub === "mediapundit.net") {
				newsrc = src.replace(/\.thumb(?:[?#].*)?$/, "");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "kobis.or.kr") return src.replace(/\/thumb\/+thn_/, "/");
			if (domain_nowww === "breaknews.com") return src.replace(/\/data\/([^/]*)\/mainimages\/[0-9]*\/([0-9]{6})/, "/imgdata/$1/$2/$2");
			if (domain_nowww === "ilyo.co.kr" ||
				domain_nowww === "beatsports.net" ||
				domain_nowww === "ohfun.net") {
				return src.replace(/\/thm[0-9]+_/, "/");
			}
			if (domain_nowww === "joseilbo.com") {
				return src
					.replace(/\.thumbnail(\.[^/.]*)$/, "$1")
					.replace(/\/gisa_img\/([0-9]+_[^/._]+)(\.[^/.]*)$/, "/gisa_img_origin/$1_origin$2");
			}
			if (domain_nosub === "phncdn.com") {
				match = src.match(/\/pics\/+albums\/+(?:[0-9]+\/+){3}([0-9]+)\/+/);
				if (match) {
					return {
						url: "https://www.pornhub.com/photo/" + match[1],
						is_pagelink: true
					};
				}
			}
			if (domain_nowww === "pornhub.com") {
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+photo\/+([0-9]+)(?:[?#].*)?$/,
					query_for_id: "https://www.pornhub.com/photo/${id}",
					process: function(done, resp, cache_key) {
						var imagesrc = get_meta(resp.responseText, "twitter:image:src"); //og:image is thumbnail
						if (!imagesrc) {
							console_error(cache_key, "Unable to find source image for", resp);
							return done(null, false);
						}
						var obj = {
							url: imagesrc.replace(/:\/\/di\./, "://ci."), // normalize to avoid excessive redirects
							extra: {
								page: resp.finalUrl
							}
						};
						var caption = get_meta(resp.responseText, "twitter:title");
						if (caption) {
							obj.extra.caption = caption;
						}
						return done(obj, 6 * 60 * 60);
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain_nosub === "pornhub.com") {
				match = src.match(/^[a-z]+:\/\/[^/]+\/+(?:view_video\.php\?(?:.*&)?viewkey=|embed\/+)([^&]+).*$/);
				if (!match) {
					match = src.match(/^[a-z]+:\/\/[^/]+\/+embed\/+([^?&#]+)(?:[?#].*)?$/);
				}
				if (match) {
					id = match[1];
					var get_pornhub_videodata = function(key, cb) {
						var cache_key = "pornhub_video:" + key;
						api_cache.fetch(cache_key, cb, function(done) {
							options.do_request({
								url: "https://www.pornhub.com/view_video.php?viewkey=" + key,
								method: "GET",
								onload: function(resp) {
									if (resp.readyState !== 4) {
										return;
									}
									if (resp.status !== 200) {
										console_error(resp);
										return done(null, false);
									}
									var match = resp.responseText.match(/<script[^>]*>\s*var (flashvars_[0-9]+) = ({.*});\s*var player_mp4_seek\s*=\s*\S+;(?:\s*\/\/.*)?\s*(var ra[0-9a-z]{10,}\s*=.*;)?/);
									if (!match) {
										console_error("Unable to find flashvars match", resp);
										return done(null, false);
									}
									var vartable = {};
									try {
										vartable[match[1]] = JSON_parse(match[2]);
									} catch (e) {
										console_error(e, resp);
										return done(null, false);
									}
									var main_name = match[1];
									var obfuscated = match[3];
									if (!obfuscated) {
										return done(vartable[main_name], 3 * 60 * 60);
									}
									var tokens = [];
									var current_token = "";
									var in_comment = false;
									var escaping = false;
									var in_string = false;
									var commit_token = function() {
										if (current_token.length > 0) {
											tokens.push(current_token);
											current_token = "";
										}
									};
									for (var i = 0; i < obfuscated.length; i++) {
										var c = obfuscated[i];
										if (in_comment) {
											if (c === "/" && obfuscated[i - 1] === "*") {
												in_comment = false;
												continue;
											} else {
												continue;
											}
										}
										if (escaping) {
											current_token += c;
											escaping = false;
											continue;
										}
										if (in_string) {
											current_token += c;
											if (c === in_string) {
												in_string = false;
												commit_token();
											}
											continue;
										}
										if (/\s/.test(c)) {
											commit_token();
											continue;
										}
										if (/["']/.test(c)) {
											commit_token();
											current_token += c;
											in_string = c;
											continue;
										}
										if (/[\[\]=;+:,{}]/.test(c)) {
											commit_token();
											current_token = c;
											commit_token();
											continue;
										}
										if (c === "\\") {
											escaping = true;
											continue;
										}
										if (c === "/" && obfuscated[i + 1] === "*") {
											in_comment = true;
											i++;
											continue;
										}
										current_token += c;
									}
									var eval_varvalue = function(varvalue) {
										var newvalues = [];
										for (var i = 0; i < varvalue.length; i++) {
											var currentvalue = varvalue[i];
											currentvalue = currentvalue.replace(/^'(.*)'$/, '"$1"'); // TODO: handle "
											if (currentvalue === "+")
												continue;
											if (varvalue[i] in vartable) {
												currentvalue = vartable[varvalue[i]];
												var currentname = null;
												var startbracket = -1;
												var had_startbracket = false;
												for (; (i + 1) < varvalue.length; i++) {
													if (varvalue[i] === "[") {
														startbracket = i;
														had_startbracket = true;
														continue;
													} else if (!had_startbracket) {
														break;
													}
													if (varvalue[i] === "]") {
														had_startbracket = false;
														currentname = varvalue.slice(startbracket + 1, i);
														currentvalue = currentvalue[eval_varvalue(currentname)];
														continue;
													}
												}
												currentvalue = JSON_stringify(currentvalue);
											}
											if (i > 1 && varvalue[i - 1] === "+") {
												var lastvalue = JSON_parse(newvalues[newvalues.length - 1]);
												newvalues[newvalues.length - 1] = JSON_stringify(lastvalue + JSON_parse(currentvalue));
											} else {
												newvalues.push(currentvalue);
											}
										}
										return JSON_parse(newvalues.join(" "));
									};
									for (var i = 0; i < tokens.length; i++) {
										var token = tokens[i];
										if (token === "var") {
											var varname = tokens[i + 1];
											i += 3; // =
											var begin = i;
											for (; i < tokens.length; i++) {
												if (tokens[i] === ";")
													break;
											}
											var varvalue = tokens.slice(begin, i);
											vartable[varname] = eval_varvalue(varvalue);
										} else if (token in vartable) {
											var parent_table = vartable;
											var currentname = token;
											var startbracket = -1;
											var had_startbracket = false;
											i++;
											for (; (i + 1) < tokens.length; i++) {
												if (tokens[i] === "[") {
													startbracket = i;
													had_startbracket = true;
													continue;
												} else if (!had_startbracket) {
													break;
												}
												if (tokens[i] === "]") {
													had_startbracket = false;
													parent_table = parent_table[currentname];
													currentname = tokens.slice(startbracket + 1, i);
													currentname = eval_varvalue(currentname);
													continue;
												}
											}
											i++; // =
											var begin = i;
											for (; i < tokens.length; i++) {
												if (tokens[i] === ";")
													break;
											}
											var varvalue = tokens.slice(begin, i);
											parent_table[currentname] = eval_varvalue(varvalue);
										}
									}
									done(vartable[main_name], 3 * 60 * 60);
								}
							});
						});
					};
					var get_pornhub_obj = function(data, cb) {
						var obj = {
							url: null,
							headers: {
								Accept: "*/*",
								Origin: "https://www.pornhub.com",
								Referer: "https://www.pornhub.com/",
								"sec-fetch-dest": "empty",
								"sec-fetch-mode": "cors",
								"sec-fetch-site": "cross-site"
							},
							extra: {}
						};
						if (data.link_url) {
							obj.extra.page = data.link_url;
						}
						if (data.video_title) {
							obj.extra.caption = data.video_title;
						}
						if (!data.mediaDefinitions) {
							return cb(obj);
						}
						var process_mediadef = function(def) {
							if (typeof def.quality === "string")
								def.quality = parseInt(def.quality);
							if (typeof def.quality === "number")
								def.quality = [def.quality];
						};
						var mediadefs = [];
						var fetchurls = [];
						array_foreach(data.mediaDefinitions, function(def) {
							process_mediadef(def);
							if (!is_array(def.quality) || !def.quality.length) {
								if (def.remote && def.videoUrl) {
									fetchurls.push(def.videoUrl);
								} else {
									console_warn("Unable to find quality for", def, "in", data);
								}
								return;
							}
							mediadefs.push(def);
						});
						var get_largest_quality = function(x) {
							return x.sort().reverse()[0];
						};
						var final = function() {
							mediadefs.sort(function(a, b) {
								var a_quality = get_largest_quality(a.quality);
								var b_quality = get_largest_quality(b.quality);
								if (!a_quality || !b_quality)
									return 0;
								var diff = b_quality - a_quality;
								if (diff)
									return diff;
								return b.quality.length - a.quality.length;
							});
							var urls = [];
							array_foreach(mediadefs, function(def) {
								var video = true;
								if (def.format === "hls") {
									video = "hls";
								}
								if (!def.videoUrl) {
									return;
								}
								urls.push({
									url: def.videoUrl,
									video: video,
									is_private: true // linked to ip
								});
							});
							if (data.image_url)
								urls.push(data.image_url);
							return cb(fillobj_urls(urls, obj));
						};
						var waiting = false;
						var finished = 0;
						array_foreach(fetchurls, function(url) {
							api_query("pornhub_url: " + url, {
								url: url,
								imu_mode: "ajax",
								headers: {
									Referer: "https://www.pornhub.com/"
								},
								json: true
							}, function(data) {
								if (data)
									array_extend(mediadefs, data);
								finished++;
								if (finished >= fetchurls.length)
									final();
							}, function(done, resp, cache_key) {
								if (!is_array(resp) || !resp.length) {
									console_error(cache_key, "Invalid response", resp);
									return done(null, false);
								}
								array_foreach(resp, process_mediadef);
								return done(resp);
							});
							waiting = true;
						});
						if (!waiting)
							final();
					};
					page_nullobj = {
						url: src,
						is_pagelink: true
					};
					if (options.do_request && options.cb) {
						get_pornhub_videodata(id, function(data) {
							if (!data) {
								return options.cb(page_nullobj);
							}
							get_pornhub_obj(data, function(obj) {
								if (!obj)
									return options.cb(page_nullobj);
								obj.push(page_nullobj);
								return options.cb(obj);
							});
						});
						return {
							waiting: true
						};
					} else {
						return page_nullobj;
					}
				}
			}
			if (host_domain_nosub === "pornhub.com" && options.element) {
				newsrc = common_functions["get_pagelink_host_el_matching"](options, {
					url_match: /^[a-z]+:\/\/[^/]+\/+view_video\.php\?(.*&)?viewkey=/,
					el_match: function(x) {
						return x.tagName.toLowerCase() === "video-element" && x.hasAttribute("unique-id");
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain_nowww === "pornkai.com") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]+\/+view\?(?:.*&)?key=(ph[0-9a-z]+)(?:&.*)?$/, "https://pornhub.com/view_video.php?viewkey=$1");
				if (newsrc !== src) {
					return {
						url: newsrc,
						is_pagelink: true
					};
				}
			}
			if (host_domain_nowww === "youporn.com") {
				newsrc = common_functions["get_pagelink_host_el_matching"](options, {
					url_match: /^[a-z]+:\/\/[^/]+\/+(?:watch|embed)\/+([0-9]+)(?:\/+(?:[^/]+\/*)?)?(?:[?#].*)?$/,
					el_match: function(x) {
						return x.tagName === "DIV" && x.id === "videoContainer";
					}
				});
				if (newsrc && newsrc.url !== src)
					return newsrc;
			}
			if (domain_nosub === "t8cdn.com" ||
				domain_nosub === "ypncdn.com") {
				newsrc = src
					.replace(/\/[0-9]+x[0-9]+\/+([0-9]+)(?:[(][a-z]+=[^/)]*\)){1,}([^/]*)$/, "/originals/$1$2")
					.replace(/(\/originals?\/+[0-9]+(?:\/+[^/]*?)?)(?:[(][a-z]+=[^/)]*\)){1,}([^/]*)$/, "$1$2");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nosub === "rdtcdn.com" && /^[a-z]i\./.test(domain)) {
				newsrc = src
					.replace(/\.webp(?:[?#].*)?$/, ".jpg")
					.replace(/\/m=[^/]*\/+_thumbs\/+/, "/m=/_thumbs/")
					.replace(/\/m=[^/]*\/+(_thumbs\/+gallery\/.*_[0-9]+_)\/+[^/]+-([0-9]+\.[^/.]+)(?:[?#].*)?$/, "/m=/$1$2");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nosub === "rdtcdn.com" ||
				domain_nowww === "redtube.com" ||
				domain_nowww === "redtube.com.br" ||
				domain === "embed.redtube.com") {
				page_nullobj = null;
				var get_redtube_id_from_url = function(url) {
					var match = url.match(/:\/\/[^/]+\/+(?:m=[^/]+\/+)?media\/+videos\/+[0-9]{6}\/+[0-9]{2}\/+([0-9]+)\/+/);
					if (match) {
						return match[1];
					}
					match = url.match(/:\/\/embed\.[^/]+\/+\?(?:.*&)?id=([0-9]+)/);
					if (!match) {
						match = url.match(/:\/\/(?:www\.)redtube\.com\/+([0-9]+)(?:[?#].*)?$/);
					}
					if (match) {
						page_nullobj = {
							url: url,
							is_pagelink: true
						};
						return match[1];
					}
					return null;
				};
				var query_redtube = function(id, cb) {
					var cache_key = "redtube:" + id;
					api_cache.fetch(cache_key, cb, function(done) {
						options.do_request({
							url: "https://www.redtube.com/" + id,
							method: "GET",
							onload: function(resp) {
								if (resp.status !== 200) {
									console_error(cache_key, resp);
									return done(null, false);
								}
								var match = resp.responseText.match(/page_params\.video_player_setup[\s\S]+playervars:\s*({.*}),/);
								if (!match) {
									console_error(cache_key, "Unable to find match for", resp);
									return done(null, false);
								}
								try {
									var json = JSON_parse(match[1]);
									return done(json, 60 * 60);
								} catch (e) {
									console_error(cache_key, e);
								}
								return done(null, false);
							}
						});
					});
				};
				var get_obj_from_redtube_info = function(data) {
					var baseobj = {
						extra: {
							page: data.link_url,
							caption: data.video_title
						}
					};
					var max = 0;
					var maxobj = null;
					for (var i = 0; i < data.mediaDefinitions.length; i++) {
						var media = data.mediaDefinitions[i];
						var our_quality = parseInt(media.quality);
						if (!isNaN(our_quality) && our_quality > max && media.videoUrl) {
							max = our_quality;
							maxobj = media;
						}
					}
					var urls = [];
					if (maxobj) {
						urls.push({
							url: maxobj.videoUrl,
							video: true,
							headers: {
								Referer: baseobj.extra.page,
								Origin: "https://redtube.com"
							}
						});
					}
					urls.push(data.image_url);
					return fillobj_urls(urls, baseobj);
				};
				id = get_redtube_id_from_url(src);
				if (id) {
					obj = {
						url: src,
						extra: {
							page: "https://www.redtube.com/" + id
						}
					};
					if (page_nullobj)
						obj.is_pagelink = true;
					if (options.do_request && options.cb) {
						query_redtube(id, function(data) {
							if (!data) {
								return options.cb(obj);
							}
							var newobj = get_obj_from_redtube_info(data);
							if (!is_array(newobj))
								newobj = [newobj];
							newobj.push(obj);
							return options.cb(newobj);
						});
						return {
							waiting: true
						};
					}
					return obj;
				}
			}
			if (domain_nowww === "tube8.com") {
				var fetch_tube8_flashvars = function(id, cb) {
					api_query("tube8_flashvars:" + id, {
						url: "https://www.tube8.com/a/a/" + id + "/"
					}, cb, function(done, resp, cache_key) {
						var match = resp.responseText.match(/var\s+flashvars\s*=\s*({.*?})\s*; *\n/);
						if (!match) {
							console_error(cache_key, "Unable to find match", resp);
							return done(null, false);
						}
						try {
							var json = JSON_parse(match[1]);
							done(json, 6 * 60 * 60);
						} catch (e) {
							console_error(cache_key, e);
							return done(null, false);
						}
					});
				};
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+[^/]+\/+[^/]+\/+([0-9]+)\/*(?:[?#].*)?$/,
					run: function(cb, match) {
						var id = match[1];
						fetch_tube8_flashvars(id, function(data) {
							var origsrc = src;
							if (options._internal_info && options._internal_info.mediadefinition_src) {
								origsrc = options._internal_info.mediadefinition_src;
							}
							cb(common_functions["parse_mediadefinition"](origsrc, data, cache_key));
						});
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain_nowww === "youporn.com") {
				var fetch_youporn_flashvars = function(id, cb) {
					api_query("youporn_flashvars:" + id, {
						url: "https://www.youporn.com/watch/" + id + "/"
					}, cb, function(done, resp, cache_key) {
						var match = resp.responseText.match(/(?:page_params.video.mediaDefinition\s*=|\s+mediaDefinition:)\s*(\[{.*?}\])\s*[;,] *\n/);
						if (!match) {
							console_error(cache_key, "Unable to find match", resp);
							return done(null, false);
						}
						try {
							var mediaDefinition = JSON_parse(match[1]);
							var json = {
								link_url: resp.finalUrl,
								mediaDefinition: mediaDefinition
							};
							done(json, 6 * 60 * 60);
						} catch (e) {
							console_error(cache_key, e);
							return done(null, false);
						}
					});
				};
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+(?:watch|embed)\/+([0-9]+)(?:\/+(?:[^/]+\/*)?)?(?:[?#].*)?$/,
					run: function(cb, match) {
						var id = match[1];
						fetch_youporn_flashvars(id, function(data) {
							var origsrc = src;
							if (options._internal_info && options._internal_info.mediadefinition_src) {
								origsrc = options._internal_info.mediadefinition_src;
							}
							cb(common_functions["parse_mediadefinition"](origsrc, data, cache_key));
						});
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain_nowww === "xtube.com") {
				var fetch_xtube_flashvars = function(id, cb) {
					api_query("xtube_flashvars:" + id, {
						url: "https://www.xtube.com/video-watch/a-" + id
					}, cb, function(done, resp, cache_key) {
						var match = resp.responseText.match(/var playerConf\s*=\s*({.*?}),\s*loaderConf/);
						if (!match) {
							console_error(cache_key, "Unable to find match", resp);
							return done(null, false);
						}
						try {
							var match1 = match[1].replace(/![01]/g, "\"true\"");
							var fixup = fixup_js_obj_proper(match1);
							var playerconf = JSON_parse(fixup);
							var json = playerconf.mainRoll;
							json.link_url = json.videoUrl;
							json.video_title = json.title;
							done(json, 6 * 60 * 60);
						} catch (e) {
							console_error(cache_key, e, match);
							return done(null, false);
						}
					});
				};
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+video-watch\/+[^/]+-([0-9]+)\/*(?:[?#].*)?$/,
					run: function(cb, match) {
						var id = match[1];
						fetch_xtube_flashvars(id, function(data) {
							var origsrc = src;
							if (options._internal_info && options._internal_info.mediadefinition_src) {
								origsrc = options._internal_info.mediadefinition_src;
							}
							cb(common_functions["parse_mediadefinition"](origsrc, data, cache_key));
						});
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain_nosub === "xtube.com" && /^cdn[0-9]*-/.test(domain)) {
				match = src.match(/^[a-z]+:\/\/[^/]+\/+m=[^/]+\/+videos\/+[0-9]{6}\/+[0-9]{1,2}\/+([0-9]+)\/+/);
				if (match) {
					id = match[1];
					options._internal_info.mediadefinition_src = src;
					return {
						url: "https://www.xtube.com/video-watch/a-" + id,
						is_pagelink: true
					};
				}
			}
			if (domain_nosub === "t8cdn.com" || domain_nosub === "ypncdn.com") {
				id = src.match(/:\/\/[^/]+\/+[0-9]{6}\/+[0-9]{1,2}\/+([0-9]+)\/+(?:vl_|[0-9]+[pP]_[0-9]+[kK]_|(?:[0-9]+x[0-9]+|originals?)\/+(?:[0-9]+\/+[^/]+-[0-9]+|[0-9]+(?:[(][a-z]+=[^/)]*\)){0,})\.)/);
				if (id) {
					id = id[1];
					options._internal_info.mediadefinition_src = src;
					if (domain_nosub === "t8cdn.com") {
						return {
							url: "https://www.tube8.com/a/a/" + id + "/",
							is_pagelink: true
						};
					} else if (domain_nosub === "ypncdn.com") {
						return {
							url: "https://www.youporn.com/watch/" + id + "/",
							is_pagelink: true
						};
					}
				}
			}
			if (domain === "cci.xnxx.fan") return src.replace(/(\/original\/)(?:\([a-z]+=[^/)]*\))*([^/]*)$/, "$1$2");
			if (domain === "img.fril.jp") return src.replace(/\/[a-z]\/([^/]*)$/, "/l/$1");
			if (domain === "img.cinematoday.jp") {
				newsrc = src
					.replace(/-[a-z0-9]*x[a-z0-9]*(\.[^/.]*)$/, "$1")
					.replace(/\/_size_[^/]*\//, "/_size_rx9999/");
				return {
					url: newsrc,
					head_wrong_contentlength: true
				};
			}
			if (domain_nosub === "seesaa.net" ||
				(domain_nowww === "fanblogs.jp" && string_indexof(src, "/file/") >= 0)) {
				return src.replace(/-thumbnail[0-9]*(\.[^/.]*)(?:[?#].*)?$/, "$1");
			}
			if (domain_nosub === "ledevoir.com" && domain.match(/media[0-9]*\.ledevoir\.com/)) {
				return src.replace(/\/images_galerie\/(?:[^-/._]*_)?([0-9]+_[0-9]+)\//, "/images_galerie/nwdp_$1/");
			}
			if (domain_nowww === "infotel.ca") return src.replace(/\/medialibrary\/image\/[^-_/.]*-/, "/medialibrary/image/orig-");
			if ((domain_nowww === "eleconomista.com.mx" && string_indexof(src, "/img/") >= 0) ||
				(domain_nowww === "informador.mx" && string_indexof(src, "/img/") >= 0) ||
				(domain_nowww === "eldeber.com.bo" && string_indexof(src, "/img/") >= 0) ||
				(domain_nowww === "chispa.tv" && string_indexof(src, "/img/") >= 0) ||
				(domain_nowww === "debate.com.mx" && string_indexof(src, "/img/") >= 0) ||
				(domain_nowww === "diarioshow.com" && string_indexof(src, "/img/") >= 0) ||
				(domain === "wp.eldeber.com.bo" && string_indexof(src, "/img/") >= 0) ||
				(domain_nowww === "tribuna.com.mx" && string_indexof(src, "/img/") >= 0) ||
				(domain_nowww === "nacionrex.com" && string_indexof(src, "/img/") >= 0) ||
				(domain_nowww === "enpareja.com" && string_indexof(src, "/img/") >= 0) ||
				(domain_nowww === "filo.news" && string_indexof(src, "/img/") >= 0) ||
				(domain_nowww === "laverdadnoticias.com" && string_indexof(src, "/img/") >= 0) ||
				(domain_nowww === "rosario3.com" && string_indexof(src, "/img/") >= 0) ||
				(domain_nowww === "soycarmin.com" && string_indexof(src, "/img/") >= 0) ||
				src.match(/^[a-z]+:\/\/[^/]*\/(?:__)?export\/+(?:[0-9]{10,}\/+)?sites\/+[^/]+\/+img\/+(?:[^/]*\/+)?[0-9]{4}\/+[0-9]{2}\/+[0-9]{2}\/+[^/]*\.[^/._]*_[0-9]{5,}\.[^/.]*(?:_[0-9]{5,}\.[^/.]*)?(?:[?#].*)?$/)) {
				return src.replace(/(\/[^/.]*\.[^/]*)_[0-9]+\.[^/._]*$/, "$1");
			}
			if (domain === "gcm-v2.omerlocdn.com") return src.replace(/_[0-9]+(\.[^/.]*)$/, "$1");
			if (domain === "www.dailystar.com.lb" ||
				domain === "dailystar.com.lb") {
				return src.replace(/([0-9]+)(?:_[^0-9][^/.]*)*(\.[^/.]*)$/, "$1$2");
			}
			if (domain === "images.dailykos.com") return src.replace(/(\/(?:images|avatars)\/[0-9]+\/)[^/]*\/([^/]*)$/, "$1original/$2");
			if (domain === "i.pixl.li") {
				if (/image3b64ca9d2cf0688e\./.test(src)) {
					return {
						url: src,
						bad: true
					};
				}
			}
			if (domain_nosub === "jpg.church") return src.replace(/(:\/\/(?:[^/]+\.)?)jpg\.church\/+/, "$1host.church/");
			if (domain_nowww === "imgmax.com" ||
				domain_nowww === "404store.com" ||
				domain_nowww === "imgpost.co.uk" ||
				domain === "ap.imagensbrasil.org" ||
				domain_nowww === "picture-post.com" ||
				domain_nowww === "stakimages.me" ||
				domain_nowww === "imgsnap.com" ||
				domain === "img.imgmax.com" ||
				domain === "i.img.ie" ||
				domain === "i.lensdump.com" ||
				domain === "img.faploads.com" ||
				(domain_nowww === "celebact.org" && string_indexof(src, "/images/") >= 0) ||
				domain_nosub === "imghost.io" ||
				domain_nosub === "img26.com" ||
				(domain_nowww === "cheapesthosting.xyz" && src.match(/\/i\/+images\//)) ||
				domain_nowww === "s4tu.com" ||
				domain_nowww === "jiopic.com" ||
				domain_nowww === "beautifulmodels.xyz" ||
				domain === "images.superimg.com" ||
				(domain_nowww === "ultraimg.com" && string_indexof(src, "/images/") >= 0) ||
				(domain_nowww === "celebfeetpics.com" && string_indexof(src, "/images/") >= 0) ||
				(domain_nowww === "lolzilla.net" && string_indexof(src, "/images/") >= 0) ||
				(domain_nowww === "extraimage.net" && string_indexof(src, "/images/") >= 0) ||
				(domain_nowww === "celebphotos.club" && string_indexof(src, "/images/") >= 0) ||
				(domain_nowww === "image.farm" && string_indexof(src, "/images/") >= 0) ||
				(domain_nowww === "girlspic.net" && string_indexof(src, "/images/") >= 0) ||
				(domain_nowww === "tgfimage.rocks" && string_indexof(src, "/images/") >= 0) ||
				(domain_nowww === "imgfy.net" && string_indexof(src, "/images/") >= 0) ||
				(domain_nosub === "picho.st" && /^s[0-9]*\./.test(domain)) ||
				domain_nowww === "imagenup.com" ||
				(domain_nowww === "imgz.pw" && /\/ch\/+images\//.test(src)) ||
				(domain_nowww === "xxximg.art" && string_indexof(src, "/images/") >= 0) ||
				(domain_nosub === "tag-fox.com" && /^data[0-9]*\./.test(domain)) ||
				(domain_nosub === "gifyu.com" && string_indexof(src, "/images/") >= 0) ||
				domain_nowww === "iili.io" ||
				domain_nowww === "privacypic.com" ||
				(domain_nosub === "imgcredit.xyz" && /^s[0-9]*\./.test(domain)) ||
				(domain_nowww === "imgcloud.pw" && string_indexof(src, "/images/") >= 0) ||
				(domain_nosub === "imgmak.com" && string_indexof(src, "/images/") >= 0) ||
				(domain_nowww === "pixio.pw" && string_indexof(src, "/images/") >= 0) ||
				(domain_nosub === "jpg.church" && /^simp[0-9]*\./.test(domain)) ||
				(domain_nosub === "host.church" && /^simp[0-9]*\./.test(domain)) ||
				(domain_nosub === "jpg5.su" && /^simp[0-9]*\./.test(domain)) ||
				(domain_nowww === "photoloading.com" && string_indexof(src, "/images/") >= 0) ||
				(domain_nosub === "lensdump.com" && /^i[0-9]*\./.test(domain)) ||
				domain === "i.pixl.li" ||
				(domain_nosub === "picturedent.org" && string_indexof(src, "/images/") >= 0) ||
				(domain_nosub === "media-storage.net" && /^s[0-9]\./.test(domain)) ||
				domain === "imagehost.thasnasty.com" ||
				domain_nowww === "img.kiwi" ||
				domain_nowww === "add.pics" ||
				domain_nowww === "putmega.com" ||
				domain_nowww === "image-bugs.com") {
				return src.replace(/\.(?:th|md)(\.[^/.]*)$/, "$1");
			}
			if (domain_nowww === "imgpile.com" && /\/images\//.test(src)) {
				return {
					url: src.replace(/\.(?:th|md)(\.[^/.]*)$/, "$1"),
					headers: {
						"Accept": "*/*"
					}
				};
			}
			if (domain_nowww === "cheapesthosting.xyz") return src.replace(/\/upload\/[a-z]+(\/[0-9]+\/[0-9]+\/[0-9]+\/)/, "/upload/big$1");
			if (domain === "static.maxmodels.pl") {
				if (string_indexof(src, "/photos/") >= 0 || string_indexof(src, "/article/") >= 0) {
					return src.replace(/_thumb(\.[^/.]*)$/, "$1");
				}
				if (string_indexof(src, "/profile/") >= 0) {
					return src.replace(/_[a-z]+(\.[^/.]*)$/, "_profile$1");
				}
			}
			if (domain_nosub === "img.yt") {
				return src.replace("/small/", "/big/");
			}
			if (domain === "cdn.wallpaperjam.com") return src.replace(/\/static\/images\/.*?\/([a-f0-9]+)(\.[^/.]*)$/, "/$1/image$2");
			if (domain === "cdn.oboi7.com") return src.replace(/\/static\/images\/[a-z]\//, "/content/images/");
			if (domain === "media.tabloidbintang.com") return src.replace(/\/thumb\/([^/]*\.[^/.]*)(?:\/.*)/, "/$1");
			if (domain === "media.teen.co.id") return src.replace(/\/thumb\/([^/?]*\.[^/.?]*).*?[?&](p=[^&]*).*/, "/view/$1?$2");
			if (domain === "cdn.imgchest.com") return src.replace(/\/files\/+thumb\//, "/files/");
			if ((domain_nosub === "hudong.com" && string_indexof(domain, ".att.hudong.com") >= 0) ||
				(domain_nowww === "eiga-board.com" && string_indexof(src, "/assets/medias/") >= 0) ||
				(domain_nowww === "kaigai-drama-board.com" && string_indexof(src, "/assets/medias/") >= 0)) {
				newsrc = src.replace(/_s(\.[^/.]*)$/, "$1");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nosub === "hudong.com" && string_indexof(domain, ".att.hudong.com") >= 0) {
				return src.replace(/_[0-9]+(\.[^/.]*)$/, "$1");
			}
			if (domain_nowww === "ihanyu.com") return src.replace(/\/cache\/([^/]*)\/([^/]*\/[0-9]+\/[0-9]+\/)[0-9]+\/([0-9]+\.[^/.]*)$/, "/uploadfile/$1/$2$3");
			if (domain_nowww === "gongl8.com" ||
				domain === "upload.mcchina.com" ||
				domain_nowww === "suanning.com" ||
				domain === "upload.site.cnhubei.com" ||
				domain_nowww === "artsbj.com" ||
				domain === "upload.taihainet.com" ||
				domain === "news.yule.com.cn" ||
				domain === "upload.sanqin.com" ||
				domain === "upload.art.ifeng.com" ||
				domain === "uploads.rayli.com.cn" ||
				(domain_nosub === "ablwang.com" && domain.match(/m[0-9]*\.ablwang\.com/)) ||
				(domain_nosub === "m1905.cn" && domain.match(/image[0-9]*\.m1905\.cn/)) ||
				domain_nowww === "ozanyerli.com" ||
				domain_nowww === "entline.cn" ||
				domain === "img.ixiumei.com" ||
				domain_nowww === "69876.com" ||
				domain === "222.186.12.239") {
				newsrc = src.replace(/(\/[0-9]{4}\/+[0-9]{4}\/+)thumb_[0-9]+_(?:[0-9]+_){0,2}([0-9]{8,})(?:_watermark)?(\.[^/.]+)(?:[?#].*)?$/, "$1$2$3");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "imgsh.jpnxcn.com" ||
				domain === "img.94hnr.com" ||
				domain === "img.cancai.net" ||
				domain === "img.sexbeautygirl.com" ||
				(domain_nosub === "huanqiu.com" && /^himg[0-9]*\./.test(domain)) ||
				domain === "file.acgxmanga.com") {
				return src.replace(/\/thumb_[0-9]+_[0-9]+_/, "/");
			}
			if (domain_nowww === "gaobei.com" &&
				string_indexof(src, "/upload/") >= 0) {
				return src.replace(/_[a-z](\.[^/.]*)$/, "_b$1");
			}
			if (domain_nowww === "urlebird.com") {
				match = src.match(/^[a-z]+:\/\/[^/]+\/+video\/+(?:[^/?#]+-)?([0-9]{10,})\/*(?:[?#].*)?$/);
				if (match) {
					return {
						url: "https://www.tiktok.com/@a/video/" + match[1],
						is_pagelink: true
					};
				}
			}
			if (host_domain_nowww === "urlebird.com" && options.element) {
				if (!src && options.element.classList.contains("overlay")) {
					return {
						url: origsrc,
						bad: "mask"
					};
				}
				if (domain_nowww !== "tiktok.com" && options.element.parentElement && options.element.parentElement.parentElement) {
					var dparent = options.element.parentElement.parentElement;
					if (dparent.classList.contains("thumb")) {
						var a = dparent.querySelector("a[href*=video]");
						if (a) {
							return {
								url: a.href,
								is_pagelink: true
							};
						}
					}
				}
			}
			if (host_domain_nosub === "tiktok.com" && options.element) {
				if (options.element.tagName === "DIV" && options.element.classList.contains("play-button")) {
					return {
						url: origsrc,
						bad: "mask"
					};
				}
			}
			if (domain_nowww === "tiktok.com") {
				var query_tiktok_url = function(url, cb) {
					var normalized_url = url
						.replace(/^[a-z]+:\/\//, "https://")
						.replace(/:\/\/[^/]*tiktok\.com\/+/, "://www.tiktok.com/")
						.replace(/\/*(?:[?#].*)?$/, "");
					var cache_key = "tiktok_nextdata:" + normalized_url;
					api_cache.fetch(cache_key, cb, function(done) {
						options.do_request({
							url: url.replace(/#.*/, ""),
							method: "GET",
							onload: function(resp) {
								if (resp.readyState < 4)
									return;
								if (resp.status !== 200) {
									console_error(resp);
									return done(null, false);
								}
								var match = resp.responseText.match(/<script[^>]+id="__UNIVERSAL_DATA_FOR_REHYDRATION__"[^>]*>({.*?})<\/script>/);
								if (!match)
									match = resp.responseText.match(/<script[^>]+id="SIGI_STATE"[^>]*>({.*?})\s*<\/script>/);
								if (!match) {
									console_error("Unable to find sigi match", resp);
									return done(null, false);
								}
								try {
									var json = JSON_parse(match[1]);
									if (json.__DEFAULT_SCOPE__) {
										json = json.__DEFAULT_SCOPE__["webapp.video-detail"];
									}
									return done(json, 60 * 60);
								} catch (e) {
									console_error(e);
									return done(null, false);
								}
							}
						});
					});
				};
				var query_tiktok_post = function(params, cb) {
					var url = "https://www.tiktok.com/@" + params.username + "/video/" + params.web_vid;
					return query_tiktok_url(url, cb);
				};
				var query_tiktok1 = function(params, cb) {
					var url = "https://www.tiktok.com/node/share/video/@" + params.username + "/" + params.web_vid + "?request_from=server";
					var cache_key = "tiktok_node:" + params.username + "/" + params.web_vid;
					api_query(cache_key, {
						url: url,
						json: true
					}, cb, function(done, resp) {
						if (!resp || !resp.itemInfo || !resp.itemInfo.itemStruct) {
							console_error(cache_key, "Unable to get tiktok info from API", resp, params);
							return done(null, false);
						}
						done(resp, 60 * 60);
					});
				};
				var query_tiktok_appapi = function(params, cb) {
					if (!options.rule_specific || !options.rule_specific.tiktok_app_api) {
						return cb(null);
					}
					var cache_key = "tiktok_appapi:" + params.username + "/" + params.web_vid;
					api_query(cache_key, {
						url: "https://api2.musical.ly/aweme/v1/feed/?aweme_id=" + params.web_vid,
						headers: {
							"User-Agent": "TikTok 32.6.0 rv:326001 (iPhone; iOS 17.1.2; en_US) Cronet"
						},
						json: true
					}, cb, function(done, resp) {
						var found_item = null;
						for (var _i = 0, _a = resp.aweme_list; _i < _a.length; _i++) {
							var item = _a[_i];
							if (item.aweme_id === params.web_vid) {
								found_item = item;
								break;
							}
						}
						if (!found_item) {
							console_error(cache_key, "Unable to find", params.web_vid, "from API", resp);
							return done(null, false);
						}
						return done(found_item, 60 * 60);
					});
				};
				var tiktok_api_to_obj = function(data) {
					if (!data || !data.itemInfo || !data.itemInfo.itemStruct) {
						return null;
					}
					try {
						var item = data.itemInfo.itemStruct;
						var caption = item.desc;
						var baseobj_2 = {
							extra: {
								caption: caption
							},
							headers: {
								"accept": "*/*",
								referer: "https://www.tiktok.com/",
								"sec-fetch-dest": "video",
								"sec-fetch-mode": "no-cors",
								"sec-fetch-site": "same-site"
							},
							cookie_url: "https://www.tiktok.com/",
							can_head: false,
						};
						if (data.metaParams && data.metaParams.canonicalHref) {
							baseobj_2.extra.page = data.metaParams.canonicalHref;
						} else {
							baseobj_2.extra.page = "https://www.tiktok.com/@" + item.author.uniqueId + "/video/" + item.id;
						}
						var urls_3 = [];
						for (var _i = 0, _a = item.video.bitrateInfo; _i < _a.length; _i++) {
							var bri = _a[_i];
							var codec = null;
							if (bri.CodecType === "h265_hvc1") {
								codec = "hevc";
							} else if (bri.CodecType !== "h264") {
								console_warn("Unknown codec type for", bri);
							}
							if (!bri.PlayAddr.UrlList.length || !bri.PlayAddr.UrlList[0]) {
								console_warn("Skipping", bri);
								continue;
							}
							urls_3.push({
								url: bri.PlayAddr.UrlList[0],
								media_info: {
									type: "video",
									codec: codec
								}
							});
						}
						var finalobj = fillobj_urls(urls_3, baseobj_2);
						for (var _b = 0, finalobj_1 = finalobj; _b < finalobj_1.length; _b++) {
							var obj_2 = finalobj_1[_b];
							common_functions["set_tiktok_vid_filename"](obj_2);
						}
						return finalobj;
					} catch (e) {
						console_error(e);
						return null;
					}
				};
				var tiktok_sigiapi_to_obj = function(data, id) {
					if (!data || !data.ItemModule || !(id in data.ItemModule)) {
						console_warn("Unable to find", id, "in", data);
						return null;
					}
					try {
						var item = data.ItemModule[id];
						var videourl = item.video.downloadAddr || item.video.playAddr;
						var caption = item.desc;
						var obj = {
							url: videourl,
							extra: {
								caption: caption,
								author_username: item.author,
								created_date: parse_int(item.createTime) * 1000,
								page: "https://www.tiktok.com/@" + item.authorId + "/video/" + item.id
							},
							headers: {
								"accept": "*/*",
								referer: "https://www.tiktok.com/",
								"sec-fetch-dest": "video",
								"sec-fetch-mode": "no-cors",
								"sec-fetch-site": "same-site"
							},
							cookie_url: "https://www.tiktok.com/",
							video: true,
							can_head: false,
						};
						common_functions["set_tiktok_vid_filename"](obj);
						return obj;
					} catch (e) {
						console_error(e, data);
						return null;
					}
				};
				var tiktok_live_sigiapi_to_obj = function(data) {
					if (!data || !data.LiveRoom) {
						console_warn("Unable to find LiveRoom in", data);
						return null;
					}
					try {
						var userinfo = data.LiveRoom.liveRoomUserInfo.user;
						var streamdata_str = data.LiveRoom.liveRoomUserInfo.liveRoom.streamData.pull_data.stream_data;
						var streamdata = JSON_parse(streamdata_str);
						var obj = {
							url: streamdata.data.origin.main.hls,
							extra: {
								author_username: userinfo.uniqueId,
								page: "https://www.tiktok.com/@" + userinfo.uniqueId + "/live"
							},
							headers: {
								"accept": "*/*",
								origin: "https://www.tiktok.com",
								referer: "https://www.tiktok.com/",
								"sec-fetch-dest": "none",
								"sec-fetch-mode": "no-cors",
								"sec-fetch-site": "cross-site"
							},
							media_info: {
								type: "video",
								delivery: "hls",
								is_live: true
							}
						};
						return obj;
					} catch (e) {
						console_error(e, data);
						return null;
					}
				};
				var tiktok_webvideo_to_obj = function(data, id) {
					if (data.itemInfo) {
						return tiktok_api_to_obj(data);
					} else {
						return tiktok_sigiapi_to_obj(data, id);
					}
				};
				var tiktok_appapi_to_obj = function(data) {
					if (!data || !data.video) {
						console_warn("Unable to find data in", data);
						return null;
					}
					try {
						var obj = {
							url: data.video.bit_rate[0].play_addr.url_list[0],
							extra: {
								caption: data.desc,
								author_username: data.author.unique_id,
								created_date: parse_int(data.create_time) * 1000,
								page: "https://www.tiktok.com/@" + data.author.unique_id + "/video/" + data.aweme_id
							},
							headers: {
								"accept": "*/*",
								referer: "https://www.tiktok.com/",
								"sec-fetch-dest": "video",
								"sec-fetch-mode": "no-cors",
								"sec-fetch-site": "same-site"
							},
							cookie_url: "https://www.tiktok.com/",
							video: true,
							can_head: false,
						};
						common_functions["set_tiktok_vid_filename"](obj);
						return obj;
					} catch (e) {
						console_error(e, data);
						return null;
					}
				};
				var remove_tiktok_watermark = function(obj, cb) {
					var page = null;
					var sobj = obj;
					if (is_array(obj))
						sobj = obj[0];
					if (sobj.extra && sobj.extra.page)
						page = sobj.extra.page;
					common_functions["tiktok_remove_watermark"](api_cache, options, sobj.url, page, function(newurl) {
						if (newurl) {
							sobj = fillobj_urls([newurl], sobj)[0];
						}
						if (!common_functions["set_tiktok_vid_filename"](sobj)) {
							delete sobj.filename;
						}
						if (is_array(obj))
							obj[0] = sobj;
						return cb(obj);
					});
				};
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+(@[^/]+)\/+live(?:[?#].*)?$/,
					run: function(cb, match) {
						query_tiktok_url("https://www.tiktok.com/" + match[1] + "/live", function(data) {
							if (!data)
								return cb(null);
							var obj = tiktok_live_sigiapi_to_obj(data);
							return cb(obj);
						});
					}
				});
				if (newsrc)
					return newsrc;
				var params = common_functions["get_tiktok_weburl_parts"](src);
				if (params) {
					page_nullobj = {
						url: src,
						is_pagelink: true
					};
					var finalcb = function(obj) {
						if (!obj) {
							var match = src.match(/#imu-video=(https?:\/\/.*)$/);
							if (match) {
								return options.cb([{
										url: src,
										video: true,
										can_head: false
									}, page_nullobj]);
							} else {
								return options.cb(page_nullobj);
							}
						} else {
							remove_tiktok_watermark(obj, function(obj) {
								if (!is_array(obj))
									obj = [obj];
								obj.push(page_nullobj);
								return options.cb(obj);
							});
						}
					};
					query_tiktok_appapi(params, function(data) {
						if (!data) {
							query_tiktok_post(params, function(data) {
								if (!data) {
									return finalcb(null);
								}
								finalcb(tiktok_webvideo_to_obj(data, params.web_vid));
							});
							return;
						}
						finalcb(tiktok_appapi_to_obj(data));
					});
					return {
						waiting: true
					};
				}
			}
			if (host_domain_nosub === "tiktok.com" && options && options.cb && options.do_request && options.element) {
				var current = options.element;
				while (current) {
					if (current.tagName === "A" && /\/@[^/]+\/+video\/+[0-9]+\/*(?:[?#].*)?$/.test(current.href)) {
						var pageurl = current.href;
						var video_query = current.querySelector("video");
						if (video_query && video_query.src && /(?:muscdn|tiktokcdn)\.com\//.test(video_query.src)) {
							pageurl += "#imu-video=" + video_query.src;
						}
						return {
							url: pageurl,
							is_pagelink: true
						};
					}
					current = current.parentElement;
				}
				var params = common_functions["get_tiktok_weburl_parts"](options.host_url);
				if (params) {
					return {
						url: options.host_url,
						is_pagelink: true
					};
				}
			}
			if ((domain_nosub === "muscdn.com" || domain_nosub === "tiktokcdn.com") && /^v[0-9]+m?\./.test(domain)) {
				var baseobj_3 = {
					url: src,
					video: true,
					can_head: false // 503 sometimes
				};
				common_functions["set_tiktok_vid_filename"](baseobj_3);
				if (options.do_request && options.cb && options.rule_specific && options.rule_specific.tiktok_no_watermarks) {
					common_functions["get_best_tiktok_url"](api_cache, options.do_request, src, function(newurl) {
						if (newurl) {
							baseobj_3.url = newurl;
						}
						common_functions["set_tiktok_vid_filename"](baseobj_3);
						options.cb(baseobj_3);
					});
					return {
						waiting: true
					};
				} else {
					return baseobj_3;
				}
			}
			if ((domain_nosub === "pstatp.com" ||
				domain_nosub === "ipstatp.com" ||
				domain_nosub === "sgpstatp.com")
				&& domain.match(/[pi][a-z]?[0-9]*\./) ||
				domain === "p16-tiktokcdn-com.akamaized.net" ||
				domain === "p16-va-default.akamaized.net" ||
				((domain_nosub === "tiktokcdn.com" ||
					domain_nosub === "tiktokmusic.me" ||
					domain_nosub === "resso.me" ||
					domain_nosub === "tiktokcdn-us.com" ||
					domain_nosub === "hypstarcdn.com") &&
					(/^p[0-9]+(?:-[^/]+)?\./.test(domain) && !/-sign[-.]/.test(domain))) ||
				domain === "p16-hypstarcdn-com.akamaized.net" ||
				domain_nosub === "bytecdn.cn" ||
				domain_nosub === "byteimg.com" ||
				domain_nosub === "ibyteimg.com" ||
				domain_nosub === "ibytedtos.com" ||
				domain_nosub === "douyinpic.com" ||
				domain_nosub === "toutiaoimg.com" ||
				domain_nosub === "bytexservice.com" ||
				domain_nosub === "muscdn.com") {
				newsrc = src
					.replace(/\?imageView2.*/, "")
					.replace(/(\/[0-9a-f]{10,})\.a?webp$/, "$1.png")
					.replace(/\.avif$/, ".png")
					.replace(/^([a-z]+:\/\/[^/]+\/+)([^/.:~]+)~(?:[^/.:]+:0:0|noop)\./, "$1origin/$2.")
					.replace(/(~[^/.:]+-[^/.:]+):[0-9]+:[0-9]+(\.(?:webp|avif))(?:[?#].*)?$/, "$1:0:0$2")
					.replace(/(:\/\/[^/]+\/+origin\/.*\.[a-z]+)\.[a-z]+(?:[?#].*)?$/, "$1")
					.replace(/(:\/\/[^/]+\/+)(?:medium|large|obj|img|aweme|list)\/+(?:[0-9]+x[0-9]+\/+)?((?:.*?\/+)?[^/~]+)(?:~noop)?(\.[^/.]+)?(?:[?#].*)?$/, "$1origin/$2$3")
					.replace(/(:\/\/[^/]+\/+)((?:(?:tos|musically)-(?:maliva|alisg|cn|us[a-z]+[0-9]*[a-z]*)-[^/]+|tiktok-obj|web\.[^/]+)\/+.*)$/, "$1img/$2")
					.replace(/(:\/\/[^/]+\/+.*?)\.image(?:[?#].*)?$/, "$1.png")
					.replace(/\/details\/+v1\/+[wh][0-9]+\/+/, "/origin/")
					.replace(/~[^/.?#:]+:0:0(\.[^/.?#]+)$/, "~noop$1")
					.replace(/(:\/\/[^/]+\/+(?:medium|large|obj|img|aweme|list)\/+.*)~[^/.?#]+(\.[^/.?#]+)?(?:[?#].*)?$/, "$1~noop$2");
				newsrc = remove_queries(newsrc, ["from"]);
				obj = {
					url: newsrc, /*src
						.replace(/(:\/\/[^/]*\/+)(?:medium|large|obj|aweme|list)\/+(?:[0-9]+x[0-9]+\/+)?/, "$1origin/")
						.replace(/(:\/\/[^/]+\/+.*?)\.image(?:[?$].*)?$/, "$1.jpg")
						.replace(/\/img\/+(.+\/+[0-9a-f]{10,}(?:_[0-9]+)?(?:\/+[^/]+|\.[^/.~?#]+)?)~noop(\.[^/.]*)(?:[?#].*)?$/, "/origin/$1$2")
						.replace(/(\/origin\/+.+\/+[0-9a-f]{10,}\/+[^/.]+\.[^/.]+)\.[^/.]+$/, "$1")
						.replace(/(\/img\/+.+\/+[0-9a-f]{10,}(?:\/+[^/]+|\.[^/.~?#]+)?~)[^/.]*?(\.[^/.]*)(?:[?#].*)?$/, "$1noop$2")
						.replace(/(:\/\/[^/]+\/+)(tos-[^/]+\/+.*)/, "$1img/$2")
						.replace(/\?imageView2.*$/, ""),*/
					can_head: false // 404
				};
				if (/^v[0-9]*\./.test(domain) && string_indexof(src, "/video/") >= 0) {
					obj.video = true;
				}
				return obj;
			}
			if (false) {
				newsrc = src
					.replace(/(\/img\/+[^/]*\/+[0-9a-f]+~)[^/.]*?(\.[^/.]*)(?:[?#].*)?$/, "$1noop$2")
					.replace(/\/large(\/+[^/]*\/+[0-9a-f]+)(?:\.[^/.]*)?(?:[?#].*)?$/, "/img$1~noop.jpeg")
					.replace(/\/(?:aweme|list)\/+[0-9]+x[0-9]+\/+/, "/obj/")
					.replace(/\?imageView2.*/, "");
				if (newsrc !== src)
					return newsrc;
				return {
					url: src,
					can_head: false // 404
				};
			}
			if (domain_nosub === "tiktokcdn.com" && /^p[0-9]*-sign-[^/.]+\./.test(domain)) {
				return src.replace(/(:\/\/p[0-9]+-)sign-([^/]+\/[^?#]+)(?:[?#].*)?$/, "$1$2");
			}
			if (domain_nosub === "tiktokcdn.com" && /^p[0-9]*-sign-(?:va|sg)\./.test(domain)) {
				return src.replace(/:\/\/[^/]+\/+([^?#&]+)(?:[?#].*)?$/, "://p16-amd-va.tiktokcdn.com/$1");
			}
			if (domain_nosub === "tiktokcdn-us.com" && /^p[0-9]*-sign/.test(domain)) {
				return src.replace(/:\/\/(p[0-9]+)-sign(?:-[^/.]+)?(\.[^?#]+)(?:[?#].*)?$/, "://$1$2");
			}
			if (domain_nosub === "bcyimg.com" && /^p[0-9]*-bcy-sign\./.test(domain)) {
				return src.replace(/:\/\/[^/]+\/+(banciyuan\/[^?#&]+)(?:[?#].*)?$/, "://p1-bcy.byteimg.com/img/$1");
			}
			if (host_domain_nowww === "bcy.net" && !src && options.element) {
				var parent_1 = options.element.parentElement;
				if (parent_1 && parent_1.tagName === "A") {
					var dparent_1 = parent_1.parentElement;
					if (dparent_1 && dparent_1.tagName === "DIV" && dparent_1.classList.contains("publish-loaf")) {
						return {
							url: origsrc,
							bad: "mask"
						};
					}
				}
			}
			if (domain === "img-bcy-qn.pstatp.com") {
				return src
					.replace(/(\/post\/[a-z0-9]+\/[a-z0-9]+\.[^/.]*)\/[^/]*(?:[?#].*)?$/, "$1")
					.replace(/(\/avatar\/[0-9]+\/[a-f0-9]+\/[^/]*\.[^/.]*)\/[^/]*(?:[?#].*)?$/, "$1");
			}
			if (domain === "tuchong.pstatp.com") {
				return add_full_extensions(src.replace(/(\/[0-9]+\/+)[a-z](?:t[0-9]+)?(\/+[0-9]+\.[^/.]*)(?:[?#].*)?$/, "$1f$2"));
			}
			if (domain === "p16-sg-default.akamaized.net") return src.replace(/^[a-z]+:\/\/[^/]+\/+china-img\/+/, "https://p0.pstatp.com/");
			if (domain_nosub === "tiktokcdn.com" && /^v[0-9]*m?(?:-[^.]+)?\./.test(domain) && string_indexof(src, "/video/") >= 0) {
				return {
					url: src,
					video: true,
					can_head: false,
					headers: {
						Referer: "https://www.tiktok.com/"
					}
				};
			}
			if (domain === "img.jizy.cn") return src.replace(/\/img\/[a-z]\//, "/img/l/");
			if (domain === "v.img.pplive.cn") return src.replace(/(:\/\/[^/]*\/)sp[0-9]+\//, "$1");
			if (domain === "uploadfile.bizhizu.cn") return src.replace(/(\/[0-9a-f]*\.)([^/.]*)(?:\.[0-9]+\.[0-9]+\.[^/.]*)?$/, "$1$2.source.$2");
			if (domain_nosub === "tgbusdata.cn" ||
				domain_nosub === "tuwandata.com") {
				return src.replace(/.*\/thumb\/[^/]*\/[^/]*\/u\//, "http://");
			}
			if (domain_nowww === "dajiazhao.com" ||
				domain_nowww === "hscbw.com" ||
				domain_nowww === "xgkoushi.com" ||
				domain_nowww === "youdew88yl.com" ||
				domain_nowww === "nvshenmen.com" ||
				domain_nowww === "sfyry.com" ||
				domain_nowww === "ynjzsf.com" ||
				src.match(/:\/\/[^/]*\/+(?:uploads|upfile)\/+allimg\/+[0-9]{6,8}\/+[0-9]+-[0-9A-Z]+-lp\.[^/.]*(?:[?#].*)?$/)) {
				return src.replace(/(\/(?:uploads|upfile)\/+allimg\/+[0-9]+\/+[0-9A-Z]+(?:-[0-9A-Z]+)?)(?:-lp)(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			}
			if (domain_nosub === "taopic.com" && domain.match(/^pic[0-9]*\./)) {
				return src.replace(/:\/\/pic([0-9]*\.[^/]*\/[0-9]+\/[0-9]+-[A-Z0-9]+)-[a-z]+(\.[^/.]*)$/, "://img$1$2");
			}
			if (domain_nowww === "renwenjun.com") return src.replace(/_lit(\.[^/.]*)$/, "_0$1");
			if (domain_nowww === "9x2.net" ||
				(domain_nosub === "izaoxing.com" && /^img[0-9]*\./.test(domain))) {
				return src.replace(/_lit(\.[^/.]*)$/, "$1");
			}
			if (domain_nowww === "lrfczp.com") return src.replace(/_[0-9]+_[0-9]+(\.[^/.]*)$/, "$1");
			if (domain === "img-toutiao.mia.com") {
				return src.replace(/\&.*/, ""); // removing @ works, but forces download, and very big images have imgScale so it's probably fine
			}
			if (domain_nosub === "xeeok.com" && string_indexof(domain, "pic.xeeok.com") >= 0) {
				return src.replace(/_s[0-9]*(\.[^/.]*)$/, "$1");
			}
			if (domain === "img.laonanren.com" ||
				(domain_nosub === "imhentai.xxx" && /^m[0-9]+/.test(domain) && /\/[0-9a-z]+\/+[0-9]+t\./.test(src)) ||
				domain === "cf.whl4u.jp") {
				return src.replace(/t(\.[^/.]*)$/, "$1");
			}
			if (domain_nosub === "xuite.net" && string_indexof(domain, ".share.photo.xuite.net") >= 0) {
				return src.replace(/_[a-zA-Z](\.[^/.]*)$/, "_y$1");
			}
			if (domain === "img.sportsv.net") return src.replace(/\/[a-z]+-([^-/]*)-[0-9a-z]*x[0-9a-z]*(\.[^/.]*)$/, "/$1$2");
			if (domain_nosub === "espncdn.com") {
				newsrc = decodeURIComponent(src.replace(/\/combiner\/i\?img=([^&]*).*/, "$1"));
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/(\/r[0-9]+(?:_[0-9]+)?)(?:_[^/.]*)(\.[^/.]*)$/, "$1$2");
				if (newsrc !== src)
					return newsrc;
			}
			if (host_domain_nosub === "fc2.com" && options.element) {
				if (options.element.tagName === "svg" && options.element.parentElement && options.element.parentElement.tagName === "DIV") {
					if (string_indexof(options.element.parentElement.getAttribute("class"), "c-videoThumbOver") >= 0)
						return {
							url: origsrc,
							bad: "mask"
						};
				}
			}
			if (domain_nosub === "fc2.com" && domain.match(/blog-imgs-[0-9]*(?:-[^.]*)?.*\.fc2\.com/)) {
				newsrc = src.replace(/:\/\/(blog-imgs-[0-9]*)\./, "://$1-origin.");
				if (newsrc !== src)
					return newsrc;
				return src.replace(/s(\.[^/.]*)$/, "$1");
			}
			if (domain === "blogthumbnail.fc2.com") return src.replace(/:\/\/[^/]+\/+r[0-9]+\/+([0-9]+)\/+/, "://blog-imgs-$1.fc2.com/");
			if (domain === "video.fc2.com") {
				var query_fc2 = function(pageurl, token, id, cb) {
					api_query("fc2_api:" + id, {
						url: "https://video.fc2.com/api/v3/videoplaylist/" + id + "?sh=1&fs=0",
						imu_mode: "xhr",
						headers: {
							Referer: pageurl,
							"X-FC2-Video-Access-Token": token
						},
						json: true
					}, cb, function(done, json, cache_key) {
						var playlist = json.playlist;
						var newurl = playlist.nq || playlist.sample;
						if (!newurl) {
							console_error(cache_key, "Unable to find playlist URL", json);
							return done(null, false);
						}
						var obj = {
							url: urljoin(pageurl, newurl, true),
							extra: {
								page: pageurl
							},
							headers: {
								Referer: pageurl
							},
							referer_ok: {
								same_domain_nosub: true
							},
							video: true
						};
						return done(obj, 6 * 60 * 60);
					});
				};
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+(?:a\/+)?content\/+([0-9a-zA-Z]+)(?:[?#&].*)?$/,
					query_for_id: "https://video.fc2.com/content/${id}",
					process: function(done, resp, cache_key, match) {
						var id = match[1];
						var match = resp.responseText.match(/window\.FC2VideoObject\.push\(\['..',\s*'([0-9a-f]{10,})'/);
						if (!match) {
							console_error(cache_key, "Unable to find access token for", resp);
							return done(null, false);
						}
						var token = match[1];
						query_fc2(resp.finalUrl, token, id, function(data) {
							if (!data)
								return done(null, false);
							return done(data, 6 * 60 * 60);
						});
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain_nosub === "fc2.com" && /^(?:vip-)?video[0-9]*-thumbnail[0-9]*\./.test(domain)) {
				obj = {
					url: src
				};
				id = null;
				match = src.match(/\/up\/+thumb[0-9]*\/+[0-9]{6}\/+[0-9]{2}\/+.\/+([0-9]{8}[a-zA-z0-9]+)\./);
				if (match) {
					id = match[1];
					obj.extra = { page: "https://video.fc2.com/content/" + id };
				}
				newsrc = src.replace(/^[a-z]+:\/\/[^/]+\/+(?:[wh][0-9]+){1,2}\/+([^/]+\.fc2\.com\/)/, "http://$1");
				if (newsrc !== src)
					return fillobj_urls([newsrc, src], obj);
				newsrc = src.replace(/(\/member\/+[0-9]+\/+[0-9]+\/+mb_pict_)icon_/, "$1");
				if (newsrc !== src)
					return fillobj_urls([newsrc, src], obj);
				newsrc = src.replace(/\/up\/+thumb\/+([0-9]{6}\/+)/, "/up/thumb2/$1");
				if (newsrc !== src)
					return fillobj_urls([newsrc, src], obj);
				if (id) {
					return {
						url: obj.extra.page,
						is_pagelink: true
					};
				}
				return obj;
			}
			if (domain_nosub === "fc2.com" && /^contents-thumbnail[0-9]*\./.test(domain)) {
				return src.replace(/:\/\/[^/]+\/+w[0-9]+\/+(storage[0-9]+\.contents\.fc2\.com\/)/, "://$1");
			}
			if (domain === "photos.hancinema.net" ||
				domain_nowww === "hancinema.net") {
				return src.replace(/\/photos\/[a-z]*(photo[0-9]*\.[^/.]*)$/, "/photos/fullsize$1");
			}
			if (domain_nowww === "inimura.com" ||
				domain_nowww === "celebritydresses.shop" ||
				domain_nowww === "thecelebritydresses.us" ||
				domain_nowww === "customcelebritydresses.com" ||
				domain_nowww === "realistgold.com" ||
				domain_nowww === "supersoccershop.com" ||
				domain_nowww === "cheap-promdresses.com" ||
				domain_nowww === "weandestudio.com" ||
				domain_nowww === "black-leatherjacket.com" ||
				domain_nowww === "kpopultra.net" ||
				domain_nowww === "myhaircare.com.au" ||
				domain_nowww === "ultimateapparels.com" ||
				domain_nowww === "cajalwinterconference.es" ||
				domain_nowww === "justfashionnow.com" ||
				domain === "mall.3785tv.com" ||
				domain_nowww === "layla-lingerie.com" ||
				domain_nowww === "fnac-andorra.com" ||
				domain_nowww === "keymailrecords.com" ||
				domain_nowww === "bdmaster.net" ||
				domain_nowww === "prettyzone.net" ||
				domain_nowww === "filmstarjackets.com" ||
				domain_nowww === "moviesjacket.com" ||
				domain_nowww === "af-hobby.com" ||
				domain_nowww === "sky-seller.com" ||
				domain_nowww === "i-aurai.com" ||
				domain_nowww === "onesieponatime.com" ||
				domain_nowww === "ucanstarjob.com" ||
				domain === "beniko.ninethemes.net" ||
				domain_nowww === "duvardamoda.com" ||
				domain_nowww === "fresh38.ru" ||
				domain_nowww === "malaysiadropship.com" ||
				domain_nowww === "yukite.ru" ||
				domain_nowww === "huzzk.com" ||
				domain_nowww === "gasookpopgalore.net" ||
				domain_nowww === "honeydear.my" ||
				domain_nowww === "americasuits.com" ||
				src.match(/^[a-z]+:\/\/[^/]+\/+image\/+cache\/+(?:data|catalog)\/.*-[0-9]+x[0-9]+\.[^/.]+(?:[?#].*)?$/)) {
				return src
					.replace(/\/image_cache\/+resize\/+[0-9]+x[0-9]+\/+image\/+/, "/image/")
					.replace(/\/cache\/(.*)-[0-9]+x[0-9]*(?:-[a-z_]+)?(?:_[0-9]+|[wh])?(?:\.[a-z_]+)?(\.[^/.]*(?:[?#].*)?)$/, "/$1$2");
			}
			if (domain_nowww === "outlookweekly.net" && string_indexof(src, "/images/") >= 0) {
				return src.replace(/.*:\/\/[^/]*\/images\//, "http://");
			}
			if (domain === "www.cdn.tv2.no" ||
				domain === "image.klikk.no" ||
				domain === "image.side2.no" ||
				domain === "image.side3.no" ||
				domain_nowww === "dagbladet.no" ||
				domain_nowww === "seher.no" ||
				domain === "image.underdusken.no" ||
				domain === "image.seiska.fi" ||
				domain === "image.elle.no" ||
				domain === "image.nyheder.dk" ||
				domain_nowww === "dbstatic.no") {
				newsrc = src
					.replace(/(:\/\/[^/]+\/+(?:images\/+)?[0-9]+\.[^/.?#]*)(?:[?#].*)?$/, "$1?width=-1&height=-1")
					.replace(/\/(?:images)?\?(?:.*&)?imageId=([0-9]+).*/, "/?imageId=$1&height=-1")
					.replace(/(\/[0-9]+\.webp\?width=-1&height=-1)$/, "$1&format=jpg");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nowww === "media-spiceee.net") return src.replace(/\/(?:large|small|thumb_lg|thumb)_([^/]*)$/, "/$1");
			if (domain_nowww === "vettri.net") return src.replace(/\/thumb\/([^/]*)_resize(\.[^/.]*)$/, "/$1$2");
			if (domain_nowww === "tiarashop.eu" ||
				domain_nowww === "streetstylestore.com" ||
				domain_nowww === "asog-labs.com" ||
				domain_nowww === "dreamline.com" ||
				domain_nowww === "techno-import.fr" ||
				domain === "cdn.poplook.com" ||
				domain_nowww === "directgardening.com" ||
				domain_nowww === "kanedashop.com" ||
				domain_nowww === "myamericanmarket.com" ||
				domain_nowww === "lapakfiguremiina.com" ||
				domain_nowww === "donnashape.com" ||
				(domain_nosub === "nin-nin-game.com" && domain.match(/^media[0-9]*\.nin/)) ||
				domain_nowww === "adintime.com" ||
				domain === "shop.marymary.gr" ||
				domain_nowww === "evawigs.com" ||
				domain_nowww === "tehrankbs.pw" ||
				domain_nowww === "ticketshow.ma" ||
				domain_nowww === "asiaworldmusic.fr" ||
				domain_nowww === "kpopmart.com" ||
				domain_nowww === "planetongames.com" ||
				domain_nowww === "baba.es" ||
				domain_nowww === "teamworldshop.it" ||
				domain_nowww === "donnemetropolitane.it" ||
				domain_nowww === "extremehobby.eu" ||
				domain_nowww === "besto24.com" ||
				domain === "static.footshop.com" ||
				domain_nowww === "rosendy.com" ||
				domain_nowww === "ultimateselfcare.com" ||
				domain_nowww === "tucano.com" ||
				domain_nowww === "project-38music.nl" ||
				domain_nowww === "recordsalbums.com" ||
				domain_nowww === "libreriaeldesvan.com" ||
				domain_nowww === "fortunapost.com" ||
				domain_nowww === "flyhighstore.pl" ||
				/^[a-z]+:\/\/[^/]+\/+[0-9]+-(?:home|large|thickbox)_default\/+[^/.]+\.jpg(?:[?#].*)?$/.test(src)) {
				newsrc = src.replace(/(\/img\/+p\/+(?:[0-9]\/+){1,}[0-9]+)[-_][^/.]*(\.[^/.]*)$/, "$1$2");
				if (newsrc !== src)
					return newsrc;
				var prefix = "(://[^/]+/+";
				if (domain_nowww === "donnemetropolitane.it" ||
					domain_nowww === "project-38music.nl") {
					prefix += "shop/+";
				} else if (domain_nowww === "ultimateselfcare.com") {
					prefix += "en/+";
				}
				newsrc = src.replace(new RegExp(prefix + "[0-9]+(?:-[0-9]+)?)(?:[-_][^/]*?)?(\/[^/]*)$"), "$1$2");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "skinzwearphotography.com") return src.replace(/\/prod[A-Z][a-z]*\//, "/prodImages/");
			if (domain_nowww === "dubiobikinis.com") return src.replace(/(\/prodimages\/+[^/]*(?:-[A-Z]|_[0-9]+))t(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain_nowww === "shelot.com") return src.replace(/\/upload\/thumbnails\/[0-9]+x[0-9]+[^/]*\//, "/upload/");
			if (domain === "xo.lulus.com") return src.replace(/(\/images\/[^/]*\/)[^/]*\/([^/]*)$/, "$1w_1.0/$2");
			if (domain_nowww === "in-tense.se") {
				return src
					.replace(/\/thumbnails\/[^/]*\//, "/")
					.replace(/(\.[^/._])*_[^/]*$/, "$1");
			}
			if (domain === "image.brazilianbikinishop.com") return src.replace(/\/cache_images\/([^/_]*)_[^/.]*(\.[^/.]*)$/, "/$1$2");
			if (domain === "i.embed.ly" ||
				domain === "i-cdn.embed.ly") {
				newsrc = src.replace(/.*\/(?:display|image).*?[?&]url=([^&]*).*/, "$1");
				if (newsrc !== src)
					return decodeuri_ifneeded(newsrc);
			}
			if (domain === "i.genius.com") {
				return decodeURIComponent(src.replace(/.*\/[0-9a-f]+.*?[?&]url=([^&]*).*/, "$1"));
			}
			if (domain_nowww === "hdqwalls.com") {
				return src
					.replace(/\/wallpapers\/[a-z]?thumb\//, "/wallpapers/");
			}
			if (domain_nowww === "wallpaperclicker.com") {
				if (src.match(/\/storage\/+Thumb\/+/)) {
					return [
						src.replace(/\/storage\/+Thumb\/+/, "/storage/wallpaper/"),
						src.replace(/\/storage\/+Thumb\/+/, "/storage/image/")
					];
				}
				return src
					.replace(/\/download\/+Image\.aspx.*?[?&]Imagefilename=([^&]*).*?$/, "/storage/Thumb/$1")
					.replace(/\/wallpaper\/+Download\.aspx.*?[?&]wallfilename=([^&]*).*?$/, "/storage/Thumb/$1");
			}
			if (domain_nosub === "prothomalo.com") return src.replace(/\/cache\/images\/[0-9]+x[0-9]+(?:x[0-9]+)\//, "/");
			if (domain === "c.tribune.com.pk") return src.replace(/-[0-9]+-[0-9]+x[0-9]+(\.[^/.]*)$/, "$1");
			if (domain_nosub === "reutersmedia.net" ||
				domain === "static.reuters.com") {
				var queries = get_queries(src);
				if (queries.d && queries.i) {
					return src.replace(/\/r\/\?.*/, "/r/?d=" + queries.d + "&t=2&i=" + queries.i);
				}
			}
			if (domain === "r.fod4.com") return src.replace(/^[a-z]*:\/\/[^/]*\/.*\/([a-z]*:\/\/)/, "$1");
			if (domain === "p.fod4.com") return src.replace(/(\/media\/[0-9a-f]+\/)[a-z]=[a-z0-9]+\//, "$1");
			if (domain_nowww === "xdressy.com" ||
				domain_nowww === "starcelebritydresses.com") {
				return src.replace(/-thumb(\.[^/.]*)$/, "$1");
			}
			if (domain_nowww === "wallpaperflare.com" && src.match(/\/static\//)) {
				return src.replace(/-(?:thumb|preview)(\.[^/.]*)$/, "$1");
			}
			if (domain === "cdn.store-assets.com") return src.replace(/_[0-9]+x(?:[0-9]+)?(\.[^/.]*)$/, "$1");
			if (domain === "img.shopperboard.com") return src.replace(/-[a-z]+(\.[^/.]*)$/, "$1");
			if ((domain_nosub === "gog.com" ||
				domain_nosub === "gog-statics.com") && domain.match(/images.*\./)) {
				newsrc = src.replace(/(\/[0-9a-f]{10,}_bs_logo)_small(\.[^/.]+)(?:[?#].*)?$/, "$1_big$2");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/(\/[0-9a-f]{10,}_bs_background)_(?:500|800)(\.[^/.]+)(?:[?#].*)?$/, "$1_1275$2");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/(\/[0-9a-f]{10,}_product_tile_(?:349|398))(\.[^/.]+)(?:[?#].*)?$/, "$1_2x$2");
				if (newsrc !== src)
					return newsrc;
				return src.replace(/(\/[0-9a-f]*)_[^/.]*(\.[^/.]*)$/, "$1$2");
			}
			if (domain === "items.gog.com") {
				if (/\/mp4\/+[^/]+\.mp4(?:[?#].*)?$/.test(src)) {
					return {
						url: src,
						video: true
					};
				}
			}
			if (domain === "www.destructoid.com") return src.replace(/-(?:t|noscale)(\.[^/.]*)$/, "$1");
			if (domain_nosub === "xboxlive.com" &&
				domain.match(/images.*\.xboxlive\.com/) &&
				src.match(/\/image\?/)) {
				newsrc = src.replace(/\/image[^/]?[?&]url=([^&]*).*/, "/image?url=$1");
				if (newsrc !== src)
					return newsrc;
				return {
					url: src,
					head_wrong_contenttype: true
				};
			}
			if (domain === "musicimage.xboxlive.com") {
				return {
					url: src.replace(/\/image\?.*/, "/image?locale=en-US"),
					can_head: false // GET, OPTIONS
				};
			}
			if (domain === "media.withtank.com") return src.replace(/_[0-9]+_wide(\.[^/.]*)$/, "$1");
			if (domain === "images.cdn.realviewdigital.com") {
				var type_1 = src.match(/[?&]type=([^&]*)/);
				return src.replace(/\?.*/, "?type=" + type_1[1]);
			}
			if (domain === "proxy.duckduckgo.com" ||
				domain === "external-content.duckduckgo.com") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]+\/+iur?\/\?(?:.*&)?u=([^&]*).*/, "$1");
				if (newsrc !== src) {
					return decodeuri_ifneeded(newsrc);
				}
			}
			if (host_domain_nowww === "duckduckgo.com" && options.element && options.do_request && options.cb) {
				var get_query_params = function(url, cb) {
					var query = url.replace(/.*\?(?:.*&)?q=([^&]+).*?$/, "$1");
					var cache_key = "duckduckgo_imagequeryparams:" + query;
					api_cache.fetch(cache_key, cb, function(done) {
						options.do_request({
							url: url,
							method: "GET",
							onload: function(resp) {
								if (resp.readyState !== 4)
									return;
								if (resp.status !== 200) {
									console_error(resp);
									return done(null, false);
								}
								var respobj = {
									query: query,
									start: 0
								};
								var match = resp.responseText.match(/'\/[td]\.js\?(?:.*?&)?l=([^&]+)/);
								if (!match) {
									console_error("Unable to find language", resp);
									return done(null, false);
								}
								respobj.lang = match[1];
								match = resp.responseText.match(/;\s*vqd\s*=\s*["']([-0-9]{20,})["']/);
								if (!match) {
									console_error("Unable to find vqd", resp);
									return done(null, false);
								}
								respobj.vqd = match[1];
								return done(respobj, 60 * 60);
							}
						});
					});
				};
				var get_images = function(querydata, cb) {
					var cache_key = "duckduckgo_imageresults:" + querydata.query + "," + querydata.start;
					api_cache.fetch(cache_key, cb, function(done) {
						var start_query = "";
						if (querydata.start) {
							start_query = "&s=" + querydata.start;
						}
						options.do_request({
							method: "GET",
							url: "https://duckduckgo.com/i.js?l=" + querydata.lang + "&o=json&q=" + querydata.query + "&vqd=" + querydata.vqd + "&p=-1" + start_query + "&v7exp=a",
							onload: function(resp) {
								if (resp.readyState !== 4)
									return;
								if (resp.status !== 200) {
									console_error(resp);
									return done(null, false);
								}
								try {
									var json = JSON_parse(resp.responseText);
									return done(json, 60 * 60);
								} catch (e) {
									console_error(e);
									return done(null, false);
								}
							}
						});
					});
				};
				var get_bing_imageid = function(url) {
					var newurl = url.replace(/.*[?&]id=([^&]+).*/, "$1");
					if (newurl !== url)
						return newurl;
					return null;
				};
				var get_result_from_image = function(querydata, image, cb) {
					get_images(querydata, function(data) {
						if (!data) {
							return cb(null);
						}
						var image_src = decodeURIComponent(image.src);
						var image_id = get_bing_imageid(image_src);
						if (!image_id) {
							console_warn("Unable to get bing image id for" + image.src);
							return cb(null);
						}
						for (var i = 0; i < data.results.length; i++) {
							var thumbnail_id = get_bing_imageid(data.results[i].thumbnail);
							if (!thumbnail_id) {
								console_warn("Unable to get bing image id for" + data.results[i].thumbnail);
								continue;
							}
							if (image_id === thumbnail_id) {
								return cb(data.results[i].image);
							}
						}
						if (data.next) {
							var start = data.next.replace(/.*&s=([0-9]+).*$/, "$1");
							if (start !== data.next) {
								querydata.start = start;
							}
							return get_result_from_image(querydata, image, cb);
						}
						return cb(null);
					});
				};
				if (!options._internal_info || !options._internal_info.duckduckgo_host) {
					if (options.element.tagName === "IMG") {
						if (options.element.classList.contains("tile--img__img") ||
							options.element.classList.contains("module--images__thumbnails__image")) {
							options._internal_info.duckduckgo_host = true;
							get_query_params(document.location.href, function(data) {
								if (!data) {
									return options.cb(null);
								}
								get_result_from_image(data, options.element, function(url) {
									return options.cb(url);
								});
							});
							return {
								waiting: true
							};
						}
					}
				}
			}
			if (domain === "static.scientificamerican.com") return src.replace(/(?:_[^/.]*)?(\.[^/.?]*)(?:\?.*)?$/, "_source$1");
			if (domain_nosub === "qwant.com" && domain.match(/s[0-9]*\.qwant\.com/) &&
				string_indexof(src, "/thumbr/") >= 0) {
				return decodeURIComponent(src.replace(/.*[?&]u=([^&]*).*/, "$1"));
			}
			if (domain === "b.fssta.com") return src.replace(/(\/[^/.]*)\.[^/]*(\.[^/.]*)$/, "$1$2");
			if (domain_nosub === "espn.com" && domain.match(/media\..*\.espn\.com$/)) {
				return src.replace(/(\/[0-9]+\/[0-9]+\/)([^/]*)\/[^/]*(\.[^/.]*)$/, "$1$2\/$2$3");
			}
			if (domain === "img.skysports.com" ||
				domain_nosub === "365dm.com") {
				return src.replace(/(:\/\/[^/]*\/[0-9]*\/[0-9]*\/)[^/]*\/(?:[0-9]*\/)?([^/]*)$/, "$1master/$2");
			}
			if (domain_nosub === "bcbits.com" &&
				domain.match(/f[0-9]*\.bcbits\.com/) &&
				string_indexof(src, "/img/") >= 0) {
				return src.replace(/_[0-9]+(\.[^/.]*)?$/, "_0$1");
			}
			if (domain === "tent.sny.sh" ||
				domain === "tent.bloatcat.tk" ||
				domain === "tent.bloat.cat" ||
				domain === "tn.vern.cc" ||
				domain === "tent.vern.cc" ||
				domain === "bandcamp.vern.cc" ||
				domain === "tent.deep-swarm.xyz") {
				return src.replace(/\/image\.php\?(?:.*&)?file=([0-9]+_)[0-9]+(\.[^/.&#]+)?(?:[#&].*)?$/, "/image.php?file=$10$2");
			}
			if (domain_nosub === "bandcamp.com") {
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/([^/]+\/+track\/+[^/]+)\/*(?:[?#].*)?$/,
					query_for_id: "https://${id}",
					process: function(done, resp, cache_key) {
						var match = resp.responseText.match(/<script.*?data-tralbum="({[^"]+?})"/);
						if (!match) {
							console_error(cache_key, "Unable to find match for", resp);
							return done(null, false);
						}
						var json_txt = decode_entities(match[1]);
						var json = JSON_parse(json_txt);
						var trackinfo = json.trackinfo[0];
						var obj = {
							extra: {
								page: urljoin(resp.finalUrl, trackinfo.title_link, true) || resp.finalUrl,
								caption: trackinfo.title
							}
						};
						var urls = [];
						var file = trackinfo.file["mp3-128"];
						if (file) {
							urls.push({
								url: file,
								media_info: {
									type: "audio"
								}
							});
						}
						var art_fn = "a" + zpadnum(json.art_id, 10, "0") + "_0.jpg";
						urls.push("https://f4.bcbits.com/img/" + art_fn);
						return done(fillobj_urls(urls, obj), 60 * 60);
					}
				});
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nosub === "motherlessmedia.com") {
				return src
					.replace(/(:\/\/cdn[0-9]*\.)thumbs(\.motherlessmedia\.com\/)/, "$1images$2")
					.replace(/\/thumbs\//, "/images/")
					.replace(/-[a-z]*(\.[^/.?]*)(?:\?.*)?$/, "$1");
			}
			if (domain_nosub === "kiev.ua" &&
				string_indexof(domain, "shram.kiev.ua") >= 0 &&
				string_indexof(src, "/img/") >= 0) {
				return src
					.replace(/-small(\.[^/.]*)$/, "-big$1")
					.replace(/-w[0-9]+(\.[^/.]*)$/, "$1");
			}
			if (googlestorage_container === "cr-resource" &&
				string_indexof(src, "/image/") >= 0) {
				return src.replace(/\/[0-9]+(\/[0-9a-f]*\.[^/.]*)$/, "$1");
			}
			if (domain_nosub === "iol.pt" &&
				string_indexof(src, "/multimedia/") >= 0) {
				return src.replace(/(\/id\/[0-9a-f]+)\/[0-9]+(?:\.[0-9a-f]+)?(?:\.[^/.]*)?$/, "$1");
			}
			if (domain === "img.purch.com") {
				newsrc = src
					.replace(/\/[a-z]+\/[0-9]+(?:x[0-9]+)?\//, "/o/")
					.replace(/\/[a-z0-9]+-[0-9]+x[0-9]+(?:-[^/]*)?\/o\//, "/o/");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/^[a-z]+:\/\/[^/]+\/+.*?\/(aHR0c[^?#/.]+)(?:[?#.].*)?$/, "$1");
				if (newsrc !== src)
					return base64_decode(newsrc);
			}
			if ((domain_nosub === "taobaocdn.com" ||
				domain_nosub === "tbcdn.cn") &&
				domain.match(/img[0-9]*\./)) {
				return src.replace(/(\.[^/._]*)_[^/.]*\.[^/.]*$/, "$1");
			}
			if (domain === "www.musictory.com" &&
				src.match(/\/pictures\//)) {
				return src.replace(/\/pictures\/[a-z]*\//, "/pictures/originali/");
			}
			if (domain_nosub === "santabanta.com" && domain.match(/media[0-9]*\.santabanta\.com/)) {
				newsrc = src
					.replace(/_th(\.[^/.]*)$/, "$1")
					.replace(/:\/\/media\.santabanta\.com\/medium[0-9]*\//, "://media1.santabanta.com/full1/");
				if (newsrc !== src)
					return newsrc;
				if (src.match(/\/full[0-9]*\//)) {
					return [
						src.replace(/\/full[0-9]*\//, "/full8/"),
						src.replace(/\/full[0-9]*\//, "/full7/"),
						src.replace(/\/full[0-9]*\//, "/full6/"),
						src.replace(/\/full[0-9]*\//, "/full5/")
					];
				}
			}
			if (domain === "www.movieinsider.com" &&
				string_indexof(src, "/images/p/") >= 0) {
				return src.replace(/\/images\/p\/[0-9]+\//, "/images/p/");
			}
			if (domain_nosub === "kastden.org") {
				return src
					.replace(/\/thumbs\/+([^/]+)_th(\.[^/]+)(?:[?#].*)?$/, "/$1$2")
					.replace(/\/thumb\//, "/original/");
			}
			if (domain === "img.hani.co.kr") {
				return src
					.replace(/\/(?:thumbnail|resize)\//, "/original/")
					.replace(/\/[0-9]+_[0-9]+_([0-9]+_[0-9]+\.[^/.]*)$/, "/$1");
			}
			if (domain === "flexible.img.hani.co.kr") return src.replace(/:\/\/[^/]*\/flexible\/.*?\/imgdb\//, "://img.hani.co.kr/imgdb/");
			if (domain === "static.ok.co.uk" ||
				amazon_container === "static.ok.co.uk" ||
				domain === "images.24ur.com" ||
				domain === "image.dnevnik.hr" ||
				domain === "img.bg.sof.cmestatic.com" ||
				domain === "static.altchar.com" ||
				domain === "img.cz.prg.cmestatic.com" ||
				domain === "image.stirileprotv.ro" ||
				amazon_container === "ns.hitcreative.com") {
				return src
					.replace(/\?.*/, "")
					.replace(/\/media\/images\/[^/]*\//, "/media/images/original/");
			}
			if (domain_nosub === "galaxypub.vn" && domain.match(/rs[0-9]*\.galaxypub\.vn/)) {
				return src.replace(/:\/\/[^/]*(\/.*?)(?:\?.*)?$/, "://st.galaxypub.vn$1");
			}
			if (domain_nowww === "implanetcorp.com" &&
				string_indexof(src, "/upload/ctoon/") >= 0) {
				return src
					.replace(/\/[a-z]*\/([0-9]+\.[^/.]*)$/, "/original/$1");
			}
			if (domain_nowww === "doramakun.ru") return src.replace(/\/thumbs\/(.*)-[0-9]+(\.[^/.]*)$/, "/$1$2");
			if (domain === "1gr.cz") return src.replace(/(\/[0-9]+\/[0-9]+\/)[^/]*\/([^/]*)$/, "$1org/$2");
			if (domain_nosub === "ancensored.com" &&
				src.match(/\/files\/images\//)) {
				return src.replace(/(\/[0-9a-f]*)(?:_[a-z]*)?(\.[^/.]*)$/, "$1_full$2");
			}
			if (domain_nowww === "desktopbackground.org" ||
				domain_nowww === "desktop-background.com") {
				return src
					.replace(/\/download\/[^/]*\//, "/download/o/")
					.replace(/(:\/\/[^/]*)\/[pt]\//, "$1/download/o/");
			}
			if (domain === "image.mlive.com" ||
				domain === "image.nj.com" ||
				domain === "image.cleveland.com") {
				return src.replace(/:\/\/image\.([^/]*)\/home\/[a-z]+-media\/[^/]*\/img\//, "://media.$1/");
			}
			if (domain === "s9v7j7a4.ssl.hwcdn.net" ||
				domain === "data-cdn.multi.xnxx.com") {
				return src.replace(/(\/galleries\/+)[^/]+\/+([0-9a-f]{2}\/+)/, "$1full/$2");
			}
			if (domain === "k5x5n5g8.ssl.hwcdn.net" ||
				domain === "k4b8k3x5.ssl.hwcdn.net" ||
				domain === "f6j6u6m9.ssl.hwcdn.net" ||
				domain === "cdn.yavtube.com" ||
				domain === "img.yavtube.com" ||
				domain === "a2h6m3w6.ssl.hwcdn.net" ||
				domain === "p8k5i9q7.map2.ssl.hwcdn.net" ||
				domain === "cdn.elitebabes.com" ||
				domain === "c9w8v3m5.ssl.hwcdn.net") {
				newsrc = src.replace(/(\/content\/+[0-9]+\/+[^/]+-[0-9]+)_(?:[wh][0-9]+|1200)(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nowww === "xjapanese.com") return src.replace(/(\/pornpics\/.*)-pin(\.[^/.]+)(?:[?#].*)?$/, "$1$2");
			if (domain === "hwcdn.funbags.com" ||
				domain === "hwcdn.voyeurweb.com") {
				regex = /(\/albums\/+[0-9]+\/+)(?:thumb|large)\/+/;
				obj = [];
				newsrc = src.replace(regex, "$1orig/");
				if (newsrc !== src)
					obj.push(newsrc);
				newsrc = src.replace(regex, "$1large/");
				if (newsrc !== src)
					obj.push(newsrc);
				if (obj.length > 0)
					return obj;
			}
			if (domain === "aws-foto.amateri.com") return src.replace(/\/[0-9]+x[^/.]*(\.[^/.]*)$/, "/x$1");
			if (domain === "cdn.tobi.com") {
				return src
					.replace(/\/product_images\/[a-z]+\//, "/product_images/lg/")
					.replace(/(\/[^/.@]*)(\.[^/.]*)$/, "$1@2x$2");
			}
			if (domain === "www.rfa.org") {
				return src.replace(/\/@@images\/.*/, "");
			}
			if (domain === "resize.blogsys.jp") return src.replace(/^[a-z]*:\/\/.*\/([a-z]*:\/\/.*)$/, "$1");
			if (amazon_container === "bw-1651cf0d2f737d7adeab84d339dbabd3-gallery") {
				return src.replace(/_[a-z]+(\.[^/.]*)$/, "_original$1");
			}
			if (domain_nosub === "rl0.ru" && domain.match(/img[0-9]*\.rl0\.ru/)) {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/[^/]*\/+[ce]?[-0-9]+x[-0-9]+(?:[pf][0-9]+x[0-9]+)*(?:q[0-9]+)?i?\/+([^/]*\.[^/.]*\/)/, "$1");
				if (newsrc !== src)
					return add_http(newsrc);
			}
			if (domain === "news.store.rambler.ru") return src.replace(/(\/img\/+[0-9a-f]+)\?.*/, "$1?img-format=png");
			if (domain_nosub === "wanelo.com" && domain.match(/cdn-img-[0-9]+\.wanelo\.com/)) {
				return src.replace(/\/[^/.]*(\.[^/.]*)$/, "/full_size$1");
			}
			if (domain === "static.kvraudio.com") return src.replace(/(:\/\/[^/]*\/i\/)[a-z]\//, "$1b/");
			if (domain === "contents.dt.co.kr") return src.replace(/\/thum\/[0-9]+\/([0-9]{6})([0-9]+)_[^/.]*(\.[^/.]*)/, "/images/$1/$1$2$3");
			if (domain === "eng.dt.co.kr") return src.replace(/\/images\/thum\/([0-9]+)/, "/images/oriimg/$1[0]");
			if (domain === "image.ytn.co.kr" ||
				domain === "img.sciencetv.kr") {
				return src
					.replace(/(:\/\/[^/]*\/[^/]*\/jpg\/[^/]*\/[^/]*\/[0-9]+_)[a-z](\.[^/.]*)$/, "$1d$2")
					.replace(/^[a-z]+:\/\/[^/]*\/osen\/+([0-9]{4}\/+[0-9]{2}\/+)([0-9]{6})([0-9]{2})([^/]*)(?:[?#].*)?$/, "http://file.osen.co.kr/article/$1$3/$2$3$4");
			}
			if (domain === "photo.kmib.co.kr") return src.replace(/\/thumb_([0-9]+\.[^/.]*)$/, "/$1");
			if (domain === "image.kmib.co.kr") {
				var extra = {};
				match = src.match(/\/online_image\/+[0-9]{4}\/+[0-9]{4}\/+[0-9]*([0-9]{10})(?:_[0-9]+)?\.[^/.]*(?:[?#].*)?$/);
				if (match) {
					extra.page = "http://news.kmib.co.kr/article/view.asp?arcid=" + match[1];
				}
				return {
					url: src,
					extra: extra
				};
			}
			if (domain === "r.kelkoo.com") {
				newsrc = src.replace(/^[a-z]*:\/\/(?:[^/]*\/){7}(http[^/]*).*?$/, "$1");
				if (newsrc !== src)
					return decodeuri_ifneeded(newsrc);
				newsrc = src.replace(/^[a-z]+:\/\/[^/]+\/+resize\.php\?(?:.*?&)?image=([^&]+).*?$/, "$1");
				if (newsrc !== src)
					return decodeuri_ifneeded(newsrc);
			}
			if (((domain_nosub === "assetsadobe2.com" ||
				domain_nosub === "legocdn.com" ||
				domain === "store.storeimages.cdn-apple.com" ||
				domain === "media.playstation.com" ||
				domain === "images.samsung.com" ||
				domain === "images.anthropologie.com" ||
				domain_nosub === "louisvuitton.com" ||
				domain === "images.ulta.com" ||
				domain === "image.uniqlo.com" ||
				domain_nowww === "staples-3p.com" ||
				domain === "s.shld.net" ||
				domain === "assets.ray-ban.com" ||
				domain === "images.menswearhouse.com" ||
				domain === "images.shaneco.com" ||
				domain === "media.kohlsimg.com" ||
				domain === "photos.mandarinoriental.com" ||
				domain_nosub === "assetsadobe.com" ||
				domain === "images.asics.com" ||
				domain_nosub === "scene7.com") && string_indexof(src, "/is/image/") >= 0) ||
				domain === "images.asos-media.com" ||
				domain === "images.nike.com" ||
				domain === "c.shld.net" ||
				domain === "image.panasonic.com" ||
				domain === "store.storeimages.cdn-apple.com" ||
				/^[a-z]+:\/\/[^/]+\/+is\/+image\/+[^/]+\/+[^/]+(?:[?#].*)?$/.test(src)) {
				obj = { url: src };
				if (domain_nosub === "scene7.com") {
					obj.bad_if = [
						{
							headers: {
								"content-type": "image/jpeg",
								"content-length": "27898"
							}
						},
						{
							headers: {
								"content-type": "image/jpeg",
								"content-length": "5996"
							}
						}
					];
				}
				match = src.match(/\/i\/s\/.*\?(?:.*&)?(?:\$p_)?src=(https?%3A.*?)(?:&.*)?$/);
				if (match) {
					obj.url = decodeURIComponent(match[1]);
					return obj;
				}
				match = src.match(/\/is\/image\/+.*\?(?:.*?&)?(?:\$p_)?src=is(?:{|%7B)(.*?)(?:}|%7D)/);
				if (match) {
					obj.url = src.replace(/\/is\/image\/.*/, "/is/image/" + decodeURIComponent(match[1]));
					return obj;
				}
				match = src.match(/\/is\/+image\/+.*?[?&]\$product=([^&]+).*?$/);
				if (match) {
					obj.url = src.replace(/\/is\/+image\/.*/, "/is/image/" + decodeURIComponent(match[1]));
					return obj;
				}
				if (domain === "bonprix.scene7.com") {
					src = src.replace(/\/[0-9]+[wh]\/+([^/]+(?:[?#].*)?)$/, "/original/$1"); // can be anything
				}
				if (domain === "image.panasonic.com") {
					src = src.replace(/\$Thumbnail\d+\$/, "");
					return add_queries(src, {
						wid: "2000",
						hei: "2000"
					});
				}
				if (string_indexof(src, "?") < 0) {
					var basename = url_basename(src);
					var querystr = basename.replace(/.*?-qm-/, "?");
					if (querystr !== basename) {
						querystr = querystr
							.replace(/-eq-/g, "=")
							.replace(/-amp-/g, "&");
						newsrc = src.replace(/^(.*\/)[^/]+$/, "$1") + basename.replace(/(.*)?-qm-.*$/, "$1") + querystr;
						if (newsrc !== src)
							return newsrc;
					}
				}
				if (/:[0-9]+-[0-9]+\?.*$/.test(src)) {
					return src.replace(/:[0-9]+-[0-9]+(\?.*)?$/, "$1");
				}
				var srcadd = "";
				if (src.match(/\.(?:jpe?g|JPE?G)(?:\?.*)?$/))
					srcadd = "scl=1";
				else
					srcadd = "scl=1&fmt=png-alpha";
				newsrc = src.replace(/(\/is\/+image\/+.*)\?(?:.*?&)?((?:\$p_)?src)=([^&]*).*?$/, "$1?$2=$3&" + srcadd);
				if (newsrc !== src) {
					obj.url = newsrc;
					return obj;
				}
				if (!(/[?&]src=/.test(src))) {
					obj.url = src.replace(/(?:[?#].*)?$/, "") + "?" + srcadd;
					return obj;
				}
			}
			if (domain === "media.bechtle.com") return src.replace(/(\/is\/+[0-9]+\/+[0-9a-f]{20,}\/+[0-9a-f]+\/+)[a-z]+\/+/, "$1original/");
			if (domain === "sm.ign.com") return src.replace(/\.[0-9]+\.([^/.]*)$/, ".999999999999999.$1");
			if ((domain === "shop.unitedcycle.com" ||
				domain_nowww === "unicorncards.co.uk" ||
				domain_nowww === "4my3boyz.com") &&
				string_indexof(src, "/images/thumbs/") >= 0) {
				return src.replace(/_[0-9]+(\.[^/.]*)$/, "$1");
			}
			if (domain_nowww === "imgr.es") {
				return src.replace(/\/thumb(?:[?#].*)?$/, "");
			}
			if (domain_nosub === "frgimages.com" ||
				domain === "images.footballfanatics.com") {
				newsrc = decodeURIComponent(src.replace(/\/FFImage\/thumb.aspx.*?[?&]i=([^&]*).*/, "$1"));
				if (newsrc !== src)
					return newsrc;
				return src
					.replace(/_[a-z]+(\.[^/.?&]*)$/, "_full$1");
			}
			if (domain === "myanimelist.cdn-dena.com" ||
				domain === "cdn.myanimelist.net" ||
				domain_nowww === "dizigol.net") {
				return src.replace(/(:\/\/[^/]*\/)r\/+[0-9]+x[0-9]+\/+/, "$1");
			}
			if (domain === "picture-cdn.wheretoget.it") return src.replace(/(\/[a-z0-9]*-[a-z])[^/.]*(\.[^/.]*)$/, "$1$2");
			if (domain === "sl.sbs.com.au") return src.replace(/(\/public\/image\/file\/[-a-f0-9]*)\/.*/, "$1");
			if ((domain_nosub === "prezly.com" && string_indexof(domain, ".assets.prezly.com") >= 0) ||
				domain === "i.shgcdn.com" ||
				domain_nowww === "ucarecdn.com" ||
				domain === "cdn.vyper.io" ||
				domain === "assets.myzeki.com" ||
				domain === "thumb.tildacdn.com" ||
				domain === "cdn.slant.co") {
				return src.replace(/(:\/\/[^/]*\/+(?:[a-z]+)?[-a-f0-9]{30,}(?:~[0-9a-f]+)?\/+(?:nth\/+[0-9]+\/+)?).*?(?:\/([^/.]+\.[^/.]+))?(?:[?#].*)?$/, "$1$2");
			}
			if (domain_nowww === "slant.co") {
				if (/:\/\/[^/]+\/+images\/+play\.png(?:[?#].*)?$/.test(src)) {
					return {
						url: src,
						bad: "mask"
					};
				}
			}
			if (domain === "leonardo.osnova.io" ||
				domain === "images.universe.com") {
				return src.replace(/(:\/\/[^/]*\/[-a-f0-9]*\/)-\/.*/, "$1");
			}
			if (domain === "cdn.iview.abc.net.au") return src.replace(/\/thumbs\/[0-9]+\//, "/thumbs/i/");
			if (domain_nosub === "ipstatic.net") {
				newsrc = decodeURIComponent(src.replace(/.*\/img.*?[?&]url=([^&]*).*?$/, "$1"));
				if (newsrc !== src)
					return newsrc;
				return src.replace(/\/thumbs\/[0-9]+x[0-9]+\//, "/photos/");
			}
			if (domain === "image.fnnews.com") {
				return src
					.replace(/(\/[a-z]?[0-9]+)_[a-z](\.[^/.]*)/, "$1$2");
			}
			if (domain_nosub === "kym-cdn.com") {
				return add_extensions({
					url: src.replace(/(:\/\/[^/]*\/[^/]*\/(?:images|icons)\/)[^/]*\//, "$1original/"),
					is_original: true
				});
			}
			if (domain === "cmeimg-a.akamaihd.net" ||
				domain === "leafimg-a.akamaihd.net") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/(?:[0-9]+(?:x[0-9]+)?|x[0-9]+|cute-article-rcp)\/([^/.]*\.[^/]*\/.*)/, "http://$1");
				if (newsrc !== src)
					return newsrc;
				return src.replace(/^([a-z]+:\/\/[^/]*\/)(?:[0-9]+(?:x[0-9]+)?|x[0-9]+)\//, "$1default/");
			}
			if ((domain_nosub === "luxnet.ua" && domain.match(/imagecdn[0-9]*\.luxnet\.ua/)) ||
				domain_nowww === "beztabu.net" ||
				domain_nowww === "34.ua" ||
				domain_nosub === "24tv.ua" ||
				domain_nowww === "football24.ua" ||
				domain_nowww === "maximum.fm" ||
				domain_nowww === "lux.fm") {
				return src.replace(/\/[0-9]+(?:x[0-9]+|[wh])?_DIR\//, "/");
			}
			if (domain_nowww === "userstyles.org") {
				return src.replace("/style_screenshot_thumbnails/", "/style_screenshots/");
			}
			if ((domain_nosub === "narvii.com" ||
				domain_nosub === "aminoapps.com") && /^[a-z]+[0-9]*\./.test(domain)) {
				regex = /(\/[0-9a-z]+(?:-[-0-9a-z]+)?_)[^/.]*(\.[^/.]*)/;
				return [
					src.replace(regex, "$1uhq$2"),
					src.replace(regex, "$1hq$2")
				];
			}
			if (domain === "img.oastatic.com") {
				return src
					.replace(/\/img\/[0-9]+\/[0-9]+(?:\/fit)?\/([0-9]+)\/([^/]*)$/, "/img/$1/$2")
					.replace(/\/img\/([0-9]+)\/([^/]*)$/, "/img2/$1/full/$2")
					.replace(/\/imgmax\/([0-9]+)\/([^/]*)$/, "/img2/$1/full/$2")
					.replace(/(\/img2\/[0-9]+\/)[^/]*\/([^/]*)$/, "$1full/$2")
					.replace(/\/img2\/([0-9]+)\/full\/([^/]*)$/, "/imgsrc/$1/$2");
			}
			if (domain === "img.valais.ch" ||
				domain === "wsrv.nl" ||
				domain === "images.weserv.nl" ||
				(domain_nosub === "qiuzhi5.com" && domain.match(/^i[0-9]*\./)) ||
				(domain_nosub === "baaz.com" && domain.match(/^proxy[0-9]*\./)) ||
				(domain_nosub === "powr-media.com" && domain.match(/^p[0-9]*-ia\./)) ||
				domain === "nimg.ws.126.net") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/.*?[?&]url=([^&]*).*/, "$1");
				if (newsrc !== src)
					return add_http(decodeURIComponent(newsrc));
			}
			if (domain_nosub === "etsystatic.com" &&
				(domain.match(/img[0-9]*\.etsystatic\.com/) ||
					domain === "i.etsystatic.com")) {
				return src.replace(/(\/[a-z]+_)[0-9a-zA-Z]+x[0-9a-zA-Z]+\./, "$1fullxfull.");
			}
			if (domain_nosub === "twnmm.com") {
				return urljoin(src, src.replace(/^[a-z]+:\/\/[^/]*\/thumb.*?[?&]src=([^?&]*).*/, "$1"), true);
			}
			if (domain_nowww === "vuecinemas.nl") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]+\/+thumb\?(?:.*&)?src=([^&]*).*?$/, "$1");
				if (newsrc !== src)
					return urljoin(src, decodeURIComponent(newsrc), true);
			}
			if (domain === "www.findx.com" &&
				string_indexof(src, "/api/images/assets/") >= 0) {
				return src.replace(/^[a-z]+:\/\/[^/]*\/api\/images\/assets\/[^/]*\//, "");
			}
			if (domain_nowww === "konsolinet.fi") return src.replace(/(:\/\/[^/]*\/[^/]*\/)[0-9]+x[0-9]+\//, "$1");
			if ((domain_nosub === "vigbo.com" ||
				domain_nosub === "gophotoweb.com") &&
				domain.match(/^static[0-9]*\./)) {
				return src.replace(/\/[0-9]+-((?:[^/]*-)?[a-f0-9]{20,}\.[^/.]*)$/, "/2000-$1");
			}
			if (domain_nosub === "feelway.com" && domain.match(/img[0-9]*.feelway\.com/)) {
				return src.replace(/(\/[0-9]+\/)small([^/]*)$/, "$1$2");
			}
			if (domain_nosub === "pichunter.com") {
				newsrc = src.replace(/(:\/\/[^/]*\/+(?:[0-9]+\/+[0-9]+\/+[0-9]+\/+)?[0-9]+_[0-9]+)(?:_[a-z])?(\.[^/.]*)(?:[?#].*)?$/, "$1_o$2");
				if (newsrc !== src) {
					return {
						url: newsrc,
						headers: {
							Referer: "https://www.pichunter.com/"
						},
						referer_ok: {
							same_domain: true
						}
					};
				}
			}
			if (domain === "appdb.winehq.org") {
				return src.replace(/(\/appimage\.php.*?)([?&])bThumbnail=[^&]*/, "$1$2").replace(/&$/, "");
			}
			if (domain_nosub === "ikea.com" &&
				string_indexof(src, "/images/") >= 0) {
				return src.replace(/([-_][sS])[0-9](\.[^/.]*)/, "$15$2");
			}
			if (domain === "img.onestore.co.kr") return src.replace(/\/[0-9]+_[0-9]+_(?:F[0-9]+_)?[0-9]+\//, "/0_0_100/");
			if (domain_nosub === "ismcdn.jp" ||
				domain === "mikiki.tokyo.jp" ||
				domain === "wedge.ismedia.jp" ||
				domain === "ure.pia.co.jp" ||
				domain_nowww === "wanibooks-newscrunch.com" ||
				domain_nowww === "afpbb.com") {
				return src.replace(/(\/mwimgs\/+(?:[0-9a-f]\/+){2})[0-9]+(?:[xmhw][whm]?[0-9]*)?(\/+img_[0-9a-f]{20,}\.[^/.]*)(?:[?#].*)?$/, "$1-$2");
			}
			if (domain_nosub === "yomiuri.co.jp" && string_indexof(src, "/photo/") >= 0) {
				return src.replace(/-[A-Z0-9](\.[^/.]*)$/, "-L$1");
			}
			if (domain_nosub === "newswitch.jp" && domain.match(/c[0-9]*\.newswitch\.jp/)) {
				return decodeURIComponent(src.replace(/^[a-z]*:\/\/[^/]*\/cover.*?[?&]url=([^&]*).*?$/, "$1"));
			}
			if (domain_nowww === "fashion-headline.com") return src.replace(/\/api\/+image\/+(?:width|height)\/+[0-9]+\//, "/");
			if (domain_nosub === "stream.ne.jp" && string_indexof(domain, "cdnext.stream.ne.jp") >= 0) {
				return src.replace(/(\/[0-9a-f]+)_[0-9]*_[0-9]*(\.[^/.]*)$/, "$1$2");
			}
			if (domain_nosub === "ptcdn.info") return src.replace(/([-_])[a-z](\.[^/.]*)$/, "$1o$2");
			if (domain_nosub === "pikabu.ru") {
				return src
					.replace(/\/post_img\/([0-9]+)\//, "/post_img/big/$1/")
					.replace(/\/images\/+previews_comm\/+/, "/images/big_size_comm/");
			}
			if (domain_nosub === "podium.life") return src.replace(/\/content\/r\/[wh]?[0-9]*(?:x[0-9]+)?\//, "/content/");
			if (domain_nowww === "lelulove.com") return src.replace(/(\/content\/+photo\/+[0-9a-z]+\/+)thumbs\/+/, "$1full/");
			if (domain_nosub === "filesor.com") {
				return {
					url: src.replace(/_(?:[a-z]|[0-9])(\.[^/.]*)/, "$1"),
					bad_if: [{
							headers: {
								"content-length": "9408",
								"content-type": "image/gif"
							}
						}]
				};
			}
			if (domain_nowww === "namooactors.com") return src.replace(/\/thumb(?:_[^/]*)?\/[a-z]+_[0-9]+(?:px|X[0-9]+)_(.*?\.[^/.]*)\.[^/.]*$/, "/$1");
			if (domain_nowww === "ftopx.com" ||
				domain_nowww === "goodwp.com" ||
				domain_nowww === "kartinkijane.ru" ||
				domain_nowww === "nastol.com.ua" ||
				domain_nowww === "fonstola.ru" ||
				domain_nowww === "luxfon.com" ||
				domain_nowww === "artleo.com") {
				var prefix_1;
				if (domain_nowww === "ftopx.com") {
					var timestamp = parseInt(src.replace(/.*[/_]([a-f0-9]{10,})\.[^/.]*$/, "$1"), 16);
					prefix_1 = ["ftop.ru", "ftopx.com"];
					if (timestamp > 1579484587755500)
						prefix_1 = ["ftopx.com", "ftop.ru"];
				} else {
					prefix_1 = domain_nosub;
				}
				regex = /\/(?:(?:(?:mini?|large)|pic\/+[0-9]+x[0-9]+)\/+([0-9]+)|pic\/+([0-9]{6})\/+[0-9]+x[0-9]+)\/+(?:[^/]*?\.[a-z]+[-_])?((?:[0-9a-f]+|[0-9]+)\.[^/.]*)(?:[?#].*)?$/;
				if (is_array(prefix_1)) {
					var urls = [];
					for (i = 0; i < prefix_1.length; i++) {
						urls.push(src.replace(regex, "/images/$1$2/" + prefix_1[i] + "_$3"));
					}
					return urls;
				} else {
					return src.replace(regex, "/images/$1$2/" + prefix_1 + "_$3");
				}
			}
			if (domain_nowww === "wykop.pl" && string_indexof(src, "/cdn/") >= 0) {
				return src.replace(/,[^/.]*(\.[^/.]*)$/, "$1");
			}
			if (domain_nowww === "phoronix.net") {
				return src
					.replace(/(\/image\.php.*?[?&]image=[^&]*)_show/, "$1")
					.replace(/(\/image\.php.*?[?&]image=[^&]*)_med/, "$1_show");
			}
			if (domain === "image.diyidan.net") {
				return {
					url: src.replace(/!.*/, ""),
					headers: {
						Referer: "https://www.diyidan.com/"
					}
				};
			}
			if (domain === "www.hrkgame.com" &&
				string_indexof(src, "/.thumbnails/") >= 0) {
				return src.replace(/\/\.thumbnails\/([^/]*)\/.*/, "/$1");
			}
			if (domain_nowww === "dlcompare.com" &&
				string_indexof(src, "/upload/cache/") >= 0) {
				return src.replace(/\/upload\/cache\/[^/]*\//, "/");
				/*newsrc = src.replace(/\/upload\/cache\/[^/]*\/upload\//, "/upload/");
				if (newsrc !== src)
					return newsrc;
				return src.replace(/\/upload\/cache\/[^/]*\//, "/upload/cache/slider/");*/
			}
			if (domain_nosub === "alphacoders.com" &&
				(domain.match(/images[0-9]*\.alphacoders\.com/) ||
					domain === "artfiles.alphacoders.com" ||
					domain === "picfiles.alphacoders.com" ||
					domain === "avatarfiles.alphacoders.com" ||
					domain === "coverfiles.alphacoders.com" ||
					domain === "photofiles.alphacoders.com")) {
				newsrc = src.replace(/\/thumb(?:-[0-9]*|big)?-([0-9]*\.[^/.]*)$/, "/$1");
				if (newsrc !== src)
					return add_extensions_from_webp(newsrc);
			}
			if (domain === "wall.alphacoders.com") {
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+big\.php\?(?:.*&)?i=([0-9]+)(?:[&#].*)?$/,
					query_for_id: "https://wall.alphacoders.com/big.php?i=${id}",
					process: function(done, resp, cache_key) {
						var image = get_meta(resp.responseText, "og:image");
						if (!image) {
							console_error(cache_key, "Unable to find og:image for", resp);
							return done(null, false);
						}
						var obj = {
							url: image,
							extra: {
								page: resp.finalUrl,
							}
						};
						var wallpaper_name = resp.responseText.match(/<h1 class="[^"]+wallpaper-name">([^<]+)<\/h1>/);
						if (wallpaper_name) {
							wallpaper_name = decode_entities(wallpaper_name[1]);
							obj.extra.caption = wallpaper_name;
						}
						return done(obj, 6 * 60 * 60);
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain === "mobile.alphacoders.com") {
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+wallpapers\/+view\/+([0-9]+)(?:\/+[^/]*\/*)?(?:[?#].*)?$/,
					query_for_id: "https://mobile.alphacoders.com/wallpapers/view/${id}/",
					process: function(done, resp, cache_key) {
						var match = resp.responseText.match(/href="([a-z]+:\/\/wall\.alphacoders\.com\/big\.php\?i=[0-9]+)"/);
						if (!match) {
							console_error(cache_key, "Unable to find big.php match for", resp);
							return done(null, false);
						}
						var mobile_url = get_meta(resp.responseText, "image");
						return done([
							{
								url: match[1],
								is_pagelink: true,
								problems: {
									uncropped: true
								}
							},
							{
								url: mobile_url
							}
						], 6 * 60 * 60);
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain === "mfiles.alphacoders.com") {
				id = src.replace(/.*\/(?:thumb(?:-[0-9]*)?-)?([0-9]+)\.[^/.]*$/, "$1");
				if (id !== src) {
					return {
						url: "https://mobile.alphacoders.com/wallpapers/view/" + id + "/",
						is_pagelink: true
					};
				}
			}
			if (domain_nowww === "gpstatic.com") return src.replace(/\/(s[0-9]*)_thumb(-[a-f0-9]*\.[^/.]*)$/, "/$1$2");
			if (domain_nosub === "walldevil.com") return src.replace(/\/(?:thumb|preview)\//, "/");
			if (domain === "www.peency.com" &&
				string_indexof(src, "/images/") >= 0) {
				return src.replace(/_[^/._]*(\.[^/.]*)$/, "$1");
			}
			if (domain === "www.wallpaperbetter.com" &&
				string_indexof(src, "/wallpaper/") >= 0) {
				return src.replace(/-(?:thumb|middle-size)(\.[^/.]*)$/, "$1");
			}
			if (domain_nowww === "thiswallpaper.com" && string_indexof(src, "/cdn/") >= 0) {
				return src.replace("/cdn/thumb/", "/cdn/hdwallpapers/");
			}
			if (domain_nowww === "superwallpapers.in" ||
				domain_nowww === "hdcarwallpapers.in") {
				return src.replace(/_[0-9]+_[0-9]+_[0-9]+_cf(\.[^/.]*)(?:[?#].*)?$/, "$1");
			}
			if (domain_nowww === "booklikes.com") {
				newsrc = src.replace(/.*\/www\/+thumb\.php\?(?:.*&)?img=([^&]*).*?$/, "$1");
				if (newsrc !== src)
					return "http://" + domain + "/" + decodeURIComponent(newsrc);
				return src.replace(/\/photo\/+max\/+[0-9]+\/+[0-9]+\/upload\/+/, "/upload/");
			}
			if ((domain_nowww === "hdwallsource.com" ||
				domain_nowww === "pickywallpapers.com") &&
				string_indexof(src, "/img/") >= 0) {
				return src.replace(/\/thumb\/+([^/.]*)-thumb(\.[^/.]*)(?:[?#].*)?$/, "/$1$2");
			}
			if ((domain_nowww === "customity.com" && string_indexof(src, "/storage/public/") >= 0) ||
				(domain_nowww === "wisebread.com" && string_indexof(src, "/files/") >= 0)) {
				return src.replace(/\/imagecache\/+[0-9]+x[0-9]+\//, "/");
			}
			if ((domain_nowww === "desktopimages.org" ||
				domain_nowww === "hdbilder.eu" ||
				domain_nowww === "hdfondos.eu" ||
				domain_nowww === "banktapet.pl" ||
				domain_nowww === "fondsecran.eu")) {
				if (string_indexof(src, "/pictures/") >= 0) {
					newsrc = src.replace(/\/[^/]*[-_]([0-9]+\.[^/.]*)$/, "/orig_$1");
					if (newsrc !== src)
						return newsrc;
				}
				if (options && options.cb && options.do_request &&
					src.match(/\/(?:p|preview)\/+get_photo\/+[0-9]+\/+[0-9]+/)) {
					var querysrc = src.replace(/\/(?:p|preview)\/+get_photo\/+([0-9]+\/+[0-9]+)(?:\/.*)?$/, "/p/$1/0/o");
					options.do_request({
						url: querysrc,
						method: "GET",
						onload: function(resp) {
							if (resp.readyState === 4) {
								var match = resp.responseText.match(/<img *src="([^">]*\/orig_[^/">]*)"/);
								if (match) {
									options.cb(match[1]);
								} else {
									options.cb(null);
								}
							}
						}
					});
					return {
						waiting: true
					};
				}
			}
			if (domain_nowww === "bikerpunks.com" && string_indexof(src, "/media/") >= 0) {
				return src.replace(/\/media\/[^/]*\/([0-9a-f]*\.[^/.]*)$/, "/media/$1");
			}
			if (domain_nosub === "livejournal.com" && domain.match(/i[a-z]*\.pics\.livejournal\.com/)) {
				return src
					.replace(/(\/pic\/[0-9a-z]+\/)s[0-9]+x[0-9]+(?:[?#].*)?$/, "$1")
					.replace(/_[0-9]*(\.[^/.]*)$/, "_original$1")
					.replace(/(\/[0-9]+\/)[0-9]+(\.[^/.]*)$/, "$1original$2");
			}
			if (domain === "pics.livejournal.com") return src.replace(/\/s[0-9]+x[0-9]+(?:[?#].*)?$/, "/original");
			if (host_domain_nosub === "livejournal.com" && options.element && domain === "imgprx.livejournal.net") {
				if (options.element.tagName === "IMG" && options.element.getAttribute("loading") === "lazy" &&
					options.element.parentElement && options.element.parentElement.tagName === "A" && options.element.parentElement.getAttribute("rel") === "nofollow") {
					return options.element.parentElement.href;
				}
			}
			if (domain === "imgprx.livejournal.net") {
				if (options.do_request && options.cb) {
					common_functions["get_redirect_url"](api_cache, options, {
						url: src,
						imu_mode: "document"
					}, options.cb);
					return {
						waiting: true
					};
				}
			}
			if (domain_nowww === "yastatic.net") {
				if (/\/s3\/+web4static\/+_\/+v2\/+/.test(src))
					return {
						url: src,
						bad: "mask"
					};
			}
			if (domain_nowww === "dzen.ru") {
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+video\/+watch\/+([0-9a-f]{10,})(?:[?#].*)?$/,
					query_for_id: "https://dzen.ru/video/watch/${id}",
					process: function(done, resp, cache_key) {
						var match = resp.responseText.match(/var data\s*=\s*({.*"__serverSettings__video-site_.*});\s*\n/);
						if (!match) {
							console_error(cache_key, "Unable to find data match for", resp);
							return done(null, false);
						}
						var json = JSON_parse(match[1]);
						var serversettingskey = null;
						for (var key_1 in json) {
							if (string_indexof(key_1, "serverSettings") >= 0) {
								serversettingskey = key_1;
								break;
							}
						}
						if (!serversettingskey) {
							console_error(cache_key, "Unable to find serverSettings key in", {
								resp: resp,
								json: json
							});
							return done(null, false);
						}
						var serversettings = json[serversettingskey];
						var videodata = serversettings.exportData.video;
						var extra = {
							caption: videodata.title,
							page: videodata.link,
							created_date: parse_int(videodata.publicationDate) * 1000
						};
						var urls = [];
						for (var _i = 0, _a = videodata.video.streams; _i < _a.length; _i++) {
							var url_2 = _a[_i];
							if (/\.m3u8\?/.test(url_2)) {
								urls.push({
									url: url_2,
									video: "hls"
								});
							} else if (/\.mpd\?/.test(url_2)) {
								urls.push({
									url: url_2,
									video: "dash"
								});
							} else {
								console_warn(cache_key, "Unhandled url", url_2);
							}
						}
						urls.push(videodata.image);
						return done(fillobj_urls(urls, {
							extra: extra
						}), 6 * 60 * 60);
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain === "zen.yandex.ru") {
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+video\/+watch\/+([0-9a-f]{10,})(?:[?#].*)?$/,
					run: function(cb, match) {
						return cb({
							url: "https://dzen.ru/video/watch/" + match[1],
							is_pagelink: true
						});
					}
				});
				if (newsrc)
					return newsrc;
			}
			if ((host_domain_nowww === "yandex.ru" ||
				host_domain_nowww === "yandex.com")
				&& options && options.element) {
				var current = options.element;
				while ((current = current.parentElement)) {
					if (current.tagName === "A") {
						match = current.href.match(/^[a-z]+:\/\/[^/]+\/+images\/+search\?(?:.*&)?img_url=([^&]+)/);
						if (match) {
							newsrc = decodeuri_ifneeded(match[1]);
							if (newsrc !== src)
								return newsrc;
						}
						break;
					}
				}
			}
			if (domain === "img-fotki.yandex.ru") return src.replace(/_[^-/._]*(\.[^/.]*)?$/, "_orig$1");
			if (domain_nosub === "yandex.ru" && /downloader.disk.yandex.ru/.test(domain)) {
				return src.replace(/(\/preview\/+[0-9a-f]{30,}\/+.*?\?(?:.*&)?size=)[0-9]+x[0-9]+(&.*)?$/, "$10x0$2");
			}
			if (domain_nosub === "steemitimages.com") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/[0-9]+x[0-9]+\//, "");
				if (newsrc !== src)
					return newsrc;
				return src.replace(/\?.*/, "");
			}
			if (amazon_container &&
				amazon_container.match(/^steemit-production-imageproxy-[^-.]*/)) {
				return src
					.replace(/-imageproxy-thumbnail((?:\.[^/]*)?\/[A-Za-z0-9]*)_[0-9]+x[0-9]+$/, "-imageproxy-upload$1");
			}
			if (domain === "images.hive.blog") return src.replace(/(\/p\/+[0-9a-zA-Z]{50,})\?.*/, "$1");
			if (domain_nowww === "newsprom.ru") return src.replace(/\/([0-9]+_[a-f0-9]+\.[^/.]*)$/, "/tn_$1");
			if (domain_nosub === "fotocdn.net" && domain.match(/i[0-9]*\.fotocdn\.net/)) {
				regex = /_(?:[a-z]+|[0-9]+c)(\/+[0-9]+\/+[0-9]+\.[^/.]*)$/;
				return [
					src.replace(regex, "_xl$1"),
					src.replace(regex, "_l$1")
				];
			}
			if (domain_nowww === "news-people.fr" && string_indexof(src, "/galerie/") >= 0) {
				return src.replace(/\/([0-9]*)(\.[^/.]*)$/, "/$1_hd$2");
			}
			if (domain_nosub === "cdn107.com") return src.replace(/_[a-z]*(\.[^/.]*)$/, "$1");
			if (domain === "hairstyles.thehairstyler.com") return src.replace(/(\/[0-9]*\/)[^/]*\/([^/]*)$/, "$1original/$2");
			if (domain_nowww === "abload.de") {
				return {
					url: src.replace(/(:\/\/[^/]+\/+)thumb\/+/, "$1img/"),
					head_wrong_contenttype: true
				};
			}
			if (domain_nowww === "wallpaperpulse.com") return src.replace(/\/thumb\//, "/img/");
			if (domain === "assets.capitalfm.com" ||
				domain === "assets.gcstatic.com") {
				return src.replace(/(\/[^/]*-[0-9]{8,})-[^/]*(\.[^/.]*)$/, "$1$2");
			}
			if (domain_nowww === "leathercelebrities.com") {
				return decodeURIComponent(src
					.replace(/^[a-z]+:\/\/[^/]*\/download\.php.*?[?&]file=([^&]*).*?$/, "$1")
					.replace(/(\/uploads\/[0-9]*\/[^/]*)__thumb(\.[^/.]*)$/, "$1$2"));
			}
			if (domain === "img.cache.vevo.com" ||
				domain === "scache.vevo.com") {
				newsrc = src.replace(/[?#].*$/, "");
				if (newsrc !== src)
					return newsrc;
				return src.replace(/(\/thumb\/[^/]*\/[^/]*)\/[0-9]+x[0-9]+(\.[^/.]*?)(?:[?#].*)?$/, "$1$2");
			}
			if (domain_nowww === "superiorpics.com" ||
				domain === "i.bollywoodmantra.com") {
				return src.replace(/\/thumb[0-9]+\//, "/");
			}
			if (domain_nowww === "celebjihad.com" ||
				domain === "image.dek-d.com") {
				return src.replace(/\/t_([^/]*)$/, "/$1");
			}
			if (domain === "cdn.teamcococdn.com") return src.replace(/\/image\/[^/]*\//, "/file/");
			if (domain === "live.staticflickr.com") {
				newsrc = src.replace(/(\/buddyicons\/+[0-9]+@N[0-9]+)(?:_[slm])?(\.[^/.]*)(?:[?#].*)?$/, "$1_r$2");
				if (newsrc !== src)
					return newsrc;
			}
			if (host_domain_nowww === "flickr.com" && domain === "combo.staticflickr.com" && options.element) {
				if (/\/images\/+(?:fuzzy\/+)?photo-fuzzy(?:-t)?\./.test(src)) {
					if (options.element.tagName === "IMG" && options.element.parentElement && options.element.parentElement.tagName === "A") {
						return options.element.parentElement.href;
					}
				}
			}
			if ((domain_nosub === "staticflickr.com" ||
				domain === "static.flickr.com" ||
				(domain_nosub === "flickr.com" && string_indexof(domain, ".static.flickr.com") >= 0)) &&
				(src.match(/\/[0-9]+_[0-9a-f]+(?:_[a-z0-9]*)*\.[a-z]+.*$/) || /\/video\/+[0-9]+\/+[0-9a-f]+\/+/.test(src)) &&
				options && options.do_request && options.cb) {
				var find_photoid_secret_from_url = function(src) {
					var match = src.match(/\/video\/+([0-9]+)\/+([0-9a-f]+)\/+/);
					if (!match) {
						match = src.match(/\/[0-9]+\/+([0-9]+)_([0-9a-z]+)(?:_[^/.]+)?\..*/);
					}
					if (match) {
						return {
							id: match[1],
							secret: match[2]
						};
					} else {
						return null;
					}
				};
				var find_image_obj = function(info, src, cb, origobj) {
					var photoinfo = find_photoid_secret_from_url(src);
					var cache_key = "flickr_image_obj:" + photoinfo.id;
					api_cache.fetch(cache_key, function(obj) {
						if (!obj)
							return cb(null);
						if (origobj) {
							if (!is_array(origobj))
								origobj = [origobj];
							cb(fillobj_urls(origobj, obj));
						} else {
							cb(obj);
						}
					}, function(done) {
						find_image_info(info, src, function(info) {
							if (!info)
								return done(null, false);
							return done(common_functions["flickr_info_to_obj"](info), 60 * 60);
						});
					});
				};
				var find_image_info = function(info, src, cb) {
					var photoinfo = find_photoid_secret_from_url(src);
					var cache_key = "flickr_image_info:" + photoinfo.id + "_" + photoinfo.secret;
					api_cache.fetch(cache_key, cb, function(done) {
						var apirequest = "method=flickr.photos.getInfo&photo_id=" + photoinfo.id;
						if (photoinfo.secret !== "face")
							apirequest += "&secret=" + photoinfo.secret;
						common_functions["flickr_api_request"](options, info, apirequest, function(out) {
							if (!out)
								return done(null, false);
							done(out.photo, 60 * 60);
						});
					});
				};
				var get_obj_from_image_info = function(info) {
					try {
						var url = info.urls.url[0]._content;
						if (!(/^https?:\/\//.test(url))) {
							url = null;
						}
						var caption = info.title._content;
						if (!caption)
							caption = null;
						var extra = {
							page: url,
							caption: caption
						};
						return extra;
					} catch (e) {
						console_error(e, info);
					}
					return null;
				};
				var find_video_info = function(info, photoinfo, cb) {
					var cache_key = "flickr_video:" + photoinfo.id + "_" + photoinfo.secret;
					api_cache.fetch(cache_key, cb, function(done) {
						var apirequest = "method=flickr.video.getStreamInfo&photo_id=" + photoinfo.id;
						if (photoinfo.secret !== "face")
							apirequest += "&secret=" + photoinfo.secret;
						common_functions["flickr_api_request"](options, info, apirequest, function(out) {
							if (!out)
								return done(null, false);
							if (out.streams.stream.length > 0) {
								done(out.streams.stream, 60 * 60);
							} else {
								console_error(cache_key, "No streams in", out);
								done(null, false);
							}
						});
					});
				};
				var find_largest_video = function(videodata) {
					var max = 0;
					var maxobj = null;
					for (var i = 0; i < videodata.length; i++) {
						var quality = parseInt(videodata[i].type);
						if (!quality || isNaN(quality) || !videodata[i]._content)
							continue;
						if (quality > max) {
							maxobj = videodata[i];
							max = quality;
						}
					}
					if (maxobj) {
						return maxobj._content;
					} else {
						return null;
					}
				};
				newsrc = src.replace(/(:\/\/[^/]*\/(?:[0-9]+\/)?[0-9]+\/[0-9]+_[0-9a-f]+(?:_[a-z])?\.[a-zA-Z0-9]*).*$/, "$1");
				if (newsrc.match(/\/[0-9]+_[0-9a-f]+_o\.[a-z]+.*$/)) {
					obj = {
						url: src,
						is_original: true
					};
					if (options.force_page) {
						common_functions["flickr_find_api_info"](options, api_cache, function(info) {
							if (!info) {
								return options.cb(obj);
							}
							find_image_obj(info, newsrc, function(newobj) {
								options.cb(newobj || obj);
							}, obj);
						});
						return {
							waiting: true
						};
					} else {
						return obj;
					}
				}
				var find_larger_image = function(info, src, cb) {
					var photoinfo = find_photoid_secret_from_url(src);
					var photoid = photoinfo.id;
					var cache_key = "flickr_larger:" + photoid;
					api_cache.fetch(cache_key, cb, function(done) {
						common_functions["flickr_api_request"](options, info, "method=flickr.photos.getSizes&photo_id=" + photoid, function(out) {
							if (!out)
								return done(null, false);
							var largesturl = null;
							var largestsize = 0;
							var is_video = false;
							array_foreach(out.sizes.size, function(size) {
								var currentsize = parseInt(size.width) * parseInt(size.height);
								if (currentsize > largestsize || size.label === "Original") {
									largestsize = currentsize;
									largesturl = size.source;
								}
								if (size.media === "video") {
									is_video = true;
								}
							});
							if (typeof largesturl === "string" && /^https?:\/\//.test(largesturl)) {
								done({
									url: largesturl,
									has_video: is_video
								}, 10 * 60);
							} else {
								done(null, false);
							}
						});
					});
				};
				common_functions["flickr_find_api_info"](options, api_cache, function(info) {
					if (!info) {
						return options.cb(null);
					}
					find_larger_image(info, src, function(largest_data) {
						if (!largest_data) {
							return options.cb(null);
						}
						var baseobj = {};
						var urls = [largest_data.url];
						var final_cb = function(photoinfo) {
							if (photoinfo && largest_data.has_video) {
								find_video_info(info, photoinfo, function(video_data) {
									if (video_data) {
										var largest_video_url = find_largest_video(video_data);
										if (largest_video_url) {
											if (largest_video_url.replace(/[?#].*/, "") === src.replace(/[?#].*/, "")) {
												largest_video_url = src;
											}
											urls.unshift({
												url: largest_video_url,
												video: true
											});
										}
									}
									return options.cb(fillobj_urls(urls, baseobj));
								});
							} else {
								return options.cb(fillobj_urls(urls, baseobj));
							}
						};
						if (largest_data.has_video) {
							find_image_info(info, newsrc, function(info) {
								if (info) {
									baseobj = {
										extra: get_obj_from_image_info(info)
									};
								}
								final_cb(info);
							});
						} else if (options.force_page) {
							find_image_obj(info, newsrc, function(obj) {
								if (obj)
									baseobj = obj;
								final_cb();
							});
						} else {
							final_cb();
						}
					});
				});
				return {
					waiting: true
				};
			}
			if (domain === "flimg.flickr.com") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/+\?(?:.*&)?url=([^&]*).*?$/, "$1");
				if (newsrc !== src)
					return decodeuri_ifneeded(newsrc);
			}
			if (host_domain_nosub === "flickr.com" && options.element) {
				if (options.element.tagName === "DIV") {
					var imgel = options.element.querySelector("img.main-photo");
					if (imgel)
						return imgel.src;
				}
				if (!src) {
					if (options.element.classList.contains("spaceball")) {
						return {
							url: origsrc,
							bad: "mask"
						};
					}
				} else if (string_indexof(src, "staticflickr.com/") < 0) {
					var current = options.element;
					while ((current = current.parentElement)) {
						if (current.tagName === "DIV" && current.classList.contains("restricted-interstitial")) {
							var meta_image = document.head.querySelector("meta[property=\"og:image\"]");
							if (meta_image) {
								return meta_image.content;
							}
						}
					}
				}
			}
			if (domain_nowww === "flickr.com") {
				var paginate = function(query, cb, token, arr) {
					if (!arr)
						arr = [];
					query(token, function(data, nexttoken) {
						if (data)
							array_extend(arr, data);
						if (nexttoken) {
							paginate(query, cb, nexttoken, arr);
						} else {
							cb(arr);
						}
					});
				};
				var get_album_photos = function(info, albumid, cb) {
					var queries = {
						per_page: 200,
						page: 1,
						extras: "can_addmeta,can_comment,can_download,can_print,can_share,contact,count_comments,count_faves,count_views,date_taken,date_upload,description,icon_urls_deep,isfavorite,ispro,license,media,needs_interstitial,owner_name,owner_datecreate,path_alias,perm_print,realname,rotation,safety_level,secret_k,secret_h,url_sq,url_q,url_t,url_s,url_n,url_w,url_m,url_z,url_c,url_l,url_h,url_k,url_3k,url_4k,url_f,url_5k,url_6k,url_o,visibility,visibility_source,o_dims,publiceditability,system_moderation",
						photoset_id: albumid,
						method: "flickr.photosets.getPhotos"
					};
					var getpage = function(page, cb) {
						if (!page)
							page = 1;
						console_log("Querying", page);
						queries.page = page;
						common_functions["flickr_api_request"](options, info, stringify_queries(queries), function(data) {
							if (!data)
								return cb(null);
							var photoset = data.photoset;
							var photos = photoset.photo;
							var objs = [];
							array_foreach(photos, function(photo) {
								var obj = common_functions["flickr_info_to_obj"](photo);
								if (!obj)
									return;
								api_cache.set("flickr_image_obj:" + photo.id, obj);
								objs.push(obj);
							});
							var current_page = parseInt(photoset.page);
							var total_pages = parseInt(photoset.pages);
							var next_page = current_page < total_pages ? current_page + 1 : null;
							cb(objs, next_page);
						});
					};
					api_cache.fetch("flickr_album:" + albumid, cb, function(done) {
						paginate(getpage, function(data) {
							if (!data || !data.length)
								done(null, false);
							done(data, 60 * 60);
						});
					});
				};
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+photos\/+[^/]+\/+([0-9]+)(?:\/+(?:(?:in|sizes)\/+.*)?)?(?:[?#].*)?$/,
					run: function(cb, match) {
						var id = match[1];
						return cb("https://live.staticflickr.com/0000/" + id + "_face_b.jpg");
					}
				});
				if (newsrc)
					return newsrc;
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+photos\/+[^/]+\/+albums\/+([0-9]+)(?:[?#].*)?$/,
					run: function(cb, match) {
						var id = match[1];
						common_functions["flickr_find_api_info"](options, api_cache, function(info) {
							get_album_photos(info, id, function(objs) {
								if (!objs || !objs.length)
									return cb(null);
								var links = [];
								array_foreach(objs, function(obj, i) {
									links.push({
										url: obj.url,
										is_current: i === 0
									});
								});
								objs[0].album_info = {
									type: "links",
									links: links
								};
								cb(objs[0]);
							});
						});
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain === "www.imagozone.com" ||
				domain_nowww === "imagozone.ro" ||
				domain_nowww === "ohsohumorous.com" ||
				domain_nowww === "travelseyahat.com" ||
				domain_nowww === "carphotoshow.com" ||
				domain_nowww === "crnobelo.com" ||
				domain_nowww === "myhentaicomics.com" ||
				domain_nowww === "komodogirls.com" ||
				domain_nowww === "celebritiestown.com") {
				if (/\/modules\/+hover_navigation\/+images\//.test(src))
					return {
						url: src,
						bad: "mask"
					};
				if (!src.match(/\/\.album\.[^/.]*$/)) {
					newsrc = src.replace(/(\/var\/+thumbs\/)/, "/var/resizes/");
					if (newsrc !== src)
						return newsrc;
					return src.replace(/\/var\/(?:resizes|thumbs)\//, "/var/albums/");
				}
			}
			if (domain_nowww === "bjwinslow.com") return src.replace(/(\/albums\/.*)\.sized(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain_nosub === "tunes.zone") {
				var basic = src.replace(/\/[0-9]+x[0-9]+[a-z]?\//, "/full/");
				if (basic !== src) {
					var other = basic.replace(/-[a-z]+-[a-z]+(-[0-9]+)?(\.[^/.]*)$/, "$1$2");
					var other1 = basic.replace(/(\/[0-9]+-+)[^/]*-([0-9]+\.[^/.]*)$/, "$1$2");
					if (basic.match(/\/[0-9]+--/))
						return [other1, basic, other];
					else if (basic.match(/-[0-9]+\.[^/.]*$/))
						return [other, basic, other1];
					else
						return [basic, other, other1];
				}
			}
			if (domain === "sf.co.ua") return src.replace(/\/tn-([0-9]*\.[^/.]*)/, "/wallpaper-$1");
			if (domain_nosub === "zerochan.net" && domain.match(/^s[^.]*.zerochan.net/)) {
				obj = {
					url: src
				};
				id = src.match(/:\/\/[^/]+\/+(?:[^/]*\.[^/.]+\.([0-9]+)|[^/]+\/+(?:[0-9]+\/+){2}([0-9]+))\.[^/.]+(?:[?#].*)?$/);
				if (id) {
					obj.extra = { page: "https://www.zerochan.net/" + (id[1] || id[2]) };
				}
				obj.url = src
					.replace(/:\/\/s[^.]*.zerochan.net\//, "://static.zerochan.net/")
					.replace(/(:\/\/[^/]*\/[^/]*\.)[0-9]+(\.[0-9]+\.[^/.]*)$/, "$1full$2")
					.replace(/(:\/\/[^/]+\/+)[0-9]+\/+([0-9]+\/+[0-9]+\/+[0-9]+\.)/, "$1full/$2");
				if (obj.url !== src) {
					return fillobj_urls(add_extensions(obj.url), obj);
				}
				return obj;
			}
			if (domain === "cdn.aibooru.download") {
				newsrc = src.replace(/(:\/\/[^/]+\/+)(?:preview|[0-9]+x[0-9]+)\/+((?:[a-f0-9]{2}\/+){2})/, "$1sample/$2__a__sample-");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/(:\/\/[^/]+\/+)sample\/+((?:[a-f0-9]{2}\/+){2}__[^/]+?__)sample-/, "$1original/$2");
				if (newsrc !== src)
					return add_extensions(newsrc);
			}
			if (domain === "cdn.donmai.us") {
				newsrc = src.replace(/^([a-z]+:\/\/[^/]+\/+)[0-9]+x[0-9]+\/+/, "$1preview/");
				if (newsrc !== src)
					return newsrc;
				return src.replace(/^[a-z]+:\/\/[^/]+\/+(preview|sample)\/+(?:[0-9a-f]{2}\/+){2}((?:(?:[^/]+__)?sample-)?[0-9a-f]{10,}\.[^/.]+)(?:[?#].*)?$/, "https://danbooru.donmai.us/data/$1/$2");
			}
			if (domain_nosub === "donmai.us") {
				newsrc = src
					.replace(/\/data\/+((?:[0-9a-f]{2}\/+){2}__original)/, "/data/original/$1")
					.replace(/\/data\/sample\/((?:(?:[0-9a-f]{2}\/+){2})?[^/]*__)?sample-([0-9a-f]*\.[^/.]*)$/, "/data/$1$2")
					.replace(/:\/\/danbooru\.donmai\.us\/data\/preview\//, "://hijiribe.donmai.us/data/")
					.replace(/\/data\/preview\/([^/]*)$/, "/data/__original__$1");
				if (newsrc !== src)
					return add_extensions_gif(newsrc);
			}
			if (domain === "yukkuri.shii.org") {
				newsrc = src.replace(/\/data\/+(?:preview|sample)\/+(?:sample-)?([0-9a-f]{20,}\.[^/.]*)(?:[?#].*)?$/, "/data/$1");
				if (newsrc !== src) {
					return add_extensions(newsrc);
				}
			}
			if ((domain_nosub === "e621.net" && /^static[0-9]*\./.test(domain)) ||
				domain_nowww === "behoimi.org") {
				newsrc = src.replace(/(:\/\/[^/]+\/+data\/+)(?:preview|sample)\/+([0-9a-f]{2}\/+)/, "$1$2");
				if (newsrc !== src) {
					return add_extensions(newsrc);
				}
			}
			if (domain_nowww === "hypnohub.net") {
				newsrc = src.replace(/\/data\/+(?:preview|sample)\/+([0-9a-f]{20,}\.[^/.]*)(?:[?#].*)?$/, "/data/image/$1");
				if (newsrc !== src) {
					return add_extensions(newsrc);
				}
			}
			if (domain === "files.yande.re") {
				return add_extensions(src
					.replace(/\/(?:sample|jpeg)\/+([0-9a-f]+\/)/, "/image/$1"));
			}
			if (domain === "assets.yande.re") {
				return add_extensions(src.replace(/:\/\/assets.yande.re\/data\/preview\/[0-9a-f]+\/[0-9a-f]+\//, "://files.yande.re/image/"));
			}
			if (domain_nowww === "konachan.com" ||
				domain_nowww === "konachan.net") {
				newsrc = src.replace(/(?:\/data\/preview\/[0-9a-f]+\/[0-9a-f]+\/|\/(?:sample|jpeg)\/)([0-9a-f]+)(\/[^/]*)?(\.[^/.?]*)(?:[?#]*)?$/, "/image/$1$3");
				if (newsrc !== src)
					return add_full_extensions(newsrc);
				return {
					url: src,
					headers: {
						Referer: "https://konachan.com/post"
					}
				};
			}
			if (domain_nowww === "gelbooru.me") return src.replace(/^[a-z]+:\/\/[^/]+\/+cdn(img[0-9]+)\/+/, "https://$1.gelbooru.com/");
			if (domain_nowww === "gelbooru.com") return src.replace(/:\/\/[^/]*\/thumbnails\//, "://img2.gelbooru.com/thumbnails/");
			if (domain_nosub === "gelbooru.com" && /^s?img[0-9]*\./.test(domain)) {
				obj = {
					url: src,
					can_head: false,
					imu_mode: "image",
					headers: {
						Referer: "https://www." + domain_nosub + "/"
					}
				};
				newsrc = src.replace(/\/+thumbnails\/+([0-9a-f]+\/[0-9a-f]+\/)thumbnail_/, "/images/$1")
					.replace(/\/+samples\/+([0-9a-f]+\/[0-9a-f]+\/)sample_/, "/images/$1");
				if (newsrc !== src) {
					return fillobj_urls(add_full_extensions(newsrc), obj);
				}
			}
			if (domain === "cali.rule34.xxx") return src.replace(/^[a-z]+:\/\/[^/]+\/+/, "https://us.rule34.xxx/");
			if (domain_nowww === "safebooru.org" ||
				domain_nowww === "tbib.org" ||
				domain === "img.xbooru.com" ||
				domain === "img.booru.org" ||
				domain_nosub === "rule34.xxx" ||
				domain_nowww === "realbooru.com") {
				newsrc = src.replace(/\/(?:thumbnails|samples|images)(\/+(?:[0-9a-f]+\/+)?[0-9a-f]+\/+)(?:(?:thumbnail|sample)_)?([0-9a-f]+\.[^/.]*)$/, "/images$1$2");
				if (/\/images\/+(?:[0-9a-f]+\/+)?[0-9a-f]+\/[0-9a-f]+\./.test(newsrc))
					return add_full_extensions(newsrc, [
						"mp4", "MP4", "jpg", "jpeg", "png", "gif", "webp",
						"JPG", "JPEG", "PNG", "GIF"
					], true);
			}
			if (domain === "thumbs.booru.org") return src.replace(/:\/\/[^/]*\//, "://img.booru.org/");
			if (domain_nosub === "booru.org" && domain !== "img.booru.org") {
				return src.replace(/:\/\/([^/]*)\.booru\.org\/thumbnails\/+/, "://img.booru.org/$1/thumbnails/");
			}
			if (domain === "cdn.aibooru.online") {
				newsrc = src.replace(/(:\/\/[^/]+\/+)[0-9]+x[0-9]+\/+/, "$1original/");
				if (newsrc !== src)
					return add_full_extensions(newsrc, ["mp4", "gif", "png", "jpg"], true);
			}
			if (domain === "cdn.vor.us") return src.replace(/\/thumbs[a-z]?\//, "/og/");
			if (domain === "wallpapers.wallhaven.cc" ||
				domain === "alpha.wallhaven.cc") {
				return src.replace(/\/thumb\/[^/]*\/th-/, "/full/wallhaven-");
			}
			if (domain === "static.wallhaven.cc") {
				if (/\/images\/+layout\/+bg-/.test(src)) {
					return {
						url: src,
						bad: "mask"
					};
				}
			}
			if (domain_nowww === "wallhaven.cc") {
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+w\/+([a-z0-9]+)(?:[?#].*)?$/,
					query_for_id: "https://wallhaven.cc/w/${id}",
					process: function(done, resp, cache_key) {
						var match = resp.responseText.match(/<img id="wallpaper" src="(https?:\/\/[^/]+\/+full\/+[^"']+)"/);
						if (!match) {
							console_error(cache_key, "Unable to find match for", resp);
							return done(null, false);
						}
						return done(decode_entities(match[1]), 6 * 60 * 60);
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain === "th.wallhaven.cc") {
				newsrc = src.replace(/:\/\/th\.([^/]+\/+)(?:small|lg|orig)\/+([a-z0-9]{2}\/+)([a-z0-9]+\.)/, "://w.$1full/$2wallhaven-$3");
				if (newsrc !== src) {
					return add_extensions(newsrc);
				}
			}
			if (domain_nowww === "pussycalor.com") return src.replace(/(\/fotospc\/+)th-([0-9]+\.)/, "$1$2");
			if (domain === "cdn.animenewsnetwork.com" ||
				domain_nowww === "animenewsnetwork.com") {
				return src
					.replace(/\/thumbnails\/[^/]*\/cms\//, "/images/cms/")
					.replace(/(\.[a-z]{3,4})\.jpg(?:[?#].*)?$/, "$1");
			}
			if ((domain_nowww === "digitalart.io" && string_indexof(src, "/storage/") >= 0) ||
				domain_nowww === "fashion-press.net" && string_indexof(src, "/img/") >= 0) {
				return src.replace(/(\/[0-9]*\/)[wh][0-9]+_([^/]*)$/, "$1$2");
			}
			if (domain_nowww === "4everstatic.com" ||
				domain === "pictures.4ever.eu") {
				if (!src.match(/:\/\/[^/]*\/data\/+download\//)) {
					return [
						src.replace(/:\/\/[^/]*\/[a-z]+\/(?:[0-9X]+x[0-9X]+\/)?([^?]*).*?$/, "://pictures.4ever.eu/data/download/$1?no-logo"),
						src.replace(/(:\/\/[^/]*\/[a-z]+\/)[0-9X]+x[0-9X]+\//, "$1")
					];
				}
			}
			if (domain_nowww === "tapeciarnia.pl") return src.replace(/\/tapety\/[^/]*\//, "/tapety/normalne/");
			if (domain_nowww === "zastavki.com") return src.replace(/\/pictures\/[0-9]+x[0-9]+\/(.*_[0-9]+)_[0-9]+(\.[^/.]*)$/, "/pictures/originals/$1_$2");
			if (domain_nosub === "wallls.com" && domain.match(/w[0-9]*\.wallls.com/)) {
				return src.replace(/\/uploads\/[^/]*\/([0-9]*\/[0-9]*\/)([0-9]*\.[^/.]*)$/, "/uploads/original/$1wallls.com_$2");
			}
			if (domain === "content.hardtunes.com") return src.replace(/\/[0-9]+x[0-9]+(\.[^/.]*)$/, "/original$1");
			if (domain_nowww === "4kw.in" &&
				string_indexof(src, "/Wallpapers/") >= 0) {
				return src.replace(/1(\.[^/.]*)$/, "$1");
			}
			if (domain === "imgs-art-dragoart-386112.c.cdn77.org") return src.replace(/_[0-9]*(\.[^/.]*)$/, "_1$1");
			if (domain_nosub === "hulkshare.com" && domain.match(/s[0-9]*\.hulkshare\.com/)) {
				return src.replace(/\/[0-9]*\/([0-9a-f]\/[0-9a-f]\/[0-9a-f]\/[0-9a-f]*\.[^/.]*)$/, "/original/$1");
			}
			if (domain_nowww === "wikihow.com" &&
				string_indexof(src, "/images/") >= 0) {
				return src.replace(/\/thumb\/(.*?\.[^/.]*)(?:\/.*)/, "/$1");
			}
			if (domain_nosub === "kakaocdn.net" ||
				domain_nosub === "kakao.co.kr") {
				newsrc = src
					.replace(/(\/img(?:_[a-z]+)?\.[^/.?#]*)(?:[?#].*)?$/, "$1")
					.replace(/\/img_[a-z]+(\.[^/.]*)$/, "/img$1");
				if (newsrc !== src)
					return newsrc;
			}
			if (host_domain === "tv.kakao.com" && domain_nosub === "kakaocdn.net" && /\/vod_thumbnail\//.test(src) && options.element) {
				newsrc = common_functions["get_pagelink_el_matching"](options.element, /\/channel\/+[0-9]+\/+cliplink\/+[0-9]+/);
				if (newsrc)
					return newsrc;
			}
			if (domain === "tv.kakao.com") {
				var query_dash_with_params = function(req, params, cb) {
					req.method = "GET";
					req.onload = function(resp) {
						if (resp.status !== 200) {
							console_error("Unable to request", req, resp);
							return cb(null);
						}
						var text = resp.responseText;
						var baseurl = req.url.replace(/\/[^/]+(?:[?#].*)?$/, "/");
						params = encode_entities(params);
						text = text.replace(/((?:initialization|media)=")([^"]+)(")/g, "$1" + baseurl + "$2?" + params + "$3");
						cb(text);
					};
					options.do_request(req);
				};
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+(?:channel\/+[0-9]+|embed\/+player)\/+cliplink\/+([0-9]+)(?:[?#].*)?$/,
					run: function(cb, match) {
						var id = match[1];
						var cache_key = "kakao_video:" + id;
						var queries = {
							player: "monet_html5",
							referer: "https://tv.kakao.com/",
							uuid: "",
							profile: "HIGH4", // 1080p ... is there anything larger?
							service: "kakao_tv",
							fields: "seekUrl,abrVideoLocationList",
							playerVersion: "3.7.1",
							startPosition: "0",
							tid: "",
							dteType: "PC",
							contentType: ""
						};
						queries[Date.now()] = "";
						api_query(cache_key, {
							url: "https://tv.kakao.com/katz/v1/ft/cliplink/" + id + "/readyNplay?" + stringify_queries(queries),
							imu_mode: "xhr",
							headers: {
								"Content-Type": "application/x-www-form-urlencoded",
								Referer: "https://tv.kakao.com/"
							},
							json: true
						}, cb, function(done, resp, cache_key) {
							if (!resp.videoLocation || !resp.videoLocation.url) {
								console_error(cache_key, "Unable to find video URL for", resp);
								return done(null, false);
							}
							var baseobj = {
								headers: {
									Referer: "https://tv.kakao.com/",
									Origin: "https://tv.kakao.com"
								}
							};
							var urls = [];
							var abr_urls = resp.abrVideoLocationList;
							var waiting = false;
							if (abr_urls) {
								for (var i = 0; i < abr_urls.length; i++) {
									var videotype = null;
									if (abr_urls[i].type === "DASH") {
										videotype = "dash";
									} else if (abr_urls[i].type === "HLS") {
										videotype = "hls";
									}
									if (!videotype) {
										console_warn(cache_key, "Unknown ABR content type", abr_urls[i].type, "for", abr_urls[i], resp);
										continue;
									}
									var obj = {
										video: videotype
									};
									var url = abr_urls[i].url;
									obj.url = url;
									if (abr_urls[i].params) {
										url += "?" + abr_urls[i].params;
										obj.url = url;
										if (abr_urls[i].type === "DASH") {
											query_dash_with_params({
												url: url,
												headers: {
													Referer: "https://tv.kakao.com/",
													Origin: "https://tv.kakao.com"
												}
											}, abr_urls[i].params, function(dash) {
												if (dash) {
													obj.url = "data:application/dash+xml," + encodeURIComponent(dash);
												}
												return done(fillobj_urls(urls, baseobj), 60 * 60);
											});
											waiting = true;
										}
									}
									urls.push(obj);
								}
							}
							var contenttype = resp.videoLocation.contentType;
							var video = true;
							if (contenttype) {
								if (contenttype === "HLS") {
									video = "hls";
								} else if (contenttype === "DASH") {
									video = "dash";
								} else if (contenttype === "MP4") {
									video = true;
								} else {
									console_warn(cache_key, "Unknown contentType:", { contenttype: contenttype, json: resp });
									video = null;
								}
							}
							if (video) {
								urls.push({
									url: resp.videoLocation.url,
									video: video,
									can_head: false // 404
								});
							}
							if (urls.length === 0)
								return done(null, false);
							if (!waiting)
								return done(fillobj_urls(urls, baseobj), 60 * 60);
						});
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain === "dn-img-page.kakao.com" ||
				domain === "page-images.kakaoentcdn.com") {
				if (/\/download\/+resource\?/.test(src)) {
					return keep_queries(src, "kid") + "&filename=o1";
				}
			}
			if (domain === "obs.line-scdn.net") {
				return {
					can_head: false,
					url: src.replace(/(:\/\/[^/]*\/(?:r\/+musicjp\/+.\/+)?[-_0-9A-Za-z]*)\/(?:small|large|preview|[fsm][0-9]+x[0-9]+)(?:[?#].*)?$$/, "$1")
				};
			}
			if (domain === "scdn.line-apps.com") return src.replace(/^[a-z]+:\/\/[^/]*\/(?:obs\/)?([-_0-9A-Za-z]*)(?:\/[a-z0-9]*)?$/, "https://obs.line-scdn.net/$1");
			if (domain === "cdn-obs.line-apps.com") return src.replace(/(\/[-0-9A-F]+\.[0-9a-z]+)\/[^/]*$/, "$1");
			if (domain === "resize-image.lineblog.me") return src.replace(/^[a-z]+:\/\/[^/]*\/[0-9a-f]*\/.*?\/([a-z]+:\/\/.*)/, "$1");
			if (domain === "stickershop.line-scdn.net") {
				return src.replace(/;[a-z]+=[^/]*(?:[?#].*)?$/, "");
			}
			if (domain === "d.line-scdn.net") {
				return src.replace(/[?].*/, "");
			}
			if (domain_nosub === "viki.io" && domain.match(/^[0-9]*\.viki\.io/)) {
				return {
					can_head: false,
					url: src.replace(/\?.*/, "")
				};
			}
			if (domain_nosub === "crunchyroll.com" && domain.match(/img[0-9]*\.[^/.]*\.crunchyroll\.com/)) {
				return src.replace(/(\/[0-9a-f]+)_(?:thumb|full)(\.[^/.]*)$/, "$1_main$2");
			}
			if (domain === "d3ieicw58ybon5.cloudfront.net") {
				return {
					url: src
						.replace(/\/resize\/[0-9]+\//, "/full/")
						.replace(/\/ex\/[0-9]+\.[0-9]+\/(?:(?:[0-9]+\.){3}[0-9]+\/)?/, "/full/"),
					can_head: false
				};
			}
			if (domain === "az616578.vo.msecnd.net") return src.replace(/\/files\/responsive\/[^/]*\/[^/]*\/[^/]*\//, "/files/");
			if ((domain_nosub === "dreamwiz.net" && domain.match(/img[0-9]*\.dreamwiz\.net/)) ||
				domain === "kep.cdn.index.hu" ||
				domain === "kep.index.hu" ||
				domain === "kep.cdn.indexvas.hu") {
				return src.replace(/_(?:[a-z]|wm)(\.[^/.]*)$/, "_o$1");
			}
			if (domain === "galeria.cdn.index.hu") return src.replace(/_[a-z]{1,2}(\.[a-z]+)(?:[?#].*)?$/, "$1");
			if ((domain_nosub === "sportsworldi.com" ||
				domain_nosub === "segye.com") &&
				string_indexof(src, "/content/image/") >= 0) {
				return src.replace(/(\/content\/+image\/+[0-9]{4}\/+[0-9]{2}\/+[0-9]{2}\/+)[0-9]+\/+([0-9]+(?:_[^/.]*)?\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			}
			if (domain_nowww === "maximkorea.net") return src.replace(/(\/[0-9]+_[0-9]+(?:_[0-9]+)?_img)_[0-9]+(\.[^/.]*)$/, "$1$2");
			if (domain === "blogimgc.eximg.jp") {
				return decodeURIComponent(decodeURIComponent(src.replace(/^[a-z]+:\/\/[^/]*\/.*?i=([^,]*).*?$/, "$1")));
			}
			if (domain === "i.gzn.jp" ||
				(domain_nosub === "uludagsozluk.com" && domain.match(/^galeri[0-9]*\./))) {
				return src.replace(/_[a-z](\.[^/.]*)$/, "$1");
			}
			if (domain_nosub === "okmusic.jp" ||
				domain === "newsimg.music-book.jp") {
				return src.replace(/(\/images\/[0-9]*\/)[^/.]*(\.[^/.]*)$/, "$1original$2");
			}
			if (domain_nowww === "kai-you.net") {
				return src
					.replace(/\/r\/img\/[a-z]\/[a-z]?[0-9]+x(?:[0-9]+)?\//, "/press/img/")
					.replace(/(\/images\/.*)\/[a-z]?[0-9]+x(?:[0-9]+)?\/([^/]*)$/, "$1/$2");
			}
			if (domain === "cdn.fortune-girl.com") return src.replace(/(:\/\/[^/]*\/)[a-z]*\/([-0-9a-f]*\.[^/.]*)$/, "$1original/$2");
			if (domain === "storage.withnews.jp" ||
				amazon_container === "storage.withnews.jp") {
				return src.replace(/-[a-z]+(\.[^/.]*)$/, "$1");
			}
			if (domain_nosub === "wowma.net" && domain.match(/ic[0-9]*-a\.wowma\.net/)) {
				return src.replace(/^[a-z]*:\/\/[^/]*\/mis?\/.*?\/([^/]*\.[^/]*\/.*)/, "http://$1");
			}
			if (domain_nowww === "sokuup.net") return src.replace(/\/img[a-z]\//, "/img/");
			if (domain_nosub === "cosp.jp" && domain.match(/image[0-9]\.cosp\.jp/)) {
				return src
					.replace(/\/thumb\/(.*?\/[0-9]+)[a-z]\.(?:gif|jpg)$/, "/images/$1.jpg")
					.replace(/(\/images\/.*\/[0-9]+)_[0-9]+(\.[^/.]*)$/, "$1$2")
					.replace(/(\/[0-9]+)[a-z](\.[^/.]*)/, "$1$2");
			}
			if (domain_nowww === "gahag.net") {
				return {
					url: src.replace(/:\/\/[^/]*\/img\/([^/]*)\/([0-9]+)[a-z]\/([^-/]+-[0-9]+)-[0-9](\.[^/.]*)/, "://img01.gahag.net/$1/$2o/$3$4"),
					headers: {
						Referer: "http://gahag.net/",
					}
				};
			}
			if (domain === "img-cdn.jg.jugem.jp") return src.replace(/_[a-z](\.[^/.]*)$/, "$1");
			if (domain === "public.muragon.com") return src.replace(/\/(?:crop|resize)\/[0-9]+x[0-9]+(\.[^/.]*)$/, "$1");
			if (domain === "base-ec2if.akamaized.net") return src.replace(/(:\/\/[^/]*\/)[^/]*[a-z]=[0-9][^/]*\//, "$1");
			if (domain_nosub === "imageflux.jp" ||
				domain === "static.mercdn.net" ||
				domain === "img-comic.pximg.net" ||
				domain === "public-img-comic.pximg.net") {
				newsrc = src.replace(/\/c!\/+[^/]*[a-z]=[0-9a-z%A-Z]+[^/]*\/+/, "/");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "img-comic.pximg.net") {
				return {
					url: src,
					imu_mode: "xhr",
					headers: {
						Referer: "https://comic.pixiv.net/",
						Origin: "https://comic.pixiv.net"
					}
				};
			}
			if (domain_nosub === "bloguru.com" &&
				string_indexof(src, "/userdata/") >= 0) {
				return src.replace(/\/([^/_]*)$/, "/orig_$1");
			}
			if (domain === "www.atpress.ne.jp") return src.replace(/(\/[0-9]+\/)[a-zA-Z]{2}_(img_[0-9]+[^/]*\.[^/.]*)$/, "$1$2");
			if (domain === "img-proxy.blog-video.jp" ||
				domain === "api.pddataservices.com") {
				return decodeURIComponent(src.replace(/^[a-z]+:\/\/[^/]*\/images.*?[?&]url=([^&]*).*?$/, "$1"));
			}
			if (domain === "cdn.otamart.com") return src.replace(/-thumbnail(\.[^/.]*)$/, "$1");
			if (domain === "www.pakutaso.com") return src.replace(/(\/img\/thumb\/[^/_.]*)_[^/.]*(\.[^/.]*)$/, "$1$2");
			if (domain === "cdn.atwiki.jp" ||
				(domain === "kinohron.mskcentrum.sk" && string_indexof(src, "/data-files/") >= 0)) {
				return src.replace(/\/small_([^/]*)$/, "/$1");
			}
			if (domain === "pliki.ppe.pl") return src.replace(/(\/storage\/+[0-9a-f]+\/+[0-9a-f]+)@[a-z]+\./, "$1.");
			if (domain === "getfile.fmkorea.com") {
				return decodeURIComponent(src.replace(/.*?\/getfile\.php.*?[?&]file=([^&]*).*/, "$1"));
			}
			if (domain === "img.ruliweb.com" ||
				domain === "img.korewaeroi.com" ||
				domain === "abc.imgxyqpdrs.xyz" ||
				(domain_nowww === "koreanartist.jp" && string_indexof(src, "/img/") >= 0 && src.match(/\/[0-9]+s\./)) ||
				domain === "image-bankingf25.com") {
				return src.replace(/s(\.[^/.]*)(?:[?#].*)?$/, "$1");
			}
			if (domain_nosub === "dtiblog.com" && /^[0-9]*\./.test(domain)) {
				return src.replace(/(?:_thumb|s)(\.[^/.]+)(?:[?#].*)?$/, "$1");
			}
			if (domain === "img2.ruliweb.com") return src.replace(/(\/mypi\/gup\/a\/[0-9]+\/[0-9]+\/)[a-z]+(\/[0-9]+\.[^/.]*)$/, "$1o$2");
			if (domain === "file.thisisgame.com") return src.replace(/\/s_([0-9]+_[0-9]+\.[^/.]*)$/, "/$1");
			if (domain === "www.op.gg") return src.replace(/^.*?\/forum\/outImage\/(http.*)$/, "$1");
			if (domain === "ssproxy.ucloudbiz.olleh.com" ||
				domain === "s.gae9.com") {
				return src.replace(/\.[a-z]*(?:[?#].*)?$/, ".orig");
			}
			if (domain_nowww === "artstation.com") {
				if (/\/assets\/+overlay-no-triangle-[0-9a-f]+\./.test(src)) {
					return {
						url: src,
						bad: "mask"
					};
				}
			}
			if (domain_nosub === "artstation.com" && domain.match(/cdn[a-z0-9]*\.artstation\.com/)) {
				regex = /(\/assets\/+(?:images|covers)\/+images\/+[0-9]{3}\/+[0-9]{3}\/+[0-9]{3}\/+)(?:[0-9]+\/+)?(?:small(?:er)?|micro|medium|large|4k)(?:_square)?\/([^/]*)$/;
				if (regex.test(src)) {
					return [
						src.replace(regex, "$1original/$2"),
						src.replace(regex, "$14k/$2"),
						src.replace(regex, "$1large/$2")
					];
				}
				return src.replace(/(\/marketplace\/+printed_product_covers\/+(?:[0-9]{3}\/+){3})(?:downscaled|(?:white_wrap|art_print)_(?:small|big)|hd_metal_print_scene)\/+/, "$1big_image/");
			}
			if (domain === "static.cosplay-it.com") return src.replace(/(\/[-0-9a-f]*)_[a-z]+(\.[^/.]*)/, "$1$2");
			if (domain === "a.fsdn.com") return src.replace(/(\/screenshots\/[^/]*)\/[0-9]+\/.*/, "$1");
			if (domain === "media.moddb.com" ||
				domain === "cdn.dbolical.com" ||
				domain === "media.indiedb.com") {
				newsrc = src.replace(/\/cache\/+images\/(.*?)\/[a-z]+_[0-9]+[^/]*(\/[^/]*\.[^/.]*)$/, "/images/$1$2");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/\/images\/+(.*?)\.mp4\.jpg(?:[?#].*)?$/, "/videos/$1.mp4");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "thumb.modcdn.io") return src.replace(/:\/\/thumb\.(.*\/)(?:crop|thumb)_[0-9]+x[0-9]+\/+/, "://image.$1");
			if (domain === "static.gamefront.com" ||
				domain_nowww === "wallpaperawesome.com" ||
				(domain_nowww === "ukstockingsex.com" && string_indexof(src, "/galleries/") >= 0) ||
				domain === "cg.adultwork.com") {
				return src.replace("/thumbnails/", "/");
			}
			if (domain === "thumb.test.mod.io" ||
				domain === "thumb.mod.io") {
				return src.replace(/:\/\/thumb\.([^/]*\..*?\/)[a-z]+_[0-9]+[^/]*\/([^/]*)$/, "://image.$1$2");
			}
			if (domain_nosub === "scirra.net" && domain.match(/static[0-9]*\.scirra\.net/)) {
				return src.replace(/\/avatars\/[0-9]+\//, "/avatars/256/");
			}
			if (domain === "cdn.gamer-network.net" ||
				domain === "d2skuhm0vrry40.cloudfront.net") {
				return src.replace(/(\.[^/.]*)\/EG[0-9]+\/.*/, "$1");
			}
			if (domain_nosub === "wikiart.org" && domain.match(/uploads[0-9]*\.wikiart\.org/)) {
				return src.replace(/![^/]*$/, "");
			}
			if ((domain_nosub === "fdncms.com" ||
				domain_nosub === "miaminewtimes.com" ||
				domain_nosub === "houstonpress.com" ||
				domain_nosub === "laweekly.com" ||
				domain_nosub === "cltampa.com" ||
				domain_nosub === "phoenixnewtimes.com") &&
				domain.match(/^(?:images|media)[0-9]*\./)) {
				newsrc = src.replace(/\/imager\/u\/[^/]*\/([0-9]+\/[^/]*)(?:\/.*)?/, "/imager/u/original/$1");
				if (newsrc !== src)
					return newsrc;
				if (src.match(/\/imager\/u\/[^/]*\/[0-9]+\/https?_3[aA]/)) {
					newsrc = src
						.replace(/.*?\/imager\/u\/[^/]*\/[0-9]+\/(https?_3[aA].*\.[^/._]*)(?:_[^/]*)?$/, "$1")
						.replace(/_([0-9a-fA-F][0-9a-fA-F])/g, "%$1");
					newsrc = decodeURIComponent(newsrc);
					return newsrc;
				}
			}
			if (domain === "images.techhive.com" ||
				domain === "images.idgesg.net") {
				return src.replace(/-[a-z]+(?:\.[^/.]*)?(\.[^/.]*)$/, "-orig$1");
			}
			if (domain_nosub === "rimg.com.tw" ||
				domain_nosub === "rimg.tw" ||
				domain === "photo.roodo.com" ||
				domain === "img.ruten.com.tw") {
				if (src.match(/(\/photos\/[0-9]+_[0-9a-z]+_)[a-z](\.[^/.]*)$/)) {
					return src.replace(/(\/photos\/[0-9]+_[0-9a-z]+_)[a-z](\.[^/.]*)$/, "$1o$2");
				}
				return {
					url: src.replace(/_[a-z](\.[^/.]*)$/, "$1"),
					headers: {
						Referer: "https://goods.ruten.com.tw/item/show"
					},
					referer_ok: {
						same_domain: true
					}
				};
			}
			if (domain === "buy.line-scdn.net") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/[a-f0-9]+\/s\//, "https://s.yimg.com/");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nosub === "hc360.cn" && domain.match(/img[0-9]*\.hc360\.cn/)) {
				return src.replace(/(\.[^/.]*)\.[^/]*$/, "$1");
			}
			if (domain_nosub === "ganref.jp" && domain.match(/photo[0-9]*\.ganref\.jp/)) {
				return src.replace(/(\/[0-9a-f]+\/)thumb[0-9]*(\.[^/.]*)$/, "$1original$2");
			}
			if (domain === "img.cdn.nimg.jp") return src.replace(/:\/\/img\.cdn\.nimg\.jp\/s\/(.*?\/images\/+[0-9]+\/+(?:[0-9a-f]+|[^/.]*\.[^/.]*))\/.*/, "://dcdn.cdn.nimg.jp/$1");
			if (domain_nosub === "photozou.jp") {
				return src
					.replace(/(\/photo\/[0-9]+\/org\.bin)\?.*$/, "$1")
					.replace(/(\/photo\/[0-9]+)_[a-z0-9]+(\.[^/]*)$/, "$1_org$2");
			}
			if (domain === "desktop.sakura.ne.jp" ||
				domain === "kysiamesecat.sakura.ne.jp") {
				return src.replace(/-thumbnail[0-9]*(\.[^/.]*)$/, "$1");
			}
			if ((domain_nowww === "ya.sakura.ne.jp" || domain === "mabi4751.orz.hm") &&
				string_indexof(src, "/~mabi/") >= 0) {
				return src.replace(/[sm](\.jpg|\.JPG)$/, "$1");
			}
			if (domain === "waganeko.sakura.ne.jp") return src.replace(/\/\.thumbnail\/([^/]*\.[^/.]*)\.[^/.]*$/, "/$1");
			if (domain_nosub === "storage-yahoo.jp") return src.replace(/_(?:m|thumb)(\?.*)?$/, "$1");
			if (domain === "static-mercari-jp-imgtr2.akamaized.net" ||
				domain === "mercari-images.global.ssl.fastly.net") {
				return src
					.replace(/\/thumb\/+(photos|members)\/+/, "/$1/")
					.replace(/(\/(?:photos|members)\/.*?)(?:[?#].*)$/, "$1");
			}
			if (domain === "assets.mercari-shops-static.com") {
				return src
					.replace(/(:\/\/[^/]+\/+-\/+large\/+[^/]+\/+[^/.]+\.[a-z]+)(?:@webp)?(?:[?#].*)?$/, "$1@jpg")
					.replace(/(:\/\/[^/]+\/+-\/+)small\/+/, "$1large/");
			}
			if (domain_nowww === "facebook.com" ||
				domain === "m.facebook.com" ||
				domain === "mbasic.facebook.com") {
				var find_from_serverjs = function(obj, requireid) {
					var require = [];
					if (obj.pre_display_requires) {
						require = obj.pre_display_requires;
					} else {
						if (obj.require) {
							require = obj.require;
						} else {
							return null;
						}
					}
					var result = [];
					for (var i = 0; i < require.length; i++) {
						if (require[i][0] === requireid) {
							result.push(require[i]);
						}
					}
					if (result.length === 0)
						return null;
					return result;
				};
				var find_prefetched_from_serverjs = function(obj, find) {
					var prefetched = find_from_serverjs(obj, "RelayPrefetchedStreamCache");
					if (!prefetched)
						return null;
					if (!find)
						find = [];
					if (!is_array(find))
						find = [find];
					var result = [];
					for (var i = 0; i < prefetched.length; i++) {
						var pre = prefetched[i];
						var data = pre[3];
						if (find.length > 0) {
							var found = false;
							for (var j = 0; j < find.length; j++) {
								if (find[j].test(data[0])) {
									found = true;
									break;
								}
							}
							if (!found)
								continue;
						}
						result.push(data);
					}
					if (result.length === 0)
						return null;
					return result;
				};
				var get_fb_serverjs = function(cache_key, resp, find) {
					var regex = /\(new ServerJS\(\)\)\.handleWithCustomApplyEach\(ScheduledApplyEach,({"(?:define|require)":.*?\]\]})\);\}/;
					var global = new RegExp(regex, "g");
					var match = resp.responseText.match(global);
					if (!match) {
						console_error(cache_key, "Unable to find matches for", resp);
						return null;
					}
					var jsons = [];
					for (var i = 0; i < match.length; i++) {
						var m = match[i];
						var submatch = m.match(regex);
						try {
							var json = JSON_parse(submatch[1]);
							var prefetched = find_prefetched_from_serverjs(json, find);
							if (!prefetched)
								continue;
							for (var j = 0; j < prefetched.length; j++) {
								jsons.push(prefetched[j]);
							}
						} catch (e) {
							console_error(cache_key, e, { match: m, submatch: submatch, resp: resp });
						}
					}
					if (jsons.length === 0)
						return null;
					return jsons;
				};
				var find_prefetched_from_bigpipe = function(bigpipe, find) {
					if (!bigpipe.jsmods || !bigpipe.jsmods.pre_display_requires)
						return;
					return find_prefetched_from_serverjs(bigpipe.jsmods, find);
				};
				var find_jsmods_instances_from_bigpipe = function(bigpipe, find) {
					if (!bigpipe.jsmods || !bigpipe.jsmods.instances)
						return;
					var instances = bigpipe.jsmods.instances;
					var retinstances = [];
					for (var i = 0; i < instances.length; i++) {
						if (find.length > 0 && false) {
							var type = instances[i][1];
							var found = false;
							for (var j = 0; j < find.length; j++) {
								for (var k = 0; k < type.length; k++) {
									console_log(type[k]);
									if (find[j].test(type[k])) {
										found = true;
										break;
									}
								}
								if (found)
									break;
							}
							if (!found)
								continue;
						}
						retinstances.push(instances[i]);
					}
					if (retinstances.length === 0)
						return null;
					return retinstances;
				};
				var get_fb_bigpipe = function(cache_key, resp, find) {
					var regex = /requireLazy\(\["__bigPipe"\],\(function\(bigPipe\){bigPipe\.onPageletArrive\(({.*?})\);}\)\);/;
					var global = new RegExp(regex, "g");
					var match = resp.responseText.match(global);
					if (!match) {
						console_error(cache_key, "Unable to find matches for", resp);
						return null;
					}
					if (!find)
						find = [];
					if (!is_array(find))
						find = [find];
					var ourfind = [];
					for (var i = 0; i < find.length; i++) {
						ourfind.push(new RegExp(find[i].source.replace(/[$^]/g, "")));
					}
					var jsons = [];
					for (var i = 0; i < match.length; i++) {
						var m = match[i];
						var submatch = m.match(regex);
						if (ourfind.length > 0 && false) {
							var found = false;
							for (var j = 0; j < ourfind.length; j++) {
								console_log(ourfind[j]);
								if (ourfind[j].test(submatch[1])) {
									found = true;
									break;
								}
							}
							if (!found)
								break;
						}
						try {
							var fixedup = fixup_js_obj_proper(submatch[1]);
							var json = JSON_parse(fixedup);
							var prefetched = find_prefetched_from_bigpipe(json, find);
							if (prefetched)
								array_extend(jsons, prefetched);
						} catch (e) {
							console_error(cache_key, e, { match: m, submatch: submatch, resp: resp });
						}
					}
					if (jsons.length === 0)
						return null;
					return jsons;
				};
				var parse_newstyle_fb = function(cache_key, resp) {
					var serverjs = get_fb_serverjs(cache_key, resp, /^adp_CometPhotoRootQueryRelayPreloader_/);
					if (!serverjs) {
						console_error(cache_key, "Unable to find serverjs match for", resp);
						return null;
					}
					var json = serverjs[0];
					var data = json[1].__bbox.result.data;
					var currMedia = data.currMedia;
					var obj = {
						extra: {
							page: resp.finalUrl
						}
					};
					if (currMedia.message && currMedia.message.text) {
						obj.extra.caption = currMedia.message.text;
					} else if (currMedia.accessibility_caption) {
						obj.extra.caption = currMedia.accessibility_caption;
					}
					obj.url = common_functions["instagram_norm_url"](currMedia.image.uri);
					return obj;
				};
				var parse_oldstyle_fb = function(cache_key, resp) {
					var match = resp.responseText.match(/\<div\s+class=\"hidden_elem\"\s*>.*?data-ploi=\"(https?:\/\/[^"]*?)\"/);
					if (!match) {
						console_error(cache_key, "Unable to find match for", resp);
						return null;
					}
					var obj = {
						extra: {
							page: resp.finalUrl
						}
					};
					obj.url = decode_entities(match[1]);
					return obj;
				};
				var parse_html_post = function(cache_key, resp, current_id) {
					var matches = match_all(resp.responseText, /<a rel="theater" ajaxify="([^"]+)"/);
					if (!matches) {
						console_error(cache_key, "Unable to find theater match for", resp);
						return null;
					}
					var links = [];
					array_foreach(matches, function(match, i) {
						var url = match[1];
						url = url.replace(/[?#].*$/, "");
						url = urljoin("https://www.facebook.com/", url, true);
						links.push({
							url: url,
							is_current: i === current_id
						});
					});
					if (!links.length) {
						console_error(cache_key, "No photos found for", resp, matches);
						return null;
					}
					return {
						url: links[current_id].url,
						is_pagelink: true,
						album_info: {
							type: "links",
							links: links
						}
					};
				};
				var query_facebook_post = function(uid, post_id, cb) {
					var cache_key = "facebook_post:" + uid + ":" + post_id;
					var url = "https://www.facebook.com/" + uid + "/posts/" + post_id;
					if (/^[0-9]{10,}$/.test(uid)) {
						url = "https://www.facebook.com/permalink.php?story_fbid=" + post_id + "&id=" + uid;
					}
					api_query(cache_key, {
						url: url,
						imu_mode: "document"
					}, cb, function(done, resp, cache_key) {
						var current_id = 0;
						var serverjs = get_fb_serverjs(cache_key, resp, [
							/^adp_CometSinglePostRootQueryRelayPreloader_/,
							/^adp_CometPagePostsRootHoistedStoryQueryRelayPreloader_/ // xpost
						]);
						if (!serverjs) {
							var html_parse = parse_html_post(cache_key, resp, 0);
							if (html_parse)
								return done(html_parse, 60 * 60);
							console_error(cache_key, "Unable to find serverjs match for", resp);
							return done(null, false);
						}
						var json = serverjs[0];
						var data = json[1].__bbox.result.data;
						var node;
						if ("node" in data) {
							node = data.node;
						} else if ("nodes" in data) { // hoisted story
							node = data.nodes[0];
						} else {
							console_error(cache_key, "Unable to find node from", data, json, resp);
							return done(null, false);
						}
						var story = node.comet_sections.content.story;
						if (story.attached_story)
							story = story.attached_story;
						var attachments = story.attachments;
						for (var i = 0; i < attachments.length; i++) {
							try {
								var attachment = attachments[i].style_type_renderer.attachment;
								var album_info = null;
								if (attachment.all_subattachments) {
									var nodes = attachment.all_subattachments.nodes;
									attachment = nodes[current_id];
									album_info = {
										type: "links",
										links: []
									};
									for (var j = 0; j < nodes.length; j++) {
										var node = nodes[j];
										var node_url = node.url || node.media.url;
										var media_url;
										try {
											var node_image = node.image || node.media.image;
											var media_url = node_image.uri;
										} catch (e) {
											console_error(e);
										}
										album_info.links.push({
											url: node_url,
											x_id: media_url,
											is_current: j === current_id
										});
									}
								}
								var url = attachment.url || attachment.media.url;
								var obj = {
									url: url,
									is_pagelink: true,
									album_info: album_info
								};
								return done(obj, 6 * 60 * 60);
							} catch (e) {
								console_error(cache_key, e);
							}
						}
						return done(null, false);
					});
				};
				var parse_facebook_post_url = function(url) {
					var match = url.match(/^[a-z]+:\/\/[^/]+\/+([^/]+)\/+posts\/+([0-9]+)(?::[0-9]+)?\/*(?:[?#].*)?$/);
					if (match) {
						return {
							uid: match[1],
							post_id: match[2]
						};
					}
					match = url.match(/^[a-z]+:\/\/[^/]+\/+(?:permalink|story)\.php\?/);
					if (match) {
						var queries = get_queries(url);
						if (queries.story_fbid && queries.id) {
							return {
								uid: queries.id,
								post_id: queries.story_fbid
							};
						}
					}
					return null;
				};
				newsrc = website_query({
					website_regex: [
						/^[a-z]+:\/\/[^/]+\/+[^/]+\/+photos\/+(?:[^/]+\/+)?([0-9]+)\/*(?:[?#].*)?$/,
						/^[a-z]+:\/\/[^/]+\/+photo(?:\/+|\.php)\?(?:.*&)?fbid=([0-9]+)(?:[&#].*)?$/
					],
					cache_key: "facebook_photo",
					query_for_id: function(id) {
						return {
							url: "https://www.facebook.com/photo/?fbid=" + id, // needed for private photos
							imu_mode: "document"
						};
					},
					process: function(done, resp, cache_key) {
						var obj = parse_newstyle_fb(cache_key, resp);
						if (!obj) {
							obj = parse_oldstyle_fb(cache_key, resp);
						}
						if (obj) {
							return done(obj, 60 * 60);
						} else {
							return done(null, false);
						}
					}
				});
				if (newsrc)
					return newsrc;
				newsrc = website_query({
					website_regex: [
						/^[a-z]+:\/\/[^/]+\/+watch\/+\?(?:.*&)?v=([0-9]+)(?:&.*)?(?:[?#].*)?$/,
						/^[a-z]+:\/\/[^/]+\/+[^/]+\/+videos\/+([0-9]+)\/*(?:[?#].*)?$/
					],
					cache_key: "facebook_video",
					query_for_id: function(id) {
						return {
							url: "https://www.facebook.com/watch/?v=" + id,
							imu_mode: "document"
						};
					},
					process: function(done, resp, cache_key) {
						var results = get_fb_serverjs(cache_key, resp, [
							/^adp_CometVideoHomeInjectedFeedUnitQueryRelayPreloader_/,
							/^adp_CometTahoeRootQueryRelayPreloader_/
						]);
						if (!results) {
							results = get_fb_bigpipe(cache_key, resp, [
								/^adp_CometVideoHomeFeedRootQueryRelayPreloader_/,
								/^adp_CometVideoHomeInjectedFeedUnitQueryRelayPreloader_/
							]);
							if (!results) {
								console_error(cache_key, "Unable to find serverjs match for", resp);
								return done(null, false);
							}
						}
						for (var i = 0; i < results.length; i++) {
							var data = results[i][1].__bbox.result.data;
							if (!data.video && !data.story)
								continue;
							var media;
							if (data.video)
								media = data.video;
							else if (data.story) // bigpipe
								media = data;
							if (media.story && media.story.attachments && media.story.attachments.length && media.story.attachments[0].media) {
								media = media.story.attachments[0].media;
							}
							if (!media.videoId && !media.id && !media.permalink_url) {
								continue;
							}
							var obj = {
								extra: {
									page: media.permalink_url || media.url || resp.finalUrl
								}
							};
							var video_data = {};
							try {
								var json_video_data = media.video_player_component_renderer.video.video_player_dash_module_renderer.json_encoded_video_data;
								video_data = JSON_parse(json_video_data);
							} catch (e) {
								video_data = media;
							}
							var urls = [];
							if (false && media.playable_url_dash) {
								urls.push({
									url: media.playable_url_dash,
									video: "dash"
								});
							}
							if (video_data.dash_manifest) {
								urls.push({
									url: "data:application/dash+xml," + encodeURIComponent(video_data.dash_manifest),
									video: "dash"
								});
							}
							if (media.playable_url_quality_hd || video_data.hd_src) {
								urls.push({
									url: media.playable_url_quality_hd || video_data.hd_src,
									video: true
								});
							}
							if (media.playable_url || video_data.sd_src_no_ratelimit || video_data.sd_src) {
								urls.push({
									url: media.playable_url || video_data.sd_src_no_ratelimit || video_data.sd_src,
									video: true
								});
							}
							var thumbnail = media.thumbnailImage || media.image;
							if (thumbnail && thumbnail.uri) {
								urls.push(thumbnail.uri);
							}
							return done(fillobj_urls(urls, obj), 60 * 60);
						}
						console_error(cache_key, "Unable to find media from", { resp: resp, serverjs: results });
						return done(null, false);
					}
				});
				if (newsrc)
					return newsrc;
				var parsed_url = parse_facebook_post_url(src);
				if (parsed_url) {
					page_nullobj = {
						url: src,
						is_pagelink: true
					};
					if (options.do_request && options.cb) {
						query_facebook_post(parsed_url.uid, parsed_url.post_id, function(obj) {
							if (!obj) {
								return options.cb(page_nullobj);
							}
							var imuurl;
							var imu_imageid;
							var imu_match = src.match(/#imu-url=(.*)$/);
							if (imu_match) {
								imuurl = imu_match[1];
								imu_imageid = common_functions["instagram_get_imageid"](imuurl);
							}
							if (imuurl && obj.album_info) {
								common_functions["update_album_info_links"](obj, function(x) {
									var imageid = common_functions["instagram_get_imageid"](x);
									return imu_imageid === imageid;
								});
							}
							return options.cb([obj, page_nullobj]);
						});
						return {
							waiting: true
						};
					} else {
						return page_nullobj;
					}
				}
				if (false) {
					newsrc = website_query({
						website_regex: [
							/^[a-z]+:\/\/[^/]+\/+stories\/([0-9]+)\/+([^/]+)\/*(?:[?#].*)?$/
						],
						cache_key: "facebook_story",
						query_for_id: function(id) {
							return {
								url: "https://www.facebook.com/stories/" + id,
								imu_mode: "document"
							};
						},
						process: function(done, resp, cache_key) {
							/*var results = get_fb_serverjs(cache_key, resp);
							console_log(results);*/
						}
					});
					if (newsrc)
						return newsrc;
				}
			}
			if (host_domain === "m.facebook.com" && options.element) {
				if (options.element.tagName === "IMG" && options.element.classList.contains("img")) {
					common_functions["get_pagelink_el_matching"](options.element, /\/photos\//);
				}
			}
			if (domain === "waichi.sakura.ne.jp") return src.replace(/(\/[^/_.]*)(\.(?:jpg|JPG|jpeg|png|PNG))$/, "$1_L$2");
			if (domain === "news.merumo.ne.jp") {
				newsrc = src
					.replace(/\/imgs\/+rect[0-9]*\//, "/imgs/src/")
					.replace(/\/(?:article)?img\/+([0-9]+)(?:\/+[0-9]+)?(?:[?#].*)?$/, "/imgs/src/$1");
				if (newsrc !== src)
					return newsrc;
				match = src.match(/\/imgs\/+src\/+([0-9]+)(?:[?#].*)?$/);
				if (false && match) {
					var id_1 = match[1];
					var folder_id = zpadnum(match[1], 9);
					return "https://images.merumo.ne.jp/" + folder_id.slice(0, 3) + "/" + folder_id.slice(3, 6) + "/" + folder_id.slice(6, 9) + "/" + id_1 + "_src_0.jpg";
				}
			}
			if (domain === "images.merumo.ne.jp") return src.replace(/(\/(?:[0-9]{3}\/+){3}[0-9]+)_(?:[a-z]+|rect[0-9]*)((?:_[0-9]+)?\.)/, "$1_src$2");
			if ((domain_nosub === "shikimori.org" ||
				domain_nosub === "shikimori.one") &&
				string_indexof(src, "/system/") >= 0) {
				return src.replace(/\/[a-z]+\/+((?:[0-9]+\/+)?[0-9]+\.[^/.]*)$/, "/original/$1");
			}
			if (domain === "assets.survivalinternational.org") return src.replace(/_[0-9a-z_]+(\.[^/.]*)$/, "_original$1");
			if (domain === "alioss.g-cores.com" &&
				string_indexof(src, "/uploads/image/") >= 0) {
				return src.replace(/_watermark(\.[^/.]*)$/, "$1");
			}
			if (domain === "img.nyato.com" ||
				domain === "img.ifun01.com" ||
				domain === "img.itw01.com" ||
				domain === "img.mttmp.com" ||
				domain === "img.maoduoer.com" ||
				domain === "img.sycs.net" ||
				domain === "img.6jyx.com" ||
				domain === "dn-kdt-img.qbox.me" ||
				domain === "pic-cdn.35pic.com" ||
				domain === "images.sharerails.com" ||
				domain === "oi5mmhyk8.qnssl.com" ||
				domain === "pic.cr173.com" ||
				(domain_nosub === "5ceimg.com" && /^i[0-9]*\./.test(domain)) ||
				domain === "movieboo.oss-cn-hangzhou.aliyuncs.com" ||
				domain === "cover.read.duokan.com" ||
				(domain_nosub === "asus.com" && /^img(?:-[a-z]+)?[0-9]*\./.test(domain) && /!t[0-9]+x[0-9]+(?:[?#].*)?$/.test(src)) ||
				(domain_nosub === "gitee.com" && /\/avatar\//.test(src)) ||
				domain === "img.mgpyh.com") {
				newsrc = src.replace(/!.*/, "");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nosub === "90sjimg.com" ||
				domain === "bpic.588ku.com" ||
				domain === "588ku.qiao88.com" ||
				domain === "static.pptstore.net" ||
				domain === "img.lovepik.com") {
				newsrc = src.replace(/(?:!|%21)\/.*/, "");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nosub === "woyaogexing.com" && domain.match(/^img[0-9]*\./)) {
				return src.replace(/(\/[0-9a-z]+)![^/]*(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			}
			if (domain === "inews.gtimg.com" ||
				domain === "pnewsapp.tc.qq.com") {
				return {
					url: src.replace(/\/newsapp_[a-z]+\/+([0-9]+\/+[0-9]+\/+)[0-9]+(?:\/+[0-9]+)?(?:[?#].*)?$/, "/newsapp_match/$10"),
					headers: {
						"Origin": "",
						"Referer": ""
					}
				};
			}
			if ((domain === "acg.ms" ||
				domain === "m.acg.ms") &&
				string_indexof(src, "/photo/") >= 0) {
				return {
					redirects: true,
					url: src.replace(/(\/[0-9]+)_[0-9]+_[0-9]+(\.[^/.]*)$/, "$1_0_9999999$2")
				};
			}
			if (domain === "sl.news.livedoor.com") {
				return src.replace(/^[a-z]+:\/\/[^/]*\/[a-f0-9]+\/[^/]*\//, "");
			}
			if (domain === "photo.tuchong.com") return src.replace(/\/[a-z]\/([0-9]+\.[^/.]*)/, "/f/$1");
			if ((domain === "arine.akamaized.net" ||
				domain === "media-assets.aumo.jp") &&
				string_indexof(src, "/uploads/photo/") >= 0) {
				return src.replace(/(\/[0-9]+\/)[a-z]+_([-0-9a-z]+\.[^/.]*)$/, "$1$2");
			}
			if (domain === "newsimg.glossom.jp") return src.replace(/(\/[0-9]+_)[0-9]+(_[0-9]+\.[^/.]*)$/, "$1org$2");
			if (domain === "www.vtianxia.cn") return src.replace(/(\/uploadfile\/[a-z]+\/)[a-z]+\//, "$1big/");
			if (domain === "img.over-blog-kiwi.com" ||
				domain === "img.over-blog.com" ||
				(domain_nosub === "over-blog.com" && string_indexof(domain, ".idata.over-blog.com") >= 0)) {
				return src.replace(/(:\/\/[^/]*\/)[0-9]+x[0-9]+(?:-[a-z]+)?\//, "$1");
			}
			if (domain === "resize.over-blog.com") {
				return src.replace(/^[a-z]+:\/\/[^/]*\/[0-9]+x[0-9]+(?:-[a-z]+)?\.[^/.?]*\?/, "");
			}
			if (domain_nosub === "eastday.com" && domain.match(/[0-9]*\.?imgmini\.eastday\.com/)) {
				return src
					.replace(/(\/[0-9]+_[0-9a-f]+_[0-9]+)_[^/.]*(\.[^/.]*)(?:[?#].*)?$/, "$1$2")
					.replace(/_wmk(\.[^/.]*)(?:[?#].*)?$/, "$1");
			}
			if (domain_nosub === "so-net.ne.jp" ||
				domain_nosub === "ss-blog.jp") {
				return src.replace(/\/(?:m|S[0-9]+)_([^/]*)$/, "/$1");
			}
			if (amazon_container === "rejob-v2-images-production" ||
				(amazon_container === "mosaia" && src.match(/\/images\/[0-9]+\/[^/]*$/))) {
				return src.replace(/\/[^/.]*(\.[^/.]*)$/, "/original$1");
			}
			if (domain === "lohas.nicoseiga.jp") {
				newsrc = src.replace(/(\/thumb\/+[0-9]+)[a-z][a-z]?(\?.*)?$/, "$1l$2");
				if (newsrc !== src)
					return newsrc;
				var get_nicovideo_obj = function(id) {
					return {
						url: src,
						extra: { page: "https://seiga.nicovideo.jp/seiga/im" + id }
					};
				};
				obj = null;
				match = src.match(/\/thumb\/+([0-9]+)(?:[a-z]+)(?:[?#].*)?$/);
				if (match) {
					id = match[1];
					obj = get_nicovideo_obj(id);
				}
				if (match && options.do_request && options.cb) {
					var cache_key = "nicoseiga:" + id;
					api_cache.fetch(cache_key, options.cb, function(done) {
						options.do_request({
							url: "https://seiga.nicovideo.jp/image/source/" + id,
							method: "GET",
							onload: function(resp) {
								if (resp.readyState !== 4)
									return;
								if (resp.status !== 200) {
									console_error(resp);
									return done(null, false);
								}
								var headers = headers_list_to_dict(parse_headers(resp.responseHeaders));
								if ("content-type" in headers) {
									if (/^image\//.test(headers["content-type"])) {
										return done(resp.finalUrl, 6 * 60 * 60);
									}
								}
								var match = resp.responseText.match(/<div\s+class=\"illust_view_big\"[^>]+data-src=\"([^"]+)\"/);
								if (!match) {
									console_error("Unable to find match (are you logged in to nicovideo?)", resp);
									return done(null, false);
								}
								var url = decode_entities(match[1]);
								obj.url = urljoin(resp.finalUrl, url, true);
								done(obj, 6 * 60 * 60);
							}
						});
					});
					return {
						waiting: true
					};
				}
				if (!match) {
					match = src.match(/\/priv\/+[0-9a-f]{10,}\/+[0-9]+\/+([0-9]+)(?:[?#].*)?$/);
					if (match) {
						id = match[1];
						obj = get_nicovideo_obj(id);
					}
				}
				if (obj) {
					return obj;
				}
			}
			if (domain === "appdata.hungryapp.co.kr") {
				return src
					.replace(/\/data_img_[a-z]\//, "/data_img/")
					.replace(/(\/[0-9]{6}\/[0-9]{2}\/[^/]*\.[^/.]*)\/hungryapp\/.*/, "$1");
			}
			if (domain === "media.funradio.fr") return src.replace(/\/cache\/[0-9a-zA-Z]+\/[0-9a-z]+-[0-9]+\//, "/");
			if (domain === "image.afcdn.com" ||
				domain === "assets.afcdn.com" ||
				domain === "imalbum.aufeminin.com" ||
				domain === "imworld.aufeminin.com") {
				return {
					url: src
						.replace(/(\/acc[0-9]+_(?:[a-z]+_)?[0-9]+\/+[a-z0-9]+)_[a-z0-9]+(\.[^/.]*)/, "$1$2")
						.replace(/(-[0-9]+_[A-Z0-9]+_)[A-Z](?:_[a-z[0-9]+)?(\.[^/.]*)/, "$1L$2")
						.replace(/\/(?:[^/.?#]+-)?((?:[a-z]+)?[0-9]+)_[a-z0-9]+(\.[^/.]*)/, "/$1_origin$2"),
					headers: {
						Origin: "https://www.sofeminine.co.uk/",
						Referer: "https://www.sofeminine.co.uk/"
					}
				};
			}
			if ((domain_nosub === "greatsong.net" && domain.match(/static[0-9]*\.greatsong\.net/)) ||
				(domain_nosub === "china.com" && domain.match(/img[0-9]*\.(?:[a-z]+\.)?china\.com/))) {
				return src.replace(/\/[0-9]+x[0-9]+\//, "/original/");
			}
			if (domain === "ipravda.sk") return src.replace(/\/thumbs\/([^/]*)-(?:stvorec|nestandard[0-9]*|galeria|clanokW?|strednaW?|malaW?)(\.[^/.]*)$/, "/$1$2");
			if (domain === "d919ce141ef35c47fc40-b9166a60eccf0f83d2d9c63fa65b9129.ssl.cf5.rackcdn.com" ||
				domain === "media.phillyvoice.com") {
				return src.replace(/(\/images\/[^/.]+\.)[^/]*(\.[^/.]*)$/, "$1original$2");
			}
			if (domain === "nation.com.pk") return src.replace(/\/print_images\/[a-z]+\//, "/print_images/large/");
			if (domain === "dazedimg.dazedgroup.netdna-cdn.com" ||
				domain === "images-prod.anothermag.com" ||
				domain === "anotherimg-dazedgroup.netdna-ssl.com" ||
				domain === "images-prod.dazeddigital.com" ||
				domain === "dazedimg-dazedgroup.netdna-ssl.com") {
				newsrc = src.replace(/(:\/\/[^/]*\/)[0-9]+\/(?:[0-9]+-[0-9]+-[0-9]+-[0-9]+\/)?/, "$1");
				if (newsrc !== src)
					return newsrc;
				return src.replace(/^[a-z]+:\/\/[^/]+\/+azure\/+(.*)/, "https://dazedprod.blob.core.windows.net/$1");
			}
			if (domain === "www.fuse.tv") return src.replace(/(\/image\/[0-9a-f]+\/)[0-9]+\/[0-9]+\/([^/]*)$/, "$1$2");
			if (domain === "assets.capitalxtra.com") return src.replace(/(\/[^/.]*-[0-9]{8,})-[^/.]*(\.[^/.]*)$/, "$1$2");
			if (domain === "imgproc.airliners.net") return src.replace(/(\/photos\/+[^/]+\/+(?:[0-9]\/+){3}[^/]+)-v[0-9a-f]+-[0-9]+(\.[^/.]+)(?:[?#].*)?$/, "$1$2");
			if (domain_nowww === "ukmix.org") {
				match = src.match(/\/proxy\.php\?(?:.*&)?url=([^&]+)/);
				if (match) {
					return base64_decode(decodeURIComponent(match[1]));
				}
			}
			if (domain === "m.static.newsvine.com" &&
				string_indexof(src, "/servista/imagesizer?") >= 0) {
				return src.replace(/(\/servista\/imagesizer).*?[?&](file=[^&]*).*/, "$1?$2");
			}
			if (domain_nosub === "cosplaywon.com" && domain.match(/theprecious[0-9]*\.cosplaywon\.com/)) {
				return src.replace(/(\/photo\/[0-9]+\/)[a-z]+_([-0-9a-f]+\.[^/.]*)$/, "$1original_$2");
			}
			if (domain_nowww === "otaku.com") return src.replace(/(\/files\/images\/)[^/]*\/(?:[A-Z]+_)?([^/]*)$/, "$1fullsize/$2");
			if ((domain_nosub === "joyreactor.com" ||
				domain_nosub === "reactor.cc" ||
				domain_nosub === "thatpervert.com" ||
				domain_nosub === "joyreactor.cc") &&
				domain.match(/^img[0-9]*\./)) {
				newsrc = src.replace(/(\/pics\/post\/)([^/]*)$/, "$1full/$2");
				if (newsrc !== src)
					return newsrc;
				id = src.replace(/.*\/pics\/thumbnail\/post-([0-9]+)\.[^/.]*$/, "$1");
				if (id !== src && options && options.cb && options.do_request) {
					options.do_request({
						url: src.replace(/:\/\/img[0-9]*\.([^/]*\/).*/, "://$1post/" + id),
						method: "GET",
						onload: function(resp) {
							if (resp.readyState === 4) {
								var match = resp.responseText.match(/<div class="image">\s*(?:<a[^>]*>)?\s*<img[^>]*src="([^"]*)"/);
								if (match) {
									options.cb(match[1]);
								} else {
									options.cb(null);
								}
							}
						}
					});
					return {
						waiting: true
					};
				}
			}
			if (domain_nowww === "coolwallpaperz.info") return src.replace(/(\/uploads\/wall\/)thumb(\/[0-9]+\/[^/]*)$/, "$1o$2");
			if (domain_nowww === "besthqwallpapers.com" ||
				domain_nowww === "wallpapers4screen.com" ||
				domain_nowww === "brightwallpapers.com.ua") {
				return src.replace(/(\/[Uu]ploads\/+(?:[0-9]{1,2}-){2}[0-9]{4}\/+(?:[0-9]+|[-0-9a-f]+)\/+)thumb[0-9]*-([^/]*)$/, "$1$2");
			}
			if (domain_nowww === "avatanplus.com") {
				if (string_indexof(src, "/resize.php?") >= 0) {
					var queries = get_queries(src);
					return "https://avatanplus.com/files/" + queries.type + "/original/" + queries.file;
				}
				return src
					.replace(/(\/files\/[a-z]+)\/[a-z]+\/([0-9a-f]+\.[^/.]*)$/, "$1/original/$2");
			}
			if (domain === "data.japanese.kpopstarz.com" ||
				domain === "image.kpopstarz.com" ||
				domain === "images.kpopstarz.com" ||
				domain === "images.kstars.kr" ||
				domain === "images.enstarz.com" ||
				domain === "cdn.breathecast.com" ||
				(domain_nosub === "yibada.com" && /^image\./.test(domain)) ||
				(domain_nosub === "cdn77.org" && /^[0-9]+\.rsc\./.test(domain)) ||
				(domain_nosub === "stackpathdns.com" && domain.match(/1tmxd3aba43noa\./))) {
				newsrc = src
					.replace(/\/data\/thumbs\/full\/([0-9]+)\/[0-9]+\/[0-9]+\/[0-9]+\/[0-9]+\/([^/]*)$/, "/data/images/full/$1/$2")
					.replace(/[?#].*$/, "");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "studiosol-a.akamaihd.net") {
				return src
					.replace(/(:\/\/[^/]*\/)([a-z]+)\/[0-9]+x[0-9]+\//, "$1uploadfile/$2/")
					.replace(/-tb_[0-9]+(\.[^/.]*)$/, "$1");
			}
			if (domain_nowww === "letradamusica.net" && string_indexof(src, "/fotos/") >= 0) {
				return src.replace(/-tb(?:_[0-9]+)?(\.[^/.]*)(?:[?#].*)?$/, "$1");
			}
			if (amazon_container === "quietus_production") {
				return src.replace(/_crop_[0-9]+x[0-9]+(\.[^/.]*)$/, "$1");
			}
			if (domain_nowww === "bmi.com" &&
				string_indexof(src, "/images/") >= 0) {
				return src.replace(/\/cache\/([^/]*)_[0-9]+_[0-9]+_[0-9]+(?:_[a-z]+)?(\.[^/.]*)$/, "/$1$2");
			}
			if (domain === "media.rbl.ms") {
				if (string_indexof(src, "/image?") >= 0) {
					var queries = get_queries(src);
					return urljoin(decodeURIComponent(queries.ho), decodeURIComponent(queries.u));
				}
			}
			if (domain_nowww === "filepicker.io" ||
				domain === "cdn.filestackcontent.com" ||
				domain === "process.fs.grailed.com" ||
				domain === "media.graphcms.com" ||
				domain === "blog.cdn.own3d.tv" ||
				domain === "d1t35hkz8sx2bl.cloudfront.net") {
				newsrc = src
					.replace(/^[a-z]+:\/\/[^/]+\/+(?:[a-zA-Z0-9]{15,}\/+)?(?:(?:(?:[a-z]+=[^/]*|(?:fl[io]p|compress|auto_image))\/+)+|api\/+file\/+)?/, "")
					.replace(/^(?:convert(?:[?#].*)?|[?#.].*)$/, ""); // to remove invalid urls
				if (newsrc !== src && newsrc.length) {
					if (/^[a-z]+:\/\/[^/]+\/+/.test(newsrc))
						return newsrc;
					return urljoin(src, "/" + newsrc, true);
				}
				return {
					url: src.replace(/^([a-z]+:\/\/[^/]+\/+(?:api\/+file\/+)?[0-9a-zA-Z]{15,})\/+convert\?.*/, "$1"),
					head_wrong_contenttype: true
				};
			}
			if (domain === "cdn.teenidols4you.com" ||
				domain === "www.teenidols4you.com") {
				return src.replace(/:\/\/[^/]*\/thumb\/(.*?)\/(?:[0-9]+)?([^/]*)$/, "://www.teenidols4you.com/blink/$1/$2");
			}
			if (domain === "cdn.pixabay.com") {
				newsrc = src.replace(/.*?\/photo\/.*\/([^/]*-[0-9]+)_+[0-9]+[^/]*(\.[^/.]*)$/, "https://pixabay.com/en/photos/download/$1$2");
				obj = {
					url: src,
					redirects: true,
					headers: {
						Referer: "https://pixabay.com/"
					}
				};
				var ret = [obj];
				if (newsrc !== src) {
					var newobj = deepcopy(obj);
					newobj.url = newsrc;
					ret.unshift(newobj);
				}
				return ret;
			}
			if (domain_nosub === "meetupstatic.com") {
				return src
					.replace(/\/photo_api\/([^/]*)\/.*\/([0-9]+\.[^/.]*)$/, "/photos/$1/0/0/0/highres_$2")
					.replace(/\/(?:thumb|[0-9]+)_([0-9]+\.[^/.]*)$/, "/highres_$1");
			}
			if (domain === "d38c5dutwb1t0j.cloudfront.net") return src.replace(/\/Pictures\/[0-9a-z]+x[0-9a-z]+\//, "/Pictures/9999999xany/");
			if (domain === "img.drillspin.com") return src.replace(/(:\/\/[^/]*\/[a-z]+\/)[0-9]+\//, "$1orig/");
			if (domain === "pics.drillspin.com") return src.replace(/\/[0-9]+(\.[^/.]*)$/, "/orig$1");
			if ((domain_nosub === "bestie.vn" && domain.match(/^static[0-9]*\./)) ||
				domain === "img.highloadtest.com" ||
				domain === "cdn.sinemia.com") {
				return src.replace(/(:\/\/[^/]*\/)[0-9]+x[0-9]+\//, "$1");
			}
			if (domain === "cdn.britannica.com") return src.replace(/(:\/\/[^/]*\/)(?:s:)?[0-9]+x[0-9]+(?:,[^/]+)?\//, "$1");
			if (domain === "cdn.awsli.com.br") return src.replace(/(:\/\/[^/]+\/+)[0-9]+x[0-9]+\/+([0-9]+\/+[0-9]+\/+)/, "$1$2");
			if (domain_nowww === "pets4homes.co.uk") return src.replace(/(\/images\/[^/]+\/[0-9]+\/)[a-z]+\/([^/]*)$/, "$1original/$2");
			if (domain === "r.hswstatic.com") return src.replace(/:\/\/[^/]*\/[a-z]_[0-9]+\//, "://s.hswstatic.com/");
			if (domain === "images.woovly.com") return src.replace(/(:\/\/[^/]+\/+)[wh]_[0-9]+\/+/, "$1");
			if (domain_nowww === "candb.com") return src.replace(/(\/candb\/)cache\/([^/]*\/)[0-9]+\/([^/]*)_[0-9]+x[0-9]+(?:[^/]*)?(\.[^/.]*)$/, "$1images/$2$3$4");
			if (domain_nowww === "ottawalife.com") return src.replace(/\/cms\/images\/[a-z]+\//, "/cms/images/large/");
			if (domain === "assets.rpgsite.net") return src.replace(/(\/images\/[0-9]+\/[0-9]+\/[0-9]+\/)[a-z]+\/([^/]+)$/, "$1original/$2");
			if (domain_nowww === "nusabali.com") return src.replace(/(\/article_images\/[0-9]+\/[^/]*)-(?:thumb|800)(-[0-9]+-[0-9]+-[0-9]+-[0-9]+_[0-9]+\.[^/.]*)$/, "$1$2");
			if (domain_nowww === "wowkeren.com") {
				return src
					.replace(/\/display\/images\/[0-9]+x[0-9]+\//, "/display/images/photo/")
					.replace(/\/images\/events\/[^/]*\//, "/images/events/ori/");
			}
			if (domain === "m.aceshowbiz.com" ||
				domain_nowww === "aceshowbiz.com") {
				newsrc = src
					.replace(/(\/display\/images\/)[0-9]+x[0-9]+\//, "$1/photo/")
					.replace(/(\/images\/[^/]*\/)preview\//, "$1");
				if (newsrc !== src)
					return newsrc;
				regex = /\/images\/+news-thumb\/+[0-9]{4}\/+[0-9]{2}\/+/;
				if (regex.test(src))
					return [
						src.replace(regex, "/images/wennpic/"),
						src.replace(regex, "/images/news/")
					];
			}
			if (domain === "asset.kompas.com" ||
				domain === "assets.pikiran-rakyat.com" ||
				(domain_nosub === "grid.id" && domain.match(/^asset(?:-[a-z]*)?\./))) {
				return src
					.replace(/\/crop\/[0-9x:]+\/[0-9]*x[0-9]*\//, "/")
					.replace(/\/crops\/+.*\/+(data\/+photo\/+)/, "/$1");
			}
			if (domain === "cdn.thinglink.me") return src.replace(/(\/api\/image\/[0-9a-zA-Z]+)\/.*$/, "$1");
			if (domain === "images.sk-static.com") {
				return {
					url: src.replace(/(\/[0-9]+\/)[a-z_]+$/, "$1original"),
					head_wrong_contenttype: true
				};
			}
			if (domain === "www.stalkcelebs.com" && string_indexof(src, "/img-folder/") >= 0) {
				return src.replace(/_t(_[0-9]+\.[^/.]*)$/, "$1");
			}
			if (domain === "www.picsofcelebrities.com") return src.replace(/\/media(\/.*\/pictures\/)[a-z]+(\/[^/]*)$/, "$1large$2");
			if (domain === "dxglax8otc2dg.cloudfront.net") return src.replace(/\/media\/cache\/(.*)[-_]thumb\.[a-f0-9]+(\.[^/.]*)$/, "/media/$1$2");
			if (domain_nosub === "smugmug.com" ||
				domain === "photos.smugmug.com") {
				if (/\/img\/+spacer\.gif(?:[?#].*)?$/.test(src)) {
					return {
						url: src,
						bad: "mask"
					};
				}
				regex = /(\/i-[A-Za-z0-9]+\/+[0-9]+\/+(?:[^/]+\/+)?)(?:[A-Z0-9x]+|Ti)(\/+[^/]*)(?:\?.*)?$/;
				newsrc = src.replace(regex, "$1O$2");
				obj = {
					url: src
				};
				if (newsrc !== src) {
					if (options.do_request) {
						common_functions["get_redirect_url"](api_cache, options, newsrc, options.cb);
						return {
							waiting: true
						};
					} else {
						return newsrc;
					}
				}
				if (options.force_page && options.do_request && options.cb && (newsrc !== src || regex.test(src))) {
					var get_original_page = function(imageid, cb) {
						api_cache.fetch("smugmug_original_page:" + imageid, cb, function(done) {
							options.do_request({
								method: "GET",
								url: "https://washingtonlife.smugmug.com/A/" + imageid + "/A",
								onload: function(result) {
									if (result.readyState !== 4)
										return;
									var match = result.responseText.match(/document\.location\.href\s*=\s*["'](.*?)["']/);
									if (match) {
										return done(match[1], 6 * 60 * 60);
									}
									done(null, false);
								}
							});
						});
					};
					match = src.match(/\/(i-[A-Za-z0-9]+)\/+[0-9]+\/+/);
					if (match) {
						get_original_page(match[1], function(originalpage) {
							if (originalpage)
								obj.extra = { page: originalpage };
							options.cb(obj);
						});
						return {
							waiting: true
						};
					}
				}
				return obj;
			}
			if (domain_nosub === "lithium.com" && string_indexof(domain, ".i.lithium.com") >= 0 ||
				domain === "answers.ea.com" ||
				(domain_nosub === "samsung.com" && /^(?:[^.]+\.)?community\.samsung\./.test(domain)) ||
				domain === "community.amd.com" ||
				domain === "community.spotify.com" ||
				domain === "nasz.orange.pl" ||
				/^[a-z]+:\/\/[^/]+\/+t5\/+image\/+serverpage\/+image-id\/+[0-9]+i[0-9A-F]+\//.test(src)) {
				var v = src.replace(/.*[?&](v=[^&]*).*/, "$1");
				if (v === src)
					v = "";
				else
					v = "?" + v;
				return {
					url: src.replace(/(\/image-id\/+[0-9]+i[0-9A-F]+)\/+image-size\/.*(?:\?.*)?$/, "$1" + v),
					head_wrong_contentlength: true
				};
			}
			if (domain === "www.favepeople.com") return src.replace(/(\/photos\/[0-9a-z]+\/[0-9a-z]+\/[0-9a-z]+)(?:_[a-z]+)?(\/[^/]*)?(\.[^/.]*)$/, "$1_b$2$3");
			if (domain === "img.anews.com") {
				newsrc = src.replace(/.*\?url=([^&]*).*?$/, "$1");
				if (newsrc !== src)
					return decodeURIComponent(newsrc);
				return src.replace(/\/r\/[0-9]+x[0-9]+\//, "/media/posts/images/");
			}
			if (domain_nosub === "5ce.com" && /^img(?:-[0-9]+)\.proxy\./.test(domain)) {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/+\?(?:.*?&)?url=([^&]*).*?$/, "$1");
				if (newsrc !== src)
					return decodeuri_ifneeded(newsrc);
			}
			if (domain === "immagini.quotidiano.net" ||
				domain === "safeimage.vusercontent.com") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/+\?url=([^&]*).*?$/, "$1");
				if (newsrc !== src)
					return decodeuri_ifneeded(newsrc);
			}
			if (domain_nowww === "realitytvworld.com" ||
				domain === "cdn.realitytvworld.com") {
				newsrc = src.replace(/(\/images\/+gallery\/+[0-9]+)-[a-z](\.[^/.]*)(?:[?#].*)?$/, "$1-o$2");
				if (newsrc !== src)
					return newsrc;
				regex = /(\/heads\/gen\/embedded\/[0-9]+)-[a-z](\.[^/.]*)$/;
				return [
					src.replace(regex, "$1-a$2"),
					src.replace(regex, "$1-l$2")
				];
			}
			if (domain === "video.newsserve.net" ||
				domain === "cdn.newsserve.net") {
				return src.replace(/(:\/\/[^/]*\/)[0-9]+\//, "$1");
			}
			if (domain_nowww === "laughspark.info") return src.replace(/\/thumbfiles\/[0-9]+X[0-9]+\//, "/uploadfiles/");
			if (domain_nosub === "giphy.com" && domain.match(/^(?:media[0-9]*|i)\./)) {
				var baseobj_4 = {
					url: src,
					headers: {
						Referer: "https://giphy.com/"
					}
				};
				obj = baseobj_4;
				match = src.match(/\/media\/+([^/]{10,})\/+/);
				if (match) {
					var get_giphy_page = function(id) {
						return "https://giphy.com/gifs/" + id;
					};
					id = match[1];
					var page = get_giphy_page(id);
					baseobj_4.extra = { page: page };
					var query_giphy = function(id, cb) {
						var cache_key = "giphy:" + id;
						api_cache.fetch(cache_key, cb, function(done) {
							options.do_request({
								url: get_giphy_page(id),
								method: "GET",
								headers: {
									Referer: ""
								},
								onload: function(result) {
									if (result.readyState !== 4)
										return;
									if (result.status !== 200) {
										console_error(result);
										return done(null, false);
									}
									var match = result.responseText.match(/<script>\s*Giphy\.renderDesktop\(.*?{\s*gif:\s*({.+}),/);
									if (match) {
										try {
											var json = JSON_parse(match[1]);
											return done(json, 6 * 60 * 60);
										} catch (e) {
											console_error(e);
										}
									} else {
										console_warn("No match found", result);
									}
									done(null, false);
								}
							});
						});
					};
					if (options && options.do_request && options.cb) {
						query_giphy(id, function(data) {
							if (!data) {
								return options.cb(null);
							}
							var images = data.images;
							var get_image = function(obj) {
								var ourobj = deepcopy(baseobj_4);
								ourobj.url = obj.url;
								return ourobj;
							};
							if (images.source) {
								return options.cb(get_image(images.source));
							} else {
								return options.cb(null);
							}
						});
						return {
							waiting: true
						};
					}
				}
				if (false) {
					newsrc = src.replace(/:\/\/media[0-9]*\./, "://i.");
					if (newsrc !== src) {
						obj.url = newsrc;
						return obj;
					}
					newsrc = src.replace(/\/(?:giphy|[0-9]+[whs_]*)\.(?:gif|webp|mp4)/, "/source.mp4");
					if (newsrc !== src) {
						obj.url = newsrc;
						return obj;
					}
				}
				return obj;
			}
			if (domain === "www.showgle.co.kr" && string_indexof(src, "/uploads/") >= 0) {
				return src.replace(/(\/[0-9a-f]+)_[a-z](\.[^/.]*)$/, "$1$2");
			}
			if (domain === "photos.modelmayhem.com") {
				newsrc = src
					.replace(/(\/photos\/[0-9]+\/[0-9a-f]+\/[0-9a-f]+)_[a-z](\.[^/.]*)$/, "$1$2")
					.replace(/(\/potd\/entrants\/[0-9]+\/[^/]*)-[a-z]+(\.[^/.]*)$/, "$1-big$2")
					.replace(/(\/avatars\/+(?:[0-9]\/+){1,}[0-9a-f]+)_x?t(\.[^/.]+)(?:[?#].*)?$/, "$1_m$2");
				if (newsrc !== src)
					return newsrc;
			}
			if (host_domain_nosub === "modelmayhem.com" && options.element) {
				if (!src) {
					var current = options.element;
					while ((current = current.parentElement)) {
						if (current.tagName === "DIV" && current.id === "viewpic") {
							var og_image_meta = document.querySelector("meta[property=\"og:image\"]");
							if (og_image_meta) {
								return og_image_meta.getAttribute("content");
							}
							break;
						}
					}
				}
				var query_picid = function(picid, cb) {
					var cache_key = "modelmayhem:" + picid;
					api_cache.fetch(cache_key, cb, function(done) {
						options.do_request({
							url: "https://www.modelmayhem.com/portfolio/pic/" + picid,
							method: "GET",
							onload: function(resp) {
								if (resp.readyState !== 4)
									return;
								if (resp.status !== 200) {
									console_error(cache_key, resp);
									return done(null, false);
								}
								var match = resp.responseText.match(/<meta\s+property="og:image"\s+content="([^"]+)"/);
								if (!match) {
									console_error(cache_key, "Unable to find match", resp);
									return done(null, false);
								}
								return done(decode_entities(match[1]), 24 * 60 * 60);
							}
						});
					});
				};
				var get_picid_from_url = function(url) {
					return url.replace(/.*\/portfolio\/+pic\/+([0-9]+)(?:[?#].)?$/, "$1");
				};
				if (options.do_request && options.cb) {
					var parent = options.element.parentElement;
					if (parent && parent.tagName === "A" && /\/portfolio\/+pic\/+[0-9]+/.test(parent.href)) {
						query_picid(get_picid_from_url(parent.href), function(newsrc) {
							if (newsrc) {
								var obj = {
									url: newsrc
								};
								if (/\/images\/+nopic_worksafe-on\./.test(src)) {
									obj.can_cache = false;
								}
								options.cb(obj);
							} else {
								options.cb(null);
							}
						});
						return {
							waiting: true
						};
					}
				}
			}
			if (domain === "static.artbible.info") return src.replace(/(:\/\/[^/]*\/)[a-z]+\//, "$1large/");
			if (domain_nosub === "oclc.org" && domain.match(/\.contentdm\./) ||
				domain === "digital.denverlibrary.org") {
				newsrc = src
					.replace(/\/+digital\/+api\/+singleitem\/+image\/+([^/]*\/+[0-9]+)\/+.*(\.[^/.?#]*)(?:[?#].*)?$/, "/digital/iiif/$1/full/full/0/default$2")
					.replace(/\/+digital\/+download\/+collection\/+([^/]*)\/(?:.*\/)?id\/+([0-9]+).*?$/, "/digital/api/singleitem/image/$1/$2/default.jpg");
				if (newsrc !== src)
					return newsrc;
				if (src.match(/:\/\/[^/]*\/+utils\/+ajaxhelper\/+/)) {
					var queries = get_queries(src);
					var folder = queries.CISOROOT;
					var id = queries.CISOPTR;
					return src.replace(/(:\/\/[^/]*\/).*$/, "$1digital/api/singleitem/image/" + folder + "/" + id + "/default.jpg");
				}
			}
			if (domain === "tools.wmflabs.org") {
				newsrc = src.replace(/(\/zoomviewer\/+iipsrv\.fcgi\/+\?(?:.*&)?iiif=[^/]+\/+[^/]+\/+)[^/]+\/[^/]+\/[^/]+\/([^/]+\.[^/.]*)$/, "$1full/full/0/$2");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nowww === "koodtv.com" ||
				domain_nowww === "hanimusic.com") {
				return src.replace(/\/thumb-([^/.]*)_[0-9]+x[0-9]+(\.[^/.]*)$/, "/$1$2");
			}
			if (domain === "file.bodnara.co.kr") {
				return decodeURIComponent(src.replace(/.*?\/insidelogo\.php.*?[?&]image=([^&]*).*$/, "$1")).replace(/^\/*/, "");
			}
			if (domain === "passport.mobilenations.com" ||
				(domain_nowww === "timpul.md" && string_indexof(src, "/uploads/") >= 0)) {
				return src.replace(/\/[0-9]+x[0-9]+_([^/]*\.[^/.]*)$/, "/$1");
			}
			if (domain === "www.dollargeneral.com" &&
				string_indexof(src, "/media/") >= 0) {
				return src.replace(/\/cache\/(?:image|thumbnail)\/[0-9]+x[0-9]+\//, "/cache/image/");
			}
			if (domain === "www.dollartree.com" &&
				string_indexof(src, "/assets/") >= 0) {
				return src.replace(/\/styles\/[^/]*\/([^/]*)$/, "/styles/jumbo/$1");
			}
			if (domain === "d2192bm55jmxp1.cloudfront.net") return src.replace(/\/resize\/[a-z]+\//, "/origin/");
			if (domain === "i.marieclaire.com.tw") {
				newsrc = src.replace(/\/[0-9]+X[0-9]+\/([0-9A-F]+\.[^/.]*)$/, "/$1");
				if (newsrc !== src) {
					return [newsrc.replace(/\.jpg$/, ".jpeg"), newsrc];
				}
			}
			if (domain === "ir.marieclaire.com.tw") return src.replace(/:\/\/[^/]*\/(?:[a-z][0-9]+){1,}\/+assets\/+/, "://i.marieclaire.com.tw/assets/");
			if (domain === "img.vogue.com.tw" ||
				domain === "dw6vrgax4fzym.cloudfront.net" ||
				domain === "img.gq.com.tw") {
				return src
					.replace(/\/_rs\/[0-9]+\//, "/")
					.replace(/\/userfiles\/(?:sm|thumbnail)\/sm[0-9]+_images/, "/userfiles/images");
			}
			if (domain === "niuerdata.donews.com" ||
				domain === "niuerdata.g.com.cn") {
				return src
					.replace(/\/new_thumb\//, "/big_media_img/")
					.replace(/\/thumb_([0-9a-f]+\.[^/.]*)$/, "/$1");
			}
			if (domain === "pictures.icpress.cn") return src.replace(/s(\.[^/.]*)$/, "$1");
			if ((domain === "interview365.mk.co.kr" &&
				string_indexof(src, "/images/") >= 0)) {
				return src.replace(/(\/[0-9]+_)[A-Z](_[0-9]+\.[^/.]*)$/, "$1L$2");
			}
			if (domain === "draw.acharts.net") return src.replace(/-[a-z](\.[^/.]*)$/, "-l$1");
			if (domain === "gqhotstuff.gq.com.mx") return src.replace(/\/api\/photos\/[a-z]+\//, "/api/photos/original/");
			if (domain === "images.apester.com") {
				return {
					url: src.replace(/(:\/\/[^/]*\/[^/]*\.[^/.]*)\/[/a-z0-9]+$/, "$1"),
					head_wrong_contentlength: true
				};
			}
			if (domain === "twt-thumbs.washtimes.com") return src.replace(/(:\/\/twt-)thumbs(\.[^/]*\/media\/(?:image|img)\/.*?)_[cs][0-9][-_0-9a-z]+(\.[^/.?]*)(?:\?.*)?$/, "$1media$2$3");
			if (domain === "dynamicmedia.zuza.com") {
				return src
					.replace(/\/zz\/m\/[^/]*\//, "/zz/m/original_/")
					.replace(/(\.[0-9]*(?:-[0-9]+)?)_[^-./]*(\.[^/.]*)$/, "$1$2");
			}
			if (domain === "images.commeaucinema.com") return src.replace(/\/galerie\/([^/]*)$/, "/galerie/big/$1");
			if (domain === "static.screenweek.it" ||
				amazon_container === "static.screenweek.it") {
				return src.replace(/_[a-z]+(\.[^/.]*)$/, "$1");
			}
			if (domain_nowww === "goodblud.com") return src.replace(/(\/media\/+mppicture\/+[0-9]{4}\/+[0-9]{2}\/+[0-9]{2}\/+[0-9]+_[-0-9a-f]{30,})_mid(\.[^/.]*)(?:[?#].*)?$/, "$1_big$2");
			if (domain === "da4pli3l5vc0d.cloudfront.net") return src.replace(/(:\/\/[^/]*\/(?:(?:[0-9a-f]{2})\/){2}[0-9a-f]+)\/.*$/, "$1");
			if (domain_nosub === "hollywood.com" && domain.match(/photo\.media[0-9]*\.hollywood\.com/)) {
				return src.replace(/(:\/\/[^/]*\/)[^/]*\//, "$1full/");
			}
			if (((domain === "www.doodoo.ru" ||
				domain === "www.youloveit.ru" ||
				domain_nowww === "take.az" ||
				domain_nowww === "starmodels.ru" ||
				domain_nowww === "nevseoboi.com.ua" ||
				domain_nowww === "photoofnude.com" ||
				domain_nowww === "hronika.info" ||
				domain_nowww === "qadin.net" ||
				domain_nowww === "allday2.com" ||
				domain_nowww === "tonshuul.mn" ||
				domain_nowww === "animechan.ru" ||
				domain_nowww === "sexs-foto.com" ||
				domain_nowww === "sexs-foto.info" ||
				domain_nowww === "informaplus.ru" ||
				domain_nowww === "modnaya.org" ||
				domain_nowww === "negani.com" ||
				domain_nowww === "chukcha.net" ||
				domain_nowww === "opa.kg" ||
				domain_nowww === "pirojok.net" ||
				domain_nowww === "femanes.ru" ||
				domain_nowww === "vistanews.ru" ||
				domain_nowww === "tour-rest.ru" ||
				domain_nowww === "znamenitka.ru" ||
				domain_nowww === "all-stars.su" ||
				domain_nowww === "kinoukr.com" ||
				domain === "ww22.zone-telechargement.lol" ||
				domain_nowww === "hdxa.me" ||
				domain_nowww === "razdam.net" ||
				domain_nowww === "bugaga.ru") &&
				string_indexof(src, "/uploads/") >= 0) ||
				domain === "cdn.prognozist.ru" ||
				src.match(/^[a-z]+:\/\/[^/]*\/uploads\/posts\/[0-9]{4}-[0-9]{2}\/(?:thumbs|medium)\/[0-9]+(?:_[^/]*)?\.[^/.]*$/) ||
				src.match(/^[a-z]+:\/\/[^/]*\/uploads\/[a-z]+\/(?:[0-9]+x[0-9]+\/)?[0-9]{4}-[0-9]{2}\/thumbs\/[0-9]+x[0-9]+_crop_[0-9]+_[^/]*$/)) {
				newsrc = src.replace(/\/uploads\/[a-z]+\/(?:[0-9]+x[0-9]+\/)?([0-9]+-[0-9]+\/)(?:(?:thumbs|medium)\/)?(?:[0-9]+x[0-9]+_crop_)?([^/]*)$/, "/uploads/posts/$1$2");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/(\/+posts\/+[0-9]{4}-[0-9]{2}\/+)thumbs\/+/, "$1");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nowww === "henchan.me") return src.replace(/(:\/\/[^/]*\/)[^/]*\/+(uploads\/+posts\/+)/, "$1$2");
			if (domain_nowww === "goldwallpapers.com") return src.replace(/(\/uploads\/posts\/[^/]*\/)thumb\/([^/]*)$/, "$1$2");
			if (domain_nowww === "tooob.com" &&
				string_indexof(src, "/api/") >= 0) {
				return src.replace(/(\/[0-9]+\/)__[^/]*$/, "$1");
			}
			if (domain_nosub === "ask.fm" && domain.match(/akphoto[0-9]*\.ask\.fm/) ||
				domain === "dok7xy59qfw9h.cloudfront.net") {
				return src.replace(/\/[a-z]+\/((?:[0-9]+|.+)\.[^/.]*)$/, "/large/$1");
			}
			if (domain_nosub === "ask.fm" && domain.match(/^akimg[0-9]*\.ask\.fm/) ||
				domain === "d2hhj3gz5jljkm.cloudfront.net" ||
				domain === "d15eldcwi10xcl.cloudfront.net") {
				return src.replace(/\/thumb(?:_big)?\/+([^/]+)(?:[?#].*)?$/, "/normal/$1");
			}
			if (domain === "d2p4y1juxwnww4.cloudfront.net") return src.replace(/(\/(?:[0-9a-f]+\/+){6})thumb\/+/, "$1original/");
			if (domain_nowww === "alchetron.com") return src.replace(/-resize-[0-9]+(\.[^/.]*)$/, "$1");
			if (domain === "img.ltn.com.tw") {
				return src
					.replace(/(\/Upload\/+(?:[a-z]+\/+page|news)\/+)[0-9]+[A-Z]?\/+([0-9]{4}\/+[0-9]{2}\/+[0-9]{2}\/+)/, "$1orig/$2")
					.replace(/\/Upload\/+style\/+bphoto\/+[^/]+\/+/, "/Upload/style/bphoto/original/");
			}
			if (domain_nosub === "lystit.com" && domain.match(/cdn[a-z]?\.lystit\.com/)) {
				return src.replace(/(:\/\/[^/]*\/)[0-9]+\/[0-9]+\/[0-9a-z]+\/photos\//, "$1photos/");
			}
			if (domain === "www.newshub.co.nz") {
				return {
					url: src.replace(/(\/image(?:[_.][0-9]+)?\.dynimg\.)[^/]*(\.q[0-9]+\.[^/.]*)(\/.*)?$/, "$1full$2$3"),
					can_head: false
				};
			}
			if (amazon_container === "s3.931wolfcountry.com" ||
				domain === "assets.instyle.co.uk" ||
				domain === "d2nzqyyfd6k6c7.cloudfront.net" ||
				(amazon_container && amazon_container.match(/^s3(?:\.[^/]*)?\.radio\.com$/)) ||
				domain === "qtxasset.com" ||
				amazon_container === "wpr-public" ||
				amazon_container === "prod-media.gameinformer.com" ||
				domain === "community-content-assets.minecraft.net" ||
				domain === "cdn-s3.si.com" ||
				(domain_nosub === "hercampus.com" && domain.match(/^cdn[0-9]*\./)) ||
				amazon_container === "southbank-ipcmedia-com" ||
				domain === "cdn.newsbusters.org" ||
				amazon_container === "radioimg" ||
				amazon_container === "b2bm" ||
				amazon_container === "looppacificassets" ||
				amazon_container === "botw-pd" ||
				amazon_container === "cartoons-s3" ||
				domain === "static.cdn.turner.com" ||
				amazon_container === "kpopimg") {
				newsrc = src.replace(/\/styles\/+[^/]+\/+s3(?:fs)?\//, "/");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nosub === "s-nbcnews.com" && domain.match(/media[0-9]*\.s-nbcnews\.com/)) {
				return src.replace(/(:\/\/[^/]*\/)j(\/.*\/[^/.]*)[^/]*(\.[^/.]*)$/, "$1i$2$3");
			}
			if (domain === "imgcp.aacdn.jp") return src.replace(/\/img-a\/[0-9a-z]+\/[0-9a-z]+\//, "/img-a/auto/auto/");
			if (domain_nowww === "kpopselca.com") return src.replace(/\/selca\/thumb\//, "/selca/");
			if (domain_nowww === "koogle.tv") return src.replace(/\/\.thumbnails\/([^/]*)-[0-9]+x[0-9]+(\.[^/.]*)$/, "/$1$2");
			if (domain_nowww === "fanaru.com" ||
				domain_nowww === "stuffpoint.com") {
				return src.replace(/\/image\/thumb\//, "/image/");
			}
			if (domain === "d9nvuahg4xykp.cloudfront.net" ||
				domain === "d1w8cc2yygc27j.cloudfront.net") {
				return src.replace(/_thumbnail(\.[^/.]*)$/, "$1");
			}
			if (domain === "i.lihkg.com" ||
				domain_nowww === "f3img.gq") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/[0-9]+\/http/, "http");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nowww === "24minus.ru") return src.replace(/^[a-z]+:\/\/[^/]+\/+[0-9]+\/+[0-9]+\/+(https?)\/+(.*)/, "$1://$2");
			if (domain_nowww === "f3img.gq") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/[0-9]*.*?[?&]u=(http[^&]*).*?$/, "$1");
				if (newsrc !== src)
					return decodeuri_ifneeded(newsrc);
			}
			if (domain === "www.nintendoworldreport.com" &&
				string_indexof(src, "/media/") >= 0) {
				return src.replace(/\/gallery\/([0-9]+\.[^/.]*)$/, "/$1");
			}
			if (domain_nowww === "nintendoeverything.com" &&
				string_indexof(src, "/gallery/") >= 0) {
				return src.replace(/\/thumbs\/thumbs_([^/]*)$/, "/$1");
			}
			if (domain === "images.nintendolife.com") {
				return src
					.replace(/(\/attachment\/[^/]*\/)[^/]+(\.[^/.]*)$/, "$1original$2")
					.replace(/(:\/\/[^/]+\/+[0-9a-f]{5,}\/+(?:[^/]+\.)?)(?:cover_)?(?:[0-9]*x[0-9]*|large|cover)(\.[^/.]+)(?:[?#].*)?$/, "$1original$2");
			}
			if (domain === "cdn.igromania.ru") return src.replace(/(\/[0-9a-f]+)(?:_[^-_/.]*)?(\.[^/.]*)$/, "$1_original$2");
			if (domain === "i.blogs.es") return src.replace(/\/[0-9]+_[0-9]+(\.[^/.]*)$/, "/original$1");
			if (domain_nosub === "rbl.ms") {
				newsrc = src.replace(/.*\/image.*?[?&]source=([^&]*).*/, "$1");
				if (newsrc !== src) {
					return decodeURIComponent(newsrc);
				}
				newsrc = src.replace(/.*?\/simage\/([^/]*)\/.*/, "$1");
				if (newsrc !== src) {
					return decodeURIComponent(newsrc);
				}
			}
			if (domain === "resize-rbl-ms.cdn.ampproject.org" ||
				(domain_nosub === "ampproject.org" && domain.match(/\.cdn\.ampproject/))) {
				return src.replace(/^[a-z]+:\/\/[^/]*\/(?:ii\/[wh][0-9]+|i)\/s\/([^/]+\.[^/]+\/[^?#]+)(?:[?#].*)?$/, "http://$1");
			}
			if (domain === "assets.rbl.ms") return src.replace(/(:\/\/[^/]*\/[0-9]+\/)[^/.]*(\.[^/.]*)$/, "$1origin$2");
			if (domain === "i.paigeeworld.com" ||
				domain === "d395qfwg4461au.cloudfront.net") {
				return src.replace(/(\/user-(?:uploads|media\/[0-9]+)\/[0-9a-f]+_[0-9a-f]+_)[^/.]*(\.[^/.]*)$/, "$1rz$2");
			}
			if (domain === "1d31c772ec21a65b0a71-0707aae3004193da193e1ad4a942592d.ssl.cf2.rackcdn.com") return src.replace(/(:\/\/[^/]*\/[0-9]+\/[^/.]*)__[^_/.]*(\.[^/.]*)$/, "$1$2");
			if (domain === "i.nextmedia.com.au") {
				return decodeURIComponent(src.replace(/.*\/Utils\/ImageResizer\.ashx.*?[?&]n=([^&]*).*?$/, "$1"));
			}
			if ((domain_nosub === "heritagestatic.com" && /^dyn[0-9]*\.heritagestatic\.com/.test(domain)) ||
				domain === "prodimage.images-bn.com" ||
				(domain_nosub === "hm.com" && /^lp[0-9]*\./.test(domain)) ||
				domain === "images.biglots.com") {
				if (/[?&](?:set|source)=/.test(src)) {
					var querystring = src.replace(/.*?\?/, "");
					var splitted = querystring.split("&");
					var newkvs = {};
					var rawkvs = [];
					var parse_command = function(value) {
						var match = value.match(/^([a-z_A-Z]+)\[([^\]]*)\]?$/);
						if (!match) {
							return null;
						}
						return {
							cmd: match[1],
							arg: decodeURIComponent(match[2])
						};
					};
					array_foreach(splitted, function(query) {
						var key = query.replace(/=.*$/, "");
						var value = decodeURIComponent(query.replace(/^.*?=/, ""));
						if (key === "set") {
							var setcmds = value.split(",");
							var local_kvs = {};
							array_foreach(setcmds, function(setcmd) {
								var parsed_command = parse_command(setcmd);
								if (!parsed_command) {
									console_error("Unable to parse command:", setcmd, setcmds);
									return false;
								}
								local_kvs[parsed_command.cmd] = parsed_command.arg;
							});
							if (local_kvs["key"]) {
								newkvs[local_kvs["key"]] = {
									value: local_kvs["value"],
									type: "kv"
								};
								delete local_kvs["key"];
								delete local_kvs["value"];
							}
							for (var lkey in local_kvs) {
								newkvs[lkey] = {
									value: local_kvs[lkey],
									type: "string"
								};
							}
						} else {
							var parsed_command = parse_command(value);
							if (!parsed_command) {
								console_warn("Unable to parse command:", parsed_command, value);
								rawkvs.push(query);
								return;
							}
							newkvs[key] = {
								value: parsed_command.arg,
								type: parsed_command.cmd
							};
						}
					});
					console_log(newkvs);
					delete newkvs.scale;
					delete newkvs.sizedata;
					delete newkvs.rotate;
					var imageurls = [];
					if (newkvs.source && newkvs.source.type === "url") {
						imageurls.push(newkvs.source.value);
					}
					if (newkvs.imageURL) {
						if (domain === "images.biglots.com") {
							newkvs.imageURL.value = urljoin("https://www.biglots.com/", newkvs.imageURL.value, true);
							newkvs.imageURL.type = "url";
						}
						imageurls.push(newkvs.imageURL.value);
					}
					var modified_size = false;
					if ("resolve.width" in newkvs)
						newkvs["resolve.width"].value = 99999;
					if ("resolve.height" in newkvs)
						newkvs["resolve.height"].value = 99999;
					if (modified_size)
						newkvs["resolve.allowImageUpscaling"].value = 0;
					if ("resolve.pixelRatio" in newkvs)
						newkvs["resolve.pixelRatio"].value = 1;
					if ("quality" in newkvs) {
						if (/^[0-9]{1,2}$/.test(newkvs["quality"].value))
							newkvs["quality"].value = 100;
					}
					if ("res" in newkvs && domain_nosub === "hm.com") {
						var resvalue = newkvs["res"].value;
						if (resvalue === "s" || // 564x846
							resvalue === "m" || // 1536x2304
							resvalue === "l") // 2160x3240
							newkvs["res"].value = "x"; // 2280x4320
					}
					if ("call" in newkvs && domain_nosub === "hm.com") {
						newkvs["call"].value = newkvs["call"].value
							.replace(/product\/main$/, "product/fullscreen")
							.replace(/product\/(?:thumb|small|medium|large)$/, "product/full");
					}
					var newqueries = [];
					var sets = [];
					for (var key_2 in newkvs) {
						var objvalue = newkvs[key_2];
						if (objvalue.type === "kv") {
							newqueries.push("set=" + encodeURIComponent("key[" + key_2 + "],value[" + objvalue.value + "]"));
						} else if (objvalue.type === "string") {
							sets.push([key_2, objvalue.value]);
						} else {
							newqueries.push(key_2 + "=" + encodeURIComponent(objvalue.type + "[" + objvalue.value + "]"));
						}
					}
					if (sets.length > 0) {
						var setkvs_1 = [];
						array_foreach(sets, function(kv) {
							setkvs_1.push(kv[0] + "[" + kv[1] + "]");
						});
						newqueries.unshift("set=" + encodeURIComponent(setkvs_1.join(",")));
					}
					querystring = newqueries.join("&");
					newsrc = src.replace(/\?.*/, "?" + querystring);
					if (newsrc !== src)
						return {
							url: newsrc,
							can_head: false
						};
					if (imageurls.length > 0)
						return imageurls;
					return {
						url: src,
						can_head: false
					};
				}
			}
			if (domain_nowww === "natedsanders.com" && string_indexof(src, "/ItemImages/") >= 0) {
				return src.replace(/(\/[0-9a-z]+)_[a-z]+(\.[^/.]*)$/, "$1_lg$2");
			}
			if (domain === "d1x0dndjbjw02n.cloudfront.net" ||
				amazon_container === "static.lovely-media.jp" ||
				amazon_container === "static.cdn.xtreeem.com" ||
				amazon_container === "cdn.bibi-star.jp" ||
				amazon_container === "cdn.panda-gossips.com") {
				return src.replace(/(\/(?:[0-9]{3}\/+){3})[a-z]+(\.[^/.]*)(?:[?#].*)?$/, "$1original$2");
			}
			if (domain === "summary-sv.fc2.com") {
				return decodeURIComponent(src.replace(/.*?\/api\/resize_img\.php.*?[?&]src=([^&]*).*?$/, "$1"));
			}
			if (domain === "c.fc2.com") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/+imgs\/+(http[^/]*)\/*$/, "$1");
				if (newsrc !== src)
					return decodeuri_ifneeded(newsrc);
			}
			if (domain === "image.tmdb.org" ||
				domain_nowww === "themoviedb.org") {
				return src.replace(/\/[wh][0-9]+(?:_and[^/]*)?\/+([0-9a-zA-Z]+\.[^/.]*)$/, "/original/$1");
			}
			if (domain_nowww === "lookmovie.ag") return src.replace(/(\/images\/+[bpf]\/+)[wh][0-9]+\/+([0-9a-f]{10,}\.)/, "$1original/$2");
			if (domain === "embedly.massrelevance.com") {
				return decodeURIComponent(src.replace(/.*\/image.*?[?&]url=([^&]*).*?$/, "$1"));
			}
			if (domain === "media.lolusercontent.com") {
				return decodeURIComponent(src.replace(/^[a-z]+:\/\/[^/]*\/api\/embedly\/1\/image\/resize.*?[?&]url=([^&]*).*?$/, "$1"));
			}
			if (domain === "img.day.az" ||
				domain === "img.milli.az") {
				newsrc = src.replace(/\/(?:(?:[0-9]+x[0-9]+[a-z]?)|thumb)(\/[^/]*)$/, "$1");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nowww === "publika.az") return src.replace(/(\/storage\/[0-9]{4}\/[0-9]{2}\/[0-9]{2}\/)[0-9]+x[0-9]+[a-z]?\/([^/]*)(?:[?#].*)?$/, "$1$2");
			if (domain === "fotos.caras.uol.com.br") return src.replace(/\/media\/images\/[^/]*\//, "/media/images/original/");
			if (domain === "img.uol.com.br") {
				if (/\/_template\/+v1\/+(?:bgs\/+bg_|album\/+seta-nav-)/.test(src)) {
					return {
						url: src,
						bad: "mask"
					};
				}
			}
			if (domain_nosub === "uol.com.br") {
				newsrc = src.replace(/\/media\/+_versions\/+(.*)_(?:sq|wide)(?:sm|md|lg)\./, "/media/uploads/$1.");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "www.wmj.ru" ||
				domain === "sih.avn.com" ||
				domain_nowww === "ferra.ru" ||
				domain_nowww === "motor.ru" ||
				domain_nowww === "passion.ru") {
				return src.replace(/(:\/\/[^/]*\/)(?:thumb\/)?[0-9]+x[0-9]+\/(?:top\/)?filters:[^/]*\//, "$1");
			}
			if (domain_nosub === "centerblog.net" && string_indexof(domain, "pic.centerblog.net") >= 0) {
				return src.replace(/(:\/\/[^/]*\/)(?:[a-z]\/)?([^/]*)$/, "$1o/$2");
			}
			if (domain === "d2n4wb9orp1vta.cloudfront.net") {
				return src.replace(/;.*/, "");
			}
			if (domain === "gd.image-gmkt.com") return src.replace(/\.[^/.]*(\.[^/.]*)$/, "$1");
			if (domain_nosub === "toonpool.com") {
				return {
					url: src
						.replace(/(\/user\/[0-9]+\/)thumbs\/([^/.]+_[0-9]+)(\.[^/.]*)$/, "$1files/$29$3")
						.replace(/(\/user\/[0-9]+\/)files\/([^/.]+_[0-9]+)[0-9](\.[^/.]*)$/, "$1files/$29$3"),
					problems: {
						watermark: true
					}
				};
			}
			if (domain === "www.cartoonmovement.com") return src.replace(/\/cartoon_thumbnails\//, "/cartoons/");
			if (domain_nosub === "sndimg.com") return src.replace(/(\/[^/.]+\.[^/.]+)\.[^/]*(?:\/[^/]*)?$/, "$1");
			if (domain === "st.hzcdn.com") {
				return src
					.replace(/\/fimgs\/([0-9a-f]+)_([0-9]+)-[^/]*(\.[^/.]*)$/, "/simgs/$1_14-$2$3")
					.replace(/(\/simgs\/[0-9a-f]+)_[0-9]+(-[0-9]+[./])/, "$1_14$2")
					.replace(/\/[fs](imgs\/+pictures\/+.*-img~[0-9a-f]+)_[0-9]+(-[0-9]+)/, "/s$1_14$2");
			}
			if ((domain_nowww === "axisanimation.com" ||
				domain_nowww === "opernhaus.ch" ||
				domain_nowww === "sexo18.net") &&
				string_indexof(src, "/assets/") >= 0) {
				return src.replace(/\.[0-9]+x[0-9]+(\.[^/.]*)$/, "$1");
			}
			if (domain === "media.baselineresearch.com") return src.replace(/(\/[0-9]+_)[a-z]+(\.[^/.]*)$/, "$1full$2");
			if (domain_nowww === "mireportz.com" ||
				domain_nowww === "gameworld.gr" ||
				domain_nowww === "pakistani.pk") {
				return src.replace(/\/photos\/+thumbnail\/+[0-9]+x[0-9]+[a-z]*\//, "/photos/original/");
			}
			if (domain_nosub === "gazeta.pl" && domain.match(/bis?\.gazeta\.pl/)) {
				return src.replace(/(\/z[0-9]+)[A-Z]+(,[^/.]*)?(\.[^/.]*)$/, "$1O$2$3");
			}
			if (domain_nosub === "static6.com" && domain.match(/cdn[0-9]*(-[a-z]+)?\.production\.[^./]*\.static6\.com$/)) {
				newsrc = src.replace(/(:\/\/cdn[0-9]*(?:-[a-z]+)?\.production\.)[^./]*(\.static6\.com)\/.*?\/([^/.-]+)-media-production\/(medias\/)/, "$1$3$2/$4");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "lajt.co.uk") return src.replace(/\/media\/cache\/[0-9]+x[0-9]+\//, "/media/cache/original/");
			if (domain_nowww === "ellearabia.com" ||
				domain_nowww === "national-geographic.pl" ||
				domain_nowww === "ecranlarge.com" ||
				domain === "estaticos.marie-claire.es") {
				return src.replace(/\/+media\/+cache\/+[^/]*\/+/, "/");
			}
			if (domain === "static.t13.cl") {
				match = src.match(/\/images\/+sizes\/+[^/]*\/+([0-9]{8,})-/);
				if (match) {
					var date = new Date(match[1] * 1000);
					return src.replace(/\/images\/+sizes\/+[^/]*\/+/, "/images/original/" + date.getUTCFullYear() + "/" + zpadnum(date.getUTCMonth() + 1, 2) + "/");
				}
				return src.replace(/__[0-9]+x(?:[0-9]+)?(\.[^/.]*)$/, "$1");
			}
			if (domain_nowww === "cosmo.com.ua") return src.replace(/(\/photos_publication\/[0-9]+\/)[0-9]+_[0-9]+\//, "$1");
			if (domain_nosub === "trrsf.com" && domain.match(/p[0-9]*\.trrsf\.com/)) {
				return src.replace(/^[a-z]+:\/\/[^/]*\/image\/fget\/[^/]*\/(?:(?:[0-9]+\/){4})?(?:fit-in\/+)?[0-9]+\/[0-9]+\//, "http://");
			}
			if (domain === "c.igte.ch" ||
				domain === "img.digitalag.ro") {
				return decodeURIComponent(src.replace(/^[a-z]+:\/\/[^/]*\/.*?[?&]u=([^&]*).*/, "$1"));
			}
			if (domain_nowww === "trendus.com" ||
				domain === "trendus.igte.ch" ||
				domain_nowww === "boxerdergisi.com.tr") {
				return src.replace(/\/PhotoGallery\/+size[0-9]*\//, "/PhotoGallery/original/");
			}
			if (domain === "mediacdn.grabone.co.nz") return src.replace(/(\/asset\/[-_=a-zA-Z0-9]+)\/[a-z]+=.*/, "$1");
			if (domain_nosub === "woman.ru" && domain.match(/i[0-9]*(?:-cdn)?\.woman\.ru/)) {
				return src.replace(/_[0-9]+_[0-9]+x[0-9]+(\.[^/.]*)$/, "$1");
			}
			if (domain_nosub === "20minutos.es" && domain.match(/st-[^/.]*\.20minutos\.es/)) {
				return src.replace(/(\/[0-9a-z]+)_[0-9]+px(\.[^/.]*)$/, "$1_original$2");
			}
			if (domain_nosub === "thehunt.com" && domain.match(/cdn[0-9]*\.thehunt\.com/)) {
				return src.replace(/(\/[0-9]+\/)[^/]*\/([0-9a-f]+\.[^/.]*)$/, "$1original/$2");
			}
			if (domain === "hosted.thehun.net") return src.replace(/(\/\.content\/+[0-9a-f]{3}\/+[0-9a-f]{5,}\/+)thumb\./, "$1");
			if (domain_nosub === "devote.se" && domain.match(/static[0-9]*\.devote\.se/)) {
				return src.replace(/\/gallery\/[^/]+\//, "/gallery/big/");
			}
			if (domain_nowww === "vev.ru" &&
				string_indexof(src, "/uploads/images/") >= 0) {
				return src.replace(/(?:_[a-z]+)?(\.[^/.]*)$/, "_original$1");
			}
			if (domain === "s.glbimg.com") return src.replace(/\/[0-9]+x[0-9]+\//, "/original/");
			if (domain === "image.xahoi.com.vn" ||
				domain === "media.tinmoi.vn" ||
				domain === "media.ngoisao.vn") {
				return src.replace(/(:\/\/[^/]*\/)resize_[0-9]+(?:x[0-9]+)?\//, "$1");
			}
			if (domain_nosub === "intermoda.ru" && domain.match(/s[0-9]*\.intermoda\.ru/)) {
				return src.replace(/\/p\/(?:max|h|w)[0-9]*\//, "/p/original/");
			}
			if (domain === "static.life.ru") return src.replace(/__[0-9]+x(?:[0-9]+)?(\.[^/.]*)$/, "$1");
			if (domain === "a.ltrbxd.com") {
				return src
					.replace(/(\/avatar\/+upload\/.*\/avtr)\.[a-z]+([?#].*)?$/, "$1$2")
					.replace(/\/resized\/(.*)-(?:[0-9]+-){4}crop(?:-[0-9]+)?(\.[^/.]*)?$/, "/$1$2");
			}
			if (domain === "images.goodsmile.info") return src.replace(/\/[a-z]+(\/[0-9a-f]+\.[^/.]*)$/, "/original$1");
			if (domain === "dzt1km7tv28ex.cloudfront.net") return src.replace(/_[a-z](\.[^/.]*)$/, "_o$1");
			if (domain_nowww === "celebs-place.com") return src.replace(/(\/(?:gallery|news\/+pics)\/+[^/]*\/+[^/]*)_[a-z](\.[^/.]*)$/, "$1$2");
			if (domain === "static.vfiles.com") {
				return {
					url: src.replace(/(\/image\/media\/[0-9]+\/)[a-z]+(?:\?.*)?$/, "$1original"),
					can_head: false
				};
			}
			if (domain === "img.mediacentrum.sk") return src.replace(/\/gallery\/(?:.*?\/)?[0-9]+(?:_[a-z])?\/([0-9]+\.[^/.]*)$/, "/gallery/original/$1");
			if (domain === "images.says.com") return src.replace(/(\/[0-9]+\/)[a-z_]+_([0-9]+\.[^/.]*)$/, "$1$2");
			if (domain_nosub === "skyrock.net" && /^(?:[0-9]+\.)?wir\./.test(domain)) {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/.*[?&]im=([^&]*).*$/, "$1");
				if (newsrc !== src)
					return urljoin("https://i.skyrock.net/", decodeuri_ifneeded(newsrc), true);
			}
			if (domain === "i.skyrock.net") {
				return src
					.replace(/(\/pics\/(?:photo_)?[0-9]+)_[a-z]+((?:_[0-9]+)?\.[^/.]*)$/, "$1$2")
					.replace(/(\/pics\/[0-9]+)_[0-9]_([0-9]+_[A-Za-z0-9]+\.[^/.]*)$/, "$1_1_$2");
			}
			if (domain === "mgl.skyrock.net") return src.replace(/(\/art\/+[A-Z]+\.[0-9]+\.[0-9]+)\.0(\.[^/.]*)(?:[?#].*)?$/, "$1.1$2");
			if (domain_nowww === "xh.video") {
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+[ve]\/+([-_a-zA-Z0-9]{2,5})\/*(?:[?#].*)?$/,
					query_for_id: "https://xh.video/v/${id}",
					process: function(done, resp, cache_key) {
						done({
							url: resp.finalUrl,
							is_pagelink: true
						}, 60 * 60);
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain_nowww === "xh.video" ||
				(domain_nosub === "xhamster.com" || // 1-45?, 500
				domain_nosub === "xhamster.one" ||
				domain_nosub === "xhamster.desi" || // 1-5, 7
				//domain_nosub === "xhamsterpremium.com" ||
				domain_nosub === "openxh.com" ||
				domain_nosub === "openxh1.com" ||
				domain_nosub === "openxh2.com" ||
				domain_nosub === "xhopen.com" ||
				domain_nosub === "xhlocal.com" ||
				domain_nosub === "unlockxh.com" || // 1-5
				domain_nosub === "fullxh.com" ||
				domain_nosub === "xhtotal.com" ||
				domain_nosub === "localxh.com" || // 1-5
				// 1-4
				domain_nosub === "xhofficial.com")) {
				var query_xhamster_hashslug_by_id = function(id, cb) {
					if (/^xh/.test(id))
						return cb(id);
					api_query("xhamster_hashslug:" + id, {
						url: "https://xhamster.com/api/flash.php?/video/info&video_id=" + id,
						headers: {
							Referer: "https://www.xhamster.com/"
						},
						json: true
					}, cb, function(done, resp, cache_key) {
						if (!resp.shareUrl) {
							console_error(cache_key, "Unable to find shareUrl in", resp);
							return done(null, false);
						}
						var match = resp.shareUrl.match(/^[a-z]+:\/\/[^/]+\/+(?:videos|embed|x)\/+(?:[^/?#.]*-)?([0-9]+|xh[0-9a-zA-Z]+)(?:[?#].*)?$/);
						if (!match) {
							console_error(cache_key, "Unsupported shareUrl", resp.shareUrl);
							return done(null, false);
						}
						return done(match[1], 6 * 60 * 60);
					});
				};
				var get_xhamster_initials = function(resp) {
					var match = resp.responseText.match(/window\.initials\s*=\s*({.*});/);
					if (!match) {
						console_error("Unable to find initials from", resp);
						return null;
					}
					try {
						var json = JSON_parse(match[1]);
						return json;
					} catch (e) {
						console_error(e, resp);
					}
					return null;
				};
				var query_xhamster_video = function(id, cb) {
					var cache_key = "xhamster:" + id;
					api_cache.fetch(cache_key, cb, function(done) {
						var tested_hashslug = false;
						var do_query = function() {
							options.do_request({
								url: "https://www." + domain_nosub + "/videos/" + id,
								method: "GET",
								onload: function(resp) {
									if (resp.status !== 200) {
										if (/^[0-9]+$/.test(id) && !tested_hashslug) {
											query_xhamster_hashslug_by_id(id, function(hashslug) {
												if (!hashslug || hashslug === id) {
													console_error(cache_key, resp);
													return done(null, false);
												} else {
													tested_hashslug = true;
													id = hashslug;
													do_query();
												}
											});
											return;
										} else {
											console_error(cache_key, resp);
											return done(null, false);
										}
									}
									var initials = get_xhamster_initials(resp);
									if (!initials)
										return done(null, false);
									try {
										var videomodel = initials.videoModel;
										if (videomodel.title && videomodel.pageURL) {
											return done(videomodel, 60 * 60);
										}
									} catch (e) {
										console_error(cache_key, e);
									}
									return done(null, false);
								}
							});
						};
						do_query();
					});
				};
				var get_max_source = function(sources) {
					if (!sources)
						return null;
					var max = 0;
					var maxobj = null;
					for (var quality in sources) {
						var qualityn = parseInt(quality);
						if (!isNaN(qualityn) && qualityn > max) {
							max = qualityn;
							maxobj = sources[quality];
						}
					}
					return maxobj;
				};
				var get_xhamster_photomodel = function(galleryid, photoid, cb) {
					api_query("xhamster_photo:" + photoid, {
						url: "https://" + domain + "/photos/gallery/" + galleryid + "/" + photoid
					}, cb, function(done, resp, cache_key) {
						var initials = get_xhamster_initials(resp);
						if (!initials)
							return done(null, false);
						var gallery = initials.photosGalleryModel;
						var photos = gallery.photos.items;
						var our_photo = null;
						array_foreach(photos, function(photo) {
							api_cache.set("xhamster_photo:" + photo.id, photo, 6 * 60 * 60);
							if (photo.id == photoid) {
								our_photo = photo;
							}
						});
						if (!our_photo) {
							console_error(cache_key, "Unable to find photo from", initials, resp);
							return done(null, false);
						}
						return done(our_photo, 6 * 60 * 60);
					});
				};
				var get_obj_from_xhamster_model = function(model) {
					if (!model)
						return null;
					var baseobj = {
						extra: {
							page: model.pageURL,
							caption: model.titleLocalized || model.title
						}
					};
					var origin = "https://" + domain;
					if (domain_nosub === "xh.video") {
						origin = "https://www.xhamster.com/";
						baseobj.extra.page = baseobj.extra.page.replace(/xh\.video\//, "xhamster.com/");
					}
					var urls = [];
					if ("sources" in model) {
						var goodsources = [
							"mp4",
							"download"
						];
						for (var i = 0; i < goodsources.length; i++) {
							var our_source = goodsources[i];
							var max = get_max_source(model.sources[our_source]);
							if (max) {
								var our_obj = {
									headers: {
										Accept: "*/*",
										Origin: origin,
										Referer: baseobj.extra.page,
										"Sec-Fetch-Dest": "empty"
									},
									url: max,
									video: true
								};
								urls.push(our_obj);
								break;
							}
						}
					}
					if (model.imageURL)
						urls.push(model.imageURL); // for photos
					if (model.thumbURL)
						urls.push(model.thumbURL);
					return fillobj_urls(urls, baseobj);
				};
				newsrc = website_query({
					website_regex: {
						regex: /^[a-z]+:\/\/[^/]+\/+photos\/+gallery\/+([0-9]+)\/+([0-9]+)\/*(?:[?#].*)?$/,
						groups: ["gallery", "id"]
					},
					run: function(cb, match) {
						get_xhamster_photomodel(match.groups.gallery, match.groups.id, function(data) {
							return cb(get_obj_from_xhamster_model(data));
						});
					}
				});
				if (newsrc)
					return newsrc;
				newsrc = website_query({
					website_regex: [
						/^[a-z]+:\/\/[^/]+\/+(?:videos|embed|x)\/+(?:[^/?#.]*-)?([0-9]+|xh[0-9a-zA-Z]+)(?:[?#].*)?$/,
						/^[a-z]+:\/\/[^/]+\/+xembed\.php\?(?:.*&)?video=([0-9]+|xh[0-9a-zA-Z]+)(?:&.*)?(?:#.*)?$/,
						/^[a-z]+:\/\/[^/]+\/+movies\/+([0-9]+)\/+[^/]+\.html(?:[?#].*)?$/
					],
					run: function(cb, match) {
						query_xhamster_video(match[1], function(data) {
							return cb(get_obj_from_xhamster_model(data));
						});
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain_nosub === "xhcdn.com") {
				if (/\/xh-(?:tpl|desktop)[0-9]*\/+images\/+pixel\./.test(src)) {
					return {
						url: src,
						bad: "mask"
					};
				}
			}
			if (domain_nosub === "xhcdn.com" && /^thumb-(?:lvlt|v[0-9]*)\./.test(domain)) {
				match = src.match(/\/a\/+[^/.]{20,}\/+((?:[0-9]{3}\/+){3})/);
				if (match) {
					id = match[1].replace(/\/+/g, "").replace(/^0+/, "");
					return "https://www.xhamster.com/videos/" + id;
				}
			}
			if (domain_nosub === "xhcdn.com" && /^thumb-(?:lvlt|p[0-9]*)\./.test(domain) &&
				options.element &&
				(host_domain_nosub === "xhamster.com" || // 1-45?, 500
				host_domain_nosub === "xhamster.one" ||
				host_domain_nosub === "xhamster.desi" || // 1-5, 7
				//host_domain_nosub === "xhamsterpremium.com" ||
				host_domain_nosub === "openxh.com" ||
				host_domain_nosub === "openxh1.com" ||
				host_domain_nosub === "openxh2.com" ||
				host_domain_nosub === "xhopen.com" ||
				host_domain_nosub === "xhlocal.com" ||
				host_domain_nosub === "unlockxh.com" || // 1-5
				host_domain_nosub === "fullxh.com" ||
				host_domain_nosub === "xhtotal.com" ||
				host_domain_nosub === "localxh.com" || // 1-5
				// 1-4
				host_domain_nosub === "xhofficial.com")) {
				newsrc = common_functions["get_pagelink_el_matching"](options.element, /^[a-z]+:\/\/[^/]+\/+photos\/+gallery\/+[0-9]+\/+[0-9]+/);
				if (newsrc)
					return newsrc;
			}
			if (domain_nosub === "netease.com" && domain.match(/img[0-9]*\.cache\.netease\.com/)) {
				return src
					.replace(/[?#].*$/, "")
					.replace(/\/(?:[a-z]|[0-9]+x[0-9]+)_([^/]*)$/, "/$1")
					.replace(/_[0-9]+(\.[^/.]*)$/, "$1")
					.replace(/\.[0-9]+x\.[0-9]+(\.[^/.]*)$/, "$1");
			}
			if (domain === "img.lengding.cn") return src.replace(/.*?\/getImage\.php.*?[?&]url=(.*)$/, "$1");
			if (domain === "cdn.sabay.com") return src.replace(/:\/\/[^/]+\/cdn\/([a-z]+\.[a-z]+\.[a-z]+\/)/, "://$1");
			if (domain === "media.sabay.com") return src.replace(/_[a-z]+(\.[^/.]*)$/, "$1");
			if (domain === "s.olj.me" ||
				(domain === "static.addiyar.com" && string_indexof(src, "/storage/attachments/") >= 0) ||
				(domain_nosub === "annahar.com" && domain.match(/^static[0-9]*\.annahar/) && string_indexof(src, "/storage/attachments/") >= 0)) {
				return src.replace(/(\/storage\/+attachments\/+[0-9]+\/+[^/]*_[0-9]+)(?:_(?:large|thumbnail))?(\.[^/.]*)(?:\/+r\/+[0-9]+)?(?:[?#].*)?$/, "$1$2");
			}
			if (domain === "binaryapi.ap.org") {
				return {
					url: src,
					can_head: false
				};
			}
			if (domain_nosub === "ekladata.com") return src.replace(/@[0-9]+x(?:[0-9]+)?(\.[^/.]*)$/, "$1");
			if (domain === "img.geinoueroch.com" ||
				domain === "image.hoopchina.com" ||
				(domain === "san.imatin.net" && string_indexof(src, "/images/") >= 0) ||
				(domain_nowww === "kandamori.com" && src.match(/\/hamblog[0-9]+\/+[0-9]+/)) ||
				domain === "img.momon-ga.com") {
				return src.replace(/-s(\.[^/.]*)$/, "$1");
			}
			if (domain === "note.taable.com" &&
				string_indexof(src, "/photo/") >= 0) {
				return decodeURIComponent(src.replace(/:\/\/[^/]*\/photo\//, "://"));
			}
			if (domain_nosub === "adult-gazou.me" && domain.match(/img-[^.]*\.adult-gazou\.me/)) {
				return src.replace(/\/[a-z](\/[0-9]*\.[^/.]*)$/, "/l$1");
			}
			if (domain_nosub === "fukugan.com" &&
				string_indexof(src, "/rssimg/") >= 0) {
				return decodeURIComponent(decodeURIComponent(src.replace(/.*\/(https?[%:].*)/, "$1"))).replace(/\.#.*/, "");
			}
			if ((domain_nosub === "lostbird.vn" ||
				domain_nosub === "nginx.page") &&
				domain.match(/img[0-9]*\./)) {
				return src.replace(/(:\/\/[^/]*\/)[-0-9]+x[-0-9]+\//, "$1");
			}
			if (domain === "img.biggo.com.tw") {
				return src.replace(/^[a-z]+:\/\/[^/]*\/[^/]*\//, "");
			}
			if (((domain_nosub === "book.com.tw" && domain.match(/im[0-9]*\.book\.com\.tw/)) ||
				domain === "www.books.com.tw" ||
				domain === "buy.line-scdn.net") &&
				string_indexof(src, "/getImage") >= 0) {
				return decodeURIComponent(src.replace(/.*\/getImage.*?[?&]i=([^&]*).*?$/, "$1"));
			}
			if (domain === "img.feebee.com.tw") {
				return src.replace(/^[a-z]+:\/\/[^/]*\/ip\/[0-9]+\/[^/]+=\//, "");
			}
			if (domain === "www.consolefun.fr" ||
				domain_nowww === "nookthem.com" ||
				domain_nowww === "nude-gals.com") {
				return src.replace(/\/thumbs\/+th_/, "/");
			}
			if (domain === "ex.f3img.gq") {
				return decodeURIComponent(src.replace(/.*?\/api\/image.*?[?&]url=([^&]*).*?$/, "$1"));
			}
			if (domain === "images.everyeye.it") return src.replace(/(-v[0-9]+-[0-9]+)-[0-9]+(\.[&/.]*)/, "$1$2");
			if (domain_nowww === "bobx.com") {
				var get_obj = function(url) {
					var normurl = url
						.replace(/\/thumbnail\/+(.*?)(?:-preview)?(-[0-9]+)(?:\.t)?(\.[^/.]*)$/, "/$1-$2$3")
						.replace(/--([0-9]+\.[^/.]*)$/, "-$1");
					var obj = {
						url: url,
						headers: {
							Referer: normurl.replace(/\/([^/]+)\.[^/.]*$/, "/$1.html")
						},
						bad_if: [{
								headers: {
									"content-length": "281567",
									"last-modified": function(value) {
										if (/^Tue, 19 Nov 2019/i.test(value)) {
											return true;
										}
										return false;
									}
								}
							}]
					};
					if (url.match(/\/[^/]+[^-]-[0-9]+\.[^/.]+(?:[?#].*)?$/)) {
						obj.headers.Referer = normurl.replace(/\/([^/]+)\.[^/.]*$/, "/large-$1.html");
						obj.is_original = true;
					}
					obj.extra = { page: obj.headers.Referer };
					return obj;
				};
				newsrc = src.replace(/\/thumbnail\/+(.*?)(?:-preview)?(-[0-9]+)(?:\.t)?(\.[^/.]*)$/, "/$1-$2$3");
				if (newsrc !== src)
					return get_obj(newsrc);
				newsrc = src.replace(/--([0-9]+\.[^/.]*)$/, "-$1");
				if (newsrc !== src)
					return get_obj(newsrc);
				return get_obj(src);
			}
			if ((domain === "www.altcine.com" && string_indexof(src, "/photo/") >= 0) ||
				domain === "gallery-cdn.tiscali.it" ||
				(domain === "img.amur.info" && string_indexof(src, "/res/") >= 0) ||
				(domain === "thumbs.vaultsex.com" && string_indexof(src, "/content/") >= 0) ||
				(domain_nowww === "dspdaily.com" && string_indexof(src, "/data/") >= 0)) {
				return src.replace(/\/[0-9]+x[0-9]+\/([^/]*)$/, "/$1");
			}
			if (domain_nowww === "spacetelescope.org" ||
				domain === "cdn.spacetelescope.org" ||
				domain_nowww === "esahubble.org") {
				return src.replace(/(\/archives\/+images\/+)[a-z]+(?:[0-9]+x)?(\/+[^/.]*\.[^/.]*)(?:[?#].*)?$/, "$1large$2");
			}
			if (domain === "static.qobuz.com") {
				return src
					.replace(/_[0-9]+(\.[^/.]*)$/, "_org$1")
					.replace(/(\/images\/+artists\/+covers\/+)(?:small|medium)\/+/, "$1large/");
			}
			if (domain_nowww === "sarajevo.travel" &&
				string_indexof(src, "/assets/photos/") >= 0) {
				return src.replace(/\/[a-z]+\/([^/]*)$/, "/original/$1");
			}
			if (domain === "avatars.mds.yandex.net" ||
				domain === "avatars.yandex.net" ||
				domain === "avatars.dzeninfra.ru") {
				obj = {
					url: src.replace(/\/(?:[a-z]+_(?:[a-z]+_)?|[a-zA-Z]|pjpg)?[0-9]+(?:x[0-9]+)?(?:[A-Za-z_0-9]+)([?&].*)?$/, "/orig$1")
				};
				match = src.match(/\/get-[^/]+\/+([0-9]+)\/+[^/]+\/+[^/]+(?:[?#].*)?$/);
				if (match)
					obj.filename = match[1];
				newsrc = src.replace(/(:\/\/[^/]+\/+i\?)(?:.*&)?id=([0-9a-f]{10,}[^&#]+)(?:[&#].*)?$/, "$1id=$2&n=13");
				if (newsrc !== src)
					return newsrc;
				return obj;
			}
			if (domain_nowww === "t2online.com") return src.replace(/^[a-z]+:\/\/[^/]*\/unsafe\//, "http://");
			if (domain_nowww === "filmnegah.com") {
				return decodeURIComponent(src.replace(/(:\/\/[^/]*)\/Image\/(?:Resize|Thumbnail).*?[?&](?:url|path)=~([^&]*).*?$/, "$1$2"));
			}
			if (domain_nowww === "niagara.sk" && string_indexof(src, "/images/") >= 0) {
				return src.replace(/\/tmb-[0-9]+(?:-[0-9]+)\//, "/big/");
			}
			if (domain_nowww === "cdn-cinenode.com") return src.replace(/(\/[0-9]+\/)([^/]*)-[0-9]+-[0-9]+(\.[^/.]*)$/, "$1full/$2$3");
			if (domain_nosub === "canalblog.com" && domain.match(/\.storage\.canalblog\.com$/)) {
				return src
					.replace(/\.[^/]*(\.[^/.]*)$/, "$1")
					.replace(/(\/[0-9]+)(?:_[a-z])?(\.[^/.]*)$/, "$1_o$2");
			}
			if (domain_nowww === "film-like.com") return src.replace(/\/thumb\//, "/full/");
			if (domain_nowww === "24smi.org" ||
				domain_nowww === "24celebs.com") {
				return src
					.replace(/\/img\/+[0-9]+_[0-9]+\//, "/img/999999999_999999999/")
					.replace(/\/public\/+media\/+(?:resize\/+)?[-0-9]+x[-0-9]+\//, "/public/media/");
			}
			if (domain === "cdn.metrotvnews.com" ||
				domain === "cdn.medcom.id") {
				return src.replace(/\?.*/, "?w=99999999999");
			}
			if (domain_nowww === "znqnet.com" && string_indexof(src, "/fileupload/") >= 0) {
				return src.replace(/\/fileupload\/thumb\//, "/fileupload/image/");
			}
			if (domain_nosub === "rpp-noticias.io" && domain.match(/[a-z]\.rpp-noticias\.io/)) {
				return src.replace(/:\/\/e\.rpp-noticias\.io\/[a-z]+\//, "://f.rpp-noticias.io/");
			}
			if (domain_nowww === "digi-film.ro") return src.replace(/\/onedb\/picture\([^/]*\//, "/onedb/picture/");
			if (domain === "s.iw.ro") {
				newsrc = src.replace(/\.thumb(\.[^/.]+)([?#].*)?$/, "$1$2");
				if (newsrc !== src)
					return newsrc;
				match = src.match(/\/gateway\/+g\/+(([^/.?]{32}\/+){1,}[^/.]*\.[^/.?#]*)/);
				if (match) {
					var splittedhex = match[1].replace(/\/+/g, "/").replace(/\..*/, "").split("/");
					var endstr = "";
					for (var i_2 = 0; i_2 < splittedhex.length; i_2++) {
						endstr += base64_decode(splittedhex[i_2]);
					}
					newsrc = endstr.replace(/^(?:.*&)?fileSource=([^&]*).*?$/, "$1");
					if (newsrc !== src)
						return decodeURIComponent(newsrc);
				}
			}
			if (domain_nosub === "jiemian.com" && domain.match(/img[0-9]*\.jiemian\.com/)) {
				return src.replace(/\/([0-9]+)_[a-zA-Z0-9]+x[a-zA-Z0-9]+(\.[^/.]*)$/, "/$1$2");
			}
			if (domain === "cdn.highdefdigest.com") return src.replace(/(\/uploads\/[0-9]+\/[0-9]+\/[0-9]+\/)[0-9]+\/([^/]*)$/, "$1$2");
			if (domain_nowww === "ojosdecafe.com") return src.replace(/\/thumbs\/[0-9]+x[0-9]+_/, "/");
			if (domain === "img.gestion.pe" ||
				domain_nowww === "multimedios.com" ||
				domain === "imagenes.heraldo.es" ||
				domain_nowww === "lavanguardia.com") {
				return src.replace(/\/files\/+[^/]+\/+uploads\//, "/uploads/");
			}
			if (domain === "imagenes.cronica.com.mx" ||
				domain === "imghandler.cronica.com.mx") {
				return src
					.replace(/:\/\/[^/]+\/+.*?\/(uploads\/+[0-9]{4}\/+(?:[0-9]{2}\/+){2}[0-9a-f]{5,}\.[a-z]+)(?:[?#].*)?/, "://imagenes.cronica.com.mx/$1")
					.replace(/(\/uploads\/+[0-9]{4}\/+(?:[0-9]{2}\/+){2}[0-9a-f]{5,}\.)[^/?#]+\.([a-z]+)(?:[?#].*)?$/, "$1$2");
			}
			if (domain === "thumb.guucdn.net") return src.replace(/:\/\/[^/]*\/[0-9]+x[0-9]+\//, "://");
			if ((domain_nowww === "game4v.com" && string_indexof(src, "/thumb/thumb.php?") >= 0) ||
				domain === "static.pinwallpapers.com") {
				newsrc = src.replace(/.*?\/thumb\.php.*?[?&]src=([^&]*).*?$/, "$1");
				if (newsrc !== src)
					return decodeuri_ifneeded(newsrc);
			}
			if (domain_nowww === "newpal.ps" ||
				domain_nosub === "iravunk.com" ||
				(domain_nowww === "mrcapetown.co.za" && src.match(/\/wp-content\/.*\/functions\/+thumb\.php/)) ||
				domain_nowww === "vtimes.com.au" ||
				domain_nowww === "pardisgame.net") {
				newsrc = decodeURIComponent(src.replace(/.*?\/thumb\.php.*?[?&]src=([^&]*).*?$/, "$1"));
				if (newsrc !== src) {
					if (newsrc.match(/^[a-z]+:\/\//))
						return newsrc;
					else
						return urljoin(src, ("/" + newsrc).replace(/^\/\//, "/"), true);
				}
			}
			if (domain === "static.santruyen.com") return src.replace(/(\/[0-9]+)_[a-z]+(\.[^/.]*)$/, "$1$2");
			if (amazon_container === "boligsurf-production" &&
				string_indexof(src, "/assets/images/") >= 0) {
				return src.replace(/\/fixed_[0-9]+_[0-9]+\//, "/original/");
			}
			if (domain_nowww === "sonara.net") {
				return decodeURIComponent(src.replace(/:\/\/[^/]*\/cro\.php.*?[?&]image=([^&]*).*?$/, "://images.sonara.net$1"));
			}
			if (domain === "d2u7zfhzkfu65k.cloudfront.net" &&
				string_indexof(src, "/resize/wp-content/") >= 0) {
				return src.replace(/:\/\/[^/]*\/resize\//, "://d3kszy5ca3yqvh.cloudfront.net/");
			}
			if (domain === "imgbp.hotp.jp") return src.replace(/_[0-9]+-[0-9]+(\.[^/.]*)$/, "$1");
			if (domain === "review.zafcdn.com") return src.replace(/(\/upload\/+zaful\/+review\/+[0-9]{8}\/+)(?:thumb\/+)?([0-9A-F]{10,})_(?:[0-9]+-[0-9]+|thumb)(\.[^/.]*)(?:[?#].*)?$/, "$1$2$3");
			if (amazon_container === "ro69-bucket") {
				return src.replace(/(\/image\/[0-9]+\/)[^/]*\/resize_image/, "$1default/resize_image");
			}
			if (domain === "aimg-pictpix.akamaized.net") return src.replace(/(:\/\/[^/]*\/)ts[0-9]+x[0-9]+\/img\//, "$1img/");
			if (amazon_container === "lattepic") {
				return src.replace(/(\/[a-z]+_)[a-z]+(\.[^/.?]*)$/, "$1org$2");
			}
			if (domain === "coconala.akamaized.net") return src.replace(/\/service_images\/[0-9]+x[0-9]+\//, "/service_images/original/");
			if (domain === "dplhqivlpbfks.cloudfront.net") return src.replace(/.*(\/[0-9a-f]+-[0-9]+\.[^/.]*)$/, "https://coconala.akamaized.net/coconala-public-files/service_images/original$1");
			if (domain_nowww === "ysbnow.com") return src.replace(/(:\/\/[^/]*\/dam).*?[?&](media-id=[^&]*).*?$/, "$1?$2");
			if (domain_nowww === "quizz.biz") return src.replace(/(\/uploads\/+quizz\/+[0-9]+\/+)[a-z]+(\/+[0-9]+)(?:_[0-9]+)?(\.[^/.]*)(?:[?#].*)?$/, "$1orig$2$3");
			if (domain_nosub === "flipagramcdn.com" && domain.match(/c[0-9]*\.flipagramcdn\.com/)) {
				return src.replace(/-[a-z]+(?:\?.*)?$/, "");
			}
			if (domain === "images-cdn.9gag.com" ||
				domain === "img-9gag-fun.9cache.com" ||
				domain === "d24w6bsrhbeh9d.cloudfront.net" ||
				domain === "miscmedia-9gag-fun.9cache.com") {
				return src
					.replace(/\/thumbnail-facebook\/([^/]*)_[0-9]+x[0-9]+(\.[^/.]*)$/, "/thumbnail-facebook/$1_n$2")
					.replace(/_460swp(\.[^/.]*)$/, "_700bwp$1")
					.replace(/_460s(_v1)?(\.[^/.]*)$/, "_700b$1$2");
			}
			if (domain_nowww === "samironsheadshots.com" &&
				string_indexof(src, "/images/") >= 0) {
				return src.replace(/\/small\/([^/]*)$/, "/large/$1");
			}
			if (domain === "cps-static.rovicorp.com") {
				return src
					.replace(/\/_derived_[^/]*(\/[^/]*)$/, "$1")
					.replace(/\/JPG_[0-9]+\//, "/JPG_SRC/");
			}
			if (domain === "rovimusic.rovicorp.com") {
				if (/[?&]c=[^&]{10,}/.test(src)) {
					var queries = get_queries(src);
					newsrc = src.replace(/\?.*/, "?c=" + queries.c + "&f=0");
					if (newsrc !== src)
						return newsrc;
				}
			}
			if (domain_nosub === "netflixmovies.com" && domain.match(/i[0-9]*\.netflixmovies\.com/)) {
				return src.replace(/\/image\/upload\/[wh]_[0-9]+\//, "/image/upload/");
			}
			if (domain_nowww === "shakespearesglobe.com") return src.replace(/(\/images\/[0-9]+)\/[a-z]+(?:\?.*)?$/, "$1");
			if (domain_nosub === "rsc.org.uk" && domain.match(/cdn[0-9]*\.rsc\.org\.uk/)) {
				return src.replace(/\.tmb-img-[0-9]*\./, ".");
			}
			if (domain === "images.fashionmodeldirectory.com") return src.replace(/-(?:square(?:small|medium)|single|fit|modelprofile[A-Za-z]+|profile|alternative)(\.[^/.]*)$/, "-fullsize$1");
			if (domain === "cdn.public.hegre.com" ||
				domain === "p.hegre.com") {
				newsrc = src.replace(/-image-[0-9]+x(?:_2x)?(\.[^/.]*)(?:[?#].*)?$/, "-image-fullsize$1");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/(\/films\/+[^/]+\/+[0-9]+\/+[^/]+)-[0-9]*x[0-9]*\./, "$1.");
				if (newsrc !== src)
					return newsrc;
				var sizes = [
					"2160p",
					"1080p",
					"720p",
					"480p"
				];
				match = src.match(/\/films\/+[^/]+\/+[^/]+-([0-9]+p)\.mp4/);
				if (match && array_indexof(sizes, match[1]) > 0) {
					sizes = sizes.slice(0, array_indexof(sizes, match[1]));
					var urls = [];
					for (var i_3 = 0; i_3 < sizes.length; i_3++) {
						urls.push({
							url: src.replace(/(\/films\/+[^/]+\/+[^/]+-)[0-9]+p\./, "$1" + sizes[i_3] + "."),
							video: true
						});
					}
					return urls;
				}
			}
			if (domain === "storage.hegre.com") return src.replace(/(\/img\/+gallery-[0-9]+-)thumb(-[0-9]+\.[^/.]+)(?:[?#].*)?$/, "$1image$2");
			if ((domain_nowww === "skinnygossip.com" ||
				domain_nowww === "alternatehistory.com" ||
				domain_nowww === "gtplanet.net" ||
				domain_nowww === "burbuja.info" ||
				domain_nowww === "kadinlarkulubu.com" ||
				domain_nowww === "arrse.co.uk") &&
				string_indexof(src, "/proxy.php?") >= 0) {
				return decodeURIComponent(src.replace(/.*?\/proxy\.php.*?[?&]image=([^&]*).*?$/, "$1"));
			}
			if (domain === "usa-grlk5lagedl.stackpathdns.com") return src.replace(/(\/images\/[^/]*)\?.*$/, "$1?fm=pjpg");
			if (domain === "static.sify.com") return src.replace(/(\/cms\/image\/[^/]*)_[a-z]+(\.[^/.]*)$/, "$1$2");
			if (domain_nowww === "wikifeet.com") return src.replace(/(\/profiles\/+[0-9]+)(\.[^/.]+)(?:[?#].*)?$/, "$1_fs$2");
			if (domain === "thumbs.wikifeet.com") return src.replace(/:\/\/[^/]*\//, "://pics.wikifeet.com/");
			if (domain === "my.wikifeet.com") {
				obj = {
					url: src.replace(/\/(photos|avatars)\/+t([0-9]+\.[^/.]*)(?:[?#].*)?$/, "/$1/$2"),
					bad_if: [{
							headers: {
								"content-length": "169698",
								"last-modified": "Thu, 01 Aug 2019 12:02:01 GMT"
							}
						}]
				};
				match = obj.url.match(/:\/\/[^/]+\/+avatars\/+([0-9]+)\./);
				if (match) {
					obj.extra = { page: "https://my.wikifeet.com/models/" + match[1] };
				}
				return obj;
			}
			if (domain === "static.spotboye.com") return src.replace(/(_[0-9a-f]+)(?:_[a-z]+)?(\.[^/.]*)$/, "$1_original$2");
			if (domain === "img.news.goo.ne.jp") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/cpimg\/([^/]*\.[^/]*)/, "http://$1");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "img.news.goo.ne.jp" ||
				domain === "img.topics.smt.news.goo.ne.jp") {
				return src
					.replace(/(\/picture\/+[a-z]+\/+m[^/?#]+)(?:[?#].*)?$/, "$1")
					.replace(/\/picture\/+([a-z]+)\/+s((?:_\1-[0-9]{8}wow[0-9]+|_\1-[0-9]{10,}|_?[0-9]{10,})\.[^/.]*)(?:[?#].*)?$/, "/picture/$1/m$2");
			}
			if (domain_nowww === "redditstatic.com") {
				if (/^[a-z]+:\/\/[^/]+\/+(?:sprite|sidebar|icon)[-_][^/]+\./.test(src))
					return {
						url: src,
						bad: "mask"
					};
				return src.replace(/(\/gold\/+awards\/+icon\/+[^/]+)_[1-4]?[0-9]{2}\./, "$1_512.");
			}
			if (domain === "preview.redd.it") return src.replace(/:\/\/preview\.redd\.it\/(award_images\/+t[0-9]*_[0-9a-z]+\/+)?(?:[-0-9a-z]+-)?([^/.]*\.[^/.?]*)\?.*$/, "://i.redd.it/$1$2");
			if (domain === "i.redd.it" && src.match(/^[a-z]+:\/\/[^/]*\/[0-9a-z]+\.[^-/._?#]*$/)) {
				return {
					url: src,
					headers: {
						Accept: '*/*',
						Referer: null
					},
					is_original: true
				};
			}
			if (domain === "i.reddituploads.com") {
				newsrc = src.replace(/(:\/\/[^/]*\/[0-9a-f]+)\?.*$/, "$1");
				if (newsrc !== src)
					return newsrc;
			}
			if (host_domain_nosub === "reddit.com" && options.element) {
				if (src === "" && options.element.tagName === "A" && options.element.classList.contains("image")) {
					return {
						url: origsrc,
						bad: "mask"
					};
				}
			}
			if (domain_nosub === "redditmedia.com" && options.element) {
				if (options.element.tagName === "DIV") {
					if (options.element.classList.contains("arrow")) {
						return {
							url: origsrc,
							bad: "mask"
						};
					}
				}
			}
			if (domain === "v.redd.it") {
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+([a-z0-9]+)(?:[?#].*)?$/,
					query_for_id: {
						url: "https://v.redd.it/${id}",
						method: "HEAD"
					},
					process: function(done, resp, cache_key) {
						return done({
							url: resp.finalUrl,
							is_pagelink: true
						}, 6 * 60 * 60);
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain_nosub === "reddit.com" || domain_nowww === "redd.it") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]+\/+media\?(?:.*&)?url=([^&]+)(?:[&#].*)?$/, "$1");
				if (newsrc !== src)
					return decodeuri_ifneeded(newsrc);
				var request_reddit_api = function(id, cb) {
					api_query("reddit_api:" + id, {
						url: "https://www.reddit.com/api/info.json?id=" + id,
						imu_mode: "xhr",
						headers: {
							"Origin": "https://old.reddit.com",
							"Referer": "https://old.reddit.com/"
						},
						json: true
					}, cb, function(done, resp, cache_key) {
						console_log(resp);
						var item = resp.data.children[0].data;
						if (_nir_debug_) {
							console_log(id, item);
						}
						done(item, 60 * 60);
					});
				};
				var request_reddit = function(id, cb) {
					request_reddit_api(id, function(item) {
						if (!item) {
							return cb(null);
						}
						if (item.crosspost_parent) {
							return request_reddit(item.crosspost_parent, cb);
						}
						var urls = [];
						var obj = {
							extra: {}
						};
						if (item.permalink) {
							obj.extra.page = urljoin("https://www.reddit.com/", item.permalink, true);
						}
						if (item.title) {
							obj.extra.caption = item.title;
						}
						var is_selfpost = item.domain && /^self\./.test(item.domain) && item.url && /^[a-z]+:\/\/[^/]*reddit\.com\/r\//.test(item.url);
						if (!is_selfpost && item.preview && item.preview.images) {
							var preview_image;
							if (item.preview.images[0].variants.gif)
								preview_image = item.preview.images[0].variants.gif.source.url;
							else
								preview_image = item.preview.images[0].source.url;
							preview_image = preview_image.replace(/&amp;/g, "&");
							urls.push(preview_image);
						}
						if (item.secure_media && item.secure_media.reddit_video) {
							var rv = item.secure_media.reddit_video;
							if (rv.fallback_url) {
								urls.unshift({
									url: rv.fallback_url,
									video: true
								});
							}
							if (rv.hls_url) {
								urls.unshift({
									url: rv.hls_url,
									video: "hls"
								});
							}
							if (rv.dash_url) {
								urls.unshift({
									url: rv.dash_url,
									video: "dash"
								});
							}
						}
						if (item.gallery_data && item.gallery_data.items) {
							var first_url = null;
							var album_links = [];
							array_foreach(item.gallery_data.items, function(item) {
								var url = "https://i.redd.it/" + item.media_id + ".jpg";
								if (!first_url)
									first_url = url;
								album_links.push({
									url: url,
									is_current: first_url === url
								});
							});
							if (first_url) {
								urls.unshift({
									url: first_url,
									album_info: {
										type: "links",
										links: album_links
									}
								});
							}
						}
						if (!/^[a-z]+:\/\/(?:[^/]*\.)?reddit\.com\/+gallery\//.test(item.url) &&
							looks_like_valid_link(item.url, item.url)) {
							urls.unshift(item.url);
						}
						return cb(fillobj_urls(urls, obj));
					});
				};
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+(?:(?:(?:r|u(?:ser)?)\/+[^/]+\/+comments|gallery)\/+)?([a-z0-9]+)(?:\/+.*)?(?:[?#].*)?$/,
					run: function(cb, match) {
						var id = match[1];
						request_reddit("t3_" + id, function(data) {
							cb(data);
						});
					}
				});
				if (newsrc)
					return newsrc;
			}
			if ((domain_nosub === "redditmedia.com" ||
				domain_nosub === "redd.it" ||
				(domain_nosub === "reddit.com" && /:\/\/[^/]+\/+[ru]\/+/.test(src)) ||
				string_indexof(origsrc, "blob:") === 0) &&
				host_domain_nosub === "reddit.com" && options.element) {
				var get_reddit_link = function(id) {
					id = id.replace(/^t[0-9]+_/, "");
					return {
						url: "https://redd.it/" + id,
						is_pagelink: true
					};
				};
				var current = options.element;
				do {
					if (current.tagName === "DIV") {
						var testid = current.getAttribute("data-testid") || current.getAttribute("data-fullname") || current.getAttribute("id");
						if (testid && testid === "post-container") {
							testid = current.getAttribute("id");
						}
						if (testid) {
							match = testid.match(/^t3_([a-z0-9]{2,8})$/);
							if (match) {
								return get_reddit_link(match[1]);
							}
						}
					}
				} while (current = current.parentElement);
			}
			if ((domain_nosub === "gstatic.com" ||
				domain === "") &&
				host_domain_nosub.match(/^google\./) && options.element) {
				newsrc = (function() {
					var get_imagesearch_url = function(current) {
						do {
							if (current.tagName !== "A")
								continue;
							if (!current.href.match(/\/imgres\?/))
								continue;
							var newsrc = current.href.replace(/.*?\/imgres.*?[?&]imgurl=([^&]*).*?$/, "$1");
							if (newsrc !== src)
								return decodeURIComponent(newsrc);
						} while (current = current.parentElement);
						return null;
					};
					var newsrc = get_imagesearch_url(options.element);
					if (newsrc)
						return newsrc;
					var tbnid = null;
					current = options.element;
					if (current.tagName === "IMG") {
						while ((current = current.parentElement)) {
							if (current.tagName !== "DIV")
								continue;
							var our_tbnid = current.getAttribute("data-tbnid");
							if (!our_tbnid)
								continue;
							tbnid = our_tbnid;
							var regex = new RegExp("\\[[0-9]+\\s*,\\s*\"" + tbnid + "\"\\s*,\\s*\\[[^\\]]*\\]\\s*,\\s*\\[(\"[^\"]+\")\\s*,");
							var match = document.documentElement.innerHTML.match(regex); // TODO: optimize
							if (match) {
								return JSON_parse(match[1]);
							} else {
								break;
							}
						}
					}
					if (tbnid && options.cb) {
						try {
							var event = new MouseEvent("mousedown", {
								bubbles: true,
								cancelable: true,
								button: 2,
								buttons: 2,
								clientX: 1,
								clientY: 1
							});
							options.element.dispatchEvent(event);
							setTimeout(function() {
								options.cb(get_imagesearch_url(options.element));
							}, 500);
							return {
								waiting: true
							};
						} catch (e) {
							console_error(e);
						}
					}
					current = options.element;
					while ((current = current.parentElement)) {
						if (current.tagName !== "A")
							continue;
						if (!current.href.match(/\/search\?/))
							continue;
						var parent = current.parentElement;
						if (parent.tagName !== "DIV")
							continue;
						var notranslate = parent.getElementsByClassName("notranslate");
						if (!notranslate.length) {
							parent = parent.parentElement;
							if (!parent || parent.tagName !== "DIV")
								break;
							notranslate = parent.getElementsByClassName("notranslate");
							if (!notranslate.length)
								continue;
						}
						for (var i = 0; i < notranslate.length; i++) {
							var el = notranslate[i];
							if (!el.innerHTML.match(/^ *{/))
								continue;
							var json = JSON_parse(el.innerHTML);
							if (json.ou.match(/^[a-z]+:/))
								return json.ou;
							break;
						}
					}
				})();
				if (newsrc !== void 0)
					return newsrc;
			}
			if (domain_nosub === "fbcdn.net") {
				if (/^[a-z]+:\/\/[^/]+\/+rsrc\.php\//.test(src)) {
					return {
						url: src,
						bad: "mask"
					};
				}
			}
			if (domain_nosub === "fbcdn.net" && host_domain_nosub === "facebook.com" && options.element) {
				var element = options.element;
				if (element.tagName === "IMG") {
					while ((element = element.parentElement)) {
						if (element.tagName === "A") {
							var ploi = element.getAttribute("data-ploi");
							if (ploi && ploi.match(/^https?:\/\/[^/]*fbcdn\.net\//) && ploi !== src) {
								return ploi;
							} else if (/^[a-z]+:\/\/[^/]+\.?facebook\.com\//.test(element.href)) {
								return {
									url: element.href,
									is_pagelink: true
								};
							}
						}
					}
				}
			}
			if (domain === "thumbnail.named.com" ||
				domain === "thumb.named.com") {
				return [
					src.replace(/:\/\/[^/]*\/.*?(\/+file\/+photo\/+.*)/, "://thumb.named.com/normal/resize/origin$1")
				];
			}
			if (host_domain_nosub === "bing.com" &&
				(domain === "" || domain_nosub === "bing.com") && options.element) {
				var current = options.element;
				while ((current = current.parentElement)) {
					if (current.tagName === "DIV" && current.id === "mainImageWindow" && current.hasAttribute("data-m")) {
						var parsed_2 = JSON_parse(current.getAttribute("data-m"));
						return parsed_2.murl;
					}
					if (current.tagName !== "A")
						continue;
					if (!current.href.match(/\/images\/search\?.*mediaurl=/))
						continue;
					newsrc = current.href.replace(/.*?\/search.*?[?&]mediaurl=([^&]*).*?$/, "$1");
					if (newsrc !== current.href && newsrc !== src) {
						newsrc = decodeuri_ifneeded(newsrc);
						return newsrc;
					}
				}
			}
			if (domain_nosub === "deviantart.net" &&
				(domain.match(/^pre[0-9]*\.deviantart\.net/) ||
					domain.match(/^img[0-9]*\.deviantart\.net/)) &&
				src.match(/\/[a-z0-9]\/[0-9]+\/[0-9a-z]+\/[0-9a-z]+\/[0-9a-z]+\/[^/]*-[0-9a-z]+\.[^/.]*$/) &&
				options && options.do_request && options.cb) {
				newsrc = (function() {
					var id = src.replace(/.*-([0-9a-z]+)\.[^/.]*$/, "$1");
					return common_functions["deviantart_fullimage"](options, api_cache, src, id, options.cb);
				})();
				return {
					"waiting": true
				};
			}
			if (domain_nowww === "huangdi5000.com") {
				return decodeURIComponent(src.replace(/^[a-z]+:\/\/[^/]*\/p\.php.*?[?&]p=(.*)$/, "$1"));
			}
			if (domain_nowww === "popcornfor2.com" && string_indexof(src, "/upload/") >= 0) {
				return src.replace(/\/news-[a-z]+-([0-9]+\.[^/.]*)(?:[?#].*)?$/, "/news-full-$1");
			}
			if (domain === "img.daily.co.kr") {
				return src.replace("/content_watermark/", "/content/");
			}
			if (domain === "file.gamedonga.co.kr") return src.replace(/(\/files\/[0-9]+\/[0-9]+\/[0-9]+\/)[a-z]\/([^/]*)$/, "$1$2");
			if (domain === "jrimage.dongascience.com") return src.replace(/(\/[0-9]+)_thumb(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain === "cloud.tcusercontent.net") return src.replace(/(-[0-9]+-[0-9a-f]+)-[0-9]+(\.[^/.]*)$/, "$1$2");
			if (domain === "image.entertainment-topics.jp" ||
				domain === "image.code-file.jp" ||
				domain === "image.make-book.jp") {
				return src.replace(/(:\/\/[^/]*\/)(item\/image\/|article\/)[a-z]+(\/[^/]*)$/, "$1$2original$3");
			}
			if ((domain_nosub === "styapokupayu.ru" &&
				string_indexof(src, "/images/") >= 0) ||
				(domain_nosub === "yapokupayu.ru" &&
					string_indexof(src, "/system/images/") >= 0)) {
				return src.replace(/(\/[0-9]+)_[a-z]+(\.[^/.]*)$/, "$1_original$2");
			}
			if (domain_nowww === "thai.ac") {
				return decodeURIComponent(src.replace(/^[a-z]+:\/\/[^/]*\/news\/tn\/.*?[?&]fn=([^&]*).*?/, "$1"));
			}
			if (domain_nosub === "styleshare.kr" &&
				domain.match(/usercontents(?:-[a-z])?\.styleshare\.kr/)) {
				return src.replace(/(\/images\/[0-9]+\/)[-0-9]+x[-0-9]+(?:\?.*)?$/, "$1original");
			}
			if (domain === "images.vingle.net") return src.replace(/(:\/\/[^/]*\/upload\/)t_[^/]*\/([^/]*)$/, "$1$2");
			if (domain === "media.vingle.net") {
				newsrc = src.replace(/(\/images\/+(?:ca|us))_s\//, "$1_l/");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/(\/images\/+(?:ca|us))_l\//, "$1_xl/");
				if (newsrc !== src)
					return newsrc;
				return {
					url: src,
					headers: {
						Referer: ""
					}
				};
			}
			if (domain_nowww === "anewsa.com") return src.replace(/(_images\/[0-9]+\/[0-9]+\/[0-9]+\/)mark(\/[^/]*)$/, "$1original$2");
			if (domain === "img.newspim.com") {
				return src
					.replace(/(\/[0-9]+)_(?:t[a-z0-9]|w)(\.[^/.]*)$/, "$1$2")
					.replace(/(\/magazine\/+[0-9]{4}\/+[0-9]{2}\/+[0-9]+_[0-9a-f]+)_thumb(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			}
			if (domain_nowww === "insectidentification.org") return src.replace(/(\/imgs\/[a-z]+\/)thumbnails\//, "$1");
			if (domain_nowww === "a-z-animals.com") return src.replace(/\/images\/[0-9]+x[0-9]+\//, "/images/original/");
			if (domain_nosub === "nicematin.com" && /^cdn\.static[0-9]*\./.test(domain)) {
				return src.replace(/(:\/\/[^/]*\/+media\/+[^/]*\/+)[^/]*(\/+[0-9]+\/+[0-9]+\/+[^/]*)(?:[?#].*)?$/, "$1original$2");
			}
			if (domain_nosub === "fbcdn.net" || domain_nosub === "cdninstagram.com") {
				newsrc = common_functions["instagram_norm_url"](src);
				if (newsrc !== src)
					return common_functions["set_cdninstagram_obj"](newsrc);
				/*newsrc = remove_queries(src, ["se"]);
				if (newsrc !== src)
					return newsrc;

				newsrc = remove_queries(src, ["_nc_cat", "_nc_rid", "efg", "ig_cache_key"]);
				if (newsrc !== src)
					return newsrc;*/
			}
			if (domain_nowww === "instagram.com") {
				newsrc = website_query({
					website_regex: {
						regex: /^[a-z]+:\/\/[^/]+\/+(p|tv|reel)\/+([^/]+)(?:\/+(?:(?:media|embed).*)?)?(?:[?#].*)?$/,
						groups: ["type", "id"]
					},
					id: "post:${type}:${id}",
					run: function(cb, match) {
						var info = [{
								type: "post",
								subtype: "link",
								url: "https://www.instagram.com/" + match[1] + "/" + match[2] + "/",
								element: options.element
							}];
						var queries = common_functions["parse_imu_hash"](src);
						if (queries) {
							if (queries.i) {
								info[0].image = parseInt(queries.i);
							} else if (queries.image_url) {
								info[0].image = queries.image_url;
							}
						}
						if (!info[0].image)
							info[0].image = "first";
						return common_functions["instagram_parse_el_info"](api_cache, options.do_request, options.rule_specific.instagram_use_app_api, options.rule_specific.instagram_dont_use_web, options.rule_specific.instagram_prefer_video_quality, info, options.host_url, cb);
					}
				});
				if (newsrc)
					return newsrc;
				newsrc = website_query({
					website_regex: {
						regex: /^[a-z]+:\/\/[^/]+\/+stories\/+([^/]+)\/+([0-9]+)\/*(?:[?#].*)?$/,
						groups: ["user", "id"]
					},
					id: "story:${user}:${id}",
					run: function(cb, match) {
						var info = [{
								type: "story",
								url: "https://www.instagram.com/stories/" + match.groups.user + "/" + match.groups.id + "/",
								element: options.element
							}];
						info[0].image = info[0].url;
						return common_functions["instagram_parse_el_info"](api_cache, options.do_request, options.rule_specific.instagram_use_app_api, options.rule_specific.instagram_dont_use_web, options.rule_specific.instagram_prefer_video_quality, info, options.host_url, cb);
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (((domain_nosub === "fbcdn.net" && domain.match(/^instagram\./)) ||
				domain_nosub === "cdninstagram.com" ||
				(!src && origsrc)) &&
				host_domain_nosub === "instagram.com" && options.element && options.cb) {
				newsrc = (function() {
					var info = common_functions["instagram_find_el_info"](document, options.element, options.host_url);
					return common_functions["instagram_parse_el_info"](api_cache, options.do_request, options.rule_specific.instagram_use_app_api, options.rule_specific.instagram_dont_use_web, options.rule_specific.instagram_prefer_video_quality, info, options.host_url, options.cb);
				})();
				if (newsrc !== void 0)
					return newsrc;
			}
			if (domain_nowww === "instagram.com") {
				if (/\/static\/+(?:bundles\/+[^/]+\/+sprite_|images\/+ico\/+)/.test(src)) {
					return {
						url: src,
						bad: "mask"
					};
				}
			}
			if (domain_nosub === "instagram.com" &&
				src.match(/:\/\/[^/]*\/+p\/+[^/]*\/+media\/*[?]size=[a-z](?:[&#].*)?$/)) {
				newsrc = {
					url: src.replace(/\/media.*?[?&]size=[a-z].*?$/, "/media?size=l"),
					can_head: false
				};
				match = src.match(/\/p\/+([^/]+)\/+media/);
				if (match) {
					return [
						{ url: "https://www.instagram.com/p/" + match[1] + "/", is_pagelink: true },
						newsrc
					];
				} else {
					return newsrc;
				}
			}
			if (domain === "l.instagram.com") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]+\/+\?(?:.*&)?u=([^&]+).*?$/, "$1");
				if (newsrc !== src)
					return decodeURIComponent(newsrc);
			}
			if (domain === "s9e.github.io") {
				match = src.match(/\/iframe\/+[0-9]+\/+instagram\.min\.html#(.*)$/);
				if (match) {
					return {
						url: "https://www.instagram.com/p/" + match[1] + "/",
						is_pagelink: true
					};
				}
			}
			if (domain === "cdns.klimg.com" ||
				domain === "cdn.klimg.com") {
				return src
					.replace(/(:\/\/[^/]*\/+[^/]*\.[^/]*\/+)resized\/+[0-9]+x(?:[0-9]+)?\/+/, "$1")
					.replace(/\/resized\/[0-9]+x(?:[0-9]+)?\//, "/kapanlagi.com/")
					.replace(/(\/g\/.\/.\/[^/]*\/)t\/([^/]*)$/, "$1$2")
					.replace(/(\/p\/+[^/]*\/+)[0-9]+x[0-9]+\/+([^/]*$)/, "$1$2")
					.replace(/\/t\/+([^/]*\.[^/.]*)(?:[?#].*)?$/, "/$1")
					.replace(/(\/resources\/.*\/)[auto0-9]+x[auto0-9]+-([^/]+)(?:[?#].*)?$/, "$1$2");
			}
			if (domain_nosub === "nintendo-europe.com" && /^cdn[0-9]*\./.test(domain)) {
				return src.replace(/_image[0-9]*[wh](\.[^/.]*)$/, "$1");
			}
			if (domain_nosub === "15min.lt" && /^s[0-9]*\./.test(domain)) {
				return src.replace(/(\/images\/+photos\/+[0-9]{4}\/+(?:[0-9]{2}\/+){2})[a-z]+(\/+[^/]+\.[^/.]+)(?:[?#].*)?$/, "$1original$2");
			}
			if (domain === "image.way2enjoy.com") return src.replace(/^[a-z]+:\/\/[^/]*\/misc\/lazyg\/.*?\/([^/]*)\.[^/.]*\.[^/.]*$/, "http://lzimages.lazygirls.info/$1");
			if (domain_nowww === "mobtada.com") return src.replace(/(:\/\/[^/]*\/)resize.*?[?&]src=([^&]*).*?$/, "$1$2");
			if (domain_nowww === "art-dept.com") return src.replace(/\/cache\/([^/]*)_[0-9]+(\.[^/.]*)$/, "/$1$2");
			if (domain === "static.stylosophy.it" ||
				domain === "static.ellahoy.es" ||
				domain === "image.nanopress.it") {
				newsrc = src.replace(/(:\/\/[^/]*\/)(r\/+|[^/]+\/+fotogallery\/+)[0-9]+[xX][0-9]+\//, "$1$2999999999999X0/");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/r\/+[0-9]+[xX][0-9]+\/+([^/]*\.[^/]*\/)/, "http://$1");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "static.stylosophy.it" ||
				domain === "static.ellahoy.es") {
				return src.replace(/(:\/\/[^/]*\/)[0-9]+X[0-9]+\/+www\/+/, "$1999999999999X0/www/");
			}
			if (amazon_container === "nikeinc" &&
				string_indexof(src, "/assets/") >= 0) {
				return src.replace(/_hd_[0-9]+(\.[^/.]*)$/, "_original$1");
			}
			if ((domain_nowww === "mitazamagica.com" ||
				domain === "mengqi.chenggong.it") &&
				string_indexof(src, "/Shops/") >= 0) {
				return src.replace(/_(?:s|m|ml)(\.[^/.]*)$/, "$1");
			}
			if (domain_nowww === "imgbase.info" &&
				string_indexof(src, "/images/safe-wallpapers/") >= 0) {
				newsrc = src.replace(/\/[a-z]+_([0-9]+[^/]*)$/, "/$1");
				return {
					url: newsrc,
					headers: {
						Referer: "https://www.wallpapervortex.com/wallpaper-" + src.replace(/\/[a-z]+_([0-9]+[^/]*)\.[^/.]*$/, "$1") + ".html"
					}
				};
			}
			if (domain_nowww === "paperlief.com" ||
				domain_nowww === "celebritywc.com" ||
				domain_nowww === "ya-webdesign.com" ||
				domain_nowww === "quotationof.com" ||
				domain_nowww === "7desktopthemes.com" ||
				domain_nowww === "eskipaper.com") {
				return src.replace(/\/images[0-9]+_([0-9]+)?\//, "/images/");
			}
			if (domain_nosub === "anidb.net" && /^cdn[0-9]*(?:-[a-z]+)?\./.test(domain)) {
				return src.replace(/\/(thumbs|images)\/+[0-9]+(?:x[0-9]+)?\/+([0-9]+\.[^/.-?#]*)-thumb\.[^/.]+$/, "/$1/main/$2");
			}
			if (domain === "web-ace.jp") return src.replace(/\/rp\/[0-9_]+\/[0-9]+_[0-9]+\/img\//, "/img/");
			if (domain_nowww === "classy-girls.com" ||
				domain_nowww === "dillonmarsh.com") {
				return src.replace(/\/images\/+thumbnails\//, "/images/");
			}
			if (domain === "staticdelivery.nexusmods.com") return src.replace(/(\/images\/+(?:[0-9]+\/+)?)thumbnails\//, "$1");
			if (domain === "forums.nexusmods.com") return src.replace(/\/uploads\/profile\/photo-thumb-([0-9]+)/, "/uploads/profile/photo-$1");
			if ((domain_nowww === "kb4images.com" ||
				domain_nowww === "digitalimagemakerworld.com" ||
				domain_nowww === "99desktopwallpapers.com") &&
				string_indexof(src, "/images/") >= 0) {
				return src.replace(/-small(\.[^/.]*)$/, "$1");
			}
			if (domain === "pics.me.me") return src.replace(/\/thumb_([^/]*-[0-9]+\.[^/.]*)$/, "/$1");
			if (domain === "image.winudf.com") {
				if (/\/v2\/+image\//.test(src)) {
					return {
						url: add_queries(remove_queries(src, ["w", "h"]), {
							type: ".png"
						}),
						headers: {
							Accept: '*/*'
						}
					};
				}
			}
			if (domain === "i.supload.com") return src.replace(/\/[0-9]+x[0-9]+\//, "/");
			if (domain_nosub === "yaplakal.com" &&
				domain.match(/s[0-9]*\.yaplakal\.com/)) {
				return src.replace(/\/pics\/pics_[a-z]+\//, "/pics/pics_original/");
			}
			if (domain === "static.comicvine.com" ||
				domain === "static.giantbomb.com" ||
				domain === "static.gamespot.com" ||
				domain_nosub === "cbsistatic.com") {
				newsrc = src.replace(/(:\/\/[^/]+\/+)uploads\/+[^/]+\/+((?:mig\/+(?:[0-9]\/+){4}|[0-9]+\/+[0-9]+\/+)[0-9]+(?:-[^/]+)?\.)/, "$1uploads/original/$2");
				if (newsrc !== src)
					return add_extensions(newsrc);
			}
			if (domain_nowww === "ibb.co") {
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+([a-zA-Z0-9]+)(?:[?#].*)?$/,
					query_for_id: "https://ibb.co/${id}",
					process: function(done, resp, cache_key) {
						var match = resp.responseText.match(/CHV\.obj\.image_viewer\.image\s*=\s*{.*?[^a-zA-Z0-9_]["']?url["']?:["'](.*?)["']/);
						if (!match) {
							console_error(cache_key, "Unable to find match for", resp);
							return done(null, false);
						}
						var url = JSON_parse('"' + match[1] + '"');
						var obj = {
							url: url,
							extra: {
								page: urljoin(resp.finalUrl + "/", url.replace(/.*\/([^/.]*).*?$/, "$1"), true)
							}
						};
						var title = get_meta(resp.responseText, "og:title");
						if (title)
							obj.extra.caption = title;
						return done(obj, 6 * 60 * 60);
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain === "i.ibb.co" ||
				domain === "image.ibb.co" ||
				domain === "thumb.ibb.co" ||
				domain === "preview.ibb.co") {
				match = src.match(/^[a-z]+:\/\/[^/]*\/+([-_A-Za-z0-9=]+)\/+([^?#]*?)(\.[^/.]*)?(?:[?#].*)?$/);
				if (match) {
					return {
						url: "https://ibb.co/" + match[1],
						is_pagelink: true
					};
				}
			}
			if (domain === "cdn.imagepush.to") return src.replace(/(:\/\/[^/]*\/)(?:in|out)\/[0-9]+x[0-9]+\//, "$1");
			if (domain === "storage.bhs.cloud.ovh.net") {
				newsrc = src.replace(/(\/v1\/+AUTH_[0-9a-f]+\/+images\/+[^/]+\/+[0-9]+\/+[^/]+)\.[0-9]+x[0-9]+\./, "$1.");
				if (newsrc !== src)
					return add_full_extensions(newsrc, ["mp4", "jpg"]);
			}
			if (domain_nosub === "luscious.net" && /^w[0-9]+\./.test(domain)) {
				return {
					url: src.replace(/^[a-z]+:\/\/[^/]+\/+/, "https://cdnio.luscious.net/"),
					can_head: false, // 403
					headers: {
						Referer: ""
					}
				};
			}
			if (domain_nosub === "luscious.net" && /^(?:cdn[a-z]*|gifs)\./.test(domain)) {
				newsrc = src
					.replace(/\.[0-9]+x[0-9]+(\.[^/]*)$/, "$1")
					.replace(/\/resized\/[0-9]+\//, "/");
				if (newsrc !== src) {
					return fillobj_urls(add_full_extensions(newsrc), {
						can_head: false,
						headers: {
							Referer: ""
						}
					});
				}
			}
			if (domain === "d2pqhom6oey9wx.cloudfront.net") return src.replace(/\/img_(?:thumb|resize)\//, "/img_original/");
			if (domain === "i.gyazo.com") return src.replace(/\/thumb\/[0-9]+\/([0-9a-f]+)-([a-z]+)\.[^/.]*$/, "/$1.$2");
			if (domain === "cdn.theatlantic.com") {
				newsrc = src.replace(/\/thumbor\/.*\/(?:assets\/+)?media\/+/, "/assets/media/");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "cdn.theatlantic.com" &&
				src.match(/\/assets\/+media\/+(?:[^/]*\/)?img\//)) {
				return src.replace(/\/[^/.]*(\.[^/.]*)$/, "/original$1");
			}
			if (domain === "media.tag24.de") return src.replace(/(:\/\/[^/]*\/)[0-9]+\//, "$10/");
			if (amazon_container === "customink-iotw-east-prod" ||
				domain === "d2fzf9bbqh0om5.cloudfront.net") {
				return src.replace(/(\/images\/[0-9]+\/)[^/]*\//, "$1original/");
			}
			if (domain === "customink-prod.imgix.net") return src.replace(/^[a-z]+:\/\/[^/]+\/+photos\/+system\/+(images\/+[0-9]+\/+[a-z]+\/+[^/?#]+)(?:[?#].*)?$/, "https://s3.amazonaws.com/customink-iotw-east-prod/$1");
			if (domain_nowww === "mypokecard.com") return src.replace(/\/galery\/thumbs\//, "/galery/");
			if (domain === "media.women.com" &&
				string_indexof(src, "/images/images/") >= 0) {
				return src.replace(/\/[a-z]+\/([^/]*)$/, "/original/$1");
			}
			if (domain_nowww === "alternathistory.com") return src.replace(/\/files\/+resize(\/+.*\/+[^/]*)-[0-9]+x[0-9]+(\.[^/.]*)$/, "/files$1$2");
			if (domain === "img.velvet.by") return src.replace(/\/files\/+resize\/+(userfiles\/+[0-9]+\/+[^/]*)-[0-9]+x[0-9]+(\.[^/.]*)(?:[?#].*)?$/, "/files/$1$2");
			if (domain_nowww === "mtvwe.com") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]+\/+vpic\.php\?(?:.*&)?f=([^&]+).*?$/, "$1");
				if (newsrc !== src)
					return urljoin(src, newsrc, true);
			}
			if (domain === "yahoo.tw.weibo.com") return src.replace(/(:\/\/[^/]+\/)[a-z]+\//, "$1large/");
			if (domain === "mobile.pic.people.com.cn") return src.replace(/\/thumbs\/+[0-9]+\/+[0-9]+\/+/, "/");
			if (domain === "images.asianstar.cz") return src.replace(/\/[a-z]+_([^/]*)$/, "/$1");
			if (domain === "images-cache.asianstar.cz") return src.replace(/:\/\/[^/]*\//, "://images.asianstar.cz/");
			if (domain === "picservice.qimai.cn") return src.replace(/^[a-z]+:\/\/[^/]*\/+get\/+(https?:)/, "$1");
			if (domain === "mediaday.co.kr" ||
				domain_nowww === "secretvt.com" ||
				domain === "file.candlemystar.com" ||
				domain_nowww === "5rs-1.com") {
				return src.replace(/\/cache\/+([_a-z]+\/+[0-9]{4}\/+[0-9]{2}\/+)thumb-([0-9a-f]+(?:_[0-9]+)?)_[0-9]+x[0-9]+(\.[^/.]*)(?:[?#].*)?$/, "/$1$2$3");
			}
			if (domain === "up.kpop.re" ||
				domain === "store.kpop.events") {
				newsrc = src.replace(/(:\/\/[^/]*\/)[a-z]+(\/[0-9a-f]{2}\/[0-9a-f]+\.[^/.]*)(?:\/[^/]*)?$/, "$1src$2");
				if (newsrc !== src)
					return add_extensions(newsrc);
			}
			if (domain === "st.kp.yandex.net" &&
				string_indexof(src, "/images/") >= 0) {
				return src
					.replace(/_iphone\/+iphone[0-9]+_([0-9]+\.[^/.]*)(?:[?#].*)?$/, "_original/$1")
					.replace(/\/[a-z]+_([0-9]+(?:_[^/]*)?\.[^/.]*)$/, "/$1");
			}
			if (domain_nowww === "startfilm.ru" && string_indexof(src, "/images/") >= 0) {
				return src
					.replace(/\/sm_([0-9]+_[^/]*)$/, "/$1")
					.replace(/(\/film\/+f_[0-9]+\/+)film_/, "$1");
			}
			if (domain_nowww === "publicfeet.com") return src.replace(/\/img\/t([0-9]+\.[^/.]*)$/, "/img/$1");
			if (domain_nowww === "twatis.com") return src.replace(/\/thumb(\.[^/.]*)$/, "/photo$1");
			if (domain === "s.smutty.com" ||
				domain === "i.smutty.com") {
				return src.replace(/\/[a-z]\/+([^/]*)(?:[?#].*)?$/, "/b/$1");
			}
			if (domain_nowww === "welovesexyfeet.com" ||
				domain_nowww === "podolatria.net" ||
				domain === "img.ibxk.com.br") {
				return src.replace(/-t[0-9]+x[0-9]+(\.[^/.]*)$/, "$1");
			}
			if (domain_nowww === "hotflick.net" ||
				amazon_container === "hotflicknet") {
				return src
					.replace(/(:\/\/[^/]*\/.*\/[0-9]+\/)tn\/[0-9]+_[a-z]+\/([^/]*)$/, "$1$2")
					.replace(/\/+(?:tn[0-9]+|Thumb)\/+([^/]*)(?:[?#].*)?$/, "/$1")
					.replace(/:\/\/(?:[^/.]*-)?s3\.amazonaws\.com\/hotflicknet\/(.*\/)tn\/([^/]*)$/, "://hotflicknet.s3.amazonaws.com/$1$2")
					.replace(/:\/\/[^/]*\/(.*\/)tn\/([^/]*)$/, "://hotflicknet.s3.amazonaws.com/$1$2");
			}
			if (domain_nowww === "seniorclassaward.com" ||
				domain_nowww === "raincoast.com" ||
				domain_nowww === "zocalo.com.mx") {
				return src.replace(/\/images\/sized(\/images\/.*)-[0-9]+x[0-9]+(\.[^/.]*)$/, "$1$2");
			}
			if (domain_nowww === "hentairing.com") {
				return src
					.replace(/\/(?:width|height)-[0-9]+\/([^/]*)(?:[?#].*)?$/, "/$1")
					.replace(/\?.*/, "");
			}
			if (domain_nosub === "enterdesk.com" && /^up\./.test(domain)) {
				return src.replace(/\/edpic_[0-9]+(?:_[0-9]+)?\//, "/edpic_source/");
			}
			if (domain_nosub === "gtimg.com" && /^img[0-9]*\./.test(domain)) {
				return {
					url: src.replace(/_[0-9]+x[0-9]+(?:_[0-9]+)?(\.[^/.]*)$/, "$1"),
					can_head: false // wrong content-length, and GET forces download (but not HEAD)
				};
			}
			if (domain_nosub === "zol-img.com.cn") {
				return src
					.replace(/(:\/\/[^/]*\/)t_[0-9a-z]+\//, "$1")
					.replace(/(\/article\/[0-9]+)_[0-9]+x[0-9]+\//, "$1/");
			}
			if (domain === "img.faxing11.com" ||
				domain === "img.pipimi.com") {
				return src.replace(/^[a-z]+:\/\/[^/]*\/img\//, "http://");
			}
			if (domain_nowww === "bifaxing.com") return src.replace(/^[a-z]+:\/\/[^/]*\/gpPic\/+[0-9]+\/+[0-9]+\/+([^/]*\.[^/]*)/, "http://$1");
			if (domain === "static.congnghe.vn" ||
				domain_nowww === "congnghe.vn") {
				newsrc = src.replace(/\/srv_thumb\.ashx.*?[?&]f=([^&]*).*/, "/$1");
				if (newsrc !== src)
					return newsrc.replace(/\\/g, "/");
				return src.replace(/\/[^/]*-([0-9]+\.[^/.]*)\.[0-9]+\.[0-9]+\.[^/.]*$/, "/$1");
			}
			if (domain === "images.foody.vn") return src.replace(/\/s[0-9]+x[0-9]+\/([^/]*)$/, "/s/$1");
			if (domain === "programma.sorrisi.com" ||
				domain_nowww === "shamra.sy") {
				return src.replace(/\/uploads\/+media\/+cache\/+[^/]*\/+uploads\//, "/uploads/");
			}
			if (domain_nowww === "vidofa.com") {
				newsrc = src.replace(/.*?\/module\/+thumb\/+sr\.php\?(?:.*&)?src=([^&]*).*?$/, "$1");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nowww === "free4kwallpapers.com") {
				return src
					.replace(/\/uploads\/+wallpaper\/+([0-9]{2}\/.*)-[0-9]+x[0-9]+-wallpaper(\.[^/.]*)$/, "/uploads/originals/20$1$2")
					.replace(/\/uploads\/+originals\//, "/no-watermarks/originals/");
			}
			if (domain_nosub === "webnode.com.br" ||
				domain_nosub === "webnode.cz" ||
				domain_nosub === "webnode.sk" ||
				domain_nosub === "webnode.com") {
				return src.replace(/(:\/\/(?:files\.[^/]*\.[^/.]*\.[^/]*\/+|[^/]*\/+_files\/+))(?:[^/]*_)?([0-9]+-[0-9a-f]+(?:-[a-z]+)?\/)+(?:[0-9]+\/+)?([^/]*)$/, "$1$2$3");
			}
			if (amazon_container === "cdn.roosterteeth.com") {
				return src.replace(/(\/images\/[-0-9a-f]+\/)[a-z]+(\/[^/]*)$/, "$1original$2");
			}
			if (domain_nowww === "wallpaperk.com") return src.replace(/\/resoluciones\/[0-9]+\/([^/]*)_[0-9]+x[0-9]+_([0-9]+\.[^/.]*)$/, "/$1-$2");
			if (domain === "pic.58pic.com" ||
				domain_nosub === "90sjimg.com" ||
				domain === "pic.qiantucdn.com") {
				return src.replace(/!.*/, "");
			}
			if (domain === "img.wallpapersafari.com" ||
				domain === "cdn.wallpapersafari.com") {
				newsrc = src
					.replace(/\/img[0-9]+\//, "/")
					.replace(/\/desktop\/+[0-9]+\/+[0-9]+\//, "/");
				if (newsrc !== src)
					return newsrc;
				match = src.match(/^[a-z]+:\/\/[^/]+\/+[0-9]+\/+[0-9]+\/+([^/.]+)\.[^/.]+$/);
				if (match) {
					return {
						url: src,
						extra: {
							page: "https://www.wallpapersafari.com/w/" + match[1]
						}
					};
				}
			}
			if (domain === "mcdn.wallpapersafari.com") return src.replace(/:\/\/mcdn(\.[^/]*\/)(?:medium|small)\/+/, "://cdn$1");
			if ((domain_nosub === "fjcdn.com" && /^static[0-9]*\./.test(domain)) ||
				domain_nosub === "funnyjunk.com") {
				return src
					.replace(/\/thumbnails\/+comments\//, "/comments/")
					.replace(/\/pictures\/+[^/]*_([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]+_[0-9]+\.[^/.]*)$/, "/large/pictures/$1/$2/$1$2$3");
			}
			if (googlestorage_container === "kendam-148811.appspot.com") {
				return src.replace(/\/thumb[0-9]+\/tn[0-9]+_/, "/temp/");
			}
			if (domain === "image-cdn.hypb.st") {
				return decodeURIComponent(src.replace(/^[a-z]+:\/\/[^/]*\/([^&]*).*/, "$1"));
			}
			if (domain_nowww === "productionparadise.com") return src.replace(/(\/photos\/[0-9]+\/)[a-z]+(\/[^/]*)$/, "$1original$2");
			if (domain_nosub === "cargocollective.com" && /^payload[0-9]*\./.test(domain)) {
				return src.replace(/_[0-9]{3,4}(?:_c)?(\.[^/.]*)$/, "$1");
			}
			if (domain_nowww === "imagebam.com") {
				var process_imagebam = function(done, resp, cache_key) {
					/*var ogimage = get_meta(resp.responseText, "og:image");
					if (!ogimage) {
						console_error(cache_key, "Unable to find og:image from", resp);
						return done(null, false);
					}*/
					var match = resp.responseText.match(/<img src="(https?:\/\/images[0-9]*\.imagebam\.com\/[^"]+)" [^>]*class="main-image/);
					if (!match) {
						console_error(cache_key, "Unable to find main image from", resp);
						return done(null, false);
					}
					var ogimage = match[1];
					done({
						url: ogimage,
						is_original: true,
						headers: {
							Referer: "https://www.imagebam.com/"
						},
						referer_ok: {
							same_domain_nosub: true
						},
						extra: {
							page: resp.finalUrl
						}
					}, 60 * 60);
				};
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+image\/+([0-9a-f]+)(?:[?#].*)?$/,
					query_for_id: "https://www.imagebam.com/image/${id}",
					process: process_imagebam
				});
				if (newsrc)
					return newsrc;
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+view\/+([0-9A-Z]+)(?:[?#].*)?$/,
					query_for_id: "https://www.imagebam.com/view/${id}",
					process: process_imagebam
				});
				if (newsrc)
					return newsrc;
			}
			if (domain_nosub === "imagebam.com" && /^thumb(?:nail)?s[0-9]*\./.test(domain)) {
				id = src.replace(/.*\/([0-9a-f]+)\.[^/.]*$/, "$1");
				if (id !== src) {
					return {
						url: "https://www.imagebam.com/image/" + id,
						is_pagelink: true
					};
				}
				id = src.replace(/.*\/([0-9A-Z]+)_t\.[^/.]+$/, "$1");
				if (id !== src) {
					return {
						url: "https://www.imagebam.com/view/" + id,
						is_pagelink: true
					};
				}
			}
			if (domain_nosub === "imagebam.com") {
				if (/\/nohotlinking\.jpg(?:[?#].*)?$/.test(src)) {
					return {
						url: src,
						bad: true
					};
				}
				if (string_indexof(src, "/download/") >= 0) {
					return {
						url: src,
						is_original: true,
						headers: {
							Referer: "https://www.imagebam.com/"
						},
						referer_ok: {
							same_domain_nosub: true
						}
					};
				}
			}
			if (domain_nosub === "imagevenue.com") {
				if (/^[a-z]+:\/\/[^/]+\/+no_image\./.test(src)) {
					return {
						url: src,
						bad: true
					};
				}
			}
			if (domain_nosub === "imagevenue.com" &&
				domain.match(/^img[0-9]+\.imagevenue\.com/) &&
				src.match(/\/th_([^/]*)$/) &&
				options && options.cb && options.do_request) {
				id = src.replace(/.*\/th_([^/]*?)(?:[?&#].*)?$/, "$1");
				if (id !== src) {
					var requrl = src.replace(/(:\/\/[^/]*\/).*/, "$1img.php?image=" + id);
					var query_imagevenue = function(requrl, cb) {
						var do_req = function(requrl, first, cb) {
							var headers = {
								Referer: requrl
							};
							options.do_request({
								url: requrl,
								method: "GET",
								headers: headers,
								onload: function(resp) {
									if (resp.status !== 200) {
										console_error("Bad status", resp);
										return cb(null);
									}
									var match = resp.responseText.match(/<img *id=['"]thepic['"][^>]* (?:src|SRC)=['"]([^"']*)['"]/);
									if (!match) {
										match = resp.responseText.match(/<a href="https?:\/\/www\.imagevenue\.com\/view\/o\?[\s\S]*?<img src="(https?:\/\/(?:img|cdn)[^/]*\.imagevenue\.[^"']+)"/);
									}
									var baseobj = {
										extra: {
											page: requrl
										},
										bad_if: [{
												headers: {
													"Last-Modified": "Mon, 04 May 2020 07:19:52 GMT",
													"Content-Length": "14396",
													"Content-Type": "image/jpeg"
												}
											}]
									};
									if (match) {
										cb(fillobj_urls([{
												url: urljoin(resp.finalUrl, match[1], true),
												is_original: true,
											}, src], baseobj));
									} else {
										console_error("Unable to find match", resp);
										if (first) {
											return do_req(resp.finalUrl, false, cb);
										} else {
											cb(null);
										}
									}
								}
							});
						};
						api_cache.fetch("imagevenue:" + requrl, cb, function(done) {
							do_req(requrl, true, function(data) {
								if (!data) {
									return done(null, false);
								} else {
									return done(data, 60 * 60);
								}
							});
						});
					};
					query_imagevenue(requrl, options.cb);
					return {
						waiting: true
					};
				}
			}
			if (domain_nowww === "imagevenue.com") {
				if (/\/images\/+loader\.svg/.test(src))
					return {
						url: src,
						bad: "mask"
					};
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+([A-Z0-9]{5,})(?:[?#].*)?$/,
					query_for_id: "https://www.imagevenue.com/${id}",
					process: function(done, resp, cache_key, match) {
						var match = resp.responseText.match(/<img src="(https?:\/\/(?:cdn-images\.[^"]+_o\.[^"]+|cdno-data\.[^"]+))"/);
						if (!match) {
							console_error(cache_key, "Unable to find match for", resp);
							return done(null, false);
						}
						return done(match[1], 6 * 60 * 60);
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain === "cdn-thumbs.imagevenue.com") {
				match = src.match(/\/(?:[0-9a-f]{2}\/+){3}([A-Z0-9]+)_t\./);
				if (match) {
					return {
						url: "https://www.imagevenue.com/" + match[1],
						is_pagelink: true
					};
				}
			}
			if (domain === "static.cinemagia.ro") return src.replace(/\/img\/resize\/db\/(.*\/(?:[^/]*?-)?[0-9]+[a-z])-[^/.]*?(\.[^/.]*)$/, "/img/db/$1$2");
			if (domain === "static.kinokopilka.pro") return src.replace(/(\/[0-9]+)_[a-z]+(\.[^/.]*)$/, "$1_original$2");
			if (domain === "d1uzk9o9cg136f.cloudfront.net") return src.replace(/(\/[a-f0-9]+)_[a-z]+(\.[^/.]*)$/, "$1$2");
			if (domain === "static.azteca.com") {
				return decodeURIComponent(src.replace(/^[a-z]+:\/\/[^/]*\/crop\/crop\.php.*?[?&]img=([^&]*).*?$/, "$1"));
			}
			if (domain_nowww === "tasoeur.biz") return src.replace(/\/thumbs\/([^/]*)\.thumb(\.[^/.]*)$/, "/$1$2");
			if (domain_nowww === "taipeitimes.com") return src.replace(/(\/images\/+[0-9]{4}\/+(?:[0-9]{2}\/+){2})thumbs\/+/, "$1");
			if (domain === "imageproxy.ifcdn.com" ||
				domain === "imageproxy.ifunny.co") {
				return src.replace(/:\/\/[^/]*\/+[^/]*(\/(?:images|user_photos)\/+[^/]*)(?:[?#].*)?$/, "://img." + domain_nosub + "$1");
			}
			if (domain === "resource.mingweekly.com") return src.replace(/\/userfiles\/sm\/sm[0-9]+_images/, "/userfiles/images");
			if (domain_nosub === "allegroimg.com") return src.replace(/(:\/\/[^/]*\/)s[0-9]+\//, "$1original/");
			if (domain === "mmc.tirto.id") return src.replace(/\/image\/otf\/[0-9]+x[0-9]+\//, "/image/");
			if (domain === "ia.tmgrup.com.tr" ||
				domain === "iaahbr.tmgrup.com.tr") {
				return decodeURIComponent(src.replace(/^[a-z]+:\/\/[^/]*\/[^/]*\/(?:[0-9]+\/){5}[0-9]+\/?.*?[?&]u=([^&]*).*?$/, "$1"));
			}
			if (domain === "img.erogazou.co") return src.replace(/\/thumb\//, "/photo/");
			if (domain === "tracks.content.hardstyle.com") return src.replace(/\/thumbs\/[0-9]+x[0-9]+\//, "/original/");
			if ((domain_nosub === "thedjlist.com" && domain.match(/i[0-9]*\./)) ||
				domain === "static.inaturalist.org") {
				return src.replace(/(\/photos\/[0-9]+\/)[a-z]+(\.[^/.]*)$/, "$1original$2");
			}
			if (domain === "artist-assets.hubbardradio.com") return src.replace(/_v[0-9]+(\.[^/.]*)$/, "$1");
			if (domain === "cdn.ebaumsworld.com" ||
				domain === "images.ebaumsworld.com") {
				return src.replace(/\/thumbs\/(?:picture|gallery)\//, "/mediaFiles/picture/");
			}
			if (domain_nosub === "kapook.com") {
				return src
					.replace(/\/rf\/[0-9]+\/[0-9]+\//, "/o/")
					.replace(/\/rq\/+[0-9]+\/+auto\/+[0-9]+\/+pagebuilder\/+/, "/pagebuilder/");
			}
			if (domain_nosub === "amcn.in" &&
				domain.match(/^cdn[0-9]*\.amcn\.in/)) {
				return src.replace(/^[a-z]+:\/\/[^/]*\/a\/([^/.]*\.[^/]*\/)/, "http://$1");
			}
			if (domain_nosub === "litlepups.net" &&
				domain.match(/^cdn[0-9]*\.litlepups\.net/)) {
				return src.replace(/:\/\/[^/]*\/resize\/(.*)\/[a-z]+-([^/]*)$/, "://cdn.litlepups.net/$1/$2");
			}
			if (domain_nowww === "wede-mail.com" ||
				domain_nowww === "warnerchappell.com") {
				return src.replace(/\/slir\/(?:[whc][0-9:]+(?:-[^/]*)|orig)\//, "/");
			}
			if (domain_nowww === "photorator.com" ||
				domain_nowww === "contrastspace.ru" ||
				domain_nowww === "galleon-realty.ru" ||
				domain_nowww === "teatrvmeste.ru" ||
				domain_nowww === "pornopics.co") {
				newsrc = src.replace(/\/photos\/(?:thumbs|small)\//, "/photos/images/");
				page = src.replace(/(\/photo)s\/+[^/]+\/+[^/]+-([0-9]+)\.[^/.]+(?:[?#].*)?$/, "$1/$2");
				if (page !== src) {
					return {
						url: newsrc,
						extra: {
							page: page
						}
					};
				} else {
					return newsrc;
				}
			}
			if (domain_nowww === "expressen.se") {
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+videoplayer\/+embed\/+([^?#]*)(?:[?#].*)?$/,
					query_for_id: "https://www.expressen.se/videoplayer/embed/${id}",
					process: function(done, resp, cache_key) {
						var match = resp.responseText.match(/<body>\s*<figure\s+class="evp evp--embeded"\s+data-article-data='({[^']+})'/);
						if (!match) {
							console_error(cache_key, "Unable to find figure match for", resp);
							return done(null, false);
						}
						var decoded = decode_entities(match[1]);
						var parsed = JSON_parse(decoded);
						var obj = {
							extra: {
								page: urljoin(resp.finalUrl, parsed.linkUrl, true),
								caption: parsed.title
							}
						};
						var urls = [];
						if (parsed.stream) {
							urls.push({
								url: parsed.stream,
								video: "hls"
							});
						}
						if (parsed.mp4File) {
							urls.push({
								url: parsed.mp4File,
								video: true
							});
						}
						if (parsed.image) {
							urls.push(parsed.image);
						}
						return done(fillobj_urls(urls, obj), 60 * 60);
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain_nosub === "cdn-expressen.se") {
				newsrc = src.replace(/\/[0-9]+(?:@[0-9]+)?(\.[^/.]*)$/, "/original$1");
				if (newsrc !== src)
					return newsrc;
				return src.replace(/(\/[0-9a-f]+\/)[0-9]+x[0-9]+(\/[^/]*)$/, "$1annan$2");
			}
			if (domain === "images.csmonitor.com") return src.replace(/(?:\?.*)?$/, "?alias=original");
			if (domain_nowww === "incimages.com" ||
				domain_nowww === "firenewsfeed.com") {
				newsrc = src.replace(/\/image\/[0-9]+x[0-9]+\//, "/image/");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nowww === "firenewsfeed.com") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]+\/+image\/+(?:[0-9]+x[0-9]+\/+)?(aHR0c[^?#./]+)(?:[?#].*)?$/, "$1");
				if (newsrc !== src)
					return base64_decode(newsrc);
			}
			if (domain === "cached.imagescaler.hbpl.co.uk") return src.replace(/^[a-z]+:\/\/[^/]*\/resize\/[^/]*\/[0-9]+\/([^/]*\.[^/]*\/)/, "http://$1");
			if (domain === "i.tuenlinea.com") return src.replace(/(\/[^/]*(\.[^/.]*))\.img[wh]\.[0-9]+\.[0-9]+\.[^/.]*$/, "$1.imgo$2");
			if (domain === "cdn-photos.extratv.com") return src.replace(/_thumb(\.[^/.]*)$/, "_full$1");
			if (domain === "media.extratv.com") return src.replace(/-(?:[0-9]+x[0-9]+|[0-9]+[wh])(?:-[0-9]+)?(\.[^/.]*)$/, "$1");
			if (domain === "i.wpimg.pl") return src.replace(/^[a-z]+:\/\/[^/]*\/(?:[A-Z]\/)?[0-9]+x(?:[0-9]+)?\//, "http://");
			if (domain === "static.keptelenseg.hu") return src.replace(/\/thumbs\/thumb\/p\//, "/p/");
			if (domain_nosub === "wdfiles.com") return src.replace(/\/local--resized-images\/(.*\.[^/.]*)\/[a-z]+\.[^/.]*$/, "/local--files/$1");
			if (domain_nowww === "astrofactor.com") return src.replace(/(\/imgs\/[^/]*\/)[0-9]+(\/[^/]*)$/, "$1full$2");
			if (domain === "makeup.nuovogennarino.org") return src.replace(/^[a-z]+:\/\/[^/]*\/static\/[0-9]+\/img\/([^/.]+\.[^/]+)/, "http://$1");
			if ((domain_nosub === "newsdog.today" && domain.match(/^img[0-9]*\./)) ||
				amazon_container === "img.newsdog.today") {
				return src.replace(/(\.newsdog\.today\/)[a-z_]+_([a-f0-9]+)$/, "$1origin_$2");
			}
			if (domain === "d1qikntta4cp8k.cloudfront.net") {
				return decodeURIComponent(src.replace(/^[a-z]+:\/\/[^/]*\/.*?[?&]url=([^&]*)$/, "$1"));
			}
			if (domain_nosub === "img.com.ua") {
				newsrc = src.replace(/\/[0-9]+x[0-9]+(\/[0-9a-f]\/[0-9a-f]{2}\/[0-9a-f]+\.[^/.]*)$/, "/orig$1");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "rs.img.com.ua") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/crop.*?[?&]url=([^&]*).*?$/, "$1");
				if (newsrc !== src) {
					return urljoin(src, decodeURIComponent(newsrc), true);
				}
			}
			if (domain === "img-hw.xvideos.com" ||
				domain === "img-hw.xvideos-cdn.com") {
				return src.replace(/(\/pic_[0-9]+)_[a-z]+(\.[^/.]*)$/, "$1_big$2");
			}
			if (domain_nowww === "xvideos.com" ||
				domain === "flashservice.xvideos.com" ||
				domain_nowww === "xvideos.xxx" ||
				domain_nowww === "xvideos.net" ||
				domain_nowww === "xvideos.es" ||
				domain_nowww === "xnxx.com" ||
				domain_nowww === "xnxx.es") {
				var our_host = domain_nosub.replace(/\..*/, "");
				var full_videourl = function(videourl) {
					if (our_host === "xvideos") {
						return urljoin("https://www.xvideos.com/", videourl, true);
					} else if (our_host === "xnxx") {
						return urljoin("https://www.xnxx.com/", videourl, true);
					}
				};
				var parse_xvideos_page = function(cache_key, resp) {
					var matches = resp.responseText.match(/html5player\.set(.*)/g);
					if (!matches) {
						console_error(cache_key, "Unable to find matches", resp);
						return null;
					}
					var table = {};
					for (var i = 0; i < matches.length; i++) {
						var match = matches[i].match(/html5player\.set([a-zA-Z0-9]+)\('([^']+)'\);$/);
						if (!match) {
							continue;
						}
						table[match[1]] = decode_entities(match[2]);
					}
					return table;
				};
				var objify_xvideos_table = function(table) {
					var obj = {
						headers: {
							Referer: "https://www.xvideos.com/"
						},
						extra: {}
					};
					if (table.VideoTitle) {
						obj.extra.caption = table.VideoTitle;
					}
					if (table.VideoURL) {
						obj.extra.page = full_videourl(table.VideoURL);
					}
					var urls = [];
					if (table.VideoHLS) {
						urls.push({
							url: table.VideoHLS,
							video: "hls"
						});
					}
					if (table.VideoUrlHigh) {
						urls.push({
							url: table.VideoUrlHigh,
							video: true
						});
					}
					if (table.VideoUrlLow) {
						urls.push({
							url: table.VideoUrlLow,
							video: true
						});
					}
					urls.push(page_nullobj);
					return fillobj_urls(urls, obj);
				};
				var videoid_to_videourl = function(videoid) {
					if (our_host === "xvideos") {
						return "https://www.xvideos.com/video." + videoid + "/a";
					} else if (our_host === "xnxx") {
						return "https://www.xnxx.com/video-" + videoid + "/";
					}
				};
				var query_xvideos_page = function(videoid, cb) {
					var cache_key = "xvideos:" + videoid;
					if (our_host === "xnxx")
						cache_key = "xnxx:" + videoid;
					api_cache.fetch(cache_key, cb, function(done) {
						options.do_request({
							url: videoid_to_videourl(videoid),
							method: "GET",
							onload: function(resp) {
								if (resp.readyState !== 4)
									return;
								if (resp.status !== 200) {
									console_error(cache_key, resp);
									return done(page_nullobj, false);
								}
								var parsed_table = parse_xvideos_page(cache_key, resp);
								if (!parsed_table) {
									return done(page_nullobj, false);
								}
								var obj = objify_xvideos_table(parsed_table);
								if (!obj) {
									console_error(cache_key, "Unable to get URLs from", parsed_table, resp);
									return done(page_nullobj, false);
								}
								return done(obj, 3 * 60 * 60);
							}
						});
					});
				};
				var get_videoid_from_url = function(url) {
					var regex = null;
					if (our_host === "xvideos") {
						regex = /:\/\/[^/]+\/+(?:video\.?|embedframe\/+)([0-9a-z]+)(?:\/+.*)?(?:[?#].*)?$/;
					} else if (our_host === "xnxx") {
						regex = /:\/\/[^/]+\/+video-([^-/._]+)\//;
					}
					if (!regex)
						return null;
					var match = url.match(regex);
					if (!match)
						return null;
					return match[1];
				};
				page_nullobj = {
					url: src,
					is_pagelink: true
				};
				id = get_videoid_from_url(src);
				if (id) {
					if (options.do_request && options.cb) {
						query_xvideos_page(id, options.cb);
						return {
							waiting: true
						};
					} else {
						return page_nullobj;
					}
				}
			}
			if ((host_domain_nowww === "xvideos.com" ||
				host_domain_nowww === "xvideos.xxx" ||
				host_domain_nowww === "xvideos.net" ||
				host_domain_nowww === "xvideos.es" ||
				host_domain_nowww === "xnxx.com" ||
				host_domain_nowww === "xnxx.es") &&
				options.element && options.do_request && options.cb) {
				var our_host = host_domain_nosub.replace(/\..*/, "");
				;
				var videoid_to_videourl = function(videoid) {
					if (our_host === "xvideos") {
						return "https://www.xvideos.com/video" + videoid + "/";
					} else if (our_host === "xnxx") {
						return "https://www.xnxx.com/video-" + videoid + "/";
					}
				};
				var get_videoid_from_url = function(url) {
					var regex = null;
					if (our_host === "xvideos") {
						regex = /:\/\/[^/]+\/+(?:video|embedframe\/+)([0-9]+)/;
					} else if (our_host === "xnxx") {
						regex = /:\/\/[^/]+\/+video-([^-/._]+)\//;
					}
					if (!regex)
						return null;
					var match = url.match(regex);
					if (!match)
						return null;
					return match[1];
				};
				var get_xvideos_vidid_from_el = function(el) {
					for (var current = el; current; current = current.parentElement) {
						if (current.tagName === "A") {
							var id = get_videoid_from_url(current.href);
							if (id) {
								return id;
							}
						}
					}
				};
				var vidid = get_xvideos_vidid_from_el(options.element);
				if (vidid) {
					return videoid_to_videourl(vidid);
				}
			}
			if (domain === "camo.derpicdn.net") {
				return decodeURIComponent(src.replace(/^[a-z]+:\/\/[^/]*\/[0-9a-f]+\?url=([^&]*).*?$/, "$1"));
			}
			if (domain === "live.store.cmcm.com") return src.replace(/(:\/\/[^/]*\/)[a-z]+\/(liveme\/)/, "$1$2");
			if (domain === "media.timeout.com") return src.replace(/(\/images\/[0-9]+\/)[0-9]+\/[0-9]+\/([^/]*)$/, "$1$2");
			if (domain_nowww === "tokkoro.com") return src.replace(/\/thumbs\//, "/picsup/");
			if (domain_nowww === "wallpapermaiden.com") {
				newsrc = src.replace(/(\/image\/[0-9]+\/[0-9]+\/[0-9]+\/[^/]*)-resized(\.[^/.]*)$/, "$1$2");
				if (newsrc !== src)
					return newsrc;
				id = src.replace(/(\/wallpaper\/[0-9]+\/)download\/[0-9]+x[0-9]+\/([^/]*)\.[^/.]*(?:[?#].*)?$/, "$1$2");
				if (id !== src &&
					options && options.cb && options.do_request) {
					options.do_request({
						url: id,
						method: "GET",
						onload: function(resp) {
							if (resp.readyState === 4) {
								var match = resp.responseText.match(/<meta *property="og:image" *content="([^"]*)"/);
								if (match) {
									options.cb(match[1]);
								} else {
									options.cb(null);
								}
							}
						}
					});
				}
			}
			if (domain_nosub === "pictoa.com" ||
				domain_nosub === "lilitube.com" ||
				domain_nosub === "heavenlynudes.net" ||
				domain_nosub === "nufap.com" ||
				domain_nosub === "fapsex.com" ||
				domain_nosub === "clickmyboobs.com" ||
				domain_nosub === "papajizz.com" ||
				domain_nosub === "babaporn.com") {
				newsrc = src.replace(/(\/[0-9a-f]{3}\/+[0-9a-f]{3}\/+[0-9a-f]+\/+)thumbs\/+([^/]*)(?:[?#].*)?$/, "$1$2");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/^([a-z]+:\/\/)t([0-9]*\.)/, "$1s$2");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nosub === "bbend.net" ||
				domain === "cdn.cnngreece.gr" ||
				domain_nowww === "funtime.gr" ||
				domain === "i.mommd.gr" ||
				domain === "i.rtpmd.gr" ||
				domain === "i.gosmd.gr" ||
				domain === "i.astmd.gr" ||
				domain === "i.onmmd.gr" ||
				domain === "i.lfmd.gr" ||
				domain === "i.qumd.gr") {
				newsrc = src
					.replace(/(\/media\/+.*\/+[0-9]{4}\/+(?:[0-9]{2}\/+){2}[0-9]+\/+)(?:facebook\/+facebook|(?:thumb|snapshot|facebook)\/+)/, "$1main/")
					.replace(/(\/media\/+.*\/+[0-9]{4}\/+(?:[0-9]{2}\/+){2}[0-9]+\/+photos\/+)[a-z]+\/+/, "$1full/");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "i.gosmd.gr") {
				if (/\/templates\/+gossip\/+images\/+placeholder\.jpg/.test(src))
					return {
						url: src,
						bad: "mask"
					};
			}
			if (domain === "static.fustany.com") {
				return {
					url: src.replace(/\/photo\/[a-z]+_([^/]*)$/, "/photo/$1"),
					headers: {
						Referer: "http://fustany.com/en/fashion/celebrity-style/front-row-celebrities-at-new-york-fashion-week-spring-2015"
					}
				};
			}
			if (domain_nosub === "protv.md" &&
				domain.match(/^assets[0-9]*\.protv/)) {
				return src
					.replace(/:\/\/[^/]*\/articles\/files\/thumbs\/[0-9]+x(?:[0-9]+)?(\/[0-9]+\.[^/.]*)$/, "://retete.perfecte.md/assets/articles/images/original$1")
					.replace(/\/articles\/+files\/+thumbs\/+[0-9]+x(?:[0-9]+)?\/+/, "/articles/images/original/");
			}
			if (domain_nowww === "bgol.us" ||
				domain_nowww === "defenceforumindia.com") {
				return decodeURIComponent(src.replace(/.*?\/forum\/proxy\.php.*?[?&]image=([^&]*).*?$/, "$1"));
			}
			if (domain === "resources.tidal.com") return src.replace(/\/[0-9]+x[0-9]+(\.[^/.]*)$/, "/origin$1");
			if (domain === "i.kfs.io") return src.replace(/\/(?:fit|cropresize)\/+[0-9]+x[0-9]+(\.[^/.]*)(?:[?#].*)?$/, "/original$1");
			if (domain_nosub === "fuskator.com") {
				return {
					url: src
						.replace(/(:\/\/[^/]*\/)small\//, "$1large/"),
					can_head: false
				};
			}
			if (domain === "ssref.net") {
				return decodeURIComponent(src.replace(/.*?\/image_resize\.cgi.*?[?&]url=([^&]*).*?$/, "$1"));
			}
			if (domain_nosub === "intermedia.ge" /* &&
				domain.match(/server[0-9]*\.intermedia\.ge/)*/) {
				return src
					.replace(/(\/article_images[0-9]*\/)[a-z]+\//, "$1large/")
					.replace(/\/pictures\/[a-z]+\//, "/pictures/original/");
			}
			if (domain_nowww === "sqshi.com") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/img\.php.*?[?&]imgurl=([^&]*).*?$/, "$1");
				if (newsrc !== src)
					return decodeuri_ifneeded(newsrc);
			}
			if (domain === "i.annihil.us") return src.replace(/(\/[0-9a-f]+\/)detail(\.[^/.]*)$/, "$1clean$2");
			if (domain === "pimg.mycdn.me" ||
				(domain_nosub === "sywcdn.net" && domain.match(/^s[0-9]*\./))) {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/getImage.*?[?&]url=([^&]*).*?$/, "$1");
				if (newsrc !== src)
					return decodeuri_ifneeded(newsrc);
			}
			if (domain_nowww === "dissidia-france.com") return src.replace(/\/small\/([^/]*)$/, "/big/$1");
			if (domain === "cdn.asiatatler.com" ||
				domain_nowww === "indonesiatatler.com") {
				return src.replace(/_(?:cropped|resized)_[0-9]+x[0-9]+(\.[^/.]*)$/, "$1");
			}
			if (domain_nosub === "stylowi.pl" &&
				domain.match(/^img[0-9]*\.stylowi\.pl/)) {
				return src.replace(/\/images\/items\/[a-z]\//, "/images/items/o/");
			}
			if (domain === "files.dals.media") return src.replace(/__[a-z]+__(\.[^/.]*)$/, "__original__$1");
			if (domain === "media.linkonlineworld.com") return src.replace(/\/img\/large\//, "/img/original/");
			if (amazon_container === "marieclairebucket") {
				return src.replace(/000[0-9]+?x[0-9]+(\.[^/.]*)$/, "000$1");
			}
			if (domain_nosub === "nh.ee" ||
				domain_nosub === "delphi.lv" ||
				domain_nosub === "delfi.ee" ||
				domain_nosub === "dcdn.lt") {
				return src.replace(/\/images\/pix\/[0-9]+x[0-9]+\//, "/images/pix/");
			}
			if (domain === "read.html5.qq.com" ||
				domain === "cdn.read.html5.qq.com") {
				return decodeURIComponent(src.replace(/^[a-z]+:\/\/[^/]*\/image.*?[?&]imageUrl=([^&]*).*?$/, "$1"));
			}
			if (domain === "img.chuansong.me" ||
				domain === "img.weiduba.net" ||
				(domain_nosub === "zx590.com" && domain.match(/^img[0-9]*\./)) ||
				(domain_nosub === "jinciwei.cn" && domain.match(/img[0-9]*\./))) {
				return src.replace(/:\/\/[^/]*\/(mmbiz(?:_[a-z]+)?)\//, "://mmbiz.qpic.cn/$1/");
			}
			if (domain === "cdn.iguang.co") return src.replace(/:\/\/[^/]*\/[0-9a-f]+\/(mmbiz(?:_[a-z]+)?)\//, "://mmbiz.qpic.cn/$1/");
			if (domain === "pic.kuaizhan.com") {
				return src.replace(/\/imageView\/v[0-9]*\/.*/, "");
			}
			if ((domain_nosub === "popcornnews.ru" && domain.match(/v[0-9]*\.popcornnews\.ru/)) ||
				domain === "static.kinoafisha.info") {
				return src
					.replace(/(:\/\/[^/]*\/+)k\/+[a-z_]+\/+[0-9]+(?:x[0-9]+)?\/+upload\//, "$1upload/")
					.replace(/(:\/\/[^/]*\/+upload\/+)_[0-9]+_[0-9]+_[0-9]+_([^/_.]*\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			}
			if (domain_nowww === "amorq.com" ||
				domain_nowww === "prikolno.cc" ||
				domain_nowww === "interesno.cc" ||
				domain_nowww === "obaldenno.com") {
				return src.replace(/\/uploads\/tumb(\/[a-z]+\/[0-9]+\/[^/.]+)_tumb_[0-9]+(\.[^/.]*)$/, "/uploads$1$2");
			}
			if (domain_nosub === "pinme.ru" &&
				domain.match(/^cdn/)) {
				return src.replace(/\/+tumb\/+[0-9]+\/+photo\//, "/photo/");
			}
			if (domain_nosub === "kakprosto.ru") return src.replace(/\/tumb\/+[0-9]+\/+images\//, "/images/");
			if (domain_nosub === "postila.ru" &&
				domain.match(/^img[0-9]*\.postila\.ru/)) {
				return urljoin(src, decodeURIComponent(src.replace(/^[a-z]+:\/\/[^/]*\/resize.*?[?&]src=([^&]*).*?$/, "$1")), true);
			}
			if (domain_nowww === "enolivier.com" ||
				domain_nowww === "fotoventasdigital.com") {
				return src.replace(/\/_thumb\/([^/]*)_[0-9]+x[0-9]+(\.[^/.]*)$/, "/_fullsize/$1$2");
			}
			if (domain === "ss.metronews.ru" ||
				domain === "ss.sport-express.ru") {
				return src.replace(/(\/userfiles\/materials\/[0-9]+\/[0-9]+\/)(?:[0-9]+x[0-9]+|[a-z]+)(\.[^/.]*)$/, "$1origin$2");
			}
			if (domain_nosub === "mtvnimages.com" ||
				domain === "images.paramount.tech" ||
				domain === "imagesmtv-a.akamaihd.net") {
				newsrc = remove_queries(src, ["quality", "width", "height", "crop", "legacyStatusCode", "gen"]);
				if (newsrc !== src) {
					return {
						url: newsrc,
						can_head: false
					};
				}
				newsrc = src.replace(/\?.*$/, "");
				if (false && newsrc !== src) {
					return {
						url: newsrc,
						can_head: false
					};
				}
			}
			if (domain_nosub === "mtvnimages.com" ||
				domain === "imagesmtv-a.akamaihd.net") {
				return src.replace(/^[a-z]+:\/\/[^/]*\/uri\/mgid:file:(https?):shared:([^/:]*\/)/, "$1://$2");
			}
			if (domain_nowww === "vh1.com") {
				return {
					url: src,
					can_head: false
				};
			}
			if (domain === "user-uploads.aznude.com") return src.replace(/(:\/\/[^/]*\/data\/)thumbs\//, "$1azncdn/");
			if (domain_nosub === "aznude.com" && /^cdn[0-9]*\./.test(domain)) {
				newsrc = src.replace(/\/antibandit\/+([^/]+\/+[^/]+\/+)thumb[0-9]+_/, "/$1");
				if (newsrc !== src)
					return newsrc;
				regex = /(:\/\/[^/]+\/+(?:[^/]+\/+){2}[^/]+)-(?:lo|hi)(\.[^/.]+)(?:[?#].*)?$/;
				if (regex.test(src)) {
					return [
						src.replace(regex, "$1-hd$2"),
						src.replace(regex, "$1-hi$2")
					];
				}
			}
			if (domain_nowww === "bstars.eu" ||
				domain_nowww === "wstars.net" ||
				domain_nowww === "bstars.ru") {
				return src
					.replace(/(\/media\/+djcatalog2\/+images\/+item\/+[0-9]+\/+[^/]+\.[0-9]+)_[a-z](\.[^/.]*)$/, "$1$2")
					.replace(/(\/media\/+djcatalog2\/+images\/+[^/]+)_[a-z](\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			}
			if (domain === "media.toofab.com" ||
				domain === "toofab.akamaized.net") { // doesn't work for all urls
				src = src.replace(/-[0-9]+w\.([^/.]*)/, ".$1");
				src = src.replace(/-[0-9]+x[0-9]+\.([^/.]*)/, ".$1");
				return src;
			}
			if (domain === "thumb.tvpalace.org") return src.replace(/\/[wh][0-9]+_([^/]*\.[^/.]*)$/, "/$1");
			if (domain_nowww === "mafab.hu") return src.replace(/\/static\/thumb\/[wh][0-9]+\//, "/static/");
			if (domain === "film.kinootziv.com" ||
				(domain_nosub === "moviesfan.org" && domain.match(/^static/)) ||
				domain_nowww === "kinokach.com") {
				return src.replace(/(:\/\/[^/]*\/source\/files\/[^/]*)_thumbs\//, "$1/");
			}
			if (amazon_container === "harmony-assets-live") {
				return {
					src: url,
					can_head: false
				};
			}
			if (domain === "cdn.kme.si") return src.replace(/\/public\/images-cache\/[0-9X]+x[0-9X]+\/([0-9]+\/[0-9]+\/[0-9]+\/)[0-9a-f]+\/[0-9a-f]+\/([0-9a-f]+\.[^/.]*)$/, "/public/images/$1$2");
			if (domain_nosub === "slidely.com" &&
				domain.match(/cdn\.slidely\.com$/)) {
				return src.replace(/^[a-z]+:\/\/[^/]*\/img-proxy\//, "http://");
			}
			if (domain_nosub === "hochu.ua") return src.replace(/\/thumbnails\/articles\/crop[a-z]*_[0-9]+x[0-9]+\//, "/images/articles/");
			if (domain === "media.professionali.ru") return src.replace(/(\/processor\/[a-z]+\/)[^/]*\//, "$1original/");
			if (domain_nowww === "stars-naked.ru") return src.replace(/(:\/\/[^/]*\/pictures\/[^/]*\/)[^/]*\/[a-z]+_([^/]*)$/, "$1$2");
			if (domain_nowww === "avsforum.com" ||
				domain_nowww === "sitcomsonline.com") {
				return src.replace(/(\/photopost\/data\/[0-9]+\/)(?:thumbs|medium)\//, "$1");
			}
			if (domain_nowww === "pgmscreen.fr") {
				newsrc = decodeURIComponent(src.replace(/^[a-z]+:\/\/[^/]*\/(?:protect|watermark)\.php.*?[?&]src=([^&]*).*?$/, "$1"));
				if (newsrc !== src)
					return newsrc;
				return src.replace(/\/galerie\/[a-z]+\/[a-z]+-/, "/galerie/grande/max-");
			}
			if (domain === "celeb.gate.cc" ||
				domain_nowww == "celebgate.org") {
				return src.replace(/(:\/\/[^/]*\/+media\/+cache\/+)[a-z]+\/+upload\//, "$1image/upload/");
			}
			if (domain_nowww === "modagid.ru") return src.replace(/(\/files\/photos\/imgs\/[0-9]+\/[0-9]+\/)[a-z]+_/, "$1original_");
			if (domain_nowww === "zdf.de" &&
				string_indexof(src, "/assets/") >= 0) {
				return src.replace(/~[0-9]+x[0-9]+([?#].*)?$/, "~original$1");
			}
			if (domain_nowww === "arcinfo.ch" ||
				domain_nowww === "lacote.ch") {
				return src.replace(/(\/media\/image\/[0-9]*\/)[^/]*\/([0-9]+-[0-9]+\.[^/.]*)$/, "$1$2");
			}
			if (domain_nowww === "gulf365.co" ||
				domain_nosub === "mogaznews.com" ||
				domain_nowww === "ksa-press.com" ||
				domain_nowww === "news-sinaa.com" ||
				domain_nowww === "akherkhabrtoday.com" ||
				domain_nowww === "arabyoum.com" ||
				domain_nowww === "uk-arabicnews.com" ||
				domain_nowww === "alsharqtimes.com" ||
				domain_nowww === "news.fox-24.com" ||
				src.match(/^[a-z]+:\/\/[^/]*\/temp\/+(?:thumb|resized)\/+(?:small|medium|[0-9]+x[0-9]+)_[0-9]{4}-[0-9]{2}-[0-9]{2}-[0-9a-f]{10}\.[^/._]+(?:[?#].*)?$/) ||
				src.match(/^[a-z]+:\/\/[^/]*\/temp\/+(?:thumb|resized)\/+(?:small|medium|[0-9]+x[0-9]+)_uploads,[0-9]{4},[0-9]{2},[0-9]{2},[0-9a-f]{10}\.[^/._]+(?:[?#].*)?$/)) {
				return src
					.replace(/(\/)temp\/(?:thumb|resized)\/[^-/_.]+_uploads,([0-9]+),([0-9]+),([0-9]+),([0-9a-f]+\.[^/.]*)$/, "$1content/uploads/$2/$3/$4/$5")
					.replace(/(\/)temp\/(?:thumb|resized)\/[a-z]+_([0-9]+)-([0-9]+)-([0-9]+)-([0-9a-f]+\.[^/.]*)$/, "$1content/uploads/$2/$3/$4/$5");
			}
			if (domain_nowww === "aljazeera.com") return src.replace(/\/mritems\/imagecache\/[^/]*\/mritems\//, "/mritems/");
			if (domain === "media.publika.md" ||
				domain === "media.dcbusiness.ro" ||
				domain === "media.realitatea.net" ||
				domain === "media.feminis.ro") {
				return src.replace(/(\/image\/+[0-9]{6}\/)+w[0-9]+(?:h[0-9]+)?\/+/, "$1full/");
			}
			if (domain === "images.tagesschau.de") return src.replace(/(\/image\/+[-0-9a-f]{10,}\/+[^/]+\/+[^/]+\/+)[^/]+\/+([^/]+)(?:[?#].*)?$/, "$1original/$2");
			if (domain === "www1.wdr.de" ||
				domain === "kinder.wdr.de" ||
				domain_nowww === "tagesschau.de" ||
				domain_nowww === "hr.de") {
				return {
					url: src.replace(/~(?:_t-[0-9]+)?_v-[a-zA-Z0-9]+(\.[^/.]*)$/, "~_v-original$1"),
					can_head: false // wrong content-type
				};
			}
			if (domain_nowww === "xrimaonline.gr" ||
				domain_nowww === "athensmagazine.gr" ||
				domain_nowww === "digalakis.com" ||
				domain_nowww === "youweekly.gr" ||
				src.match(/^[a-z]+:\/\/[^/]+\/+photos\/+[wc]_[0-9]+px(?:_[0-9]+px)?\/+(?:products|articles)\//)) {
				return src.replace(/\/photos\/+[a-z]_[0-9]+px[^/]*\/+([^/]+)\//, "/photos/master/$1/");
			}
			if (domain_nosub === "avisen.dk" &&
				domain.match(/^media[0-9]*\.avisen\.dk/)) {
				return src.replace(/([?&]sizeid=)[0-9]+/, "$1255");
			}
			if (domain_nowww === "elimparcial.es" &&
				string_indexof(src, "/fotos/") >= 0) {
				return src.replace(/_thumb_[0-9]+(\.[^/.]*)$/, "$1");
			}
			if (domain_nosub === "agora.md" &&
				domain.match(/^st[0-9]*\.agora\.md/)) {
				return src.replace(/(:\/\/[^/]*\/news\/)[a-z]+\//, "$1big/");
			}
			if (domain_nowww === "demokrathaber.org") return src.replace(/\/images\/resize\/[0-9]+\/[0-9]+x[0-9]+\//, "/images/");
			if (domain === "imgl.krone.at") return src.replace(/(\/scaled\/[0-9]+\/[0-9a-z]+\/)[0-9]+x[0-9]+((?:\.[^/.]+)?(?:[?#].*)?)?$/, "$1full$2");
			if (domain_nowww === "elfinanciero.com.mx" &&
				string_indexof(src, "/uploads/") >= 0) {
				return src.replace(/(\/[0-9a-f]+)_[a-z_]+(\.[^/.]*)$/, "$1$2");
			}
			if (domain_nosub === "redcdn.pl" &&
				string_indexof(domain, "dcs.redcdn.pl") >= 0) {
				return src.replace(/(:\/\/[^/]*\/)scale(\/.*?)(?:[?#].*)?$/, "$1dcs/$2");
			}
			if (domain === "media.nu.nl") return src.replace(/(:\/\/[^/]*\/+m\/+[0-9a-z]+)_[0-9a-z]+(\.[^/.]*)?(\/[^/]*\.[^/.]*)?$/, "$1$2$3");
			if (domain === "cloudia.hnonline.sk" ||
				domain === "img.joj.sk") {
				return src.replace(/(:\/\/[^/]*\/)[a-z]?[0-9]*x[0-9]*[a-z]?\/([-0-9a-f]+(?:\.[^/.]*?)?)(?:\?.*)?$/, "$1$2");
			}
			if (googlestorage_container === "nana10img") {
				return src.replace(/\/crop\/(?:_[a-z]-[0-9]+){1,}\/images\//, "/images/");
			}
			if ((domain_nowww === "webnews.bg" ||
				domain === "static.webcafe.bg" ||
				domain === "static.dir.bg") &&
				string_indexof(src, "/uploads/images/") >= 0) {
				return src.replace(/\/[0-9]+x(?:[0-9]+)?(\.[^/.]*)$/, "/orig$1");
			}
			if (domain === "static.ffx.io") {
				return {
					url: src.replace(/\/images\/\$[^/]*\/.*\/([0-9a-f]+)([?#].*)?$/, "/images/$1$2"),
					can_head: false // 404 for some images
				};
			}
			if (domain === "images.stv.tv") return src.replace(/\/articles\/[wh][0-9]+(?:xh[0-9]+)?(?:xm[^/]*)?\/([^/]*)$/, "/articles/master/$1");
			if (domain === "cdn.cretalive.gr") return src.replace(/(:\/\/[^/]*\/)_[a-z]+Image\//, "$1");
			if (domain === "img.budgettravel.com") return src.replace(/(:\/\/[^/]+\/+)_[a-zA-Z]+\/+/, "$1");
			if (amazon_container === "festivalkontoret") {
				return src.replace(/\/_[a-zA-Z]+\/+([^/]+)$/, "/$1");
			}
			if ((domain_nosub === "ellingtoncms.com" &&
				domain.match(/\.media\.clients\.ellingtoncms\.com$/)) ||
				domain === "media.lasvegasweekly.com" ||
				domain === "media.spokesman.com") {
				return src.replace(/_t[0-9]*(?:x[0-9]+)?(\.[^/.]*)$/, "$1");
			}
			if (domain === "ajo.prod.reuters.tv") return src.replace(/(\/img\/[0-9a-f]+-[0-9]+).*?[?&](location=[^&]*).*?$/, "$1?$2");
			if (domain_nowww === "nos.nl" ||
				domain === "cdn.nos.nl" ||
				domain === "assets.nos.nl") {
				return src.replace(/(\/image\/+[0-9]{4}\/+(?:[0-9]{2}\/+){2}[0-9]+\/+)(?:[a-z]+|[0-9]+x[0-9]+[a-z]*)(\.[^/.]+)(?:[?#].*)?$/, "$1original$2");
			}
			if (domain_nowww === "braunschweiger-zeitung.de" ||
				domain === "img.derwesten.de" ||
				domain_nowww === "thueringen24.de" ||
				domain_nowww === "helmstedter-nachrichten.de") {
				return src.replace(/\/img\/(?:panorama|welt|landsberg)\/crop([0-9]+)\/.*(\.[^/.]*)$/, "/bin/src-$1$2");
			}
			if (domain === "iprx.ten.com.au") {
				return decodeURIComponent(src.replace(/^[a-z]+:\/\/[^/]*\/ImageHandler\.ashx.*?[?&]u=([^&]*).*?$/, "$1"));
			}
			if (domain === "images.sudouest.fr") return src.replace(/(\/[0-9a-f]+\/)[a-z]+\/[0-9]+x[0-9]+\/([^/]*)$/, "$1$2");
			if (domain === "gdb.rferl.org" ||
				domain === "gdb.voanews.com" ||
				domain === "gdb.alhurra.eu" ||
				domain === "gdb.rferl.org" ||
				domain === "gdb.radiosawa.us") {
				return src.replace(/(:\/\/[^/]*\/+[-0-9A-Fa-f]+)(?:_c?[a-z][0-9]*){1,}(\.[^/.]*)$/, "$1$2");
			}
			if (domain === "img.nzz.ch") return src.replace(/^[a-z]+:\/\/[^/]+\/+(?:[A-Z]=[^/]+\/+){1,}(https?:\/\/)/, "$1");
			if (domain === "images-cdn.impresa.pt" ||
				domain === "images.impresa.pt") {
				newsrc = src
					.replace(/\/(?:[0-9]+x[0-9]+|original)\/+m[wh]-[0-9]+(?:\?.*)?$/, "/original")
					.replace(/\?.*/, "");
				if (newsrc !== src)
					return newsrc;
				obj = {
					url: src,
					head_wrong_contentlength: true
				};
				match = src.match(/^[a-z]+:\/\/[^/]+\/+[a-z]+\/+([^/]+\.[^/.]*?)(?:-[0-9])?\/original/);
				if (match) {
					obj.filename = match[1];
				}
				return obj;
			}
			if (domain === "awsimages.detik.net.id" ||
				domain === "akcdn.detik.net.id") {
				if (src.match(/\/customthumb\//)) {
					return src.replace(/\?.*/, "");
				}
				newsrc = src.replace(/(\/community\/+media\/+visual\/+[0-9]{4}\/+(?:[0-9]{2}\/+){2}[-0-9a-f]{20,})_[0-9]+\./, "$1.");
				if (newsrc !== src)
					return newsrc;
				return src.replace(/(?:\?.*)?$/, "?a=1");
			}
			if (domain_nowww === "sexhd.pics" ||
				domain_nowww === "sexphotos.pw" ||
				domain_nosub === "yespornpics.com" ||
				domain_nowww === "babe.today" ||
				domain_nowww === "xxxporn.pics" ||
				domain_nosub === "jjgirls.com") {
				newsrc = src
					.replace(/(:\/\/[^/]*\/)photo(\/.*\/)hd-([^/]*)$/, "$1gallery$2$3")
					.replace(/(:\/\/[^/]*\/)image(\/.*\/)hd-([^/]*)$/, "$1xxx$2$3")
					.replace(/(:\/\/[^/]*\/)(?:thumbs|pictures)(\/.*\/)hd-([^/]*)$/, "$1pictures$2$3")
					.replace(/(:\/\/[^/]*\/)thumb(\/.*\/)hd-([^/]*)$/, "$1media$2$3")
					.replace(/(:\/\/[^/]*\/)pic(\/.*\/)hd-([^/]*)$/, "$1pics$2$3");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nowww === "nakedwench.com") return src.replace(/(\/galleries\/+[0-9]{4}\/+[^/]*\/+)thumbnail([0-9]+\.[^/.]*)(?:[?#].*)?$/, "$1middle$2");
			if (domain === "pics.tubetubetube.com" ||
				domain === "pics.javbtc.com") {
				return src.replace(/(:\/\/[^/]*\/)thumbs(\/.*\/)hd-([^/]*)$/, "$1pornpics$2$3");
			}
			if (domain_nowww === "jav.gallery" ||
				domain_nowww === "javpics.com" ||
				domain_nowww === "javpornpics.com" ||
				domain_nowww === "javhd.pics" ||
				domain_nowww === "jav.photos") {
				var thumbdir = null;
				var fulldir = null;
				if (domain_nowww === "jav.gallery") {
					thumbdir = "photo";
					fulldir = "pics";
				} else if (domain_nowww === "jav.photos") {
					thumbdir = "pics";
					fulldir = "pictures";
				} else if (domain_nowww === "javpics.com") {
					thumbdir = "xxx";
					fulldir = "images";
				} else if (domain_nowww === "javhd.pics" ||
					domain_nowww === "javpornpics.com") {
					thumbdir = "media";
					fulldir = "photos";
				}
				if (thumbdir && fulldir) {
					regex = new RegExp("(:\/\/[^/]*\/)" + thumbdir + "(\/.*\/)(?:u?hd|pin)-([^/]*)(?:[?#].*)?$");
					return src.replace(regex, "$1" + fulldir + "$2$3");
				}
			}
			if (domain_nowww === "pornpics.vip") return src.replace(/(\/xxx\/.*\/)hd-([^/]+)(?:[?#].*)?$/, "$1$2");
			if (domain_nowww === "purejapanese.com" ||
				domain_nowww === "jjgirls.com" ||
				domain_nowww === "1pondo.com" ||
				domain_nowww === "asiauncensored.com" ||
				domain_nowww === "69dv.com" ||
				domain_nowww === "japanesethumbs.com" ||
				domain === "img.yavtube.com" ||
				domain_nowww === "javtube.com") {
				newsrc = src.replace(/(:\/\/[^/]*\/)(pic|tokyo(?:pic|sex)|uncensored|javmodel|japansex|heydouga|jav|japanese(?:girl)?)(\/.*\/)cute-([^/]*)$/, "$1$2$3$4");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nowww === "jjgirls.com") {
				return src
					.replace(/(\/photo\/+[^/]*\/+[^/]*\/+[^/]*\/+[0-9]+)t(\.[^/.]*)(?:[?#].*)?$/, "$1$2")
					.replace(/(\/photo\/+[^/]*\/+[^/]*\/+[^/]*\/+[^/]*)_small(\.[^/.]*)(?:[?#].*)?$/, "$1$2")
					.replace(/(\/photo\/+[^/]+\/+[^/]+\/+[0-9]+\/+)tn([0-9]+\.[^/.]+)(?:[?#].*)?$/, "$1$2")
					.replace(/(\/photo\/+watch4beauty\/+.*\/+)thumbnail([0-9]+\.[^/.]*)(?:[?#].*)?$/, "$1middle$2");
				;
			}
			if (domain_nowww === "javbtc.com") return src.replace(/(:\/\/[^/]*\/)media(\/.*\/)hd-([^/]*)$/, "$1photos$2$3");
			if (domain_nowww === "japanesebeauties.net") return src.replace(/\/media\/+(.*\/)hd-([^/]*)(?:[?#].*)?$/, "/$1$2");
			if (domain_nowww === "tubetubetube.com") return src.replace(/(:\/\/[^/]*\/)media(\/.*\/)(?:u?hd|pin)-([^/]*)$/, "$1pics$2$3");
			if (domain_nowww === "nuceleb.ru") return src.replace(/(\/assets\/images\/resources\/[0-9]+\/)[0-9]+x[0-9]+\/([^/]*)$/, "$1$2");
			if (domain_nosub === "imgserve.net") {
				return {
					url: src.replace(/(:\/\/[^/]*\/)images\/[a-z]+\//, "$1images/big/"),
					headers: {
						Referer: src
					}
				};
			}
			if (domain === "image.celebrityrave.com") return src.replace(/(\/[0-9a-f]*)-[0-9a-z]+(\.[^/.]*)$/, "$1$2");
			if (domain === "photo.addyoursex.com") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/remote_control\.php.*?[?&]file=([^&]*).*?$/, "$1");
				if (newsrc !== src)
					return urljoin(src, decodeURIComponent(newsrc), true);
			}
			if (domain_nowww === "nudogram.com") {
				newsrc = src.replace(/(\/contents\/+.\/+.\/+[^/]+\/+[0-9]+\/+[^/]+)_280\./, "$1.");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "statics.cdntrex.com" ||
				domain_nowww === "anon-v.com" ||
				domain_nowww === "break.ie" ||
				domain_nowww === "xcadr.org" ||
				domain_nowww === "fitting-room.com" ||
				domain_nowww === "camwhoreshd.com" ||
				domain_nowww === "cwtvembeds.com" ||
				domain_nosub === "camwhores.tv" ||
				domain_nowww === "camwhoresbay.com" ||
				domain_nowww === "asianleak.com" ||
				domain_nosub === "zbporn.tv" ||
				domain_nosub === "zbporn.com" ||
				domain_nowww === "dato.porn" ||
				domain_nowww === "smutr.com" ||
				domain_nosub === "fapster.xxx" ||
				domain_nowww === "bogmedia.org" ||
				domain_nowww === "femdomtb.com" ||
				domain_nowww === "solopornoitaliani.xxx" ||
				domain_nowww === "mature-porn.xxx" ||
				domain_nowww === "camhub.cc" ||
				domain_nowww === "camhub.world" ||
				domain_nowww === "zzpornozz.xyz" ||
				domain_nowww === "hiddencam.tv" ||
				domain_nowww === "mypornhere.com" ||
				(domain_nowww === "mvpchannel.net" && string_indexof(src, "/tube/") >= 0) ||
				domain_nowww === "gaythebest.com" ||
				domain_nosub === "watchmygf.me" ||
				domain_nosub === "yeswegays.com" ||
				domain_nowww === "mytradevideo.com" ||
				domain_nosub === "boundhub.com" ||
				domain_nowww === "youhealthtube.com" ||
				domain_nowww === "mywebgirls.tv" ||
				domain_nowww === "thebestshemalevideos.com" ||
				domain_nosub === "katestube.com" ||
				domain_nowww === "nudogram.com" ||
				domain_nosub === "analdin.com" ||
				domain_nosub === "tube-bunny.com" ||
				domain_nowww === "blackporn24.com" ||
				domain_nosub === "pornwhite.com" ||
				domain_nosub === "sleazyneasy.com" ||
				domain_nosub === "vikiporn.com" ||
				domain_nosub === "sheshaft.com" ||
				domain_nosub === "xozilla.com" ||
				domain_nosub === "xtits.com" ||
				domain_nosub === "wankoz.com" ||
				domain_nosub === "fetishshrine.com" ||
				domain_nowww === "x18.xxx" ||
				domain_nosub === "mt-static.com" ||
				domain_nosub === "megatube.xxx" ||
				domain_nosub === "slutload-media.com" ||
				domain_nowww === "porngem.com" ||
				domain_nowww === "uiporn.com" ||
				domain_nosub === "pornicom.com" ||
				domain_nosub === "youx.xxx" ||
				domain_nosub === "pornalin.com" ||
				domain_nosub === "cartoontube.xxx" ||
				domain_nowww === "amateurporn.me" ||
				domain_nowww === "hardsexvids.com" ||
				domain_nosub === "sexvid.xxx" ||
				domain_nosub === "its.porn" ||
				domain === "itsporn.woxcdn.com" ||
				domain_nosub === "frprn.com" ||
				domain_nosub === "japan-whores.com" ||
				domain_nosub === "pornid.xxx" ||
				domain_nosub === "mypornhere.com" ||
				domain_nosub === "pornhat.com" ||
				domain_nosub === "camshooker.com" ||
				domain_nosub === "cambro.tv" ||
				domain_nosub === "camseek.tv" ||
				domain_nowww === "camvideos.tv" ||
				domain_nosub === "anysex.com" ||
				domain_nosub === "mrdeepfakes.com" ||
				domain_nosub === "pornktu.be" ||
				domain_nosub === "3movs.com" ||
				domain_nosub === "sunporno.com" ||
				domain_nosub === "xcafe.com" ||
				domain_nowww === "18fuck.me" ||
				domain_nowww === "my18pussy.com" ||
				domain_nowww === "freepornvideo.sex" ||
				domain_nosub === "sexroom.xxx" ||
				domain_nosub === "porno666.cam" ||
				domain_nosub === "pornfappy.com" ||
				domain_nosub === "aporn.xxx" ||
				domain_nosub === "fapteentube.net" ||
				domain_nosub === "xxxsextube.tv" ||
				domain_nosub === "camfz.com" ||
				domain_nowww === "camclips.tv" ||
				domain_nowww === "tubedupe.com" ||
				domain_nosub === "stfucdn.com" ||
				domain_nosub === "porntn.com" ||
				domain_nosub === "tolkorus.info" ||
				domain_nosub === "pornozavod.cc" ||
				domain_nosub === "onlineporno.cc" ||
				domain_nosub === "prostoporno.help" ||
				domain === "jb503wdraf.ent-cdn.com" ||
				domain_nosub === "freehardcore.com" ||
				domain === "b3bepw16kz.ent-cdn.com" ||
				domain_nowww === "asianpornvideo.xxx" ||
				domain_nowww === "18pussy.porn" ||
				domain_nowww === "fuckteen.xxx" ||
				domain_nowww === "japanporn.tv" ||
				domain_nowww === "18teenporno.tv" ||
				domain_nowww === "japaneseporn.xxx" ||
				domain_nowww === "hdteen.porn" ||
				domain_nowww === "indiansexvideo.xxx" ||
				domain_nosub === "theyarehuge.com" ||
				domain_nosub === "videocelebs.net" ||
				domain_nowww === "mangovideo.club" ||
				domain_nosub === "xmegadrive.com" ||
				domain_nosub === "deviants.com" ||
				domain_nosub === "cuckoldplacetube.com" ||
				domain_nosub === "alphaporno.com" ||
				domain_nosub === "fapality.com" ||
				domain_nowww === "freeporn8.com" ||
				(domain_nosub === "b-cdn.net" && /^(18yos|amateurporn(?:girlfriends|tape|vidz|wives)|analcuties|asian(?:cuties|teens)|boombj|brosislove|cuteasians|d1ck|d1rty|extremejapanese|faphard(?:er)?|fi1thy|f1ix|fl1rt|freexxxhardcore|hard(?:(?:core)?teens|family|jap|milfs|moms)|hotmature|japteens|k1nk|milfz|porn(?:ouploads|n|r[yz])|roleplayers|taboofamily|teenanal|twistednuts|wanktank|extremeteens)\./.test(domain)) ||
				domain_nosub === "hardmoms.co" ||
				domain_nosub === "d1ck.co" ||
				domain_nosub === "twistednuts.com" ||
				domain_nosub === "f1ix.com" ||
				domain_nosub === "18yos.co" ||
				domain_nosub === "amateurporngirlfriends.com" ||
				domain_nosub === "amateurporntape.com" ||
				domain_nosub === "amateurpornvidz.com" ||
				domain_nosub === "amateurpornwives.com" ||
				domain_nosub === "analcuties.co" ||
				domain_nosub === "asian-cuties.com" ||
				domain_nosub === "asian-teens.co" ||
				domain_nosub === "boombj.com" ||
				domain_nosub === "brosislove.com" ||
				domain_nosub === "cuteasians.co" ||
				domain_nosub === "d1rty.com" ||
				domain_nosub === "extremejapanese.co" ||
				domain_nosub === "faphard.co" ||
				domain_nosub === "fapharder.com" ||
				domain_nosub === "fi1thy.com" ||
				domain_nosub === "fl1rt.com" ||
				domain_nosub === "freexxxhardcore.com" ||
				domain_nosub === "hardcoreteens.co" ||
				domain_nosub === "hardfamily.co" ||
				domain_nosub === "hardjap.co" ||
				domain_nosub === "hardmilfs.co" ||
				domain_nosub === "hardteens.co" ||
				domain_nosub === "hotmature.co" ||
				domain_nosub === "japteens.co" ||
				domain_nosub === "k1nk.co" ||
				domain_nosub === "milfz.co" ||
				domain_nosub === "pornouploads.com" ||
				domain_nosub === "pornn.co" ||
				domain_nosub === "pornry.com" ||
				domain_nosub === "pornrz.com" ||
				domain_nosub === "roleplayers.co" ||
				domain_nosub === "taboofamily.co" ||
				domain_nosub === "teenanal.co" ||
				domain_nosub === "wanktank.co" ||
				domain_nosub === "extremeteens.co" ||
				domain_nowww === "thothub.lol" ||
				domain_nowww === "thothub.to" ||
				domain_nowww === "thothub.tube" ||
				domain_nowww === "thothub.is" ||
				domain_nowww === "cartoon-sex.tv" ||
				domain_nowww === "cartoonporn.pro" ||
				domain_nosub === "love4porn.com" ||
				domain_nosub === "hoes.tube" ||
				domain_nosub === "hqbang.com" ||
				domain_nosub === "porndr.com" ||
				domain_nosub === "pervclips.com" ||
				domain_nosub === "fapnado.xxx" ||
				domain_nosub === "homemade.xxx" ||
				domain_nosub === "xgroovy.com" ||
				domain_nosub === "jizzberry.com" ||
				domain_nosub === "alotporn.com" ||
				domain_nosub === "analdin.xxx" ||
				domain_nosub === "4kporn.xxx" ||
				domain_nosub === "xozilla.xxx" ||
				domain_nosub === "xxxshake.com" ||
				domain_nosub === "fapnow.xxx" ||
				domain_nosub === "4wank.com" ||
				domain_nosub === "fapnado.com" ||
				domain_nosub === "crazyporn.xxx" ||
				domain_nowww === "thisvid.com" ||
				domain_nowww === "amateur8.com" ||
				domain_nowww === "fpo.xxx" ||
				domain_nosub === "mylust.com" ||
				domain_nosub === "yourlust.com" ||
				domain_nowww === "pornrewind.com") {
				if (/\/(?:kt_)?player\/+skin\/+img\//.test(src) ||
					/\/images\/+title_icon\./.test(src))
					return {
						url: src,
						bad: "mask"
					};
				page_nullobj = null;
				var is_pagelink = false;
				id = null;
				match = src.match(/\/(?:videos_(?:screenshots|sources)|v?th|kvs|videos\/+th)\/+[0-9]+\/+([0-9]+)\/+(?:(?:[0-9]+x[0-9]+|screenshots)\/+|preview(?:mp4_hd|_(?:trailer|[0-9]+p?|[hn]|embed_[0-9]+p))?\.)/);
				if (!match) {
					match = src.match(/\/get_file\/+[0-9a-f]+\/+[0-9a-f]{30,}\/+[0-9a-f]\/+([0-9]+)\/+screenshots\/+/);
				}
				if (!match) {
					match = src.match(/(?:\/get_file\/+[0-9a-f]+\/+[0-9a-f]{30,}|:\/\/[^/]+)\/+[0-9]+\/+[0-9]+\/+([0-9]+)_preview\./);
				}
				if (!match) {
					match = src.match(/\/(?:contents|c1)\/+videos\/+[0-9]+\/+[0-9]+\/+([0-9]+)(?:_(?:short|small))?_(?:preview|tr)\./);
				}
				if (!match) {
					match = src.match(/\/storage[0-9]*\/+([0-9a-zA-Z]+)\/+(?:[0-9]+|default)\./);
				}
				if (match) {
					id = match[1];
				} else {
					match = src.match(/^[a-z]+:\/\/[^/]+\/+(?:(?:(?:tube\/+)?v(?:id(?:eo)?s?)?|embed)\/+(?:([0-9]+)(?:\/+[^/]+)?|([^/]+))\/*)?(?:[?#].*)?$/);
					if (!match) {
						if (domain_nowww === "pornid.xxx") {
							match = src.match(/^[a-z]+:\/\/[^/]+\/+([^/.]{20,})\.html(?:[?#].*)?$/);
						} else if (domain_nosub === "cartoon-sex.tv") {
							match = src.match(/^[a-z]+:\/\/[^/]+\/+video\/+([^/.]+)\.html(?:[?#].*)?$/);
						} else if (domain_nosub === "alotporn.com" || domain_nosub === "xcafe.com") {
							match = src.match(/^[a-z]+:\/\/[^/]+\/+([0-9]+)\/+(?:[^/]+\/*)?(?:[?#].*)?$/);
						}
					}
					if (match) {
						id = match[1] || match[2];
						is_pagelink = true;
						page_nullobj = {
							url: src,
							is_pagelink: true
						};
					}
				}
				var basedomain = "https://www." + domain_nosub + "/";
				var base_component = "";
				var videos_component = "videos";
				var videos_slash = "/";
				var addslash = "/";
				var a_component = "/a";
				var idprefix = "";
				var can_detect_videourl = true;
				var cache_host = domain_nosub;
				var can_add_referer_1 = true;
				if (domain_nosub === "porntrex.com" || domain_nosub === "cdntrex.com") {
					basedomain = "https://www.porntrex.com/";
					cache_host = "porntrex.com";
					videos_component = "video";
					addslash = "";
				} else if (domain_nosub === "porntb.com" ||
					domain_nosub === "pornstarsadvice.com" ||
					domain_nosub === "fetishburg.com" ||
					domain_nosub === "camhub.cc" ||
					domain_nosub === "mytradevideo.com" ||
					domain_nosub === "japan-whores.com" ||
					domain_nosub === "camshooker.com" ||
					domain_nosub === "aporn.xxx" ||
					domain_nosub === "camwhoreshd.com" ||
					domain_nosub === "mywebgirls.tv") {
					basedomain = "http://www." + domain_nosub + "/";
				} else if (domain_nosub === "tolkorus.info") {
					basedomain = "http://" + domain_nosub + "/";
				} else if (domain_nosub === "smutr.com") {
					videos_component = "v";
					a_component = "";
				} else if (domain_nosub === "mature-porn.xxx") {
					videos_component = "v";
					addslash = "";
					basedomain = "http://www." + domain_nosub + "/";
				} else if (domain_nosub === "bogmedia.org") {
					basedomain = "https://bogmedia.org/";
				} else if (domain_nosub === "solopornoitaliani.xxx") {
					videos_component = "video";
					addslash = ".html";
				} else if (domain_nosub === "mvpchannel.net") {
					videos_component = "tube/videos";
				} else if (domain_nosub === "watchmygf.me" ||
					domain_nosub === "yeswegays.com" ||
					domain_nosub === "x18.xxx" ||
					domain_nosub === "thebestshemalevideos.com" ||
					domain_nosub === "its.porn" ||
					domain_nosub === "yourlust.com" ||
					domain_nosub === "sexroom.xxx" ||
					domain_nosub === "pornalin.com" ||
					domain_nosub === "fapteentube.net" ||
					domain_nosub === "alphaporno.com" ||
					domain_nosub === "videocelebs.net" ||
					domain_nosub === "pornfappy.com" ||
					domain_nosub === "theyarehuge.com" ||
					domain_nosub === "pervclips.com" ||
					domain_nosub === "thisvid.com") {
					videos_component = "embed";
					addslash = "";
					a_component = "";
				} else if (domain_nosub === "xxxsextube.tv") {
					videos_component = "embed";
					addslash = "";
					a_component = "";
					basedomain = "https://" + domain + "/";
				} else if (domain_nosub === "cuckoldplacetube.com") {
					videos_component = "embed";
					addslash = "";
					a_component = "";
					basedomain = "http://www." + domain_nosub + "/";
				} else if (domain_nosub === "mcstatic.com") {
					basedomain = "https://www.metacafe.com/";
					videos_component = "watch";
					cache_host = "metacafe.com";
				} else if (domain_nosub === "mt-static.com") {
					basedomain = "https://www.megatube.xxx/";
				} else if (domain_nosub === "tube-bunny.com") {
					videos_component = "watch";
				} else if (domain_nosub === "slutload-media.com") {
					videos_component = "embed";
					addslash = "";
					a_component = "";
					basedomain = "https://www.slutload.com/";
				} else if (domain_nosub === "porngem.com" ||
					domain_nosub === "uiporn.com") {
					idprefix = "a-";
					addslash = "";
					a_component = "";
				} else if (domain_nosub === "youx.xxx") {
					videos_component = "videos/embed";
					a_component = "";
				} else if (domain_nosub === "cartoontube.xxx") {
					idprefix = "video";
					videos_component = "";
				} else if (domain_nosub === "onlineporno.cc") {
					idprefix = "video";
					videos_component = "";
					a_component = "";
				} else if (domain === "cdn84436847.ahacdn.me" ||
					domain_nosub === "zteenporn.com") {
					basedomain = "https://www.zteenporn.com/";
					idprefix = "a-";
					videos_component = "";
					a_component = "";
				} else if (domain === "itsporn.woxcdn.com") {
					basedomain = "https://www.its.porn/";
					videos_component = "embed";
					addslash = "";
					a_component = "";
				} else if (domain === "frprn.com") {
					a_component = "";
				} else if (domain_nosub === "b-cdn.net") {
					var bcdn_basedomain_map = {
						"hardmoms": "hardmoms.co",
						"d1ck": "d1ck.co",
						"18yos": "18yos.co",
						"analcuties": "analcuties.co",
						"asiancuties": "asian-cuties.com",
						"asianteens": "asian-teens.co",
						"cuteasians": "cuteasians.co",
						"extremejapanese": "extremejapanese.co",
						"faphard": "faphard.co",
						"hardcoreteens": "hardcoreteens.co",
						"hardfamily": "hardfamily.co",
						"hardjap": "hardjap.co",
						"hardmilfs": "hardmilfs.co",
						"hardteens": "hardteens.co",
						"hotmature": "hotmature.co",
						"japteens": "japteens.co",
						"k1nk": "k1nk.co",
						"milfz": "milfz.co",
						"pornn": "pornn.co",
						"roleplayers": "roleplayers.co",
						"taboofamily": "taboofamily.co",
						"teenanal": "teenanal.co",
						"wanktank": "wanktank.co",
						"extremeteens": "extremeteens.co"
					};
					var bcdn_subdomain = domain.replace(/\.b-cdn\.net$/, "");
					if (bcdn_subdomain in bcdn_basedomain_map) {
						basedomain = "https://" + bcdn_basedomain_map[bcdn_subdomain] + "/";
					} else {
						basedomain = "https://" + bcdn_subdomain + ".com/";
					}
				} else if (domain_nosub === "pornid.xxx") {
					can_detect_videourl = false;
				} else if (domain_nosub === "pornhat.com" ||
					domain_nosub === "mrdeepfakes.com" ||
					domain_nosub === "tubedupe.com" ||
					domain_nosub === "porno666.cam") {
					videos_component = "video";
				} else if (domain_nosub === "anysex.com") {
					videos_component = "";
					a_component = "";
				} else if (domain_nosub === "cambro.tv") {
					videos_component = "";
				} else if (domain_nosub === "camvideos.tv") {
					videos_component = "";
					basedomain = "http://www." + domain_nosub + "/";
				} else if (domain_nosub === "xcafe.com") {
					videos_component = "";
					a_component = "";
				} else if (domain_nosub === "18fuck.me") {
					a_component = "/a.tube";
					addslash = "";
				} else if (domain_nosub === "freepornvideo.sex") {
					videos_component = "xxx";
				} else if (domain_nosub === "pervclips.com") {
					base_component = "tube/";
					videos_component = "embed";
					addslash = "";
					a_component = "";
				} else if (domain_nosub === "stfucdn.com") {
					basedomain = "https://tubedupe.com/";
					videos_component = "video";
				} else if (domain_nosub === "prostoporno.help") {
					basedomain = "https://xxx.prostoporno.help/";
					a_component = "";
				} else if (domain === "jb503wdraf.ent-cdn.com") {
					basedomain = "https://www.freehardcore.com/";
				} else if (domain === "b3bepw16kz.ent-cdn.com") {
					basedomain = "https://www.deviants.com/";
				} else if (domain_nosub === "japaneseporn.xxx") {
					videos_component = "u";
				} else if (domain_nosub === "fapality.com") {
					videos_component = "";
					a_component = "";
				} else if (domain_nosub === "cartoonporn.pro") {
					videos_component = "vids";
				} else if (domain_nosub === "cartoon-sex.tv") {
					videos_component = "video";
					a_component = "";
					addslash = ".html";
				} else if (domain_nosub === "fapnado.xxx") {
					can_add_referer_1 = false;
				} else if (domain_nosub === "alotporn.com" ||
					domain_nosub === "xcafe.com") {
					videos_component = "";
					videos_slash = "";
				}
				var detected_url = null;
				if (can_detect_videourl) {
					detected_url = basedomain + base_component + videos_component + videos_slash + idprefix + id + a_component + addslash;
				}
				if (is_pagelink) {
					if (domain === "embeds.sunporno.com") {
						src = src.replace(/^[a-z]+:\/\/[^/]+\/+embed\/+/, "https://www.sunporno.com/videos/");
					}
					detected_url = src;
				}
				cache_host = basedomain.replace(/^[a-z]+:\/\/(?:www\.)?([^/]+)\/*$/, "$1");
				var fixup_function_url = function(flashvars) {
					var global_fn_num = 0;
					var first_common_sub = function(url, base, mult, divisor) {
						for (var i = 0; i < 12; i++) {
							var num = base;
							for (var url_ch_i = 0; url_ch_i < url.length; url_ch_i++) {
								var current_num = parseInt(url[url_ch_i]) || 0;
								num += i * current_num;
							}
							global_fn_num += mult * Math_floor(num / divisor);
						}
					};
					function update_fn_num2(urls) {
						for (var url_i = 0; url_i < urls.length; url_i++) {
							var url = urls[url_i].url;
							first_common_sub(url, 0, -1, 7);
						}
					}
					function update_fn_num1(urls) {
						var c, d, f, g, i;
						for (var url_i = 0; url_i < urls.length; url_i++) {
							var urlobj = urls[url_i];
							var url_key = urlobj.key;
							var url = urlobj.url;
							var slash_index = string_indexof(url, "/");
							var fn_num, real_url;
							if (slash_index > 0) {
								fn_num = parseInt(url.substring(0, slash_index));
								real_url = url.substring(slash_index);
							} else {
								fn_num = 0;
								real_url = url;
							}
							first_common_sub(url, fn_num, 1, 6);
							if (flashvars[url_key] && flashvars[url_key].substring(0, 8) === "function") {
								if (global_fn_num < 0) {
									f = "" + -global_fn_num;
									for (c = 0; c < 4; c++)
										f += f;
									real_url = real_url.substring(1);
									real_url = real_url.split("/");
									for (c = 0; c < real_url[5].length; c++) {
										g = c;
										for (d = c; d < f.length; d++) {
											g += parseInt(f[d]);
										}
										while (g >= real_url[5].length) {
											g = g - real_url[5].length;
										}
										i = real_url[5][c];
										real_url[5] = real_url[5].substring(0, c) + real_url[5][g] + real_url[5].substring(c + 1);
										real_url[5] = real_url[5].substring(0, g) + (i + "") + real_url[5].substring(g + 1);
									}
									flashvars[url_key] = real_url.join("/");
								} else {
									flashvars[url_key] = "function" + "/" + global_fn_num + real_url;
								}
							}
						}
					}
					var get_license_from_flashvars = function(flashvars) {
						for (var key in flashvars) {
							if (string_indexof(key, "code") > 0 && flashvars[key].length == 16) {
								return flashvars[key];
							}
						}
						return "";
					};
					var decrypt_license = function(license_code) {
						if (!license_code)
							return license_code;
						var license_num = "";
						for (var license_i = 1; license_i < license_code.length; license_i++) {
							var current_code_n = parseInt(license_code[license_i]);
							if (current_code_n) {
								license_num += current_code_n;
							} else {
								license_num += 1;
							}
						}
						var first_half = parseInt(license_num.substring(0, 8));
						var second_half = parseInt(license_num.substring(7));
						var license_num1_int = (Math_abs(second_half - first_half) + Math_abs(first_half - second_half)) * 2;
						var license_num1 = "" + license_num1_int;
						var decrypted = "";
						for (var i = 0; i < 8; i++) {
							for (var j = 1; j <= 4; j++) {
								var n = parseInt(license_code[i + j]) + parseInt(license_num1[i]);
								if (n >= 10) {
									n -= 10;
								}
								decrypted += n;
							}
						}
						return decrypted;
					};
					var update_url = function(flashvars) {
						var function_header = "function" + "/";
						for (var key in flashvars) {
							var value = flashvars[key];
							if (string_indexof(value, function_header) === 0) {
								var splitted_url = value.substring(function_header.length).split("/");
								if (splitted_url[0] > 0) {
									var vidid = splitted_url[6].substring(0, 32);
									var decrypted_license = decrypt_license(get_license_from_flashvars(flashvars));
									if (decrypted_license && vidid) {
										var old_vidid = vidid;
										for (var vidid_ri = vidid.length - 1; vidid_ri >= 0; vidid_ri--) {
											var current_key = vidid_ri;
											for (var i = vidid_ri; i < decrypted_license.length; i++) {
												current_key += parseInt(decrypted_license[i]);
											}
											while (current_key >= vidid.length) {
												current_key -= vidid.length;
											}
											var new_vidid = "";
											for (var vidid_i = 0; vidid_i < vidid.length; vidid_i++) {
												if (vidid_i === vidid_ri) {
													new_vidid += vidid[current_key];
												} else if (vidid_i === current_key) {
													new_vidid += vidid[vidid_ri];
												} else {
													new_vidid += vidid[vidid_i];
												}
											}
											vidid = new_vidid;
										}
										splitted_url[6] = splitted_url[6].replace(old_vidid, vidid);
										splitted_url.splice(0, 1);
										flashvars[key] = splitted_url.join("/");
									}
								}
							}
						}
					};
					var main = function() {
						var urls = [];
						var function_header = "function" + "/";
						for (var key in flashvars) {
							if (flashvars[key].substring(0, 9) === function_header) {
								var url = flashvars[key].substring(function_header.length);
								urls.push({ key: key, url: url });
							}
						}
						if (urls.length === 0) {
							return flashvars;
						} else {
							update_fn_num1(urls);
							update_fn_num2(urls);
							update_url(flashvars);
							return main();
						}
					};
					return main();
				};
				if (id && options.do_request && options.cb) {
					var cache_key = cache_host + ":" + id;
					var parse_flashvars = function(ourdata) {
						if (!ourdata || !ourdata.data) {
							return null;
						}
						var data = ourdata.data;
						var origpage = ourdata.finalurl;
						var maxurl = null;
						var maxsize = null;
						fixup_function_url(data);
						for (var key in data) {
							if (/^video_.*url[0-9]*$/.test(key)) {
								var oururl = data[key];
								var oursize = oururl.replace(/.*_([0-9]+)p\.[^/.]+(?:\/*[^/]*)?(?:[?#].*)?$/, "$1");
								if (oursize === oururl) {
									oursize = oururl.replace(/.*\/storage[0-9]*\/+[a-zA-Z0-9]+\/+([0-9]+)p\.mp4(?:[?#].*)?$/, "$1");
								}
								if (oursize === oururl) {
									oursize = oururl.replace(/.*\/key=.*\/+([0-9]+)x[0-9]+_[0-9]+k(?:_h264)?_[0-9]+\.mp4(?:[?#].*)?$/, "$1");
								}
								if (oursize === oururl) {
									oursize = oururl.replace(/.*\/key=.*\/+mobile_[0-9]+\.mp4(?:[?#].*)?$/, "480");
								}
								if (oursize === oururl) {
									oursize = null;
									if ((key + "_text") in data) {
										var keytext = data[key + "_text"];
										if (keytext === "LQ") { // 320x180 for prostoporno
											oursize = 240;
										} else if (keytext === "SD") {
											oursize = 360; // 640x360 for japan-whores
										} else if (keytext === "HQ" || keytext === "HD") { // 1280x720 for prostoporno
											oursize = 720;
										} else {
											var keytext_match = keytext.match(/^([0-9]{3,})p$/);
											if (keytext_match) {
												oursize = keytext_match[1];
											}
										}
									}
									if ((key + "_redirect") in data) {
										console_warn("URL appears to redirect: " + oururl);
										continue;
									}
									if (!oursize) {
										if (oururl.match(/\/([0-9]+)\/+\1(?:_(?:trailer|s))?\.[^/.]+(?:\/*[^/]*)?(?:[?#].*)?$/)) {
											oursize = 480;
										} else {
											console_warn("Unable to detect size from URL: " + oururl, data);
											continue;
										}
									}
								}
								oursize = parseInt(oursize);
								if (!maxsize || oursize > maxsize) {
									maxsize = oursize;
									maxurl = oururl;
								}
							}
						}
						if (maxurl) {
							var newobj = {
								url: maxurl,
								headers: {
									Referer: origpage || basedomain
								},
								extra: {
									page: origpage,
									caption: data.video_title || data.video_tags || data.video_categories || void 0
								}
							};
							if (!can_add_referer_1)
								newobj.headers.Referer = null;
							if (string_indexof(maxurl, ".mp4") >= 0) {
								newobj.video = true;
							}
							return newobj;
						} else {
							return null;
						}
					};
					var find_flashvars_from_page = function(resp) {
						var resptext = resp.responseText;
						resptext = resptext.replace(/low_quality_for_uc == true\)\s*{\s*var flashvars[\s\S]+?}\s*else\s*{/, ""); // zbporn.com
						var match = resptext.match(/var\s+flashvars\s*=\s*({[\s\S]+?})\s*;/);
						if (!match) {
							console_warn(cache_key, "Unable to find flashvars match", resp);
							return null;
						}
						var jsoned = match[1]
							.replace(/adv_pre_vast(?:_alt)?:\s*'[^\\']+?'(?:\s*\+\s*[a-z_]+),/g, "") // theyarehuge.com, zbporn.com
							.replace(/adv_pre_vast(?:_alt)?:\s*'[^\\']+?'\s*,/g, "") // thisvid.com
							.replace(/([{,]\s*)([^"'\s:]+)\s*:/g, "$1\"$2\":")
							.replace(/:\s*encodeURIComponent\(('[^']+')\)/g, ":$1")
							.replace(/([^\\])\\'/g, "$1\\u0027")
							.replace(/(\"[^\s:"]+?\":)\s*'([^']*)'(\s*[,}])/g, "$1 \"$2\"$3")
							.replace(/,\s*}$/, "}")
							.replace(/((?:[0-9]|")\s*,)\s*\/\/[^\n]*/, "$1");
						try {
							var json = JSON_parse(jsoned);
							if (!("video_id" in json) && "flashvars" in json && json.flashvars && "video_id" in json.flashvars) {
								json = json.flashvars;
							}
							return json;
						} catch (e) {
							console_error(cache_key, e, { match: match[1], jsoned: jsoned });
							return null;
						}
					};
					var find_itsporn_video = function(resp) {
						var match = resp.responseText.match(/<video\s([^>]+data-src-(?:hls|dash|mp4)="https?:[^"]+".*?)>\s*<\/video>/);
						if (!match) {
							console_warn(cache_key, "Unable to find data-src-(hls|dash|mp4) match", resp);
							return null;
						}
						var obj = [];
						var matches = match_all(match[1], /data-src-(hls|dash|mp4)="(https?:[^"]+)"/);
						array_foreach(matches, function(submatch) {
							var videotype = submatch[1];
							if (videotype === "mp4")
								videotype = true;
							obj.push({
								url: submatch[2],
								video: videotype
							});
						});
						if (obj.length > 0)
							return obj;
						console_error(cache_key, "Unable to find sources for data-src match", resp);
						return null;
					};
					var find_embed = function(resp) {
						var match = resp.responseText.match(/"player-holder">\s*<div class="embed-wrap"[^>]*><iframe\s[^>]*src=['"]([^'"]+)['"]/);
						if (!match) {
							console_warn(cache_key, "Unable to find iframe embed for", resp);
							return null;
						}
						return decode_entities(match[1]);
					};
					var find_plainvid = function(resp) {
						var match = resp.responseText.match(/<div id="kt_player"[^>]*>\s*<video id="main_video"[^>]+>\s*<source\s[^>]*src="([^"]+)"/);
						if (!match) { // alphaporno.com
							match = resp.responseText.match(/<video id="bravoplayer"[^>]+>(?:\s*<source[^>]*>){0,}\s*<source\s[^>]*src="([^"]+)"/);
						}
						if (!match) {
							console_warn(cache_key, "Unable to find plain kt video for", resp);
							return null;
						}
						return [{
								url: decode_entities(match[1]),
								video: true
							}];
					};
					var find_pornktube = function(resp) {
						var match = resp.responseText.match(/<div id="player"(?:\s+data-(?:id|[sqnt])="[^"]+?"){5}\s*>/);
						if (!match) {
							console_warn(cache_key, "Unable to find player div for", resp);
							return null;
						}
						var playerdiv = match[0];
						var matches = match_all(playerdiv, /data-(id|[sqnt])="([^"]+?)"/);
						var attrs = {};
						array_foreach(matches, function(submatch) {
							attrs[submatch[1]] = decode_entities(submatch[2]);
						});
						var qualities = attrs["q"].split(",");
						qualities.sort(function(a, b) {
							return parseInt(b) - parseInt(a);
						});
						var http_prefix = "https://s" + attrs["n"] + ".fapmedia.com/" + "cq" + "p" + "vid/";
						var folder = 1000 * Math_floor(parseFloat(attrs["id"]) / 1000);
						var tfolder = folder + "/" + attrs["id"];
						var urls = [];
						for (var i = 0; i < qualities.length; i++) {
							var quality = qualities[i].split(";");
							var suffix = "";
							if (quality[0] !== "720p") {
								if (quality[0] === "2160p") {
									suffix = "_4k";
								} else {
									suffix = "_" + quality[0];
								}
							}
							urls.push(http_prefix + quality[4] + "/" + quality[5] + "/" + tfolder + "/" + attrs.id + suffix + ".mp4");
						}
						return urls;
					};
					api_cache.fetch(cache_key, function(obj) {
						if (!obj)
							return options.cb(page_nullobj);
						if (!is_array(obj))
							obj = [obj];
						if (page_nullobj)
							obj.push(page_nullobj);
						return options.cb(obj);
					}, function(done) {
						var url = detected_url;
						var fetch_video = function(url, can_refetch) {
							if (!url) {
								console_error("Null url, ignoring");
								return done(null, false);
							}
							options.do_request({
								url: url,
								method: "GET",
								onload: function(resp) {
									if (resp.readyState !== 4)
										return;
									if (resp.status === 404) {
										var match = resp.responseText.match(/<meta http-equiv="Refresh" content="[0-9]+; URL=(https?:\/\/[^"]+)">/);
										if (match) {
											finalurl = decode_entities(match[1]);
											if (finalurl !== resp.finalUrl) {
												return fetch_video(finalurl, false);
											}
										}
									}
									if (resp.status !== 200) {
										console_error(resp);
										return done(null, false);
									}
									var finalurl = resp.finalUrl;
									var match = resp.responseText.match(/<link href="(https?:\/\/[^"]+)" rel="canonical"\s*\/>/);
									if (match) {
										finalurl = decode_entities(match[1]);
									}
									var baseobj = {
										headers: {
											Referer: finalurl || basedomain
										},
										extra: {
											page: finalurl
										}
									};
									var flashvars = find_flashvars_from_page(resp);
									if (flashvars) {
										var dataobj = {
											data: flashvars,
											finalurl: finalurl
										};
										return done(parse_flashvars(dataobj), 60 * 60);
									}
									var obj = find_itsporn_video(resp) || find_plainvid(resp);
									if (obj) {
										return done(fillobj_urls(obj, baseobj), 60 * 60);
									}
									var embed_url = find_embed(resp);
									if (embed_url) {
										return done({
											url: embed_url,
											is_pagelink: true
										}, 60 * 60);
									}
									obj = find_pornktube(resp);
									if (obj) {
										return done(fillobj_urls(obj, baseobj), 60 * 60);
									}
									if (can_refetch && finalurl !== resp.finalUrl) {
										return fetch_video(finalurl, false);
									} else {
										return done(null, false);
									}
								}
							});
						};
						fetch_video(url, true);
					});
					return {
						waiting: true
					};
				}
			}
			if ((host_domain_nowww === "vikiporn.com" ||
				host_domain_nowww === "sleazyneasy.com") && options.element) {
				if (!src && options.element.tagName === "DIV" && options.element.classList.contains("fp-ui")) {
					return {
						url: origsrc,
						bad: "mask"
					};
				}
			}
			if (domain === "cora.porntrex.com") {
				return {
					url: src,
					headers: {
						Referer: "https://www.porntrex.com/"
					}
				};
			}
			if (domain_nowww === "vjav.com" ||
				domain_nowww === "upornia.com" ||
				domain_nowww === "hotmovs.com" ||
				domain_nowww === "shemalez.com" ||
				domain_nowww === "hdzog.com") {
				match = src.match(/^[a-z]+:\/\/[^/]+\/+(?:videos|embed)\/+([0-9]+)(?:\/+.*)?(?:[?#].*)?$/);
				if (match) {
					id = match[1];
					page_nullobj = {
						url: src,
						is_pagelink: true
					};
					var base_domain = domain_nosub;
					var query_vjav_api = function(vidid, url, signature, cb) {
						api_query(base_domain + "_api:" + vidid, {
							url: "https://" + base_domain + "/sn4diyux.php",
							method: "POST",
							imu_mode: "iframe",
							headers: {
								"Content-Type": "application/x-www-form-urlencoded",
								"Origin": "https://" + base_domain,
								"Referer": url
							},
							data: "param=" + encodeURIComponent(vidid + "," + signature)
						}, cb, function(done, resp, cache_key) {
							var obf_b64_decode = function(url) {
								var origurl = url;
								url = url
									.replace(/\u041c/g, 'M')
									.replace(/\u0415/g, 'E')
									.replace(/\u0410/g, 'A')
									.replace(/\u0421/g, 'C')
									.replace(/\u0412/g, 'B')
									.replace(/~/g, '=');
								var splitted = url.split(",");
								try {
									url = base64_decode(splitted[0]);
									if (splitted.length > 1) {
										url += "?" + base64_decode(splitted[1]);
									}
									return url;
								} catch (e) {
									console_error(cache_key, "Unable to properly decode", url);
									throw e;
								}
							};
							var match = resp.responseText.match(/var [^\s=]+\s*='(\[[^']+aHR0[^']+\])';/);
							if (!match) {
								console_log(cache_key, "Unable to find match for", resp);
								return done(null, false);
							}
							var json = JSON_parse(match[1]);
							for (var key in json[0]) {
								if (/^aHR0/.test(json[0][key])) {
									json[0][key] = obf_b64_decode(json[0][key]);
								}
							}
							return done(json, 60 * 60);
						});
					};
					var query_vjav = function(vidid, cb) {
						api_query(base_domain + ":" + vidid, {
							url: "https://" + base_domain + "/videos/" + vidid + "/a/"
						}, cb, function(done, resp, cache_key) {
							var match = resp.responseText.match(/window\.jwsettings\s*=\s*{\s*pC3:\s*'([0-9]+\|[0-9]+,[0-9]+)'/);
							if (!match) {
								console_error(cache_key, "Unable to find signature for", resp);
								return done(null, false);
							}
							var sig = match[1];
							query_vjav_api(vidid, resp.finalUrl, sig, function(data) {
								if (!data)
									return done(null, false);
								return done(data, 60 * 60);
							});
						});
					};
					var jwplayer_obj_to_imu = function(data) {
						if (!data)
							return page_nullobj;
						var baseobj = {
							headers: {
								Referer: "https://" + base_domain + "/"
							}
						};
						var urls = [];
						urls.push({ url: data[0].video_url, video: true });
						urls.push(page_nullobj);
						return fillobj_urls(urls, baseobj);
					};
					if (options.do_request && options.cb) {
						query_vjav(id, function(data) {
							options.cb(jwplayer_obj_to_imu(data));
						});
						return {
							waiting: true
						};
					} else {
						return page_nullobj;
					}
				}
			}
			if (domain_nosub === "hclips.com" ||
				domain_nosub === "voyeurhit.com" ||
				domain_nowww === "txxx.com" ||
				domain_nowww === "thegay.com" ||
				domain_nowww === "tubepornclassic.com" ||
				domain_nosub === "videotxxx.com") {
				var match = src.match(/^[a-z]+:\/\/[^/]+\/+(?:videos|embed)\/+([0-9]+)\//);
				if (match) {
					id = match[1];
					var base_domain = domain_nosub;
					if (domain_nosub === "videotxxx.com")
						base_domain = "txxx.com";
					var decode_hclips_base64 = function(data) {
						var charset = decodeURIComponent("%D0%90%D0%92%D0%A1D%D0%95FGHIJKL%D0%9CNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789.%2C~"), output = "";
						var invalid_regex = new RegExp(decodeURIComponent("%5B%5E%D0%90%D0%92%D0%A1%D0%95%D0%9CA-Za-z0-9.%2C~%5D"), "g");
						if (invalid_regex.exec(data)) {
							console_warn("Invalid characters found in", data);
						}
						data = data.replace(invalid_regex, "");
						for (var i = 0; i < data.length;) {
							var c1 = string_indexof(charset, string_charat(data, i++)), c2 = string_indexof(charset, string_charat(data, i++)), c3 = string_indexof(charset, string_charat(data, i++)), c4 = string_indexof(charset, string_charat(data, i++));
							c1 = c1 << 2 | c2 >> 4;
							c2 = (15 & c2) << 4 | c3 >> 2;
							var last = (3 & c3) << 6 | c4;
							output += string_fromcharcode(c1);
							if (c3 !== 64) {
								output += string_fromcharcode(c2);
							}
							if (c4 !== 64) {
								output += string_fromcharcode(last);
							}
						}
						return unescape(output);
					};
					var query_hclips = function(vid, cb) {
						api_query(base_domain + ":" + vid, {
							url: "https://" + base_domain + "/api/videofile.php?video_id=" + vid + "&lifetime=8640000",
							headers: {
								"Accept": "application/json, text/plain, */*",
								"Referer": "https://" + base_domain + "/videos/" + vid + "/"
							},
							json: true
						}, cb, function(done, resp, cache_key) {
							var formats = ["_hq", "_lq"];
							var get_format_id = function(format) {
								format = format.replace(/\..*/, "");
								var index = array_indexof(formats, format);
								if (index < 0) {
									console_warn("Unknown format", format);
									return formats.length;
								} else {
									return index;
								}
							};
							resp.sort(function(a, b) {
								return get_format_id(a) - get_format_id(b);
							});
							for (var i = 0; i < resp.length; i++) {
								resp[i].video_url = urljoin("https://" + base_domain + "/", decode_hclips_base64(resp[i].video_url), true);
							}
							done(resp, 60 * 60);
						});
					};
					var hclips_to_obj = function(data) {
						if (!data || data.length === 0) {
							return page_nullobj;
						}
						var baseobj = {
							headers: {
								Referer: "https://" + base_domain
							}
						};
						urls = [{
								url: data[0].video_url,
								video: true
							}];
						urls.push(page_nullobj);
						return fillobj_urls(urls, baseobj);
					};
					page_nullobj = {
						url: src,
						is_pagelink: true
					};
					if (options.do_request && options.cb) {
						query_hclips(id, function(data) {
							options.cb(hclips_to_obj(data));
						});
						return {
							waiting: true
						};
					} else {
						return page_nullobj;
					}
				}
			}
			if (domain === "cdn69508963.ahacdn.me" ||
				domain === "cdn35854568.ahacdn.me" ||
				domain === "cdn60563788.ahacdn.me" ||
				domain === "12111549.pix-cdn.org" ||
				domain === "cdn56191079.ahacdn.me" ||
				domain === "cdn25122858.ahacdn.me" ||
				domain === "12111553.pix-cdn.org" ||
				domain === "cdn22821955.ahacdn.me" ||
				domain === "cdn37699375.ahacdn.me" ||
				(domain_nosub === "tubepornclassic.com" && /^static[0-9]*\./.test(domain)) ||
				domain === "cdn39638151.ahacdn.me" ||
				domain === "vjav1.hclips.net" ||
				domain === "vjav2.hclips.net" ||
				domain === "vjav3.hclips.net" ||
				domain === "cdn61283513.ahacdn.me" ||
				domain === "cdn42705446.ahacdn.me" ||
				domain === "cdn85419624.ahacdn.me" ||
				domain === "cdn49752055.ahacdn.me" ||
				domain === "cdn12694176.ahacdn.me" ||
				domain === "cdn27185998.ahacdn.me" ||
				domain === "cdn52810799.ahacdn.me" ||
				domain === "cdn47590165.ahacdn.me" ||
				(domain_nosub === "shemalez.com" && /^tn[0-9]*\./.test(domain)) ||
				domain === "cdn37804682.ahacdn.me") {
				var basedomain_map = {
					"cdn69508963.ahacdn.me": "hdzog.com",
					"cdn39638151.ahacdn.me": "vjav.com",
					"vjav1.hclips.net": "vjav.com",
					"vjav2.hclips.net": "vjav.com",
					"vjav3.hclips.net": "vjav.com",
					"cdn35854568.ahacdn.me": "upornia.com",
					"cdn60563788.ahacdn.me": "upornia.com",
					"12111549.pix-cdn.org": "upornia.com",
					"cdn56191079.ahacdn.me": "hotmovs.com",
					"cdn25122858.ahacdn.me": "hotmovs.com",
					"12111553.pix-cdn.org": "hotmovs.com",
					"cdn22821955.ahacdn.me": "tubepornclassic.com",
					"cdn37699375.ahacdn.me": "tubepornclassic.com",
					"cdn61283513.ahacdn.me": "hclips.com",
					"cdn42705446.ahacdn.me": "hclips.com",
					"cdn85419624.ahacdn.me": "hclips.com",
					"cdn49752055.ahacdn.me": "hdzog.com",
					"cdn12694176.ahacdn.me": "hdzog.com",
					"cdn27185998.ahacdn.me": "thegay.com",
					"cdn52810799.ahacdn.me": "thegay.com",
					"cdn47590165.ahacdn.me": "shemalez.com",
					"cdn37804682.ahacdn.me": "txxx.com"
				};
				var basedomain = basedomain_map[domain];
				if (!basedomain)
					basedomain = domain_nosub;
				match = src.match(/\/(?:c[0-9]*|contents)\/+videos(?:_(?:sources|screenshots))?\/+[0-9]+\/+([0-9]+)\/+(?:(?:[0-9]+_tr|preview)\.|(?:screenshots|[0-9]+x[0-9]+)\/)/);
				if (match) {
					return {
						url: "https://" + basedomain + "/videos/" + match[1] + "/a/",
						is_pagelink: true
					};
				}
			}
			if (domain_nowww === "xbabe.com") {
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+videos\/+([^/]+)\/*(?:[?#].*)?$/,
					query_for_id: "https://xbabe.com/videos/${id}/",
					process: function(done, resp) {
						var obj = common_functions["get_videotag_obj"](resp);
						if (!obj)
							return done(null, false);
						return done(fillobj_urls(obj, {
							headers: {
								Referer: resp.finalUrl
							}
						}), 60 * 60);
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain_nowww === "zceleb.com" ||
				domain === "cdn.faponix.com" ||
				domain_nosub === "fapality.com" ||
				domain === "alb-xb.hellcdn.net" ||
				domain_nowww === "vjav.com" ||
				domain_nosub === "tubsexer.com" ||
				domain_nowww === "bobs-tube.com" ||
				domain === "i.pornsexer.com" ||
				domain_nowww === "pervertedmilfs.com" ||
				domain_nowww === "xcadr.com" ||
				domain_nowww === "anon-v.com" ||
				domain_nosub === "okporn.com" ||
				(domain_nosub === "cdntrex.com" && /^albums?[0-9]*\./.test(domain)) ||
				domain_nosub === "p7cdn.com" ||
				domain_nosub === "pornoreino.com" ||
				domain_nowww === "mylust.com" ||
				domain_nosub === "smutr.com" ||
				domain_nowww === "megaporn.co" ||
				domain === "i.tubsexer.com" ||
				domain_nowww === "break.ie" ||
				(domain_nosub === "watchmygf.me" && /^cdn[0-9]*\./.test(domain)) ||
				domain === "watchmyexgf.good-cdn.com" ||
				domain_nowww === "fitting-room.com" ||
				(domain_nosub === "tubepornclassic.com" && /^static[0-9]*\./.test(domain)) ||
				domain_nowww === "iloveporn.xxx" ||
				domain_nowww === "zzgays.com" ||
				domain_nowww === "pornhat.com" ||
				domain === "i.bobs-tube.com" ||
				domain_nowww === "xbabe.com" ||
				domain_nowww === "pornzee.com" ||
				domain === "media.thebestshemalevideos.com" ||
				domain_nowww === "themilf.net" ||
				domain_nowww === "pornstarsadvice.com" ||
				domain_nowww === "porntb.com" ||
				domain === "109.206.187.183" ||
				domain_nowww === "fetishburg.com" ||
				domain_nosub === "zbporn.tv" ||
				domain_nosub === "zbporn.com" ||
				domain_nosub === "stfucdn.com" ||
				domain_nowww === "mythumbnails.com" ||
				domain === "static.ok.xxx" ||
				domain_nowww === "nudems.com" ||
				(domain_nosub === "thub.lol" && /\/contents\/+albums\//.test(src)) ||
				domain === "cdn.pornstill.com") {
				if (domain_nosub !== "thebestshemalevideos.com" && domain_nosub !== "smutr.com") {
					newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/+remote_control\.php\?(?:.*?&)?file=([^&]*).*?$/, "$1");
					if (newsrc !== src)
						return urljoin(src, decodeURIComponent(newsrc), true);
				}
				newsrc = src.replace(/\/get_image\/[0-9a-f]\/[0-9a-f]+\/main\/(.*?)\/+(?:[?#].*)?$/, "/contents/albums/main/$1");
				if (newsrc !== src)
					return newsrc;
				var max = null;
				if (domain_nowww === "porntb.com") {
					max = "1920x1920";
				} else if (domain_nowww === "fetishburg.com") {
					max = "1920x1200";
				} else if (domain_nosub === "zbporn.tv") {
					max = "9998x9998";
				}
				match = src.match(/\/main\/+([0-9]+x[0-9]+)\/+/);
				if (max && match) {
					var get_pixels = function(x) {
						var match = x.match(/^([0-9]+)x([0-9]+)$/);
						if (!match)
							return 0;
						return parseInt(match[1]) * parseInt(match[2]);
					};
					if (get_pixels(max) > get_pixels(match[1])) {
						newsrc = src.replace(/\/main\/+[0-9]+x[0-9]+\/+/, "/main/" + max + "/");
					}
				} else if (!max) {
					newsrc = src.replace(/\/main\/+[0-9]+x[0-9]+\/+/, "/sources/");
				}
				obj = {
					url: newsrc
				};
				var referer_1 = "http://" + domain_nosub + "/";
				if (domain_nosub === "p7cdn.com") {
					referer_1 = "https://www.sex-hd.xxx/";
				} else if (domain_nosub === "cdntrex.com") {
					referer_1 = "";
				} else if (domain === "109.206.187.183" || domain_nosub === "porntb.com") {
					referer_1 = "http://www.porntb.com/";
				} else {
					obj.referer_ok = { same_domain: true };
				}
				obj.headers = { Referer: referer_1 };
				return obj;
			}
			if (domain === "image.jeuxvideo.com") {
				return {
					url: src.replace(/(:\/\/[^/]+\/+(?:medias|images))-[a-z]+\//, "$1/"),
					can_head: false
				};
			}
			if (domain_nosub === "mt-static.com" && /^img[0-9]*\./.test(domain)) {
				return src.replace(/(\/contents\/+albums_overview\/+[0-9]+\/+[0-9]+\/+)[0-9]+x[0-9]+\/+/, "$1sources/");
			}
			if (domain === "images.pushsquare.com") {
				return src
					.replace(/((?:\/news\/+[0-9]+\/+[0-9]+\/+[^/]+\/+)|(?:\/screenshots\/+[0-9]+\/+)|(?:\/reviews\/+[^/]*\/+[^/]*\/+))(?:[0-9]+x(?:[0-9]+)?|[a-z]+)(\.[^/.]*)$/, "$1original$2")
					.replace(/(:\/\/[^/]+\/+[0-9a-f]{5,}\/+)(?:[0-9]+x(?:[0-9]+)?|large)\./, "$1original.")
					.replace(/(\/games\/.*\/cover)(?:_[a-z]+)?(\.[^/.]*)$/, "$1_original$2");
			}
			if (domain_nowww === "pcgames.de") return src.replace(/\/screenshots\/+[0-9]*x[0-9]*\//, "/screenshots/original/");
			if (domain_nowww === "collinsdictionary.com") return src.replace(/\/images\/thumb\/([^/]*)_[0-9]+(\.[^/.]*)(\?.*)?$/, "/images/full/$1$2$3");
			if (domain_nowww === "abc.net.au") {
				return src
					.replace(/(\/pluck-cache\/images\/[-0-9a-f]+\.)[A-Z][a-z]+(\.[^/.]*)$/, "$1Full$2")
					.replace(/(\/cm\/rimage\/[0-9]+-[0-9]+x[0-9]+-)[a-z]+(\.[^/.]*)$/, "$1large$2");
			}
			if (domain_nowww === "1x.com") {
				return src
					.replace(/(:\/\/[^/]*\/)img\/[^/]*?[?&]id=([0-9a-f]+).*$/, "$1images/user/$2-hd4.jpg")
					.replace(/(\/images\/user\/[0-9a-f]+)-[a-z]+(?:[0-9]+)?(\.[^/.]*)$/, "$1-hd4$2");
			}
			if (domain === "fotografroku.ifotovideo.cz") return src.replace(/(:\/\/[^/]*\/image\.php).*?[?&]id=([0-9]+).*?$/, "$1?id=$2&size=2");
			if (domain === "img.kutikomiya.jp") return src.replace(/\/thumbnail(\/[^/]*\/)W[0-9]+(?:xH[0-9]+)?\//, "/album$1");
			if (domain === "attach.setn.com") {
				regex = /(\/newsimages\/+[0-9]+\/+[0-9]+\/+[0-9]+\/+[0-9]+)(?:-[A-Z]+)?(\.[^/.]*)$/;
				if (regex.test(src)) {
					return [
						src.replace(regex, "$1-SOURCE$2"),
						src.replace(regex, "$1$2")
					];
				}
			}
			if (domain_nowww === "heyzo.com") return src.replace(/\/gallery\/thumbnail_([0-9]+\.[^/.]*)$/, "/gallery/$1");
			if (domain === "img.picabcd.com") return src.replace(/\/thumbnail\/images\//, "/images/");
			if (domain === "mozishop.cdn.shoprenter.hu") return src.replace(/\/mozishop\/image\/cache\/(?:[a-z]{1,}[0-9]+){1,}\//, "/mozishop/image/data/");
			if (domain === "terrigen-cdn-dev.marvel.com") return src.replace(/(\/content\/[a-z]+\/)1x\//, "$12x/");
			if (domain_nowww === "czmodels.cz" ||
				domain_nowww === "phmodels.cz") {
				return src.replace(/(\/image\/itemid-([0-9]+)\/).*/, "$1q-100/$2.jpg");
			}
			if (domain_nosub === "amazonaws.com" && /^[a-z0-9]+\.execute-api\./.test(domain)) {
				return {
					url: src
						.replace(/(:\/\/[^/]*\/image\/)fit-in\/[0-9]+x[0-9]+\//, "$1")
						.replace(/\/prod\/+image-renderer\/+[^/]+\/+[^/]+\/+[0-9]+\/+[^/]+\/+[0-9]+\/+([-0-9a-f]{20}[^/]+)(?:[?#].*)?$/, "/prod/image-renderer/original/full/0/center/100/$1"),
					can_head: false // otherwise it returns 502
				};
			}
			if (domain === "cdn.pudra.com") return src.replace(/(:\/\/[^/]*\/[0-9]+\/)fit[a-z]?[0-9]+x[0-9]+\//, "$1");
			if (domain === "arhiva.dalje.com") return src.replace(/(\/slike_[0-9]*\/)r[0-9]*(\/g[0-9]+\/)/, "$1r1$2");
			if (domain === "media.super.cz") return src.replace(/(:\/\/[^/]*\/images\/+)[^/]+\/(.*?)(?:[?#].*)?$/, "$1original/$2");
			if (domain_nowww === "d1g.com") return src.replace(/(\/photos\/[0-9]+\/[0-9]+\/[0-9]+)_[a-z]+(\.[^/.]*)$/, "$1_max$2");
			if (domain_nowww === "e-shuushuu.net") {
				return add_extensions_jpeg(src.replace(/(:\/\/[^/]*\/images\/)thumbs\//, "$1"));
			}
			if (domain === "cdn.anime-pictures.net" ||
				domain_nosub === "anime-pictures.net") {
				return src.replace(/(\/[0-9a-f]+)_[a-z]+(\.[^/.]*)(?:\.webp)?(\?.*)?$/, "$1$2$3");
			}
			if (domain === "images.treccani.it") return src.replace(/\/enc\/+media\/+share\/+images\/+[a-z]+\/+system\//, "/enc/media/share/images/orig/system/");
			if (domain === "image-store.slidesharecdn.com") return src.replace(/(:\/\/[^/]*\/[-0-9a-f]+)-large(\.[^/.]*)$/, "$1-original$2");
			if (domain_nosub === "stgy.ovh" && /^(?:[0-9]+\.)?citynews-(?:rimini)?today\./.test(domain)) {
				return src.replace(/\/~media\/[-a-z]+(\/[0-9]+\/)/, "/~media/$1");
			}
			if (domain === "media.raccweb.com") return src.replace(/^[a-z]+:\/\/[^/]+\/+(__sized__\/+)/, "https://www.racctrusted.com/media/$1");
			if (domain === "music.librepunk.club" ||
				domain_nowww === "racctrusted.com" ||
				domain === "d16kd6gzalkogb.cloudfront.net" ||
				domain_nowww === "oye-records.com" ||
				domain === "audio.gafamfree.party") {
				return src.replace(/(:\/\/[^/]*\/+(?:media\/+)?)__sized__\/+(.*)-(?:thumbnail|crop-c[0-9]+-[0-9]+__[0-9]+-[0-9]+)-[0-9]+x[0-9]+(?:-[0-9]+)?(\.[^/.]*)(?:[?#].*)?$/, "$1$2$3");
			}
			if (domain_nowww === "mormonnewsroom.org" ||
				domain === "newsroom.churchofjesuschrist.org") {
				return src.replace(/\/media\/+[0-9]+x[0-9]+\//, "/media/original/");
			}
			if (domain === "contents.mediadecathlon.com") return src.replace(/(\/p[0-9]+\/)(?:[0-9]+x[0-9]+\/)?(?:[a-z]+\/)?([^/]*)$/, "$1$2");
			if (domain_nowww === "overcast.fm") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/art.*?[?&]u=([^&]*).*?$/, "$1");
				if (newsrc !== src)
					return decodeURIComponent(newsrc);
			}
			if (amazon_container === "clovermedia") {
				return src.replace(/(\/store\/+[-0-9a-f]{20,}\/+[0-9a-f]+\/+thumbnails\/+)[a-z]+\/+/, "$1original/");
			}
			if (domain === "spottappeu01prd.blob.core.windows.net") return src.replace(/(\/[0-9a-f]+\/)[0-9]+(?:_[0-9]+)(\.[^/.]*)$/, "$10$2");
			if (domain === "medias.spotern.com") return src.replace(/\/[wh][0-9]+\/([0-9]+(?:_[0-9a-f]+)?(?:-[0-9]+)?\.[^/.]*)$/, "/original/$1");
			if (domain_nosub === "ounousa.com") return src.replace(/\/Content\/ResizedImages\/[0-9]+\/[0-9]+\/[a-z]+(\/[0-9]+\.[^/.]*)$/, "/content/uploads/Article$1");
			if (domain_nowww === "divahair.ro") return src.replace(/(\/articole_imagini\/[^/]*\/[0-9]+\.[0-9]+\.[0-9]+\/)[0-9]+x[0-9]+\/([^/]*)_[0-9]+_[0-9]+(\.[^/.]*)$/, "$1$2$3");
			if (domain_nowww === "wall.hr") return src.replace(/\/cdn\/uploads\/[0-9]+x\//, "/cdn/uploads/");
			if (domain_nosub === "tialoto.bg") return src.replace(/(\/media\/tialoto\/files\/[a-z]+\/)[0-9]+x[0-9]+(?:[a-z]+)?(\/[0-9a-f]+\.[^/.]*)$/, "$1orig$2");
			if (domain === "bizweb.dktcdn.net") return src.replace(/(:\/\/[^/]+\/+)thumb\/+(?:[a-z]+|[0-9]+x[0-9]+)\/+/, "$1");
			if (domain_nowww === "socialbliss.com") return src.replace(/\/img\/[0-9]+x[0-9]+\/assets\//, "/assets/");
			if (domain_nowww === "forumfr.com") {
				return "http://" + src.replace(/.*\/applications\/core\/interface\/imageproxy\/ximageproxy\.php.*?,qimg=,h(.*?)(?:,[^_].*)?$/, "$1").replace(/,_/g, "/");
			}
			if (domain_nowww === "pinkomatic.com") return src.replace(/(\/images\/[0-9]+\/)[a-z]+\//, "$1full/");
			if (domain_nowww === "khmeread.com" ||
				(domain_nosub === "techbang.com" && domain.match(/^cdn[0-9]*(?:-[a-z]+)?\./))) {
				return src.replace(/(\/images\/[0-9]+\/)[a-z]+\//, "$1original/");
			}
			if (domain === "cfshopeetw-a.akamaihd.net" ||
				domain === "cf.shopee.tw" ||
				domain === "cf.shopee.co.id" ||
				domain === "cf.shopee.ph" ||
				domain === "cf.shopee.com.my" ||
				domain === "cf.shopee.sg" ||
				domain === "cf.shopee.co.th" ||
				domain === "cf.shopee.vn") {
				return src.replace(/(\/file\/[0-9a-f]+)_tn(?:\?.*)?$/, "$1");
			}
			if (domain_nowww === "theredlist.com") return src.replace(/\/media\/\.cache\/database\/(.*\/)[0-9]+-([^/]*)$/, "/media/database/$1$2");
			if ((domain_nosub === "hentai-cosplay.com" ||
				domain_nosub === "hentai-image.com" ||
				domain_nosub === "porn-image-xxx.com" ||
				domain_nosub === "porn-movie-xxx.com" ||
				domain_nosub === "hentai-animes.com" ||
				domain_nosub === "hentai-comic.com" ||
				domain_nosub === "aniimg.com") &&
				domain.match(/^static[0-9]*\./) &&
				string_indexof(src, "/upload/") >= 0) {
				newsrc = src
					.replace(/^[a-z]+:\/\/[^/]*\/upload\/cache\/thumbnail\/create\.php.*?[?&]image=([^&]*).*?$/, "$1");
				if (newsrc !== src) {
					return newsrc;
				}
				return src
					.replace(/(\/+[0-9]+\/+)(?:[a-z]+=[^/]*\/+){1,}([0-9]+\.[^/.]*)$/, "$1$2")
					.replace(/(\/+[0-9A-Z]+\/+)(?:[a-z]+=[^/]*\/+){1,}([0-9A-Za-z]+\.[^/.]*)$/, "$1$2");
			}
			if (domain === "d1in1v57myx5v.cloudfront.net" ||
				domain === "mpics.mgronline.com") {
				return src.replace(/\/pics\/+Thumbnails\//, "/pics/Images/");
			}
			if (domain_nowww === "artistic-nude-images.com") return src.replace(/\/thumbnail\/tn-([^/]*)$/, "/$1");
			if (domain_nowww === "babefilter.net") {
				return {
					url: src.replace(/(\/i\/[0-9a-f]+\/[0-9a-f]+)_tn(\.[^/.]*)$/, "$1$2"),
					headers: {
						Referer: src
					}
				};
			}
			if ((domain_nosub === "dagospia.com" && string_indexof(src, "/img/") >= 0) ||
				(domain_nowww === "sutki.net" && string_indexof(src, "/img/") >= 0) ||
				(domain_nowww === "screensonic.net" && string_indexof(src, "/images/") >= 0)) {
				return src.replace(/_tn(\.[^/.]*)$/, "$1");
			}
			if (domain_nowww === "fabhairypussy.com") {
				return {
					url: src.replace(/(\/+galleries\/+[^/]*\/+(?:[0-9]{4}\/+[0-9]{2}\/+)?[^/]+\/+[0-9]+)(?:_[a-z]+){1,}(\.[^/.]*)(?:[?#].*)?$/, "$1$2"),
					headers: {
						Referer: ""
					},
					referer_ok: {
						same_domain: true
					}
				};
			}
			if (domain_nowww === "redcarpetnudes.com" ||
				domain_nowww === "shamelesscelebrities.com" ||
				domain === "cdn.onedala.tv") {
				return src.replace(/-tn(\.[^/.]*)$/, "$1");
			}
			if (domain === "pat.primecdn.net") return src.replace(/\/pics\/[a-z]+(\/[0-9a-f]+\/[0-9a-f]+\.[^/.]*)$/, "/pics/original$1");
			if (domain_nosub === "imagearn.com") return src.replace(/(:\/\/[^/]*\/)([0-9]+\/[0-9]+\.[^/.]*)$/, "$1imags/$2");
			if (domain === "img.static-smb.be" ||
				domain === "img.static-rmg.be") {
				return src.replace(/\/view\/q[0-9]*\/w[0-9]*\/h[0-9]*\//, "/view/q100/w/h/");
			}
			if (domain_nosub === "buro247.mn" ||
				domain_nosub === "buro247.sg" ||
				domain_nosub === "buro247.kz" ||
				domain_nosub === "buro247.mx" ||
				domain_nosub === "buro247.com.au" ||
				domain_nosub === "buro247.ua" ||
				domain_nosub === "buro247.mn" ||
				domain_nosub === "buro247.ru") {
				return src
					.replace(/(\/thumb\/[^/]*\/)galleries\//, "$1local/images/buro/galleries/")
					.replace(/\/thumb\/[0-9]+x[0-9]+(?:_[0-9]+)?((?:\/local)?\/(?:images|thumb)\/)/, "$1");
			}
			if (domain_nosub === "hellomagazine.com") return src.replace(/\/thumb\/+[0-9]+x[0-9]+(?:_[0-9]+)?\/+(images|gallery\/+)/, "/$1");
			if (domain === "images.vogue.it") {
				return src
					.replace(/(\/gallery\/[0-9]+\/)[A-Za-z]+(\/[-0-9a-f]+\.[^/.]*)$/, "$1Original$2")
					.replace(/(\/Photovogue\/+[-0-9a-f]{10,})_small(\.[^/.]+)(?:[?#].*)?$/, "$1_large$2");
			}
			if (domain === "blogs.glamour.de") return src.replace(/\/thumbs\/[^/]*\//, "/files/");
			if (domain === "img.beatles.ru") return src.replace(/(\/[0-9]+)(\/[0-9]+\.[^/.]*)$/, "$1b$2");
			if (domain_nowww === "boutique.az") return src.replace(/(\/images\/[0-9]+)_[a-z](\.[^/.]*)$/, "$1$2");
			if (domain_nowww === "izum.ua") return src.replace(/(_[0-9]+)_sml[0-9]*(\.[^/.]*)$/, "$1$2");
			if (domain_nosub === "senatus.net" &&
				domain.match(/^cache[0-9]*\./)) {
				return src.replace(/\/files\/albums\/resized(?:[0-9]+x)?\//, "/files/albums/");
			}
			if (domain_nowww === "max-pix.com" ||
				domain_nowww === "kollywoodzone.com" ||
				domain_nowww === "celebwallpaper.org" ||
				domain_nowww === "carlyslayjepsen.com" ||
				domain_nosub === "moregirls.org") {
				return src.replace(/\/data\/thumbnails(\/[0-9]+\/)/, "/data/media$1");
			}
			if (domain_nowww === "tapeteos.pl") {
				return src
					.replace(/\/data\/thumbnails(\/[0-9]+\/)/, "/data/media$1big/")
					.replace(/(\/data\/media\/[0-9]+\/)([^/]*)$/, "$1big/$2")
					.replace(/__resized_[0-9]+x[0-9]+(\.[^/.]*)$/, "$1");
			}
			if (domain === "media.8ch.net" ||
				domain === "media.8kun.top") {
				return src.replace(/\/file_store\/thumb\//, "/file_store/");
			}
			if (domain_nowww === "elles-se-mettent-nues-pour-nous.fr") return src.replace(/(\/photos\/[^/]+\/)thumb\//, "$1");
			if (domain === "media.filmz.ru") return src.replace(/\/photos\/+[a-z]+\/+([^/_]{2,}_)?(?:[a-z]_)?([0-9]+\.[^/.]*)$/, "/photos/full/$1f_$2");
			if (domain_nowww === "kinofilms.ua") return src.replace(/\/images\/photos\/[a-z0-9]+\/([0-9]+\.[^/.]*)$/, "/images/photos/hd/$1");
			if (domain_nowww === "grandmagazine.gr") return src.replace(/\/cache\/uploaded_images\/(.*)\/[0-9]+_[0-9]+_([^/]*)$/, "/uploaded_images/$1/$2");
			if (domain === "a69.g.akamai.net") {
				return add_http(src.replace(/^[a-z]+:\/\/[^/]*\/[a-z]+\/[0-9]+\/[0-9]+\/v[0-9]+\//, ""));
			}
			if (domain === "images.allocine.fr") return src.replace(/\/[rc]_[0-9]+_[0-9]+\/+pictures\/+/, "/pictures/");
			if (domain === "cdn-media.rtl.fr") return src.replace(/\/cache\/[-a-zA-Z0-9_]+\/[0-9]+v[0-9]+(?:-[0-9]+)?\/online\//, "/online/");
			if (domain === "images.rtl.fr") return src.replace(/(:\/\/[^/]+\/+)~c\/+[^/]+\/+/, "$1");
			if (domain === "bcdn.newshunt.com" ||
				(domain_nosub === "dailyhunt.in" && domain.match(/bcdn[-.]/))) {
				obj = {
					url: src,
					head_wrong_contentlength: true
				};
				newsrc = src.replace(/\/cmd\/[a-z]+\/[^/]*\/(fetchdata[0-9]*\/images\/)/, "/$1");
				if (newsrc !== src) {
					obj.url = newsrc.replace(/\.webp(?:[?#].*)?$/, ".jpg");
				}
				return obj;
			}
			if (domain === "media.search.lt") return src.replace(/\/GetFile\.php.*?[?&](OID=[0-9]+).*?$/, "/GetFile.php?$1&filetype=4");
			if (domain_nowww === "wallofcelebrities.com") {
				return {
					url: src.replace(/\/pictures\/[a-z]+\/([^/]*_[0-9]+\.[^/.]*)$/, "/pictures/original/$1"),
					headers: {
						Referer: "https://www.wallofcelebrities.com/"
					}
				};
			}
			if (domain_nosub === "lmstube.com") return src.replace(/\/[0-9]+x[0-9]+\/([^/]*)$/, "/$1");
			if (domain === "assets.mubi.com") return src.replace(/(\/images?)-[a-z0-9]+(\.[^/.]*)(?:[?#].*)?$/, "$1-original$2");
			if (domain_nowww === "fundir.org") return src.replace(/(:\/\/[^/]*\/)th\//, "$1img/");
			if (domain_nowww === "spletnik.ru") return src.replace(/\/thumb\/[0-9]+x[0-9]+(?:_[0-9]+)?\/img\//, "/img/");
			if (domain === "r.mtdata.ru") return src.replace(/:\/\/[^/]*\/[a-z][-0-9]+x[-0-9]+\//, "://mtdata.ru/");
			if (domain_nowww === "mtdata.ru" &&
				src.match(/:\/\/[^/]*\/u[0-9]+\/photo/)) {
				return src.replace(/\/(?:huge|big)(\.[^/.]*)$/, "/original$1");
			}
			if (domain === "img.uduba.com") {
				newsrc = src.replace(/:\/\/[^/]*\/mtdata\.ru\//, "://mtdata.ru/");
				if (newsrc !== src) {
					return newsrc.replace(/\/[a-z]+_[0-9]+x[0-9]+(\.[^/.]*)$/, "/original$1");
				}
			}
			if (domain_nowww === "russianpulse.ru") return src.replace(/^[a-z]+:\/\/[^/]*\/img\/([a-z]+:\/\/.*)$/, "$1");
			if (domain === "img.noobzone.ru" ||
				domain === "m.btdx8.com" ||
				domain_nowww === "guihuayun.com") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/+(?:uploads\/+)?getimg\.php\?(?:.*&)?(?:url|src)=([^&]+).*?$/, "$1");
				if (newsrc !== src)
					return decodeuri_ifneeded(newsrc);
			}
			if (domain === "media.aintitcool.com") return src.replace(/_(?:large|big|huge|medium)(\.[^/.]*)(?:[?#].*)?$/, "$1");
			if (domain_nowww === "lichnosti.net") {
				return src
					.replace(/\/rs\/+thumbs\/+([0-9]+)\/+set_([^/]*)_([a-z]+)_[0-9]+_[0-9]+_[0-9]+\.[^/.]*$/, "/photos/$1/sets/$2.$3")
					.replace(/\/rs\/+thumbs\/+([0-9]+)\/+([^/]*)_([a-z]+)_[0-9]+_[0-9]+_[0-9]+\.[^/.]*$/, "/photos/$1/$2.$3");
			}
			if (domain_nosub === "zmones.lt" &&
				domain.match(/^s[0-9]*\.zmones\.lt/)) {
				return src.replace(/(\/images\/photos\/[0-9]+\/[0-9]+\/[0-9]+\/)[a-z]+(\/[^/]*\.[^/.]*)$/, "$1original$2");
			}
			if (domain_nosub === "hsmedia.ru" ||
				domain_nosub === "elle.ru") {
				return src.replace(/(:\/\/[^/]*\/[0-9a-f]{2}\/[0-9a-f]{2}\/[0-9a-f]{2}\/[0-9a-f]+\/)[0-9]+x[0-9]+_[^/]*@([0-9]+x[0-9]+_[^/]*)$/, "$1$2");
			}
			if (domain_nowww === "starbeat.ru" &&
				string_indexof(src, "/gallery/") >= 0) {
				return src.replace(/\/(?:small|medium)\/([^/]*)$/, "/$1");
			}
			if ((domain === "image.kilimall.com" ||
				domain === "d2lpfujvrf17tu.cloudfront.net") &&
				string_indexof(src, "/shop/store/") >= 0) {
				return src.replace(/(\/[0-9]+_[0-9]+)_[0-9]+(\.[^/.]*)$/, "$1$2");
			}
			if (domain_nowww === "zevenmart.com") return src.replace(/\/resized\/([^/]*)_[0-9]+x[0-9]+(\.[^/.]*)$/, "/$1$2");
			if (domain_nowww === "superherotv.net" ||
				domain_nowww === "starsplanet.ru") {
				return src.replace(/\/photo\/images_small\//, "/photo/images_large/");
			}
			if (domain_nowww === "xxx-photo.com") return src.replace(/\/photo\/t\/(.*?)(?:_t)?(\.[^/.]*)$/, "/photo/i/$1$2");
			if (domain_nowww === "div.bg" ||
				domain_nowww === "jenite.bg") {
				return src.replace(/(\/pictures\/[0-9]+)_[0-9]*(?:_[0-9]*)?(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			}
			if (domain === "cdn.hqsluts.com" ||
				domain_nowww === "hqbabes.com" ||
				domain === "c.xme.net") {
				return src.replace(/(:\/\/[^/]*\/(?:t\/)?[0-9]+)[a-z]([0-9]+(?:\.[^/.]*)?)$/, "$1c$2");
			}
			if ((domain_nowww === "sensualgirls.org" ||
				domain_nowww === "deliciousbabes.org" ||
				domain_nowww === "girlsofdesire.org") &&
				src.match(/\/media\/pictures(?:_new)?\//)) {
				return {
					url: src.replace(/(\/[^/.]*)_thumb(\.[^/.]*)$/, "$1$2"),
					headers: {
						Origin: "https://" + domain,
						Referer: "https://" + domain + "/"
					}
				};
			}
			if (domain_nowww === "littlemutt.com") return src.replace(/(\/hosted\/+[^/]+\/+[0-9]+)_thumb(\.[^/.]+)(?:[?#].*)?$/, "$1$2");
			if ((domain_nosub === "mainbabes.com" && domain.match(/^content[0-9a-z]*\./)) ||
				(domain_nosub === "livejasminbabes.net" && domain.match(/^content[0-9a-z]*\./)) ||
				(domain_nosub === "babesandgirls.com" && domain.match(/^content[0-9a-z]*\./)) ||
				(domain_nosub === "exgirlfriendmarket.com" && domain.match(/^content[0-9a-z]*\./)) ||
				(domain_nosub === "rossoporn.com" && domain.match(/^content[0-9a-z]*\./)) ||
				(domain_nosub === "novostrong.com" && domain.match(/^content[0-9a-z]*\./)) ||
				(domain_nosub === "novoporn.com" && domain.match(/^content[0-9a-z]*\./)) ||
				(domain_nosub === "silkengirl.com" && /^content[0-9a-z]*\./.test(domain)) ||
				(domain_nosub === "girlsofdesire.org" && /^content[0-9a-z]*\./.test(domain)) ||
				(domain_nosub === "babesbang.com" && /^content[0-9a-z]*\./.test(domain)) ||
				(domain && domain.match(/^content[0-9a-z]*\./) && src.match(/^[a-z]+:\/\/[^/]*\/[^/.]*(?:\.[^/.]*)?\/[0-9]{4,}\/(?:[^/]*_)?tn_[0-9]{2}\.[^/.]*(?:[?#].*)?$/)) ||
				(domain_nosub === "thousandbabes.com" && domain.match(/^content[0-9a-z]*\./)) ||
				(domain_nosub === "morazzia.com" && domain.match(/^content[0-9a-z]*\./)) ||
				(domain_nosub === "babesmachine.com" && domain.match(/^content[0-9a-z]*\./)) ||
				(domain_nosub === "glam0ur.com" && domain.match(/^content[0-9a-z]*\./)) ||
				domain_nosub === "avidolz.com" ||
				domain_nosub === "pbabes.com" ||
				(domain === "static.thenude.eu" && string_indexof(src, "/galleries/") >= 0) ||
				(domain_nowww === "eros-and-grace.net" && string_indexof(src, "/galleries/") >= 0) ||
				domain === "gals.sextronix.com" ||
				domain === "fhg.baberotica.com" ||
				domain_nosub === "pornodontstop.com") {
				newsrc = src.replace(/(\/(?:[^/]*_)?)tn_([0-9]+\.[^/.]*)(?:[?#].*)?$/, "$1$2");
				if (newsrc !== src)
					return newsrc;
				if (domain_nosub === "novoporn.com" ||
					domain_nosub === "silkengirl.com" ||
					domain_nosub === "babesbang.com" ||
					domain_nosub === "morazzia.com") {
					return src.replace(/(\/[0-9]+\/+)([0-9]+\.)/, "$1orig_$2");
				}
			}
			if (domain_nowww === "phun.org") return src.replace(/(\/galleries\/.*\/images\/+)tn_/, "$1");
			if (domain_nosub === "livejasminbabes.net" && domain.match(/^content[0-9]*\./)) {
				return src.replace(/\/upload\/main\/tn\//, "/upload/main/");
			}
			if (domain === "static.thenude.eu") return src.replace(/(\/admin\/+covers\/+.*\/+)(?:thumbs|medheads)\/+/, "$1");
			if ((domain_nowww === "captaingoodlink.com" && string_indexof(src, "/celebrities/") >= 0) ||
				domain_nowww === "nudecelebs-a-z.com" ||
				domain_nowww === "poseposter.com" ||
				(domain_nosub === "tacamateurs.com" && domain.match(/^cdn(?:-[^/]*)?\./) && src.match(/\/tn_pic[0-9]+\./))) {
				return src.replace(/\/tn_([^/]*\.[^/.]*)(?:[?#].*)?$/, "/$1");
			}
			if (domain_nosub === "pornodontstop.com" ||
				domain === "hosted.amourangels.com" ||
				domain_nowww === "hornyteen.pro" ||
				domain_nowww === "theasianpics.com" ||
				domain_nowww === "teenporngallery.net" ||
				domain_nowww === "asiangalleries.net" ||
				domain_nowww === "chinesepornpics.com" ||
				domain_nowww === "asianteenpictures.com" ||
				domain_nowww === "japanesegirlspictures.com" ||
				domain_nowww === "koreanpornpictures.com" ||
				domain_nowww === "sexyasians.net" ||
				domain_nowww === "maturexxxpics.net" ||
				domain_nowww === "japxxx.pro" ||
				domain_nowww === "girlsnudepussy.com" ||
				domain_nowww === "hornybabepics.com" ||
				domain === "hosted.showybeauty.com" ||
				domain_nowww === "sexyhairyvagina.com" ||
				domain_nowww === "pronpic.org" ||
				domain_nowww === "teengalleries.mobi") {
				return src.replace(/\/th_([0-9]+\.[^/.]*)$/, "/$1");
			}
			if (domain === "i.girlstop.info" ||
				domain_nosub === "girlstop-extra.info" ||
				domain_nosub === "girlstop.info") {
				return src.replace(/\/thumbs\/+[0-9]+px_([^/]*)$/, "/$1");
			}
			if (domain === "photos.freeones.com") return src.replace(/(:\/\/[^/]*\/[^/]*_[^/]*\/+[^/]*\/+[^/]*\/+)([^/]*)(?:[?#].*)?$/, "$1images/$2");
			if (domain === "cdn.freeones.com" ||
				domain === "media.freeones.com") {
				return src
					.replace(/(\/(?:photo-[^/]+|freeones-photo-generated)\/+.*)_big(\.[^/.]+)(?:[?#].*)?$/, "$1_ultra$2")
					.replace(/(\/(?:photo-[^/]+|freeones-photo-generated)\/+.*)_preview(\.[^/.]+)(?:[?#].*)?$/, "$1_big$2");
			}
			if (domain_nosub === "freeones.com" && /img\./.test(domain)) {
				newsrc = src.replace(/\/pinned_pictures\/pin\//, "/pinned_pictures/original/");
				if (newsrc !== src)
					return newsrc;
				match = src.match(/^[a-z]+:\/\/[^/]+\/+videos\/+([0-9]{3}\/+[0-9a-zA-Z]{2}\/+[0-9a-zA-Z]{2}\/+[^/]{10,}\/+)(?:poster)\/+/);
				if (match) {
					return [
						{
							url: "https://videolb.freeones.com/fo/" + match[1] + "list.smil/playlist.m3u8",
							video: "hls"
						},
						{
							url: "https://videolb.freeones.com/fo/" + match[1] + "list.smil/manifest.mpd",
							video: "dash"
						}
					];
				}
				return src.replace(/(\/photos\/+[0-9]{3}\/+[0-9a-zA-Z]{2}\/+[0-9a-zA-Z]{2}\/+[^/]{10,}\/+)(?:preview|teaser)\/+/, "$1big/");
			}
			if (domain === "videolb.freeones.com") {
				match = src.match(/^[a-z]+:\/\/[^/]+\/+fo\/+([0-9]{3}\/+[0-9a-zA-Z]{2}\/+[0-9a-zA-Z]{2}\/+[^/]{10,}\/+)(?:trailerWebM)\./);
				if (match) {
					return [
						{
							url: "https://videolb.freeones.com/fo/" + match[1] + "list.smil/playlist.m3u8",
							video: "hls"
						},
						{
							url: "https://videolb.freeones.com/fo/" + match[1] + "list.smil/manifest.mpd",
							video: "dash"
						}
					];
				}
			}
			if (domain_nowww === "freeones.com") {
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+video\/+([-a-z0-9]+)\/*(?:[?#].*)?$/,
					query_for_id: "https://www.freeones.com/video/${id}",
					process: function(done, resp, cache_key) {
						var match = resp.responseText.match(/loadFOPlayer\(.*?({\s*\n[\s\S]*?})\);\s*\n/);
						if (!match) {
							console_error(cache_key, "Unable to find match for", resp);
							return done(null, false);
						}
						var json_text = fixup_js_obj(match[1]);
						var json = JSON_parse(json_text);
						var urls = [];
						array_foreach(json.src, function(url) {
							var video = true;
							if (url.type === "application/x-mpegURL") {
								video = "hls";
							} else if (url.type === "application/dash+xml") {
								video = "dash";
							} else if (url.type === "video/mp4") {
								video = true;
							} else {
								console_warn(cache_key, "Unsupported video type", url);
								return;
							}
							urls.push({
								url: url.src,
								video: video
							});
						});
						urls.push(json.poster);
						var obj = {
							extra: {
								page: resp.finalUrl,
								caption: json.chromecast.metadata.title
							}
						};
						return done(fillobj_urls(urls, obj), 6 * 60 * 60);
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (host_domain_nowww === "freeones.com") {
				newsrc = common_functions["get_pagelink_host_el_matching"](options, {
					url_match: /^[a-z]+:\/\/[^/]+\/+video\/+([-a-z0-9]+)\/*(?:[?#].*)?$/,
					el_match: function(x) {
						return x.tagName === "DIV" && x.classList.contains("player");
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain_nowww === "starspics.ru" ||
				domain_nowww === "otherstars.ru") {
				return src.replace(/(:\/\/[^/]*\/)thumbs\//, "$1img/");
			}
			if (domain === "images.apina.biz") return src.replace(/(:\/\/[^/]*\/)[a-z]+\/[a-z]+_([0-9]+\.[^/.]*)$/, "$1full/$2");
			if (domain_nowww === "wallpaperaccess.com") return src.replace(/\/thumb\/+([0-9]+\.)/, "/full/$1");
			if (domain_nowww === "pluska.sk" ||
				domain_nosub === "casopiszdravie.sk") {
				return src.replace(/\/thumb\/images\/(.*?)(?:[?#].*)?$/, "/images/$1");
			}
			if (domain_nowww === "mad-movies.com") return src.replace(/(:\/\/[^/]*\/)[0-9]+-[0-9]+-[0-9]+-images\//, "$1images/");
			if (domain === "assets.mycast.io") return src.replace(/(\/[0-9]+)_[a-z]+(\.[^/.]*)$/, "$1_original$2");
			if (domain === "cdn.cinemur.fr") return src.replace(/(?:\/cache\/[0-9]+x[0-9]+_|\/blur\/)([0-9]+\.[^/.]*)$/, "/original/$1");
			if (domain_nowww === "farfarawaysite.com") return src.replace(/\/hires\/t\//, "/hires/");
			if (domain === "movieplayer.net-cdn.it" ||
				domain === "d17vsf20mehj1i.cloudfront.net" ||
				domain === "multiplayer.net-cdn.it") {
				return src.replace(/(?:\/(?:thumbs|t))?(\/+images\/.*?|:\/\/[^/]*\/[^/]*)_([a-z]+)_(?:[0-9]+x[0-9]+_)?(?:crop_)?(?:upscale_)?(?:q[0-9]+)?(\.[^/.]*)$/, "$1.$2");
			}
			if (domain === "u.livelib.ru") {
				return src
					.replace(/\/[a-z](\/[a-z0-9]+\/)[^/]*(\.[^/.]*)$/, "/o$1o-o$2")
					.replace(/\.jpg(\?.*)?$/, ".jpeg$1");
			}
			if (domain_nosub === "celebsnetworth.org") return src.replace(/(:\/\/[^/]*\/main\/)thumbs\//, "$1images/");
			if (domain === "file.hstatic.net") return src.replace(/(\/file\/[^/]*-[0-9]+)_[a-z]+(\.[^/.]*)$/, "$1$2");
			if (domain === "sm.askmen.com") return src.replace(/(:\/\/[^/]*\/)t\/(.*\/[^/]*)\.[0-9]+(\.[^/.]*)$/, "$1$2$3");
			if (domain_nosub === "elsiglodetorreon.com.mx" && /^media[0-9]*\./.test(domain)) {
				newsrc = src.replace(/:\/\/[^/]*\/+(n?[a-z]\/+)/, "://www.elsiglodetorreon.com.mx/m/$1");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nowww === "elsiglodetorreon.com.mx" ||
				domain_nowww === "siglo.mx") {
				newsrc = src
					.replace(/(:\/\/[^/]*\/+(?:[^/]*\/+)?m\/+)ni\/+(.*\/[0-9]+)\.[0-9]+(\.[^/.]*)$/, "$1i/$2$3");
				if (newsrc !== src)
					return newsrc
						.replace(/\.jpg(\?.*)?$/, ".jpeg$1");
			}
			if (domain_nowww === "elsiglo.mx") {
				return src
					.replace(/(:\/\/[^/]*\/m\/)n([a-z]\/.*\/[0-9]+)\.[0-9]+(\.[^/.]*)$/, "$1$2$3")
					.replace(/(\/[0-9]+)_[a-z](\.[^/.]*)$/, "$1$2")
					.replace(/\.jpg(\?.*)?$/, ".jpeg$1");
			}
			if (domain === "img.richestcelebrities.org" ||
				domain_nowww === "celebritypictures.wiki" ||
				domain === "img.networthpost.org" ||
				domain_nowww === "thefappeningpics.com") {
				return src.replace(/(:\/\/[^/]*\/)thumbs\//, "$1images/");
			}
			if (domain_nowww === "fashionscene.nl") return src.replace(/_thumb_[0-9]+x[0-9]+(\.[^/.]*)$/, "$1");
			if (domain_nowww === "monitor.bg") return src.replace(/\/gallery\/thumb_[0-9]+x[0-9]+_([^/]*)$/, "/gallery/$1");
			if (domain_nowww === "textilwirtschaft.de" ||
				domain_nowww === "fashionmagazine.it") {
				return src.replace(/(\/gallery\/media\/[0-9]+\/[0-9]+)-[a-z]+(\.[^/.]*)$/, "$1$2");
			}
			if (domain_nowww === "horizont.net" && string_indexof(src, "/media/") >= 0) {
				return src.replace(/(-[0-9]+)-[a-z]+(\.[^/.]*)$/, "$1$2");
			}
			if (domain === "twproxy.stiletto.fr") return src.replace(/^[a-z]+:\/\/[^/]*\/[0-9a-z]+\/[wh][0-9]+\//, "http://");
			if (domain_nowww === "we123.com") {
				return decodeURIComponent(src.replace(/^[a-z]+:\/\/[^/]*\/img\/p\.php.*?[?&]p=([^&]*).*?$/, "$1"));
			}
			if (domain_nosub === "vagalume.com" && /^s[0-9]*\./.test(domain)) {
				return src.replace(/(\/images\/g?[0-9]+)[wh][0-9]+(\.[^/.]*)$/, "$1$2");
			}
			if (domain_nosub === "glanacion.com" && domain.match(/^bucket[0-9]*\./)) {
				return src.replace(/(\/fotos\/+[0-9]+\/+[0-9]+)[wh][0-9]+(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			}
			if (domain === "storage.gra1.cloud.ovh.net" &&
				src.match(/\/Futurenet[^/]*Images\//)) {
				return src.replace(/_[0-9]+x[0-9]+(\?.*)?$/, "$1");
			}
			if (domain === "iasbh.tmgrup.com.tr") {
				return decodeURIComponent(src.replace(/^[a-z]+:\/\/[^/]*\/[0-9a-f]+\/(?:[0-9]+\/){5}[0-9]+.*?[?&]u=([^&]*).*?$/, "$1"));
			}
			if (domain === "i.sabah.com.tr") return src.replace(/(\/sb\/+[^/]*\/+magazin\/+[^/]*\/+[^/]*)_[a-z](\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain_nowww === "bideew.com") return src.replace(/(\/photos\/thumbnail\/[0-9]+\/)[a-z]+(\/*)(\?.*)?$/, "$1master$2$3");
			if (domain === "media.filfan.com") return src.replace(/(\/NewsPics\/[^/]*\/)[a-z]+(\/[^/]*)$/, "$1original$2");
			if (domain_nowww === "ana.rs") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/forum\/thumbs\/img\.php.*?[?&]src=([^&]*).*?$/, "$1");
				if (newsrc !== src)
					return decodeuri_ifneeded(newsrc);
			}
			if (domain_nowww === "squa.re") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/wp-content\/+themes\/+[^/]*\/+img\.php.*?[?&]src=([^&]*).*?$/, "$1");
				if (newsrc !== src)
					return urljoin(src, newsrc, true);
			}
			if (domain_nosub === "itvnet.lv" &&
				src.match(/\/upload[0-9]*\/articles\//)) {
				return src
					.replace(/\/thumbs\/[0-9]+([^/]*)$/, "/images/$1")
					.replace(/\/images\/([^_][^/]*)$/, "/images/_origin_$1");
			}
			if (domain_nowww === "connectgalaxy.com") return src.replace(/\/gallery\/icon\/([0-9]+)\/[a-z0-9]+(\?.*)?$/, "/gallery/download/$1");
			if (domain === "nst.sky.it" ||
				domain === "sydney.edu.au" ||
				(domain_nosub === "deloitte.com" && /^www/.test(domain)) ||
				domain === "about.hm.com" ||
				domain_nowww === "prada.com" ||
				domain_nowww === "hbo.com") {
				return src.replace(/(\/[^/]*\.[^/.]*)\/_jcr_content\/renditions\/.*/, "$1");
			}
			if (domain === "cdnimage.terbitsport.com") {
				return decodeURIComponent(src.replace(/^[a-z]+:\/\/[^/]*\/image\.php.*?[?&]image=([^&]*).*?$/, "$1"));
			}
			if (domain_nowww === "beimg.com") {
				return decodeURIComponent(src.replace(/^[a-z]+:\/\/[^/]*\/fangimg\.php.*?[?&]url=([^&]*).*?$/, "$1"));
			}
			if (domain_nowww === "que.es") return src.replace(/-[0-9X]+x[0-9X]+(?:x[0-9]+)?(\.[^/.]*)$/, "$1");
			if (domain_nowww === "independent.com.mt") return src.replace(/(:\/\/[^/]*\/file\.aspx).*?[?&](f=[0-9]+).*?$/, "$1?$2");
			if (domain === "img.selenka.pl") return src.replace(/(\/(?:fb)?walls\/[0-9a-f]+\/)[a-z](\.[^/.]*)$/, "$1o$2");
			if (domain === "ki.ill.in.ua") return src.replace(/\/[0-9]+x[0-9]+(\/[0-9]+\.[^/.]*)$/, "/0x0$1");
			if (domain === "stg.pcg.space") return src.replace(/\/[a-z]+(\.[^/.]*)$/, "/org$1");
			if (domain === "static.noticiasaominuto.com" ||
				domain === "static.noticiasaominuto.com.br") {
				return src.replace(/(\/stockimages\/)(?:gallery\/)?[^/]*(\/[^/]*)$/, "$1hires_original$2");
			}
			if (domain === "media-manager.noticiasaominuto.com") {
				return src
					.replace(/\?.*/, "")
					.replace(/(:\/\/[^/]*\/)[0-9]+\/+[0-9]+\/+(naom_)/, "$1$2");
			}
			if (domain_nowww === "harry-potter.net.pl") return src.replace(/(\/images\/photoalbum\/[^/]*\/[^/]*)_t[0-9](\.[^/.]*)$/, "$1$2");
			if ((domain_nosub === "kanobu.ru" ||
				domain_nosub === "kanobu.net") &&
				domain.match(/^i[0-9]*\./)) {
				return src.replace(/:\/\/[^/]*\/r\/[0-9a-f]+\/[-0-9]+x[-0-9]+\//, "://");
			}
			if (domain_nowww === "tv3.lt" ||
				domain_nosub === "inspektorius.lt") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/+usi\/+[0-9]+x[0-9]+\/+.*?[?&]f=([^&]*).*?$/, "$1");
				if (newsrc !== src)
					return urljoin(src, decodeURIComponent(newsrc), true);
			}
			if (domain_nosub === "gallery.ru" &&
				domain.match(/^data[0-9]*\.(?:i\.)?gallery\.ru/)) {
				return src.replace(/(\/albums\/gallery\/[^/]*-[0-9]{5,}-)[whmc]?[0-9]+(?:x[0-9]+)?(?:-[0-9a-z]+)?(\.[^/.]*)$/, "$1$2");
			}
			if (domain_nowww === "fotosdefamosas.tk") return src.replace(/\/miniaturas\/TN_([^/]*)$/, "/$1");
			if (domain_nowww === "starwiki.org") {
				return {
					url: src.replace(/\/thumbs\/photos\//, "/photos/"),
					head_wrong_contenttype: true
				};
			}
			if (domain_nowww === "postervdom.ru" && string_indexof(src, "/upload/") >= 0) {
				return src.replace(/(\/item_[0-9]+\/)[a-z]+_(item_[0-9]+[^/]*)$/, "$1$2");
			}
			if ((domain_nosub === "fastpic.ru" || domain_nosub === "fastpic.org") &&
				domain.match(/^i[0-9]*\./)) {
				return {
					url: src.replace(/(:\/\/[^/]*\/)thumb(\/.*\.)jpeg/, "$1big$2jpg?noht=1"),
					headers: {
						Referer: "https://" + domain_nosub + "/",
						"Sec-Fetch-Dest": "image",
						"Accept": "image/webp,image/apng,image/*,*/*;q=0.8"
					}
				};
			}
			if (domain === "i.nahraj.to") return src.replace(/(:\/\/[^/]*\/)[a-z](\/[^/]+\.[^/.]*)$/, "$1f$2");
			if (domain === "skwww.plusden.sk") return src.replace(/\/thumb(\/images\/gallery\/.*?)(?:\?.*)?$/, "$1");
			if (domain_nowww === "admags.xyz" ||
				domain_nowww === "hotmags.xyz") {
				return src.replace(/_tb(\/[^/]*)$/, "$1");
			}
			if (domain === "img.topky.sk") return src.replace(/(\/dc\/+[0-9]+\/+)thumb\//, "$1");
			if (domain_nowww === "kungahuset.org") return src.replace(/\/uploads\/thumb\/[0-9]+X[0-9]+_/, "/uploads/");
			if (domain_nosub === "e-monsite.com") return src.replace(/\/resize_[0-9]+_[0-9]+\//, "/");
			if (domain === "static.guide.supereva.it" ||
				domain === "media.gossipblog.it" ||
				domain === "media.fashionblog.it") {
				return src.replace(/\/thn_([^/]*)$/, "/$1");
			}
			if (domain_nowww === "apachan.net" ||
				domain_nowww === "prokote.info") {
				return src.replace(/(:\/\/[^/]*\/)(?:thumbs|previews)\//, "$1images/");
			}
			if (domain === "imggaleri.hurriyet.com.tr" ||
				domain === "imgkelebek.hurriyet.com.tr") {
				return src.replace(/(\/+LiveImages\/+[^/]*\/+[0-9]+\/+[^/]*)(?:\/+ThumbFolder)?\/+([^/]*)$/, "$1/LargeFolder/$2");
			}
			if (domain_nowww === "army.mil") return src.replace(/(\/e2\/c\/images\/)(.*\/)size[0-9]*(\.[^/.]*)$/, "$1$2original$3");
			if (domain_nosub === "disquscdn.com") {
				regex = /(\/uploads\/+users\/+[0-9]+\/+[0-9]+\/+avatar)(?:36|92|128)\./;
				if (regex.test(src)) {
					return replace_sizes(src, [
						src.replace(regex, "$1200."),
						src.replace(regex, "$1128.")
					]);
				}
				return decodeURIComponent(src.replace(/^[a-z]+:\/\/[^/]*\/get.*?[?&]url=([^&]*).*?$/, "$1"));
			}
			if (domain_nowww === "smore.com") {
				return decodeURIComponent(src.replace(/^[a-z]+:\/\/[^/]*\/external_image.*?[?&]url=([^&]*).*?$/, "$1"));
			}
			if (domain === "images.ctfassets.net") {
				return src.replace(/\?.*$/, "");
			}
			if (domain_nosub === "okccdn.com") return src.replace(/(\/php\/load_okc_image\.php\/images\/)(?:[0-9]+(?:x[0-9]+)?\/){1,}([0-9]+\.[^/.]*)$/, "$1$2");
			if (domain_nosub === "metapix.net" ||
				domain_nowww === "inkbunny.net") {
				newsrc = src.replace(/\/files\/[a-z]+\/([0-9]+\/[^/]*)$/, "/files/full/$1");
				if (newsrc === src)
					newsrc = src.replace(/\/thumbnails\/[a-z]*\/([0-9]+\/[0-9]+[^/]*?)(?:_noncustom)?(\.[^/.]*)$/, "/files/full/$1$2");
				if (newsrc !== src)
					return add_extensions(newsrc);
				return src.replace(/(\/usericons\/+)(?:tiny|small)\/+/, "$1large/");
			}
			if (domain === "cdn.furiffic.com") {
				return add_extensions(src.replace(/(:\/\/[^/]*\/)[a-z]+(\/[0-9]+\.[^/.]*)$/, "$1originals$2"));
			}
			if (domain === "d3gz42uwgl1r1y.cloudfront.net") {
				return add_extensions(src.replace(/(\/submission\/[0-9]+\/[0-9]+\/[0-9a-f]+)\/[0-9]+x[0-9]+(\.[^/.]*)$/, "$1$2"));
			}
			if (domain_nosub === "route50.net") return src.replace(/(\/data\/gallery\/submissions\/[0-9a-f]+_)[a-z]+(\.[^/.]*)$/, "$1full$2");
			if (domain === "img.luxusbenz.com" ||
				domain === "img.bmwcase.com" ||
				domain === "img.benzspirit.com") {
				return src.replace(/(:\/\/[^/]*\/)[a-z]+(\/[a-f0-9]+(?:-[^/]*)?\.[^/.]*)$/, "$1full$2");
			}
			if (domain === "dot.asahi.com") return src.replace(/\/upload\/[0-9]+_([0-9]{10,}_[0-9]+\.[^/.]*)$/, "/upload/$1");
			if (domain === "p.potaufeu.asahi.com") return src.replace(/(\/picture\/+[0-9]+\/+[0-9a-f]{10,})_[0-9]+px\./, "$1.");
			if (domain === "news-img.dwango.jp" ||
				amazon_container === "img-news-dwango-jp-prod" ||
				amazon_container === "green-img-news-dwango-jp-prod") {
				newsrc = src.replace(/(\/uploads\/[a-z]+\/file\/.*\/)(?:md|sm|lg|xl)_([^/]*)$/, "$1$2");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/:\/\/news-img\.dwango\.jp\//, "://green-img-news-dwango-jp-prod.s3.amazonaws.com/");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nowww === "getnews.jp") return src.replace(/^[a-z]+:\/\/[^/]*\/thumb2\/ext\/([a-z]+:\/\/.*)$/, "$1");
			if (domain_nowww === "amuro.fr" ||
				domain_nowww === "freshfappening.com" ||
				domain_nowww === "pornoplaatjes.nl" ||
				domain_nowww === "thefappening.sexy" ||
				domain_nowww === "thefappening.rocks" ||
				domain === "gallery.cyclegarden.com" ||
				src.match(/\/_data\/+i\/+upload\/+/)) {
				newsrc = src.replace(/(\/_data\/+i\/+(?:upload|galleries)\/+[0-9]{4}\/+(?:[0-9]{2}\/+){2}[0-9]{10,}-[0-9a-f]+)-th\./, "$1-me.");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/\/i\.php\?\/upload\/+/, "/_data/i/upload/");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/\/_data\/+i(\/+(?:upload|galleries)\/+(?:[0-9]{4}\/+(?:[0-9]{2}\/+){2}[0-9]{10,}-[0-9a-f]+|[^/]+\/+[^/]+\/+[^/]+))-(?:[^/.]*|cu_s[0-9]+x[0-9]+)(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nosub === "cdn-news30.it") return src.replace(/\/blobs\/variants\/((?:[a-f0-9]\/){4}[-0-9a-f]+)_[a-z]+(\.[^/.]*)$/, "/blobs/full/$1$2");
			if (domain_nowww === "osobnosti.cz") {
				if (/\/img\/+pic-hover\./.test(src))
					return {
						url: src,
						bad: "mask"
					};
			}
			if (domain === "imagebox.cz.osobnosti.cz" ||
				domain === "img.osobnosti.cz") {
				return src.replace(/\/[A-Z]([0-9]+)(?:-[0-9]+x[0-9]+)?(-[0-9a-z]+)?(\.[^/.]*)(?:[?#].*)?$/, "/O$1$2$3");
			}
			if (domain === "spicy.southdreamz.com") return src.replace(/\/cache\/(.*?)(?:_[0-9]+|(?:(?:_[a-z][0-9]+){1,}(?:_thumb)?))(\.[^/.]*)$/, "/spicysource/$1$2");
			if (domain === "img.miumag.pl") return src.replace(/\/[a-z]([0-9]+\.[^/.]*)$/, "/c$1");
			if (domain_nowww === "hotnews.bg") return src.replace(/(\/uploads\/news\/[^/]*\/)thumb(\/[0-9]+\.[^/.]*)$/, "$1images$2");
			if (domain === "mediaproxy.salon.com" ||
				domain === "mediaproxy.snopes.com") {
				return src.replace(/^[a-z]+:\/\/[^/]+\/+[a-z]+\/+[0-9]+\/+(https?:\/\/)/, "$1");
			}
			if (domain_nosub === "cloudimg.io" ||
				(domain_nosub === "furniture1.eu" && /^cdn[0-9]*\./.test(domain))) {
				var get_orig_cloudimg_url = function(url) {
					var aliases = {};
					if (domain === "heise.cloudimg.io") {
						aliases["_www-heise-de_"] = "https://www.heise.de";
					}
					if (domain === "cdm0lfbn.cloudimg.io") {
						aliases["_origin_"] = "https://static1.seecannes.com";
					}
					if (domain === "cdheefyn.cloudimg.io") {
						aliases["--immosquare--"] = "https://s3.amazonaws.com";
					}
					var new_domain = url.replace(/^([^/]+)\/.*/, "$1");
					for (var alias in aliases) {
						if (new_domain === alias) {
							new_domain = aliases[new_domain];
							url = new_domain + url.replace(/^[^/]+\//, "/");
							break;
						}
					}
					if (string_indexof(new_domain, ".") < 0) {
						return null;
					}
					return add_http(url);
				};
				newsrc = src.replace(/^([a-z]+:\/\/[^/]+\/+)(?:(?:cdn|cdno|fit|width|height|crop(?:_px)?|cover|fit|bound)\/(?:[0-9]+|[0-9]+(?:,[0-9]+){3}-[0-9]*x?[0-9]+|[0-9]+x[0-9]+|n(?:one)?)\/[^/@]+\/|s\/+(?:crop|width|height|resizeinbox|resizenp|cdn|fit)\/+[0-9]*(?:x[0-9]*)?\/+)/, "$1cdn/n/n/");
				if (newsrc !== src)
					return newsrc;
				if (/^[a-z]+:\/\/[^/]+\/+v7\//.test(src) && !/[?#]ci_sign=/.test(src)) {
					newsrc = src.replace(/\?.*/, "");
					if (newsrc !== src)
						return newsrc;
				}
				newsrc = src.replace(/^[a-z]+:\/\/[^/]+\/+(?:(?:cdn|cdno|fit|width|height|crop(?:_px)?|cover|fit|bound)\/(?:[0-9]+|[0-9]+(?:,[0-9]+){3}-[0-9]*x?[0-9]+|[0-9]+x[0-9]+|n(?:one)?)\/[^/]+\/|s\/+(?:crop|width|height|resizeinbox|resizenp|cdn|fit)\/+[0-9]*(?:x[0-9]*)?\/+)((?:[a-z]+:\/\/)?[^/]+\/.*?)$/, "$1");
				if (newsrc !== src)
					return get_orig_cloudimg_url(newsrc) || src;
				newsrc = src.replace(/^[a-z]+:\/\/[^/]+\/+v7\/+(.*?)(?:[?#].*)?$/, "$1");
				if (newsrc !== src)
					return get_orig_cloudimg_url(newsrc) || src;
			}
			if (domain === "1.f.ix.de") return src.replace(/^[a-z]+:\/\/[^/]+\/+scale\/.*?\/q[0-9]+\/+/, "https://www.heise.de/");
			if (domain_nowww === "cloudphoto.io" || domain === "cdn.cloudphoto.io") {
				return src.replace(/^[a-z]+:\/\/[^/]+\/+[^/]+\/+(?:width|height|crop|cover|fit|bound|none)\/+[0-9]+(?:x[0-9]+)?\/+[^/]+\/+(https?:\/\/)/, "$1");
			}
			if (domain_nowww === "kinataka.ru") return src.replace(/\/photos\/[0-9]+\/([^/]*)$/, "/photos/$1");
			if (domain === "easttouch.my-magazine.me") return src.replace(/(\/upload\/photoalbum\/)thumbnail(\/[0-9a-f]+\/[0-9a-f]+\.[^/.]*)$/, "$1original$2");
			if (domain === "tvdaily.asiae.co.kr") return src.replace(/\/upimages\/+photoda\//, "/upimages/gisaimg/");
			if (domain === "img.thefactjp.com" ||
				domain === "img.thefact.tv") {
				return src.replace(/(\/service\/[a-z]+\/[0-9]+\/[0-9]+\/[0-9]+\/)(?:[0-9]+|thumb)\/([0-9a-f]+\.[^/.]*)$/, "$1$2");
			}
			if (domain === "rlv.zcache.co.nz" ||
				domain === "rlv.zcache.ca" ||
				domain === "rlv.zcache.com.br") {
				return src.replace(/(-r[0-9a-f]+(?:_[_0-9a-z]+)?)_[0-9]+(\.[^/.?]*)(?:\?.*?)?$/, "$1_999999999$2?rvtype=content");
			}
			if (domain_nowww === "empireposter.de") return src.replace(/\/bilder\/bilder_[a-z]\//, "/bilder/bilder_l/");
			if (domain === "dg31sz3gwrwan.cloudfront.net") return src.replace(/(\/[0-9]+\/[0-9]+)_[a-z]+(?:-optimized-[0-9]*)?(\.[^/.]*)$/, "$1$2");
			if (domain === "img.mach-shiko.net") return src.replace(/(\/images\/[0-9]+\/[0-9]+\/)[a-z]\/([0-9]+\.[^/.]*)$/, "$1$2");
			if (domain === "img.onvshen.com") return src.replace(/(\/gallery\/+[0-9]+\/+[0-9]+\/+)[a-z]\/+([0-9]+\.[^/.]*)$/, "$1$2");
			if (domain === "img.geinou-img.com") return src.replace(/(\/[_0-9]+\/)[a-z]\/([0-9]+\.[^/.]*)$/, "$1$2");
			if (domain_nowww === "showbiz.cz" ||
				domain === "fotky.showbiz.cz") {
				return src.replace(/(?:\/public)?(\/+files\/+gallery\/+)thumb\/+([0-9a-f]+\/[0-9a-f]+)(?:_[a-z]+)?(\.[^/.]*)$/, "$1$2$3");
			}
			if (domain === "images.nudereviews.com") return src.replace(/(\/data\/media\/image\/)[a-z]+\//, "$1original/");
			if (domain_nowww === "thefamouspeople.com") return src.replace(/\/profiles\/thumbs\//, "/profiles/images/");
			if (domain === "i.trust.ua") return src.replace(/\/files\/photo\/[0-9]+\//, "/files/photo/source/");
			if (domain === "media.beritagar.id") return src.replace(/\/(?:lme-)?([0-9]{4}-[0-9]{2}\/)(?:[a-z]+_[0-9]+\/)?(?:wd\/+)?((?:[0-9a-f]+|[^/]*_[0-9]{5,}))(?:_imresized)?(\.[^/.]*)(?:[?#].*)?$/, "/$1$2$3");
			if (domain === "imgs.ckcdn.com" ||
				domain === "i.imgscc.com") {
				return {
					url: src.replace(/\?.*$/, ""), //src.replace(/\?.*$/, "?_w=9999999999999"),
					headers: {
						Origin: null,
						Referer: null
					},
					can_head: false
				};
			}
			if (domain === "im.mtv.fi" ||
				domain_nowww === "mz-web.de" ||
				domain === "im.mtvuutiset.fi" ||
				domain_nowww === "swissinfo.ch") {
				return src.replace(/\/image(\/[0-9]+\/)(?:(?:portrait|landscape[^/]*|3x2|max)\/[0-9]+\/[0-9]+\/)?([0-9a-f]+\/)[a-zA-Z0-9]{2}\/([^/.]+)(\.[^/.]*)$/, "/blob$1$2$3-data$4");
			}
			if (domain_nowww === "katsomo.fi") return src.replace(/^.*\/static\/+[a-z]vod\/+(?:stripe_)?images\/+(image)-([0-9]+)-(portrait|landscape[^-/]*|3x2|max)-([0-9]+)-([0-9]+)-([0-9a-f]+)-([a-zA-Z0-9]{2})-([^/]+)$/, "https://im.mtv.fi/$1/$2/$3/$4/$5/$6/$7/$8");
			if (domain_nowww === "imageweb.ws" ||
				domain_nowww === "pezporn.com" ||
				domain_nowww === "hardcoreluv.com" ||
				domain_nowww === "wildpictures.net" ||
				domain_nosub === "pussyspot.net") {
				newsrc = src.replace(/(:\/\/)cdn[0-9]*\.([^/]*\/+media\/+images)/, "$1www.$2");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/\/media\/+images_[0-9]+\//, "/media/images/");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "t.imageweb.ws" ||
				domain_nowww === "pezporn.com" ||
				domain_nosub === "pussyspot.net") {
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+[^/]+\/+([0-9]+)\.html(?:[?#].*)?$/,
					query_for_id: "http://www." + domain_nosub + "/a/${id}.html",
					process: function(done, resp, cache_key) {
						var match = resp.responseText.match(/href="(\/media\/images\/[^"]*)"/);
						if (!match) {
							console_error(cache_key, "Unable to find match for", resp);
							return done(null, false);
						}
						return done(urljoin(resp.finalUrl, match[1], true).replace(/\?.*/, ""), 6 * 60 * 60);
					}
				});
				if (newsrc)
					return newsrc;
				match = src.match(/\/media\/+[^/]*\/+[0-9]+\/+[0-9]+\/+([0-9]+)\.[^/.]*/);
				if (match) {
					var queryurl = "http://www." + domain_nosub + "/a/" + match[1] + ".html";
					return {
						url: queryurl,
						is_pagelink: true
					};
				}
			}
			if (domain_nosub === "vcg.com" &&
				domain.match(/goss[0-9]*\.vcg/)) {
				return src.replace(/\/editorial\/vcg\/[0-9]+\//, "/editorial/vcg/nowarter800/");
			}
			if (domain_nosub === "renault-dacia.com.ua") {
				newsrc = urljoin("http://www.renault-dacia.com.ua/", decodeURIComponent(src.replace(/^[a-z]+:\/\/[^/]*\/im\.php.*?[?&]image=([^&]*).*?$/, "$1")), true);
				if (newsrc !== src)
					return newsrc;
				return src.replace(/\/pictgen\/[0-9]+\//, "/topicsfoto/");
			}
			if (domain_nowww === "numberoneturk.com.tr" ||
				domain_nowww === "fashionone.com.tr") {
				return src.replace(/(\/plog-content\/+)thumbs(\/+.*\/+)[a-z]+\/+[0-9]+-([^/]*)$/, "$1images$2$3");
			}
			if (domain === "prsize.allviki.com") return src.replace(/:\/\/[^/]*\/resize_[0-9]+(?:x[0-9]+)?\//, "://pic.allviki.com/");
			if (domain_nowww === "celebritygalls.com") return src.replace(/\/cache\/(.*)_[0-9]+_cw[0-9]+_ch[0-9]+_thumb(\.[^/.]*)$/, "/albums/$1$2");
			if (domain_nowww === "instantfap.com") return src.replace(/:\/\/[^/]*\/image\/([^/]*)$/, "://i.imgur.com/$1");
			if (domain_nowww === "agensite.com" ||
				domain === "cdn.agensite.online" ||
				domain === "cdn.conexaohost.com.br") {
				return {
					url: src
						.replace(/\/img\/[0-9]+x[0-9]+\//, "/img/original/")
						.replace(/\/temp\/img\/([0-9a-z]+)_([0-9]+)_([0-9a-z]+)_([0-9a-z]+)_([0-9]+)_([a-z]+)_[^/]*$/, "/img/original/0/0/png/$1/$2/$3/$4/$5.$6")
						.replace(/\/imagizer_export\.php\?([^,]*).*/, "/img/original/0/0/png/$1"),
					redirects: true
				};
			}
			if (domain === "images.mtvnn.com") return src.replace(/(:\/\/[^/]*\/[0-9a-f]+\/)[0-9]+(?:x[0-9]+)?_?(\.[^/.?]*)?(?:[?#].*)?$/, "$1original$2");
			if (domain === "assets.deutschlandfunk.de") return src.replace(/(\/[-0-9a-f]{20,}\/+)[0-9]+x[0-9]+\./, "$1original.");
			if (domain_nowww === "hipernoticias.com.br" ||
				domain_nowww === "noticiamax.com.br") {
				return src.replace(/(\/storage\/+webdisco\/+[0-9]+\/+[0-9]+\/+[0-9]+\/).*(\/[0-9a-f]+\.[^/.]*)$/, "$1original$2");
			}
			if (domain_nowww === "bd-journal.com") {
				match = src.match(/\/image-contents\/[0-9]+x[0-9]+x[0-9]+\/news-photos\/((?:[0-9]+\/){2,})([-0-9a-zA-Z_=+]+)(?:[?#].*)?$/);
				if (match) {
					return src.replace(/(:\/\/[^/]*\/).*/, "$1") + "assets/news_photos/" + match[1] + base64_decode(match[2]);
				}
			}
			if (domain_nowww === "myidol.com.vn") return src.replace(/\/pictures\/pic[a-z]+(\/[0-9]+\/[0-9]+\/[0-9]+\/)[0-9]+\/([a-z]+[0-9]+\.[^/.]*)$/, "/pictures/picfullsizes/$1$2");
			if (domain_nowww === "dw.com") return src.replace(/(:\/\/[^/]*\/image\/[0-9]+_)[0-9]+(\.[^/.]*)$/, "$17$2");
			if (domain_nowww === "finds.ir") return src.replace(/\/img\/tu\//, "/img/");
			if ((domain_nosub === "xuk.mobi" ||
				domain_nosub === "xuk.one" ||
				domain_nosub === "xuk.life" ||
				domain_nosub === "xuk.ooo") &&
				domain.match(/^img[0-9]*\./) &&
				string_indexof(src, "/images/photos/") >= 0) {
				return src.replace(/\/(?:thumb|big|mini)\/+([0-9a-f]+\.[^/.]*)$/, "/origin/$1");
			}
			if (domain === "s.filmsextv.com") return src.replace(/(\/[0-9a-f]+\/)thumbs\/([0-9a-f]+\.[^/.]*)$/, "$1$2");
			if (domain_nowww === "lanita.ru" &&
				string_indexof(src, "/images/offer/") >= 0) {
				return src.replace(/(\/[0-9]+)-thumb(\.[^/.]*)$/, "$1$2");
			}
			if (domain_nowww === "backalleypics.net") return src.replace(/(\/images\/(?:[0-9]+-[0-9]+-[0-9]+|photoshoots)\/)thumbs\/([^/]*)$/, "$1$2");
			if (domain_nowww === "turboimagehost.com") {
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+p\/+([0-9]+)\/+([^/?#]+\.html)(?:[?#].*)?$/,
					query_for_id: "https://www.turboimagehost.com/p/${1}/${2}",
					process: function(done, resp, cache_key) {
						var image = get_meta(resp.responseText, "og:image");
						if (!image) {
							console_error(cache_key, "Unable to find og:image from", resp);
							return done(null, false);
						}
						return done({
							url: image,
							is_original: true,
							extra: {
								page: resp.finalUrl
							}
						}, 6 * 60 * 60);
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain_nosub === "turboimg.net" ||
				domain_nosub === "turboimagehost.com") {
				match = src.match(/\/t[0-9]*\/+([0-9]+)_([^/?#]+)(?:[?#].*)?$/);
				if (match) {
					return {
						url: "https://www.turboimagehost.com/p/" + match[1] + "/" + match[2] + ".html",
						is_pagelink: true
					};
				}
			}
			if (domain_nowww === "arhivach.cf" ||
				domain_nowww === "arhivach.ng") {
				return src.replace(/(\/storage[0-9]*\/)t\/([0-9a-f])([0-9a-f]{2})([0-9a-f]+\.[^/.]*)$/, "$1$2/$3/$2$3$4");
			}
			if (domain === "content.wafflegirl.com" ||
				domain_nosub === "youx.xxx" ||
				domain_nosub === "xxxwaffle.com" ||
				domain === "cdn.pornpictureshq.com") {
				return {
					url: src.replace(/\/gthumb\/(.*)(?:__x[0-9]+|_[0-9]+x(?:[0-9]+)?_?)(\.[^/.]*)$/, "/content/$1$2"),
					can_head: false // youx.xxx returns 404
				};
			}
			if (domain_nowww === "anawalls.com") {
				return decodeURIComponent(src.replace(/^[a-z]+:\/\/[^/]*\/repic\/image\.php.*?[?&]src=([^&]*).*?$/, "$1"));
			}
			if (domain === "d3ofq03apmfb8c.cloudfront.net" ||
				domain_nowww === "lipstickalley.com" ||
				(domain_nosub === "mandatory.com" && domain.match(/^cdn[0-9]*-hfboards\./)) ||
				domain === "forum.purseblog.com" ||
				(domain_nowww === "behindbigbrother.com" && string_indexof(src, "/forums/data/") >= 0) ||
				domain_nowww === "simsettlements.com" ||
				domain_nowww === "resetera.com" ||
				domain === "data.voz.vn" ||
				domain === "forums.mangadex.org" ||
				/\/avatars\/+[smlh]\/+[0-9]+\/+[0-9]+\.jpg\?[0-9]{10}$/.test(src)) {
				regex = /(\/avatar(?:s|\/+[0-9]{5,}))\/+[a-z]\/+([0-9]+\/+[0-9]+\.[^/.]*)$/;
				if (regex.test(src)) {
					return [
						src.replace(regex, "$1/o/$2"),
						src.replace(regex, "$1/l/$2")
					];
				}
			}
			if (/\/data\/+attachments\/+[0-9]+\/+[0-9]+-[0-9a-f]{20,}\.[^/.]+(?:[?#].*)?$/.test(src) && options.element) {
				if (options.element.parentElement && options.element.parentElement.tagName === "A") {
					var parent = options.element.parentElement;
					if (parent.classList.contains("js-lbImage") && /\/attachments\/+[-0-9a-f]{20,}-(?:jpeg|png)\.[0-9]+\/*(?:[?#].*)?$/.test(parent.href)) {
						return parent.href;
					}
				}
			}
			if (domain === "img-cache.cdn.gaiaonline.com") {
				return src.replace(/^[a-z]+:\/\/[^/]*\/[0-9a-f]+\//, "");
			}
			if (domain === "y.zdmimg.com") return src.replace(/(\/[0-9a-f]+\.[^/._]*)_[a-z][0-9]+\.[^/.]*$/, "$1");
			if (domain_nosub === "oboi.ws") return src.replace(/\/wallpapers\/(?:[0-9]+|[a-z])_([0-9]+_[^/]*)(?:_[0-9]+x[0-9]+)?(\.[^/.]*)$/, "/originals/original_$1$2");
			if (domain_nowww === "wallpaperscraft.com") {
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+(?:download|wallpaper)\/+((?:[^/]*_)?[0-9]+)(?:\/+[0-9]+x[0-9]+)?(?:[?#].*)?$/,
					query_for_id: "https://wallpaperscraft.com/wallpaper/${id}",
					process: function(done, resp, cache_key, match) {
						var id = match[1];
						match = resp.responseText.match(/<a[^>]*\/download\/[^>]*>\s*Original Resolution: *([0-9]+x[0-9]+)/);
						if (!match) {
							console_error(cache_key, "Unable to find match for", resp);
							return done(null, false);
						}
						return done("https://images.wallpaperscraft.com/image/" + id + "_" + match[1] + ".jpg", 6 * 60 * 60);
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain === "images.wallpaperscraft.com") {
				id = src.replace(/.*\/([^/]*)_[0-9]+x[0-9]+\.[^/.]*$/, "$1");
				if (id !== src) {
					return {
						url: "https://wallpaperscraft.com/wallpaper/" + id,
						is_pagelink: true
					};
				}
			}
			if (domain === "cdn.eso.org" ||
				domain_nowww === "eso.org") {
				return src.replace(/(\/images\/|\/archives\/postcards\/)[^/]*\/([^/.]*\.[^/.]*)$/, "$1large/$2");
			}
			if (domain_nowww === "galex.caltech.edu") {
				return src
					.replace(/(_img[0-9]*)_(?:Sm|small)(\.[^/.]*)$/, "$1$2")
					.replace(/(_vid[0-9]*)_tn(\.[^/.]*)$/, "$1_shot$2");
			}
			if (domain_nowww === "astro-austral.cl") return src.replace(/(\/imagenes\/galaxies\/[^/]*\/)[a-z]+(\.[^/.]*)$/, "$1max$2");
			if (domain_nowww === "buddhistdoor.net") return src.replace(/(\/upload\/file\/[0-9]+\/[0-9]+\/[0-9a-f]+)_[0-9]+(?:__[0-9]+)?(\.[^/.]*)$/, "$1$2");
			if (domain_nowww === "agraroldal.hu") {
				return add_extensions(src.replace(/\/[^/]*\/[0-9]+x[0-9]+\/([0-9]+\.[^/.]*)$/, "/upload/upimages/$1"));
			}
			if (domain === "media.lamsao.com") return src.replace(/\/Thumbnail\/Cache\/*Data\/(.*)_[0-9]+_[0-9]+(\.[^/.]*)$/, "/Data/$1$2");
			if (domain === "tupian.aladd.net") return src.replace(/(\.[^-/.]*)-[0-9]+(?:[?#]*)?$/, "$1");
			if (domain === "uploadfile.huiyi8.com" ||
				domain === "i.hexuexiao.cn" ||
				(domain_nowww === "popwindshop.com" && string_indexof(src, "/pics/") >= 0)) {
				return src.replace(/(\.[^/.]*)\.[0-9]+\.[^/.?#]*([?#].*)?$/, "$1$2");
			}
			if ((domain_nosub === "redocn.com" && domain.match(/^img[0-9]*\./)) ||
				domain === "image.tupian114.com") {
				return {
					url: src.replace(/(\/[^/]*\.[^/.]*)\.[0-9]+\.[^/.]*$/, "$1"),
					problems: {
						watermark: true
					}
				};
			}
			if (domain_nosub === "mangadex.org" && /\/covers\/+[-0-9a-f]{20,}\/+[-0-9a-f]{20,}[^/]+(?:[?#].*)?$/.test(src)) {
				return {
					url: src.replace(/(\.[^/.]*)\.[0-9]+\.[^/.?#]*([?#].*)?$/, "$1$2"),
					can_head: false // 404
				};
			}
			if (domain === "media.alienwarearena.com") return src.replace(/\/thumb(?:nail)?_[0-9]+x[0-9]+\/+([0-9a-f]{10,}\.[^/.]*)$/, "/media/$1");
			if (domain_nowww === "6asian.com") return src.replace(/(\/imglink\/[a-z]+)-thumb[0-9]+x[0-9]+\//, "$1/");
			if (domain === "music.fetnet.net") return src.replace(/(\/img\/album\/[0-9]+)-[0-9]+(\.[^/.]*)$/, "$1$2");
			if (domain_nowww === "wallpaperscave.ru") return src.replace(/\/images\/thumbs\/[^/]*\/[0-9]+x[0-9]+\//, "/images/original/");
			if (domain_nowww === "lilit.lv") return src.replace(/\/[0-9]+px_([0-9]+_[0-9a-f]+\.[^/.]*)$/, "/full_$1");
			if (domain === "img.kurocore.com") return src.replace(/(:\/\/[^/]*\/)thumbnail\/p\//, "$1p/");
			if (domain_nowww === "mocah.org") return src.replace(/(:\/\/[^/]*\/)thumbs\/([0-9]+-[^/]*)$/, "$1uploads/posts/$2");
			if (domain_nowww === "anime-zone.ru") return src.replace(/(\/inc\/goods_[a-z]+\/[^/]*\/)[a-z]+\/([^/]*)$/, "$1$2");
			if (domain_nowww === "99px.ru") return src.replace(/:\/\/[^/]*\/sstorage\/[0-9]+\/[0-9]+\/[0-9]+\/[a-z]+_([0-9]+)_[0-9]+\.[^/.]*$/, "://wallpapers.99px.ru/cms/mhost.php?tid=53&act=getimage&id=$1");
			if (domain_nowww === "wall2born.com") return src.replace(/\/file\/download\/[0-9]+x[0-9]+\/([0-9]+\/[^/]*)-[0-9]+x[0-9]+(\.[^/.]*)$/, "/data/out/$1$2");
			if (domain_nowww === "wallpapersexpert.com") return src.replace(/\/images\/+file\/+([0-9]+\/+)[0-9]+x[0-9]+-([0-9]+-)/, "/data/out/$1$2");
			if (amazon_container === "desktop-backgrounds-org") {
				return src.replace(/\/(?:[^-/]*-)?[0-9]+x[0-9]+\/([^/]*\.[^/.]*)$/, "/$1");
			}
			if (domain_nowww === "oboi.cc" ||
				domain_nowww === "oboik.ru") {
				return src.replace(/\/(?:[-0-9]+)?uploads(?:_full)?(\/[0-9]+_[0-9]+_[0-9]+\/)[a-z]+(\/[0-9]+\/[^/]*)$/, "/uploads$1view$2");
			}
			if (domain === "img.getbg.net") return src.replace(/\/upload\/[a-z]+\/([0-9]*\/)(?:thumbnail_)?([^/]*)$/, "/upload/full/$1$2");
			if ((domain_nosub === "fichub.com" ||
				domain === "scontent.ccdn.cloud")
				&& string_indexof(src, "/image/") >= 0) {
				return src.replace(/(\/image\/+[^/]+\/+[-0-9a-f]{30,}\/+[^/]+?)(?:-(?:maxw-[0-9]+|[0-9]+x[0-9]+))?(?:\/+[0-9]+x[0-9]+)?(\.[^/.]*)$/, "$1$2");
			}
			if (domain_nowww === "nishinippon.co.jp" && string_indexof(src, "/import/") >= 0) {
				return src.replace(/(\/[0-9]+\/[0-9]+_[0-9]+)_s(\.[^/.]*)$/, "$1$2");
			}
			if (domain_nowww === "nishinippon.co.jp") return src.replace(/(\/uploads\/+image\/+[0-9]+\/+)[a-z]+_([0-9a-f]{6,}(?:_org)?\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain === "resource.shuud.mn") return src.replace(/(\/[0-9]+)_t(\.[^/.]*)$/, "$1$2");
			if (domain_nowww === "anime-fresh.ru") return src.replace(/(\/upload\/[a-z]+\/)thumbs\/([^/]*)$/, "$1$2");
			if (domain === "imgfiles.plaync.com") return src.replace(/\/download_thumbnail\/([^/]*)$/, "/download/$1");
			if (domain_nowww === "jjdao.com") return src.replace(/(\/wiki\/uploads\/[0-9]+\/[0-9+][0-9a-zA-Z]+)_[a-z](\.[^/.]*)$/, "$1$2");
			if (domain === "t.huv.kr") {
				return decodeURIComponent(src.replace(/^[a-z]+:\/\/[^/]*\/thumb_crop_resize\.php.*?[?&]url=([^&?]*).*?$/, "$1"));
			}
			if (domain === "down.humoruniv.org") {
				return {
					url: src,
					headers: {
						Referer: ""
					}
				};
			}
			if (domain_nosub === "pocoimg.cn" &&
				domain.match(/^img[0-9]*\./)) {
				return src.replace(/_[WH][0-9]+(\.[^/.]*)$/, "$1");
			}
			if (domain_nowww === "qcmt.bid") {
				return decodeURIComponent(src.replace(/^[a-z]+:\/\/[^/]*\/upload\/.*?[?&]src=([^&]*).*?$/, "$1"));
			}
			if (domain === "pic.xiao4j.com") return src.replace(/(\/[0-9]+\.[^/._]*)_[0-9]+_[0-9]+\.[^/.]*$/, "$1");
			if (domain === "img.mm29.com") return src.replace(/(\/[0-9]+\.[^/.]*)\/[0-9]+\.[^/.]*$/, "$1");
			if (domain_nosub === "2chmatome2.jp" &&
				domain.match(/^image[0-9]*\./)) {
				return decodeURIComponent(src.replace(/^[a-z]+:\/\/[^/]*\/v2\/thumb\/app\/[0-9]+\/[0-9]+\/.*?[?&]url=([^&]*).*?$/, "$1"));
			}
			if (domain === "file.2chmatome2.jp") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/(http)/, "$1");
				if (newsrc !== src) {
					return decodeURIComponent(decodeURIComponent(newsrc));
				}
			}
			if (domain_nowww === "wnacg.net") return src.replace(/\/data\/thumb\//, "/data/");
			if (domain === "rs.n1info.com") return src.replace(/\/Thumbnail(\/[0-9]+\/)/, "/Picture$1");
			if (domain_nowww === "adevarul.ro" && string_indexof(src, "/MRImage/") >= 0) {
				return src.replace(/\/[0-9]+x[0-9]+(\.[^/.]*)$/, "/orig$1");
			}
			if (domain_nowww === "eva.bg") return src.replace(/\/media_cache\/[^/]*\/media\//, "/media/");
			if (domain === "data.kontrakty.ua") return src.replace(/(\/cache\/[a-z]+\/)[0-9]+\//, "$1orig/");
			if (domain === "d3t543lkaz1xy.cloudfront.net") return src.replace(/(\/photo\/[0-9a-f]+)_[a-z](?:[?#].*)?$/, "$1");
			if (domain_nowww === "merokhabar.net") return src.replace(/\/thumbnail\/thumb([^/]*)$/, "/original/ori$1");
			if (domain_nosub === "ali213.net" &&
				domain.match(/^img[0-9]*\./)) {
				return src.replace(/\/[0-9]+_([0-9]+\.[^/.]*)$/, "/$1");
			}
			if (domain === "cdn.magzter.com" ||
				amazon_container === "magztertemp") {
				newsrc = src.replace(/\/images\/+thumb\/+thumb_([0-9]+\.[^/.]+)(?:[?#].*)?$/, "/images/original/large_$1");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "reseuro.magzter.com" ||
				domain === "rse.magzter.com") {
				return src
					.replace(/:\/\/[^/]*\/[0-9]+x[0-9]+\/articles\//, "://magarticles.magzter.com/articles/")
					.replace(/:\/\/rse\.[^/]*\/[0-9]+x[0-9]+\//, "://cdn.magzter.com/");
			}
			if (domain === "dev.magzter.com") {
				return decodeURIComponent(src.replace(/^[a-z]+:\/\/[^/]*\/dynimage\/thumb_news\.php.*?[?&]src=([^&]*).*$/, "$1"));
			}
			if (domain === "content.haycdn.com" ||
				domain === "images.hayneedle.com") {
				return src
					.replace(/\/dynimage\.ms\?(?:.*&)?img=([^&]+).*?$/, "/$1")
					.replace(/\?is=.*/, "");
			}
			if (domain === "img.bulawayo24.com") return src.replace(/\/articles\/thumbs\/[0-9]+x[0-9]+\//, "/articles/");
			if (domain === "static.eva.ro") return src.replace(/\/img\/auto_resized\/db\/(.*)-[0-9]+x[0-9]+(?:-.-[0-9a-f]+)?(\.[^/.]*)$/, "/img/db/$1$2");
			if (domain === "s-image.hnol.net") return src.replace(/^[a-z]+:\/\/[^/]*\/x\/[0-9]+x[0-9]+\/auto\/(https?):\/\/?/, "$1://");
			if (domain === "cdn.tower.jp") return src.replace(/(:\/\/[^/]*\/za\/)[a-z]\//, "$1o/");
			if (domain_nowww === "gamers-onlineshop.jp" ||
				domain_nowww === "animate-onlineshop.jp" ||
				domain_nowww === "acoop-onlineshop.jp" ||
				domain === "cdn.melonbooks.co.jp" ||
				domain_nowww === "melonbooks.co.jp" ||
				domain === "jpstore.dwango.jp" ||
				domain_nowww === "gamers.co.jp" ||
				(domain_nosub === "techorus-cdn.com" && /^tc-/.test(domain)) ||
				domain === "melonbooks.akamaized.net") {
				return src.replace(/(:\/\/[^/]*\/)(?:(?:user_data\/packages|resize_image)\/)?resize_image\.php.*?[?&]image=([^&]*).*$/, "$1upload/save_image/$2");
			}
			if (domain_nowww === "hmv.com.hk") return src.replace(/\/data\/upload\/[0-9]+\//, "/data/upload/");
			if (domain === "img.hmv.co.jp") {
				if (/\/image\/+backimage\.gif(?:[?#].*)?$/.test(src))
					return {
						url: src,
						bad: "mask"
					};
			}
			if (domain_nowww === "buysmartjapan.com") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/images\/[0-9a-f]+.*?[?&]original=([^&]*).*$/, "$1");
				if (newsrc !== src)
					return decodeURIComponent(newsrc);
			}
			if (domain_nowww === "sonymusic.co.jp") return src.replace(/(\/adm_image\/common\/.*)__[0-9]+_[0-9]+_[0-9]+(\.[^/.]*)$/, "$1$2");
			if (domain_nosub === "imageban.ru" &&
				domain.match(/^i[0-9]*\./)) {
				return src.replace(/(:\/\/[^/]*\/)thumbs\/([0-9]+)\.([0-9]+)\.([0-9]+)\/([0-9a-f]+\.[^/.]*)$/, "$1out/$2/$3/$4/$5");
			}
			if (domain === "image.hackadoll.com") {
				return decodeURIComponent(src.replace(/^[a-z]+:\/\/[^/]*\/thumbs.*?[?&]u=([^&]*).*$/, "$1"));
			}
			if (domain === "images.niooz.fr") {
				return urljoin(src, decodeURIComponent(src.replace(/^[a-z]+:\/\/[^/]*\/safe_image\.php.*?[?&]i=([^&]*).*$/, "$1")), true);
			}
			if (domain_nowww === "mengchongzhi.com") return src.replace(/\/uploadfile\/thumb\//, "/uploadfile/");
			if (domain_nowww === "playground33.com") return src.replace(/(\/uploads\/(?:[0-9]\/){4}[0-9]+\/[0-9]+)(\.[^/.]*)$/, "$1_orig$2");
			if (domain_nosub === "trends.com.cn" &&
				domain.match(/^cdn[0-9]*\./)) {
				return src.replace(/-tweb\.[a-z]+(?:\.[^/.]*)?(?:[?#].*)?$/, "");
			}
			if (domain_nowww === "la-soubrette.fr") {
				return src
					.replace(/\/photo-ps\/+([^/]*)-([0-9]+)\./, "/photo-ps-grande/$2-$1.")
					.replace(/\/thumbs-photo-nue\//, "/photo-ps-nue/");
			}
			if (domain === "static.feber.se" && string_indexof(src, "/article_images/") >= 0) {
				return src.replace(/(\/[0-9]+)_[0-9]+(\.[^/.]*)$/, "$1$2");
			}
			if (domain_nowww === "previiew.com" ||
				domain_nowww === "lfi-online.de" ||
				domain_nowww === "s-magazine.photography" ||
				domain_nowww === "m-magazine.photography" ||
				domain_nowww === "l-mount.com" ||
				domain_nowww === "bettinaschoenbach.com" ||
				domain_nowww === "portrix-ls.de" ||
				domain_nowww === "glocon.eu" ||
				domain_nosub === "olympus.eu") {
				return {
					url: src.replace(/(\/webfile\/+img\/+[0-9]+)(?:\/+[xy]=[0-9]+)*(?:\/+[a-zA-Z0-9=]{10,})?(\/[^/]+\.[^/.?]+)?(?:[?#].*)?$/, "$1$2"),
					can_head: false
				};
			}
			if (domain === "d2e7nuz2r6mjca.cloudfront.net") return src.replace(/-[0-9]+[wh](\.[^/.]*)$/, "$1");
			if (domain_nowww === "vplate.ru" ||
				domain_nowww === "wlooks.ru") {
				return src.replace(/\/images\/article\/cropped\/[0-9]+-[0-9]+\//, "/images/article/orig/");
			}
			if (domain === "media.vogue.com") return src.replace(/(:\/\/[^/]*\/)r\/[a-z]_[0-9]+(?:(?:,|%2C)[a-z]_[0-9]+)*\//, "$1r/original/");
			if (domain_nosub === "efu.com.cn" &&
				domain.match(/^img[0-9]*\./)) {
				return src.replace(/(\/upfile\/[^/]*\/photo\/)[a-z]+\/([0-9]+\/[0-9]+\.[^/.]*)$/, "$1$2");
			}
			if (domain === "static.stopgame.ru") {
				if (/\/video\/blank\./.test(src))
					return {
						url: src,
						bad: "mask"
					};
			}
			if (domain === "images.stopgame.ru" ||
				domain_nowww === "stopga.me") {
				return src
					.replace(/(\/(?:articles|images\/+video)\/[0-9]+\/[0-9]+\/[0-9]+\/)c[0-9]+x[0-9]+\/[0-9a-zA-Z]+\/([^/]*)$/, "$1$2")
					.replace(/(\/articles\/[0-9]+\/[0-9]+\/[0-9]+\/[^/]*-[0-9]+)-s(\.[^/.]*)$/, "$1$2")
					.replace(/(\/uploads\/images\/[0-9]+\/[a-z]+\/[0-9]+\/[0-9]+\/[0-9]+\/)[a-z]+_([0-9]+\.[^/.]*)$/, "$1$2");
			}
			if (domain_nowww === "pure-nude-celebs.com" ||
				domain_nowww === "celebsandstarsnude.com" ||
				domain_nowww === "celebsking.com") {
				return src.replace(/\/pic-([^/]*)$/, "/$1");
			}
			if (domain_nowww === "pincelebs.net") return src.replace(/\/thumbs(\/(?:[0-9a-f]\/){3}[0-9a-f]+\.[^/.]*)$/, "/images$1");
			if (domain === "img.new2005.com") return src.replace(/(\/[0-9a-f]+\.[^/._]+)_old(?:[?#].*)?$/, "$1");
			if (domain === "s.libertaddigital.com") {
				return src
					.replace(/(:\/\/[^/]*\/(?:(?:fotos\/+(?:galerias\/+[^/]*|[a-z]+))|(?:[0-9]{4}\/+[0-9]{2}\/+[0-9]{2}))\/+)[0-9]+\/+[0-9]+\/+(?:fit\/+)?([^/]*)(?:[?#].*)?$/, "$1$2");
			}
			if (domain_nowww === "imgstudio.org" ||
				domain_nowww === "imgadult.com" ||
				domain_nowww === "imageboom.net" ||
				domain_nowww === "acidimg.cc" ||
				domain_nowww === "imagedecode.com" ||
				domain_nowww === "damimage.com" ||
				domain_nosub === "imgcredit.xyz" ||
				domain_nowww === "imgwallet.com" ||
				domain_nowww === "imgdrive.net" ||
				domain_nowww === "imgaws.com" ||
				domain_nowww === "imgtaxi.com") {
				if (/\/css\/+img\/+showcase\.img\./.test(src)) {
					return {
						url: src,
						bad: "mask"
					};
				}
				if (domain_nowww === "imgaws.com") {
					newsrc = website_query({
						website_regex: /^[a-z]+:\/\/[^/]+\/+img-([0-9a-f]{5,})\.html(?:[?#].*)?$/,
						query_for_id: function(id) {
							return {
								method: "POST",
								url: "https://" + domain + "/img-" + id + ".html",
								imu_mode: "document",
								headers: {
									"content-type": "application/x-www-form-urlencoded",
									origin: "https://" + domain,
									Referer: "https://" + domain + "/img-" + id + ".html"
								},
								data: "imgContinue=Continue+to+image..."
							};
						},
						process: function(done, resp, cache_key) {
							var match = resp.responseText.match(/<a href='(https?:\/\/[^"']+\/upload\/+big\/+[^"']+)'/);
							if (!match) {
								console_error(cache_key, "Unable to find match for", resp);
								return done(null, false);
							}
							var url = decode_entities(match[1]);
							return done({
								url: url,
								extra: {
									page: resp.finalUrl
								}
							}, 6 * 60 * 60);
						}
					});
					if (newsrc)
						return newsrc;
				} else {
					newsrc = website_query({
						website_regex: /^[a-z]+:\/\/[^/]+\/+img-([0-9a-f]+)\.html(?:[?#].*)?$/,
						query_for_id: "https://" + domain + "/img-${id}.html",
						process: function(done, resp, cache_key) {
							var image = get_meta(resp.responseText, "og:image");
							return done(image, 6 * 60 * 60);
						}
					});
					if (newsrc)
						return newsrc;
				}
				return {
					url: src.replace(/\/(images|upload)\/+small(?:-medium)?\/+/, "/$1/big/"),
					headers: {
						Referer: "https://" + domain + "/"
					},
					referer_ok: {
						same_domain_nosub: true
					}
				};
			}
			if (domain === "i.acidimg.cc") return src.replace(/(:\/\/[^/]*\/)[a-z]+\//, "$1big/");
			if (domain === "img.depo.ua") return src.replace(/(:\/\/[^/]*\/)[0-9X]+x[0-9X]+\//, "$1original/");
			if ((domain_nowww === "elfagr.com" ||
				domain_nowww === "arabmubasher.com" ||
				domain_nowww === "elbalad.news" ||
				domain_nowww === "elmwatin.com" ||
				domain_nowww === "dostor.org" ||
				domain_nowww === "studio-dostor.org" ||
				domain_nowww === "albawabhnews.com") &&
				/\/upload\/+photo\//.test(src)) {
				return src.replace(/\/+[0-9]+x[0-9]+[a-z]?\/+([^/]*?)(?:[?#].*)?$/, "/$1");
			}
			if (domain_nowww === "cdnimpuls.com") return src.replace(/\/-[0-9]+-[0-9]+-([0-9a-f]+(?:_[^/]*)?\.[^/.]*)$/, "/$1");
			if (domain_nowww === "mshreqnews.net" ||
				(domain_nowww === "mykentfamily.co.uk" && string_indexof(src, "/_media/") >= 0) ||
				domain_nowww === "pdfkul.com") {
				newsrc = src.replace(/\/img\/+[0-9]+x[0-9]+\/+([^/]*)(?:[?#].*)?$/, "/img/$1");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nowww === "choisirunfilm.fr") return src.replace(/\/persons\/small\/([0-9]+\.[^/.]*)$/, "/persons/$1");
			if (domain_nosub === "gazetaexpress.com" ||
				domain === "old.fishmedia.info") {
				return src.replace(/(\/public\/+uploads\/+image\/+[0-9]+\/+[0-9]+\/+)[0-9]+x[0-9]+\/+([^/]*)(?:[?#].*)?$/, "$1$2");
			}
			if (domain_nowww === "kosovapress.com") return src.replace(/(\/public\/+uploads\/+image\/+)[0-9]+x[0-9]+\/+/, "$1");
			if (domain_nowww === "haynews.am") return src.replace(/\/thumbs\/[0-9]+x(?:[0-9]+)?\//, "/images/");
			if (domain_nowww === "emlakkulisi.com") return src.replace(/\/resim\/[a-z]+\//, "/resim/orjinal/");
			if (domain_nowww === "aquarellefm.md" && string_indexof(src, "/storage/") >= 0) {
				return src.replace(/_Fit_[0-9]+x[0-9]+(\.[^/.]*)$/, "$1");
			}
			if (domain_nowww === "joy.hu" ||
				domain === "static.marquardmedia.hu") {
				return src.replace(/(\/data\/[^/]*\/[0-9]+\/[0-9]+)(?:-[^/.]*)?\.(?:[0-9]+(?:x[0-9]+)?|layer|w)(\.[^/.]*)$/, "$1$2");
			}
			if (domain_nowww === "ivoirematin.com") return src.replace(/(\/images\/[0-9]+-[0-9]+\/)fb_([0-9a-f]+\.[^/.]*)$/, "$1$2");
			if (domain === "img.theqoo.net") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/proxy\.php.*?[?&]url=([^&]*).*?$/, "$1");
				if (newsrc === src) {
					newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/proxy\/(.*)$/, "$1");
				}
				if (newsrc !== src) {
					if (!newsrc.match(/^[a-z]+:\/\//))
						newsrc = "http://" + newsrc;
					return newsrc;
				}
			}
			if (domain_nowww === "gpslifetime.com.br" && string_indexof(src, "/uploads/") >= 0) {
				return src.replace(/\/image\/thumbs\//, "/image/");
			}
			if (domain_nowww === "lasillarota.com" ||
				domain === "lasillarotarm.blob.core.windows.net.optimalcdn.com" ||
				domain === "info7rm.blob.core.windows.net.optimalcdn.com") {
				return src
					.replace(/:\/\/[^/]*lasillarota\.com\/images\/tnfocus\/(?:[0-9]+\/){4}([0-9]+\/[0-9]+\/[0-9]+\/[^/]*)$/, "://lasillarotarm.blob.core.windows.net.optimalcdn.com/images/$1")
					.replace(/(\/images\/[0-9]+\/[0-9]+\/[0-9]+\/[^/]*)-focus(?:-[0-9]+){4}(\.[^/.]*)$/, "$1$2");
			}
			if (domain_nowww === "znaj.ua" ||
				domain_nowww === "akcenty.com.ua") {
				return src.replace(/\/crops\/+[a-z0-9]+\/+[0-9]+x[0-9]+\/+[0-9]+\/+[0-9]+\/+([0-9]+\/+[0-9]+\/+[0-9]+\/+[^/]*)$/, "/images/$1");
			}
			if (domain_nowww === "raragente.com.br") return src.replace(/\/imagem\/noticia\/[0-9]+\/[0-9]+\//, "/images/materias/");
			if (domain_nowww === "pastefs.com") return src.replace(/\/resource\/[a-z]+\//, "/resource/files/");
			if (domain_nowww === "sigmalive.com") return src.replace(/\/application\/cache\/[^/]*\/(images\/[^/]*\/)[0-9]+x[0-9]+\//, "/uploads/$1");
			if (domain_nowww === "luna.ovh") return src.replace(/\/imgw\/[0-9]+px\//, "/imgw/");
			if (domain_nowww === "shalala.ru") return src.replace(/(\/upload\/artists\/[0-9]+\/)[a-z]+\/([0-9]+_[0-9]+\.[^/.]*)$/, "$1$2");
			if (domain_nowww === "fay3.com") return src.replace(/\/assets\/uploads\/(?:images_)?thumbs\//, "/assets/uploads/images/");
			if (domain_nowww === "vijesti.ba" ||
				domain_nosub === "novi.ba") {
				return src.replace(/(\/storage\/[0-9]+\/[0-9]+\/[0-9]+\/)thumbs\/([^/]*)-(?:preview(?:Org)?|[0-9]+x[0-9]+)(\.[^/.]*)$/, "$1$2$3");
			}
			if (domain === "m.smedata.sk") return src.replace(/(\/api-media\/media\/image\/.*)_[0-9]+x[0-9]*(\.[^/.]*)$/, "$1$2");
			if ((domain_nosub === "diariolibre.com" && domain.match(/estatico[0-9]*\.diariolibre\.com/)) ||
				domain_nowww === "expreso.ec" ||
				domain_nowww === "vanguardia.com" ||
				domain_nowww === "thesundaily.my" ||
				domain_nowww === "canarias7.es") {
				return src.replace(/\/binrepository\/[0-9]+x[0-9]+\/.*(\/[^/]*)(?:[?#].*)?$/, "/binrepository$1");
			}
			if (domain_nowww === "modelisto.com") return src.replace(/(-[0-9]+)@[0-9]+(\.[^/.]*)$/, "$1$2");
			if (domain === "media.kg-portal.ru") return src.replace(/(_[0-9]+)[st](\.[^/.]*)$/, "$1$2");
			if (domain_nowww === "desktopwallpaperhd.net") return src.replace(/(:\/\/[^/]*\/)thumbs\//, "$1wallpapers/");
			if (domain_nowww === "wallpaperplay.com") return src.replace(/\/walls\/[^/]*\//, "/walls/full/");
			if (domain_nosub === "pics.vc" &&
				domain.match(/^s[0-9]*\./)) {
				return src.replace(/(:\/\/[^/]*\/pics\/)[a-z]\//, "$1o/");
			}
			if ((domain_nosub === "imageshack.us" ||
				domain_nosub === "imageshack.com") &&
				domain.match(/^imagizer/)) {
				return src.replace(/(:\/\/[^/]*\/v2\/)[^/]*\//, "$1x/");
			}
			if (domain_nowww === "girlofthehour.com") return src.replace(/\/IMG\/poster_resized\//, "/IMG/poster/");
			if (domain === "hwcdn.ddstatic.com") {
				regex = /(-gal-)[0-9]+(-[a-z]+\/[^/]*)$/;
				return [
					src.replace(regex, "$11600$2"),
					src.replace(regex, "$11024$2")
				];
			}
			if (domain_nowww === "wallpaperbackgrounds.com") return src.replace(/(\/Content\/wallpapers\/.*\/)thumb-([0-9]+-[0-9]+\.[^/.]*)$/, "$1$2");
			if (domain_nosub === "barelist.com" && /^img[0-9]*\./.test(domain)) {
				return src
					.replace(/(\/images\/+hosted\/+[^/]*\/+[^/]*\/+)thumbs\//, "$1pics/")
					.replace(/\/images\/+gallery_[0-9]+_[0-9]+\//, "/images/gallery/");
			}
			if (domain === "proxy.imgsmail.ru") {
				return add_http(decodeURIComponent(src.replace(/^[a-z]+:\/\/[^/]*\/.*?[?&]url[0-9]*=([^&]*).*?$/, "$1")));
			}
			if (domain_nosub === "imgsmail.ru" &&
				domain.match(/^filapp[0-9]*\./)) {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/+pic.*?[?^]url=([^&]*).*?$/, "$1");
				if (newsrc !== src)
					return decodeuri_ifneeded(newsrc);
			}
			if (domain_nosub === "imgsmail.ru" && /^my[0-9]*\./.test(domain)) {
				if (/\/mail\/+ru\/+images\/+my\/+compass\/+static\//.test(src)) {
					return {
						url: src,
						bad: "mask"
					};
				}
			}
			if (domain === "go.imgsmail.ru") {
				if (/\/imgpreview\?/.test(src)) {
					return remove_queries(src, ["h", "w"]);
				}
			}
			if (domain_nowww === "pornoonline.com.pl") return src.replace(/(\/images\/galerie\/[0-9]+\/)[a-z]+\/[a-z]+_([0-9a-f]+\.[^/.]*)$/, "$1$2");
			if (domain === "img.cdn.pornzone.com") return src.replace(/(\/galerie\/+[0-9]+\/+[0-9]+\/+)small_([0-9a-f]{20,}\.)/, "$1big_$2");
			if (domain_nowww === "photo-erotique.org") return src.replace(/(\/girls\/[0-9]+\/)thumb_([0-9]+\.[^/.]*)$/, "$1$2");
			if (domain === "s.mediasole.ru") return src.replace(/:\/\/[^/]*\/cache\/preview\/data\//, "://mediasole.ru/data/");
			if ((domain_nosub === "godsartnudes.com" ||
				domain_nosub === "godsartglam.com") &&
				domain.match(/^pics[0-9]*\./)) {
				return src.replace(/(-[0-9]+_[0-9]+)(?:_thumb)?(\.[^/.]*)$/, "$1_big$2");
			}
			if (domain_nowww === "gotgalleries.com") return src.replace(/th([0-9]*\.[^/.]*)$/, "$1");
			if ((domain_nosub === "perfectnaked.com" ||
				domain === "cdn.erocurves.com")
				&& string_indexof(src, "/galleries/") >= 0) {
				return src.replace(/(\/[0-9]+)_tn(\.[^/.]*)$/, "$1_big$2");
			}
			if (domain_nowww === "facefuckingporn.com") return src.replace(/(\/galleries\/+[^/]+\/+[^/]+)_tn(\.[^/.]+)(?:[?#].*)?$/, "$1_big$2");
			if (domain_nowww === "eroticbeauties.net" ||
				domain === "blog.pinkworld.com") {
				var eb_info = {
					regex: /^[a-z]+:\/\/[^/]+\/+pics\/+[^/]*-([0-9]+)\.html(?:[?#].*)?$/,
					qfi: "https://" + domain + "/pics/-${id}.html",
					image_regex: /<img class='img-thumbnail\s+img-responsive\s+sharpen' src='(https?:\/\/[^/]+\/+content\/[^']+)'/,
					video_regex: /(<video id="fluidPlayer">[\s\S]+<\/video>)/
				};
				var pw_info = {
					regex: /^[a-z]+:\/\/[^/]+\/+[^/]*-([0-9]+)\.html(?:[?#].*)?$/,
					qfi: "https://" + domain + "/-${id}.html",
					image_regex: /<figure\s+class='gallery-thumb[^"']*'>\s*<a\s+(?:[^>]+\s+)?href='(https?:\/\/[^/]+\/+(?:[^"']+\/+)?content\/[^'"]+\/full\/[^'"]+)'/,
					video_regex: /(<video id="pinkworld_video"[\s\S]+<\/video>)/
				};
				var our_info = domain_nosub === "eroticbeauties.net" ? eb_info : pw_info;
				newsrc = website_query({
					website_regex: our_info.regex,
					query_for_id: our_info.qfi,
					override_cb: function(cb, data) {
						var id = "1";
						var imu_id = src.match(/#imu-id=(.*)/);
						if (imu_id)
							id = imu_id[1];
						common_functions["update_album_info_links"](data, function(x) {
							var x_id = x.replace(/.*\/(?:[^/?#.]+_)?([0-9]+\.)[a-z0-9]{3,4}(?:[?#].*)?$/i, "$1");
							return x_id === id;
						});
						cb(data);
					},
					process: function(done, resp, cache_key) {
						var matches = match_all(resp.responseText, our_info.image_regex);
						if (!matches) {
							console_error(cache_key, "Unable to find match for", resp);
							return done(null, false);
						}
						var images = [];
						var video_match = resp.responseText.match(our_info.video_regex);
						if (video_match) {
							var videosources = common_functions["get_videotag_sources"](video_match[1]);
							if (videosources && videosources.video.length) {
								for (var _i = 0, _a = videosources.video; _i < _a.length; _i++) {
									var video = _a[_i];
									images.push({
										url: video.url,
										headers: {
											Referer: "https://" + domain + "/"
										},
										video: true,
										is_current: false
									});
									break;
								}
							}
						}
						for (var i_5 = 0; i_5 < matches.length; i_5++) {
							images.push({
								url: decode_entities(matches[i_5][1]),
								is_current: i_5 === 0
							});
						}
						return done({
							url: images[0].url,
							album_info: {
								type: "links",
								links: images
							},
							is_private: true
						}, 200); // pinkworld = 255 seconds?
					}
				});
				if (newsrc)
					return newsrc;
			}
			if ((host_domain_nowww === "eroticbeauties.net" ||
				host_domain === "blog.pinkworld.com") && options.element) {
				var fullimg = null;
				newsrc = common_functions["get_pagelink_host_el_matching"](options, {
					url_match: /^[a-z]+:\/\/[^/]+\/+(?:pics\/+)?[^/]*-[0-9]+\.html(?:[?#].*)?$/,
					el_match: function(x) {
						if ((x.tagName !== "IMG" || !x.classList.contains("img-responsive")) &&
							(x.tagName !== "SOURCE" && (!x.parentElement || x.parentElement.tagName !== "PICTURE")))
							return false;
						var current = x;
						while (current = current.parentElement) {
							if (current.tagName === "FIGURE" ||
								(current.tagName === "A" && current.classList.contains("pswp_open"))) {
								var alink = current;
								if (current.tagName !== "A")
									alink = current.querySelector("a");
								fullimg = alink.href;
								return true;
							}
						}
						return false;
					}
				});
				if (newsrc) {
					var urls = [];
					urls.push({
						url: options.host_url.replace(/[?#].*/, "") + "#imu-id=" + src.replace(/.*\/(?:[^/?#.]+_)?([0-9]+\.)[a-z0-9]{3,4}(?:[?#].*)?$/i, "$1"),
						is_pagelink: true
					});
					if (fullimg)
						urls.push(fullimg);
					if (urls.length)
						return urls;
				}
			}
			if (domain_nosub === "eroticbeauties.net" ||
				domain_nosub === "hometownnudes.com" ||
				domain_nosub === "eroticmetart.com"
			) {
				var baseobj_5 = {
					headers: {
						Referer: "http://" + domain_nosub + "/"
					},
					referer_ok: {
						same_domain_nosub: true
					}
				};
				newsrc = src.replace(/\.webp([?#].*)?$/, ".jpg$1");
				if (newsrc !== src) {
					baseobj_5.url = newsrc;
					return baseobj_5;
				}
				newsrc = src.replace(/(\/content\/+[^/]*\/+)(?:[^/]*\/+[^/]*\/+)?(?:tn@[^/]*|[0-9]+|main)\/+((?:[^/.]+_)?[0-9]+\.[^/.]*)$/, "$1full/$2");
				if (newsrc !== src) {
					baseobj_5.url = newsrc;
					return baseobj_5;
				}
			}
			if (domain_nowww === "barahla.net") return src.replace(/(\/images\/photo\/[0-9]+\/[0-9]+\/[0-9]+\/)(?:[a-z]+\/)?([0-9]+)(?:_[a-z]+)?(\.[^/.]*)$/, "$1big/$2_big$3");
			if (domain === "i.pipec.info") return src.replace(/\/[0-9]+px\/([^/]*)$/, "/$1");
			if (domain_nosub === "hothag.com" && domain.match(/^cdn[0-9]*\./)) {
				newsrc = src.replace(/(\/media\/+(?:galleries|images))_[0-9]+\//, "$1/");
				if (newsrc !== src)
					return add_full_extensions(newsrc);
				return src.replace(/(\/media\/+gifs)_[0-9]+(\/+[0-9/]+)\.[^/.]*(?:[?#].*)?$/, "$1/$2.gif");
			}
			if ((domain_nosub === "1zoom.ru" ||
				domain_nosub === "1zoom.me") &&
				domain.match(/^s[0-9]*\./)) {
				return src
					.replace(/(:\/\/[^/]*\/)prev2\//, "$1prev/")
					.replace(/(:\/\/[^/]*\/)big[0-9]*\//, "$1big3/");
			}
			if (domain === "st-gdefon.gallery.world" ||
				domain === "st.gde-fon.com") {
				return src.replace(/\/wallpapers_[a-z]+(\/[0-9]+_[^/]*)$/, "/wallpapers_original$1");
			}
			if (domain_nowww === "boorp.com") return src.replace(/\/miniature(\/[^/]*)$/, "$1");
			if (domain === "d2pptc4exyus09.cloudfront.net" ||
				domain === "static.puzzlefactory.pl") {
				return src.replace(/(\/puzzle\/[0-9]+\/[0-9]+\/)[a-z]+(\.[^/.]*)$/, "$1original$2");
			}
			if (domain_nowww === "sfondo.info") return src.replace(/\/i\/[a-z]+\//, "/i/original/");
			if (domain_nosub === "yiihuu.com" &&
				domain.match(/^img[0-9]*\./)) {
				return src
					.replace(/\/[0-9]+X[0-9]+\/upimg\//, "/upimg/")
					.replace(/\?.*/, "");
			}
			if (domain_nowww === "superwall.us" ||
				domain_nowww === "rex-fox.com") {
				return src.replace(/(:\/\/[^/]*\/)thumbnail\//, "$1wallpaper/");
			}
			if (domain_nosub === "mangadrawing.net") return src.replace(/\/imagecache\/display\/image\//, "/image/");
			if (domain_nosub === "ucoz.ru" ||
				domain_nowww === "intoclassics.net" ||
				domain_nowww === "zonemod.com" ||
				domain_nosub === "ucoz.net") {
				newsrc = src
					.replace(/(\/_ph\/+[0-9]+\/+)[0-9]+\/+([0-9]+\.[^/.]*)$/, "$1$2")
					.replace(/(\/_(?:nw|pu)\/+[0-9]+\/+)s([0-9]+\.[^/.]*)(?:[?#].*)?$/, "$1$2");
				if (newsrc !== src)
					return add_extensions_jpeg(newsrc);
			}
			if (domain_nowww === "wallpapersdig.com") return src.replace(/\/images\/[a-z]+(?:\/.*)?(\/[^/]*-[0-9]+\.[^/.]*)$/, "/images/original$1");
			if (domain === "img.hebus.com") return src.replace(/\/[a-z]+\/[a-z]?([0-9]+_[0-9]+\.[^/.]*)$/, "/$1");
			if (domain === "content.eroo.pl") return src.replace(/(\/[0-9]+)_[a-z]+(\.[^/.]*)$/, "$1$2");
			if (domain_nowww === "timdir.com") return src.replace(/\.tn(\.[^/.]*)$/, "$1");
			if (domain_nowww === "live-stats.me") return src.replace(/\/pics\/+thumbs\//, "/pics/images/");
			if (domain_nowww === "plekoflady.ga") return src.replace(/\/media\/+thumbs\/+/, "/media/images/");
			if (domain_nowww === "celebcafe.net") {
				newsrc = src.replace(/\/blog\/thumbs\//, "/blog/pics/");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nowww === "z-celebs.com" ||
				domain_nowww === "celebcafe.net" ||
				domain_nowww === "neocelebs.com" ||
				domain_nowww === "starsmaster.com" ||
				domain_nowww === "starzhunter.com" ||
				domain_nowww === "easycelebritys.com") {
				return src.replace(/\/pics\/+thumbs\/+/, "/pics/");
			}
			if (domain === "cdn.xpics.me" ||
				domain === "cdn.pornpic.xxx" ||
				domain === "cdn.pornpictures.today" ||
				domain === "cdn.xnxxpics.top" ||
				domain === "cdn.hdpornpics.net" ||
				domain === "cdn.pussy-porn-pics.com") {
				return src.replace(/(:\/\/[^/]*\/)[0-9]\//, "$10/");
			}
			if (domain_nowww === "nehuha.net" && string_indexof(src, "/data/photo/") >= 0) {
				return src.replace(/\/thumb\.([^/]*)$/, "/$1");
			}
			if (domain_nowww === "pornrice.com" ||
				domain_nowww === "monocdn.com" ||
				domain === "media.jpegworld.com" ||
				domain_nowww === "tokyoteenies.com" ||
				domain === "cdn.smutie.com" ||
				domain_nowww === "sexthread.com" ||
				domain_nowww === "sugarnips.com" ||
				domain_nowww === "galleryportal.com") {
				newsrc = src.replace(/(:\/\/[^/]*|\/media)\/+thumbs\/+((?:[0-9a-f]\/){5}[0-9a-f]+\/)[0-9]+x[0-9]+\//, "$1/galleries/$2");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nowww === "tokyoteenies.com") return src.replace(/(\/content\/+[^/]*\/+)thumbs_([0-9]+\.[^/.]*)(?:[?#].*)?$/, "$1image_$2");
			if (domain === "wallpapers.jami.lt") return src.replace(/_big(\.[^/.]*)$/, "$1");
			if (domain === "y.yarn.co") {
				if (/\/site\/+assets\/+images\/+black\./.test(src))
					return {
						url: src,
						bad: "mask"
					};
				obj = {
					url: src
				};
				match = src.match(/:\/\/[^/]*\/([-0-9a-f]+)(?:_.*?)(?:[?#].*)?$/);
				if (match) {
					obj.extra = { page: "https://yarn.co/yarn-clip/" + match[1] };
				}
				newsrc = src.replace(/(:\/\/[^/]*\/[-0-9a-f]+)_thumb(\.[^/.]*)$/, "$1_screenshot$2");
				if (newsrc !== src) {
					obj.url = newsrc;
					return obj;
				}
				newsrc = src.replace(/(:\/\/[^/]*\/[-0-9a-f]+)_[0-9]+_[wh]_[0-9]+\.gif(?:[?#].*)?$/, "$1.mp4");
				if (newsrc !== src) {
					obj.url = newsrc;
					obj.video = true;
					return obj;
				}
			}
			if (domain === "images.genius.com") return src.replace(/\/avatars\/[a-z]+\/([0-9a-f]+)(?:[?#].*)?$/, "/avatars/original/$1");
			if (domain_nosub === "smcloud.net" &&
				domain.match(/^cdn[0-9]*\.thumbs\.common\./)) {
				return src.replace(/:\/\/[^/]*\/common\/.\/.\/s\/([^/]*\.[^/.]*)\/.*/, "://static.common.smcloud.net/s/$1");
			}
			if (domain_nowww === "recordeli.com") return src.replace(/(\/items\/[0-9]+\/image_)[a-z]+(?:[?#].*)?$/, "$1big");
			if (domain_nosub === "liveinternet.ru" &&
				domain.match(/^img[0-9]*\./)) {
				return src.replace(/(\/[0-9]+)_[a-z]+(_+[0-9A-Za-z]+\.[^/.]*)$/, "$1$2");
			}
			if (domain === "assets.heart.co.uk" ||
				domain === "assets.popbuzz.com") {
				return src.replace(/(-[0-9]+)-(?:view|herowidev[0-9]*)-[0-9]+(\.[^/.]*)$/, "$1$2");
			}
			if (domain === "kms.yawmiyati.com") return src.replace(/\/Images\/[0-9io]+x[0-9io]+x[0-9io]+\//, "/content/uploads/Article/");
			if (domain === "pic.chinasspp.com") return src.replace(/_s_[0-9]+x[0-9]+(\.[^/.]*)$/, "$1");
			if (domain_nowww === "eveningecho.ie") return src.replace(/(\/portalsuite\/image\/+[-0-9a-f]+)\/+[^/]*(\.[^/.]*)$/, "$1/mainMediaSize=FILE__image$2");
			if (domain_nowww === "drunkenstepfather.com") return src.replace(/\/cms\/ul\/t-/, "/cms/ul/");
			if (domain_nowww === "fraufluger.ru") return src.replace(/(\/files\/images\/html_gallerys\/[^/]*\/[0-9a-f]+)_[0-9]+(\.[^/.]*)$/, "$1_origin$2");
			if (domain_nowww === "alfacdn.com") return src.replace(/(\/[0-9]+)h?(\.[^/.]*)/, "$1m$2");
			if (domain === "s.img.mix.sina.com.cn") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/auto\/resize.*?[?&]img=([^&]*).*?$/, "$1");
				if (newsrc !== src)
					return decodeURIComponent(newsrc);
			}
			if (domain === "albums.timg.co.il") return src.replace(/(\/userFolders\/[0-9]+\/[0-9]+\/)[a-z]+\/([0-9]+\.[^/.]*)$/, "$1$2");
			if (domain_nowww === "aljanh.net") return src.replace(/(\/data\/archive\/)[a-z]+\/(img\/[0-9]+\.[^/.]*)$/, "$1$2");
			if (amazon_container === "files.d20.io") {
				return src.replace(/(\/images\/[0-9]+\/[^/]*\/)[a-z]+(\.[^/.?]*)(?:[?#].*)?$/, "$1max$2");
			}
			if (domain_nowww === "wallpaperdx.com") return src.replace(/\/photo(\/[^/]*)-[0-9]+-[0-9]+(\.[^/.]*)$/, "/images$1$2");
			if (domain_nowww === "patrasevents.gr") return src.replace(/(\/imgsrv\/+.\/+)[0-9]+x(?:[0-9]+)?\/+/, "$1full/");
			if (domain_nowww === "alazmenah.com" ||
				domain_nowww === "syria-in.com") {
				return src.replace(/\/thumb_photo\//, "/photo/");
			}
			if (domain === "images.alwatanvoice.com") return src.replace(/\/news\/thumbs\//, "/news/large/");
			if (domain_nowww === "ammanalyoum.com") {
				return {
					url: src.replace(/(\/images\/upload\/[^/]*\.[^/.]*)\/[0-9]+\/[0-9]+\/[0-9]+(?:[?#].*)?$/, "$1"),
					can_head: false // 403
				};
			}
			if (domain_nowww === "shitpostbot.com") {
				newsrc = src.replace(/(:\/\/[^/]*\/)resize\/[0-9]+\/[0-9]+.*?[?&]img=([^&]*).*?$/, "$1$2");
				if (newsrc !== src) {
					return decodeURIComponent(newsrc).replace(/(:\/\/[^/]*)\/+/, "$1/");
				}
			}
			if (domain_nowww === "extremnews.com") return src.replace(/\/images\/[a-z_]+-([0-9a-f]+\.[^/.]*)$/, "/images/full-$1");
			if (domain === "contestimg.wish.com") {
				return {
					url: src.replace(/(\/api\/webimage\/[0-9a-f]+(?:-[0-9]+)?)-[a-z]+(\.[^/.?]*)(?:[?#].*)?$/, "$1-original$2"),
					head_wrong_contenttype: true
				};
			}
			if (domain === "image.phimmoi.net") return src.replace(/(\/profile\/[0-9]+\/)[a-z]+(\.[^/.]*)$/, "$1full$2");
			if (domain_nosub === "static-bluray.com" &&
				domain.match(/^images[0-9]*\./)) {
				return src
					.replace(/(\/reviews\/+[0-9]+_[0-9]+)(?:_tn)?(\.[^/.]*)$/, "$1_large$2")
					.replace(/(\/htgallery\/+[0-9]+)_tn(\.[^/.]*)$/, "$1$2")
					.replace(/(\/products\/+[0-9]+\/+[0-9]+_[0-9]+_)[a-z]+(\.[^/.]*)$/, "$1original$2")
					.replace(/(\/movies\/+(?:ma|uv)?covers\/+[0-9]+_)(?:small|medium|large)\./, "$1front.");
			}
			if (domain_nowww === "titus.kz" ||
				domain_nowww === "shymkent.kz") {
				return src.replace(/(\/load_theme\/files\/[0-9a-f]+)\.[^/]*(\.[^/.]*)$/, "$1$2");
			}
			if (domain_nowww === "mfoxes.net") {
				return src
					.replace(/\/[a-z],[0-9]+,[^/]*\/gal\//, "/gal/")
					.replace(/\/castimagethumb-([0-9]+\.[^/.]*)$/, "/castimage-$1");
			}
			if (domain === "i.ucrazy.ru") return src.replace(/(\/files\/+(?:i|pics)\/+[0-9]{4}\.[0-9]{1,2}(?:\.[0-9]{1,2})?\/)thumbs\//, "$1");
			if (domain_nowww === "athinorama.gr") return src.replace(/(\/articles\/[0-9]+\/[^/.]*\.[^/.]*)\.ashx\?.*$/, "$1");
			if (domain_nosub === "spiiky.com" && domain.match(/^img[0-9]*\./)) {
				return src.replace(/\.ashx\?.*/, "");
			}
			if (domain_nowww === "murekkephaber.com") return src.replace(/(\/images\/[^/]*\/[0-9]+\/[0-9]+\/[^/]*)_t(\.[^/.]*)$/, "$1$2");
			if (domain_nowww === "egehaber.com") return src.replace(/\/images\/+haberler\/+thumbs\/+/, "/images/haberler/");
			if (domain_nowww === "dienvienvietnam.vn" &&
				string_indexof(src, "/assets/img/") >= 0) {
				return src.replace(/(_[0-9]+)_[a-z]+(\.[^/.]*)$/, "$1_grande$2");
			}
			if (amazon_container === "s3bucketvn") {
				return src.replace(/\/images\/thumbs\/[a-z]+\/([0-9a-f]+\.[^/.]*)$/, "/images/$1");
			}
			if (domain_nosub === "gazeta.ua" &&
				domain.match(/^static[0-9]*\./)) {
				return src.replace(/(\/img2?\/+)[a-z]+\/+([a-z]+\/+[0-9]+\/+[0-9]+(?:_[0-9]+)?)_[^/]*(\.[^/.]*)$/, "$1original/$2$3");
			}
			if (domain_nowww === "gazzettadiparma.it" ||
				domain === "img.liberoquotidiano.it" ||
				domain_nowww === "dundalkdemocrat.ie" ||
				domain_nowww === "donegaldemocrat.ie" ||
				domain_nowww === "liberoquotidiano.it") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/resizer_ext\/[-0-9]+\/[-0-9]+\/[a-z]+\/(http)/, "$1");
				if (newsrc !== src)
					return decodeURIComponent(newsrc).replace(/--(\.[^/.]*)$/, "");
				newsrc = src.replace(/\/resizer\/[-0-9]+\/[-0-9]+\/[a-z]+\/([0-9]+(?:_[0-9]+)?\.[^-/.]+)--.*/, "/upload/$1");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/\/resizer\/+[-0-9]+\/+[-0-9]+\/+[a-z]+\//, "/resizer/-1/-1/true/");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "media.defense.gov") return src.replace(/\/[0-9]+\/+[0-9]+\/+[^/]+\/+([^/]+)(?:[?#].*)?$/, "/-1/-1/0/$1");
			if (domain === "multimidia.correiodopovo.com.br") return src.replace(/(:\/\/[^/]*\/)thumb\.aspx.*?Caminho=([^&]*).*?$/, "$1$2");
			if (domain_nosub === "diziler.com" &&
				domain.match(/^s[0-9]*\./)) {
				return src.replace(/(:\/\/[^/]*\/)img\/[0-9]+x[0-9]+\//, "$1original/");
			}
			if (domain === "g.denik.cz") return src.replace(/_sip-[0-9]+up(\.[^/.]*)$/, "$1");
			if (domain_nowww === "imperiodefamosas.com") return src.replace(/(:\/\/[^/]*\/)image_cache\.php.*?[?&]file=([^&]*).*?$/, "$1$2");
			if (domain_nowww === "lostfilm.info") return src.replace(/\/images\/+[0-9]+(photo|poster)/, "/images/$1");
			if (domain_nowww === "hinhnenso1.com") return src.replace(/(\/images\/blogs\/[0-9]+\/[0-9]+\/)[a-z]+\//, "$1original/");
			if (domain_nowww === "avatarko.ru") return src.replace(/(:\/\/[^/]*\/img\/)[a-z]+\//, "$1kartinka/");
			if (domain_nowww === "ppe.pl") return src.replace(/(\/upload\/news\/(?:[0-9]+\/){3})[a-z]+_([0-9]+\.[^/.]*)$/, "$1$2");
			if (domain === "storge.pic2.me") return src.replace(/\/cm?\/[0-9]+x[0-9]+\//, "/upload/");
			if (domain_nowww === "serey.io") return src.replace(/^[a-z]+:\/\/[^/]*\/imageproxy\/[0-9]+x[0-9]+\/(https?:\/\/)/, "$1");
			if (domain === "static.pjmedia.com") return src.replace(/\.sized-[0-9t]+x[0-9t]+x[0-9t]+(\.[^/.]*)$/, "$1");
			if (domain === "file.nxing.cn" ||
				domain === "upload.nxing.cn") {
				return {
					url: src.replace(/(\/uploads\/uploads\/[0-9]+\/[0-9]+\/[0-9]+\/[0-9]+\/[0-9a-f]+)-size[0-9]+x[0-9]+(?:_[^/]*)?(\.[^/.]*)$/, "$1$2"),
					headers: {
						Referer: ""
					}
				};
			}
			if (amazon_container === "kateryan" ||
				amazon_container === "totalworld" ||
				amazon_container === "lkbkspro" ||
				amazon_container === "clmlkbks" ||
				amazon_container === "defacto" ||
				amazon_container === "apostrophelookbooks" ||
				amazon_container === "thegardenparty" ||
				amazon_container === "exposureny" ||
				amazon_container === "atomo-management" ||
				amazon_container === "traceymattingly" ||
				amazon_container === "jmireps" ||
				(domain_nosub === "lookbookspro.com" && domain.match(/assets\.lookbookspro\.com$/))) {
				if (/\/[a-z]+_[0-9a-f]{8}(?:-[0-9a-f]{4}){3}-[0-9a-f]{12}\.[^/.]+(?:[?#].*)?$/) {
					return src
						.replace(/\/(?:lg|g(?:[sm]|x?l))_([-0-9a-f]{20,}\.)/, "/gxxl_$1")
						.replace(/\/hd_([-0-9a-f]{20,}\.)/, "/fullhd_$1")
						.replace(/\/video_([-0-9a-f]{20,}\.)/, "/hd_$1");
				}
			}
			if (domain_nowww === "havepussy.com") return src.replace(/\/uploads\/photos\/previews\/([0-9]+_[^/]*)$/, "/0-0/$1");
			if (domain === "news.walkerplus.com") {
				return {
					url: src.replace(/(\/article\/[0-9]+\/[0-9]+)_[0-9]+(\.[^/.]*)$/, "$1$2"),
					can_head: false // 404
				};
			}
			if (domain === "movie.walkerplus.com" ||
				domain_nowww === "moviewalker.jp") {
				newsrc = src.replace(/(\/api\/+resizeimage\/.*?)(?:[?#].*)?$/, "$1?w=");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/:\/\/[^/]+\/+api\/+resizeimage\/+news\/+(.*?)(?:[?#].*)?$/, "://news.walkerplus.com/$1.jpg");
				if (newsrc !== src)
					return add_extensions(newsrc);
			}
			if (domain === "img.jj20.com") return src.replace(/(\/[0-9A-Z]+-[0-9]+)-[a-z]+(\.[^/.]*)$/, "$1$2");
			if (domain === "i.iplsc.com") return src.replace(/(\/[0-9A-Z]+)-C[0-9]+(?:-F[0-9]+)?(\.[^/.]*)$/, "$1-C0$2");
			if (domain === "s3.viva.pl") return src.replace(/-GALLERY_[0-9]+(\.[^/.]*)$/, "-GALLERY_BIG$1");
			if ((domain_nosub === "vogue.com.tr" && domain.match(/^cdn[0-9]*\./)) ||
				(domain_nosub === "gq.com.tr" && domain.match(/^cdn[0-9]*\./)) ||
				domain === "wr3mii5n.rocketcdn.com" ||
				domain === "voguecdn.blob.core.windows.net") {
				return src.replace(/\/files\/img\/[^/]*\//, "/files/original/");
			}
			if (domain_nosub === "clients-cdnnow.ru" ||
				domain === "s.properm.ru") {
				return src
					.replace(/(\/[a-z]+Storage\/(?:(?:post|news)\/)?(?:[0-9a-f]{2}\/){1,}[0-9a-f]+)_resizedScaled_[0-9]+to[0-9]+(\.[^/.]*)$/, "$1$2")
					.replace(/(:\/\/[^/]*\/)[a-z]+Storage\/+/, "$1originalStorage/");
			}
			if (domain_nowww === "hollywoodtuna.com") return src.replace(/\/images([0-9])\/([^/]*)$/, "/images$1/bigimages$1/$2");
			if (domain_nosub === "soupcdn.com" &&
				domain.match(/^asset-.\./)) {
				return src.replace(/(\/asset\/[0-9]+\/[0-9]+_[0-9a-z]+)_[0-9]+(\.[^/.]*)$/, "$1$2");
			}
			if (domain_nosub === "qqmofasi.com" &&
				domain.match(/^pic[0-9]*\./)) {
				return src.replace(/_crop(\.[^/.]*)$/, "$1");
			}
			if (domain_nowww === "download-rooz.com" ||
				domain_nowww === "day-download.com") {
				return src.replace(/\/img\/+[0-9]+-[0-9]+\//, "/img/");
			}
			if (domain_nowww === "know.cf") return src.replace(/\/imgw\/[0-9]+px\/([^/]*)$/, "/imgw/$1");
			if (amazon_container === "timely-api-public") {
				return src.replace(/(\/timely-api-public[^/]*\/[0-9]+_[0-9a-zA-Z]+)_[a-z]+(\.[^/.]*)$/, "$1$2");
			}
			if (domain_nowww === "image-share.com") return src.replace(/(\/upload\/[0-9]+\/[0-9]+)m(\.[^/.]*)$/, "$1$2");
			if (domain_nowww === "amando.it") return src.replace(/\/imagesdyn\/gallery_plus\/(?:[0-9]+x[0-9]+|orig_[0-9]+)\//, "/imagesdyn/gallery_plus/orig/");
			if (domain_nowww === "textureking.com") {
				return add_extensions_upper(src.replace(/\/content\/img\/stock\/([^/]*)$/, "/content/img/stock/big/$1"));
			}
			if (domain_nowww === "textures.com") {
				if (src.match(/\/system\/+gallery\/+photos\/+[^/]*\/+(?:[^/]*\/+)?[0-9]+\/+[^/]+(?:[?#].*)?$/)) {
					return {
						url: src.replace(/(\/[0-9]+\/+)([^/]*_)(?:download)?[0-9]+(\.[^/.]*)$/, "$1hotlink-ok/$2shared$3"),
						problems: {
							watermark: true
						}
					};
				}
			}
			if ((domain_nosub === "gmbox.ru" ||
				domain_nosub === "vestifinance.ru") &&
				domain.match(/^[a-z][0-9]*\./)) {
				return src.replace(/(\/c\/[0-9]+)\.[0-9]+x[0-9p]+(?:c[0-9]+)?(\.[^/.]*)$/, "$1$2");
			}
			if (domain_nosub === "game2day.ru") return src.replace(/\/images\/made\/[0-9a-f]+\/([0-9]+-[0-9]+)_[0-9]+_[0-9]+_(?:s_)?c[0-9]+(\.[^/.]*)$/, "/uploads/userfiles/images/$1$2");
			if (domain_nowww === "topcrochetpatterns.com") return src.replace(/\/images\/+made\/+(images\/+uploads\/+blog\/+[^/]*?)_[0-9]+_[0-9]+_[0-9]+_c[0-9]+(\.[^/.]*)(?:[?#].*)?$/, "/$1$2");
			if (domain_nowww === "dangerousminds.net") return src.replace(/\/content\/+uploads\/+images\/+made\/+(content\/+uploads\/+images\/+[^/]+)_[0-9]+_[0-9]+_int(\.[^/.]*)(?:[?#].*)?$/, "/$1$2");
			if (domain_nosub === "nupics.pro" ||
				domain_nowww === "epicsoid.com" ||
				domain_nowww === "xwetpics.com" ||
				domain_nowww === "xsexpics.com" ||
				domain_nowww === "picsninja.club" ||
				domain_nowww === "hotnupics.com" ||
				domain_nowww === "ehotpics.com" ||
				domain_nowww === "picsegg.com" ||
				domain_nowww === "upicsz.com" ||
				domain_nowww === "xpicse.com" ||
				domain_nowww === "hdpicsx.com" ||
				domain_nowww === "picsninja.com" ||
				domain_nowww === "nuslut.com" ||
				domain_nowww === "repicsx.com") {
				return src.replace(/(\/pics\/+[0-9]+\/+)_([^/]*)$/, "$1$2");
			}
			if (domain_nowww === "pornstarapex.com") return src.replace(/(\/pics\/+[0-9a-f]+\/+)th_([0-9]+\.[^/.]+)(?:[?#].*)?$/, "$1$2");
			if (domain_nosub === "cloud.it" &&
				domain.match(/^ldm[0-9]*\.r1-it\.storage\./)) {
				return src
					.replace(/(\/img\/.*\/)big\/([0-9]+_[0-9a-f]+\.[0-9]+\.[^/.]*)$/, "$1$2")
					.replace(/(\/(?:av|logo)\/.*\/)thumbs\/([0-9a-f]+\.[^/.]*)$/, "$1$2");
			}
			if (domain_nosub === "cfimg.com" &&
				domain.match(/^i[0-9]*\./)) {
				return src.replace(/(:\/\/[^/]*\/[0-9]+\/[0-9a-f]+)s(\.[^/.]*)$/, "$1$2");
			}
			if (domain === "i.chzbgr.com") {
				newsrc = src.replace(/(:\/\/[^/]*\/+)(?:thumb[0-9]*|full)\/+/, "$1original/");
				if (newsrc !== src)
					return newsrc;
				return src.replace(/(\/imagestore\/+[0-9]{4}\/+[0-9]+\/+[0-9]+\/+)th_/, "$1");
			}
			if (domain === "img.memecdn.com") {
				return add_full_extensions(src.replace(/(:\/\/[^/]*\/[^/]*_)[a-z]+(_[0-9]+\.[^/.]*)(?:[?#].*)?$/, "$1o$2"));
			}
			if (domain === "p.memecdn.com") return src.replace(/\/avatars\/+[a-z]+_([0-9]+_[0-9a-f]+\.[^/.]*)(?:[?#].*)?$/, "/avatars/$1");
			if (domain_nosub === "123rf.com") {
				if (!src.match(/:\/\/[a-z]+cdn\./) &&
					src.match(/:\/\/[^/]*\/(?:images|[0-9]+wm)\//)) {
					var full = src.replace(/:\/\/[^/]*\/[^/]*\//, "://previews.123rf.com/images/");
					var small = src.replace(/:\/\/[^/]*\/[^/]*\//, "://us.123rf.com/450wm/");
					var urls = [
						{
							url: full,
							problems: {
								watermark: true
							}
						},
						{
							url: small,
							problems: {
								smaller: true
							}
						},
						src
					];
					var baseobj_6 = {};
					var match = src.match(/\/([0-9]+)-[^/]+\.[^/.]+(?:[?#].*)?$/);
					if (match) {
						id = match[1];
						baseobj_6.extra = {
							page: "https://www.123rf.com/photo_" + id + ".html"
						};
						if (options.do_request && options.cb) {
							api_query("123rf:" + id, {
								url: "https://www.123rf.com/photo_" + id + ".html",
							}, function(data) {
								if (data) {
									baseobj_6 = data;
								}
								return options.cb(fillobj_urls(urls, baseobj_6));
							}, function(done, resp, cache_key) {
								var match = resp.responseText.match(/dataLayer\.push\({[\s\S]+?["']product_name["']:\s*["'](.*?)["'],/);
								baseobj_6.extra.page = resp.finalUrl;
								if (match) {
									baseobj_6.extra.caption = match[1];
								} else {
									console_warn(cache_key, "Unable to find match in", resp);
								}
								done(baseobj_6, 24 * 60 * 60);
							});
							return {
								waiting: true
							};
						}
					}
					return fillobj_urls(urls, baseobj_6);
				}
			}
			if (domain_nowww === "chenderroad.com") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/image\.php.*?[?&]src=([^&]*).*?$/, "$1");
				if (newsrc !== src)
					return decodeURIComponent(newsrc);
			}
			if (domain_nosub === "estranky.cz" ||
				domain_nosub === "estranky.sk") {
				if (domain !== "s3a.estranky.sk") {
					return src
						.replace(/(:\/\/[^/]*\/img\/)[a-z]+\//, "$1original/")
						.replace(/(:\/\/[^/]*\/img\/original\/[0-9]+)(\.[^/.]*)/, "$1/image$2");
				}
			}
			if (domain_nowww === "stagelook.ru") return src.replace(/\/images\/tumbs\//, "/images/");
			if (domain === "media.taaze.tw") return src.replace(/\/showProdImageByPK\.html.*?[?&]pid=([0-9]+).*?$/, "/showTakeLook/$1.jpg");
			if (domain === "st.cdjapan.co.jp") return src.replace(/\/pictures\/s\//, "/pictures/l/");
			if (domain === "image.blozoo.info") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/v2\/thumb\/[0-9]+\/[0-9]+\/.*?[?&]url=(http[^&]*).*?$/, "$1");
				if (newsrc !== src)
					return decodeURIComponent(newsrc);
			}
			if (domain === "img.suilengea.com") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/img\.php.*?[?&]url=([^&]*).*?$/, "$1");
				if (newsrc !== src)
					return add_http(decodeURIComponent(newsrc));
			}
			if (domain === "files.sirclocdn.xyz") return src.replace(/(\/products\/_[0-9]+_[^/._]*)(?:_[a-z]+)?(\.[^/.]*)$/, "$1_ori$2");
			if (domain === "s.tvp.pl") return src.replace(/(\/images2?\/(?:[0-9a-f]\/){3})[-_a-zA-Z0-9]*(uid_[0-9a-f]+)[^/.]*?(\.[^/.]*)$/, "$1$2_width_9999999999999$3");
			if (domain === "sf.be.com") return src.replace(/(\/photo\/[0-9]+\/[0-9a-z]+\/[^/]*-)[a-z][0-9]+(\.[^/.]*)$/, "$1img$2");
			if (domain_nowww === "fitwell.bg") return src.replace(/(\/pictures\/[0-9]+)_[0-9]+_*(\.[^/.]*)$/, "$1$2");
			if (domain === "bilder.bild.de") return src.replace(/\/fotos-skaliert(\/[^/]*\/)([0-9]+),[^/.]*(\.bild\.[^/.]*)$/, "/fotos$1Bild/$2$3");
			if (domain === "galeria.cdn.divany.hu") return src.replace(/(\/[0-9]+_[0-9a-f]+)_[a-z](\.[^/.]*)$/, "$1$2");
			if (domain === "img.cncenter.cz") return src.replace(/(\/img\/[0-9]+\/)[a-z]+(\/[^/]*)$/, "$1full$2");
			if (domain_nowww === "cosmopolitan.de") return src.replace(/\/bilder\/[0-9]+(?:x[0-9]+)?\//, "/assets/");
			if (domain === "d1o73ibskzeirn.cloudfront.net") return src.replace(/(:\/\/[^/]*\/)[0-9]+x[0-9]+\/content\//, "$10x0/content/");
			if (domain_nowww === "elle.co.za" ||
				domain_nowww === "xgn.nl" ||
				domain_nowww === "sandinyoureye.co.uk" ||
				domain_nowww === "skitguys.com" ||
				domain === "cache.wizardworld.com") {
				return src.replace(/\/+_[0-9AUTO]+x[0-9AUTO]+_(?:crop|fit)_[^/]+\/+/, "/");
			}
			if (domain === "assets-c3.propublica.org") return src.replace(/\/images\/+articles\/+_[^/]+\/+/, "/images/articles/");
			if (domain_nowww === "kartinnay-galerey.ru") return src.replace(/\/uploads\/posts\/news_thumb\//, "/uploads/posts/");
			if (domain_nowww === "imhomir.com") return src.replace(/(\/uploads\/[a-z]+\/preview\/.*)_[0-9]+(\.[^/.]*)$/, "$1$2");
			if (domain_nowww === "mumsnet.com") return src.replace(/(\/uploads\/talk\/[0-9]+\/)[a-z]+-([0-9]+-[^/]*)$/, "$1$2");
			if (domain === "static.stylemagazin.hu") return src.replace(/(\/medias\/[0-9]+\/)[0-9]+x[0-9]+\//, "$1");
			if (domain === "img.thoibao.today") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/home\/fetch.*?[?&]u=([^&]*).*?$/, "$1");
				if (newsrc !== src)
					return decodeURIComponent(newsrc);
			}
			if (amazon_container === "photo.elcinema.com" ||
				(domain_nosub === "elcinema.com" && /^media[0-9]*\./.test(domain))) {
				return src.replace(/\/uploads\/_[0-9]+x(?:[0-9]+)?_([0-9a-f]+\.[^/.]*)$/, "/uploads/$1");
			}
			if (domain_nowww === "colors.life") return src.replace(/(\/upload\/blogs\/[0-9a-f]{2}\/[0-9a-f]{2}\/[0-9a-f]+)_RSZ_[0-9]+(\.[^/.]*)$/, "$1$2");
			if (domain_nosub === "tnews.ir" && domain.match(/^i[0-9]*\./)) {
				return src.replace(/(\/[0-9]+\/[0-9]+\/[0-9]+\/)Thumbnail\//, "$1");
			}
			if (domain === "multimedia.mmc.com.do") return src.replace(/(\/multimedia\/[0-9]+\/[0-9]+\/[0-9]+\/[0-9a-f]+)_max.?_[0-9]+x[0-9]+(\.[^/.]*)$/, "$1$2");
			if (domain === "img.europapress.es") return src.replace(/(\/fotoweb\/[a-z]+_(?:[0-9]+-)?[0-9]+)(?:_[0-9]+)?(\.[^/.]*)$/, "$1_9999$2");
			if (domain === "img.estadao.com.br") return src.replace(/\/thumbs\/[0-9]+\/resources\//, "/resources/");
			if (domain_nosub === "asianews.cc" &&
				domain.match(/^s[0-9]*\./)) {
				return src.replace(/(\/[0-9]+\/[0-9a-f]+)_[a-z]+(\.[^/.]*)$/, "$1_orgn$2");
			}
			if (domain_nosub === "wallpapermix.club" ||
				domain_nosub === "wallpaper-planet.com") {
				return src.replace(/(\/doc\/wallpaper\/img\/)[a-z]\//, "$1l/");
			}
			if (domain_nosub === "utaten.com" && string_indexof(src, "/uploads/images/") >= 0) {
				return src
					.replace(/\/thumbnail\/+[0-9]+x[0-9]+\/+/, "/")
					.replace(/_(?:[a-z]|[0-9]+x[0-9]+)(\.[^/.]*)$/, "$1");
			}
			if (domain_nowww === "frostsnow.com") {
				return add_extensions_with_jpeg(src
					.replace(/\/x([^/.]*\.[^/.]*)\.pagespeed\.[^/]*$/, "/$1")
					.replace(/\/[0-9]+x[0-9]+\/([^/]*)$/, "/$1"));
			}
			if (domain_nowww === "mewch.net" ||
				domain_nowww === "kohlchan.net" ||
				domain_nowww === "anonib.al" ||
				domain === "lynx.farted.net" ||
				domain === "cdn.incel.shop" ||
				domain_nowww === "endchan.net" ||
				/:\/\/[^/]+\/+\.(?:media\/+t_[0-9a-f]{32,64}(?:-image[a-z]+)?|static\/+images\/+404-[0-9]+\.png)(?:[?#].*)?$/) {
				if (/\/\.static\/+images\/+404-/.test(src))
					return {
						url: src,
						bad: "true"
					};
				newsrc = src
					.replace(/\/\.media\/+t_([0-9a-f]+-imagejpeg)(?:[?#].*)?$/, "/.media/$1.jpg")
					.replace(/\/\.media\/+t_([0-9a-f]+-imagepng)(?:[?#].*)?$/, "/.media/$1.png");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/\/\.media\/+t_([0-9a-f]{20,})(?:[?#].*)?$/, "/.media/$1.jpg");
				if (newsrc !== src) {
					return add_full_extensions2(newsrc, { extensions: ["jpg", "png", "mp4", "gif"] });
				}
			}
			if (domain === "media.mehrnews.com") return src.replace(/\/old\/[^/]*\/([0-9]+\/)/, "/old/Original/$1");
			if (domain_nowww === "barking-moonbat.com") return src.replace(/(\/images\/uploads\/[^/]*)_thumb(\.[^/.]*)$/, "$1$2");
			if (domain_nowww === "deseretnews.com") return src.replace(/\/images\/article\/[a-z]+res\//, "/images/article/hires/");
			if (domain_nowww === "orsm.net") {
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+v\/+(update[0-9]+\/+[^/]+\.[^/.?#]+)(?:[?#].*)?$/,
					query_for_id: "https://www.orsm.net/v/${id}",
					run: function(cb, match) {
						return cb({
							url: "https://grab.orsm.net/" + match[1],
							video: true
						});
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain_nowww === "orsm.net") return src.replace(/(\/i\/galleries\/[^/]*\/)thumbnails\//, "$1");
			if (domain_nowww === "niklife.com.ua") return src.replace(/(:\/\/[^/]*\/)[0-9]+x[0-9]+[A-Z]?\/images\//, "$1images/");
			if (domain === "img.ef43.com.cn") return src.replace(/(\/newsImages\/[0-9]+\/[0-9]+\/[0-9]+)small(\.[^/.]*)$/, "$1$2");
			if (domain === "st.clopotel.t1.ro") return src.replace(/(\/_files\/datafiles\/.*\/)thumbs\/([0-9]+\.[^/.]*)$/, "$1$2");
			if (domain_nosub === "akamaized.net" &&
				domain.match(/^cdn[0-9]*-production-images-kly\./)) {
				return src.replace(/:\/\/[^/]*\/.*?\/kly-media-production\/([a-z]+\/[0-9]+\/)/, "://cdn-production-assets-kly.akamaized.net/$1");
			}
			if ((domain_nosub === "akamaized.net" && domain.match(/^cdn[0-9]*-production-assets-kly\./)) ||
				domain_nosub === "static6.com") {
				return src.replace(/(\/medias\/+[0-9]+\/+)[^/]*\/+/, "$1original/");
			}
			if (domain === "cdn.xn--cumpleaosdefamosos-t0b.com") return src.replace(/(\/gallery\/[0-9]+\/[0-9]+\/[^/]*\/[^/]*)_thumb(\.[^/.]*)$/, "$1$2");
			if (domain === "up.zhuoku.org" ||
				domain === "up.padtu.com" ||
				domain === "up.deskbus.com" ||
				domain === "up.bizhitupian.com" ||
				domain === "up.8desk.com") {
				return src.replace(/\/pic_[0-9]+\//, "/pic/");
			}
			if (domain_nowww === "apherald.com" && string_indexof(src, "/ImageStore/images/") >= 0) {
				return src.replace(/\/tn-([^/]*)$/, "/$1");
			}
			if (domain_nowww === "luxo.co.za") return src.replace(/\/system-files\/[a-z]+\//, "/system-files/");
			if (domain_nowww === "longroom.com") return src.replace(/\/uploads\/stock\/[a-z]+_([0-9]+\.[^/.]*)$/, "/uploads/stock/$1");
			if ((domain_nosub === "cennoticias.com" ||
				domain_nosub === "baca.co.id") &&
				domain.match(/^img\.cdn\./)) {
				return src.replace(/:\/\/img\.([^/]*)\/([-0-9a-f]+)(?:_thumbnail)?(?:[?#].*)?$/, "://raw.$1/$2");
			}
			if (domain === "cdn-tehran.wisgoon.com") return src.replace(/\/dlir-s3\/([0-9]+)?[0-9]{3}x[0-9]{3}_([0-9]+\.[^/.]*)$/, "/dlir-s3/$1$2");
			if (domain === "s.stylemode.com") return src.replace(/(\/uploads\/(?:(?:article|blog|album|recommend)(?:_desc|detail)?)\/)(?:[0-9]+x[0-9]+|deal)\//, "$1origin/");
			if (domain_nosub === "akairan.com" && domain.match(/^cdn[0-9]*\./) &&
				string_indexof(src, "/files/images/") >= 0) {
				return src.replace(/waterM(\.[^/.]*)$/, "$1");
			}
			if (domain === "cdn.idntimes.com" && string_indexof(src, "/content-images/") >= 0) {
				return src.replace(/_[0-9auto]+x[0-9auto]+(\.[^/.]*)$/, "$1");
			}
			if (domain_nowww === "comicsblog.fr") return src.replace(/\/images\/galerie\/[a-z]+image\/(?:small_)?/, "/images/galerie/bigimage/");
			if (domain === "ent.sina.com.cn" ||
				domain === "auto.sina.com.cn") {
				return src.replace(/^[a-z]+:\/\/[^/]*\/([^/]*\.sinaimg\.cn\/)/, "http://$1");
			}
			if (domain_nowww === "analisadaily.com") return src.replace(/\/assets\/image\/news\/small\//, "/assets/image/news/big/");
			if (domain === "fi.realself.com") return src.replace(/(:\/\/[^/]*\/)[a-z]+(\/[0-9a-f]+\/)/, "$1full$2");
			if (domain_nosub === "babeimpact.com" && domain.match(/^content[0-9]*\./)) {
				return src.replace(/_tn(_[0-9]+\.[^/.]*)$/, "$1");
			}
			if (domain === "i.widelec.org") return src.replace(/_[a-z](\.[^/.]*)$/, "$1");
			if (domain === "image.kurier.at" ||
				domain === "image.film.at") {
				return src.replace(/\/images\/+[^/]*\/+([0-9]+\/)/, "/images/original/$1");
			}
			if (domain === "media.game8.vn") {
				newsrc = src.replace(/\.[0-9]+\.(?:[0-9]+\.)?cache(?:[?#].*)?$/, "");
				if (newsrc !== src)
					return newsrc;
				if (string_indexof(src, "/srv_thumb.ashx") >= 0) {
					var queries = get_queries(src);
					var ext = queries.w || "jpg";
					return urljoin("http://media.game8.vn/", queries.f, true) + "." + ext;
				}
			}
			if (domain_nosub === "xiongyan.tv" &&
				domain.match(/^img[0-9]*\./)) {
				return src.replace(/\/[a-z]+_([0-9a-f]+[0-9A-Za-z]+\.[^/.]*)$/, "/origin_$1");
			}
			if (domain_nowww === "coffelt.me") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/image.*?[?&]q=([^&]*)$/, "$1");
				if (newsrc !== src)
					return decodeURIComponent(newsrc);
			}
			if (domain === "kiev.segodnya.ua") return src.replace(/(\/img\/gallery\/[0-9]+\/[0-9]+\/[0-9]+)_[a-z]+(\.[^/.]*)$/, "$1_main$2");
			if (domain === "image.jjang0u.service.concdn.com" ||
				domain === "pic.doctorteen.com" ||
				domain === "pic.freeporn.hu" ||
				(domain_nowww === "hotxxxgirls.org" && /\/images\/+galleries\/+/.test(src)) ||
				domain === "content.brazz-girls.com" ||
				domain === "pic.fineartteens.com" ||
				(domain_nowww === "simplemetart.com" && /\/images\/+galleries\//.test(src)) ||
				(domain_nowww === "picsftv.com" && /\/images\/+galleries\//.test(src)) ||
				(domain_nowww === "metartdb.com" && string_indexof(src, "/images/galleries/") >= 0)) {
				newsrc = src.replace(/\/t_([0-9]+\.[^/.]*)$/, "/$1");
				if (newsrc !== src) {
					return newsrc;
				}
			}
			if (domain === "image.jjang0u.service.concdn.com") {
				return {
					url: src,
					headers: {
						Referer: "http://fun.jjang0u.com/"
					}
				};
			}
			if (domain_nowww === "fotoshoots.be") return src.replace(/(\/images\/fotografen\/[0-9]+\/)thumbs\//, "$1");
			if (domain_nosub === "tapatalk.com") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/groups\/[^/]*\/imageproxy\.php.*?[?&]url=([^&]*).*?$/, "$1");
				if (newsrc !== src)
					return decodeURIComponent(newsrc);
			}
			if (domain === "dl.backbook.me") return src.replace(/(:\/\/[^/]*\/)[a-z_]+(\/[0-9a-f]+\.[^/.]*)$/, "$1full$2");
			if (domain_nosub === "backbook.me" && /^[a-z]\./.test(domain)) {
				return src
					.replace(/(\/file\/+[0-9]{4}\/+(?:[0-9]{2}\/+){2}[0-9a-f]{2}\/+)[a-z_]+_([0-9a-f]+\.[^/.]*)(?:[?#].*)?$/, "$1full_$2");
			}
			if (domain === "nthumb.cyworld.com") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/thumb.*?[?&]url=([^&]*).*?$/, "$1");
				if (newsrc !== src)
					return decodeURIComponent(newsrc);
			}
			if (domain === "e.porosenka.net") return src.replace(/(\/uploads\/[0-9a-f]\/[0-9a-f]+\/[0-9a-f]+)_[a-z]+(\.[^/.]*)$/, "$1$2");
			if ((domain_nosub === "qhimg.com" ||
				domain_nosub === "qhmsg.com") &&
				domain.match(/^p[0-9]*\./)) {
				return src.replace(/(:\/\/[^/]*\/+)[a-z]+\/+[0-9]+_[0-9]+_\/+/, "$1");
			}
			if (domain_nosub === "gamersky.com" && domain.match(/^img[0-9]*\./)) {
				return {
					url: src
						.replace(/(\/upimg\/pic\/[0-9]{4}\/[0-9]{2}\/[0-9]{2}\/[0-9]+)_[a-z]+(\.[^/.]*)$/, "$1$2")
						.replace(/(\/upimg\/users\/[0-9]{4}\/[0-9]{2}\/[0-9]{2}\/)[a-z]+_([^/]*)$/, "$1origin_$2")
						.replace(/(\/image[0-9]{4}\/+[0-9]{2}\/+[0-9]{8}_[a-z]{2}_[0-9]+_[0-9]+\/+[^/_.]*)_[A-Z](\.[^/.]*)(?:[?#].*)?$/, "$1$2"),
					headers: {
						Referer: ""
					},
					referer_ok: {
						same_domain_nosub: true
					}
				};
			}
			if (domain_nosub === "game234.com" && domain.match(/^webimg[0-9]*\./) ||
				domain_nowww === "reho.st") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/+((?:[a-z]+:\/\/)?[^/]+\.[^/.]+\/+)/, "$1");
				if (newsrc !== src)
					return add_http(newsrc);
			}
			if (domain === "img.izismile.com" ||
				domain_nowww === "izismile.com") {
				return src
					.replace(/(\/img[0-9]*\/+[0-9]{8}\/+)640\/+([^/]*_)640_(?:high_)?([0-9]+\.[^/.]*)(?:[?#].*)?$/, "$11000/$2$3")
					.replace(/(\/img[0-9]*\/+[0-9]{8}\/+[^/]*)_l(_[0-9]+\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			}
			if (domain === "cdn.snsimg.carview.co.jp") return src.replace(/(\/blog\/(?:[0-9]+\/){5}[^/]*)[sm](\.[^/.]*)$/, "$1$2");
			if (domain_nowww === "wallpapersontheweb.net") {
				regex = /\/wallpapers\/[a-z]\/(?:(?:[0-9]+x[0-9]+)?\/)?(?:(?:[a-z]|[0-9]+x[0-9]+)-)?([^/]*)-([0-9]+)(\.[^/.]*)$/;
				return {
					url: src.replace(regex, "/wallpapers/l/$1-$2$3"),
					headers: {
						Referer: src.replace(regex, "/$2-$1/")
					}
				};
			}
			if (domain_nosub === "funon.cc" && domain.match(/^s[0-9]*\./)) {
				return src.replace(/(\/img\/)[a-z]+(\/[0-9]+\/)/, "$1orig$2");
			}
			if (domain === "img.joemonster.org") return src.replace(/(\/upload\/[^/]*\/)[a-z]_([0-9a-f]+[0-9a-z]+\.[^/.]*)$/, "$1$2");
			if (domain === "mobimg.b-cdn.net") return src.replace(/\/pic\/v2\/gallery\/[^/]*\//, "/pic/v2/gallery/real/");
			if (domain === "img.wanduorou.com") return src.replace(/^[a-z]+:\/\/[^/]*\/imgs\/([^/.]*\.[^/]*\/)/, "http://$1");
			if (domain === "i.gbc.tw") return src.replace(/(\/gb_img\/[0-9]+)[a-z](\.[^/.]*)$/, "$1$2");
			if ((domain_nosub === "xuehuaimg.com" && domain.match(/^pic[0-9]*\./)) ||
				(domain_nosub === "11street.my" && domain.match(/^cdn[0-9]*\./))) {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/proxy\/+(?:[a-z]+\/+)?([a-z]+:\/\/)/, "$1");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "img.tgchengzi.com") return src.replace(/(\/Uploads\/ueditor\/php\/upload\/image\/[0-9]+\/[0-9]+)_[a-z](\.[^/.]*)$/, "$1$2");
			if (domain_nosub === "doyo.cn" &&
				domain.match(/^s[0-9]*\./)) {
				return src.replace(/(\/img\/(?:[0-9a-f]{2}\/){2}[0-9a-f]+\.[^/._]*)_[a-z]+(?:[?#].*)?$/, "$1");
			}
			if (domain === "newsimg.hankookilbo.com" ||
				domain === "image.hankookilbo.com" ||
				domain === "betaimage.hankookilbo.com") {
				var extra = {};
				match = src.match(/^[a-z]+:\/\/[^/]*\/+[0-9]{4}\/+(?:[0-9]{2}\/+){2}([0-9]{8,})_[0-9]+(?:_[a-z])?\.[^/.]*(?:[?#].*)?$/);
				if (match) {
					extra.page = "http://star.hankookilbo.com/News/Read/" + match[1];
				}
				return {
					url: src.replace(/(\/[0-9]{4}\/[0-9]{2}\/[0-9]{2}\/(?:[0-9]+_[0-9]+|[-0-9a-f]+))_[a-z](\.[^/.]*)$/, "$1$2"),
					extra: extra
				};
			}
			if (domain === "dispatch.cdnser.be") return src.replace(/(\/[0-9]+[^-/_.]*_)T[0-9]*(_[0-9]+\.[^/.]*)$/, "$1T5$2");
			if (domain === "cms.artandarchaeology.princeton.edu") return src.replace(/\/media\/thumbnails\/([^/?]*)\?.*$/, "/media/files/$1");
			if (domain_nowww === "pronto.com.ar" ||
				domain_nowww === "atalayar.com") {
				return src.replace(/\/asset\/+thumbnail[,%][^/]*\/+media\//, "/media/");
			}
			if (domain === "cdn.thebest.gr") return src.replace(/\/media\/images\/[^/]*\//, "/media/images/original/");
			if (domain_nowww === "glow.gr" ||
				domain === "omegalive-sf.cdn.edgeport.net" ||
				domain_nowww === "omegalive.com.cy") {
				return src.replace(/(:\/\/[^/]*\/)(?:image|[a-z]+-img)\/+[^/]+(\/+[0-9]+\/+[^/]*\.[^/.?#]*)(?:[?#].*)?$/, "$1image/original$2");
			}
			if (domain_nowww === "scifi-forum.de" ||
				domain_nowww === "phica.net") {
				return src.replace(/\/filedata\/fetch.*?[?&](id=[0-9]+).*?$/, "/filedata/fetch?$1");
			}
			if (domain === "cache.net-a-porter.com") return src.replace(/^[a-z]+:\/\/[^/]*\/content\/images\/(story-[^/]*\.[^/.]*)\/[^/]*$/, "https://assets.ynap-content.com/$1");
			if (domain_nowww === "celluloidportraits.com" && string_indexof(src, "/img/") >= 0) {
				return src.replace(/(_[0-9]+_)[A-Z](\.[^/.]*)$/, "$1L$2");
			}
			if (domain_nowww === "nowtoronto.com") return src.replace(/(\/downloads\/[0-9]+\/download\/[^/?#]*)(?:.*?[?&](cb=[0-9a-f]+).*?)?$/, "$1?$2");
			if (domain === "cde.peru.com") return src.replace(/(\/ima\/(?:[0-9]\/){5}(?:[0-9]+\/)?)(?:[0-9]+x[0-9]+|thumb)\/([^/]*)$/, "$1$2");
			if (domain === "cd.cinescape.com.pe") {
				match = src.match(/^[a-z]+:\/\/[^/]*\/cinescape-[0-9]+x[0-9]+-([0-9]+)(\.[^/.]*)(?:[?#].*)?$/);
				if (match) {
					var digits = match[1].replace(/[0-9]{3}$/, "");
					var length = digits.length;
					for (i = length; i < 5; i++) {
						digits = "0" + digits;
					}
					return "http://e.cinescape.americadigital.pe/ima/"
						+ digits[0] + "/" + digits[1] + "/" + digits[2] + "/" + digits[3] + "/" + digits[4] + "/" + match[1] + match[2];
				}
			}
			if (domain_nowww === "celebritytalent.net") return src.replace(/\/photos\/[a-z]+\/([0-9]+\.[^/.]*)$/, "/photos/lg/$1");
			if (domain === "img-ovh-cloud.zszywka.pl") return src.replace(/\/thb_([0-9]+\.[^/.]*)$/, "/$1");
			if (domain_nosub === "clickthecity.com" && domain.match(/^cdn[0-9]*\./)) {
				return src.replace(/\/profiles\/[0-9]+(\/[0-9]+(?:_[0-9]+)?\.[^/.]*)$/, "/profiles$1");
			}
			if (domain_nowww === "lafactoriadelshow.com") return src.replace(/\/[a-z]+_([0-9a-f]+_[0-9]+\.[^/.]*)$/, "/full_$1");
			if (domain_nowww === "elintra.com.ar" ||
				domain_nowww === "diariorepublica.com.ar" ||
				domain_nosub === "minutoneuquen.com" ||
				domain_nowww === "abcdiario.com.ar" ||
				domain_nowww === "gamesbras.com" ||
				domain_nowww === "paginasiete.bo" ||
				domain_nowww === "diariolaprovinciasj.com" ||
				domain_nowww === "elintransigente.com" ||
				/^[a-z]+:\/\/[^/]+\/+u\/+fotografias\/+m\/[0-9]{4}\/+[0-9]{1,2}\/+[0-9]{1,2}\/+f[0-9]+x[0-9]+-[0-9]+_/.test(src)) {
				return src.replace(/\/fotografias\/m\/([0-9]{4}\/[0-9]+\/[0-9]+\/)f[0-9]+x[0-9]+-([0-9]+)_[0-9]+[^/]*(\.[^/.]*)$/, "/fotografias/fotosnoticias/$1$2$3");
			}
			if (domain === "f.aukro.cz" ||
				domain === "cdn.aukro.cz") {
				return src.replace(/(\/images\/+sk[0-9]+\/+)[0-9]+x[0-9]+\/+/, "$1");
			}
			if (domain_nowww === "wallpapershome.com" ||
				domain_nowww === "wallpapershome.ru") {
				return src.replace(/(\/images\/+pages\/+)ico_([hv]\/)/, "$1pic_$2");
			}
			if (domain === "envivoblog.estrellatv.com" ||
				domain_nowww === "gamegrin.com" ||
				domain === "cdn.okjeok.hr") {
				return src.replace(/\/_resampled\/(?:Set(?:Width|Height)|resizedimage)[0-9]+-([^/]*)$/, "/$1");
			}
			if (domain_nowww === "haltadefinizione.com") return src.replace(/\/_resampled\/+Scale(?:Width|Height)[^/]+\/+/, "/");
			if (domain === "images.sex.com") {
				match = src.match(/(\/images\/pinporn\/[0-9]{4}\/[0-9]{2}\/[0-9]{2}\/)[0-9]+(?:x[0-9]+)?\/([0-9]+\.[^/.?#]+)(?:[?#],*)?$/);
				if (match) {
					return "https://cdn.sex.com" + match[1] + match[2];
				}
				return {
					url: src.replace(/(\/images\/pinporn\/[0-9]{4}\/[0-9]{2}\/[0-9]{2}\/)(?:300|460|126x126)\//, "$1620/"),
					headers: {
						Referer: "https://www.sex.com/" // no referer doesn't work
					},
					referer_ok: {
						same_domain_nosub: true
					}
				};
			}
			if (domain === "cdn.sex.com") {
				return {
					url: src.replace(/\?.*/, ""),
					headers: {
						Referer: "https://www.sex.com/" // no referer doesn't work
					}
				};
			}
			if (domain === "fotografias.antena3.com" ||
				domain === "image.europafm.com" ||
				src.match(/^[a-z]+:\/\/[^/]*\/clipping\/cmsimages[0-9]*\/[0-9]{4}\/[0-9]{2}\/[0-9]{2}\/[-0-9A-F]+\/[^/]*\.[^/.]*$/)) {
				newsrc = src.replace(/(\/clipping\/cmsimages[0-9]*\/[0-9]{4}\/[0-9]{2}\/[0-9]{2}\/[-0-9A-F]+\/)[^/]*(\.[^/.]*)$/, "$1default$2");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nosub === "nickiswift.com" && domain.match(/^img[0-9]*\./)) {
				return src.replace(/-[0-9]+x[0-9]+(?:_rev[0-9]*)?(\.[^/.]*)$/, "$1");
			}
			if (amazon_container === "sphm-female-site-production") {
				return src.replace(/-[0-9]+px(\.[^/.]*)$/, "$1");
			}
			if (domain_nowww === "maxpapendieck.com") return src.replace(/(\/app\/webroot\/upload\/[0-9]+\/[^/]*)-(?:large|medium|thumb)(\.[^/.]*)$/, "$1$2");
			if (domain === "i.mdel.net") {
				if (/\/i\/+db\/+(?:play-[0-9]+|transBack)\./.test(src))
					return {
						url: src,
						bad: "mask"
					};
				return src.replace(/(\/i\/db\/[0-9]+\/[0-9]+\/[0-9]+\/[0-9]+)-[0-9]+[a-z]n?(\.[^/.]*)$/, "$1-orig$2");
			}
			if (domain === "cdn-img.fimfiction.net") {
				return src
					.replace(/(\/story\/[^-/]*-[0-9]+-[0-9]+-)[a-z]+([?#].*)?$/, "$1full$2")
					.replace(/(\/user\/[^-/]*-[0-9]+-[0-9]+-)[0-9]+([?#].*)?$/, "$1512$2");
			}
			if (domain_nosub === "tv-happening.com" && domain.match(/^img(?:-[a-z]+)?[0-9]*\./)) {
				return src.replace(/\/[a-z]\/([0-9]+\.[^/.]*)$/, "/b/$1");
			}
			if (domain_nowww === "kbbs.jp" ||
				domain_nowww === "ibbs.info") {
				return src.replace(/\/fitimg\/cache\/([^/]*)\/[0-9]+\/[^/_.]*_([^/]*)(?:[?#].*)?$/, "/data/$1/img/$2");
			}
			if (domain_nowww === "pzy.be") return src.replace(/(:\/\/[^/]*\/)t(\/[0-9]+\/[^/]*)$/, "$1i$2");
			if ((domain_nosub === "blick.ch" && domain.match(/^f[0-9]*\./)) ||
				domain === "static.pulse.ng" ||
				domain === "static.pulselive.co.ke" ||
				(domain_nosub === "focus.de" && domain.match(/^p[0-9]*\./)) ||
				domain === "static.pulse.com.gh") {
				return src.replace(/\/img\/[a-z]+\/(?:origs|crop)([0-9]*)\/[0-9]+(?:-[^/]*)?\/([^/?#]*\.[^/.?#]*)(?:[?#].*)?$/, "/media/$1/$2");
			}
			if (domain === "img.blick.ch") return src.replace(/\?.*/, "?ratio=FREE&x=0&y=0");
			if (domain_nowww === "mixnews.lv") return src.replace(/(\/uploads\/media\/image\/[0-9]{4}\/[0-9]{2}\/[0-9]{2}\/[^/]*)_medium\.png(?:[?#].*)?$/, "$1.jpg");
			if (domain_nosub === "promiflash.de" &&
				domain.match(/^content[0-9]*\./)) {
				return src.replace(/\/article-images\/+gallery1024\//, "/article-images/gallery2048/");
			}
			if (domain_nowww === "mycharm.ru") return src.replace(/(\/data\/cache\/[0-9]{4}[a-z]+\/.*)thumb[0-9]+(\.[^/.]*)$/, "$1$2");
			if (domain === "images.worthpoint.com") return src.replace(/(\/files\/[^/]*\/)tn\//, "$1");
			if (domain_nowww === "benishop.co" ||
				domain === "cdn.benishop.co" ||
				domain_nowww === "awanshop.co") {
				return src.replace(/^[a-z]+:\/\/[^/]*\/imgcdn\/[0-9]+\/([a-z]+)\/(.*)_\.[^/.]*$/, "$1://$2");
			}
			if (domain === "img.auctiva.com") return src.replace(/(\/[0-9]+_)[a-z]+(\.[^/.]*)$/, "$1o$2");
			if (domain === "img.networthpost.com") return src.replace(/\/thumbs\/([0-9]+_)/, "/images/$1");
			if (domain === "img.static.butygirls.com") return src.replace(/\/resize\/[0-9]+\/[0-9]+\/[0-9]+(\/[0-9a-f]+\.[^/.]*)$/, "$1");
			if (domain_nowww === "wallpapersmug.com" ||
				domain_nowww === "picstatio.com") {
				return src.replace(/\/(?:download\/+[0-9]+x[0-9]+|(?:thumb|large))\/+([-0-9a-z]+\/+[^/]*)(?:[?#].*)?$/, "/u/$1");
			}
			if (domain === "cp12.nevsepic.com.ua") return src.replace(/(\/[0-9]+\/)thumbs\/([0-9]+-[0-9]+-[^/]*)$/, "$1$2");
			if (domain === "itn.dmarge.com") return src.replace(/:\/\/[^/]*\/[0-9]+x[0-9]+\//, "://i.dmarge.com/");
			if (domain_nosub === "idnes.cz" && domain.match(/^img[0-9]*\./)) {
				return src.replace(/\/thumb\//, "/images/");
			}
			if (domain_nowww === "funsubstance.com") return src.replace(/\/uploads\/[a-z]+\//, "/uploads/original/");
			if (domain === "global.unitednations.entermediadb.net") {
				return src
					.replace(/(\/downloads\/+preset\/+[^/]+\/+[^/]+\/+[^/]+\.[a-zA-Z]{3,4}\/+)image[0-9]+x[0-9]+(?:cropped)?(\.[^/.]*)$/, "$1image3000x3000$2")
					.replace(/(\/downloads\/+preset\/+assets\/+[0-9]{4}\/+[0-9]{2}\/+[0-9]+\/+)image[0-9]+x[0-9]+(?:cropped)?(\.[^/.]*)$/, "$1image$2");
			}
			if (domain === "rimg.bookwalker.jp") return src.replace(/:\/\/[^/]+\/+([0-9a-f]{30,}\/+)(?:BM2j7K0aiKyzud2kfkni6g__|eUnObgIVNjRTJtVUNQrbaQ__|OWWPXNVne2Og5o9nA6tp3Q__|WYSt3oZAsOZeWLNOG6XDcw__)\./, "://c.bookwalker.jp/$1t_700x780.");
			if (domain === "c.bookwalker.jp") {
				match = src.match(/:\/\/[^/]*\/([0-9]+)\/[^/]*(?:[?#].*)?$/);
				if (match) {
					var number = match[1];
					var reversed_number = parseInt(reverse_str(number)) - 1;
					return "https://c.bookwalker.jp/coverImage_" + reversed_number + src.replace(/.*(\.[^/.?#]*)(?:[?#].*)?$/, "$1");
				}
			}
			if (domain === "taiwan-image.bookwalker.com.tw") return src.replace(/(\/product\/+[0-9]+\/+[0-9]+)_[0-9]+(?:_mask)?\./, "$1.");
			if (domain === "images.cdn.circlesix.co") return src.replace(/\/image\/(?:[0-9]+\/){3}uploads\//, "/image/uploads/");
			if (domain === "static.japanhdv.com") return src.replace(/(:\/\/[^/]*\/)cache\/(.*)\.[0-9]+x[0-9]+(\.[^/.]*)$/, "$1$2$3");
			if (domain === "image.gala.de") {
				return src
					.replace(/(:\/\/[^/]*\/v[0-9]*\/cms\/[^/]*\/[^/]*_[0-9]+-)[a-z]+[-_][^/]*(\.[^/.]*)$/, "$1original-lightbox$2")
					.replace(/:\/\/[^/]*\/+([0-9]+)\/+(?:[a-z]+)?(?:uncropped|[0-9]+x[0-9]+)-[0-9]+-[0-9]+\/([0-9a-f]{20,})\/+[^/]*\/+([^/]*)(\.[^/.]*)(?:[?#].*)?$/, "://www.gala.de/resource/blob/$1/$2/$3-data$4")
					.replace(/:\/\/[^/]+\/+([0-9]+)\/+.*?\/+([0-9a-f]{10,}|-)\/+([^/.?#]+)(\.[^/]+)(?:[?#].*)?$/, "://www.gala.de/resource/blob/$1/$2/$3-data$4");
			}
			if (domain_nosub === "fashionwelike.com" &&
				domain.match(/^static[0-9]*\./)) {
				return src.replace(/\/photos\/thumbnail\//, "/photos/original/");
			}
			if (domain === "images.metmuseum.org") return src.replace(/(\/CRDImages\/+[^/]*\/+)[^/]*\/+/, "$1original/");
			if (domain === "images-assets.nasa.gov") return src.replace(/~[a-z]+(\.[^/.]*)$/, "~orig$1");
			if (domain_nowww === "jpl.nasa.gov") return src.replace(/:\/\/[^/]+\/+spaceimages\/+images\/+[^/]+\/+(PIA[0-9]+)(?:_[^/]+|-[0-9]+(?:x[0-9]+|[wh]))(\.(?:jpg|jpeg|JPG|JPEG))(?:[?#].*)?$/, "://photojournal.jpl.nasa.gov/jpeg/$1$2");
			if (domain === "imagecache.jpl.nasa.gov") {
				match = src.match(/:\/\/[^/]+\/+images\/+[0-9]+x[0-9]+\/+(?:pia|PIA)([0-9]+)-[0-9]+-[0-9]+x[0-9]+\./);
				if (match) {
					return "https://photojournal.jpl.nasa.gov/jpeg/PIA" + match[1] + ".jpg";
				}
			}
			if (domain === "solarsystem.nasa.gov") return src.replace(/:\/\/[^/]+\/+system\/+(?:resources|news_items)\/+(?:detail_files|(?:list|main)_images)\/+[0-9]+_(?:pia|PIA)([0-9]+)(?:_[a-z]+)?(?:\.[^/.]+_[^/]+|[-_][^/]+)?\.[^/.]+(?:[?#].*)?$/, "://photojournal.jpl.nasa.gov/jpeg/PIA$1.jpg");
			if (domain === "photojournal.jpl.nasa.gov") {
				obj = { url: src };
				id = src.replace(/.*\/(PIA[0-9]+)(?:_[^/]+)?\.[^/.]+(?:[?#].*)?$/, "$1");
				if (id !== src) {
					obj.extra = {
						page: "https://www.jpl.nasa.gov/spaceimages/details.php?id=" + id
					};
				}
				newsrc = src.replace(/(:\/\/[^/]+\/+)jpegMod\/+([^/]+)_modest\./, "$1jpeg/$2.");
				if (newsrc !== src) {
					obj.url = newsrc;
					return obj;
				}
				newsrc = src.replace(/(:\/\/[^/]+\/+)(?:browse|thumb)\/+/, "$1jpeg/");
				if (newsrc !== src) {
					obj.url = newsrc;
					return obj;
				}
				return obj;
			}
			if (domain === "nssdc.gsfc.nasa.gov") {
				obj = { url: src };
				id = src.match(/\/imgcat\/+[^/]+res\/+(vg[0-9]*_p[0-9]+)\./);
				if (id) {
					obj.extra = { page: "https://nssdc.gsfc.nasa.gov/imgcat/html/object_page/" + id[1] + ".html" };
				}
				newsrc = src.replace(/(\/imgcat\/+)midres\/+/, "$1hires/");
				if (newsrc !== src) {
					obj.url = newsrc;
					return obj;
				}
				return obj;
			}
			if (amazon_container === "attachments.readmedia.com") {
				return src.replace(/(\/+files\/+[0-9]+\/+)[a-z]+\/+([^/]*)(?:[?#].*)?$/, "$1original/$2");
			}
			if (domain === "files.sexyandfunny.com") return src.replace(/\/(?:img|gallery)_[a-z]+\//, "/img_orig/");
			if (domain === "mb.cision.com") return src.replace(/(\/Public\/+[0-9]+\/+[0-9]+\/+[0-9a-f]+)_[^/_]*(\.[^/.]*)$/, "$1_org$2");
			if (domain_nowww === "ftvmagic.com") {
				return src
					.replace(/(\/+grand-media\/+image\/+)thumb\//, "$1")
					.replace(/-[0-9]+x[0-9]+(\.[^/.]*)$/, "$1")
					.replace(/(\/post_pics\/+[0-9]+\/+[0-9]+\/+[0-9]+)_thumb(\.[^/.]*)$/, "$1$2");
			}
			if (domain_nowww === "wdb.space" ||
				domain_nowww === "onlythere.com") {
				return src.replace(/(\/media\/[^/]*\/[^/]*)_scale_[0-9]+x[0-9]+(\.[^/.]*)$/, "$1$2");
			}
			if (domain_nowww === "iphone8wallpapers.com" && string_indexof(src, "/media/uploads/") >= 0) {
				return {
					url: src.replace(/-[0-9]+x[0-9]+(\.[^/.]*)$/, "$1"),
					headers: {
						Referer: src.replace(/(:\/\/[^/]*\/).*/, "$1") // works without, but adds a "click here full resolution, no hotlinking" watermark
					}
				};
			}
			if (domain === "upload.sanqin.com" ||
				domain === "upload.mnw.cn") {
				return src.replace(/\/thumb_[0-9]+__([^/]*)(?:[?#]*.*)?$/, "/$1");
			}
			if (domain_nosub === "best-wallpaper.net") {
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+([^/?#]+)_wallpapers\.html(?:[?#].*)?$/,
					query_for_id: "https://best-wallpaper.net/${id}_wallpapers.html",
					process: function(done, resp, cache_key) {
						var match = resp.responseText.match(/<img ID="viewImg"[^>]*data-src="([^">]*)"/);
						if (!match) {
							console_error(cache_key, "Unable to find match for", resp);
							return done(null, false);
						}
						done(urljoin(src, match[1], true), 6 * 60 * 60);
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain_nosub === "best-wallpaper.net") {
				match = src.match(/\/wallpaper\/+[^/]+\/[0-9]+\/([^/]*)_[^-_/.]+\.[^/.]*$/);
				if (match) {
					return {
						url: "https://best-wallpaper.net/" + match[1] + "_wallpapers.html",
						is_pagelink: true
					};
				}
			}
			if (domain_nosub === "trueart.com" &&
				domain.match(/^s[0-9]*\./)) {
				return src.replace(/(\/[0-9]+)_[0-9]+(\.[^/.]*)$/, "$1$2");
			}
			if (domain_nowww === "atkfan.com") return src.replace(/\/thumbs(\/[^/]*)_[0-9]+(\.[^/.]*)$/, "/set$1$2");
			if (domain === "imbbsfile.imbc.com") return src.replace(/\/thnb_([^/]*\.[^/.]*)(?:[?#].*)?$/, "/$1");
			if (domain_nowww === "hdwall.us") {
				return {
					url: src.replace(/(:\/\/[^/]*\/+)(?:wallpaper|thumbnail)[^/]*\/+([^/]*\.[^/.]*)(?:[?#].*)?$/, "$1wallpaper/$2"),
					problems: {
						watermark: true
					}
				};
			}
			if (domain === "thmbs.baklol.com") return src.replace(/:\/\/thmbs\./, "://images.");
			if (domain_nowww === "svtstatic.se") {
				return {
					url: src.replace(/\/image\/+[^/]*\/+[^/]*\/+([0-9]+\/+[0-9]+)(?:\.[^/?#]*)?(?:[?#].*)?$/, "/image/original/unscaled/$1.png"),
					head_wrong_contentlength: true
				};
			}
			if (domain === "thmb.inkfrog.com" ||
				amazon_container === "thmb.inkfrog.com") {
				return src
					.replace(/^[a-z]+:\/\/.*\/+thumb[^/]*\/+([^/]*\/+[^/]*\.[^/.=]*)(?:=[0-9]+)?(?:[?#].*)?$/, "https://imgs.inkfrog.com/pix/$1")
					.replace(/^[a-z]+:\/\/.*\/+pix\/+([^/]*\/+[^/]*\.[^/.]*)\/+[0-9]+\/+[0-9]+(?:[?#].*)?$/, "https://imgs.inkfrog.com/pix/$1");
			}
			if (domain_nosub === "xnostars.com" &&
				domain.match(/^img[0-9]*\./)) {
				return src.replace(/(\/fotos\/+[^/]*)\/+thumbs\/+/, "$1/");
			}
			if (domain_nowww === "mobilmusic.ru") return src.replace(/(\/mfile\/+[0-9a-f]{2}\/+[0-9a-f]{2}\/+[0-9a-f]{2}\/+[0-9]+)-[0-9]+(\.[^/.]*)$/, "$1$2");
			if (domain === "pics.definebabe.com") return src.replace(/\/thumbs\/+thumb_([0-9]+\.[^/.]*)(?:[?#].*)?$/, "/$1");
			if (domain_nosub === "definebabe.com" &&
				domain.match(/^cdn-i[0-9]+\./)) {
				return src.replace(/(\/+[0-9a-f]+\/+)[a-z]?[0-9]+\/+((?:[^/]*-)?[0-9]+\.[^/.]*)$/, "$1$2");
			}
			if (amazon_container === "everipedia-storage") {
				return add_extensions_upper(src.replace(/(\/NewlinkFiles\/+[0-9]+\/+(?:[^/]*\/+)?[^/]+)_[0-9]+x[0-9]+(\.[^/.]*)(?:[?#].*)?$/, "$1$2"));
			}
			if (domain_nowww === "w-dog.pw" ||
				domain_nowww === "w-dog.net") {
				if (/:\/\/[^/]+\/+img\/+[0-9]+x[0-9]+.[^/.]+(?:[?#].*)?$/.test(src))
					return {
						url: src,
						bad: "mask"
					};
				return src.replace(/(\/(?:android-)?wallpapers\/+[0-9]+\/+[0-9]+)\/+[a-z]+(\/[0-9]+\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			}
			if (domain_nosub === "wsimg.com" && /^i(?:mg[0-9]*|steam)\./.test(domain)) {
				return src.replace(/(\/+ip\/+[-0-9a-f]+\/+(?:ols\/+)?[^/]*|\/isteam\/+stock\/+[a-zA-Z0-9]+)(?:\/+:\/+.*)?(?:[?#].*)?$/, "$1");
			}
			if (domain === "img.lovpho.com") return src.replace(/\/+anh\/+(?:width|height)[0-9]+\//, "/anh/");
			if (domain_nowww === "divnil.com") return src.replace(/(\/wallpaper\/.*_[0-9a-f]+_)[a-z]+(\.[^/.]*)$/, "$1raw$2");
			if (domain === "images.dbnaked.com") return src.replace(/\/thumb_(?:[0-9]+x[0-9]+_)?([0-9]+\.[^/.]*)$/, "/$1");
			if (domain === "img.iseephoto.com") return src.replace(/(\/+files\/+[^/]*\/+)thumes\/+/, "$1");
			if (domain === "media.elle.gr") return src.replace(/.*\/engine\/[^/]*?_([0-9]+)_([0-9]+)(?:_type[0-9]+)?\.[^/.]*(?:[?#].*)?$/, "http://engine.numatek.netuse.gr/?imgid=$2&srcid=$1&type=2");
			if (domain === "engine.numatek.netuse.gr") {
				var queries = get_queries(src);
				if (queries.imgid && queries.srcid) {
					return "http://engine.numatek.netuse.gr/?imgid=" + queries.imgid + "&srcid=" + queries.srcid + "&type=2";
				}
			}
			if (domain === "actualite.benchmark.fr") return src.replace(/_diaporama_[0-9]+x[0-9]+(\.[^/.]*)(?:[?#].*)?$/, "$1");
			if (domain_nowww === "showstudio.com") return src.replace(/(\/+img\/+images\/+[0-9]+-[0-9]+\/+[0-9]+)_[^/]*(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain === "static.trendme.net") {
				newsrc = src.replace(/\/showThumb\.php.*?[?&]src=([^&]*).*?$/, "/showThumb.php?src=$1&h=99999999&height=99999999&zc=3");
				if (newsrc !== src)
					return newsrc;
				return src
					.replace(/\/+temp\/+thumbs\/+[0-9]+-[0-9]+-[0-9]+-[0-9]+\/+/, "/pictures/items/")
					.replace(/\/showThumb\.php.*?[?&]src=([^&]*).*?$/, "/pictures/items/$1");
			}
			if (domain_nowww === "ifairer.com") return src.replace(/\/+article_image\/+[a-z]+[0-9]+\/+/, "/article_image/");
			if (amazon_container === "khaskhabar") {
				return src.replace(/\/+khaskhabarimages\/+[a-z]+img\/+img[0-9]+\/+/, "/khaskhabarimages/img500/");
			}
			if (domain === "i.infospesial.net") return src.replace(/:\/\/[^/]*\/+[0-9]+x(?:[0-9]+)?\/+p\/+/, "://media.infospesial.net/image/p/");
			if (domain === "nik.bot.nu") return src.replace(/(:\/\/[^/]*\/+)[a-z]([0-9]+\.[^/.]*)(?:[?#].*)?$/, "$1o$2");
			if (domain_nosub === "eyeem.com" &&
				domain.match(/^cdn[0-9]*\./)) {
				return {
					url: src.replace(/(\/+thumb\/+[0-9a-f]+-[0-9]+\/+).*$/, "$1full"),
					problems: {
						watermark: true
					}
				};
			}
			if (domain === "3c1703fe8d.site.internapcdn.net" ||
				domain_nowww === "phys.org") {
				newsrc = src.replace(/\/newman\/+csz\/+([^/]*)\/+[^/]*\/+([0-9]{4}\/+[^/]*)(?:[?#].*)?$/, "/newman/gfx/$1/$2");
				if (newsrc !== src)
					return newsrc;
				return newsrc.replace(/\/+newman\/+gfx\/+([^/]*)\/+([0-9]{4}\/+[^/]*)(?:[?#].*)?$/, "/newman/gfx/$1/hires/$2");
			}
			if (domain_nowww === "sott.net") return src.replace(/(\/+image\/+s[0-9]+\/+[0-9]+\/+)[a-z]+\//, "$1full/");
			if (domain_nowww === "fimgs.net") return src.replace(/\/(?:images|mdimg)\/+([^/]*)\/+[^/.]*\.([0-9]+\.[^/.]*)(?:[?#].*)?$/, "/images/$1/o.$2");
			if ((domain_nosub === "ndsstatic.com" ||
				domain_nosub === "ohmymag.com" ||
				domain_nosub === "gentside.co.uk") &&
				domain.match(/^img[0-9]*\./)) {
				return src.replace(/(:\/\/[^/]*\/+)article\/+[0-9]+\/+/, "$1article/");
			}
			if (domain_nowww === "stickpng.com") return src.replace(/\/+assets\/+[a-z]+\/+([0-9a-f]+\.[^/.]*)(?:[?#].*)?$/, "/assets/images/$1");
			if (domain === "media.bizj.us") return src.replace(/(\/view\/img\/[0-9]+\/[^/*]*)(?:\*|%2A)[^/.]*(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain === "assets.becomegorgeous.com") return src.replace(/:\/\/[^/]*\/+assets\/+(static\.becomegorgeous\.com\/)/, "://$1");
			if (domain === "static.becomegorgeous.com") return src.replace(/\/+gallery\/+thumbs\/+thumb_/, "/gallery/pictures/");
			if (domain_nowww === "styleslum.com") return src.replace(/\/+main_image_thumbs\/+([^/]*\.[^/.]*)\.thumb_[^/.]*\.[^/.]*(?:[?#].*)?$/, "/main_image/$1");
			if (domain_nowww === "sideshowtoy.com") return src.replace(/(\/+assets\/+products\/+[0-9]+-[^/]*\/+)[a-z]+\/+/, "$1lg/");
			if (domain_nowww === "suwalls.com") {
				newsrc = website_query({
					website_regex: [
						/^[a-z]+:\/\/[^/]+\/+([^/]+\/+[^/]+)\/*(?:[?#].*)?$/,
						/^[a-z]+:\/\/[^/]+\/+([0-9]+)(?:[?#].*)?$/
					],
					query_for_id: "https://suwalls.com/${id}",
					process: function(done, resp, cache_key) {
						var match = resp.responseText.match(/<a[^>]* href="(https?:\/\/cdn\.suwalls\.com\/+wallpapers\/+[^">]*)"[^>]*>\s*<img/);
						if (!match) {
							console_error(cache_key, "Unable to find match for", resp);
							return done(null, false);
						}
						return done(match[1], 6 * 60 * 60);
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain === "cdn.suwalls.com") {
				if (/\/_media\/+styles\/+default[0-9]*\/+images\/+star[0-9]*\./.test(src)) {
					return {
						url: src,
						bad: "mask"
					};
				}
				newsrc = src.replace(/\/+_media\/+users_[0-9]+x[0-9]+\/+/, "/_media/users/");
				if (false && newsrc !== src)
					return newsrc;
				match = src.match(/.*\/+wallpapers\/+[^/]+\/+[^/]*-([0-9]+)-[0-9]+x[0-9]+\.[^/.]*(?:[?#].*)?$/);
				if (match) {
					return {
						url: "https://suwalls.com/" + match[1],
						is_pagelink: true
					};
				}
			}
			if (domain_nowww === "japanator.com") return src.replace(/(\/+ul\/+[0-9]+-\/+[0-9]+)-[0-9]+x(?:[0-9]+)?(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain === "cs.mg.co.za") return src.replace(/\/+crop\/+(content\/+images\/+[0-9]{4}\/+[0-9]{2}\/+[0-9]{2}\/+[^/]*\.[^/.]*)\/+[0-9]+x[0-9]+\/*(?:[?#].*)?$/, "/$1");
			if (domain_nowww === "drytickets.com.au") return src.replace(/\/+assets\/+upload\/+[0-9]+\/+[0-9]+\/+[0-9]+\/+/, "/assets/upload/");
			if (domain_nosub === "filmibeat.com") {
				newsrc = src
					.replace(/\/ph-[^/]*\/+/, "/ph-big/")
					.replace(/\/+img[hm]\/+[0-9]+x[0-9]+\/+/, "/ph-big/")
					.replace(/\/img\/+[0-9]+x[0-9]+(?:x[0-9]*)?\//, "/img/");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "g.ahan.in") return src.replace(/\/+thumbnails\/+([^/]*\.[^/.]*)(?:[?#].*)?$/, "/$1");
			if (domain_nowww === "behindwoods.com") {
				newsrc = src.replace(/\/+thumbnails\/+([^/]*\.[^/.]*)(?:[?#].*)?$/, "/$1");
				if (newsrc !== src) {
					return {
						url: newsrc,
						problems: {
							watermark: true
						}
					};
				}
			}
			if (domain === "gallery.123telugu.com") return src.replace(/\/+thumbs\/+tn_([^/]*)(?:[?#].*)?$/, "/images/$1");
			if (domain === "images.gludy.com") return src.replace(/(\/+photos\/+[0-9]+\/+[^/]*)_[0-9]+(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain === "static.az-cdn.ch") return src.replace(/\/n-[^/]*(?:[?#].*)?$/, "/teaser-goldbach");
			if (domain_nowww === "starchive.ru") return src.replace(/\/+thumbnails_foto\/+thumb_/, "/foto/");
			if (domain === "pre.aichi.jp") return src.replace(/\/+archive\/+storage\/+thumb\/+/, "/archive/storage/");
			if (domain === "img.kaikai.ch" ||
				domain === "bbs.animanch.com") {
				return src.replace(/\/thumb(?:_[a-z]+)\//, "/img/");
			}
			if (domain_nowww === "4fzone.com") return src.replace(/(\/+uploads\/+images\/+clip_[0-9]+_[0-9]+)_[a-z]+(\.[^/.]*)(?:[?#].*)?$/, "$1_poster$2");
			if ((domain_nosub === "s1sf.com" ||
				domain_nosub === "isanook.com") &&
				domain.match(/^(?:s|p[0-9]+)\./)) {
				newsrc = src.replace(/\/+rp\/+r\/+[wh][0-9]+\/+/, "/rp/r/w9999999/");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/.*\/(aHR0c[^?#/.]+)\.[^/.]+(?:[?#].)?$/, "$1");
				if (newsrc !== src)
					return base64_decode(newsrc);
			}
			if (domain_nosub === "caping.co.id" &&
				domain.match(/^image[0-9]*\./)) {
				return src.replace(/(\.[^/._]+)_[0-9A-Z]+(\.[^/.]*)(?:[?#].*)?$/, "$1");
			}
			if (domain_nowww === "zozchat.com") return src.replace(/\/+thumb-news\/+[0-9]+\/+[0-9]+\/+/, "/images/uploads/images/");
			if (domain === "media.tintuc.vn") return src.replace(/(\/+uploads\/+medias\/+[0-9]{4}\/+[0-9]{2}\/+[0-9]{2}\/+)[0-9]+x[0-9]+\//, "$1");
			if (domain_nosub === "gigacircle.com") return src.replace(/\/+media\/+[0-9]+x[0-9]+_/, "/media/");
			if (domain_nowww === "ckywf.com") {
				return {
					url: src.replace(/(\/+data\/+[^/]*\/+[0-9]{4}\/+[0-9]{2}\/[0-9a-f]+)_thumb(\.[^/.]*)$/, "$1$2"),
					head_wrong_contenttype: true
				};
			}
			if (domain_nowww === "hao.news") return src.replace(/(\/+Uploads\/+Picture\/+[0-9]{4}-[0-9]{2}-[0-9]{2}\/+[0-9a-f]+)_[0-9]+_[0-9]+(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain === "img.joinfo.ua") return src.replace(/(\/+g\/+[0-9]{4}\/+[0-9]{2}\/+)[0-9]+x[0-9]+\/+/, "$1");
			if (domain_nosub === "hebeilong.com" &&
				domain.match(/^img/)) {
				return src.replace(/^[a-z]+:\/\/[^/]*\/+img\.php\?(http.*)$/, "$1");
			}
			if (domain === "cdn.blogimage2.crooz.jp") return src.replace(/\/smp_thum_([0-9a-f]+\.[^/.]*)(?:[?#].*)?$/, "/$1");
			if (domain_nosub === "lockerdome.com" && domain.match(/^cdn[0-9]*\./)) {
				return src.replace(/(\/+uploads\/+[0-9a-f]+)_:?[_a-z]+(?:[?#].*)?$/, "$1_:original");
			}
			if (domain === "images.headlines.pw") return src.replace(/(\/[0-9a-f]+)_[0-9]+_[0-9]+(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain_nowww === "harianbernas.com") return src.replace(/\/image_news_[0-9]+\//, "/image_news/");
			if (domain === "static.weloveshopping.com") return src.replace(/(\/[^/_.]*)_[a-z]+(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain_nosub === "heykorean.com" &&
				domain.match(/^store[0-9]*\./)) {
				return src.replace(/(\/+board\/+[0-9]+\/+[0-9]+\/+)thumb\//, "$1");
			}
			if (domain_nowww === "searx.info") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]+\/+image_proxy.*?[?&]url=([^&]*).*?$/, "$1");
				if (newsrc !== src)
					return decodeURIComponent(newsrc);
			}
			if (domain_nosub === "nocutnews.co.kr" && domain.match(/^file[0-9]*\./)) {
				return src.replace(/(\/[0-9]+)_preview(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			}
			if (domain_nosub === "flixcart.com") return src.replace(/(:\/\/[^/]*\/+image)\/+[0-9]+\/+[0-9]+\/+([0-9a-z]+\/+(?:[^/]*\/+)?.\/+.\/+.\/+[^/]*\.[^/.?]*)(?:[?#].*)?$/, "$1/$2");
			if (domain === "conteudo.imguol.com.br") {
				return src
					.replace(/(-[0-9]{5,}_v2)_([0-9]+)x\2\./, "$1_1x1.")
					.replace(/(\/[^/]*\.[^/.?#]*)x(?:[?#].*)?$/, "$1");
			}
			if (domain === "images.gog.com") return src.replace(/(:\/\/[^/]*\/+[0-9a-f]+)_[^/]*(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain_nowww === "imx.to") {
				newsrc = website_query({
					website_regex: [
						/^[a-z]+:\/\/[^/]+\/+img-([0-9a-f]{5,})\.html(?:[?#].*)?$/,
						/^[a-z]+:\/\/[^/]+\/+i\/+([0-9a-z]{5,})(?:[?#].*)?$/,
					],
					query_for_id: function(id, match) {
						var url = "https://imx.to/img-" + id + ".html";
						if (/:\/\/[^/]+\/+i\//.test(match[0]))
							url = "https://imx.to/i/" + id;
						return {
							method: "POST",
							url: url,
							imu_mode: "document",
							headers: {
								"content-type": "application/x-www-form-urlencoded",
								origin: "https://imx.to",
								Referer: url
							},
							data: "imgContinue=Continue+to+your+image..."
						};
					},
					process: function(done, resp, cache_key) {
						var match = resp.responseText.match(/<a href="(https?:\/\/imx\.to\/+u\/+i\/+[^"]+)" title="([^"]+)"[^>]*><img class="[^"]+" src="https?:\/\/imx\.to\/+u\/+i\/+/);
						if (!match) {
							console_error(cache_key, "Unable to find match for", resp);
							return done(null, false);
						}
						var url = decode_entities(match[1]);
						var caption = decode_entities(match[2]);
						return done({
							url: url,
							extra: {
								page: resp.finalUrl,
								caption: caption
							}
						}, 6 * 60 * 60);
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain_nowww === "imx.to") {
				newsrc = src
					.replace(/(:\/\/[^/]+\/+u\/+)t\/+/, "$1i/")
					.replace(/(:\/\/[^/]+\/+)upload\/+[a-z]+\/+/, "$1u/i/");
				if (newsrc !== src)
					return newsrc;
				return src
					.replace(/:\/\/[^/]*\/u\/t\//, "://imx.to/t/")
					.replace(/:\/\/[^/]*\/upload\/+[a-z]+\/+/, "://x001.imx.to/i/");
			}
			if (domain === "t.imx.to") return src.replace(/:\/\/[^/]*\/t\//, "://i.imx.to/i/");
			if (domain_nosub === "imx.to" && domain.match(/^[xi][0-9]+\./)) {
				return src.replace(/:\/\/[^/]*\/t\//, "://imx.to/u/i/");
			}
			if (domain_nowww === "sisajb.com" ||
				domain === "image.kbsm.net") {
				newsrc = src.replace(/\/data\/newsThumb\/([0-9]+(?:&&)?).*?$/, "/data/newsData/$1.jpg");
				if (newsrc !== src)
					return add_extensions_upper(newsrc);
			}
			if (domain === "assets.cdn.moviepilot.de") {
				return {
					url: src.replace(/(\/+files\/+[0-9a-f]+)\/+(?:limit|fill)\/+[0-9]+\/+[0-9]+\/+/, "$1/"),
					head_wrong_contentlength: true
				};
			}
			if (domain === "img.xuehi.cn") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/+(?:[0-9]\/+){3}([^/]*%2F.*?\.[^%]+?)[.!]([0-9]+\.)?[0-9]+x[0-9]+\.auto\.[^/.]+(?:[?#].*)?$/, "$1");
				if (newsrc !== src)
					return add_http(decodeURIComponent(newsrc));
			}
			if (domain_nowww === "infectedbyart.com" && string_indexof(src, "/Images/") >= 0) {
				return {
					url: src.replace(/\/+thumbs\/+/, "/"),
					problems: {
						watermark: true
					}
				};
			}
			if (domain === "static.doramatv.me") return src.replace(/(\/uploads\/+pics\/+.*\/[0-9]+)(\.[^/.]*)(?:[?#].*)?$/, "$1_o$2");
			if (domain === "chi.gomtv.com") return src.replace(/\/imgview\.cgi.*?[?&]nid=([0-9]+).*?$/, "/imgview.cgi?nid=$1&type=0");
			if (domain === "static-thechristianpost.netdna-ssl.com" ||
				domain === "cdn.christianpost.com") {
				return src
					.replace(/\/files\/+cache\/+(image|thumbnail)\/+([0-9]{1,2}\/+[0-9]{1,2}\/+[0-9]+)_(?:[wh]_[0-9]+(?:_[0-9]+)?|(?:a(?:_[0-9]+){2,4}))(\.[^/.]*)(?:[?#].*)?$/, "/files/original/$1/$2$3")
					.replace(/(\/(?:image|thumbnail)\/+[^/]*\.[^/.?#]+)(?:[?#].*)?$/, "$1");
			}
			if (domain === "prnewswire2-a.akamaihd.net") return src.replace(/(\/+entry_id\/+[0-9a-z]+_[0-9a-z]+\/+).*$/, "$1def_height/0/def_width/0");
			if (domain_nosub === "eldarioncloud.com" &&
				domain.match(/^radiocms-images\./)) {
				return src.replace(/^[a-z]+:\/\/[^/]*\/+resize\/+[0-9]+\/+(https?:)/, "$1");
			}
			if (domain === "media.ntslive.co.uk") return src.replace(/\/(?:crop|resize)\/+[0-9]+x[0-9]+\/+/, "/images/");
			if (domain === "icdn.ensonhaber.com") return src.replace(/\/(?:crop|resize)\/+[0-9]+x[0-9]+(?:-[0-9]+)?\/+resimler\/+/, "/resimler/");
			if (domain_nosub === "tedsby.com" && domain.match(/^cdn[0-9]*\./)) {
				return src.replace(/\/tb\/+[a-z]+\/+storage\//, "/storage/");
			}
			if (domain_nosub === "cumicumi.com") return src.replace(/(\/uploads\/+public\/+(?:[0-9a-f]+\/+){3})th_[0-9]+x[0-9]+_([0-9a-f]+\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain_nowww === "kanal247.com") return src.replace(/\/images\/+media\/+[0-9]+x[0-9]+\/+/, "/images/media/photo/");
			if (domain_nowww === "sportuvai.bg") return src.replace(/(\/pictures\/+[0-9]+_{1,2})[0-9]+(_+(?:[0-9]+)?)?(\.[^/.]*)(?:[?#].*)?$/, "$1$2$3");
			if ((domain_nosub === "thetimes.co.uk" ||
				domain_nosub === "thetimes.com") && /\/imageserver\/+image\//.test(src)) {
				return {
					url: src.replace(/(?:\?.*)?$/, "?resize=999999999"),
					head_wrong_contentlength: true
				};
			}
			if (domain === "cdn.celebyolo.com") return src.replace(/\/+(?:thumbnails\/+)?([^/]*-[0-9]+)-[a-z]+(\.[^/.]*)(?:[?#].*)?$/, "/$1$2");
			if (domain_nowww === "voice.fi" ||
				domain_nowww === "radionova.fi") {
				return src.replace(/(\/+files\/+media\/+image\/+(?:[0-9]{4}\/+[0-9]{2}\/+[0-9]{4}_[0-9]{2}_[0-9]{2}_[0-9a-f]+|[0-9a-z]{4}\/+[0-9a-z]{2}\/+[0-9a-z]+|[0-9]+\/+_r\/+[0-9]+_retinaarticle))_[0-9]+(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			}
			if (domain_nowww === "funtime.ge") {
				return src
					.replace(/\/+img\/+[0-9]+\/+uploaded\/+/, "/uploaded/")
					.replace(/(\/+uploaded\/+[a-z]+\/+[0-9]{4}-[0-9]{2}\/+[0-9]+)_[a-z]+(\.[^/.]*)$/, "$1$2");
			}
			if (domain === "t.nhentai.net" ||
				(domain_nosub === "hentaifox.com" && /^i[0-9]*\./.test(domain)) ||
				domain === "images.asmhentai.com" ||
				domain === "t.nyahentai.net") {
				newsrc = src.replace(/(:\/\/[^/]+\/+(?:galleries|[0-9]+)\/+[0-9]+\/+[0-9]+)t(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
				if (newsrc !== src)
					return newsrc.replace(/:\/\/t\./, "://i.");
				return src.replace(/(:\/\/[^/]+\/+(?:galleries|[0-9]+)\/+[0-9]+\/)thumb(\.[^/.]*)(?:[?#].*)?$/, "$1cover$2");
			}
			if (domain_nosub === "hitomi.la") {
				newsrc = src.replace(/:\/\/([a-z])tn\.hitomi\.la\/+(?:small|big)tn\/+([0-9a-f]\/+[0-9a-f]{2}\/+[0-9a-f]{20,})\.[^/.]+(?:[?#].*)?$/, "://$1a.hitomi.la/webp/$2.webp");
				if (newsrc !== src)
					return newsrc;
				regex = /:\/\/[a-z]?tn\.hitomi\.la\/+[a-z]+\/+([0-9]+\/+p?[0-9]+\.[^/.]*)\.[^/.]*(?:[?#].*)?$/;
				if (src.match(regex)) {
					return [
						src.replace(regex, "://aa.hitomi.la/galleries/$1"),
						src.replace(regex, "://ba.hitomi.la/galleries/$1"),
					];
				} else {
					var pageid = src.replace(/^[a-z]+:\/\/[^/]*\/+[a-z]+\/+([0-9]+)\/+.*/, "$1");
					if (src !== pageid) {
						var page = "https://hitomi.la/galleries/" + pageid + ".html";
						return {
							url: src,
							extra: { page: page }
						};
					}
				}
			}
			if (domain === "img.insight.co.kr") return src.replace(/(\/static\/+[0-9]{4}\/+[0-9]{2}\/+[0-9]{2}\/+)[0-9]+\/+([0-9a-z]+\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain_nowww === "express.de") return src.replace(/\/+image\/+([0-9]+)\/+[0-9]+x[0-9]+\/+[0-9]+\/+[0-9]+\/+([0-9a-f]+)\/+..\/+([^/.]*)(\.[^/]*)(?:[?#].*)?$/, "/blob/$1/$2/$3-data$4");
			if (domain === "media.news.de") return src.replace(/:\/\/[^/]*\/(?:images\/+[0-9]+|resources)\/+images\/+([0-9a-f]{2}\/+[0-9a-f]{2}\/+)([0-9a-f]+)\/+.*(\.[^/.]*)(?:[?#].*)?$/, "://media.news.de/resources/images/$1$2$3");
			if (domain === "store.live.ksmobile.net") return src.replace(/(:\/\/[^/]*\/)[a-z]+\/+liveme\/+/, "$1liveme/");
			if (domain === "c.fantia.jp") return src.replace(/(\/uploads\/.*\/)[a-z]+_((?:[0-9a-f]+-){4}[0-9a-f]+\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain_nowww === "ehgt.org") {
				if (/\/g\/+blank\.gif(?:[?#].*)?$/.test(src)) {
					return {
						url: src,
						bad: "mask"
					};
				}
			}
			if (domain_nowww === "e-hentai.org") {
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+(?:lofi\/+)?(s\/+[0-9a-f]+\/+[0-9]+-[0-9]+)(?:[?#].*)?$/,
					query_for_id: "https://e-hentai.org/${id}",
					process: function(done, resp, cache_key) {
						var match = resp.responseText.match(/<img id="(?:sm|img)" src="(https?:\/\/[^"]+)"/);
						if (!match) {
							console_error(cache_key, "Unable to find regular image match for", resp);
							return done(null, false);
						}
						var mainimage = match[1];
						match = null;
						if (options.rule_specific && options.rule_specific.ehentai_full_image)
							match = resp.responseText.match(/href=["'](https?:\/\/(?:www\.)?e-hentai\.org\/fullimg\.php.*?)["']/);
						if (match) {
							return done([decode_entities(match[1]), mainimage], 60 * 60);
						} else {
							return done(mainimage, 60 * 60);
						}
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (host_domain_nowww === "e-hentai.org" && /:\/\/[^/]+\/+s\//.test(options.host_url) &&
				options.element && options.document &&
				options.rule_specific && options.rule_specific.ehentai_full_image) {
				if (options.element.tagName === "IMG" && options.element.id === "img" && options.element.src === src) {
					var els = options.document.getElementsByTagName("a");
					for (var i_6 = 0; i_6 < els.length; i_6++) {
						var el = els[i_6];
						if (!/^https?:\/\/(?:www\.)?e-hentai\.org\/fullimg\.php/.test(els[i_6].href))
							continue;
						return els[i_6].href;
					}
				}
			}
			if (host_domain_nowww === "e-hentai.org" && /:\/\/[^/]+\/+lofi\/+s\//.test(options.host_url) && options.element &&
				options.rule_specific && options.rule_specific.ehentai_full_image) {
				if (options.element.tagName === "IMG" && options.element.id === "sm" && options.element.src === src) {
					return {
						url: options.host_url,
						is_pagelink: true
					};
				}
			}
			if (host_domain_nowww === "e-hentai.org" && /:\/\/[^/]*\/+(?:lofi\/+)?g\//.test(options.host_url) && options.element) {
				newsrc = common_functions["get_pagelink_el_matching"](options.element, /^[a-z]+:\/\/[^/]+\/+(?:lofi\/+)?s\/+/);
				if (newsrc)
					return newsrc;
				if (options.element.tagName === "DIV" && options.element.children.length === 1 && options.element.children[0].tagName === "A") {
					var childel = options.element.children[0];
					if (/^[a-z]+:\/\/[^/]+\/+(?:lofi\/+)?s\/+/.test(childel.href)) {
						return {
							url: childel.href,
							is_pagelink: true
						};
					}
				}
			}
			if (domain === "cdn.zenfolio.net" ||
				domain_nosub === "zenfolio.com") {
				if (/\/zf\/+img\/+null\./.test(src))
					return {
						url: src,
						bad: "mask"
					};
			}
			if ((domain === "cdn.zenfolio.net" ||
				domain_nosub === "zenfolio.com") && /:\/\/[^/]+\/+cdn[0-9]*\/+pub\//.test(src)) {
				return src.replace(/:\/\/[^/]*\/+cdn[0-9]*\/+pub\/+(?:[^?#]*?)(\/(?:s[0-9]*\/+)?[^/]*\/+p[0-9]+-[0-9]+\.[^/.?#]*)(?:[?#].*)?$/, "://www.zenfolio.com/img$1");
			}
			if (domain_nosub === "zenfolio.com") {
				regex = /(\/img\/+(?:s[0-9]*\/+)?v-?[0-9]+\/+p[0-9]+)-[0-9]+(\.[^/.?#]*)(?:[?#].*)?$/;
				return fillobj_urls([
					src.replace(regex, "$1$2"),
					src.replace(regex, "$1-7$2"),
					src.replace(regex, "$1-6$2"),
					src.replace(regex, "$1-5$2"),
					src.replace(regex, "$1-4$2"),
					src.replace(regex, "$1-3$2")
				], {
					bad_if: [{
							headers: {
								"content-length": "3446",
								"content-type": "image/png"
							}
						}],
					can_head: false // head only works sometimes, and returns odd last-modified
				});
			}
			if (domain === "gallery.greatandhra.com") return src.replace(/(\/upload\/+[0-9]+\/+)[a-z]+\/+/, "$1images/");
			if (domain_nowww === "fortstore.net" ||
				domain_nowww === "imgfrost.net" ||
				domain_nowww === "imgblaze.net" ||
				domain_nowww === "imgair.net" ||
				domain_nowww === "iceimg.net" ||
				domain_nowww === "vestimage.site" ||
				domain_nowww === "chaosimg.site" ||
				domain_nowww === "imgweng.xyz" ||
				domain_nowww === "imgkes.xyz" ||
				domain_nowww === "venpix.xyz" ||
				domain_nowww === "imgwew.xyz" ||
				domain_nowww === "imgvivo.xyz" ||
				domain_nowww === "imgkr.xyz" ||
				domain_nowww === "imgkoi.xyz" ||
				domain_nowww === "imgtigr.xyz" ||
				domain_nowww === "imgbird.xyz" ||
				domain_nowww === "imglin.xyz" ||
				domain_nowww === "pickjsn.cfd" ||
				domain_nowww === "imgcdfd.sbs" ||
				domain_nosub === "imgopaleno.site" ||
				domain_nowww === "pixsera.net" ||
				domain_nowww === "cloudgallery.net" ||
				domain_nosub === "imgbig.xyz" ||
				domain_nosub === "fiyar.live") {
				newsrc = src.replace(/(\/data_server_(?:[0-9]+|new)\/+[0-9]+\/+)[a-z]+\/+[a-z]+_([^/]*\.[^/.]*)(?:[?#].*)?$/, "$1big/$2");
				if (newsrc !== src)
					return newsrc;
				regex = /\/themes\/+latest\/+ssd\/+small\/+([0-9]+)\/+small-/;
				if (regex.test(src)) {
					return [
						src.replace(regex, "/themes/latest/uploads4/pixsense/big/$1/"),
						src.replace(regex, "/themes/latest/uploads3/pixsense/big/$1/"),
						src.replace(regex, "/themes/latest/uploads2/pixsense/big/$1/")
					];
				}
				newsrc = src.replace(/\/themes\/+latest\/+ssd\/+small\/+small-/, "/themes/default/big/");
				if (newsrc !== src)
					return newsrc;
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+([a-z0-9]{3,}|site\/+v\/+[0-9]+)(?:[?#].*)?$/,
					query_for_id: "http://" + domain + "/${id}",
					process: function(done, resp, cache_key) {
						var match = resp.responseText.match(/document\.location\.href="(https?:\/\/[^/]+\/+(?:data_server[^/]*\/+[0-9]+\/+big\/+|themes\/+latest\/+uploads[0-9]*\/+pixsense\/+big\/+[0-9]+\/+|themes\/+default\/+big\/+)[^"]+)"/);
						if (!match) {
							console_error(cache_key, "Unable to find match for", resp);
							return done(null, false);
						}
						return done(match[1], 6 * 60 * 60);
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain === "static.jpg.pl") return src.replace(/(\/static\/+photos\/+[0-9a-f]+\/+[0-9a-f]+\/+[0-9a-f]+)_[a-z]+(\.[^/.]*)(?:[?#].*)?$/, "$1_original$2");
			if ((domain_nosub === "nevsepic.com.ua" ||
				domain_nosub === "nevseoboi.com.ua") &&
				domain.match(/^c[po][0-9]*\./)) {
				return src.replace(/(\/[0-9]{3}\/+[0-9]+\/+)thumbs\//, "$1");
			}
			if (domain === "static.pulsk.com" ||
				domain_nowww === "pulsk.com") {
				return src.replace(/(\/images\/+[0-9]{4}\/+[0-9]{2}\/+[0-9]{2}\/+)thumb_[0-9]+_([^/]*\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			}
			if (domain_nowww === "pornchampion.com") return src.replace(/\/images\/+[^/]*\/+([0-9]{4}\/+[0-9]{2}\/+[0-9]{2}\/)/, "/images/big_images/$1");
			if (domain === "cdn.vthumbs.com") return src.replace(/:\/\/[^/]*\/thumbs\/[0-9]+px\/content\//, "://content.pornpics.com/");
			if (domain === "content.pornpics.com" ||
				domain === "img.pornpics.com") {
				var folder = "pics";
				if (domain === "img.pornpics.com")
					folder = "pics1";
				return src.replace(/:\/\/[^/]*\/+(?:[0-9]+\/+)?([0-9]{4}-[0-9]{2}-[0-9]{2}\/+[0-9]+_[0-9]+)(\.[^/.]*)(?:[?#].*)?$/, "://cdn.pornpics.com/" + folder + "/$1big$2");
			}
			if (domain === "images.pornpics.com" ||
				domain === "cdni.shavedpics.com" ||
				domain === "cdni.hotnudegirls.net" ||
				domain === "cdni.pornpics.com") {
				obj = {
					url: src
				};
				match = src.match(/\/([0-9]{5,})\/\1_[0-9]{3}_[0-9a-f]+\./);
				if (false && match) {
					obj.extra = {
						page: "https://www.pornpics.com/galleries/" + match[1] + "/"
					};
				}
				newsrc = src.replace(/(:\/\/[^/]*\/)(?:300|460)\/+/, "$11280/");
				if (newsrc !== src)
					obj.url = newsrc;
				return obj;
			}
			if (domain_nowww === "vipissy.com" ||
				domain === "media.fistertwister.com" ||
				domain_nowww === "peeonher.com" ||
				domain === "media.wetandpissy.com" ||
				domain === "media.puffynetwork.com") {
				return src.replace(/(\/fhg\/+[0-9a-f]+\/+)thumbs\//, "$1files/");
			}
			if (domain_nosub === "explicithd.com" && /^static-cdn/.test(domain)) {
				return src.replace(/(\/content\/+[^/]*\/+[0-9a-f]{20,}\/+)thumbs\/+/, "$1files/");
			}
			if (domain === "images.porninspector.com") return src.replace(/\/tmb_([^/]*)(?:[?#].*)?$/, "/$1");
			if (domain_nosub === "zoznam.sk") {
				newsrc = src.replace(/:\/\/([^/.]*)\.[^/]*\/cacheImg\/[^/]*\/([0-9]+px)\/(?:[^/.]*-)?([0-9]+[^/]*)(?:[?#].*)?$/, "://static.$1.zoznam.sk/$2/$3");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "gamesite.zoznam.sk") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]+\/+images\/+thumb\.php\?(?:.*?&)?src=([^&]+).*?$/, "$1");
				if (newsrc !== src)
					return decodeuri_ifneeded(newsrc);
				return {
					url: src,
					headers: {
						Referer: ""
					}
				};
			}
			if (domain_nosub === "zoznam.sk") return src.replace(/(:\/\/[^/]*\/)[0-9]+px\//, "$1original/");
			if (domain_nowww === "wallhalla.com" &&
				options && options.cb && options.do_request) {
				id = src.replace(/.*\/thumbs\/.*\/([^/.]*)[^/]*(?:[?#].*)?$/, "$1");
				if (id !== src) {
					options.do_request({
						url: "https://wallhalla.com/wallpaper/" + id,
						method: "GET",
						onload: function(resp) {
							if (resp.readyState === 4) {
								var match = resp.responseText.match(/ data-wallurl=["']([^"']*)["']/);
								if (match) {
									options.cb(urljoin(src, match[1], true));
								} else {
									options.cb(null);
								}
							}
						}
					});
					return {
						waiting: true
					};
				}
			}
			if (domain_nowww === "artfile.ru") {
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+i\.php\?(?:.*&)?i=([0-9]+)(?:[&#].*)?$/,
					query_for_id: "https://www.artfile.ru/i.php?i=${id}",
					process: function(done, resp, cache_key) {
						var match = resp.responseText.match(/top.location.href *= *["'](https?:\/\/i\.artfile\.ru\/[^"']*)["']/);
						if (!match) {
							console_error(cache_key, "Unable to find match for", resp);
							return done(null, false);
						}
						done({
							url: urljoin(src, match[1], true),
							extra: {
								page: resp.finalUrl
							}
						}, 6 * 60 * 60);
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain === "i.artfile.ru") {
				id = src.replace(/^[a-z]+:\/\/[^/]*\/[0-9]+x[0-9]+_([0-9]+)_.*$/, "$1");
				if (id === src) {
					id = src.replace(/^[a-z]+:\/\/[^/]*\/s\/+([0-9]+)_[0-9]+_[^/]*(?:[?#].*)?$/, "$1");
				}
				if (id !== src) {
					return {
						url: "http://www.artfile.ru/i.php?i=" + id,
						is_pagelink: true
					};
				}
			}
			if (domain_nowww === "relook.ru" ||
				domain === "st.relook.ru") {
				return src.replace(/(\/data\/+cache\/+.*)(?:nothumb[0-9]+|-[0-9]+x[0-9]+)(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			}
			if (domain_nowww === "izhevsk.ru") return src.replace(/(\/forum_pictures\/+[^/]*\/+)thm\//, "$1");
			if (domain === "img.navodayatimes.in") return src.replace(/^[a-z]+:\/\/[^/]*\/default\.aspx.*?[?&]img=([^&]*).*?$/, "$1");
			if (domain_nowww === "wallmachine.pl") return src.replace(/(\/media\/+ecommerce\/+products\/+product[0-9]+\/+)[0-9]+x[0-9]+_(?:true|false)_/, "$1");
			if (domain === "ds393qgzrxwzn.cloudfront.net") return src.replace(/\/resize\/m[0-9]+x[0-9]+\//, "/");
			if (domain_nowww === "religionpeace.ru" ||
				domain_nowww === "eurikacosmetics.ru") {
				return src.replace(/^[a-z]+:\/\/[^/]*\/[0-9]+\/+[0-9]+\/+(https?)\/(.*)$/, "$1://$2");
			}
			if (domain_nowww === "fb.ru") {
				return src
					.replace(/\/misc\/+i\/+thumb\/+[^/]*\/+/, "/media/i/")
					.replace(/(\/media\/+i\/+(?:[0-9]+\/+){1,}i\/+[0-9]+)_[0-9]+x[0-9]+(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			}
			if (domain_nowww === "specialone.co.kr") return src.replace(/(\/alldata\/+[^/]*\/+)thum_([^/]*)(?:[?#].*)?$/, "$1$2");
			if (domain === "static.mellbimbo.eu") {
				return {
					url: src.replace(/(:\/\/[^/]*\/+)thumb\//, "$1files/"),
					headers: {
						Origin: "http://mellbimbo.eu",
						Referer: "http://mellbimbo.eu"
					}
				};
			}
			if (domain_nowww === "8xxx.net") {
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+pictures\/+([0-9]+)(?:-[^/]+)?(?:\.html)?(?:[?#].*)?$/,
					query_for_id: "http://8xxx.net/pictures/${id}",
					process: function(done, resp, cache_key) {
						var match = resp.responseText.match(/<p><a href=["'](.*?)["']>https?:\/\//);
						if (!match) {
							console_error(cache_key, "Unable to find match for", resp);
							return done(null, false);
						}
						return done(match[1], 6 * 60 * 60);
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain_nowww === "8xxx.net") {
				id = src.replace(/^[a-z]+:\/\/[^/]*\/preview\/+[0-9]\/+[0-9]+\/+([0-9]+)\.[^/.]*(?:[?#].*)?$/, "$1");
				if (id !== src) {
					return {
						url: "http://8xxx.net/pictures/" + id,
						is_pagelink: true
					};
				}
			}
			if (domain === "i.frg.im") return src.replace(/_[0-9]+(\.[^/.]*)(?:[?#].*)?$/, "$1");
			if (domain_nowww === "thehshq.com") {
				regex = /\/d\/+([0-9]+)(-[0-9]+\/+[^/]*)(?:[?#].*)?$/;
				match = src.match(regex);
				if (match) {
					var parsed_3 = parseInt(match[1]);
					return [
						{
							url: src.replace(regex, "/d/" + (parsed_3 - 2) + "$2"),
							norecurse: true
						},
						{
							url: src.replace(regex, "/d/" + (parsed_3 - 1) + "$2"),
							norecurse: true
						}
					];
				}
			}
			if (domain_nosub === "11alive.com" ||
				domain_nosub === "12news.com" ||
				domain_nosub === "12newsnow.com" ||
				domain_nosub === "13newsnow.com" ||
				domain_nosub === "13wmaz.com" ||
				domain_nosub === "9news.com" ||
				domain_nosub === "abc10.com" ||
				domain_nosub === "cbs8.com" ||
				domain_nosub === "cbs19.tv" ||
				domain_nosub === "firstcoastnews.com" ||
				domain_nosub === "kagstv.com" ||
				domain_nosub === "kare11.com" ||
				domain_nosub === "kcentv.com" ||
				domain_nosub === "kens5.com" ||
				domain_nosub === "kgw.com" ||
				domain_nosub === "khou.com" ||
				domain_nosub === "kiiitv.com" ||
				domain_nosub === "king5.com" ||
				domain_nosub === "krem.com" ||
				domain_nosub === "ksdk.com" ||
				domain_nosub === "ktvb.com" ||
				domain_nosub === "kvue.com" ||
				domain_nosub === "myfoxzone.com" ||
				domain_nosub === "newscentermaine.com" ||
				domain_nosub === "thv11.com" ||
				domain_nosub === "wbir.com" ||
				domain_nosub === "wcnc.com" ||
				domain_nosub === "wfaa.com" ||
				domain_nosub === "wfmynews2.com" ||
				domain_nosub === "wgrz.com" ||
				domain_nosub === "whas11.com" ||
				domain_nosub === "wltx.com" ||
				domain_nosub === "wtsp.com" ||
				domain_nosub === "wusa9.com" ||
				domain_nosub === "wwltv.com" ||
				domain_nosub === "wzzm13.com") {
				if (/^media\./.test(domain)) {
					return src.replace(/(\/assets\/+[A-Z]+\/+images\/+[-0-9a-f]{20,}\/+[-0-9a-f]{20,})_[0-9]+x[0-9]+(\.[^/.]+)(?:[?#].*)?$/, "$1$2");
				}
				if (domain_nowww === domain_nosub) {
					newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/+img\/+resize\/+([^/]*\.[^/]*\/.*?)(?:[?#].*)?$/, "$1");
					if (newsrc !== src)
						return add_http(newsrc);
				}
			}
			if (domain_nowww === "celeb6free.com" ||
				domain_nowww === "celeb-for-free.com") {
				newsrc = src.replace(/\/pics\/+tn_([^/]*)(?:[?#].*)?$/, "/pics/$1");
				if (newsrc !== src) {
					return {
						url: newsrc,
						extra: {
							page: newsrc.replace(/\/pics\/[^/]*$/, "/")
						}
					};
				}
			}
			if (domain === "images.poms.omroep.nl") return src.replace(/\/image\/+(?:s[0-9]+(?:x[0-9]+)?|c[0-9]+(?:x[0-9]+)?)\/+/, "/image/");
			if (domain_nosub === "tvbuzer.com" &&
				domain.match(/^static[0-9]*\./)) {
				return src.replace(/(\/images\/+[a-z]+\/+)([0-9a-f]+\/+[0-9a-f]+-[0-9]+)-[0-9]+-[0-9]+(\.[^/.]*)(?:[?#].*)?$/, "$1sources/$2$3");
			}
			if (domain_nosub === "mrskincdn.com" &&
				domain.match(/^assets[0-9]*\./)) {
				return src.replace(/(\/[^/]*-[0-9a-f]+)_[a-z_]+(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			}
			if (domain_nosub === "spankbang.com" &&
				domain.match(/^cdnthumb[0-9]*\./)) {
				return src.replace(/(:\/\/[^/]*\/)[0-9]+\/+([0-9]\/+[0-9]\/+[0-9]+-t)/, "$10/$2");
			}
			if (domain === "static.spankbang.com") return src.replace(/(\/pornstarimg\/+f\/+[0-9]+)-[0-9]+(\.[^/.]+)(?:[?#].*)?$/, "$1$2");
			if (domain_nosub === "sb-cd.com" && /^tb[0-9]*\./.test(domain)) {
				newsrc = src
					.replace(/(\/[0-9]+-t[0-9]+)-(?:s|enh)\/+/, "$1/")
					.replace(/(:\/\/[^/]+\/+)w:[0-9]+\/+/, "$1w:0/");
				if (newsrc !== src)
					return newsrc;
			}
			if ((domain_nosub === "sb-cd.com" && /^tbv?[0-9]*\./.test(domain)) ||
				(domain_nosub === "spankbang.com" && /^vcdn-[^-]+(?:-[0-9]+)?\./.test(domain))) {
				match = src.match(/:\/\/[^/]+\/+(?:w:[0-9]+\/+)?[0-9]\/+[0-9]\/+([0-9]+)-/);
				var vidid_numeric, vidid;
				if (match) {
					vidid_numeric = parseInt(match[1]);
					vidid = vidid_numeric.toString(36);
					obj = {
						url: src,
						extra: { page: "https://spankbang.com/" + vidid + "/video/" }
					};
				}
				if (options.cb && options.do_request && match) {
					var get_streamkey_for_vidid = function(vidid, cb) {
						var cache_key = "spankbang_streamkey:" + vidid;
						api_cache.fetch(cache_key, cb, function(done) {
							options.do_request({
								method: "GET",
								url: "https://spankbang.com/" + vidid + "/video/",
								onload: function(resp) {
									if (resp.readyState !== 4)
										return;
									if (resp.status !== 200) {
										console_error(resp);
										return done(null, false);
									}
									match = resp.responseText.match(/data-videoid=["'][0-9]+["']\s+data-streamkey=["']([^"']+)["']/);
									if (match) {
										return done(match[1], 24 * 60 * 60);
									} else {
										console_warn("Unable to find match", resp);
										return done(null, false);
									}
								}
							});
						});
					};
					var get_streamdata = function(streamkey, cb) {
						var cache_key = "spankbang_streamdata:" + streamkey;
						api_cache.fetch(cache_key, cb, function(done) {
							options.do_request({
								method: "POST",
								url: "https://spankbang.com/api/videos/stream",
								data: "id=" + streamkey + "&data=0",
								headers: {
									"Origin": "https://spankbang.com",
									"Referer": "https://spankbang.com/", // add /.../video?
									"Content-Type": "application/x-www-form-urlencoded; charset=UTF-8",
									"X-Requested-With": "XMLHttpRequest"
								},
								onload: function(resp) {
									if (resp.readyState !== 4)
										return;
									if (resp.status !== 200) {
										console_error(resp);
										return done(null, false);
									}
									try {
										var response = JSON_parse(resp.responseText);
										return done(response, 6 * 60 * 60);
									} catch (e) {
										console_error(e, resp);
										return done(null, false);
									}
								}
							});
						});
					};
					var find_largest_from_streamdata = function(streamdata) {
						var sizes = [
							"4k",
							"1080p",
							"720p",
							"480p",
							"360p",
							"320p",
							"240p",
							"144p"
						];
						var largestsize = 100;
						for (var key in streamdata) {
							if (!streamdata[key] || streamdata[key].length === 0)
								continue;
							var ourindex = array_indexof(sizes, key);
							if (ourindex >= 0 && ourindex < largestsize)
								largestsize = ourindex;
						}
						if (largestsize < sizes.length) {
							return streamdata[sizes[largestsize]][0];
						}
						return null;
					};
					var get_norm_sb_url = function(url) {
						return url.replace(/.*\/([0-9]+-[0-9]+[a-z]+\.[^/.?]+)(?:[?#].*)?$/, "$1");
					};
					get_streamkey_for_vidid(vidid, function(streamkey) {
						if (!streamkey)
							return options.cb(obj);
						get_streamdata(streamkey, function(streamdata) {
							if (!streamdata)
								return options.cb(obj);
							var largest = find_largest_from_streamdata(streamdata);
							if (get_norm_sb_url(largest) !== get_norm_sb_url(src)) {
								obj.url = largest;
							}
							options.cb(obj);
						});
					});
					return {
						waiting: true
					};
				} else if (match) {
					return options.cb(obj);
				}
			}
			if (domain_nowww === "kosova-sot.info" ||
				domain_nowww === "botasot.info" ||
				domain_nowww === "syri.net") {
				return src.replace(/(\/(?:uploads|media)\/+(?:[^/]+\/+)?images\/+[0-9]{4}\/+[A-Z][a-z]+\/+[0-9]+\/+)(?:auto|thumb|thumbauto|[0-9]+x[0-9]+)_([^/]*)(?:[?#].*)?$/, "$1$2");
			}
			if (domain === "img.mako.co.il") return src.replace(/(:\/\/[^/]*\/[0-9]{4}\/+[0-9]{2}\/+[0-9]{2}\/+[^/]*)_(?:[a-z]|reduced)?(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain_nosub === "okeinfo.net" &&
				domain.match(/^img(?:-[^.]*)?\./)) {
				return src.replace(/(:\/\/[^/]*\/)okz\/+[0-9]+\/+([a-z]+\/)/, "$1$2");
			}
			if (domain_nowww === "freexcafe.com" ||
				domain_nowww === "foxyporn.com") {
				return src
					.replace(/\/img\/([0-9]+)(\.[^/.]*)(?:[?#].*)?$/, "/pics/pics$1$2")
					.replace(/\/img\/([0-9a-f]+)-thumb[0-9]+x[0-9]+(\.[^/.]*)(?:[?#].*)?$/, "/pics/$1$2");
			}
			if (domain === "cdn-webimages.wimages.net") return src.replace(/(:\/\/[^/]*\/[0-9a-f]+)(?:-(?:[a-z]+|v[0-9]+)){1,}(\.[^/.]*)$/, "$1$2");
			if (domain === "portal-images.azureedge.net") return src.replace(/\/images\/([-0-9a-f]+\.[^/.]*?)(?:[?#].*)?$/, "/images/$1");
			if (domain === "img.goldlive.co.kr") return src.replace(/\/resize_[0-9]+x[0-9]+\//, "/");
			if (domain_nowww === "nicegirl.io" ||
				domain_nowww === "sexypic.org") {
				return src.replace(/(\/album_[0-9]+\/+)t_(i_[^/]*)(?:[?#].*)?$/, "$1$2");
			}
			if ((domain_nosub === "35photo.ru" ||
				domain_nosub === "35photo.pro") &&
				src.match(/:\/\/[^/]*\/photos_/)) {
				newsrc = src
					.replace(/:\/\/m[0-9]*\.35photo[^/]*\//, "://35photo.pro/")
					.replace(/\/photos_(?:col|temp)\/+(?:r[0-9]|sizes)\/+([0-9]+\/[0-9]+)(?:_[^/.]*)?(\.[^/.]*)(?:[?#].*)?$/, "/photos_main/$1$2");
				if (newsrc !== src)
					return newsrc;
				match = src.match(/:\/\/[^/]+\/+photos_main\/+[0-9]+\/+([0-9]+)\./);
				if (match) {
					return {
						url: src,
						extra: { page: "https://35photo.pro/photo_" + match[1] + "/" }
					};
				}
			}
			if (domain_nowww === "artfile.me") {
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+wallpaper\/+((?:[^/?#]+-)?[0-9]+)\.[^/.]+(?:[?#].*)?$/,
					query_for_id: "https://artfile.me/wallpaper/${id}.html",
					process: function(done, resp, cache_key) {
						var match = resp.responseText.match(/<a href="\/download\/[^/]+\/([0-9]+x[0-9]+)"/);
						if (!match) {
							console_error(cache_key, "Unable to find match for", resp);
							return done(null, false);
						}
						var size = match[1];
						var image = get_meta(resp.responseText, "og:image");
						if (!image) {
							console_error(cache_key, "Unable to find image from", resp);
							return done(null, false);
						}
						image = urljoin(resp.finalUrl, image, true);
						image = image.replace(/\/[0-9]+x[0-9]+\//, "/" + size + "/")
							.replace(/:\/\/pw\.artfile/, "://i.artfile");
						return done({
							url: image,
							extra: {
								page: resp.finalUrl
							}
						}, 6 * 60 * 60);
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain === "pw.artfile.me" || domain === "i.artfile.me") {
				id = src.replace(/.*\/wallpaper\/+[0-9]+-[0-9]+-[0-9]{4}\/+[0-9]+x[0-9]+\/+([^/.?#]*).*?$/, "$1");
				if (id !== src) {
					return {
						url: "https://artfile.me/wallpaper/" + id + ".html",
						is_pagelink: true
					};
				}
			}
			if (domain_nosub === "fotokto.ru" && domain.match(/^s[0-9]*\./)) {
				return src.replace(/\/photo\/+[a-z]+\//, "/photo/full/");
			}
			if (domain_nowww === "500px.com") {
				/*
				PHOTO_GRID_IMAGE_SIZES: ["1", "2", "32", "31", "33", "34", "35", "36", "2048", "4", "14"],
				PHOTO_SIZES: {
					S3_IMG_SIZE_70: 1,
					S3_IMG_SIZE_140: 2,
					S3_IMG_GRID_300: 32,
					S3_IMG_GRID_450: 31,
					S3_IMG_GRID_600: 33,
					S3_IMG_WEB_1000: 34,
					S3_IMG_WEB_1500: 35,
					S3_IMG_WEB_2000: 36,
					S3_IMG_SIZE_XLARGE: 2048,
					S3_IMG_STORE_900: 14
				},
				*/
				var query_500px_api_1 = function(url, cb) {
					var query_obj = {
						url: url,
						json: true
					};
					var do_query = function() {
						api_query("500px_api:" + url, query_obj, cb, function(done, resp, cache_key) {
							if (!resp) {
								return done(null, false);
							} else {
								return done(resp, 60 * 60);
							}
						});
					};
					if (options.get_cookies) {
						options.get_cookies(url, function(cookies) {
							if (cookies) {
								var cookies_dict = headers_list_to_dict(cookies);
								if (cookies_dict && cookies_dict["x-csrf-token"]) {
									query_obj.headers = {
										"x-csrf-token": cookies_dict["x-csrf-token"]
									};
								}
							}
							do_query();
						});
					} else {
						do_query();
					}
				};
				var query_500px_photo_1 = function(id, cb) {
					var page = "https://500px.com/photo/" + id + "/";
					var query_url = "https://api.500px.com/v1/photos?image_size%5B%5D=1&image_size%5B%5D=2&image_size%5B%5D=32&image_size%5B%5D=31&image_size%5B%5D=33&image_size%5B%5D=34&image_size%5B%5D=35&image_size%5B%5D=36&image_size%5B%5D=2048&image_size%5B%5D=4096&image_size%5B%5D=4&image_size%5B%5D=14&expanded_user_info=true&include_tags=true&include_geo=true&include_equipment_info=true&vendor_photos=true&include_licensing=true&include_releases=true&liked_by=1&following_sample=100&ids=" + id;
					query_500px_api_1(query_url, function(data) {
						var obj = {
							url: src,
							extra: {
								page: page
							}
						};
						var sizelist = [0, 1, 2, 32, 31, 33, 14, 34, 35, 36, 2048, 4096];
						var comparesizes = function(a, b) {
							var a_index = array_indexof(sizelist, a);
							if (a_index < 0)
								return false;
							var b_index = array_indexof(sizelist, b);
							if (b_index < 0)
								return false;
							return b_index > a_index;
						};
						try {
							var images = data.photos[id].images;
							page = urljoin(page, data.photos[id].url, true);
							obj.extra.page = page;
							obj.extra.caption = data.photos[id].name || data.photos[id].description;
							var largestsize = 0;
							var largesturl = null;
							for (var i = 0; i < images.length; i++) {
								if (comparesizes(largestsize, images[i].size)) {
									largestsize = images[i].size;
									largesturl = images[i].https_url;
								}
							}
							if (largesturl !== null)
								obj.url = largesturl;
						} catch (e) {
							console_error(e);
							return cb(null);
						}
						return cb(obj);
					});
				};
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+photo\/+([0-9]+)(?:\/+[^/]*\/*)?(?:[?#].*)?$/,
					run: function(cb, match) {
						query_500px_photo_1(match[1], cb);
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain === "drscdn.500px.org") {
				id = src.replace(/^[a-z]+:\/\/[^/]*\/photo\/+([0-9]+)\/.*$/, "$1");
				if (id !== src) {
					return {
						url: "https://500px.com/photo/" + id + "/",
						is_pagelink: true
					};
				}
			}
			if (domain_nowww === "xportsnews.com" ||
				domain === "image.xportsnews.com") {
				return src.replace(/(\/contents\/+images\/+upload\/+.*\/)thm_/, "$1");
			}
			if (domain === "contents.innolife.net") return src.replace(/(\/mobile\/img\/item\/[0-9]+_)[a-z]+(\.[^/.]*)$/, "$1l$2");
			if (domain === "mnews.imaeil.com" ||
				domain === "news.imaeil.com") {
				return src.replace(/(\/photos\/+[0-9]{4}\/+(?:[0-9]{2}\/+){2}[0-9]{5,})_[sm](\.[^/.]*)(?:[?#].*)?$/, "$1_l$2");
			}
			if (domain_nowww === "blognews.am") return src.replace(/\/static\/+news\/+[a-z]\/+/, "/static/news/b/");
			if (domain_nowww === "sasisa.ru") return src.replace(/(\/blog\/+content\/+[0-9]+\/+[0-9a-f]+)_[0-9]+(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain === "i.photographers.ua" ||
				domain_nowww === "photographers.ua") {
				return src.replace(/\/thumbnails\/+((?:pictures|users)\/+[0-9]+)\/+[0-9]+x([^/.]*\.[^/.]*)(?:[?#].*)?$/, "/images/$1/$2");
			}
			if (domain_nowww === "copia-di-arte.com" &&
				string_indexof(src, "/kunst/") >= 0) {
				return src.replace(/_lo(\.[^/.]*)(?:[?#].*)?$/, "$1");
			}
			if (domain_nowww === "kino-teatr.ru") return src.replace(/(\/movie\/+kadr\/+[0-9]+\/+)pv_([0-9]+\.[^/.]+)(?:[?#].*)?$/, "$1$2");
			if (domain_nosub === "photosight.ru" &&
				domain.match(/^prv-[0-9]{4}-[0-9]+\./)) {
				return src.replace(/:\/\/prv(-.*\/)pv_([0-9]+\.[^/.]*)(?:[?#].*)?$/, "://img$1$2");
			}
			if (domain === "cdn.photosight.ru") {
				newsrc = src.replace(/(\/img\/+[0-9a-f]\/+[0-9a-f]{3}\/+[0-9]+)_(?:thumb|large|mini)(\.[^/.]+)(?:[?#].*)?$/, "$1_xlarge$2");
				match = src.match(/\/img\/+[0-9a-f]\/+[0-9a-f]{3}\/+([0-9]+)(?:_[a-z]+)?\./);
				if (match) {
					return {
						url: newsrc,
						extra: { page: "https://photosight.ru/photos/" + match[1] + "/" }
					};
				} else {
					return newsrc;
				}
			}
			if (domain === "rs.kantie.org") return src.replace(/^[a-z]+:\/\/[^/]*\/it\/(https?:)/, "$1");
			if (domain_nowww === "zmut.com") return src.replace(/\/uploads\/cache\/(pins\/+[0-9]{4}\/+[0-9]{2}\/+[^/]*)-[0-9]+x(\.[^/.]*)(?:[?#].*)?$/, "/uploads/$1$2");
			if (domain_nosub === "2photo.ru" &&
				domain.match(/^i[0-9]*\./)) {
				return src.replace(/(:\/\/[^/]*)\/[a-z]+\/+(.\/+.\/+[0-9]+\.)/, "$1/$2");
			}
			if (domain === "m.salon24.pl") return src.replace(/(:\/\/[^/]*\/[0-9a-f]+)(?:,[0-9]+){4}(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain === "cdn.fishki.net" ||
				domain === "cdn-tn.fishki.net") {
				return src
					.replace(/(\/upload\/+post\/+[0-9]{6}\/+[0-9]{2}\/+[0-9]+\/+)tn\/+/, "$1")
					.replace(/(\/upload\/+post\/+[0-9]{4}\/+(?:[0-9]{2}\/+){2}[0-9]+\/+(?:gallery\/+)?)tn\/+/, "$1")
					.replace(/:\/\/cdn-tn\.([^/]*\/)(?:[0-9]+\/+)?upload\//, "://cdn.$1upload/");
			}
			if (domain_nowww === "ravshaniya.com") return src.replace(/\/uploads\/+photos\/+thumbs\/+[0-9]+\/+/, "/uploads/photos/");
			if (domain_nowww === "onlyhdwallpapers.com" ||
				domain_nowww === "hdwallpapers.cat") {
				var cookie = null;
				var watermark = true;
				if (options.document && options.document.cookie) {
					cookie = options.document.cookie;
					watermark = false;
				}
				return {
					url: src.replace(/(:\/\/[^/]*\/)thumbnail(?:_[a-z]+)?\/+/, "$1wallpaper/"),
					headers: {
						Origin: "https://" + domain,
						Referer: src,
						Cookie: cookie
					},
					problems: {
						watermark: true
					}
				};
			}
			if (domain === "cdn.slushe.com") {
				newsrc = src.replace(/\/thumbs\/+((?:[0-9a-f]\/+){5}[0-9a-f]+\.mp4)\/+[^/]+(?:[?#].*)?$/, "/videos/$1");
				if (newsrc !== src) {
					return newsrc.replace(/:\/\/cdn\./, "://vcdn.");
				}
			}
			if (domain_nowww === "bestpornbabes.com" ||
				domain === "cdn.shesfreaky.com" ||
				domain === "media.ruleporn.com" ||
				domain_nowww === "teenplanet.org" ||
				domain_nowww === "goodsexporn.org" ||
				domain === "cdn.slushe.com" ||
				domain === "media.theync.com" ||
				domain === "media.babesource.com") {
				return src.replace(/(\/+galleries\/+(?:[0-9a-f]+|[0-9a-zA-Z]+)\/+)thumbs\/+(?:[0-9]+x[0-9]+\/+)?/, "$1");
			}
			if (domain === "cdn.brdmedia.com") return src.replace(/(\/galleries\/.*\/)thumbs\/+/, "$1");
			if (domain === "staticpopopics.popopics.com") return src.replace(/\/uploads\/(?:thumb|display)\//, "/uploads/original/");
			if (domain_nowww === "stopga.me") return src.replace(/(\/images\/+(?:uploads\/+images|news)\/+[0-9]+\/+.*\/)normal_([^/]+\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain_nosub === "foap.com" && domain.match(/^cdn[0-9]*\./)) {
				return src.replace(/(\/images\/+[-0-9a-f]+\/+)[wh][0-9]+(\.[^/.]*)(?:[?#].*)?$/, "$1original$2");
			}
			if (domain_nosub === "foap.com" && domain.match(/^images[0-9]*\./)) {
				return src.replace(/:\/\/images[0-9]*(\.foap\.com\/images\/+[-0-9a-f]+\/+)[^/.]*(\.[^/.?#]*)(?:[?#].*)?$/, "://cdn2$1original$2");
			}
			if (domain_nowww === "themepack.me") return src.replace(/\/i\/+c\/+[0-9]+x[0-9]+\/+media\/+/, "/media/");
			if (domain === "static.mycuteasian.com") return src.replace(/\/cache\/+(content\/+pictures\/+.*)\.[0-9]+x[0-9]+(\.[^/.]*)(?:[?#].*)?$/, "/$1$2");
			if (domain_nowww === "jiji.com") return src.replace(/(\/v[0-9]*_photos\/.*)_[sm](\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain === "storage.mantan-web.jp" ||
				domain === "storage.mainichikirei.jp") {
				regex = /(\/[^/]*)_(?:size[0-9]*|thumb[0-9]*)(\.[^/.]*)(?:[?#].*)?$/;
				if (regex.test(src)) {
					return fillobj_urls(replace_sizes(src, [
						src.replace(regex, "$1_size10$2"),
						src.replace(regex, "$1_size9$2"),
						src.replace(regex, "$1_size8$2"),
						src.replace(regex, "$1_size7$2"),
						src.replace(regex, "$1_size6$2")
					]), {
						headers: {
							Accept: '*/*'
						}
					});
				}
			}
			if (domain_nowww === "cinra.net") return src.replace(/(\/uploads\/+img\/+.*)_[a-z]+(\.[^/.]*)(?:[?#].*)?$/, "$1_full$2");
			if ((domain_nosub === "uecdn.es" && /^e00-[a-z]+\./.test(domain)) ||
				domain === "estaticos.telva.com") {
				return src.replace(/_(?:inc|movil|m|[0-9]+x[0-9]+)(\.[^/.]*)(?:[?#].*)?$/, "$1");
			}
			if (domain === "fs.kinomania.ru") return src.replace(/\/image(\/+file\/.*\/[0-9a-f]+)\.[0-9]+\.[0-9]+(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain_nowww === "notigape.com") return src.replace(/\/thumburl\/+thumbnail\/+[0-9]+x[0-9]+\/+outbound\/+uploads\/+/, "/uploads/");
			if (domain_nowww === "prdelinky.cz") return src.replace(/\/uploaded\/+gallery\/+thumb_/, "/uploaded/gallery/");
			if (domain_nosub === "selfimg.com.cn" &&
				domain.match(/^img[0-9]*\./)) {
				return src
					.replace(/(:\/\/[^/]*\/)gq[0-9]+[^/]*\/+/i, "$1uedgqcms/")
					.replace(/(:\/\/[^/]*\/)vogue[^/]*\//i, "$1uedvoguecms/");
			}
			if (domain === "hp.funrahi.com") return src.replace(/(:\/\/[^/]*\/[0-9]{4}\/+[0-9]{2}\/+[^/]*\/+[^/]*)_(?:t|[0-9]+)(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain === "img.007shoes.com") return src.replace(/^[a-z]+:\/\/[^/]*\/\?img_url=(https?:)/, "$1");
			if (domain_nowww === "cineol.net") return src.replace(/\/fotos\/+thumb[0-9]+_/, "/fotos/");
			if (domain_nowww === "nosolocine.es") return src.replace(/\/images\/+galeria\/+thumbs\/+/, "/images/galeria/");
			if (domain === "pics.filmaffinity.com") {
				return src
					.replace(/-nm_[0-9]+(\.[^/.]*)(?:[?#].*)?$/, "-nm_large$1")
					.replace(/-(?:s[0-9]*|m(?:small|med|tiny)|small|main)(\.[^/.]*)(?:[?#].*)?$/, "-large$1");
			}
			if (domain === "fitsnews.files.wordpress.com") {
				newsrc = src.replace(/\.thumbnail(\.[^/.]*)(?:[?#].*)?$/, "$1");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "data.okinny.heypo.net") {
				return {
					url: src.replace(/\/image\/+thumb\/+([0-9a-f]+\.[^/.]*)(?:[?#].*)?$/, "/image/large/$1"),
					headers: {
						Referer: "https://okinny.heypo.net/image/12345"
					}
				};
			}
			if (domain_nosub === "mgstage.com" &&
				domain.match(/^(?:spimg[0-9]*|image)\./)) {
				return src.replace(/(\/[^/_]*_)[^/_]*(_[^/]*)(?:[?#].*)?$/, "$1e$2");
			}
			if (domain_nosub === "gettextbooks.com" &&
				domain.match(/^img[0-9]*\./)) {
				return src.replace(/(\/pi\/+[0-9]+\/+)[-0-9]+\/+[-0-9]+(?:\/+)?(?:[?#].*)?$/, "$1999999999/999999999");
			}
			if ((domain_nosub === "y3600.cn" ||
				domain_nosub === "y3600.cz") && /^img[0-9]*\./.test(domain)) {
				newsrc = src.replace(/\/z(?:resize|crop)?\/+[0-9]+\/+[0-9]+\//, "/zresize/999999999999/999999999999/");
				if (newsrc !== src)
					return newsrc;
				return src.replace(/:\/\/img[0-9]*\.([^/]+\/)z(?:resize|crop)\/+[0-9]+\/+[0-9]+\/+d\/+/, "://img.$1d/");
			}
			if (domain_nowww === "life.tw" ||
				domain === "amazon.life.com.tw") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/proxy\.php\?url=([^&]*).*?$/, "$1");
				if (newsrc !== src) {
					return decodeURIComponent(newsrc);
				}
			}
			if (domain === "public.onlyfans.com") {
				newsrc = src.replace(/\/files\/+thumbs\/+[wc][0-9]+\/+/, "/files/");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "thumbs.onlyfans.com") {
				newsrc = src.replace(/:\/\/[^/]+\/+public\/+files\/+thumbs\/+[wc][0-9]+\/+/, "://public.onlyfans.com/files/");
				if (newsrc !== src)
					return newsrc;
			}
			if (host_domain_nosub === "onlyfans.com" &&
				(domain_nosub === "onlyfans.com" ||
					domain === "media.onlyfans.com" ||
					amazon_container === "of2media") && options && options.element && options.do_request && options.cb) {
				var get_appkey = function(cb) {
					return cb(base64_decode("Lj0zM2Q1N2FkZThjMDJkYmM1YTMzM2RiOTlmZjlhZTI2YQ==").substr(2));
				};
				var onlyfans_api_call = function(url, querystring, referer, cb) {
					get_appkey(function(appkey) {
						if (!appkey)
							return cb(null);
						url = urljoin("https://onlyfans.com/api2/v2", url, false);
						if (querystring) {
							url += "?" + querystring + "&app-token=" + appkey;
						} else {
							url += "?app-token=" + appkey;
						}
						options.do_request({
							url: url,
							method: "GET",
							headers: {
								Referer: referer,
								"Sec-Fetch-Site": "same-origin",
								"Accept": "application/json, text/plain, */*"
							},
							onload: function(result) {
								if (result.readyState !== 4)
									return;
								if (result.status !== 200) {
									console_error(result);
									return cb(null);
								}
								try {
									var json = JSON_parse(result.responseText);
									cb(json);
								} catch (e) {
									console_error(e, result);
									cb(null);
								}
							}
						});
					});
				};
				var get_user = function(username, cb) {
					api_cache.fetch("onlyfans_user:" + username, cb, function(done) {
						onlyfans_api_call("/users/" + username, null, "https://onlyfans.com/" + username, function(data) {
							if (data) {
								return done(data, 1 * 60 * 60);
							} else {
								return done(null, false);
							}
						});
					});
				};
				var get_avatar = function(username, cb) {
					get_user(username, function(data) {
						if (data) {
							return cb(data.avatar);
						} else {
							return cb(null);
						}
					});
				};
				var get_avatar_from_a = function(el, cb) {
					var match = el.href.match(/^https?:\/\/[^/]+\/+([^/]+)\/*(?:[?#].*)?$/);
					if (match) {
						get_avatar(match[1], cb);
						return true;
					}
					return false;
				};
				if (options.element.parentElement &&
					(options.element.parentElement.classList.contains("b-avatar") ||
						options.element.parentElement.classList.contains("g-avatar"))) {
					var dparent = options.element.parentElement.parentElement;
					if (dparent.tagName === "A") {
						if (get_avatar_from_a(dparent, options.cb)) {
							return {
								waiting: true
							};
						}
					} else if (dparent.tagName === "DIV" && dparent.classList.contains("b-profile__user")) {
						var link = dparent.querySelector("a.g-user-realname__wrapper");
						if (link && get_avatar_from_a(link, options.cb)) {
							return {
								waiting: true
							};
						}
					}
				}
			}
			if (domain === "img.mfcimg.com") return src.replace(/(\/photos2\/+[0-9]+\/+[0-9]+\/+[-0-9]+)\.[0-9x]+(\.[^/.]*)$/, "$1$2");
			if (domain_nowww === "webnewtype.com") {
				return {
					url: src
						.replace(/(\/media\/+[0-9]+\/+[0-9]+\/+)(?:_?(?:mode|[wh])[0-9]*)+-/, "$1")
						.replace(/(\/rsz\/+S[0-9]*\/+[0-9]+\/+[^/.]*\.[^/.?#]*)(?:\/[wh][0-9]+.*)?(?:[?#].*)?$/, "$1"),
					can_head: false // returns 404
				};
			}
			if (domain === "cdn.themis-media.com") return src.replace(/\/media\/+global\/+images\/+galleries\/+[a-z]+\/+/, "/media/global/images/galleries/full/");
			if (domain === "tn.nozomi.la") {
				newsrc = src.replace(/:\/\/tn\.([^/]*\/[0-9a-f]+\/+[0-9a-f]+\/+[0-9a-f]+)(\.[^/.]*)(?:\.[^/.]*)(?:[?#].*)?$/, "://i.$1$2");
				if (newsrc !== src) {
					return {
						url: newsrc,
						headers: {
							Referer: "https://nozomi.la/"
						}
					};
				}
			}
			if (domain === "pic.baike.soso.com") return src.replace(/(\/baikepic[0-9]*\/+[^/]*\/+[^/]*\/+)[0-9]+(?:[?#].*)?$/, "$10");
			if (domain_nosub === "jpopasia.com" && domain.match(/^i[0-9]*\./)) {
				return add_extensions(src.replace(/(\/(?:assets|news|albums)\/+[0-9]+\/+[^/]*)-t(\.[^/.]*)(?:[?#].*)?$/, "$1$2"));
			}
			if (domain_nowww === "jpgravure.com" ||
				domain_nowww === "tiedvirgins.com" ||
				domain_nowww === "hqjpporn.com" ||
				domain_nowww === "thethaigirls.com") {
				return src.replace(/(\/galleries\/.*\/)tn([0-9]+\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			}
			if (domain_nowww === "highasianporn.com") return src.replace(/(\/g\/.*\/)tn([0-9]+\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain_nowww === "asianxxxpics.com" ||
				domain_nowww === "japanfetishpics.com" ||
				domain_nowww === "asianfuckpics.com" ||
				domain_nowww === "asianteenpics.com" ||
				domain_nowww === "nudejapangirls.com" ||
				domain_nowww === "japaneseidols.org" ||
				domain === "promo.spunkyangels.com") {
				return src.replace(/\/tn([0-9]+\.[^/.]*)(?:[?#].*)?$/, "/$1");
			}
			if (domain_nowww === "vintage-flash.com") {
				return {
					url: src.replace(/(\/vfg\/+[^/]*\/+)tn([0-9]+\.[^/.]*)(?:[?#].*)?$/, "$10$2"),
					headers: {
						Referer: ""
					}
				};
			}
			if (domain_nowww === "1pondo.tv") {
				return src
					.replace(/(\/assets\/+sample\/+[0-9]+_[0-9]+\/+[^/]*)_s(\.[^/.]*)(?:[?#].*)?$/, "$1$2")
					.replace(/(\/assets\/+sample\/+[0-9]+_[0-9]+\/+)thum_[0-9]+(\/+[0-9]+\.[^/.]*)(?:[?#].*)?$/, "$1popu$2");
			}
			if (host_domain_nosub === "javhd.com" && options.element) {
				if (options.element.tagName === "I" && options.element.classList.contains("border")) {
					return {
						url: origsrc,
						bad: "mask"
					};
				}
			}
			if (domain_nosub === "javhd.com" ||
				domain_nosub === "pussyav.com" ||
				domain_nosub === "ferame.com" ||
				domain_nosub === "shiofuky.com" ||
				domain_nosub === "av69.tv" ||
				domain_nosub === "lingerieav.com") {
				if (/\/images\/+th2-border\.gif/.test(src)) {
					return {
						url: src,
						bad: "mask"
					};
				}
				return src.replace(/(\/[0-9]+\/+[0-9]+)t(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			}
			if (domain === "galleries.allgravure.com") return src.replace(/(\/[0-9]+\/+[^/]*\/+[0-9]+)t(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain_nowww === "bravoerotica.com") return src.replace(/(\/[0-9]+)t(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain_nowww === "japanesepussyclub.com" ||
				domain_nowww === "kabukicho-girls.com") {
				return {
					url: src.replace(/(\/+[^/]*\/+)thumbnails\/+([^/]*)_tn(\.[^/.]*)(?:[?#].*)?$/, "$1images/$2$3"),
					headers: {
						Referer: "http://" + domain
					}
				};
			}
			if (domain_nowww === "asianthumbs.org") return src.replace(/(\/gallery\/+.*\/+)tn\/+([^/]*\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain === "pics.r18.com" ||
				domain === "pics.dmm.co.jp" ||
				domain === "pics.avdmm.top") {
				newsrc = src.replace(/(\/digital\/+video\/+[0-9a-z_]+[0-9]+\/+[0-9a-z_]+[0-9]+)(-[0-9]+\.[^/.]+)(?:[?#].*)?$/, "$1jp$2");
				if (newsrc !== src)
					return newsrc;
				newsrc = src.replace(/(\/digital\/+video\/+[0-9a-z_]+[0-9]+\/+[0-9a-z_]+[0-9]+p)[ts](\.[^/.]+)(?:[?#].*)?$/, "$1l$2");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "pics.dmm.com" ||
				domain === "pics.dmm.co.jp") {
				return src.replace(/s(\.[^/.]*)$/, "l$1");
			}
			if (domain === "images.anilos.com" ||
				domain === "images.nubiles.net") {
				return src.replace(/\/tn\/+([^/]*)(?:[?#].*)?$/, "/$1");
			}
			if (domain_nosub === "cre.ma" && domain.match(/^assets[0-9]*\./)) {
				return src.replace(/(\/image[0-9]*\/+)thumbnail_([0-9a-f]+\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			}
			if (domain === "cdn.megacountry.livenation.com") return src.replace(/(\/production\/+[^/]*-photo\/+[0-9]+\/+)[a-z]+_([0-9a-f]+\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain_nowww === "annangelxxx.com") return src.replace(/(\/tgp\/+[^/]*\/+[0-9]+\/+)thumbnails\/+tn([0-9]+\.[^/.]*)(?:[?#].*)?$/, "$1originalimages/$2");
			if (domain_nosub === "coedcherry.com" && /^content[0-9]*\./.test(domain)) {
				return src
					.replace(/\/th[0-9]+x[0-9]+_(w_[0-9A-F]{10,}\.[^/.]+)(?:[?#].*)?$/, "/$1")
					.replace(/\/th[0-9]+x[0-9]+_(?:a_)?([^/]*?)(?:[?#].*)?$/, "/$1");
			}
			if (domain_nowww === "nicsgalleries.com") return src.replace(/(\/g\/.*\/[0-9a-f]+\/+)thumbs\/+thumb_([^/]*)(?:[?#].*)?$/, "$1$2");
			if (domain_nowww === "classypussy.com" ||
				domain_nowww === "onlyhcore.com" ||
				domain_nosub === "skankypussy.com") {
				return src.replace(/\/thumbs\/+thumbs_/, "/");
			}
			if (domain_nowww === "airlinerphotos.com") {
				newsrc = src.replace(/(:\/\/[^/]+\/+gallery\/+[^/]+\/+)thumbs\/+thumbs_/, "$1");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nowww === "hiqqu.xxx" ||
				domain_nowww === "hiqqu.com") {
				return src.replace(/\/files\/+[0-9]+x[0-9]+\/+/, "/files/");
			}
			if (domain === "img.chan4chan.com") {
				return {
					url: src.replace(/(\/img\/+[0-9]{4}-[0-9]{2}-[0-9]{2}\/+)tn_([^/]*)(?:[?#].*)?$/, "$1$2"),
					can_head: false // 404
				};
			}
			if (domain_nowww === "pissblog.com") return src.replace(/(\/img\/+[^/]+\/+)tn([0-9]+\.[^/.]+)(?:[?#].*)?$/, "$1$2");
			if (domain_nowww === "haxprofiles.com") return src.replace(/(\/gallery\/+[^/]+\/+)tn([^/]*)_[0-9]+x[0-9]+(\.[^/.]*)(?:[?#].*)?$/, "$1$2$3");
			if (domain_nowww === "drago99.com") return src.replace(/\/tn([^/]*\.[^/.]*)(?:[?#].*)?$/, "/$1");
			if (domain === "img.indexxx.com") {
				return {
					url: src.replace(/\/images\/+thumbs\/+[0-9]+x[0-9]+\/+/, "/images/"),
					headers: {
						Referer: "https://www.indexxx.com/"
					}
				};
			}
			if (domain_nosub === "ero.today" ||
				domain_nosub === "oldax.com") {
				newsrc = src.replace(/\/p\/+[0-9]+x[0-9]+_([0-9]+\.[^/.]*)(?:[?#].*)?$/, "/m$1");
				if (newsrc !== src) {
					return {
						url: newsrc,
						headers: {
							Referer: "http://www." + domain_nosub + "/"
						}
					};
				}
			}
			if (domain_nosub === "dreamercdn.com") return src.replace(/(\/media\/+[0-9]+\/+[0-9]+\/+)[0-9]+x[0-9]+(\.[^/.]*)(?:[?#].*)?$/, "$1original$2");
			if (amazon_container === "images.charitybuzz.com" ||
				domain === "images.charitybuzz.com") {
				return src.replace(/(\/images\/+[0-9]+\/+)[a-z]+(\.[^/.]*)(?:[?#].*)?$/, "$1original$2");
			}
			if (domain === "media.movieassets.com") return src.replace(/(\/static\/+images\/+.*\/)[0-9]+\/+[0-9]+\/+(?:[^/]*-)?([0-9a-f]{20,}\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (digitalocean_container === "movieassetsdigital") {
				return src.replace(/\/thumb\/+([0-9a-f]{20,})(?:[?#].*)?$/, "/original/$1");
			}
			if (domain_nosub === "happyhair.sk") return src.replace(/\/celebrity_img\/+thumbs[^/]*\/+/, "/celebrity_img/");
			if (domain_nosub === "wn.com" &&
				domain.match(/^e?cdn[0-9]*\./)) {
				return src.replace(/(\/[0-9a-f]{20,}[-_])(?:small|medium|grande)(\.[^/.]*)(?:[?#].*)?$/, "$1large$2");
			}
			if (domain_nowww === "atoananet.com.br") return src.replace(/(\/links\/+[0-9]{4}\/+[0-9]{2}\/+[0-9]{2}\/+[^/]*)_[0-9]+(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain === "img.ifcdn.com") {
				regex = /(\/images\/+[0-9a-f]+_)[0-9]+(\.[^/.]*)(?:[?#].*)?$/;
				return [
					src.replace(regex, "$13$2"),
					{
						url: src.replace(regex, "$11$2"),
						problems: {
							watermark: true
						}
					}
				];
			}
			if (domain_nowww === "babeprofiles.com") return src.replace(/(\/media\/+models\/.*\/)[0-9]+x[0-9]+\/+([^/]*)(?:[?#].*)?$/, "$1$2");
			if (domain_nosub === "meetmecdna.com") return src.replace(/\/thumb_userimages(\/+.*\/)thm_/, "/userimages$1");
			if (domain === "images.spicyadulttools.com") return src.replace(/\/images\/+thumb\/+([0-9]+\.[^/.]*)(?:[?#].*)?$/, "/images/full/$1");
			if (domain_nosub === "trafficdeposit.com" &&
				domain.match(/^[sb][0-9]*\./)) {
				var baseobj_7 = {
					url: src,
					extra: {}
				};
				urls = [];
				match = src.match(/^[a-z]+:\/\/[^/]+\/+blog\/+(?:[0-9]+\/+[0-9]+\/+)?(?:vid|img)\/+(?:[0-9a-f]+|porn-collection)\/+([0-9a-f]{10,})\/+[^/]+$/);
				if (match) {
					id = match[1];
					baseobj_7.extra.page = "https://sxyprn.com/post/" + id + ".html";
					urls.push({
						url: baseobj_7.extra.page,
						is_pagelink: true
					});
				}
				newsrc = src.replace(/(\/vid\/+[0-9a-f]+\/+[0-9a-f]+\/+)[a-z]+(\.[^/.]*)(?:[?#].*)?$/, "$1full$2");
				if (newsrc !== src) {
					urls.push(newsrc);
				}
				urls.push(src);
				return fillobj_urls(urls, baseobj_7);
			}
			if (domain_nosub === "sxyprn.com") {
				match = src.match(/^[a-z]+:\/\/[^/]+\/+post\/+([0-9a-f]{10,})\.html/);
				if (match) {
					id = match[1];
					var get_url_from_sxyprn_vid = function(vid) {
						return "https://sxyprn.com/post/" + vid + ".html";
					};
					var query_sxyprn = function(vid, cb) {
						api_query("sxyprn:" + vid, {
							url: get_url_from_sxyprn_vid(vid)
						}, cb, function(done, resp, cache_key) {
							var match = resp.responseText.match(/data-vnfo='({"[0-9a-f]{10,}":"[^"}]+"})'>/);
							if (!match) {
								console_error(cache_key, "Unable to find match for", resp);
								return done(null, false);
							}
							var json_text = decode_entities(match[1]);
							var json = JSON_parse(json_text);
							if (!(vid in json)) {
								console_warn(cache_key, "Unable to find", vid, "in", json);
								vid = Object.keys(json)[0];
							}
							var get_added_num = function(str) {
								str = str.replace(/[^0-9]/g, "");
								var n = 0;
								for (var i = 0; i < str.length; i++) {
									n += parseInt(str[i]);
								}
								return n;
							};
							var splitted = json[vid].split("/");
							splitted[1] += "8"; // cdn8
							splitted[5] -= parseInt(get_added_num(splitted[6])) + parseInt(get_added_num(splitted[7]));
							var url = urljoin(resp.finalUrl, splitted.join("/"), true);
							return done({
								url: url,
								video: true,
								extra: {
									page: get_url_from_sxyprn_vid(vid)
								},
								headers: {
									Referer: resp.finalUrl
								}
							}, 60 * 60);
						});
					};
					page_nullobj = {
						url: src,
						is_pagelink: true
					};
					if (options.do_request && options.cb) {
						query_sxyprn(id, function(data) {
							if (!data)
								return options.cb(page_nullobj);
							return options.cb(data);
						});
						return {
							waiting: true
						};
					} else {
						return page_nullobj;
					}
				}
			}
			if (host_domain_nosub === "sxyprn.com" && options.element) {
				if (options.element.tagName === "SPAN" && options.element.classList.contains("player_icon")) {
					return {
						url: origsrc,
						bad: "mask"
					};
				}
			}
			if (domain_nowww === "fullporner.com") {
				newsrc = website_query({
					website_regex: /^[a-z]+:\/\/[^/]+\/+watch\/+([0-9a-f]{10,})(?:[?#].*)?$/,
					query_for_id: "https://fullporner.com/watch/${id}",
					process: function(done, resp, cache_key) {
						var match = resp.responseText.match(/<iframe[^>]*src="(\/\/[^/]+\/+videox\/+[0-9a-f]+)"/);
						if (!match) {
							console_error(cache_key, "Unable to find match for", resp);
							return done(null, false);
						}
						return done({ url: "https:" + match[1], is_pagelink: true }, 6 * 60 * 60);
					}
				});
				if (newsrc)
					return newsrc;
			}
			if (domain_nowww === "xiaoshenke.net") {
				match = src.match(/\/videox\/+([0-9a-f]{10,})(?:[?#].*)?$/);
				if (match) {
					return {
						url: "https://sxyprn.com/post/" + match[1] + ".html",
						is_pagelink: true
					};
				}
			}
			if (domain_nowww === "babepedia.com") {
				return src
					.replace(/\/galleries-thumbs\/+/, "/galleries/")
					.replace(/(\/pics\/+[^/]+)_thumb[0-9]*\./, "$1.");
			}
			if (domain_nowww === "yourdailygirls.com" ||
				domain_nowww === "girlsfordays.com" ||
				domain_nowww === "girlznation.com") {
				return src.replace(/(\/galleries\/.*\/[^/]*)-tn(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			}
			if (domain === "static.ftvgirls.com" ||
				domain === "static.ftvmilfs.com" ||
				domain === "promo.ftvgirls.com") {
				return src
					.replace(/(\/galleries\/.*\/[0-9]+)-thumb(\.[^/.]*)(?:[?#].*)?$/, "$1$2")
					.replace(/\/thumbnails\/+[0-9]+x[0-9]+_/, "/pictures/content_");
			}
			if (domain_nosub === "femjoy.com" && /^n[0-9]*\./.test(domain)) {
				return src.replace(/(\/free\/+[^/]+\/+)thumbs\/+([0-9]+\.[^/.]+)(?:[?#].*)?$/, "$1pics/$2");
			}
			if (domain_nowww === "candidsplash.com") return src.replace(/(\/candid-galleries-[0-9]+\/+[^/]+\/+)thumbs\/+([0-9]+\.[^/.]+)(?:[?#].*)?$/, "$1pics/$2");
			if (domain === "image.istyle24.com") return src.replace(/(\/upload\/+ProductImage\/+[0-9]+\/+[0-9]+\/+[0-9]+_(?:[0-9]+_)?)[a-zA-Z]+(\.[^/.]*)(?:[?#].*)?$/, "$1L$2");
			if (domain === "zine.istyle24.com") {
				if (/\/App_Themes\/.*\/images\/+common\//.test(src))
					return {
						url: src,
						bad: "mask"
					};
				return src.replace(/(\/FileUpload\/+Content\/+[0-9]{10,})_[0-9]+(\.[^/.]+)(?:[?#].*)?$/, "$1$2");
			}
			if (domain_nowww === "bbstar.kr") return src.replace(/(\/model\/+[^/]*[0-9]+)s(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain_nosub === "asn.im" && domain.match(/^i[0-9]*\./)) {
				return src.replace(/(:\/\/[^/]*\/[^/]*)-[a-z](\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			}
			if (domain_nowww === "bebzol.com") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]*\/thumbs.*?[?&]i=([^&]*).*?$/, "$1");
				if (newsrc !== src) {
					return urljoin(src, "/" + decodeURIComponent(newsrc), true);
				}
			}
			if (domain_nowww === "thecandidforum.com") return src.replace(/(\/attachments\/+[0-9a-f]+)t(-[^/]*)(?:[?#].*)?$/, "$1$2");
			if (domain_nowww === "hottystop.com" ||
				domain === "d3m3u5a3.ssl.hwcdn.net" ||
				domain_nowww === "nextdoortease.com" ||
				domain_nowww === "foxhq.com" ||
				domain_nosub === "bunnylust.com" ||
				domain === "f2h3f6e6.ssl.hwcdn.net" ||
				domain === "a2w8r2x2.ssl.hwcdn.net") {
				newsrc = src.replace(/\/smallimage([0-9]+\.[^/.]*)(?:[?#].*)?$/, "/$1");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "img.highviral.news") return src.replace(/(:\/\/[^/]*\/)[0-9]+x[0-9]+\/+([0-9]+_[0-9a-f]+\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain === "mondrian.mashable.com") {
				newsrc = src.replace(/(:\/\/[^/]*\/[^/?]*%252F[^/?]*)\?.*$/, "$1");
				if (newsrc !== src)
					return decodeURIComponent(decodeURIComponent(newsrc));
				newsrc = src.replace(/:\/\/[^/]*\/(wp-content\/+.*?\/[^/]*\.[^/.]*)\/[^/]*\.[^/.]*(?:[?#].*)?$/, "://admin.mashable.com/$1");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain === "helios-i.mashable.com") return src.replace(/(\/imagery\/+[^/]+\/+[^/]+\/+[^/.]+\.)(?:(?:fill|(?:size_|v)[^/.?#]+)\.)*/, "$1");
			if (domain === "image.wisetrail.com" ||
				amazon_container === "image.wisetrail.com") {
				return src.replace(/(\/bookmark[0-9]+\/+[^/]*)_small(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			}
			if (domain_nowww === "internationallovescout.com") {
				return src
					.replace(/(\/entries\/+[0-9]+\/+)thumb_/, "$1")
					.replace(/(\/images\/+uploads\/.*)-[0-9]+x[0-9]+(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			}
			if (domain.match(/^images\.locanto\./)) {
				return src.replace(/(:\/\/[^/]*\/[^/]*\/+)[a-z]+_([0-9]+\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			}
			if (domain_nowww === "dailytravelphotos.com") return src.replace(/(\/images\/+[0-9]+)t(\/[^/]*)_th(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain === "galleries.grooby.com") return src.replace(/\/tn-([0-9]+\.[^/.]*)(?:[?#].*)?$/, "/$1");
			if ((domain_nosub === "adult-empire.com" ||
				domain_nosub === "gigapron.com" ||
				domain_nosub === "bulkjerk.com" ||
				domain_nosub === "cozyxxx.com") &&
				domain.match(/^pbs(?:-[0-9]+)?\./)) {
				newsrc = src
					.replace(/\/tns\/+tn([0-9]+\.[^/.]*)(?:[?#].*)?$/, "/$1")
					.replace(/\/thumb\/+([0-9]+\.[^/.]*)(?:[?#].*)?$/, "/pics/$1")
					.replace(/\/pic\/+t(?:n[0-9]*\/+)?([0-9]+\.[^/.]*)(?:[?#].*)?$/, "/pic/$1")
					.replace(/\/(?:thumbnails|tm)\/+([0-9]+\.[^/.]*)(?:[?#].*)?$/, "/$1")
					.replace(/\/thumbs\/+([0-9]+\.[^/.]*)(?:[?#].*)?$/, "/pics/$1")
					.replace(/\/t\/+([0-9]+\.[^/.]*)(?:[?#].*)?$/, "/p/$1")
					.replace(/\/tumb\/+tumb([0-9]+\.[^/.]*)(?:[?#].*)?$/, "/pics/$1")
					.replace(/\/pics\/+thumbs\/+p([0-9]+\.[^/.]*)(?:[?#].*)?$/, "/pics/p$1")
					.replace(/(\/[0-9]+)xxx(\.[^/.]*)(?:[?#].*)?$/, "$1$2")
					.replace(/\/th\/+thumbnails\/+tn([0-9]+\.[^/.]*)(?:[?#].*)?$/, "/$1")
					.replace(/(\/[0-9]+)_resize(\.[^/.]*)(?:[?#].*)?$/, "$1$2")
					.replace(/\/tn(chicksandbeasts\.com-[0-9]+\.[^/.]*)(?:[?#].*)?$/, "/www.$1")
					.replace(/\/th([0-9]+\.[^/.]*)(?:[?#].*)?$/, "/$1")
					.replace(/(\/[0-9]+)a(\.[^/.]*)(?:[?#].*)?$/, "$1$2")
					.replace(/\/thumbs\/+thumb([0-9]+\.[^/.]*)(?:[?#].*)?$/, "/pics/pic$1")
					.replace(/(\/[0-9]+\/+[0-9]+\/+p[0-9]+\/+)tn_([^/]*)(?:[?#].*)?$/, "$1$2")
					.replace(/(\/[0-9]+\/+[0-9]+\/+)thumbnails\/+tn([0-9]+\.[^/.]*)(?:[?#].*)?$/, "$1images/$2")
					.replace(/(\/[0-9]+\/+[0-9]+\/+cg_[0-9]+_[0-9]+\/+)thumbs\/+tn_([0-9]+\.[^/.]*)(?:[?#].*)?$/, "$1$2")
					.replace(/(:\/\/[^/]*\/[^/]*\/+[^/]*\/+[^/]*\/+)tn([0-9]+\.[^/.]*)(?:[?#].*)?$/, "$1$2")
					.replace(/(:\/\/[^/]*\/+[0-9]{3}\/+[0-9]+\/+[0-9]+\/+)t([0-9]+\.[^/.]*)(?:[?#].*)?$/, "$1i$2");
				if (newsrc !== src)
					return newsrc;
				regex = /\/thumbnails\/+tn([0-9]+\.[^/.]*)(?:[?#].*)?$/;
				if (src.match(regex)) {
					return [
						src.replace(regex, "/images/$1"),
						src.replace(regex, "/$1")
					];
				}
			}
			if (domain_nowww === "exl.io") return src.replace(/(\/[0-9a-f]{20,}\/+)tmd([0-9a-f]+\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain_nowww === "idols69.net") return src.replace(/(\/pictures\/+[^/]*\/+)t([0-9]+\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain === "fhg.mycuteasian.com" ||
				domain === "fhg.avidolz.com") {
				return src.replace(/(\/picture\/+[^/._]*_)t([0-9]+\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			}
			if (domain_nowww === "teenfilipina.net") {
				return src
					.replace(/\/thumbs\//, "/")
					.replace(/(-[0-9]+)thumb(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			}
			if (domain_nowww === "rexxx.co") return src.replace(/(:\/\/[^/]*\/[0-9]+\/[0-9]+)(\.[^/.]*)(?:[?#].*)?$/, "$1f$2");
			if (domain_nosub === "mobile9.com") return src.replace(/\/download\/+thumb\/+([0-9]+)\/+[0-9]+\/+([^/]*\.[^/.]*)(?:[?#].*)?$/, "/download/media/$1/$2");
			if (domain === "s.fap5.com" ||
				domain === "s.mycosplayclub.com") {
				return src.replace(/(\/[0-9a-f]{15,}\/+)thumbs\/+([0-9a-f]+\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			}
			if (domain_nowww === "coolspotters.com") return src.replace(/(\/files\/+photos\/+[0-9]+\/+[^/]*)-(?:small|large|medium|micro|popover|gallery)(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain_nowww === "celebsdump.com" ||
				domain_nowww === "nakedcelebs.top") {
				regex = /(\/posts\/+[0-9]{4}\/+[0-9]{2}\/+[0-9]+\/+)(?:thumbs|featured|images)\/+/;
				return [
					src.replace(regex, "$1originals/"),
					src.replace(regex, "$1images/")
				];
			}
			if (domain === "photos.laineygossip.com") return src.replace(/\/thumbs\/+tmb_[0-9]+x[0-9]+_/, "/articles/");
			if (domain_nowww === "laineygossip.com") {
				return urljoin(src, src
					.replace(/^[a-z]+:\/\/[^/]*\/Thumbnail\.axd.*?[?&]p=([^&]*).*?$/, "$1")
					.replace(/[+]/g, "%20"), true);
			}
			if (domain === "images.successstory.com") return src.replace(/(\/img_[a-z]+\/+[^/]*\/+)[0-9]+X[0-9]+\/+/, "$1");
			if (domain_nosub === "flixster.com" &&
				domain.match(/^content[0-9]*\./)) {
				return src
					.replace(/(\/(?:poll|question)\/+(?:[0-9]+\/+){1,3}[0-9]+_)tmb(\.[^/.]*)(?:[?#].*)?$/, "$1std$2")
					.replace(/(\/(?:photo|(?:rt)?movie|rtactor|editorial|site|tv|quiz|critic|personality)\/+(?:[0-9]+\/+){1,3}[0-9]+_)(?:[a-z]+|[0-9]+)(\.[^/.]*)(?:[?#].*)?$/, "$1ori$2");
			}
			if (domain === "resizing.flixster.com") {
				var match = src.match(/^[a-z]+:\/\/resizing\.flixster\.com\/.*\/v1\.([^-_/?#.]+)(?:[?#].*)?$/);
				if (match) {
					try {
						var decoded = base64_decode(match[1]);
						var newmatch = decoded.match(/^(?:.*?;)?([chmprst]);([0-9]+)/);
						if (newmatch) {
							var cat = newmatch[1];
							var id = newmatch[2];
							var folder = "";
							var cats = {
								"m": "movie",
								"p": "photo",
								"h": "rtmovie",
								"r": "rtactor",
								"c": "critic",
								"s": "site",
								"t": "tv"
							};
							folder = cats[cat];
							var base_1 = "https://content9.flixster.com/" + folder + "/" + id.slice(0, 2);
							if (id.length > 4) {
								base_1 += "/" + id.slice(2, 4);
							}
							if (id.length > 6) {
								base_1 += "/" + id.slice(4, 6);
							}
							return base_1 + "/" + id + "_ori.jpg";
						}
					} catch (e) {
						console_error(e);
					}
				}
			}
			if (domain_nosub === "tmsimg.com") {
				newsrc = src.replace(/^[a-z]+:\/\/[^/]+\/+(https?:\/\/)/, "$1");
				if (newsrc !== src)
					return newsrc;
				if (false) {
					var urls = [];
					match = src.match(/^([a-z]+:\/\/[^/]+\/+assets\/+p[0-9]+_[a-z]_[vh])([0-9]+)(_.*)$/);
					if (match) {
						var num_1 = parseInt(match[2]);
						for (var i_7 = num_1 + 1; i_7 <= 12; i_7++) {
							if (i_7 === 9)
								continue;
							urls.push(match[1] + i_7 + match[3]);
						}
						if (urls.length)
							return urls;
					}
				}
			}
			if (host_domain_nowww === "rottentomatoes.com" && options.element && domain === "resizing.flixster.com") {
				var get_thumborid_for_flixster = function(url) {
					if (url.match(/^v1\.[^/?#.]+$/)) {
						return url;
					}
					var match = url.match(/^[a-z]+:\/\/resizing\.flixster\.com\/.*\/(v1\.[^/?#]+)(?:[?#].*)?$/);
					if (!match)
						return null;
					return match[1];
				};
				var get_pictures_json = function() {
					var pictures_json = document.getElementById("pictures-json");
					if (!pictures_json)
						return null;
					try {
						var json = JSON_parse(pictures_json.innerHTML);
						return parse_pictures_json(json);
					} catch (e) {
						console_error(e);
						return null;
					}
				};
				var parse_pictures_json = function(json) {
					var images = [];
					for (var i = 0; i < json.length; i++) {
						var image = {};
						image.full = json[i].srcFull;
						image.id = get_thumborid_for_flixster(image.full);
						image.caption = json[i].caption || null;
						images.push(image);
					}
					return images;
				};
				var get_imagesjson = function() {
					var scripts = document.getElementsByTagName("script");
					for (var i = 0; i < scripts.length; i++) {
						var script_text = scripts[i].innerHTML;
						var match = script_text.match(/root\.RottenTomatoes\.context\.imagesJson\s*=\s*(\[.*?]);/);
						if (!match) {
							continue;
						}
						try {
							var json = JSON_parse(match[1]);
							return parse_imagesjson(json);
						} catch (e) {
							console_error(e);
							return null;
						}
					}
					return null;
				};
				var parse_imagesjson = function(json) {
					var images = [];
					for (var i = 0; i < json.length; i++) {
						var image = {};
						image.id = json[i].thumborId;
						image.full = json[i].urls.fullscreen;
						image.caption = json[i].caption || json[i].alt || null;
						images.push(image);
					}
					return images;
				};
				var get_full_flixster = function(url) {
					var id = get_thumborid_for_flixster(url);
					var cache_key = "flixster:" + id;
					if (api_cache.has(cache_key)) {
						return api_cache.get(cache_key);
					}
					var imagesjson = get_imagesjson();
					if (!imagesjson) {
						imagesjson = get_pictures_json();
					}
					if (!imagesjson) {
						return null;
					}
					for (var i = 0; i < imagesjson.length; i++) {
						api_cache.set("flixster:" + imagesjson[i].id, imagesjson[i], 24 * 60 * 60);
					}
					return api_cache.get(cache_key);
				};
				var full_picture = get_full_flixster(src);
				if (full_picture) {
					return {
						url: full_picture.full,
						extra: {
							caption: full_picture.caption
						}
					};
				}
			}
			if (amazon_container === "focusmicrosites") {
				return src.replace(/(\/assets\/+uploads\/+)_tmp\/+([^/]*)-[0-9]+x[0-9]+(\.[^/.]*)(?:[?#].*)?$/, "$1$2$3");
			}
			if (domain === "i.digiguide.tv") return src.replace(/(\/p\/+[0-9]+\/+)tn-/, "$1");
			if (domain_nowww === "azquotes.com") return src.replace(/(\/public\/+pictures\/+.*\/)c_([0-9a-f]+[^/]*)_thumb(\.[^/.]*)(?:[?#].*)?$/, "$1$2$3");
			if (domain_nowww === "newsarama.com" ||
				domain === "i.newsarama.com") {
				return src.replace(/(\/images\/+i\/+[0-9]+\/+[0-9]+\/+[0-9]+\/+)i[0-9]+\/+/, "$1original/");
			}
			if (domain_nowww === "moly.hu") {
				newsrc = src.replace(/(\/system\/+authors\/+[0-9]+\/+image_)[a-z]+\./, "$1original.");
				if (newsrc !== src)
					return newsrc;
				regex = /(\/system\/+[^/]*\/+)[a-z]+(\/+[a-z]+_[0-9]+\.)/;
				newsrc = src.replace(regex, "$1original$2");
				if (newsrc !== src)
					return [newsrc, src.replace(regex, "$1big$2")];
			}
			if (domain_nowww === "arasale.com") return src.replace(/(\/photo[0-9]*\/.*)_small[0-9]*(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain_nowww === "imgth.com") return src.replace(/\/thumbs\/+/, "/images/");
			if (domain_nowww === "about.me") return src.replace(/^[a-z]+:\/\/[^/]+\/+cdn-cgi\/+image\/+[^/]+\/+(https?:\/\/)/, "$1");
			if (domain_nowww === "intimatecelebs.com") return src.replace(/(\.[^/.]*)\.icthumb\.[^/.]*(?:[?#].*)?$/, "$1");
			if (domain_nowww === "celebriot.com") return src.replace(/(\.[^/.]*)\.thumb_[0-9]+x[0-9]+\.[^/.]*(?:[?#].*)?$/, "$1");
			if (domain_nosub === "paheal.net" && options.do_request && options.cb) {
				newsrc = src.replace(/(:\/\/[^/]*\/+)_thumbs\//, "$1_images/");
				if (string_indexof(src, "/_thumbs/") >= 0 && newsrc !== src) {
					common_functions["get_file_signature"](api_cache, options, newsrc, function(sig) {
						if (!sig) {
							return options.cb(newsrc);
						}
						var newfilename = newsrc.replace(/(\/[0-9a-f]{10,}\/+[^/]*?)(?:[.?#].*)?$/, "$1." + sig);
						if (sig === "mp4" || sig === "webm") {
							return options.cb({
								url: newfilename,
								video: true
							});
						} else {
							return options.cb(newfilename);
						}
					});
					return {
						waiting: true
					};
				}
			}
			if (domain_nowww === "rule34hentai.net") {
				return {
					url: src.replace(/(:\/\/[^/]*\/)_thumbs\//, "$1_images/"),
					head_wrong_contenttype: true,
					can_head: false
				};
			}
			if (domain_nosub === "lovethispic.com") return src.replace(/\/uploaded_images\/+thumbs\/+/, "/uploaded_images/");
			if (domain_nowww === "zwz.cz" &&
				options && options.do_request && options.cb) {
				id = src.replace(/^[a-z]+:\/\/[^/]*\/o[^/]*\.zwz\/+([A-Z0-9]+)\.[^/.]*(?:[?#].*)?$/, "$1");
				if (id !== src) {
					options.do_request({
						url: "http://zwz.cz/f/" + id,
						method: "GET",
						headers: {
							Referer: "http://zwz.cz/",
							Cookie: "agree=yes"
						},
						onload: function(result) {
							if (result.readyState === 4) {
								if (result.status !== 200) {
									console_log(result);
									options.cb(null);
									return;
								}
								var match = result.responseText.match(/<img *id=['"]?pic["']? *class[^>]*?src=["']([^'"]*)['"]/);
								if (match) {
									options.cb({
										url: urljoin(src, match[1], true),
										headers: {
											Referer: "http://zwz.cz/",
											Cookie: "agree=yes"
										}
									});
								} else {
									options.cb(null);
								}
							}
						}
					});
					return {
						waiting: true
					};
				}
			}
			if (domain_nowww === "hockeygods.com") return src.replace(/(\/system\/+gallery_images\/+[0-9]+\/+)[a-z]+(\.[^/.]*)(?:[?#].*)?$/, "$1original$2");
			if (domain === "galleries.cosmid.net") return src.replace(/(:\/\/[^/]*\/[0-9]+)\/+thumbs\/+/, "$1/");
			if (domain_nowww === "porn-star.com" ||
				(domain_nosub === "ptclassic.com" && /^galleries[0-9]*\./.test(domain))) {
				newsrc = src.replace(/\/thumbs\/+([0-9]+\.[^/.]*)(?:[?#].*)?$/, "/$1");
				if (newsrc !== src)
					return newsrc;
			}
			if (domain_nowww === "suburbanamateurs.com") {
				return {
					url: src.replace(/(\/galleries\/+[^/]*\/+)thumbs\/+/, "$1highres/"),
					headers: {
						Referer: "http://www.suburbanamateurs.com/"
					}
				};
			}
			if (domain === "video.soloteengirls.net") return src.replace(/\/materials\/+thumbs\/+([0-9]+\.[^/.]*)(?:[?#].*)?$/, "/materials/$1");
			if (domain_nosub === "fantasti.cc" &&
				domain.match(/^cdn(?:-[a-z]+)?\./)) {
				return src.replace(/\/thumb\/+([^/]*)(?:[?#].*)?$/, "/$1");
			}
			if (domain === "images.larepubliquedespyrenees.fr") return src.replace(/(\/[0-9a-f]{20,}\/+)golden\/+[0-9]+x[0-9]+\/+/, "$1");
			if (domain === "img.aws.la-croix.com") return src.replace(/_[0-9]+_[0-9]+(\.[^/.]*)(?:[?#].*)?$/, "$1");
			if (domain === "i.la-croix.com") return src.replace(/^[a-z]+:\/\/[^/]+\/+.*?(\/[0-9]{4}\/+(?:[0-9]{2}\/+){2}[0-9]{5,}\/+.*)/, "https://img.aws.la-croix.com$1");
			if (domain_nowww === "getty.edu") return src.replace(/\/media\/+images\/+web\/+[^/]*\/+/, "/media/images/web/download/");
			if (domain_nosub === "yelpcdn.com") return src.replace(/(\/b?photo\/+[^/]*\/+)(?:[0-9]+s|[a-z]+)(\.[^/.]*)(?:[?#].*)?$/, "$1o$2");
			if (domain_nosub === "rtbf.be" &&
				domain.match(/^(?:[^/]*\.)?static\./)) {
				return src
					.replace(/\/article\/+image\/+[0-9]+x[0-9]+\/+/, "/article/image/original/")
					.replace(/(\/pictureGallery\/+album\/+[0-9]+\/+)(?:thumb|big)\/+/, "$1");
			}
			if (domain === "d5xydlzdo08s0.cloudfront.net") return src.replace(/(\/media\/+[^/]*\/+[0-9]+\/+(?:[^/]*\/)?[^/]*)(?:__[A-Z]|_[0-9]+)(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain === "photos.geni.com") return src.replace(/_[a-z]+(\.[^/.]*)(?:[?#].*)?$/, "_original$1");
			if (domain === "cdn.hipwallpaper.com") return src.replace(/(:\/\/[^/]*\/)m\/+/, "$1i/");
			if (domain === "photos.bandsintown.com" ||
				amazon_container === "bit-photos") {
				return src.replace(/\/thumb\/+([0-9]+\.[^/.]*)(?:[?#].*)?$/, "/large/$1");
			}
			if (domain === "d1dojdv0rym6r6.cloudfront.net") return src.replace(/\/imgs\/+[a-z]+\/+([0-9]+_pic[0-9a-f]+\.[^/.]*)(?:[?#].*)?$/, "/imgs/large/$1");
			if (domain_nowww === "mynetsit.ir") return src.replace(/(:\/\/[^/]*\/).*?[?&]dt=([^/&]*).*?$/, "$1?di=$2");
			if (domain === "cf.kizlarsoruyor.com" ||
				domain === "cf.girlsaskguys.com") {
				return src.replace(/(\/[a-z][0-9]+\/+[0-9a-f]+-[-0-9a-f]+)-m(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			}
			if (domain === "static.framar.bg") return src.replace(/\/thumbs\/+[0-9]+\/+lifestyle\/+/, "/snimki/lstyle/");
			if (domain === "life.tert.am" ||
				domain_nowww === "tert.am" ||
				domain_nowww === "xochuanime.online") {
				return add_full_extensions(src.replace(/(:\/\/[^/]*\/)(?:[^/]*\/+)?cache_image\/+(.*)[-_][0-9]+x[0-9]+(?:_[0-9]+[a-z]*)?(\.[^/.]*)(?:[?#].*)?$/, "$1$2$3"));
			}
			if (domain_nowww === "woman.at") {
				return src
					.replace(/\/storage\/+[^/]*\/+file\/+/, "/storage/master/file/") // this doesn't seem to do any difference
					.replace(/(\/file\/+[0-9]+\/+)download\/+/, "$1"); // removes force-downloading
			}
			if (domain === "files.elfann.com") return src.replace(/\/imagine\/+pictures_[0-9]+(?:_[0-9]+)?\/+/, "/pictures/");
			if (domain === "cdn.axar.az") return src.replace(/(:\/\/[^/]*\/[0-9]{4}\/+[0-9]{2}\/+[0-9]{2}\/+)[0-9]+\/+([^/]*)(?:[?#].*)?$/, "$1$2");
			if (domain === "media.milovana.com") return src.replace(/(\/timg\/+(?:[0-9]+\/+[0-9]+\/+)?)tb_[a-z]+\/+/, "$1tb_l/");
			if (domain === "uploads.spiritfanfiction.com") return src.replace(/\/fanfics\/+thumbs\/+/, "/fanfics/historias/");
			if (domain === "pic.homepornbay.com") return src.replace(/(\/[0-9]+)s(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain === "cdn.funpic.us") return src.replace(/(-[0-9]+)-[a-z]+(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain_nowww === "themanwiththehat.de") return src.replace(/\/files\/+attachments\/+[0-9]+\/+/, "/files/attachments/");
			if (domain_nosub === "motorsport.com" &&
				domain.match(/^cdn(?:-[0-9]*)?\./)) {
				return src.replace(/(\/images\/+[^/]*\/+[^/]*\/+)s[5897]\/+/, "$1s10/");
			}
			if (domain_nowww === "epicwallpapers.com" ||
				domain_nowww === "freshwallpapers.net" ||
				domain_nowww === "alliswall.com") {
				return src
					.replace(/\/imagecache\/+thumbnails\/+([0-9]+)\/+[0-9]+x[0-9]+\.[^/.]*(?:[?#].*)?$/, "/file/$1/0x0/crop/")
					.replace(/(\/file\/+[0-9]+)\/+[0-9]+x[0-9]+\/+(?:crop|[0-9]+:[0-9]+)\/+/, "$1/0x0/crop/");
			}
			if (domain === "kookbang.dema.mil.kr") return src.replace(/(\/upload\/+[0-9]{8}\/+)thumb[0-9]*\/+/, "$1");
			if (domain === "dyaaf063c1cms.cloudfront.net") return src.replace(/(:\/\/[^/]*\/[0-9a-f]+\/)(?:sq[0-9]+|medium)_/, "$1large_");
			if (domain_nowww === "specialfruit.com" ||
				domain_nowww === "studio100.com" ||
				(domain_nosub === "schellywood.be" && /^images-[0-9]*\./.test(domain))) {
				return src
					.replace(/\/thumbnail\/+product[^/]*\/+/, "/thumbnail/productFull/")
					.replace(/\/thumbnail\/+(?:inline|character|book-image|gallery|poster|badge|hero-slider-[a-z]+|thumbnail|(?:visual|eyecatcher|square|tile)-[^/]+)\/+/, "/thumbnail/full/");
			}
			if (domain === "static.planetminecraft.com") {
				return src
					.replace(/(\/files\/+image\/.*)_[sml](\.[^/.]+)(?:[?#].*)?$/, "$1_xl$2")
					.replace(/(\/files\/.*_[0-9]+)_[a-z]+(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			}
			if (domain === "games.renpy.org") return src.replace(/\/media\/+screenshot\/+small\/+/, "/media/screenshot/");
			if (domain_nowww === "700016.xyz") return src.replace(/(\/files\/.*)_thumb(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain_nowww === "mytinyphone.com") return src.replace(/(\/uploads\/.*\/)sm[0-9]*\/([0-9]+\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain_nowww === "wallcoo.net") return src.replace(/\/s\/+([^/]*_[0-9]+)s(\.[^/.]*)(?:[?#].*)?$/, "/images/$1$2");
			if (domain_nowww === "absfreepic.com") return src.replace(/\/[a-z]+_photos\/+([^/]*)(?:[?#].*)?$/, "/original_photos/$1");
			if (domain_nowww === "gif-favicon.com") return src.replace(/\/images\/+download\.php.*?[?&]image=([^&]*).*?$/, "/images/$1");
			if (domain_nowww === "ametart.com") return src.replace(/\/thumbs\/+([0-9]+\/+[0-9]+\/+)[0-9]+x_([^/]*)(?:[?#].*)?$/, "/photos/$1$2");
			if (domain_nowww === "nicepornphotos.com" ||
				domain_nowww === "suzisporn.com" ||
				domain_nowww === "youngporno.com" ||
				domain_nowww === "hoodtube.com" ||
				domain_nosub === "swapsmut.com" ||
				domain_nosub === "asianpornmovies.com") {
				return src.replace(/(\/galleries\/+[0-9]+\/+[0-9]+\/+[0-9a-f]{10,})-t(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			}
			if (domain_nowww === "hostave2.net") return src.replace(/(\/photo\/+[^/]*\/+[^/]*\/+)th\/+([0-9]+\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain === "i.penisbot.com") return src.replace(/\/tmb_([0-9]+\.[^/.]*)(?:[?#].*)?$/, "/$1");
			if (domain_nowww === "erowall.com") {
				newsrc = src
					.replace(/\/download_img\.php.*?[?&]dimg=([0-9]+).*?$/, "/wallpapers/original/$1.jpg")
					.replace(/\/wallpapers\/+[a-z]+\/+([0-9]+\.[^/.]*)(?:[?#].*)?$/, "/wallpapers/original/$1");
				if (newsrc !== src)
					return newsrc;
				match = src.match(/\/wallpapers\/+[a-z]+\/+([0-9]+)\.[^/.]+(?:[?#].*)?$/);
				if (match)
					return {
						url: src,
						extra: {
							page: "https://erowall.com/w/" + match[1]
						}
					};
			}
			if (domain === "promo.mattsmodels.com" ||
				domain_nowww === "nextdoortease.com" ||
				domain_nowww === "amateurindex.com") {
				return src.replace(/(\/galleries\/+[^/]*\/+[^/]*\/+)thumbs\/+/, "$1");
			}
			if (domain === "ww3.aziani.com" ||
				domain_nowww === "clubglamour.net") {
				return src.replace(/(\/galleries\/+[^/]+\/+)thumbs\/+/, "$1");
			}
			if (domain === "galleries.allover30.com") {
				return src
					.replace(/(\/[^/]+-[0-9]+\/+[^/]+[0-9]+)-thumb(\.[^/.]+)(?:[?#].*)?$/, "$1$2")
					.replace(/\/Z[0-9]+\/+([^/]*)(?:[?#].*)?$/, "/$1");
			}
			if (domain === "images.sxx.com" ||
				domain === "images.blazingmovies.com") {
				return src.replace(/\/thumbs\/+([^/]*)_tb(\.[^/.]*)(?:[?#].*)?$/, "/$1$2");
			}
			if (domain === "ww2.aziani.com") return src.replace(/\/t_([^/]*-[0-9]+\.[^/.]*)(?:[?#].*)?$/, "/$1");
			if (domain === "fhg.karupsow.com" ||
				domain === "fhg.karupsha.com") {
				return src.replace(/\/images\/+thumbs(-[^/]*\/)/, "/images/pics$1");
			}
			if (domain_nowww === "stockingvideos.com") return src.replace(/\/images\/thumbs\/thumb([0-9]+\.[^/.]*)(?:[?#].*)?$/, "/images/full/full$1");
			if (domain === "media.virbcdn.com") return src.replace(/\/cdn_images\/+resize_[0-9]+x[0-9]+\/+/, "/images/");
			if (domain === "images.yuku.com") return src.replace(/(\/image\/+[^/]*\/+[0-9a-f]+(?:\.[0-9]+)?)_[^/.]*(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (host_domain_nosub === "kpopping.com" && domain_nowww === "kpopping.com" && options.element) {
				if (/\/uploads\/+documents\//.test(src)) {
					if (options.element.tagName === "IMG" && options.element.classList.contains("img-fluid")) {
						if (options.element.parentElement.tagName === "A" && options.element.parentElement.href && /\/uploads\/+documents\//.test(options.element.parentElement.href)) {
							return options.element.parentElement.href;
						}
					}
				}
			}
			if (domain_nowww === "kpopping.com") {
				if (/\/bundles\/+app\/+img\//.test(src))
					return {
						url: src,
						bad: "mask"
					};
				/*
				  seems like they changed something, again.
				  every time i update this script, it seems like a few days later, something changes in the way their site works, breaking the fix i did for this site.
				  they're aware of this script (they linked to it at one point), so it could very well be intentional on their part.
				*/
				if (false) {
					return src
						.replace(/\/uploads\/+documents\/+[^/]+\/+(?:[0-9]*x){0,2}([^/]+?)(?:,[0-9]+){0,}(\.[^/]+?)(?:\.(?:keep|crop)\..*)?(?:[?#].*)?$/, "/uploads/documents/$1$2");
				}
				return src
					.replace(/\/uploads\/+documents\/+[^/]+\/+(?:[0-9]*x){0,2}([^/]+?)(\.[^/]+?)(?:\.(?:keep|crop)\..*)?(?:[?#].*)?$/, "/uploads/documents/$1$2");
			}
			if (domain_nosub === "tin247.com" &&
				domain.match(/^image[0-9]*\./)) {
				return src.replace(/\/picsmall\/+([0-9]{4}\/+[0-9]{2}\/+[0-9]{2}\/+)[0-9]+\/+/, "/$1");
			}
			if (domain === "assets.blogr.xxx" ||
				domain === "assets-old.blogr.xxx") {
				return src.replace(/\/posts\/+[^/]*\/+([0-9]{4}\/+[0-9]{2}\/+[0-9]{2}\/+)/, "/posts/large/$1");
			}
			if (domain_nowww === "internationalcelebrityfeet.com") return src.replace(/\/thumbs\/([^/]*)thumb(\.[^/.]*)(?:[?#].*)?$/, "/pics/$1$2");
			if (domain === "content.gulte.com") return src.replace(/(\/content\/+[0-9]{4}\/+[0-9]{2}\/+photos\/+events\/+[^/]*\/+)thumb\/+([^/]*)(?:[?#].*)?$/, "$1normal/$2");
			if (domain_nowww === "moda.ru") return src.replace(/(\/files\/+user\/+(?:[0-9]{2}\/+){3}content\/+[0-9]+\/+)[0-9]+x[0-9]+x[0-9]+_([0-9a-f]+\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain_nosub === "sodonsolution.org" &&
				domain.match(/^resource[0-9]*\./)) {
				return src.replace(/(\/images\/[0-9]{4}\/+[0-9]+\/+[0-9a-f]+\/+[0-9a-z]+)_[a-z](\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			}
			if (domain === "youmediafanpage.akamaized.net") return src.replace(/(\/gallery\/+[0-9a-f]+_[0-9a-f]+_)p[0-9]+x[0-9]+(\.[^/.]*)(?:[?#].*)?$/, "$1o$2");
			if (domain_nosub === "hayatapp.com" &&
				domain.match(/^cdn-media-[0-9]+\./)) {
				return src.replace(/(\/uploads\/+backend_wysiwyg_asset\/+asset\/+)[a-z]+_([0-9a-f]+\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			}
			if (domain === "static.klix.ba") {
				newsrc = src.replace(/(\/media\/+images\/+vijesti\/+)m[0-9]+_([0-9]{8,}\.[^/.]+)(?:[?#].*)?$/, "$1$2");
				if (newsrc != src)
					return newsrc;
				regex = /(\/media\/+images\/+vijesti\/+[0-9]+\.[0-9]+)(\.[^/.]+)(?:[?#].*)?$/;
				if (regex.test(src)) {
					return [
						src.replace(regex, "$1_xl$2"),
						src.replace(regex, "$1_mn$2")
					];
				}
				regex = /(\/media\/+images\/+vijesti\/+[0-9]+\.[0-9]+_)[a-z]+(\.[^/.]+)(?:[?#].*)?$/;
				if (options.do_request && options.cb && regex.test(src)) {
					var images = [];
					array_foreach(["mn", "xxl", "xl"], function(size) {
						images.push(src.replace(regex, "$1" + size + "$2"));
					});
					common_functions["find_actual_largest_image"](src, images, options.cb, {
						check_length: true,
						api_cache: api_cache,
						do_request: options.do_request
					});
					return {
						waiting: true
					};
				}
				return src.replace(/(\/media\/+images\/+[^/]+\/+)(?:s[0-9]+|b)_([0-9]+\.[^/.]+)(?:[?#].*)?$/, "$1$2");
			}
			if (host_domain_nowww === "klix.ba" && options.element) {
				if (!src && options.element.tagName === "DIV" && options.element.classList.contains("galleria-thumbnails-container")) {
					return {
						url: origsrc,
						bad: "mask"
					};
				}
			}
			if (domain === "img.nga.178.com") {
				return {
					url: src.replace(/(\/attachments\/+[^/]*_[0-9]{6}\/+[0-9]+\/+[^/]*)\.(?:thumb|medium)(?:_[a-z])?\.[^/.]*(?:[?#].*)?$/, "$1"),
					headers: {
						Referer: null
					},
					referer_ok: {
						same_domain_nosub: true
					}
				};
			}
			if (domain_nowww === "livesport.ru" ||
				domain === "cdn.livesport.ru") {
				return src.replace(/\/picture--[0-9]+(\.[^/.]*)(?:[?#].*)$/, "/picture$1");
			}
			if (domain_nowww === "vseprosport.ru") return src.replace(/(\/images\/+uploads[0-9]+\/+)thumbs\/+[0-9]+x[0-9]+\/+([0-9]+\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain_nowww === "evrimagaci.org") return src.replace(/\/public\/+content_media\/+[0-9]+\/+/, "/public/content_media/");
			if (domain_nowww === "jagranimages.com") return src.replace(/(\/images\/+[0-9]{2}_[0-9]{2}_[0-9]{4}-[^-/_]+)_[a-z](\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain === "cdn.doctailieu.com") return src.replace(/(\/images\/+[0-9]{4}\/+[0-9]{2}\/+[0-9]{2}\/+[^/]*)-rs[0-9]+(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			if (domain_nosub === "cdn-redfin.com") return src.replace(/(\/photo\/+[0-9]+\/+)[^/]*\/+([0-9]+\/+)[^/.]*\.((?:[0-9A-Z]+-)?[0-9A-Z]+_[0-9A-Z]+(?:_[0-9A-Z]+)?\.[^/.]*)(?:[?#].*)?$/, "$1bigphoto/$2$3");
			if (domain === "images.estately.net") return src.replace(/_[0-9]+x[0-9]+[a-z]?(\.[^/.]*)(?:[?#].*)?$/, "$1");
			if (domain_nowww === "mjolbybillack.se") return src.replace(/\/img\/+media\/+[sl]_/, "/img/media/");
			if (domain_nowww === "mathworks.com") return src.replace(/\/responsive_image\/+(?:[0-9]+\/+){5}cache\/+/, "/");
			if (domain === "images.kz.prom.st") return src.replace(/(:\/\/[^/]*\/[0-9]+)(?:_[wh][0-9]+){1,}(_[^/]*)(?:[?#].*)?$/, "$1$2");
			if (domain === "treesale.sccd.org") {
				newsrc = urljoin(src, src.replace(/^[a-z]+:\/\/[^/]*\/thumbnail\.asp.*?[?&]file=([^&]*).*?$/, "$1"), true);
				if (newsrc !== src)
					return newsrc;
				return src.replace(/(\/assets\/+images\/+[^/]+)_thumbnail(\.[^/.]*)(?:[?#].*)?$/, "$1$2");
			}
			if (domain_nowww === "zive.cz") return src.replace(/\/GetThumbNail\.aspx.*?[?&](id_file=[0-9]+).*?$/, "/GetFile.aspx?$1");
			if (domain === "hasbrouck.asu.edu") {
				regex = /(\/imglib\/+.*)_[a-z]+(\.[^/.]*)(?:[?#].*)?$/;
				return [
					src.replace(regex, "$1_lg$2"),
					src.replace(regex, "$1_web$2")
				];
			}
			if (domain_nowww === "parsstock.ir") {
				return {
					url: src.replace(/(:\/\/[^/]*\/)thumbs\/+([0-9]+\/)/, "$1photos/$2"),
					problems: {
						watermark: true
					}
				};
			}
			if (domain === "img.pixers.pics") {
				return src
					.replace(/:\/\/[^/]*\/pho_wat[(]s3:([^,)]*).*/, "://s3.pixers.pics/pixers/$1")
					.replace(/:\/\/[^/]*\/pho_wat[(]cms:([^,)]*).*/, "://s3.pixers.pics/cms/$1");
			}
			if (domain === "d7hftxdivxxvm.cloudfront.net") {
				return decodeURIComponent(src.replace(/^[a-z]+:\/\/[^/]*\/.*?[?&]src=([^&]*).*?$/, "$1"));
			}
			if (domain === "d32dm0rphc51dk.cloudfront.net") {
				return src
					.replace(/\/larger(\.[^/.]*)(?:[?#].*)?$/, "/normalized$1")
					.replace(/\/(?:small|medium|large)(\.[^/.]*)(?:[?#].*)?$/, "/larger$1");
			}
			if (domain_nowww === "royalparks.org.uk") return src.replace(/(\/_gallery\/+[^/]*\.[^/.]*)\/+[^/]*\.[^/.]*(?:[?#].*)?$/, "$1");
			if (domain === "cdn.downtoearth.org.in") return src.replace(/\/library\/+[a-z]+\/+([0-9]{4}-[0-9]{2}-[0-9]{2}\/)/, "/library/original/$1");
			if (domain_nowww === "arborday.org") return src.replace(/(\/images\/+hero\/+)[a-z]+\/+/, "$1");
			if (domain === "assets.publishing.service.gov.uk") return src.replace(/(\/image_data\/+file\/+[0-9]+\/+)s[0-9]+_([^/]*)(?:[?#].*)?$/, "$1$2");
			if (domain === "media.swncdn.com") return src.replace(/\.[0-9]+[wh]\.