**Welcome to the 1st Edition UNIX repository. Here you will find the kernel
source code and userland binaries which will allow you to run 1e UNIX on
a PDP-11 simulator.**

### Contents
- [Build Instructions](https://github.com/qrush/unix#Build-Instructions)
- [Running 1st Edition UNIX](https://github.com/qrush/unix#Running-1st-Edition-UNIX)
- [Documentation](https://github.com/qrush/unix#Documentation)
- [Repository Layout](https://github.com/qrush/unix#Repository-Layout)


## Build Instructions
Unless otherwise noted, file and directory names refer to this repository.

1. Download the source code for the Simh simulator from here:
   http://simh.trailing-edge.com/. Make sure that you download
   version 3.8-0 or later; earlier versions need patches to work.

2. Unpack Simh somewhere. Make the BIN/ directory in Simh at the top level.
   Do make pdp11 to make the pdp11 simulator in the BIN/ directory. Copy
   the BIN/pdp11 executable into the tools/ directory.

2. Return to the 1st Edition top-level directory. Do a make. This will do
   several things.  It will build tools/mkfs, tools/ml and tools/apout/apout.
   These tools are required to build the filesystems for 1e UNIX, and the
   kernel. It will create kernel sources with some necessary patches, assemble
   the kernel and build a bootable Simh memory image which is installed into
   the images directory.  Finally, the make will build the rf0.dsk, rk0.dsk
   and tape images and install these in the images directory. You can also do
   a "make clean" to clean out the images/ and build/ directories. A "make
   clobber" will clean out the images/, build/  and tools/ directories.

## Running 1st Edition UNIX

1. Run ./simh.cfg which starts the pdp11 simulator. You should see this:

     PDP-11 simulator V3.8-0
     ./simh2.cfg> #!tools/pdp11
     Unknown command
     Disabling CR
     Disabling XQ
     RF: buffering file in memory
     TC0: 16b format, buffering file in memory
     Listening on port 5555 (socket 7)

   You will receive a login: prompt:

2. Type in root followed by <RETURN>. You should receive a # prompt.

3. Type in an ls -l command. You should see something like this:

   total    6
    43 sdrwr-  2 root    620 Jan  1 00:00:00 bin
    42 sdrwr-  2 root    250 Jan  1 00:00:00 dev
   104 sdrwr-  2 root    110 Jan  1 00:00:00 etc
   114 sdrwr-  2 root     50 Jan  1 00:00:00 tmp
    41 sdrwr-  7 root     70 Jan  1 00:00:00 usr

4. To change directories, use chdir, e.g. chdir /usr. The only editor installed
   is `ed'. You can find an ed tutorial in notes/edtut.txt.

5. To log in multiple times, telnet to localhost port 5555.  The system
   is configured to allow 8 remote logins.

6. To shut the system down, enter ctrl-E to stop the simulator, and q to quit.
   You do not need to sync the system before shutdown.

## Documentation

The manuals for 1st Edition UNIX are available here:
https://www.bell-labs.com/usr/dmr/www/1stEdman.html, and
http://www.bitsavers.org/pdf/bellLabs/unix/UNIX_ProgrammersManual_Nov71.pdf

Some documentation of the internals of the 1st Edition UNIX are available here:
http://www.bitsavers.org/pdf/bellLabs/unix/PreliminaryUnixImplementationDocument_Jun72.pdf

Details of the PDP-11/20 architecture and its peripherals can be found at:
http://www.bitsavers.org/pdf/dec/pdp11/handbooks/PDP1120_Handbook_1972.pdf
http://www.bitsavers.org/pdf/dec/pdp11/handbooks/PDP11_PeripheralsHbk_1972.pdf

The C compiler from 2nd Edition UNIX is also installed and works, but the
language is a very early dialect of C. The closest reference to the language
at this point in time is this, but it is probably 2 years too late:
https://www.bell-labs.com/usr/dmr/www/cman74.pdf

The userland binaries come from a period somewhere between the 1st and 2nd
Edition of UNIX. You may find the 2e manuals useful too:
http://www.bitsavers.org/pdf/bellLabs/unix/Unix_2nd_Edition_Manual_Jun72.pdf

## Repository Layout

pages/		- OCR'd pages from the PreliminaryUnixImplementation document
rebuilt/	- kernel source rebuilt from the OCR'd pages, as asm files
patches/	- patches to rebuilt/ files to get kernel to run
fs/		- userland binaries and files, used to make rf0.dsk and rk0.dsk
src/		- source code for userland: there is not much available
tools/		- tools and scripts to build the kernel and filesystem
build/		- build area: patched kernel files, patched filesystems
images/		- final disk and tape images to be used by the Simh simulator
misc/		- misc. files, e.g. the Simh patch for KE11A support
notes/		- notes on the work done to get 1e UNIX to run again
diffs/		- Differences between pages/* and the high quality OCR
                  done by James Markevitch.  Includes headers and footers.
