---
# Page settings
layout: default
right_illustration: illustrations/wittek_prize_right_side.png
custom_css: wittek_prize.css
keywords:
comments: false

# Hero section
title: Wittek Quantum Prize for Open Source Software
description: Wittek Quantum Prize is dedicated to the life and memory of Peter Wittek. Read more about the story behind the prize [in our blog post](https://medium.com/qosf/announcing-the-2020-wittek-quantum-prize-for-open-source-software-f578f03823b1).
buttons:
    - content: Check out the official website
      url: 'https://wittekprize.com'
      external_url: true
      icon: fa-window-maximize

# Micro navigation
micro_nav: false

---

In a partnership between QOSF and the [Unitary Fund](https://unitary.fund), we want to recognize the work of the unsung heroes, developers and maintainers behind the software projects we all use. They are often unaware of the impact their work is having on the quantum software community and thus we are awarding a
{::nomarkdown}<h3 align='center' style="margin-top: -5px"><b>US$4000 prize</b></h3>{:/}
**to a software contributor/maintainer among crowd-sourced nominees on an annual basis**. The winner of the prize is going to be selected by the Unitary's Fund advisory board, which kindly agreed to act as an independent evaluation committee.

## About the prize

The Wittek Quantum Prize is dedicated to [Peter Wittek](https://peterwittek.com/) - a pioneer in the field of open quantum software who went missing on a mountaineering expedition in the Himalayas last year. The prize is a collaboration between the [Unitary Fund](https://unitary.fund) and the Quantum Open Source Foundation and it aims to reward an otherwise unnoticed individual for their outstanding high-impact contribution to the field of open source quantum software.

The field of quantum computing is in large building upon the successfully established open source development models, and we are happy to report that open source software has been embraced, by academia, industry players alike. However, we are still in the early days of establishing the technology stack for future quantum software developers and while some of the components of the critical infrastructure is developed by larger development teams with commercial backing, there are plentiful individuals who are helping shape the building blocks of the foundations upon which the quantum computing software industry is going to rely in the decades to come.

Read the full story in our [Medium blog post](https://medium.com/qosf/announcing-the-2020-wittek-quantum-prize-for-open-source-software-f578f03823b1).

## Previous winners

{::nomarkdown}<h4 style="margin-top: -5px"><b>2021</b></h3>{:/}

[Victory Omole](https://github.com/vtomole) for his outstanding contributions to Google's Cirq library and other open source projects.

{::nomarkdown}<h4 style="margin-top: -5px"><b>2020</b></h3>{:/}

[Roger Luo](https://github.com/Roger-luo) for his work on Yao.jl and for his commitment to create and foster a quantum software ecosystem in Julia..

## Frequently asked questions

### Can I nominate teams?
No, the Wittek Quantum Prize for Open Source Software is awarded to individuals.

### Does the nominee have to be an original author of an open source project?
No, but they should be a contributor to one or more open source projects in the space of quantum computing.

### What about nominating freely available education materials (i.e. blog posts, books) or other community work (i.e. organizing conferences)?
This year's edition of the Wittek Quantum Prize is awarded only in the category of "Open Source Software", however, we are looking into expanding the scope for the next year. Get in touch if you would like to [support our efforts](mailto:funding@qosf.org).

### How many individuals are being awarded?
We are going to award a single individual.

### Is this a one-off event?
The Wittek Quantum Prize is going to be awarded annually. If your nominee did not make the selection this year, please consider nominating them again for next year's edition.

### When do nominations close?
Nominations will be accepted until 11:59PM [anywhere on Earth (UTC-12)](https://datetime360.com/timezone-aoe/) on Nov 1st, 2021.
