---
# Page settings
layout: default
bottom_illustration: illustrations/why_os.png
custom_css: why_os.css
keywords:
comments: false

# Hero section
title: Why you should open source.
description: How you and others benefit from open sourcing your work.
buttons:
    - content: Sign up for the newsletter
      url: 'https://mailchi.mp/762c19baab5a/qosf-supporter'
      external_url: true
      icon: home
    - icon: slack
      content: Join our Slack
      url: 'https://qosf.org/join'
      external_url: true
    - icon: fa-hand-holding-heart
      content: Donate to QOSF
      url: 'https://qosf.org/donate'

# Micro navigation
micro_nav: false

---

# Research

## Reproducibility
The difficulties of reproducing results are, in the vast majority of cases, not due to the authors having made mistakes or, even worse, forged data.
Rather, the lack of detail about methods, data, and code in a paper is often the greatest impediment.
Sharing the source code alleviates this problem.

## Impact and publicity
There is evidence that sharing details of the code of a scientific work increases its impact.
Additionaly, public evidence of mastering quantum computing may be perceived as a pathway to better career prospects.

# Software development

## Community innovation

Open sourcing your work is a way of giving back to the community. Most of the popular software solutions nowadays are based on non-proprietary open source technology stacks, whether we look to the area of web development or machine learning.

Since resources are no longer spent on re-inventing the wheel, the whole community of software developers and researchers benefits from community-fueled innovation - standing on the shoulders of each others' work.

## Licence sets expectations correctly

Releasing your code under an open source license sets the expectation correctly for both sides of the table. People that use your code know what are the permissions and limitations that go with using your code in their projects.

## Open source encourages contribution

The projects that you are working on can attract external contributions if you make them available under an open source licence. Open source projects often attract a community of users and developers that help with beta-testing, bug-fixing and eventually maintaining the project. Open sourcing your project is a way of increasing the chances of its long-term survival.
