---
# Page settings
layout: default
keywords:
left_illustration: illustrations/what_is_os_left_side.png
right_illustration: illustrations/what_is_os_right_side.png
custom_css: what_is_os.css
comments: false

# Hero section
title: What is open source...
description: ...and why it's not about <i>just</i> putting code out there
buttons:
    - content: Sign up for the newsletter
      url: 'https://mailchi.mp/762c19baab5a/qosf-supporter'
      external_url: true
      icon: home
    - icon: slack
      content: Join our Slack
      url: 'https://qosf.org/join'
      external_url: true
    - icon: fa-hand-holding-heart
      content: Donate to QOSF
      url: 'https://qosf.org/donate'

# Micro navigation
micro_nav: false

---

## What happens when I put code on GitHub or Gitlab
The source code of a software project is considered creative work and as such, in the absence of other arrangements, default copyright laws apply.
Simply making the source code of the project publicly available, i.e. as publishing it on a code hosting site such as GitHub does not release the project into the public domain and does not make it open source.
On the contrary, code that is made public without a licence is still considered proprietary and as such, not free to be used, shared or modified, even for non-commercial or research purposes.

## How to choose a licence

Therefore the act of including a licence with the code -- formally referred to as releasing the code under a given licence -- is what is granting users and developers a set of rights to use, modify and share the project's source code.

For choosing a licence, we recommend following resources:
* [Choose an open source license](https://choosealicense.com/) 
* [Open Source Initiative on Licences](https://opensource.org/licenses)
* [How to choose a licence for your own work by Free Software Foundation](https://www.gnu.org/licenses/license-recommendations.en.html)

### Permissive or copyleft
In general, the open source software licences are divided into two groups -- so called permissive and copyleft.
Permissive licences tend to not restrict the users and developers, and allow the inclusion of the licenced code within commercial software.
Some licences include less severe restrictions, such as preserving attribution (i.e. [The Apache 2.0 Licence](https://opensource.org/licenses/Apache-2.0)).
Copyleft licences, on the other hand, require the authors of the derivative works to redistribute their work under the same, or compatible copyleft licence.
The advantage of using a copyleft licence is in enforcing the open access even to the works that extend or otherwise build upon the original work.
However, that might be seen as restrictive, especially in commercially driven settings.
