---
# Page settings
layout: default
keywords:
comments: false

# Hero section
title: Our Team
description: Overview of the main people behind QOSF. We're always looking for new people so hit us up if you're interested!
buttons:
    - icon: slack
      content: Join our Slack
      url: 'https://qosf.org/join'
      external_url: true
    - icon: fa-hand-holding-heart
      content: Donate to QOSF
      url: 'https://qosf.org/donate'

# Micro navigation
micro_nav: false

---

# Core team
<br>

<div class='row'>
    <div class='col-md-4'>
        <br>
        <br>
        <img style='border-radius:50%;' src='/assets/img/team/tomas.jpg' alt='Tomas Babej' width="200px">
    </div>
    <div class='col-md-8' style='text-align: justify;'>
       <b>Tomas Babej</b>
       is a serial open source project author and maintainer. He became infatuated with the spirit of open source at a very early age while being employed at Red Hat, where motivated by the fear of public shaming on mailing lists he absorbed the best practices for conducting open source software development and governing open source communities. Tomas loves how open source enables him to tweak every little piece of his setup and hopes to maintain this capability even when playing with quantum computing hardware.
    </div>
</div>

<br>
<br>

<div class='row'>
    <div class='col-md-4'>
        <br>
        <br>
        <img style='border-radius:50%;' src='/assets/img/team/mark.jpg' alt='Mark Fingerhuth' width="200px">
    </div>
    <div class='col-md-8' style='text-align: justify;'>
       <b>Mark Fingerhuth</b> wants to rid his life of as much third-party and proprietary software as possible through the use of open source software in all aspects of his life - be it his phone, 3D printer, laptop or smart speakers. He loves popularizing the term <i>quantum software engineer</i> and with the <a href="https://github.com/qosf/os_quantum_software">list of open source quantum software projects on GitHub</a> he kickstarted the effort to enumerate and categorize all existing quantum software projects in our observable universe. In his day-to-day life, Mark is the CEO of <a href="https://proteinqure.com">ProteinQure</a> whose goal it is to demonstrate the world's first useful application of quantum/classical hybrid computation in pharmaceutical drug discovery.
    </div>
</div>

<br>
<br>

<div class='row'>
    <div class='col-md-4'>
        <br>
        <img style='border-radius:50%;' src='/assets/img/team/michal.png' alt='Michał Stęchły' width="200px">
    </div>
    <div class='col-md-8' style='text-align: justify;'>
       <b>Michał Stęchły</b> got into open source thanks to quantum computing - when he discovered he can contribute to the quantum computing community as a newcomer to the field, he immediately fell in love with the idea. He authored and supported open source implementations and research of several quantum computing algorithms. Michał has also a blog <a href="https://www.mustythoughts.com">"Musty Thoughts"</a>, which aims to help people get into the realm of quantum computing. Professionally, he is a Quantum Software Engineer at <a href="https://www.zapatacomputing.com">Zapata Computing</a>.
    </div>
</div>

<br>
<br>

<div class='row'>
    <div class='col-md-4'>
        <br>
        <img style='border-radius:50%;' src='/assets/img/team/maggie.jpg' alt='Maggie Li' width="200px">
    </div>
    <div class='col-md-8' style='text-align: justify;'>
       <b>Maggie Li</b> loves all things open source, from science to software, as a believer in innovation through collaboration. She stepped into the world of open source software as a quantum computing amateur by contributing to <a href="https://github.com/XanaduAI/pennylane">PennyLane</a>, thanks to QOSF's Quantum Mentorship Program. Outside of quantum computing, she cares about healthcare and education accessibility.
    </div>
</div>

<br>
<br>

<div class='row'>
    <div class='col-md-4'>
        <br>
        <br>
        <img style='border-radius:50%;' src='/assets/img/team/peter.jpg' alt='Peter Wittek' width="200px">
    </div>
    <div class='col-md-8' style='text-align: justify;'>
        <b>Peter Wittek<sup>&#8224;</sup></b> was a life-long fan of free and open source software who got furious every time he had to fill in a PDF form that did not work on Linux. When he was not preaching about the importance of open source software, he pursued research on the borderline of artificial intelligence and quantum physics as an Assistant Professor in the University of Toronto, and as an affiliate in the Vector Institute for Artificial Intelligence and the Perimeter Institute for Theoretical Physics. He also was the Academic Director of the Quantum Stream in the Creative Destruction Lab, where he saw dozens of startups exploring ideas using quantum computers and the corresponding software stack. In September 2019, he disappeared in an avalanche during a mountaineering expedition on Mt. Trishul in the Himalayas.
    </div>
</div>
<br>

# Contributors

<div class="callout callout--info">
    <p><strong>A big thank you to all the engaged Github/Gitlab contributors on all of our various repos! You are making QOSF possible!</strong>
    Become a QOSF contributor by opening an issue or submitting a pull request on our <a href="https://github.com/qosf">GitHub</a> or <a href="https://gitlab.com/qosf">GitLab</a> page.
    </p>
	<p> Contributor list:
	<ul><li>00mjk</li>
		<li>1ucian0</li>
		<li>BillyLjm</li>
		<li>InfamousPlatypus</li>
		<li>JoelPasvolsky</li>
		<li>MaldoAlberto</li>
		<li>MariaBat</li>
		<li>MarkCunningham0410</li>
		<li>Qottmann</li>
		<li>Qubit1718</li>
		<li>Roger-luo</li>
		<li>SSdevelop</li>
		<li>Shiro-Raven</li>
		<li>Sinestro38</li>
		<li>TerraVenil</li>
		<li>TheGupta2012</li>
		<li>Travis-S-IBM</li>
		<li>VoicuTomut</li>
		<li>aditya-giri</li>
		<li>amirebrahimi</li>
		<li>artix41</li>
		<li>bestquark</li>
		<li>boegel</li>
		<li>contepablod</li>
		<li>crazy4pi314</li>
		<li>dangirsh</li>
		<li>dependabot[bot]</li>
		<li>desireevl</li>
		<li>dhruvbhq</li>
		<li>diemilio</li>
		<li>dlyongemallo</li>
		<li>dstrain115</li>
		<li>dudalev</li>
		<li>efratshabtai</li>
		<li>enakai00</li>
		<li>georgios-ts</li>
		<li>giorgosgiapis</li>
		<li>hay-k</li>
		<li>hillmich</li>
		<li>iamvamsikrishnad</li>
		<li>ihincks</li>
		<li>johnzl-777</li>
		<li>josh146</li>
		<li>kodaj</li>
		<li>ksjin-git</li>
		<li>lazyoracle</li>
		<li>lkuligin</li>
		<li>lvignoli</li>
		<li>lzylili</li>
		<li>mariaschuld</li>
		<li>markf94</li>
		<li>miguefalvarez</li>
		<li>mkalis</li>
		<li>mstechly</li>
		<li>oscarhiggott</li>
		<li>peguerosdc</li>
		<li>peterwittek</li>
		<li>prince-ph0en1x</li>
		<li>rryoung98</li>
		<li>rsln-s</li>
		<li>saravsak</li>
		<li>scarrazza</li>
		<li>sikfeng</li>
		<li>silky</li>
		<li>spakin</li>
		<li>stared</li>
		<li>stewdio</li>
		<li>tbabej</li>
		<li>tjstavenger-pnnl</li>
		<li>tlubowe</li>
		<li>vic023</li>
		<li>vprusso</li>
		<li>vsoftco</li>
		<li>willzeng</li>
		<li>yardolabs</li>
		<li>yourball</li></ul>
	</p>
</div>

# Donors

<div class="callout callout--info">
    <p><strong>Interested in funding QOSF's mission?</strong>
    We're a not-for-profit charity and are looking for financial support in order to make the QOSF software grant program possible. If you're interested in supporting QOSF's mission financially, feel free to send us an <a href="mailto:funding@qosf.org">email</a>.
    </p>
</div>