---
# Page settings
layout: default
keywords:
comments: false
hackathon_illustration: illustrations/smaller_octopus.png

# Hero section
title: "Quantum Futures Hackathon"
description: A weekend co-organized with CERN dedicated to hacking on quantum computers at the Fields Institute in Toronto, the world's most renown mathematics institute.
buttons:
    - content: Apply for the hackathon
      url: 'https://docs.google.com/forms/d/e/1FAIpQLSeuOYCQLf6wGGB6nMrVsnK4fZs1zL1ioSgK7A-DSKZukTONHA/viewform?usp=sf_link'
      external_url: true
      icon:
---

## Quantum Futures Hackathon

_Are you interested in learning more about quantum technologies and where it could take us? Do you enjoy collaborating on solutions to challenging problems? Whether you are an artist, a scientist or an engineer, whether you are a complete novice or have already fooled around with quantum technologies, this is for you._

---

## Overview

Toronto's first Quantum Futures Hackathon is co-organized by CERN (the world's largest particle accelerator) and QOSF. The Toronto leg of the hackathon will be held at the Fields Institute from Friday the 18th to Sunday the 20th of October 2019 whilst the Swiss leg will take place simultaneously at CERN IdeaSquare. [Register now](https://docs.google.com/forms/d/e/1FAIpQLSeuOYCQLf6wGGB6nMrVsnK4fZs1zL1ioSgK7A-DSKZukTONHA/viewform?usp=sf_link) to secure your chance to explore one of the most promising technologies of our time. The hackathon is a follow up event to the Quantum Futures Workshop, which took place at CERN earlier this year.

Participants will learn more about quantum computing by working in cross-disciplinary teams, exploring the emerging quantum-based technologies and developing their own contributions. Mentored by top scientists from both industry and academia, they will engage in a wide range of projects and challenges, such designing online games, developing solutions that help physicists at CERN, and quantum-generated artworks.

You can pick freely what topic to work on and we will provide support for the open source software packages of all major quantum hardware providers, including
* [Cirq](https://github.com/quantumlib/Cirq) from Google,
* [Qiskit](https://qiskit.org/) from IBM,
* [Forest](https://www.rigetti.com/forest) from Rigetti,
* [D-Wave's Ocean](https://ocean.dwavesys.com/) from D-Wave,
* [Strawberry Fields](https://strawberryfields.readthedocs.io/en/latest/) and [PennyLane](https://pennylane.readthedocs.io/en/latest/) from Xanadu,
* [QuTiP](http://qutip.org/),
* and many more independent quantum open source projects that you might find helpful.

The event is designed to bring together participants from all backgrounds and all levels of expertise – all you need to apply is an interest in learning more about quantum technology. If you are inclined to learn more from from engineers and researchers working on the forefront of quantum computing software and want to push the limits of quantum open source software, there's no better place than here! To apply, simply fill out [our sign up sheet](https://docs.google.com/forms/d/e/1FAIpQLSeuOYCQLf6wGGB6nMrVsnK4fZs1zL1ioSgK7A-DSKZukTONHA/viewform?usp=sf_link).

## Schedule

### Friday, Oct 18th

The first day of the hackathon will consist of a gentle introduction to quantum computing, an overview of potential topics to work on and most importantly team formation. People can already start hacking but we encourage everyone to get a good night of sleep to have a productive weekend!

| Section                                                            | Start    | End      |
|--------------------------------------------------------------------|----------|----------|
| Arrival & Registration	                                         | 05:00 PM | 05:30 PM |
| Introductory lecture on quantum computing & software	             | 05:30 PM | 06:30 PM |
| Pizza & getting to know each other                                 | 06:30 PM | 07:30 PM |
| Overview of potential topics	                                     | 07:30 PM | 08:00 PM |
| Team formation and hackathon kickoff                               | 08:00 PM | 09:00 PM |
| Go home and sleep!                                                 | 09:00 PM | --:-- PM |

### Saturday, Oct 19th

The second day of the hackathon is supposed to be the most productive. The idea is to meet with your team and then hack away! You are more than welcome to use our awesome location - the Fields Institute - from 9AM to 9PM and we will make sure that you're well fed!

| Section                                                            | Start    | End      |
|--------------------------------------------------------------------|----------|----------|
| Hacking                                                            | 09:00 AM | 09:00 PM |
| Light breakfast (Coffee, Tea & Cereals)	                         | 09:00 AM | 11:00 AM |
| Lunch (buffet style)                                               | 12:00 PM | 02:00 PM |
| Dinner (buffet style)	                                             | 06:00 PM | 08:00 PM |
| Go home and sleep!                                                 | 09:00 PM | --:-- PM |


### Sunday, Oct 20th

The last hackathon day is usually pretty hectic! Once again, we gather at the Fields Institute at 9AM and you have until 6PM to finalize your projects and presentations. Then it's time to present what your team achieved in the past days and celebrate your achievements!

| Section                                                            | Start    | End      |
|--------------------------------------------------------------------|----------|----------|
| Hacking                                                            | 09:00 AM | 06:00 PM |
| Light breakfast (Coffee, Tea & Cereals)	                         | 09:00 AM | 11:00 AM |
| Lunch (buffet style)                                               | 12:00 PM | 02:00 PM |
| Final presentations & dinner	                                     | 06:00 PM | 08:30 PM |
| Optional post-hackathon get-together                               | 08:30 PM | 10:30 PM |


# Organizers

* [Tomas Babej](https://github.com/tbabej) - QOSF and ProteinQure Inc.
* [Mark Fingerhuth](https://github.com/markf94) - QOSF and ProteinQure Inc.
* [Peter Wittek](https://gitlab.com/peterwittek) - QOSF, University of Toronto, Vector Institute and Perimeter Institute for Theoretical Physics

Please take a moment to read the [QOSF manifesto](https://qosf.org/manifesto) to learn what we're all about.
