---

# Page settings
layout: default
keywords:
comments: false

# Hero section
title: Quantum Computing Mentorship Program
description: Connecting quantum enthusiasts with mentors from academia & industry.
buttons:
    - content: Apply for mentorship (for applicants)
      url: 'https://forms.gle/fxiUALvWedAEGcSP6'
      external_url: true
      icon: fa-file-import
    - content: Apply to be a mentor
      url: 'https://forms.gle/NTa94uTJDGweNfuP7'
      external_url: true
      icon: fa-file-import
    - icon: slack
      content: Join our Slack
      url: 'https://join.slack.com/t/qosf/shared_invite/zt-2nq2n0t9i-PyiiCKg1bAzRpNzLMM7pWg'
      external_url: true
    - icon: fa-hand-holding-heart
      content: Donate to QOSF
      url: 'https://qosf.org/donate'

# Author box -- to add in when the URL is fixed
#author:
    #title: Cohort 1 showcase
    #title_url: 'cohort_1'
    #external_url: false
    #description: Take a look at the list of open source projects and contributions from the first cohort of the Quantum Computing Mentorship Program.

# Micro navigation
micro_nav: false

---

## General Overview

You’re invited to participate in our Quantum Computing Mentorship Program. 

With the support of a mentor who is an expert in the field and a global community of like-minded people, you’ll complete an open-source project to contribute to quantum computing software as an individual or in a team of up to 3 members. 


## Why?

The idea for this program comes from the fact that many people from diverse backgrounds want to learn more about quantum computing but they face many challenges, such as:

- Shortage of educational materials at the intermediate level,
- There are many “blind alleys” that one can get into, which might severely slow down their progress,
- It’s easy to get a distorted view of the field from the outside.

By pairing people with mentors we want to help them overcome these hurdles and create interesting projects, which will, in turn, will help others.

If you're interested, you can learn more about the [story behind the program](https://www.mustythoughts.com/qc-mentorship-program-backstory) and [how the application process looks like from our perspective](https://www.mustythoughts.com/qosf-mentorship-application.html) on one of the program's organizer's (Michał Stęchły) blog. 


## Project Highlights

Cohort one (March 2020 to June 2020): [mentorship projects]({{ 'mentorship_cohort_1' | absolute_url }}).

Cohort two (October 2020 to January 2021): [mentorship projects]({{ 'mentorship_cohort_2' | absolute_url }}).

Cohort three (March 2021 to June 2021): [mentorship projects]({{ 'mentorship_cohort_3' | absolute_url }}).

Cohort four (October 2021 to January 2022): [mentorship projects]({{ 'mentorship_cohort_4' | absolute_url }}).

Cohort five (March 2022 to June 2022): [mentorship projects]({{ 'mentorship_cohort_5' | absolute_url }}).

Cohort six (October 2022 to January 2023): [mentorship projects]({{ 'mentorship_cohort_6' | absolute_url }}).

Cohort seven (March 2023 to June 2023): [mentorship projects]({{ 'mentorship_cohort_7' | absolute_url }}).

Cohort eight (October 2023 to January 2024): [mentorship projects]({{ 'mentorship_cohort_8' | absolute_url }}).

Cohort nine (March 2024 to June 2024): [mentorship projects]({{ 'mentorship_cohort_9' | absolute_url }}).

## Timeline 

The program is running in cohorts. Here is the timeline for the next cohort, i.e., cohort 10th, which will start in October 2024. If you would like to be informed about updates, please follow us on [Twitter](https://twitter.com/qosfoundation), [LinkedIn](https://www.linkedin.com/company/qosf/) and [Facebook](https://www.facebook.com/quantumOSfoundation)!

| Program milestone                                           | Timeframe                                                           |
--------------------------------------------------------------|---------------------------------------------------------------------|
| Program applications released for mentors                   | October 2, 2024                     | 
| Program applications released for mentees                   | October 7, 2024                     |
| Program applications closed for mentors                     | October 15, 2024                    |
| Program applications closed for mentees                     | October 28, 2024                    | 
| Applications review                                         | October 28 - November 17, 2024       |
| Pairing mentors with mentees and defining projects’ scope   | November 18 - December 1, 2024       |
| Mentees and mentors work on projects                        | December 9, 2024 - March 15, 2025   |
| Program wrap-up, Final presentations                        | March 16-17, 2025     |
| Promotion of all open-source projects                       | April - May 2025|
    

## How does it work?

1. Application
2. Assessment task
3. Mentor and project assignment
4. Project!
5. Finalizing

### Application

To take part in the program, you need to fill in an application form. Link to the application is available at the top and bottom of this page.

### Assessment task

We know that just reading someone’s CV is not enough. We also know that reading the description of this program might not be enough for you to tell whether it’s something you would enjoy. That’s why we will send “homework tasks” to people who filled in the application. You will have 2 weeks to complete them, from the moment you submit your application. It will be the second step of the assessment process.

To get an idea of what to expect from these tasks, you can find the assessment tasks from the previous cohorts:
1.[1st Cohort](https://docs.google.com/document/d/1lo_qy6Y7jhwBMWpQuecxAFG3L_4soYkpq0TaLq42o-A/edit?usp=sharing)
2.[2nd Cohort](https://docs.google.com/document/d/1Ow3v8Y4rYBdgxXNxKV9ZUAM4bwL6211U6DWCcByZ4A4/edit?usp=sharing)
3.[3rd Cohort](https://docs.google.com/document/d/1944peQceYXhRA4Usp6ub_l2ms1xj8mXgseCgWpyBZOA/edit?usp=sharing)
4.[4th Cohort](https://docs.google.com/document/d/1kG2YwNwYclN06iI506rlfrmLCZqFFmS7r_TxjVNLAa8/edit?usp=sharing)
5.[6th Cohort](https://docs.google.com/document/d/1r7QpnUi0LC_VYPLD7o6Mc37bTsOjKibZ/edit?usp=sharing&ouid=108705151841689674364&rtpof=true&sd=true)
6.[7th Cohort](https://docs.google.com/document/d/1KBot_q-CQ7FSmAXK45PDHNu8VKedOEbh/edit?usp=sharing&ouid=108705151841689674364&rtpof=true&sd=true)

### Mentor and project assignment

Based on applications and assessment tasks, the QOSF team and the mentors will choose people who would be admitted to the program. Mentors will choose who they want to work with and will contact their mentees with ideas for the project. 

Once both you and your mentor agree on the project, you will work together to plan its exact scope.

### Project

Finally, we have arrived at the most exciting part! You will work on the project under the supervision of the mentor. This part will last for a maximum of 3 months.

Most (but not all) projects will probably fall into one of two categories:

- Contribution to existing software projects.
- Research projects – implementing papers, reproducing results, etc.

You can also take a look at the list of projects from the [first cohort]({{ 'mentorship_cohort_1' | absolute_url }}), [second cohort]({{ 'mentorship_cohort_2' | absolute_url }})  or [third cohort]({{ 'mentorship_cohort_3' | absolute_url }}) to get a better idea how such projects could look like.

### Finalizing

The project is done – great! But your job is not over yet. What good will do the project that no-one knows about? Now it’s time to wrap it up and promote – depending on the nature of your project, it might be either a blog post, paper, tutorial or something entirely different.


## Requirements

Below you can find the minimal requirements for participation in the project.

### Knowledge of quantum computing basics

While we don’t require expertise, you need to know the basics. We don’t want to specify it exactly, but if you have done any of the things below, you probably know enough:

- Read a book about quantum computing (e.g. [Nielsen and Chuang](https://en.wikipedia.org/wiki/Quantum_Computation_and_Quantum_Information)),
- Finished a course on quantum computing (online or at your university),
- Implemented some quantum algorithms on a simulator.

A place which probably gathers all the necessary basics in one place is [Quantum Computing for the Very Curious](https://quantum.country/qcvc) – if after reading this essay you feel like everything sounds new, then it might be a sign that you need to study a little bit more before applying.

### Coding skills

Projects in this program are about writing software – while you don’t need to be a professional software developer, you need to have practical coding experience - at least a year.

When it comes to programming languages, Python is the most prominent language in quantum computing right now and is a preferred language for this program. However, knowing Python is not a requirement – there might be some interesting projects involving other languages.

Also, working knowledge of one of the major quantum computing libraries like Qiskit or pyQuil will probably be helpful.

### Motivation

We estimate that finishing such a project would take about 80-100 hours of work. Since we plan the projects to last for up to 3 months, it means it might take you about 6-8 hours per week to finish them.
We know it’s a lot of time, but we also know that there is a lot of effort behind every great software project.
That’s why we want the participants to be highly motivated and committed – if you have other commitments and won’t be able to spend that much time on a project in the upcoming months, perhaps it’s better to wait.


## Mentors

What would a mentorship program be without the mentors? We have invited a diverse group of professionals, from both industry and academia to be mentors in this program. 
If you think you could be a mentor, please fill in [this form](https://forms.gle/eu6ZXdLveGCHscA88), there are more details about the requirements in the form.

Here is the list of confirmed mentors for cohort 6th (October 2022 - Jan 2023):

- Stephen DiAdamo, Cisco Systems
- Manuel S. Rudolph, Zapata Computing
- And many more!

In previous cohorts, we have had mentors such as:

- [Ntwali Bashige](https://twitter.com/nbashige), Zapata Computing 
- [Peter Korponaic](https://www.linkedin.com/in/petar-korponaic), Quantastica 
- [Tom Lubowe](https://www.linkedin.com/in/tom-l-17814775/), Xanadu
- [Alba Ceverta Lierta](https://albacl.github.io/), UofT (Alan Aspuru-Guzik Group) 
- [Pierre-Luc Dallaire-Demers](https://www.linkedin.com/in/pierre-luc-dallaire-demers-006540116/), Zapata Computing
- [William Simons](https://www.linkedin.com/in/william-simon-197310112), Zapata Computing 
- [Theodor Issacson](https://www.linkedin.com/in/theodorisacsson/), Xanadu
- [Hannah (Sukin) Sim](https://www.linkedin.com/in/sukin-hannah-sim), Harvard (Alan Aspuru-Guzik Group)
- [Antal Szava](https://www.linkedin.com/in/antalszava/), Xanadu
- [Amira Abbas](https://www.linkedin.com/in/amira-abbas/), IBM Research Zurich
- [Seyon Sivarajah](https://www.linkedin.com/in/seyon-sivarajah-720067b6/), Cambridge Quantum Computing
- [Mark Skillbeck](https://www.linkedin.com/in/mark-skilbeck-5418b317b/), Rigetti Computing
- [Tushar Mittal](https://www.linkedin.com/in/tushar-mittal/), Rigetti Computing
- [Anastasia Marchenkova](https://www.linkedin.com/in/amarchenkova/), Bleximo Corporation
- [Sarah Kaiser](https://www.sckaiser.com/), Q# Community
- And many more! 


## Summary

- The goal of the program is to create an open-source project related to quantum computing.
- Experts from industry and academia will help you build this project.
- The deadline for the application is October 6th, 2023.

You can find link to the application form [here](https://forms.gle/9qcEd7HSUVZieeyNA).


## FAQ

### How will the work with mentors look like?
First, you will have a call with your mentor to get to know each other and decide on the details of the projects. Then, your mentor will check-in with you every two weeks, to make sure you’re on track with the project and you’re not stuck. In the meantime, there will also be a Slack channel, where you can ask them questions or schedule a call if you need that and they will do their best to answer you quickly.

### We would like to apply as a team
We do accept groups of up to 3 people. In such a case, we require you to provide some information about the projects you have done together. Please fill in a separate application form for each of the team members. Also, each of the team members should solve and submit screening tasks separately.

### How can I prepare for the tasks ?

QOSF performs monthly challenges in different fields of quantum computing that can help you to improve your skills, you can find the challenges [here](https://github.com/qosf/monthly-challenges )


If you have any other questions, don't hesitate to [reach out](mailto:qosf.mentorship@gmail.com). 

And if you want, you can find more information about how we handle your data in our [privacy policy]({{ 'privacy_policy' | absolute_url }}).
