---

# Page settings
layout: default
keywords:
comments: false

# Hero section
title: Quantum Computing Mentorship Program Cohort Three Showcase 
description: Connecting quantum enthusiasts with mentors from academia & industry.
buttons:
    - content: Apply for mentorship
      url: 'https://forms.gle/z3FRmje71LtkSNh49'
      external_url: true
      icon: fa-file-import
    - icon: fa-hand-holding-heart
      content: Donate to QOSF
      url: 'https://qosf.org/donate'

# Micro navigation
micro_nav: false

permalink: /mentorship_cohort_3/

---

## Quantum Mentorship Program Cohort 3 Project Showcase 

This is a showcase of all the projects created during the third cohort of our Quantum Computing Mentorship Program. Mentees and mentors worked on a open-source project, with the support of a community of like-minded people from all around the world. In total, there were 24 projects completed!

---

##### **A Julia package on Quantum Optimal Control (QOptCtrl.jl)**  
  
*Project description*: This project aims at developing a general purpose Julia package for implementing quantum gates in the presence of noise or other physical/hardware restrictions.
A few examples are engineering an arbitrary single qubit gate in the presence of stochastic fluctuation in frequency parameters, engineering a pulse sequence to effectively decouple a system of interacting spins, or, designing an optimum pulse sequence to rotate an ensemble of electrons in the presence of an inhomogeneous magnetic field.

*Mentee*: **[Mostafa Atallah](https://twitter.com/M_Ataallah)** A first-year Physics master student at Cairo University, Main research interests are Quantum Information, Quantum Computation and Quantum Machine Learning  [linkedin](https://www.linkedin.com/in/mostafa-atallah-540334120/) [facebook](https://www.facebook.com/mostafa.atallah.1996). 

*Mentor*: **Razieh Annabestani** A Strategic Partner Alliance Manager at Zapata Computing, and a senior scientist with 10+ years experience in physics, quantum information processing, mathematical modelling and numerical simulations and two years experimental experience in spectroscopy.  She has a PhD in Quantum Information and Computation from the University of Waterloo, Canada.

*Links*: [Repository](https://github.com/Mostafa-Atallah2020/QOptCtrl.jl).

---
  
##### **Quantum autoencoder**  

*Project description*: Project is related to the demonstration of hierarchical Extreme Quantum Machine Learning with Neural Tensor Networks in the NISQ Era. In this project, the mentee's introduced the framework of combining classical neural networks and different quantum variants of tensor networks such as tree tensor or multi-entangled renormalization ansatz for classifying the images. 
 
*Mentees*: 
- **[Pinaki Sen](https://www.linkedin.com/in/pinaki-sen/)** is a junior year Electrical Engineering Undergrad. Besides, he is exploring and learning Machine Learning and Quantum Computing. 
- **[Alberto Maldonado Romo](https://www.linkedin.com/in/albertomaldonadoromo/)** is a PhD student in Computer Science at the Centro de Investigación en Computación, Instituto Politecnico Nacional, Mexico, where he has collaborated with the Fermilab and CERN research centres on the GeantV project, and did his Master’s thesis on quantum image processing. Alberto is an admin of the Quantum Universal Education not-forprofit, he has conducted workshops and webinars on introduction to quantum computing, designed comics introducing beginning quantum computing concepts, and created tutorials in five different quantum programming languages. 

*Mentor*: **Amandeep Singh Bhatia** is developing quantum computational models and quantum algorithms with new artificial intelligence methods for physics, and novel quantum machine learning techniques. He received PhD degree in Computer Science Engineering at Thapar University in July 2020. He has more than five years of work experience in quantum computing and technologies. He has contributed to the progress of quantum automata theory and developed quantum computational models for Biology, Chemistry and Tensor network theory. Presently, contributing to the progress of quantum machine learning. 

*Links*: The paper writing is in process.

---
  
##### **Quantum Error Correction**  
  
*Project description*: Mitiq is a Python toolkit for implementing error mitigation techniques on quantum computers. This project was focussed on making a meaningful contribution to Mitiq, which was accomplished by adding additional methods to Mitiq's probabilistic error cancellation (PEC) module allowing it to be used in the same way as Mitiq's zero-noise extrapolation (ZNE) module. In addition, other contributions were made including modifications to the organization of Mitiq's tests, improvements to documentation, and identifying and correcting a bug in Windows-based documentation generation.

*Mentee*: **[Andre Alves]( http://linkedin.com/in/andre-a-alves)**  is an undergraduate computer engineering student whose return to university followed career hopping between the military, diplomacy, and entrepreneurship. He also holds an undergraduate degree in physics, and he plans to continue his studies and pursue an advance degree in quantum science, technology, and/or engineering.

*Mentor*: **Tom Lubowe** is a product and business development leader at Xanadu Quantum Technologies. He focuses on enabling users to learn and do more with the quantum software and hardware that is available today through Xanadu's cloud offering. He hopes to make quantum computing accessible to the masses by reducing the barrier to entry while also ensuring that power users can get the most out of current technology. Tom is a mentor with QOSF and also helps with QOSF operations in his spare time. Prior to this he worked at 3 other quantum software and hardware startups where he focused on both business and product operations.

*Links*: [Repository](https://github.com/unitaryfund/mitiq)

---

##### **Study of many quantum algorithms**  
  
*Project description*: In this project we studied 2 techniques to prove lower bounds in the query complexity model of quantum algorithms. Trong focused on the polynomial method and the adversary method. 
The output of this project is a [new chapter](https://quantumalgorithms.org) where you can find a new (simpler) proof of the main theorem behind the adversary method written by Trong. While the polynomial method is arguably simpler, (you can find some lecture notes about it online), this is the first set of lecture notes where you can learn about the adversary method.

*Mentee*: **[Trong Duong](https://www.linkedin.com/in/trong-duong-0a75b6171/)**  is finishing his second year at KAIST, where he majors in Mathematics and Electrical Engineering. His current research interest is quantum machine learning, specifically optimization for parametrized circuits. He also likes writing blog about quantum computing topics. He enjoys spending his spare time making cheesecake [twitter](https://twitter.com/TrongDu27153458) [personal website](https://myentangled.com/en/).

*Mentor*: **Alessandro Luongo** got a PhD in quantum machine learning and now is a researcher in quantum algorithms at the Centre for Quantum Technologies of Singapore.

*Links*: [Repository](https://github.com/Scinawa/quantumalgorithms.org/commit/dbadd206b1b1b38e8b4a160545971771f453f35e), [Contribution](https://quantumalgorithms.org/lower-bounds-on-query-complexity-of-quantum-algorithms.html )

---

##### **Gradient-free quantum optimization using Evolutionary Algorithms**  
  
*Project description*: Implementing evolutionary algorithms to minimize the cost function so as to estimate the ground state for a model. The evolutionary algorithm part involves inserting/deleting/modifying quantum gates at random locations in the quantum circuit.
    
*Mentee*: **[Saksham Sarwari](https://twitter.com/sarwarisak)** , B.Tech. in Engineering Physics from Indian Institute of Technology, Roorkee, India. Currently working in General Electric as a Software Developer [linkedin](https://www.linkedin.com/in/sarwarisak/). 

*Mentor*: **Dario Rosa**  is a Senior Researcher and Junior Research Team Leader at Institute for Basic Science (IBS), Daejeon, South Korea

*Links*: [Repository](https://github.com/sarwarisak/Quantum-Optimization-using-Evolutionary-Algorithms).

---
  

  
##### **Implement a Qiskit Braket-plugin**  
  
*Project description*: This project aims at building a Qiskit-Braket plugin which provided Qiskit users access to Amazon Braket devices. Upon installing the package, costumers are able to code their quantum circuits, submit the job to a AWS quantum device, and retrieve and analysis the results through the Qiskit framework. The basis workflow as described has been achieved. We are currently reviewing the existing code, and we will continue to expand the utilities of our plugin to incorporate more features from the Qiskit library. 
    
*Mentee*: **[Aike Liu](http://www.linkedin.com/in/aike-liu-505547123)** Theoretical Physics, Graduate Student at California Institute of Technology.

*Mentors*: 
- **Derek Bolt** Principal Engineer at Amazon Braket. 
- **Yunong Shi**: Research Scientist at Amazon Braket.

*Links*: [Repository](https://gitlab.com/AikeLiu/qosf_plugin).

---

##### **An Exploration of the Vehicle Routing Problem (VRP)** 

*Project description*: The major challenge of the logistics industry is to come up with the optimal delivery plan for hundreds and thousands of delivery clients with a given number of available vehicles. This mathematical problem is known as the Vehicle Routing Problem (VRP). In this project, we look at the case of the VRP with a single depot and a fixed number of vehicles and try to minimize the total distance covered by the vehicles using D-Wave Systems. We compare various quantum algorithms against each other using different D-Wave solvers. We also compare D-Wave results against the classical CPLEX and IBM Qiskit results.

*Mentees*: 
- **[Shantom Borah](https://github.com/arkonaire)** is a final year undergraduate at BITS Pilani, India, currently in the final stages of completing his double majors in Physics and Electrical & Electronics Engineering. Other than Quantum Computation and Information, he is also interested in Digital Electronics, Signal Processing, and Artificial Intelligence for games [linkedin](https://in.linkedin.com/in/shantom-borah-69811a149 ). 
- **[Avneesh Verma](https://vectorbolt.github.io/landing-page.html )**  is a 17-year-old at Richmond Hill High School in Canada who loves quantum computing and STEM education. He likes making animated videos to explain concepts in math and science [github](https://github.com/VectorBolt) [youtube](https://www.youtube.com/channel/UCN3uzbzGgzp75Cl2Ai73QSA) [linkedin](https://www.linkedin.com/in/avneesh-verma/). 
- **[Aniket Sanjay Sinha](https://www.linkedin.com/in/sinha-aniket/)** has recently graduated from the Indian Institute of Information Technology Ranchi with a Bachelor of Technology in Electronics and Communications Engineering (class of 2021). His interest lies in learning and developing algorithms to use current and near-term quantum computers to solve real-world problems [github](https://github.com/Aniket-235).

*Mentor*: **[Dr. Vesselin G. Gueorguiev](https://www.linkedin.com/in/vgg-consulting/)**  is a physics [researcher](https://www.researchgate.net/profile/Vesselin_Gueorguiev2) affiliated with the Ronin Institute for [Independent Scholarship](http://ronininstitute.org/research-scholars/vesselin-gueorguiev/) and the [Institute for Advanced Physical Studies](http://iaps.institute/people/). His team AlphaQ won the [2020 CDL Quantum Hackathon](https://github.com/VGGatGitHub/Hackathon2020). He is active in AI and ML Hackathon space as well [personal website](https://devpost.com/vggconsulting). In 2020 he was one of the mentors  for cohort#2 of the QOSF - see project [QOSF cohort#2](https://github.com/VGGatGitHub?tab=projects&q=is:closed).

*Links*: [Repository](https://github.com/VGGatGitHub/QOSF-cohort3).

---

##### **Exploring financial applications of qGANs through Braket** 

*Project description*: This project takes an empirical stab at answering the question: which hyperparameters are optimal for quantum generative adversarial learning. With the application of learning consecutive equity prices, we built a proof-of-concept quantum generative adversarial network and a simple quantum neural network to accomplish the task of predicting the next four days of prices given fifteen prior days of prices. We evaluate quantum model capacity, convergence characteristics, training efficency, and more on the basis of 7 hyperparameters we tuned.

*Mentee*: **[Pavan Jayasinha](https://pavanjay.com/)** is an incoming UWaterloo undergraduate for computer engineering and summer intern at Zapata. Over the past year he has built a strong interest in building and learning quantum machine learning algorithms coupled with the underlying foundations.

*Mentor*: **Yunong Shi**  is a research scientist at Amazon Braket

*Links*: [Repository](https://github.com/Sinestro38/qosf-qgan/tree/code-review-1).

---

##### **Parallel and distributed low-depth algorithms for quantum amplitude estimation** 

*Project description*: Quantum Amplitude Estimation (QAE) is a core subroutine in quantum computation with various applications, including Monte Carlo integration. Quantum computers can potentially utilize QAE to achieve quadratic speed-up compared to classical Monte Carlo. In the conventional approach, the Quantum Phase Estimation (QPE) algorithm is used for amplitude estimation; however, QPE requires expensive controlled operations as well as a Fourier transform, which currently lead to difficulties with implementation in near-term quantum devices. In response to this, some alternative lower depth algorithms have been developed. In this project, I focused on implementing a parallelized and distributed version of the Power Law algorithm for QAE, which should further reduce the current hardware challenges by interconnecting small quantum computers as opposed to relying on a single big quantum computer.

*Mentee*: **[Andrea Ricciardi](https://www.linkedin.com/in/andrea-ricciardi-5887b983/)**  is a mathematician with 5+ years of professional experience as Algorithmic Trader and Developer. He is fascinated with quantum computation and the impact it could have on the world we live in. 

*Mentor*: **Stephen Diadamo**  is a PhD student at the Technical University of Munich. His work focuses on quantum communication systems design, such as protocol design and simulation of quantum networks, distributed quantum computing, and quantum information theory. He developed and maintains several related open-source repos including QuNetSim and Interlin-q.

*Links*: [Repository](https://github.com/andrea-ricciardi/qosf_project), [Paper](http://arxiv.org/abs/2106.06841).

---

##### **Variational Quantum Circuits as General Function Approximators**

*Project description*: Tequila is an open source framework for developing variational quantum algorithms. The project focused on developing and implementing General Function Generators using variational quantum circuits in Tequila. Different techniques were explored and studied to train these variational quantum circuits. Additionally, tutorials were contributed to the Tequila repository which show the use of the generators to create 1-dimensional and 2-dimensional functions.

*Mentee*: **[Tanya Garg](https://www.linkedin.com/in/tanyagarg0/)**  is an engineering physics undergraduate student at the Indian Institute of Technology, Roorkee. She is really interested in quantum computing especially quantum communication and quantum algorithms.

*Mentor*: **Jakob Kottmann** is currently a postdoctoral fellow at The Matter Lab at the University of Toronto.

*Links*: [Repository](https://github.com/tgag17/General-Function-Generators).

---

##### **Implement high-level quantum algorithms in Braket**

*Project description*: Currently, implementing a quantum algorithm in the Amazon Braket SDK requires manually constructing its corresponding quantum circuit using gates. The aim of my project is to develop a feature that supports adding quantum operations that are more useful for building quantum algorithms. Moreover, it should allow us to compartmentalize quantum circuits into distinct sub operations when visualizing. The basic design of this feature has been completed, and operations for constructing the Greenberger-Horne-Zeilinger state, Quantum Fourier Transform, and Quantum Phase Estimation have been added. The code is currently being reviewed, and more operations and utilities will be added in the future.

*Mentee*: **[Jerry Huang](https://www.linkedin.com/in/jerry-huang-243a671b2/)**  is an undergraduate student studying applied and computational mathematics at the California Institute of Technology.

*Mentors*: 
- **Derek Bolt**, Principal Engineer in Amazon Braket. 
- **Yunong Shi**, Research Scientist in Amazon Braket.

*Links*: [Repository](https://github.com/jrrhuang/amazon-braket-sdk-python/tree/composite-operator), [Notebook](https://github.com/jrrhuang/amazon-braket-sdk-python/blob/composite-operator/examples/composite_operator_examples.ipynb)

--- 

##### **Implement a Braket Jupyter notebook text editor plugin**

*Project description*: In this project we created a Jupyter notebook extension for Amazon Braket that can inform users the compatibility of hardware providers with the circuits they intend to run with just a simple click of button in the notebook and a line of code.
To achieve this functionality,  the extension will parse through the function body and generate the corresponding Abstract Syntax Tree (AST), then it analyzes the AST to extract useful information in the circuit to match hardware provider capabilities.The extension is implemented in JavaScript and leverages the ANTLR parsing framework. 

*Mentees*: 
- **[Sehmimul Hoque](https://www.linkedin.com/in/sehmimul-hoque-420419178/)** I am an undergraduate student from Bangladesh, pursuing Mathematical Physics and Combinatorics and Optimization at the University of Waterloo. I like studying about Quantum Computing/Physics and am looking for research opportunities. I am currently doing research at the Institute for Quantum Computing of UWaterloo on Quantum Cryptography.
- **[Matt Wright](https://www.linkedin.com/in/matt-queens/)** I am an undergraduate student at Queen's University studying Engineering Physics, specializing in Computing. I am fascinated by quantum computing and its vast applications and am interested in pursuing graduate studies in the field. I founded a quantum computing division in my school's AI club and am working to share this incredible technology with others.

*Mentor*: **Yunong Shi**, research scientist at Amazon Braket

*Links*: [Repository](https://github.com/shiyunon/jupyter_contrib_nbextensions/tree/master/src/jupyter_contrib_nbextensions/nbextensions/bracket_extension)

--- 

##### **Quantum key distribution and information reconciliation**

*Project description*: Simulating Quantum Key Distribution Protocols with NetSquid

*Mentee*: **[Christopher Um](https://www.linkedin.com/in/christopher-u-116b50181/)** , an incoming college freshman at Cornell University. 

*Mentor*: **Stephen DiAdamo**  PhD student at Technical University of Munich (TUM). He has done previous research in quantum software research with NetSquid. 

*Links*: [Repository](https://github.com/stephendiadamo/qkd_error_recon/tree/master/qkd/protocols)

---

##### **Study the capacity of quantum neural networks**

*Project description*: This project aims to extend the work done by Schuld et al. in [link](https://arxiv.org/abs/2008.08605) by implementing a quantum circuit -> partial fourier series converter to allow for easy access to the fourier coefficients that different quantum circuits give rise to, and ultimately draw inferences about the properties of different quantum ansatze with regards to their expressibiliy as quantum neural networks, and the kernels they give rise to as quantum kernel methods.

*Mentee*: **[Sashwat Anagolum](https://github.com/SashwatAnagolum)** is a undergraduate student at Penn State University interested in quantum computing, machine learning, and everything in between [linkedin](https://www.linkedin.com/in/sashwatanagolum/).

*Mentor*: **Yunong Shi**, research scientist at Amazon Braket

*Links*: [Repository](https://github.com/SashwatAnagolum/qnn_fourier_series)

---

##### **Quantum Generative Models: interplay between depth, topology and accuracy**

*Project description*: Implementation of new qubit topologies for Quantum Circuit Born Machine ansatz in the Orquestra quantum environment

*Mentee*: **[Ben Foxman](https://www.linkedin.com/in/benfoxman1)**, I'm a Rising Junior at Yale University, majoring in mathematics and computer science. I'm currently interning at Fidelity Investments in the Quantitative Research Division. In my free time, I enjoy playing chess, piano, and tennis. 

*Mentor*: **Marta Mauri**, I'm a Quantum Software Engineer at Zapata Computing, where I landed soon after my Physics MSc. My main interests revolve around Quantum Machine Learning and Hybrid Quantum-Classical Algorithms. I'm passionate about developing software to face fundamentals research questions and love working on quantum algorithms for real world applications

*Links*: [Repository](https://github.com/zapatacomputing/z-quantum-qcbm/pull/45)

--- 

##### **Benchmarking quantum convolutional neural networks for classical data**

*Project description*: In this project, we benchmark the classification performance of fully parametrized Quantum Convolutional Neural Network (QCNN) for classical pattern recognition problems. In particular, we investigate the classification accuracy of QCNN designs with various quantum data embedding methods, structures of the parametrized  quantum circuit, classical data pre-processing methods, and loss functions on a number of standard classical datasets.

*Mentees*: 
- **[Tak Hur](https://takh04.github.io)**  is a Quantum Computing enthusiast majoring Msci Physics with Theoretical Physics at Imperial College London. His current research interests are Quantum Information Theory, Quantum Simulation of physical systems, and Quantum Machine Learning.
- **[Leeseok Kim](https://www.linkedin.com/in/leeseok-kim/)**  graduated from Cornell University in 2021 with a B.A. in Physics and Mathematics, and will begin the Master’s program in Engineering Physics at Cornell University from Fall 2021. He is interested in intersections of physics, mathematics, and computer science, especially in quantum machine learning and quantum simulations.

*Mentor*: **Daniel K. Park**  is a Research Professor at Sungkyunkwan University (SKKU) in Korea working on quantum information processing. Before joining SKKU in 2021, he worked at KAIST as a post-doc for 3 years, and then as a research assistant professor for 2 years. He obtained his Ph.D degree in Physics-Quantum Information in 2015 at University of Waterloo & Institute for Quantum Computing.

*Links*: [Repository](https://github.com/takh04/QOSF_release)

--- 

##### **[A NEAT quantum error decoder](https://arxiv.org/abs/2101.08093)**

*Project description*: The aim of my project was to implement a new method of quantum error decoding provided by H. Théveniaut and E.van Nieuwenburg in their paper from January. It uses NEAT to evolve artificial neural networks for correcting the errors occuring to physical qubits of the toric code without introducing a logical error for reasonable noise levels. While I haven't finished the implementation, I learned a lot about the toric code as well as NEAT. My report is a gentle introduction for beginners to both of them which they can use to grasp crucial ideas on these topics. It also prepares ground for implementing the neural network training, which I'm going to add in the future.

*Mentee*: **[Filip Rękawek](https://www.linkedin.com/in/filip-rekawek/)**  is an undergrad at University of Warsaw enrolled in an inter-faculty programme Mathematics and Natural Sciences. Besides quantum computing, his interests embrace mathematical logic and quantum physics.

*Mentor*: **Dario Rosa**  is a theoretical physicist working on quantum chaos and quantum many-body systems. He is based in Korea at the Institute for Basic Science in Daejeon and is interested in the applications of quantum computing to condensed matter and quantum many-body problems

*Links*: [Repository](https://github.com/filomath/Quantum-Error-Decoding-using-NEAT)

--- 

##### **Study of quantum algorithms for monte carlo**

*Project description*: In this project we studied how we can implement quantum algorithms for speeding up Monte Carlo techniques. Michele started from understanding algorithms for amplitude amplification and estimation, and then learned how to apply them in the context of Monte Carlo. We also discussed practical problems where Quantum Monte Carlo can be applied successfully, and we plan to explore further some problems, like the problem of estimating the trace distance between distributions.

*Mentee*: **[Michele Vischi](https://www.linkedin.com/in/michele-vischi-1274b4151)** is a PhD student on Quantum Computing at the University of Trieste. He got his bachelor’s in math and his master’s in physics at Udine and Trieste respectively. He works on decoherence in quantum devices. He wants to learn quantum algorithms. He is a true quantum enthusiast [twitter](https://mobile.twitter.com/Michele06426778).

*Mentor*: **Alessandro Luongo** got a PhD in quantum machine learning and now is a researcher in quantum algorithms at the Centre for Quantum Technologies of Singapore.

*Links*: [Contribution](https://quantumalgorithms.org/chap-montecarlo.html)

--- 

##### **Study of some quantum algorithms (graphs)**

*Project description*: In this project we studied quantum algorithms for graph related problems. Adrian focused on the problem of connectivity on undirected graphs, learning the difference between quantum query complexity and time complexity of an algorithm. He also explored similar techniques for quantum algorithms for finding minimum spanning trees on weighted graphs. 

*Mentee*: **[Adrian Lee](https://www.linkedin.com/in/adrian-lee-b1257714b/)**  is passionate about helping others to grow in the society. Inspired by his academic background in physics (BSc 2015) and mathematics (MSc 2017), he is interested in closing the gap between academia and industries by applying his knowledge in quantum computing.

*Mentor*: **Alessandro Luongo** got a PhD in quantum machine learning and now is a researcher in quantum algorithms at the Centre for Quantum Technologies of Singapore.

*Links*: [Contribution](https://quantumalgorithms.org/chap-graphs.html)

--- 

##### **Study of quantum algorithms for perceptrons**

*Project description*: The project consisted in writing a new chapter for [website](https://quantumalgorithms.org), enhancing the open-source book with an explanation of the quantum Perceptron algorithm. Samantha got acquainted with the classical Perceptron algorithm first and then analyzed its quantum counterpart, writing the new chapter.

*Mentee*: **[ Samantha Buck ](https://www.linkedin.com/in/s-buck)** is pursuing her MSc in experimental nuclear physics at the University of Guelph. In 2019 she received a Mitacs Accelerate research award to work on the quantum simulations division at 1QBit. Future interests entail research at the intersection of quantum machine learning and quantum computing towards initiatives in nuclear physics.

*Mentor*: **Armando** is a Ph.D. student in Quantum Machine Learning at Politecnico di Milano. He has a computer science background, with a focus on cybersecurity and data analysis. His research currently covers provable speed-ups for data representation algorithms, though his interests in quantum algorithms/computation are broader. 

*Links*: [Repository](https://github.com/Scinawa/quantumalgorithms.org)

--- 

##### **Continuous Variable Quantum Algorithms: an Introduction**

*Project description*: Quantum computing is usually associated with discrete quantum states and physical quantities possessing discrete eigenvalue spectrum. However, quantum computing in general is any computation accomplished by the exploitation of quantum properties of physical quantities, discrete or otherwise. It has been shown that physical quantities with continuous eigenvalue spectrum can be used for quantum computing as well. Currently, continuous variable quantum computing is a rapidly developing field both theoretically and experimentally. In this pedagogical introduction we present the basic theoretical concepts behind it and the tools for algorithm development. The paper targets readers with discrete quantum computing background, who are new to continuous variable quantum computing.

*Mentees*: 
- **[Robin Coleman](https://www.linkedin.com/in/robin-coleman-98b19614b/)**  is a PhD student at University of Guelph studying nuclear structure away from stability. M.S. in Physics and B.S. in Engineering Physics. His QC interests are mostly in using quantum computing to solve currently prohibitive physics problems as well as investigating current algorithms and theoretical limits of quantum computing.
- **[Samantha Buck](https://www.linkedin.com/in/s-buck/)** is pursuing her MSc in experimental nuclear physics at the University of Guelph. In 2019 she received a Mitacs Accelerate research award to work on the quantum simulations division at 1QBit. Future interests entail research at the intersection of quantum machine learning and quantum computing towards initiatives in nuclear physics.


*Mentor*: **Hayk** is a theoretical physicist who defended his PhD at Yerevan State University while the mentorship program was in progress. He is currently working as a quantum software engineer at IQM.

*Links*: [Paper](https://arxiv.org/abs/2107.02151)

--- 

##### **Brief Introduction to Quantum Option Pricing**

*Project description*: This project is about quantum quantitative finance. We collected a substantial amount of relevant information on the topic and compiled a brief pedagogical introduction to Quantum Option Pricing. First, we will talk about the field of quantitative finance and introduce the financial instruments called options, along with the crucial Monte Carlo method for pricing American options - the Longstaff-Schwartz algorithm. We will then introduce the recently discovered quantum approach for pricing European Options. We conclude by outlining the direction for future research and development of the project after the conclusion of the QOSF Mentorship Program.

*Mentee*: **[Henry Makhanov](https://www.linkedin.com/in/henry-makhanov/)**  is a MS in CS student at The University of Texas at Austin and a current participant at the Creative Destruction Lab. Henry completed his undergraduate degree in Economics at The University of British Columbia. He is interested in applying quantum computing to the study of stochastic processes [github](https://github.com/edenian/).

*Mentor*: **Dr. Maria Kieferova**, is an SQA postdoctoral fellow at the UTS Centre for Quantum Software and Information and the ARC Centre of Excellence for Quantum Computation and Communication Technology.  Maria completed her undergraduate and masters degree at Comenius University in Slovakia and her PhD at IQC, University of Waterloo and Macquarie University. She is interested in developing quantum algorithms, namely for machine learning and quantum simulations.

*Links*: [Contribution](https://henrymakhanov.medium.com/brief-introduction-to-quantum-option-pricing-7f8c2f3bbbb4)

---

##### **Quantum Image Encryption Algorithm**  

*Project description*: This project is about using quantum computers to scramble and encrypt images. A new quantum algorithm to encrypt a classical image, represented as a quantum state through FRQI encoding, was developed. The algorithm uses quantum baker scrambling, and quantum discrete cosine transform to perform encryption. The algorithm was simulated using Qiskit, and the performance of encrypted images was analyzed. The outcome will be a research paper, and it is also planned to make the code open-source, in the form of a github repository, along with the paper.  
 
*Mentee*: **[Dhruv Bhatnagar](https://www.linkedin.com/in/dhruv-bhatnagar-471abb113/)** Dhruv is a meritorious electronics engineering graduate from NSIT, University of Delhi, with professional experience in developing verification IP software. He is passionate about the great potential of quantum technology. Currently, he is pursuing a research MSc in Applied Physics at TU Delft, with strong focus on quantum computing.

*Mentor*: **[Amandeep Singh Bhatia](https://www.linkedin.com/in/amandeep-singh-bhatia-ph-d-07b83822)** is developing quantum computational models and quantum algorithms with new artificial intelligence methods for physics, and novel quantum machine learning techniques. He received PhD degree in Computer Science Engineering at Thapar University in July 2020. He has more than five years of work experience in quantum computing and technologies. He has contributed to the progress of quantum automata theory and developed quantum computational models for Biology, Chemistry and Tensor network theory. Presently, contributing to the progress of quantum machine learning. 

*Links*: The paper writing is in process.

---
