---
# Page settings
layout: default
keywords:
left_illustration: illustrations/manifesto_left_side.png
right_illustration: illustrations/manifesto_right_side.png
custom_css: manifesto.css
comments: false

# Hero section
title: QOSF Manifesto
description: Our core beliefs and mission statement and why you should get excited about us.
buttons:
    - content: Sign up for the newsletter
      url: 'https://mailchi.mp/762c19baab5a/qosf-supporter'
      external_url: true
      icon: home
    - icon: slack
      content: Join our Slack
      url: 'https://qosf.org/join'
      external_url: true
    - icon: fa-hand-holding-heart
      content: Donate to QOSF
      url: 'https://qosf.org/donate'

# Micro navigation
micro_nav: false

---

# Mission

The Quantum Open Source Foundation, herein after referred to as QOSF, is charged to expand the role of open source software in quantum computing and improve the standardization and quality thereof. The main focus of the QOSF will be on software intended for the use with current and near-term quantum computing technologies also often referred to as noisy intermediate scale quantum (NISQ) technologies. The QOSF will also pursue activities and financial support related to the exploration of upcoming open source software for fault-tolerant universal quantum computers on the scale of hundreds of logical qubits. A specific focus lies in the standardization of the low-level hardware interfaces and their compilation in order to allow for cross-compatibility of quantum programming languages. The objective of QOSF is to:

- Foster collaboration between the quantum hardware and software developer communities;

- Provide financial funding for selected projects and travel awards for selected QOSF members and maintainers of open source quantum projects;

- Incentivize and support the distribution of free and open information regarding advances in quantum software engineering and quantum computing in general;

- Provide a forum for physicists, software developers, quantum hardware providers and other parties to discuss common problems and obstacles related to open quantum software engineering;

- Organize free and open conferences, workshops and informational sessions on quantum software engineering;

- Convey the fundamental concepts of quantum computing and quantum software engineering to the general public.

# Membership

Membership in the QOSF is open and free to anyone interested in open source software development for quantum computing. Members and supporters of the QOSF are not obliged to donate to the foundation itself but are committing to support the values stated in this manifesto. There are no dues of any kind. You can become a QOSF member/supporter today by simply subscribing to our <a href="https://mailchi.mp/762c19baab5a/qosf-supporter">newsletter</a>.

# Amendments
Amendments to this manifesto may be proposed by petition supported by at least 10% (at the time of submission) of QOSF members and must be submitted to the board of directors of the QOSF. The proposed amendment shall be submitted to the QOSF members for vote at the time of our biannual meetings. If approved by vote through an absolute majority of the QOSF members, the amendment is approved. An approved amendment shall be effective immediately, unless otherwise specified in the amendment itself.
