---
# Page settings
layout: default
keywords:
comments: false

# Hero section
title: "FOSDEM&#39;19 Quantum Computing"
description: Two days dedicated to Quantum computing at Europe's largest open source conference!
buttons:
    - content: Sign up for the newsletter
      url: 'https://mailchi.mp/762c19baab5a/qosf-supporter'
      external_url: true
      icon: home
    - icon: slack
      content: Join our Slack
      url: 'https://qosf.org/join'
      external_url: true
    - icon: fa-hand-holding-heart
      content: Donate to QOSF
      url: 'https://qosf.org/donate'

---

## FOSDEM&#39;19 Quantum Computing

_Are you interested in Quantum Computing? Unsure where the industry's heading? Is the
hype justified? And when are quantum computers going to take over the world?_

**or**

_Are you a developer interested in jumping on the rising tide of the new
computing paradigm?_

---

Join us for two packed days full of quantum computing, celebrating open source
and fostering collaboration at [FOSDEM 2019](https://fosdem.org/2019/) and
learn answers to (not only!) those questions.

The space of the open source software for quantum computing is blooming,
with researchers and hardware providers alike investing in creating
software infrastructure for this new computing paradigm.

The main themes of the event are:

- to flatten down the learning curve and break perceived barriers that prevent
  developers from entering the field of quantum software development
- to promote existing quantum computing open source projects and foster
  collaboration between new and existing developers
- to ensure that the field is dominated by high-quality, community driven FOSS
  open source software, standards and protocols

All major hardware providers with open source development frameworks, including
[Qiskit](https://qiskit.org/) (IBM),
[Forest](https://www.rigetti.com/forest) (Rigetti), 
[D-Wave's Ocean](https://ocean.dwavesys.com/) (D-Wave), 
[PennyLane](https://pennylane.readthedocs.io/en/latest/),
[Strawberry Fields](https://strawberryfields.readthedocs.io/en/latest/) (Xanadu),
[QuTiP](http://qutip.org/),
[Cirq](https://github.com/quantumlib/Cirq) (Google),
and a vast number of academic and independent open source projects will be featured over the two days. 

If you are inclined to learn more from directly from engineers and researchers
working on the forefront of quantum computing software, join the community and
contribute to pushing the limits of the quantum computing open source, there's no
better place than here!

## Overview

### Saturday: Quantum computing devroom
Saturday is devoted to quantum computing full-stack libraries and established, mature quantum computing projects.
Attendees are free to come and go in-between the talks, but beware that rooms at FOSDEM can get crowded!
This day will also include a discussion on the state of open source and possible directions going forward with respect to development of open source and open standards.

### Sunday: Quantum computing workshop
Sunday is hands-on day: we're organizing a **quantum computing workshop**! In the morning, developers of 11 open source quantum computing projects in total will introduce attendees of the workshop to their projects.
During the afternoon, participants of the workshop (yes, you!) will work in small groups with the developers of the selected project to work learn more about the respective projects, help improve the documentation or even work on their first contributions!

Participants of the Quantum computing workshop are generally expected to attend the whole day - the space is limited. If you want a better chance to get a spot, [pre-register here](https://docs.google.com/forms/d/e/1FAIpQLScmbT0L2lDeMOhcLmSEmif-dqkuCg_EV0S7RkP4RJxZy5ksyQ/viewform).

## Schedule

### Saturday, Feb 2nd

During the first day of the conference, the quantum computing track is held in the room [AW.121](https://fosdem.org/2019/schedule/room/aw1121/).

* Calendar: [iCal](https://fosdem.org/2019/schedule/track/quantum_computing.ics), [xCal](https://fosdem.org/2019/schedule/track/quantum_computing.xcs)
* Duration: 10.30 -- 19.00
* Capacity: 82

| Talk title                                                         | Start       | End         | Speaker               |
|--------------------------------------------------------------------|-------------|-------------|-----------------------|
| When open source meets quantum computing	                         | 10:30:00 AM | 10:55:00 AM | Tomas Babej           |
| Forest: An Open Source Quantum Software Development Kit            | 11:00:00 AM | 11:45:00 AM | Robert Smith          |
| Delivering Practical Quantum Computing                             | 11:50:00 AM | 12:20:00 PM | Murray Thom           |
| D-Wave's Software Development Kit                                  | 12:25:00 PM | 12:55:00 PM | Alexander Condello    |
| D-Wave Hybrid Framework	                                         | 01:00:00 PM | 01:30:00 PM | Radomir Stevanovic    |
| What is IBMQ                                                       | 01:35:00 PM | 02:20:00 PM | Mark Mattingley-Scott |
| Qutip: Quantum simulations and collaborative code development      | 02:25:00 PM | 03:10:00 PM | Shahnawaz Ahmed       |
| Strawberry Fields - software for photonic quantum computing        | 03:15:00 PM | 04:00:00 PM | Nathan Killoran       |
| PennyLane - Automatic differentiation and ML of QC                 | 04:05:00 PM | 04:50:00 PM | Josh Izaac            |
| Quantum Computing at Google and in the Cloud                       | 04:55:00 PM | 05:40:00 PM | Kevin D. Kissell      |
| Promotion of open source and role of standardization in QC         | 05:45:00 PM | 06:30:00 PM | Panel Discussion      |
| Exponential speedup in progress                                    | 06:35:00 PM | 07:00:00 PM | Mark Fingerhuth       |

### Sunday, Feb 3rd

During the second day of the conference, the quantum computing workshop is held in the room [UB2.147](https://fosdem.org/2019/schedule/room/ub2147/).

* Calendar: [iCal](https://fosdem.org/2019/schedule/track/quantum_computing_workshop.ics), [xCal](https://fosdem.org/2019/schedule/track/quantum_computing_workshop.xcs)
* Duration: 9.00 -- 16.30
* Capacity: 91

| Workshop title                                                     | Start       | End         | Speaker               |
|--------------------------------------------------------------------|-------------|-------------|-----------------------|
| Towards Practical Quantum Machine Learning with NISQAI             | 09:00:00 AM | 09:20:00 AM | Ryan LaRose           |
| Bayesforge: Elevating the QC Stack                                 | 09:20:00 AM | 09:40:00 AM | Henning Dekant        |
| An Open-Source General Compiler for Quantum Computers	             | 09:40:00 AM | 10:00:00 AM | Kaitlin Smith         |
| Julia programming language for quantum software development        | 10:00:00 AM | 10:20:00 AM | Piotr Gawron          |
| QCL - A Programming Language for Quantum Computers	             | 10:20:00 AM | 10:40:00 AM | Andrew Savchenko      |
| Curry: A probabilistic quantum programming language                | 10:40:00 AM | 11:00:00 AM | Lucas Saldyt          |
| PyZX: Graph-theoretic optimization of quantum circuits             | 11:20:00 AM | 11:40:00 AM | John van de Wetering  |
| An implementation of a classifier on Qiskit                        | 11:40:00 AM | 12:00:00 PM | Carsten Blank         |
| Through the RevKit v3 implementation                               | 12:00:00 PM | 12:20:00 PM | Bruno Schmitt         |
| Q-bug: Visualizing Quantum Circuits                                | 12:20:00 PM | 12:40:00 PM | Felix Tripier         |
| SimulaQron — a simulator for developing quantum internet software  | 12:40:00 PM | 13:00:00 PM | Axel Dahlberg         |
| Contribution hackathon session                                     | 13:30:00 PM | 16:30:00 PM | N/A                   |

# Live streaming and recordings

Live streaming [will be available](https://fosdem.org/2019/schedule/streaming/),
with talks being recorded and hosted on the official [FOSDEM video archive](https://video.fosdem.org/2019/).

# Organizers

* [Tomas Babej](https://github.com/tbabej) - ProteinQure Inc.
* [Mark Fingerhuth](https://github.com/markf94) - ProteinQure Inc.
* [Peter Wittek](https://gitlab.com/peterwittek) - University Of Toronto, Vector Institute, Perimeter Institute for Theoretical Physics

# Sponsors
[![Unitary Fund](https://unitary.fund/logos/logo.png)](https://unitary.fund)

Please, take a moment to read the [FOSDEM Code of Conduct](https://fosdem.org/2019/practical/conduct/).
