/*
 Navicat Premium Data Transfer

 Source Server         : localhost
 Source Server Type    : MySQL
 Source Server Version : 50733
 Source Host           : localhost:3306
 Source Schema         : qingting

 Target Server Type    : MySQL
 Target Server Version : 50733
 File Encoding         : 65001

 Date: 07/04/2021 16:17:23
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for advert
-- ----------------------------
DROP TABLE IF EXISTS `advert`;
CREATE TABLE `advert`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '广告类型，1:启动图广告，2:视频广告,3:弹窗霸屏广告,4:图文广告',
  `provider_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '推广商名称',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '广告标题',
  `img_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '广告图片',
  `video_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '广告视频播放地址',
  `ad_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '广告跳转/下载链接',
  `desc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '广告描述',
  `open_type` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '打开方式：1：直接下载，2：浏览器打开',
  `end_time` datetime(0) NOT NULL COMMENT '到期时间',
  `view_num` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '浏览次数，可做显示那条广告的依据',
  `sort` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '排序',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '广告状态 0 禁用， 1 启用',
  `updated_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '更新时间',
  `created_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `type_end`(`end_time`, `type`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 5 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '广告表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of advert
-- ----------------------------
INSERT INTO `advert` VALUES (2, 2, '老干妈', '老干妈', 'http://qingtingcun.youyacao.com/qiniu_202006150957138663373508.jpg', 'http://qingtingcun.youyacao.com/qiniu_202006110908518923412071.mp4', 'http://baidu.com', '老干妈，好吃到爆炸~', 2, '2020-12-24 00:00:00', 0, 0, 1, 1597047681, 1592214605);
INSERT INTO `advert` VALUES (3, 2, '腾讯云', '腾讯云主机', 'http://img.kaiyanapp.com/33e2a6d1e3a83d68323fe6ab87a19882.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=170114&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', 'http://sina.com', '腾讯云主机!!!', 2, '2021-01-21 00:00:00', 0, 0, 1, 1597047671, 1592294545);
INSERT INTO `advert` VALUES (4, 1, '今日头条', '推妹子', 'qiniu_202012210345380623857816.png?imageView2/1/w/800/h/800', '', 'https://songshu.youyacao.com/', '最养眼的占位图', 2, '2020-12-31 00:00:00', 0, 0, 1, 1608522356, 1594302711);

-- ----------------------------
-- Table structure for api_log
-- ----------------------------
DROP TABLE IF EXISTS `api_log`;
CREATE TABLE `api_log`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `type` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '类型1后端',
  `user_id` int(11) NOT NULL DEFAULT 0 COMMENT 'user_id',
  `code` int(10) NOT NULL DEFAULT 0 COMMENT 'code',
  `msg` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '提示信息',
  `datas` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '数据',
  `requests` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '输入参数',
  `method` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT 'method',
  `action` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '操作方法',
  `ip` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '登录ip',
  `updated_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '更新时间',
  `created_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `type`(`type`) USING BTREE,
  INDEX `action`(`action`(191)) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '接口日志表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for article
-- ----------------------------
DROP TABLE IF EXISTS `article`;
CREATE TABLE `article`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `user_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '关联用户ID',
  `category_id` int(10) NOT NULL DEFAULT 0 COMMENT '分类id',
  `oid` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '对象id',
  `type` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '1:图文2视频',
  `title` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '标题',
  `content` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '内容',
  `images` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '图片',
  `thumb` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '视频预览图',
  `video_url` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '视频地址',
  `videos` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '视频',
  `view_num` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '查看次数',
  `like_num` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '点赞次数',
  `comment_num` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '评论次数',
  `share_num` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '分享次数',
  `collect_num` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '收藏次数',
  `tags` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '标签',
  `is_top` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '是否置顶',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT 1 COMMENT '状态0:删除1:待审核2:审核通过',
  `updated_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '更新时间',
  `created_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `category`(`category_id`) USING BTREE,
  INDEX `user_id`(`user_id`) USING BTREE,
  INDEX `created_at`(`created_at`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 86 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '图文表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of article
-- ----------------------------
INSERT INTO `article` VALUES (1, 5, 19, 0, 1, '测试1', '斯大学疫情实时监测系统显示，截至美东时间6月2日下午5时33分，美国已有新冠病毒感染病例1828736例，其中包括死亡病例106046例。美国新增感染病例24530例，新增死亡病例1247例。\n疫情最为严重的纽约州有感染病例3', 'qiniu_202006030206409974652735.jpg?imageView2/1/w/800/h/800,qiniu_202006050533560662433205.jpg?imageView2/1/w/800/h/800', 'qiniu_202006050607179041154445.mp4?vframe/jpg/offset/1', 'qiniu_202006050607179041154445.mp4', '', 100565, 333115, 5, 9988, 0, '', 0, 2, 1608286620, 1591150004);
INSERT INTO `article` VALUES (2, 2, 3, 0, 2, '我是标题', '瀚海瀚海瀚海瀚海瀚海瀚海', '', 'qiniu_202006081422428669078474.mp4?vframe/jpg/offset/1', 'qiniu_202006081422428669078474.mp4', '', 383, 2, 11, 0, 0, '', 0, 2, 1593272489, 1591626217);
INSERT INTO `article` VALUES (3, 4, 0, 0, 1, '', '1111', '', '', '', '', 70, 0, 1, 0, 0, '', 0, 0, 1593403506, 1592640366);
INSERT INTO `article` VALUES (4, 69, 0, 0, 1, '', '123', '', '', '', '', 85, 0, 0, 0, 0, '', 0, 0, 1592832496, 1592640554);
INSERT INTO `article` VALUES (5, 69, 0, 0, 1, '', '333', '', '', '', '', 86, 0, 0, 0, 0, '', 0, 0, 1592832496, 1592640577);
INSERT INTO `article` VALUES (6, 69, 0, 0, 1, '', '雕牌', 'http://qingtingcun.youyacao.com/qiniu_202006200810011133968695.jpg', '', '', '', 232, 0, 4, 0, 0, '', 0, 2, 1593403923, 1592640609);
INSERT INTO `article` VALUES (7, 69, 0, 0, 1, '', '258', '', '', '', '', 96, 1, 0, 0, 0, '', 0, 0, 1592832488, 1592640727);
INSERT INTO `article` VALUES (8, 69, 0, 0, 1, '', '', '', '', '', '', 101, 0, 0, 0, 0, '', 0, 0, 1592832488, 1592640877);
INSERT INTO `article` VALUES (9, 69, 0, 0, 1, '', '', '', '', '', '', 134, 0, 0, 0, 0, '', 0, 0, 1592832488, 1592640901);
INSERT INTO `article` VALUES (10, 69, 0, 0, 1, '', '雕牌', '', 'http://qingtingcun.youyacao.com/qiniu_202006200842287635015804.mp4?vframe/jpg/offset/1', 'http://qingtingcun.youyacao.com/qiniu_202006200842287635015804.mp4', '', 87, 0, 0, 0, 0, '', 0, 0, 1592751630, 1592642581);
INSERT INTO `article` VALUES (11, 69, 0, 0, 2, '', '雕', '', 'http://qingtingcun.youyacao.com/qiniu_202006200844089464565623.mp4?vframe/jpg/offset/1', 'http://qingtingcun.youyacao.com/qiniu_202006200844089464565623.mp4', '', 90, 0, 0, 0, 0, '', 0, 0, 1592751628, 1592642675);
INSERT INTO `article` VALUES (12, 69, 0, 0, 2, '', '123', '', 'http://qingtingcun.youyacao.com/qiniu_202006201526404741661535.mp4?vframe/jpg/offset/1', 'http://qingtingcun.youyacao.com/qiniu_202006201526404741661535.mp4', '', 80, 0, 0, 0, 0, '', 0, 0, 1592751625, 1592666821);
INSERT INTO `article` VALUES (13, 69, 0, 0, 1, '', '456', 'http://qingtingcun.youyacao.com/qiniu_202006201601424920112961.jpg,http://qingtingcun.youyacao.com/qiniu_202006201601499170230571.jpg', 'qiniu', '', '', 64, 0, 0, 0, 0, '', 0, 0, 1592746583, 1592668959);
INSERT INTO `article` VALUES (14, 69, 0, 0, 2, '', '123', '', 'http://qingtingcun.youyacao.com/qiniu_202006211231006824710157.mp4?vframe/jpg/offset/1', 'http://qingtingcun.youyacao.com/qiniu_202006211231006824710157.mp4', '', 59, 0, 0, 0, 0, '', 0, 0, 1592751622, 1592742708);
INSERT INTO `article` VALUES (15, 69, 0, 0, 2, '', '123', '', 'http://qingtingcun.youyacao.com/qiniu_202006211240320310456213.mp4?vframe/jpg/offset/1', 'http://qingtingcun.youyacao.com/qiniu_202006211240320310456213.mp4', '', 66, 0, 0, 0, 0, '', 0, 0, 1592751618, 1592743254);
INSERT INTO `article` VALUES (16, 69, 0, 0, 1, '', '456', '', '', '', '', 113, 0, 0, 0, 0, '', 0, 0, 1592832481, 1592744753);
INSERT INTO `article` VALUES (17, 69, 0, 0, 1, '', '789', '', '', '', '', 154, 0, 0, 0, 0, '', 0, 0, 1592832481, 1592744773);
INSERT INTO `article` VALUES (18, 69, 0, 0, 1, '', '666', '', '', '', '', 147, 0, 0, 0, 0, '', 0, 0, 1592832481, 1592744824);
INSERT INTO `article` VALUES (19, 69, 0, 0, 1, '', '123', '', '', '', '', 140, 0, 0, 0, 0, '', 0, 0, 1592832481, 1592744856);
INSERT INTO `article` VALUES (20, 69, 0, 0, 1, '', '456', '', '', '', '', 135, 0, 0, 0, 0, '', 0, 0, 1592832481, 1592744894);
INSERT INTO `article` VALUES (21, 69, 0, 0, 1, '', '123', '', '', '', '', 131, 0, 0, 0, 0, '', 0, 0, 1592832474, 1592744996);
INSERT INTO `article` VALUES (22, 69, 0, 0, 1, '', '1', 'http://qingtingcun.youyacao.com/qiniu_202006211322165670779857.jpg,', '', '', '', 7, 0, 0, 0, 0, '', 0, 0, 1592746580, 1592745743);
INSERT INTO `article` VALUES (23, 69, 0, 0, 1, '', '2', 'http://qingtingcun.youyacao.com/qiniu_202006211322406182215717.jpg,http://qingtingcun.youyacao.com/qiniu_202006211322446111922299.jpg,', '', '', '', 6, 0, 0, 0, 0, '', 0, 0, 1592746578, 1592745767);
INSERT INTO `article` VALUES (24, 69, 0, 0, 1, '', '3', 'http://qingtingcun.youyacao.com/qiniu_202006211325083137747476.jpg,http://qingtingcun.youyacao.com/qiniu_202006211325112399147727.jpg,http://qingtingcun.youyacao.com/qiniu_202006211325147049894176.jpg,', '', '', '', 5, 0, 1, 0, 0, '', 0, 0, 1592746576, 1592745917);
INSERT INTO `article` VALUES (25, 69, 0, 0, 1, '', '4', 'http://qingtingcun.youyacao.com/qiniu_202006211326563984585953.jpg,http://qingtingcun.youyacao.com/qiniu_202006211326591192232696.jpg,http://qingtingcun.youyacao.com/qiniu_202006211327038269617128.jpg,http://qingtingcun.youyacao.com/qiniu_202006211327090539591296.jpg,', '', '', '', 298, 2, 4, 0, 0, '', 0, 2, 1594687755, 1592746033);
INSERT INTO `article` VALUES (26, 69, 0, 0, 1, '', '123', 'http://qingtingcun.youyacao.com/qiniu_202006211402179346999113.jpg,', '', '', '', 288, 0, 4, 0, 0, '', 0, 2, 1595426237, 1592748151);
INSERT INTO `article` VALUES (27, 69, 0, 0, 1, '', '3', 'http://qingtingcun.youyacao.com/qiniu_202006211429463495867598.jpg,http://qingtingcun.youyacao.com/qiniu_202006211430020416144203.jpg,http://qingtingcun.youyacao.com/qiniu_202006211430105260290221.jpg,', '', '', '', 280, 0, 1, 0, 0, '', 0, 0, 1593256858, 1592749816);
INSERT INTO `article` VALUES (28, 69, 0, 0, 1, '', '123', 'http://qingtingcun.youyacao.com/qiniu_202006220308167707611826.jpg,', '', '', '', 273, 0, 6, 0, 0, '', 0, 2, 1595426237, 1592795307);
INSERT INTO `article` VALUES (29, 82, 0, 0, 2, '', '可以上传视频的。', '', 'http://qingtingcun.youyacao.com/qiniu_202006220315131627372322.mp4?vframe/jpg/offset/1', 'http://qingtingcun.youyacao.com/qiniu_202006220315131627372322.mp4', '', 271, 0, 7, 0, 0, '', 0, 2, 1595426237, 1592795740);
INSERT INTO `article` VALUES (30, 69, 0, 0, 2, '', '键盘侠?', '', 'http://qingtingcun.youyacao.com/qiniu_202006230325226302431430.mp4?vframe/jpg/offset/1', 'http://qingtingcun.youyacao.com/qiniu_202006230325226302431430.mp4', '', 158, 0, 0, 0, 0, '', 0, 2, 1595426237, 1592882781);
INSERT INTO `article` VALUES (31, 69, 0, 0, 2, '', '椒盐排条', '', 'http://qingtingcun.youyacao.com/qiniu_202006230334205759091099.mp4?vframe/jpg/offset/1', 'http://qingtingcun.youyacao.com/qiniu_202006230334205759091099.mp4', '', 157, 1, 0, 0, 0, '', 0, 2, 1595426237, 1592883295);
INSERT INTO `article` VALUES (32, 69, 0, 0, 2, '', '赢家', '', 'http://qingtingcun.youyacao.com/qiniu_202006230355212202855689.mp4?vframe/jpg/offset/1', 'http://qingtingcun.youyacao.com/qiniu_202006230355212202855689.mp4', '', 151, 2, 0, 0, 1, '', 0, 2, 1595426237, 1592884555);
INSERT INTO `article` VALUES (35, 69, 0, 0, 2, '', '光', '', 'qiniu_202006230542385560196487.mp4?vframe/jpg/offset/1', 'qiniu_202006230542385560196487.mp4', '', 131, 0, 0, 0, 0, '', 0, 0, 1593256864, 1592891079);
INSERT INTO `article` VALUES (36, 69, 0, 0, 1, '', '水系', 'qiniu_202006230557047335819134.jpg?imageView2/1/w/800/h/800,qiniu_202006230557131533070017.jpg?imageView2/1/w/800/h/800,qiniu_202006230557203924574501.jpg?imageView2/1/w/800/h/800,', '', '', '', 110, 0, 0, 0, 0, '', 0, 0, 1593250423, 1592891851);
INSERT INTO `article` VALUES (37, 69, 0, 0, 1, '', '话题终结者', 'qiniu_202006231328151076199241.jpg?imageView2/1/w/800/h/800,', '', '', '', 93, 0, 0, 0, 0, '', 0, 0, 1593250396, 1592918903);
INSERT INTO `article` VALUES (38, 69, 0, 0, 1, '', '话题4', 'qiniu_202006231331286328498140.jpg?imageView2/1/w/800/h/800,', '', '', '', 150, 0, 2, 0, 0, '', 0, 0, 1593250391, 1592919094);
INSERT INTO `article` VALUES (39, 69, 0, 0, 1, '', '1', 'qiniu_202006231334257546137968.jpg?imageView2/1/w/800/h/800,', '', '', '', 150, 2, 1, 0, 0, '', 0, 0, 1593250354, 1592919274);
INSERT INTO `article` VALUES (40, 4, 0, 0, 1, '', '1111', '', '', '', '', 338, 0, 0, 0, 0, '', 0, 2, 1595426237, 1592924538);
INSERT INTO `article` VALUES (41, 4, 0, 0, 1, '', '1111', '', '', '', '', 353, 0, 0, 0, 0, '', 0, 2, 1595426237, 1592924637);
INSERT INTO `article` VALUES (42, 4, 0, 0, 1, '', '1111', '', '', '', '', 353, 0, 0, 0, 0, '', 0, 2, 1595426237, 1592924664);
INSERT INTO `article` VALUES (43, 4, 0, 0, 1, '', '1111', '', '', '', '', 358, 1, 0, 0, 0, '', 0, 2, 1595426237, 1592924714);
INSERT INTO `article` VALUES (44, 4, 0, 0, 1, '', '1111', '', '', '', '', 360, 1, 5, 0, 0, '', 0, 2, 1595665479, 1592924749);
INSERT INTO `article` VALUES (45, 4, 0, 0, 1, '', '1111', '', '', '', '', 359, 0, 0, 0, 0, '', 0, 2, 1595665479, 1592924838);
INSERT INTO `article` VALUES (46, 4, 0, 0, 1, '', '1111222222', '', '', '', '', 359, 0, 5, 0, 0, '', 0, 2, 1595665479, 1592924889);
INSERT INTO `article` VALUES (47, 69, 0, 0, 1, '', '3', 'qiniu_202006231523435067432851.jpg?imageView2/1/w/800/h/800,', '', '', '', 193, 0, 2, 0, 0, '', 0, 0, 1593185306, 1592925830);
INSERT INTO `article` VALUES (48, 69, 0, 0, 1, '', '2  8', 'qiniu_202006231553419812291071.jpg?imageView2/1/w/800/h/800,qiniu_202006231553533607125217.jpg?imageView2/1/w/800/h/800,', '', '', '', 163, 0, 0, 0, 0, '', 0, 0, 1593184966, 1592927672);
INSERT INTO `article` VALUES (49, 69, 0, 0, 2, '', '彩虹', '', 'qiniu_202006231555035155857488.mp4?vframe/jpg/offset/1', 'qiniu_202006231555035155857488.mp4', '', 162, 0, 0, 0, 0, '', 0, 0, 1593184885, 1592927739);
INSERT INTO `article` VALUES (50, 26, 0, 0, 1, '', '嗯嗯', '', '', '', '', 134, 1, 0, 0, 0, '', 0, 2, 1595665479, 1593237422);
INSERT INTO `article` VALUES (51, 82, 0, 0, 1, '', '测试', 'qiniu_202006270646057926763392.jpg?imageView2/1/w/800/h/800,', '', '', '', 100, 0, 0, 0, 0, '', 0, 2, 1595665479, 1593240402);
INSERT INTO `article` VALUES (52, 82, 0, 0, 1, '', '拍的聊天.上传功能可以的', 'qiniu_202006270647028605672715.jpg?imageView2/1/w/800/h/800,', '', '', '', 91, 3, 1, 0, 2, '', 0, 0, 1594056620, 1593240449);
INSERT INTO `article` VALUES (53, 69, 0, 0, 2, '', '测的峨', '', 'qiniu_202006270939242105916947.mp4?vframe/jpg/offset/1', 'qiniu_202006270939242105916947.mp4', '', 18, 0, 0, 0, 0, '', 0, 0, 1593256871, 1593250783);
INSERT INTO `article` VALUES (54, 90, 0, 0, 1, '', 'r', 'qiniu_202006271723564832821617.jpg?imageView2/1/w/800/h/800', '', '', '', 19, 10, 38, 0, 0, '', 0, 2, 1595665479, 1593278651);
INSERT INTO `article` VALUES (55, 26, 0, 0, 1, '', '今天的天空好美呀。有人看见了吗？没有的话我等会儿再问一问。', 'qiniu_202007021138395676734696.jpg?imageView2/1/w/800/h/800,', '', '', '', 10, 1, 3, 0, 1, '', 0, 2, 1595665479, 1593690025);
INSERT INTO `article` VALUES (56, 26, 0, 0, 1, '', '一次只能上传一张照片吗？照片在发布预览页面不显示缩略图吗？', 'qiniu_202007021203526263090074.jpg?imageView2/1/w/800/h/800,qiniu_202007021204066576795816.jpg?imageView2/1/w/800/h/800,qiniu_202007021204275902497432.jpg?imageView2/1/w/800/h/800,', '', '', '', 10, 1, 4, 0, 1, '', 0, 2, 1595665479, 1593691527);
INSERT INTO `article` VALUES (57, 82, 0, 0, 1, '', '美女一起吃饭的咯咯', 'qiniu_202007040307114157980863.jpg?imageView2/1/w/800/h/800,', '', '', '', 10, 0, 0, 0, 0, '', 0, 2, 1595665479, 1593832069);
INSERT INTO `article` VALUES (58, 69, 0, 0, 2, '', '2', '', 'qiniu_202007051438348608880251.mp4?vframe/jpg/offset/1', 'qiniu_202007051438348608880251.mp4', '', 15, 0, 7, 0, 0, '', 0, 0, 1597047581, 1593959936);
INSERT INTO `article` VALUES (59, 116, 19, 0, 1, '1', '1', 'qiniu_202007290720063509289615.jpg?imageView2/1/w/800/h/800', '', '', '', 0, 0, 0, 0, 0, '', 0, 2, 1596007207, 1596007207);
INSERT INTO `article` VALUES (60, 140, 19, 0, 1, '遇到好的好的', '国画山水', 'qiniu_202011200325220648136584.jpg?imageView2/1/w/800/h/800', '', '', '', 0, 0, 0, 0, 0, '', 0, 2, 1605842724, 1605842724);
INSERT INTO `article` VALUES (61, 5, 0, 0, 1, '', '', '', '', '', '', 0, 0, 0, 0, 0, '', 0, 2, 1607074868, 1607074868);
INSERT INTO `article` VALUES (62, 5, 0, 0, 1, '', '哈哈哈哈', '', '', '', '', 0, 0, 0, 0, 0, '', 0, 2, 1607074896, 1607074896);
INSERT INTO `article` VALUES (63, 5, 20, 0, 1, '', '测试多图上传', ',http://qingtingcun.youyacao.com/qiniu_202012041118312024857749.jpg', '', '', '', 0, 0, 0, 0, 0, '', 0, 2, 1607080781, 1607080781);
INSERT INTO `article` VALUES (64, 5, 20, 0, 1, '', '测试上传多图？', 'http://qingtingcun.youyacao.com/qiniu_202012041123195591233102.jpg,,http://qingtingcun.youyacao.com/qiniu_202012041123193572784755.png', '', '', '', 0, 0, 0, 0, 0, '', 0, 2, 1607081047, 1607081047);
INSERT INTO `article` VALUES (65, 5, 20, 0, 1, '', '测试一下', '', '', '', '', 0, 0, 0, 0, 0, '', 0, 2, 1607084300, 1607084300);
INSERT INTO `article` VALUES (66, 5, 20, 0, 1, '', '七夕今宵看碧霄，牵牛织女渡河桥。', 'http://qingtingcun.youyacao.com/qiniu_202012041229497310275207.jpg,http://qingtingcun.youyacao.com/qiniu_202012041229505041058407.jpg,http://qingtingcun.youyacao.com/qiniu_202012041229547761866823.jpg', '', '', '', 0, 0, 0, 0, 0, '', 0, 2, 1607085010, 1607085010);
INSERT INTO `article` VALUES (67, 5, 6, 0, 1, '', '我发个内容测试一下而已', '', '', '', '', 0, 0, 0, 0, 0, '', 0, 2, 1607085963, 1607085963);
INSERT INTO `article` VALUES (68, 4, 20, 0, 1, '', '哈哈哈哈', '', '', '', '', 0, 0, 0, 0, 0, '', 0, 2, 1607251523, 1607251523);
INSERT INTO `article` VALUES (69, 9, 6, 0, 1, '', '很好 不错', 'http://qingtingcun.youyacao.com/qiniu_202012061326076850973918.jpg', '', '', '', 0, 0, 0, 0, 0, '', 0, 2, 1607261199, 1607261199);
INSERT INTO `article` VALUES (70, 5, 20, 0, 1, '', '测试', 'http://qingtingcun.youyacao.com/qiniu_202012061750398078143210.jpg', '', '', '', 0, 0, 0, 0, 0, '', 0, 2, 1607277043, 1607277043);
INSERT INTO `article` VALUES (71, 9, 6, 0, 1, '', '我发布测试一下的', '', '', '', '', 0, 0, 0, 0, 0, '', 0, 2, 1607313928, 1607313928);
INSERT INTO `article` VALUES (72, 9, 3, 0, 1, '', '哈哈哈哈哈', '', '', '', '', 0, 0, 0, 0, 0, '', 0, 2, 1607320031, 1607320031);
INSERT INTO `article` VALUES (73, 9, 8, 0, 1, '', '测试测试', '', '', '', '', 0, 0, 0, 0, 0, '', 0, 2, 1607321656, 1607321656);
INSERT INTO `article` VALUES (74, 5, 20, 0, 1, '', '测试', 'http://qingtingcun.youyacao.com/qiniu_202012070621045965610628.png,http://qingtingcun.youyacao.com/qiniu_202012070621116997599198.png', '', '', '', 0, 0, 0, 0, 0, '', 0, 2, 1607322125, 1607322125);
INSERT INTO `article` VALUES (75, 5, 20, 0, 1, '', '测试一下上传', 'http://qingtingcun.youyacao.com/qiniu_202012070622506148836013.png', '', '', '', 0, 0, 0, 0, 0, '', 0, 2, 1607322187, 1607322187);
INSERT INTO `article` VALUES (76, 5, 19, 0, 1, '', '测试一下吧', '', '', '', '', 0, 0, 0, 0, 0, '', 0, 2, 1607322664, 1607322664);
INSERT INTO `article` VALUES (77, 5, 20, 0, 1, '', '略略略', 'http://qingtingcun.youyacao.com/qiniu_202012070647222962026867.jpg,http://qingtingcun.youyacao.com/qiniu_202012070647239402828362.png,http://qingtingcun.youyacao.com/qiniu_202012070647300447296527.png', '', '', '', 0, 0, 0, 0, 0, '', 0, 2, 1607323707, 1607323707);
INSERT INTO `article` VALUES (78, 5, 20, 0, 1, '', '图图犬', '', '', '', '', 0, 0, 0, 0, 0, '', 0, 2, 1607325051, 1607325051);
INSERT INTO `article` VALUES (79, 5, 20, 0, 1, '', '略略略', '', '', '', '', 0, 0, 0, 0, 0, '', 0, 2, 1607325264, 1607325264);
INSERT INTO `article` VALUES (80, 5, 19, 0, 1, '', '哈哈哈', 'http://qingtingcun.youyacao.com/qiniu_202012070718164686124787.jpg,http://qingtingcun.youyacao.com/qiniu_202012070718242578716634.png', '', '', '', 0, 0, 0, 0, 0, '', 0, 2, 1607325561, 1607325561);
INSERT INTO `article` VALUES (81, 9, 20, 0, 1, '', '就啊班服', 'http://qingtingcun.youyacao.com/qiniu_202012140727176594598563.jpg,http://qingtingcun.youyacao.com/qiniu_202012140727177357432158.jpg,http://qingtingcun.youyacao.com/qiniu_202012140727178237847063.jpg', '', '', '', 0, 0, 0, 0, 0, '', 0, 2, 1607930847, 1607930847);
INSERT INTO `article` VALUES (82, 9, 20, 0, 1, '', '图图', 'http://qingtingcun.youyacao.com/qiniu_202012140729125042947901.jpg', '', '', '', 0, 0, 0, 0, 0, '', 0, 2, 1607930958, 1607930958);
INSERT INTO `article` VALUES (83, 147, 20, 0, 1, '测试', '测试', 'qiniu_202012160601521100075169.png?imageView2/1/w/800/h/800', '', '', '', 0, 0, 0, 0, 0, '', 0, 2, 1608098512, 1608098512);
INSERT INTO `article` VALUES (84, 154, 0, 5, 3, '', '你好', '', '', '', '', 0, 0, 0, 0, 0, '', 0, 2, 1608455634, 1608455634);
INSERT INTO `article` VALUES (85, 154, 0, 5, 3, '', '测试', 'qiniu_202012200914237250636018.jpg?imageView2/1/w/800/h/800', '', '', '', 0, 0, 0, 0, 0, '', 0, 2, 1608455665, 1608455665);

-- ----------------------------
-- Table structure for category
-- ----------------------------
DROP TABLE IF EXISTS `category`;
CREATE TABLE `category`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '分类名称',
  `icon` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '图标',
  `level` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '深度',
  `pid` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '父级别',
  `sort` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '排序',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT 1 COMMENT '状态0:删除1:开启',
  `updated_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '更新时间',
  `created_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `pid`(`pid`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 21 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '分类表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of category
-- ----------------------------
INSERT INTO `category` VALUES (1, '游戏', '', 1, 0, 1, 1, 1586761177, 1585409552);
INSERT INTO `category` VALUES (2, '资讯', '', 1, 0, 1, 1, 1586231072, 1585409552);
INSERT INTO `category` VALUES (3, '密聊', '', 1, 0, 1, 1, 1586229164, 1585409552);
INSERT INTO `category` VALUES (4, '好货', '', 1, 0, 1, 1, 1586229233, 1585409552);
INSERT INTO `category` VALUES (5, '景图', '', 1, 0, 1, 1, 1586229273, 1585409552);
INSERT INTO `category` VALUES (6, '影音', '', 1, 0, 1, 1, 1586229278, 1585409552);
INSERT INTO `category` VALUES (7, '知寻', '', 1, 0, 1, 1, 1586229283, 1585409552);
INSERT INTO `category` VALUES (8, '吃喝', '', 1, 0, 1, 1, 1586229289, 1585409552);
INSERT INTO `category` VALUES (19, '测试11', '', 0, 1, 1, 1, 1586239626, 1586239626);
INSERT INTO `category` VALUES (20, '测试2', '', 0, 1, 0, 1, 1586243653, 1586243653);

-- ----------------------------
-- Table structure for cipher
-- ----------------------------
DROP TABLE IF EXISTS `cipher`;
CREATE TABLE `cipher`  (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `user_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '提交人ID',
  `code` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '卡密编码',
  `account_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '兑换账户类型',
  `amount` decimal(10, 2) NOT NULL DEFAULT 0.00 COMMENT '额度',
  `over_time` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '过期时间',
  `get_user_id` int(10) NOT NULL DEFAULT 0 COMMENT '兑换人user_id',
  `get_time` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '兑换时间',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '状态0删除1可用2已用',
  `updated_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '更新时间',
  `created_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `get_user_id`(`get_user_id`) USING BTREE,
  INDEX `code`(`code`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '卡密表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for collect
-- ----------------------------
DROP TABLE IF EXISTS `collect`;
CREATE TABLE `collect`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `type` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '分类1:短视频2图文3:直播',
  `user_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '关联user_id',
  `vid` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '关联作品ID',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT 1 COMMENT '状态0:取消收藏1:已收藏',
  `updated_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '更新时间',
  `created_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `user_vid`(`user_id`, `vid`) USING BTREE,
  INDEX `created_at`(`created_at`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 14 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '用户收藏表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of collect
-- ----------------------------
INSERT INTO `collect` VALUES (1, 2, 4, 52, 1, 1593264609, 1593264571);
INSERT INTO `collect` VALUES (2, 2, 69, 54, 0, 1593701584, 1593354726);
INSERT INTO `collect` VALUES (3, 2, 69, 32, 0, 1593359803, 1593359655);
INSERT INTO `collect` VALUES (4, 2, 69, 51, 0, 1593359943, 1593359942);
INSERT INTO `collect` VALUES (5, 2, 26, 52, 1, 1593690137, 1593690137);
INSERT INTO `collect` VALUES (6, 2, 26, 55, 1, 1593692060, 1593692060);
INSERT INTO `collect` VALUES (7, 2, 26, 32, 1, 1593692162, 1593692162);
INSERT INTO `collect` VALUES (8, 2, 69, 56, 1, 1593959439, 1593959439);
INSERT INTO `collect` VALUES (9, 2, 154, 1, 1, 1608369462, 1608286315);
INSERT INTO `collect` VALUES (10, 4, 1, 1, 1, 1608389254, 1608389254);
INSERT INTO `collect` VALUES (11, 4, 1, 2, 1, 1608389277, 1608389277);
INSERT INTO `collect` VALUES (12, 4, 9, 3, 0, 1608444509, 1608444462);
INSERT INTO `collect` VALUES (13, 4, 154, 5, 0, 1608455813, 1608455792);

-- ----------------------------
-- Table structure for comment
-- ----------------------------
DROP TABLE IF EXISTS `comment`;
CREATE TABLE `comment`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `type` tinyint(1) UNSIGNED NOT NULL DEFAULT 1 COMMENT '分类1:视频2图文',
  `vid` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '关联评论对象ID',
  `user_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '关联user_id',
  `content` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '评论内容',
  `like_num` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '点赞次数',
  `pid` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '回复关联评论ID',
  `comment_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '回复的评论id',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT 1 COMMENT '状态0:删除1:待审核2:审核通过',
  `updated_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '更新时间',
  `created_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `user_id`(`user_id`) USING BTREE,
  INDEX `type_vid`(`type`, `vid`) USING BTREE,
  INDEX `pid`(`pid`) USING BTREE,
  INDEX `created_at`(`created_at`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 486 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '用户评论表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of comment
-- ----------------------------
INSERT INTO `comment` VALUES (1, 1, 1964, 45, '不错', 1, 0, 0, 2, 1591925250, 1589066765);
INSERT INTO `comment` VALUES (2, 1, 1962, 57, '好的', 1, 0, 0, 2, 1590713741, 1590632483);
INSERT INTO `comment` VALUES (3, 1, 1966, 61, 'O(∩_∩)O哈哈~', 0, 0, 0, 2, 1590759034, 1590759034);
INSERT INTO `comment` VALUES (4, 1, 1966, 61, '不错吧', 0, 0, 0, 2, 1590759060, 1590759060);
INSERT INTO `comment` VALUES (5, 1, 1966, 16, '没有人评论吗。 有人可以发点视频', 0, 0, 0, 2, 1591029483, 1591029483);
INSERT INTO `comment` VALUES (6, 1, 1959, 16, '喂？', 0, 0, 0, 2, 1591029513, 1591029513);
INSERT INTO `comment` VALUES (7, 1, 1964, 63, '哈哈哈', 1, 0, 0, 2, 1591260204, 1591088318);
INSERT INTO `comment` VALUES (8, 2, 2, 69, '123', 0, 0, 0, 2, 1591715769, 1591715769);
INSERT INTO `comment` VALUES (9, 2, 2, 69, '666', 0, 0, 0, 2, 1591797976, 1591797976);
INSERT INTO `comment` VALUES (10, 2, 2, 69, '1', 0, 0, 0, 2, 1591799502, 1591799502);
INSERT INTO `comment` VALUES (11, 2, 2, 69, '滨海大道', 0, 0, 0, 2, 1591799710, 1591799710);
INSERT INTO `comment` VALUES (12, 2, 2, 69, '爱你哟', 0, 0, 0, 2, 1591799837, 1591799837);
INSERT INTO `comment` VALUES (13, 2, 2, 69, '?', 0, 0, 0, 2, 1591799850, 1591799850);
INSERT INTO `comment` VALUES (14, 2, 2, 69, '?', 0, 0, 0, 2, 1591799860, 1591799860);
INSERT INTO `comment` VALUES (15, 2, 2, 69, '666?', 0, 0, 0, 2, 1591799916, 1591799916);
INSERT INTO `comment` VALUES (16, 2, 1, 69, '???', 0, 0, 0, 2, 1591799983, 1591799983);
INSERT INTO `comment` VALUES (17, 2, 2, 69, '123', 0, 0, 0, 2, 1591974407, 1591974407);
INSERT INTO `comment` VALUES (18, 2, 3, 69, '?', 0, 0, 0, 2, 1592640769, 1592640769);
INSERT INTO `comment` VALUES (19, 2, 24, 69, '123', 0, 0, 0, 2, 1592746454, 1592746454);
INSERT INTO `comment` VALUES (20, 2, 6, 69, '123', 0, 0, 0, 2, 1592746624, 1592746624);
INSERT INTO `comment` VALUES (21, 2, 6, 69, '?', 0, 0, 0, 2, 1592746630, 1592746630);
INSERT INTO `comment` VALUES (22, 2, 6, 69, '?', 0, 0, 0, 2, 1592746638, 1592746638);
INSERT INTO `comment` VALUES (23, 2, 25, 69, '1', 1, 0, 0, 2, 1592838542, 1592748086);
INSERT INTO `comment` VALUES (24, 2, 27, 69, '123', 0, 0, 0, 2, 1592751268, 1592751268);
INSERT INTO `comment` VALUES (25, 2, 2, 69, '123?', 0, 0, 0, 2, 1592751822, 1592751822);
INSERT INTO `comment` VALUES (26, 2, 2, 69, '?', 0, 0, 0, 2, 1592751829, 1592751829);
INSERT INTO `comment` VALUES (27, 2, 6, 69, '123', 0, 0, 0, 2, 1592751941, 1592751941);
INSERT INTO `comment` VALUES (28, 2, 28, 82, '是可以正常发布评论的', 0, 0, 0, 2, 1592795609, 1592795609);
INSERT INTO `comment` VALUES (29, 2, 26, 82, '可以发布', 0, 0, 0, 2, 1592797286, 1592797286);
INSERT INTO `comment` VALUES (30, 2, 29, 69, '123', 1, 0, 0, 2, 1592811020, 1592804927);
INSERT INTO `comment` VALUES (31, 2, 26, 69, '?', 0, 0, 0, 2, 1592807712, 1592807712);
INSERT INTO `comment` VALUES (32, 2, 26, 69, '123', 0, 0, 0, 2, 1592807816, 1592807816);
INSERT INTO `comment` VALUES (33, 2, 29, 69, '123', 1, 0, 0, 2, 1592818739, 1592810963);
INSERT INTO `comment` VALUES (34, 2, 29, 69, '?', 1, 0, 0, 2, 1592811039, 1592811031);
INSERT INTO `comment` VALUES (35, 2, 29, 69, '?', 0, 0, 0, 2, 1592818753, 1592818753);
INSERT INTO `comment` VALUES (36, 2, 29, 69, '123', 0, 0, 0, 2, 1592831171, 1592831171);
INSERT INTO `comment` VALUES (37, 2, 29, 69, '?', 0, 0, 0, 2, 1592833972, 1592833972);
INSERT INTO `comment` VALUES (38, 2, 29, 69, '?', 0, 0, 0, 2, 1592834038, 1592834038);
INSERT INTO `comment` VALUES (39, 2, 28, 69, '123', 0, 0, 0, 2, 1592835882, 1592835882);
INSERT INTO `comment` VALUES (40, 2, 28, 69, '123', 1, 0, 0, 2, 1592836075, 1592835896);
INSERT INTO `comment` VALUES (41, 2, 28, 69, '???', 0, 0, 0, 2, 1592836087, 1592836087);
INSERT INTO `comment` VALUES (42, 2, 28, 69, '???', 0, 0, 0, 2, 1592836646, 1592836646);
INSERT INTO `comment` VALUES (43, 2, 28, 69, '???', 0, 28, 0, 2, 1592836784, 1592836784);
INSERT INTO `comment` VALUES (44, 2, 25, 69, '???', 0, 23, 0, 2, 1592836909, 1592836909);
INSERT INTO `comment` VALUES (45, 2, 25, 69, '?', 1, 23, 0, 2, 1592839762, 1592838401);
INSERT INTO `comment` VALUES (46, 2, 25, 69, '?', 0, 23, 0, 2, 1592839660, 1592839660);
INSERT INTO `comment` VALUES (47, 2, 26, 69, '66', 0, 29, 0, 2, 1592839785, 1592839785);
INSERT INTO `comment` VALUES (48, 2, 38, 69, '126', 0, 0, 0, 2, 1592919152, 1592919152);
INSERT INTO `comment` VALUES (49, 2, 38, 69, '123', 0, 48, 0, 2, 1592919729, 1592919729);
INSERT INTO `comment` VALUES (50, 1, 1960, 86, '兔兔', 0, 0, 0, 2, 1592920768, 1592920768);
INSERT INTO `comment` VALUES (51, 1, 1960, 86, '看看了', 0, 0, 0, 2, 1592921007, 1592921007);
INSERT INTO `comment` VALUES (52, 1, 1964, 86, '图图', 0, 0, 0, 2, 1592921027, 1592921027);
INSERT INTO `comment` VALUES (53, 1, 1964, 86, '图图', 0, 0, 0, 2, 1592921031, 1592921031);
INSERT INTO `comment` VALUES (54, 1, 1964, 86, '啊啊啊', 0, 0, 0, 2, 1592921070, 1592921070);
INSERT INTO `comment` VALUES (55, 1, 1964, 86, '来来来', 0, 0, 0, 2, 1592921265, 1592921265);
INSERT INTO `comment` VALUES (56, 1, 1964, 86, '兔兔也约有', 0, 0, 0, 2, 1592921295, 1592921295);
INSERT INTO `comment` VALUES (57, 1, 1964, 86, '不顺路', 0, 0, 0, 2, 1592921308, 1592921308);
INSERT INTO `comment` VALUES (58, 1, 256, 86, '需求的时候就可以去', 0, 0, 0, 2, 1592921408, 1592921408);
INSERT INTO `comment` VALUES (59, 1, 1960, 86, '爱了吗', 0, 0, 0, 2, 1592921428, 1592921428);
INSERT INTO `comment` VALUES (60, 1, 512, 83, '罗汉果', 0, 0, 0, 2, 1592922431, 1592922431);
INSERT INTO `comment` VALUES (61, 1, 1964, 83, '来咯哦哦', 0, 54, 0, 2, 1592923963, 1592923963);
INSERT INTO `comment` VALUES (62, 1, 1964, 83, '来咯哦哦', 0, 54, 0, 2, 1592924006, 1592924006);
INSERT INTO `comment` VALUES (63, 1, 1964, 83, '来咯哦哦', 0, 54, 0, 2, 1592924054, 1592924054);
INSERT INTO `comment` VALUES (64, 1, 1964, 83, '来咯哦哦', 0, 54, 0, 2, 1592924074, 1592924074);
INSERT INTO `comment` VALUES (65, 1, 1964, 83, '墨jn', 0, 54, 0, 2, 1592924100, 1592924100);
INSERT INTO `comment` VALUES (66, 2, 44, 69, '?', 0, 0, 0, 2, 1592924840, 1592924840);
INSERT INTO `comment` VALUES (67, 2, 44, 69, '?', 0, 66, 0, 2, 1592924846, 1592924846);
INSERT INTO `comment` VALUES (68, 2, 44, 69, '??', 0, 66, 0, 2, 1592924882, 1592924882);
INSERT INTO `comment` VALUES (69, 2, 44, 69, '?', 0, 66, 0, 2, 1592924976, 1592924970);
INSERT INTO `comment` VALUES (70, 2, 44, 69, '?', 0, 66, 0, 2, 1592925095, 1592925095);
INSERT INTO `comment` VALUES (71, 2, 47, 69, '123', 0, 0, 0, 2, 1592925851, 1592925851);
INSERT INTO `comment` VALUES (72, 2, 47, 69, '?', 0, 0, 0, 2, 1592926117, 1592926117);
INSERT INTO `comment` VALUES (73, 2, 46, 69, '?', 1, 0, 0, 2, 1592932133, 1592926154);
INSERT INTO `comment` VALUES (74, 2, 46, 69, '?', 1, 0, 0, 2, 1592932134, 1592926167);
INSERT INTO `comment` VALUES (75, 2, 46, 69, '?', 1, 0, 0, 2, 1592932135, 1592926172);
INSERT INTO `comment` VALUES (76, 2, 46, 82, '再评', 0, 0, 0, 2, 1592932144, 1592932144);
INSERT INTO `comment` VALUES (77, 1, 1961, 83, '凡心❤', 0, 0, 0, 2, 1593004385, 1593004385);
INSERT INTO `comment` VALUES (78, 1, 1961, 83, '许多葵', 0, 0, 0, 2, 1593004522, 1593004522);
INSERT INTO `comment` VALUES (79, 1, 1961, 83, '艾玛呀', 0, 0, 0, 2, 1593004537, 1593004537);
INSERT INTO `comment` VALUES (80, 1, 1961, 83, '哈哈', 0, 0, 0, 2, 1593004700, 1593004700);
INSERT INTO `comment` VALUES (81, 1, 1961, 83, '你死定了', 0, 0, 0, 2, 1593004934, 1593004934);
INSERT INTO `comment` VALUES (82, 1, 1961, 83, '还不行！！！', 0, 0, 0, 2, 1593005001, 1593005001);
INSERT INTO `comment` VALUES (83, 1, 1961, 83, '好难吖', 0, 0, 0, 2, 1593005080, 1593005080);
INSERT INTO `comment` VALUES (84, 1, 1962, 83, '米奇老鼠', 0, 0, 0, 2, 1593005176, 1593005176);
INSERT INTO `comment` VALUES (85, 1, 1962, 83, '好吧', 0, 2, 0, 2, 1593005197, 1593005197);
INSERT INTO `comment` VALUES (86, 1, 1963, 83, '嗨', 0, 0, 0, 2, 1593005260, 1593005260);
INSERT INTO `comment` VALUES (87, 1, 1963, 83, '回复一下，谢谢', 0, 86, 0, 2, 1593005278, 1593005278);
INSERT INTO `comment` VALUES (88, 1, 512, 83, '还是可以的', 0, 60, 0, 2, 1593005655, 1593005655);
INSERT INTO `comment` VALUES (89, 1, 512, 83, '不贵了', 0, 60, 0, 2, 1593005832, 1593005832);
INSERT INTO `comment` VALUES (90, 1, 256, 83, '嗨', 0, 58, 0, 2, 1593006928, 1593006928);
INSERT INTO `comment` VALUES (91, 1, 256, 83, '六七点', 0, 58, 0, 2, 1593006971, 1593006971);
INSERT INTO `comment` VALUES (92, 1, 256, 83, '嗨', 0, 58, 0, 2, 1593007119, 1593007119);
INSERT INTO `comment` VALUES (93, 1, 1965, 83, '桃花劫', 0, 0, 0, 2, 1593007909, 1593007909);
INSERT INTO `comment` VALUES (94, 1, 1965, 83, '还是什么？', 0, 93, 0, 2, 1593008150, 1593008150);
INSERT INTO `comment` VALUES (95, 1, 1965, 83, '还是可以接受你的', 0, 93, 0, 2, 1593008250, 1593008250);
INSERT INTO `comment` VALUES (96, 1, 1965, 83, '突突了没', 0, 93, 0, 2, 1593008648, 1593008648);
INSERT INTO `comment` VALUES (97, 1, 1965, 83, '真的是无语', 0, 93, 0, 2, 1593008701, 1593008701);
INSERT INTO `comment` VALUES (98, 1, 1965, 83, '怕是要翻水水', 0, 0, 0, 2, 1593008789, 1593008789);
INSERT INTO `comment` VALUES (99, 1, 1965, 83, '你好', 0, 98, 0, 2, 1593008853, 1593008853);
INSERT INTO `comment` VALUES (100, 1, 256, 83, '嗨起来', 0, 0, 90, 2, 1593009023, 1593009023);
INSERT INTO `comment` VALUES (101, 1, 256, 83, '又有问题了', 0, 0, 90, 2, 1593009148, 1593009148);
INSERT INTO `comment` VALUES (102, 1, 1963, 83, '嗨', 0, 86, 0, 2, 1593009298, 1593009298);
INSERT INTO `comment` VALUES (103, 1, 1963, 83, '你好', 0, 0, 102, 2, 1593009315, 1593009315);
INSERT INTO `comment` VALUES (104, 1, 512, 83, '有问题', 0, 60, 0, 2, 1593009539, 1593009539);
INSERT INTO `comment` VALUES (105, 1, 1965, 83, '还好吧', 0, 0, 95, 2, 1593009610, 1593009610);
INSERT INTO `comment` VALUES (106, 1, 1965, 83, '不是吧', 0, 0, 0, 2, 1593009699, 1593009699);
INSERT INTO `comment` VALUES (107, 1, 1963, 86, '不是吧', 0, 0, 87, 2, 1593009907, 1593009907);
INSERT INTO `comment` VALUES (108, 1, 1963, 86, '你好', 0, 0, 87, 2, 1593009919, 1593009919);
INSERT INTO `comment` VALUES (109, 1, 1963, 86, '嗨', 0, 103, 0, 2, 1593009926, 1593009926);
INSERT INTO `comment` VALUES (110, 1, 1963, 4, '132', 0, 103, 109, 2, 1593010051, 1593010051);
INSERT INTO `comment` VALUES (111, 1, 1972, 4, 'nihao a', 0, 0, 0, 2, 1593010084, 1593010084);
INSERT INTO `comment` VALUES (112, 1, 1972, 86, '嗨', 0, 111, 0, 2, 1593010104, 1593010104);
INSERT INTO `comment` VALUES (113, 1, 1972, 4, 'bushiba', 0, 111, 112, 2, 1593010128, 1593010128);
INSERT INTO `comment` VALUES (114, 1, 1972, 4, '无人问津的地方', 0, 111, 113, 2, 1593011095, 1593011095);
INSERT INTO `comment` VALUES (115, 1, 1972, 86, '试一下', 0, 0, 112, 2, 1593011112, 1593011112);
INSERT INTO `comment` VALUES (116, 1, 1972, 86, '嗨喽', 0, 0, 114, 2, 1593011132, 1593011132);
INSERT INTO `comment` VALUES (117, 1, 1972, 4, '不会吧', 0, 111, 112, 2, 1593011154, 1593011154);
INSERT INTO `comment` VALUES (118, 1, 1972, 86, '会的', 0, 111, 117, 2, 1593011231, 1593011231);
INSERT INTO `comment` VALUES (119, 1, 1972, 86, '终于可以了', 0, 111, 0, 2, 1593011255, 1593011255);
INSERT INTO `comment` VALUES (120, 1, 1972, 86, '嗨皮', 0, 111, 119, 2, 1593011264, 1593011264);
INSERT INTO `comment` VALUES (121, 1, 1972, 86, '??', 0, 0, 0, 2, 1593011561, 1593011561);
INSERT INTO `comment` VALUES (122, 1, 1972, 86, '还有就是这样的人了吗', 0, 0, 0, 2, 1593011818, 1593011818);
INSERT INTO `comment` VALUES (123, 1, 1972, 86, '略略略啦啦啦', 0, 0, 0, 2, 1593011981, 1593011981);
INSERT INTO `comment` VALUES (124, 1, 1972, 86, '不是吧我也觉得有点尴尬了', 0, 0, 0, 2, 1593012564, 1593012564);
INSERT INTO `comment` VALUES (125, 1, 1972, 86, 'Mon', 0, 0, 0, 2, 1593012717, 1593012717);
INSERT INTO `comment` VALUES (126, 1, 1964, 86, '巴巴爸爸妈妈', 0, 0, 0, 2, 1593012755, 1593012755);
INSERT INTO `comment` VALUES (127, 1, 1965, 86, '突突突', 0, 0, 0, 2, 1593012772, 1593012772);
INSERT INTO `comment` VALUES (128, 1, 1960, 86, 'LJL哦哦我屋头', 0, 0, 0, 2, 1593012894, 1593012894);
INSERT INTO `comment` VALUES (129, 1, 1960, 86, 'mommy也懂', 0, 0, 0, 2, 1593013082, 1593013082);
INSERT INTO `comment` VALUES (130, 1, 512, 86, '啦阿鲁', 0, 0, 0, 2, 1593013158, 1593013158);
INSERT INTO `comment` VALUES (131, 1, 512, 86, '测的本', 0, 0, 0, 2, 1593013250, 1593013250);
INSERT INTO `comment` VALUES (132, 1, 512, 86, '测的本', 0, 0, 0, 2, 1593013250, 1593013250);
INSERT INTO `comment` VALUES (133, 1, 512, 86, '测的本', 0, 0, 0, 2, 1593013250, 1593013250);
INSERT INTO `comment` VALUES (134, 1, 512, 86, '测的本', 0, 0, 0, 2, 1593013250, 1593013250);
INSERT INTO `comment` VALUES (135, 1, 512, 86, '测的本', 0, 0, 0, 2, 1593013251, 1593013251);
INSERT INTO `comment` VALUES (136, 1, 512, 86, '测的本', 0, 0, 0, 2, 1593013251, 1593013251);
INSERT INTO `comment` VALUES (137, 1, 1965, 86, '123', 0, 0, 0, 2, 1593013270, 1593013270);
INSERT INTO `comment` VALUES (138, 1, 768, 86, '沐浴露', 0, 0, 0, 2, 1593013288, 1593013288);
INSERT INTO `comment` VALUES (139, 1, 768, 86, '789654', 0, 0, 0, 2, 1593013342, 1593013342);
INSERT INTO `comment` VALUES (140, 1, 768, 86, '看看了', 0, 0, 0, 2, 1593013392, 1593013392);
INSERT INTO `comment` VALUES (141, 1, 768, 86, '要用微信', 0, 0, 0, 2, 1593013404, 1593013404);
INSERT INTO `comment` VALUES (142, 1, 1, 86, '哈哈哈', 0, 0, 0, 2, 1593013563, 1593013563);
INSERT INTO `comment` VALUES (143, 1, 1, 86, '德德玛', 0, 0, 0, 2, 1593013654, 1593013654);
INSERT INTO `comment` VALUES (144, 1, 1963, 86, '垃圾游戏，毁我青春', 0, 0, 0, 2, 1593013902, 1593013902);
INSERT INTO `comment` VALUES (145, 1, 1963, 86, 'www我摸', 0, 0, 0, 2, 1593013996, 1593013996);
INSERT INTO `comment` VALUES (146, 1, 1963, 86, '迦拉克隆', 0, 0, 0, 2, 1593014010, 1593014010);
INSERT INTO `comment` VALUES (147, 1, 1963, 86, 'TCL咳咳咳', 0, 0, 0, 2, 1593014042, 1593014042);
INSERT INTO `comment` VALUES (148, 1, 1963, 86, '1236698745', 0, 0, 0, 2, 1593014101, 1593014101);
INSERT INTO `comment` VALUES (149, 1, 1963, 86, '摸摸头发', 0, 0, 0, 2, 1593014126, 1593014126);
INSERT INTO `comment` VALUES (150, 1, 1968, 86, '哈哈哈姐姐我也可以?', 0, 0, 0, 2, 1593014387, 1593014387);
INSERT INTO `comment` VALUES (151, 1, 256, 86, '略略略', 0, 0, 0, 2, 1593014652, 1593014652);
INSERT INTO `comment` VALUES (152, 1, 256, 76, '啦啦啦', 0, 0, 0, 2, 1593016549, 1593016549);
INSERT INTO `comment` VALUES (153, 1, 256, 76, '突突了', 0, 58, 0, 2, 1593016561, 1593016561);
INSERT INTO `comment` VALUES (154, 1, 256, 76, '司机您好', 0, 58, 92, 2, 1593016571, 1593016571);
INSERT INTO `comment` VALUES (155, 2, 39, 26, '?', 1, 0, 0, 2, 1593237773, 1593237765);
INSERT INTO `comment` VALUES (156, 2, 52, 90, '?', 0, 0, 0, 2, 1593278336, 1593278336);
INSERT INTO `comment` VALUES (157, 1, 1962, 76, '啦啦啦', 0, 0, 0, 2, 1593338510, 1593338510);
INSERT INTO `comment` VALUES (158, 1, 1961, 75, 'jjj', 0, 0, 0, 2, 1593418215, 1593418215);
INSERT INTO `comment` VALUES (159, 1, 1962, 75, 'bjjj', 0, 0, 0, 2, 1593418533, 1593418533);
INSERT INTO `comment` VALUES (160, 1, 1962, 75, 'hhjn', 0, 0, 0, 2, 1593418742, 1593418742);
INSERT INTO `comment` VALUES (161, 1, 1975, 75, 'hjjgg', 0, 0, 0, 2, 1593418806, 1593418806);
INSERT INTO `comment` VALUES (162, 1, 1975, 75, 'vvbn', 0, 0, 0, 2, 1593418817, 1593418817);
INSERT INTO `comment` VALUES (163, 1, 1975, 75, 'jjbvn', 0, 161, 0, 2, 1593418824, 1593418824);
INSERT INTO `comment` VALUES (164, 1, 1975, 75, 'nmm', 0, 161, 163, 2, 1593418830, 1593418830);
INSERT INTO `comment` VALUES (165, 1, 1975, 75, '图兔兔', 0, 161, 161, 2, 1593418839, 1593418839);
INSERT INTO `comment` VALUES (166, 1, 1975, 75, '吴裕泰', 0, 161, 0, 2, 1593418948, 1593418948);
INSERT INTO `comment` VALUES (167, 1, 1975, 75, '莫有', 0, 161, 166, 2, 1593418956, 1593418956);
INSERT INTO `comment` VALUES (168, 1, 1975, 75, '哦呜UK', 0, 161, 0, 2, 1593418963, 1593418963);
INSERT INTO `comment` VALUES (169, 1, 1975, 75, '突突', 0, 161, 0, 2, 1593420183, 1593420183);
INSERT INTO `comment` VALUES (170, 1, 1975, 75, '图兔兔', 0, 161, 0, 2, 1593420241, 1593420241);
INSERT INTO `comment` VALUES (171, 1, 1975, 75, 'medem', 0, 161, 169, 2, 1593420333, 1593420333);
INSERT INTO `comment` VALUES (172, 1, 1961, 91, '发红包吧', 0, 83, 0, 2, 1593420750, 1593420750);
INSERT INTO `comment` VALUES (173, 1, 1961, 91, '回复v', 0, 83, 0, 2, 1593420856, 1593420856);
INSERT INTO `comment` VALUES (174, 1, 1961, 91, '感觉黄飞鸿', 0, 79, 0, 2, 1593421240, 1593421240);
INSERT INTO `comment` VALUES (175, 1, 1961, 91, '还好保驾护航', 0, 79, 0, 2, 1593421259, 1593421259);
INSERT INTO `comment` VALUES (176, 1, 1, 75, '魔图发给我', 0, 0, 0, 2, 1593421986, 1593421986);
INSERT INTO `comment` VALUES (177, 1, 1961, 91, '啾啾啾', 0, 0, 0, 2, 1593425005, 1593425005);
INSERT INTO `comment` VALUES (178, 1, 1975, 75, '啦啦啦', 0, 0, 0, 2, 1593426296, 1593426296);
INSERT INTO `comment` VALUES (179, 1, 1975, 75, '萝莉控', 0, 0, 0, 2, 1593426352, 1593426352);
INSERT INTO `comment` VALUES (180, 1, 1975, 75, '网易云', 0, 0, 0, 2, 1593426380, 1593426380);
INSERT INTO `comment` VALUES (181, 1, 1975, 75, '哦哟哟额', 0, 0, 0, 2, 1593426395, 1593426395);
INSERT INTO `comment` VALUES (182, 1, 1975, 75, '得到', 0, 0, 0, 2, 1593426401, 1593426401);
INSERT INTO `comment` VALUES (183, 1, 1975, 75, '默默', 0, 0, 0, 2, 1593426410, 1593426410);
INSERT INTO `comment` VALUES (184, 1, 1971, 75, '啦啦啦', 0, 0, 0, 2, 1593426540, 1593426540);
INSERT INTO `comment` VALUES (185, 1, 1971, 75, '玩游戏', 0, 0, 0, 2, 1593426570, 1593426570);
INSERT INTO `comment` VALUES (186, 1, 1972, 75, '噢噢噢', 0, 0, 0, 2, 1593427140, 1593427140);
INSERT INTO `comment` VALUES (187, 1, 1971, 75, '哦哦哦', 0, 0, 0, 2, 1593427192, 1593427192);
INSERT INTO `comment` VALUES (188, 1, 1971, 75, 'Melian', 0, 0, 0, 2, 1593427297, 1593427297);
INSERT INTO `comment` VALUES (189, 1, 1970, 75, '陌陌', 0, 0, 0, 2, 1593427361, 1593427361);
INSERT INTO `comment` VALUES (190, 1, 1970, 75, '需求', 0, 0, 0, 2, 1593427467, 1593427467);
INSERT INTO `comment` VALUES (191, 1, 1970, 91, '哈哈哈宝宝', 0, 0, 0, 2, 1593427656, 1593427656);
INSERT INTO `comment` VALUES (192, 1, 1970, 91, '好纠结', 0, 0, 0, 2, 1593427758, 1593427758);
INSERT INTO `comment` VALUES (193, 1, 1969, 86, '看看了', 0, 0, 0, 2, 1593441497, 1593441497);
INSERT INTO `comment` VALUES (194, 1, 1969, 86, '来来来', 0, 193, 0, 2, 1593441826, 1593441826);
INSERT INTO `comment` VALUES (195, 1, 1969, 86, '陌陌', 0, 193, 194, 2, 1593441832, 1593441832);
INSERT INTO `comment` VALUES (196, 1, 1969, 86, '要用微信', 0, 193, 0, 2, 1593441838, 1593441838);
INSERT INTO `comment` VALUES (197, 1, 1971, 86, '噢噢噢', 0, 0, 0, 2, 1593442225, 1593442225);
INSERT INTO `comment` VALUES (198, 1, 1971, 86, '噢噢噢不见了', 0, 0, 0, 2, 1593442418, 1593442418);
INSERT INTO `comment` VALUES (199, 1, 1971, 86, '呃呃呃', 0, 0, 0, 2, 1593442431, 1593442431);
INSERT INTO `comment` VALUES (200, 1, 1971, 86, '呃呃呃呃呃', 0, 0, 0, 2, 1593442444, 1593442444);
INSERT INTO `comment` VALUES (201, 1, 1971, 86, '本激素药', 0, 0, 0, 2, 1593442492, 1593442492);
INSERT INTO `comment` VALUES (202, 1, 1968, 86, '哪里去咋啊', 0, 0, 0, 2, 1593442997, 1593442997);
INSERT INTO `comment` VALUES (203, 1, 1968, 86, '得到了', 0, 0, 0, 2, 1593443013, 1593443013);
INSERT INTO `comment` VALUES (204, 1, 1968, 86, '佛祖开始', 0, 0, 0, 2, 1593443020, 1593443020);
INSERT INTO `comment` VALUES (205, 1, 1968, 86, '哦呜拉二胡', 0, 0, 0, 2, 1593443159, 1593443159);
INSERT INTO `comment` VALUES (206, 1, 1967, 86, '略略略', 0, 0, 0, 2, 1593443559, 1593443559);
INSERT INTO `comment` VALUES (207, 1, 1967, 86, '路测亲自', 0, 0, 0, 2, 1593443736, 1593443736);
INSERT INTO `comment` VALUES (208, 1, 1967, 86, '吴倩', 0, 0, 0, 2, 1593444017, 1593444017);
INSERT INTO `comment` VALUES (209, 1, 1967, 86, '太卡', 0, 0, 0, 2, 1593444094, 1593444094);
INSERT INTO `comment` VALUES (210, 1, 1967, 86, '123', 0, 0, 0, 2, 1593444128, 1593444128);
INSERT INTO `comment` VALUES (211, 1, 1967, 86, '去我家额', 0, 0, 0, 2, 1593444139, 1593444139);
INSERT INTO `comment` VALUES (212, 1, 1967, 86, '阿鲁', 0, 0, 0, 2, 1593444252, 1593444252);
INSERT INTO `comment` VALUES (213, 1, 1967, 86, '啊绿卡通', 0, 0, 0, 2, 1593444332, 1593444332);
INSERT INTO `comment` VALUES (214, 1, 1967, 86, '阿鲁我发扩大了', 0, 0, 0, 2, 1593444403, 1593444403);
INSERT INTO `comment` VALUES (215, 1, 1967, 86, '杀戮我饿', 0, 0, 0, 2, 1593444413, 1593444413);
INSERT INTO `comment` VALUES (216, 1, 1, 86, 'KKK', 0, 0, 0, 2, 1593526919, 1593526919);
INSERT INTO `comment` VALUES (217, 2, 54, 69, '?12226?????', 0, 0, 0, 2, 1593613632, 1593613582);
INSERT INTO `comment` VALUES (218, 2, 54, 69, '?', 0, 217, 0, 2, 1593613594, 1593613594);
INSERT INTO `comment` VALUES (219, 2, 54, 69, '?', 0, 218, 0, 2, 1593613617, 1593613617);
INSERT INTO `comment` VALUES (220, 1, 1960, 78, '哈哈哈哈哈', 0, 0, 0, 2, 1593673879, 1593673879);
INSERT INTO `comment` VALUES (221, 2, 55, 26, '这是在大武汉，好久没见过了', 0, 0, 0, 2, 1593690313, 1593690313);
INSERT INTO `comment` VALUES (222, 2, 46, 26, '???可以吗？', 1, 73, 0, 2, 1593691284, 1593691273);
INSERT INTO `comment` VALUES (223, 2, 55, 26, '天这么蓝、也是意外，真的挺好看的?', 0, 0, 0, 2, 1593691368, 1593691368);
INSERT INTO `comment` VALUES (224, 2, 55, 69, '?', 0, 0, 0, 2, 1593701250, 1593701250);
INSERT INTO `comment` VALUES (225, 2, 56, 82, '肯定可多个的呀?', 0, 0, 0, 2, 1593831969, 1593831969);
INSERT INTO `comment` VALUES (226, 2, 54, 69, '123', 0, 0, 0, 2, 1593940594, 1593940594);
INSERT INTO `comment` VALUES (227, 2, 54, 69, '456', 0, 0, 0, 2, 1593940940, 1593940940);
INSERT INTO `comment` VALUES (228, 2, 54, 69, '258', 0, 0, 0, 2, 1593940947, 1593940947);
INSERT INTO `comment` VALUES (229, 2, 54, 69, '258', 0, 0, 0, 2, 1593940955, 1593940955);
INSERT INTO `comment` VALUES (230, 2, 54, 69, '369', 0, 0, 0, 2, 1593941087, 1593941087);
INSERT INTO `comment` VALUES (231, 2, 54, 69, '2369856', 0, 217, 0, 2, 1593941094, 1593941094);
INSERT INTO `comment` VALUES (232, 2, 54, 69, '123', 0, 217, 0, 2, 1593941530, 1593941530);
INSERT INTO `comment` VALUES (233, 2, 54, 69, '456', 0, 217, 0, 2, 1593941541, 1593941541);
INSERT INTO `comment` VALUES (234, 2, 54, 69, '258', 0, 217, 0, 2, 1593941575, 1593941575);
INSERT INTO `comment` VALUES (235, 2, 54, 69, 'k', 0, 217, 0, 2, 1593941615, 1593941615);
INSERT INTO `comment` VALUES (236, 2, 54, 69, '369', 0, 234, 0, 2, 1593941625, 1593941625);
INSERT INTO `comment` VALUES (237, 2, 54, 69, '噜噜噜噜了', 0, 234, 0, 2, 1593941650, 1593941650);
INSERT INTO `comment` VALUES (238, 2, 54, 69, '噢噢噢哦哦', 0, 235, 0, 2, 1593941880, 1593941880);
INSERT INTO `comment` VALUES (239, 2, 54, 69, '99999', 0, 234, 0, 2, 1593951562, 1593951562);
INSERT INTO `comment` VALUES (240, 2, 54, 69, '3699999', 0, 235, 0, 2, 1593951689, 1593951689);
INSERT INTO `comment` VALUES (241, 2, 54, 69, '9666666', 0, 217, 0, 2, 1593952398, 1593952398);
INSERT INTO `comment` VALUES (242, 1, 1961, 76, '你好', 0, 83, 172, 2, 1593954994, 1593954994);
INSERT INTO `comment` VALUES (243, 2, 54, 69, '258369', 0, 217, 218, 2, 1593956778, 1593956778);
INSERT INTO `comment` VALUES (244, 2, 54, 69, '258', 0, 217, 234, 2, 1593956904, 1593956904);
INSERT INTO `comment` VALUES (245, 2, 54, 69, '666', 0, 217, 0, 2, 1593957215, 1593957215);
INSERT INTO `comment` VALUES (246, 2, 54, 69, '2', 0, 228, 0, 2, 1593957277, 1593957277);
INSERT INTO `comment` VALUES (247, 2, 54, 69, '3', 0, 228, 0, 2, 1593957282, 1593957282);
INSERT INTO `comment` VALUES (248, 2, 54, 69, '2.1', 0, 228, 246, 2, 1593957291, 1593957291);
INSERT INTO `comment` VALUES (249, 2, 54, 69, '2', 0, 0, 0, 2, 1593957346, 1593957346);
INSERT INTO `comment` VALUES (250, 2, 54, 69, '222', 0, 217, 0, 2, 1593957356, 1593957356);
INSERT INTO `comment` VALUES (251, 2, 54, 69, '3', 0, 228, 0, 2, 1593957364, 1593957364);
INSERT INTO `comment` VALUES (252, 2, 54, 69, '2', 0, 249, 0, 2, 1593957780, 1593957780);
INSERT INTO `comment` VALUES (253, 2, 54, 69, '2.1', 0, 249, 252, 2, 1593957800, 1593957800);
INSERT INTO `comment` VALUES (254, 2, 54, 69, '2.3', 0, 249, 253, 2, 1593962864, 1593962864);
INSERT INTO `comment` VALUES (255, 2, 54, 90, '2.4', 0, 249, 254, 2, 1593963046, 1593963046);
INSERT INTO `comment` VALUES (256, 2, 54, 69, '3.1', 0, 228, 0, 2, 1593963735, 1593963735);
INSERT INTO `comment` VALUES (257, 1, 1975, 4, '22', 0, 161, 170, 2, 1593963973, 1593963973);
INSERT INTO `comment` VALUES (258, 1, 1975, 4, '22', 0, 161, 170, 2, 1593964011, 1593964011);
INSERT INTO `comment` VALUES (259, 1, 1975, 4, '2', 0, 182, 0, 2, 1593964028, 1593964028);
INSERT INTO `comment` VALUES (260, 1, 1975, 4, '2.2', 0, 182, 259, 2, 1593964044, 1593964044);
INSERT INTO `comment` VALUES (261, 2, 54, 69, '2.3', 0, 249, 253, 2, 1593965960, 1593965960);
INSERT INTO `comment` VALUES (262, 2, 54, 69, '2.9', 0, 249, 255, 2, 1593965978, 1593965978);
INSERT INTO `comment` VALUES (263, 2, 54, 69, '3.9', 0, 249, 261, 2, 1593965998, 1593965998);
INSERT INTO `comment` VALUES (264, 2, 54, 69, '6.6', 0, 249, 255, 2, 1593966085, 1593966085);
INSERT INTO `comment` VALUES (265, 2, 54, 69, '合脚', 0, 249, 264, 2, 1593966232, 1593966232);
INSERT INTO `comment` VALUES (266, 2, 58, 69, '??2586?99?99999???', 0, 0, 0, 2, 1594048246, 1594048246);
INSERT INTO `comment` VALUES (267, 2, 58, 69, '???????', 0, 0, 0, 2, 1594048314, 1594048314);
INSERT INTO `comment` VALUES (268, 2, 58, 69, '?', 0, 267, 0, 2, 1594048321, 1594048321);
INSERT INTO `comment` VALUES (269, 2, 58, 69, '?', 0, 267, 268, 2, 1594048327, 1594048327);
INSERT INTO `comment` VALUES (270, 2, 58, 69, '?', 0, 267, 268, 2, 1594048334, 1594048334);
INSERT INTO `comment` VALUES (271, 2, 58, 69, '123', 0, 267, 0, 2, 1594048341, 1594048341);
INSERT INTO `comment` VALUES (272, 2, 58, 69, '???1236?6998552??', 0, 0, 0, 2, 1594048429, 1594048429);
INSERT INTO `comment` VALUES (273, 2, 56, 69, '?', 1, 0, 0, 2, 1594129787, 1594128351);
INSERT INTO `comment` VALUES (274, 2, 56, 69, '?', 0, 225, 0, 2, 1594128355, 1594128355);
INSERT INTO `comment` VALUES (275, 2, 56, 69, '?', 0, 225, 274, 2, 1594128363, 1594128363);
INSERT INTO `comment` VALUES (276, 1, 1960, 105, '哈哈', 0, 59, 0, 2, 1594475462, 1594475462);
INSERT INTO `comment` VALUES (277, 1, 232, 5, '123', 0, 0, 0, 2, 1607160421, 1607160421);
INSERT INTO `comment` VALUES (278, 1, 568, 5, '123123', 0, 0, 0, 2, 1607160456, 1607160456);
INSERT INTO `comment` VALUES (279, 1, 175, 5, '12312312', 0, 0, 0, 2, 1607160477, 1607160477);
INSERT INTO `comment` VALUES (280, 1, 332, 5, '123123', 0, 0, 0, 2, 1607160562, 1607160562);
INSERT INTO `comment` VALUES (281, 1, 750, 5, '123123123123', 0, 0, 0, 2, 1607160581, 1607160581);
INSERT INTO `comment` VALUES (282, 1, 1691, 5, '1', 0, 0, 0, 2, 1607160719, 1607160719);
INSERT INTO `comment` VALUES (283, 1, 1691, 5, '2323', 0, 0, 0, 2, 1607160724, 1607160724);
INSERT INTO `comment` VALUES (284, 1, 1691, 5, '123123123', 0, 0, 0, 2, 1607160727, 1607160727);
INSERT INTO `comment` VALUES (285, 1, 963, 5, '123123', 0, 0, 0, 2, 1607161063, 1607161063);
INSERT INTO `comment` VALUES (286, 1, 412, 5, '12123', 0, 0, 0, 2, 1607161244, 1607161244);
INSERT INTO `comment` VALUES (287, 1, 589, 5, '1231231', 0, 0, 0, 2, 1607161273, 1607161273);
INSERT INTO `comment` VALUES (288, 1, 589, 5, '123123123', 0, 0, 0, 2, 1607161276, 1607161276);
INSERT INTO `comment` VALUES (289, 1, 589, 5, '123123123', 0, 0, 0, 2, 1607161281, 1607161281);
INSERT INTO `comment` VALUES (290, 1, 1042, 5, '123123', 0, 0, 0, 2, 1607161361, 1607161361);
INSERT INTO `comment` VALUES (291, 1, 1042, 5, '123123123', 0, 0, 0, 2, 1607161364, 1607161364);
INSERT INTO `comment` VALUES (292, 1, 1486, 5, '123123', 0, 0, 0, 2, 1607162198, 1607162198);
INSERT INTO `comment` VALUES (293, 1, 1627, 5, '123', 0, 0, 0, 2, 1607162493, 1607162493);
INSERT INTO `comment` VALUES (294, 1, 898, 5, '12312', 0, 0, 0, 2, 1607162515, 1607162515);
INSERT INTO `comment` VALUES (295, 1, 1535, 5, '123', 0, 0, 0, 2, 1607162577, 1607162577);
INSERT INTO `comment` VALUES (296, 1, 1535, 5, '123', 0, 0, 0, 2, 1607162580, 1607162580);
INSERT INTO `comment` VALUES (297, 1, 1556, 5, '123', 0, 0, 0, 2, 1607162592, 1607162592);
INSERT INTO `comment` VALUES (298, 1, 1122, 5, '123', 0, 0, 0, 2, 1607162610, 1607162610);
INSERT INTO `comment` VALUES (299, 1, 444, 5, '123123', 0, 0, 0, 2, 1607162665, 1607162665);
INSERT INTO `comment` VALUES (300, 1, 459, 5, '123123', 0, 0, 0, 2, 1607162676, 1607162676);
INSERT INTO `comment` VALUES (301, 1, 192, 5, '123', 0, 0, 0, 2, 1607162689, 1607162689);
INSERT INTO `comment` VALUES (302, 1, 192, 5, '123123', 0, 0, 0, 2, 1607162691, 1607162691);
INSERT INTO `comment` VALUES (303, 1, 192, 5, '123123123', 0, 0, 0, 2, 1607162694, 1607162694);
INSERT INTO `comment` VALUES (304, 1, 622, 5, '123123123', 0, 0, 0, 2, 1607162771, 1607162771);
INSERT INTO `comment` VALUES (305, 1, 622, 5, '123123123', 0, 0, 0, 2, 1607162776, 1607162776);
INSERT INTO `comment` VALUES (306, 1, 622, 5, '123123', 0, 0, 0, 2, 1607162780, 1607162780);
INSERT INTO `comment` VALUES (307, 1, 1624, 5, '123123', 0, 0, 0, 2, 1607162910, 1607162910);
INSERT INTO `comment` VALUES (308, 1, 1624, 5, '123123', 0, 0, 0, 2, 1607162914, 1607162914);
INSERT INTO `comment` VALUES (309, 1, 377, 5, '123123123', 0, 0, 0, 2, 1607162926, 1607162926);
INSERT INTO `comment` VALUES (310, 1, 377, 5, '1231231231231123123123123123123123sdfgdfsgdfsgdfgdfsgdfsgdfsgfdg', 0, 0, 0, 2, 1607162935, 1607162935);
INSERT INTO `comment` VALUES (311, 1, 71, 5, '1231231231231231fdsgdsfgdfsgdsfgdsfgfdsgfdsgdfsgdfsgfdg', 0, 0, 0, 2, 1607162973, 1607162973);
INSERT INTO `comment` VALUES (312, 1, 71, 5, 'dsfgfdsgsdfgdsfgdfsgdfgdfg234234234234234234234234234234234234234234234234234234', 0, 0, 0, 2, 1607162984, 1607162984);
INSERT INTO `comment` VALUES (313, 1, 239, 5, '23423423434234234234234234234234234243234234234234234234234234234234234234234', 0, 0, 0, 2, 1607163060, 1607163060);
INSERT INTO `comment` VALUES (314, 1, 1388, 5, '123123123123123123123123123123123123123123123123123123123123123', 0, 0, 0, 2, 1607163249, 1607163249);
INSERT INTO `comment` VALUES (315, 1, 1708, 5, '1231231231231231231231231231231231231231231231231231231', 0, 0, 0, 2, 1607163313, 1607163313);
INSERT INTO `comment` VALUES (316, 1, 1220, 5, '123123123123123123123123123123123123123123123123123123', 0, 0, 0, 2, 1607163451, 1607163451);
INSERT INTO `comment` VALUES (317, 1, 1296, 5, 'word-wrap:&lt;string&gt; break-word | normal | anywhere. 对 Weex 来说 anywhere 表示在以字符为最小元素做截断换行，其它值或不指定该属性，都以英文单词为单位进行换行。', 0, 0, 0, 2, 1607163557, 1607163557);
INSERT INTO `comment` VALUES (318, 1, 386, 5, 'comment-contentcomment-contentcomment-contentcomment-contentcomment-contentcomment-contentcomment-contentcomment-contentcomment-content', 0, 0, 0, 2, 1607163621, 1607163621);
INSERT INTO `comment` VALUES (319, 1, 918, 5, 'word-wrap: anywhere;		word-wrap: anywhere;		word-wrap: anywhere;		word-wrap: anywhere;		word-wrap: anywhere;		word-wrap: anywhere;', 0, 0, 0, 2, 1607163656, 1607163656);
INSERT INTO `comment` VALUES (320, 1, 918, 5, 'word-wrap:&lt;string&gt; break-word | normal | anywhere. 对 Weex 来说 anywhere 表示在以字符为最小元素做截断换行，其它值或不指定该属性，都以英文单词为单位进行换行。', 0, 0, 0, 2, 1607163665, 1607163665);
INSERT INTO `comment` VALUES (321, 1, 918, 5, '文本类组件共享一些通用样式, 这类组件目前包括 &lt;text&gt;、&lt;input&gt;和&lt;richtext&gt;\n#', 0, 0, 0, 2, 1607163675, 1607163675);
INSERT INTO `comment` VALUES (322, 1, 1300, 5, '文本类组件共享一些通用样式, 这类组件目前包括 &lt;text&gt;、&lt;input&gt;和&lt;richtext&gt;\n#', 0, 0, 0, 2, 1607163700, 1607163700);
INSERT INTO `comment` VALUES (323, 1, 1300, 5, 'word-wrap:&lt;string&gt; break-word | normal | anywhere. 对 Weex 来说 anywhere 表示在以字符为最小元素做截断换行，其它值或不指定该属性，都以英文单词为单位进行换行。', 0, 0, 0, 2, 1607163716, 1607163716);
INSERT INTO `comment` VALUES (324, 1, 598, 5, 'word-wrap:&lt;string&gt; break-word | normal | anywhere. 对 Weex 来说 anywhere 表示在以字符为最小元素做截断换行，其它值或不指定该属性，都以英文单词为单位进行换行。', 0, 0, 0, 2, 1607163771, 1607163771);
INSERT INTO `comment` VALUES (325, 1, 598, 5, '12312312312312312312313123123123123123123123123123123123132', 0, 0, 0, 2, 1607163916, 1607163916);
INSERT INTO `comment` VALUES (326, 1, 1307, 5, 'word-wrap:&lt;string&gt; break-word | normal | anywhere. 对 Weex 来说 anywhere 表示在以字符为最小元素做截断换行，其它值或不指定该属性，都以英文单词为单位进行换行。', 0, 0, 0, 2, 1607164009, 1607164009);
INSERT INTO `comment` VALUES (327, 1, 1525, 5, 'word-wrap:&lt;string&gt; break-word | normal | anywhere. 对 Weex 来说 anywhere 表示在以字符为最小元素做截断换行，其它值或不指定该属性，都以英文单词为单位进行换行。', 0, 0, 0, 2, 1607164045, 1607164045);
INSERT INTO `comment` VALUES (328, 1, 1596, 5, '123123', 0, 0, 0, 2, 1607164153, 1607164153);
INSERT INTO `comment` VALUES (329, 1, 1594, 5, '123123123', 0, 0, 0, 2, 1607164191, 1607164191);
INSERT INTO `comment` VALUES (330, 1, 1594, 5, '123123123', 0, 0, 0, 2, 1607164197, 1607164197);
INSERT INTO `comment` VALUES (331, 1, 1780, 5, '123123', 0, 0, 0, 2, 1607164232, 1607164232);
INSERT INTO `comment` VALUES (332, 1, 1912, 5, '123123', 0, 0, 0, 2, 1607164245, 1607164245);
INSERT INTO `comment` VALUES (333, 1, 291, 5, '123123123', 0, 0, 0, 2, 1607164348, 1607164348);
INSERT INTO `comment` VALUES (334, 1, 163, 5, '123123', 0, 0, 0, 2, 1607164393, 1607164393);
INSERT INTO `comment` VALUES (335, 1, 219, 5, '123123', 0, 0, 0, 2, 1607164412, 1607164412);
INSERT INTO `comment` VALUES (336, 1, 986, 5, 'word-wrap:&lt;string&gt; break-word | normal | anywhere. 对 Weex 来说 anywhere 表示在以字符为最小元素做截断换行，其它值或不指定该属性，都以英文单词为单位进行换行。', 0, 0, 0, 2, 1607164457, 1607164457);
INSERT INTO `comment` VALUES (337, 1, 1442, 5, 'word-wrap:&lt;string&gt; break-word | normal | anywhere. 对 Weex 来说 anywhere 表示在以字符为最小元素做截断换行，其它值或不指定该属性，都以英文单词为单位进行换行。', 0, 0, 0, 2, 1607164493, 1607164493);
INSERT INTO `comment` VALUES (338, 1, 1765, 5, 'word-wrap:&lt;string&gt; break-word | normal | anywhere. 对 Weex 来说 anywhere 表示在以字符为最小元素做截断换行，其它值或不指定该属性，都以英文单词为单位进行换行。', 0, 0, 0, 2, 1607164519, 1607164519);
INSERT INTO `comment` VALUES (339, 1, 1320, 5, 'word-wrap:&lt;string&gt; break-word | normal | anywhere. 对 Weex 来说 anywhere 表示在以字符为最小元素做截断换行，其它值或不指定该属性，都以英文单词为单位进行换行。', 0, 0, 0, 2, 1607164539, 1607164539);
INSERT INTO `comment` VALUES (340, 1, 16, 5, 'flex: 1;		flex: 1;		flex: 1;		flex: 1;		flex: 1;		flex: 1;		flex: 1;', 0, 0, 0, 2, 1607164606, 1607164606);
INSERT INTO `comment` VALUES (341, 1, 470, 5, 'word-wrap:&lt;string&gt; break-word | normal | anywhere. 对 Weex 来说 anywhere 表示在以字符为最小元素做截断换行，其它值或不指定该属性，都以英文单词为单位进行换行。', 0, 0, 0, 2, 1607164624, 1607164624);
INSERT INTO `comment` VALUES (342, 1, 483, 5, '123123', 0, 0, 0, 2, 1607164757, 1607164757);
INSERT INTO `comment` VALUES (343, 1, 893, 5, '123123123123', 0, 0, 0, 2, 1607164772, 1607164772);
INSERT INTO `comment` VALUES (344, 1, 1448, 5, '123123123', 0, 0, 0, 2, 1607164785, 1607164785);
INSERT INTO `comment` VALUES (345, 1, 823, 5, '23123', 0, 0, 0, 2, 1607164801, 1607164801);
INSERT INTO `comment` VALUES (346, 1, 584, 5, 'word-wrap:&lt;string&gt; break-word | normal | anywhere. 对 Weex 来说 anywhere 表示在以字符为最小元素做截断换行，其它值或不指定该属性，都以英文单词为单位进行换行。', 0, 0, 0, 2, 1607164899, 1607164899);
INSERT INTO `comment` VALUES (347, 1, 363, 5, 'word-wrap:&lt;string&gt; break-word | normal | anywhere. 对 Weex 来说 anywhere 表示在以字符为最小元素做截断换行，其它值或不指定该属性，都以英文单词为单位进行换行。', 0, 0, 0, 2, 1607164954, 1607164954);
INSERT INTO `comment` VALUES (348, 1, 1120, 5, 'background-color: #007AFF;		background-color: #007AFF;		background-color: #007AFF;		background-color: #007AFF;		background-color: #007AFF;', 0, 0, 0, 2, 1607165011, 1607165011);
INSERT INTO `comment` VALUES (349, 1, 1120, 5, 'word-wrap:&lt;string&gt; break-word | normal | anywhere. 对 Weex 来说 anywhere 表示在以字符为最小元素做截断换行，其它值或不指定该属性，都以英文单词为单位进行换行。', 0, 0, 0, 2, 1607165022, 1607165022);
INSERT INTO `comment` VALUES (350, 1, 753, 5, 'word-wrap:&lt;string&gt; break-word | normal | anywhere. 对 Weex 来说 anywhere 表示在以字符为最小元素做截断换行，其它值或不指定该属性，都以英文单词为单位进行换行。', 0, 0, 0, 2, 1607165042, 1607165042);
INSERT INTO `comment` VALUES (351, 1, 1178, 5, 'word-wrap:&lt;string&gt; break-word | normal | anywhere. 对 Weex 来说 anywhere 表示在以字符为最小元素做截断换行，其它值或不指定该属性，都以英文单词为单位进行换行。', 0, 0, 0, 2, 1607165081, 1607165081);
INSERT INTO `comment` VALUES (352, 1, 1182, 5, '123123', 0, 0, 0, 2, 1607165449, 1607165449);
INSERT INTO `comment` VALUES (353, 1, 1174, 5, '123', 0, 0, 0, 2, 1607165470, 1607165470);
INSERT INTO `comment` VALUES (354, 1, 549, 5, '123', 0, 0, 0, 2, 1607165485, 1607165485);
INSERT INTO `comment` VALUES (355, 1, 549, 5, '123123123123', 0, 0, 0, 2, 1607165487, 1607165487);
INSERT INTO `comment` VALUES (356, 1, 633, 5, '123123', 0, 0, 0, 2, 1607165744, 1607165744);
INSERT INTO `comment` VALUES (357, 1, 1105, 5, '12313123', 0, 0, 0, 2, 1607165834, 1607165834);
INSERT INTO `comment` VALUES (358, 1, 1820, 5, '123123', 0, 0, 0, 2, 1607165877, 1607165877);
INSERT INTO `comment` VALUES (359, 1, 237, 5, '123123', 0, 0, 0, 2, 1607165981, 1607165981);
INSERT INTO `comment` VALUES (360, 1, 1184, 5, '123123', 0, 0, 0, 2, 1607166019, 1607166019);
INSERT INTO `comment` VALUES (361, 1, 1112, 5, '123', 0, 0, 0, 2, 1607166032, 1607166032);
INSERT INTO `comment` VALUES (362, 1, 1112, 5, '123123123', 0, 0, 0, 2, 1607166037, 1607166037);
INSERT INTO `comment` VALUES (363, 1, 1112, 5, '123123123', 0, 0, 0, 2, 1607166040, 1607166040);
INSERT INTO `comment` VALUES (364, 1, 172, 5, '123', 0, 0, 0, 2, 1607166105, 1607166105);
INSERT INTO `comment` VALUES (365, 1, 172, 5, '12123', 0, 0, 0, 2, 1607166108, 1607166108);
INSERT INTO `comment` VALUES (366, 1, 797, 5, '123', 0, 0, 0, 2, 1607166139, 1607166139);
INSERT INTO `comment` VALUES (367, 1, 797, 5, '123123', 0, 0, 0, 2, 1607166141, 1607166141);
INSERT INTO `comment` VALUES (368, 1, 797, 5, '123123', 0, 0, 0, 2, 1607166145, 1607166145);
INSERT INTO `comment` VALUES (369, 1, 797, 5, '123123', 0, 0, 0, 2, 1607166148, 1607166148);
INSERT INTO `comment` VALUES (370, 1, 1075, 5, '123', 0, 0, 0, 2, 1607166208, 1607166208);
INSERT INTO `comment` VALUES (371, 1, 1075, 5, '123123', 0, 0, 0, 2, 1607166210, 1607166210);
INSERT INTO `comment` VALUES (372, 1, 1075, 5, '123123132', 0, 0, 0, 2, 1607166213, 1607166213);
INSERT INTO `comment` VALUES (373, 1, 1075, 5, '123123123', 0, 0, 0, 2, 1607166216, 1607166216);
INSERT INTO `comment` VALUES (374, 1, 1090, 5, '123123123', 0, 0, 0, 2, 1607166279, 1607166279);
INSERT INTO `comment` VALUES (375, 1, 1090, 5, '123123123', 0, 0, 0, 2, 1607166281, 1607166281);
INSERT INTO `comment` VALUES (376, 1, 564, 5, '123123', 0, 0, 0, 2, 1607166380, 1607166380);
INSERT INTO `comment` VALUES (377, 1, 564, 5, '123123', 0, 0, 0, 2, 1607166383, 1607166383);
INSERT INTO `comment` VALUES (378, 1, 564, 5, '123123', 0, 0, 0, 2, 1607166387, 1607166387);
INSERT INTO `comment` VALUES (379, 1, 564, 5, '123123', 0, 0, 0, 2, 1607166390, 1607166390);
INSERT INTO `comment` VALUES (380, 1, 853, 5, '1', 0, 0, 0, 2, 1607166569, 1607166569);
INSERT INTO `comment` VALUES (381, 1, 853, 5, '2', 0, 0, 0, 2, 1607166571, 1607166571);
INSERT INTO `comment` VALUES (382, 1, 853, 5, '3', 0, 0, 0, 2, 1607166573, 1607166573);
INSERT INTO `comment` VALUES (383, 1, 853, 5, '4', 0, 0, 0, 2, 1607166575, 1607166575);
INSERT INTO `comment` VALUES (384, 1, 853, 5, '5', 0, 0, 0, 2, 1607166579, 1607166579);
INSERT INTO `comment` VALUES (385, 1, 853, 5, '6', 0, 0, 0, 2, 1607166581, 1607166581);
INSERT INTO `comment` VALUES (386, 1, 853, 5, '7', 0, 0, 0, 2, 1607166584, 1607166584);
INSERT INTO `comment` VALUES (387, 1, 545, 5, '```', 0, 0, 0, 2, 1607166649, 1607166649);
INSERT INTO `comment` VALUES (388, 1, 545, 5, '111', 0, 0, 0, 2, 1607166652, 1607166652);
INSERT INTO `comment` VALUES (389, 1, 545, 5, '222', 0, 0, 0, 2, 1607166654, 1607166654);
INSERT INTO `comment` VALUES (390, 1, 545, 5, '333', 0, 0, 0, 2, 1607166657, 1607166657);
INSERT INTO `comment` VALUES (391, 1, 545, 5, '444', 0, 0, 0, 2, 1607166660, 1607166660);
INSERT INTO `comment` VALUES (392, 1, 809, 5, '123', 0, 0, 0, 2, 1607166724, 1607166724);
INSERT INTO `comment` VALUES (393, 1, 69, 5, '123', 0, 0, 0, 2, 1607166748, 1607166748);
INSERT INTO `comment` VALUES (394, 1, 1106, 5, '1231', 0, 0, 0, 2, 1607166803, 1607166803);
INSERT INTO `comment` VALUES (395, 1, 1690, 5, '123', 0, 0, 0, 2, 1607166901, 1607166901);
INSERT INTO `comment` VALUES (396, 1, 1038, 5, '123', 0, 0, 0, 2, 1607166935, 1607166935);
INSERT INTO `comment` VALUES (397, 1, 1038, 5, '设置全屏时视频的方向，不指定则根据宽高比自动判断。有效值为 0（正常竖向）, 90（屏幕逆时针90度）, -90（屏幕顺时针90度）', 0, 0, 0, 2, 1607166962, 1607166962);
INSERT INTO `comment` VALUES (398, 1, 1049, 5, '123', 0, 0, 0, 2, 1607167409, 1607167409);
INSERT INTO `comment` VALUES (399, 1, 1728, 5, '123', 0, 0, 0, 2, 1607167443, 1607167443);
INSERT INTO `comment` VALUES (400, 1, 1661, 5, '123', 0, 0, 0, 2, 1607167467, 1607167467);
INSERT INTO `comment` VALUES (401, 1, 8, 5, '123', 0, 0, 0, 2, 1607167520, 1607167520);
INSERT INTO `comment` VALUES (402, 1, 689, 5, '123321', 0, 0, 0, 2, 1607167552, 1607167552);
INSERT INTO `comment` VALUES (403, 1, 1140, 5, '123', 0, 0, 0, 2, 1607167620, 1607167620);
INSERT INTO `comment` VALUES (404, 1, 1140, 5, '123123', 0, 0, 0, 2, 1607167624, 1607167624);
INSERT INTO `comment` VALUES (405, 1, 370, 5, '123123', 0, 0, 0, 2, 1607167656, 1607167656);
INSERT INTO `comment` VALUES (406, 1, 533, 5, '11', 0, 0, 0, 2, 1607167771, 1607167771);
INSERT INTO `comment` VALUES (407, 1, 533, 5, '22', 0, 0, 0, 2, 1607167773, 1607167773);
INSERT INTO `comment` VALUES (408, 1, 533, 5, '33', 0, 0, 0, 2, 1607167774, 1607167774);
INSERT INTO `comment` VALUES (409, 1, 533, 5, '44', 0, 0, 0, 2, 1607167776, 1607167776);
INSERT INTO `comment` VALUES (410, 1, 533, 5, '55', 0, 0, 0, 2, 1607167778, 1607167778);
INSERT INTO `comment` VALUES (411, 1, 533, 5, '66', 0, 0, 0, 2, 1607167781, 1607167781);
INSERT INTO `comment` VALUES (412, 1, 533, 5, '77', 0, 0, 0, 2, 1607167783, 1607167783);
INSERT INTO `comment` VALUES (413, 1, 533, 5, '88', 0, 0, 0, 2, 1607167784, 1607167784);
INSERT INTO `comment` VALUES (414, 1, 533, 5, '99', 0, 0, 0, 2, 1607167786, 1607167786);
INSERT INTO `comment` VALUES (415, 1, 533, 5, '00', 0, 0, 0, 2, 1607167787, 1607167787);
INSERT INTO `comment` VALUES (416, 1, 533, 5, '111', 0, 0, 0, 2, 1607167793, 1607167793);
INSERT INTO `comment` VALUES (417, 1, 533, 5, '2222', 0, 0, 0, 2, 1607167807, 1607167807);
INSERT INTO `comment` VALUES (418, 1, 431, 5, '1', 0, 0, 0, 2, 1607167865, 1607167865);
INSERT INTO `comment` VALUES (419, 1, 431, 5, '2', 0, 0, 0, 2, 1607167866, 1607167866);
INSERT INTO `comment` VALUES (420, 1, 431, 5, '3', 0, 0, 0, 2, 1607167868, 1607167868);
INSERT INTO `comment` VALUES (421, 1, 431, 5, '4', 0, 0, 0, 2, 1607167870, 1607167870);
INSERT INTO `comment` VALUES (422, 1, 431, 5, '5', 0, 0, 0, 2, 1607167874, 1607167874);
INSERT INTO `comment` VALUES (423, 1, 431, 5, '6', 0, 0, 0, 2, 1607167877, 1607167877);
INSERT INTO `comment` VALUES (424, 1, 431, 5, '7', 0, 0, 0, 2, 1607167879, 1607167879);
INSERT INTO `comment` VALUES (425, 1, 431, 5, '8', 0, 0, 0, 2, 1607167881, 1607167881);
INSERT INTO `comment` VALUES (426, 1, 431, 5, '9', 0, 0, 0, 2, 1607167882, 1607167882);
INSERT INTO `comment` VALUES (427, 1, 431, 5, '001', 0, 0, 0, 2, 1607167893, 1607167893);
INSERT INTO `comment` VALUES (428, 1, 431, 5, '111', 0, 0, 0, 2, 1607167895, 1607167895);
INSERT INTO `comment` VALUES (429, 1, 431, 5, '222', 0, 0, 0, 2, 1607167897, 1607167897);
INSERT INTO `comment` VALUES (430, 1, 1209, 5, '1', 0, 0, 0, 2, 1607167935, 1607167935);
INSERT INTO `comment` VALUES (431, 1, 1209, 5, '2', 0, 0, 0, 2, 1607167937, 1607167937);
INSERT INTO `comment` VALUES (432, 1, 1209, 5, '3', 0, 0, 0, 2, 1607167939, 1607167939);
INSERT INTO `comment` VALUES (433, 1, 1209, 5, '4', 0, 0, 0, 2, 1607167940, 1607167940);
INSERT INTO `comment` VALUES (434, 1, 1209, 5, '5', 0, 0, 0, 2, 1607167942, 1607167942);
INSERT INTO `comment` VALUES (435, 1, 1209, 5, '6', 0, 0, 0, 2, 1607167944, 1607167944);
INSERT INTO `comment` VALUES (436, 1, 1209, 5, '7', 0, 0, 0, 2, 1607167945, 1607167945);
INSERT INTO `comment` VALUES (437, 1, 1209, 5, '8', 0, 0, 0, 2, 1607167947, 1607167947);
INSERT INTO `comment` VALUES (438, 1, 1209, 5, '9', 0, 0, 0, 2, 1607167949, 1607167949);
INSERT INTO `comment` VALUES (439, 1, 1209, 5, '10', 0, 0, 0, 2, 1607167951, 1607167951);
INSERT INTO `comment` VALUES (440, 1, 1209, 5, '11', 0, 0, 0, 2, 1607167953, 1607167953);
INSERT INTO `comment` VALUES (441, 1, 1209, 5, '12', 0, 0, 0, 2, 1607167957, 1607167957);
INSERT INTO `comment` VALUES (442, 1, 1209, 5, '13', 0, 0, 0, 2, 1607167959, 1607167959);
INSERT INTO `comment` VALUES (443, 1, 899, 5, '123', 0, 0, 0, 2, 1607167985, 1607167985);
INSERT INTO `comment` VALUES (444, 1, 899, 5, '1', 0, 0, 0, 2, 1607167987, 1607167987);
INSERT INTO `comment` VALUES (445, 1, 899, 5, '1', 0, 0, 0, 2, 1607167988, 1607167988);
INSERT INTO `comment` VALUES (446, 1, 899, 5, '11', 0, 0, 0, 2, 1607167988, 1607167988);
INSERT INTO `comment` VALUES (447, 1, 899, 5, '111', 0, 0, 0, 2, 1607167988, 1607167988);
INSERT INTO `comment` VALUES (448, 1, 899, 5, '1', 0, 0, 0, 2, 1607167988, 1607167988);
INSERT INTO `comment` VALUES (449, 1, 899, 5, '11', 0, 0, 0, 2, 1607167988, 1607167988);
INSERT INTO `comment` VALUES (450, 1, 899, 5, '11', 0, 0, 0, 2, 1607167989, 1607167989);
INSERT INTO `comment` VALUES (451, 1, 899, 5, '11', 0, 0, 0, 2, 1607167989, 1607167989);
INSERT INTO `comment` VALUES (452, 1, 899, 5, '1', 0, 0, 0, 2, 1607167990, 1607167990);
INSERT INTO `comment` VALUES (453, 1, 899, 5, '11', 0, 0, 0, 2, 1607167990, 1607167990);
INSERT INTO `comment` VALUES (454, 1, 899, 5, '11', 0, 0, 0, 2, 1607167990, 1607167990);
INSERT INTO `comment` VALUES (455, 1, 899, 5, '1111', 0, 0, 0, 2, 1607167991, 1607167991);
INSERT INTO `comment` VALUES (456, 1, 899, 5, '1', 0, 0, 0, 2, 1607167991, 1607167991);
INSERT INTO `comment` VALUES (457, 1, 899, 5, '1', 0, 0, 0, 2, 1607167991, 1607167991);
INSERT INTO `comment` VALUES (458, 1, 899, 5, '11', 0, 0, 0, 2, 1607167992, 1607167992);
INSERT INTO `comment` VALUES (459, 1, 899, 5, '11', 0, 0, 0, 2, 1607167992, 1607167992);
INSERT INTO `comment` VALUES (460, 1, 899, 5, '111', 0, 0, 0, 2, 1607167992, 1607167992);
INSERT INTO `comment` VALUES (461, 1, 899, 5, '1', 0, 0, 0, 2, 1607167992, 1607167992);
INSERT INTO `comment` VALUES (462, 1, 899, 5, '1', 0, 0, 0, 2, 1607167992, 1607167992);
INSERT INTO `comment` VALUES (463, 1, 899, 5, '2222', 0, 0, 0, 2, 1607167994, 1607167994);
INSERT INTO `comment` VALUES (464, 1, 1747, 5, '1', 0, 0, 0, 2, 1607168268, 1607168268);
INSERT INTO `comment` VALUES (465, 1, 724, 5, '123', 0, 0, 0, 2, 1607168295, 1607168295);
INSERT INTO `comment` VALUES (466, 1, 724, 5, '123123', 0, 0, 0, 2, 1607168325, 1607168325);
INSERT INTO `comment` VALUES (467, 1, 737, 5, '123', 1, 0, 0, 2, 1607168365, 1607168363);
INSERT INTO `comment` VALUES (468, 1, 838, 5, '1', 1, 0, 0, 2, 1607168419, 1607168418);
INSERT INTO `comment` VALUES (469, 1, 1084, 5, '1', 1, 0, 0, 2, 1607168483, 1607168481);
INSERT INTO `comment` VALUES (470, 1, 1439, 5, '111', 0, 0, 0, 2, 1607168557, 1607168557);
INSERT INTO `comment` VALUES (471, 1, 468, 5, '123123', 1, 0, 0, 2, 1607168701, 1607168699);
INSERT INTO `comment` VALUES (472, 1, 1776, 5, '123', 1, 0, 0, 2, 1607168758, 1607168757);
INSERT INTO `comment` VALUES (473, 1, 1039, 5, '123', 1, 0, 0, 2, 1607168837, 1607168831);
INSERT INTO `comment` VALUES (474, 1, 340, 5, '234234', 1, 0, 0, 2, 1607168913, 1607168911);
INSERT INTO `comment` VALUES (475, 1, 921, 5, '123', 0, 0, 0, 2, 1607168943, 1607168943);
INSERT INTO `comment` VALUES (476, 1, 87, 5, '还好哈哈哈', 0, 0, 0, 2, 1607168985, 1607168985);
INSERT INTO `comment` VALUES (477, 1, 1604, 5, '略略略', 0, 0, 0, 2, 1607169095, 1607169095);
INSERT INTO `comment` VALUES (478, 1, 818, 5, '略略略', 1, 0, 0, 2, 1607169151, 1607169140);
INSERT INTO `comment` VALUES (479, 1, 818, 5, '还是不是的，', 0, 0, 0, 2, 1607169180, 1607169180);
INSERT INTO `comment` VALUES (480, 1, 414, 5, '123123', 1, 0, 0, 2, 1607172634, 1607172621);
INSERT INTO `comment` VALUES (481, 1, 414, 5, '123123123', 1, 0, 0, 2, 1607172633, 1607172624);
INSERT INTO `comment` VALUES (482, 1, 414, 5, '123123123123', 1, 0, 0, 2, 1607172631, 1607172629);
INSERT INTO `comment` VALUES (483, 1, 1007, 4, '哈哈哈哈', 1, 0, 0, 2, 1607251365, 1607251360);
INSERT INTO `comment` VALUES (484, 1, 1318, 9, '测试', 0, 0, 0, 2, 1607320043, 1607320043);
INSERT INTO `comment` VALUES (485, 1, 1979, 147, '。。', 0, 0, 0, 2, 1608097480, 1608097480);

-- ----------------------------
-- Table structure for comment_like
-- ----------------------------
DROP TABLE IF EXISTS `comment_like`;
CREATE TABLE `comment_like`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `comment_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '关联comment_id',
  `user_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '关联user_id',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT 1 COMMENT '状态0:取消点赞1:点赞',
  `updated_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '更新时间',
  `created_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `comment_user`(`comment_id`, `user_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 30 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '用户评论点赞表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of comment_like
-- ----------------------------
INSERT INTO `comment_like` VALUES (1, 1, 45, 1, 1589066767, 1589066767);
INSERT INTO `comment_like` VALUES (2, 2, 60, 1, 1590713741, 1590713741);
INSERT INTO `comment_like` VALUES (3, 7, 4, 1, 1591260204, 1591260204);
INSERT INTO `comment_like` VALUES (4, 30, 69, 1, 1592811020, 1592810570);
INSERT INTO `comment_like` VALUES (5, 34, 69, 1, 1592811039, 1592811039);
INSERT INTO `comment_like` VALUES (6, 33, 69, 1, 1592818739, 1592818739);
INSERT INTO `comment_like` VALUES (7, 40, 69, 1, 1592836075, 1592836075);
INSERT INTO `comment_like` VALUES (8, 23, 69, 1, 1592838542, 1592838542);
INSERT INTO `comment_like` VALUES (9, 45, 69, 1, 1592839762, 1592839760);
INSERT INTO `comment_like` VALUES (10, 69, 69, 0, 1592924976, 1592924975);
INSERT INTO `comment_like` VALUES (11, 73, 82, 1, 1592932133, 1592932133);
INSERT INTO `comment_like` VALUES (12, 74, 82, 1, 1592932134, 1592932134);
INSERT INTO `comment_like` VALUES (13, 75, 82, 1, 1592932135, 1592932135);
INSERT INTO `comment_like` VALUES (14, 155, 26, 1, 1593237773, 1593237769);
INSERT INTO `comment_like` VALUES (15, 217, 69, 0, 1593613632, 1593613590);
INSERT INTO `comment_like` VALUES (16, 222, 26, 1, 1593691284, 1593691284);
INSERT INTO `comment_like` VALUES (17, 273, 69, 1, 1594129787, 1594129787);
INSERT INTO `comment_like` VALUES (18, 467, 5, 1, 1607168365, 1607168365);
INSERT INTO `comment_like` VALUES (19, 468, 5, 1, 1607168419, 1607168419);
INSERT INTO `comment_like` VALUES (20, 469, 5, 1, 1607168483, 1607168483);
INSERT INTO `comment_like` VALUES (21, 471, 5, 1, 1607168701, 1607168701);
INSERT INTO `comment_like` VALUES (22, 472, 5, 1, 1607168758, 1607168758);
INSERT INTO `comment_like` VALUES (23, 473, 5, 1, 1607168837, 1607168833);
INSERT INTO `comment_like` VALUES (24, 474, 5, 1, 1607168913, 1607168913);
INSERT INTO `comment_like` VALUES (25, 478, 5, 1, 1607169151, 1607169151);
INSERT INTO `comment_like` VALUES (26, 482, 5, 1, 1607172631, 1607172631);
INSERT INTO `comment_like` VALUES (27, 481, 5, 1, 1607172633, 1607172633);
INSERT INTO `comment_like` VALUES (28, 480, 5, 1, 1607172634, 1607172634);
INSERT INTO `comment_like` VALUES (29, 483, 4, 1, 1607251365, 1607251365);

-- ----------------------------
-- Table structure for config
-- ----------------------------
DROP TABLE IF EXISTS `config`;
CREATE TABLE `config`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `attr_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '字段名',
  `attr_value` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '字段内容',
  `updated_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '更新时间',
  `created_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 157 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '配置表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of config
-- ----------------------------
INSERT INTO `config` VALUES (101, 'base_site_status', '1', 1608449473, 1591352360);
INSERT INTO `config` VALUES (102, 'email_smtp', 'smtp.163.com', 1608449473, 1591352360);
INSERT INTO `config` VALUES (103, 'email_smtp_port', '465', 1608449473, 1591352360);
INSERT INTO `config` VALUES (104, 'email_account', 'xinxinghome@163.com', 1608449473, 1591352360);
INSERT INTO `config` VALUES (105, 'email_password', 'XVRMOBFNRBAWZCKX', 1608449473, 1591352360);
INSERT INTO `config` VALUES (106, 'email_name', '鑫兴民宿', 1608449473, 1591352360);
INSERT INTO `config` VALUES (107, 'email_valid_time', '600', 1608449473, 1591352360);
INSERT INTO `config` VALUES (108, 'email_code_template', '您的验证码是：{验证码}，请在10分钟内输入。请勿告诉其他人。', 1608449473, 1591352360);
INSERT INTO `config` VALUES (109, 'email_day_error_time', '5', 1608449473, 1591352360);
INSERT INTO `config` VALUES (110, 'upload_file_ext', 'png|gif|jpg|jpeg', 1608449473, 1591352360);
INSERT INTO `config` VALUES (111, 'upload_max_size', '50', 1608449473, 1591352360);
INSERT INTO `config` VALUES (112, 'upload_qiniu_accessKey', '7Swd0fkWhx8P5IznfkF2t_5vMcik2_Vwt1JqLJOe', 1608449473, 1591352360);
INSERT INTO `config` VALUES (113, 'upload_qiniu_secretKey', 'XwYhJU5xdsqDVKbwC03eljUW2KpyByLzYnf_h6gf', 1608449473, 1591352360);
INSERT INTO `config` VALUES (114, 'upload_qiniu_bucket', 'songshulive', 1608449473, 1591352360);
INSERT INTO `config` VALUES (115, 'upload_qiniu_domain', 'http://qingtingcun.youyacao.com/', 1608449473, 1591352360);
INSERT INTO `config` VALUES (116, 'base_video_need_login', '0', 1608449473, 1591352360);
INSERT INTO `config` VALUES (117, 'base_video_free_time', '0', 1608449473, 1591352360);
INSERT INTO `config` VALUES (118, 'base_video_free_duration', '0', 1608449473, 1591352360);
INSERT INTO `config` VALUES (119, 'base_live_need_login', '0', 1608449473, 1591352360);
INSERT INTO `config` VALUES (120, 'base_live_free_time', '0', 1608449473, 1591352360);
INSERT INTO `config` VALUES (121, 'base_live_free_duration', '0', 1608449473, 1591352360);
INSERT INTO `config` VALUES (122, 'comment_forbid_keys', '腾讯,阿里', 1608449473, 1591352360);
INSERT INTO `config` VALUES (123, 'comment_open_check', '0', 1608449473, 1591352360);
INSERT INTO `config` VALUES (124, 'sms_valid_time', '300', 1608449473, 1591352360);
INSERT INTO `config` VALUES (125, 'sms_day_error_num', '5', 1608449473, 1591352360);
INSERT INTO `config` VALUES (126, 'sms_code_template', '【优雅草科技】您的验证码是{验证码}。如非本人操作，请忽略本短信。', 1608449473, 1591352360);
INSERT INTO `config` VALUES (127, 'sms_apikey', '3c4caf2b7b9f6830a411184007123254', 1608449473, 1591352360);
INSERT INTO `config` VALUES (128, 'base_video_open_check', '0', 1608449473, 1591352360);
INSERT INTO `config` VALUES (129, 'article_open_check', '0', 1608449473, 1591352360);
INSERT INTO `config` VALUES (130, 'upload_video_file_ext', 'mp4', 1608449473, 1591352360);
INSERT INTO `config` VALUES (131, 'upload_video_max_size', '100', 1608449473, 1591352360);
INSERT INTO `config` VALUES (132, 'upload_qiniu_video_thumb', '?vframe/jpg/offset/1', 1608449473, 1591352360);
INSERT INTO `config` VALUES (133, 'base_default_avatar', 'qiniu_202012200731118232113882.png?imageView2/1/w/800/h/800', 1608449473, 1591352360);
INSERT INTO `config` VALUES (134, 'base_default_avatar_url', 'http://qingtingcun.youyacao.com/qiniu_202005301706070740025005.png?imageView2/1/w/800/h/800', 1608449473, 1591352360);
INSERT INTO `config` VALUES (135, 'login_weixin_key', 'wx29af4fafd67d8397', 1608449473, 1591352360);
INSERT INTO `config` VALUES (136, 'login_weixin_secret', 'b64d8dc8fb374aeccc2de56f375cfa32', 1608449473, 1591352360);
INSERT INTO `config` VALUES (137, 'login_qq_key', '101849320', 1608449473, 1591352360);
INSERT INTO `config` VALUES (138, 'login_qq_secret', 'b853fd7423b6a29060749062630994f7', 1608449473, 1591352360);
INSERT INTO `config` VALUES (139, 'login_weibo_key', 'weiboappid', 1608449473, 1591352360);
INSERT INTO `config` VALUES (140, 'login_weibo_secret', 'weiboappsecret', 1608449473, 1591352360);
INSERT INTO `config` VALUES (141, 'sms_service', 'yunpian', 1608449473, 1591352360);
INSERT INTO `config` VALUES (142, 'sms_yunpian_apikey', '3c4caf2b7b9f6830a411184007123254', 1608449473, 1591352360);
INSERT INTO `config` VALUES (143, 'upload_service', 'qiniu', 1608449473, 1591352360);
INSERT INTO `config` VALUES (144, 'upload_aliyun_accessKey', 'LTAI4GKDafiQar5sReYE1HMa', 1608449473, 1591352360);
INSERT INTO `config` VALUES (145, 'upload_aliyun_secretKey', 'IXSKEfrmBdYwXdsOHkS1hi27AEsXje', 1608449473, 1591352360);
INSERT INTO `config` VALUES (146, 'upload_aliyun_bucket', 'simg1', 1608449473, 1591352360);
INSERT INTO `config` VALUES (147, 'upload_aliyun_domain', 'http://simg1.oss-accelerate.aliyuncs.com/', 1608449473, 1591352360);
INSERT INTO `config` VALUES (148, 'upload_aliyun_video_thumb', '?x-oss-process=video/snapshot,t_1000,f_jpg,w_800,h_600,m_fast', 1608449473, 1591352360);
INSERT INTO `config` VALUES (149, 'upload_aliyun_endPoint', 'http://oss-accelerate.aliyuncs.com', 1608449473, 1591352360);
INSERT INTO `config` VALUES (150, 'base_video_start_second', '10', 1608449474, 1592219317);
INSERT INTO `config` VALUES (151, 'base_video_end_second', '20', 1608449474, 1592219317);
INSERT INTO `config` VALUES (152, 'base_video_show_ad', '3', 1608449474, 1592275530);
INSERT INTO `config` VALUES (153, 'base_video_free_num', '0', 1608449474, 1592275530);
INSERT INTO `config` VALUES (154, 'base_live_free_num', '0', 1608449474, 1592275530);
INSERT INTO `config` VALUES (155, 'upload_qiniu_video_segment', '', 1608449474, 1594285202);
INSERT INTO `config` VALUES (156, 'upload_qiniu_status', '1', 1608449474, 1606622911);

-- ----------------------------
-- Table structure for download
-- ----------------------------
DROP TABLE IF EXISTS `download`;
CREATE TABLE `download`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `user_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '关联user_id',
  `vid` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '关联视频id',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '状态1:已下载',
  `updated_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '更新时间',
  `created_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `user_id`(`user_id`) USING BTREE,
  INDEX `vid`(`vid`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 40 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '用户下载记录表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of download
-- ----------------------------
INSERT INTO `download` VALUES (1, 75, 1971, 1, 1592037500, 1592037500);
INSERT INTO `download` VALUES (2, 75, 1965, 1, 1592037585, 1592037585);
INSERT INTO `download` VALUES (3, 75, 1948, 1, 1592204238, 1592204238);
INSERT INTO `download` VALUES (4, 75, 1947, 1, 1592204244, 1592204244);
INSERT INTO `download` VALUES (5, 75, 1946, 1, 1592204252, 1592204252);
INSERT INTO `download` VALUES (6, 75, 1954, 1, 1592212428, 1592212428);
INSERT INTO `download` VALUES (7, 75, 1954, 1, 1592212479, 1592212479);
INSERT INTO `download` VALUES (8, 75, 1963, 1, 1592212700, 1592212700);
INSERT INTO `download` VALUES (9, 75, 1968, 1, 1592212706, 1592212706);
INSERT INTO `download` VALUES (10, 75, 1972, 1, 1592212713, 1592212713);
INSERT INTO `download` VALUES (11, 75, 1971, 1, 1592212740, 1592212740);
INSERT INTO `download` VALUES (12, 75, 1965, 1, 1592213095, 1592213095);
INSERT INTO `download` VALUES (13, 76, 1963, 1, 1592299843, 1592299843);
INSERT INTO `download` VALUES (14, 76, 1964, 1, 1592301930, 1592301930);
INSERT INTO `download` VALUES (15, 78, 1971, 1, 1592311028, 1592311028);
INSERT INTO `download` VALUES (16, 76, 512, 1, 1592535282, 1592535282);
INSERT INTO `download` VALUES (17, 86, 1960, 1, 1592920732, 1592920732);
INSERT INTO `download` VALUES (18, 79, 1970, 1, 1593029594, 1593029594);
INSERT INTO `download` VALUES (19, 79, 1962, 1, 1593029685, 1593029685);
INSERT INTO `download` VALUES (20, 83, 1962, 1, 1593531604, 1593531604);
INSERT INTO `download` VALUES (21, 83, 1962, 1, 1593531917, 1593531917);
INSERT INTO `download` VALUES (22, 83, 1967, 1, 1593532002, 1593532002);
INSERT INTO `download` VALUES (23, 83, 1967, 1, 1593532010, 1593532010);
INSERT INTO `download` VALUES (24, 83, 1964, 1, 1593532215, 1593532215);
INSERT INTO `download` VALUES (25, 83, 1961, 1, 1593533278, 1593533278);
INSERT INTO `download` VALUES (26, 83, 1961, 1, 1593533285, 1593533285);
INSERT INTO `download` VALUES (27, 83, 1961, 1, 1593533289, 1593533289);
INSERT INTO `download` VALUES (28, 83, 1975, 1, 1593533346, 1593533346);
INSERT INTO `download` VALUES (29, 83, 1968, 1, 1593533371, 1593533371);
INSERT INTO `download` VALUES (30, 83, 1972, 1, 1593533544, 1593533544);
INSERT INTO `download` VALUES (31, 76, 1965, 1, 1593533683, 1593533683);
INSERT INTO `download` VALUES (32, 76, 1965, 1, 1593533694, 1593533694);
INSERT INTO `download` VALUES (33, 76, 1965, 1, 1593533702, 1593533702);
INSERT INTO `download` VALUES (34, 76, 1965, 1, 1593533757, 1593533757);
INSERT INTO `download` VALUES (35, 76, 1965, 1, 1593533766, 1593533766);
INSERT INTO `download` VALUES (36, 79, 1961, 1, 1593650377, 1593650377);
INSERT INTO `download` VALUES (37, 86, 1961, 1, 1593706393, 1593706393);
INSERT INTO `download` VALUES (38, 86, 1964, 1, 1593706404, 1593706404);
INSERT INTO `download` VALUES (39, 78, 1967, 1, 1593707072, 1593707072);

-- ----------------------------
-- Table structure for follow
-- ----------------------------
DROP TABLE IF EXISTS `follow`;
CREATE TABLE `follow`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `user_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '关联user_id',
  `follow_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '关注用户user_id',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '状态0:取消关注1:正在关注',
  `updated_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '更新时间',
  `created_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `user_id`(`user_id`) USING BTREE,
  INDEX `follow_id`(`follow_id`) USING BTREE,
  INDEX `created_at`(`created_at`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 14 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '用户关注表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of follow
-- ----------------------------
INSERT INTO `follow` VALUES (1, 1, 82, 1, 1593359939, 1593248219);
INSERT INTO `follow` VALUES (2, 0, 82, 1, 1593278321, 1593276947);
INSERT INTO `follow` VALUES (3, 1, 69, 1, 1593527481, 1593277976);
INSERT INTO `follow` VALUES (4, 82, 1, 1, 1593278951, 1593278869);
INSERT INTO `follow` VALUES (5, 69, 90, 1, 1593357536, 1593357536);
INSERT INTO `follow` VALUES (6, 82, 26, 1, 1593673180, 1593673177);
INSERT INTO `follow` VALUES (7, 26, 82, 1, 1593689847, 1593689843);
INSERT INTO `follow` VALUES (8, 26, 69, 1, 1593692154, 1593692154);
INSERT INTO `follow` VALUES (9, 69, 26, 1, 1593705658, 1593701269);
INSERT INTO `follow` VALUES (10, 82, 69, 1, 1593832226, 1593832221);
INSERT INTO `follow` VALUES (11, 5, 4, 1, 1606401748, 1606401748);
INSERT INTO `follow` VALUES (12, 5, 12, 0, 1607848365, 1606919541);
INSERT INTO `follow` VALUES (13, 9, 12, 1, 1607327139, 1607327139);

-- ----------------------------
-- Table structure for give
-- ----------------------------
DROP TABLE IF EXISTS `give`;
CREATE TABLE `give`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `data_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '0' COMMENT '类别：ARTICLE,VIDEO,LIVE',
  `data_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '对象ID',
  `user_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '打赏人user_id',
  `to_user_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '打赏对象user_id',
  `amount` decimal(10, 2) NOT NULL DEFAULT 0.00 COMMENT '打赏金额',
  `remark` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '备注',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT 1 COMMENT '状态',
  `updated_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '更新时间',
  `created_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `data_type_id`(`data_id`, `data_type`) USING BTREE,
  INDEX `user_data`(`user_id`, `data_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '打赏记录表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for goods
-- ----------------------------
DROP TABLE IF EXISTS `goods`;
CREATE TABLE `goods`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '用户ID',
  `type` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '类别：1淘宝',
  `goods_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '商品名称',
  `thumb` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '商品头图',
  `price` decimal(10, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '商品价格',
  `images` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '商品图片',
  `content` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '商品描述',
  `open_type` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '打开方式：1外链跳转',
  `out_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '外链',
  `buy_num` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '购买数',
  `view_num` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '浏览次数，可做显示那条广告的依据',
  `sort` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '排序',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '状态 0 删除， 1 待审核，2审核通过',
  `updated_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '更新时间',
  `created_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `type`(`type`) USING BTREE,
  INDEX `created_at`(`created_at`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '商品表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of goods
-- ----------------------------
INSERT INTO `goods` VALUES (1, 0, 1, '324234', 'qiniu_202006290649409416995713.jpg?imageView2/1/w/800/h/800', 0.00, ' ', '', 1, 'www.baidu.com', 15, 55, 5, 1, 1593413533, 1593413289);

-- ----------------------------
-- Table structure for like
-- ----------------------------
DROP TABLE IF EXISTS `like`;
CREATE TABLE `like`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `type` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '分类1:短视频2图文3:直播',
  `user_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '关联user_id',
  `vid` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '关联作品ID',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT 1 COMMENT '状态0:取消点赞1:点赞',
  `updated_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '更新时间',
  `created_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `user_vid`(`user_id`, `vid`) USING BTREE,
  INDEX `created_at`(`created_at`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 103 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '用户点赞详情表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of like
-- ----------------------------
INSERT INTO `like` VALUES (1, 1, 45, 1964, 1, 1589066754, 1589066754);
INSERT INTO `like` VALUES (2, 1, 44, 1965, 0, 1589554896, 1589553689);
INSERT INTO `like` VALUES (3, 1, 57, 1964, 1, 1590632431, 1590632429);
INSERT INTO `like` VALUES (4, 1, 57, 1962, 1, 1590632535, 1590632535);
INSERT INTO `like` VALUES (5, 1, 60, 1960, 1, 1590707926, 1590707926);
INSERT INTO `like` VALUES (6, 1, 61, 1966, 1, 1590759094, 1590758938);
INSERT INTO `like` VALUES (7, 1, 16, 1966, 1, 1591029460, 1591029460);
INSERT INTO `like` VALUES (8, 1, 63, 1964, 0, 1591088305, 1591088303);
INSERT INTO `like` VALUES (9, 1, 64, 1964, 1, 1591146578, 1591146578);
INSERT INTO `like` VALUES (10, 1, 4, 1, 1, 1592448102, 1592448102);
INSERT INTO `like` VALUES (11, 3, 4, 7, 1, 1592448131, 1592448131);
INSERT INTO `like` VALUES (12, 1, 4, 7, 1, 1592448489, 1592448489);
INSERT INTO `like` VALUES (13, 1, 4, 2, 1, 1592448492, 1592448492);
INSERT INTO `like` VALUES (14, 1, 4, 4, 1, 1592448495, 1592448495);
INSERT INTO `like` VALUES (15, 1, 4, 5, 1, 1592448498, 1592448498);
INSERT INTO `like` VALUES (16, 1, 4, 6, 1, 1592448501, 1592448501);
INSERT INTO `like` VALUES (17, 1, 4, 8, 1, 1592448506, 1592448506);
INSERT INTO `like` VALUES (18, 1, 4, 1544, 1, 1592448512, 1592448512);
INSERT INTO `like` VALUES (19, 2, 4, 1, 1, 1592448528, 1592448528);
INSERT INTO `like` VALUES (20, 2, 4, 2, 1, 1592448531, 1592448531);
INSERT INTO `like` VALUES (21, 2, 69, 25, 1, 1592748074, 1592747337);
INSERT INTO `like` VALUES (22, 2, 69, 7, 1, 1592748029, 1592748029);
INSERT INTO `like` VALUES (23, 2, 69, 2, 1, 1592751658, 1592748033);
INSERT INTO `like` VALUES (24, 2, 69, 1, 1, 1592754016, 1592748039);
INSERT INTO `like` VALUES (25, 2, 69, 10, 0, 1592748120, 1592748112);
INSERT INTO `like` VALUES (26, 2, 69, 26, 0, 1592748203, 1592748170);
INSERT INTO `like` VALUES (27, 2, 69, 27, 0, 1592838494, 1592750585);
INSERT INTO `like` VALUES (28, 2, 69, 14, 0, 1592751499, 1592751498);
INSERT INTO `like` VALUES (29, 2, 69, 18, 0, 1592813109, 1592813107);
INSERT INTO `like` VALUES (30, 2, 69, 38, 0, 1592926921, 1592926920);
INSERT INTO `like` VALUES (31, 2, 26, 44, 1, 1593237230, 1593237201);
INSERT INTO `like` VALUES (32, 2, 26, 43, 1, 1593237208, 1593237208);
INSERT INTO `like` VALUES (33, 2, 26, 50, 1, 1593237450, 1593237450);
INSERT INTO `like` VALUES (34, 2, 26, 39, 1, 1593237728, 1593237728);
INSERT INTO `like` VALUES (35, 2, 82, 39, 1, 1593237912, 1593237912);
INSERT INTO `like` VALUES (36, 2, 82, 25, 1, 1593238669, 1593238669);
INSERT INTO `like` VALUES (37, 2, 69, 52, 1, 1593245493, 1593245393);
INSERT INTO `like` VALUES (38, 2, 69, 51, 0, 1593359945, 1593246247);
INSERT INTO `like` VALUES (39, 2, 69, 53, 0, 1593251513, 1593251511);
INSERT INTO `like` VALUES (40, 2, 69, 31, 1, 1593251852, 1593251852);
INSERT INTO `like` VALUES (41, 2, 90, 52, 1, 1593278331, 1593276925);
INSERT INTO `like` VALUES (42, 2, 90, 32, 1, 1593277677, 1593277677);
INSERT INTO `like` VALUES (43, 2, 90, 54, 1, 1593278674, 1593278672);
INSERT INTO `like` VALUES (44, 2, 69, 54, 1, 1593609847, 1593354541);
INSERT INTO `like` VALUES (45, 2, 26, 54, 0, 1593689562, 1593689558);
INSERT INTO `like` VALUES (46, 2, 26, 52, 1, 1593690142, 1593690139);
INSERT INTO `like` VALUES (47, 2, 26, 55, 1, 1593691320, 1593691320);
INSERT INTO `like` VALUES (48, 2, 26, 32, 1, 1593692164, 1593692164);
INSERT INTO `like` VALUES (49, 2, 26, 1, 1, 1593692242, 1593692242);
INSERT INTO `like` VALUES (50, 2, 69, 56, 1, 1593701275, 1593701275);
INSERT INTO `like` VALUES (51, 2, 82, 1, 0, 1593832322, 1593832321);
INSERT INTO `like` VALUES (52, 1, 16, 1975, 1, 1594186420, 1594186418);
INSERT INTO `like` VALUES (53, 1, 16, 1971, 1, 1594199907, 1594199907);
INSERT INTO `like` VALUES (54, 1, 115, 1975, 1, 1595924778, 1595924778);
INSERT INTO `like` VALUES (55, 1, 122, 1978, 1, 1596854480, 1596854480);
INSERT INTO `like` VALUES (56, 1, 22, 1975, 1, 1597335183, 1597335183);
INSERT INTO `like` VALUES (57, 1, 22, 1972, 1, 1597338546, 1597338543);
INSERT INTO `like` VALUES (58, 1, 143, 1972, 1, 1606223946, 1606223946);
INSERT INTO `like` VALUES (59, 1, 143, 1971, 1, 1606223955, 1606223955);
INSERT INTO `like` VALUES (60, 1, 143, 1970, 1, 1606223956, 1606223956);
INSERT INTO `like` VALUES (61, 1, 143, 1969, 1, 1606223958, 1606223958);
INSERT INTO `like` VALUES (62, 1, 5, 320, 1, 1606364214, 1606364214);
INSERT INTO `like` VALUES (63, 1, 5, 886, 1, 1606364408, 1606364408);
INSERT INTO `like` VALUES (64, 1, 5, 1949, 1, 1606390167, 1606364424);
INSERT INTO `like` VALUES (65, 1, 5, 1247, 1, 1606364478, 1606364478);
INSERT INTO `like` VALUES (66, 1, 5, 897, 1, 1606389779, 1606389779);
INSERT INTO `like` VALUES (67, 1, 5, 826, 1, 1606389952, 1606389952);
INSERT INTO `like` VALUES (68, 1, 5, 1394, 1, 1606389999, 1606389999);
INSERT INTO `like` VALUES (69, 1, 5, 464, 1, 1606393000, 1606393000);
INSERT INTO `like` VALUES (70, 1, 5, 1727, 1, 1606393588, 1606393588);
INSERT INTO `like` VALUES (71, 1, 5, 1851, 1, 1606395455, 1606395455);
INSERT INTO `like` VALUES (72, 1, 5, 1342, 1, 1606401509, 1606401509);
INSERT INTO `like` VALUES (73, 1, 5, 1257, 1, 1606565198, 1606565198);
INSERT INTO `like` VALUES (74, 1, 5, 535, 1, 1606582312, 1606582312);
INSERT INTO `like` VALUES (75, 1, 5, 1489, 1, 1606724632, 1606724632);
INSERT INTO `like` VALUES (76, 1, 5, 1818, 1, 1606726474, 1606726474);
INSERT INTO `like` VALUES (77, 1, 5, 211, 1, 1606726607, 1606726607);
INSERT INTO `like` VALUES (78, 1, 5, 700, 1, 1606807242, 1606807242);
INSERT INTO `like` VALUES (79, 1, 146, 1972, 1, 1606811937, 1606811937);
INSERT INTO `like` VALUES (80, 1, 5, 1077, 1, 1606833771, 1606833771);
INSERT INTO `like` VALUES (81, 1, 5, 1212, 1, 1607085438, 1607085438);
INSERT INTO `like` VALUES (82, 1, 5, 1782, 1, 1607090613, 1607090611);
INSERT INTO `like` VALUES (83, 1, 5, 468, 0, 1607168705, 1607168703);
INSERT INTO `like` VALUES (84, 1, 5, 1776, 1, 1607168752, 1607168750);
INSERT INTO `like` VALUES (85, 1, 5, 340, 1, 1607168918, 1607168918);
INSERT INTO `like` VALUES (86, 1, 5, 818, 1, 1607169156, 1607169156);
INSERT INTO `like` VALUES (87, 1, 5, 774, 1, 1607169990, 1607169990);
INSERT INTO `like` VALUES (88, 1, 5, 414, 1, 1607172639, 1607172639);
INSERT INTO `like` VALUES (89, 1, 147, 1972, 1, 1607276377, 1607276377);
INSERT INTO `like` VALUES (90, 1, 5, 1699, 1, 1607277007, 1607277007);
INSERT INTO `like` VALUES (91, 1, 5, 756, 1, 1607277010, 1607277010);
INSERT INTO `like` VALUES (92, 1, 5, 372, 1, 1607277019, 1607277019);
INSERT INTO `like` VALUES (93, 1, 9, 1318, 0, 1607320047, 1607320046);
INSERT INTO `like` VALUES (94, 1, 147, 1979, 0, 1608098367, 1608098366);
INSERT INTO `like` VALUES (95, 1, 151, 1980, 1, 1608175745, 1608175745);
INSERT INTO `like` VALUES (98, 1, 1, 2, 1, 1608393230, 1608393230);
INSERT INTO `like` VALUES (99, 1, 1, 1, 1, 1608393571, 1608393571);
INSERT INTO `like` VALUES (100, 4, 1, 1, 1, 1608393615, 1608393615);
INSERT INTO `like` VALUES (101, 4, 1, 2, 1, 1608393619, 1608393619);
INSERT INTO `like` VALUES (102, 4, 9, 3, 0, 1608444514, 1608444468);

-- ----------------------------
-- Table structure for live
-- ----------------------------
DROP TABLE IF EXISTS `live`;
CREATE TABLE `live`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `user_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '关联user_id',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '标题',
  `thumb` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '预览图',
  `rtmp_push_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '直播推流地址',
  `push_end_time` datetime(0) NOT NULL COMMENT '直播地址结束时间',
  `view_num` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '查看次数',
  `like_num` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '点赞次数',
  `share_num` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '分享次数',
  `collect_num` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '收藏次数',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT 1 COMMENT '状态0:关闭1:开启',
  `updated_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '更新时间',
  `created_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `user_id`(`user_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 20 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '直播表' ROW_FORMAT = Compact;

-- ----------------------------
-- Records of live
-- ----------------------------
INSERT INTO `live` VALUES (12, 5, '测试', 'http://qingtingcun.youyacao.com/qiniu_202012181353351268812177.jpg', 'rtmp://txlivepush.youyacao.com/蜻蜓-uni/197032148?txSecret=bc7bdf7201909603e0735815139f9674&txTime=5FDE05DF', '2020-12-19 13:53:35', 26, 0, 0, 0, 1, 1608299617, 1606720985);
INSERT INTO `live` VALUES (15, 9, '哈哈哈哈', 'http://qingtingcun.youyacao.com/qiniu_202012201545275785777030.jpg', 'rtmp://txlivepush.youyacao.com/蜻蜓-uni/169748531?txSecret=df96b4be8634cc6435e9d017334e60e1&txTime=5FE0C318', '2020-12-21 15:45:28', 0, 0, 0, 0, 1, 1608479129, 1607261494);
INSERT INTO `live` VALUES (16, 1, '', '', 'rtmp://txlivepush.youyacao.com/蜻蜓-uni/kiro?txSecret=d83dff506d06f17bc550bf84d5edb1bf&txTime=5FDDD0CE', '2020-12-19 10:07:10', 0, 0, 0, 0, 1, 1608286030, 1607326790);
INSERT INTO `live` VALUES (17, 147, '测试', 'http://qingtingcun.youyacao.com/qiniu_202012170414100782236970.jpg', 'rtmp://txlivepush.youyacao.com/蜻蜓-uni/178610293?txSecret=3587df77c326ac7327585c583a2d19c7&txTime=5FDC2C92', '2020-12-18 04:14:10', 0, 0, 0, 0, 1, 1608178451, 1608178351);
INSERT INTO `live` VALUES (18, 22, '11111', 'http://qingtingcun.youyacao.com/qiniu_202012200223111942784507.jpg', 'rtmp://txlivepush.youyacao.com/蜻蜓-uni/161593207?txSecret=1cb7a15deab04201f4e9fffb8d07bdce&txTime=5FE0070F', '2020-12-21 02:23:11', 0, 0, 0, 0, 1, 1608430992, 1608430992);
INSERT INTO `live` VALUES (19, 0, '', '', 'rtmp://txlivepush.youyacao.com/蜻蜓-uni/?txSecret=21c32dd0e2b9745030f8b171a34e496e&txTime=5FE2F459', '2020-12-23 07:40:09', 0, 0, 0, 0, 1, 1608622810, 1608622810);

-- ----------------------------
-- Table structure for message
-- ----------------------------
DROP TABLE IF EXISTS `message`;
CREATE TABLE `message`  (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `user_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '发送人ID',
  `to_user_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '接收人ID',
  `type` tinyint(1) NOT NULL COMMENT '类别1粉丝2点赞3评论4@我',
  `data_type` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '分类1视频2图文3直播',
  `data_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '针对消息对象作品ID',
  `work_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '评论ID',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '状态0删除1未读2已读',
  `updated_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '更新时间',
  `created_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `user_type`(`user_id`, `type`) USING BTREE,
  INDEX `to_user_type`(`to_user_id`, `type`) USING BTREE,
  INDEX `created_at`(`created_at`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 712 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '消息推送表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of message
-- ----------------------------
INSERT INTO `message` VALUES (5, 4, 63, 2, 1, 1964, 7, 1, 1591260204, 1591260204);
INSERT INTO `message` VALUES (6, 69, 2, 3, 2, 2, 0, 1, 1591715769, 1591715769);
INSERT INTO `message` VALUES (7, 69, 2, 3, 2, 2, 0, 1, 1591797976, 1591797976);
INSERT INTO `message` VALUES (8, 69, 2, 3, 2, 2, 0, 1, 1591799502, 1591799502);
INSERT INTO `message` VALUES (9, 69, 2, 3, 2, 2, 0, 2, 1594128654, 1591799710);
INSERT INTO `message` VALUES (10, 69, 2, 3, 2, 2, 0, 1, 1591799837, 1591799837);
INSERT INTO `message` VALUES (11, 69, 2, 3, 2, 2, 0, 1, 1591799850, 1591799850);
INSERT INTO `message` VALUES (12, 69, 2, 3, 2, 2, 11, 1, 1591799860, 1591799860);
INSERT INTO `message` VALUES (13, 69, 2, 3, 2, 2, 0, 1, 1591799916, 1591799916);
INSERT INTO `message` VALUES (14, 69, 5, 3, 2, 1, 0, 1, 1591799983, 1591799983);
INSERT INTO `message` VALUES (15, 69, 2, 3, 2, 2, 0, 1, 1591974407, 1591974407);
INSERT INTO `message` VALUES (16, 4, 4, 2, 1, 1, 0, 1, 1592448102, 1592448102);
INSERT INTO `message` VALUES (17, 4, 4, 2, 3, 7, 0, 1, 1592448131, 1592448131);
INSERT INTO `message` VALUES (18, 4, 4, 2, 1, 7, 0, 1, 1592448489, 1592448489);
INSERT INTO `message` VALUES (19, 4, 4, 2, 1, 2, 0, 1, 1592448492, 1592448492);
INSERT INTO `message` VALUES (20, 4, 4, 2, 1, 4, 0, 1, 1592448495, 1592448495);
INSERT INTO `message` VALUES (21, 4, 4, 2, 1, 5, 0, 1, 1592448498, 1592448498);
INSERT INTO `message` VALUES (22, 4, 4, 2, 1, 6, 0, 1, 1592448501, 1592448501);
INSERT INTO `message` VALUES (23, 4, 4, 2, 1, 8, 0, 1, 1592448506, 1592448506);
INSERT INTO `message` VALUES (24, 4, 4, 2, 1, 1544, 0, 1, 1592448512, 1592448512);
INSERT INTO `message` VALUES (25, 4, 5, 2, 2, 1, 0, 1, 1592448528, 1592448528);
INSERT INTO `message` VALUES (26, 4, 2, 2, 2, 2, 0, 1, 1592448531, 1592448531);
INSERT INTO `message` VALUES (27, 69, 4, 3, 2, 3, 0, 1, 1592640769, 1592640769);
INSERT INTO `message` VALUES (28, 69, 69, 3, 2, 24, 0, 1, 1592746454, 1592746454);
INSERT INTO `message` VALUES (29, 69, 69, 3, 2, 6, 0, 1, 1592746624, 1592746624);
INSERT INTO `message` VALUES (30, 69, 69, 3, 2, 6, 0, 1, 1592746630, 1592746630);
INSERT INTO `message` VALUES (31, 69, 69, 3, 2, 6, 0, 1, 1592746638, 1592746638);
INSERT INTO `message` VALUES (42, 69, 69, 2, 2, 7, 0, 1, 1592748029, 1592748029);
INSERT INTO `message` VALUES (47, 69, 69, 2, 2, 25, 0, 1, 1592748074, 1592748074);
INSERT INTO `message` VALUES (48, 69, 69, 3, 2, 25, 0, 1, 1592748086, 1592748086);
INSERT INTO `message` VALUES (63, 69, 69, 3, 2, 27, 0, 1, 1592751268, 1592751268);
INSERT INTO `message` VALUES (66, 69, 2, 2, 2, 2, 0, 1, 1592751658, 1592751658);
INSERT INTO `message` VALUES (67, 69, 2, 3, 2, 2, 0, 1, 1592751822, 1592751822);
INSERT INTO `message` VALUES (68, 69, 2, 3, 2, 2, 0, 1, 1592751829, 1592751829);
INSERT INTO `message` VALUES (69, 69, 69, 3, 2, 6, 0, 1, 1592751941, 1592751941);
INSERT INTO `message` VALUES (70, 69, 5, 2, 2, 1, 0, 1, 1592754016, 1592754016);
INSERT INTO `message` VALUES (71, 82, 69, 3, 2, 28, 0, 1, 1592795609, 1592795609);
INSERT INTO `message` VALUES (72, 82, 69, 3, 2, 26, 0, 1, 1592797286, 1592797286);
INSERT INTO `message` VALUES (73, 69, 82, 3, 2, 29, 0, 1, 1592804927, 1592804927);
INSERT INTO `message` VALUES (74, 69, 69, 3, 2, 26, 0, 1, 1592807712, 1592807712);
INSERT INTO `message` VALUES (75, 69, 69, 3, 2, 26, 0, 1, 1592807816, 1592807816);
INSERT INTO `message` VALUES (92, 69, 82, 3, 2, 29, 0, 1, 1592810963, 1592810963);
INSERT INTO `message` VALUES (93, 69, 69, 2, 2, 29, 30, 1, 1592811020, 1592811020);
INSERT INTO `message` VALUES (94, 69, 82, 3, 2, 29, 0, 1, 1592811031, 1592811031);
INSERT INTO `message` VALUES (95, 69, 69, 2, 2, 29, 34, 1, 1592811039, 1592811039);
INSERT INTO `message` VALUES (97, 69, 69, 2, 2, 29, 33, 2, 1594129872, 1592818739);
INSERT INTO `message` VALUES (98, 69, 82, 3, 2, 29, 0, 1, 1592818753, 1592818753);
INSERT INTO `message` VALUES (99, 69, 82, 3, 2, 29, 0, 1, 1592831171, 1592831171);
INSERT INTO `message` VALUES (100, 69, 82, 3, 2, 29, 0, 1, 1592833972, 1592833972);
INSERT INTO `message` VALUES (101, 69, 82, 3, 2, 29, 0, 1, 1592834038, 1592834038);
INSERT INTO `message` VALUES (102, 69, 69, 3, 2, 28, 0, 1, 1592835882, 1592835882);
INSERT INTO `message` VALUES (103, 69, 69, 3, 2, 28, 0, 1, 1592835896, 1592835896);
INSERT INTO `message` VALUES (104, 69, 69, 2, 2, 28, 40, 1, 1592836075, 1592836075);
INSERT INTO `message` VALUES (105, 69, 69, 3, 2, 28, 0, 1, 1592836087, 1592836087);
INSERT INTO `message` VALUES (106, 69, 69, 3, 2, 28, 0, 1, 1592836646, 1592836646);
INSERT INTO `message` VALUES (107, 69, 69, 3, 2, 28, 28, 1, 1592836784, 1592836784);
INSERT INTO `message` VALUES (108, 69, 69, 3, 2, 25, 23, 1, 1592836909, 1592836909);
INSERT INTO `message` VALUES (109, 69, 69, 3, 2, 25, 23, 1, 1592838401, 1592838401);
INSERT INTO `message` VALUES (111, 69, 69, 2, 2, 25, 23, 1, 1592838542, 1592838542);
INSERT INTO `message` VALUES (112, 69, 69, 3, 2, 25, 23, 1, 1592839660, 1592839660);
INSERT INTO `message` VALUES (114, 69, 69, 2, 2, 25, 45, 1, 1592839762, 1592839762);
INSERT INTO `message` VALUES (115, 69, 69, 3, 2, 26, 29, 1, 1592839785, 1592839785);
INSERT INTO `message` VALUES (116, 69, 69, 3, 2, 38, 0, 1, 1592919152, 1592919152);
INSERT INTO `message` VALUES (117, 69, 69, 3, 2, 38, 48, 1, 1592919729, 1592919729);
INSERT INTO `message` VALUES (118, 86, 4, 3, 1, 1960, 0, 1, 1592920768, 1592920768);
INSERT INTO `message` VALUES (119, 86, 4, 3, 1, 1960, 0, 1, 1592921007, 1592921007);
INSERT INTO `message` VALUES (120, 86, 2, 3, 1, 1964, 0, 1, 1592921027, 1592921027);
INSERT INTO `message` VALUES (121, 86, 2, 3, 1, 1964, 0, 1, 1592921031, 1592921031);
INSERT INTO `message` VALUES (122, 86, 2, 3, 1, 1964, 0, 1, 1592921070, 1592921070);
INSERT INTO `message` VALUES (123, 86, 2, 3, 1, 1964, 0, 1, 1592921265, 1592921265);
INSERT INTO `message` VALUES (124, 86, 2, 3, 1, 1964, 0, 1, 1592921295, 1592921295);
INSERT INTO `message` VALUES (125, 86, 2, 3, 1, 1964, 0, 1, 1592921308, 1592921308);
INSERT INTO `message` VALUES (126, 86, 4, 3, 1, 256, 0, 1, 1592921408, 1592921408);
INSERT INTO `message` VALUES (127, 86, 4, 3, 1, 1960, 0, 1, 1592921428, 1592921428);
INSERT INTO `message` VALUES (128, 83, 4, 3, 1, 512, 0, 1, 1592922431, 1592922431);
INSERT INTO `message` VALUES (129, 83, 2, 3, 1, 1964, 54, 1, 1592923963, 1592923963);
INSERT INTO `message` VALUES (130, 83, 2, 3, 1, 1964, 54, 1, 1592924006, 1592924006);
INSERT INTO `message` VALUES (131, 83, 2, 3, 1, 1964, 54, 1, 1592924054, 1592924054);
INSERT INTO `message` VALUES (132, 83, 2, 3, 1, 1964, 54, 1, 1592924074, 1592924074);
INSERT INTO `message` VALUES (133, 83, 2, 3, 1, 1964, 54, 1, 1592924100, 1592924100);
INSERT INTO `message` VALUES (134, 69, 4, 3, 2, 44, 0, 1, 1592924840, 1592924840);
INSERT INTO `message` VALUES (135, 69, 4, 3, 2, 44, 66, 1, 1592924846, 1592924846);
INSERT INTO `message` VALUES (136, 69, 4, 3, 2, 44, 66, 1, 1592924882, 1592924882);
INSERT INTO `message` VALUES (137, 69, 4, 3, 2, 44, 66, 1, 1592924970, 1592924970);
INSERT INTO `message` VALUES (139, 69, 4, 3, 2, 44, 66, 1, 1592925095, 1592925095);
INSERT INTO `message` VALUES (140, 69, 69, 3, 2, 47, 0, 1, 1592925851, 1592925851);
INSERT INTO `message` VALUES (141, 69, 69, 3, 2, 47, 0, 1, 1592926117, 1592926117);
INSERT INTO `message` VALUES (142, 69, 4, 3, 2, 46, 0, 1, 1592926154, 1592926154);
INSERT INTO `message` VALUES (143, 69, 4, 3, 2, 46, 0, 1, 1592926167, 1592926167);
INSERT INTO `message` VALUES (144, 69, 4, 3, 2, 46, 0, 1, 1592926172, 1592926172);
INSERT INTO `message` VALUES (146, 82, 69, 2, 2, 46, 73, 1, 1592932133, 1592932133);
INSERT INTO `message` VALUES (147, 82, 69, 2, 2, 46, 74, 1, 1592932134, 1592932134);
INSERT INTO `message` VALUES (148, 82, 69, 2, 2, 46, 75, 1, 1592932135, 1592932135);
INSERT INTO `message` VALUES (149, 82, 4, 3, 2, 46, 0, 1, 1592932144, 1592932144);
INSERT INTO `message` VALUES (150, 83, 4, 3, 1, 1961, 0, 1, 1593004385, 1593004385);
INSERT INTO `message` VALUES (151, 83, 4, 3, 1, 1961, 0, 1, 1593004522, 1593004522);
INSERT INTO `message` VALUES (152, 83, 4, 3, 1, 1961, 0, 1, 1593004537, 1593004537);
INSERT INTO `message` VALUES (153, 83, 4, 3, 1, 1961, 0, 1, 1593004700, 1593004700);
INSERT INTO `message` VALUES (154, 83, 4, 3, 1, 1961, 0, 1, 1593004934, 1593004934);
INSERT INTO `message` VALUES (155, 83, 4, 3, 1, 1961, 0, 1, 1593005001, 1593005001);
INSERT INTO `message` VALUES (156, 83, 4, 3, 1, 1961, 0, 1, 1593005080, 1593005080);
INSERT INTO `message` VALUES (157, 83, 4, 3, 1, 1962, 0, 1, 1593005176, 1593005176);
INSERT INTO `message` VALUES (158, 83, 4, 3, 1, 1962, 2, 1, 1593005197, 1593005197);
INSERT INTO `message` VALUES (159, 83, 4, 3, 1, 1963, 0, 1, 1593005260, 1593005260);
INSERT INTO `message` VALUES (160, 83, 4, 3, 1, 1963, 86, 1, 1593005278, 1593005278);
INSERT INTO `message` VALUES (161, 83, 4, 3, 1, 512, 60, 1, 1593005655, 1593005655);
INSERT INTO `message` VALUES (162, 83, 4, 3, 1, 512, 60, 1, 1593005832, 1593005832);
INSERT INTO `message` VALUES (163, 83, 4, 3, 1, 256, 58, 1, 1593006928, 1593006928);
INSERT INTO `message` VALUES (164, 83, 4, 3, 1, 256, 58, 1, 1593006971, 1593006971);
INSERT INTO `message` VALUES (165, 83, 4, 3, 1, 256, 58, 1, 1593007119, 1593007119);
INSERT INTO `message` VALUES (166, 83, 2, 3, 1, 1965, 0, 1, 1593007909, 1593007909);
INSERT INTO `message` VALUES (167, 83, 2, 3, 1, 1965, 93, 1, 1593008150, 1593008150);
INSERT INTO `message` VALUES (168, 83, 2, 3, 1, 1965, 93, 1, 1593008250, 1593008250);
INSERT INTO `message` VALUES (169, 83, 2, 3, 1, 1965, 93, 1, 1593008648, 1593008648);
INSERT INTO `message` VALUES (170, 83, 2, 3, 1, 1965, 93, 1, 1593008701, 1593008701);
INSERT INTO `message` VALUES (171, 83, 2, 3, 1, 1965, 0, 1, 1593008789, 1593008789);
INSERT INTO `message` VALUES (172, 83, 2, 3, 1, 1965, 98, 1, 1593008853, 1593008853);
INSERT INTO `message` VALUES (173, 83, 4, 3, 1, 256, 90, 1, 1593009023, 1593009023);
INSERT INTO `message` VALUES (174, 83, 4, 3, 1, 256, 90, 1, 1593009148, 1593009148);
INSERT INTO `message` VALUES (175, 83, 4, 3, 1, 1963, 86, 1, 1593009298, 1593009298);
INSERT INTO `message` VALUES (176, 83, 4, 3, 1, 1963, 102, 1, 1593009315, 1593009315);
INSERT INTO `message` VALUES (177, 83, 4, 3, 1, 512, 60, 1, 1593009539, 1593009539);
INSERT INTO `message` VALUES (178, 83, 2, 3, 1, 1965, 95, 1, 1593009610, 1593009610);
INSERT INTO `message` VALUES (179, 83, 2, 3, 1, 1965, 0, 1, 1593009699, 1593009699);
INSERT INTO `message` VALUES (180, 86, 4, 3, 1, 1963, 87, 1, 1593009907, 1593009907);
INSERT INTO `message` VALUES (181, 86, 4, 3, 1, 1963, 87, 1, 1593009919, 1593009919);
INSERT INTO `message` VALUES (182, 86, 4, 3, 1, 1963, 103, 1, 1593009926, 1593009926);
INSERT INTO `message` VALUES (183, 4, 4, 3, 1, 1963, 109, 1, 1593010051, 1593010051);
INSERT INTO `message` VALUES (184, 4, 76, 3, 1, 1972, 0, 1, 1593010084, 1593010084);
INSERT INTO `message` VALUES (185, 86, 76, 3, 1, 1972, 111, 1, 1593010104, 1593010104);
INSERT INTO `message` VALUES (186, 4, 76, 3, 1, 1972, 112, 1, 1593010128, 1593010128);
INSERT INTO `message` VALUES (187, 4, 76, 3, 1, 1972, 113, 1, 1593011095, 1593011095);
INSERT INTO `message` VALUES (188, 86, 76, 3, 1, 1972, 112, 1, 1593011112, 1593011112);
INSERT INTO `message` VALUES (189, 86, 76, 3, 1, 1972, 114, 1, 1593011132, 1593011132);
INSERT INTO `message` VALUES (190, 4, 76, 3, 1, 1972, 112, 1, 1593011154, 1593011154);
INSERT INTO `message` VALUES (191, 86, 76, 3, 1, 1972, 117, 1, 1593011231, 1593011231);
INSERT INTO `message` VALUES (192, 86, 76, 3, 1, 1972, 111, 1, 1593011255, 1593011255);
INSERT INTO `message` VALUES (193, 86, 76, 3, 1, 1972, 119, 1, 1593011264, 1593011264);
INSERT INTO `message` VALUES (194, 86, 76, 3, 1, 1972, 0, 1, 1593011561, 1593011561);
INSERT INTO `message` VALUES (195, 86, 76, 3, 1, 1972, 0, 1, 1593011818, 1593011818);
INSERT INTO `message` VALUES (196, 86, 76, 3, 1, 1972, 0, 1, 1593011981, 1593011981);
INSERT INTO `message` VALUES (197, 86, 76, 3, 1, 1972, 0, 1, 1593012564, 1593012564);
INSERT INTO `message` VALUES (198, 86, 76, 3, 1, 1972, 0, 1, 1593012717, 1593012717);
INSERT INTO `message` VALUES (199, 86, 2, 3, 1, 1964, 0, 1, 1593012755, 1593012755);
INSERT INTO `message` VALUES (200, 86, 2, 3, 1, 1965, 0, 1, 1593012772, 1593012772);
INSERT INTO `message` VALUES (201, 86, 4, 3, 1, 1960, 0, 1, 1593012894, 1593012894);
INSERT INTO `message` VALUES (202, 86, 4, 3, 1, 1960, 0, 1, 1593013082, 1593013082);
INSERT INTO `message` VALUES (203, 86, 4, 3, 1, 512, 0, 1, 1593013158, 1593013158);
INSERT INTO `message` VALUES (204, 86, 4, 3, 1, 512, 0, 1, 1593013250, 1593013250);
INSERT INTO `message` VALUES (205, 86, 4, 3, 1, 512, 0, 1, 1593013250, 1593013250);
INSERT INTO `message` VALUES (206, 86, 4, 3, 1, 512, 0, 1, 1593013250, 1593013250);
INSERT INTO `message` VALUES (207, 86, 4, 3, 1, 512, 0, 1, 1593013250, 1593013250);
INSERT INTO `message` VALUES (208, 86, 4, 3, 1, 512, 0, 1, 1593013251, 1593013251);
INSERT INTO `message` VALUES (209, 86, 4, 3, 1, 512, 0, 1, 1593013251, 1593013251);
INSERT INTO `message` VALUES (210, 86, 2, 3, 1, 1965, 0, 1, 1593013270, 1593013270);
INSERT INTO `message` VALUES (211, 86, 4, 3, 1, 768, 0, 1, 1593013288, 1593013288);
INSERT INTO `message` VALUES (212, 86, 4, 3, 1, 768, 0, 1, 1593013342, 1593013342);
INSERT INTO `message` VALUES (213, 86, 4, 3, 1, 768, 0, 1, 1593013392, 1593013392);
INSERT INTO `message` VALUES (214, 86, 4, 3, 1, 768, 0, 1, 1593013404, 1593013404);
INSERT INTO `message` VALUES (215, 86, 4, 3, 1, 1, 0, 1, 1593013563, 1593013563);
INSERT INTO `message` VALUES (216, 86, 4, 3, 1, 1, 0, 1, 1593013654, 1593013654);
INSERT INTO `message` VALUES (217, 86, 4, 3, 1, 1963, 0, 1, 1593013902, 1593013902);
INSERT INTO `message` VALUES (218, 86, 4, 3, 1, 1963, 0, 1, 1593013996, 1593013996);
INSERT INTO `message` VALUES (219, 86, 4, 3, 1, 1963, 0, 1, 1593014010, 1593014010);
INSERT INTO `message` VALUES (220, 86, 4, 3, 1, 1963, 0, 1, 1593014042, 1593014042);
INSERT INTO `message` VALUES (221, 86, 4, 3, 1, 1963, 0, 1, 1593014101, 1593014101);
INSERT INTO `message` VALUES (222, 86, 4, 3, 1, 1963, 0, 1, 1593014126, 1593014126);
INSERT INTO `message` VALUES (223, 86, 75, 3, 1, 1968, 0, 1, 1593014387, 1593014387);
INSERT INTO `message` VALUES (224, 86, 4, 3, 1, 256, 0, 1, 1593014652, 1593014652);
INSERT INTO `message` VALUES (225, 76, 4, 3, 1, 256, 0, 1, 1593016549, 1593016549);
INSERT INTO `message` VALUES (226, 76, 4, 3, 1, 256, 58, 1, 1593016561, 1593016561);
INSERT INTO `message` VALUES (227, 76, 4, 3, 1, 256, 92, 1, 1593016571, 1593016571);
INSERT INTO `message` VALUES (229, 26, 4, 2, 2, 43, 0, 1, 1593237208, 1593237208);
INSERT INTO `message` VALUES (230, 26, 4, 2, 2, 44, 0, 1, 1593237230, 1593237230);
INSERT INTO `message` VALUES (231, 26, 26, 2, 2, 50, 0, 1, 1593237450, 1593237450);
INSERT INTO `message` VALUES (232, 26, 69, 2, 2, 39, 0, 1, 1593237728, 1593237728);
INSERT INTO `message` VALUES (233, 26, 69, 3, 2, 39, 0, 1, 1593237765, 1593237765);
INSERT INTO `message` VALUES (235, 26, 26, 2, 2, 39, 155, 1, 1593237773, 1593237773);
INSERT INTO `message` VALUES (236, 82, 69, 2, 2, 39, 0, 1, 1593237912, 1593237912);
INSERT INTO `message` VALUES (237, 82, 69, 2, 2, 25, 0, 2, 1593923203, 1593238669);
INSERT INTO `message` VALUES (239, 69, 82, 2, 2, 52, 0, 1, 1593245493, 1593245493);
INSERT INTO `message` VALUES (247, 69, 69, 2, 2, 31, 0, 0, 1593923196, 1593251852);
INSERT INTO `message` VALUES (259, 90, 69, 2, 2, 32, 0, 1, 1593277677, 1593277677);
INSERT INTO `message` VALUES (263, 90, 82, 1, 0, 0, 0, 1, 1593278321, 1593278321);
INSERT INTO `message` VALUES (265, 90, 82, 2, 2, 52, 0, 1, 1593278331, 1593278331);
INSERT INTO `message` VALUES (266, 90, 82, 3, 2, 52, 0, 1, 1593278336, 1593278336);
INSERT INTO `message` VALUES (268, 90, 90, 2, 2, 54, 0, 1, 1593278674, 1593278674);
INSERT INTO `message` VALUES (271, 69, 5, 1, 0, 0, 0, 1, 1593278951, 1593278951);
INSERT INTO `message` VALUES (272, 76, 4, 3, 1, 1962, 11, 1, 1593338510, 1593338510);
INSERT INTO `message` VALUES (275, 69, 90, 1, 0, 0, 0, 1, 1593357536, 1593357536);
INSERT INTO `message` VALUES (276, 69, 82, 1, 0, 0, 0, 1, 1593359939, 1593359939);
INSERT INTO `message` VALUES (278, 75, 4, 3, 1, 1961, 158, 1, 1593418215, 1593418215);
INSERT INTO `message` VALUES (279, 75, 4, 3, 1, 1962, 159, 1, 1593418533, 1593418533);
INSERT INTO `message` VALUES (280, 75, 4, 3, 1, 1962, 160, 1, 1593418742, 1593418742);
INSERT INTO `message` VALUES (281, 75, 68, 3, 1, 1975, 161, 1, 1593418806, 1593418806);
INSERT INTO `message` VALUES (282, 75, 68, 3, 1, 1975, 162, 1, 1593418817, 1593418817);
INSERT INTO `message` VALUES (283, 75, 68, 3, 1, 1975, 161, 1, 1593418824, 1593418824);
INSERT INTO `message` VALUES (284, 75, 68, 3, 1, 1975, 163, 1, 1593418830, 1593418830);
INSERT INTO `message` VALUES (285, 75, 68, 3, 1, 1975, 161, 1, 1593418839, 1593418839);
INSERT INTO `message` VALUES (286, 75, 68, 3, 1, 1975, 161, 1, 1593418948, 1593418948);
INSERT INTO `message` VALUES (287, 75, 68, 3, 1, 1975, 166, 1, 1593418956, 1593418956);
INSERT INTO `message` VALUES (288, 75, 68, 3, 1, 1975, 161, 1, 1593418963, 1593418963);
INSERT INTO `message` VALUES (289, 75, 68, 3, 1, 1975, 161, 1, 1593420183, 1593420183);
INSERT INTO `message` VALUES (290, 75, 68, 3, 1, 1975, 161, 1, 1593420241, 1593420241);
INSERT INTO `message` VALUES (291, 75, 68, 3, 1, 1975, 169, 1, 1593420333, 1593420333);
INSERT INTO `message` VALUES (292, 91, 4, 3, 1, 1961, 83, 1, 1593420750, 1593420750);
INSERT INTO `message` VALUES (293, 91, 4, 3, 1, 1961, 83, 1, 1593420856, 1593420856);
INSERT INTO `message` VALUES (294, 91, 4, 3, 1, 1961, 79, 1, 1593421240, 1593421240);
INSERT INTO `message` VALUES (295, 91, 4, 3, 1, 1961, 79, 1, 1593421259, 1593421259);
INSERT INTO `message` VALUES (296, 75, 4, 3, 1, 1, 176, 1, 1593421986, 1593421986);
INSERT INTO `message` VALUES (297, 91, 4, 3, 1, 1961, 177, 1, 1593425005, 1593425005);
INSERT INTO `message` VALUES (298, 75, 68, 3, 1, 1975, 178, 1, 1593426296, 1593426296);
INSERT INTO `message` VALUES (299, 75, 68, 3, 1, 1975, 179, 1, 1593426352, 1593426352);
INSERT INTO `message` VALUES (300, 75, 68, 3, 1, 1975, 180, 1, 1593426380, 1593426380);
INSERT INTO `message` VALUES (301, 75, 68, 3, 1, 1975, 181, 1, 1593426395, 1593426395);
INSERT INTO `message` VALUES (302, 75, 68, 3, 1, 1975, 182, 1, 1593426401, 1593426401);
INSERT INTO `message` VALUES (303, 75, 68, 3, 1, 1975, 183, 1, 1593426410, 1593426410);
INSERT INTO `message` VALUES (304, 75, 75, 3, 1, 1971, 184, 1, 1593426540, 1593426540);
INSERT INTO `message` VALUES (305, 75, 75, 3, 1, 1971, 185, 1, 1593426570, 1593426570);
INSERT INTO `message` VALUES (306, 75, 76, 3, 1, 1972, 186, 1, 1593427140, 1593427140);
INSERT INTO `message` VALUES (307, 75, 75, 3, 1, 1971, 187, 1, 1593427192, 1593427192);
INSERT INTO `message` VALUES (308, 75, 75, 3, 1, 1971, 188, 1, 1593427297, 1593427297);
INSERT INTO `message` VALUES (309, 75, 75, 3, 1, 1970, 189, 1, 1593427361, 1593427361);
INSERT INTO `message` VALUES (310, 75, 75, 3, 1, 1970, 190, 1, 1593427467, 1593427467);
INSERT INTO `message` VALUES (311, 91, 75, 3, 1, 1970, 191, 1, 1593427656, 1593427656);
INSERT INTO `message` VALUES (312, 91, 75, 3, 1, 1970, 192, 1, 1593427758, 1593427758);
INSERT INTO `message` VALUES (313, 86, 75, 3, 1, 1969, 193, 1, 1593441497, 1593441497);
INSERT INTO `message` VALUES (314, 86, 75, 3, 1, 1969, 193, 1, 1593441826, 1593441826);
INSERT INTO `message` VALUES (315, 86, 75, 3, 1, 1969, 194, 1, 1593441832, 1593441832);
INSERT INTO `message` VALUES (316, 86, 75, 3, 1, 1969, 193, 1, 1593441838, 1593441838);
INSERT INTO `message` VALUES (317, 86, 75, 3, 1, 1971, 197, 1, 1593442225, 1593442225);
INSERT INTO `message` VALUES (318, 86, 75, 3, 1, 1971, 198, 1, 1593442418, 1593442418);
INSERT INTO `message` VALUES (319, 86, 75, 3, 1, 1971, 199, 1, 1593442431, 1593442431);
INSERT INTO `message` VALUES (320, 86, 75, 3, 1, 1971, 200, 1, 1593442444, 1593442444);
INSERT INTO `message` VALUES (321, 86, 75, 3, 1, 1971, 201, 1, 1593442492, 1593442492);
INSERT INTO `message` VALUES (322, 86, 75, 3, 1, 1968, 202, 1, 1593442997, 1593442997);
INSERT INTO `message` VALUES (323, 86, 75, 3, 1, 1968, 203, 1, 1593443013, 1593443013);
INSERT INTO `message` VALUES (324, 86, 75, 3, 1, 1968, 204, 1, 1593443020, 1593443020);
INSERT INTO `message` VALUES (325, 86, 75, 3, 1, 1968, 205, 1, 1593443159, 1593443159);
INSERT INTO `message` VALUES (326, 86, 75, 3, 1, 1967, 206, 1, 1593443559, 1593443559);
INSERT INTO `message` VALUES (327, 86, 75, 3, 1, 1967, 207, 1, 1593443736, 1593443736);
INSERT INTO `message` VALUES (328, 86, 75, 3, 1, 1967, 208, 1, 1593444017, 1593444017);
INSERT INTO `message` VALUES (329, 86, 75, 3, 1, 1967, 209, 1, 1593444094, 1593444094);
INSERT INTO `message` VALUES (330, 86, 75, 3, 1, 1967, 210, 1, 1593444128, 1593444128);
INSERT INTO `message` VALUES (331, 86, 75, 3, 1, 1967, 211, 1, 1593444139, 1593444139);
INSERT INTO `message` VALUES (332, 86, 75, 3, 1, 1967, 212, 1, 1593444252, 1593444252);
INSERT INTO `message` VALUES (333, 86, 75, 3, 1, 1967, 213, 1, 1593444332, 1593444332);
INSERT INTO `message` VALUES (334, 86, 75, 3, 1, 1967, 214, 1, 1593444403, 1593444403);
INSERT INTO `message` VALUES (335, 86, 75, 3, 1, 1967, 215, 1, 1593444413, 1593444413);
INSERT INTO `message` VALUES (343, 86, 4, 3, 1, 1, 216, 1, 1593526919, 1593526919);
INSERT INTO `message` VALUES (344, 90, 69, 1, 0, 0, 0, 2, 1593922950, 1593527481);
INSERT INTO `message` VALUES (346, 69, 90, 2, 2, 54, 0, 1, 1593609847, 1593609847);
INSERT INTO `message` VALUES (347, 69, 90, 3, 2, 54, 217, 1, 1593613582, 1593613582);
INSERT INTO `message` VALUES (349, 69, 90, 3, 2, 54, 217, 1, 1593613594, 1593613594);
INSERT INTO `message` VALUES (350, 69, 90, 3, 2, 54, 218, 1, 1593613617, 1593613617);
INSERT INTO `message` VALUES (352, 82, 26, 1, 0, 0, 0, 1, 1593673180, 1593673180);
INSERT INTO `message` VALUES (353, 78, 4, 3, 1, 1960, 220, 1, 1593673879, 1593673879);
INSERT INTO `message` VALUES (356, 26, 82, 1, 0, 0, 0, 1, 1593689847, 1593689847);
INSERT INTO `message` VALUES (358, 26, 82, 2, 2, 52, 0, 1, 1593690142, 1593690142);
INSERT INTO `message` VALUES (359, 26, 26, 3, 2, 55, 221, 1, 1593690313, 1593690313);
INSERT INTO `message` VALUES (360, 26, 4, 3, 2, 46, 73, 1, 1593691273, 1593691273);
INSERT INTO `message` VALUES (361, 26, 26, 2, 2, 46, 222, 1, 1593691284, 1593691284);
INSERT INTO `message` VALUES (362, 26, 26, 2, 2, 55, 0, 1, 1593691320, 1593691320);
INSERT INTO `message` VALUES (363, 26, 26, 3, 2, 55, 223, 1, 1593691368, 1593691368);
INSERT INTO `message` VALUES (364, 26, 69, 1, 0, 0, 0, 0, 1593923181, 1593692154);
INSERT INTO `message` VALUES (365, 26, 69, 2, 2, 32, 0, 2, 1593922417, 1593692164);
INSERT INTO `message` VALUES (366, 26, 5, 2, 2, 1, 0, 1, 1593692242, 1593692242);
INSERT INTO `message` VALUES (367, 69, 26, 3, 2, 55, 224, 1, 1593701250, 1593701250);
INSERT INTO `message` VALUES (369, 69, 26, 2, 2, 56, 0, 1, 1593701275, 1593701275);
INSERT INTO `message` VALUES (370, 69, 26, 1, 0, 0, 0, 1, 1593705658, 1593705658);
INSERT INTO `message` VALUES (371, 82, 26, 3, 2, 56, 225, 1, 1593831969, 1593831969);
INSERT INTO `message` VALUES (374, 82, 69, 1, 0, 0, 0, 0, 1593923156, 1593832226);
INSERT INTO `message` VALUES (376, 69, 90, 3, 2, 54, 226, 1, 1593940594, 1593940594);
INSERT INTO `message` VALUES (377, 69, 90, 3, 2, 54, 227, 1, 1593940940, 1593940940);
INSERT INTO `message` VALUES (378, 69, 90, 3, 2, 54, 228, 1, 1593940947, 1593940947);
INSERT INTO `message` VALUES (379, 69, 90, 3, 2, 54, 229, 1, 1593940955, 1593940955);
INSERT INTO `message` VALUES (380, 69, 90, 3, 2, 54, 230, 1, 1593941087, 1593941087);
INSERT INTO `message` VALUES (381, 69, 90, 3, 2, 54, 217, 1, 1593941094, 1593941094);
INSERT INTO `message` VALUES (382, 69, 90, 3, 2, 54, 217, 1, 1593941530, 1593941530);
INSERT INTO `message` VALUES (383, 69, 90, 3, 2, 54, 217, 1, 1593941541, 1593941541);
INSERT INTO `message` VALUES (384, 69, 90, 3, 2, 54, 217, 1, 1593941575, 1593941575);
INSERT INTO `message` VALUES (385, 69, 90, 3, 2, 54, 217, 1, 1593941615, 1593941615);
INSERT INTO `message` VALUES (386, 69, 90, 3, 2, 54, 234, 1, 1593941625, 1593941625);
INSERT INTO `message` VALUES (387, 69, 90, 3, 2, 54, 234, 1, 1593941650, 1593941650);
INSERT INTO `message` VALUES (388, 69, 90, 3, 2, 54, 235, 1, 1593941880, 1593941880);
INSERT INTO `message` VALUES (389, 69, 90, 3, 2, 54, 234, 1, 1593951562, 1593951562);
INSERT INTO `message` VALUES (390, 69, 90, 3, 2, 54, 235, 1, 1593951689, 1593951689);
INSERT INTO `message` VALUES (391, 69, 90, 3, 2, 54, 217, 1, 1593952398, 1593952398);
INSERT INTO `message` VALUES (392, 76, 4, 3, 1, 1961, 172, 1, 1593954994, 1593954994);
INSERT INTO `message` VALUES (393, 69, 90, 3, 2, 54, 218, 1, 1593956778, 1593956778);
INSERT INTO `message` VALUES (394, 69, 69, 4, 2, 54, 218, 1, 1593956778, 1593956778);
INSERT INTO `message` VALUES (395, 69, 90, 3, 2, 54, 234, 1, 1593956904, 1593956904);
INSERT INTO `message` VALUES (396, 69, 69, 4, 2, 54, 234, 1, 1593956904, 1593956904);
INSERT INTO `message` VALUES (397, 69, 90, 3, 2, 54, 217, 1, 1593957215, 1593957215);
INSERT INTO `message` VALUES (398, 69, 90, 3, 2, 54, 228, 1, 1593957277, 1593957277);
INSERT INTO `message` VALUES (399, 69, 90, 3, 2, 54, 228, 1, 1593957282, 1593957282);
INSERT INTO `message` VALUES (400, 69, 90, 3, 2, 54, 246, 1, 1593957291, 1593957291);
INSERT INTO `message` VALUES (401, 69, 69, 4, 2, 54, 246, 1, 1593957291, 1593957291);
INSERT INTO `message` VALUES (402, 69, 90, 3, 2, 54, 249, 1, 1593957346, 1593957346);
INSERT INTO `message` VALUES (403, 69, 90, 3, 2, 54, 217, 1, 1593957356, 1593957356);
INSERT INTO `message` VALUES (404, 69, 90, 3, 2, 54, 228, 1, 1593957364, 1593957364);
INSERT INTO `message` VALUES (405, 69, 90, 3, 2, 54, 249, 1, 1593957780, 1593957780);
INSERT INTO `message` VALUES (406, 69, 90, 3, 2, 54, 252, 1, 1593957800, 1593957800);
INSERT INTO `message` VALUES (407, 69, 69, 4, 2, 54, 252, 2, 1594129157, 1593957800);
INSERT INTO `message` VALUES (408, 69, 90, 3, 2, 54, 253, 1, 1593962864, 1593962864);
INSERT INTO `message` VALUES (409, 90, 90, 3, 2, 54, 254, 1, 1593963046, 1593963046);
INSERT INTO `message` VALUES (410, 69, 90, 3, 2, 54, 228, 1, 1593963735, 1593963735);
INSERT INTO `message` VALUES (411, 4, 68, 3, 1, 1975, 170, 1, 1593963973, 1593963973);
INSERT INTO `message` VALUES (412, 4, 68, 3, 1, 1975, 170, 1, 1593964011, 1593964011);
INSERT INTO `message` VALUES (413, 4, 68, 3, 1, 1975, 182, 1, 1593964028, 1593964028);
INSERT INTO `message` VALUES (414, 4, 68, 3, 1, 1975, 259, 1, 1593964044, 1593964044);
INSERT INTO `message` VALUES (415, 69, 90, 3, 2, 54, 253, 1, 1593965960, 1593965960);
INSERT INTO `message` VALUES (416, 69, 90, 3, 2, 54, 255, 1, 1593965978, 1593965978);
INSERT INTO `message` VALUES (417, 69, 90, 3, 2, 54, 261, 1, 1593965998, 1593965998);
INSERT INTO `message` VALUES (418, 69, 90, 3, 2, 54, 255, 1, 1593966086, 1593966086);
INSERT INTO `message` VALUES (419, 69, 90, 3, 2, 54, 264, 1, 1593966232, 1593966232);
INSERT INTO `message` VALUES (420, 69, 69, 3, 2, 58, 266, 1, 1594048246, 1594048246);
INSERT INTO `message` VALUES (421, 69, 69, 3, 2, 58, 267, 1, 1594048314, 1594048314);
INSERT INTO `message` VALUES (422, 69, 69, 3, 2, 58, 267, 2, 1594128285, 1594048321);
INSERT INTO `message` VALUES (423, 69, 69, 3, 2, 58, 268, 2, 1594129302, 1594048327);
INSERT INTO `message` VALUES (424, 69, 69, 3, 2, 58, 268, 1, 1594048334, 1594048334);
INSERT INTO `message` VALUES (425, 69, 69, 3, 2, 58, 267, 2, 1594048547, 1594048341);
INSERT INTO `message` VALUES (426, 69, 69, 3, 2, 58, 272, 2, 1594128193, 1594048429);
INSERT INTO `message` VALUES (427, 69, 26, 3, 2, 56, 273, 1, 1594128351, 1594128351);
INSERT INTO `message` VALUES (428, 69, 26, 3, 2, 56, 225, 1, 1594128355, 1594128355);
INSERT INTO `message` VALUES (429, 69, 26, 3, 2, 56, 274, 1, 1594128363, 1594128363);
INSERT INTO `message` VALUES (430, 69, 69, 2, 2, 56, 273, 1, 1594129787, 1594129787);
INSERT INTO `message` VALUES (432, 16, 68, 2, 1, 1975, 0, 1, 1594186420, 1594186420);
INSERT INTO `message` VALUES (433, 16, 75, 2, 1, 1971, 0, 1, 1594199907, 1594199907);
INSERT INTO `message` VALUES (434, 105, 4, 3, 1, 1960, 59, 1, 1594475462, 1594475462);
INSERT INTO `message` VALUES (435, 115, 68, 2, 1, 1975, 0, 1, 1595924778, 1595924778);
INSERT INTO `message` VALUES (436, 122, 116, 2, 1, 1978, 0, 1, 1596854480, 1596854480);
INSERT INTO `message` VALUES (437, 22, 68, 2, 1, 1975, 0, 1, 1597335183, 1597335183);
INSERT INTO `message` VALUES (439, 22, 76, 2, 1, 1972, 0, 1, 1597338546, 1597338546);
INSERT INTO `message` VALUES (440, 143, 76, 2, 1, 1972, 0, 1, 1606223946, 1606223946);
INSERT INTO `message` VALUES (441, 143, 75, 2, 1, 1971, 0, 1, 1606223955, 1606223955);
INSERT INTO `message` VALUES (442, 143, 75, 2, 1, 1970, 0, 1, 1606223956, 1606223956);
INSERT INTO `message` VALUES (443, 143, 75, 2, 1, 1969, 0, 1, 1606223958, 1606223958);
INSERT INTO `message` VALUES (444, 5, 4, 2, 1, 320, 0, 1, 1606364214, 1606364214);
INSERT INTO `message` VALUES (445, 5, 4, 2, 1, 886, 0, 1, 1606364408, 1606364408);
INSERT INTO `message` VALUES (447, 5, 4, 2, 1, 1247, 0, 1, 1606364478, 1606364478);
INSERT INTO `message` VALUES (448, 5, 4, 2, 1, 897, 0, 1, 1606389779, 1606389779);
INSERT INTO `message` VALUES (449, 5, 4, 2, 1, 826, 0, 1, 1606389952, 1606389952);
INSERT INTO `message` VALUES (450, 5, 4, 2, 1, 1394, 0, 1, 1606389999, 1606389999);
INSERT INTO `message` VALUES (451, 5, 4, 2, 1, 1949, 0, 1, 1606390167, 1606390167);
INSERT INTO `message` VALUES (452, 5, 4, 2, 1, 464, 0, 1, 1606393001, 1606393001);
INSERT INTO `message` VALUES (453, 5, 4, 2, 1, 1727, 0, 1, 1606393588, 1606393588);
INSERT INTO `message` VALUES (454, 5, 4, 2, 1, 1851, 0, 1, 1606395455, 1606395455);
INSERT INTO `message` VALUES (455, 5, 4, 2, 1, 1342, 0, 1, 1606401509, 1606401509);
INSERT INTO `message` VALUES (456, 5, 4, 1, 0, 0, 0, 1, 1606401748, 1606401748);
INSERT INTO `message` VALUES (457, 5, 4, 2, 1, 1257, 0, 1, 1606565198, 1606565198);
INSERT INTO `message` VALUES (458, 5, 4, 2, 1, 535, 0, 1, 1606582312, 1606582312);
INSERT INTO `message` VALUES (459, 5, 4, 2, 1, 1489, 0, 1, 1606724632, 1606724632);
INSERT INTO `message` VALUES (460, 5, 4, 2, 1, 1818, 0, 1, 1606726474, 1606726474);
INSERT INTO `message` VALUES (461, 5, 4, 2, 1, 211, 0, 1, 1606726607, 1606726607);
INSERT INTO `message` VALUES (462, 5, 4, 2, 1, 700, 0, 1, 1606807242, 1606807242);
INSERT INTO `message` VALUES (463, 146, 76, 2, 1, 1972, 0, 1, 1606811937, 1606811937);
INSERT INTO `message` VALUES (464, 5, 4, 2, 1, 1077, 0, 1, 1606833771, 1606833771);
INSERT INTO `message` VALUES (466, 5, 4, 2, 1, 1212, 0, 1, 1607085438, 1607085438);
INSERT INTO `message` VALUES (468, 5, 4, 2, 1, 1782, 0, 1, 1607090613, 1607090613);
INSERT INTO `message` VALUES (469, 5, 4, 3, 1, 232, 277, 1, 1607160421, 1607160421);
INSERT INTO `message` VALUES (470, 5, 4, 3, 1, 568, 278, 1, 1607160456, 1607160456);
INSERT INTO `message` VALUES (471, 5, 4, 3, 1, 175, 279, 1, 1607160477, 1607160477);
INSERT INTO `message` VALUES (472, 5, 4, 3, 1, 332, 280, 1, 1607160562, 1607160562);
INSERT INTO `message` VALUES (473, 5, 4, 3, 1, 750, 281, 1, 1607160581, 1607160581);
INSERT INTO `message` VALUES (474, 5, 4, 3, 1, 1691, 282, 1, 1607160719, 1607160719);
INSERT INTO `message` VALUES (475, 5, 4, 3, 1, 1691, 283, 1, 1607160724, 1607160724);
INSERT INTO `message` VALUES (476, 5, 4, 3, 1, 1691, 284, 1, 1607160727, 1607160727);
INSERT INTO `message` VALUES (477, 5, 4, 3, 1, 963, 285, 1, 1607161063, 1607161063);
INSERT INTO `message` VALUES (478, 5, 4, 3, 1, 412, 286, 1, 1607161244, 1607161244);
INSERT INTO `message` VALUES (479, 5, 4, 3, 1, 589, 287, 1, 1607161273, 1607161273);
INSERT INTO `message` VALUES (480, 5, 4, 3, 1, 589, 288, 1, 1607161276, 1607161276);
INSERT INTO `message` VALUES (481, 5, 4, 3, 1, 589, 289, 1, 1607161281, 1607161281);
INSERT INTO `message` VALUES (482, 5, 4, 3, 1, 1042, 290, 1, 1607161361, 1607161361);
INSERT INTO `message` VALUES (483, 5, 4, 3, 1, 1042, 291, 1, 1607161364, 1607161364);
INSERT INTO `message` VALUES (484, 5, 4, 3, 1, 1486, 292, 1, 1607162198, 1607162198);
INSERT INTO `message` VALUES (485, 5, 4, 3, 1, 1627, 293, 1, 1607162493, 1607162493);
INSERT INTO `message` VALUES (486, 5, 4, 3, 1, 898, 294, 1, 1607162515, 1607162515);
INSERT INTO `message` VALUES (487, 5, 4, 3, 1, 1535, 295, 1, 1607162577, 1607162577);
INSERT INTO `message` VALUES (488, 5, 4, 3, 1, 1535, 296, 1, 1607162580, 1607162580);
INSERT INTO `message` VALUES (489, 5, 4, 3, 1, 1556, 297, 1, 1607162592, 1607162592);
INSERT INTO `message` VALUES (490, 5, 4, 3, 1, 1122, 298, 1, 1607162610, 1607162610);
INSERT INTO `message` VALUES (491, 5, 4, 3, 1, 444, 299, 1, 1607162665, 1607162665);
INSERT INTO `message` VALUES (492, 5, 4, 3, 1, 459, 300, 1, 1607162676, 1607162676);
INSERT INTO `message` VALUES (493, 5, 4, 3, 1, 192, 301, 1, 1607162689, 1607162689);
INSERT INTO `message` VALUES (494, 5, 4, 3, 1, 192, 302, 1, 1607162691, 1607162691);
INSERT INTO `message` VALUES (495, 5, 4, 3, 1, 192, 303, 1, 1607162694, 1607162694);
INSERT INTO `message` VALUES (496, 5, 4, 3, 1, 622, 304, 1, 1607162771, 1607162771);
INSERT INTO `message` VALUES (497, 5, 4, 3, 1, 622, 305, 1, 1607162776, 1607162776);
INSERT INTO `message` VALUES (498, 5, 4, 3, 1, 622, 306, 1, 1607162780, 1607162780);
INSERT INTO `message` VALUES (499, 5, 4, 3, 1, 1624, 307, 1, 1607162910, 1607162910);
INSERT INTO `message` VALUES (500, 5, 4, 3, 1, 1624, 308, 1, 1607162914, 1607162914);
INSERT INTO `message` VALUES (501, 5, 4, 3, 1, 377, 309, 1, 1607162926, 1607162926);
INSERT INTO `message` VALUES (502, 5, 4, 3, 1, 377, 310, 1, 1607162935, 1607162935);
INSERT INTO `message` VALUES (503, 5, 4, 3, 1, 71, 311, 1, 1607162973, 1607162973);
INSERT INTO `message` VALUES (504, 5, 4, 3, 1, 71, 312, 1, 1607162984, 1607162984);
INSERT INTO `message` VALUES (505, 5, 4, 3, 1, 239, 313, 1, 1607163060, 1607163060);
INSERT INTO `message` VALUES (506, 5, 4, 3, 1, 1388, 314, 1, 1607163249, 1607163249);
INSERT INTO `message` VALUES (507, 5, 4, 3, 1, 1708, 315, 1, 1607163313, 1607163313);
INSERT INTO `message` VALUES (508, 5, 4, 3, 1, 1220, 316, 1, 1607163451, 1607163451);
INSERT INTO `message` VALUES (509, 5, 4, 3, 1, 1296, 317, 1, 1607163557, 1607163557);
INSERT INTO `message` VALUES (510, 5, 4, 3, 1, 386, 318, 1, 1607163621, 1607163621);
INSERT INTO `message` VALUES (511, 5, 4, 3, 1, 918, 319, 1, 1607163656, 1607163656);
INSERT INTO `message` VALUES (512, 5, 4, 3, 1, 918, 320, 1, 1607163665, 1607163665);
INSERT INTO `message` VALUES (513, 5, 4, 3, 1, 918, 321, 1, 1607163675, 1607163675);
INSERT INTO `message` VALUES (514, 5, 4, 3, 1, 1300, 322, 1, 1607163700, 1607163700);
INSERT INTO `message` VALUES (515, 5, 4, 3, 1, 1300, 323, 1, 1607163716, 1607163716);
INSERT INTO `message` VALUES (516, 5, 4, 3, 1, 598, 324, 1, 1607163771, 1607163771);
INSERT INTO `message` VALUES (517, 5, 4, 3, 1, 598, 325, 1, 1607163916, 1607163916);
INSERT INTO `message` VALUES (518, 5, 4, 3, 1, 1307, 326, 1, 1607164009, 1607164009);
INSERT INTO `message` VALUES (519, 5, 4, 3, 1, 1525, 327, 1, 1607164045, 1607164045);
INSERT INTO `message` VALUES (520, 5, 4, 3, 1, 1596, 328, 1, 1607164153, 1607164153);
INSERT INTO `message` VALUES (521, 5, 4, 3, 1, 1594, 329, 1, 1607164191, 1607164191);
INSERT INTO `message` VALUES (522, 5, 4, 3, 1, 1594, 330, 1, 1607164197, 1607164197);
INSERT INTO `message` VALUES (523, 5, 4, 3, 1, 1780, 331, 1, 1607164232, 1607164232);
INSERT INTO `message` VALUES (524, 5, 4, 3, 1, 1912, 332, 1, 1607164245, 1607164245);
INSERT INTO `message` VALUES (525, 5, 4, 3, 1, 291, 333, 1, 1607164348, 1607164348);
INSERT INTO `message` VALUES (526, 5, 4, 3, 1, 163, 334, 1, 1607164393, 1607164393);
INSERT INTO `message` VALUES (527, 5, 4, 3, 1, 219, 335, 1, 1607164412, 1607164412);
INSERT INTO `message` VALUES (528, 5, 4, 3, 1, 986, 336, 1, 1607164457, 1607164457);
INSERT INTO `message` VALUES (529, 5, 4, 3, 1, 1442, 337, 1, 1607164493, 1607164493);
INSERT INTO `message` VALUES (530, 5, 4, 3, 1, 1765, 338, 1, 1607164519, 1607164519);
INSERT INTO `message` VALUES (531, 5, 4, 3, 1, 1320, 339, 1, 1607164539, 1607164539);
INSERT INTO `message` VALUES (532, 5, 4, 3, 1, 16, 340, 1, 1607164606, 1607164606);
INSERT INTO `message` VALUES (533, 5, 4, 3, 1, 470, 341, 1, 1607164624, 1607164624);
INSERT INTO `message` VALUES (534, 5, 4, 3, 1, 483, 342, 1, 1607164757, 1607164757);
INSERT INTO `message` VALUES (535, 5, 4, 3, 1, 893, 343, 1, 1607164772, 1607164772);
INSERT INTO `message` VALUES (536, 5, 4, 3, 1, 1448, 344, 1, 1607164785, 1607164785);
INSERT INTO `message` VALUES (537, 5, 4, 3, 1, 823, 345, 1, 1607164801, 1607164801);
INSERT INTO `message` VALUES (538, 5, 4, 3, 1, 584, 346, 1, 1607164899, 1607164899);
INSERT INTO `message` VALUES (539, 5, 4, 3, 1, 363, 347, 1, 1607164954, 1607164954);
INSERT INTO `message` VALUES (540, 5, 4, 3, 1, 1120, 348, 1, 1607165011, 1607165011);
INSERT INTO `message` VALUES (541, 5, 4, 3, 1, 1120, 349, 1, 1607165022, 1607165022);
INSERT INTO `message` VALUES (542, 5, 4, 3, 1, 753, 350, 1, 1607165042, 1607165042);
INSERT INTO `message` VALUES (543, 5, 4, 3, 1, 1178, 351, 1, 1607165081, 1607165081);
INSERT INTO `message` VALUES (544, 5, 4, 3, 1, 1182, 352, 1, 1607165449, 1607165449);
INSERT INTO `message` VALUES (545, 5, 4, 3, 1, 1174, 353, 1, 1607165470, 1607165470);
INSERT INTO `message` VALUES (546, 5, 4, 3, 1, 549, 354, 1, 1607165485, 1607165485);
INSERT INTO `message` VALUES (547, 5, 4, 3, 1, 549, 355, 1, 1607165487, 1607165487);
INSERT INTO `message` VALUES (548, 5, 4, 3, 1, 633, 356, 1, 1607165744, 1607165744);
INSERT INTO `message` VALUES (549, 5, 4, 3, 1, 1105, 357, 1, 1607165834, 1607165834);
INSERT INTO `message` VALUES (550, 5, 4, 3, 1, 1820, 358, 1, 1607165877, 1607165877);
INSERT INTO `message` VALUES (551, 5, 4, 3, 1, 237, 359, 1, 1607165981, 1607165981);
INSERT INTO `message` VALUES (552, 5, 4, 3, 1, 1184, 360, 1, 1607166019, 1607166019);
INSERT INTO `message` VALUES (553, 5, 4, 3, 1, 1112, 361, 1, 1607166032, 1607166032);
INSERT INTO `message` VALUES (554, 5, 4, 3, 1, 1112, 362, 1, 1607166037, 1607166037);
INSERT INTO `message` VALUES (555, 5, 4, 3, 1, 1112, 363, 1, 1607166040, 1607166040);
INSERT INTO `message` VALUES (556, 5, 4, 3, 1, 172, 364, 1, 1607166105, 1607166105);
INSERT INTO `message` VALUES (557, 5, 4, 3, 1, 172, 365, 1, 1607166108, 1607166108);
INSERT INTO `message` VALUES (558, 5, 4, 3, 1, 797, 366, 1, 1607166139, 1607166139);
INSERT INTO `message` VALUES (559, 5, 4, 3, 1, 797, 367, 1, 1607166141, 1607166141);
INSERT INTO `message` VALUES (560, 5, 4, 3, 1, 797, 368, 1, 1607166145, 1607166145);
INSERT INTO `message` VALUES (561, 5, 4, 3, 1, 797, 369, 1, 1607166148, 1607166148);
INSERT INTO `message` VALUES (562, 5, 4, 3, 1, 1075, 370, 1, 1607166208, 1607166208);
INSERT INTO `message` VALUES (563, 5, 4, 3, 1, 1075, 371, 1, 1607166210, 1607166210);
INSERT INTO `message` VALUES (564, 5, 4, 3, 1, 1075, 372, 1, 1607166213, 1607166213);
INSERT INTO `message` VALUES (565, 5, 4, 3, 1, 1075, 373, 1, 1607166216, 1607166216);
INSERT INTO `message` VALUES (566, 5, 4, 3, 1, 1090, 374, 1, 1607166279, 1607166279);
INSERT INTO `message` VALUES (567, 5, 4, 3, 1, 1090, 375, 1, 1607166281, 1607166281);
INSERT INTO `message` VALUES (568, 5, 4, 3, 1, 564, 376, 1, 1607166380, 1607166380);
INSERT INTO `message` VALUES (569, 5, 4, 3, 1, 564, 377, 1, 1607166383, 1607166383);
INSERT INTO `message` VALUES (570, 5, 4, 3, 1, 564, 378, 1, 1607166387, 1607166387);
INSERT INTO `message` VALUES (571, 5, 4, 3, 1, 564, 379, 1, 1607166390, 1607166390);
INSERT INTO `message` VALUES (572, 5, 4, 3, 1, 853, 380, 1, 1607166569, 1607166569);
INSERT INTO `message` VALUES (573, 5, 4, 3, 1, 853, 381, 1, 1607166571, 1607166571);
INSERT INTO `message` VALUES (574, 5, 4, 3, 1, 853, 382, 1, 1607166573, 1607166573);
INSERT INTO `message` VALUES (575, 5, 4, 3, 1, 853, 383, 1, 1607166575, 1607166575);
INSERT INTO `message` VALUES (576, 5, 4, 3, 1, 853, 384, 1, 1607166579, 1607166579);
INSERT INTO `message` VALUES (577, 5, 4, 3, 1, 853, 385, 1, 1607166581, 1607166581);
INSERT INTO `message` VALUES (578, 5, 4, 3, 1, 853, 386, 1, 1607166584, 1607166584);
INSERT INTO `message` VALUES (579, 5, 4, 3, 1, 545, 387, 1, 1607166649, 1607166649);
INSERT INTO `message` VALUES (580, 5, 4, 3, 1, 545, 388, 1, 1607166652, 1607166652);
INSERT INTO `message` VALUES (581, 5, 4, 3, 1, 545, 389, 1, 1607166654, 1607166654);
INSERT INTO `message` VALUES (582, 5, 4, 3, 1, 545, 390, 1, 1607166657, 1607166657);
INSERT INTO `message` VALUES (583, 5, 4, 3, 1, 545, 391, 1, 1607166660, 1607166660);
INSERT INTO `message` VALUES (584, 5, 4, 3, 1, 809, 392, 1, 1607166724, 1607166724);
INSERT INTO `message` VALUES (585, 5, 4, 3, 1, 69, 393, 1, 1607166748, 1607166748);
INSERT INTO `message` VALUES (586, 5, 4, 3, 1, 1106, 394, 1, 1607166803, 1607166803);
INSERT INTO `message` VALUES (587, 5, 4, 3, 1, 1690, 395, 1, 1607166901, 1607166901);
INSERT INTO `message` VALUES (588, 5, 4, 3, 1, 1038, 396, 1, 1607166935, 1607166935);
INSERT INTO `message` VALUES (589, 5, 4, 3, 1, 1038, 397, 1, 1607166962, 1607166962);
INSERT INTO `message` VALUES (590, 5, 4, 3, 1, 1049, 398, 1, 1607167409, 1607167409);
INSERT INTO `message` VALUES (591, 5, 4, 3, 1, 1728, 399, 1, 1607167443, 1607167443);
INSERT INTO `message` VALUES (592, 5, 4, 3, 1, 1661, 400, 1, 1607167467, 1607167467);
INSERT INTO `message` VALUES (593, 5, 4, 3, 1, 8, 401, 1, 1607167520, 1607167520);
INSERT INTO `message` VALUES (594, 5, 4, 3, 1, 689, 402, 1, 1607167552, 1607167552);
INSERT INTO `message` VALUES (595, 5, 4, 3, 1, 1140, 403, 1, 1607167620, 1607167620);
INSERT INTO `message` VALUES (596, 5, 4, 3, 1, 1140, 404, 1, 1607167624, 1607167624);
INSERT INTO `message` VALUES (597, 5, 4, 3, 1, 370, 405, 1, 1607167656, 1607167656);
INSERT INTO `message` VALUES (598, 5, 4, 3, 1, 533, 406, 1, 1607167771, 1607167771);
INSERT INTO `message` VALUES (599, 5, 4, 3, 1, 533, 407, 1, 1607167773, 1607167773);
INSERT INTO `message` VALUES (600, 5, 4, 3, 1, 533, 408, 1, 1607167774, 1607167774);
INSERT INTO `message` VALUES (601, 5, 4, 3, 1, 533, 409, 1, 1607167776, 1607167776);
INSERT INTO `message` VALUES (602, 5, 4, 3, 1, 533, 410, 1, 1607167778, 1607167778);
INSERT INTO `message` VALUES (603, 5, 4, 3, 1, 533, 411, 1, 1607167781, 1607167781);
INSERT INTO `message` VALUES (604, 5, 4, 3, 1, 533, 412, 1, 1607167783, 1607167783);
INSERT INTO `message` VALUES (605, 5, 4, 3, 1, 533, 413, 1, 1607167784, 1607167784);
INSERT INTO `message` VALUES (606, 5, 4, 3, 1, 533, 414, 1, 1607167786, 1607167786);
INSERT INTO `message` VALUES (607, 5, 4, 3, 1, 533, 415, 1, 1607167787, 1607167787);
INSERT INTO `message` VALUES (608, 5, 4, 3, 1, 533, 416, 1, 1607167793, 1607167793);
INSERT INTO `message` VALUES (609, 5, 4, 3, 1, 533, 417, 1, 1607167807, 1607167807);
INSERT INTO `message` VALUES (610, 5, 4, 3, 1, 431, 418, 1, 1607167865, 1607167865);
INSERT INTO `message` VALUES (611, 5, 4, 3, 1, 431, 419, 1, 1607167866, 1607167866);
INSERT INTO `message` VALUES (612, 5, 4, 3, 1, 431, 420, 1, 1607167868, 1607167868);
INSERT INTO `message` VALUES (613, 5, 4, 3, 1, 431, 421, 1, 1607167870, 1607167870);
INSERT INTO `message` VALUES (614, 5, 4, 3, 1, 431, 422, 1, 1607167874, 1607167874);
INSERT INTO `message` VALUES (615, 5, 4, 3, 1, 431, 423, 1, 1607167877, 1607167877);
INSERT INTO `message` VALUES (616, 5, 4, 3, 1, 431, 424, 1, 1607167879, 1607167879);
INSERT INTO `message` VALUES (617, 5, 4, 3, 1, 431, 425, 1, 1607167881, 1607167881);
INSERT INTO `message` VALUES (618, 5, 4, 3, 1, 431, 426, 1, 1607167882, 1607167882);
INSERT INTO `message` VALUES (619, 5, 4, 3, 1, 431, 427, 1, 1607167893, 1607167893);
INSERT INTO `message` VALUES (620, 5, 4, 3, 1, 431, 428, 1, 1607167895, 1607167895);
INSERT INTO `message` VALUES (621, 5, 4, 3, 1, 431, 429, 1, 1607167897, 1607167897);
INSERT INTO `message` VALUES (622, 5, 4, 3, 1, 1209, 430, 1, 1607167935, 1607167935);
INSERT INTO `message` VALUES (623, 5, 4, 3, 1, 1209, 431, 1, 1607167937, 1607167937);
INSERT INTO `message` VALUES (624, 5, 4, 3, 1, 1209, 432, 1, 1607167939, 1607167939);
INSERT INTO `message` VALUES (625, 5, 4, 3, 1, 1209, 433, 1, 1607167940, 1607167940);
INSERT INTO `message` VALUES (626, 5, 4, 3, 1, 1209, 434, 1, 1607167942, 1607167942);
INSERT INTO `message` VALUES (627, 5, 4, 3, 1, 1209, 435, 1, 1607167944, 1607167944);
INSERT INTO `message` VALUES (628, 5, 4, 3, 1, 1209, 436, 1, 1607167945, 1607167945);
INSERT INTO `message` VALUES (629, 5, 4, 3, 1, 1209, 437, 1, 1607167947, 1607167947);
INSERT INTO `message` VALUES (630, 5, 4, 3, 1, 1209, 438, 1, 1607167949, 1607167949);
INSERT INTO `message` VALUES (631, 5, 4, 3, 1, 1209, 439, 1, 1607167951, 1607167951);
INSERT INTO `message` VALUES (632, 5, 4, 3, 1, 1209, 440, 1, 1607167953, 1607167953);
INSERT INTO `message` VALUES (633, 5, 4, 3, 1, 1209, 441, 1, 1607167957, 1607167957);
INSERT INTO `message` VALUES (634, 5, 4, 3, 1, 1209, 442, 1, 1607167959, 1607167959);
INSERT INTO `message` VALUES (635, 5, 4, 3, 1, 899, 443, 1, 1607167985, 1607167985);
INSERT INTO `message` VALUES (636, 5, 4, 3, 1, 899, 444, 1, 1607167987, 1607167987);
INSERT INTO `message` VALUES (637, 5, 4, 3, 1, 899, 445, 1, 1607167988, 1607167988);
INSERT INTO `message` VALUES (638, 5, 4, 3, 1, 899, 446, 1, 1607167988, 1607167988);
INSERT INTO `message` VALUES (639, 5, 4, 3, 1, 899, 447, 1, 1607167988, 1607167988);
INSERT INTO `message` VALUES (640, 5, 4, 3, 1, 899, 448, 1, 1607167988, 1607167988);
INSERT INTO `message` VALUES (641, 5, 4, 3, 1, 899, 449, 1, 1607167989, 1607167989);
INSERT INTO `message` VALUES (642, 5, 4, 3, 1, 899, 450, 1, 1607167989, 1607167989);
INSERT INTO `message` VALUES (643, 5, 4, 3, 1, 899, 451, 1, 1607167989, 1607167989);
INSERT INTO `message` VALUES (644, 5, 4, 3, 1, 899, 452, 1, 1607167990, 1607167990);
INSERT INTO `message` VALUES (645, 5, 4, 3, 1, 899, 453, 1, 1607167990, 1607167990);
INSERT INTO `message` VALUES (646, 5, 4, 3, 1, 899, 454, 1, 1607167990, 1607167990);
INSERT INTO `message` VALUES (647, 5, 4, 3, 1, 899, 455, 1, 1607167991, 1607167991);
INSERT INTO `message` VALUES (648, 5, 4, 3, 1, 899, 456, 1, 1607167991, 1607167991);
INSERT INTO `message` VALUES (649, 5, 4, 3, 1, 899, 457, 1, 1607167991, 1607167991);
INSERT INTO `message` VALUES (650, 5, 4, 3, 1, 899, 458, 1, 1607167992, 1607167992);
INSERT INTO `message` VALUES (651, 5, 4, 3, 1, 899, 459, 1, 1607167992, 1607167992);
INSERT INTO `message` VALUES (652, 5, 4, 3, 1, 899, 460, 1, 1607167992, 1607167992);
INSERT INTO `message` VALUES (653, 5, 4, 3, 1, 899, 461, 1, 1607167992, 1607167992);
INSERT INTO `message` VALUES (654, 5, 4, 3, 1, 899, 462, 1, 1607167992, 1607167992);
INSERT INTO `message` VALUES (655, 5, 4, 3, 1, 899, 463, 1, 1607167994, 1607167994);
INSERT INTO `message` VALUES (656, 5, 4, 3, 1, 1747, 464, 1, 1607168268, 1607168268);
INSERT INTO `message` VALUES (657, 5, 4, 3, 1, 724, 465, 1, 1607168295, 1607168295);
INSERT INTO `message` VALUES (658, 5, 4, 3, 1, 724, 466, 1, 1607168325, 1607168325);
INSERT INTO `message` VALUES (659, 5, 4, 3, 1, 737, 467, 1, 1607168363, 1607168363);
INSERT INTO `message` VALUES (660, 5, 5, 2, 1, 737, 467, 1, 1607168365, 1607168365);
INSERT INTO `message` VALUES (661, 5, 4, 3, 1, 838, 468, 1, 1607168418, 1607168418);
INSERT INTO `message` VALUES (662, 5, 5, 2, 1, 838, 468, 1, 1607168419, 1607168419);
INSERT INTO `message` VALUES (663, 5, 4, 3, 1, 1084, 469, 1, 1607168481, 1607168481);
INSERT INTO `message` VALUES (664, 5, 5, 2, 1, 1084, 469, 1, 1607168483, 1607168483);
INSERT INTO `message` VALUES (665, 5, 4, 3, 1, 1439, 470, 1, 1607168557, 1607168557);
INSERT INTO `message` VALUES (666, 5, 4, 3, 1, 468, 471, 1, 1607168699, 1607168699);
INSERT INTO `message` VALUES (667, 5, 5, 2, 1, 468, 471, 1, 1607168701, 1607168701);
INSERT INTO `message` VALUES (670, 5, 4, 2, 1, 1776, 0, 1, 1607168752, 1607168752);
INSERT INTO `message` VALUES (671, 5, 4, 3, 1, 1776, 472, 1, 1607168757, 1607168757);
INSERT INTO `message` VALUES (672, 5, 5, 2, 1, 1776, 472, 1, 1607168758, 1607168758);
INSERT INTO `message` VALUES (673, 5, 4, 3, 1, 1039, 473, 1, 1607168831, 1607168831);
INSERT INTO `message` VALUES (675, 5, 5, 2, 1, 1039, 473, 1, 1607168837, 1607168837);
INSERT INTO `message` VALUES (676, 5, 4, 3, 1, 340, 474, 1, 1607168911, 1607168911);
INSERT INTO `message` VALUES (677, 5, 5, 2, 1, 340, 474, 1, 1607168913, 1607168913);
INSERT INTO `message` VALUES (678, 5, 4, 2, 1, 340, 0, 1, 1607168918, 1607168918);
INSERT INTO `message` VALUES (679, 5, 4, 3, 1, 921, 475, 1, 1607168943, 1607168943);
INSERT INTO `message` VALUES (680, 5, 4, 3, 1, 87, 476, 1, 1607168985, 1607168985);
INSERT INTO `message` VALUES (681, 5, 4, 3, 1, 1604, 477, 1, 1607169095, 1607169095);
INSERT INTO `message` VALUES (682, 5, 4, 3, 1, 818, 478, 1, 1607169140, 1607169140);
INSERT INTO `message` VALUES (683, 5, 5, 2, 1, 818, 478, 1, 1607169151, 1607169151);
INSERT INTO `message` VALUES (684, 5, 4, 2, 1, 818, 0, 1, 1607169156, 1607169156);
INSERT INTO `message` VALUES (685, 5, 4, 3, 1, 818, 479, 1, 1607169180, 1607169180);
INSERT INTO `message` VALUES (686, 5, 4, 2, 1, 774, 0, 1, 1607169990, 1607169990);
INSERT INTO `message` VALUES (687, 5, 4, 3, 1, 414, 480, 1, 1607172621, 1607172621);
INSERT INTO `message` VALUES (688, 5, 4, 3, 1, 414, 481, 1, 1607172624, 1607172624);
INSERT INTO `message` VALUES (689, 5, 4, 3, 1, 414, 482, 1, 1607172629, 1607172629);
INSERT INTO `message` VALUES (690, 5, 5, 2, 1, 414, 482, 1, 1607172631, 1607172631);
INSERT INTO `message` VALUES (691, 5, 5, 2, 1, 414, 481, 1, 1607172633, 1607172633);
INSERT INTO `message` VALUES (692, 5, 5, 2, 1, 414, 480, 1, 1607172634, 1607172634);
INSERT INTO `message` VALUES (693, 5, 4, 2, 1, 414, 0, 1, 1607172639, 1607172639);
INSERT INTO `message` VALUES (694, 4, 4, 3, 1, 1007, 483, 1, 1607251360, 1607251360);
INSERT INTO `message` VALUES (695, 4, 4, 2, 1, 1007, 483, 1, 1607251365, 1607251365);
INSERT INTO `message` VALUES (696, 147, 76, 2, 1, 1972, 0, 1, 1607276377, 1607276377);
INSERT INTO `message` VALUES (697, 5, 4, 2, 1, 1699, 0, 1, 1607277007, 1607277007);
INSERT INTO `message` VALUES (698, 5, 4, 2, 1, 756, 0, 1, 1607277010, 1607277010);
INSERT INTO `message` VALUES (699, 5, 4, 2, 1, 372, 0, 1, 1607277019, 1607277019);
INSERT INTO `message` VALUES (700, 9, 4, 3, 1, 1318, 484, 1, 1607320043, 1607320043);
INSERT INTO `message` VALUES (702, 9, 12, 1, 0, 0, 0, 1, 1607327139, 1607327139);
INSERT INTO `message` VALUES (704, 147, 4, 3, 1, 1979, 485, 1, 1608097480, 1608097480);
INSERT INTO `message` VALUES (706, 151, 147, 2, 1, 1980, 0, 1, 1608175745, 1608175745);
INSERT INTO `message` VALUES (707, 1, 4, 2, 1, 2, 0, 1, 1608393202, 1608393202);
INSERT INTO `message` VALUES (708, 1, 4, 2, 1, 2, 0, 1, 1608393230, 1608393230);
INSERT INTO `message` VALUES (709, 1, 4, 2, 1, 1, 0, 1, 1608393571, 1608393571);
INSERT INTO `message` VALUES (710, 1, 1, 2, 4, 1, 0, 1, 1608393615, 1608393615);
INSERT INTO `message` VALUES (711, 1, 1, 2, 4, 2, 0, 1, 1608393619, 1608393619);

-- ----------------------------
-- Table structure for monitor
-- ----------------------------
DROP TABLE IF EXISTS `monitor`;
CREATE TABLE `monitor`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '访问地址',
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '参数',
  `ip` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT 'IP',
  `server` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '服务',
  `updated_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '更新时间',
  `created_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `created_at`(`created_at`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '监控记录表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for movie
-- ----------------------------
DROP TABLE IF EXISTS `movie`;
CREATE TABLE `movie`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `user_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '关联user_id',
  `category_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '分类ID',
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '分类MOVIE:电影,TV:剧集,3其他',
  `region` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '地区国家',
  `year` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '年份',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '标题',
  `subtitle` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '副标题',
  `thumb` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '封面图',
  `images` varchar(5000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '多图',
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '地址',
  `intro` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '介绍',
  `duration` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '时长',
  `score` float(3, 1) UNSIGNED NOT NULL DEFAULT 0.0 COMMENT '评分',
  `release_date` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '上映时间',
  `release_address` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '上映地点',
  `tags` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '标签',
  `actor_list` varchar(5000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '演员表',
  `view_num` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '查看次数',
  `like_num` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '点赞次数',
  `comment_num` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '评论次数',
  `share_num` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '分享次数',
  `collect_num` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '收藏次数',
  `relate_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '关联ID',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT 1 COMMENT '状态0:删除1:待审核2:审核通过',
  `updated_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '更新时间',
  `created_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `user_id`(`user_id`) USING BTREE,
  INDEX `category`(`category_id`) USING BTREE,
  INDEX `created_at`(`created_at`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '影视主表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for movie_category
-- ----------------------------
DROP TABLE IF EXISTS `movie_category`;
CREATE TABLE `movie_category`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '分类名称',
  `code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '分类code',
  `icon` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '图标',
  `level` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '深度',
  `pid` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '父级别',
  `sort` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '排序',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT 1 COMMENT '状态0:删除1:开启',
  `updated_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '更新时间',
  `created_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `pid`(`pid`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 11 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '影视分类表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of movie_category
-- ----------------------------
INSERT INTO `movie_category` VALUES (1, '动作', '', '', 0, 0, 0, 1, 1606576242, 1606576242);
INSERT INTO `movie_category` VALUES (2, '喜剧', '', '', 0, 0, 0, 1, 1606576253, 1606576253);
INSERT INTO `movie_category` VALUES (3, '科幻', '', '', 0, 0, 0, 1, 1606576264, 1606576264);
INSERT INTO `movie_category` VALUES (4, '喜剧', '', '', 0, 0, 0, 1, 1606576273, 1606576273);
INSERT INTO `movie_category` VALUES (5, '爱情', '', '', 0, 0, 0, 1, 1606576281, 1606576281);
INSERT INTO `movie_category` VALUES (6, '剧情', '', '', 0, 0, 0, 1, 1606576294, 1606576294);
INSERT INTO `movie_category` VALUES (7, '恐怖', '', '', 0, 0, 0, 1, 1607753003, 1607753003);
INSERT INTO `movie_category` VALUES (8, '纪录', '', '', 0, 0, 0, 1, 1607753003, 1607753003);
INSERT INTO `movie_category` VALUES (9, '动漫', '', '', 0, 0, 0, 1, 1607753003, 1607753003);
INSERT INTO `movie_category` VALUES (10, '伦理', '', '', 0, 0, 0, 1, 1607753003, 1607753003);

-- ----------------------------
-- Table structure for movie_detail
-- ----------------------------
DROP TABLE IF EXISTS `movie_detail`;
CREATE TABLE `movie_detail`  (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `user_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '发送人ID',
  `movie_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '影视ID',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '0' COMMENT '标题',
  `thumb` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '预览图',
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '视频地址',
  `intro` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '本集介绍',
  `sort` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '排序（越小越靠前）',
  `relate_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '关联ID',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '状态0删除1未读2已读',
  `updated_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '更新时间',
  `created_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `movie_id`(`movie_id`) USING BTREE,
  INDEX `created_at`(`created_at`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '剧集列表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for movie_history
-- ----------------------------
DROP TABLE IF EXISTS `movie_history`;
CREATE TABLE `movie_history`  (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `user_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '发送人ID',
  `movie_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '影视ID',
  `movie_detail_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '影视剧集ID',
  `second` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '观看的秒数',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '状态0删除1未读2已读',
  `updated_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '更新时间',
  `created_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `movie_id`(`movie_id`) USING BTREE,
  INDEX `user_id`(`user_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '影视浏览历史表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for user_account_log
-- ----------------------------
DROP TABLE IF EXISTS `user_account_log`;
CREATE TABLE `user_account_log`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `user_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '关联user_id',
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '分类AMOUNT余额变化INTEGRAL积分变化GOLD金币变化',
  `amount` decimal(10, 2) NOT NULL DEFAULT 0.00 COMMENT '金额',
  `integral` int(10) NOT NULL DEFAULT 0 COMMENT '积分',
  `gold` int(10) NOT NULL DEFAULT 0 COMMENT '金币',
  `source` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '来源：AGENT_RECHARGE',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '备注',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '状态1:正常',
  `updated_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '更新时间',
  `created_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `user_id`(`user_id`) USING BTREE,
  INDEX `source`(`source`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '用户账变记录表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for user_book
-- ----------------------------
DROP TABLE IF EXISTS `user_book`;
CREATE TABLE `user_book`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `user_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '关联user_id',
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '用户名',
  `phone` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '手机号',
  `updated_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '更新时间',
  `created_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `created_at`(`created_at`) USING BTREE,
  INDEX `user_id`(`user_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '用户通讯录表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for user_group
-- ----------------------------
DROP TABLE IF EXISTS `user_group`;
CREATE TABLE `user_group`  (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '群组名称',
  `intro` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '群组介绍',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '状态0禁用1启用',
  `updated_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '更新时间',
  `created_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '用户群组表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for user_group_relate
-- ----------------------------
DROP TABLE IF EXISTS `user_group_relate`;
CREATE TABLE `user_group_relate`  (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `group_id` int(10) NOT NULL DEFAULT 0 COMMENT '群组ID',
  `user_id` int(10) NOT NULL DEFAULT 0 COMMENT '关联用户',
  `updated_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '更新时间',
  `created_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `group_user`(`group_id`, `user_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '用户群组关联表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for user_has_roles
-- ----------------------------
DROP TABLE IF EXISTS `user_has_roles`;
CREATE TABLE `user_has_roles`  (
  `role_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '角色ID',
  `user_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '用户ID',
  `model_type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '类型',
  INDEX `user_id`(`user_id`, `model_type`(191)) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '用户拥有角色' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of user_has_roles
-- ----------------------------
INSERT INTO `user_has_roles` VALUES (1, 1, 'App\\Models\\User');
INSERT INTO `user_has_roles` VALUES (1, 2, 'App\\Models\\User');
INSERT INTO `user_has_roles` VALUES (2, 3, 'App\\Models\\User');
INSERT INTO `user_has_roles` VALUES (3, 4, 'App\\Models\\User');

-- ----------------------------
-- Table structure for user_has_tags
-- ----------------------------
DROP TABLE IF EXISTS `user_has_tags`;
CREATE TABLE `user_has_tags`  (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `user_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '用户ID',
  `tag_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '关联tag_id',
  `updated_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '更新时间',
  `created_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `user_id`(`user_id`, `updated_at`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 109 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '用户标签关联表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of user_has_tags
-- ----------------------------
INSERT INTO `user_has_tags` VALUES (9, 4, 25, 0, 0);
INSERT INTO `user_has_tags` VALUES (10, 4, 27, 0, 0);
INSERT INTO `user_has_tags` VALUES (11, 4, 26, 0, 0);
INSERT INTO `user_has_tags` VALUES (12, 4, 23, 0, 0);
INSERT INTO `user_has_tags` VALUES (13, 4, 21, 0, 0);
INSERT INTO `user_has_tags` VALUES (14, 4, 22, 0, 0);
INSERT INTO `user_has_tags` VALUES (15, 49, 23, 0, 0);
INSERT INTO `user_has_tags` VALUES (16, 48, 24, 0, 0);
INSERT INTO `user_has_tags` VALUES (17, 48, 25, 0, 0);
INSERT INTO `user_has_tags` VALUES (18, 48, 27, 0, 0);
INSERT INTO `user_has_tags` VALUES (19, 48, 26, 0, 0);
INSERT INTO `user_has_tags` VALUES (20, 48, 23, 0, 0);
INSERT INTO `user_has_tags` VALUES (21, 48, 22, 0, 0);
INSERT INTO `user_has_tags` VALUES (22, 47, 25, 0, 0);
INSERT INTO `user_has_tags` VALUES (23, 47, 27, 0, 0);
INSERT INTO `user_has_tags` VALUES (24, 47, 24, 0, 0);
INSERT INTO `user_has_tags` VALUES (25, 47, 21, 0, 0);
INSERT INTO `user_has_tags` VALUES (26, 46, 21, 0, 0);
INSERT INTO `user_has_tags` VALUES (27, 46, 24, 0, 0);
INSERT INTO `user_has_tags` VALUES (28, 46, 26, 0, 0);
INSERT INTO `user_has_tags` VALUES (29, 46, 22, 0, 0);
INSERT INTO `user_has_tags` VALUES (30, 45, 23, 0, 0);
INSERT INTO `user_has_tags` VALUES (31, 45, 25, 0, 0);
INSERT INTO `user_has_tags` VALUES (32, 45, 26, 0, 0);
INSERT INTO `user_has_tags` VALUES (33, 44, 23, 0, 0);
INSERT INTO `user_has_tags` VALUES (34, 44, 25, 0, 0);
INSERT INTO `user_has_tags` VALUES (35, 44, 26, 0, 0);
INSERT INTO `user_has_tags` VALUES (36, 43, 21, 0, 0);
INSERT INTO `user_has_tags` VALUES (37, 43, 24, 0, 0);
INSERT INTO `user_has_tags` VALUES (38, 43, 25, 0, 0);
INSERT INTO `user_has_tags` VALUES (39, 42, 21, 0, 0);
INSERT INTO `user_has_tags` VALUES (40, 42, 26, 0, 0);
INSERT INTO `user_has_tags` VALUES (41, 42, 27, 0, 0);
INSERT INTO `user_has_tags` VALUES (42, 40, 21, 0, 0);
INSERT INTO `user_has_tags` VALUES (43, 40, 23, 0, 0);
INSERT INTO `user_has_tags` VALUES (44, 39, 22, 0, 0);
INSERT INTO `user_has_tags` VALUES (45, 39, 23, 0, 0);
INSERT INTO `user_has_tags` VALUES (50, 37, 23, 0, 0);
INSERT INTO `user_has_tags` VALUES (51, 37, 24, 0, 0);
INSERT INTO `user_has_tags` VALUES (52, 37, 26, 0, 0);
INSERT INTO `user_has_tags` VALUES (53, 36, 22, 0, 0);
INSERT INTO `user_has_tags` VALUES (54, 36, 23, 0, 0);
INSERT INTO `user_has_tags` VALUES (55, 34, 23, 0, 0);
INSERT INTO `user_has_tags` VALUES (56, 34, 24, 0, 0);
INSERT INTO `user_has_tags` VALUES (57, 31, 23, 0, 0);
INSERT INTO `user_has_tags` VALUES (58, 31, 25, 0, 0);
INSERT INTO `user_has_tags` VALUES (59, 30, 22, 0, 0);
INSERT INTO `user_has_tags` VALUES (60, 30, 23, 0, 0);
INSERT INTO `user_has_tags` VALUES (61, 30, 24, 0, 0);
INSERT INTO `user_has_tags` VALUES (62, 29, 23, 0, 0);
INSERT INTO `user_has_tags` VALUES (63, 29, 25, 0, 0);
INSERT INTO `user_has_tags` VALUES (64, 28, 21, 0, 0);
INSERT INTO `user_has_tags` VALUES (65, 28, 24, 0, 0);
INSERT INTO `user_has_tags` VALUES (66, 27, 21, 0, 0);
INSERT INTO `user_has_tags` VALUES (67, 22, 21, 0, 0);
INSERT INTO `user_has_tags` VALUES (68, 22, 23, 0, 0);
INSERT INTO `user_has_tags` VALUES (69, 21, 23, 0, 0);
INSERT INTO `user_has_tags` VALUES (70, 21, 24, 0, 0);
INSERT INTO `user_has_tags` VALUES (71, 38, 23, 0, 0);
INSERT INTO `user_has_tags` VALUES (72, 38, 25, 0, 0);
INSERT INTO `user_has_tags` VALUES (73, 38, 24, 0, 0);
INSERT INTO `user_has_tags` VALUES (98, 82, 27, 0, 1593673189);
INSERT INTO `user_has_tags` VALUES (99, 82, 26, 0, 1593673189);
INSERT INTO `user_has_tags` VALUES (100, 82, 25, 0, 1593673189);
INSERT INTO `user_has_tags` VALUES (101, 82, 24, 0, 1593673189);
INSERT INTO `user_has_tags` VALUES (102, 82, 23, 0, 1593673189);
INSERT INTO `user_has_tags` VALUES (103, 82, 21, 0, 1593673189);
INSERT INTO `user_has_tags` VALUES (104, 82, 22, 0, 1593673189);
INSERT INTO `user_has_tags` VALUES (105, 26, 27, 0, 1593689794);
INSERT INTO `user_has_tags` VALUES (106, 26, 21, 0, 1593689794);
INSERT INTO `user_has_tags` VALUES (107, 69, 26, 0, 1594048572);
INSERT INTO `user_has_tags` VALUES (108, 69, 25, 0, 1594048572);

-- ----------------------------
-- Table structure for user_login_log
-- ----------------------------
DROP TABLE IF EXISTS `user_login_log`;
CREATE TABLE `user_login_log`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `username` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '登录账号',
  `login_type` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '登录类型0:账号名1:微信2:QQ',
  `ip` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '登录ip',
  `requests` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '提交参数',
  `remark` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '备注',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT 1 COMMENT '状态0:登录失败,1:登录成功',
  `updated_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '更新时间',
  `created_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1406 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '登录日志表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of user_login_log
-- ----------------------------
INSERT INTO `user_login_log` VALUES (1, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1589001102, 1589001102);
INSERT INTO `user_login_log` VALUES (2, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1589001230, 1589001230);
INSERT INTO `user_login_log` VALUES (3, 'demo', 0, '122.114.88.197', '{\"username\":\"demo\",\"timestamp\":1589007523}', '登录成功', 1, 1589007433, 1589007433);
INSERT INTO `user_login_log` VALUES (4, '15507946721', 0, '122.114.88.197', '{\"username\":\"15507946721\",\"timestamp\":1589015460}', '账号或者密码错误', 0, 1589015370, 1589015370);
INSERT INTO `user_login_log` VALUES (5, '15507946721', 0, '122.114.88.197', '{\"username\":\"15507946721\",\"timestamp\":1589015470}', '账号或者密码错误', 0, 1589015380, 1589015380);
INSERT INTO `user_login_log` VALUES (6, '15507946721', 0, '122.114.88.197', '{\"username\":\"15507946721\",\"timestamp\":1589015473}', '账号或者密码错误', 0, 1589015382, 1589015382);
INSERT INTO `user_login_log` VALUES (7, '15507946721', 0, '122.114.88.197', '{\"username\":\"15507946721\",\"timestamp\":1589015506}', '登录成功', 1, 1589015415, 1589015415);
INSERT INTO `user_login_log` VALUES (8, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1589053275, 1589053275);
INSERT INTO `user_login_log` VALUES (9, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1589053517, 1589053517);
INSERT INTO `user_login_log` VALUES (10, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1589053566, 1589053566);
INSERT INTO `user_login_log` VALUES (11, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1589053578, 1589053578);
INSERT INTO `user_login_log` VALUES (12, '138000138000', 0, '122.114.88.197', '{\"username\":\"138000138000\",\"timestamp\":1589062079}', '账号或者密码错误', 0, 1589062080, 1589062080);
INSERT INTO `user_login_log` VALUES (13, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1589062094}', '账号或者密码错误', 0, 1589062094, 1589062094);
INSERT INTO `user_login_log` VALUES (14, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1589062108}', '账号或者密码错误', 0, 1589062108, 1589062108);
INSERT INTO `user_login_log` VALUES (15, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1589062115}', '账号或者密码错误', 0, 1589062115, 1589062115);
INSERT INTO `user_login_log` VALUES (16, '18929636347', 0, '122.114.88.197', '{\"username\":\"18929636347\",\"timestamp\":1589066704}', '登录成功', 1, 1589066706, 1589066706);
INSERT INTO `user_login_log` VALUES (17, '15504311017', 0, '122.114.88.197', '{\"username\":\"15504311017\",\"timestamp\":1589174924}', '登录成功', 1, 1589174926, 1589174926);
INSERT INTO `user_login_log` VALUES (18, '1380000138000', 0, '122.114.88.197', '{\"username\":\"1380000138000\",\"timestamp\":1589187414}', '账号或者密码错误', 0, 1589187415, 1589187415);
INSERT INTO `user_login_log` VALUES (19, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1589187428}', '账号或者密码错误', 0, 1589187429, 1589187429);
INSERT INTO `user_login_log` VALUES (20, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1589187430}', '账号或者密码错误', 0, 1589187431, 1589187431);
INSERT INTO `user_login_log` VALUES (21, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1589187431}', '账号或者密码错误', 0, 1589187432, 1589187432);
INSERT INTO `user_login_log` VALUES (22, '15504311017', 0, '122.114.88.197', '{\"username\":\"15504311017\",\"timestamp\":1589187448}', '登录成功', 1, 1589187448, 1589187448);
INSERT INTO `user_login_log` VALUES (23, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1589283701}', '账号或者密码错误', 0, 1589283701, 1589283701);
INSERT INTO `user_login_log` VALUES (24, '15200000000', 0, '122.114.88.197', '{\"username\":\"15200000000\",\"timestamp\":1589283733}', '账号或者密码错误', 0, 1589283733, 1589283733);
INSERT INTO `user_login_log` VALUES (25, '13145204000', 0, '122.114.88.197', '{\"username\":\"13145204000\",\"timestamp\":1589283757}', '登录成功', 1, 1589283757, 1589283757);
INSERT INTO `user_login_log` VALUES (26, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1589284837, 1589284837);
INSERT INTO `user_login_log` VALUES (27, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589338148, 1589338148);
INSERT INTO `user_login_log` VALUES (28, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589338706, 1589338706);
INSERT INTO `user_login_log` VALUES (29, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589338735, 1589338735);
INSERT INTO `user_login_log` VALUES (30, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589339017, 1589339017);
INSERT INTO `user_login_log` VALUES (31, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589339106, 1589339106);
INSERT INTO `user_login_log` VALUES (32, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589339110, 1589339110);
INSERT INTO `user_login_log` VALUES (33, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589339885, 1589339885);
INSERT INTO `user_login_log` VALUES (34, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589339886, 1589339886);
INSERT INTO `user_login_log` VALUES (35, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589340056, 1589340056);
INSERT INTO `user_login_log` VALUES (36, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589342110, 1589342110);
INSERT INTO `user_login_log` VALUES (37, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589342112, 1589342112);
INSERT INTO `user_login_log` VALUES (38, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589342173, 1589342173);
INSERT INTO `user_login_log` VALUES (39, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589342175, 1589342175);
INSERT INTO `user_login_log` VALUES (40, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589342239, 1589342239);
INSERT INTO `user_login_log` VALUES (41, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589342244, 1589342244);
INSERT INTO `user_login_log` VALUES (42, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589342292, 1589342292);
INSERT INTO `user_login_log` VALUES (43, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589342293, 1589342293);
INSERT INTO `user_login_log` VALUES (44, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589342293, 1589342293);
INSERT INTO `user_login_log` VALUES (45, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589342294, 1589342294);
INSERT INTO `user_login_log` VALUES (46, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589342391, 1589342391);
INSERT INTO `user_login_log` VALUES (47, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589342392, 1589342392);
INSERT INTO `user_login_log` VALUES (48, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589342393, 1589342393);
INSERT INTO `user_login_log` VALUES (49, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589342434, 1589342434);
INSERT INTO `user_login_log` VALUES (50, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589342456, 1589342456);
INSERT INTO `user_login_log` VALUES (51, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589342458, 1589342458);
INSERT INTO `user_login_log` VALUES (52, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589342459, 1589342459);
INSERT INTO `user_login_log` VALUES (53, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589349112, 1589349112);
INSERT INTO `user_login_log` VALUES (54, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589349113, 1589349113);
INSERT INTO `user_login_log` VALUES (55, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589349154, 1589349154);
INSERT INTO `user_login_log` VALUES (56, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589349322, 1589349322);
INSERT INTO `user_login_log` VALUES (57, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589349420, 1589349420);
INSERT INTO `user_login_log` VALUES (58, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589349422, 1589349422);
INSERT INTO `user_login_log` VALUES (59, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589349423, 1589349423);
INSERT INTO `user_login_log` VALUES (60, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589349424, 1589349424);
INSERT INTO `user_login_log` VALUES (61, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589349456, 1589349456);
INSERT INTO `user_login_log` VALUES (62, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589349468, 1589349468);
INSERT INTO `user_login_log` VALUES (63, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589351964, 1589351964);
INSERT INTO `user_login_log` VALUES (64, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589351994, 1589351994);
INSERT INTO `user_login_log` VALUES (65, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589352750, 1589352750);
INSERT INTO `user_login_log` VALUES (66, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589352750, 1589352750);
INSERT INTO `user_login_log` VALUES (67, '12121', 0, '117.176.132.82', '{\"username\":\"12121\"}', '账号或者密码错误', 0, 1589352763, 1589352763);
INSERT INTO `user_login_log` VALUES (68, 'demi', 0, '117.176.132.82', '{\"username\":\"demi\"}', '账号或者密码错误', 0, 1589352834, 1589352834);
INSERT INTO `user_login_log` VALUES (69, 'demo', 0, '117.176.132.82', '{\"username\":\"demo\"}', '登录成功', 1, 1589352840, 1589352840);
INSERT INTO `user_login_log` VALUES (70, 'demo', 0, '117.176.132.82', '{\"username\":\"demo\"}', '登录成功', 1, 1589352954, 1589352954);
INSERT INTO `user_login_log` VALUES (71, 'demo', 0, '117.176.132.82', '{\"username\":\"demo\"}', '登录成功', 1, 1589353006, 1589353006);
INSERT INTO `user_login_log` VALUES (72, 'demo', 0, '117.176.132.82', '{\"username\":\"demo\"}', '登录成功', 1, 1589353082, 1589353082);
INSERT INTO `user_login_log` VALUES (73, 'demo', 0, '117.176.132.82', '{\"username\":\"demo\"}', '登录成功', 1, 1589353196, 1589353196);
INSERT INTO `user_login_log` VALUES (74, 'demo', 0, '117.176.132.82', '{\"username\":\"demo\"}', '登录成功', 1, 1589354335, 1589354335);
INSERT INTO `user_login_log` VALUES (75, 'demo', 0, '117.176.132.82', '{\"username\":\"demo\"}', '登录成功', 1, 1589354336, 1589354336);
INSERT INTO `user_login_log` VALUES (76, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1589426436, 1589426436);
INSERT INTO `user_login_log` VALUES (77, '15638118026', 0, '122.114.88.197', '{\"username\":\"15638118026\",\"timestamp\":1589444722}', '登录成功', 1, 1589444723, 1589444723);
INSERT INTO `user_login_log` VALUES (78, '15638118026', 0, '122.114.88.197', '{\"username\":\"15638118026\",\"timestamp\":1589444766}', '登录成功', 1, 1589444762, 1589444762);
INSERT INTO `user_login_log` VALUES (79, '18660983020', 0, '122.114.88.197', '{\"username\":\"18660983020\",\"timestamp\":1589502454}', '登录成功', 1, 1589502453, 1589502453);
INSERT INTO `user_login_log` VALUES (80, '18660983020', 0, '122.114.88.197', '{\"username\":\"18660983020\",\"timestamp\":1589502550}', '登录成功', 1, 1589502551, 1589502551);
INSERT INTO `user_login_log` VALUES (81, '15507946721', 0, '122.114.88.197', '{\"username\":\"15507946721\",\"timestamp\":1589522198}', '登录成功', 1, 1589522199, 1589522199);
INSERT INTO `user_login_log` VALUES (82, '15507946721', 0, '122.114.88.197', '{\"username\":\"15507946721\",\"timestamp\":1589553671}', '登录成功', 1, 1589553678, 1589553678);
INSERT INTO `user_login_log` VALUES (83, '15507946721', 0, '122.114.88.197', '{\"username\":\"15507946721\",\"timestamp\":1589553676}', '登录成功', 1, 1589553680, 1589553680);
INSERT INTO `user_login_log` VALUES (84, '1380013800', 0, '122.114.88.197', '{\"username\":\"1380013800\",\"timestamp\":1589559557}', '账号或者密码错误', 0, 1589559557, 1589559557);
INSERT INTO `user_login_log` VALUES (85, '1380013800', 0, '122.114.88.197', '{\"username\":\"1380013800\",\"timestamp\":1589559577}', '账号或者密码错误', 0, 1589559578, 1589559578);
INSERT INTO `user_login_log` VALUES (86, 'admin', 0, '183.193.116.247', '{\"username\":\"admin\"}', '登录成功', 1, 1589605853, 1589605853);
INSERT INTO `user_login_log` VALUES (87, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1589635403}', '账号或者密码错误', 0, 1589635405, 1589635405);
INSERT INTO `user_login_log` VALUES (88, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1589635414}', '账号或者密码错误', 0, 1589635416, 1589635416);
INSERT INTO `user_login_log` VALUES (89, 'admin', 0, '183.193.116.247', '{\"username\":\"admin\"}', '登录成功', 1, 1589640254, 1589640254);
INSERT INTO `user_login_log` VALUES (90, 'admin', 0, '183.193.116.247', '{\"username\":\"admin\"}', '登录成功', 1, 1589642212, 1589642212);
INSERT INTO `user_login_log` VALUES (91, 'admin', 0, '172.18.0.1', '{\"username\":\"admin\"}', '登录成功', 1, 1589643444, 1589643444);
INSERT INTO `user_login_log` VALUES (92, 'admin', 0, '172.18.0.1', '{\"username\":\"admin\"}', '登录成功', 1, 1589643454, 1589643454);
INSERT INTO `user_login_log` VALUES (93, 'admin', 0, '172.18.0.1', '{\"username\":\"admin\"}', '登录成功', 1, 1589643464, 1589643464);
INSERT INTO `user_login_log` VALUES (94, 'admin', 0, '172.18.0.1', '{\"username\":\"admin\"}', '登录成功', 1, 1589643477, 1589643477);
INSERT INTO `user_login_log` VALUES (95, 'admin', 0, '172.18.0.1', '{\"username\":\"admin\"}', '登录成功', 1, 1589643488, 1589643488);
INSERT INTO `user_login_log` VALUES (96, 'admin', 0, '172.18.0.1', '{\"username\":\"admin\"}', '登录成功', 1, 1589643500, 1589643500);
INSERT INTO `user_login_log` VALUES (97, 'admin', 0, '172.18.0.1', '{\"username\":\"admin\"}', '登录成功', 1, 1589643815, 1589643815);
INSERT INTO `user_login_log` VALUES (98, 'demo', 0, '172.18.0.1', '{\"username\":\"demo\"}', '登录成功', 1, 1589648319, 1589648319);
INSERT INTO `user_login_log` VALUES (99, 'admin', 0, '172.18.0.1', '{\"username\":\"admin\"}', '登录成功', 1, 1589648355, 1589648355);
INSERT INTO `user_login_log` VALUES (100, 'demo', 0, '172.18.0.1', '{\"username\":\"demo\"}', '登录成功', 1, 1589649404, 1589649404);
INSERT INTO `user_login_log` VALUES (101, 'admin', 0, '172.18.0.1', '{\"username\":\"admin\"}', '登录成功', 1, 1589649593, 1589649593);
INSERT INTO `user_login_log` VALUES (102, 'admin', 0, '172.18.0.1', '{\"username\":\"admin\"}', '登录成功', 1, 1589897240, 1589897240);
INSERT INTO `user_login_log` VALUES (103, 'demo', 0, '172.18.0.1', '{\"username\":\"demo\"}', '登录成功', 1, 1589897580, 1589897580);
INSERT INTO `user_login_log` VALUES (104, 'admin', 0, '172.18.0.1', '{\"username\":\"admin\"}', '登录成功', 1, 1589984485, 1589984485);
INSERT INTO `user_login_log` VALUES (105, 'demo', 0, '172.18.0.1', '{\"username\":\"demo\"}', '登录成功', 1, 1589984574, 1589984574);
INSERT INTO `user_login_log` VALUES (106, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1590021399}', '账号或者密码错误', 0, 1590021396, 1590021396);
INSERT INTO `user_login_log` VALUES (107, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1590021409}', '账号或者密码错误', 0, 1590021406, 1590021406);
INSERT INTO `user_login_log` VALUES (108, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1590021411}', '账号或者密码错误', 0, 1590021407, 1590021407);
INSERT INTO `user_login_log` VALUES (109, '13800238000', 0, '122.114.88.197', '{\"username\":\"13800238000\",\"timestamp\":1590021457}', '账号或者密码错误', 0, 1590021453, 1590021453);
INSERT INTO `user_login_log` VALUES (110, '13800238000', 0, '122.114.88.197', '{\"username\":\"13800238000\",\"timestamp\":1590021458}', '账号或者密码错误', 0, 1590021455, 1590021455);
INSERT INTO `user_login_log` VALUES (111, '13800238000', 0, '122.114.88.197', '{\"username\":\"13800238000\",\"timestamp\":1590021466}', '账号或者密码错误', 0, 1590021462, 1590021462);
INSERT INTO `user_login_log` VALUES (112, '13800238000', 0, '122.114.88.197', '{\"username\":\"13800238000\",\"timestamp\":1590021472}', '账号或者密码错误', 0, 1590021469, 1590021469);
INSERT INTO `user_login_log` VALUES (113, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1590041871, 1590041871);
INSERT INTO `user_login_log` VALUES (114, '1380013800', 0, '122.114.88.197', '{\"username\":\"1380013800\",\"timestamp\":1590048470}', '账号或者密码错误', 0, 1590048470, 1590048470);
INSERT INTO `user_login_log` VALUES (115, '1380013800', 0, '122.114.88.197', '{\"username\":\"1380013800\",\"timestamp\":1590048501}', '账号或者密码错误', 0, 1590048501, 1590048501);
INSERT INTO `user_login_log` VALUES (116, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1590048555}', '账号或者密码错误', 0, 1590048555, 1590048555);
INSERT INTO `user_login_log` VALUES (117, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1590048628}', '账号或者密码错误', 0, 1590048628, 1590048628);
INSERT INTO `user_login_log` VALUES (118, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1590048632}', '账号或者密码错误', 0, 1590048633, 1590048633);
INSERT INTO `user_login_log` VALUES (119, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1590048645}', '账号或者密码错误', 0, 1590048646, 1590048646);
INSERT INTO `user_login_log` VALUES (120, '13760625332', 0, '122.114.88.197', '{\"username\":\"13760625332\",\"timestamp\":1590048678}', '登录成功', 1, 1590048680, 1590048680);
INSERT INTO `user_login_log` VALUES (121, '13086864754', 0, '122.114.88.197', '{\"username\":\"13086864754\",\"timestamp\":1590052142}', '账号或者密码错误', 0, 1590052143, 1590052143);
INSERT INTO `user_login_log` VALUES (122, '18381087280', 0, '122.114.88.197', '{\"username\":\"18381087280\",\"timestamp\":1590139148}', '账号或者密码错误', 0, 1590139149, 1590139149);
INSERT INTO `user_login_log` VALUES (123, '18736292100', 0, '122.114.88.197', '{\"username\":\"18736292100\",\"timestamp\":1590146602}', '登录成功', 1, 1590146603, 1590146603);
INSERT INTO `user_login_log` VALUES (124, '18736292100', 0, '122.114.88.197', '{\"username\":\"18736292100\",\"timestamp\":1590164011}', '登录成功', 1, 1590164012, 1590164012);
INSERT INTO `user_login_log` VALUES (125, '18736292100', 0, '122.114.88.197', '{\"username\":\"18736292100\",\"timestamp\":1590371969}', '登录成功', 1, 1590371970, 1590371970);
INSERT INTO `user_login_log` VALUES (126, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1590395385}', '账号或者密码错误', 0, 1590395386, 1590395386);
INSERT INTO `user_login_log` VALUES (127, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1590395403}', '账号或者密码错误', 0, 1590395403, 1590395403);
INSERT INTO `user_login_log` VALUES (128, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1590395431}', '账号或者密码错误', 0, 1590395431, 1590395431);
INSERT INTO `user_login_log` VALUES (129, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1590395675}', '账号或者密码错误', 0, 1590395675, 1590395675);
INSERT INTO `user_login_log` VALUES (130, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1590416451}', '账号或者密码错误', 0, 1590416464, 1590416464);
INSERT INTO `user_login_log` VALUES (131, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1590416455}', '账号或者密码错误', 0, 1590416468, 1590416468);
INSERT INTO `user_login_log` VALUES (132, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1590416458}', '账号或者密码错误', 0, 1590416471, 1590416471);
INSERT INTO `user_login_log` VALUES (133, '18373166779', 0, '122.114.88.197', '{\"username\":\"18373166779\",\"timestamp\":1590495569}', '登录成功', 1, 1590495570, 1590495570);
INSERT INTO `user_login_log` VALUES (134, '15645059079', 0, '112.32.205.217', '{\"username\":\"15645059079\"}', '账号或者密码错误', 0, 1590496903, 1590496903);
INSERT INTO `user_login_log` VALUES (135, '15645059079', 0, '112.32.205.217', '{\"username\":\"15645059079\"}', '账号或者密码错误', 0, 1590496905, 1590496905);
INSERT INTO `user_login_log` VALUES (136, '15645059079', 0, '112.32.205.217', '{\"username\":\"15645059079\"}', '账号或者密码错误', 0, 1590496905, 1590496905);
INSERT INTO `user_login_log` VALUES (137, '15645059079', 0, '112.32.205.217', '{\"username\":\"15645059079\"}', '账号或者密码错误', 0, 1590496911, 1590496911);
INSERT INTO `user_login_log` VALUES (138, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1590551669}', '登录成功', 1, 1590551670, 1590551670);
INSERT INTO `user_login_log` VALUES (139, '18539967405', 0, '122.114.88.197', '{\"username\":\"18539967405\",\"timestamp\":1590632377}', '登录成功', 1, 1590632377, 1590632377);
INSERT INTO `user_login_log` VALUES (140, '13911257751', 0, '122.114.88.197', '{\"username\":\"13911257751\",\"timestamp\":1590633521}', '账号或者密码错误', 0, 1590633521, 1590633521);
INSERT INTO `user_login_log` VALUES (141, '13911257751', 0, '122.114.88.197', '{\"username\":\"13911257751\",\"timestamp\":1590633532}', '账号或者密码错误', 0, 1590633538, 1590633538);
INSERT INTO `user_login_log` VALUES (142, '13911257751', 0, '122.114.88.197', '{\"username\":\"13911257751\",\"timestamp\":1590633538}', '账号或者密码错误', 0, 1590633542, 1590633542);
INSERT INTO `user_login_log` VALUES (143, '13911257751', 0, '122.114.88.197', '{\"username\":\"13911257751\",\"timestamp\":1590633534}', '账号或者密码错误', 0, 1590633542, 1590633542);
INSERT INTO `user_login_log` VALUES (144, '13911257751', 0, '122.114.88.197', '{\"username\":\"13911257751\",\"timestamp\":1590633538}', '账号或者密码错误', 0, 1590633542, 1590633542);
INSERT INTO `user_login_log` VALUES (145, '13911257751', 0, '122.114.88.197', '{\"username\":\"13911257751\",\"timestamp\":1590633536}', '账号或者密码错误', 0, 1590633543, 1590633543);
INSERT INTO `user_login_log` VALUES (146, '13911257751', 0, '122.114.88.197', '{\"username\":\"13911257751\",\"timestamp\":1590633583}', '账号或者密码错误', 0, 1590633584, 1590633584);
INSERT INTO `user_login_log` VALUES (147, '13911257751', 0, '122.114.88.197', '{\"username\":\"13911257751\",\"timestamp\":1590633590}', '账号或者密码错误', 0, 1590633590, 1590633590);
INSERT INTO `user_login_log` VALUES (148, '13911257751', 0, '122.114.88.197', '{\"username\":\"13911257751\",\"timestamp\":1590633594}', '账号或者密码错误', 0, 1590633595, 1590633595);
INSERT INTO `user_login_log` VALUES (149, '15579879635', 0, '122.114.88.197', '{\"username\":\"15579879635\",\"timestamp\":1590672859}', '登录成功', 1, 1590672860, 1590672860);
INSERT INTO `user_login_log` VALUES (150, '15018097614', 0, '122.114.88.197', '{\"username\":\"15018097614\",\"timestamp\":1590707884}', '登录成功', 1, 1590707885, 1590707885);
INSERT INTO `user_login_log` VALUES (151, '15018097614', 0, '122.114.88.197', '{\"username\":\"15018097614\",\"timestamp\":1590743424}', '登录成功', 1, 1590743425, 1590743425);
INSERT INTO `user_login_log` VALUES (152, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1590746061}', '账号或者密码错误', 0, 1590746062, 1590746062);
INSERT INTO `user_login_log` VALUES (153, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1590746097}', '账号或者密码错误', 0, 1590746099, 1590746099);
INSERT INTO `user_login_log` VALUES (154, '13812345678', 0, '122.114.88.197', '{\"username\":\"13812345678\",\"timestamp\":1590758775}', '登录成功', 1, 1590758779, 1590758779);
INSERT INTO `user_login_log` VALUES (155, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1590797475}', '账号或者密码错误', 0, 1590797476, 1590797476);
INSERT INTO `user_login_log` VALUES (156, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1590797490}', '账号或者密码错误', 0, 1590797492, 1590797492);
INSERT INTO `user_login_log` VALUES (157, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1590797500}', '账号或者密码错误', 0, 1590797501, 1590797501);
INSERT INTO `user_login_log` VALUES (158, 'admin', 0, '39.109.7.74', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1590937662, 1590937662);
INSERT INTO `user_login_log` VALUES (159, 'admin', 0, '39.109.7.74', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1590937665, 1590937665);
INSERT INTO `user_login_log` VALUES (160, 'admin', 0, '39.109.7.74', '{\"username\":\"admin\"}', '登录成功', 1, 1590937803, 1590937803);
INSERT INTO `user_login_log` VALUES (161, 'admin', 0, '39.109.7.74', '{\"username\":\"admin\"}', '登录成功', 1, 1590937810, 1590937810);
INSERT INTO `user_login_log` VALUES (162, 'admin', 0, '39.109.7.74', '{\"username\":\"admin\"}', '登录成功', 1, 1590969894, 1590969894);
INSERT INTO `user_login_log` VALUES (163, 'admin', 0, '39.109.7.74', '{\"username\":\"admin\"}', '登录成功', 1, 1590988107, 1590988107);
INSERT INTO `user_login_log` VALUES (164, '18203606007', 0, '122.114.88.197', '{\"username\":\"18203606007\",\"timestamp\":1591009694}', '登录成功', 1, 1591009717, 1591009717);
INSERT INTO `user_login_log` VALUES (165, 'admin', 0, '39.109.7.74', '{\"username\":\"admin\"}', '登录成功', 1, 1591022557, 1591022557);
INSERT INTO `user_login_log` VALUES (166, '13708021643', 0, '122.114.88.197', '{\"username\":\"13708021643\",\"timestamp\":1591029435}', '账号或者密码错误', 0, 1591029437, 1591029437);
INSERT INTO `user_login_log` VALUES (167, '13708021643', 0, '122.114.88.197', '{\"username\":\"13708021643\",\"timestamp\":1591029437}', '账号或者密码错误', 0, 1591029437, 1591029437);
INSERT INTO `user_login_log` VALUES (168, '13708021643', 0, '122.114.88.197', '{\"username\":\"13708021643\",\"timestamp\":1591029444}', '登录成功', 1, 1591029444, 1591029444);
INSERT INTO `user_login_log` VALUES (169, 'admin', 0, '180.167.105.22', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1591080354, 1591080354);
INSERT INTO `user_login_log` VALUES (170, 'admin', 0, '180.167.105.22', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1591080360, 1591080360);
INSERT INTO `user_login_log` VALUES (171, 'admin', 0, '180.167.105.22', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1591080369, 1591080369);
INSERT INTO `user_login_log` VALUES (172, 'admin', 0, '180.167.105.22', '{\"username\":\"admin\"}', '登录成功', 1, 1591080376, 1591080376);
INSERT INTO `user_login_log` VALUES (173, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1591081193, 1591081193);
INSERT INTO `user_login_log` VALUES (174, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1591081198, 1591081198);
INSERT INTO `user_login_log` VALUES (175, '13631390448', 0, '122.114.88.197', '{\"username\":\"13631390448\",\"timestamp\":1591088285}', '登录成功', 1, 1591088287, 1591088287);
INSERT INTO `user_login_log` VALUES (176, '17308051367', 0, '122.114.88.197', '{\"username\":\"17308051367\",\"timestamp\":1591146533}', '登录成功', 1, 1591146532, 1591146532);
INSERT INTO `user_login_log` VALUES (177, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1591149882, 1591149882);
INSERT INTO `user_login_log` VALUES (178, 'demo', 0, '180.167.105.22', '{\"username\":\"demo\"}', '登录成功', 1, 1591149966, 1591149966);
INSERT INTO `user_login_log` VALUES (179, '18656687900', 1, '180.167.105.22', '{\"phone\":\"18656687900\",\"code\":\"468940\"}', '登录成功', 1, 1591152539, 1591152539);
INSERT INTO `user_login_log` VALUES (180, '18656687900', 1, '180.167.105.22', '{\"phone\":\"18656687900\",\"code\":\"435446\"}', '登录成功', 1, 1591152584, 1591152584);
INSERT INTO `user_login_log` VALUES (181, '18656687900', 1, '180.167.105.22', '{\"phone\":\"18656687900\",\"code\":\"435446\"}', '登录成功', 1, 1591152616, 1591152616);
INSERT INTO `user_login_log` VALUES (182, '18656687900', 1, '180.167.105.22', '{\"phone\":\"18656687900\",\"code\":\"435446\"}', '登录成功', 1, 1591152622, 1591152622);
INSERT INTO `user_login_log` VALUES (183, '18656687900', 1, '180.167.105.22', '{\"phone\":\"18656687900\",\"code\":\"435446\"}', '登录成功', 1, 1591152811, 1591152811);
INSERT INTO `user_login_log` VALUES (184, 'demo', 0, '180.167.105.22', '{\"username\":\"demo\"}', '登录成功', 1, 1591260140, 1591260140);
INSERT INTO `user_login_log` VALUES (185, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1591320299, 1591320299);
INSERT INTO `user_login_log` VALUES (186, 'admin', 0, '180.167.105.22', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1591320405, 1591320405);
INSERT INTO `user_login_log` VALUES (187, 'admin', 0, '180.167.105.22', '{\"username\":\"admin\"}', '登录成功', 1, 1591320411, 1591320411);
INSERT INTO `user_login_log` VALUES (188, 'demo', 0, '180.167.105.22', '{\"username\":\"demo\"}', '登录成功', 1, 1591320428, 1591320428);
INSERT INTO `user_login_log` VALUES (189, 'admin', 0, '180.167.105.22', '{\"username\":\"admin\"}', '登录成功', 1, 1591322411, 1591322411);
INSERT INTO `user_login_log` VALUES (190, 'demo', 0, '180.167.105.22', '{\"username\":\"demo\"}', '登录成功', 1, 1591322448, 1591322448);
INSERT INTO `user_login_log` VALUES (191, 'admin', 0, '180.167.105.22', '{\"username\":\"admin\"}', '登录成功', 1, 1591322567, 1591322567);
INSERT INTO `user_login_log` VALUES (192, 'admin', 0, '180.167.105.22', '{\"username\":\"admin\"}', '登录成功', 1, 1591322571, 1591322571);
INSERT INTO `user_login_log` VALUES (193, 'demo', 0, '180.167.105.22', '{\"username\":\"demo\"}', '登录成功', 1, 1591322865, 1591322865);
INSERT INTO `user_login_log` VALUES (194, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '登录成功', 1, 1591323217, 1591323217);
INSERT INTO `user_login_log` VALUES (195, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '登录成功', 1, 1591323714, 1591323714);
INSERT INTO `user_login_log` VALUES (196, 'admin', 0, '180.167.105.22', '{\"username\":\"admin\"}', '登录成功', 1, 1591335214, 1591335214);
INSERT INTO `user_login_log` VALUES (197, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1591350662, 1591350662);
INSERT INTO `user_login_log` VALUES (198, '1300180047', 0, '122.114.88.197', '{\"username\":\"1300180047\",\"timestamp\":1591490413}', '账号或者密码错误', 0, 1591490413, 1591490413);
INSERT INTO `user_login_log` VALUES (199, '15881063321', 1, '118.114.13.68', '{\"phone\":\"15881063321\",\"code\":\"640870\"}', '登录成功', 1, 1591541236, 1591541236);
INSERT INTO `user_login_log` VALUES (200, '15881063321', 1, '118.114.13.68', '{\"phone\":\"15881063321\",\"code\":\"640870\"}', '登录成功', 1, 1591541246, 1591541246);
INSERT INTO `user_login_log` VALUES (201, '15881063321', 1, '118.114.13.68', '{\"phone\":\"15881063321\",\"code\":\"640870\"}', '登录成功', 1, 1591541247, 1591541247);
INSERT INTO `user_login_log` VALUES (202, '15881063321', 1, '118.114.13.68', '{\"phone\":\"15881063321\",\"code\":\"640870\"}', '登录成功', 1, 1591541249, 1591541249);
INSERT INTO `user_login_log` VALUES (203, '15881063321', 1, '118.114.13.68', '{\"phone\":\"15881063321\",\"code\":\"640870\"}', '登录成功', 1, 1591541250, 1591541250);
INSERT INTO `user_login_log` VALUES (204, '15881063321', 1, '118.114.13.68', '{\"phone\":\"15881063321\",\"code\":\"640870\"}', '登录成功', 1, 1591541251, 1591541251);
INSERT INTO `user_login_log` VALUES (205, '15881063321', 1, '118.114.13.68', '{\"phone\":\"15881063321\",\"code\":\"640870\"}', '登录成功', 1, 1591541251, 1591541251);
INSERT INTO `user_login_log` VALUES (206, '15881063321', 1, '118.114.13.68', '{\"phone\":\"15881063321\",\"code\":\"640870\"}', '登录成功', 1, 1591541251, 1591541251);
INSERT INTO `user_login_log` VALUES (207, '15881063321', 1, '118.114.13.68', '{\"phone\":\"15881063321\",\"code\":\"640870\"}', '登录成功', 1, 1591541253, 1591541253);
INSERT INTO `user_login_log` VALUES (208, '15881063321', 1, '118.114.13.68', '{\"phone\":\"15881063321\",\"code\":\"640870\"}', '登录成功', 1, 1591541562, 1591541562);
INSERT INTO `user_login_log` VALUES (209, '15881063321', 1, '118.114.13.68', '{\"phone\":\"15881063321\",\"code\":\"801758\"}', '登录成功', 1, 1591543641, 1591543641);
INSERT INTO `user_login_log` VALUES (210, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1591554266}', '账号或者密码错误', 0, 1591554265, 1591554265);
INSERT INTO `user_login_log` VALUES (211, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1591626005, 1591626005);
INSERT INTO `user_login_log` VALUES (212, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1591756584, 1591756584);
INSERT INTO `user_login_log` VALUES (213, '168340729', 1, '180.167.105.22', '{\"no_captcha\":\"0\",\"email\":\"ztao8@qq.com\",\"device_id\":\"88888888\"}', '登录成功', 1, 1591758248, 1591758248);
INSERT INTO `user_login_log` VALUES (214, '176923410', 1, '180.167.105.22', '{\"no_captcha\":\"0\",\"email\":\"ztao8@qq.com\",\"device_id\":\"88888888\"}', '登录成功', 1, 1591758251, 1591758251);
INSERT INTO `user_login_log` VALUES (215, '115064832', 1, '180.167.105.22', '{\"no_captcha\":\"0\",\"email\":\"ztao8@qq.com\",\"device_id\":\"88888888\"}', '登录成功', 1, 1591758253, 1591758253);
INSERT INTO `user_login_log` VALUES (216, '187064315', 1, '180.167.105.22', '{\"no_captcha\":\"0\",\"email\":\"ztao8@qq.com\",\"device_id\":\"88888888\"}', '登录成功', 1, 1591758350, 1591758350);
INSERT INTO `user_login_log` VALUES (217, '187064315', 1, '180.167.105.22', '{\"no_captcha\":\"0\",\"email\":\"ztao8@qq.com\",\"device_id\":\"88888888\"}', '登录成功', 1, 1591758365, 1591758365);
INSERT INTO `user_login_log` VALUES (218, '187064315', 1, '180.167.105.22', '{\"no_captcha\":\"0\",\"email\":\"ztao8@qq.com\",\"device_id\":\"88888888\"}', '登录成功', 1, 1591758367, 1591758367);
INSERT INTO `user_login_log` VALUES (219, '187064315', 1, '180.167.105.22', '{\"no_captcha\":\"0\",\"email\":\"ztao8@qq.com\",\"device_id\":\"88888888\"}', '登录成功', 1, 1591758805, 1591758805);
INSERT INTO `user_login_log` VALUES (220, '187064315', 1, '180.167.105.22', '{\"no_captcha\":\"0\",\"email\":\"ztao8@qq.com\",\"device_id\":\"88888888\"}', '登录成功', 1, 1591782544, 1591782544);
INSERT INTO `user_login_log` VALUES (221, '15881063321', 1, '110.185.28.231', '{\"phone\":\"15881063321\",\"code\":\"732912\"}', '登录成功', 1, 1591799465, 1591799465);
INSERT INTO `user_login_log` VALUES (222, '187064315', 1, '180.167.105.22', '{\"no_captcha\":\"0\",\"email\":\"ztao8@qq.com\",\"device_id\":\"88888888\"}', '登录成功', 1, 1591843333, 1591843333);
INSERT INTO `user_login_log` VALUES (223, '187064315', 1, '180.167.105.22', '{\"no_captcha\":\"0\",\"email\":\"ztao8@qq.com\",\"device_id\":\"88888888\"}', '登录成功', 1, 1591843336, 1591843336);
INSERT INTO `user_login_log` VALUES (224, '187064315', 1, '180.167.105.22', '{\"no_captcha\":\"0\",\"email\":\"ztao8@qq.com\",\"device_id\":\"88888888\"}', '登录成功', 1, 1591843338, 1591843338);
INSERT INTO `user_login_log` VALUES (225, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1591844078, 1591844078);
INSERT INTO `user_login_log` VALUES (226, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1591846708, 1591846708);
INSERT INTO `user_login_log` VALUES (227, '187064315', 1, '180.167.105.22', '{\"no_captcha\":\"0\",\"email\":\"ztao8@qq.com\",\"device_id\":\"88888888\"}', '登录成功', 1, 1591846987, 1591846987);
INSERT INTO `user_login_log` VALUES (228, 'demo', 0, '180.167.105.22', '{\"username\":\"demo\"}', '登录成功', 1, 1591854614, 1591854614);
INSERT INTO `user_login_log` VALUES (229, '187064315', 1, '180.167.105.22', '{\"no_captcha\":\"0\",\"email\":\"ztao8@qq.com\",\"device_id\":\"88888888\"}', '登录成功', 1, 1591855217, 1591855217);
INSERT INTO `user_login_log` VALUES (230, '187064315', 1, '180.167.105.22', '{\"no_captcha\":\"0\",\"email\":\"ztao8@qq.com\",\"device_id\":\"88888888\"}', '登录成功', 1, 1591855403, 1591855403);
INSERT INTO `user_login_log` VALUES (231, 'demo', 0, '180.167.105.22', '{\"username\":\"demo\"}', '登录成功', 1, 1591856356, 1591856356);
INSERT INTO `user_login_log` VALUES (232, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1591856814, 1591856814);
INSERT INTO `user_login_log` VALUES (233, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1591857590, 1591857590);
INSERT INTO `user_login_log` VALUES (234, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1591857775, 1591857775);
INSERT INTO `user_login_log` VALUES (235, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '登录成功', 1, 1591858050, 1591858050);
INSERT INTO `user_login_log` VALUES (236, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '账号或者密码错误', 0, 1591858178, 1591858178);
INSERT INTO `user_login_log` VALUES (237, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '登录成功', 1, 1591858183, 1591858183);
INSERT INTO `user_login_log` VALUES (238, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1591858663, 1591858663);
INSERT INTO `user_login_log` VALUES (239, 'demo', 0, '180.167.105.22', '{\"username\":\"demo\"}', '登录成功', 1, 1591858745, 1591858745);
INSERT INTO `user_login_log` VALUES (240, 'demo', 0, '180.167.105.22', '{\"username\":\"demo\"}', '登录成功', 1, 1591859329, 1591859329);
INSERT INTO `user_login_log` VALUES (241, 'demo', 0, '180.167.105.22', '{\"username\":\"demo\"}', '登录成功', 1, 1591859702, 1591859702);
INSERT INTO `user_login_log` VALUES (242, 'demo', 0, '180.167.105.22', '{\"username\":\"demo\"}', '登录成功', 1, 1591859739, 1591859739);
INSERT INTO `user_login_log` VALUES (243, 'demo', 0, '180.167.105.22', '{\"username\":\"demo\"}', '登录成功', 1, 1591860003, 1591860003);
INSERT INTO `user_login_log` VALUES (244, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1591860262, 1591860262);
INSERT INTO `user_login_log` VALUES (245, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1591860402, 1591860402);
INSERT INTO `user_login_log` VALUES (246, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1591860880, 1591860880);
INSERT INTO `user_login_log` VALUES (247, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1591860885, 1591860885);
INSERT INTO `user_login_log` VALUES (248, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1591863392, 1591863392);
INSERT INTO `user_login_log` VALUES (249, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1591864334, 1591864334);
INSERT INTO `user_login_log` VALUES (250, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1591864534, 1591864534);
INSERT INTO `user_login_log` VALUES (251, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1591864877, 1591864877);
INSERT INTO `user_login_log` VALUES (252, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1591864988, 1591864988);
INSERT INTO `user_login_log` VALUES (253, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1591865085, 1591865085);
INSERT INTO `user_login_log` VALUES (254, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1591865161, 1591865161);
INSERT INTO `user_login_log` VALUES (255, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1591865517, 1591865517);
INSERT INTO `user_login_log` VALUES (256, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1591865561, 1591865561);
INSERT INTO `user_login_log` VALUES (257, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1591865571, 1591865571);
INSERT INTO `user_login_log` VALUES (258, '134295087', 1, '117.172.255.20', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1591866477, 1591866477);
INSERT INTO `user_login_log` VALUES (259, '134295087', 1, '117.172.255.20', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1591866594, 1591866594);
INSERT INTO `user_login_log` VALUES (260, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1591867335, 1591867335);
INSERT INTO `user_login_log` VALUES (261, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1591868377, 1591868377);
INSERT INTO `user_login_log` VALUES (262, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1591868477, 1591868477);
INSERT INTO `user_login_log` VALUES (263, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1591868489, 1591868489);
INSERT INTO `user_login_log` VALUES (264, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1591868646, 1591868646);
INSERT INTO `user_login_log` VALUES (265, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1591868657, 1591868657);
INSERT INTO `user_login_log` VALUES (266, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '登录成功', 1, 1591868670, 1591868670);
INSERT INTO `user_login_log` VALUES (267, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '登录成功', 1, 1591868674, 1591868674);
INSERT INTO `user_login_log` VALUES (268, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1591868695, 1591868695);
INSERT INTO `user_login_log` VALUES (269, 'admin', 0, '180.167.105.22', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1591868728, 1591868728);
INSERT INTO `user_login_log` VALUES (270, 'admin', 0, '180.167.105.22', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1591868733, 1591868733);
INSERT INTO `user_login_log` VALUES (271, 'admin', 0, '180.167.105.22', '{\"username\":\"admin\"}', '登录成功', 1, 1591868745, 1591868745);
INSERT INTO `user_login_log` VALUES (272, 'admin', 0, '180.167.105.22', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1591868819, 1591868819);
INSERT INTO `user_login_log` VALUES (273, 'admin', 0, '180.167.105.22', '{\"username\":\"admin\"}', '登录成功', 1, 1591868826, 1591868826);
INSERT INTO `user_login_log` VALUES (274, 'admin', 0, '180.167.105.22', '{\"username\":\"admin\"}', '登录成功', 1, 1591868841, 1591868841);
INSERT INTO `user_login_log` VALUES (275, 'admin', 0, '180.167.105.22', '{\"username\":\"admin\"}', '登录成功', 1, 1591868879, 1591868879);
INSERT INTO `user_login_log` VALUES (276, 'admin', 0, '180.167.105.22', '{\"username\":\"admin\"}', '登录成功', 1, 1591868926, 1591868926);
INSERT INTO `user_login_log` VALUES (277, 'admin', 0, '180.167.105.22', '{\"username\":\"admin\"}', '登录成功', 1, 1591868970, 1591868970);
INSERT INTO `user_login_log` VALUES (278, 'admin', 0, '180.167.105.22', '{\"username\":\"admin\"}', '登录成功', 1, 1591868987, 1591868987);
INSERT INTO `user_login_log` VALUES (279, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1591869090, 1591869090);
INSERT INTO `user_login_log` VALUES (280, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '登录成功', 1, 1591869111, 1591869111);
INSERT INTO `user_login_log` VALUES (281, '1083048661', 0, '122.114.88.197', '{\"username\":\"1083048661\",\"timestamp\":1591871009}', '账号或者密码错误', 0, 1591871009, 1591871009);
INSERT INTO `user_login_log` VALUES (282, 'demo', 0, '180.167.105.22', '{\"username\":\"demo\"}', '登录成功', 1, 1591925199, 1591925199);
INSERT INTO `user_login_log` VALUES (283, 'admin', 0, '180.167.105.22', '{\"username\":\"admin\"}', '登录成功', 1, 1591925646, 1591925646);
INSERT INTO `user_login_log` VALUES (284, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1591925810, 1591925810);
INSERT INTO `user_login_log` VALUES (285, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1591926815, 1591926815);
INSERT INTO `user_login_log` VALUES (286, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1591926879, 1591926879);
INSERT INTO `user_login_log` VALUES (287, 'admin', 0, '180.167.105.22', '{\"username\":\"admin\"}', '登录成功', 1, 1591928150, 1591928150);
INSERT INTO `user_login_log` VALUES (288, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1591929961, 1591929961);
INSERT INTO `user_login_log` VALUES (289, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1591932418, 1591932418);
INSERT INTO `user_login_log` VALUES (290, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1591932453, 1591932453);
INSERT INTO `user_login_log` VALUES (291, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1591933799, 1591933799);
INSERT INTO `user_login_log` VALUES (292, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1591933956, 1591933956);
INSERT INTO `user_login_log` VALUES (293, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1591943027, 1591943027);
INSERT INTO `user_login_log` VALUES (294, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1591943121, 1591943121);
INSERT INTO `user_login_log` VALUES (295, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1591946241, 1591946241);
INSERT INTO `user_login_log` VALUES (296, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '登录成功', 1, 1591946407, 1591946407);
INSERT INTO `user_login_log` VALUES (297, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1591947851, 1591947851);
INSERT INTO `user_login_log` VALUES (298, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1591947861, 1591947861);
INSERT INTO `user_login_log` VALUES (299, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1591948808, 1591948808);
INSERT INTO `user_login_log` VALUES (300, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1591949363, 1591949363);
INSERT INTO `user_login_log` VALUES (301, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592010055, 1592010055);
INSERT INTO `user_login_log` VALUES (302, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592012716, 1592012716);
INSERT INTO `user_login_log` VALUES (303, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592012996, 1592012996);
INSERT INTO `user_login_log` VALUES (304, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592013055, 1592013055);
INSERT INTO `user_login_log` VALUES (305, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592013110, 1592013110);
INSERT INTO `user_login_log` VALUES (306, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592013149, 1592013149);
INSERT INTO `user_login_log` VALUES (307, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592013793, 1592013793);
INSERT INTO `user_login_log` VALUES (308, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592014120, 1592014120);
INSERT INTO `user_login_log` VALUES (309, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592014177, 1592014177);
INSERT INTO `user_login_log` VALUES (310, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592014193, 1592014193);
INSERT INTO `user_login_log` VALUES (311, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592014262, 1592014262);
INSERT INTO `user_login_log` VALUES (312, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592014282, 1592014282);
INSERT INTO `user_login_log` VALUES (313, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592014359, 1592014359);
INSERT INTO `user_login_log` VALUES (314, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592014390, 1592014390);
INSERT INTO `user_login_log` VALUES (315, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592014403, 1592014403);
INSERT INTO `user_login_log` VALUES (316, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592014415, 1592014415);
INSERT INTO `user_login_log` VALUES (317, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592014432, 1592014432);
INSERT INTO `user_login_log` VALUES (318, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592014583, 1592014583);
INSERT INTO `user_login_log` VALUES (319, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592015242, 1592015242);
INSERT INTO `user_login_log` VALUES (320, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592015679, 1592015679);
INSERT INTO `user_login_log` VALUES (321, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592016079, 1592016079);
INSERT INTO `user_login_log` VALUES (322, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592016193, 1592016193);
INSERT INTO `user_login_log` VALUES (323, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592016434, 1592016434);
INSERT INTO `user_login_log` VALUES (324, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592016485, 1592016485);
INSERT INTO `user_login_log` VALUES (325, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592016510, 1592016510);
INSERT INTO `user_login_log` VALUES (326, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592016558, 1592016558);
INSERT INTO `user_login_log` VALUES (327, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592016576, 1592016576);
INSERT INTO `user_login_log` VALUES (328, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592016644, 1592016644);
INSERT INTO `user_login_log` VALUES (329, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592016698, 1592016698);
INSERT INTO `user_login_log` VALUES (330, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592017159, 1592017159);
INSERT INTO `user_login_log` VALUES (331, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592017265, 1592017265);
INSERT INTO `user_login_log` VALUES (332, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592017326, 1592017326);
INSERT INTO `user_login_log` VALUES (333, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592017336, 1592017336);
INSERT INTO `user_login_log` VALUES (334, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592017441, 1592017441);
INSERT INTO `user_login_log` VALUES (335, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592017495, 1592017495);
INSERT INTO `user_login_log` VALUES (336, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592017580, 1592017580);
INSERT INTO `user_login_log` VALUES (337, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592017777, 1592017777);
INSERT INTO `user_login_log` VALUES (338, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592017917, 1592017917);
INSERT INTO `user_login_log` VALUES (339, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592017959, 1592017959);
INSERT INTO `user_login_log` VALUES (340, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592018177, 1592018177);
INSERT INTO `user_login_log` VALUES (341, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592018259, 1592018259);
INSERT INTO `user_login_log` VALUES (342, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592018295, 1592018295);
INSERT INTO `user_login_log` VALUES (343, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592020276, 1592020276);
INSERT INTO `user_login_log` VALUES (344, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592020562, 1592020562);
INSERT INTO `user_login_log` VALUES (345, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592020588, 1592020588);
INSERT INTO `user_login_log` VALUES (346, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592020629, 1592020629);
INSERT INTO `user_login_log` VALUES (347, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1592023147}', '账号或者密码错误', 0, 1592023148, 1592023148);
INSERT INTO `user_login_log` VALUES (348, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1592023160}', '账号或者密码错误', 0, 1592023161, 1592023161);
INSERT INTO `user_login_log` VALUES (349, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1592023162}', '账号或者密码错误', 0, 1592023163, 1592023163);
INSERT INTO `user_login_log` VALUES (350, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1592023162}', '账号或者密码错误', 0, 1592023163, 1592023163);
INSERT INTO `user_login_log` VALUES (351, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592027471, 1592027471);
INSERT INTO `user_login_log` VALUES (352, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592028727, 1592028727);
INSERT INTO `user_login_log` VALUES (353, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592028816, 1592028816);
INSERT INTO `user_login_log` VALUES (354, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592028973, 1592028973);
INSERT INTO `user_login_log` VALUES (355, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592029073, 1592029073);
INSERT INTO `user_login_log` VALUES (356, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592029116, 1592029116);
INSERT INTO `user_login_log` VALUES (357, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592029240, 1592029240);
INSERT INTO `user_login_log` VALUES (358, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592029276, 1592029276);
INSERT INTO `user_login_log` VALUES (359, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592029367, 1592029367);
INSERT INTO `user_login_log` VALUES (360, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592029682, 1592029682);
INSERT INTO `user_login_log` VALUES (361, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592029894, 1592029894);
INSERT INTO `user_login_log` VALUES (362, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592029930, 1592029930);
INSERT INTO `user_login_log` VALUES (363, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592030271, 1592030271);
INSERT INTO `user_login_log` VALUES (364, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592030450, 1592030450);
INSERT INTO `user_login_log` VALUES (365, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592030607, 1592030607);
INSERT INTO `user_login_log` VALUES (366, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592030735, 1592030735);
INSERT INTO `user_login_log` VALUES (367, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592030816, 1592030816);
INSERT INTO `user_login_log` VALUES (368, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592031071, 1592031071);
INSERT INTO `user_login_log` VALUES (369, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592031385, 1592031385);
INSERT INTO `user_login_log` VALUES (370, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592031545, 1592031545);
INSERT INTO `user_login_log` VALUES (371, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592032253, 1592032253);
INSERT INTO `user_login_log` VALUES (372, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592032396, 1592032396);
INSERT INTO `user_login_log` VALUES (373, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592034535, 1592034535);
INSERT INTO `user_login_log` VALUES (374, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592034542, 1592034542);
INSERT INTO `user_login_log` VALUES (375, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592034622, 1592034622);
INSERT INTO `user_login_log` VALUES (376, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592037488, 1592037488);
INSERT INTO `user_login_log` VALUES (377, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592187572, 1592187572);
INSERT INTO `user_login_log` VALUES (378, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592187610, 1592187610);
INSERT INTO `user_login_log` VALUES (379, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592188814, 1592188814);
INSERT INTO `user_login_log` VALUES (380, 'admin', 0, '180.167.105.22', '{\"username\":\"admin\"}', '登录成功', 1, 1592189737, 1592189737);
INSERT INTO `user_login_log` VALUES (381, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592190284, 1592190284);
INSERT INTO `user_login_log` VALUES (382, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592190444, 1592190444);
INSERT INTO `user_login_log` VALUES (383, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592193099, 1592193099);
INSERT INTO `user_login_log` VALUES (384, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592193701, 1592193701);
INSERT INTO `user_login_log` VALUES (385, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592193799, 1592193799);
INSERT INTO `user_login_log` VALUES (386, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592193949, 1592193949);
INSERT INTO `user_login_log` VALUES (387, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592199851, 1592199851);
INSERT INTO `user_login_log` VALUES (388, 'admin', 0, '180.167.105.22', '{\"username\":\"admin\"}', '登录成功', 1, 1592200362, 1592200362);
INSERT INTO `user_login_log` VALUES (389, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592200421, 1592200421);
INSERT INTO `user_login_log` VALUES (390, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592200465, 1592200465);
INSERT INTO `user_login_log` VALUES (391, 'admin', 0, '180.167.105.22', '{\"username\":\"admin\"}', '登录成功', 1, 1592200477, 1592200477);
INSERT INTO `user_login_log` VALUES (392, 'admin', 0, '180.167.105.22', '{\"username\":\"admin\"}', '登录成功', 1, 1592200565, 1592200565);
INSERT INTO `user_login_log` VALUES (393, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592200628, 1592200628);
INSERT INTO `user_login_log` VALUES (394, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592200824, 1592200824);
INSERT INTO `user_login_log` VALUES (395, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592201050, 1592201050);
INSERT INTO `user_login_log` VALUES (396, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592204112, 1592204112);
INSERT INTO `user_login_log` VALUES (397, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592205401, 1592205401);
INSERT INTO `user_login_log` VALUES (398, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592205784, 1592205784);
INSERT INTO `user_login_log` VALUES (399, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592205873, 1592205873);
INSERT INTO `user_login_log` VALUES (400, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592206136, 1592206136);
INSERT INTO `user_login_log` VALUES (401, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592206292, 1592206292);
INSERT INTO `user_login_log` VALUES (402, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592206430, 1592206430);
INSERT INTO `user_login_log` VALUES (403, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592206484, 1592206484);
INSERT INTO `user_login_log` VALUES (404, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592206515, 1592206515);
INSERT INTO `user_login_log` VALUES (405, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592207092, 1592207092);
INSERT INTO `user_login_log` VALUES (406, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592207560, 1592207560);
INSERT INTO `user_login_log` VALUES (407, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592207635, 1592207635);
INSERT INTO `user_login_log` VALUES (408, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592207702, 1592207702);
INSERT INTO `user_login_log` VALUES (409, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592208331, 1592208331);
INSERT INTO `user_login_log` VALUES (410, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592208401, 1592208401);
INSERT INTO `user_login_log` VALUES (411, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592208688, 1592208688);
INSERT INTO `user_login_log` VALUES (412, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592209021, 1592209021);
INSERT INTO `user_login_log` VALUES (413, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592209961, 1592209961);
INSERT INTO `user_login_log` VALUES (414, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592210421, 1592210421);
INSERT INTO `user_login_log` VALUES (415, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592210435, 1592210435);
INSERT INTO `user_login_log` VALUES (416, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592210485, 1592210485);
INSERT INTO `user_login_log` VALUES (417, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592210505, 1592210505);
INSERT INTO `user_login_log` VALUES (418, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592210520, 1592210520);
INSERT INTO `user_login_log` VALUES (419, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592210601, 1592210601);
INSERT INTO `user_login_log` VALUES (420, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592211033, 1592211033);
INSERT INTO `user_login_log` VALUES (421, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592211120, 1592211120);
INSERT INTO `user_login_log` VALUES (422, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592211128, 1592211128);
INSERT INTO `user_login_log` VALUES (423, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592211137, 1592211137);
INSERT INTO `user_login_log` VALUES (424, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592212335, 1592212335);
INSERT INTO `user_login_log` VALUES (425, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592212623, 1592212623);
INSERT INTO `user_login_log` VALUES (426, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592212732, 1592212732);
INSERT INTO `user_login_log` VALUES (427, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592212992, 1592212992);
INSERT INTO `user_login_log` VALUES (428, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592213361, 1592213361);
INSERT INTO `user_login_log` VALUES (429, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592213385, 1592213385);
INSERT INTO `user_login_log` VALUES (430, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1592213563, 1592213563);
INSERT INTO `user_login_log` VALUES (431, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1592213564, 1592213564);
INSERT INTO `user_login_log` VALUES (432, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592213622, 1592213622);
INSERT INTO `user_login_log` VALUES (433, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592214626, 1592214626);
INSERT INTO `user_login_log` VALUES (434, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592214659, 1592214659);
INSERT INTO `user_login_log` VALUES (435, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592214789, 1592214789);
INSERT INTO `user_login_log` VALUES (436, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592215109, 1592215109);
INSERT INTO `user_login_log` VALUES (437, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592215435, 1592215435);
INSERT INTO `user_login_log` VALUES (438, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592269889, 1592269889);
INSERT INTO `user_login_log` VALUES (439, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592270190, 1592270190);
INSERT INTO `user_login_log` VALUES (440, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592271763, 1592271763);
INSERT INTO `user_login_log` VALUES (441, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592272059, 1592272059);
INSERT INTO `user_login_log` VALUES (442, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592272754, 1592272754);
INSERT INTO `user_login_log` VALUES (443, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592272796, 1592272796);
INSERT INTO `user_login_log` VALUES (444, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592272887, 1592272887);
INSERT INTO `user_login_log` VALUES (445, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592272922, 1592272922);
INSERT INTO `user_login_log` VALUES (446, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592273141, 1592273141);
INSERT INTO `user_login_log` VALUES (447, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592273467, 1592273467);
INSERT INTO `user_login_log` VALUES (448, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592273490, 1592273490);
INSERT INTO `user_login_log` VALUES (449, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592274040, 1592274040);
INSERT INTO `user_login_log` VALUES (450, 'admin', 0, '180.167.105.22', '{\"username\":\"admin\"}', '登录成功', 1, 1592274097, 1592274097);
INSERT INTO `user_login_log` VALUES (451, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592274645, 1592274645);
INSERT INTO `user_login_log` VALUES (452, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592274724, 1592274724);
INSERT INTO `user_login_log` VALUES (453, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592274862, 1592274862);
INSERT INTO `user_login_log` VALUES (454, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592275130, 1592275130);
INSERT INTO `user_login_log` VALUES (455, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592275301, 1592275301);
INSERT INTO `user_login_log` VALUES (456, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592275315, 1592275315);
INSERT INTO `user_login_log` VALUES (457, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592275839, 1592275839);
INSERT INTO `user_login_log` VALUES (458, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592276002, 1592276002);
INSERT INTO `user_login_log` VALUES (459, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592276182, 1592276182);
INSERT INTO `user_login_log` VALUES (460, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592276210, 1592276210);
INSERT INTO `user_login_log` VALUES (461, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592276342, 1592276342);
INSERT INTO `user_login_log` VALUES (462, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592276385, 1592276385);
INSERT INTO `user_login_log` VALUES (463, 'demo', 0, '180.167.105.22', '{\"username\":\"demo\"}', '账号或者密码错误', 0, 1592276433, 1592276433);
INSERT INTO `user_login_log` VALUES (464, 'demo', 0, '180.167.105.22', '{\"username\":\"demo\"}', '登录成功', 1, 1592276540, 1592276540);
INSERT INTO `user_login_log` VALUES (465, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592276917, 1592276917);
INSERT INTO `user_login_log` VALUES (466, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592277702, 1592277702);
INSERT INTO `user_login_log` VALUES (467, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592277771, 1592277771);
INSERT INTO `user_login_log` VALUES (468, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592277798, 1592277798);
INSERT INTO `user_login_log` VALUES (469, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592277933, 1592277933);
INSERT INTO `user_login_log` VALUES (470, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592278014, 1592278014);
INSERT INTO `user_login_log` VALUES (471, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592279127, 1592279127);
INSERT INTO `user_login_log` VALUES (472, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592279348, 1592279348);
INSERT INTO `user_login_log` VALUES (473, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592279381, 1592279381);
INSERT INTO `user_login_log` VALUES (474, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592279563, 1592279563);
INSERT INTO `user_login_log` VALUES (475, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592279727, 1592279727);
INSERT INTO `user_login_log` VALUES (476, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592279846, 1592279846);
INSERT INTO `user_login_log` VALUES (477, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592279912, 1592279912);
INSERT INTO `user_login_log` VALUES (478, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592285746, 1592285746);
INSERT INTO `user_login_log` VALUES (479, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592286443, 1592286443);
INSERT INTO `user_login_log` VALUES (480, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592286579, 1592286579);
INSERT INTO `user_login_log` VALUES (481, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592286592, 1592286592);
INSERT INTO `user_login_log` VALUES (482, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592286601, 1592286601);
INSERT INTO `user_login_log` VALUES (483, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592286715, 1592286715);
INSERT INTO `user_login_log` VALUES (484, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592286751, 1592286751);
INSERT INTO `user_login_log` VALUES (485, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592286792, 1592286792);
INSERT INTO `user_login_log` VALUES (486, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592286855, 1592286855);
INSERT INTO `user_login_log` VALUES (487, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592287020, 1592287020);
INSERT INTO `user_login_log` VALUES (488, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592287072, 1592287072);
INSERT INTO `user_login_log` VALUES (489, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592287090, 1592287090);
INSERT INTO `user_login_log` VALUES (490, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592287133, 1592287133);
INSERT INTO `user_login_log` VALUES (491, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592287186, 1592287186);
INSERT INTO `user_login_log` VALUES (492, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592287221, 1592287221);
INSERT INTO `user_login_log` VALUES (493, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592287323, 1592287323);
INSERT INTO `user_login_log` VALUES (494, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592287425, 1592287425);
INSERT INTO `user_login_log` VALUES (495, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592287754, 1592287754);
INSERT INTO `user_login_log` VALUES (496, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592287772, 1592287772);
INSERT INTO `user_login_log` VALUES (497, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592288242, 1592288242);
INSERT INTO `user_login_log` VALUES (498, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592288269, 1592288269);
INSERT INTO `user_login_log` VALUES (499, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592288295, 1592288295);
INSERT INTO `user_login_log` VALUES (500, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592288319, 1592288319);
INSERT INTO `user_login_log` VALUES (501, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592288355, 1592288355);
INSERT INTO `user_login_log` VALUES (502, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592288407, 1592288407);
INSERT INTO `user_login_log` VALUES (503, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592288451, 1592288451);
INSERT INTO `user_login_log` VALUES (504, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592288483, 1592288483);
INSERT INTO `user_login_log` VALUES (505, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592288533, 1592288533);
INSERT INTO `user_login_log` VALUES (506, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592288584, 1592288584);
INSERT INTO `user_login_log` VALUES (507, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592288697, 1592288697);
INSERT INTO `user_login_log` VALUES (508, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592288721, 1592288721);
INSERT INTO `user_login_log` VALUES (509, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592288816, 1592288816);
INSERT INTO `user_login_log` VALUES (510, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592289710, 1592289710);
INSERT INTO `user_login_log` VALUES (511, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592289769, 1592289769);
INSERT INTO `user_login_log` VALUES (512, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592289825, 1592289825);
INSERT INTO `user_login_log` VALUES (513, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592289931, 1592289931);
INSERT INTO `user_login_log` VALUES (514, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592289988, 1592289988);
INSERT INTO `user_login_log` VALUES (515, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592290065, 1592290065);
INSERT INTO `user_login_log` VALUES (516, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592291418, 1592291418);
INSERT INTO `user_login_log` VALUES (517, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592291632, 1592291632);
INSERT INTO `user_login_log` VALUES (518, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592293081, 1592293081);
INSERT INTO `user_login_log` VALUES (519, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592293331, 1592293331);
INSERT INTO `user_login_log` VALUES (520, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592294105, 1592294105);
INSERT INTO `user_login_log` VALUES (521, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592294122, 1592294122);
INSERT INTO `user_login_log` VALUES (522, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592294143, 1592294143);
INSERT INTO `user_login_log` VALUES (523, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592294171, 1592294171);
INSERT INTO `user_login_log` VALUES (524, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592294185, 1592294185);
INSERT INTO `user_login_log` VALUES (525, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592294202, 1592294202);
INSERT INTO `user_login_log` VALUES (526, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592294221, 1592294221);
INSERT INTO `user_login_log` VALUES (527, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592294388, 1592294388);
INSERT INTO `user_login_log` VALUES (528, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592294555, 1592294555);
INSERT INTO `user_login_log` VALUES (529, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592294561, 1592294561);
INSERT INTO `user_login_log` VALUES (530, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1592295289}', '账号或者密码错误', 0, 1592295294, 1592295294);
INSERT INTO `user_login_log` VALUES (531, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '登录成功', 1, 1592295384, 1592295384);
INSERT INTO `user_login_log` VALUES (532, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592295591, 1592295591);
INSERT INTO `user_login_log` VALUES (533, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592295633, 1592295633);
INSERT INTO `user_login_log` VALUES (534, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592295644, 1592295644);
INSERT INTO `user_login_log` VALUES (535, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592295672, 1592295672);
INSERT INTO `user_login_log` VALUES (536, '134295087', 1, '117.172.255.20', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1592299455, 1592299455);
INSERT INTO `user_login_log` VALUES (537, '134295087', 1, '117.172.255.20', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1592299651, 1592299651);
INSERT INTO `user_login_log` VALUES (538, '134295087', 1, '117.172.255.20', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1592299910, 1592299910);
INSERT INTO `user_login_log` VALUES (539, '134295087', 1, '117.172.255.20', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1592299924, 1592299924);
INSERT INTO `user_login_log` VALUES (540, '134295087', 1, '117.172.255.20', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1592300095, 1592300095);
INSERT INTO `user_login_log` VALUES (541, '134295087', 1, '117.172.255.20', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1592300102, 1592300102);
INSERT INTO `user_login_log` VALUES (542, '134295087', 1, '117.172.255.20', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1592300111, 1592300111);
INSERT INTO `user_login_log` VALUES (543, '134295087', 1, '117.172.255.20', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1592300114, 1592300114);
INSERT INTO `user_login_log` VALUES (544, '134295087', 1, '117.172.255.20', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1592300117, 1592300117);
INSERT INTO `user_login_log` VALUES (545, '134295087', 1, '117.172.255.20', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1592300121, 1592300121);
INSERT INTO `user_login_log` VALUES (546, '134295087', 1, '117.172.255.20', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1592300127, 1592300127);
INSERT INTO `user_login_log` VALUES (547, '134295087', 1, '117.172.255.20', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1592300132, 1592300132);
INSERT INTO `user_login_log` VALUES (548, '134295087', 1, '117.172.255.20', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1592300256, 1592300256);
INSERT INTO `user_login_log` VALUES (549, '134295087', 1, '117.172.255.20', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1592300263, 1592300263);
INSERT INTO `user_login_log` VALUES (550, '134295087', 1, '117.172.255.20', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1592300268, 1592300268);
INSERT INTO `user_login_log` VALUES (551, '134295087', 1, '117.172.255.20', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1592300508, 1592300508);
INSERT INTO `user_login_log` VALUES (552, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592300634, 1592300634);
INSERT INTO `user_login_log` VALUES (553, '134295087', 1, '117.172.255.20', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1592301315, 1592301315);
INSERT INTO `user_login_log` VALUES (554, '134295087', 1, '117.172.255.20', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1592301325, 1592301325);
INSERT INTO `user_login_log` VALUES (555, '134295087', 1, '117.172.255.20', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1592301379, 1592301379);
INSERT INTO `user_login_log` VALUES (556, '134295087', 1, '117.172.255.20', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1592301695, 1592301695);
INSERT INTO `user_login_log` VALUES (557, '134295087', 1, '117.172.255.20', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1592301884, 1592301884);
INSERT INTO `user_login_log` VALUES (558, '134295087', 1, '117.172.255.20', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1592302687, 1592302687);
INSERT INTO `user_login_log` VALUES (559, '134295087', 1, '117.172.255.20', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1592302692, 1592302692);
INSERT INTO `user_login_log` VALUES (560, '134295087', 1, '117.172.255.20', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1592302694, 1592302694);
INSERT INTO `user_login_log` VALUES (561, '134295087', 1, '117.172.255.20', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1592302697, 1592302697);
INSERT INTO `user_login_log` VALUES (562, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1592302709, 1592302709);
INSERT INTO `user_login_log` VALUES (563, '139526480', 1, '118.112.196.251', '{\"device_id\":\"d8933a7f280e5861\"}', '登录成功', 1, 1592302853, 1592302853);
INSERT INTO `user_login_log` VALUES (564, '134295087', 1, '171.221.108.70', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1592304101, 1592304101);
INSERT INTO `user_login_log` VALUES (565, '194237865', 1, '100.2.103.245', '{\"device_id\":\"dd530514d757e718\"}', '登录成功', 1, 1592309750, 1592309750);
INSERT INTO `user_login_log` VALUES (566, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1592309832, 1592309832);
INSERT INTO `user_login_log` VALUES (567, '194237865', 1, '100.2.103.245', '{\"device_id\":\"dd530514d757e718\"}', '登录成功', 1, 1592309956, 1592309956);
INSERT INTO `user_login_log` VALUES (568, '194237865', 1, '100.2.103.245', '{\"device_id\":\"dd530514d757e718\"}', '登录成功', 1, 1592309973, 1592309973);
INSERT INTO `user_login_log` VALUES (569, '194237865', 1, '100.2.103.245', '{\"device_id\":\"dd530514d757e718\"}', '登录成功', 1, 1592309977, 1592309977);
INSERT INTO `user_login_log` VALUES (570, '194237865', 1, '100.2.103.245', '{\"device_id\":\"dd530514d757e718\"}', '登录成功', 1, 1592310285, 1592310285);
INSERT INTO `user_login_log` VALUES (571, '194237865', 1, '100.2.103.245', '{\"device_id\":\"dd530514d757e718\"}', '登录成功', 1, 1592310571, 1592310571);
INSERT INTO `user_login_log` VALUES (572, '139526480', 1, '118.112.196.251', '{\"device_id\":\"d8933a7f280e5861\"}', '登录成功', 1, 1592310994, 1592310994);
INSERT INTO `user_login_log` VALUES (573, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1592312437, 1592312437);
INSERT INTO `user_login_log` VALUES (574, '139526480', 1, '118.112.196.251', '{\"device_id\":\"d8933a7f280e5861\"}', '登录成功', 1, 1592319104, 1592319104);
INSERT INTO `user_login_log` VALUES (575, '194237865', 1, '100.2.103.245', '{\"device_id\":\"dd530514d757e718\"}', '登录成功', 1, 1592324367, 1592324367);
INSERT INTO `user_login_log` VALUES (576, '134295087', 1, '117.172.255.20', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1592356058, 1592356058);
INSERT INTO `user_login_log` VALUES (577, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592356717, 1592356717);
INSERT INTO `user_login_log` VALUES (578, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592357235, 1592357235);
INSERT INTO `user_login_log` VALUES (579, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592357294, 1592357294);
INSERT INTO `user_login_log` VALUES (580, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592357375, 1592357375);
INSERT INTO `user_login_log` VALUES (581, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592357598, 1592357598);
INSERT INTO `user_login_log` VALUES (582, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592358785, 1592358785);
INSERT INTO `user_login_log` VALUES (583, '139526480', 1, '118.112.196.251', '{\"device_id\":\"d8933a7f280e5861\"}', '登录成功', 1, 1592359619, 1592359619);
INSERT INTO `user_login_log` VALUES (584, '15881063321', 1, '117.172.255.20', '{\"phone\":\"15881063321\",\"code\":\"314056\"}', '登录成功', 1, 1592360358, 1592360358);
INSERT INTO `user_login_log` VALUES (585, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592361076, 1592361076);
INSERT INTO `user_login_log` VALUES (586, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592361491, 1592361491);
INSERT INTO `user_login_log` VALUES (587, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592362622, 1592362622);
INSERT INTO `user_login_log` VALUES (588, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592362695, 1592362695);
INSERT INTO `user_login_log` VALUES (589, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592362703, 1592362703);
INSERT INTO `user_login_log` VALUES (590, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592362710, 1592362710);
INSERT INTO `user_login_log` VALUES (591, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592362719, 1592362719);
INSERT INTO `user_login_log` VALUES (592, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592362836, 1592362836);
INSERT INTO `user_login_log` VALUES (593, '139526480', 1, '118.112.196.251', '{\"device_id\":\"d8933a7f280e5861\"}', '登录成功', 1, 1592363238, 1592363238);
INSERT INTO `user_login_log` VALUES (594, '134295087', 1, '117.172.255.20', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1592363384, 1592363384);
INSERT INTO `user_login_log` VALUES (595, '134295087', 1, '117.172.255.20', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1592363422, 1592363422);
INSERT INTO `user_login_log` VALUES (596, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592374947, 1592374947);
INSERT INTO `user_login_log` VALUES (597, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592378426, 1592378426);
INSERT INTO `user_login_log` VALUES (598, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592379097, 1592379097);
INSERT INTO `user_login_log` VALUES (599, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592379142, 1592379142);
INSERT INTO `user_login_log` VALUES (600, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592379224, 1592379224);
INSERT INTO `user_login_log` VALUES (601, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592379257, 1592379257);
INSERT INTO `user_login_log` VALUES (602, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592379260, 1592379260);
INSERT INTO `user_login_log` VALUES (603, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592379265, 1592379265);
INSERT INTO `user_login_log` VALUES (604, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592379474, 1592379474);
INSERT INTO `user_login_log` VALUES (605, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592379579, 1592379579);
INSERT INTO `user_login_log` VALUES (606, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '登录成功', 1, 1592380788, 1592380788);
INSERT INTO `user_login_log` VALUES (607, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '登录成功', 1, 1592381018, 1592381018);
INSERT INTO `user_login_log` VALUES (608, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '登录成功', 1, 1592383250, 1592383250);
INSERT INTO `user_login_log` VALUES (609, '174259136', 1, '114.244.132.248', '{\"device_id\":\"a0d127c39ba139ce\"}', '登录成功', 1, 1592383655, 1592383655);
INSERT INTO `user_login_log` VALUES (610, '121530874', 1, '221.216.207.182', '{\"device_id\":\"e1b38af99c549d29\"}', '登录成功', 1, 1592384428, 1592384428);
INSERT INTO `user_login_log` VALUES (611, 'demo', 0, '180.167.105.22', '{\"username\":\"demo\"}', '登录成功', 1, 1592385828, 1592385828);
INSERT INTO `user_login_log` VALUES (612, '174259136', 1, '114.244.132.248', '{\"device_id\":\"a0d127c39ba139ce\"}', '登录成功', 1, 1592387467, 1592387467);
INSERT INTO `user_login_log` VALUES (613, '194237865', 1, '100.2.103.245', '{\"device_id\":\"dd530514d757e718\"}', '登录成功', 1, 1592395133, 1592395133);
INSERT INTO `user_login_log` VALUES (614, '194237865', 1, '100.2.103.245', '{\"device_id\":\"dd530514d757e718\"}', '登录成功', 1, 1592434998, 1592434998);
INSERT INTO `user_login_log` VALUES (615, 'demo', 0, '180.167.105.22', '{\"username\":\"demo\"}', '登录成功', 1, 1592447667, 1592447667);
INSERT INTO `user_login_log` VALUES (616, '15881063321', 1, '117.172.255.20', '{\"phone\":\"15881063321\",\"code\":\"464220\"}', '登录成功', 1, 1592460109, 1592460109);
INSERT INTO `user_login_log` VALUES (617, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592529984, 1592529984);
INSERT INTO `user_login_log` VALUES (618, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592530380, 1592530380);
INSERT INTO `user_login_log` VALUES (619, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592531315, 1592531315);
INSERT INTO `user_login_log` VALUES (620, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592532056, 1592532056);
INSERT INTO `user_login_log` VALUES (621, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592532149, 1592532149);
INSERT INTO `user_login_log` VALUES (622, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592532216, 1592532216);
INSERT INTO `user_login_log` VALUES (623, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592532297, 1592532297);
INSERT INTO `user_login_log` VALUES (624, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592532482, 1592532482);
INSERT INTO `user_login_log` VALUES (625, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592532653, 1592532653);
INSERT INTO `user_login_log` VALUES (626, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592532796, 1592532796);
INSERT INTO `user_login_log` VALUES (627, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592533569, 1592533569);
INSERT INTO `user_login_log` VALUES (628, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1592533687, 1592533687);
INSERT INTO `user_login_log` VALUES (629, '134295087', 1, '117.172.255.20', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1592535251, 1592535251);
INSERT INTO `user_login_log` VALUES (630, '134295087', 1, '117.172.255.20', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1592535467, 1592535467);
INSERT INTO `user_login_log` VALUES (631, '134295087', 1, '117.172.255.20', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1592535687, 1592535687);
INSERT INTO `user_login_log` VALUES (632, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '登录成功', 1, 1592535942, 1592535942);
INSERT INTO `user_login_log` VALUES (633, 'adminkan', 0, '122.114.88.197', '{\"username\":\"adminkan\",\"timestamp\":1592556217}', '账号或者密码错误', 0, 1592556535, 1592556535);
INSERT INTO `user_login_log` VALUES (634, '121530874', 1, '106.121.134.3', '{\"device_id\":\"e1b38af99c549d29\"}', '登录成功', 1, 1592566719, 1592566719);
INSERT INTO `user_login_log` VALUES (635, '15881063321', 1, '118.113.12.212', '{\"phone\":\"15881063321\",\"code\":\"363366\"}', '登录成功', 1, 1592634999, 1592634999);
INSERT INTO `user_login_log` VALUES (636, 'demo', 0, '183.193.116.42', '{\"username\":\"demo\"}', '登录成功', 1, 1592639469, 1592639469);
INSERT INTO `user_login_log` VALUES (637, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1592662394, 1592662394);
INSERT INTO `user_login_log` VALUES (638, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '登录成功', 1, 1592662399, 1592662399);
INSERT INTO `user_login_log` VALUES (639, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '登录成功', 1, 1592669142, 1592669142);
INSERT INTO `user_login_log` VALUES (640, '15881063321', 1, '118.113.12.212', '{\"phone\":\"15881063321\",\"code\":\"973929\"}', '登录成功', 1, 1592701633, 1592701633);
INSERT INTO `user_login_log` VALUES (641, '15881063321', 1, '118.113.12.212', '{\"phone\":\"15881063321\",\"code\":\"401801\"}', '登录成功', 1, 1592741320, 1592741320);
INSERT INTO `user_login_log` VALUES (642, '15881063321', 1, '118.113.12.212', '{\"phone\":\"15881063321\",\"code\":\"326558\"}', '登录成功', 1, 1592744051, 1592744051);
INSERT INTO `user_login_log` VALUES (643, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1592745954, 1592745954);
INSERT INTO `user_login_log` VALUES (644, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1592745955, 1592745955);
INSERT INTO `user_login_log` VALUES (645, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1592745960, 1592745960);
INSERT INTO `user_login_log` VALUES (646, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1592746564, 1592746564);
INSERT INTO `user_login_log` VALUES (647, '15881063321', 1, '118.113.12.212', '{\"phone\":\"15881063321\",\"code\":\"423966\"}', '登录成功', 1, 1592752599, 1592752599);
INSERT INTO `user_login_log` VALUES (648, '13917441782', 1, '36.155.117.17', '{\"phone\":\"13917441782\",\"code\":\"384853\"}', '登录成功', 1, 1592754566, 1592754566);
INSERT INTO `user_login_log` VALUES (649, '15881063321', 1, '223.104.9.241', '{\"phone\":\"15881063321\",\"code\":\"736931\"}', '登录成功', 1, 1592795276, 1592795276);
INSERT INTO `user_login_log` VALUES (650, '19980731625', 1, '118.112.196.231', '{\"phone\":\"19980731625\",\"code\":\"934815\"}', '登录成功', 1, 1592795587, 1592795587);
INSERT INTO `user_login_log` VALUES (651, '15881063321', 1, '117.172.255.20', '{\"phone\":\"15881063321\",\"code\":\"834359\"}', '登录成功', 1, 1592804919, 1592804919);
INSERT INTO `user_login_log` VALUES (652, '121530874', 1, '221.216.207.182', '{\"device_id\":\"e1b38af99c549d29\"}', '登录成功', 1, 1592810482, 1592810482);
INSERT INTO `user_login_log` VALUES (653, 'demo', 0, '180.167.105.22', '{\"username\":\"demo\"}', '登录成功', 1, 1592813169, 1592813169);
INSERT INTO `user_login_log` VALUES (654, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1592819132}', '账号或者密码错误', 0, 1592819132, 1592819132);
INSERT INTO `user_login_log` VALUES (655, '115439082', 1, '182.149.72.196', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1592829720, 1592829720);
INSERT INTO `user_login_log` VALUES (656, '15881063321', 1, '118.114.13.213', '{\"phone\":\"15881063321\",\"code\":\"168769\"}', '登录成功', 1, 1592830989, 1592830989);
INSERT INTO `user_login_log` VALUES (657, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1592832443, 1592832443);
INSERT INTO `user_login_log` VALUES (658, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1592832455, 1592832455);
INSERT INTO `user_login_log` VALUES (659, '115439082', 1, '182.149.72.196', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1592834164, 1592834164);
INSERT INTO `user_login_log` VALUES (660, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '登录成功', 1, 1592835461, 1592835461);
INSERT INTO `user_login_log` VALUES (661, '115439082', 1, '182.149.72.196', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1592836568, 1592836568);
INSERT INTO `user_login_log` VALUES (662, '115439082', 1, '182.149.72.196', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1592836651, 1592836651);
INSERT INTO `user_login_log` VALUES (663, '115439082', 1, '182.149.72.196', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1592836699, 1592836699);
INSERT INTO `user_login_log` VALUES (664, '115439082', 1, '182.149.72.196', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1592837431, 1592837431);
INSERT INTO `user_login_log` VALUES (665, '115439082', 1, '182.149.72.196', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1592837759, 1592837759);
INSERT INTO `user_login_log` VALUES (666, '115439082', 1, '182.149.72.196', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1592837881, 1592837881);
INSERT INTO `user_login_log` VALUES (667, '115439082', 1, '182.149.72.196', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1592837941, 1592837941);
INSERT INTO `user_login_log` VALUES (668, '115439082', 1, '182.149.72.196', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1592837990, 1592837990);
INSERT INTO `user_login_log` VALUES (669, '115439082', 1, '182.149.72.196', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1592838083, 1592838083);
INSERT INTO `user_login_log` VALUES (670, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1592840021, 1592840021);
INSERT INTO `user_login_log` VALUES (671, '15881063321', 1, '117.136.63.160', '{\"phone\":\"15881063321\",\"code\":\"796619\"}', '登录成功', 1, 1592875593, 1592875593);
INSERT INTO `user_login_log` VALUES (672, 'demo', 0, '180.167.105.22', '{\"username\":\"demo\"}', '登录成功', 1, 1592884730, 1592884730);
INSERT INTO `user_login_log` VALUES (673, '18600167848', 1, '221.216.207.182', '{\"phone\":\"18600167848\",\"code\":\"308737\"}', '登录成功', 1, 1592893512, 1592893512);
INSERT INTO `user_login_log` VALUES (674, '15881063321', 1, '117.136.70.53', '{\"phone\":\"15881063321\",\"code\":\"640651\"}', '登录成功', 1, 1592918887, 1592918887);
INSERT INTO `user_login_log` VALUES (675, '128451637', 1, '182.149.72.196', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1592920654, 1592920654);
INSERT INTO `user_login_log` VALUES (676, '128451637', 1, '182.149.72.196', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1592921016, 1592921016);
INSERT INTO `user_login_log` VALUES (677, '115439082', 1, '182.149.72.196', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1592922416, 1592922416);
INSERT INTO `user_login_log` VALUES (678, 'demo', 0, '183.193.116.42', '{\"username\":\"demo\"}', '登录成功', 1, 1592924625, 1592924625);
INSERT INTO `user_login_log` VALUES (679, '15881063321', 1, '118.114.13.213', '{\"phone\":\"15881063321\",\"code\":\"268500\"}', '登录成功', 1, 1592927197, 1592927197);
INSERT INTO `user_login_log` VALUES (680, '15881063321', 1, '118.114.13.213', '{\"phone\":\"15881063321\",\"code\":\"636266\"}', '登录成功', 1, 1592927336, 1592927336);
INSERT INTO `user_login_log` VALUES (681, '15881063321', 1, '118.114.13.213', '{\"phone\":\"15881063321\",\"code\":\"254748\"}', '登录成功', 1, 1592928742, 1592928742);
INSERT INTO `user_login_log` VALUES (682, '19980731625', 1, '118.112.196.231', '{\"phone\":\"19980731625\",\"code\":\"163766\"}', '登录成功', 1, 1592932073, 1592932073);
INSERT INTO `user_login_log` VALUES (683, '139526480', 1, '171.92.119.81', '{\"device_id\":\"d8933a7f280e5861\"}', '登录成功', 1, 1592974329, 1592974329);
INSERT INTO `user_login_log` VALUES (684, '115439082', 1, '182.149.73.250', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1593000748, 1593000748);
INSERT INTO `user_login_log` VALUES (685, '115439082', 1, '182.149.73.250', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1593004260, 1593004260);
INSERT INTO `user_login_log` VALUES (686, '115439082', 1, '182.149.73.250', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1593005135, 1593005135);
INSERT INTO `user_login_log` VALUES (687, '115439082', 1, '182.149.73.250', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1593006275, 1593006275);
INSERT INTO `user_login_log` VALUES (688, '115439082', 1, '182.149.73.250', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1593006895, 1593006895);
INSERT INTO `user_login_log` VALUES (689, '115439082', 1, '182.149.73.250', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1593007888, 1593007888);
INSERT INTO `user_login_log` VALUES (690, '115439082', 1, '182.149.73.250', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1593008077, 1593008077);
INSERT INTO `user_login_log` VALUES (691, '115439082', 1, '182.149.73.250', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1593008110, 1593008110);
INSERT INTO `user_login_log` VALUES (692, '115439082', 1, '182.149.73.250', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1593009251, 1593009251);
INSERT INTO `user_login_log` VALUES (693, '128451637', 1, '182.149.73.250', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593009825, 1593009825);
INSERT INTO `user_login_log` VALUES (694, 'demo', 0, '122.114.88.197', '{\"username\":\"demo\",\"timestamp\":1593010008}', '登录成功', 1, 1593010008, 1593010008);
INSERT INTO `user_login_log` VALUES (695, '128451637', 1, '182.149.73.250', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593010172, 1593010172);
INSERT INTO `user_login_log` VALUES (696, '128451637', 1, '182.149.73.250', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593010357, 1593010357);
INSERT INTO `user_login_log` VALUES (697, '128451637', 1, '182.149.73.250', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593012742, 1593012742);
INSERT INTO `user_login_log` VALUES (698, '128451637', 1, '182.149.73.250', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593013146, 1593013146);
INSERT INTO `user_login_log` VALUES (699, '128451637', 1, '182.149.73.250', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593013259, 1593013259);
INSERT INTO `user_login_log` VALUES (700, '128451637', 1, '182.149.73.250', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593013476, 1593013476);
INSERT INTO `user_login_log` VALUES (701, '128451637', 1, '182.149.73.250', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593013718, 1593013718);
INSERT INTO `user_login_log` VALUES (702, '128451637', 1, '182.149.73.250', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593014213, 1593014213);
INSERT INTO `user_login_log` VALUES (703, '128451637', 1, '182.149.73.250', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593014313, 1593014313);
INSERT INTO `user_login_log` VALUES (704, '128451637', 1, '182.149.73.250', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593014486, 1593014486);
INSERT INTO `user_login_log` VALUES (705, '128451637', 1, '182.149.73.250', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593014815, 1593014815);
INSERT INTO `user_login_log` VALUES (706, '134295087', 1, '182.149.73.250', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1593016529, 1593016529);
INSERT INTO `user_login_log` VALUES (707, '194237865', 1, '100.2.103.245', '{\"device_id\":\"dd530514d757e718\"}', '登录成功', 1, 1593029012, 1593029012);
INSERT INTO `user_login_log` VALUES (708, '194237865', 1, '100.2.103.245', '{\"device_id\":\"dd530514d757e718\"}', '登录成功', 1, 1593029067, 1593029067);
INSERT INTO `user_login_log` VALUES (709, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1593029138, 1593029138);
INSERT INTO `user_login_log` VALUES (710, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1593029198, 1593029198);
INSERT INTO `user_login_log` VALUES (711, '194237865', 1, '100.2.103.245', '{\"device_id\":\"dd530514d757e718\"}', '登录成功', 1, 1593029238, 1593029238);
INSERT INTO `user_login_log` VALUES (712, '194237865', 1, '100.2.103.245', '{\"device_id\":\"dd530514d757e718\"}', '登录成功', 1, 1593029504, 1593029504);
INSERT INTO `user_login_log` VALUES (713, '194237865', 1, '100.2.103.245', '{\"device_id\":\"dd530514d757e718\"}', '登录成功', 1, 1593029510, 1593029510);
INSERT INTO `user_login_log` VALUES (714, '194237865', 1, '100.2.103.245', '{\"device_id\":\"dd530514d757e718\"}', '登录成功', 1, 1593029574, 1593029574);
INSERT INTO `user_login_log` VALUES (715, '128451637', 1, '118.113.101.248', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593075311, 1593075311);
INSERT INTO `user_login_log` VALUES (716, 'adminkan', 0, '122.114.88.197', '{\"username\":\"adminkan\",\"timestamp\":1593139148}', '账号或者密码错误', 0, 1593139146, 1593139146);
INSERT INTO `user_login_log` VALUES (717, '15881063321', 1, '171.216.152.79', '{\"phone\":\"15881063321\",\"code\":\"570481\"}', '登录成功', 1, 1593173123, 1593173123);
INSERT INTO `user_login_log` VALUES (718, '13917441782', 1, '36.155.117.21', '{\"phone\":\"13917441782\",\"code\":\"328269\"}', '登录成功', 1, 1593237191, 1593237191);
INSERT INTO `user_login_log` VALUES (719, '19980731625', 1, '118.113.163.72', '{\"phone\":\"19980731625\",\"code\":\"768132\"}', '登录成功', 1, 1593237869, 1593237869);
INSERT INTO `user_login_log` VALUES (720, '15881063321', 1, '171.216.152.79', '{\"phone\":\"15881063321\",\"code\":\"503299\"}', '登录成功', 1, 1593238690, 1593238690);
INSERT INTO `user_login_log` VALUES (721, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1593240191, 1593240191);
INSERT INTO `user_login_log` VALUES (722, 'demo', 0, '183.193.117.177', '{\"username\":\"demo\"}', '登录成功', 1, 1593264102, 1593264102);
INSERT INTO `user_login_log` VALUES (723, 'demo', 0, '183.193.117.177', '{\"username\":\"demo\"}', '登录成功', 1, 1593273756, 1593273756);
INSERT INTO `user_login_log` VALUES (724, 'demo', 0, '183.193.117.177', '{\"username\":\"demo\"}', '登录成功', 1, 1593276785, 1593276785);
INSERT INTO `user_login_log` VALUES (725, '18280459085', 1, '171.216.152.79', '{\"phone\":\"18280459085\",\"code\":\"625601\"}', '登录成功', 1, 1593276912, 1593276912);
INSERT INTO `user_login_log` VALUES (726, '15881063321', 1, '171.216.152.79', '{\"phone\":\"15881063321\",\"code\":\"239699\"}', '登录成功', 1, 1593278797, 1593278797);
INSERT INTO `user_login_log` VALUES (727, '19980731625', 1, '118.113.163.72', '{\"phone\":\"19980731625\",\"code\":\"356527\"}', '登录成功', 1, 1593314167, 1593314167);
INSERT INTO `user_login_log` VALUES (728, '134295087', 1, '117.172.255.20', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1593338483, 1593338483);
INSERT INTO `user_login_log` VALUES (729, '15881063321', 1, '171.216.152.79', '{\"phone\":\"15881063321\",\"code\":\"877495\"}', '登录成功', 1, 1593348180, 1593348180);
INSERT INTO `user_login_log` VALUES (730, '128451637', 1, '118.113.101.248', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593352528, 1593352528);
INSERT INTO `user_login_log` VALUES (731, '128451637', 1, '118.113.101.248', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593353782, 1593353782);
INSERT INTO `user_login_log` VALUES (732, '128451637', 1, '118.113.101.248', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593354490, 1593354490);
INSERT INTO `user_login_log` VALUES (733, '128451637', 1, '118.113.101.248', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593356954, 1593356954);
INSERT INTO `user_login_log` VALUES (734, '15881063321', 1, '171.216.152.79', '{\"phone\":\"15881063321\",\"code\":\"864586\"}', '登录成功', 1, 1593360302, 1593360302);
INSERT INTO `user_login_log` VALUES (735, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '登录成功', 1, 1593385264, 1593385264);
INSERT INTO `user_login_log` VALUES (736, '1380013800', 0, '122.114.88.197', '{\"username\":\"1380013800\",\"timestamp\":1593388311}', '账号或者密码错误', 0, 1593388312, 1593388312);
INSERT INTO `user_login_log` VALUES (737, '1380013800', 0, '122.114.88.197', '{\"username\":\"1380013800\",\"timestamp\":1593388321}', '账号或者密码错误', 0, 1593388321, 1593388321);
INSERT INTO `user_login_log` VALUES (738, 'demo', 0, '180.167.105.22', '{\"username\":\"demo\"}', '登录成功', 1, 1593399188, 1593399188);
INSERT INTO `user_login_log` VALUES (739, 'admin', 0, '180.167.105.22', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1593411502, 1593411502);
INSERT INTO `user_login_log` VALUES (740, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '账号或者密码错误', 0, 1593411520, 1593411520);
INSERT INTO `user_login_log` VALUES (741, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '账号或者密码错误', 0, 1593411527, 1593411527);
INSERT INTO `user_login_log` VALUES (742, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '账号或者密码错误', 0, 1593411532, 1593411532);
INSERT INTO `user_login_log` VALUES (743, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1593411541, 1593411541);
INSERT INTO `user_login_log` VALUES (744, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1593417108, 1593417108);
INSERT INTO `user_login_log` VALUES (745, '187506492', 1, '117.172.255.20', '{\"device_id\":\"d60459915cdcab5a\"}', '登录成功', 1, 1593420712, 1593420712);
INSERT INTO `user_login_log` VALUES (746, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1593422976, 1593422976);
INSERT INTO `user_login_log` VALUES (747, '19980731625', 1, '118.113.163.72', '{\"phone\":\"19980731625\",\"code\":\"519170\"}', '登录成功', 1, 1593424036, 1593424036);
INSERT INTO `user_login_log` VALUES (748, '187506492', 1, '117.172.255.20', '{\"device_id\":\"d60459915cdcab5a\"}', '登录成功', 1, 1593424974, 1593424974);
INSERT INTO `user_login_log` VALUES (749, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1593426512, 1593426512);
INSERT INTO `user_login_log` VALUES (750, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1593426656, 1593426656);
INSERT INTO `user_login_log` VALUES (751, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1593426777, 1593426777);
INSERT INTO `user_login_log` VALUES (752, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1593426796, 1593426796);
INSERT INTO `user_login_log` VALUES (753, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1593427171, 1593427171);
INSERT INTO `user_login_log` VALUES (754, '164582709', 1, '117.172.255.20', '{\"device_id\":\"70395a92fe028077\"}', '登录成功', 1, 1593427257, 1593427257);
INSERT INTO `user_login_log` VALUES (755, '187506492', 1, '117.172.255.20', '{\"device_id\":\"d60459915cdcab5a\"}', '登录成功', 1, 1593427640, 1593427640);
INSERT INTO `user_login_log` VALUES (756, '15881063321', 1, '223.104.215.34', '{\"phone\":\"15881063321\",\"code\":\"365525\"}', '登录成功', 1, 1593440876, 1593440876);
INSERT INTO `user_login_log` VALUES (757, '128451637', 1, '182.149.72.124', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593441471, 1593441471);
INSERT INTO `user_login_log` VALUES (758, '128451637', 1, '182.149.72.124', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593442185, 1593442185);
INSERT INTO `user_login_log` VALUES (759, 'demo', 0, '183.193.117.177', '{\"username\":\"demo\"}', '登录成功', 1, 1593442668, 1593442668);
INSERT INTO `user_login_log` VALUES (760, '128451637', 1, '182.149.72.124', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593442675, 1593442675);
INSERT INTO `user_login_log` VALUES (761, 'demo', 0, '172.18.0.1', '{\"username\":\"demo\"}', '登录成功', 1, 1593442646, 1593442646);
INSERT INTO `user_login_log` VALUES (762, '128451637', 1, '182.149.72.124', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593442974, 1593442974);
INSERT INTO `user_login_log` VALUES (763, '128451637', 1, '182.149.72.124', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593443704, 1593443704);
INSERT INTO `user_login_log` VALUES (764, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '登录成功', 1, 1593479792, 1593479792);
INSERT INTO `user_login_log` VALUES (765, 'demo', 0, '180.167.105.22', '{\"username\":\"demo\"}', '登录成功', 1, 1593483761, 1593483761);
INSERT INTO `user_login_log` VALUES (766, '139526480', 1, '118.114.210.188', '{\"device_id\":\"d8933a7f280e5861\"}', '登录成功', 1, 1593486405, 1593486405);
INSERT INTO `user_login_log` VALUES (767, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '登录成功', 1, 1593493589, 1593493589);
INSERT INTO `user_login_log` VALUES (768, '18280459085', 1, '110.185.28.25', '{\"phone\":\"18280459085\",\"code\":\"477197\"}', '登录成功', 1, 1593522913, 1593522913);
INSERT INTO `user_login_log` VALUES (769, '128451637', 1, '182.149.72.124', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593525623, 1593525623);
INSERT INTO `user_login_log` VALUES (770, 'demo', 0, '183.193.117.177', '{\"username\":\"demo\"}', '登录成功', 1, 1593525670, 1593525670);
INSERT INTO `user_login_log` VALUES (771, '128451637', 1, '182.149.72.124', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593527139, 1593527139);
INSERT INTO `user_login_log` VALUES (772, '128451637', 1, '182.149.72.124', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593527257, 1593527257);
INSERT INTO `user_login_log` VALUES (773, '128451637', 1, '182.149.72.124', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593527304, 1593527304);
INSERT INTO `user_login_log` VALUES (774, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1593527369, 1593527369);
INSERT INTO `user_login_log` VALUES (775, '128451637', 1, '182.149.72.124', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593527424, 1593527424);
INSERT INTO `user_login_log` VALUES (776, '128451637', 1, '182.149.72.124', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593527443, 1593527443);
INSERT INTO `user_login_log` VALUES (777, '128451637', 1, '182.149.72.124', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593527491, 1593527491);
INSERT INTO `user_login_log` VALUES (778, '128451637', 1, '182.149.72.124', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593527963, 1593527963);
INSERT INTO `user_login_log` VALUES (779, '128451637', 1, '182.149.72.124', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593528058, 1593528058);
INSERT INTO `user_login_log` VALUES (780, '128451637', 1, '182.149.72.124', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593528129, 1593528129);
INSERT INTO `user_login_log` VALUES (781, '128451637', 1, '182.149.72.124', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593528351, 1593528351);
INSERT INTO `user_login_log` VALUES (782, '128451637', 1, '182.149.72.124', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593528433, 1593528433);
INSERT INTO `user_login_log` VALUES (783, '128451637', 1, '182.149.72.124', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593528495, 1593528495);
INSERT INTO `user_login_log` VALUES (784, '128451637', 1, '182.149.72.124', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593528518, 1593528518);
INSERT INTO `user_login_log` VALUES (785, '128451637', 1, '182.149.72.124', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593528712, 1593528712);
INSERT INTO `user_login_log` VALUES (786, '128451637', 1, '182.149.72.124', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593528724, 1593528724);
INSERT INTO `user_login_log` VALUES (787, '128451637', 1, '182.149.72.124', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593528770, 1593528770);
INSERT INTO `user_login_log` VALUES (788, '128451637', 1, '182.149.72.124', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593528799, 1593528799);
INSERT INTO `user_login_log` VALUES (789, '128451637', 1, '182.149.72.124', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593528917, 1593528917);
INSERT INTO `user_login_log` VALUES (790, '128451637', 1, '182.149.72.124', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593529056, 1593529056);
INSERT INTO `user_login_log` VALUES (791, '128451637', 1, '182.149.72.124', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593529496, 1593529496);
INSERT INTO `user_login_log` VALUES (792, '128451637', 1, '182.149.72.124', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593529629, 1593529629);
INSERT INTO `user_login_log` VALUES (793, '115439082', 1, '182.149.72.124', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1593531324, 1593531324);
INSERT INTO `user_login_log` VALUES (794, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '登录成功', 1, 1593531539, 1593531539);
INSERT INTO `user_login_log` VALUES (795, '115439082', 1, '182.149.72.124', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1593532146, 1593532146);
INSERT INTO `user_login_log` VALUES (796, '115439082', 1, '182.149.72.124', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1593532273, 1593532273);
INSERT INTO `user_login_log` VALUES (797, '115439082', 1, '182.149.72.124', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1593532432, 1593532432);
INSERT INTO `user_login_log` VALUES (798, '115439082', 1, '182.149.72.124', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1593532665, 1593532665);
INSERT INTO `user_login_log` VALUES (799, '115439082', 1, '182.149.72.124', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1593532712, 1593532712);
INSERT INTO `user_login_log` VALUES (800, '115439082', 1, '182.149.72.124', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1593532798, 1593532798);
INSERT INTO `user_login_log` VALUES (801, '115439082', 1, '182.149.72.124', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1593533261, 1593533261);
INSERT INTO `user_login_log` VALUES (802, '115439082', 1, '182.149.72.124', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1593533301, 1593533301);
INSERT INTO `user_login_log` VALUES (803, '115439082', 1, '182.149.72.124', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1593533380, 1593533380);
INSERT INTO `user_login_log` VALUES (804, '115439082', 1, '182.149.72.124', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1593533394, 1593533394);
INSERT INTO `user_login_log` VALUES (805, '115439082', 1, '182.149.72.124', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1593533442, 1593533442);
INSERT INTO `user_login_log` VALUES (806, '115439082', 1, '182.149.72.124', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1593533529, 1593533529);
INSERT INTO `user_login_log` VALUES (807, '134295087', 1, '182.149.72.124', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1593533663, 1593533663);
INSERT INTO `user_login_log` VALUES (808, '115439082', 1, '182.149.72.124', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1593533902, 1593533902);
INSERT INTO `user_login_log` VALUES (809, '115439082', 1, '182.149.72.124', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1593534194, 1593534194);
INSERT INTO `user_login_log` VALUES (810, '115439082', 1, '182.149.72.124', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1593535028, 1593535028);
INSERT INTO `user_login_log` VALUES (811, '134295087', 1, '182.149.72.124', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1593535159, 1593535159);
INSERT INTO `user_login_log` VALUES (812, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1593575105}', '账号或者密码错误', 0, 1593575104, 1593575104);
INSERT INTO `user_login_log` VALUES (813, '15881063321', 1, '118.114.14.150', '{\"phone\":\"15881063321\",\"code\":\"303715\"}', '登录成功', 1, 1593609820, 1593609820);
INSERT INTO `user_login_log` VALUES (814, 'demo', 0, '172.18.0.1', '{\"username\":\"demo\"}', '登录成功', 1, 1593614694, 1593614694);
INSERT INTO `user_login_log` VALUES (815, '19980731625', 1, '171.210.254.186', '{\"phone\":\"19980731625\",\"code\":\"144905\"}', '登录成功', 1, 1593616214, 1593616214);
INSERT INTO `user_login_log` VALUES (816, 'demo', 0, '183.193.117.177', '{\"username\":\"demo\"}', '登录成功', 1, 1593616290, 1593616290);
INSERT INTO `user_login_log` VALUES (817, 'demo', 0, '183.193.117.177', '{\"username\":\"demo\"}', '登录成功', 1, 1593616477, 1593616477);
INSERT INTO `user_login_log` VALUES (818, '194237865', 1, '100.2.103.245', '{\"device_id\":\"dd530514d757e718\"}', '登录成功', 1, 1593650126, 1593650126);
INSERT INTO `user_login_log` VALUES (819, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1593650258, 1593650258);
INSERT INTO `user_login_log` VALUES (820, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1593650261, 1593650261);
INSERT INTO `user_login_log` VALUES (821, '194237865', 1, '100.2.103.245', '{\"device_id\":\"dd530514d757e718\"}', '登录成功', 1, 1593650370, 1593650370);
INSERT INTO `user_login_log` VALUES (822, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1593667970}', '账号或者密码错误', 0, 1593667982, 1593667982);
INSERT INTO `user_login_log` VALUES (823, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1593667978}', '账号或者密码错误', 0, 1593667985, 1593667985);
INSERT INTO `user_login_log` VALUES (824, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1593667991}', '账号或者密码错误', 0, 1593668004, 1593668004);
INSERT INTO `user_login_log` VALUES (825, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1593667975}', '账号或者密码错误', 0, 1593668007, 1593668007);
INSERT INTO `user_login_log` VALUES (826, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1593668042}', '账号或者密码错误', 0, 1593668048, 1593668048);
INSERT INTO `user_login_log` VALUES (827, '19980731625', 1, '110.184.12.20', '{\"phone\":\"19980731625\",\"code\":\"783192\"}', '登录成功', 1, 1593673155, 1593673155);
INSERT INTO `user_login_log` VALUES (828, '139526480', 1, '110.184.12.20', '{\"device_id\":\"d8933a7f280e5861\"}', '登录成功', 1, 1593673750, 1593673750);
INSERT INTO `user_login_log` VALUES (829, '139526480', 1, '110.184.12.20', '{\"device_id\":\"d8933a7f280e5861\"}', '登录成功', 1, 1593673773, 1593673773);
INSERT INTO `user_login_log` VALUES (830, '139526480', 1, '110.184.12.20', '{\"device_id\":\"d8933a7f280e5861\"}', '登录成功', 1, 1593673839, 1593673839);
INSERT INTO `user_login_log` VALUES (831, '139526480', 1, '110.184.12.20', '{\"device_id\":\"d8933a7f280e5861\"}', '登录成功', 1, 1593673851, 1593673851);
INSERT INTO `user_login_log` VALUES (832, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '登录成功', 1, 1593675042, 1593675042);
INSERT INTO `user_login_log` VALUES (833, 'kiro', 0, '103.224.82.246', '{\"username\":\"kiro\"}', '账号或者密码错误', 0, 1593675072, 1593675072);
INSERT INTO `user_login_log` VALUES (834, 'kiro', 0, '103.224.82.246', '{\"username\":\"kiro\"}', '登录成功', 1, 1593675078, 1593675078);
INSERT INTO `user_login_log` VALUES (835, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '登录成功', 1, 1593678065, 1593678065);
INSERT INTO `user_login_log` VALUES (836, '13917441782', 1, '36.155.117.9', '{\"phone\":\"13917441782\",\"code\":\"191648\"}', '登录成功', 1, 1593689551, 1593689551);
INSERT INTO `user_login_log` VALUES (837, '187506492', 1, '117.172.255.20', '{\"device_id\":\"d60459915cdcab5a\"}', '登录成功', 1, 1593690265, 1593690265);
INSERT INTO `user_login_log` VALUES (838, '128451637', 1, '182.149.72.124', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593700229, 1593700229);
INSERT INTO `user_login_log` VALUES (839, '15881063321', 1, '118.114.14.150', '{\"phone\":\"15881063321\",\"code\":\"186098\"}', '登录成功', 1, 1593701225, 1593701225);
INSERT INTO `user_login_log` VALUES (840, '128451637', 1, '182.149.72.124', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593702788, 1593702788);
INSERT INTO `user_login_log` VALUES (841, '128451637', 1, '182.149.72.124', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593703920, 1593703920);
INSERT INTO `user_login_log` VALUES (842, '128451637', 1, '182.149.72.124', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593704270, 1593704270);
INSERT INTO `user_login_log` VALUES (843, '128451637', 1, '182.149.72.124', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593704691, 1593704691);
INSERT INTO `user_login_log` VALUES (844, '194237865', 1, '100.2.103.245', '{\"device_id\":\"dd530514d757e718\"}', '登录成功', 1, 1593706505, 1593706505);
INSERT INTO `user_login_log` VALUES (845, '139526480', 1, '110.184.12.20', '{\"device_id\":\"d8933a7f280e5861\"}', '登录成功', 1, 1593706886, 1593706886);
INSERT INTO `user_login_log` VALUES (846, '146931728', 1, '223.104.63.164', '{\"device_id\":\"9e4a508febb6d347\"}', '登录成功', 1, 1593755278, 1593755278);
INSERT INTO `user_login_log` VALUES (847, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1593759078}', '账号或者密码错误', 0, 1593759082, 1593759082);
INSERT INTO `user_login_log` VALUES (848, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1593821100, 1593821100);
INSERT INTO `user_login_log` VALUES (849, '19980731625', 1, '110.184.12.20', '{\"phone\":\"19980731625\",\"code\":\"775369\"}', '登录成功', 1, 1593831946, 1593831946);
INSERT INTO `user_login_log` VALUES (850, '15881063321', 1, '117.136.63.143', '{\"phone\":\"15881063321\",\"code\":\"134415\"}', '登录成功', 1, 1593836035, 1593836035);
INSERT INTO `user_login_log` VALUES (851, '15840760112', 0, '122.114.88.197', '{\"username\":\"15840760112\",\"timestamp\":1593846377}', '账号或者密码错误', 0, 1593846379, 1593846379);
INSERT INTO `user_login_log` VALUES (852, '15840760112', 0, '122.114.88.197', '{\"username\":\"15840760112\",\"timestamp\":1593846379}', '账号或者密码错误', 0, 1593846381, 1593846381);
INSERT INTO `user_login_log` VALUES (853, '15840760112', 0, '122.114.88.197', '{\"username\":\"15840760112\",\"timestamp\":1593846387}', '账号或者密码错误', 0, 1593846389, 1593846389);
INSERT INTO `user_login_log` VALUES (854, '139526480', 1, '110.184.12.20', '{\"device_id\":\"d8933a7f280e5861\"}', '登录成功', 1, 1593869101, 1593869101);
INSERT INTO `user_login_log` VALUES (855, '15881063321', 1, '118.114.14.136', '{\"phone\":\"15881063321\",\"code\":\"244582\"}', '登录成功', 1, 1593915249, 1593915249);
INSERT INTO `user_login_log` VALUES (856, '134295087', 1, '182.149.72.124', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1593930777, 1593930777);
INSERT INTO `user_login_log` VALUES (857, '15881063321', 1, '118.114.14.136', '{\"phone\":\"15881063321\",\"code\":\"175723\"}', '登录成功', 1, 1593951493, 1593951493);
INSERT INTO `user_login_log` VALUES (858, '128451637', 1, '182.149.78.190', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1593955013, 1593955013);
INSERT INTO `user_login_log` VALUES (859, 'demo', 0, '183.193.117.177', '{\"username\":\"demo\"}', '登录成功', 1, 1593959928, 1593959928);
INSERT INTO `user_login_log` VALUES (860, 'demo', 0, '172.18.0.1', '{\"username\":\"demo\"}', '登录成功', 1, 1593959903, 1593959903);
INSERT INTO `user_login_log` VALUES (861, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '登录成功', 1, 1593961363, 1593961363);
INSERT INTO `user_login_log` VALUES (862, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '登录成功', 1, 1593961364, 1593961364);
INSERT INTO `user_login_log` VALUES (863, '18280459085', 1, '118.114.14.136', '{\"phone\":\"18280459085\",\"code\":\"993976\"}', '登录成功', 1, 1593963031, 1593963031);
INSERT INTO `user_login_log` VALUES (864, 'demo', 0, '122.114.88.197', '{\"username\":\"demo\",\"timestamp\":1593963910}', '登录成功', 1, 1593963912, 1593963912);
INSERT INTO `user_login_log` VALUES (865, '1380013800', 0, '122.114.88.197', '{\"username\":\"1380013800\",\"timestamp\":1593967449}', '账号或者密码错误', 0, 1593967451, 1593967451);
INSERT INTO `user_login_log` VALUES (866, '138000138000', 0, '122.114.88.197', '{\"username\":\"138000138000\",\"timestamp\":1593967490}', '账号或者密码错误', 0, 1593967492, 1593967492);
INSERT INTO `user_login_log` VALUES (867, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1593967544}', '账号或者密码错误', 0, 1593967546, 1593967546);
INSERT INTO `user_login_log` VALUES (868, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1593967573}', '账号或者密码错误', 0, 1593967575, 1593967575);
INSERT INTO `user_login_log` VALUES (869, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1593967612}', '账号或者密码错误', 0, 1593967614, 1593967614);
INSERT INTO `user_login_log` VALUES (870, '19980731625', 1, '110.184.12.20', '{\"phone\":\"19980731625\",\"code\":\"378226\"}', '登录成功', 1, 1594020935, 1594020935);
INSERT INTO `user_login_log` VALUES (871, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1594024455, 1594024455);
INSERT INTO `user_login_log` VALUES (872, '15881063321', 1, '171.216.153.4', '{\"phone\":\"15881063321\",\"code\":\"672218\"}', '登录成功', 1, 1594046770, 1594046770);
INSERT INTO `user_login_log` VALUES (873, '1380013800', 0, '122.114.88.197', '{\"username\":\"1380013800\",\"timestamp\":1594048287}', '账号或者密码错误', 0, 1594048288, 1594048288);
INSERT INTO `user_login_log` VALUES (874, '1380013800', 0, '122.114.88.197', '{\"username\":\"1380013800\",\"timestamp\":1594048298}', '账号或者密码错误', 0, 1594048299, 1594048299);
INSERT INTO `user_login_log` VALUES (875, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1594048448}', '账号或者密码错误', 0, 1594048448, 1594048448);
INSERT INTO `user_login_log` VALUES (876, '128451637', 1, '117.172.255.20', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1594088456, 1594088456);
INSERT INTO `user_login_log` VALUES (877, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1594090143, 1594090143);
INSERT INTO `user_login_log` VALUES (878, '18656687900', 0, '122.114.88.197', '{\"username\":\"18656687900\",\"timestamp\":1594091527}', '账号或者密码错误', 0, 1594091595, 1594091595);
INSERT INTO `user_login_log` VALUES (879, '18656687900', 0, '122.114.88.197', '{\"username\":\"18656687900\",\"timestamp\":1594091606}', '账号或者密码错误', 0, 1594091674, 1594091674);
INSERT INTO `user_login_log` VALUES (880, '15881063321', 1, '117.172.255.20', '{\"phone\":\"15881063321\",\"code\":\"328389\"}', '登录成功', 1, 1594116353, 1594116353);
INSERT INTO `user_login_log` VALUES (881, '134295087', 1, '182.149.78.190', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1594133179, 1594133179);
INSERT INTO `user_login_log` VALUES (882, '13343080314', 1, '183.199.23.99', '{\"phone\":\"13343080314\",\"code\":\"116001\"}', '登录成功', 1, 1594181158, 1594181158);
INSERT INTO `user_login_log` VALUES (883, '13708021643', 0, '39.109.7.74', '{\"username\":\"13708021643\",\"timestamp\":1594186450}', '登录成功', 1, 1594186345, 1594186345);
INSERT INTO `user_login_log` VALUES (884, '13708021643', 0, '39.109.7.74', '{\"username\":\"13708021643\",\"timestamp\":1594199996}', '登录成功', 1, 1594199890, 1594199890);
INSERT INTO `user_login_log` VALUES (885, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1594225340}', '账号或者密码错误', 0, 1594225340, 1594225340);
INSERT INTO `user_login_log` VALUES (886, 'kiro', 0, '103.224.82.246', '{\"username\":\"kiro\"}', '登录成功', 1, 1594281094, 1594281094);
INSERT INTO `user_login_log` VALUES (887, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1594289261}', '账号或者密码错误', 0, 1594289278, 1594289278);
INSERT INTO `user_login_log` VALUES (888, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1594289265}', '账号或者密码错误', 0, 1594289282, 1594289282);
INSERT INTO `user_login_log` VALUES (889, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1594289297}', '账号或者密码错误', 0, 1594289314, 1594289314);
INSERT INTO `user_login_log` VALUES (890, '2910005060@qq.com', 0, '122.114.88.197', '{\"username\":\"2910005060@qq.com\",\"timestamp\":1594294440}', '登录成功', 1, 1594294440, 1594294440);
INSERT INTO `user_login_log` VALUES (891, '128451637', 1, '182.149.78.190', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1594299936, 1594299936);
INSERT INTO `user_login_log` VALUES (892, '128451637', 1, '182.149.78.190', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1594301743, 1594301743);
INSERT INTO `user_login_log` VALUES (893, '128451637', 1, '182.149.78.190', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1594301787, 1594301787);
INSERT INTO `user_login_log` VALUES (894, '128451637', 1, '182.149.78.190', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1594302191, 1594302191);
INSERT INTO `user_login_log` VALUES (895, '128451637', 1, '182.149.78.190', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1594303058, 1594303058);
INSERT INTO `user_login_log` VALUES (896, '128451637', 1, '182.149.78.190', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1594303143, 1594303143);
INSERT INTO `user_login_log` VALUES (897, '128451637', 1, '182.149.78.190', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1594303179, 1594303179);
INSERT INTO `user_login_log` VALUES (898, '128451637', 1, '182.149.78.190', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1594303201, 1594303201);
INSERT INTO `user_login_log` VALUES (899, '128451637', 1, '182.149.78.190', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1594303249, 1594303249);
INSERT INTO `user_login_log` VALUES (900, '128451637', 1, '182.149.78.190', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1594303256, 1594303256);
INSERT INTO `user_login_log` VALUES (901, '128451637', 1, '182.149.78.190', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1594303305, 1594303305);
INSERT INTO `user_login_log` VALUES (902, '128451637', 1, '182.149.78.190', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1594303419, 1594303419);
INSERT INTO `user_login_log` VALUES (903, '128451637', 1, '182.149.78.190', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1594303452, 1594303452);
INSERT INTO `user_login_log` VALUES (904, '128451637', 1, '182.149.78.190', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1594303575, 1594303575);
INSERT INTO `user_login_log` VALUES (905, '128451637', 1, '182.149.78.190', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1594303674, 1594303674);
INSERT INTO `user_login_log` VALUES (906, '128451637', 1, '182.149.78.190', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1594303971, 1594303971);
INSERT INTO `user_login_log` VALUES (907, '128451637', 1, '182.149.78.190', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1594304145, 1594304145);
INSERT INTO `user_login_log` VALUES (908, '128451637', 1, '182.149.78.190', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1594304296, 1594304296);
INSERT INTO `user_login_log` VALUES (909, '128451637', 1, '182.149.78.190', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1594304637, 1594304637);
INSERT INTO `user_login_log` VALUES (910, '134295087', 1, '182.149.78.190', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1594304886, 1594304886);
INSERT INTO `user_login_log` VALUES (911, '134295087', 1, '182.149.78.190', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1594304968, 1594304968);
INSERT INTO `user_login_log` VALUES (912, '134295087', 1, '182.149.78.190', '{\"device_id\":\"6c01d8180fe08af8\"}', '登录成功', 1, 1594304981, 1594304981);
INSERT INTO `user_login_log` VALUES (913, '115439082', 1, '182.149.78.190', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1594305121, 1594305121);
INSERT INTO `user_login_log` VALUES (914, '115439082', 1, '182.149.78.190', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1594305174, 1594305174);
INSERT INTO `user_login_log` VALUES (915, '115439082', 1, '182.149.78.190', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1594305282, 1594305282);
INSERT INTO `user_login_log` VALUES (916, '115439082', 1, '182.149.78.190', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1594305419, 1594305419);
INSERT INTO `user_login_log` VALUES (917, '115439082', 1, '182.149.78.190', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1594305610, 1594305610);
INSERT INTO `user_login_log` VALUES (918, '115439082', 1, '182.149.78.190', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1594305638, 1594305638);
INSERT INTO `user_login_log` VALUES (919, '115439082', 1, '182.149.78.190', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1594305648, 1594305648);
INSERT INTO `user_login_log` VALUES (920, '115439082', 1, '182.149.78.190', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1594305695, 1594305695);
INSERT INTO `user_login_log` VALUES (921, '115439082', 1, '182.149.78.190', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1594305823, 1594305823);
INSERT INTO `user_login_log` VALUES (922, '115439082', 1, '182.149.78.190', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1594305831, 1594305831);
INSERT INTO `user_login_log` VALUES (923, '115439082', 1, '182.149.78.190', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1594306451, 1594306451);
INSERT INTO `user_login_log` VALUES (924, '115439082', 1, '182.149.78.190', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1594306479, 1594306479);
INSERT INTO `user_login_log` VALUES (925, '115439082', 1, '182.149.78.190', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1594306693, 1594306693);
INSERT INTO `user_login_log` VALUES (926, '115439082', 1, '182.149.78.190', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1594306722, 1594306722);
INSERT INTO `user_login_log` VALUES (927, '115439082', 1, '182.149.78.190', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1594306759, 1594306759);
INSERT INTO `user_login_log` VALUES (928, '115439082', 1, '182.149.78.190', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1594306792, 1594306792);
INSERT INTO `user_login_log` VALUES (929, '115439082', 1, '182.149.78.190', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1594306816, 1594306816);
INSERT INTO `user_login_log` VALUES (930, '115439082', 1, '182.149.78.190', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1594306820, 1594306820);
INSERT INTO `user_login_log` VALUES (931, '115439082', 1, '182.149.78.190', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1594306870, 1594306870);
INSERT INTO `user_login_log` VALUES (932, '115439082', 1, '182.149.78.190', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1594306895, 1594306895);
INSERT INTO `user_login_log` VALUES (933, '115439082', 1, '182.149.78.190', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1594306983, 1594306983);
INSERT INTO `user_login_log` VALUES (934, '115439082', 1, '182.149.78.190', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1594306997, 1594306997);
INSERT INTO `user_login_log` VALUES (935, '115439082', 1, '182.149.78.190', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1594308451, 1594308451);
INSERT INTO `user_login_log` VALUES (936, '115439082', 1, '182.149.78.190', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1594308762, 1594308762);
INSERT INTO `user_login_log` VALUES (937, '115439082', 1, '182.149.78.190', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1594308795, 1594308795);
INSERT INTO `user_login_log` VALUES (938, '115439082', 1, '182.149.78.190', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1594308890, 1594308890);
INSERT INTO `user_login_log` VALUES (939, '115439082', 1, '182.149.78.190', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1594309618, 1594309618);
INSERT INTO `user_login_log` VALUES (940, '115439082', 1, '182.149.78.190', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1594309680, 1594309680);
INSERT INTO `user_login_log` VALUES (941, '115439082', 1, '182.149.78.190', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1594309813, 1594309813);
INSERT INTO `user_login_log` VALUES (942, '115439082', 1, '182.149.78.190', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1594310032, 1594310032);
INSERT INTO `user_login_log` VALUES (943, '115439082', 1, '182.149.78.190', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1594310221, 1594310221);
INSERT INTO `user_login_log` VALUES (944, '115439082', 1, '182.149.78.190', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1594313858, 1594313858);
INSERT INTO `user_login_log` VALUES (945, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '登录成功', 1, 1594380424, 1594380424);
INSERT INTO `user_login_log` VALUES (946, '134761820', 1, '106.19.102.69', '{\"device_id\":\"3c7c0ba5d8e8489f\"}', '登录成功', 1, 1594385074, 1594385074);
INSERT INTO `user_login_log` VALUES (947, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1594386667, 1594386667);
INSERT INTO `user_login_log` VALUES (948, 'demo', 0, '122.114.88.197', '{\"username\":\"demo\",\"timestamp\":1594451601}', '登录成功', 1, 1594451602, 1594451602);
INSERT INTO `user_login_log` VALUES (949, '184195670', 1, '58.64.152.87', '{\"device_id\":\"a20ce740b15ab477\"}', '登录成功', 1, 1594475420, 1594475420);
INSERT INTO `user_login_log` VALUES (950, '112233@qq.com', 0, '122.114.88.197', '{\"username\":\"112233@qq.com\",\"timestamp\":1594479949}', '登录成功', 1, 1594479951, 1594479951);
INSERT INTO `user_login_log` VALUES (951, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1594497329, 1594497329);
INSERT INTO `user_login_log` VALUES (952, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1594553497}', '账号或者密码错误', 0, 1594553497, 1594553497);
INSERT INTO `user_login_log` VALUES (953, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1594553519}', '账号或者密码错误', 0, 1594553519, 1594553519);
INSERT INTO `user_login_log` VALUES (954, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '登录成功', 1, 1594583541, 1594583541);
INSERT INTO `user_login_log` VALUES (955, '13708021643', 0, '122.114.88.197', '{\"username\":\"13708021643\",\"timestamp\":1594606188}', '登录成功', 1, 1594606189, 1594606189);
INSERT INTO `user_login_log` VALUES (956, '13708021643', 0, '39.109.7.74', '{\"username\":\"13708021643\",\"timestamp\":1594606723}', '登录成功', 1, 1594606606, 1594606606);
INSERT INTO `user_login_log` VALUES (957, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1594607680}', '账号或者密码错误', 0, 1594607678, 1594607678);
INSERT INTO `user_login_log` VALUES (958, '140983715', 1, '183.39.62.104', '{\"device_id\":\"1f65972f0282661b\"}', '登录成功', 1, 1594631941, 1594631941);
INSERT INTO `user_login_log` VALUES (959, '13708021643', 0, '39.109.7.74', '{\"username\":\"13708021643\",\"timestamp\":1594643771}', '登录成功', 1, 1594643653, 1594643653);
INSERT INTO `user_login_log` VALUES (960, '18582887369', 0, '122.114.88.197', '{\"username\":\"18582887369\",\"timestamp\":1594644486}', '账号或者密码错误', 0, 1594644487, 1594644487);
INSERT INTO `user_login_log` VALUES (961, '15993881199', 0, '122.114.88.197', '{\"username\":\"15993881199\",\"timestamp\":1594652067}', '账号或者密码错误', 0, 1594652067, 1594652067);
INSERT INTO `user_login_log` VALUES (962, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1594718380, 1594718380);
INSERT INTO `user_login_log` VALUES (963, '172539068', 1, '171.223.172.92', '{\"device_id\":\"8e728a3803b5e9f9\"}', '登录成功', 1, 1594786180, 1594786180);
INSERT INTO `user_login_log` VALUES (964, 'ganhgd@163.com', 0, '122.114.88.197', '{\"username\":\"ganhgd@163.com\",\"timestamp\":1594829940}', '账号或者密码错误', 0, 1594829940, 1594829940);
INSERT INTO `user_login_log` VALUES (965, '1380013800', 0, '122.114.88.197', '{\"username\":\"1380013800\",\"timestamp\":1594881974}', '账号或者密码错误', 0, 1594881974, 1594881974);
INSERT INTO `user_login_log` VALUES (966, '1380013800', 0, '122.114.88.197', '{\"username\":\"1380013800\",\"timestamp\":1594882001}', '账号或者密码错误', 0, 1594882001, 1594882001);
INSERT INTO `user_login_log` VALUES (967, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1594882013}', '账号或者密码错误', 0, 1594882013, 1594882013);
INSERT INTO `user_login_log` VALUES (968, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1594882014}', '账号或者密码错误', 0, 1594882015, 1594882015);
INSERT INTO `user_login_log` VALUES (969, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1594882020}', '账号或者密码错误', 0, 1594882021, 1594882021);
INSERT INTO `user_login_log` VALUES (970, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1594882166}', '账号或者密码错误', 0, 1594882167, 1594882167);
INSERT INTO `user_login_log` VALUES (971, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1594882168}', '账号或者密码错误', 0, 1594882168, 1594882168);
INSERT INTO `user_login_log` VALUES (972, '1380013800', 0, '122.114.88.197', '{\"username\":\"1380013800\",\"timestamp\":1594951188}', '账号或者密码错误', 0, 1594951189, 1594951189);
INSERT INTO `user_login_log` VALUES (973, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1594951194}', '账号或者密码错误', 0, 1594951195, 1594951195);
INSERT INTO `user_login_log` VALUES (974, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1594951207}', '账号或者密码错误', 0, 1594951208, 1594951208);
INSERT INTO `user_login_log` VALUES (975, 'bigniu', 0, '122.114.88.197', '{\"username\":\"bigniu\",\"timestamp\":1594951274}', '账号或者密码错误', 0, 1594951275, 1594951275);
INSERT INTO `user_login_log` VALUES (976, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1594951284}', '账号或者密码错误', 0, 1594951285, 1594951285);
INSERT INTO `user_login_log` VALUES (977, 'demo', 0, '172.18.0.1', '{\"username\":\"demo\"}', '登录成功', 1, 1595043227, 1595043227);
INSERT INTO `user_login_log` VALUES (978, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '登录成功', 1, 1595068532, 1595068532);
INSERT INTO `user_login_log` VALUES (979, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1595070731, 1595070731);
INSERT INTO `user_login_log` VALUES (980, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1595070763, 1595070763);
INSERT INTO `user_login_log` VALUES (981, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1595070808, 1595070808);
INSERT INTO `user_login_log` VALUES (982, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1595070967, 1595070967);
INSERT INTO `user_login_log` VALUES (983, '115439082', 1, '118.113.103.87', '{\"device_id\":\"383d0fbd78fed5f0\"}', '登录成功', 1, 1595168277, 1595168277);
INSERT INTO `user_login_log` VALUES (984, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1595203054}', '账号或者密码错误', 0, 1595203055, 1595203055);
INSERT INTO `user_login_log` VALUES (985, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1595203110}', '账号或者密码错误', 0, 1595203111, 1595203111);
INSERT INTO `user_login_log` VALUES (986, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1595207392, 1595207392);
INSERT INTO `user_login_log` VALUES (987, '19834191160', 0, '122.114.88.197', '{\"username\":\"19834191160\",\"timestamp\":1595233427}', '账号或者密码错误', 0, 1595233427, 1595233427);
INSERT INTO `user_login_log` VALUES (988, '19834191160', 0, '122.114.88.197', '{\"username\":\"19834191160\",\"timestamp\":1595233429}', '账号或者密码错误', 0, 1595233429, 1595233429);
INSERT INTO `user_login_log` VALUES (989, '19834191160', 0, '122.114.88.197', '{\"username\":\"19834191160\",\"timestamp\":1595233430}', '账号或者密码错误', 0, 1595233430, 1595233430);
INSERT INTO `user_login_log` VALUES (990, '19834191160', 0, '122.114.88.197', '{\"username\":\"19834191160\",\"timestamp\":1595233438}', '账号或者密码错误', 0, 1595233438, 1595233438);
INSERT INTO `user_login_log` VALUES (991, '19834191160', 0, '122.114.88.197', '{\"username\":\"19834191160\",\"timestamp\":1595233491}', '账号或者密码错误', 0, 1595233491, 1595233491);
INSERT INTO `user_login_log` VALUES (992, '19834191160', 0, '122.114.88.197', '{\"username\":\"19834191160\",\"timestamp\":1595233493}', '账号或者密码错误', 0, 1595233493, 1595233493);
INSERT INTO `user_login_log` VALUES (993, '19834191160', 0, '122.114.88.197', '{\"username\":\"19834191160\",\"timestamp\":1595233500}', '账号或者密码错误', 0, 1595233500, 1595233500);
INSERT INTO `user_login_log` VALUES (994, '19834191160', 0, '122.114.88.197', '{\"username\":\"19834191160\",\"timestamp\":1595233509}', '账号或者密码错误', 0, 1595233509, 1595233509);
INSERT INTO `user_login_log` VALUES (995, '19834191160', 0, '122.114.88.197', '{\"username\":\"19834191160\",\"timestamp\":1595233510}', '账号或者密码错误', 0, 1595233510, 1595233510);
INSERT INTO `user_login_log` VALUES (996, '19834191160', 0, '122.114.88.197', '{\"username\":\"19834191160\",\"timestamp\":1595233511}', '账号或者密码错误', 0, 1595233511, 1595233511);
INSERT INTO `user_login_log` VALUES (997, '15882478524', 1, '117.172.255.20', '{\"phone\":\"15882478524\",\"code\":\"224764\"}', '登录成功', 1, 1595237340, 1595237340);
INSERT INTO `user_login_log` VALUES (998, '128451637', 1, '118.113.103.87', '{\"device_id\":\"65F69581-6431-4EAC-8A2A-CAA4EA800913\"}', '登录成功', 1, 1595347206, 1595347206);
INSERT INTO `user_login_log` VALUES (999, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '登录成功', 1, 1595382934, 1595382934);
INSERT INTO `user_login_log` VALUES (1000, '168195473', 1, '42.240.141.31', '{\"device_id\":\"4766f5cf012efd25\"}', '登录成功', 1, 1595542954, 1595542954);
INSERT INTO `user_login_log` VALUES (1001, '154806931', 1, '183.193.141.109', '{\"device_id\":\"58137b319caaf561\"}', '登录成功', 1, 1595550156, 1595550156);
INSERT INTO `user_login_log` VALUES (1002, '154806931', 1, '183.193.141.109', '{\"device_id\":\"58137b319caaf561\"}', '登录成功', 1, 1595550189, 1595550189);
INSERT INTO `user_login_log` VALUES (1003, '154806931', 1, '183.193.141.109', '{\"device_id\":\"58137b319caaf561\"}', '登录成功', 1, 1595550244, 1595550244);
INSERT INTO `user_login_log` VALUES (1004, 'musicity@163.com', 0, '122.114.88.197', '{\"username\":\"musicity@163.com\",\"timestamp\":1595562148}', '登录成功', 1, 1595562150, 1595562150);
INSERT INTO `user_login_log` VALUES (1005, 'musicity@163.com', 0, '122.114.88.197', '{\"username\":\"musicity@163.com\",\"timestamp\":1595562151}', '登录成功', 1, 1595562151, 1595562151);
INSERT INTO `user_login_log` VALUES (1006, 'musicity@163.com', 0, '122.114.88.197', '{\"username\":\"musicity@163.com\",\"timestamp\":1595562149}', '登录成功', 1, 1595562152, 1595562152);
INSERT INTO `user_login_log` VALUES (1007, 'musicity@163.com', 0, '122.114.88.197', '{\"username\":\"musicity@163.com\",\"timestamp\":1595562150}', '登录成功', 1, 1595562152, 1595562152);
INSERT INTO `user_login_log` VALUES (1008, 'musicity@163.com', 0, '122.114.88.197', '{\"username\":\"musicity@163.com\",\"timestamp\":1595562151}', '登录成功', 1, 1595562152, 1595562152);
INSERT INTO `user_login_log` VALUES (1009, 'musicity@163.com', 0, '122.114.88.197', '{\"username\":\"musicity@163.com\",\"timestamp\":1595562152}', '登录成功', 1, 1595562153, 1595562153);
INSERT INTO `user_login_log` VALUES (1010, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1595737040, 1595737040);
INSERT INTO `user_login_log` VALUES (1011, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1595831063}', '账号或者密码错误', 0, 1595831063, 1595831063);
INSERT INTO `user_login_log` VALUES (1012, '1380013800', 0, '122.114.88.197', '{\"username\":\"1380013800\",\"timestamp\":1595924667}', '账号或者密码错误', 0, 1595924667, 1595924667);
INSERT INTO `user_login_log` VALUES (1013, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1595924681}', '账号或者密码错误', 0, 1595924680, 1595924680);
INSERT INTO `user_login_log` VALUES (1014, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1595924700}', '账号或者密码错误', 0, 1595924700, 1595924700);
INSERT INTO `user_login_log` VALUES (1015, '228590184@qq.com', 0, '122.114.88.197', '{\"username\":\"228590184@qq.com\",\"timestamp\":1595924755}', '登录成功', 1, 1595924755, 1595924755);
INSERT INTO `user_login_log` VALUES (1016, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1595935173, 1595935173);
INSERT INTO `user_login_log` VALUES (1017, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1595945424}', '账号或者密码错误', 0, 1595945425, 1595945425);
INSERT INTO `user_login_log` VALUES (1018, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1595945426}', '账号或者密码错误', 0, 1595945427, 1595945427);
INSERT INTO `user_login_log` VALUES (1019, '123454@qq.com', 0, '122.114.88.197', '{\"username\":\"123454@qq.com\",\"timestamp\":1596006998}', '登录成功', 1, 1596007169, 1596007169);
INSERT INTO `user_login_log` VALUES (1020, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1596019446}', '账号或者密码错误', 0, 1596019444, 1596019444);
INSERT INTO `user_login_log` VALUES (1021, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1596019456}', '账号或者密码错误', 0, 1596019454, 1596019454);
INSERT INTO `user_login_log` VALUES (1022, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1596098209, 1596098209);
INSERT INTO `user_login_log` VALUES (1023, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '登录成功', 1, 1596102175, 1596102175);
INSERT INTO `user_login_log` VALUES (1024, '19980731625', 1, '171.210.228.112', '{\"phone\":\"19980731625\",\"code\":\"539349\"}', '登录成功', 1, 1596116064, 1596116064);
INSERT INTO `user_login_log` VALUES (1025, 'hacker-sos@foxmail.com', 0, '122.114.88.197', '{\"username\":\"hacker-sos@foxmail.com\",\"timestamp\":1596330428}', '登录成功', 1, 1596330439, 1596330439);
INSERT INTO `user_login_log` VALUES (1026, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '登录成功', 1, 1596438949, 1596438949);
INSERT INTO `user_login_log` VALUES (1027, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '登录成功', 1, 1596447798, 1596447798);
INSERT INTO `user_login_log` VALUES (1028, '19980731625', 1, '118.112.196.46', '{\"phone\":\"19980731625\",\"code\":\"205876\"}', '登录成功', 1, 1596514233, 1596514233);
INSERT INTO `user_login_log` VALUES (1029, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1596526430}', '账号或者密码错误', 0, 1596526430, 1596526430);
INSERT INTO `user_login_log` VALUES (1030, '214213366@qq.com', 0, '122.114.88.197', '{\"username\":\"214213366@qq.com\",\"timestamp\":1596566485}', '登录成功', 1, 1596566486, 1596566486);
INSERT INTO `user_login_log` VALUES (1031, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1596622361, 1596622361);
INSERT INTO `user_login_log` VALUES (1032, '174259018', 1, '123.8.98.50', '{\"device_id\":\"96100a82f4f0a517\"}', '登录成功', 1, 1596675606, 1596675606);
INSERT INTO `user_login_log` VALUES (1033, '174259018', 1, '123.8.98.50', '{\"device_id\":\"96100a82f4f0a517\"}', '登录成功', 1, 1596675666, 1596675666);
INSERT INTO `user_login_log` VALUES (1034, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '登录成功', 1, 1596681570, 1596681570);
INSERT INTO `user_login_log` VALUES (1035, '193845701', 1, '120.228.167.22', '{\"device_id\":\"7f1cc5c80397e087\"}', '登录成功', 1, 1596708660, 1596708660);
INSERT INTO `user_login_log` VALUES (1036, '18899999999@qq.com', 0, '122.114.88.197', '{\"username\":\"18899999999@qq.com\",\"timestamp\":1596714045}', '登录成功', 1, 1596714035, 1596714035);
INSERT INTO `user_login_log` VALUES (1037, '104692731', 1, '171.43.150.37', '{\"device_id\":\"167953ebe147878e\"}', '登录成功', 1, 1596717246, 1596717246);
INSERT INTO `user_login_log` VALUES (1038, '113280547', 1, '113.232.32.200', '{\"device_id\":\"f88a0deca0a6b863\"}', '登录成功', 1, 1596721315, 1596721315);
INSERT INTO `user_login_log` VALUES (1039, '174259018', 1, '123.12.112.58', '{\"device_id\":\"96100a82f4f0a517\"}', '登录成功', 1, 1596757573, 1596757573);
INSERT INTO `user_login_log` VALUES (1040, '15240714175', 0, '122.114.88.197', '{\"username\":\"15240714175\",\"timestamp\":1596783558}', '账号或者密码错误', 0, 1596783560, 1596783560);
INSERT INTO `user_login_log` VALUES (1041, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '登录成功', 1, 1596871782, 1596871782);
INSERT INTO `user_login_log` VALUES (1042, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '登录成功', 1, 1596871784, 1596871784);
INSERT INTO `user_login_log` VALUES (1043, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '登录成功', 1, 1596876943, 1596876943);
INSERT INTO `user_login_log` VALUES (1044, '123', 0, '117.179.44.60', '{\"username\":\"123\"}', '账号或者密码错误', 0, 1596950437, 1596950437);
INSERT INTO `user_login_log` VALUES (1045, '123123', 0, '117.179.44.60', '{\"username\":\"123123\"}', '账号或者密码错误', 0, 1596950439, 1596950439);
INSERT INTO `user_login_log` VALUES (1046, '123123', 0, '117.179.44.60', '{\"username\":\"123123\"}', '账号或者密码错误', 0, 1596950439, 1596950439);
INSERT INTO `user_login_log` VALUES (1047, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1597047488, 1597047488);
INSERT INTO `user_login_log` VALUES (1048, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '登录成功', 1, 1597112970, 1597112970);
INSERT INTO `user_login_log` VALUES (1049, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1597135268}', '账号或者密码错误', 0, 1597135268, 1597135268);
INSERT INTO `user_login_log` VALUES (1050, '174259018', 1, '61.158.152.21', '{\"device_id\":\"96100a82f4f0a517\"}', '登录成功', 1, 1597146981, 1597146981);
INSERT INTO `user_login_log` VALUES (1051, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '登录成功', 1, 1597151270, 1597151270);
INSERT INTO `user_login_log` VALUES (1052, '1380013800', 0, '122.114.88.197', '{\"username\":\"1380013800\",\"timestamp\":1597164496}', '账号或者密码错误', 0, 1597164500, 1597164500);
INSERT INTO `user_login_log` VALUES (1053, 'superlon@qq.com', 0, '122.114.88.197', '{\"username\":\"superlon@qq.com\",\"timestamp\":1597164538}', '登录成功', 1, 1597164542, 1597164542);
INSERT INTO `user_login_log` VALUES (1054, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1597230344}', '账号或者密码错误', 0, 1597230347, 1597230347);
INSERT INTO `user_login_log` VALUES (1055, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1597230351}', '账号或者密码错误', 0, 1597230354, 1597230354);
INSERT INTO `user_login_log` VALUES (1056, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1597230369}', '账号或者密码错误', 0, 1597230372, 1597230372);
INSERT INTO `user_login_log` VALUES (1057, 'james@163.com', 0, '122.114.88.197', '{\"username\":\"james@163.com\",\"timestamp\":1597230568}', '登录成功', 1, 1597230572, 1597230572);
INSERT INTO `user_login_log` VALUES (1058, '104692731', 1, '171.113.144.25', '{\"device_id\":\"167953ebe147878e\"}', '登录成功', 1, 1597239849, 1597239849);
INSERT INTO `user_login_log` VALUES (1059, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1597299463, 1597299463);
INSERT INTO `user_login_log` VALUES (1060, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1597299467, 1597299467);
INSERT INTO `user_login_log` VALUES (1061, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1597299472, 1597299472);
INSERT INTO `user_login_log` VALUES (1062, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '登录成功', 1, 1597299488, 1597299488);
INSERT INTO `user_login_log` VALUES (1063, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1597299511, 1597299511);
INSERT INTO `user_login_log` VALUES (1064, '3274417239@qq.com', 0, '122.114.88.197', '{\"username\":\"3274417239@qq.com\",\"timestamp\":1597328543}', '登录成功', 1, 1597328587, 1597328587);
INSERT INTO `user_login_log` VALUES (1065, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1597335027}', '登录成功', 1, 1597335027, 1597335027);
INSERT INTO `user_login_log` VALUES (1066, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1597339648}', '账号或者密码错误', 0, 1597339647, 1597339647);
INSERT INTO `user_login_log` VALUES (1067, '13800138000', 0, '122.114.88.197', '{\"username\":\"13800138000\",\"timestamp\":1597339858}', '账号或者密码错误', 0, 1597339858, 1597339858);
INSERT INTO `user_login_log` VALUES (1068, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '登录成功', 1, 1597411565, 1597411565);
INSERT INTO `user_login_log` VALUES (1069, '14774989814', 1, '120.229.50.98', '{\"phone\":\"14774989814\",\"code\":\"256031\"}', '登录成功', 1, 1597468142, 1597468142);
INSERT INTO `user_login_log` VALUES (1070, 'wfgo@qq.com', 0, '122.114.88.197', '{\"username\":\"wfgo@qq.com\",\"timestamp\":1597728788}', '登录成功', 1, 1597728787, 1597728787);
INSERT INTO `user_login_log` VALUES (1071, 'adminkan', 0, '122.114.88.197', '{\"username\":\"adminkan\",\"timestamp\":1597730322}', '账号或者密码错误', 0, 1597730362, 1597730362);
INSERT INTO `user_login_log` VALUES (1072, '106931425', 1, '40.115.161.232', '{\"device_id\":\"4ecd946886c91254\"}', '登录成功', 1, 1597734892, 1597734892);
INSERT INTO `user_login_log` VALUES (1073, '106931425', 1, '40.115.161.232', '{\"device_id\":\"4ecd946886c91254\"}', '登录成功', 1, 1597734935, 1597734935);
INSERT INTO `user_login_log` VALUES (1074, '117943856', 1, '111.35.239.227', '{\"device_id\":\"6c7d9c0e7366a521\"}', '登录成功', 1, 1597813609, 1597813609);
INSERT INTO `user_login_log` VALUES (1075, '117943856', 1, '111.35.239.227', '{\"device_id\":\"6c7d9c0e7366a521\"}', '登录成功', 1, 1597813707, 1597813707);
INSERT INTO `user_login_log` VALUES (1076, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1597823106, 1597823106);
INSERT INTO `user_login_log` VALUES (1077, 'admin', 0, '103.224.82.246', '{\"username\":\"admin\"}', '登录成功', 1, 1597823113, 1597823113);
INSERT INTO `user_login_log` VALUES (1078, 'demo', 0, '103.224.82.246', '{\"username\":\"demo\"}', '登录成功', 1, 1597823256, 1597823256);
INSERT INTO `user_login_log` VALUES (1079, 'ztao', 0, '122.114.122.71', '{\"username\":\"ztao\"}', '账号或者密码错误', 0, 1605772881, 1605772881);
INSERT INTO `user_login_log` VALUES (1080, 'kiro', 0, '122.114.122.71', '{\"username\":\"kiro\"}', '登录成功', 1, 1605772891, 1605772891);
INSERT INTO `user_login_log` VALUES (1081, 'kiro', 0, '122.114.122.71', '{\"username\":\"kiro\"}', '登录成功', 1, 1605772966, 1605772966);
INSERT INTO `user_login_log` VALUES (1082, 'kiro', 0, '122.114.122.71', '{\"username\":\"kiro\"}', '登录成功', 1, 1605773056, 1605773056);
INSERT INTO `user_login_log` VALUES (1083, 'kiro', 0, '122.114.122.71', '{\"username\":\"kiro\"}', '登录成功', 1, 1605773208, 1605773208);
INSERT INTO `user_login_log` VALUES (1084, 'kiro', 0, '122.114.122.71', '{\"username\":\"kiro\"}', '登录成功', 1, 1605773219, 1605773219);
INSERT INTO `user_login_log` VALUES (1085, 'admin', 0, '122.114.122.71', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1605773241, 1605773241);
INSERT INTO `user_login_log` VALUES (1086, 'admin', 0, '122.114.122.71', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1605773243, 1605773243);
INSERT INTO `user_login_log` VALUES (1087, 'kiro', 0, '122.114.122.71', '{\"username\":\"kiro\"}', '登录成功', 1, 1605773257, 1605773257);
INSERT INTO `user_login_log` VALUES (1088, 'kiro', 0, '122.114.122.71', '{\"username\":\"kiro\"}', '登录成功', 1, 1605773271, 1605773271);
INSERT INTO `user_login_log` VALUES (1089, 'demo', 0, '122.114.122.71', '{\"username\":\"demo\"}', '登录成功', 1, 1605773342, 1605773342);
INSERT INTO `user_login_log` VALUES (1090, 'demo', 0, '122.114.122.71', '{\"username\":\"demo\"}', '登录成功', 1, 1605773345, 1605773345);
INSERT INTO `user_login_log` VALUES (1091, 'kiro', 0, '122.114.122.71', '{\"username\":\"kiro\"}', '登录成功', 1, 1605773459, 1605773459);
INSERT INTO `user_login_log` VALUES (1092, 'kiro', 0, '122.114.122.71', '{\"username\":\"kiro\"}', '登录成功', 1, 1605773576, 1605773576);
INSERT INTO `user_login_log` VALUES (1093, 'kiro', 0, '122.114.122.71', '{\"username\":\"kiro\"}', '登录成功', 1, 1605774494, 1605774494);
INSERT INTO `user_login_log` VALUES (1094, 'aaax@11.com', 0, '122.114.122.71', '{\"username\":\"aaax@11.com\",\"timestamp\":1605842609}', '登录成功', 1, 1605842629, 1605842629);
INSERT INTO `user_login_log` VALUES (1095, 'demo', 0, '122.114.122.71', '{\"username\":\"demo\"}', '登录成功', 1, 1605847911, 1605847911);
INSERT INTO `user_login_log` VALUES (1096, '1339574399@qq.com', 0, '122.114.122.71', '{\"username\":\"1339574399@qq.com\",\"timestamp\":1605959218}', '登录成功', 1, 1605959218, 1605959218);
INSERT INTO `user_login_log` VALUES (1097, '734976028@qq.com', 0, '122.114.122.71', '{\"username\":\"734976028@qq.com\",\"timestamp\":1606034365}', '登录成功', 1, 1606034365, 1606034365);
INSERT INTO `user_login_log` VALUES (1098, '734976028@qq.com', 0, '122.114.122.71', '{\"username\":\"734976028@qq.com\",\"timestamp\":1606034473}', '登录成功', 1, 1606034473, 1606034473);
INSERT INTO `user_login_log` VALUES (1099, '734976028@qq.com', 0, '122.114.122.71', '{\"username\":\"734976028@qq.com\",\"timestamp\":1606046585}', '登录成功', 1, 1606046586, 1606046586);
INSERT INTO `user_login_log` VALUES (1100, '734976028@qq.com', 0, '122.114.122.71', '{\"username\":\"734976028@qq.com\",\"timestamp\":1606100488}', '登录成功', 1, 1606100488, 1606100488);
INSERT INTO `user_login_log` VALUES (1101, 'demo', 0, '122.114.122.71', '{\"username\":\"demo\"}', '登录成功', 1, 1606148835, 1606148835);
INSERT INTO `user_login_log` VALUES (1102, 'admin', 0, '122.114.122.71', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1606204179, 1606204179);
INSERT INTO `user_login_log` VALUES (1103, 'admin', 0, '122.114.122.71', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1606204184, 1606204184);
INSERT INTO `user_login_log` VALUES (1104, 'demo', 0, '122.114.122.71', '{\"username\":\"demo\"}', '登录成功', 1, 1606205051, 1606205051);
INSERT INTO `user_login_log` VALUES (1105, 'admin', 0, '122.114.122.71', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1606205765, 1606205765);
INSERT INTO `user_login_log` VALUES (1106, 'kiro', 0, '122.114.122.71', '{\"username\":\"kiro\"}', '登录成功', 1, 1606205849, 1606205849);
INSERT INTO `user_login_log` VALUES (1107, '734976028@qq.com', 0, '122.114.122.71', '{\"username\":\"734976028@qq.com\",\"timestamp\":1606206495}', '登录成功', 1, 1606206496, 1606206496);
INSERT INTO `user_login_log` VALUES (1108, '734976028@qq.com', 0, '122.114.122.71', '{\"username\":\"734976028@qq.com\",\"timestamp\":1606217893}', '登录成功', 1, 1606217893, 1606217893);
INSERT INTO `user_login_log` VALUES (1109, '4729260@qq.com', 0, '122.114.122.71', '{\"username\":\"4729260@qq.com\",\"timestamp\":1606223767}', '登录成功', 1, 1606223768, 1606223768);
INSERT INTO `user_login_log` VALUES (1110, '4729260@qq.com', 0, '122.114.122.71', '{\"username\":\"4729260@qq.com\",\"timestamp\":1606223847}', '登录成功', 1, 1606223849, 1606223849);
INSERT INTO `user_login_log` VALUES (1111, '5311947@qq.com', 0, '122.114.122.71', '{\"username\":\"5311947@qq.com\",\"timestamp\":1606226272}', '登录成功', 1, 1606226275, 1606226275);
INSERT INTO `user_login_log` VALUES (1112, 'demo', 0, '122.114.122.71', '{\"username\":\"demo\",\"timestamp\":1606257519}', '登录成功', 1, 1606257518, 1606257518);
INSERT INTO `user_login_log` VALUES (1113, 'demo', 0, '122.114.122.71', '{\"username\":\"demo\"}', '登录成功', 1, 1606301398, 1606301398);
INSERT INTO `user_login_log` VALUES (1114, 'kiro', 0, '122.114.122.71', '{\"username\":\"kiro\"}', '登录成功', 1, 1606355683, 1606355683);
INSERT INTO `user_login_log` VALUES (1115, 'demo', 0, '122.114.122.71', '{\"username\":\"demo\"}', '登录成功', 1, 1606358285, 1606358285);
INSERT INTO `user_login_log` VALUES (1116, 'admin', 0, '122.114.122.71', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1606360482, 1606360482);
INSERT INTO `user_login_log` VALUES (1117, 'admin', 0, '122.114.122.71', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1606360486, 1606360486);
INSERT INTO `user_login_log` VALUES (1118, 'admin', 0, '122.114.122.71', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1606360492, 1606360492);
INSERT INTO `user_login_log` VALUES (1119, 'admin', 0, '122.114.122.71', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1606360495, 1606360495);
INSERT INTO `user_login_log` VALUES (1120, 'admin', 0, '122.114.122.71', '{\"username\":\"admin\"}', '登录成功', 1, 1606360608, 1606360608);
INSERT INTO `user_login_log` VALUES (1121, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1606362354, 1606362354);
INSERT INTO `user_login_log` VALUES (1122, '15882478525', 0, '222.211.125.203', '{\"username\":\"15882478525\"}', '登录成功', 1, 1606362649, 1606362649);
INSERT INTO `user_login_log` VALUES (1123, '15882478525', 0, '222.211.125.203', '{\"username\":\"15882478525\"}', '登录成功', 1, 1606362818, 1606362818);
INSERT INTO `user_login_log` VALUES (1124, '15882478525', 0, '222.211.125.203', '{\"username\":\"15882478525\"}', '登录成功', 1, 1606362824, 1606362824);
INSERT INTO `user_login_log` VALUES (1125, 'demo', 0, '122.114.122.71', '{\"username\":\"demo\"}', '登录成功', 1, 1606379391, 1606379391);
INSERT INTO `user_login_log` VALUES (1126, '15882478525', 0, '222.211.125.203', '{\"username\":\"15882478525\"}', '登录成功', 1, 1606401502, 1606401502);
INSERT INTO `user_login_log` VALUES (1127, '15882478525', 0, '222.211.125.203', '{\"username\":\"15882478525\"}', '登录成功', 1, 1606401506, 1606401506);
INSERT INTO `user_login_log` VALUES (1128, 'demo', 0, '122.114.122.71', '{\"username\":\"demo\"}', '登录成功', 1, 1606480598, 1606480598);
INSERT INTO `user_login_log` VALUES (1129, 'admin', 0, '122.114.122.71', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1606487649, 1606487649);
INSERT INTO `user_login_log` VALUES (1130, 'admin', 0, '122.114.122.71', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1606487652, 1606487652);
INSERT INTO `user_login_log` VALUES (1131, 'admin', 0, '122.114.122.71', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1606487656, 1606487656);
INSERT INTO `user_login_log` VALUES (1132, 'admin', 0, '122.114.122.71', '{\"username\":\"admin\"}', '登录成功', 1, 1606487661, 1606487661);
INSERT INTO `user_login_log` VALUES (1133, 'kiro', 0, '122.114.122.71', '{\"username\":\"kiro\"}', '登录成功', 1, 1606552994, 1606552994);
INSERT INTO `user_login_log` VALUES (1134, '15882478525', 0, '222.211.125.160', '{\"username\":\"15882478525\"}', '登录成功', 1, 1606563963, 1606563963);
INSERT INTO `user_login_log` VALUES (1135, '15887788771@qq.com', 0, '122.114.122.71', '{\"username\":\"15887788771@qq.com\",\"timestamp\":1606573459}', '登录成功', 1, 1606573460, 1606573460);
INSERT INTO `user_login_log` VALUES (1136, '15573733370', 0, '122.114.122.71', '{\"username\":\"15573733370\",\"timestamp\":1606588560}', '账号或者密码错误', 0, 1606588561, 1606588561);
INSERT INTO `user_login_log` VALUES (1137, '17624401391', 0, '122.114.122.71', '{\"username\":\"17624401391\",\"timestamp\":1606604676}', '账号或者密码错误', 0, 1606604677, 1606604677);
INSERT INTO `user_login_log` VALUES (1138, 'demo', 0, '122.114.122.71', '{\"username\":\"demo\"}', '登录成功', 1, 1606624802, 1606624802);
INSERT INTO `user_login_log` VALUES (1139, '15882478525', 0, '222.211.125.160', '{\"username\":\"15882478525\"}', '登录成功', 1, 1606707869, 1606707869);
INSERT INTO `user_login_log` VALUES (1140, '15882478525', 0, '222.211.125.160', '{\"username\":\"15882478525\"}', '登录成功', 1, 1606707918, 1606707918);
INSERT INTO `user_login_log` VALUES (1141, '15882478525', 0, '222.211.125.160', '{\"username\":\"15882478525\"}', '登录成功', 1, 1606708012, 1606708012);
INSERT INTO `user_login_log` VALUES (1142, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1606717519, 1606717519);
INSERT INTO `user_login_log` VALUES (1143, '15882478525', 0, '171.210.66.179', '{\"username\":\"15882478525\"}', '登录成功', 1, 1606723833, 1606723833);
INSERT INTO `user_login_log` VALUES (1144, '15882478525', 0, '222.211.125.160', '{\"username\":\"15882478525\"}', '登录成功', 1, 1606726347, 1606726347);
INSERT INTO `user_login_log` VALUES (1145, '15882478525', 0, '222.211.125.160', '{\"username\":\"15882478525\"}', '登录成功', 1, 1606726356, 1606726356);
INSERT INTO `user_login_log` VALUES (1146, '15882478525', 0, '222.211.125.160', '{\"username\":\"15882478525\"}', '登录成功', 1, 1606726366, 1606726366);
INSERT INTO `user_login_log` VALUES (1147, '15882478525', 0, '222.211.125.160', '{\"username\":\"15882478525\"}', '登录成功', 1, 1606726396, 1606726396);
INSERT INTO `user_login_log` VALUES (1148, '15882478525', 0, '222.211.125.160', '{\"username\":\"15882478525\"}', '登录成功', 1, 1606726461, 1606726461);
INSERT INTO `user_login_log` VALUES (1149, '15882478525', 0, '222.211.125.160', '{\"username\":\"15882478525\"}', '登录成功', 1, 1606726499, 1606726499);
INSERT INTO `user_login_log` VALUES (1150, '15882478525', 0, '222.211.125.160', '{\"username\":\"15882478525\"}', '登录成功', 1, 1606726570, 1606726570);
INSERT INTO `user_login_log` VALUES (1151, '15882478525', 0, '222.211.125.160', '{\"username\":\"15882478525\"}', '登录成功', 1, 1606726614, 1606726614);
INSERT INTO `user_login_log` VALUES (1152, '15882478525', 0, '222.211.125.160', '{\"username\":\"15882478525\"}', '登录成功', 1, 1606726639, 1606726639);
INSERT INTO `user_login_log` VALUES (1153, '15882478525', 0, '222.211.125.160', '{\"username\":\"15882478525\"}', '登录成功', 1, 1606726654, 1606726654);
INSERT INTO `user_login_log` VALUES (1154, '15882478525', 0, '222.211.125.160', '{\"username\":\"15882478525\"}', '登录成功', 1, 1606726695, 1606726695);
INSERT INTO `user_login_log` VALUES (1155, '15882478525', 0, '222.211.125.160', '{\"username\":\"15882478525\"}', '登录成功', 1, 1606727119, 1606727119);
INSERT INTO `user_login_log` VALUES (1156, 'kiro', 0, '122.114.122.71', '{\"username\":\"kiro\"}', '账号或者密码错误', 0, 1606807426, 1606807426);
INSERT INTO `user_login_log` VALUES (1157, 'kiro', 0, '122.114.122.71', '{\"username\":\"kiro\"}', '登录成功', 1, 1606807431, 1606807431);
INSERT INTO `user_login_log` VALUES (1158, 'kiro', 0, '122.114.122.71', '{\"username\":\"kiro\"}', '登录成功', 1, 1606807437, 1606807437);
INSERT INTO `user_login_log` VALUES (1159, 'admin', 0, '122.114.122.71', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1606807736, 1606807736);
INSERT INTO `user_login_log` VALUES (1160, 'admin', 0, '122.114.122.71', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1606807807, 1606807807);
INSERT INTO `user_login_log` VALUES (1161, 'admin', 0, '122.114.122.71', '{\"username\":\"admin\"}', '登录成功', 1, 1606807813, 1606807813);
INSERT INTO `user_login_log` VALUES (1162, '13666666666', 0, '171.88.66.154', '{\"username\":\"13666666666\"}', '登录成功', 1, 1606807868, 1606807868);
INSERT INTO `user_login_log` VALUES (1163, '15882478525', 0, '222.211.125.160', '{\"username\":\"15882478525\"}', '登录成功', 1, 1606807899, 1606807899);
INSERT INTO `user_login_log` VALUES (1164, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809371, 1606809371);
INSERT INTO `user_login_log` VALUES (1165, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809372, 1606809372);
INSERT INTO `user_login_log` VALUES (1166, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809374, 1606809374);
INSERT INTO `user_login_log` VALUES (1167, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809375, 1606809375);
INSERT INTO `user_login_log` VALUES (1168, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809376, 1606809376);
INSERT INTO `user_login_log` VALUES (1169, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809376, 1606809376);
INSERT INTO `user_login_log` VALUES (1170, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809377, 1606809377);
INSERT INTO `user_login_log` VALUES (1171, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809377, 1606809377);
INSERT INTO `user_login_log` VALUES (1172, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809377, 1606809377);
INSERT INTO `user_login_log` VALUES (1173, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809378, 1606809378);
INSERT INTO `user_login_log` VALUES (1174, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809378, 1606809378);
INSERT INTO `user_login_log` VALUES (1175, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809378, 1606809378);
INSERT INTO `user_login_log` VALUES (1176, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809379, 1606809379);
INSERT INTO `user_login_log` VALUES (1177, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809576, 1606809576);
INSERT INTO `user_login_log` VALUES (1178, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809578, 1606809578);
INSERT INTO `user_login_log` VALUES (1179, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809581, 1606809581);
INSERT INTO `user_login_log` VALUES (1180, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809585, 1606809585);
INSERT INTO `user_login_log` VALUES (1181, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809586, 1606809586);
INSERT INTO `user_login_log` VALUES (1182, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809586, 1606809586);
INSERT INTO `user_login_log` VALUES (1183, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809617, 1606809617);
INSERT INTO `user_login_log` VALUES (1184, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809630, 1606809630);
INSERT INTO `user_login_log` VALUES (1185, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809630, 1606809630);
INSERT INTO `user_login_log` VALUES (1186, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809630, 1606809630);
INSERT INTO `user_login_log` VALUES (1187, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809630, 1606809630);
INSERT INTO `user_login_log` VALUES (1188, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809634, 1606809634);
INSERT INTO `user_login_log` VALUES (1189, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809634, 1606809634);
INSERT INTO `user_login_log` VALUES (1190, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809635, 1606809635);
INSERT INTO `user_login_log` VALUES (1191, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809635, 1606809635);
INSERT INTO `user_login_log` VALUES (1192, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809636, 1606809636);
INSERT INTO `user_login_log` VALUES (1193, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809636, 1606809636);
INSERT INTO `user_login_log` VALUES (1194, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809636, 1606809636);
INSERT INTO `user_login_log` VALUES (1195, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809636, 1606809636);
INSERT INTO `user_login_log` VALUES (1196, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809637, 1606809637);
INSERT INTO `user_login_log` VALUES (1197, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809637, 1606809637);
INSERT INTO `user_login_log` VALUES (1198, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809637, 1606809637);
INSERT INTO `user_login_log` VALUES (1199, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809637, 1606809637);
INSERT INTO `user_login_log` VALUES (1200, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809637, 1606809637);
INSERT INTO `user_login_log` VALUES (1201, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809638, 1606809638);
INSERT INTO `user_login_log` VALUES (1202, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809638, 1606809638);
INSERT INTO `user_login_log` VALUES (1203, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809638, 1606809638);
INSERT INTO `user_login_log` VALUES (1204, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809638, 1606809638);
INSERT INTO `user_login_log` VALUES (1205, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809638, 1606809638);
INSERT INTO `user_login_log` VALUES (1206, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809639, 1606809639);
INSERT INTO `user_login_log` VALUES (1207, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809639, 1606809639);
INSERT INTO `user_login_log` VALUES (1208, '16666666666', 0, '171.88.66.154', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1606809639, 1606809639);
INSERT INTO `user_login_log` VALUES (1209, '15882478525', 0, '171.88.66.154', '{\"username\":\"15882478525\"}', '登录成功', 1, 1606809667, 1606809667);
INSERT INTO `user_login_log` VALUES (1210, '15882478525', 0, '222.211.125.160', '{\"username\":\"15882478525\"}', '登录成功', 1, 1606809671, 1606809671);
INSERT INTO `user_login_log` VALUES (1211, '17623545019', 0, '122.114.122.71', '{\"username\":\"17623545019\",\"timestamp\":1606811977}', '账号或者密码错误', 0, 1606811927, 1606811927);
INSERT INTO `user_login_log` VALUES (1212, '17623545019@qq.com', 0, '122.114.122.71', '{\"username\":\"17623545019@qq.com\",\"timestamp\":1606811984}', '登录成功', 1, 1606811934, 1606811934);
INSERT INTO `user_login_log` VALUES (1213, 'demo', 0, '122.114.122.71', '{\"username\":\"demo\"}', '登录成功', 1, 1606819789, 1606819789);
INSERT INTO `user_login_log` VALUES (1214, 'kiro', 0, '116.234.101.142', '{\"username\":\"kiro\"}', '登录成功', 1, 1606826134, 1606826134);
INSERT INTO `user_login_log` VALUES (1215, '15882478525', 0, '222.211.125.160', '{\"username\":\"15882478525\"}', '登录成功', 1, 1606833870, 1606833870);
INSERT INTO `user_login_log` VALUES (1216, '15882478525', 0, '222.211.125.160', '{\"username\":\"15882478525\"}', '登录成功', 1, 1606890989, 1606890989);
INSERT INTO `user_login_log` VALUES (1217, '15882478525', 0, '222.211.125.160', '{\"username\":\"15882478525\"}', '登录成功', 1, 1606895349, 1606895349);
INSERT INTO `user_login_log` VALUES (1218, 'admin', 0, '122.114.122.71', '{\"username\":\"admin\"}', '登录成功', 1, 1606895846, 1606895846);
INSERT INTO `user_login_log` VALUES (1219, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1606897295, 1606897295);
INSERT INTO `user_login_log` VALUES (1220, '15882478525', 0, '171.88.66.154', '{\"username\":\"15882478525\"}', '登录成功', 1, 1606926449, 1606926449);
INSERT INTO `user_login_log` VALUES (1221, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1606963952, 1606963952);
INSERT INTO `user_login_log` VALUES (1222, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1606979038, 1606979038);
INSERT INTO `user_login_log` VALUES (1223, '15882478525', 0, '171.217.107.10', '{\"username\":\"15882478525\"}', '登录成功', 1, 1606981110, 1606981110);
INSERT INTO `user_login_log` VALUES (1224, '15882478525', 0, '171.217.107.10', '{\"username\":\"15882478525\"}', '登录成功', 1, 1606988302, 1606988302);
INSERT INTO `user_login_log` VALUES (1225, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1606989422, 1606989422);
INSERT INTO `user_login_log` VALUES (1226, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1606990129, 1606990129);
INSERT INTO `user_login_log` VALUES (1227, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1606990796, 1606990796);
INSERT INTO `user_login_log` VALUES (1228, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1606990929, 1606990929);
INSERT INTO `user_login_log` VALUES (1229, '15882478525', 0, '171.217.107.10', '{\"username\":\"15882478525\"}', '登录成功', 1, 1606993364, 1606993364);
INSERT INTO `user_login_log` VALUES (1230, 'kiro', 0, '122.114.122.71', '{\"username\":\"kiro\"}', '登录成功', 1, 1606993899, 1606993899);
INSERT INTO `user_login_log` VALUES (1231, 'kiro', 0, '122.114.122.71', '{\"username\":\"kiro\"}', '登录成功', 1, 1606993908, 1606993908);
INSERT INTO `user_login_log` VALUES (1232, 'admin', 0, '122.114.122.71', '{\"username\":\"admin\"}', '登录成功', 1, 1606994686, 1606994686);
INSERT INTO `user_login_log` VALUES (1233, 'admin', 0, '122.114.122.71', '{\"username\":\"admin\"}', '登录成功', 1, 1606994692, 1606994692);
INSERT INTO `user_login_log` VALUES (1234, 'admin', 0, '122.114.122.71', '{\"username\":\"admin\"}', '登录成功', 1, 1606994697, 1606994697);
INSERT INTO `user_login_log` VALUES (1235, 'admin', 0, '122.114.122.71', '{\"username\":\"admin\"}', '登录成功', 1, 1606995385, 1606995385);
INSERT INTO `user_login_log` VALUES (1236, 'demo', 0, '122.114.122.71', '{\"username\":\"demo\"}', '登录成功', 1, 1606995392, 1606995392);
INSERT INTO `user_login_log` VALUES (1237, 'kiro', 0, '122.114.122.71', '{\"username\":\"kiro\"}', '登录成功', 1, 1606995542, 1606995542);
INSERT INTO `user_login_log` VALUES (1238, 'kiro', 0, '122.114.122.71', '{\"username\":\"kiro\"}', '登录成功', 1, 1606995546, 1606995546);
INSERT INTO `user_login_log` VALUES (1239, 'kiro', 0, '122.114.122.71', '{\"username\":\"kiro\"}', '登录成功', 1, 1606995566, 1606995566);
INSERT INTO `user_login_log` VALUES (1240, '15882478525', 0, '171.92.171.106', '{\"username\":\"15882478525\"}', '登录成功', 1, 1606995874, 1606995874);
INSERT INTO `user_login_log` VALUES (1241, 'kiro', 0, '122.114.122.71', '{\"username\":\"kiro\"}', '登录成功', 1, 1606996088, 1606996088);
INSERT INTO `user_login_log` VALUES (1242, 'kiro', 0, '122.114.122.71', '{\"username\":\"kiro\"}', '登录成功', 1, 1606996170, 1606996170);
INSERT INTO `user_login_log` VALUES (1243, 'kiro', 0, '122.114.122.71', '{\"username\":\"kiro\"}', '登录成功', 1, 1606996179, 1606996179);
INSERT INTO `user_login_log` VALUES (1244, 'kiro', 0, '122.114.122.71', '{\"username\":\"kiro\"}', '登录成功', 1, 1606996685, 1606996685);
INSERT INTO `user_login_log` VALUES (1245, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1607043762, 1607043762);
INSERT INTO `user_login_log` VALUES (1246, 'admin', 0, '122.114.122.71', '{\"username\":\"admin\"}', '登录成功', 1, 1607067860, 1607067860);
INSERT INTO `user_login_log` VALUES (1247, 'kiro', 0, '122.114.122.71', '{\"username\":\"kiro\"}', '登录成功', 1, 1607068571, 1607068571);
INSERT INTO `user_login_log` VALUES (1248, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1607070388, 1607070388);
INSERT INTO `user_login_log` VALUES (1249, '15882478525', 0, '171.88.66.154', '{\"username\":\"15882478525\"}', '登录成功', 1, 1607072185, 1607072185);
INSERT INTO `user_login_log` VALUES (1250, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1607073410, 1607073410);
INSERT INTO `user_login_log` VALUES (1251, '15882478525', 0, '171.217.107.10', '{\"username\":\"15882478525\"}', '登录成功', 1, 1607074866, 1607074866);
INSERT INTO `user_login_log` VALUES (1252, '15882478525', 0, '171.217.107.10', '{\"username\":\"15882478525\"}', '登录成功', 1, 1607084838, 1607084838);
INSERT INTO `user_login_log` VALUES (1253, '15882478525', 0, '111.14.69.147', '{\"username\":\"15882478525\"}', '登录成功', 1, 1607085437, 1607085437);
INSERT INTO `user_login_log` VALUES (1254, '15882478525', 0, '171.88.66.154', '{\"username\":\"15882478525\"}', '登录成功', 1, 1607085607, 1607085607);
INSERT INTO `user_login_log` VALUES (1255, 'demo', 0, '122.114.122.71', '{\"username\":\"demo\"}', '登录成功', 1, 1607090032, 1607090032);
INSERT INTO `user_login_log` VALUES (1256, '15882478525', 0, '171.88.66.154', '{\"username\":\"15882478525\"}', '登录成功', 1, 1607090103, 1607090103);
INSERT INTO `user_login_log` VALUES (1257, '15882478525', 0, '171.217.107.10', '{\"username\":\"15882478525\"}', '登录成功', 1, 1607090434, 1607090434);
INSERT INTO `user_login_log` VALUES (1258, '15882478525', 0, '171.217.107.10', '{\"username\":\"15882478525\"}', '登录成功', 1, 1607090660, 1607090660);
INSERT INTO `user_login_log` VALUES (1259, '15882478525', 0, '111.14.71.177', '{\"username\":\"15882478525\"}', '登录成功', 1, 1607125553, 1607125553);
INSERT INTO `user_login_log` VALUES (1260, '15882478525', 0, '118.112.197.45', '{\"username\":\"15882478525\"}', '登录成功', 1, 1607135688, 1607135688);
INSERT INTO `user_login_log` VALUES (1261, 'admin', 0, '122.114.122.71', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1607135870, 1607135870);
INSERT INTO `user_login_log` VALUES (1262, 'admin', 0, '122.114.122.71', '{\"username\":\"admin\"}', '登录成功', 1, 1607135876, 1607135876);
INSERT INTO `user_login_log` VALUES (1263, '15882478525', 0, '171.217.107.10', '{\"username\":\"15882478525\"}', '登录成功', 1, 1607156872, 1607156872);
INSERT INTO `user_login_log` VALUES (1264, 'kiro', 0, '116.234.97.183', '{\"username\":\"kiro\"}', '登录成功', 1, 1607157651, 1607157651);
INSERT INTO `user_login_log` VALUES (1265, '15882478525', 0, '171.217.107.10', '{\"username\":\"15882478525\"}', '登录成功', 1, 1607158408, 1607158408);
INSERT INTO `user_login_log` VALUES (1266, 'kiro', 0, '116.234.97.183', '{\"username\":\"kiro\"}', '登录成功', 1, 1607160663, 1607160663);
INSERT INTO `user_login_log` VALUES (1267, 'kiro', 0, '116.234.97.183', '{\"username\":\"kiro\"}', '登录成功', 1, 1607161724, 1607161724);
INSERT INTO `user_login_log` VALUES (1268, '15882478524', 0, '171.217.107.10', '{\"username\":\"15882478524\"}', '登录成功', 1, 1607250268, 1607250268);
INSERT INTO `user_login_log` VALUES (1269, '15882478525', 0, '171.217.107.10', '{\"username\":\"15882478525\"}', '登录成功', 1, 1607251895, 1607251895);
INSERT INTO `user_login_log` VALUES (1270, '15882478525', 0, '171.217.107.10', '{\"username\":\"15882478525\"}', '登录成功', 1, 1607255634, 1607255634);
INSERT INTO `user_login_log` VALUES (1271, '13666666666', 0, '118.112.197.45', '{\"username\":\"13666666666\"}', '登录成功', 1, 1607261113, 1607261113);
INSERT INTO `user_login_log` VALUES (1272, '18227984841', 0, '122.114.122.71', '{\"username\":\"18227984841\",\"timestamp\":1607276264}', '账号或者密码错误', 0, 1607276266, 1607276266);
INSERT INTO `user_login_log` VALUES (1273, '991899182@qq.com', 0, '122.114.122.71', '{\"username\":\"991899182@qq.com\",\"timestamp\":1607276350}', '登录成功', 1, 1607276352, 1607276352);
INSERT INTO `user_login_log` VALUES (1274, '15882478525', 0, '117.61.8.89', '{\"username\":\"15882478525\"}', '登录成功', 1, 1607276579, 1607276579);
INSERT INTO `user_login_log` VALUES (1275, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1607303688, 1607303688);
INSERT INTO `user_login_log` VALUES (1276, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1607303692, 1607303692);
INSERT INTO `user_login_log` VALUES (1277, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1607304029, 1607304029);
INSERT INTO `user_login_log` VALUES (1278, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1607308676, 1607308676);
INSERT INTO `user_login_log` VALUES (1279, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1607309220, 1607309220);
INSERT INTO `user_login_log` VALUES (1280, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1607311779, 1607311779);
INSERT INTO `user_login_log` VALUES (1281, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1607312137, 1607312137);
INSERT INTO `user_login_log` VALUES (1282, '15882478525', 0, '171.217.107.10', '{\"username\":\"15882478525\"}', '登录成功', 1, 1607312754, 1607312754);
INSERT INTO `user_login_log` VALUES (1283, '15882478524', 0, '171.217.107.10', '{\"username\":\"15882478524\"}', '登录成功', 1, 1607312800, 1607312800);
INSERT INTO `user_login_log` VALUES (1284, '15882478525', 0, '171.217.107.10', '{\"username\":\"15882478525\"}', '登录成功', 1, 1607312833, 1607312833);
INSERT INTO `user_login_log` VALUES (1285, '15882478525', 0, '171.217.107.10', '{\"username\":\"15882478525\"}', '登录成功', 1, 1607312899, 1607312899);
INSERT INTO `user_login_log` VALUES (1286, '15882478524', 0, '171.217.107.10', '{\"username\":\"15882478524\"}', '登录成功', 1, 1607313050, 1607313050);
INSERT INTO `user_login_log` VALUES (1287, '13666666666', 0, '171.216.203.181', '{\"username\":\"13666666666\"}', '登录成功', 1, 1607313784, 1607313784);
INSERT INTO `user_login_log` VALUES (1288, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1607319544, 1607319544);
INSERT INTO `user_login_log` VALUES (1289, '13800138000', 0, '222.210.227.213', '{\"username\":\"13800138000\"}', '账号或者密码错误', 0, 1607321218, 1607321218);
INSERT INTO `user_login_log` VALUES (1290, '13800138000', 0, '222.210.227.213', '{\"username\":\"13800138000\"}', '账号或者密码错误', 0, 1607321221, 1607321221);
INSERT INTO `user_login_log` VALUES (1291, '13800138000', 0, '222.210.227.213', '{\"username\":\"13800138000\"}', '账号或者密码错误', 0, 1607321222, 1607321222);
INSERT INTO `user_login_log` VALUES (1292, '13800138000', 0, '222.210.227.213', '{\"username\":\"13800138000\"}', '账号或者密码错误', 0, 1607321223, 1607321223);
INSERT INTO `user_login_log` VALUES (1293, '13800138000', 0, '222.210.227.213', '{\"username\":\"13800138000\"}', '账号或者密码错误', 0, 1607321225, 1607321225);
INSERT INTO `user_login_log` VALUES (1294, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1607321279, 1607321279);
INSERT INTO `user_login_log` VALUES (1295, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1607321598, 1607321598);
INSERT INTO `user_login_log` VALUES (1296, 'admin', 0, '122.114.122.71', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1607321735, 1607321735);
INSERT INTO `user_login_log` VALUES (1297, 'admin', 0, '122.114.122.71', '{\"username\":\"admin\"}', '登录成功', 1, 1607321742, 1607321742);
INSERT INTO `user_login_log` VALUES (1298, '15882478525', 0, '171.217.107.10', '{\"username\":\"15882478525\"}', '登录成功', 1, 1607322050, 1607322050);
INSERT INTO `user_login_log` VALUES (1299, '13666666666', 0, '183.222.23.100', '{\"username\":\"13666666666\"}', '登录成功', 1, 1607325811, 1607325811);
INSERT INTO `user_login_log` VALUES (1300, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1607326436, 1607326436);
INSERT INTO `user_login_log` VALUES (1301, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1607326768, 1607326768);
INSERT INTO `user_login_log` VALUES (1302, '13666666666', 0, '183.222.23.100', '{\"username\":\"13666666666\"}', '登录成功', 1, 1607327127, 1607327127);
INSERT INTO `user_login_log` VALUES (1303, '13666666666', 0, '171.216.237.38', '{\"username\":\"13666666666\"}', '登录成功', 1, 1607332511, 1607332511);
INSERT INTO `user_login_log` VALUES (1304, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1607332771, 1607332771);
INSERT INTO `user_login_log` VALUES (1305, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1607332772, 1607332772);
INSERT INTO `user_login_log` VALUES (1306, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1607332773, 1607332773);
INSERT INTO `user_login_log` VALUES (1307, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1607332773, 1607332773);
INSERT INTO `user_login_log` VALUES (1308, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1607332774, 1607332774);
INSERT INTO `user_login_log` VALUES (1309, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1607332774, 1607332774);
INSERT INTO `user_login_log` VALUES (1310, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1607332775, 1607332775);
INSERT INTO `user_login_log` VALUES (1311, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1607332775, 1607332775);
INSERT INTO `user_login_log` VALUES (1312, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1607332776, 1607332776);
INSERT INTO `user_login_log` VALUES (1313, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1607332776, 1607332776);
INSERT INTO `user_login_log` VALUES (1314, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1607332777, 1607332777);
INSERT INTO `user_login_log` VALUES (1315, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1607332777, 1607332777);
INSERT INTO `user_login_log` VALUES (1316, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1607332778, 1607332778);
INSERT INTO `user_login_log` VALUES (1317, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1607332778, 1607332778);
INSERT INTO `user_login_log` VALUES (1318, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1607332779, 1607332779);
INSERT INTO `user_login_log` VALUES (1319, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1607332779, 1607332779);
INSERT INTO `user_login_log` VALUES (1320, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1607332780, 1607332780);
INSERT INTO `user_login_log` VALUES (1321, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1607332780, 1607332780);
INSERT INTO `user_login_log` VALUES (1322, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1607332781, 1607332781);
INSERT INTO `user_login_log` VALUES (1323, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1607332781, 1607332781);
INSERT INTO `user_login_log` VALUES (1324, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1607332782, 1607332782);
INSERT INTO `user_login_log` VALUES (1325, 'kiro', 0, '180.167.105.22', '{\"username\":\"kiro\"}', '登录成功', 1, 1607332782, 1607332782);
INSERT INTO `user_login_log` VALUES (1326, 'xnoam4be', 0, '101.89.32.18', '{\"username\":\"xnoam4be\",\"timestamp\":1607785353}', '账号或者密码错误', 0, 1607785350, 1607785350);
INSERT INTO `user_login_log` VALUES (1327, 'zixzqbzd', 0, '101.89.32.18', '{\"username\":\"zixzqbzd\",\"timestamp\":1607785377}', '账号或者密码错误', 0, 1607785374, 1607785374);
INSERT INTO `user_login_log` VALUES (1328, '15637252863', 0, '123.151.144.103', '{\"username\":\"15637252863\",\"timestamp\":1607785421}', '账号或者密码错误', 0, 1607785418, 1607785418);
INSERT INTO `user_login_log` VALUES (1329, '15637252863', 0, '123.151.144.103', '{\"username\":\"15637252863\",\"timestamp\":1607785427}', '账号或者密码错误', 0, 1607785423, 1607785423);
INSERT INTO `user_login_log` VALUES (1330, '18227984841', 0, '220.194.88.217', '{\"username\":\"18227984841\"}', '账号或者密码错误', 0, 1607787520, 1607787520);
INSERT INTO `user_login_log` VALUES (1331, 'kiro', 0, '101.89.27.209', '{\"username\":\"kiro\"}', '登录成功', 1, 1607845369, 1607845369);
INSERT INTO `user_login_log` VALUES (1332, 'kiro', 0, '61.151.164.124', '{\"username\":\"kiro\"}', '登录成功', 1, 1607847381, 1607847381);
INSERT INTO `user_login_log` VALUES (1333, 'admin', 0, '101.89.34.239', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1607847429, 1607847429);
INSERT INTO `user_login_log` VALUES (1334, '13666666666', 0, '223.166.151.125', '{\"username\":\"13666666666\"}', '登录成功', 1, 1607916702, 1607916702);
INSERT INTO `user_login_log` VALUES (1335, '15882478524', 0, '220.194.88.217', '{\"username\":\"15882478524\"}', '登录成功', 1, 1607930970, 1607930970);
INSERT INTO `user_login_log` VALUES (1336, '16666666666', 0, '123.151.144.18', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1607953792, 1607953792);
INSERT INTO `user_login_log` VALUES (1337, '166666666666', 0, '101.91.24.25', '{\"username\":\"166666666666\"}', '账号或者密码错误', 0, 1607953798, 1607953798);
INSERT INTO `user_login_log` VALUES (1338, '1666666666', 0, '220.194.88.252', '{\"username\":\"1666666666\"}', '账号或者密码错误', 0, 1607953801, 1607953801);
INSERT INTO `user_login_log` VALUES (1339, '16666666666', 0, '220.194.88.217', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1607953825, 1607953825);
INSERT INTO `user_login_log` VALUES (1340, '16666666666', 0, '123.151.144.18', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1607953827, 1607953827);
INSERT INTO `user_login_log` VALUES (1341, '16666666666', 0, '101.91.24.25', '{\"username\":\"16666666666\"}', '账号或者密码错误', 0, 1607953832, 1607953832);
INSERT INTO `user_login_log` VALUES (1342, '13666666666', 0, '220.194.88.252', '{\"username\":\"13666666666\"}', '登录成功', 1, 1607953876, 1607953876);
INSERT INTO `user_login_log` VALUES (1343, 'admin', 0, '123.151.144.103', '{\"username\":\"admin\"}', '登录成功', 1, 1607954432, 1607954432);
INSERT INTO `user_login_log` VALUES (1344, '67', 0, '101.89.34.223', '{\"username\":\"67\",\"timestamp\":1608019402}', '账号或者密码错误', 0, 1608019402, 1608019402);
INSERT INTO `user_login_log` VALUES (1345, '18227984841', 0, '220.194.88.252', '{\"username\":\"18227984841\"}', '账号或者密码错误', 0, 1608097213, 1608097213);
INSERT INTO `user_login_log` VALUES (1346, '18227984841', 0, '101.89.34.244', '{\"username\":\"18227984841\",\"timestamp\":1608097394}', '账号或者密码错误', 0, 1608097394, 1608097394);
INSERT INTO `user_login_log` VALUES (1347, '991899182@qq.com', 0, '123.151.144.103', '{\"username\":\"991899182@qq.com\",\"timestamp\":1608097446}', '登录成功', 1, 1608097446, 1608097446);
INSERT INTO `user_login_log` VALUES (1348, '18227984841', 0, '123.151.144.103', '{\"username\":\"18227984841\",\"timestamp\":1608098179}', '账号或者密码错误', 0, 1608098179, 1608098179);
INSERT INTO `user_login_log` VALUES (1349, '18227984841', 0, '101.89.34.243', '{\"username\":\"18227984841\",\"timestamp\":1608098187}', '账号或者密码错误', 0, 1608098187, 1608098187);
INSERT INTO `user_login_log` VALUES (1350, '991899182@qq.com', 0, '101.89.34.243', '{\"username\":\"991899182@qq.com\",\"timestamp\":1608098194}', '登录成功', 1, 1608098195, 1608098195);
INSERT INTO `user_login_log` VALUES (1351, 'lyingjack', 0, '123.151.144.18', '{\"username\":\"lyingjack\"}', '账号或者密码错误', 0, 1608113426, 1608113426);
INSERT INTO `user_login_log` VALUES (1352, 'lyingjack', 0, '220.194.88.252', '{\"username\":\"lyingjack\"}', '登录成功', 1, 1608113434, 1608113434);
INSERT INTO `user_login_log` VALUES (1353, 'lyingjack', 0, '220.194.88.252', '{\"username\":\"lyingjack\"}', '登录成功', 1, 1608114499, 1608114499);
INSERT INTO `user_login_log` VALUES (1354, 'lyingjack', 0, '101.91.24.25', '{\"username\":\"lyingjack\"}', '登录成功', 1, 1608114558, 1608114558);
INSERT INTO `user_login_log` VALUES (1355, 'lyingjack', 0, '123.151.144.18', '{\"username\":\"lyingjack\"}', '登录成功', 1, 1608114673, 1608114673);
INSERT INTO `user_login_log` VALUES (1356, '13708021643', 0, '220.194.88.217', '{\"username\":\"13708021643\"}', '登录成功', 1, 1608142524, 1608142524);
INSERT INTO `user_login_log` VALUES (1357, '487689854@qq.com', 0, '101.89.34.225', '{\"username\":\"487689854@qq.com\",\"timestamp\":1608175666}', '登录成功', 1, 1608175665, 1608175665);
INSERT INTO `user_login_log` VALUES (1358, '991899182@qq.com', 0, '220.194.88.252', '{\"username\":\"991899182@qq.com\"}', '登录成功', 1, 1608177841, 1608177841);
INSERT INTO `user_login_log` VALUES (1359, '13666666666', 0, '223.166.151.125', '{\"username\":\"13666666666\"}', '登录成功', 1, 1608189373, 1608189373);
INSERT INTO `user_login_log` VALUES (1360, 'adminkan', 0, '123.151.144.103', '{\"username\":\"adminkan\"}', '账号或者密码错误', 0, 1608192640, 1608192640);
INSERT INTO `user_login_log` VALUES (1361, 'adminkan', 0, '123.151.144.103', '{\"username\":\"adminkan\"}', '账号或者密码错误', 0, 1608192642, 1608192642);
INSERT INTO `user_login_log` VALUES (1362, 'admin', 0, '123.151.144.103', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1608192648, 1608192648);
INSERT INTO `user_login_log` VALUES (1363, 'demo', 0, '220.194.88.144', '{\"username\":\"demo\"}', '登录成功', 1, 1608192695, 1608192695);
INSERT INTO `user_login_log` VALUES (1364, '15342556269', 0, '61.151.164.63', '{\"username\":\"15342556269\",\"phone\":\"15342556269\",\"code\":\"276118\"}', '登录成功', 1, 1608195743, 1608195743);
INSERT INTO `user_login_log` VALUES (1365, '18181408136', 0, '220.194.88.252', '{\"code\":\"497392\",\"repassword\":\"123456\",\"username\":\"18181408136\"}', '登录成功', 1, 1608195774, 1608195774);
INSERT INTO `user_login_log` VALUES (1366, '15342556269', 1, '101.89.27.209', '{\"phone\":\"15342556269\",\"code\":\"844412\"}', '登录成功', 1, 1608195851, 1608195851);
INSERT INTO `user_login_log` VALUES (1367, '18181408136', 0, '101.91.24.25', '{\"username\":\"18181408136\"}', '登录成功', 1, 1608195866, 1608195866);
INSERT INTO `user_login_log` VALUES (1368, 'demo', 0, '101.89.32.18', '{\"username\":\"demo\"}', '登录成功', 1, 1608213026, 1608213026);
INSERT INTO `user_login_log` VALUES (1369, 'kiro', 0, '61.151.164.124', '{\"username\":\"kiro\"}', '登录成功', 1, 1608277566, 1608277566);
INSERT INTO `user_login_log` VALUES (1370, '18181408136', 0, '220.194.88.252', '{\"username\":\"18181408136\"}', '登录成功', 1, 1608280786, 1608280786);
INSERT INTO `user_login_log` VALUES (1371, '513743203@qq.com', 0, '101.89.34.225', '{\"username\":\"513743203@qq.com\",\"timestamp\":1608293716}', '登录成功', 1, 1608293717, 1608293717);
INSERT INTO `user_login_log` VALUES (1372, '15882578524', 0, '220.194.88.252', '{\"username\":\"15882578524\"}', '账号或者密码错误', 0, 1608298874, 1608298874);
INSERT INTO `user_login_log` VALUES (1373, '15882578525', 0, '123.151.144.18', '{\"username\":\"15882578525\"}', '账号或者密码错误', 0, 1608298880, 1608298880);
INSERT INTO `user_login_log` VALUES (1374, '15882578525', 0, '220.194.88.217', '{\"username\":\"15882578525\"}', '账号或者密码错误', 0, 1608298893, 1608298893);
INSERT INTO `user_login_log` VALUES (1375, '15882478524', 1, '101.91.24.25', '{\"username\":\"15882478524\",\"phone\":\"15882478524\",\"email\":null,\"code\":\"708240\",\"refcode\":null}', '登录成功', 1, 1608298934, 1608298934);
INSERT INTO `user_login_log` VALUES (1376, '15882478524', 0, '220.194.88.217', '{\"username\":\"15882478524\"}', '登录成功', 1, 1608298989, 1608298989);
INSERT INTO `user_login_log` VALUES (1377, 'kiro', 0, '101.89.32.18', '{\"username\":\"kiro\"}', '登录成功', 1, 1608299195, 1608299195);
INSERT INTO `user_login_log` VALUES (1378, '15882478525', 0, '101.91.24.25', '{\"username\":\"15882478525\"}', '登录成功', 1, 1608299436, 1608299436);
INSERT INTO `user_login_log` VALUES (1379, '151506687648', 0, '101.89.34.225', '{\"username\":\"151506687648\",\"timestamp\":1608307782}', '账号或者密码错误', 0, 1608307783, 1608307783);
INSERT INTO `user_login_log` VALUES (1380, '18181408136', 0, '123.151.144.18', '{\"username\":\"18181408136\"}', '登录成功', 1, 1608369460, 1608369460);
INSERT INTO `user_login_log` VALUES (1381, '17340159856', 0, '101.89.34.231', '{\"code\":\"898056\",\"refcode\":null,\"username\":\"17340159856\"}', '登录成功', 1, 1608385340, 1608385340);
INSERT INTO `user_login_log` VALUES (1382, '17340159856', 0, '123.151.144.114', '{\"username\":\"17340159856\"}', '登录成功', 1, 1608385351, 1608385351);
INSERT INTO `user_login_log` VALUES (1383, 'kiro', 0, '61.151.164.124', '{\"username\":\"kiro\"}', '登录成功', 1, 1608385365, 1608385365);
INSERT INTO `user_login_log` VALUES (1384, 'kiro', 0, '61.151.164.124', '{\"username\":\"kiro\"}', '登录成功', 1, 1608387090, 1608387090);
INSERT INTO `user_login_log` VALUES (1385, 'admin', 0, '101.89.32.18', '{\"username\":\"admin\"}', '登录成功', 1, 1608387583, 1608387583);
INSERT INTO `user_login_log` VALUES (1386, 'admin', 0, '123.151.144.103', '{\"username\":\"admin\"}', '登录成功', 1, 1608387587, 1608387587);
INSERT INTO `user_login_log` VALUES (1387, 'kiro', 0, '101.89.27.156', '{\"username\":\"kiro\"}', '登录成功', 1, 1608388671, 1608388671);
INSERT INTO `user_login_log` VALUES (1388, 'kiro', 0, '101.89.34.239', '{\"username\":\"kiro\"}', '登录成功', 1, 1608391602, 1608391602);
INSERT INTO `user_login_log` VALUES (1389, 'demo', 0, '101.89.32.18', '{\"username\":\"demo\"}', '登录成功', 1, 1608430569, 1608430569);
INSERT INTO `user_login_log` VALUES (1390, '13800138000', 0, '123.151.144.114', '{\"username\":\"13800138000\"}', '登录成功', 1, 1608430938, 1608430938);
INSERT INTO `user_login_log` VALUES (1391, '13666666666', 0, '116.128.128.92', '{\"username\":\"13666666666\"}', '登录成功', 1, 1608439830, 1608439830);
INSERT INTO `user_login_log` VALUES (1392, 'admin', 0, '123.151.144.103', '{\"username\":\"admin\"}', '登录成功', 1, 1608440241, 1608440241);
INSERT INTO `user_login_log` VALUES (1393, '18181408136', 0, '220.194.88.217', '{\"username\":\"18181408136\"}', '登录成功', 1, 1608454125, 1608454125);
INSERT INTO `user_login_log` VALUES (1394, '15882478524', 0, '220.194.88.217', '{\"username\":\"15882478524\"}', '登录成功', 1, 1608455433, 1608455433);
INSERT INTO `user_login_log` VALUES (1395, '13666666666', 0, '101.89.34.214', '{\"username\":\"13666666666\"}', '账号或者密码错误', 0, 1608466008, 1608466008);
INSERT INTO `user_login_log` VALUES (1396, '13666666666', 0, '59.36.95.43', '{\"username\":\"13666666666\"}', '登录成功', 1, 1608466012, 1608466012);
INSERT INTO `user_login_log` VALUES (1397, '13666666666', 0, '116.128.128.91', '{\"username\":\"13666666666\"}', '登录成功', 1, 1608478986, 1608478986);
INSERT INTO `user_login_log` VALUES (1398, 'kiro', 0, '101.89.34.226', '{\"username\":\"kiro\"}', '账号或者密码错误', 0, 1608514142, 1608514142);
INSERT INTO `user_login_log` VALUES (1399, 'kiro', 0, '101.89.34.226', '{\"username\":\"kiro\"}', '登录成功', 1, 1608514148, 1608514148);
INSERT INTO `user_login_log` VALUES (1400, 'admin', 0, '101.89.34.225', '{\"username\":\"admin\"}', '登录成功', 1, 1608521308, 1608521308);
INSERT INTO `user_login_log` VALUES (1401, 'kiro', 0, '101.89.34.225', '{\"username\":\"kiro\"}', '登录成功', 1, 1608521353, 1608521353);
INSERT INTO `user_login_log` VALUES (1402, 'admin', 0, '101.89.34.226', '{\"username\":\"admin\"}', '账号或者密码错误', 0, 1608521391, 1608521391);
INSERT INTO `user_login_log` VALUES (1403, 'admin', 0, '101.89.34.226', '{\"username\":\"admin\"}', '登录成功', 1, 1608521396, 1608521396);
INSERT INTO `user_login_log` VALUES (1404, '13666666666', 0, '220.194.88.217', '{\"username\":\"13666666666\"}', '登录成功', 1, 1608563530, 1608563530);
INSERT INTO `user_login_log` VALUES (1405, '18181408136', 0, '220.194.88.217', '{\"username\":\"18181408136\"}', '登录成功', 1, 1608619754, 1608619754);

-- ----------------------------
-- Table structure for user_tags
-- ----------------------------
DROP TABLE IF EXISTS `user_tags`;
CREATE TABLE `user_tags`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `type` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '标签分类0其他1优点2缺点',
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '标签名称',
  `sort` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '排序',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT 1 COMMENT '状态0:删除1:开启',
  `updated_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '更新时间',
  `created_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 28 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '用户标签表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of user_tags
-- ----------------------------
INSERT INTO `user_tags` VALUES (21, 1, '测试1', 0, 2, 1589815541, 1589646744);
INSERT INTO `user_tags` VALUES (22, 1, '测试2', 2, 2, 1589815563, 1589646755);
INSERT INTO `user_tags` VALUES (23, 1, '测试3', 0, 2, 1589815573, 1589815573);
INSERT INTO `user_tags` VALUES (24, 1, '测试4', 0, 2, 1589815581, 1589815581);
INSERT INTO `user_tags` VALUES (25, 2, '测试5', 0, 2, 1589815589, 1589815589);
INSERT INTO `user_tags` VALUES (26, 2, '测试6', 0, 2, 1589815597, 1589815597);
INSERT INTO `user_tags` VALUES (27, 2, '测试7', 0, 2, 1589815612, 1589815612);

-- ----------------------------
-- Table structure for user_vip_log
-- ----------------------------
DROP TABLE IF EXISTS `user_vip_log`;
CREATE TABLE `user_vip_log`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `user_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '关联用户id',
  `shop_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '关联vip商品id',
  `amount` decimal(10, 2) NOT NULL DEFAULT 0.00 COMMENT '总价',
  `pay_type` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '支付方式1:微信2:支付宝3:其他',
  `pay_order_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '支付第三方order_id',
  `ip` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT 'IP',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT 1 COMMENT '状态1待付款2已付款',
  `updated_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '更新时间',
  `created_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `type`(`shop_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'VIP开通日志表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for user_vip_shop
-- ----------------------------
DROP TABLE IF EXISTS `user_vip_shop`;
CREATE TABLE `user_vip_shop`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `type` tinyint(1) NOT NULL COMMENT '分类1:开通会员2:开通代理',
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '商品名称',
  `price` decimal(10, 2) NOT NULL DEFAULT 0.00 COMMENT '价格',
  `icon` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '图标',
  `desc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '描述',
  `sort` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '排序',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT 1 COMMENT '状态0:删除1:开启',
  `updated_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '更新时间',
  `created_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `type`(`type`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'VIP商品表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for user_withdraw_log
-- ----------------------------
DROP TABLE IF EXISTS `user_withdraw_log`;
CREATE TABLE `user_withdraw_log`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `user_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '关联user_id',
  `type` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '分类1余额2积分3金币',
  `amount` decimal(10, 2) NOT NULL DEFAULT 0.00 COMMENT '金额',
  `integral` int(10) NOT NULL DEFAULT 0 COMMENT '积分',
  `gold` int(10) NOT NULL DEFAULT 0 COMMENT '金币',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '状态1:待审核2审核通过',
  `updated_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '更新时间',
  `created_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `user_id`(`user_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '用户提现记录表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for users
-- ----------------------------
DROP TABLE IF EXISTS `users`;
CREATE TABLE `users`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `username` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '用户名',
  `phone` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '手机号码',
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '邮箱',
  `password` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '密码',
  `nickname` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '昵称名称',
  `avatar` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '头像',
  `refcode` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '推荐码',
  `truename` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '真实姓名',
  `qq` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT 'QQ',
  `sex` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '性别0保密1男2女',
  `birthday` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '生日',
  `amount` decimal(10, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '账户余额',
  `integral` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '积分',
  `gold` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '金币',
  `heat` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '热度',
  `grade` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '等级',
  `alipay_account_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '支付宝账户名称',
  `alipay_account` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '支付宝账户',
  `vip_end_time` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT 'VIP过期时间',
  `position` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '职位描述',
  `desc` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '描述简介',
  `pid` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '推荐人ID',
  `level` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '推荐上级别',
  `is_auth` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'NO' COMMENT '是否认证',
  `is_audio` tinyint(1) NOT NULL DEFAULT 1 COMMENT '是否开通语音',
  `api_token` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT 'token',
  `wx_openid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '微信openid',
  `qq_openid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT 'QQopenid',
  `wb_openid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '微博openid',
  `device_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '设备ID',
  `is_admin` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '是否管理员',
  `is_super` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '是否超级管理员0:否,1:是',
  `last_login_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '最后登录时间',
  `tags` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '标签',
  `can_live` tinyint(1) NOT NULL DEFAULT 0 COMMENT '是否可以直播',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT 1 COMMENT '状态0:删除1:正常2:禁用',
  `updated_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '更新时间',
  `created_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `username`(`username`) USING BTREE,
  INDEX `phone`(`phone`) USING BTREE,
  INDEX `email`(`email`) USING BTREE,
  INDEX `refcode`(`refcode`) USING BTREE,
  INDEX `device_id`(`device_id`(191)) USING BTREE,
  INDEX `created_at`(`created_at`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 165 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '用户表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of users
-- ----------------------------
INSERT INTO `users` VALUES (1, 'kiro', '18656687900', 'ztao8@qq.com', '$2y$10$pAGHIGwhhaCdi8hvO217auat7KJsRHnvsmg5BJccknQ9.ADCU8u/q', '我真的是管理员', '', 'AjhdwE', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 1709459200, '', '', 0, '', 'NO', 0, 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJodHRwczpcL1wvcWluZ3RpbmdhcGkueW91eWFjYW8uY29tXC9hZG1pbi1hcGlcL3YxXC91c2VyIiwiaWF0IjoxNjA4NTIxMzUzLCJleHAiOjE2MDg2NTI5NjYsIm5iZiI6MTYwODYxNjk2NiwianRpIjoieE42bWpBb2tLTWpFUXF3aCIsInN1YiI6MSwicHJ2IjoiMjNiZDVjODk0OWY2MDBhZGIzOWU3MDFjNDAwODcyZGI3YTU5NzZmNyJ9.lK5b-dRfThC-cRZ-k5PDnyWBbXPocIeEEdxvEIIj0Ns', '', '', '', '', 1, 1, '2020-12-22 06:02:46', '', 1, 1, 1608616966, 1584341332);
INSERT INTO `users` VALUES (2, 'admin', '18656687904', 'xinxing@qq.com', '$2y$10$ZdAZLXSGQp9tiWc.bAdKvujsD9YU99vTHW2XSz8cZf/8GW02MowBm', '我是管理员', '', 'adkePJ', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 1609459200, '', '', 0, '', 'NO', 0, 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJodHRwczpcL1wvcWluZ3RpbmdhcGkueW91eWFjYW8uY29tXC9hZG1pbi1hcGlcL3YxXC91c2VyIiwiaWF0IjoxNjA4NDQwMjQxLCJleHAiOjE2MDg1NTcyODgsIm5iZiI6MTYwODUyMTI4OCwianRpIjoiTkZuNm00QkcwaHFNUEJFNyIsInN1YiI6MiwicHJ2IjoiMjNiZDVjODk0OWY2MDBhZGIzOWU3MDFjNDAwODcyZGI3YTU5NzZmNyJ9.RjRZT9a97u4gf7PiRXHrMDpvYeVz8v0X8Oyb2p_EXMU', '', '', '', '', 1, 0, '2020-12-20 19:29:56', '', 0, 1, 1608521396, 1584501817);
INSERT INTO `users` VALUES (3, 'editor', '18888888888', '', '$2y$10$LEXTVoTBEyST6uwdfBSyvegUwJ4twCmEpLmOuudrB2YgjbPP32bEq', '我是测试员', '', 'PbYPL2', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 1609459200, '', '', 0, '', 'NO', 0, '', '', '', '', '', 1, 0, '2020-06-27 06:49:54', '', 0, 0, 1593240594, 1585580139);
INSERT INTO `users` VALUES (4, 'demo', '15882478524', '', '$2y$10$EnkF92RVULnd42mrIwbwxuzbe2n3Q3n0xPX3.xouDuO1rcHhZhTRm', '', '', '1fIywY', '', '', 1, '1992-04-28', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJodHRwczpcL1wvcWluZ3RpbmdhcGkueW91eWFjYW8uY29tXC9hcGlcL3YxXC91c2VyIiwiaWF0IjoxNjA3OTMwOTcwLCJleHAiOjE2MDgzMzQ4NjAsIm5iZiI6MTYwODI5ODg2MCwianRpIjoiMEJ3WHNHaEdqWGNKeWtGNSIsInN1YiI6NCwicHJ2IjoiMjNiZDVjODk0OWY2MDBhZGIzOWU3MDFjNDAwODcyZGI3YTU5NzZmNyJ9.MxLxgskXg9_UAwUWrJxXBMKrroyjP19fOsyxZ-FN4HE', '', '', '', '', 1, 0, '2020-12-20 01:10:33', '', 0, 1, 1608455433, 1586878488);
INSERT INTO `users` VALUES (5, '197032148', '15882478525', '', '$2y$10$OV8NhXC0MmfJIRhDfmyGxufcv6teWgccm9UDLLzMNSucsRpjXZ0du', 'ck56781', '', 'fMJzUY', '吴银满', '666666', 1, '', 0.00, 0, 0, 0, 0, '', '', 1609372800, '', '我是一颗小小的石头～', 5, '', 'NO', 0, 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJodHRwczpcL1wvcWluZ3RpbmdhcGkueW91eWFjYW8uY29tXC9hcGlcL3YxXC91c2VyIiwiaWF0IjoxNjA3ODQ3NjM0LCJleHAiOjE2MDc5NjY5NDUsIm5iZiI6MTYwNzkzMDk0NSwianRpIjoiSkswaXpLQ1FRUHM0cFZjeiIsInN1YiI6NSwicHJ2IjoiMjNiZDVjODk0OWY2MDBhZGIzOWU3MDFjNDAwODcyZGI3YTU5NzZmNyJ9.pJtjeVsGrjnEXwN88h1wHS753nVrT7xiPRbIy3A2jfc', '', '', '', '', 0, 0, '2020-12-18 13:51:30', '', 1, 1, 1608299490, 1586881294);
INSERT INTO `users` VALUES (6, '139865247', '18217199582', '', '$2y$10$s/Eakt5QSY/09.w1/tbT8.58DFgGAedC.pm6FPojBj6JuaxVJJPI.', '', '', 'wjyVIX', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJodHRwOlwvXC9xdC1hcGkueXVueWluZ2luZy5jb21cL2FwaVwvdjFcL3VzZXIiLCJpYXQiOjE1ODcwOTM3MjksImV4cCI6MTU4ODEwMTY0MCwibmJmIjoxNTg4MDk4MDQwLCJqdGkiOiI2eEp0R0NFOW5ZM3lXa1dpIiwic3ViIjoxMDAwNSwicHJ2IjoiMjNiZDVjODk0OWY2MDBhZGIzOWU3MDFjNDAwODcyZGI3YTU5NzZmNyJ9.ZvJhNVFZRFqaq_PZQnb1DIH-fl-e6XaQ4UsjXu3BZrQ', '', '', '', '', 0, 0, '2020-05-30 08:36:19', '', 0, 1, 1588098040, 1587093714);
INSERT INTO `users` VALUES (7, '183970462', '16639009130', '', '$2y$10$5gghIRI.o2ciMebBVx7jW.T9r9mrJnTVYJvf13JgWbvVJe7w05qsq', '', '', '4s01k0', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-30 08:36:19', '', 0, 1, 1587272322, 1587272310);
INSERT INTO `users` VALUES (8, '106983417', '18689896575', '', '$2y$10$72gISwE/vVuKr/O3DrrLE.77pR0U8egBwW8QdZlR1BR6Z01P/sOee', '', '', 'Iyd5s2', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-30 08:36:19', '', 0, 1, 1587281646, 1587281641);
INSERT INTO `users` VALUES (9, '169748531', '13666666666', '', '$2y$10$MOkqjtCG7RFTTLr.aZD46utqcATi4w/6XHRdWOV/hwWM7YnrAkpOO', '', '', 'xErzCG', '', '', 1, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJodHRwczpcL1wvcWluZ3RpbmdhcGkueW91eWFjYW8uY29tXC9hcGlcL3YxXC91c2VyIiwiaWF0IjoxNjA4NDM5ODMwLCJleHAiOjE2MDg2NDcwMTMsIm5iZiI6MTYwODYxMTAxMywianRpIjoiVk1EcVd0aEUwb0tnR0JTeiIsInN1YiI6OSwicHJ2IjoiMjNiZDVjODk0OWY2MDBhZGIzOWU3MDFjNDAwODcyZGI3YTU5NzZmNyJ9.BkF0ixdMYmhVwiS5H4msLNRs1X4bIvPuPSAr4DlGFAE', '', '', '', '', 0, 0, '2020-12-22 04:23:33', '', 1, 1, 1608611013, 1587293563);
INSERT INTO `users` VALUES (10, '190465132', '13247126549', '', '$2y$10$7TzcFHOJj33wi9x0b8yzxOgYhKG5YkP0IZ49D/LW2o45kLzvPxvK.', '', '', 'hWeVH3', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-30 08:36:19', '', 0, 1, 1587295071, 1587295064);
INSERT INTO `users` VALUES (11, '153041896', '18988643266', '', '$2y$10$3BJsR7sRxIw3bRQZbKKm7.UcucV12Uv6iRxuXuWyUfI7C6DXbwEMy', '', '', '6mg1H5', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-30 08:36:19', '', 0, 1, 1587385223, 1587385223);
INSERT INTO `users` VALUES (12, '130256891', '18866332255', '', '$2y$10$36LDwIGoCyRJnl5xknSI9eLxR7fPZ6xqrRF4klq63NsaAcvwcSjRq', '', '', 'pVMIxl', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-30 08:36:19', '', 0, 1, 1587385261, 1587385252);
INSERT INTO `users` VALUES (13, '107829431', '', 'guopeihaoduiab@qq.com', '$2y$10$QSldeZr1YV3aESCJBmaVzub9vR/2XXm5rI9BM4JOE72xBrFbEjKA.', '', '', 'c1wvFH', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJodHRwOlwvXC9xdC1hcGkueXVueWluZ2luZy5jb21cL2FwaVwvdjFcL2NvbGxlY3RcL21lIiwiaWF0IjoxNTg3NTE3NDg3LCJleHAiOjE1ODgzNDQ1ODUsIm5iZiI6MTU4ODM0MDk4NSwianRpIjoiSkVBNHBuZDNrTEhvTExEcSIsInN1YiI6MTAwMTIsInBydiI6IjIzYmQ1Yzg5NDlmNjAwYWRiMzllNzAxYzQwMDg3MmRiN2E1OTc2ZjcifQ.i4Sno3lKi2dfGhR4lg3afLaOXfZdFko_MRwBeo2h4y4', '', '', '', '', 0, 0, '2020-05-30 08:36:19', '', 0, 1, 1588340985, 1587479656);
INSERT INTO `users` VALUES (14, '129573804', '', 'guopeihaodui@eknnwb.cms', '$2y$10$2K87fojz0tbYZXPUgEqAuOdWKba4W3BpcpYcbv/ZTvuHK26cuR0e6', '', '', '1ikMPH', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-30 08:36:19', '', 0, 1, 1587517424, 1587517424);
INSERT INTO `users` VALUES (15, '108179236', '18500567129', '', '$2y$10$n2VLvA34hflRGRWNjwTjDudanH2u3k42FwsQQK4PmTih5E0g5yM7W', '', '', 'XvHKcB', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-30 08:36:19', '', 0, 1, 1587619270, 1587619257);
INSERT INTO `users` VALUES (16, '176298501', '13708021643', '', '$2y$10$2Qo.zwRzYnrFYrTXljBiPOsdkBII24jLBgyAKlpXjrq65G9HfQLS.', '', '', 'FEPewd', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJodHRwOlwvXC9oNWFwaS5tb3JuZmxvdy5jb21cL2FwaVwvdjFcL2NvbGxlY3RcL21lIiwiaWF0IjoxNTk0NjQzNjUzLCJleHAiOjE1OTQ2OTEzMzMsIm5iZiI6MTU5NDY4NzczMywianRpIjoiWGRWYWFnZlRIUmp6MndMbiIsInN1YiI6MTYsInBydiI6IjIzYmQ1Yzg5NDlmNjAwYWRiMzllNzAxYzQwMDg3MmRiN2E1OTc2ZjcifQ.jWW-r8coAypNMuNATMdkM-_3M-6f6USDoVbkRoBWgIg', '', '', '', '', 0, 0, '2020-12-16 10:15:24', '', 0, 1, 1608142524, 1587714543);
INSERT INTO `users` VALUES (17, '115697302', '15890182202', '', '$2y$10$8ogS6MJOVgC2ABefRiT1OOvkOQ.rnmpNqj9ai1O/7FIhXkjplvYEm', '', '', 'Y9hqZV', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJodHRwOlwvXC9xdC1hcGkueXVueWluZ2luZy5jb21cL2FwaVwvdjFcL3VzZXIiLCJpYXQiOjE1ODc3Mzc5MjAsImV4cCI6MTU4Nzc5ODQ3OCwibmJmIjoxNTg3Nzk0ODc4LCJqdGkiOiIyYlhTbHM4bzBTSGNiRFJhIiwic3ViIjoxMDAxNiwicHJ2IjoiMjNiZDVjODk0OWY2MDBhZGIzOWU3MDFjNDAwODcyZGI3YTU5NzZmNyJ9.QouNAmthwtkuUWltJeKrga7PflBAcDt2l6xqBNp4c4w', '', '', '', '', 0, 0, '2020-05-30 08:36:19', '', 0, 1, 1587794878, 1587737908);
INSERT INTO `users` VALUES (18, '135980124', '18788845685', '', '$2y$10$QpHugW.aee/nwaYX36f9RukGPD.Cu.HpNSntvX1GNCFon2O4xgtHS', '', '', 'bPp31Z', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-30 08:36:19', '', 0, 1, 1587791433, 1587791425);
INSERT INTO `users` VALUES (19, '191346587', '13904054000', '', '$2y$10$5bVYb83rWNAFkJSqvG1p4Oe4SpsSFBehtZmOgTmcOoPqsxCyOtUIy', '', '', 'WXazQK', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-30 08:36:19', '', 0, 1, 1587836319, 1587836319);
INSERT INTO `users` VALUES (20, '197315240', '13333333333', '', '$2y$10$66CxvM73iGmzIKJPmIq00ubMd9Rt6FZcRqKonEsFXu43rEoMj3HgK', '', '', 'UJi3sh', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-30 08:36:19', '', 0, 1, 1587836339, 1587836333);
INSERT INTO `users` VALUES (21, '146109732', '', '3103971529@qq.com', '$2y$10$QlMIYTuOwnDaVfchDWiBhOr4kOhtML1Yi.WmiRn2WqmRo5VHBUgia', '', '', 'esTJ7t', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-30 08:36:19', '', 0, 1, 1587837811, 1587837792);
INSERT INTO `users` VALUES (22, '161593207', '13800138000', '', '$2y$10$9ISgZ27iNtasN2KGLVds.O8I4.Y6Bg..TRgA.QThAeoD6NK4B/30W', '', '', 'wcs8Gw', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-12-19 18:22:18', '', 0, 1, 1608430938, 1587858781);
INSERT INTO `users` VALUES (23, 'test', '', '', '$2y$10$8XBMCTnhoLkLT9OehO2wv.7ZR3DBVhKiMz/ZlL1l5X0QIuiL7MsmO', '', '', '', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 1, 0, '2020-05-09 05:07:43', '', 0, 0, 1587878887, 1587878870);
INSERT INTO `users` VALUES (25, '149130567', '', '1369166171@qq.com', '$2y$10$UQSaa4ZoXPsstVvZT27gC.3hGWUuT6RzssruuEntAJBQ84ptAVUpa', '', '', 'gGVFAt', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-30 08:36:19', '', 0, 1, 1587896271, 1587896271);
INSERT INTO `users` VALUES (26, '129510347', '13917441782', '', '$2y$10$QawsnqxywxlmAADnO/9DS.rVNEYheAjlMlV3Al.1yMhjWzSwHqzGa', '昵称叫JoJoo', 'qiniu_202007021134232003840734.jpg?imageView2/1/w/800/h/800', 'uArNEH', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '90后\n喜爱安静\n?\n商务合作请私信\n123.abc\n哈\n哈\n哈', 0, '', 'NO', 0, 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJodHRwOlwvXC9hcGkueGlueGluZy5ydW5cL2FwaVwvdjFcL3VzZXIiLCJpYXQiOjE1OTM2ODk1NTEsImV4cCI6MTU5NDEzMzQ1OCwibmJmIjoxNTk0MDk3NDU4LCJqdGkiOiJNVDVYdldFd3BrUHQyaXNYIiwic3ViIjoyNiwicHJ2IjoiMjNiZDVjODk0OWY2MDBhZGIzOWU3MDFjNDAwODcyZGI3YTU5NzZmNyJ9.JVHJ0-PTCauMBTA85f9DBXzBbj9Ay_n_x6EnJwaGHRA', '', '', '', '', 0, 0, '2020-07-07 04:50:58', '', 0, 1, 1594097458, 1587989064);
INSERT INTO `users` VALUES (27, '137246095', '13878945612', '', '$2y$10$nw2eKUaUHCbyre79yefRS.6qI0A9MgONe3Q3Q9U2zN4zPV7C0bd2O', '', '', 'TmASLr', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-30 08:36:19', '', 0, 1, 1588093516, 1588093516);
INSERT INTO `users` VALUES (28, '128576409', '13312345678', '', '$2y$10$QHXMR8ZQ5ZV10owBv7oUGO1mot3chDU2uTBjfqJ9ig0VIlvMyLb3S', '', '', 'zANsqT', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-30 08:36:19', '', 0, 1, 1588093554, 1588093544);
INSERT INTO `users` VALUES (29, '191584273', '15610102020', '', '$2y$10$EN3JtKaAA85fH0P8qSfZD.6IaJRrOnTdCn1DxiT.ALDQBImZQK5MC', '', '', 'ePJ1es', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-30 08:36:19', '', 0, 1, 1588171087, 1588171082);
INSERT INTO `users` VALUES (30, '157193086', '13311210771', '', '$2y$10$NaUgnqkfhU8/MLOSRBvOPei0VBxkkruh/2O0/VKYzHV9lg0aovxxW', '', '', 'CPE66P', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-30 08:36:19', '', 0, 1, 1588404859, 1588404840);
INSERT INTO `users` VALUES (31, '132684017', '', '123456789@qq.com', '$2y$10$G8pMvtg/jaUxQm5gLOVavemOK9W4nql3AEYLjZWKjDwly.b.QJav2', '', '', 'qeFq9D', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-30 08:36:19', '', 0, 1, 1588484836, 1588484836);
INSERT INTO `users` VALUES (32, '136079128', '15000002222', '', '$2y$10$xrwrQGlQtk4r1fHb4s9OWu.4LS7i1QCS0/KsQlgryGz205upi4/1e', '', '', '9Sxd5T', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-30 08:36:19', '', 0, 1, 1588484870, 1588484870);
INSERT INTO `users` VALUES (33, '162013759', '15015001500', '', '$2y$10$.rEIYYBUgN76eJl2RD8eWeLAT3rzzd70xBhzb0W1A36x6emRx6jC.', '', '', 'DFTQMy', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-30 08:36:19', '', 0, 1, 1588484906, 1588484898);
INSERT INTO `users` VALUES (34, '195862374', '17723850770', '', '$2y$10$KLLRqfggq0hm7PfGacOnTONPYBCx4gilrnSOmgSV6u1Rrkx.NVyha', '', '', 'UkeSl2', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-30 08:36:19', '', 0, 1, 1588599559, 1588599537);
INSERT INTO `users` VALUES (35, '165037412', '13661947250', '', '$2y$10$bSaj91pb9Y9N7fhJGoG/humv78JVI5xtlmOXNAY/tu4LeBbsiD9I6', '', '', 'IDpxqN', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '你好', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-30 08:36:19', '', 0, 1, 1588667362, 1588667074);
INSERT INTO `users` VALUES (36, '108147236', '13800123456', '', '$2y$10$doUop9vAyZI3O2yzoVr9/euN48MWo/21Of8qOn.qfjfbG22SI9YD2', '', '', 'mRAfqr', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-30 08:36:19', '', 0, 1, 1588672781, 1588672169);
INSERT INTO `users` VALUES (37, '174082569', '', 'wuke567054556@163.com', '$2y$10$E/mI4B.xzBB.Sk0BtQF6Ce2GThI0r8u2Xld52JCE5wymXKuLWhhdS', '', '', 'xwsaWP', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-30 08:36:19', '', 0, 1, 1588675440, 1588675420);
INSERT INTO `users` VALUES (38, '187201536', '', '1234567895@qq.com', '$2y$10$Me/1jER4/RobUcDt0Y/dpu.fKAOEUlKuU4v/Ij9TrKgPLflOCG8z2', '', '', 'gbZdb4', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-30 08:36:19', '', 0, 1, 1588745687, 1588745669);
INSERT INTO `users` VALUES (39, '174056381', '13611252848', '', '$2y$10$wZ6N8w5hyoEDkqt9vnU7zeeU3HYz1EXn5rnWYZ5dukdchRD6mNjsi', '', '', 'HpX1Ez', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-30 08:36:19', '', 0, 1, 1588758875, 1588758857);
INSERT INTO `users` VALUES (40, '165047312', '18593944351', '', '$2y$10$RqN6OzraKyAinviRVFcQquqVaqGr4kJ00gXr3sszGLVswqVKpCJGu', '', '', 'yVS5aN', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-30 08:36:19', '', 0, 1, 1588811955, 1588811944);
INSERT INTO `users` VALUES (41, '162073894', '18720255828', '', '$2y$10$AGYTZAk/Msu8tIpmF8SkIe2ZNtnBjmRoP2oDzzHPq46IYafzSQU..', '', '', 'ZgsszQ', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-30 08:36:19', '', 0, 1, 1588816051, 1588816037);
INSERT INTO `users` VALUES (42, '127910865', '13111111111', '', '$2y$10$1jQf.SmCqmbwhHOvmqQPRe8bgT3nHStR7GV/NF0R1N8UW51ePbj9O', '', '', '1Ax7Xy', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-30 08:36:19', '', 0, 1, 1588927817, 1588927808);
INSERT INTO `users` VALUES (43, '145701928', '', 'hlj520123@hotmail.com', '$2y$10$knuP9Un0nt8fKKEjzNjFw.Y4XyPxkCGi0aiWV0ySJo6fRgzAZp1Ia', '', '', 'KmiJ5p', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-30 08:36:19', '', 0, 1, 1588993332, 1588993307);
INSERT INTO `users` VALUES (44, '161450728', '15507946721', '', '$2y$10$T6K2Y1qKMXbiFqyg.W2kB.0Zr8KiLKvgk8i.peszY6.oV6kHn1iq6', '', '', 'pl9pRN', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJodHRwOlwvXC9xdC1hcGkueXVueWluZ2luZy5jb21cL2FwaVwvdjFcL2NvbGxlY3RcL21lIiwiaWF0IjoxNTg5NTIyMTk5LCJleHAiOjE1ODk1MzQ2NjUsIm5iZiI6MTU4OTUzMTA2NSwianRpIjoiTXZWbjIwd0lDdDJuajh0USIsInN1YiI6NDQsInBydiI6IjIzYmQ1Yzg5NDlmNjAwYWRiMzllNzAxYzQwMDg3MmRiN2E1OTc2ZjcifQ._hNqCtQZvURAlX_2giMhiKUdLkIuo8pBD325te4XaTA', '', '', '', '', 0, 0, '2020-05-30 08:36:19', '', 0, 1, 1589553680, 1589015401);
INSERT INTO `users` VALUES (45, '138162490', '18929636347', '', '$2y$10$U/CZBspOmAKn0gZexUqpReKAym9XNk2w5tcYxJ8LzzL21FB1yQgoy', '', '', '1ybciD', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-30 08:36:19', '', 0, 1, 1589066706, 1589066696);
INSERT INTO `users` VALUES (46, '139526704', '15504311017', '', '$2y$10$u1vN6icV7k9dpHlBZyipSONe3cBuIAKgeB7YkvXC9v/7qMOS2/Y0q', '', '', 'uwx3fY', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-30 08:36:19', '', 0, 1, 1589187448, 1589174916);
INSERT INTO `users` VALUES (47, '181063572', '13145204000', '', '$2y$10$FBJRIV/2kcbeAGfPLCatUueMoDyIi3JQfsohY/ptf.x7h3puFolce', '', '', 'FPGKkl', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-30 08:36:19', '', 0, 1, 1589283757, 1589283744);
INSERT INTO `users` VALUES (48, '180249673', '15638118026', '', '$2y$10$bIYtgq4IkNSCgPEtio5Q/OuI2cWrJWG2JkNUAZzQfK4AS.76Iih7W', '', '', 'UEae4E', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-30 08:36:19', '', 0, 1, 1589444762, 1589444711);
INSERT INTO `users` VALUES (49, '127831956', '18660983020', '', '$2y$10$8MPKFplWMq1Sj9eFfKbhWOxzEBc0VGjGrPZlYfyNibetiTaMwGQ1K', '', '', 'BpSBtY', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-30 08:36:19', '', 0, 1, 1589502551, 1589502444);
INSERT INTO `users` VALUES (50, '124763810', '13800338000', '', '$2y$10$sU3CY0BPx32EoxwH1/ER8e/16/ySpSbk7v/bMy5bRcMELaJyzZfQy', '', '', 'zml6TF', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-21 00:37:17', '', 0, 1, 1590021437, 1590021437);
INSERT INTO `users` VALUES (51, '128301956', '13760625332', '', '$2y$10$6N2RvXiMuKl.KinSLdZi8eEf3jXWQk/Q10ajjqcFd8DQDwchTVO7u', '', '', 'eW7A44', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-21 00:11:20', '', 0, 1, 1590048680, 1590048667);
INSERT INTO `users` VALUES (52, '176309152', '13086864754', '', '$2y$10$s0wBoyJoypac0/YbiAbNs.WUmeI/U7di6T6y3z9XbZYYTM1AIvnCK', '', '', 'Wgpu2K', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-21 09:08:38', '', 0, 1, 1590052118, 1590052118);
INSERT INTO `users` VALUES (53, '150481293', '18381087280', '', '$2y$10$u3DPoAii/yWXSFkmqY.M3O/zRs8a3ks1Sb99dgNZ8ft3FuFuQa7FO', '', '', 'AKf2y8', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-22 09:18:54', '', 0, 1, 1590139134, 1590139134);
INSERT INTO `users` VALUES (54, '123578649', '18736292100', '', '$2y$10$gcjp85AtOMzvT2U2xx1yDePfRvxlwKrdAfgjTCes3kQPhv0DJZQr2', '', '', 'cJjRcv', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-24 17:59:30', '', 0, 1, 1590371970, 1590146591);
INSERT INTO `users` VALUES (55, '108529416', '18373166779', '', '$2y$10$8tCzO6xZUJcOowdyinjGzuIkQEodR7YRbo8ZyisCgwi6LljWx/wFK', '', '', 'GI3RYp', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-26 04:19:30', '', 0, 1, 1590495570, 1590495561);
INSERT INTO `users` VALUES (56, '128517069', '', 'zsoft@foxmail.com', '$2y$10$JkkguNZJExKMRUbtGfl58O9JuFfkO3oQ..7YaIIl6LfUs54gB5kQi', '', '', 'VMve4H', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-28 02:18:05', '', 0, 1, 1590632285, 1590632285);
INSERT INTO `users` VALUES (57, '193062745', '18539967405', '', '$2y$10$BiqZ912i2.aIfxYfgX1eEOfl0aGMEK1BqVbyvqCkRxkdGojsu5G9e', '', '', 'dyq6Ph', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-27 18:19:37', '', 0, 1, 1590632377, 1590632366);
INSERT INTO `users` VALUES (58, '126081397', '13911257751', '', '$2y$10$n/vzWxecAmQof2EeBJ6KfuM.j87IyUjot9rA6vSIXfAzKQI/b1rWy', '', '', 'be9bVS', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-28 02:38:25', '', 0, 1, 1590633505, 1590633505);
INSERT INTO `users` VALUES (59, '146951832', '15579879635', '', '$2y$10$DTOFDSviv4CRhm3XxH8Dc.6E.lCqVda1gv/kj1oAXvHFhgL9tRU0K', '', '', '261Uq6', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-28 05:34:20', '', 0, 1, 1590672860, 1590672853);
INSERT INTO `users` VALUES (60, '130615284', '15018097614', '', '$2y$10$eREsSry57MNGUBPJVv2A8ut6ksl69Av3pCuddwoyp4tPY3QAFsdwy', '', '', 'WY1Rm3', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJodHRwOlwvXC9xdC1hcGkueXVueWluZ2luZy5jb21cL2FwaVwvdjFcL3VzZXIiLCJpYXQiOjE1OTA3NDM0MjUsImV4cCI6MTU5MTAwMTc2OSwibmJmIjoxNTkwOTk4MTY5LCJqdGkiOiIzbVVSNEQwNWFXem9CR0tuIiwic3ViIjo2MCwicHJ2IjoiMjNiZDVjODk0OWY2MDBhZGIzOWU3MDFjNDAwODcyZGI3YTU5NzZmNyJ9.5YPeRkJV-d2rzph5PaYIJK7k6rHiVJR7IU3eAPW7wm8', '', '', '', '', 0, 0, '2020-06-01 07:56:09', '', 0, 1, 1590998169, 1590707870);
INSERT INTO `users` VALUES (61, '146327018', '13812345678', '', '$2y$10$vKHgy0jx6/0O12FxMhu2LOSBxJ22mupydT2kuZj6zTiyez8xwzM3C', '', '', 'NhnDy2', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-05-29 05:26:19', '', 0, 1, 1590758779, 1590758743);
INSERT INTO `users` VALUES (62, '165147938', '18203606007', '', '$2y$10$g8WkMBlTmDdPA6H1BBRfFOKq6bTORgybBD0DPsD7inPFlFZuQlWwy', '', '', 'JKxEhq', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-06-01 03:08:37', '', 0, 1, 1591009717, 1591009694);
INSERT INTO `users` VALUES (63, '181650237', '13631390448', '', '$2y$10$4J1Hp1fFsxBNFA8g78Ih0umrOjeKwQpBzSmVjuq7W/.UoRskXt4j2', '', '', 'Yphy28', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-06-02 00:58:07', '', 0, 1, 1591088287, 1591088271);
INSERT INTO `users` VALUES (64, '142561039', '17308051367', '', '$2y$10$GHCSxDiwKhhZ1iBd/QOi.etdlSXtUTy6V9sW1KVKVrA2l/rcJ6uS.', '', '', 'Gxsvxm', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-06-02 17:08:52', '', 0, 1, 1591146532, 1591146524);
INSERT INTO `users` VALUES (66, '118754392', '', '13167953001@qq.com', '$2y$10$ksP9Dp1Kbu/xXfk0Q7zauu8B7AGQIg2t7AqbtisMwK7dgya40YqQC', '', '', 'dCQsKv', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-06-05 10:17:01', '', 0, 1, 1591352221, 1591352221);
INSERT INTO `users` VALUES (67, '119543208', '', '13167953002@qq.com', '$2y$10$btfgcIoblsgcrzI3CX2M7OJW.yXmL8uby39lIZIRveOP/3E/X921O', '', '', 'PhGw65', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-06-05 10:17:46', '', 0, 1, 1591352266, 1591352266);
INSERT INTO `users` VALUES (68, '102786541', '', '1300180047@qq.com', '$2y$10$ItiSdkye7lluRlXTFr33o.Hlygg2AeS1JFK/vAqIiYHpfI80UAOWm', '', '', '3BrCNA', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-06-07 00:40:02', '', 0, 1, 1591490402, 1591490402);
INSERT INTO `users` VALUES (69, '190124536', '15881063321', '', '', '我的的呃呃呃额额的', 'qiniu_202006271413303347320620.jpg?imageView2/1/w/800/h/800', 'rUcDBA', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', 'jjjjjjch5666', 0, '', 'NO', 0, 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJodHRwOlwvXC9hcGkueGlueGluZy5ydW5cL2FwaVwvdjFcL3VzZXIiLCJpYXQiOjE1OTQxMTYzNTMsImV4cCI6MTU5NDMzNTc2MywibmJmIjoxNTk0Mjk5NzYzLCJqdGkiOiJnSTJkbHNVRjlWU1p3WjU0Iiwic3ViIjo2OSwicHJ2IjoiMjNiZDVjODk0OWY2MDBhZGIzOWU3MDFjNDAwODcyZGI3YTU5NzZmNyJ9.93XjeaGky2Ko7D3TYtoScNx9-o7ufOl94M1vHmaGNfo', '', '', '', '', 0, 0, '2020-07-09 13:02:43', '', 0, 1, 1594299763, 1591541116);
INSERT INTO `users` VALUES (70, '158249063', '', '178465674@qq.com', '$2y$10$mnUdG.X9Gw4fkvj1Tl2aX.ikE.al8oxl4EXs6JF0S2.EGV.XbwlvC', '', '', 'yxNdmU', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-06-08 02:48:28', '', 0, 1, 1591584508, 1591584508);
INSERT INTO `users` VALUES (75, '164582709', '', '', '', '', '', 'Lbq51D', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJodHRwOlwvXC9xdC1hcGkueXVueWluZ2luZy5jb21cL2FwaVwvdjFcL2Rvd25sb2FkTGlzdCIsImlhdCI6MTU5MjIwMTA1MCwiZXhwIjoxNTkyMjM5MTM1LCJuYmYiOjE1OTIyMDMxMzUsImp0aSI6IjJXalJTSUVsRmZNNFlNTm4iLCJzdWIiOjc1LCJwcnYiOiIyM2JkNWM4OTQ5ZjYwMGFkYjM5ZTcwMWM0MDA4NzJkYjdhNTk3NmY3In0.myK-Eu7gHzMzuZ2tyRE3kLBqOpImeyfItNS__jdEd1M', '', '', '', '70395a92fe028077', 0, 0, '2020-06-15 06:38:55', '', 0, 1, 1592203135, 1591844078);
INSERT INTO `users` VALUES (76, '134295087', '', '', '', '', '', 'HApyiv', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '6c01d8180fe08af8', 0, 0, '2020-06-11 09:07:57', '', 0, 1, 1591866477, 1591866477);
INSERT INTO `users` VALUES (77, '135467918', '', '1083048661@qq.com', '$2y$10$Me.GsZPnlO1fE63Ck0Wj..mzsYSrXJ4X2mfRDYOExG9eMBUvdRg2G', '', '', 'EMrCks', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-06-11 10:23:12', '', 0, 1, 1591870992, 1591870992);
INSERT INTO `users` VALUES (78, '139526480', '', '', '', '', '', 'Sjl1Hc', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', 'd8933a7f280e5861', 0, 0, '2020-06-16 10:20:53', '', 0, 1, 1592302853, 1592302853);
INSERT INTO `users` VALUES (79, '194237865', '', '', '', '', '', 'CsCC2U', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', 'dd530514d757e718', 0, 0, '2020-06-16 12:15:50', '', 0, 1, 1592309750, 1592309750);
INSERT INTO `users` VALUES (80, '174259136', '', '', '', '', '', 'hVVjkX', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', 'a0d127c39ba139ce', 0, 0, '2020-06-17 08:47:35', '', 0, 1, 1592383655, 1592383655);
INSERT INTO `users` VALUES (81, '121530874', '', '', '', '', '', 'cKrpe7', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', 'e1b38af99c549d29', 0, 0, '2020-06-17 09:00:28', '', 0, 1, 1592384428, 1592384428);
INSERT INTO `users` VALUES (82, '149160582', '19980731625', '', '', '我吃霸王餐的', '', 'aWm90d', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJodHRwOlwvXC9hcGkueGlueGluZy5ydW5cL2FwaVwvdjFcL3VzZXIiLCJpYXQiOjE1OTYxMTYwNjQsImV4cCI6MTU5NjU1MDE3OSwibmJmIjoxNTk2NTE0MTc5LCJqdGkiOiJmSjlGSE9qQ2FnWjhPU0FoIiwic3ViIjo4MiwicHJ2IjoiMjNiZDVjODk0OWY2MDBhZGIzOWU3MDFjNDAwODcyZGI3YTU5NzZmNyJ9.AEnTyMX-iJykCff2oPhy7Wdcr_DavQG9nxhgUFdXbYE', '', '', '', '', 0, 0, '2020-08-04 04:09:39', '', 0, 1, 1596514179, 1592795506);
INSERT INTO `users` VALUES (83, '115439082', '', '', '', '', '', 'I9CkkS', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '383d0fbd78fed5f0', 0, 0, '2020-06-22 12:42:00', '', 0, 1, 1592829720, 1592829720);
INSERT INTO `users` VALUES (84, '161092743', '', '35991353@qq.com', '$2y$10$KX2L3qHpHFNtPxxA.3KhyOBuV0FJeAZYvR54/lgqY45Af56VLHWjW', '', '', 'XtjIys', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-06-23 03:27:37', '', 0, 1, 1592882857, 1592882857);
INSERT INTO `users` VALUES (85, '120687143', '18600167848', '', '', '', '', 'KA97Ff', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-06-23 06:23:09', '', 0, 1, 1592893389, 1592893389);
INSERT INTO `users` VALUES (86, '128451637', '', '', '', '', '', 'Qh1mPZ', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '65F69581-6431-4EAC-8A2A-CAA4EA800913', 0, 0, '2020-06-23 13:57:34', '', 0, 1, 1592920654, 1592920654);
INSERT INTO `users` VALUES (87, '106315298', '', '1394278344@qq.com', '$2y$10$MA.UhCzYYRNVpk5fJVFQCOULlKZx4BUESS.cnmit9EKTmSyabrp/u', '', '', 'e1sD8P', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-06-24 08:09:54', '', 0, 1, 1592986194, 1592986194);
INSERT INTO `users` VALUES (88, '184592671', '', '249302075@qq.com', '$2y$10$xwMm/BhBOcm/9pNaBtLDpO8hrTPQsrfIba3B14Uiak11UhjnF9WPS', '', '', 'IeyGhy', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-06-24 14:37:38', '', 0, 1, 1593009458, 1593009458);
INSERT INTO `users` VALUES (89, '130284671', '', '991244003@qq.com', '$2y$10$P47sHKIqvJxpU4aO4Gi1B.E5EF2vVX3FJP3QUAWvHPidaaIODh/RO', '', '', 'iNTYA3', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-06-24 14:40:44', '', 0, 1, 1593009644, 1593009644);
INSERT INTO `users` VALUES (90, '180639742', '18280459085', '', '', '', '', 'YgyXWG', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJodHRwOlwvXC9hcGkueGlueGluZy5ydW5cL2FwaVwvdjFcL3VzZXIiLCJpYXQiOjE1OTM1MjI5MTMsImV4cCI6MTU5MzY0NTYwNywibmJmIjoxNTkzNjA5NjA3LCJqdGkiOiJod0x6Qmxhemk5eENVTVN2Iiwic3ViIjo5MCwicHJ2IjoiMjNiZDVjODk0OWY2MDBhZGIzOWU3MDFjNDAwODcyZGI3YTU5NzZmNyJ9.9J_fP20lFJFfkMzU9wNlmBuue8XLgKJDZH8otUtE-7w', '', '', '', '', 0, 0, '2020-07-01 13:20:07', '', 0, 1, 1593609607, 1593276287);
INSERT INTO `users` VALUES (91, '187506492', '', '', '', '', '', 'DNZqyc', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', 'd60459915cdcab5a', 0, 0, '2020-06-29 08:51:51', '', 0, 1, 1593420711, 1593420711);
INSERT INTO `users` VALUES (92, '194375201', '', '123456@qq.com', '$2y$10$2EsKj3FEWQuyKkfTclUhg.c3Nx3pYdxY8hfEujJTai9q8Bk9ZUTWa', '', '', 'i2z8eN', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-07-02 05:34:04', '', 0, 1, 1593668044, 1593668044);
INSERT INTO `users` VALUES (93, '146931728', '', '', '', '', '', 'w8CLjQ', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '9e4a508febb6d347', 0, 0, '2020-07-03 05:47:58', '', 0, 1, 1593755278, 1593755278);
INSERT INTO `users` VALUES (94, '137086495', '', '755616651@qq.com', '$2y$10$spgo5lBEqmODm2sf6ktNMedyrWdSnSyWonpnz2T65GVeGCfKpAiyq', '', '', '4gPPnb', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-07-04 07:06:10', '', 0, 1, 1593846370, 1593846370);
INSERT INTO `users` VALUES (95, '167320549', '18382232153', '', '', '', '', 'jlBa25', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-07-05 06:35:38', '', 0, 1, 1593930938, 1593930938);
INSERT INTO `users` VALUES (96, '159864123', '', '1@qq.com', '$2y$10$tXFeT3vb9OY8ebdW5Pq73efRvlcUGn/O9VeLZ.jBXubRzwD8U/bWi', '', '', 'yaCw9W', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-07-05 15:33:03', '', 0, 1, 1593963183, 1593963183);
INSERT INTO `users` VALUES (97, '129870314', '', '845903928@qq.com', '$2y$10$Wh88hp8VZbHrGG7lsrNQ1uGzQwjaYx3MSu1jd2HLXey4lvIsuKqaO', '', '', 'rUqETG', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-07-05 18:51:23', '', 0, 1, 1593975083, 1593975083);
INSERT INTO `users` VALUES (98, '108523164', '', '2657651858@qq.com', '$2y$10$pGW2Whkx6AGl9Ns7JwWgDOtZaS9REOK4EbrRtvW0xam1P1YYR93zy', '', '', 'uQ0tYX', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-07-06 13:29:50', '', 0, 1, 1594042190, 1594042190);
INSERT INTO `users` VALUES (99, '131084652', '', 'wt_0735@163.com', '$2y$10$trDP/2Z9buMx1IbWlebRU.vomostLPPoD5e66Y1v0REWO3dIgNVeC', '', '', 'iEF9F5', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-07-06 14:25:30', '', 0, 1, 1594045530, 1594045530);
INSERT INTO `users` VALUES (100, '116275483', '', '254897498@qq.com', '$2y$10$guPaEeirT4eNCa9wBGSTE.iKg7QlmhhdWYT4XcJbN/zyXkB6zVDhq', '', '', 'MwYHxs', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-07-07 03:03:22', '', 0, 1, 1594091002, 1594091002);
INSERT INTO `users` VALUES (101, '192578014', '13343080314', '', '', '', '', 'ULvyE8', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-07-08 04:03:09', '', 0, 1, 1594180989, 1594180989);
INSERT INTO `users` VALUES (102, '146253179', '', '2910005060@qq.com', '$2y$10$EBp/lzEFdyEhxNCFGsOxPeemBJL.JAzva2nAczZJy3KK9ED6mZIly', '', '', 'KsLNMN', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-07-09 03:34:00', '', 0, 1, 1594294440, 1594294424);
INSERT INTO `users` VALUES (103, '151736428', '15622222291', '', '', '', '', 'ubgiWD', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-07-09 16:54:46', '', 0, 1, 1594313686, 1594313686);
INSERT INTO `users` VALUES (104, '134761820', '', '', '', '', '', '2YKkL6', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '3c7c0ba5d8e8489f', 0, 0, '2020-07-10 12:44:34', '', 0, 1, 1594385074, 1594385074);
INSERT INTO `users` VALUES (105, '184195670', '', '', '', '', '', 'yubYHC', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', 'a20ce740b15ab477', 0, 0, '2020-07-11 13:50:20', '', 0, 1, 1594475420, 1594475420);
INSERT INTO `users` VALUES (106, '115632478', '', '112233@qq.com', '$2y$10$PbOW4bbu47RQhh7wS9s1ZeXuLW8jRKmHiPOqCTPIOTr5I/ASPbSj6', '', '', 'm51yCi', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-07-11 07:05:51', '', 0, 1, 1594479951, 1594479927);
INSERT INTO `users` VALUES (107, '140983715', '', '', '', '', '', 'fXMVwC', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '1f65972f0282661b', 0, 0, '2020-07-13 09:19:01', '', 0, 1, 1594631941, 1594631941);
INSERT INTO `users` VALUES (108, '172539068', '', '', '', '', '', 'ccq1Yx', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '8e728a3803b5e9f9', 0, 0, '2020-07-15 04:09:40', '', 0, 1, 1594786180, 1594786180);
INSERT INTO `users` VALUES (109, '158392146', '15184488443', '', '', '', '', 'SyvTRb', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-07-15 04:11:18', '', 0, 1, 1594786278, 1594786278);
INSERT INTO `users` VALUES (110, '101437985', '', 'ganhgd@163.com', '$2y$10$KK9l7BPpd8BLRQ5Izrfek.lbBpY4SlyPRqNdgPGF86SjMzcD9Ly3W', '', '', 'SrqErS', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-07-15 16:18:49', '', 0, 1, 1594829929, 1594829929);
INSERT INTO `users` VALUES (111, '189275601', '', '3659823671@qq.com', '$2y$10$IQ4cPyXv.tS4oj4HmJOyUOJ9VgHo0qdPLNU360n5OnzFyl3wjDeqy', '', '', 'D5tQCl', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-07-21 21:06:10', '', 0, 1, 1595365570, 1595365570);
INSERT INTO `users` VALUES (112, '168195473', '', '', '', '', '', 'TwJd8g', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '4766f5cf012efd25', 0, 0, '2020-07-23 22:22:34', '', 0, 1, 1595542954, 1595542954);
INSERT INTO `users` VALUES (113, '154806931', '', '', '', '', '', 'gKZN1K', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '58137b319caaf561', 0, 0, '2020-07-24 00:22:36', '', 0, 1, 1595550156, 1595550156);
INSERT INTO `users` VALUES (114, '137962580', '', 'musicity@163.com', '$2y$10$nV2f7bZwHvnBN0f8GcuNq.4rlIZqzqBfd4MFyJTDdQQD2u.NXpfJW', '', '', 'tPYGcg', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-07-23 19:42:33', '', 0, 1, 1595562153, 1595562123);
INSERT INTO `users` VALUES (115, '191204586', '', '228590184@qq.com', '$2y$10$Dc6oQT3m5ImDfdjldw2uSOCIH.Fb.WAs.93wFj94riOYT0qfUQUA2', '', '', 'AhIvf2', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-07-28 00:25:55', '', 0, 1, 1595924755, 1595924743);
INSERT INTO `users` VALUES (116, '150897241', '', '123454@qq.com', '$2y$10$wDoSa87m57Nl6WxLYAvqRezIfVkIWeY.lMqhPOahlZbLzAtfLD4Xy', '', '', 'wqJiF7', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-07-28 23:19:29', '', 0, 1, 1596007169, 1596007127);
INSERT INTO `users` VALUES (117, '158793014', '', 'hacker-sos@foxmail.com', '$2y$10$HGZO45SbhXEnFWsM626MEeIJn9G0lXFbwQlqis/D6stZiFCSDelGm', '', '', '7ephVe', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-08-01 17:07:19', '', 0, 1, 1596330439, 1596330431);
INSERT INTO `users` VALUES (118, '137480596', '', '23489129@qq.com', '$2y$10$i8hh7Kwz3iEnOUpAblfXFes5XLmSlj1TKjPzEuXWy/gv1VTxhIY0W', '', '', '4jNEti', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-08-04 18:40:22', '', 0, 1, 1596566422, 1596566422);
INSERT INTO `users` VALUES (119, '107163589', '', '214213366@qq.com', '$2y$10$l7JyPXTf7llbF28mK2qWtuFaCRjwPUiHh5MPSugMH6.7.jR1L75Uu', '', '', 'WHface', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-08-04 10:41:26', '', 0, 1, 1596566486, 1596566472);
INSERT INTO `users` VALUES (120, '174259018', '', '', '', '', '', 'epz8hg', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '96100a82f4f0a517', 0, 0, '2020-08-06 01:00:06', '', 0, 1, 1596675606, 1596675606);
INSERT INTO `users` VALUES (121, '193845701', '', '', '', '', '', 'gatuRT', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '7f1cc5c80397e087', 0, 0, '2020-08-06 10:11:00', '', 0, 1, 1596708660, 1596708660);
INSERT INTO `users` VALUES (122, '137961058', '', '18899999999@qq.com', '$2y$10$dku1QLpyKFiZ0/7EH8Owu.xLnTJCAyPCY3myb7KE2OJzgBqNzSLeS', '', '', 'LSmJjd', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJodHRwOlwvXC9xdC1hcGkueXVueWluZ2luZy5jb21cL2FwaVwvdjFcL2NvbGxlY3RcL21lIiwiaWF0IjoxNTk2NzE0MDM1LCJleHAiOjE1OTcwODMzNTAsIm5iZiI6MTU5NzA0NzM1MCwianRpIjoiTWFRa0VOWFZCM0tsNjdFdyIsInN1YiI6MTIyLCJwcnYiOiIyM2JkNWM4OTQ5ZjYwMGFkYjM5ZTcwMWM0MDA4NzJkYjdhNTk3NmY3In0.tMFSqtEVJPeB9f3TS5Fgx7-9PsLdNXfRL4YOlh9Qsbc', '', '', '', '', 0, 0, '2020-08-10 08:15:50', '', 0, 1, 1597047350, 1596714020);
INSERT INTO `users` VALUES (123, '104692731', '', '', '', '', '', 'Pv1mJp', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '167953ebe147878e', 0, 0, '2020-08-06 12:34:06', '', 0, 1, 1596717246, 1596717246);
INSERT INTO `users` VALUES (124, '113280547', '', '', '', '', '', '3ZtLa4', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', 'f88a0deca0a6b863', 0, 0, '2020-08-06 13:41:55', '', 0, 1, 1596721315, 1596721315);
INSERT INTO `users` VALUES (125, '182643975', '', 'superlon@qq.com', '$2y$10$H8Khf0DssKnzJSXnPQzDs.B/v2uEAPe5MOR4peVzJDt8MAe9reac6', '', '', 'PaMYA2', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJodHRwOlwvXC9xdC1hcGkueXVueWluZ2luZy5jb21cL2FwaVwvdjFcL3VzZXIiLCJpYXQiOjE1OTcxNjQ1NDIsImV4cCI6MTU5NzM3ODM2MiwibmJmIjoxNTk3MzQyMzYyLCJqdGkiOiJpTE1mTXFocm1xdm5iNFBuIiwic3ViIjoxMjUsInBydiI6IjIzYmQ1Yzg5NDlmNjAwYWRiMzllNzAxYzQwMDg3MmRiN2E1OTc2ZjcifQ.36Y3CxG1N4cl69lnnsrgfxl5YOxMMMjRcNLwy2-rlUo', '', '', '', '', 0, 0, '2020-08-13 18:12:42', '', 0, 1, 1597342362, 1597164531);
INSERT INTO `users` VALUES (126, '171345609', '14774989814', '', '', '', '', 'xm0Khb', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-08-12 09:03:33', '', 0, 1, 1597223013, 1597223013);
INSERT INTO `users` VALUES (127, '171942380', '', 'james@163.com', '$2y$10$3hr6L.iq/R3IW6cjarF/GO9CULog5WmuiNrhqRK2UrsChgCFmyIkS', '', '', 'QUAKwb', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-08-12 03:09:32', '', 0, 1, 1597230572, 1597230555);
INSERT INTO `users` VALUES (128, '132768195', '', '3274417239@qq.com', '$2y$10$lbIj0QtLjNhO4cMw/y0vneGrwA13FPIqMJcRhj6i.WLvsDgGdxwHq', '', '', 'CTISYZ', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-08-13 06:23:07', '', 0, 1, 1597328587, 1597328559);
INSERT INTO `users` VALUES (129, '152864397', '', 'wfgo@qq.com', '$2y$10$.5YGGLbSHTpz.skGya8ugOzab7a0DK.kGe75gwjNuIUX8t2.RVulq', '', '', 'CSKK04', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-08-17 21:33:07', '', 0, 1, 1597728787, 1597728776);
INSERT INTO `users` VALUES (130, '106931425', '', '', '', '', '', 'ieebYE', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '4ecd946886c91254', 0, 0, '2020-08-18 07:14:52', '', 0, 1, 1597734892, 1597734892);
INSERT INTO `users` VALUES (131, '117943856', '', '', '', '', '', '6GxiwZ', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '6c7d9c0e7366a521', 0, 0, '2020-08-19 05:06:49', '', 0, 1, 1597813609, 1597813609);
INSERT INTO `users` VALUES (132, 'test123', '', '', '$2y$10$NpcjSyPTLNjgT0hxDQk8k.kr9KKYBuwJUUuf/x2Y1LGBcVsfbcSTm', '', '', '6KBZ5t', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-08-19 10:11:31', '', 0, 1, 1597831891, 1597831891);
INSERT INTO `users` VALUES (140, '192651374', '', 'aaax@11.com', '$2y$10$dgiiAyuRi340h1Cw2bzT0e6Xi2Tq4yetDspD3SLHTfNF/9e1BzvhG', '哟喂变得不到你', '', '2alpVJ', '到啦', '11236698', 1, '2010-11-19', 0.00, 0, 0, 0, 0, '', '', 0, '', '觉得好的鸡蛋卷风景', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-11-20 03:27:43', '', 0, 1, 1605842863, 1605842611);
INSERT INTO `users` VALUES (141, '179510234', '', '1339574399@qq.com', '$2y$10$T6UV1lZ32kPAJMEmpC8BT.VX3llc/xEybVjs2Y.vLNmin2yba9p0S', '', '', 'vU0ec3', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-11-21 03:46:58', '', 0, 1, 1605959218, 1605959208);
INSERT INTO `users` VALUES (142, '143605897', '', '734976028@qq.com', '$2y$10$0JpcEFmJazUsb1uY89qYgOa7WHix2jZwI8.lX7NpLgeEKdZKszL86', '', '', 'wT093x', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-11-24 03:38:13', '', 0, 1, 1606217893, 1606034343);
INSERT INTO `users` VALUES (143, '131459682', '', '4729260@qq.com', '$2y$10$J1XukUzhMh7ZoqtGvgsNmOAEHRQM2gyveteYgopEsBZf2aTNM5xIu', '', '', '9UmkGB', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-11-24 05:17:29', '', 0, 1, 1606223849, 1606223756);
INSERT INTO `users` VALUES (144, '169728413', '', '5311947@qq.com', '$2y$10$2s/WSd397NO1B3WKb1M04eSQ0nTwGbd5BDOyP9Vh9uWGkgzQee3dm', '', '', 'SM6FGt', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-11-24 05:57:55', '', 0, 1, 1606226275, 1606226267);
INSERT INTO `users` VALUES (145, '118297036', '', '15887788771@qq.com', '$2y$10$ganQ.MBZ/CAhCouqnPcJXeu.o2JgVwAm5f.5aQih7ijPy25B/nnDe', '', '', 'Rb4s5k', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJodHRwczpcL1wvcWluZ3RpbmdhcGkueW91eWFjYW8uY29tXC9cL2FwaVwvdjFcL2NvbGxlY3RcL21lIiwiaWF0IjoxNjA2NTczNDYwLCJleHAiOjE2MDY4NTU0ODAsIm5iZiI6MTYwNjgxOTQ4MCwianRpIjoicmhMM3M2eUdoeWU2U0RIcyIsInN1YiI6MTQ1LCJwcnYiOiIyM2JkNWM4OTQ5ZjYwMGFkYjM5ZTcwMWM0MDA4NzJkYjdhNTk3NmY3In0.Yw4WYGZ-Ccm91d6KmQpDgTI2dxyMKePLE3ZK1BUv19A', '', '', '', '', 0, 0, '2020-12-01 10:44:40', '', 0, 1, 1606819480, 1606573456);
INSERT INTO `users` VALUES (146, '190768253', '', '17623545019@qq.com', '$2y$10$1j1P5XG5R2haw/OtRVnKEeUkIVPN9q5yO07UMpVBLZiEFUZFm0K1u', '', '', 'um6wF3', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-12-04 09:37:10', '', 1, 1, 1607074630, 1606811917);
INSERT INTO `users` VALUES (147, '178610293', '', '991899182@qq.com', '$2y$10$lwMmbaXIIT9JYEVnBmxEfOSBXdJ6rkQzOOTc0UkLV.KqXPMFzsWXK', '', '', 'LIy14z', '', '991899182', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJodHRwczpcL1wvcWluZ3RpbmdhcGkueW91eWFjYW8uY29tXC9hcGlcL3YxXC91c2VyIiwiaWF0IjoxNjA4MDk3NDQ2LCJleHAiOjE2MDgzMzYyNzYsIm5iZiI6MTYwODMwMDI3NiwianRpIjoiNzVnd2NOSnhKWHdlTndNQyIsInN1YiI6MTQ3LCJwcnYiOiIyM2JkNWM4OTQ5ZjYwMGFkYjM5ZTcwMWM0MDA4NzJkYjdhNTk3NmY3In0.YAEY_36tmMkP4MBqKN0stbjFB9oOIOgHyi1YdnOCVxM', '', '', '', '', 0, 0, '2020-12-18 14:04:36', '', 0, 1, 1608300276, 1607276240);
INSERT INTO `users` VALUES (148, '163245791', '', '76101700@qq.com', '$2y$10$VtPNIrHAO0p16fk75/3Iq.7Ctr/CSI7hf6MMhmUMifgFM8p8u8qjq', '', '', 'EAKw0K', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-12-13 10:46:55', '', 0, 1, 1607856415, 1607856415);
INSERT INTO `users` VALUES (149, 'lyingjack', '', '', '$2y$10$.XEYaKxcOYDjsVUu4SdgIOzYvctl5v2CGCKGSdgJluat0sa7M645W', '', '', 'IrdgUH', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJodHRwczpcL1wvcWluZ3RpbmdhcGkueW91eWFjYW8uY29tXC9hcGlcL3YxXC91c2VyIiwiaWF0IjoxNjA4MTE0NjczLCJleHAiOjE2MDgyMjgwMTIsIm5iZiI6MTYwODE5MjAxMiwianRpIjoiMFZHVVFQZ2psUjhaaHlxcCIsInN1YiI6MTQ5LCJwcnYiOiIyM2JkNWM4OTQ5ZjYwMGFkYjM5ZTcwMWM0MDA4NzJkYjdhNTk3NmY3In0.9Wpk50pdp7RDipKc-AwSu07qgqt8eai5b0UMexXf7cU', '', '', '', '', 0, 0, '2020-12-17 08:00:12', '', 0, 1, 1608192012, 1608112756);
INSERT INTO `users` VALUES (150, '13708021643', '', '', '$2y$10$QbrNuYYfWR2Xx8OlGdt.Zef9OyqtBAnRUgOismqiCR6YXraSD6opG', '', '', 'EjmIPW', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-12-16 18:15:16', '', 0, 1, 1608142516, 1608142516);
INSERT INTO `users` VALUES (151, '184231579', '', '487689854@qq.com', '$2y$10$DmUkLWU3t8UAVkrDx4MSAOr2F9TngR6oFlTcYtOCM4rGatsdFBqhy', '', '', '3akLBP', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-12-16 19:27:45', '', 0, 1, 1608175665, 1608175660);
INSERT INTO `users` VALUES (153, '193875214', '15342556269', '', '$2y$10$IczA4veBSZcAKiZjRruSluiId7PYXnZu7jNnukdtjTyCC/rMpheAi', '', '', 'Vk1XDz', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-12-17 01:02:23', '', 0, 1, 1608195743, 1608195743);
INSERT INTO `users` VALUES (154, '162504389', '18181408136', '', '$2y$10$aJ3DKExFqy8joaIWQbuRVuMYZTALd/28pGoFSKZiBBfs4Rb2b4P/a', '', '', 'bBqzWZ', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJodHRwczpcL1wvcWluZ3RpbmdhcGkueW91eWFjYW8uY29tXC9hcGlcL3YxXC91c2VyIiwiaWF0IjoxNjA4MzY5NDYwLCJleHAiOjE2MDg0ODc5MDcsIm5iZiI6MTYwODQ1MTkwNywianRpIjoiMUx4dlc3endneDJiRGVvMiIsInN1YiI6MTU0LCJwcnYiOiIyM2JkNWM4OTQ5ZjYwMGFkYjM5ZTcwMWM0MDA4NzJkYjdhNTk3NmY3In0.V677nagm84jro_Y-pNY8s8UbRmhf0rbruDak-Ai53Ng', '', '', '', '', 0, 0, '2020-12-21 22:49:14', '', 0, 1, 1608619754, 1608195773);
INSERT INTO `users` VALUES (157, 'demo001', '', '', '$2y$10$OJxFOKZDLwaH40JDsYMmo.b3weOrwVyt8yJmgxp1pyZehz2EGhRpm', '', '', 'P0aPPG', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 1, '/1', 'NO', 0, '', '', '', '', '', 0, 0, '2020-12-18 08:08:39', '', 0, 1, 1608278919, 1608278919);
INSERT INTO `users` VALUES (158, 'demo002', '', '', '$2y$10$xTZUMJ3EQl9AO5UoaERd3OhvPhL.vKmuzjVyBz3mj0.lvWnYn6/Nu', '', '', 'Ugk6Ag', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 1, '/1', 'NO', 0, '', '', '', '', '', 0, 0, '2020-12-18 08:09:03', '', 0, 1, 1608278943, 1608278943);
INSERT INTO `users` VALUES (159, 'demo003', '', '', '$2y$10$neAtEJd.Tm6dMHSgrDGkMeArsKWsSVhzN7/6fr9SRp3eQtqX6.52S', '', '', 'jxX6L4', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 157, '/1/157', 'NO', 0, '', '', '', '', '', 0, 0, '2020-12-18 08:09:10', '', 0, 1, 1608278950, 1608278950);
INSERT INTO `users` VALUES (160, 'demo004', '', '', '$2y$10$LBQVo1J7JeWpgIh7hISzueVs4dTkf2b8MXM79SN833D.vwY7cRtvm', '', '', 'Fffpdz', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 159, '/1/157/159', 'NO', 0, '', '', '', '', '', 0, 0, '2020-12-18 08:09:28', '', 0, 1, 1608278968, 1608278968);
INSERT INTO `users` VALUES (161, 'demo005', '', '', '$2y$10$Yas9sAmQDu7za0XLXFtpOecPBFlVTfFJFcwyZRj/78DCRgAeXg4Je', '', '', 'jwjzWi', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 160, '/1/157/159/160', 'NO', 0, '', '', '', '', '', 0, 0, '2020-12-18 08:10:13', '', 0, 1, 1608279013, 1608279013);
INSERT INTO `users` VALUES (162, '183294156', '', '513743203@qq.com', '$2y$10$p9fVfs.d1IRLokQPzgw8HOwTOEvG./wVR2yIhSPU/7N8nKmx36nmK', '', '', 'Xy8D11', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-12-18 04:15:17', '', 0, 1, 1608293717, 1608293705);
INSERT INTO `users` VALUES (163, '17340159856', '17340159856', '', '$2y$10$L2EOuyZWTBIk9bCtQd14l.xrUGodLKJzRM8dBJ9bPI3B2Xnkh1v4e', '', '', 'SVLupP', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-12-19 05:42:31', '', 0, 1, 1608385351, 1608385340);
INSERT INTO `users` VALUES (164, '143102957', '15690482338', '', '$2y$10$sSGwrd/SvGeejU9VlXvc..vdsH1JqrR8peYgr0KmawMXq4sY7.LC6', '', '', 't7jg3E', '', '', 0, '', 0.00, 0, 0, 0, 0, '', '', 0, '', '', 0, '', 'NO', 0, '', '', '', '', '', 0, 0, '2020-12-20 07:03:13', '', 0, 1, 1608447793, 1608447793);

-- ----------------------------
-- Table structure for version
-- ----------------------------
DROP TABLE IF EXISTS `version`;
CREATE TABLE `version`  (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `user_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '发送人ID',
  `type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '任务类型',
  `forceUpdate` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '是否强制更新',
  `versionCode` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '版本号',
  `versionName` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '版本名称',
  `versionInfo` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '版本信息',
  `downloadUrl` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '版本下载链接安卓',
  `downloadUrl_IOS` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '版本下载链接IOS',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '状态0删除1已领取',
  `updated_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '更新时间',
  `created_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `versionCode`(`versionCode`) USING BTREE,
  INDEX `user_id`(`user_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '版本记录表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for video
-- ----------------------------
DROP TABLE IF EXISTS `video`;
CREATE TABLE `video`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `user_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '关联user_id',
  `category_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '分类ID',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '标题',
  `thumb` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '封面图',
  `video_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '视频地址',
  `short_video_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '短视频地址',
  `duration` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '视频时长',
  `view_num` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '查看次数',
  `like_num` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '点赞次数',
  `comment_num` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '评论次数',
  `share_num` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '分享次数',
  `collect_num` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '收藏次数',
  `tags` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '标签',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT 1 COMMENT '状态0:删除1:待审核2:审核通过',
  `updated_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '更新时间',
  `created_at` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `user_id`(`user_id`) USING BTREE,
  INDEX `category`(`category_id`) USING BTREE,
  INDEX `created_at`(`created_at`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1983 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '短视频表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of video
-- ----------------------------
INSERT INTO `video` VALUES (1, 4, 6, '思想领袖演讲模板', 'http://img.kaiyanapp.com/31b9af2a26c3d8b090c508990ed6ace6.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=134238&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 9, 2, 5, 0, 0, '', 2, 1608393571, 1585981965);
INSERT INTO `video` VALUES (2, 4, 7, '澳洲创作新人 Ruel ，实力颜值双爆表', 'http://img.kaiyanapp.com/45d54b8ffe638e01c7ab20869bdd3e2e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=170261&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 3, 11, 0, 0, '', 2, 1608393230, 1585981965);
INSERT INTO `video` VALUES (3, 4, 3, '超多梗！动画恶搞 A 妹「thank u, next」', 'http://img.kaiyanapp.com/38063ca585372955e7a1748d9f4c0ce0.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=150615&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 1, 0, 0, '', 2, 1607150289, 1585981965);
INSERT INTO `video` VALUES (4, 4, 1, '泰国浪漫搞笑广告：艺术与否，只在一念之间', 'http://img.kaiyanapp.com/49de6c0778c3ead8e3d40349a5c7c6da.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=168438&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 1, 0, 0, 0, '', 2, 1592448495, 1585981965);
INSERT INTO `video` VALUES (5, 4, 5, '数数汽车广告的套路', 'http://img.kaiyanapp.com/48e60e4f96eb9065e3e567c17f986eda.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=127373&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 1, 0, 0, 0, '', 2, 1606725241, 1585981965);
INSERT INTO `video` VALUES (6, 4, 1, '蒙娜丽莎为何微笑？', 'http://img.kaiyanapp.com/521a39b714fa5d6e4fb95d6df8cd05d8.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=150485&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 1, 4, 0, 0, '', 2, 1607320059, 1585981965);
INSERT INTO `video` VALUES (7, 4, 1, '一旦无路可退，你才有决心面对', 'http://img.kaiyanapp.com/ac0c3d3401e22e9ab166445745a51a07.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=132975&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 1, 0, 0, 0, '', 2, 1607153956, 1585981965);
INSERT INTO `video` VALUES (8, 4, 8, '超魔性洗脑广告曲：流量之歌', 'http://img.kaiyanapp.com/112ccdacd46ece961a9b4398e80f2598.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=128873&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 1, 1, 0, 0, '', 2, 1607167520, 1585981965);
INSERT INTO `video` VALUES (9, 4, 7, '用 GIF 也可以做出一支音乐录影带', 'http://img.kaiyanapp.com/88cebf3f721997cbf0ebb2aa371ba4dc.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=168081&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (10, 4, 8, '生娃前后生活对比', 'http://img.kaiyanapp.com/c570aeaa77a18096a5a62eb24f6f0e65.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=123107&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607090777, 1585981965);
INSERT INTO `video` VALUES (11, 4, 2, '如何用FinalCut制作出萤火虫/飞蛾', 'http://img.kaiyanapp.com/0bb4d41c5215223852a927351d635c67.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=145316&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607320070, 1585981965);
INSERT INTO `video` VALUES (12, 4, 6, '动态的萤火虫：新西兰萤火虫洞的延时', 'http://img.kaiyanapp.com/4d4a4fe11060355352bb14dd5b80f06d.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=147698&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (13, 4, 5, 'FinalCutPro不求人时光倒退效果', 'http://img.kaiyanapp.com/679e17c1f106f3bf5dd22256a01d62e5.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=130398&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1608181645, 1585981965);
INSERT INTO `video` VALUES (14, 4, 4, '瞬间白天变晚上视频中添加下雨后的效果演示', 'http://img.kaiyanapp.com/eeb732ff7a3d1129e275c70b7bfcee22.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=159062&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607314607, 1585981965);
INSERT INTO `video` VALUES (15, 4, 8, '据说是台北最美的夜景，可以看到萤火虫', 'http://img.kaiyanapp.com/6a29114542af25d4d6329a58f663173b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=153044&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 4, 0, 0, 0, 0, '', 2, 1607332845, 1585981965);
INSERT INTO `video` VALUES (16, 4, 4, 'Final CutPro不求人竖屏变宽屏', 'http://img.kaiyanapp.com/174ec506a2f3aa93c9aa512f76c15eb1.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=115079&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607164606, 1585981965);
INSERT INTO `video` VALUES (17, 4, 6, '轻松学会给视频添加转场', 'http://img.kaiyanapp.com/aba2de9a197640296831c6768bb3eb4b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=148330&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607159357, 1585981965);
INSERT INTO `video` VALUES (18, 4, 1, 'Final Cut Pro不求人滤镜效果', 'http://img.kaiyanapp.com/8379cedf0d846468aeb40519b1269d2c.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=115370&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (19, 4, 8, 'FinalCutPro不求人形状遮罩演示', 'http://img.kaiyanapp.com/d2b43dccda7014c27846b8d61c954117.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=117384&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607325345, 1585981965);
INSERT INTO `video` VALUES (20, 4, 3, '如何在视频中导出单张图片或单独片段FCP', 'http://img.kaiyanapp.com/082190eca7669bf28e8a6dafe405381b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=162729&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (21, 4, 3, '比起被管教，孩子可能更适合做「管教」', 'http://img.kaiyanapp.com/2d9b3df160d8f4eb60cb1f382f0f437d.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=115462&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (22, 4, 1, '零距离现场体验多累都值 世界杯游记大收官', 'http://img.kaiyanapp.com/f6b8d71ddb6ed07723c62c3230f63e46.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=120429&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (23, 4, 5, '做一道香辣鸡尖，下酒下饭还下剧，太上头了', 'http://img.kaiyanapp.com/c152d18a82143fc8e6352f2de7e2220b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=168822&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607331285, 1585981965);
INSERT INTO `video` VALUES (24, 4, 2, '台风天吃了3顿泡面，今天我要八菜一汤', 'http://img.kaiyanapp.com/e8bc141d2e379a0ab61c22dcf74df410.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=127436&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1606832041, 1585981965);
INSERT INTO `video` VALUES (25, 4, 7, '90后只用3天把老房子改造成时尚短租空间', 'http://img.kaiyanapp.com/19efbd38b895c533d99b82daee825756.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=117667&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 4, 0, 0, '', 2, 1607947566, 1585981965);
INSERT INTO `video` VALUES (26, 4, 5, '是时候吃掉你眼前的键盘了', 'http://img.kaiyanapp.com/b204e915436503d9e9ad9c18982ea492.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=160140&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 4, 0, 0, '', 2, 1607169084, 1585981965);
INSERT INTO `video` VALUES (27, 4, 1, '爱长板 爱自由', 'http://img.kaiyanapp.com/3717a86ba77b3f5e34b8ab2c0d59b66c.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=161964&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1606898155, 1585981965);
INSERT INTO `video` VALUES (28, 4, 2, '猫咪们搬新家第一天，一副满意的样子', 'http://img.kaiyanapp.com/e82cbbd8300d0e3619e12cd774de3fe6.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=115266&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 1, 6, 0, 0, '', 2, 1606833635, 1585981965);
INSERT INTO `video` VALUES (29, 4, 7, '宇宙有多大？', 'http://img.kaiyanapp.com/b4ffcf0f98e0ca4f5a402863e3e433a1.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=155212&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 1, 7, 0, 0, '', 2, 1606726555, 1585981965);
INSERT INTO `video` VALUES (30, 4, 3, '买辆山地车，竟然也能改变人生？', 'http://img.kaiyanapp.com/79751e3d161e227e642c11c851673114.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=132547&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607154234, 1585981965);
INSERT INTO `video` VALUES (31, 4, 4, 'ASMR 甜品教程：无花果奶油蛋糕', 'http://img.kaiyanapp.com/795e3b37fc619b59b40c8973e25f0964.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138366&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607252241, 1585981965);
INSERT INTO `video` VALUES (32, 4, 2, '奶油千层煎饼', 'http://img.kaiyanapp.com/b73375edb695401b26d67cea2a822c7f.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=142479&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332739, 1585981965);
INSERT INTO `video` VALUES (33, 4, 3, '巧克力草莓瓶蛋糕', 'http://img.kaiyanapp.com/6670a4683fd70fa507056a7f2d3dc5ad.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=143960&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607321034, 1585981965);
INSERT INTO `video` VALUES (34, 4, 3, '秋日南瓜小点心', 'http://img.kaiyanapp.com/8b64974caf4abe72ed5a21776aadfbe4.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=134661&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607154037, 1585981965);
INSERT INTO `video` VALUES (35, 4, 1, '黄油牛奶肉桂卷', 'http://img.kaiyanapp.com/1c31fcb80acfed8753624cd76d5658f4.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=145585&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607953914, 1585981965);
INSERT INTO `video` VALUES (36, 4, 3, '甜瓜奶油蛋糕', 'http://img.kaiyanapp.com/7bf24967b79f9afcec37bd91a615c0a6.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140823&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608460298, 1585981965);
INSERT INTO `video` VALUES (37, 4, 7, '苹果起司蛋糕', 'http://img.kaiyanapp.com/6dc9cd850651e1d6d2e2a94821bbe8bd.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139965&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (38, 4, 1, 'ASMR 耳机福利：酥脆可可泡芙', 'http://img.kaiyanapp.com/a8adfd2045a588682473937a7816b2e9.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=130855&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 2, 0, 0, '', 2, 1607955111, 1585981965);
INSERT INTO `video` VALUES (39, 4, 5, '一千多人都在做的香甜南瓜意面酱', 'http://img.kaiyanapp.com/3faa80f4b628e731fd150f8c85a21d56.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=110754&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1606992840, 1585981965);
INSERT INTO `video` VALUES (40, 4, 8, '芋圆烧仙草|爱上你，因为你咬起来最带劲！', 'http://img.kaiyanapp.com/c179097789db9fc0c9ced60f2e093054.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=117389&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833356, 1585981965);
INSERT INTO `video` VALUES (41, 4, 8, '过鞋瘾 adidas BillupsPE', 'http://img.kaiyanapp.com/f3886fea450d8c7ed55baafc7d426e2c.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=115659&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606566251, 1585981965);
INSERT INTO `video` VALUES (42, 4, 8, '过鞋瘾 | 李宁专业跑鞋特辑', 'http://img.kaiyanapp.com/4b06c9ccefb2cea344a5f687b78e596b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136421&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606727101, 1585981965);
INSERT INTO `video` VALUES (43, 4, 7, '过鞋瘾 | AIR JORDAN 18', 'http://img.kaiyanapp.com/e4d2b5d13694cde8992afca20f1be2ae.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136413&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607318009, 1585981965);
INSERT INTO `video` VALUES (44, 4, 1, '过鞋瘾 | NIKE LEBRON 16', 'http://img.kaiyanapp.com/c13ec1af56c8517f14b3713f60d45e99.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136410&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 5, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (45, 4, 4, '鞋会讲科技VOL29PUMA CELL', 'http://img.kaiyanapp.com/69faddffb0e3d9e11cc3fb3c7db288ce.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136429&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332810, 1585981965);
INSERT INTO `video` VALUES (46, 4, 8, '鞋会讲科技 adidas Bounce', 'http://img.kaiyanapp.com/75224bc8314b4517412f7b0aa7bbc2e7.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139365&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 4, 0, 0, '', 2, 1607332550, 1585981965);
INSERT INTO `video` VALUES (47, 4, 1, '鞋会讲科技 NIKE ULTRAMAX', 'http://img.kaiyanapp.com/62692c781b265b6ba91759361b13a5b6.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=133443&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 2, 0, 0, '', 2, 1606833370, 1585981965);
INSERT INTO `video` VALUES (48, 4, 2, '鞋会讲科技13 NIKE REACT', 'http://img.kaiyanapp.com/7cb11dfb20605b15236b30ee8d81833b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=113683&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607332680, 1585981965);
INSERT INTO `video` VALUES (49, 4, 7, '甜品还是咖啡？一分钟带你领略苦与甜的世界', 'http://img.kaiyanapp.com/6a76a5d82c69e7a83e7c693871f98ef4.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=143546&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607165428, 1585981965);
INSERT INTO `video` VALUES (50, 4, 4, '最受女生欢迎的 10 款男士香水，人生赢家必备！', 'http://img.kaiyanapp.com/b03b95a225a9836bb8c04972c82c99c9.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=125091&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607318649, 1585981965);
INSERT INTO `video` VALUES (51, 4, 7, '《神奇动物在哪里2》第三支官方中文预告', 'http://img.kaiyanapp.com/477a6519c9e097f9fc7c303a03548e68.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=117516&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607164181, 1585981965);
INSERT INTO `video` VALUES (52, 4, 4, '「神奇动物 2」预告特辑：J.K.罗琳现身解读', 'http://img.kaiyanapp.com/883f654e63f1c4913d6c3728f0c33722.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=132585&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607157926, 1585981965);
INSERT INTO `video` VALUES (53, 4, 3, '霍格沃茨开学了！「神奇动物 2」预告特辑', 'http://img.kaiyanapp.com/aa7437b05792717ad146d60195cfa388.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=124912&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (54, 4, 7, '小米9拆解：结构简单易量产/做工愈发稳定', 'http://img.kaiyanapp.com/c5875f6d52ed9d9e936d85ad61d9e178.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=151656&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 3, 0, 0, '', 2, 1607786641, 1585981965);
INSERT INTO `video` VALUES (55, 4, 8, '高萌来袭！「乐高大电影 2」预告', 'http://img.kaiyanapp.com/f57e3225fc2ebed33dee9c2f57a954ad.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138576&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606708694, 1585981965);
INSERT INTO `video` VALUES (56, 4, 5, '崔宇：这里有一份“艺术外卖”！', 'http://img.kaiyanapp.com/3e7c6c0851b5e1c3729348feb6205919.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=160327&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607166738, 1585981965);
INSERT INTO `video` VALUES (57, 4, 1, '悬疑惊悚片「忌日快乐 2」最新预告', 'http://img.kaiyanapp.com/44b51cc9a194c725204295312750db84.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=144759&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607157878, 1585981965);
INSERT INTO `video` VALUES (58, 4, 4, '反套路广告：过河「拆」车的男人', 'http://img.kaiyanapp.com/508c2f2f4a9adbbe388b7a1766f29fdc.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=122856&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608458721, 1585981965);
INSERT INTO `video` VALUES (59, 4, 1, '一美惊悚片「玻璃先生」第二支中文预告', 'http://img.kaiyanapp.com/3da9d4391f85f74e11b69d78a1737f5d.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=131506&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332794, 1585981965);
INSERT INTO `video` VALUES (60, 4, 2, '动物也疯狂：醉酒的獾深夜上演大飙车', 'http://img.kaiyanapp.com/01be2a8a6d6e39c7b470fd40599d50e6.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=145908&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606717990, 1585981965);
INSERT INTO `video` VALUES (61, 4, 7, '当潮人遇到潮车......', 'http://img.kaiyanapp.com/028463749e2ab39dad5578ac602afee3.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=134051&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 1, 0, 0, 0, '', 2, 1588152018, 1585981965);
INSERT INTO `video` VALUES (62, 4, 6, '看见厦门-SEE AMOY', 'http://img.kaiyanapp.com/63070988ad50f745792076ba10add201.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=127838&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 1, 0, 0, 0, '', 2, 1588151992, 1585981965);
INSERT INTO `video` VALUES (63, 4, 3, '「Rick Owens」2019 春夏时装发布', 'http://img.kaiyanapp.com/a2348213fb87e5e04b6624387a144646.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=130345&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607259167, 1585981965);
INSERT INTO `video` VALUES (64, 4, 6, '时尚掌中宝｜打开周末唤醒爱人的最浪漫方式', 'http://img.kaiyanapp.com/f599d4731497c96b9c195ba6049ae796.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=111112&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606583022, 1585981965);
INSERT INTO `video` VALUES (65, 4, 3, '偶遇石人殿庙会', 'http://img.kaiyanapp.com/23478eee3609ea37396df19a515acc68.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=132166&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (66, 4, 6, '疯狂单板滑雪不走寻常路！大神技巧秀起来！', 'http://img.kaiyanapp.com/7bba7a4c5a68ab07667030616cc420a8.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=143653&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607253421, 1585981965);
INSERT INTO `video` VALUES (67, 4, 7, '她用轮椅跳了一段舞蹈,所有人都惊呆了', 'http://img.kaiyanapp.com/1dd8c75586e0402fd52449e82f27514f.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=113138&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (68, 4, 6, '《小鬼当家》真。续集来了 | TOPYS', 'http://img.kaiyanapp.com/f042a7665c93084053278f2ce64d69e6.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=143577&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 1, 0, 0, 0, '', 2, 1606725548, 1585981965);
INSERT INTO `video` VALUES (69, 4, 3, '「Alexander McQueen」2019 春夏时装发布', 'http://img.kaiyanapp.com/64faac1eef8796738b8be5c00e2857fb.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=130223&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 1, 0, 0, '', 2, 1608522623, 1585981965);
INSERT INTO `video` VALUES (70, 4, 4, 'Nicole Kirkland 编舞「Kream」', 'http://img.kaiyanapp.com/e3965724c03dbb12343889d78d5799b6.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=129011&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606993596, 1585981965);
INSERT INTO `video` VALUES (71, 4, 1, 'Nicole Kirkland 动感编舞 「Horses」', 'http://img.kaiyanapp.com/c4a852d414f271d72ccdc3530d32b5a8.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140954&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 2, 0, 0, '', 2, 1607162984, 1585981965);
INSERT INTO `video` VALUES (72, 4, 7, 'Nicole Kirkland 编舞「Rich Sex」  ', 'http://img.kaiyanapp.com/aa8e02453f3943cd2ada10e612fcf054.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=114388&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (73, 4, 3, 'JIYOUNG 编舞「How Many Times」  ', 'http://img.kaiyanapp.com/ead8147b8c24f25d1c247e2daa9771b0.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=135464&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607332721, 1585981965);
INSERT INTO `video` VALUES (74, 4, 4, 'HERTZ 编舞「How Many Times」 ', 'http://img.kaiyanapp.com/f1ba2822ab4277b64073f26fabea4b0c.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136131&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607320198, 1585981965);
INSERT INTO `video` VALUES (75, 4, 8, 'ALL.K 编舞「How Long」 ', 'http://img.kaiyanapp.com/50b286a03bd4ee8d8a18741f9eb10f1f.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=110257&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (76, 4, 6, 'Nicole Kirkland 编舞', 'http://img.kaiyanapp.com/ae7b1753110c3f62e08d6a993604c461.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=142402&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833696, 1585981965);
INSERT INTO `video` VALUES (77, 4, 8, 'ALL.K 编舞「Do U Wrong」 ', 'http://img.kaiyanapp.com/c52a5a8fe250df7e9cc734c91dab80f7.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=110101&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1606981032, 1585981965);
INSERT INTO `video` VALUES (78, 4, 5, 'Nicole Kirkland 编舞「Karma」', 'http://img.kaiyanapp.com/bf21eb11dbeb031123feb63b91ad790c.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=142404&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 1, 0, 0, 0, '', 2, 1607325207, 1585981965);
INSERT INTO `video` VALUES (79, 4, 7, 'Nicole Kirkland 编舞「Mama」', 'http://img.kaiyanapp.com/81767fa30de9da2e7bf8efbe5c9d1cd6.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=142400&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607327101, 1585981965);
INSERT INTO `video` VALUES (80, 4, 3, 'Nycole | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/b50f4de7b62fc27b3379c7ec74978691.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138529&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (81, 4, 1, 'MEAM | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/f4d36efe75147e364c1da5c57c09e98e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138535&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1606996405, 1585981965);
INSERT INTO `video` VALUES (82, 4, 1, 'Decenio | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/5133a058bc0e59f5cff85bab912b41dd.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139938&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607318326, 1585981965);
INSERT INTO `video` VALUES (83, 4, 4, '米格尔维埃拉 | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/03a1380e36429c347219395cacdae652.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138536&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607150212, 1585981965);
INSERT INTO `video` VALUES (84, 4, 7, 'Storytailors | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/a4fcea075acfecfa432b7d879060241e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138078&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (85, 4, 5, 'Sara Maia | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/983a131ae62c20907143c4511c2ed0a1.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138531&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606981160, 1585981965);
INSERT INTO `video` VALUES (86, 4, 2, 'Sophia Kah | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/bafe3558fbe911fe0b9c260e20c85971.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138075&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606813602, 1585981965);
INSERT INTO `video` VALUES (87, 4, 1, 'Aucarre | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/23c8049f5aea75d86d1fc4b7babf2a67.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=141267&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607168985, 1585981965);
INSERT INTO `video` VALUES (88, 4, 6, 'Carla Pontes | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/6f31efe49def599046c70a1905b913e4.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139936&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607955040, 1585981965);
INSERT INTO `video` VALUES (89, 4, 1, 'Nuno Baltazar | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/086e42a450edcbd63ac19e30a7e79b24.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138533&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833105, 1585981965);
INSERT INTO `video` VALUES (90, 4, 5, '教育公司创始人：孩子能做到成人不能做到的', 'http://img.kaiyanapp.com/4d5cc48bfa2a3d6803b4067d966e343e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139298&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (91, 4, 2, '把美做成一种生意，一条是靠什么成功的？', 'http://img.kaiyanapp.com/e11b39ec2bbb94939b148b8f05aa4737.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138829&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606564183, 1585981965);
INSERT INTO `video` VALUES (92, 4, 7, '中国消费者是否把节操都献给了二维码？', 'http://img.kaiyanapp.com/edf5a0d7724bc1303bd9be8c144388d2.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=147952&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607953957, 1585981965);
INSERT INTO `video` VALUES (93, 4, 6, '快节奏里的慢生活，摄影师夫妇开的浪漫花店', 'http://img.kaiyanapp.com/e9063d834e83736c20751c2e8b81b81b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=168654&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607090769, 1585981965);
INSERT INTO `video` VALUES (94, 4, 5, '王希：中国游戏缺的是什么？', 'http://img.kaiyanapp.com/78dce5965b24a4d46bed457daf7a43db.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140472&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (95, 4, 1, '没落的企业，通常都是管理过度，领导不足', 'http://img.kaiyanapp.com/219964532b1d6300f592bd9157f30793.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=151110&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606821528, 1585981965);
INSERT INTO `video` VALUES (96, 4, 1, '我终于找到了健身的终极动力', 'http://img.kaiyanapp.com/5c32876723b58b74d2d175e62f62ebaf.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=167451&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (97, 4, 7, '宝马高管：出行变革中中国会是引领者', 'http://img.kaiyanapp.com/a9d6269fa42da4c79b11c1f05b67d282.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=143285&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606807923, 1585981965);
INSERT INTO `video` VALUES (98, 4, 8, '弱人工智能时代产品量产的必备要素有这些', 'http://img.kaiyanapp.com/f95b73633fc6a09b86c0204d15816cb3.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=111740&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607325054, 1585981965);
INSERT INTO `video` VALUES (99, 4, 4, '俄罗斯电影「买下我」中文预告', 'http://img.kaiyanapp.com/5776abf53c9fa29bb64ceea786cef2c4.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=114001&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332723, 1585981965);
INSERT INTO `video` VALUES (100, 4, 5, '咆哮吧，你就是天生的王者：翻唱「Roar」', 'http://img.kaiyanapp.com/2d096a93e53c9d5f870921a95b9032ee.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=112401&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (101, 4, 7, '夏天胃口太好，还得归功于它！', 'http://img.kaiyanapp.com/5717c257588878afbe26413219a0b567.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=114077&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (102, 4, 2, '一学就会的舌尖美味：香辣芝麻鸡翅', 'http://img.kaiyanapp.com/f30476023d43e6d5382cd284c148755e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=114545&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 1, 0, 0, 0, '', 2, 1607256044, 1585981965);
INSERT INTO `video` VALUES (103, 4, 4, 'KHS 翻唱「阿拉丁」电影主题曲', 'http://img.kaiyanapp.com/9829932d2590a11b8808a5bbd73f50b5.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=117787&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607325343, 1585981965);
INSERT INTO `video` VALUES (104, 4, 7, '8 月 27 日| 去加拿大感受自然的魅力', 'http://img.kaiyanapp.com/5623b93633177cad1aa112cc7f5fb21e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=131515&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332823, 1585981965);
INSERT INTO `video` VALUES (105, 4, 6, '动画 MV：梦想总要有的，万一实现了呢', 'http://img.kaiyanapp.com/ce84ca0855bdeb52d02f6679e04fa3a8.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136982&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607325768, 1585981965);
INSERT INTO `video` VALUES (106, 4, 8, '创意 LG 品牌短片：探秘银河星系', 'http://img.kaiyanapp.com/ef12150a74480c49d4beacbac67cd8a7.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=148135&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 1, 0, 0, 0, '', 2, 1607327128, 1585981965);
INSERT INTO `video` VALUES (107, 4, 8, '高燃踩点！漫威 DC 女性英雄混剪', 'http://img.kaiyanapp.com/bfe54011d2cbd2df7bbf1415796d66b0.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=152978&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (108, 4, 5, '享饕餮大餐来北京国贸79，满足你的胃！', 'http://img.kaiyanapp.com/c74fa9bd51ad4477dad3af2d99d374d6.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=169739&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (109, 4, 6, '史上最「美国」的一条广告', 'http://img.kaiyanapp.com/648b64e4acf1b6950fcfaf520405f3a6.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=35459&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606725081, 1585981965);
INSERT INTO `video` VALUES (110, 4, 5, '3 个制作定格的小技巧，新技能 get！', 'http://img.kaiyanapp.com/39085345d65fd57c6c41ca755d5cd719.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=144380&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606394219, 1585981965);
INSERT INTO `video` VALUES (111, 4, 4, '萌猫可以看到激光哦', 'http://img.kaiyanapp.com/8c7e626a7f29731e6824859dc7d7c3f0.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=110164&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (112, 4, 2, '90 秒学会 5 种超简单创意摄影技巧', 'http://img.kaiyanapp.com/ef07650ee09aac6fb4b73fd0643bf76b.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=153522&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (113, 4, 4, '这个夏天，欢迎来柠檬度假村玩！', 'http://img.kaiyanapp.com/61d252054f4a4a4b83fe2f6a831f4fb8.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=166554&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607323435, 1585981965);
INSERT INTO `video` VALUES (114, 4, 7, '你家的孩子不吃青菜吗？', 'http://img.kaiyanapp.com/21bf6f80158d643123a47bf05a57b3fd.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=114727&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (115, 4, 1, '刚出生的小猫咪的第一声啼哭', 'http://img.kaiyanapp.com/1acc2f940eaa3a5d20b71b739e7d9155.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=125414&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607157633, 1585981965);
INSERT INTO `video` VALUES (116, 4, 1, '现实版的超级马里奥跑酷，高手真的在民间', 'http://img.kaiyanapp.com/7664aa1a0b0239a0bf13d32ac554e501.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=146057&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1595045517, 1585981965);
INSERT INTO `video` VALUES (117, 4, 3, '做冰粉真的很头疼，折腾了两个礼拜才做出来', 'http://img.kaiyanapp.com/a9e4b19e32187942891e362d32a50c07.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=120661&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607327091, 1585981965);
INSERT INTO `video` VALUES (118, 4, 3, '巨型草莓恶作剧狗用草莓', 'http://img.kaiyanapp.com/4340402b504a11f4a3070fde7f2f202c.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=132196&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607167319, 1585981965);
INSERT INTO `video` VALUES (119, 4, 3, '林间厨房之香酥牛肉派', 'http://img.kaiyanapp.com/5a6a8133cba51af28dc97709b28bcdbd.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136246&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608458693, 1585981965);
INSERT INTO `video` VALUES (120, 4, 1, '跟汤老湿学英国俚语', 'http://img.kaiyanapp.com/9ac350a5a7c56301d4f92ea7b5319c71.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136493&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 4, 0, 0, 0, 0, '', 2, 1607332695, 1585981965);
INSERT INTO `video` VALUES (121, 4, 1, '跟詹米多南学北爱尔兰俚语', 'http://img.kaiyanapp.com/fcc159b2e5410dc9eb8c8924dfed0e6f.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138733&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (122, 4, 8, '跟亚历山大斯卡斯加德学瑞典俚语', 'http://img.kaiyanapp.com/c9f9f7a8bba55afadd61e6a46ffce90d.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138948&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607149267, 1585981965);
INSERT INTO `video` VALUES (123, 4, 7, '动作犯罪片「贼王」正式预告', 'http://img.kaiyanapp.com/234b31f477a6c90dbda827020b4ad945.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=111893&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606401801, 1585981965);
INSERT INTO `video` VALUES (124, 4, 6, '4 个瑜伽动作：让你放松身心 轻松好眠', 'http://img.kaiyanapp.com/ee682f799fe0dcaf7b4581b5791ecff6.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=164060&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607325463, 1585981965);
INSERT INTO `video` VALUES (125, 4, 4, '吉他教学第2期-右手拨弦小技巧', 'http://img.kaiyanapp.com/1cc21279287432dd387ad2e168cd54e6.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=147164&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (126, 4, 3, '请你喝，蓝天白云茶。', 'http://img.kaiyanapp.com/1bcfdfe08f674db149459c6908401536.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=113004&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (127, 4, 6, '轻松学会给视频添加转场', 'http://img.kaiyanapp.com/aba2de9a197640296831c6768bb3eb4b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=148330&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607324025, 1585981965);
INSERT INTO `video` VALUES (128, 4, 8, '如何导出占内存小的高清视频', 'http://img.kaiyanapp.com/9e87018f195666269d0c250df246933f.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=148333&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (129, 4, 5, 'pr的视频调色与导出', 'http://img.kaiyanapp.com/073d4a17bf3b6d4ba90af9716b12ab0e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=148317&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1608458107, 1585981965);
INSERT INTO `video` VALUES (130, 4, 8, '水煮肉片最正宗做法，鲜嫩过瘾，好吃还下饭', 'http://img.kaiyanapp.com/d4ad3abbe622df7fdd32508db5b7087b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=112972&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1608458250, 1585981965);
INSERT INTO `video` VALUES (131, 4, 4, '信不信？这道红烧羊肉煲，香气飘了一千公里', 'http://img.kaiyanapp.com/3232258ec4fa4a542726d60749f06f63.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=151279&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (132, 4, 2, '在青岛吃了这么多美食，这种烤肉你见过吗？', 'http://img.kaiyanapp.com/b0f117f4763da98c8a3e220d49e0849c.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=135417&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (133, 4, 6, '煎蛋新方法，好看好吃像披萨！', 'http://img.kaiyanapp.com/779430a82b29eaad798f5be8750e62e0.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=150407&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (134, 4, 7, '【徐妈妈厨房】红烧玉秃', 'http://img.kaiyanapp.com/4ac92bcaaf3a559e4d8df2feeace3f7b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=131567&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606831435, 1585981965);
INSERT INTO `video` VALUES (135, 4, 5, '2分钟学会孜然羊肉正宗做法，新疆风味！', 'http://img.kaiyanapp.com/9c90b27170d4b00bdc42910eed59099b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=143152&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (136, 4, 6, '炖羊肉这样做，才是吃出了羊肉的精华', 'http://img.kaiyanapp.com/f11d2fb34042ce0363cf0ba0a5bf2c63.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=151416&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607159660, 1585981965);
INSERT INTO `video` VALUES (137, 4, 6, '如何制作世界上最好吃的马铃薯沙拉', 'http://img.kaiyanapp.com/944dde5883d82619ad13a9a49b59b767.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=158075&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (138, 4, 1, '法式经典吐司，高端大气，好看又好吃', 'http://img.kaiyanapp.com/4f12661afdf3711cbe24bcac2aecbada.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=110457&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607070855, 1585981965);
INSERT INTO `video` VALUES (139, 4, 3, '五花肉新做法，这样吃才过瘾！', 'http://img.kaiyanapp.com/6f793297f664d6948040d11ebfdaf65f.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=150535&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607332596, 1585981965);
INSERT INTO `video` VALUES (140, 4, 3, '在他的“共享经济王国”里，一切都刚刚好', 'http://img.kaiyanapp.com/0769bfeb188388eb503dffddcc4f184e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=147433&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (141, 4, 2, '房地产数据专家：房价为什么高？大数据知道', 'http://img.kaiyanapp.com/620171bafed69c595b540d170ca222f5.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=151348&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607153908, 1585981965);
INSERT INTO `video` VALUES (142, 4, 5, '朱竞翔：负担得起的房子', 'http://img.kaiyanapp.com/03487bd9a09e6707f6d3fcfda93608ff.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139444&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1606726528, 1585981965);
INSERT INTO `video` VALUES (143, 4, 5, '“花园城市”搬回家，花50W造了座小森林', 'http://img.kaiyanapp.com/ce770ee050f60cd59e55b8bb482a5c5b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=167772&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (144, 4, 4, '他在20楼挖池塘，把家改成空中花园', 'http://img.kaiyanapp.com/3cc8ebe54b12095a0c5ac4e1b4a04986.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=114211&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607325834, 1585981965);
INSERT INTO `video` VALUES (145, 4, 3, '最省心的装修法：用收纳柜装饰家', 'http://img.kaiyanapp.com/87b74f1561581e1ad73b01ca1e0a7ae4.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=152136&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607150152, 1585981965);
INSERT INTO `video` VALUES (146, 4, 6, '在荒野里寻找真实，那是击穿一切的力量', 'http://img.kaiyanapp.com/70f629d9f5b4d0c1b849604b79bf8c96.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140191&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606718675, 1585981965);
INSERT INTO `video` VALUES (147, 4, 7, '何健翔：看不见的城市', 'http://img.kaiyanapp.com/7197588e173208602a407b896a30b130.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=154761&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607319241, 1585981965);
INSERT INTO `video` VALUES (148, 4, 1, '青山周平: 房子不等于「家」', 'http://img.kaiyanapp.com/7cf25417efefb752345631b3082a27b1.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140476&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607277069, 1585981965);
INSERT INTO `video` VALUES (149, 4, 6, '马岩松：建筑不是资本的纪念碑', 'http://img.kaiyanapp.com/032683f8e73fbef1da454f47f271c605.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=143744&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608007400, 1585981965);
INSERT INTO `video` VALUES (150, 4, 4, '表观遗传学：为什么遗传比我们想象的更强大', 'http://img.kaiyanapp.com/8379b51e6d01b47d896b1e7d497f949c.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=148508&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833403, 1585981965);
INSERT INTO `video` VALUES (151, 4, 8, '谁是苏格拉底？', 'http://img.kaiyanapp.com/285f37ec06a434afba553ea05e7ae388.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=164328&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (152, 4, 6, '心理治疗是怎样帮你清除负面情绪的？', 'http://img.kaiyanapp.com/41e143deb7afef5096cf4b4bcb0034e2.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=143049&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606565847, 1585981965);
INSERT INTO `video` VALUES (153, 4, 4, '如何科学地分析你的口水？', 'http://img.kaiyanapp.com/bedda6edeaacee8250b9761de6795d63.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=163550&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606724956, 1585981965);
INSERT INTO `video` VALUES (154, 4, 7, '为什么泰坦尼克号不会自己浮出水面？', 'http://img.kaiyanapp.com/16eec7c8f5cf8ed70a5a65f1dbb95aed.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138566&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607068251, 1585981965);
INSERT INTO `video` VALUES (155, 4, 4, '一秒治好社恐：朋友的必要性', 'http://img.kaiyanapp.com/1bbba200e3f68040763c2c59d5bfd82a.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=128972&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607318593, 1585981965);
INSERT INTO `video` VALUES (156, 4, 7, '你所恐惧的，终将使你充满力量', 'http://img.kaiyanapp.com/232ebffaa6daa398d97395eedb441c8e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=112677&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833705, 1585981965);
INSERT INTO `video` VALUES (157, 4, 7, '“中国草”的文明之旅，带你感受技艺的温度', 'http://img.kaiyanapp.com/09ab17008bf3bdd40b70a645bb88eed7.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=131948&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606809906, 1585981965);
INSERT INTO `video` VALUES (158, 4, 6, '假面骑士始祖作，出没于黑暗的《骷髅人》', 'http://img.kaiyanapp.com/081f31eff9e97418c6b09c38ce8f34a5.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=170634&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606401660, 1585981965);
INSERT INTO `video` VALUES (159, 4, 3, '让食物更美味的细菌', 'http://img.kaiyanapp.com/9b6fe59d8784ed6d3bbf8d68526e7158.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140052&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (160, 4, 5, '维多利亚贝克汉姆 | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/1e5c69d0f51901ef85c4b9946748404e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=141263&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607329027, 1585981965);
INSERT INTO `video` VALUES (161, 4, 8, '2018 维密现场：The Struts「Body Talks」', 'http://img.kaiyanapp.com/681d6cc6e07a1680b25c464f5880f1fd.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140733&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (162, 4, 7, '2018 维密现场：Leela James「This Is Me」', 'http://img.kaiyanapp.com/32f2c7d9eb248c6c650a2dd2bef3422d.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140736&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (163, 4, 3, '2019香港维多利亚港跨年烟火秀', 'http://img.kaiyanapp.com/493600c6498d47a90c753374da06298d.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=146460&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 1, 0, 0, '', 2, 1607332792, 1585981965);
INSERT INTO `video` VALUES (164, 4, 7, '2018 维密现场：Shawn Mendes「Lost In Japan」', 'http://img.kaiyanapp.com/62f7dcaa6ecf60713c98f897fadb78ee.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140737&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607325205, 1585981965);
INSERT INTO `video` VALUES (165, 4, 4, '2018 维密现场：Halsey「Without Me」', 'http://img.kaiyanapp.com/e2a31026b4adfe7a215f981f54a79e3e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140738&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833119, 1585981965);
INSERT INTO `video` VALUES (166, 4, 3, '遗憾！这种美食的老手艺，快消失了！', 'http://img.kaiyanapp.com/767a8143849e30d79769b2eed34964ea.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=142986&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606393027, 1585981965);
INSERT INTO `video` VALUES (167, 4, 1, '性感内衣的兴与衰：为什么 2019 维密秀被取消', 'http://img.kaiyanapp.com/4f190b909adfb9ed575daf982983162e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=149802&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607167187, 1585981965);
INSERT INTO `video` VALUES (168, 4, 7, '耗资千万！香港2019烟火秀震撼维港夜空', 'http://img.kaiyanapp.com/a35d7285607371b52f688edfb603df1b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=148072&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606996509, 1585981965);
INSERT INTO `video` VALUES (169, 4, 8, '蕾哈娜教你做人系列：惊艳维密现场', 'http://img.kaiyanapp.com/926c1e7de980c371739a504015ab069c.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=150336&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833610, 1585981965);
INSERT INTO `video` VALUES (170, 4, 6, '水果巧克力起司蛋糕', 'http://img.kaiyanapp.com/70bb6562820fb53d798910e461723bef.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=146919&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607953900, 1585981965);
INSERT INTO `video` VALUES (171, 4, 7, '南瓜料理之起司蛋糕块', 'http://img.kaiyanapp.com/3242f1f52d5c4b4be7d31cdd1b3524ca.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138727&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (172, 4, 5, '奥利奥蓝莓起司蛋糕', 'http://img.kaiyanapp.com/5b5b3575da0c0c62bca441058cd07da8.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139320&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 2, 0, 0, '', 2, 1607166108, 1585981965);
INSERT INTO `video` VALUES (173, 4, 7, '十全菜谱：如何制作南瓜口味的芝士杯子小蛋糕', 'http://img.kaiyanapp.com/60e99895315575513c4d31bd77d22b9c.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=133392&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (174, 4, 6, '抹茶渐变起司蛋糕', 'http://img.kaiyanapp.com/ab7f21651dd6a43cc5363615a6f69e62.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=129196&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607332743, 1585981965);
INSERT INTO `video` VALUES (175, 4, 6, 'kimi 厨房：水果瓶装蛋糕', 'http://img.kaiyanapp.com/9e8295653b61a3586fe4eb328fcb969b.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=110468&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 4, 0, 1, 0, 0, '', 2, 1607312853, 1585981965);
INSERT INTO `video` VALUES (176, 4, 2, '林间厨房之香浓芝士猪排堡', 'http://img.kaiyanapp.com/09e4222b28c8af57072d77db05f6f97f.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=137364&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1608458737, 1585981965);
INSERT INTO `video` VALUES (177, 4, 4, '好吃又美味的简易通心粉做法', 'http://img.kaiyanapp.com/8a5bd1de0e6c4a38b7ed1849b107be12.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=130213&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606708411, 1585981965);
INSERT INTO `video` VALUES (178, 4, 1, 'ASMR 甜品教程：芒果起司蛋糕', 'http://img.kaiyanapp.com/6d792e24f00d52efb6c8374bf096f1f6.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136776&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833702, 1585981965);
INSERT INTO `video` VALUES (179, 4, 6, '无需烘焙的甜点：无麸质芝士蛋糕', 'http://img.kaiyanapp.com/da80465a113990e4d8714811833a898a.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=116457&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607163649, 1585981965);
INSERT INTO `video` VALUES (180, 4, 5, '思想领袖演讲模板', 'http://img.kaiyanapp.com/31b9af2a26c3d8b090c508990ed6ace6.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=134238&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606981357, 1585981965);
INSERT INTO `video` VALUES (181, 4, 7, '澳洲创作新人 Ruel ，实力颜值双爆表', 'http://img.kaiyanapp.com/45d54b8ffe638e01c7ab20869bdd3e2e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=170261&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607319892, 1585981965);
INSERT INTO `video` VALUES (182, 4, 3, '超多梗！动画恶搞 A 妹「thank u, next」', 'http://img.kaiyanapp.com/38063ca585372955e7a1748d9f4c0ce0.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=150615&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607319871, 1585981965);
INSERT INTO `video` VALUES (183, 4, 5, '泰国浪漫搞笑广告：艺术与否，只在一念之间', 'http://img.kaiyanapp.com/49de6c0778c3ead8e3d40349a5c7c6da.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=168438&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (184, 4, 6, '数数汽车广告的套路', 'http://img.kaiyanapp.com/48e60e4f96eb9065e3e567c17f986eda.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=127373&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606577480, 1585981965);
INSERT INTO `video` VALUES (185, 4, 2, '蒙娜丽莎为何微笑？', 'http://img.kaiyanapp.com/521a39b714fa5d6e4fb95d6df8cd05d8.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=150485&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606829657, 1585981965);
INSERT INTO `video` VALUES (186, 4, 2, '一旦无路可退，你才有决心面对', 'http://img.kaiyanapp.com/ac0c3d3401e22e9ab166445745a51a07.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=132975&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607273296, 1585981965);
INSERT INTO `video` VALUES (187, 4, 2, '超魔性洗脑广告曲：流量之歌', 'http://img.kaiyanapp.com/112ccdacd46ece961a9b4398e80f2598.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=128873&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606996291, 1585981965);
INSERT INTO `video` VALUES (188, 4, 6, '用 GIF 也可以做出一支音乐录影带', 'http://img.kaiyanapp.com/88cebf3f721997cbf0ebb2aa371ba4dc.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=168081&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (189, 4, 6, '生娃前后生活对比', 'http://img.kaiyanapp.com/c570aeaa77a18096a5a62eb24f6f0e65.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=123107&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607931013, 1585981965);
INSERT INTO `video` VALUES (190, 4, 7, '如何用FinalCut制作出萤火虫/飞蛾', 'http://img.kaiyanapp.com/0bb4d41c5215223852a927351d635c67.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=145316&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606996556, 1585981965);
INSERT INTO `video` VALUES (191, 4, 4, '动态的萤火虫：新西兰萤火虫洞的延时', 'http://img.kaiyanapp.com/4d4a4fe11060355352bb14dd5b80f06d.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=147698&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607325170, 1585981965);
INSERT INTO `video` VALUES (192, 4, 3, 'FinalCutPro不求人时光倒退效果', 'http://img.kaiyanapp.com/679e17c1f106f3bf5dd22256a01d62e5.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=130398&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 3, 0, 0, '', 2, 1607162694, 1585981965);
INSERT INTO `video` VALUES (193, 4, 3, '瞬间白天变晚上视频中添加下雨后的效果演示', 'http://img.kaiyanapp.com/eeb732ff7a3d1129e275c70b7bfcee22.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=159062&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (194, 4, 1, '据说是台北最美的夜景，可以看到萤火虫', 'http://img.kaiyanapp.com/6a29114542af25d4d6329a58f663173b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=153044&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607276818, 1585981965);
INSERT INTO `video` VALUES (195, 4, 3, 'Final CutPro不求人竖屏变宽屏', 'http://img.kaiyanapp.com/174ec506a2f3aa93c9aa512f76c15eb1.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=115079&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606832049, 1585981965);
INSERT INTO `video` VALUES (196, 4, 3, '轻松学会给视频添加转场', 'http://img.kaiyanapp.com/aba2de9a197640296831c6768bb3eb4b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=148330&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607258512, 1585981965);
INSERT INTO `video` VALUES (197, 4, 6, 'Final Cut Pro不求人滤镜效果', 'http://img.kaiyanapp.com/8379cedf0d846468aeb40519b1269d2c.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=115370&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607332711, 1585981965);
INSERT INTO `video` VALUES (198, 4, 4, 'FinalCutPro不求人形状遮罩演示', 'http://img.kaiyanapp.com/d2b43dccda7014c27846b8d61c954117.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=117384&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (199, 4, 4, '如何在视频中导出单张图片或单独片段FCP', 'http://img.kaiyanapp.com/082190eca7669bf28e8a6dafe405381b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=162729&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606895344, 1585981965);
INSERT INTO `video` VALUES (200, 4, 7, '比起被管教，孩子可能更适合做「管教」', 'http://img.kaiyanapp.com/2d9b3df160d8f4eb60cb1f382f0f437d.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=115462&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (201, 4, 1, '零距离现场体验多累都值 世界杯游记大收官', 'http://img.kaiyanapp.com/f6b8d71ddb6ed07723c62c3230f63e46.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=120429&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (202, 4, 4, '做一道香辣鸡尖，下酒下饭还下剧，太上头了', 'http://img.kaiyanapp.com/c152d18a82143fc8e6352f2de7e2220b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=168822&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (203, 4, 2, '台风天吃了3顿泡面，今天我要八菜一汤', 'http://img.kaiyanapp.com/e8bc141d2e379a0ab61c22dcf74df410.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=127436&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (204, 4, 3, '90后只用3天把老房子改造成时尚短租空间', 'http://img.kaiyanapp.com/19efbd38b895c533d99b82daee825756.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=117667&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607332561, 1585981965);
INSERT INTO `video` VALUES (205, 4, 6, '是时候吃掉你眼前的键盘了', 'http://img.kaiyanapp.com/b204e915436503d9e9ad9c18982ea492.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=160140&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607276802, 1585981965);
INSERT INTO `video` VALUES (206, 4, 7, '爱长板 爱自由', 'http://img.kaiyanapp.com/3717a86ba77b3f5e34b8ab2c0d59b66c.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=161964&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607325908, 1585981965);
INSERT INTO `video` VALUES (207, 4, 6, '猫咪们搬新家第一天，一副满意的样子', 'http://img.kaiyanapp.com/e82cbbd8300d0e3619e12cd774de3fe6.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=115266&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (208, 4, 4, '宇宙有多大？', 'http://img.kaiyanapp.com/b4ffcf0f98e0ca4f5a402863e3e433a1.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=155212&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (209, 4, 3, '买辆山地车，竟然也能改变人生？', 'http://img.kaiyanapp.com/79751e3d161e227e642c11c851673114.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=132547&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (210, 4, 2, 'ASMR 甜品教程：无花果奶油蛋糕', 'http://img.kaiyanapp.com/795e3b37fc619b59b40c8973e25f0964.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138366&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607149571, 1585981965);
INSERT INTO `video` VALUES (211, 4, 3, '奶油千层煎饼', 'http://img.kaiyanapp.com/b73375edb695401b26d67cea2a822c7f.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=142479&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 1, 0, 0, 0, '', 2, 1606726607, 1585981965);
INSERT INTO `video` VALUES (212, 4, 8, '巧克力草莓瓶蛋糕', 'http://img.kaiyanapp.com/6670a4683fd70fa507056a7f2d3dc5ad.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=143960&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (213, 4, 4, '秋日南瓜小点心', 'http://img.kaiyanapp.com/8b64974caf4abe72ed5a21776aadfbe4.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=134661&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607153551, 1585981965);
INSERT INTO `video` VALUES (214, 4, 7, '黄油牛奶肉桂卷', 'http://img.kaiyanapp.com/1c31fcb80acfed8753624cd76d5658f4.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=145585&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606717038, 1585981965);
INSERT INTO `video` VALUES (215, 4, 8, '甜瓜奶油蛋糕', 'http://img.kaiyanapp.com/7bf24967b79f9afcec37bd91a615c0a6.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140823&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607149595, 1585981965);
INSERT INTO `video` VALUES (216, 4, 3, '苹果起司蛋糕', 'http://img.kaiyanapp.com/6dc9cd850651e1d6d2e2a94821bbe8bd.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139965&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607076089, 1585981965);
INSERT INTO `video` VALUES (217, 4, 1, 'ASMR 耳机福利：酥脆可可泡芙', 'http://img.kaiyanapp.com/a8adfd2045a588682473937a7816b2e9.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=130855&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607248526, 1585981965);
INSERT INTO `video` VALUES (218, 4, 7, '一千多人都在做的香甜南瓜意面酱', 'http://img.kaiyanapp.com/3faa80f4b628e731fd150f8c85a21d56.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=110754&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608479199, 1585981965);
INSERT INTO `video` VALUES (219, 4, 1, '芋圆烧仙草|爱上你，因为你咬起来最带劲！', 'http://img.kaiyanapp.com/c179097789db9fc0c9ced60f2e093054.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=117389&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607164412, 1585981965);
INSERT INTO `video` VALUES (220, 4, 7, '过鞋瘾 adidas BillupsPE', 'http://img.kaiyanapp.com/f3886fea450d8c7ed55baafc7d426e2c.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=115659&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607312563, 1585981965);
INSERT INTO `video` VALUES (221, 4, 4, '过鞋瘾 | 李宁专业跑鞋特辑', 'http://img.kaiyanapp.com/4b06c9ccefb2cea344a5f687b78e596b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136421&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607332730, 1585981965);
INSERT INTO `video` VALUES (222, 4, 6, '过鞋瘾 | AIR JORDAN 18', 'http://img.kaiyanapp.com/e4d2b5d13694cde8992afca20f1be2ae.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136413&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606718155, 1585981965);
INSERT INTO `video` VALUES (223, 4, 2, '过鞋瘾 | NIKE LEBRON 16', 'http://img.kaiyanapp.com/c13ec1af56c8517f14b3713f60d45e99.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136410&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607325754, 1585981965);
INSERT INTO `video` VALUES (224, 4, 1, '鞋会讲科技VOL29PUMA CELL', 'http://img.kaiyanapp.com/69faddffb0e3d9e11cc3fb3c7db288ce.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136429&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1608458829, 1585981965);
INSERT INTO `video` VALUES (225, 4, 7, '鞋会讲科技 adidas Bounce', 'http://img.kaiyanapp.com/75224bc8314b4517412f7b0aa7bbc2e7.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139365&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607320060, 1585981965);
INSERT INTO `video` VALUES (226, 4, 4, '鞋会讲科技 NIKE ULTRAMAX', 'http://img.kaiyanapp.com/62692c781b265b6ba91759361b13a5b6.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=133443&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (227, 4, 1, '鞋会讲科技13 NIKE REACT', 'http://img.kaiyanapp.com/7cb11dfb20605b15236b30ee8d81833b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=113683&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607325907, 1585981965);
INSERT INTO `video` VALUES (228, 4, 4, '甜品还是咖啡？一分钟带你领略苦与甜的世界', 'http://img.kaiyanapp.com/6a76a5d82c69e7a83e7c693871f98ef4.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=143546&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606390865, 1585981965);
INSERT INTO `video` VALUES (229, 4, 7, '最受女生欢迎的 10 款男士香水，人生赢家必备！', 'http://img.kaiyanapp.com/b03b95a225a9836bb8c04972c82c99c9.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=125091&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (230, 4, 8, '《神奇动物在哪里2》第三支官方中文预告', 'http://img.kaiyanapp.com/477a6519c9e097f9fc7c303a03548e68.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=117516&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1606890915, 1585981965);
INSERT INTO `video` VALUES (231, 4, 7, '「神奇动物 2」预告特辑：J.K.罗琳现身解读', 'http://img.kaiyanapp.com/883f654e63f1c4913d6c3728f0c33722.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=132585&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606799804, 1585981965);
INSERT INTO `video` VALUES (232, 4, 2, '霍格沃茨开学了！「神奇动物 2」预告特辑', 'http://img.kaiyanapp.com/aa7437b05792717ad146d60195cfa388.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=124912&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607160421, 1585981965);
INSERT INTO `video` VALUES (233, 4, 3, '小米9拆解：结构简单易量产/做工愈发稳定', 'http://img.kaiyanapp.com/c5875f6d52ed9d9e936d85ad61d9e178.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=151656&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606395330, 1585981965);
INSERT INTO `video` VALUES (234, 4, 8, '高萌来袭！「乐高大电影 2」预告', 'http://img.kaiyanapp.com/f57e3225fc2ebed33dee9c2f57a954ad.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138576&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (235, 4, 5, '崔宇：这里有一份“艺术外卖”！', 'http://img.kaiyanapp.com/3e7c6c0851b5e1c3729348feb6205919.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=160327&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (236, 4, 5, '悬疑惊悚片「忌日快乐 2」最新预告', 'http://img.kaiyanapp.com/44b51cc9a194c725204295312750db84.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=144759&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607167274, 1585981965);
INSERT INTO `video` VALUES (237, 4, 3, '反套路广告：过河「拆」车的男人', 'http://img.kaiyanapp.com/508c2f2f4a9adbbe388b7a1766f29fdc.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=122856&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607165981, 1585981965);
INSERT INTO `video` VALUES (238, 4, 7, '一美惊悚片「玻璃先生」第二支中文预告', 'http://img.kaiyanapp.com/3da9d4391f85f74e11b69d78a1737f5d.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=131506&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607162442, 1585981965);
INSERT INTO `video` VALUES (239, 4, 3, '动物也疯狂：醉酒的獾深夜上演大飙车', 'http://img.kaiyanapp.com/01be2a8a6d6e39c7b470fd40599d50e6.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=145908&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 1, 0, 0, '', 2, 1607163060, 1585981965);
INSERT INTO `video` VALUES (240, 4, 5, '当潮人遇到潮车......', 'http://img.kaiyanapp.com/028463749e2ab39dad5578ac602afee3.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=134051&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606981568, 1585981965);
INSERT INTO `video` VALUES (241, 4, 2, '看见厦门-SEE AMOY', 'http://img.kaiyanapp.com/63070988ad50f745792076ba10add201.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=127838&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332818, 1585981965);
INSERT INTO `video` VALUES (242, 4, 5, '「Rick Owens」2019 春夏时装发布', 'http://img.kaiyanapp.com/a2348213fb87e5e04b6624387a144646.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=130345&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606713003, 1585981965);
INSERT INTO `video` VALUES (243, 4, 8, '时尚掌中宝｜打开周末唤醒爱人的最浪漫方式', 'http://img.kaiyanapp.com/f599d4731497c96b9c195ba6049ae796.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=111112&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (244, 4, 4, '偶遇石人殿庙会', 'http://img.kaiyanapp.com/23478eee3609ea37396df19a515acc68.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=132166&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (245, 4, 6, '疯狂单板滑雪不走寻常路！大神技巧秀起来！', 'http://img.kaiyanapp.com/7bba7a4c5a68ab07667030616cc420a8.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=143653&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608261227, 1585981965);
INSERT INTO `video` VALUES (246, 4, 7, '她用轮椅跳了一段舞蹈,所有人都惊呆了', 'http://img.kaiyanapp.com/1dd8c75586e0402fd52449e82f27514f.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=113138&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (247, 4, 5, '《小鬼当家》真。续集来了 | TOPYS', 'http://img.kaiyanapp.com/f042a7665c93084053278f2ce64d69e6.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=143577&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606724281, 1585981965);
INSERT INTO `video` VALUES (248, 4, 4, '「Alexander McQueen」2019 春夏时装发布', 'http://img.kaiyanapp.com/64faac1eef8796738b8be5c00e2857fb.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=130223&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606401819, 1585981965);
INSERT INTO `video` VALUES (249, 4, 6, 'Nicole Kirkland 编舞「Kream」', 'http://img.kaiyanapp.com/e3965724c03dbb12343889d78d5799b6.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=129011&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (250, 4, 4, 'Nicole Kirkland 动感编舞 「Horses」', 'http://img.kaiyanapp.com/c4a852d414f271d72ccdc3530d32b5a8.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140954&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606725770, 1585981965);
INSERT INTO `video` VALUES (251, 4, 2, 'Nicole Kirkland 编舞「Rich Sex」  ', 'http://img.kaiyanapp.com/aa8e02453f3943cd2ada10e612fcf054.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=114388&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607153973, 1585981965);
INSERT INTO `video` VALUES (252, 4, 6, 'JIYOUNG 编舞「How Many Times」  ', 'http://img.kaiyanapp.com/ead8147b8c24f25d1c247e2daa9771b0.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=135464&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (253, 4, 7, 'HERTZ 编舞「How Many Times」 ', 'http://img.kaiyanapp.com/f1ba2822ab4277b64073f26fabea4b0c.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136131&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608479053, 1585981965);
INSERT INTO `video` VALUES (254, 4, 8, 'ALL.K 编舞「How Long」 ', 'http://img.kaiyanapp.com/50b286a03bd4ee8d8a18741f9eb10f1f.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=110257&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607323436, 1585981965);
INSERT INTO `video` VALUES (255, 4, 1, 'Nicole Kirkland 编舞', 'http://img.kaiyanapp.com/ae7b1753110c3f62e08d6a993604c461.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=142402&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606564702, 1585981965);
INSERT INTO `video` VALUES (256, 4, 2, 'ALL.K 编舞「Do U Wrong」 ', 'http://img.kaiyanapp.com/c52a5a8fe250df7e9cc734c91dab80f7.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=110101&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 10, 0, 0, '', 2, 1593016571, 1585981965);
INSERT INTO `video` VALUES (257, 4, 3, 'Nicole Kirkland 编舞「Karma」', 'http://img.kaiyanapp.com/bf21eb11dbeb031123feb63b91ad790c.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=142404&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833477, 1585981965);
INSERT INTO `video` VALUES (258, 4, 6, 'Nicole Kirkland 编舞「Mama」', 'http://img.kaiyanapp.com/81767fa30de9da2e7bf8efbe5c9d1cd6.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=142400&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (259, 4, 8, 'Nycole | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/b50f4de7b62fc27b3379c7ec74978691.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138529&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (260, 4, 3, 'MEAM | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/f4d36efe75147e364c1da5c57c09e98e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138535&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1606826340, 1585981965);
INSERT INTO `video` VALUES (261, 4, 2, 'Decenio | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/5133a058bc0e59f5cff85bab912b41dd.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139938&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (262, 4, 2, '米格尔维埃拉 | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/03a1380e36429c347219395cacdae652.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138536&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607318635, 1585981965);
INSERT INTO `video` VALUES (263, 4, 7, 'Storytailors | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/a4fcea075acfecfa432b7d879060241e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138078&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 4, 0, 0, 0, 0, '', 2, 1608261233, 1585981965);
INSERT INTO `video` VALUES (264, 4, 7, 'Sara Maia | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/983a131ae62c20907143c4511c2ed0a1.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138531&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607153703, 1585981965);
INSERT INTO `video` VALUES (265, 4, 5, 'Sophia Kah | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/bafe3558fbe911fe0b9c260e20c85971.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138075&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606981437, 1585981965);
INSERT INTO `video` VALUES (266, 4, 8, 'Aucarre | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/23c8049f5aea75d86d1fc4b7babf2a67.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=141267&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (267, 4, 4, 'Carla Pontes | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/6f31efe49def599046c70a1905b913e4.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139936&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607318026, 1585981965);
INSERT INTO `video` VALUES (268, 4, 3, 'Nuno Baltazar | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/086e42a450edcbd63ac19e30a7e79b24.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138533&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606809985, 1585981965);
INSERT INTO `video` VALUES (269, 4, 3, '教育公司创始人：孩子能做到成人不能做到的', 'http://img.kaiyanapp.com/4d5cc48bfa2a3d6803b4067d966e343e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139298&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608563548, 1585981965);
INSERT INTO `video` VALUES (270, 4, 6, '把美做成一种生意，一条是靠什么成功的？', 'http://img.kaiyanapp.com/e11b39ec2bbb94939b148b8f05aa4737.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138829&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608479045, 1585981965);
INSERT INTO `video` VALUES (271, 4, 3, '中国消费者是否把节操都献给了二维码？', 'http://img.kaiyanapp.com/edf5a0d7724bc1303bd9be8c144388d2.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=147952&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607090733, 1585981965);
INSERT INTO `video` VALUES (272, 4, 3, '快节奏里的慢生活，摄影师夫妇开的浪漫花店', 'http://img.kaiyanapp.com/e9063d834e83736c20751c2e8b81b81b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=168654&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607090795, 1585981965);
INSERT INTO `video` VALUES (273, 4, 5, '王希：中国游戏缺的是什么？', 'http://img.kaiyanapp.com/78dce5965b24a4d46bed457daf7a43db.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140472&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (274, 4, 1, '没落的企业，通常都是管理过度，领导不足', 'http://img.kaiyanapp.com/219964532b1d6300f592bd9157f30793.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=151110&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (275, 4, 2, '我终于找到了健身的终极动力', 'http://img.kaiyanapp.com/5c32876723b58b74d2d175e62f62ebaf.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=167451&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607848508, 1585981965);
INSERT INTO `video` VALUES (276, 4, 4, '宝马高管：出行变革中中国会是引领者', 'http://img.kaiyanapp.com/a9d6269fa42da4c79b11c1f05b67d282.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=143285&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607955116, 1585981965);
INSERT INTO `video` VALUES (277, 4, 1, '弱人工智能时代产品量产的必备要素有这些', 'http://img.kaiyanapp.com/f95b73633fc6a09b86c0204d15816cb3.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=111740&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (278, 4, 8, '俄罗斯电影「买下我」中文预告', 'http://img.kaiyanapp.com/5776abf53c9fa29bb64ceea786cef2c4.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=114001&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607166200, 1585981965);
INSERT INTO `video` VALUES (279, 4, 6, '咆哮吧，你就是天生的王者：翻唱「Roar」', 'http://img.kaiyanapp.com/2d096a93e53c9d5f870921a95b9032ee.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=112401&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606401798, 1585981965);
INSERT INTO `video` VALUES (280, 4, 4, '夏天胃口太好，还得归功于它！', 'http://img.kaiyanapp.com/5717c257588878afbe26413219a0b567.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=114077&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833503, 1585981965);
INSERT INTO `video` VALUES (281, 4, 8, '一学就会的舌尖美味：香辣芝麻鸡翅', 'http://img.kaiyanapp.com/f30476023d43e6d5382cd284c148755e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=114545&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (282, 4, 6, 'KHS 翻唱「阿拉丁」电影主题曲', 'http://img.kaiyanapp.com/9829932d2590a11b8808a5bbd73f50b5.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=117787&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (283, 4, 7, '8 月 27 日| 去加拿大感受自然的魅力', 'http://img.kaiyanapp.com/5623b93633177cad1aa112cc7f5fb21e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=131515&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833633, 1585981965);
INSERT INTO `video` VALUES (284, 4, 3, '动画 MV：梦想总要有的，万一实现了呢', 'http://img.kaiyanapp.com/ce84ca0855bdeb52d02f6679e04fa3a8.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136982&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606831796, 1585981965);
INSERT INTO `video` VALUES (285, 4, 1, '创意 LG 品牌短片：探秘银河星系', 'http://img.kaiyanapp.com/ef12150a74480c49d4beacbac67cd8a7.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=148135&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607325838, 1585981965);
INSERT INTO `video` VALUES (286, 4, 8, '高燃踩点！漫威 DC 女性英雄混剪', 'http://img.kaiyanapp.com/bfe54011d2cbd2df7bbf1415796d66b0.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=152978&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (287, 4, 4, '享饕餮大餐来北京国贸79，满足你的胃！', 'http://img.kaiyanapp.com/c74fa9bd51ad4477dad3af2d99d374d6.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=169739&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607319753, 1585981965);
INSERT INTO `video` VALUES (288, 4, 3, '史上最「美国」的一条广告', 'http://img.kaiyanapp.com/648b64e4acf1b6950fcfaf520405f3a6.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=35459&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (289, 4, 3, '3 个制作定格的小技巧，新技能 get！', 'http://img.kaiyanapp.com/39085345d65fd57c6c41ca755d5cd719.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=144380&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833570, 1585981965);
INSERT INTO `video` VALUES (290, 4, 6, '萌猫可以看到激光哦', 'http://img.kaiyanapp.com/8c7e626a7f29731e6824859dc7d7c3f0.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=110164&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (291, 4, 3, '90 秒学会 5 种超简单创意摄影技巧', 'http://img.kaiyanapp.com/ef07650ee09aac6fb4b73fd0643bf76b.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=153522&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607164348, 1585981965);
INSERT INTO `video` VALUES (292, 4, 3, '这个夏天，欢迎来柠檬度假村玩！', 'http://img.kaiyanapp.com/61d252054f4a4a4b83fe2f6a831f4fb8.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=166554&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (293, 4, 4, '你家的孩子不吃青菜吗？', 'http://img.kaiyanapp.com/21bf6f80158d643123a47bf05a57b3fd.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=114727&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606725757, 1585981965);
INSERT INTO `video` VALUES (294, 4, 1, '刚出生的小猫咪的第一声啼哭', 'http://img.kaiyanapp.com/1acc2f940eaa3a5d20b71b739e7d9155.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=125414&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606564379, 1585981965);
INSERT INTO `video` VALUES (295, 4, 2, '现实版的超级马里奥跑酷，高手真的在民间', 'http://img.kaiyanapp.com/7664aa1a0b0239a0bf13d32ac554e501.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=146057&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607323429, 1585981965);
INSERT INTO `video` VALUES (296, 4, 8, '做冰粉真的很头疼，折腾了两个礼拜才做出来', 'http://img.kaiyanapp.com/a9e4b19e32187942891e362d32a50c07.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=120661&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606725701, 1585981965);
INSERT INTO `video` VALUES (297, 4, 2, '巨型草莓恶作剧狗用草莓', 'http://img.kaiyanapp.com/4340402b504a11f4a3070fde7f2f202c.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=132196&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607167377, 1585981965);
INSERT INTO `video` VALUES (298, 4, 7, '林间厨房之香酥牛肉派', 'http://img.kaiyanapp.com/5a6a8133cba51af28dc97709b28bcdbd.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136246&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607318357, 1585981965);
INSERT INTO `video` VALUES (299, 4, 3, '跟汤老湿学英国俚语', 'http://img.kaiyanapp.com/9ac350a5a7c56301d4f92ea7b5319c71.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136493&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607325619, 1585981965);
INSERT INTO `video` VALUES (300, 4, 5, '跟詹米多南学北爱尔兰俚语', 'http://img.kaiyanapp.com/fcc159b2e5410dc9eb8c8924dfed0e6f.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138733&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833568, 1585981965);
INSERT INTO `video` VALUES (301, 4, 7, '跟亚历山大斯卡斯加德学瑞典俚语', 'http://img.kaiyanapp.com/c9f9f7a8bba55afadd61e6a46ffce90d.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138948&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606390666, 1585981965);
INSERT INTO `video` VALUES (302, 4, 6, '动作犯罪片「贼王」正式预告', 'http://img.kaiyanapp.com/234b31f477a6c90dbda827020b4ad945.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=111893&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606832348, 1585981965);
INSERT INTO `video` VALUES (303, 4, 4, '4 个瑜伽动作：让你放松身心 轻松好眠', 'http://img.kaiyanapp.com/ee682f799fe0dcaf7b4581b5791ecff6.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=164060&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607125525, 1585981965);
INSERT INTO `video` VALUES (304, 4, 8, '吉他教学第2期-右手拨弦小技巧', 'http://img.kaiyanapp.com/1cc21279287432dd387ad2e168cd54e6.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=147164&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606717957, 1585981965);
INSERT INTO `video` VALUES (305, 4, 2, '请你喝，蓝天白云茶。', 'http://img.kaiyanapp.com/1bcfdfe08f674db149459c6908401536.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=113004&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607953929, 1585981965);
INSERT INTO `video` VALUES (306, 4, 5, '轻松学会给视频添加转场', 'http://img.kaiyanapp.com/aba2de9a197640296831c6768bb3eb4b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=148330&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607868500, 1585981965);
INSERT INTO `video` VALUES (307, 4, 6, '如何导出占内存小的高清视频', 'http://img.kaiyanapp.com/9e87018f195666269d0c250df246933f.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=148333&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606364787, 1585981965);
INSERT INTO `video` VALUES (308, 4, 7, 'pr的视频调色与导出', 'http://img.kaiyanapp.com/073d4a17bf3b6d4ba90af9716b12ab0e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=148317&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607326765, 1585981965);
INSERT INTO `video` VALUES (309, 4, 3, '水煮肉片最正宗做法，鲜嫩过瘾，好吃还下饭', 'http://img.kaiyanapp.com/d4ad3abbe622df7fdd32508db5b7087b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=112972&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607955080, 1585981965);
INSERT INTO `video` VALUES (310, 4, 6, '信不信？这道红烧羊肉煲，香气飘了一千公里', 'http://img.kaiyanapp.com/3232258ec4fa4a542726d60749f06f63.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=151279&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1608458884, 1585981965);
INSERT INTO `video` VALUES (311, 4, 1, '在青岛吃了这么多美食，这种烤肉你见过吗？', 'http://img.kaiyanapp.com/b0f117f4763da98c8a3e220d49e0849c.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=135417&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1606981060, 1585981965);
INSERT INTO `video` VALUES (312, 4, 1, '煎蛋新方法，好看好吃像披萨！', 'http://img.kaiyanapp.com/779430a82b29eaad798f5be8750e62e0.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=150407&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608465990, 1585981965);
INSERT INTO `video` VALUES (313, 4, 4, '【徐妈妈厨房】红烧玉秃', 'http://img.kaiyanapp.com/4ac92bcaaf3a559e4d8df2feeace3f7b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=131567&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (314, 4, 7, '2分钟学会孜然羊肉正宗做法，新疆风味！', 'http://img.kaiyanapp.com/9c90b27170d4b00bdc42910eed59099b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=143152&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (315, 4, 2, '炖羊肉这样做，才是吃出了羊肉的精华', 'http://img.kaiyanapp.com/f11d2fb34042ce0363cf0ba0a5bf2c63.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=151416&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (316, 4, 4, '如何制作世界上最好吃的马铃薯沙拉', 'http://img.kaiyanapp.com/944dde5883d82619ad13a9a49b59b767.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=158075&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607255760, 1585981965);
INSERT INTO `video` VALUES (317, 4, 6, '法式经典吐司，高端大气，好看又好吃', 'http://img.kaiyanapp.com/4f12661afdf3711cbe24bcac2aecbada.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=110457&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607148955, 1585981965);
INSERT INTO `video` VALUES (318, 4, 3, '五花肉新做法，这样吃才过瘾！', 'http://img.kaiyanapp.com/6f793297f664d6948040d11ebfdaf65f.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=150535&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332793, 1585981965);
INSERT INTO `video` VALUES (319, 4, 2, '在他的“共享经济王国”里，一切都刚刚好', 'http://img.kaiyanapp.com/0769bfeb188388eb503dffddcc4f184e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=147433&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607318069, 1585981965);
INSERT INTO `video` VALUES (320, 4, 7, '房地产数据专家：房价为什么高？大数据知道', 'http://img.kaiyanapp.com/620171bafed69c595b540d170ca222f5.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=151348&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 1, 0, 0, 0, '', 2, 1608563545, 1585981965);
INSERT INTO `video` VALUES (321, 4, 5, '朱竞翔：负担得起的房子', 'http://img.kaiyanapp.com/03487bd9a09e6707f6d3fcfda93608ff.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139444&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (322, 4, 8, '“花园城市”搬回家，花50W造了座小森林', 'http://img.kaiyanapp.com/ce770ee050f60cd59e55b8bb482a5c5b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=167772&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607326404, 1585981965);
INSERT INTO `video` VALUES (323, 4, 7, '他在20楼挖池塘，把家改成空中花园', 'http://img.kaiyanapp.com/3cc8ebe54b12095a0c5ac4e1b4a04986.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=114211&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607332725, 1585981965);
INSERT INTO `video` VALUES (324, 4, 8, '最省心的装修法：用收纳柜装饰家', 'http://img.kaiyanapp.com/87b74f1561581e1ad73b01ca1e0a7ae4.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=152136&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607160060, 1585981965);
INSERT INTO `video` VALUES (325, 4, 7, '在荒野里寻找真实，那是击穿一切的力量', 'http://img.kaiyanapp.com/70f629d9f5b4d0c1b849604b79bf8c96.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140191&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607325902, 1585981965);
INSERT INTO `video` VALUES (326, 4, 3, '何健翔：看不见的城市', 'http://img.kaiyanapp.com/7197588e173208602a407b896a30b130.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=154761&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607318328, 1585981965);
INSERT INTO `video` VALUES (327, 4, 5, '青山周平: 房子不等于「家」', 'http://img.kaiyanapp.com/7cf25417efefb752345631b3082a27b1.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140476&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1608189358, 1585981965);
INSERT INTO `video` VALUES (328, 4, 3, '马岩松：建筑不是资本的纪念碑', 'http://img.kaiyanapp.com/032683f8e73fbef1da454f47f271c605.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=143744&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1606988292, 1585981965);
INSERT INTO `video` VALUES (329, 4, 2, '表观遗传学：为什么遗传比我们想象的更强大', 'http://img.kaiyanapp.com/8379b51e6d01b47d896b1e7d497f949c.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=148508&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607158308, 1585981965);
INSERT INTO `video` VALUES (330, 4, 3, '谁是苏格拉底？', 'http://img.kaiyanapp.com/285f37ec06a434afba553ea05e7ae388.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=164328&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (331, 4, 3, '心理治疗是怎样帮你清除负面情绪的？', 'http://img.kaiyanapp.com/41e143deb7afef5096cf4b4bcb0034e2.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=143049&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606830945, 1585981965);
INSERT INTO `video` VALUES (332, 4, 2, '如何科学地分析你的口水？', 'http://img.kaiyanapp.com/bedda6edeaacee8250b9761de6795d63.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=163550&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607160562, 1585981965);
INSERT INTO `video` VALUES (333, 4, 1, '为什么泰坦尼克号不会自己浮出水面？', 'http://img.kaiyanapp.com/16eec7c8f5cf8ed70a5a65f1dbb95aed.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138566&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606919774, 1585981965);
INSERT INTO `video` VALUES (334, 4, 4, '一秒治好社恐：朋友的必要性', 'http://img.kaiyanapp.com/1bbba200e3f68040763c2c59d5bfd82a.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=128972&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606811250, 1585981965);
INSERT INTO `video` VALUES (335, 4, 3, '你所恐惧的，终将使你充满力量', 'http://img.kaiyanapp.com/232ebffaa6daa398d97395eedb441c8e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=112677&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606571904, 1585981965);
INSERT INTO `video` VALUES (336, 4, 7, '“中国草”的文明之旅，带你感受技艺的温度', 'http://img.kaiyanapp.com/09ab17008bf3bdd40b70a645bb88eed7.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=131948&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606725791, 1585981965);
INSERT INTO `video` VALUES (337, 4, 2, '假面骑士始祖作，出没于黑暗的《骷髅人》', 'http://img.kaiyanapp.com/081f31eff9e97418c6b09c38ce8f34a5.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=170634&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1606998282, 1585981965);
INSERT INTO `video` VALUES (338, 4, 3, '让食物更美味的细菌', 'http://img.kaiyanapp.com/9b6fe59d8784ed6d3bbf8d68526e7158.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140052&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332815, 1585981965);
INSERT INTO `video` VALUES (339, 4, 2, '维多利亚贝克汉姆 | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/1e5c69d0f51901ef85c4b9946748404e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=141263&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607276985, 1585981965);
INSERT INTO `video` VALUES (340, 4, 3, '2018 维密现场：The Struts「Body Talks」', 'http://img.kaiyanapp.com/681d6cc6e07a1680b25c464f5880f1fd.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140733&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 1, 1, 0, 0, '', 2, 1607168923, 1585981965);
INSERT INTO `video` VALUES (341, 4, 3, '2018 维密现场：Leela James「This Is Me」', 'http://img.kaiyanapp.com/32f2c7d9eb248c6c650a2dd2bef3422d.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140736&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (342, 4, 4, '2019香港维多利亚港跨年烟火秀', 'http://img.kaiyanapp.com/493600c6498d47a90c753374da06298d.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=146460&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606831541, 1585981965);
INSERT INTO `video` VALUES (343, 4, 8, '2018 维密现场：Shawn Mendes「Lost In Japan」', 'http://img.kaiyanapp.com/62f7dcaa6ecf60713c98f897fadb78ee.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140737&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607277021, 1585981965);
INSERT INTO `video` VALUES (344, 4, 6, '2018 维密现场：Halsey「Without Me」', 'http://img.kaiyanapp.com/e2a31026b4adfe7a215f981f54a79e3e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140738&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1608542106, 1585981965);
INSERT INTO `video` VALUES (345, 4, 5, '遗憾！这种美食的老手艺，快消失了！', 'http://img.kaiyanapp.com/767a8143849e30d79769b2eed34964ea.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=142986&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607848528, 1585981965);
INSERT INTO `video` VALUES (346, 4, 6, '性感内衣的兴与衰：为什么 2019 维密秀被取消', 'http://img.kaiyanapp.com/4f190b909adfb9ed575daf982983162e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=149802&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606831872, 1585981965);
INSERT INTO `video` VALUES (347, 4, 5, '耗资千万！香港2019烟火秀震撼维港夜空', 'http://img.kaiyanapp.com/a35d7285607371b52f688edfb603df1b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=148072&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607158797, 1585981965);
INSERT INTO `video` VALUES (348, 4, 3, '蕾哈娜教你做人系列：惊艳维密现场', 'http://img.kaiyanapp.com/926c1e7de980c371739a504015ab069c.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=150336&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606564398, 1585981965);
INSERT INTO `video` VALUES (349, 4, 8, '水果巧克力起司蛋糕', 'http://img.kaiyanapp.com/70bb6562820fb53d798910e461723bef.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=146919&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1608189427, 1585981965);
INSERT INTO `video` VALUES (350, 4, 7, '南瓜料理之起司蛋糕块', 'http://img.kaiyanapp.com/3242f1f52d5c4b4be7d31cdd1b3524ca.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138727&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (351, 4, 8, '奥利奥蓝莓起司蛋糕', 'http://img.kaiyanapp.com/5b5b3575da0c0c62bca441058cd07da8.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139320&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606564611, 1585981965);
INSERT INTO `video` VALUES (352, 4, 6, '十全菜谱：如何制作南瓜口味的芝士杯子小蛋糕', 'http://img.kaiyanapp.com/60e99895315575513c4d31bd77d22b9c.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=133392&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606832013, 1585981965);
INSERT INTO `video` VALUES (353, 4, 4, '抹茶渐变起司蛋糕', 'http://img.kaiyanapp.com/ab7f21651dd6a43cc5363615a6f69e62.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=129196&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606708255, 1585981965);
INSERT INTO `video` VALUES (354, 4, 2, 'kimi 厨房：水果瓶装蛋糕', 'http://img.kaiyanapp.com/9e8295653b61a3586fe4eb328fcb969b.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=110468&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606830390, 1585981965);
INSERT INTO `video` VALUES (355, 4, 4, '林间厨房之香浓芝士猪排堡', 'http://img.kaiyanapp.com/09e4222b28c8af57072d77db05f6f97f.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=137364&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (356, 4, 5, '好吃又美味的简易通心粉做法', 'http://img.kaiyanapp.com/8a5bd1de0e6c4a38b7ed1849b107be12.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=130213&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833716, 1585981965);
INSERT INTO `video` VALUES (357, 4, 4, 'ASMR 甜品教程：芒果起司蛋糕', 'http://img.kaiyanapp.com/6d792e24f00d52efb6c8374bf096f1f6.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136776&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1606996939, 1585981965);
INSERT INTO `video` VALUES (358, 4, 4, '无需烘焙的甜点：无麸质芝士蛋糕', 'http://img.kaiyanapp.com/da80465a113990e4d8714811833a898a.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=116457&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607332812, 1585981965);
INSERT INTO `video` VALUES (359, 4, 3, '保时捷 911 GT3 RS改装案例', 'http://img.kaiyanapp.com/cc54298c5abef2cda430b2c31dea7e10.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138033&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607325341, 1585981965);
INSERT INTO `video` VALUES (360, 4, 5, '保时捷 911 GT3 陈震一镜到底', 'http://img.kaiyanapp.com/69652adcfd2c2a8a11e7fadb747da39a.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=124122&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607319263, 1585981965);
INSERT INTO `video` VALUES (361, 4, 6, '雪中漂移，他和保时捷一起滑雪！', 'http://img.kaiyanapp.com/850f826363c3e73c6a19145ddcfdbbae.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=124866&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606582528, 1585981965);
INSERT INTO `video` VALUES (362, 4, 3, '极限竞速GTR雨天比赛直播', 'http://img.kaiyanapp.com/f3c34e5903bf8e6f0110b77bbb44d1a8.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=146508&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607090779, 1585981965);
INSERT INTO `video` VALUES (363, 4, 3, '疯狂的摩托车，上帝见了都要开启吐槽模式', 'http://img.kaiyanapp.com/c260c452d2366629a94ee57ae686437d.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=127423&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607164954, 1585981965);
INSERT INTO `video` VALUES (364, 4, 5, '对标保时捷，「终极」版捷豹只卖 300 辆', 'http://img.kaiyanapp.com/fa3b8a2ba70998996aa45a071273ae84.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=128266&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606708288, 1585981965);
INSERT INTO `video` VALUES (365, 4, 1, '赛道利器911GT3能否俘获贩子的心', 'http://img.kaiyanapp.com/bb34d67763590d06beadd503872bd8e0.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=171352&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606993484, 1585981965);
INSERT INTO `video` VALUES (366, 4, 2, '奔驰在曼谷的不眠街头 | 保时捷 919', 'http://img.kaiyanapp.com/69791fc40ba6228a0e230fcb3eabb41a.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=123180&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607318551, 1585981965);
INSERT INTO `video` VALUES (367, 4, 3, '2018CHINAGT上海站R7R8', 'http://img.kaiyanapp.com/f21ba93fa0a2405b995c0fbc81c7da84.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=126827&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (368, 4, 6, '椰子700发售前开箱！这配色！这鞋型..', 'http://img.kaiyanapp.com/1b917b8ea70fd2c8ad183e2d07af4561.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=127126&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (369, 4, 4, '拒绝无聊人生「如此疯狂的心」中文预告', 'http://img.kaiyanapp.com/4c786537426eee292d3a5a14f6c786b9.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=120718&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607256842, 1585981965);
INSERT INTO `video` VALUES (370, 4, 8, '卡梅隆监制！「阿丽塔：战斗天使」预告', 'http://img.kaiyanapp.com/e0334d158447e93e2dfaae71e18a4205.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=137117&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607167656, 1585981965);
INSERT INTO `video` VALUES (371, 4, 5, '山田孝之：「客人的笑臉」篇', 'http://img.kaiyanapp.com/7f438227f9590c0f6ae6f1724401e701.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=128599&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606724977, 1585981965);
INSERT INTO `video` VALUES (372, 4, 3, '日本游记：濑户内海', 'http://img.kaiyanapp.com/35153adfb1e77315d6bb4ed7c17e16b5.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=120569&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 1, 0, 0, 0, '', 2, 1607277019, 1585981965);
INSERT INTO `video` VALUES (373, 4, 8, '剪辑/燃向/踩点/转场/鬼畜带着节奏海王', 'http://img.kaiyanapp.com/ffc1f0fd787b3e123cebf77d8fc8baa1.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=154810&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332742, 1585981965);
INSERT INTO `video` VALUES (374, 4, 8, '海王来了！杰森·莫玛中国行 Vlog', 'http://img.kaiyanapp.com/0f58860bbdd4d35438cfd2c90828f50c.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139519&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607256916, 1585981965);
INSERT INTO `video` VALUES (375, 4, 4, '亚洲第一禁欲系酒店，地下挖洞穴供客人裸泳', 'http://img.kaiyanapp.com/87ed9f659535e1e68c6f788cfc2ba6e5.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=163044&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606823515, 1585981965);
INSERT INTO `video` VALUES (376, 4, 1, '女骗徒在线敲诈：安妮·海瑟薇「偷心女盗」预告', 'http://img.kaiyanapp.com/d066a9c7241ca8f84cb532e4e056ce54.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=149897&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1608385400, 1585981965);
INSERT INTO `video` VALUES (377, 4, 7, '禁书改编！「在黑暗中说的鬼故事」电影预告', 'http://img.kaiyanapp.com/7da4c488a10fa7d1e6532464ce4cea5b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=155855&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 2, 0, 0, '', 2, 1607162935, 1585981965);
INSERT INTO `video` VALUES (378, 4, 7, '是女优，也是作家', 'http://img.kaiyanapp.com/70b57d40ab03bafa380af2ce62866a2a.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=129191&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (379, 4, 5, '环境反思动画：拯救刺猬 Harry', 'http://img.kaiyanapp.com/ffd8356390d5eb73e248327b2797b7be.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=137052&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606708511, 1585981965);
INSERT INTO `video` VALUES (380, 4, 5, '萌趣动画：吃翔吧，猎人！', 'http://img.kaiyanapp.com/fa74fba90376a4ebb68b277c3b585a8f.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=145110&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607325943, 1585981965);
INSERT INTO `video` VALUES (381, 4, 4, '意识流短片：猎杀科技', 'http://img.kaiyanapp.com/a01a911cbaafb44eb0621de87b438de9.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=161414&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (382, 4, 7, '柏林电影节入围短片：火山岛', 'http://img.kaiyanapp.com/379bfddf5a68ab6f910105805d42e0c2.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=153332&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606926445, 1585981965);
INSERT INTO `video` VALUES (383, 4, 4, '血色森林：愿猎人的枪声不要打扰自然的生灵', 'http://img.kaiyanapp.com/565b3fc196e5865a2185c344cf2155b4.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=135178&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607168893, 1585981965);
INSERT INTO `video` VALUES (384, 4, 5, '多人 FPS 游戏「猎杀：对决」预告片', 'http://img.kaiyanapp.com/39b85305d8abbce556abc8a2b9be86f5.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=123027&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606832328, 1585981965);
INSERT INTO `video` VALUES (385, 4, 4, '狩猎爱好者的天堂：200 英亩豪华狩猎庄园', 'http://img.kaiyanapp.com/2501575b4e929ae8f2368c64d2300f38.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=117342&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607325235, 1585981965);
INSERT INTO `video` VALUES (386, 4, 6, '杨晓洋：水果猎人', 'http://img.kaiyanapp.com/2205e351f2dcd29e19d006a78b115f5e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=151702&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607163621, 1585981965);
INSERT INTO `video` VALUES (387, 4, 3, '韩国公益广告：无家可归的黑狗', 'http://img.kaiyanapp.com/9c242b29cf314c3b1cc151a90798f83e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=128738&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607312666, 1585981965);
INSERT INTO `video` VALUES (388, 4, 1, '萌出血：用迷你「奶瓶」给小松鼠喂奶', 'http://img.kaiyanapp.com/fb33b719b6b45a695d40fe56ce4b4b68.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=122296&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606401610, 1585981965);
INSERT INTO `video` VALUES (389, 4, 6, '一句话选车指南（一）：豪华品牌怎么选？', 'http://img.kaiyanapp.com/2d900b2c4f18664957685415928b1571.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138476&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (390, 4, 8, '一句话选车指南（三）：国产品牌怎么选？', 'http://img.kaiyanapp.com/7a5d438b5d7e7721fab3db05fb6c1db1.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138737&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607250629, 1585981965);
INSERT INTO `video` VALUES (391, 4, 5, '玩自吸的Jeep 1.3T也这么溜', 'http://img.kaiyanapp.com/12853028c4657765bcaeb7e510e0398c.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=158205&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606823892, 1585981965);
INSERT INTO `video` VALUES (392, 4, 7, '大疆硬核刚Gopro运动相机', 'http://img.kaiyanapp.com/77bd892b77fb6e763f04e91d40b47e96.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=160762&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607259300, 1585981965);
INSERT INTO `video` VALUES (393, 4, 5, '你以为有台超跑很拉风？', 'http://img.kaiyanapp.com/c67979c05bdfe8147e6804cf1493a133.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=110099&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606831819, 1585981965);
INSERT INTO `video` VALUES (394, 4, 4, '趣味测试：哪个是真的？ 肉桂卷绘图挑战！', 'http://img.kaiyanapp.com/d8c3b39c353392f9f7015d661e75fd7d.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=115236&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (395, 4, 6, '趣味测试：哪一个是真实的？香蕉画挑战！', 'http://img.kaiyanapp.com/1434e9dffa3f21e8dc8b16d814a5b064.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=115237&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (396, 4, 2, '趣味测试：哪一个是真实的？红辣椒画挑战！', 'http://img.kaiyanapp.com/53344db226cf557674f8cdc9af2d9a02.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=116543&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (397, 4, 8, '50 个真相打破你关于澳洲的一切刻板认知', 'http://img.kaiyanapp.com/d2e10c5a77ae3ba05287911be2e3c04d.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=166862&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607320059, 1585981965);
INSERT INTO `video` VALUES (398, 4, 1, '10万块钱的合资车和自主车，到底差在哪？', 'http://img.kaiyanapp.com/7e629c4c51a06971bc13b690ee20cb7a.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138903&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833689, 1585981965);
INSERT INTO `video` VALUES (399, 4, 5, '范大将军怒批阿根廷，再这样就该输汤加了！', 'http://img.kaiyanapp.com/26fd16a9da2406a962895990a6aa8de5.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=164516&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332819, 1585981965);
INSERT INTO `video` VALUES (400, 4, 4, '大将军郭：为什么女性更容易焦虑？', 'http://img.kaiyanapp.com/c59cd96c763924ee1ffcd7d5610ad671.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=170364&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (401, 4, 7, 'C罗回归梦剧场，尤文后防大将实力抢戏', 'http://img.kaiyanapp.com/239d39cf6aa6ef7299f4dd0cc0a0b16c.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=134018&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606832639, 1585981965);
INSERT INTO `video` VALUES (402, 4, 5, '爆笑解毒国足vs菲律宾，里皮回归开门红！', 'http://img.kaiyanapp.com/9dd152caaf56864f7c76a71fcf7f0361.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=163059&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607081729, 1585981965);
INSERT INTO `video` VALUES (403, 4, 4, '精灵小仙女闯荡江湖，女扮男装围剿山贼', 'http://img.kaiyanapp.com/9f31028f4e275deef5a65407284c95ba.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=111799&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607332819, 1585981965);
INSERT INTO `video` VALUES (404, 4, 7, '爆笑解毒国足大战吉尔吉斯斯坦', 'http://img.kaiyanapp.com/4e1c039745d96d7dfb991f5f95e2bc06.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=145804&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (405, 4, 4, '德国队惊现防守大将，最强之人已在阵中？', 'http://img.kaiyanapp.com/500d5c01e9deff5aacb5e1de9771752f.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=164538&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607157727, 1585981965);
INSERT INTO `video` VALUES (406, 4, 3, '孙兴慜兮进球绝杀，国足球迷你酸了吗？', 'http://img.kaiyanapp.com/a742793650035675f86ad9fd09ebb384.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=156810&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (407, 4, 8, '北京老外图鉴——苏丹人的国足梦', 'http://img.kaiyanapp.com/87c0fe7441fb69bbd6168431a44d79b1.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=130119&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606720144, 1585981965);
INSERT INTO `video` VALUES (408, 4, 6, '「Take That Shit Off」舞蹈教程', 'http://img.kaiyanapp.com/b3fdbb9914ba62245a41b6b216788a97.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=110390&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 4, 0, 0, 0, 0, '', 2, 1607332678, 1585981965);
INSERT INTO `video` VALUES (409, 4, 5, '「爱·拆」OPPO R17 Pro拆解', 'http://img.kaiyanapp.com/9cea1602e969ec3917469f542d409ce2.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=142189&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (410, 4, 7, 'OPPO K3开箱上手：巴萨感觉的配色', 'http://img.kaiyanapp.com/c43bf5131ca538c7b6b9ffff6d7c2503.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=161132&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606392439, 1585981965);
INSERT INTO `video` VALUES (411, 4, 7, '开眼 x OPPO 欧洲艺术巡游', 'http://img.kaiyanapp.com/d515e8d51412e4772bd384908e9d4aae.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=165180&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607157941, 1585981965);
INSERT INTO `video` VALUES (412, 4, 8, '华为nova5 Pro星耀限定礼盒开箱', 'http://img.kaiyanapp.com/0b2a7de5d1d8df96520004958ea07052.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=164582&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607161244, 1585981965);
INSERT INTO `video` VALUES (413, 4, 5, 'OPPO K1开箱：性价比千元机？', 'http://img.kaiyanapp.com/27d485d83fd2c6b4bca4f57c0c068796.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=133434&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608479194, 1585981965);
INSERT INTO `video` VALUES (414, 4, 8, '「爱·拆」Reno 10倍变焦版拆解', 'http://img.kaiyanapp.com/1ad5d2a34b235eaf145271203a68dc54.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=157102&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 1, 3, 0, 0, '', 2, 1607172639, 1585981965);
INSERT INTO `video` VALUES (415, 4, 3, '宝马 R 1250 系列新车初体验', 'http://img.kaiyanapp.com/0541c7dd96df990048cf6e850dd9d0b3.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=168853&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606811243, 1585981965);
INSERT INTO `video` VALUES (416, 4, 3, '领先30年的强大安全技术是真是假？', 'http://img.kaiyanapp.com/8a467fa544075f35db2a65e3fc5b921e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=158313&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607324037, 1585981965);
INSERT INTO `video` VALUES (417, 4, 2, 'Reno手机10倍变焦版体验', 'http://img.kaiyanapp.com/3139f15952bf3fee4807b94309d12b49.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=156813&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (418, 4, 6, '《星战》里的R2-D2机器人走进现实啦！', 'http://img.kaiyanapp.com/739b7cfe73d25ef15db43290d4d72e18.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=144020&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (419, 4, 5, '《G星情报局》PCPI中国区预选赛集锦', 'http://img.kaiyanapp.com/69f6c59efd1383529e3e4120f27dfd9d.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138256&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606571907, 1585981965);
INSERT INTO `video` VALUES (420, 4, 6, '千千小伙伴们DIY日做寿司', 'http://img.kaiyanapp.com/5984c5340ea47ab08431f340401e67c0.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=134265&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606981067, 1585981965);
INSERT INTO `video` VALUES (421, 4, 7, '冲浪锦标赛最后一天', 'http://img.kaiyanapp.com/8f550663d9e5fc7df57dbd3eaf35fd50.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=144568&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (422, 4, 6, '这个视频重点是：万圣节“快乐”', 'http://img.kaiyanapp.com/c143f76227cf2388349fd8018c83027e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=135109&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606718158, 1585981965);
INSERT INTO `video` VALUES (423, 4, 4, '七步料理：韩式煎饼', 'http://img.kaiyanapp.com/dbfa7c68db73ea37fbdc5911725be07e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=130164&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1606996833, 1585981965);
INSERT INTO `video` VALUES (424, 4, 5, '驾车出行槽点多？他们用脑洞挑战出行难题', 'http://img.kaiyanapp.com/117685905223879e31f305af70613413.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=166277&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607312380, 1585981965);
INSERT INTO `video` VALUES (425, 4, 8, '第39个粉丝愿望：唱遍巴黎', 'http://img.kaiyanapp.com/db84ebfe9f2c95585c09c96a44bd9180.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=110091&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (426, 4, 6, '豆豉瓦片加小鱼，一个你想不到的真香组合！', 'http://img.kaiyanapp.com/095edffd05fa3b4ef19ddd5b426031c4.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136369&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (427, 4, 3, '多雷：我就是“别人家的孩子”', 'http://img.kaiyanapp.com/caec77fedfd4ded4ff368692b145fb62.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=147308&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607153988, 1585981965);
INSERT INTO `video` VALUES (428, 4, 5, '沙漠中的火人节#2 — 沙尘暴来袭', 'http://img.kaiyanapp.com/df578711e146eb9ca8285c31d1ef006d.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=127641&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (429, 4, 5, '香港这么美，请不要让她流下眼泪', 'http://img.kaiyanapp.com/a2992db7babd5d7a3305de7999e55727.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=169063&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606401686, 1585981965);
INSERT INTO `video` VALUES (430, 4, 5, '斯里兰卡冲浪之旅', 'http://img.kaiyanapp.com/91bd19ff2c8005310eb3cb03581215e1.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=145284&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332823, 1585981965);
INSERT INTO `video` VALUES (431, 4, 4, '民宿中国行贵州万峰林里最美的十大民宿推荐', 'http://img.kaiyanapp.com/8a3b95bc43d3b640319e2324e4abe37c.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=171551&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 12, 0, 0, '', 2, 1607167897, 1585981965);
INSERT INTO `video` VALUES (432, 4, 4, '暑假旅行攻略：在韩国千万不要做的 11 件事', 'http://img.kaiyanapp.com/228dc3a090248fef286ec21ba69dd153.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=165597&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607318577, 1585981965);
INSERT INTO `video` VALUES (433, 4, 1, '在班夫滑春雪', 'http://img.kaiyanapp.com/e54c68bf3550423ec214f695cf791ce6.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=159064&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (434, 4, 4, '暑假旅行攻略：去日本前必须知道的 10 件事', 'http://img.kaiyanapp.com/2917e26dc8aa92833aba81a1652f3810.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=165582&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607167739, 1585981965);
INSERT INTO `video` VALUES (435, 4, 4, '4 分钟游泰国，领略暹罗的人文和美景', 'http://img.kaiyanapp.com/50ecc8907f11dc5735b077e6ec1b4dc9.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=124601&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833692, 1585981965);
INSERT INTO `video` VALUES (436, 4, 6, '这样的假期我也想要，情侣同游巴厘岛', 'http://img.kaiyanapp.com/31adcd15945dc160bd50da2d1f15135e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=133955&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606707919, 1585981965);
INSERT INTO `video` VALUES (437, 4, 4, '「火人节」全世界艺术家放飞自我的天堂', 'http://img.kaiyanapp.com/a7c8c9d35c70f9ba9cba874abf2373ae.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=171121&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606831718, 1585981965);
INSERT INTO `video` VALUES (438, 4, 1, '世界十大旅行必去城市，你去过几个？', 'http://img.kaiyanapp.com/a6ac9f48b6b2e39d6a7db2a46df74b8e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=126129&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606721502, 1585981965);
INSERT INTO `video` VALUES (439, 4, 3, 'R&B 新人 Khalid「Better」MV', 'http://img.kaiyanapp.com/9e503bf9aa178d6efa59f2dd0043e822.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136721&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (440, 4, 5, 'A 妹根据亲身经历创作歌曲「breathin」MV', 'http://img.kaiyanapp.com/f4e75409a5989493fd7ca806d0ae8e1c.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136144&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606393070, 1585981965);
INSERT INTO `video` VALUES (441, 4, 8, '西语版舞女泪「BAGDAD」MV', 'http://img.kaiyanapp.com/ef8185d2de500f4474b85f933b4ccf08.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=141679&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1606993126, 1585981965);
INSERT INTO `video` VALUES (442, 4, 4, '洁匪新曲「Baby」不插电版 MV', 'http://img.kaiyanapp.com/a19bd9980409ea033c1fee985ea64416.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138138&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (443, 4, 7, '完美对你来说是什么？「Perfect To Me」MV', 'http://img.kaiyanapp.com/4650b791b570315e3e8197a618216978.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136319&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607325808, 1585981965);
INSERT INTO `video` VALUES (444, 4, 5, 'Jay Rock & Tee Grizzley「Shit Real」MV', 'http://img.kaiyanapp.com/cecee2b3940275930190078fc4b87ba0.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140565&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607162665, 1585981965);
INSERT INTO `video` VALUES (445, 4, 3, '前五美成员 Dinah Jane 个人首单「Bottled Up」MV', 'http://img.kaiyanapp.com/786f2248cd593f3f1ba9b4ed7a08611c.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136211&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607318217, 1585981965);
INSERT INTO `video` VALUES (446, 4, 2, '拉美天后 Shakira「Nada」MV', 'http://img.kaiyanapp.com/3ea56ef13ca33227f7f18718dbb85cc1.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136722&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (447, 4, 1, '数一数，Maluma 的床上睡了多少女人？', 'http://img.kaiyanapp.com/5c124c6b79aaaf0a8206f695096390cb.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=121468&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332793, 1585981965);
INSERT INTO `video` VALUES (448, 4, 2, 'Kiiara 绚丽的彩衣「Gloe」MV', 'http://img.kaiyanapp.com/e3c9890f8371bac22ff0a3f461bb814c.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=124110&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (449, 4, 8, '广东最“低调”的景点：山水秀丽堪比桂林', 'http://img.kaiyanapp.com/70b449c38a82012f0663502aae159364.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=112849&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607332797, 1585981965);
INSERT INTO `video` VALUES (450, 4, 4, '黄山大观', 'http://img.kaiyanapp.com/bb8d47c3461f6a5c5649ffbc75ffefd4.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=168558&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606581486, 1585981965);
INSERT INTO `video` VALUES (451, 4, 4, '南澳杨梅坑之旅-深圳最东端的度假胜地', 'http://img.kaiyanapp.com/665ffb3dfe97025e9287fd7cabfb03f2.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=111880&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607277072, 1585981965);
INSERT INTO `video` VALUES (452, 4, 3, '黄山不一样', 'http://img.kaiyanapp.com/d8b4f78c3fc16d512940b3bbeb05a97d.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=163017&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607083899, 1585981965);
INSERT INTO `video` VALUES (453, 4, 8, '黄山', 'http://img.kaiyanapp.com/c6faf06ae52a434d7a05080e023bada2.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=141725&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (454, 4, 2, '贝多芬：音乐大师也是数学天才', 'http://img.kaiyanapp.com/76b920242f13b7f99d2d93a4218aa943.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=142132&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (455, 4, 8, '黄山｜冬雪', 'http://img.kaiyanapp.com/f7fee5d467eb96cce9ec6759d61a2e31.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=145100&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (456, 4, 6, '带你体验下值两辆法拉利的奔驰SLR！', 'http://img.kaiyanapp.com/7fd5fb166dd00e6d40d332fa0305ad15.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=123103&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607158994, 1585981965);
INSERT INTO `video` VALUES (457, 4, 1, '西北第一村——白哈巴，原始的童话世界！', 'http://img.kaiyanapp.com/3410abd22c7900d28eb2e69beed5945c.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=169876&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607332673, 1585981965);
INSERT INTO `video` VALUES (458, 4, 4, '这里被誉为日本最幸福的地方，去什么东京！', 'http://img.kaiyanapp.com/ac34bf4ee180b0bf2762305adcec0bd4.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=163698&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606993039, 1585981965);
INSERT INTO `video` VALUES (459, 4, 2, '浓香四溢的豆豉麻油鸡，是对吃货的极度诱惑', 'http://img.kaiyanapp.com/f5fed0731fd7b183da03ccf7f1e8a033.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=120597&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 1, 0, 0, '', 2, 1607162676, 1585981965);
INSERT INTO `video` VALUES (460, 4, 2, '快速煲之火鸡胸肉', 'http://img.kaiyanapp.com/4c5efbf0ed407223407632756ed1846b.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138708&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607319781, 1585981965);
INSERT INTO `video` VALUES (461, 4, 3, '热情芒果奶油蛋糕', 'http://img.kaiyanapp.com/aa16c44eb14e88874cec0c704edcc0b5.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=141077&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833632, 1585981965);
INSERT INTO `video` VALUES (462, 4, 6, '麦旋风提拉米苏蛋糕', 'http://img.kaiyanapp.com/3aa8be8576dc22aecfd7714c95c5409b.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=141078&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607325964, 1585981965);
INSERT INTO `video` VALUES (463, 4, 6, '布蕾奶油饼干泡芙', 'http://img.kaiyanapp.com/d6b68c35d725db4d027e4e8b01021155.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=144080&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (464, 4, 3, '烘焙芝士风味蛋糕', 'http://img.kaiyanapp.com/a89bef541f834c613593fbeda60ad4bd.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138561&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 1, 0, 0, 0, '', 2, 1606393001, 1585981965);
INSERT INTO `video` VALUES (465, 4, 7, 'ASMR 甜品教程：蜂蜜起司蛋糕', 'http://img.kaiyanapp.com/ba53a8d879e6770ac24e3ea692448a80.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138235&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607312548, 1585981965);
INSERT INTO `video` VALUES (466, 4, 1, '肉食控专场！软嫩香酥的猪肉料理合集', 'http://img.kaiyanapp.com/c320b978bc203575f1fb06feb27ed88f.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=153644&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606725789, 1585981965);
INSERT INTO `video` VALUES (467, 4, 1, '夏日小清新：茶香虾仁', 'http://img.kaiyanapp.com/efa48d150bab26315d0e9e2fe99117e2.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=165016&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607150016, 1585981965);
INSERT INTO `video` VALUES (468, 4, 2, '戴吉利适合在餐前的一款开胃酒', 'http://img.kaiyanapp.com/a43aa70761bf78489643fcfb9e665c3f.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=112135&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607168705, 1585981965);
INSERT INTO `video` VALUES (469, 4, 8, '天津人的家常独面筋，绵香烫口谁吃谁喜欢', 'http://img.kaiyanapp.com/f66043e6401c2de6063efc6a2b6a67e7.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=172659&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833314, 1585981965);
INSERT INTO `video` VALUES (470, 4, 7, '「食语集」零厨艺好味道，虾仁青豆蒸滑蛋', 'http://img.kaiyanapp.com/0749bbdbafbace1bc70a467bc20a92c3.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=133142&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607164624, 1585981965);
INSERT INTO `video` VALUES (471, 4, 3, '「食语集」鲜鲜滑滑好味道，Q弹虾仁炒滑蛋', 'http://img.kaiyanapp.com/5645e55d67e8cb3cbc2c9c80e71fb23f.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=130231&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606716952, 1585981965);
INSERT INTO `video` VALUES (472, 4, 6, '零厨艺，几步就做好的快手家常菜：豉油鸡腿', 'http://img.kaiyanapp.com/557262c5cc27e68addd7b2a1e6f1e4d8.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138877&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (473, 4, 6, '《食语集》重庆芋儿鸡，芋儿糯糯鸡肉香！', 'http://img.kaiyanapp.com/abf0fbf3b1d1acafbeb42011d8af94a4.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=127378&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607329797, 1585981965);
INSERT INTO `video` VALUES (474, 4, 8, '快手家常菜：豉油口水鸭，不过瘾算我输', 'http://img.kaiyanapp.com/b8741430b1cd0abc28800d03042bc2e9.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139352&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608458498, 1585981965);
INSERT INTO `video` VALUES (475, 4, 3, '「食语集」滚滚而来的美味：香煎孜然小土豆', 'http://img.kaiyanapp.com/8343deeceb2129e1f77e882b4ff0837a.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=128401&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607253430, 1585981965);
INSERT INTO `video` VALUES (476, 4, 4, '美美的虾仁蟹黄豆腐，原来一个咸鸭蛋就搞定', 'http://img.kaiyanapp.com/470eddf66c1fb9db8f1c92c68bc0fbcc.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=112395&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606563930, 1585981965);
INSERT INTO `video` VALUES (477, 4, 4, '吃不到谢霆锋做的菜，我就吃他的锋味月饼！', 'http://img.kaiyanapp.com/30acdfa26366d0c836c70c7c0652763e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=127654&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606718135, 1585981965);
INSERT INTO `video` VALUES (478, 4, 3, '茄子新吃法，糖酥麻仁茄子，外脆里嫩满口香', 'http://img.kaiyanapp.com/45e76624c22f1ecbc2b33971c09f4fbe.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=133640&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (479, 4, 4, '同样是豪宅，女儿奴的家总是那么不一样', 'http://img.kaiyanapp.com/186a974bda998ede76bc58b7a8197040.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=169166&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (480, 4, 3, '「杀手 6」万圣节礼包预告片', 'http://img.kaiyanapp.com/4cb0d26406c7cbdbe9f2b3cb14e48dfc.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=133355&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1606993043, 1585981965);
INSERT INTO `video` VALUES (481, 4, 8, '《清新视界第十季》第1期：谷心平', 'http://img.kaiyanapp.com/8f0ef273e7fb0e0fe7904012a3836d85.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=133985&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (482, 4, 4, '10 天带你玩转 6 个欧洲国家！', 'http://img.kaiyanapp.com/4a75bbc3096b9a24324fa206e574e8d1.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=148578&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606832039, 1585981965);
INSERT INTO `video` VALUES (483, 4, 6, '长泽雅美 KUBOTA「德国拖拉机」篇', 'http://img.kaiyanapp.com/14236fa146cb61c526a7cfa1cfca44ce.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=120580&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607164757, 1585981965);
INSERT INTO `video` VALUES (484, 4, 6, '研究出物理界一半公式的科学家居然是社恐！', 'http://img.kaiyanapp.com/f9e172e0d82c628f39b69f3967715fa2.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140299&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607323436, 1585981965);
INSERT INTO `video` VALUES (485, 4, 2, '【物造东方】全世界最好的家人召唤神器！', 'http://img.kaiyanapp.com/eef6257110c5f65543d1031909e4647f.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=169505&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606564289, 1585981965);
INSERT INTO `video` VALUES (486, 4, 1, '丹麦反思动画：捕鲸父子的故事', 'http://img.kaiyanapp.com/e2ff287302854bc4f74cd304a63fb748.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=119209&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607332813, 1585981965);
INSERT INTO `video` VALUES (487, 4, 2, '《苗岭银饰 响叮当》—— 雷山县银饰  ', 'http://img.kaiyanapp.com/97f111c6a08be4c0fabb809d3f8d1d46.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=128082&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606579092, 1585981965);
INSERT INTO `video` VALUES (488, 4, 5, '创意趣味广告：一对好姐妹( • )( • )', 'http://img.kaiyanapp.com/ff3d8b4f36111b51a2e319351926571e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=141773&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (489, 4, 5, '温柔的忧郁：即便没有光也能照亮你的心', 'http://img.kaiyanapp.com/dc4ce51cd6a9e27cb0316d4d11fc8d22.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=124435&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833107, 1585981965);
INSERT INTO `video` VALUES (490, 4, 7, '青岛印象·雪', 'http://img.kaiyanapp.com/2e6a5acafa2876386ff7e2175c864f41.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=151115&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607078721, 1585981965);
INSERT INTO `video` VALUES (491, 4, 1, '天冷了，来碗热腾腾的咖喱海鲜炒饭吧！', 'http://img.kaiyanapp.com/35659f2d463f396a3de6b1e5d841c0d9.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=135130&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606822363, 1585981965);
INSERT INTO `video` VALUES (492, 4, 3, '没什么秋愁，是一块桂花糕治愈不了的！', 'http://img.kaiyanapp.com/2ff91c01e66c77f91b369a9e305df21b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=172322&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607318943, 1585981965);
INSERT INTO `video` VALUES (493, 4, 7, '【古法腊肠】冬腊风腌，蓄以御冬', 'http://img.kaiyanapp.com/6ae24177a69a27d67dc23e265a0d4c28.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139807&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1608437788, 1585981965);
INSERT INTO `video` VALUES (494, 4, 1, '男士靴子这样穿才够酷！', 'http://img.kaiyanapp.com/c575883b1fbea2d9020fce434c574e1b.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=146098&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607159518, 1585981965);
INSERT INTO `video` VALUES (495, 4, 3, '蒜泥狠！不爱吃五花肉的我，倒戈了', 'http://img.kaiyanapp.com/475bd33f4b5fd3699cc0dfbfec1d9e7d.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136200&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606831872, 1585981965);
INSERT INTO `video` VALUES (496, 4, 4, '郁闷的下雨天，来一口酸辣粉丝让心情好起来', 'http://img.kaiyanapp.com/d3ec47bf476dd86aac28bef3f0f6e576.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=124961&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981965, 1585981965);
INSERT INTO `video` VALUES (497, 4, 8, '荷兰豆荸荠炒香肠，忍不住恋上这味道', 'http://img.kaiyanapp.com/596546c70e0aeda78a40583c8c8fbb6e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=163803&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332822, 1585981965);
INSERT INTO `video` VALUES (498, 4, 1, '广州也能吃到极品臭豆腐：下雨生意也火爆！', 'http://img.kaiyanapp.com/e9f7525aa22c72eec52c955c300b079d.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=114783&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1608563553, 1585981965);
INSERT INTO `video` VALUES (499, 4, 2, '巧克力布丁', 'http://img.kaiyanapp.com/be6dd87ca214e0d66b0c1ad4ceaa98db.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139676&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833728, 1585981965);
INSERT INTO `video` VALUES (500, 4, 3, '无需烘焙的甜点：无麸质芝士蛋糕', 'http://img.kaiyanapp.com/da80465a113990e4d8714811833a898a.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=116457&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607167589, 1585981965);
INSERT INTO `video` VALUES (501, 4, 5, '焦糖布丁的美味之旅', 'http://img.kaiyanapp.com/fbdcd884db3bfb9146acf690ee8f3871.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139968&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606401814, 1585981985);
INSERT INTO `video` VALUES (502, 4, 4, '散发着杏仁香气的巧克力夹心薄脆', 'http://img.kaiyanapp.com/8fac2476bf0b922e3bc6183802c5d582.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=116465&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607317967, 1585981985);
INSERT INTO `video` VALUES (503, 4, 7, 'ASMR 甜品教程：蓝莓奶油芝士蛋挞', 'http://img.kaiyanapp.com/f5f74808db56a079052f8fc463514846.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=116582&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (504, 4, 2, '食谱：如何制作南瓜饼', 'http://img.kaiyanapp.com/30e009025c70b51dc4c56bd8f4e41c0c.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=117346&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833340, 1585981985);
INSERT INTO `video` VALUES (505, 4, 4, 'ASMR 甜品教程：焦糖布丁蛋糕', 'http://img.kaiyanapp.com/fadc81ef500b17aaa5dcb56a16bf3c76.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136778&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606566130, 1585981985);
INSERT INTO `video` VALUES (506, 4, 2, '食谱：如何制作杏仁奶油香蕉吐司', 'http://img.kaiyanapp.com/83641700a485f9a81cce812e8231a9fb.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=117350&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (507, 4, 4, '食谱：如何制作爆米花棉花糖蛋糕', 'http://img.kaiyanapp.com/5fc7509c2608e321cbb73796104286f4.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=118341&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606981145, 1585981985);
INSERT INTO `video` VALUES (508, 4, 8, '少女心满分的凯蒂猫奶酪慕斯蛋糕', 'http://img.kaiyanapp.com/58a1aab2ba17b2807c9ec83d17dbf4cf.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=118936&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606832499, 1585981985);
INSERT INTO `video` VALUES (509, 4, 3, '迷幻视觉动画：衍生', 'http://img.kaiyanapp.com/a88051ea8321208bdb818da6a0849c8d.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=114249&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833343, 1585981985);
INSERT INTO `video` VALUES (510, 4, 8, '北方人烙大饼，真的很有门道！', 'http://img.kaiyanapp.com/3de748e11693c0371932a8a57b7c7757.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=118624&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (511, 4, 3, '宁静湖畔别墅：舒适度假生活', 'http://img.kaiyanapp.com/5c6e6dd2ff54ad9729bf4d78f4b65781.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=121118&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607325959, 1585981985);
INSERT INTO `video` VALUES (512, 4, 5, '说到啪啪啪，多久才算久？', 'http://img.kaiyanapp.com/6e96a95efcaffdb16194e287f296dd9b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=121997&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 11, 0, 0, '', 2, 1606833349, 1585981985);
INSERT INTO `video` VALUES (513, 4, 5, '在太空中啪啪啪是一种什么样的体验？', 'http://img.kaiyanapp.com/06b9200565c4dd09a2dd4d779ee13314.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=122677&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606394914, 1585981985);
INSERT INTO `video` VALUES (514, 4, 8, '穷游陕西西安，吃到正宗的凉皮小吃！', 'http://img.kaiyanapp.com/7c36d4790ba49769a1fa7358f4e7881f.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=142519&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607325935, 1585981985);
INSERT INTO `video` VALUES (515, 4, 7, '14 个关于啪啪啪的酷炫事实', 'http://img.kaiyanapp.com/62a3beb2b17914e512fd51efebe5336e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=145230&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (516, 4, 3, '7 个理由告诉你为什么一定要啪啪啪', 'http://img.kaiyanapp.com/46abf517217f52c1b64f38676e9d3596.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=146161&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606568174, 1585981985);
INSERT INTO `video` VALUES (517, 4, 3, '「爱，死亡和机器人」第 14 集「知马蓝」', 'http://img.kaiyanapp.com/30c46e290ad7e7b0b2bb22d8f4a801f6.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=154749&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607253778, 1585981985);
INSERT INTO `video` VALUES (518, 4, 5, '「爱，死亡和机器人」第11集「帮手」', 'http://img.kaiyanapp.com/77662592e4de1e6f143f9f6bb59bff4f.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=155148&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (519, 4, 2, '30年前，中国没有人比她更红了', 'http://img.kaiyanapp.com/fa3d8ab6eb656f2e85884c11f656c7b0.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=118032&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1606926552, 1585981985);
INSERT INTO `video` VALUES (520, 4, 4, '她28岁拍下一部禁片，5年后成奥斯卡评委', 'http://img.kaiyanapp.com/0635e36d57cafa70057408db078cc8b2.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=118514&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1606981723, 1585981985);
INSERT INTO `video` VALUES (521, 4, 6, '啪啪啪的时候，你有特别的癖好吗？', 'http://img.kaiyanapp.com/59537fb3478f6987e1f07a91912422ca.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=121761&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (522, 4, 3, '视效集锦短片：思维的形状', 'http://img.kaiyanapp.com/382f16a2c400d62fbfa186264809d157.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=125069&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608430914, 1585981985);
INSERT INTO `video` VALUES (523, 4, 8, '别否认，这就是日常「失控」的你', 'http://img.kaiyanapp.com/ff70db7c34b3d3698e92909e5d8d65e7.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=125620&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607325615, 1585981985);
INSERT INTO `video` VALUES (524, 4, 4, '关于啪啪啪，你一定不知道的 14 个冷知识', 'http://img.kaiyanapp.com/d3a1e395ddc9da0bea05d4d8b48d6808.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=127968&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607154141, 1585981985);
INSERT INTO `video` VALUES (525, 4, 8, '泰国搞笑广告：媳妇大战婆婆', 'http://img.kaiyanapp.com/f5c641b0808c84b7cc0435d1a5f371f4.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=128508&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606831790, 1585981985);
INSERT INTO `video` VALUES (526, 4, 3, '爆笑短片：一个人吃饭如何避免尴尬？', 'http://img.kaiyanapp.com/c772ba5818fd7a54f0bb4b76517d0335.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=131097&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607149357, 1585981985);
INSERT INTO `video` VALUES (527, 4, 7, '他50岁，不顾妻儿反对，变性为一个女人', 'http://img.kaiyanapp.com/c9acd3b71c3f20484fcf28d731c35248.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=137296&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607318874, 1585981985);
INSERT INTO `video` VALUES (528, 4, 8, '搞笑动画：我听不见穷人讲话', 'http://img.kaiyanapp.com/637f193bcd2ff06de82c53cc8d2d6ef0.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=148005&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608522595, 1585981985);
INSERT INTO `video` VALUES (529, 4, 1, '茄子这样烧，鲜香入味补气血！', 'http://img.kaiyanapp.com/94e4defb221f8450b02c3aeefe6229ac.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=116264&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (530, 4, 2, '我想和你好好相处，好像不太可能？', 'http://img.kaiyanapp.com/b6c545d43660065d02900c14dea0eed0.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=121641&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608563540, 1585981985);
INSERT INTO `video` VALUES (531, 4, 5, '5 分钟了解保时捷 911 全系车型', 'http://img.kaiyanapp.com/0c1556957c66688a384f1df795f324d0.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=134549&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607955105, 1585981985);
INSERT INTO `video` VALUES (532, 4, 8, '新疆美食-凉皮', 'http://img.kaiyanapp.com/ab8674ff40b09ffee27f1f4564c30a9d.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=134596&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (533, 4, 2, '聆听山与水的声音：探索加拿大班夫公园', 'http://img.kaiyanapp.com/61d01c15f5b4e881edbb5e4537d73746.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136121&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 12, 0, 0, '', 2, 1607953916, 1585981985);
INSERT INTO `video` VALUES (534, 4, 3, '创意品牌短片：珠宝的魅力', 'http://img.kaiyanapp.com/bda959b81abfe05d8a0da0c67aea2720.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=137922&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833636, 1585981985);
INSERT INTO `video` VALUES (535, 4, 5, '女性亲身解答，钱赚得越多就越不焦虑吗？', 'http://img.kaiyanapp.com/0c3b2b85ec1f53f2902fc6833087dc31.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=141177&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 4, 1, 0, 0, 0, '', 2, 1608479203, 1585981985);
INSERT INTO `video` VALUES (536, 4, 6, '穷游西安街头：一碗羊杂汤，一份爽口凉皮', 'http://img.kaiyanapp.com/a6823c8620456d905ded42a97005bcf9.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=143512&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606395775, 1585981985);
INSERT INTO `video` VALUES (537, 4, 1, '青海羊肉串不坑人：9毛9一串！', 'http://img.kaiyanapp.com/06c639f96e76aaa15051438b6074d009.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=146386&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607276979, 1585981985);
INSERT INTO `video` VALUES (538, 4, 5, '「爱，死亡和机器人」第 10 集「易形」', 'http://img.kaiyanapp.com/ab35a16cbd4a51d5f1279b897383213f.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=154748&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607270377, 1585981985);
INSERT INTO `video` VALUES (539, 4, 1, '奥比都斯：国王送给王后的礼物成了结婚圣地', 'http://img.kaiyanapp.com/0e6d9c9ad06e432f053bd6e595df44f8.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=117375&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607261795, 1585981985);
INSERT INTO `video` VALUES (540, 4, 6, '教师节，我们每人给老师做一朵可以吃的玫瑰', 'http://img.kaiyanapp.com/04870deb18b59cec4ba7ce38fef7b2be.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=126307&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (541, 4, 3, '76岁奶奶用8年亲手为自己造房', 'http://img.kaiyanapp.com/96cc521b7bdca760e193d128143f9489.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=148604&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (542, 4, 1, '镂空的艺术，两个10年的守候！', 'http://img.kaiyanapp.com/2ec4746090e9b615197326c897de77df.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=125866&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (543, 4, 3, '恐怖经典翻拍！新版「鬼娃回魂」预告', 'http://img.kaiyanapp.com/f6e35003e7d57fcd3bd13ad8a3a8b2d6.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=157894&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606395693, 1585981985);
INSERT INTO `video` VALUES (544, 4, 4, '他卖掉别墅住进山洞，引爆争议', 'http://img.kaiyanapp.com/972ee6f5120453b625735aec98d40441.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=141011&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607332734, 1585981985);
INSERT INTO `video` VALUES (545, 4, 1, 'AR日历了解一下，让你和健忘症说拜拜', 'http://img.kaiyanapp.com/3c8c774529d12dcb38c2d37b98c47d3b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=113900&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 5, 0, 0, '', 2, 1607166660, 1585981985);
INSERT INTO `video` VALUES (546, 4, 6, '养颜早餐香椿千层饼，错过还要等一年！', 'http://img.kaiyanapp.com/189ee205e6e0531e1ad5d1ce6762abb4.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=156189&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606389715, 1585981985);
INSERT INTO `video` VALUES (547, 4, 1, '16岁少年捐器官救7人，组成一个人篮球队', 'http://img.kaiyanapp.com/34d8752c11fb9abca860c9d05930a521.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=152850&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606710112, 1585981985);
INSERT INTO `video` VALUES (548, 4, 4, '一个数学老师，造了栋土房子，打败日本大师', 'http://img.kaiyanapp.com/3a17dd30794a59e0989fb4b2930d8294.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=134367&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606581489, 1585981985);
INSERT INTO `video` VALUES (549, 4, 2, '第29集：中国凭什么成为AI大国？', 'http://img.kaiyanapp.com/d0c01f4bffcf98d0da8b1da8dc0962d9.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139396&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 2, 0, 0, '', 2, 1607165487, 1585981985);
INSERT INTO `video` VALUES (550, 4, 8, '【第7集】AI翻身做主人，为什么不可能？', 'http://img.kaiyanapp.com/13f3b0c367c5f1126578f524accad48d.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=129368&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (551, 4, 6, '第36集：AI面前，人人赤裸？', 'http://img.kaiyanapp.com/b8762414c860788f536044e2a2c4b6e4.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=142021&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607848512, 1585981985);
INSERT INTO `video` VALUES (552, 4, 7, '第27集：有AI，再无人买车？', 'http://img.kaiyanapp.com/2ed04ccc80e646ec4635ad7ef80deb9b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140282&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607157534, 1585981985);
INSERT INTO `video` VALUES (553, 4, 6, '第31集：AI七大“列强”将瓜分世界？', 'http://img.kaiyanapp.com/d4fe3b8fcf8f1840b3eb2cceb38f1de0.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140257&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833309, 1585981985);
INSERT INTO `video` VALUES (554, 4, 3, '中国的AI成功的秘诀，美国也得服！', 'http://img.kaiyanapp.com/314cfbbbddef87b47974b502cab2fc8a.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140288&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (555, 4, 2, '第27集：AI是最完美的员工？', 'http://img.kaiyanapp.com/7f0dab9eaf0bed6ac61e1ab97345e6ad.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138486&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606988274, 1585981985);
INSERT INTO `video` VALUES (556, 4, 3, '第13集：AI工程师，未来最稳妥的职业？', 'http://img.kaiyanapp.com/6c84cd5ccdd3857fc36d645aa9fe62f4.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=132923&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332737, 1585981985);
INSERT INTO `video` VALUES (557, 4, 1, '第30集：未来AI世界，会出现三国争霸吗', 'http://img.kaiyanapp.com/314cfbbbddef87b47974b502cab2fc8a.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139791&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606810466, 1585981985);
INSERT INTO `video` VALUES (558, 4, 1, '为什么越来越的年轻人不想要孩子？', 'http://img.kaiyanapp.com/5e6cf8dccbfd69bc46911311a3c5ce47.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=128172&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833106, 1585981985);
INSERT INTO `video` VALUES (559, 4, 7, '水滴之冒险，生命之灵性', 'http://img.kaiyanapp.com/b7522c92fe7d9b2a2ca0266900441aa4.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=148494&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607930815, 1585981985);
INSERT INTO `video` VALUES (560, 4, 2, '脑洞大开：发现生活里的乐趣', 'http://img.kaiyanapp.com/62702848579a7363b5a1b406899f6277.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=145939&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (561, 4, 8, '魔幻而绚丽：光线之舞', 'http://img.kaiyanapp.com/afa2513f7b6e47ee81e970588c832736.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=142089&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607318363, 1585981985);
INSERT INTO `video` VALUES (562, 4, 5, '酷炫作品集锦：浩瀚太空', 'http://img.kaiyanapp.com/a6805a78377e02f692cebafaa4615c80.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=142869&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607953940, 1585981985);
INSERT INTO `video` VALUES (563, 4, 6, '关于「圆」的奇思妙想', 'http://img.kaiyanapp.com/c5e5557634574371549cf0f8189dbc76.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=134156&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (564, 4, 5, '黑白创意实验性短片：叠加', 'http://img.kaiyanapp.com/2c2feba5b75d5842e83fd612d06f03f1.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=137956&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 4, 0, 0, '', 2, 1607166390, 1585981985);
INSERT INTO `video` VALUES (565, 4, 3, '迷失东京：朦胧中发现日本之美', 'http://img.kaiyanapp.com/4ada3a5b876c9e1a4d7c972ee38f89b9.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=146868&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606390859, 1585981985);
INSERT INTO `video` VALUES (566, 4, 5, '夜景摄影短片：动物们的夜生活', 'http://img.kaiyanapp.com/3f881dc6a0c3d65ff90686c9a1c75add.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140121&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (567, 4, 7, '探索物质世界里的奥妙', 'http://img.kaiyanapp.com/879e5cada6557659ea1f29dc0b15cc87.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=133711&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607318361, 1585981985);
INSERT INTO `video` VALUES (568, 4, 7, '「英雄联盟」暗黑短片：阿木木的宇宙', 'http://img.kaiyanapp.com/f145ed98a628766b84b3aa876fe40d3f.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=135833&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 1, 0, 0, '', 2, 1607312963, 1585981985);
INSERT INTO `video` VALUES (569, 4, 2, '超级无敌海鲜船！大胃王见到都怕', 'http://img.kaiyanapp.com/9856a6e92bcdcf7a175ef471699f37e8.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=126835&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (570, 4, 4, '分身乏术不可能，看杨幂高能演技', 'http://img.kaiyanapp.com/1dbff90e7e84974f8180e4b502e4cc69.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=117582&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (571, 4, 4, '为什么金钱买不到快乐？', 'http://img.kaiyanapp.com/371c29e7695ac0b048f1c8550beab894.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=153779&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1608458977, 1585981985);
INSERT INTO `video` VALUES (572, 4, 5, '大家在吐槽的时候，老外被春晚震惊!', 'http://img.kaiyanapp.com/818fa4fd9367ae0282783d49128827c2.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=149375&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607153340, 1585981985);
INSERT INTO `video` VALUES (573, 4, 7, '动物界的智商之最', 'http://img.kaiyanapp.com/e7e518c88463363853a935316bf787ed.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=133402&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607083849, 1585981985);
INSERT INTO `video` VALUES (574, 4, 2, '苹果发布会新品预测，有你心仪的 iPhone 么？', 'http://img.kaiyanapp.com/59a6a1918a01a894e1199effd58746e5.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=172407&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606830308, 1585981985);
INSERT INTO `video` VALUES (575, 4, 3, '最佳俄罗斯失败集锦', 'http://img.kaiyanapp.com/bf617f66b427630db3f11f31db281b07.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=128482&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1608178461, 1585981985);
INSERT INTO `video` VALUES (576, 4, 3, '英伦街头自由滑行，感受轮滑圣地伦敦', 'http://img.kaiyanapp.com/295e0c879862e9c1e5de138cc74831a2.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=159143&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606390584, 1585981985);
INSERT INTO `video` VALUES (577, 4, 7, '人生何止一串，还有霸气鲍鱼焖鸡煲', 'http://img.kaiyanapp.com/f3792938f13b156a6724dd64755898bd.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=118427&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1608563512, 1585981985);
INSERT INTO `video` VALUES (578, 4, 2, '葡萄牙人过节癖好多，人手一个锤子见谁砸谁', 'http://img.kaiyanapp.com/e651814cdc3d0bebacc5c6d4d6a55c7a.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=164860&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833110, 1585981985);
INSERT INTO `video` VALUES (579, 4, 3, '十里桃花已经开满林芝，还在办公室加班吗？', 'http://img.kaiyanapp.com/b204af5925b2ad4a99f44cf2ff815c7f.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=155409&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606725134, 1585981985);
INSERT INTO `video` VALUES (580, 4, 8, '2018年世界花式纸牌大会官方高清版视频', 'http://img.kaiyanapp.com/4401b9973dba3becdddf09efdeee5b20.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=151937&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (581, 4, 3, 'SwissPeaks360K值不值得去？', 'http://img.kaiyanapp.com/1c1693444800daca85e7dad785598975.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=128305&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607158728, 1585981985);
INSERT INTO `video` VALUES (582, 4, 1, '长达360公里的超级越野跑瑞士360', 'http://img.kaiyanapp.com/8cdddc27472684f9e4c031ccd5648783.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=127643&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606993374, 1585981985);
INSERT INTO `video` VALUES (583, 4, 6, '澳大利亚人把“反串”也变成了艺术？', 'http://img.kaiyanapp.com/25618d874c36bbb81a488d3ba2ced331.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=172547&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332744, 1585981985);
INSERT INTO `video` VALUES (584, 4, 3, '航拍潍坊第三十六届国际风筝节', 'http://img.kaiyanapp.com/2714f30eb18b5fad0f9b652757747797.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=158424&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607164899, 1585981985);
INSERT INTO `video` VALUES (585, 4, 5, '你可低估了这个城市人民的爱水程度', 'http://img.kaiyanapp.com/d8785a353abb0ebd946102f2e24effac.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=167222&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833583, 1585981985);
INSERT INTO `video` VALUES (586, 4, 7, '隐蔽的物：关于“物”的创作方法', 'http://img.kaiyanapp.com/39749040686e4a69653a1fb97b73c848.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=131050&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607158637, 1585981985);
INSERT INTO `video` VALUES (587, 4, 7, '2018 第 70 届艾美奖爆笑讽刺短片', 'http://img.kaiyanapp.com/8504cbb0cf87fd8f63ee30ccf7d8f72c.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=127551&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606823953, 1585981985);
INSERT INTO `video` VALUES (588, 4, 6, '一只平底锅就能做的极品早餐', 'http://img.kaiyanapp.com/3e4508584553d5257a681371de32c3cd.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=10112&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606830426, 1585981985);
INSERT INTO `video` VALUES (589, 4, 3, '他坚持45年, 拍摄有趣的灵魂', 'http://img.kaiyanapp.com/f10bceae3d46312f6881b8917bf0dc54.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=110090&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 3, 0, 0, '', 2, 1607318072, 1585981985);
INSERT INTO `video` VALUES (590, 4, 2, '迷幻视觉动画：衍生', 'http://img.kaiyanapp.com/a88051ea8321208bdb818da6a0849c8d.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=114249&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (591, 4, 6, '比起打败对手，更难的是战胜自己', 'http://img.kaiyanapp.com/f88b5e2d1b6f1831ff1203faefa7208e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=114409&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833111, 1585981985);
INSERT INTO `video` VALUES (592, 4, 7, '啪啪啪的时候，快乐究竟来自哪里？', 'http://img.kaiyanapp.com/d3986816daf9daac9f03064b83cefd47.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=116661&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1608460684, 1585981985);
INSERT INTO `video` VALUES (593, 4, 5, '说到啪啪啪，多久才算久？', 'http://img.kaiyanapp.com/6e96a95efcaffdb16194e287f296dd9b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=121997&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606364791, 1585981985);
INSERT INTO `video` VALUES (594, 4, 4, '在太空中啪啪啪是一种什么样的体验？', 'http://img.kaiyanapp.com/06b9200565c4dd09a2dd4d779ee13314.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=122677&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606725410, 1585981985);
INSERT INTO `video` VALUES (595, 4, 6, '2 分钟了解女性「啪啪啪」全过程', 'http://img.kaiyanapp.com/b791ff216f44bf9f336480c95b362cb7.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139529&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607277012, 1585981985);
INSERT INTO `video` VALUES (596, 4, 6, '14 个关于啪啪啪的酷炫事实', 'http://img.kaiyanapp.com/62a3beb2b17914e512fd51efebe5336e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=145230&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607787438, 1585981985);
INSERT INTO `video` VALUES (597, 4, 7, '7 个理由告诉你为什么一定要啪啪啪', 'http://img.kaiyanapp.com/46abf517217f52c1b64f38676e9d3596.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=146161&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (598, 4, 1, '复古港风妆 我真的超爱这个妆！', 'http://img.kaiyanapp.com/464d95f02044a677b2e679820e16c20a.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=142667&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 2, 0, 0, '', 2, 1607163916, 1585981985);
INSERT INTO `video` VALUES (599, 4, 2, '黄绿眼妆，超美牛油果妆容', 'http://img.kaiyanapp.com/6731df2414cf39f6385fb3ffcbb6f3c4.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=135729&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (600, 4, 1, '冬日炼瓦色系妆容 可以说很温柔了', 'http://img.kaiyanapp.com/b7da8aae32af91d0f3300c0f63ced22c.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138029&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608479189, 1585981985);
INSERT INTO `video` VALUES (601, 4, 1, '满满的购物欲！9 月购物分享 + 妆容 ', 'http://img.kaiyanapp.com/ad92be702f21f1b171f1bd9426db6d77.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=132519&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1608178408, 1585981985);
INSERT INTO `video` VALUES (602, 4, 6, '欧美复古红妆容，枫叶的颜色！', 'http://img.kaiyanapp.com/abdb665fc32d36a2550644500c07f383.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=126068&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (603, 4, 1, '超适合拍照用的闪亮珍珠美艳妆', 'http://img.kaiyanapp.com/59032799ff26ea0b8569dbbcebb304da.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=134340&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606832443, 1585981985);
INSERT INTO `video` VALUES (604, 4, 8, '温柔本人！韩剧「内在美」女二李多喜仿妆', 'http://img.kaiyanapp.com/5595369cb2f171ca34edad71f39f6782.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140110&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607955036, 1585981985);
INSERT INTO `video` VALUES (605, 4, 6, '秋冬新尝试 橘色系蜂蜜黄油妆容', 'http://img.kaiyanapp.com/32c7e8e727ae34d02f9e860fc89995af.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140883&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607312784, 1585981985);
INSERT INTO `video` VALUES (606, 4, 1, '秋冬新尝试：橘色系蜂蜜黄油妆容', 'http://img.kaiyanapp.com/32c7e8e727ae34d02f9e860fc89995af.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136607&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608455415, 1585981985);
INSERT INTO `video` VALUES (607, 4, 2, '圣诞妆容第一弹！软妹必备 无敌可爱！', 'http://img.kaiyanapp.com/ec41837db78b913176f54fc990295ae4.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=142669&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607153847, 1585981985);
INSERT INTO `video` VALUES (608, 4, 3, 'Malafacha | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/b23134d4a1ecd31537ee6e8e9c7184d0.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139246&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606708411, 1585981985);
INSERT INTO `video` VALUES (609, 4, 1, 'Anuar Lyon | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/5bef17b87074c39770a05afb79f247b6.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139276&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (610, 4, 3, 'Rcano | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/6703fc73a139f33670f090ee81e0128e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139248&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (611, 4, 8, 'Kris Goyri | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/3b4e09d372527200f76f685e7fadc1ec.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139277&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833759, 1585981985);
INSERT INTO `video` VALUES (612, 4, 4, 'Galo Bertin | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/f5d998f4469e634e01eab7f4c1da7e31.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139271&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606831655, 1585981985);
INSERT INTO `video` VALUES (613, 4, 1, '包 | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/cfe0038de34a66e7486818c67092a7be.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139719&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (614, 4, 4, 'Alexa Chung | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/57359761a1e04f3d15afce258228fcbc.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138068&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (615, 4, 7, 'Cynthia Buttenklepper | 2019 年春夏秀', 'http://img.kaiyanapp.com/0655a39b160170f396913a0e970422b6.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138889&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607318106, 1585981985);
INSERT INTO `video` VALUES (616, 4, 4, 'Sankuanz | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/f1b2460a8ffabce569b7228adc47fc5d.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=141276&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606826893, 1585981985);
INSERT INTO `video` VALUES (617, 4, 4, 'DM 小姐 | 2019 年春夏全时装秀 ', 'http://img.kaiyanapp.com/0acad7ae42f014e95d9a0a236658bdc2.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138054&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (618, 4, 8, '「翻车了吗」收了台3年前的手机', 'http://img.kaiyanapp.com/456a8b2de2d08a4025bc12a83a072450.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=157944&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (619, 4, 3, '「Koala Vlog」难得的忙里偷闲', 'http://img.kaiyanapp.com/2571ef502459754e5def7c866987475c.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=165401&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (620, 4, 2, 'Koala Vlog-教科书式搭讪小姐姐', 'http://img.kaiyanapp.com/8409467febba2cf5bbaace0a913acc44.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=166800&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606993371, 1585981985);
INSERT INTO `video` VALUES (621, 4, 8, '最值得推荐的 20 款任天堂 Switch 游戏', 'http://img.kaiyanapp.com/a00ddb91ee9d7ff487a491b150cd3a87.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=122336&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607150052, 1585981985);
INSERT INTO `video` VALUES (622, 4, 8, '「爱·吃」16种辅料煮的泡面是什么味？', 'http://img.kaiyanapp.com/064d70388c520c92eac492879cf587de.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=167648&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 3, 0, 0, '', 2, 1608261240, 1585981985);
INSERT INTO `video` VALUES (623, 4, 6, '新垣结衣：「Life is Your Life.」', 'http://img.kaiyanapp.com/9d887714d1016fbd5a05ceb6664359fa.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=130499&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607332825, 1585981985);
INSERT INTO `video` VALUES (624, 4, 2, '探壮阔沙漠，访约旦千年古迹', 'http://img.kaiyanapp.com/f518a08cfddbc703480db839e8e3e633.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136819&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606395931, 1585981985);
INSERT INTO `video` VALUES (625, 4, 5, '这是一条告别视频，是时候做个了结了', 'http://img.kaiyanapp.com/c2fe84b0fa9ac1a433f2c9fdfeb0c23c.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=135273&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607322595, 1585981985);
INSERT INTO `video` VALUES (626, 4, 7, '把 PS4 带到户外：构建便携式游戏主机', 'http://img.kaiyanapp.com/9388b0d21ec582c91cc03dd7c3e5d464.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=144057&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833634, 1585981985);
INSERT INTO `video` VALUES (627, 4, 2, 'OPPO K1上手：冲小米8青春版来的？', 'http://img.kaiyanapp.com/2d49baece21ac87200c4ba5403908616.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=133981&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606823552, 1585981985);
INSERT INTO `video` VALUES (628, 4, 1, '用物品演奏音乐：杯子交响曲', 'http://img.kaiyanapp.com/6d1b5ccb0495687252542a727e9964d1.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=118592&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606992785, 1585981985);
INSERT INTO `video` VALUES (629, 4, 3, '杭三丁', 'http://img.kaiyanapp.com/55e756791709ccbf1b2c597cba8fcc16.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=172037&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (630, 4, 6, '掌握这些技巧，西红柿炒鸡蛋会更好吃!', 'http://img.kaiyanapp.com/ee7504030fbfee6b85e0cde4eca7ace3.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=166445&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607320081, 1585981985);
INSERT INTO `video` VALUES (631, 4, 7, '数字交响乐，苹果要“扼住命运的咽喉”？', 'http://img.kaiyanapp.com/ac6449cd491ceece359f248441407f15.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=147910&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607083396, 1585981985);
INSERT INTO `video` VALUES (632, 4, 5, '章鱼足拍黄瓜', 'http://img.kaiyanapp.com/44b7bad8d4aac84fecd2d034dc5c9b70.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=164562&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (633, 4, 1, '一分钟美食：年饭必备的年年有余', 'http://img.kaiyanapp.com/93d92f155f68ae1607135065fccd85b0.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=149260&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607165744, 1585981985);
INSERT INTO `video` VALUES (634, 4, 6, '交响乐与光之舞：绚丽而璀璨', 'http://img.kaiyanapp.com/e6820f02442b0440b2f1968bf84e0788.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=148136&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606999891, 1585981985);
INSERT INTO `video` VALUES (635, 4, 1, '神秘的门后世界，一起来探险吧', 'http://img.kaiyanapp.com/21f735d61874bf2f9eff32e44e70c03a.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=144040&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (636, 4, 5, '大神历时3个月 动画完美诠释 命运交响曲', 'http://img.kaiyanapp.com/0aeaf72d4d3096c35ffae8129d8a220b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=135728&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833663, 1585981985);
INSERT INTO `video` VALUES (637, 4, 5, '怕七大姑八大姨催婚一块雪花酥就能搞定她们', 'http://img.kaiyanapp.com/3ff8f61b62c3c7ddfeeca00b1012ee3b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=149152&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606395780, 1585981985);
INSERT INTO `video` VALUES (638, 4, 8, '戴建武：未来女人再也不用「生」孩子', 'http://img.kaiyanapp.com/a3234ce59f42a3d00355dabd0f0efcb5.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140475&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607332818, 1585981985);
INSERT INTO `video` VALUES (639, 4, 3, '二十亿年前，我们的老祖先，一口把另一个生物吞进去了', 'http://img.kaiyanapp.com/23d9246a91afd24f9e59968e72e76f68.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=164349&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (640, 4, 5, '爱看韩剧的人，更难收获爱情与婚姻？', 'http://img.kaiyanapp.com/42cf4d2dd401beb5c68bac32d439aaba.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=146339&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (641, 4, 5, '李铭建：广州真是一座说不清楚的城市', 'http://img.kaiyanapp.com/bc89d55079b93dc0479ee62f5f875f9e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=143288&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607953949, 1585981985);
INSERT INTO `video` VALUES (642, 4, 7, '北大教授：能和男性平起平坐的女性是花木兰', 'http://img.kaiyanapp.com/c005d71b90d224a71a583e32ce104b6b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=128833&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607320084, 1585981985);
INSERT INTO `video` VALUES (643, 4, 6, '戴锦华：贾斯汀·比伯是如何影响男性文化的', 'http://img.kaiyanapp.com/fb7ca846e8958da096e237e9ff6f0f0a.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138924&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607332682, 1585981985);
INSERT INTO `video` VALUES (644, 4, 3, '戴建武：再生医学的目的不是长生不老', 'http://img.kaiyanapp.com/bedf56657e04a7167f17dc35d2af00dd.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=143542&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607248715, 1585981985);
INSERT INTO `video` VALUES (645, 4, 8, '车品觉VS尤瓦尔·赫拉利：谁敢把人生交给算法？', 'http://img.kaiyanapp.com/e7ad7c2baa9ce0cc68f9239fffedbf13.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=157151&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606389891, 1585981985);
INSERT INTO `video` VALUES (646, 4, 4, '生物科学家：失明不再是不治之症', 'http://img.kaiyanapp.com/3eaff56543e4cf32ed8f2f04b9927964.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139304&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (647, 4, 2, '计算机牛人：淘宝排名的算法有什么问题？', 'http://img.kaiyanapp.com/fce92edb78eb45a571d7bd65b52921fb.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139862&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1606996499, 1585981985);
INSERT INTO `video` VALUES (648, 4, 3, '魔幻动画：千里寻女记', 'http://img.kaiyanapp.com/fa47d1149b3c02e8b82ddc237523ac15.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=147105&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332822, 1585981985);
INSERT INTO `video` VALUES (649, 4, 6, '父亲节特辑：我的爸爸，是菜鸟妈妈', 'http://img.kaiyanapp.com/6c89325eb74d1e1498f37c13888dc3a8.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=159857&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606831571, 1585981985);
INSERT INTO `video` VALUES (650, 4, 7, '女儿的化装舞会，苦的都是老妈', 'http://img.kaiyanapp.com/d8382a715bec5eeca8b48def658e19b0.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=160885&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607172617, 1585981985);
INSERT INTO `video` VALUES (651, 4, 6, '温馨回忆动画：爸爸，突然就老了', 'http://img.kaiyanapp.com/13dca48a747dadfcaea548e7a9e8ca86.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=143662&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1608458938, 1585981985);
INSERT INTO `video` VALUES (652, 4, 7, '同一个世界同一种父母，你的父母超多戏', 'http://img.kaiyanapp.com/428cc64c6a0bf1e6cc2eda17bab58fc0.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=157312&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607325756, 1585981985);
INSERT INTO `video` VALUES (653, 4, 4, '看过《霍比特人》，这间山洞小屋你一定会去', 'http://img.kaiyanapp.com/dbb0cdf0f3e7829968d673306f22de6a.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=120763&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608430919, 1585981985);
INSERT INTO `video` VALUES (654, 4, 7, '女儿随手涂鸦，被老爸做成了彩色绘本', 'http://img.kaiyanapp.com/1b64cad09acb5cb8a8581b2fb5d4402a.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=151779&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607325610, 1585981985);
INSERT INTO `video` VALUES (655, 4, 6, '纽约广告节银奖：阳光小美女', 'http://img.kaiyanapp.com/5ec904b8721e946ee117a0a5ae9cb7df.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=146786&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607314639, 1585981985);
INSERT INTO `video` VALUES (656, 4, 5, '朱丹：女子本弱，为母则强', 'http://img.kaiyanapp.com/fd0ac7f19ba5d8227cacbead9e577746.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=160292&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (657, 4, 3, '温馨动画短片：父爱从未缺席，只是你没发现', 'http://img.kaiyanapp.com/c28ca6d99e1030e4dd7600f7b25467d6.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=145633&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607332545, 1585981985);
INSERT INTO `video` VALUES (658, 4, 1, '入围奥斯卡最佳真人短片：「伊卡洛斯」', 'http://img.kaiyanapp.com/6fe6a8103e574687ebb5ff13b7a0ec12.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=146222&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606992730, 1585981985);
INSERT INTO `video` VALUES (659, 4, 5, '入围奥斯卡最佳记录短片：「我老爸的遗物」', 'http://img.kaiyanapp.com/b869e00fdb3466e693170788d353b8a4.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=146259&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606926535, 1585981985);
INSERT INTO `video` VALUES (660, 4, 4, '「权游」虐恋混剪：那些爱情的戳心瞬间', 'http://img.kaiyanapp.com/3af085efa34f26e73c130f2d772c0b79.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=146770&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833734, 1585981985);
INSERT INTO `video` VALUES (661, 4, 3, '西西第一次滑雪比赛', 'http://img.kaiyanapp.com/211f303293f587420115121d5e9ec4ac.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=148662&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607160179, 1585981985);
INSERT INTO `video` VALUES (662, 4, 7, '前方高「污」广告：食色性也', 'http://img.kaiyanapp.com/583078145cc8419d7572045cb288461e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=149521&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (663, 4, 3, '他们花1000万，改造了一个老仓库', 'http://img.kaiyanapp.com/cef61e81b0b1eab590c6c8480ffed1d2.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=25050&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607325627, 1585981985);
INSERT INTO `video` VALUES (664, 4, 1, '一炉香，为何如此迷人？', 'http://img.kaiyanapp.com/012a94fa6706fd181bbedda732d36fb1.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=25496&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (665, 4, 1, '赤裸的、不停扭动的身体', 'http://img.kaiyanapp.com/67ac74426546612ebaca509b378dc684.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=26063&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607255737, 1585981985);
INSERT INTO `video` VALUES (666, 4, 3, '《舌尖上的中国》导演告诉你什么最好吃', 'http://img.kaiyanapp.com/b0377cc3f441dde914757982094f8fb3.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=26128&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607325759, 1585981985);
INSERT INTO `video` VALUES (667, 4, 4, '比动版《清明上河图》更逆天的视频古画', 'http://img.kaiyanapp.com/07821ea8f6af92e28d1f9a9a374b61fd.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=26182&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607325217, 1585981985);
INSERT INTO `video` VALUES (668, 4, 5, '周末沙雕：苍天！我就想吃个 cookie 而已', 'http://img.kaiyanapp.com/5a853deb0241996c04da885289e0e209.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=165785&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607090782, 1585981985);
INSERT INTO `video` VALUES (669, 4, 7, '水煮牛肉解馋吃不胖', 'http://img.kaiyanapp.com/f0bd4d471dc2a01f9b87871406da6f74.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=160922&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (670, 4, 2, '最skr的日料打卡胜地,你还没来pick', 'http://img.kaiyanapp.com/cc5486b388d0fc70140ffe382b450611.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=120889&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332732, 1585981985);
INSERT INTO `video` VALUES (671, 4, 7, '忙碌周一，用快手美味晚餐治愈疲惫的一天', 'http://img.kaiyanapp.com/4a0ce703f120622044685cb54d5b9cfa.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=161339&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607159530, 1585981985);
INSERT INTO `video` VALUES (672, 4, 4, '图片和实物相符的红烧牛肉面，终于吃上了！', 'http://img.kaiyanapp.com/557029395a37118b14b377b48e796154.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=152518&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607325653, 1585981985);
INSERT INTO `video` VALUES (673, 4, 6, '12 道省钱料理！小资又美味', 'http://img.kaiyanapp.com/46d5966076966d32566b976855ab17e4.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=126860&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1608299419, 1585981985);
INSERT INTO `video` VALUES (674, 4, 6, '简单一蒸就好吃，小编看一眼就被馋哭了', 'http://img.kaiyanapp.com/df2c05bd6994bef14ccdb3a041c2f8e2.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=159963&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606726924, 1585981985);
INSERT INTO `video` VALUES (675, 4, 2, '【原创定格动画】煎饼果子', 'http://img.kaiyanapp.com/a2684eba295227e0e4cd88b5be513099.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=129110&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1606979139, 1585981985);
INSERT INTO `video` VALUES (676, 4, 1, '【创意视觉】我的名字是OTAKUKO', 'http://img.kaiyanapp.com/3cb76a40245d0dd5d0b32e44cac798be.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=168136&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606724106, 1585981985);
INSERT INTO `video` VALUES (677, 4, 5, '创意定格动画：城市之秋', 'http://img.kaiyanapp.com/f244c13cb755f15e1601d98dd1904520.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=132964&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (678, 4, 8, '催眠必看广告：高级 Spa 级行车体验', 'http://img.kaiyanapp.com/475d5b1402cf656ec3b6b6ed7db610b1.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=145157&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607332681, 1585981985);
INSERT INTO `video` VALUES (679, 4, 2, '为什么你应该读一读「堂吉柯德」', 'http://img.kaiyanapp.com/b993c5107464202d14204b20d7eee678.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=148207&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607324056, 1585981985);
INSERT INTO `video` VALUES (680, 4, 2, '这样的架子鼓才好玩，卷起就走，人人学的会', 'http://img.kaiyanapp.com/c6e2c17cb26ccd8041b8fc192607afdb.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=113005&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (681, 4, 4, '你还记得上次怦然心动是什么时候，为了谁吗', 'http://img.kaiyanapp.com/a5755fccf4a5e6682ce249d76897349d.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=118677&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607325960, 1585981985);
INSERT INTO `video` VALUES (682, 4, 1, '驶向荒野第二季番外：回顾车队的前世今生', 'http://img.kaiyanapp.com/f4824c91b754233e0f3ca624f221717c.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=163849&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606726570, 1585981985);
INSERT INTO `video` VALUES (683, 4, 8, '揭开霸王龙的进化之谜', 'http://img.kaiyanapp.com/a56c4b3cceee205271cd032144cdece9.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=157637&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (684, 4, 1, '大货车频繁“吃”人，这些致命盲区不得不防', 'http://img.kaiyanapp.com/32290434671515924f3c79a4b4e8c6cb.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=162068&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (685, 4, 5, '横跨千里，12城市空气质量观察', 'http://img.kaiyanapp.com/025011a0d223ae1513761bb5116df050.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=135025&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332748, 1585981985);
INSERT INTO `video` VALUES (686, 4, 3, '占据整个宇宙绝大部分的暗物质到底是什么？', 'http://img.kaiyanapp.com/683f94d42d7cdcf935dafdd06bfd1267.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=164273&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (687, 4, 5, '如果人类看不到色彩，地球就得了抑郁症', 'http://img.kaiyanapp.com/dd7d611c6888d0c638d6652a47d901c1.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=170284&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607319187, 1585981985);
INSERT INTO `video` VALUES (688, 4, 7, '咆哮吧，你就是天生的王者：翻唱「Roar」', 'http://img.kaiyanapp.com/2d096a93e53c9d5f870921a95b9032ee.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=112401&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607323426, 1585981985);
INSERT INTO `video` VALUES (689, 4, 5, '一学就会的舌尖美味：香辣芝麻鸡翅', 'http://img.kaiyanapp.com/f30476023d43e6d5382cd284c148755e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=114545&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607167552, 1585981985);
INSERT INTO `video` VALUES (690, 4, 3, 'KHS 翻唱「阿拉丁」电影主题曲', 'http://img.kaiyanapp.com/9829932d2590a11b8808a5bbd73f50b5.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=117787&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607325971, 1585981985);
INSERT INTO `video` VALUES (691, 4, 5, '给自己放个假：亚特兰大清新大宅', 'http://img.kaiyanapp.com/708d92ca6255a94928222282c9df9d00.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=121535&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606725986, 1585981985);
INSERT INTO `video` VALUES (692, 4, 5, '售价上千万，自带车库的豪华房车', 'http://img.kaiyanapp.com/a2a6de0f2e69814692902297b50f2c8d.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=122681&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607318691, 1585981985);
INSERT INTO `video` VALUES (693, 4, 5, '8 月 27 日| 去加拿大感受自然的魅力', 'http://img.kaiyanapp.com/5623b93633177cad1aa112cc7f5fb21e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=131515&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607332757, 1585981985);
INSERT INTO `video` VALUES (694, 4, 1, '爽口劲道的酸辣柠檬凤爪，只要几步就做好', 'http://img.kaiyanapp.com/40972cdce8f61452a37aa44578582a9d.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=132788&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (695, 4, 7, '5 分钟了解保时捷 911 全系车型', 'http://img.kaiyanapp.com/0c1556957c66688a384f1df795f324d0.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=134549&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (696, 4, 4, '创意品牌短片：梦幻纯净之蓝', 'http://img.kaiyanapp.com/816cac6421d0abe9276288fcbc2fd1d4.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=135811&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607325613, 1585981985);
INSERT INTO `video` VALUES (697, 4, 6, '创意品牌短片：毛刺植物的细腻触角', 'http://img.kaiyanapp.com/4d1727579949b48becaf1622820cde34.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=137516&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607325458, 1585981985);
INSERT INTO `video` VALUES (698, 4, 5, '吃秋葵先焯水？原来一直做错，难怪不好吃', 'http://img.kaiyanapp.com/d24ca25417e31f09cb7660ad41d9e5e7.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=151324&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606894311, 1585981985);
INSERT INTO `video` VALUES (699, 4, 5, '菜菜干货日记｜油炸小技巧', 'http://img.kaiyanapp.com/5d6896865420d412729f6328f659f5e9.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=131598&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607332798, 1585981985);
INSERT INTO `video` VALUES (700, 4, 5, '菜菜干货日记｜泡发干货小诀窍', 'http://img.kaiyanapp.com/73c692fc77d7699a93328b31c17e2c72.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=133016&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 1, 0, 0, 0, '', 2, 1606807242, 1585981985);
INSERT INTO `video` VALUES (701, 4, 5, '菜菜干货日记丨肉要这样切才更嫩更好吃！', 'http://img.kaiyanapp.com/68e7ec71148909e9cd8354676bb012d1.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=135051&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (702, 4, 8, '牛肉一做就老？你做错这一步，难怪又老又硬', 'http://img.kaiyanapp.com/e2a1467f2ece2b1b1a6a7d73744d9dcf.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=151614&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606831240, 1585981985);
INSERT INTO `video` VALUES (703, 4, 2, '海鲜腥，原来第一步做错了，难怪吃不吃鲜味', 'http://img.kaiyanapp.com/4b19e6e4609cdc9f2772077e3f6d8ea8.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=153431&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607955041, 1585981985);
INSERT INTO `video` VALUES (704, 4, 3, '南方经典菜，家家必备，很多人第一步就做错', 'http://img.kaiyanapp.com/aa96552739e0cb80c8a82ecb730c173a.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=152470&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (705, 4, 7, '猪耳朵美味吃法，掌握这步，比大厨做的好吃', 'http://img.kaiyanapp.com/c1ac747e6f41fc1cf9ea71282a0d8734.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=153471&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (706, 4, 7, '皮冻晶莹剔透，这步是关键，试过的都成功了', 'http://img.kaiyanapp.com/9fcf7186ecfb290242d31e4ead7deb4a.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=153499&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606725324, 1585981985);
INSERT INTO `video` VALUES (707, 4, 8, '无门无派的可乐鸡翅太好吃！做法其实真简单', 'http://img.kaiyanapp.com/0b0e79e2304c11c2d159e00eff861f51.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=172129&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (708, 4, 5, '忘', 'http://img.kaiyanapp.com/7fce1c98aa3002652a35a9f615343e81.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=154082&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (709, 4, 1, '粗旷炒粿、浓稠芝麻糊 - 汕头福平路美食', 'http://img.kaiyanapp.com/088ba0d423df36e06c68a988166d84b1.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=144696&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (710, 4, 6, '阿塔卡马沙漠：体验火星人的生活', 'http://img.kaiyanapp.com/84f14bd00cf0fd1c05cb46cf004a6aa6.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=113356&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606394885, 1585981985);
INSERT INTO `video` VALUES (711, 4, 1, '周末出逃vlog丨乐山48小时吃住攻略', 'http://img.kaiyanapp.com/e4cea2591968a41e73ca2ceeecca47af.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=119274&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606389944, 1585981985);
INSERT INTO `video` VALUES (712, 4, 6, '跟着电影里的背影，一直往前走吧', 'http://img.kaiyanapp.com/bdaae363c8a3aafae1d88a70a5b32dcc.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=165926&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607250599, 1585981985);
INSERT INTO `video` VALUES (713, 4, 1, '赚钱的最高境界，她来告诉你', 'http://img.kaiyanapp.com/4b1f8b0dd53aad7da3b8bae766017769.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140049&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607090728, 1585981985);
INSERT INTO `video` VALUES (714, 4, 3, ' 331天，自驾环游欧亚的中国情侣', 'http://img.kaiyanapp.com/20d38d7565b9a414f2f97ae2c2ceb08c.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=145047&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606726771, 1585981985);
INSERT INTO `video` VALUES (715, 4, 3, 'One Day, London', 'http://img.kaiyanapp.com/cad58d9876dfb0a1deacf2d54c90a197.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=168633&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606981502, 1585981985);
INSERT INTO `video` VALUES (716, 4, 4, '如何装饰圣诞树呢', 'http://img.kaiyanapp.com/3068b223000a6f3d27c408e863e64769.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=110155&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608460341, 1585981985);
INSERT INTO `video` VALUES (717, 4, 4, '吉他版《往后余生》', 'http://img.kaiyanapp.com/9976e2c53261adcdb9bbeae53667c601.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=122643&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606832698, 1585981985);
INSERT INTO `video` VALUES (718, 4, 5, '战地4-怒海狂涛实机演示', 'http://img.kaiyanapp.com/3054cf0d3202e6150270f2c83c75cec2.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139026&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (719, 4, 7, '汤姆克兰西全境封锁实机演示', 'http://img.kaiyanapp.com/d444340bc7430162a1456e194545d68d.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138988&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833699, 1585981985);
INSERT INTO `video` VALUES (720, 4, 7, '战地1-实机预告片', 'http://img.kaiyanapp.com/8c90ef623a1e20b18107281c62f55db7.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138861&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607251376, 1585981985);
INSERT INTO `video` VALUES (721, 4, 8, '战地5-首发全地图实机演示', 'http://img.kaiyanapp.com/d501c626e37d8ce0791eb694022db879.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140343&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606401751, 1585981985);
INSERT INTO `video` VALUES (722, 4, 3, '「战地 4」卡车 vs 直升机', 'http://img.kaiyanapp.com/de08eed8bfd4236aeb0c5c54de584405.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=117646&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606832042, 1585981985);
INSERT INTO `video` VALUES (723, 4, 8, '战地3-碎剑者行动', 'http://img.kaiyanapp.com/f6143751e5bc36b0e4dbde8f09804c84.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139057&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607154207, 1585981985);
INSERT INTO `video` VALUES (724, 4, 5, '极品飞车19-Demo演示', 'http://img.kaiyanapp.com/adbc63fb07465287ade03dd8883d5cc3.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139362&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 2, 0, 0, '', 2, 1607332744, 1585981985);
INSERT INTO `video` VALUES (725, 4, 1, '超自然存在的他，每天魂穿，只为守护她', 'http://img.kaiyanapp.com/2d5060e7ebc066ff7d4e4191c758b9fa.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=162212&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (726, 4, 7, '4分钟看完高分新片《犬舍惊魂》', 'http://img.kaiyanapp.com/e3512b0c27d48da14b9951d530782650.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140243&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607159217, 1585981985);
INSERT INTO `video` VALUES (727, 4, 2, '是大腿求生TOP1018： 图拉夫屠戮', 'http://img.kaiyanapp.com/cfbd730905a4d8e99918ce9353cf12a8.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=126599&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (728, 4, 4, '一把手工紫砂壶的炼成', 'http://img.kaiyanapp.com/d6c2f369e3f6111ee0d1c68dc2d0e252.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139013&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608189374, 1585981985);
INSERT INTO `video` VALUES (729, 4, 8, '功夫小子闯少林，10岁神童神似释小龙', 'http://img.kaiyanapp.com/a49213b808815a33b599b9567c889167.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=144306&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607318407, 1585981985);
INSERT INTO `video` VALUES (730, 4, 5, '好莱坞华人教母，83岁仍在演戏', 'http://img.kaiyanapp.com/dad50fbb79eda703fa75da6cd5bf7e6e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=165693&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (731, 4, 3, '「樱桃小丸子」作者去世，这首歌你一定会唱', 'http://img.kaiyanapp.com/5dfe5ff400e9f71669afdd60f3812257.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=123981&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (732, 4, 1, '世界上最蠢的妈，把神童养成了连环杀手', 'http://img.kaiyanapp.com/da8cd10f85c64e9f568cafa3e79d3e46.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=167010&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (733, 4, 3, '她65岁考驾照，跑到深山造房独居', 'http://img.kaiyanapp.com/a8c84653e7a5129679335baedf8dd8ad.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=166454&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606926539, 1585981985);
INSERT INTO `video` VALUES (734, 4, 6, '覆盆子流心巧克力蛋糕：流心的规律', 'http://img.kaiyanapp.com/5db28b38cc58432c6e2ee2a0d3dd4e39.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=148969&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606831790, 1585981985);
INSERT INTO `video` VALUES (735, 4, 2, '“中华巧女”93岁高龄仍不舍放下手中剪刀', 'http://img.kaiyanapp.com/95ae0e89abf2753e8fac32dea5b7a64a.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=165908&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607320019, 1585981985);
INSERT INTO `video` VALUES (736, 4, 7, '这就是街舞冠军韩宇 ：不服是一种少年心气', 'http://img.kaiyanapp.com/06232da582f485cc23667845bf7cf2db.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=111010&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607953952, 1585981985);
INSERT INTO `video` VALUES (737, 4, 3, '快感、焦虑、性障碍，他患上“网络色情瘾”', 'http://img.kaiyanapp.com/aa9c26ef9709b8bdb6ecffc4ed2cd32e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=113722&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 1, 0, 0, '', 2, 1607787440, 1585981985);
INSERT INTO `video` VALUES (738, 4, 5, '一只平底锅就能做的极品早餐', 'http://img.kaiyanapp.com/3e4508584553d5257a681371de32c3cd.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=10112&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 4, 0, 0, 0, 0, '', 2, 1608563493, 1585981985);
INSERT INTO `video` VALUES (739, 4, 4, '比起打败对手，更难的是战胜自己', 'http://img.kaiyanapp.com/f88b5e2d1b6f1831ff1203faefa7208e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=114409&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (740, 4, 6, '门前鲜花盛开的舒适别墅', 'http://img.kaiyanapp.com/afe6554fb53c0a1feac17a74874fdd2d.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=121116&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607955079, 1585981985);
INSERT INTO `video` VALUES (741, 4, 2, '揭秘偷拍，日本的停车场怎么工作', 'http://img.kaiyanapp.com/8a547f751b4590793e685cacc70a9ce3.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=131684&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332867, 1585981985);
INSERT INTO `video` VALUES (742, 4, 2, '创意品牌短片：信号', 'http://img.kaiyanapp.com/70d3ba439a411b676554bbe5b2c5cc17.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=135210&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (743, 4, 8, '搞笑动画：我听不见穷人讲话', 'http://img.kaiyanapp.com/637f193bcd2ff06de82c53cc8d2d6ef0.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=148005&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607248519, 1585981985);
INSERT INTO `video` VALUES (744, 4, 3, '中华美食必须拥有姓名：华裔大厨教你做油泼面！', 'http://img.kaiyanapp.com/39c9b480d6a5ca527146e8dbc0e6598a.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=150633&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606725067, 1585981985);
INSERT INTO `video` VALUES (745, 4, 8, '「爱，死亡和机器人」第2集「三个机器人」', 'http://img.kaiyanapp.com/330d77948340405f38a95d7bf43962d5.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=155146&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833387, 1585981985);
INSERT INTO `video` VALUES (746, 4, 5, '「爱，死亡和机器人」第 15 集「盲点」', 'http://img.kaiyanapp.com/7b10b68a20d944e2b2908fe4f12ff978.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=155988&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607332681, 1585981985);
INSERT INTO `video` VALUES (747, 4, 8, '八月 3 日 | 宜去印度花谷看百花争艳', 'http://img.kaiyanapp.com/c7c4bf4e1c5f6e1025c9253dd80dd4a6.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=168950&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607955114, 1585981985);
INSERT INTO `video` VALUES (748, 4, 6, '泰式烤猪颈肉｜酸甜辣咸', 'http://img.kaiyanapp.com/e43d7e2e7c7b508139bbfd5656c09073.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=124573&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607321035, 1585981985);
INSERT INTO `video` VALUES (749, 4, 3, '来一块外酥里嫩的【烤年糕】看它慢慢变大！', 'http://img.kaiyanapp.com/36c0f93560ea4b8a367618eb34a2dfdc.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=170002&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607953957, 1585981985);
INSERT INTO `video` VALUES (750, 4, 2, '辽宁超级火爆小卷饼，一口气吃上五张才过瘾', 'http://img.kaiyanapp.com/4b697e5a5e28dca9ffef1a304fcaec58.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=142816&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607160581, 1585981985);
INSERT INTO `video` VALUES (751, 4, 6, '用微波炉做的两种汤', 'http://img.kaiyanapp.com/5fed00afc1098814b2c215a587bef2dc.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=154255&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606724980, 1585981985);
INSERT INTO `video` VALUES (752, 4, 6, '蔬菜这样烧，丝滑浓香营养高！', 'http://img.kaiyanapp.com/b98c1f703da85b7830e6e0e7797d18d1.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=123924&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1608261241, 1585981985);
INSERT INTO `video` VALUES (753, 4, 3, '南京698元全羊宴：10斤烤全羊滋滋冒油', 'http://img.kaiyanapp.com/270ad2f4bb8d685f5512db608bdac207.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=167821&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 1, 0, 0, '', 2, 1607318970, 1585981985);
INSERT INTO `video` VALUES (754, 4, 1, '韩式烤肉配烧酒，果然冬天就是要吃肉！', 'http://img.kaiyanapp.com/498c49bae8134af9b44d9443dbf046a7.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=142850&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607319967, 1585981985);
INSERT INTO `video` VALUES (755, 4, 7, '丢给猫咪一根玩具骨头', 'http://img.kaiyanapp.com/048e6621b77618e093942178ec861c4d.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=110023&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607333802, 1585981985);
INSERT INTO `video` VALUES (756, 4, 5, '无油也能做脆脆烤燕麦', 'http://img.kaiyanapp.com/066e9b826f124386ce151bc4c3f44ed5.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=124616&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 1, 0, 0, 0, '', 2, 1607277010, 1585981985);
INSERT INTO `video` VALUES (757, 4, 6, '刚吃了一颗68块钱的橙子，我真是飘了', 'http://img.kaiyanapp.com/361633b5ce8dfdbb58f2a1cfa08ade45.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=156762&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607325761, 1585981985);
INSERT INTO `video` VALUES (758, 4, 5, '激励 500 万人的健身短片：男人就该像强森一样', 'http://img.kaiyanapp.com/7bce6c62f2e7df99b0decf8418538f3a.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=158331&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (759, 4, 8, '法国获奖荒诞动画：危险的人工智能', 'http://img.kaiyanapp.com/19bc8d8a84f70f153cf7a5a03be18a5e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=168050&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606395996, 1585981985);
INSERT INTO `video` VALUES (760, 4, 1, '绮梦vol.6 | 仲夏之梦', 'http://img.kaiyanapp.com/cb063ca26d848a684677f6fea4c4407c.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=171039&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607325939, 1585981985);
INSERT INTO `video` VALUES (761, 4, 2, '作为一只鸭我容易吗？', 'http://img.kaiyanapp.com/8c5159da3dfcd9b72c7e8e6fd2d56696.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=109970&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606996836, 1585981985);
INSERT INTO `video` VALUES (762, 4, 4, '抑郁症患者的颅内世界：我感觉不太好', 'http://img.kaiyanapp.com/bc57b10af4a1a872012978a5d3c23f90.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=133724&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606832044, 1585981985);
INSERT INTO `video` VALUES (763, 4, 1, '时光相册', 'http://img.kaiyanapp.com/36a721b1e7f52136ecd69e4c690da6a9.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=153186&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332539, 1585981985);
INSERT INTO `video` VALUES (764, 4, 5, '这杯茶一出山，就拿了全场最佳“盖帽”', 'http://img.kaiyanapp.com/8e79290d2454de06417b70f93086a007.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=129832&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1606996734, 1585981985);
INSERT INTO `video` VALUES (765, 4, 8, '【物造东方】这件上古神器，现在还在使用', 'http://img.kaiyanapp.com/1f8cd982dec21076c38ff67111f9f8a6.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=168989&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1606975734, 1585981985);
INSERT INTO `video` VALUES (766, 4, 5, '超现实魔幻短片：古老而灿烂的文明图腾', 'http://img.kaiyanapp.com/dee69a489a8cce6064a16c39459db1bc.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=150220&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (767, 4, 8, '点石数码《独与天地精神往来》', 'http://img.kaiyanapp.com/feaf9e078be3e0d745c70c9c3c593e09.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=165859&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606583008, 1585981985);
INSERT INTO `video` VALUES (768, 4, 3, '阿特兹改装德国TEI P60大六刹车套装', 'http://img.kaiyanapp.com/480878149a7afca26155de8e5ab62797.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=134425&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 4, 0, 0, '', 2, 1607916705, 1585981985);
INSERT INTO `video` VALUES (769, 4, 5, '丰田新锐志改装TEI大六刹车套件', 'http://img.kaiyanapp.com/f81166a669c2621a8e2ffc3835d1a304.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=127175&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833594, 1585981985);
INSERT INTO `video` VALUES (770, 4, 4, '领克01改装德国TEI大六刹车套装', 'http://img.kaiyanapp.com/c7fbc405216061c8e089f8515302b4f4.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=158410&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (771, 4, 4, '马自达睿翼改装德国TEI刹车套装作业', 'http://img.kaiyanapp.com/111c978b23ec36212bca1c482fe5d3fb.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=155177&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606725456, 1585981985);
INSERT INTO `video` VALUES (772, 4, 7, '丰田锐志改装德国TEI 前六后四刹车套装', 'http://img.kaiyanapp.com/26e352811fa3326d230f6d6f97178d23.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=132581&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833694, 1585981985);
INSERT INTO `video` VALUES (773, 4, 6, '宝马X5改装德国TEI前后刹车套装', 'http://img.kaiyanapp.com/b7ff1e4c3f23039d4bab2f30011047e0.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139683&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (774, 4, 4, '阿特兹改装德国TEI-P60S刹车套装', 'http://img.kaiyanapp.com/29eef4c00fae14ab1480e9d2702c738f.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=150405&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 1, 0, 0, 0, '', 2, 1607169990, 1585981985);
INSERT INTO `video` VALUES (775, 4, 4, '众泰T700改装德国TEI大六刹车套装', 'http://img.kaiyanapp.com/a42043b76ecc3349a329fdf4fecd9870.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=168504&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606566009, 1585981985);
INSERT INTO `video` VALUES (776, 4, 1, '9.5代雅阁改装德国TEI前后刹车套装', 'http://img.kaiyanapp.com/47e202fb772a711f01be05ce1931f909.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=150304&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (777, 4, 3, '十代思域改装德国TEI P60S大六刹车', 'http://img.kaiyanapp.com/26c3ffd943e3427708d0f4f6e3bef0e7.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=141578&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607326420, 1585981985);
INSERT INTO `video` VALUES (778, 4, 4, '对口型大作战：凯茜·贝茨', 'http://img.kaiyanapp.com/5de20f6f169d897563738698f2839941.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=137883&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607277076, 1585981985);
INSERT INTO `video` VALUES (779, 4, 3, '对口型大作战：泰雅·迪格斯', 'http://img.kaiyanapp.com/00f73205454b9fa867f2c130e15dd1bc.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=137882&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332552, 1585981985);
INSERT INTO `video` VALUES (780, 4, 5, '对口型大作战：拉弗恩·考克斯', 'http://img.kaiyanapp.com/be6226bf9cdb0dcdb70cc9a0cd495739.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138066&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (781, 4, 7, '对口型大作战：米娜·苏瓦莉', 'http://img.kaiyanapp.com/fe80dcc279af3cd9bbe8f10bb5dc1215.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138325&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606726774, 1585981985);
INSERT INTO `video` VALUES (782, 4, 8, '对口型大作战：里雷·霍沃利', 'http://img.kaiyanapp.com/30f7dbb43492462113c4b0898e66cf0a.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=137878&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607325203, 1585981985);
INSERT INTO `video` VALUES (783, 4, 4, '对口型大作战：雷蒙娜歌手', 'http://img.kaiyanapp.com/2386ce9ad9d0dc81264cfd811b9ba570.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139061&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1606998687, 1585981985);
INSERT INTO `video` VALUES (784, 4, 2, '对口型大作战：迈克·泰森', 'http://img.kaiyanapp.com/d6015bcee2ce73b5b1289f4dbedfb295.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=147553&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606566089, 1585981985);
INSERT INTO `video` VALUES (785, 4, 8, '对口型大作战：拉莫·威利斯', 'http://img.kaiyanapp.com/e74887f4770a7349d14864042515277f.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=147544&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833508, 1585981985);
INSERT INTO `video` VALUES (786, 4, 1, '对口型大作战：狄娜·珍', 'http://img.kaiyanapp.com/f480829d30ae423502571181b554f569.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=147551&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332680, 1585981985);
INSERT INTO `video` VALUES (787, 4, 8, '对口型大作战：维尔摩·瓦尔德拉玛', 'http://img.kaiyanapp.com/c1608b66239d9322e30aba51b024e54c.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=134939&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (788, 4, 6, '主题是好吃的低卡零食，结果越低卡越难吃', 'http://img.kaiyanapp.com/6e632db750c388348813b94fdae7659d.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=124551&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607319075, 1585981985);
INSERT INTO `video` VALUES (789, 4, 8, '实测网红奶茶含糖量，竟能做出三支棒棒糖', 'http://img.kaiyanapp.com/d739b98bb47491c6c88f856001e23fc0.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=133917&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (790, 4, 6, '制作酷似鸡腿的甜面包棒棒糖', 'http://img.kaiyanapp.com/b36c54fef30dd340523b041dedd19581.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=110247&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607848508, 1585981985);
INSERT INTO `video` VALUES (791, 4, 5, '3分钟，54家店，跟这两个帅气小哥吃台南', 'http://img.kaiyanapp.com/ed43d023f003c3a00530e48f69de7019.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=153056&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607256521, 1585981985);
INSERT INTO `video` VALUES (792, 4, 4, '汤姆·克鲁斯(Tom Cruise)', 'http://img.kaiyanapp.com/ad112d10d803d5d22e6a2cc7b53ec32a.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=124855&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332792, 1585981985);
INSERT INTO `video` VALUES (793, 4, 8, '周末 腹肌健身小哥哥的健身日常 ', 'http://img.kaiyanapp.com/c6c13653d6fff4ab6debf5a64e8c141e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=168608&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606726959, 1585981985);
INSERT INTO `video` VALUES (794, 4, 8, '一口吃下银河系！这样的甜品美到不忍心下口', 'http://img.kaiyanapp.com/4624ed2dab92976462409aa2b69e4fd3.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=145760&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (795, 4, 1, '下辈子，可不可以换你来守着我？', 'http://img.kaiyanapp.com/11f8c47bcfed56ac2f88bd3d1ae2cf61.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=124678&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607166924, 1585981985);
INSERT INTO `video` VALUES (796, 4, 2, '《那女孩对我说》我耳朵怀孕了！', 'http://img.kaiyanapp.com/207a9dd2acba62c16b43fa76201462af.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=125834&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332756, 1585981985);
INSERT INTO `video` VALUES (797, 4, 3, '男帅女美，靠谱漫改剧了解一下', 'http://img.kaiyanapp.com/4be15d21639a34a14725623c7e7bdcb7.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=114779&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 4, 0, 0, '', 2, 1607332818, 1585981985);
INSERT INTO `video` VALUES (798, 4, 3, '在桂林漓江穷游，被老大爷套路拍照！', 'http://img.kaiyanapp.com/57bf3a4885659ee572e92fb22d9a9cf2.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139009&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 9, 0, 0, 0, 0, '', 2, 1607332664, 1585981985);
INSERT INTO `video` VALUES (799, 4, 5, '穷游桂林九马画山，向大妈请教拍照秘诀', 'http://img.kaiyanapp.com/8f59d1539bb2cd1ed1823871373aa0f9.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139501&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607321035, 1585981985);
INSERT INTO `video` VALUES (800, 4, 3, '穷游广西桂林：跟明星牛拍照收费10元', 'http://img.kaiyanapp.com/c4e577f69bd898823e50421dcd579426.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140901&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833749, 1585981985);
INSERT INTO `video` VALUES (801, 4, 5, '广西桂林有棵千年古树，游客看一次要20元', 'http://img.kaiyanapp.com/d86d0314e557f6dd4e273de212ebe773.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140653&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607082652, 1585981985);
INSERT INTO `video` VALUES (802, 4, 1, '穷游广西桂林：30米河道乘坐竹筏收10元', 'http://img.kaiyanapp.com/3fabfb0b7fed47d75013994ef8474739.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=141066&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607327094, 1585981985);
INSERT INTO `video` VALUES (803, 4, 1, '2018游广西桂林兴坪漓江', 'http://img.kaiyanapp.com/9d031e310930378827a36589539eeb38.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138188&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606809453, 1585981985);
INSERT INTO `video` VALUES (804, 4, 1, '桂林阳朔的特色农家乐：在竹筏上吃竹筒饭', 'http://img.kaiyanapp.com/64fd167bdf2e1b559c31b6349a8f08c6.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140439&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606390789, 1585981985);
INSERT INTO `video` VALUES (805, 4, 1, '桂林漓江边上的特色小吃：油炸小河鲜', 'http://img.kaiyanapp.com/554d9949a219a556ffa48c723afb5b82.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139353&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 4, 0, 0, 0, 0, '', 2, 1607332661, 1585981985);
INSERT INTO `video` VALUES (806, 4, 7, '广西古镇的腊肉竹筒饭，用糯米香竹烧制', 'http://img.kaiyanapp.com/40d206e56e655895fd4c26e264cc3c95.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138862&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607953510, 1585981985);
INSERT INTO `video` VALUES (807, 4, 7, '寻找心灵的净土，一种被向往的生活', 'http://img.kaiyanapp.com/e4509942752071d5fddf470bae675f60.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=161773&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606831806, 1585981985);
INSERT INTO `video` VALUES (808, 4, 2, '一个明星的诞生：「Shallow」深情翻唱', 'http://img.kaiyanapp.com/c7f4ddb44450779a1d1e6df886f35ede.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=137999&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606564854, 1585981985);
INSERT INTO `video` VALUES (809, 4, 3, '男声深情演唱「一个明星的诞生」原声歌曲', 'http://img.kaiyanapp.com/a0bf8eba4f3cad414b64102bdc627c5b.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=135892&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607166724, 1585981985);
INSERT INTO `video` VALUES (810, 4, 1, '夫妻深情对唱「\'Tis So Sweet」', 'http://img.kaiyanapp.com/42bff0ebff3d1d287993f7f19bc806e5.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=157703&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608458561, 1585981985);
INSERT INTO `video` VALUES (811, 4, 1, '「一个明星的诞生」原声「Shallow」官方中文 MV', 'http://img.kaiyanapp.com/e06834c62b897710c1df910af2f891d5.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=130946&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (812, 4, 5, '一个明星的诞生：「Maybe It\'s Time」翻唱', 'http://img.kaiyanapp.com/e947aefb4014385aa9db54809e62d0ee.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=141849&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (813, 4, 8, 'Gaga 联手 Cooper 主演「一个明星的诞生」原声：Look What I Found', 'http://img.kaiyanapp.com/1e024f58823b8df7c93a9bd6ad01e3e9.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=130769&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606708581, 1585981985);
INSERT INTO `video` VALUES (814, 4, 6, '感动！夫妻对唱「My Heart Will Go On」', 'http://img.kaiyanapp.com/28b8f3578bb07a98ee542e348aee03a5.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=126793&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606718276, 1585981985);
INSERT INTO `video` VALUES (815, 4, 3, '「一个明星的诞生」片花：Gaga 清唱新歌', 'http://img.kaiyanapp.com/1fb9b920b52507a1ee7e60150e89f770.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=125746&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606724953, 1585981985);
INSERT INTO `video` VALUES (816, 4, 2, '「一个明星的诞生」原声：I\'ll Never Love Again', 'http://img.kaiyanapp.com/ed81e947c4e167d6b1a2c519511a2a79.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=134650&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606892840, 1585981985);
INSERT INTO `video` VALUES (817, 4, 6, '夫妻深情翻唱「Be Thou My Vision」', 'http://img.kaiyanapp.com/0a829e1ca37058475948ac51dc31ebbb.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=163102&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606823588, 1585981985);
INSERT INTO `video` VALUES (818, 4, 7, 'Matt Bloyd 翻唱「All The Woman I Need」', 'http://img.kaiyanapp.com/8271a5a7e874d4a125ee8aeb2af23e3e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=114987&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 1, 2, 0, 0, '', 2, 1607169180, 1585981985);
INSERT INTO `video` VALUES (819, 4, 1, 'Matt Bloyd 翻唱「I Could Fall in Love」', 'http://img.kaiyanapp.com/4560d024ba5e59b78ce1d44d52e66391.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=111489&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606995894, 1585981985);
INSERT INTO `video` VALUES (820, 4, 7, 'Matt Bloyd 翻唱「Moving Parts」', 'http://img.kaiyanapp.com/a291b62a58d02d41e86846dff516780c.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=111465&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606831872, 1585981985);
INSERT INTO `video` VALUES (821, 4, 3, 'Matt Bloyd 翻唱 JoJo 的「Leave」', 'http://img.kaiyanapp.com/42db399d86d9e5bb4ebb6e32d7b04e68.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139099&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (822, 4, 1, 'Matt Bloyd 深情翻唱 ZAYN「Pillowtalk」', 'http://img.kaiyanapp.com/a5181994ca909efb5c297b5c62a37f86.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=111463&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607256492, 1585981985);
INSERT INTO `video` VALUES (823, 4, 2, 'Matt Bloyd 翻唱「Speechless」', 'http://img.kaiyanapp.com/4c95b0bfb6999fbbaf4fc1cccf7b538f.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139098&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607164801, 1585981985);
INSERT INTO `video` VALUES (824, 4, 1, 'Matt Bloyd「Give This Love A Try」MV', 'http://img.kaiyanapp.com/92ecc9ec9cea8b554cc778491ad1ab10.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=141049&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (825, 4, 2, 'Matt Bloyd 翻唱 Journey 的「Open Arms」', 'http://img.kaiyanapp.com/1fa6a8a66dc42c3a8359289adb233010.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=111491&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606582943, 1585981985);
INSERT INTO `video` VALUES (826, 4, 8, 'Matt Bloyd 翻唱「Snow In California」', 'http://img.kaiyanapp.com/0a3e05d67ceb95b383809d502d9134a1.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=111466&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 1, 0, 0, 0, '', 2, 1606809667, 1585981985);
INSERT INTO `video` VALUES (827, 4, 3, 'Matt Bloyd 翻唱「Bless the Broken Road」', 'http://img.kaiyanapp.com/d32929c77b87362856be2ab32ebbe935.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140138&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (828, 4, 7, 'Maddie 翻唱「Something Just Like This」', 'http://img.kaiyanapp.com/bcb682ffe7b466998e36f8798cbe153e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=133978&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608097222, 1585981985);
INSERT INTO `video` VALUES (829, 4, 4, 'Emma 翻唱「Kiss and Make Up」', 'http://img.kaiyanapp.com/9a6a0df26c61b4542a3018d17d2d3489.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139107&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606725531, 1585981985);
INSERT INTO `video` VALUES (830, 4, 3, '好听哭！Emma 深情翻唱热单「Without Me」', 'http://img.kaiyanapp.com/9e5c99622238415c30d61c97e4d311f5.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=155576&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607332787, 1585981985);
INSERT INTO `video` VALUES (831, 4, 2, '泪目！Emma 翻唱 Demi Lovato 的「Sober」', 'http://img.kaiyanapp.com/804896822573b659e4d7fa29996354f9.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136133&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606708369, 1585981985);
INSERT INTO `video` VALUES (832, 4, 7, '今晚打给我，好吗？', 'http://img.kaiyanapp.com/f1328a9df201242ab286258bd83282e6.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=169209&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (833, 4, 8, '致敬猫王！Emma 翻唱经典曲目「坠入情网」', 'http://img.kaiyanapp.com/6127d21c5882ffd95e25370019d126e5.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=151037&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606390721, 1585981985);
INSERT INTO `video` VALUES (834, 4, 2, 'Emma 英文翻唱 BTS 的「Fake Love」', 'http://img.kaiyanapp.com/ae7f6cdd4eb0cdf16b8ee4dfcabc4eb7.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139111&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607332729, 1585981985);
INSERT INTO `video` VALUES (835, 4, 2, '女声翻唱 R&B 版黄老板金曲「Shape Of You」', 'http://img.kaiyanapp.com/2bfcdbe090fa637d798cc9b6e80b2dcd.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140145&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (836, 4, 4, '听首 Emma 翻唱的「IDGAF」，忘记所有不开心', 'http://img.kaiyanapp.com/b234fab60bd765b104c3b1ec3178ee90.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=146367&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607080835, 1585981985);
INSERT INTO `video` VALUES (837, 4, 1, 'Emma Heesters 翻唱 BTS「Spring Day」', 'http://img.kaiyanapp.com/493f23be9884d31bd6b97d50c5d5eb4c.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=126781&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607333087, 1585981985);
INSERT INTO `video` VALUES (838, 4, 7, '回顾！2017 欧美流行热单串烧！', 'http://img.kaiyanapp.com/95de3bd87c201f8dd86ae11fef4d4ea6.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136141&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 1, 0, 0, '', 2, 1608479201, 1585981985);
INSERT INTO `video` VALUES (839, 4, 1, 'Rajiv Dhall 翻唱「Story of My Life」', 'http://img.kaiyanapp.com/84a3ffaf95350edcfa1a9c734908e3c7.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=117891&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606725413, 1585981985);
INSERT INTO `video` VALUES (840, 4, 1, 'Rajiv Dhall 翻唱「Little Things」', 'http://img.kaiyanapp.com/d65b3bec4ff2dbbe3ef6b1485d1049cf.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=118368&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606831396, 1585981985);
INSERT INTO `video` VALUES (841, 4, 1, '当 Taylor Swift 碰上 Katy Perry！', 'http://img.kaiyanapp.com/db73f32d5937899595adee86b139725d.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=137983&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606390087, 1585981985);
INSERT INTO `video` VALUES (842, 4, 7, '「18」岁的那个夏天，你是如何度过的？', 'http://img.kaiyanapp.com/4936b81b1dd6376ce577f02d6c5cc935.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=167876&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (843, 4, 7, '翻唱「What Makes You Beautiful」', 'http://img.kaiyanapp.com/cd1b99b7dfbe02f486c1353d4bd1dc57.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=118976&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606710194, 1585981985);
INSERT INTO `video` VALUES (844, 4, 6, '小破团带你游伦敦「One Thing」MV', 'http://img.kaiyanapp.com/dcf2fdd9acb42b39d28001ce9a25fdae.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=128882&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606919051, 1585981985);
INSERT INTO `video` VALUES (845, 4, 3, 'Travis Atreo 翻唱「Perfect」', 'http://img.kaiyanapp.com/1c16cb17b8efa89bea2d9f453fd0ee8d.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=118119&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607330694, 1585981985);
INSERT INTO `video` VALUES (846, 4, 6, 'Attention！被「Despacito」支配的恐惧还记得吗？', 'http://img.kaiyanapp.com/e8cd1e8b956c2bc201f92ad544d46ce1.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=168323&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607318688, 1585981985);
INSERT INTO `video` VALUES (847, 4, 8, 'Matt Bloyd 串烧「狮子王」两首经典原声', 'http://img.kaiyanapp.com/6dd6ac93ad071eb9ffdff977252ccc22.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=169203&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (848, 4, 1, 'Pentatonix 翻唱「Making Christmas」', 'http://img.kaiyanapp.com/30ecaf0952f36267c869b10549461fac.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138008&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (849, 4, 5, '烈日炎炎，来首「Waving Through A Window」清凉一夏！', 'http://img.kaiyanapp.com/ffd6c44be8c871e9d980d4533f7263ff.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=161610&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (850, 4, 3, 'PTX 人声翻唱经典「The Sound of Silence」', 'http://img.kaiyanapp.com/16e9b8be3a373d9d780d40678a6661b0.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=151040&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833338, 1585981985);
INSERT INTO `video` VALUES (851, 4, 3, '大神翻唱系列：人声演绎啪姐热单「New Rules」', 'http://img.kaiyanapp.com/a9a80c2b89860c790e4d8d58a0bbb27f.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136602&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (852, 4, 7, '超震撼！人声翻唱格莱美金曲「Shallow」', 'http://img.kaiyanapp.com/ed196d2d481adcd5c306bd87889087de.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=162320&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607256486, 1585981985);
INSERT INTO `video` VALUES (853, 4, 8, '夫妻翻唱圣诞经典「Christmas Hallelujah」', 'http://img.kaiyanapp.com/10315cd84b221c1739eca098ed7757d5.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139093&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 7, 0, 0, '', 2, 1607318300, 1585981985);
INSERT INTO `video` VALUES (854, 4, 5, 'iPhone XR 广告曲「Come Along」也能这样唱？', 'http://img.kaiyanapp.com/4ae17b18c62685ff7089659259bec7a1.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=154829&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607786603, 1585981985);
INSERT INTO `video` VALUES (855, 4, 5, '神降光芒于此，圣诞夜的好去处', 'http://img.kaiyanapp.com/1da6757ac1ce076dfd6f74ce85f91b59.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=143742&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606565898, 1585981985);
INSERT INTO `video` VALUES (856, 4, 7, '一起绕着圣诞树跳舞吧！', 'http://img.kaiyanapp.com/8c7fdbda14ed57899861786f3c662982.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140135&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332811, 1585981985);
INSERT INTO `video` VALUES (857, 4, 3, '覆盆子夹心奶油蛋糕', 'http://img.kaiyanapp.com/50eade53e054b9125d6a5da4d33c9b43.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=141079&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606709585, 1585981985);
INSERT INTO `video` VALUES (858, 4, 2, 'Jared 纯人声翻唱串烧 Imagine Dragons 热单', 'http://img.kaiyanapp.com/539e61214d0cbf9228d743cf0fa1f69c.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139143&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606725344, 1585981985);
INSERT INTO `video` VALUES (859, 4, 4, '致敬 Journey！Jared 人声串烧多首经典歌曲', 'http://img.kaiyanapp.com/f9170a538e9064b2edce0d9e0f6d5e80.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=153748&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606725250, 1585981985);
INSERT INTO `video` VALUES (860, 4, 5, '紧靠一张嘴，五分钟唱爽梦龙的经典热单', 'http://img.kaiyanapp.com/127acd53a45b72cbb0b51248603f59e1.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140478&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833356, 1585981985);
INSERT INTO `video` VALUES (861, 4, 1, '让你一次听个够！分裂人声翻唱萌德热单串烧', 'http://img.kaiyanapp.com/f055113289d4498468da525561e5359d.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139142&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833546, 1585981985);
INSERT INTO `video` VALUES (862, 4, 2, 'Jared 纯人声爵士风串烧 Michael Bublé 热单', 'http://img.kaiyanapp.com/536ca0eca44afcec890b5c966fefac9d.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139144&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (863, 4, 4, '人声串烧：圣诞节怎么能少了这些经典歌曲！', 'http://img.kaiyanapp.com/f34a5027a9cfe2361a2d8a3d055d20c8.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=142836&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607930944, 1585981985);
INSERT INTO `video` VALUES (864, 4, 6, '惊艳！人声串烧「马戏之王」多首原声', 'http://img.kaiyanapp.com/b70d7a09b15daad55c916fb217a7f914.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=168064&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606395723, 1585981985);
INSERT INTO `video` VALUES (865, 4, 6, '六分钟阿卡贝拉演绎迈克尔·杰克逊经典混音', 'http://img.kaiyanapp.com/8751c9691f648a81d8acfacf348807df.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140464&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607331792, 1585981985);
INSERT INTO `video` VALUES (866, 4, 3, '七分钟人声翻唱串烧皇后乐队 Queen 的经典', 'http://img.kaiyanapp.com/5f5403b63aa5bc8e57896efbac7312fe.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138045&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606577501, 1585981985);
INSERT INTO `video` VALUES (867, 4, 1, '致敬披头士！5 分钟人声串烧 22 首经典歌曲', 'http://img.kaiyanapp.com/91f04fab4d6e1acf8c6baf5938ea2a87.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=157109&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607325811, 1585981985);
INSERT INTO `video` VALUES (868, 4, 3, '一只平底锅就能做的极品早餐', 'http://img.kaiyanapp.com/3e4508584553d5257a681371de32c3cd.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=10112&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608299660, 1585981985);
INSERT INTO `video` VALUES (869, 4, 3, '他坚持45年, 拍摄有趣的灵魂', 'http://img.kaiyanapp.com/f10bceae3d46312f6881b8917bf0dc54.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=110090&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (870, 4, 7, '迷幻视觉动画：衍生', 'http://img.kaiyanapp.com/a88051ea8321208bdb818da6a0849c8d.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=114249&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606831336, 1585981985);
INSERT INTO `video` VALUES (871, 4, 2, '比起打败对手，更难的是战胜自己', 'http://img.kaiyanapp.com/f88b5e2d1b6f1831ff1203faefa7208e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=114409&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (872, 4, 8, '啪啪啪的时候，快乐究竟来自哪里？', 'http://img.kaiyanapp.com/d3986816daf9daac9f03064b83cefd47.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=116661&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607072840, 1585981985);
INSERT INTO `video` VALUES (873, 4, 1, '说到啪啪啪，多久才算久？', 'http://img.kaiyanapp.com/6e96a95efcaffdb16194e287f296dd9b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=121997&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606919216, 1585981985);
INSERT INTO `video` VALUES (874, 4, 7, '在太空中啪啪啪是一种什么样的体验？', 'http://img.kaiyanapp.com/06b9200565c4dd09a2dd4d779ee13314.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=122677&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (875, 4, 6, '2 分钟了解女性「啪啪啪」全过程', 'http://img.kaiyanapp.com/b791ff216f44bf9f336480c95b362cb7.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139529&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606830379, 1585981985);
INSERT INTO `video` VALUES (876, 4, 4, '14 个关于啪啪啪的酷炫事实', 'http://img.kaiyanapp.com/62a3beb2b17914e512fd51efebe5336e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=145230&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606724896, 1585981985);
INSERT INTO `video` VALUES (877, 4, 2, '7 个理由告诉你为什么一定要啪啪啪', 'http://img.kaiyanapp.com/46abf517217f52c1b64f38676e9d3596.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=146161&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606393217, 1585981985);
INSERT INTO `video` VALUES (878, 4, 3, '广州 | 设计周展+灯光展 【第二期】', 'http://img.kaiyanapp.com/66e53017ea00705788b4616a596e738d.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140591&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606708581, 1585981985);
INSERT INTO `video` VALUES (879, 4, 8, '深圳  | 甘坑小镇+2019【第三期】', 'http://img.kaiyanapp.com/948acaddd6ee4fc23e7204d4ac21dbbb.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=145397&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (880, 4, 5, '字幕蒙版效果（第八期剪辑教程）', 'http://img.kaiyanapp.com/0604654980ca143346d35feb9881240d.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=168496&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833342, 1585981985);
INSERT INTO `video` VALUES (881, 4, 5, 'WWSD-摄影师宝妹在上海的家。', 'http://img.kaiyanapp.com/578c56ab9bd7f1a5302807cb805fdc12.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=110425&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607168169, 1585981985);
INSERT INTO `video` VALUES (882, 4, 2, 'WWSD-睡衣和早餐-第二集', 'http://img.kaiyanapp.com/e1ccbacd50ad28a4e7b86e9d085f0bd7.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=119227&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (883, 4, 4, '阳光正好的下午我在人才公园都拍了些什么？', 'http://img.kaiyanapp.com/3e0dc4354a10224429f36991b99d75a6.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=160719&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606820039, 1585981985);
INSERT INTO `video` VALUES (884, 4, 6, '健身值得坚持，一起 Get 好身材好伴侣', 'http://img.kaiyanapp.com/4e7ab78c95df9cb9326beffe0151e77e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=165202&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (885, 4, 1, '新西兰怀卡托大学的生活小片段', 'http://img.kaiyanapp.com/218a6f94a9a5616a6663a7a572be7ca3.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140273&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (886, 4, 3, '新派青年 第一期', 'http://img.kaiyanapp.com/bc4aefd78f8349961b7735dab6b8e0fb.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=123808&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 1, 0, 0, 0, '', 2, 1606364408, 1585981985);
INSERT INTO `video` VALUES (887, 4, 5, '三大黑科技一个月不堵头，爱普生这台打印机', 'http://img.kaiyanapp.com/b1c891277f8b252f108f50cf44012985.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=155607&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (888, 4, 3, '我们「不一样」，但都一样倒霉', 'http://img.kaiyanapp.com/6619bd958552fbc0a54f20eb38d9cba6.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=108785&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1606996640, 1585981985);
INSERT INTO `video` VALUES (889, 4, 2, '「追」到我，我就嫁给你', 'http://img.kaiyanapp.com/5f2954df58130d4af0017b8bd7596f76.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=113191&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607324044, 1585981985);
INSERT INTO `video` VALUES (890, 4, 8, '快感、焦虑、性障碍，他患上“网络色情瘾”', 'http://img.kaiyanapp.com/aa9c26ef9709b8bdb6ecffc4ed2cd32e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=113722&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (891, 4, 8, '醒醒，人生没有奇迹面对现实吧', 'http://img.kaiyanapp.com/dc4264273943be6db55ce028305f063a.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=114219&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (892, 4, 8, '虽然有点污，但都是为了你好啊', 'http://img.kaiyanapp.com/1bc96f610c245355fea7fccef97111a9.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=115760&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607332816, 1585981985);
INSERT INTO `video` VALUES (893, 4, 3, '国人睡不好觉！这4大误区每个人都该看', 'http://img.kaiyanapp.com/e90ebaca66180f94901395ca390ff8de.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=115893&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607164772, 1585981985);
INSERT INTO `video` VALUES (894, 4, 6, '茄子这样烧，鲜香入味补气血！', 'http://img.kaiyanapp.com/94e4defb221f8450b02c3aeefe6229ac.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=116264&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607955094, 1585981985);
INSERT INTO `video` VALUES (895, 4, 8, '他用 7 年跟拍 8 对夫妻，探寻婚姻保鲜秘诀', 'http://img.kaiyanapp.com/f8bfcfbf96bbfd544aee848e973c4022.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=120532&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607251387, 1585981985);
INSERT INTO `video` VALUES (896, 4, 2, '十大最佳现代超级跑车盘点！', 'http://img.kaiyanapp.com/6ff905858051152797de8a64d75938f5.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=124889&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1608563542, 1585981985);
INSERT INTO `video` VALUES (897, 4, 5, '动画 MV：梦想总要有的，万一实现了呢', 'http://img.kaiyanapp.com/ce84ca0855bdeb52d02f6679e04fa3a8.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136982&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 1, 0, 0, 0, '', 2, 1606389779, 1585981985);
INSERT INTO `video` VALUES (898, 4, 5, '麻婆豆腐的美味，难怪征服了地球人的胃！', 'http://img.kaiyanapp.com/93ab2c757b265946be6b2a23fb4b6661.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=123540&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607162515, 1585981985);
INSERT INTO `video` VALUES (899, 4, 2, '十大最佳现代超级跑车盘点！', 'http://img.kaiyanapp.com/6ff905858051152797de8a64d75938f5.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=124889&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 21, 0, 0, '', 2, 1607167994, 1585981985);
INSERT INTO `video` VALUES (900, 4, 7, '娜塔莉·波特曼突破自我！「光之声」预告', 'http://img.kaiyanapp.com/618296d963a60147cadc40737d1de133.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=134189&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (901, 4, 6, '聆听山与水的声音：探索加拿大班夫公园', 'http://img.kaiyanapp.com/61d01c15f5b4e881edbb5e4537d73746.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136121&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607159054, 1585981985);
INSERT INTO `video` VALUES (902, 4, 2, '创意品牌短片：百变包包', 'http://img.kaiyanapp.com/1d52255f3915c54dd030cf958ec720ae.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136310&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (903, 4, 5, '虽然你是爸爸，但今天也过母亲节', 'http://img.kaiyanapp.com/4fac3f3498c0044e923e69d9d9a2eba3.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=159856&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607324774, 1585981985);
INSERT INTO `video` VALUES (904, 4, 2, '国际接吻日特辑 | 影史 100 个经典 kiss', 'http://img.kaiyanapp.com/72d231689d145343c842ca7a38b2c400.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=165931&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607332845, 1585981985);
INSERT INTO `video` VALUES (905, 4, 8, ' 清爽可口凉拌菌，你的心和胃！', 'http://img.kaiyanapp.com/911457b19df014f3c091c38cedbf15db.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=170321&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606565787, 1585981985);
INSERT INTO `video` VALUES (906, 4, 1, '心动新斯科舍，一起来倾听海洋的秘密', 'http://img.kaiyanapp.com/feecd483519c91c63eb36acd4f545a1a.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=171794&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332588, 1585981985);
INSERT INTO `video` VALUES (907, 4, 3, '如何打造一个日式庭院？', 'http://img.kaiyanapp.com/9ae9c467963cdef51313e44aaea4e586.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=25162&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608459021, 1585981985);
INSERT INTO `video` VALUES (908, 4, 2, 'Alex G 翻唱「Cruise」', 'http://img.kaiyanapp.com/68e34e39bb459b802c43252b0a0a6231.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=117768&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607314675, 1585981985);
INSERT INTO `video` VALUES (909, 4, 6, '获奖 CG 短片：被污染的水下世界', 'http://img.kaiyanapp.com/09005279860dab66a03fc838f21acf1b.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=133991&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 4, 0, 0, 0, 0, '', 2, 1608522609, 1585981985);
INSERT INTO `video` VALUES (910, 4, 4, '还在发愁行李不会收拾？27 个打包小技巧让你摆脱烦恼', 'http://img.kaiyanapp.com/9e385641c4465e058717e01aefe23086.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139612&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (911, 4, 7, '我是机器人，但也可以和你啪啪啪', 'http://img.kaiyanapp.com/8e88056aa30300455d54f4917374e2ea.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=152582&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 4, 0, 0, 0, 0, '', 2, 1607325863, 1585981985);
INSERT INTO `video` VALUES (912, 4, 8, '讽刺动画，拒绝假唱从米奇做起', 'http://img.kaiyanapp.com/88a16c0ae429a26388aedaa91cbb92d2.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=158515&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (913, 4, 2, '在班夫滑春雪', 'http://img.kaiyanapp.com/e54c68bf3550423ec214f695cf791ce6.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=159064&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606725188, 1585981985);
INSERT INTO `video` VALUES (914, 4, 8, '动物保护广告：获得这样的冠军你感到羞愧吗', 'http://img.kaiyanapp.com/41b6934e20cef578de57e88b7099ceb0.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=165915&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332769, 1585981985);
INSERT INTO `video` VALUES (915, 4, 5, '史上最「美国」的一条广告', 'http://img.kaiyanapp.com/648b64e4acf1b6950fcfaf520405f3a6.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=35459&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833595, 1585981985);
INSERT INTO `video` VALUES (916, 4, 5, '路人甲秒变女主角，连走路都是大片', 'http://img.kaiyanapp.com/148c2992046c17ac8f9cd50c9d38f8dd.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=56626&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606566102, 1585981985);
INSERT INTO `video` VALUES (917, 4, 6, '36 个极具创意的书籍封面', 'http://img.kaiyanapp.com/2b4dd01ed4709a2670b081608b8d1256.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=67272&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (918, 4, 3, '一只平底锅就能做的极品早餐', 'http://img.kaiyanapp.com/3e4508584553d5257a681371de32c3cd.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=10112&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 3, 0, 0, '', 2, 1607332826, 1585981985);
INSERT INTO `video` VALUES (919, 4, 2, '他坚持45年, 拍摄有趣的灵魂', 'http://img.kaiyanapp.com/f10bceae3d46312f6881b8917bf0dc54.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=110090&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607326344, 1585981985);
INSERT INTO `video` VALUES (920, 4, 6, '迷幻视觉动画：衍生', 'http://img.kaiyanapp.com/a88051ea8321208bdb818da6a0849c8d.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=114249&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608097264, 1585981985);
INSERT INTO `video` VALUES (921, 4, 7, '比起打败对手，更难的是战胜自己', 'http://img.kaiyanapp.com/f88b5e2d1b6f1831ff1203faefa7208e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=114409&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 1, 0, 0, '', 2, 1607168943, 1585981985);
INSERT INTO `video` VALUES (922, 4, 5, '啪啪啪的时候，快乐究竟来自哪里？', 'http://img.kaiyanapp.com/d3986816daf9daac9f03064b83cefd47.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=116661&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606926540, 1585981985);
INSERT INTO `video` VALUES (923, 4, 2, '说到啪啪啪，多久才算久？', 'http://img.kaiyanapp.com/6e96a95efcaffdb16194e287f296dd9b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=121997&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608479354, 1585981985);
INSERT INTO `video` VALUES (924, 4, 2, '在太空中啪啪啪是一种什么样的体验？', 'http://img.kaiyanapp.com/06b9200565c4dd09a2dd4d779ee13314.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=122677&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606565348, 1585981985);
INSERT INTO `video` VALUES (925, 4, 5, '2 分钟了解女性「啪啪啪」全过程', 'http://img.kaiyanapp.com/b791ff216f44bf9f336480c95b362cb7.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139529&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607320061, 1585981985);
INSERT INTO `video` VALUES (926, 4, 7, '14 个关于啪啪啪的酷炫事实', 'http://img.kaiyanapp.com/62a3beb2b17914e512fd51efebe5336e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=145230&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607318871, 1585981985);
INSERT INTO `video` VALUES (927, 4, 7, '7 个理由告诉你为什么一定要啪啪啪', 'http://img.kaiyanapp.com/46abf517217f52c1b64f38676e9d3596.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=146161&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607085683, 1585981985);
INSERT INTO `video` VALUES (928, 4, 2, '2CELLOS 提琴演奏「Cavatina」', 'http://img.kaiyanapp.com/1f08c340adfbad557464dad156784b41.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=119960&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607332854, 1585981985);
INSERT INTO `video` VALUES (929, 4, 1, '提琴双杰乔装演奏「加勒比海盗」经典配乐', 'http://img.kaiyanapp.com/78ab57d1446741d4d0b0e699a9f2cbcf.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139249&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1606988320, 1585981985);
INSERT INTO `video` VALUES (930, 4, 3, '净化人心！2CELLOS 提琴双杰「Hallelujah」', 'http://img.kaiyanapp.com/e7285a07b56b8eb47590b1b7b2cf297b.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=142845&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607332818, 1585981985);
INSERT INTO `video` VALUES (931, 4, 8, '2CELLOS 大提琴演奏「Eye Of The Tiger」', 'http://img.kaiyanapp.com/b3481156712e25109faad646648e4929.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=119951&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607168890, 1585981985);
INSERT INTO `video` VALUES (932, 4, 3, '2CELLOS 演奏「Seven Nation Army」', 'http://img.kaiyanapp.com/bb2f65753ba301bd7fa5d989a0fb840d.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=119957&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607325842, 1585981985);
INSERT INTO `video` VALUES (933, 4, 5, 'Donkee 编舞「Quiet Storm」  ', 'http://img.kaiyanapp.com/b8a4d313ce8fe9fe9a51df0be9d57c4b.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=110256&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608097223, 1585981985);
INSERT INTO `video` VALUES (934, 4, 8, '超好听小提琴演奏「First Light」', 'http://img.kaiyanapp.com/8aeb21188c389f3922e02338ef25f2bc.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=121317&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607158940, 1585981985);
INSERT INTO `video` VALUES (935, 4, 2, '游戏音乐混剪：做好准备去风暴中心吧', 'http://img.kaiyanapp.com/6cd8dfb60b5d579b4301bd4b39f6db31.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=125980&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833352, 1585981985);
INSERT INTO `video` VALUES (936, 4, 5, '2018 EMA | Halsey 雨中演唱「Without Me」', 'http://img.kaiyanapp.com/14f7ec8c6b79baed76e5df3837fa4742.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=135578&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (937, 4, 3, '游戏音乐混剪：别让我走', 'http://img.kaiyanapp.com/dad300d97a879f87f951b35b07f76468.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=126831&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607314605, 1585981985);
INSERT INTO `video` VALUES (938, 4, 1, '曹博文：冬日必吃酸菜鱼，切鱼片鱼一步到位', 'http://img.kaiyanapp.com/563a8476a91a9f8236044e8008213124.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=146414&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (939, 4, 8, '双层银河乳酪蛋糕', 'http://img.kaiyanapp.com/c8e5b5a0cf414e004c38e8ec65a88184.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=166820&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332548, 1585981985);
INSERT INTO `video` VALUES (940, 4, 8, '迪士尼奕欧来随拍1分钟', 'http://img.kaiyanapp.com/65857f898421afe262d9a5eeffe440ee.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=157993&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607276988, 1585981985);
INSERT INTO `video` VALUES (941, 4, 1, '26 种烹饪诀窍和技巧', 'http://img.kaiyanapp.com/2ed2dda046498f5475f9e2aae64c2e51.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=168029&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607327095, 1585981985);
INSERT INTO `video` VALUES (942, 4, 7, '为什么你的时间总是不够用？这条视频给你答案', 'http://img.kaiyanapp.com/d952af79613ad3e08877e0345c653e5f.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=157586&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606919065, 1585981985);
INSERT INTO `video` VALUES (943, 4, 4, '只有 1% 的人能做到的事，5 步让你拥有更多时间', 'http://img.kaiyanapp.com/4883ab7f025d9e53f3710e2db1d6edbe.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=154628&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606808330, 1585981985);
INSERT INTO `video` VALUES (944, 4, 5, '美食分析师：耗时7小时的手工咖喱鱼蛋', 'http://img.kaiyanapp.com/628192f5ca566c67ac54cb55f964f5a9.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=153450&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (945, 4, 2, 'Malafacha | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/b23134d4a1ecd31537ee6e8e9c7184d0.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139246&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607276540, 1585981985);
INSERT INTO `video` VALUES (946, 4, 8, 'Mugako | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/c66288100ecc0bea7d436557c4357f2c.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139721&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (947, 4, 2, 'Kris Goyri | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/3b4e09d372527200f76f685e7fadc1ec.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139277&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607848205, 1585981985);
INSERT INTO `video` VALUES (948, 4, 8, 'Galo Bertin | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/f5d998f4469e634e01eab7f4c1da7e31.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139271&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1608285008, 1585981985);
INSERT INTO `video` VALUES (949, 4, 1, 'Sankuanz | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/f1b2460a8ffabce569b7228adc47fc5d.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=141276&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1608261252, 1585981985);
INSERT INTO `video` VALUES (950, 4, 2, 'Apujan | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/41030a0fc61ed21f2807c87e3103694d.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=141275&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607149626, 1585981985);
INSERT INTO `video` VALUES (951, 4, 3, 'Pineda Covalin | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/c90825cb9402e282c8c6a4959267df86.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139245&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607325347, 1585981985);
INSERT INTO `video` VALUES (952, 4, 1, 'Anuar Lyon | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/5bef17b87074c39770a05afb79f247b6.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139276&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607312598, 1585981985);
INSERT INTO `video` VALUES (953, 4, 1, '包 | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/cfe0038de34a66e7486818c67092a7be.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139719&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (954, 4, 6, 'Aucarre | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/23c8049f5aea75d86d1fc4b7babf2a67.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=141267&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607318716, 1585981985);
INSERT INTO `video` VALUES (955, 4, 3, 'Joana Braga | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/40e91acc14598336a1f6d36998ac7b15.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139729&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606401571, 1585981985);
INSERT INTO `video` VALUES (956, 4, 3, 'Nycole | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/b50f4de7b62fc27b3379c7ec74978691.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138529&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (957, 4, 5, 'MEAM | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/f4d36efe75147e364c1da5c57c09e98e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138535&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606726564, 1585981985);
INSERT INTO `video` VALUES (958, 4, 3, 'Decenio | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/5133a058bc0e59f5cff85bab912b41dd.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139938&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606809833, 1585981985);
INSERT INTO `video` VALUES (959, 4, 6, '玛丽亚梅拉 | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/a73af8f5764ebde3694382effb6ca6b2.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=141277&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607158144, 1585981985);
INSERT INTO `video` VALUES (960, 4, 2, 'Storytailors | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/a4fcea075acfecfa432b7d879060241e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138078&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606813575, 1585981985);
INSERT INTO `video` VALUES (961, 4, 8, 'Mugako | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/c66288100ecc0bea7d436557c4357f2c.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139721&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 4, 0, 0, 0, 0, '', 2, 1607000441, 1585981985);
INSERT INTO `video` VALUES (962, 4, 5, 'Malafacha | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/b23134d4a1ecd31537ee6e8e9c7184d0.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139246&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (963, 4, 8, 'Aucarre | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/23c8049f5aea75d86d1fc4b7babf2a67.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=141267&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607161063, 1585981985);
INSERT INTO `video` VALUES (964, 4, 4, 'Sankuanz | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/f1b2460a8ffabce569b7228adc47fc5d.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=141276&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (965, 4, 7, '生物科学家：失明不再是不治之症', 'http://img.kaiyanapp.com/3eaff56543e4cf32ed8f2f04b9927964.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139304&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833708, 1585981985);
INSERT INTO `video` VALUES (966, 4, 7, '杨宇光：成本探索太空，需要依靠这两种火箭', 'http://img.kaiyanapp.com/1398b724de78433d173baa7291f5dc41.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140974&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (967, 4, 7, '航天二院杨宇光：空间站有哪些重要技术？', 'http://img.kaiyanapp.com/e9ef620bf097966a362a76e0ddb42b81.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=149738&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (968, 4, 2, '马强：温暖的俄罗斯', 'http://img.kaiyanapp.com/6a130d0204d70ce723006006ef42470b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=155921&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607090739, 1585981985);
INSERT INTO `video` VALUES (969, 4, 1, '徐星：恐龙与鸟', 'http://img.kaiyanapp.com/9caf85fce5340d43a49eee7b7da5100f.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=145981&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (970, 4, 6, '周雯：当我们放弃嗅觉时我们放弃了什么', 'http://img.kaiyanapp.com/67d15e8b23f37f4ece57220f1c93fc4c.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=167508&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (971, 4, 6, '懒才是科技进步的最大源动力', 'http://img.kaiyanapp.com/e8f0eb3f5e6dc01da4b0f443e1108b66.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=157157&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606820963, 1585981985);
INSERT INTO `video` VALUES (972, 4, 7, '杨辉：罕见病的基因药离我们有多远？', 'http://img.kaiyanapp.com/4437680e59d135405e70edd5503306f8.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=165751&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1608460697, 1585981985);
INSERT INTO `video` VALUES (973, 4, 1, '杜忆：音乐如何塑造了我们的大脑', 'http://img.kaiyanapp.com/845d10d8c02d22e2cda2492c3d95e2be.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=153693&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606725793, 1585981985);
INSERT INTO `video` VALUES (974, 4, 8, '罗非：痛到底是什么', 'http://img.kaiyanapp.com/42123685022aa01283d4dd2865441496.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136248&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1608385381, 1585981985);
INSERT INTO `video` VALUES (975, 4, 3, '咆哮吧，你就是天生的王者：翻唱「Roar」', 'http://img.kaiyanapp.com/2d096a93e53c9d5f870921a95b9032ee.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=112401&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607256894, 1585981985);
INSERT INTO `video` VALUES (976, 4, 6, '一学就会的舌尖美味：香辣芝麻鸡翅', 'http://img.kaiyanapp.com/f30476023d43e6d5382cd284c148755e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=114545&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607169968, 1585981985);
INSERT INTO `video` VALUES (977, 4, 3, 'KHS 翻唱「阿拉丁」电影主题曲', 'http://img.kaiyanapp.com/9829932d2590a11b8808a5bbd73f50b5.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=117787&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606809974, 1585981985);
INSERT INTO `video` VALUES (978, 4, 1, '给自己放个假：亚特兰大清新大宅', 'http://img.kaiyanapp.com/708d92ca6255a94928222282c9df9d00.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=121535&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606996804, 1585981985);
INSERT INTO `video` VALUES (979, 4, 5, '售价上千万，自带车库的豪华房车', 'http://img.kaiyanapp.com/a2a6de0f2e69814692902297b50f2c8d.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=122681&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608458177, 1585981985);
INSERT INTO `video` VALUES (980, 4, 3, '8 月 27 日| 去加拿大感受自然的魅力', 'http://img.kaiyanapp.com/5623b93633177cad1aa112cc7f5fb21e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=131515&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608479191, 1585981985);
INSERT INTO `video` VALUES (981, 4, 5, '爽口劲道的酸辣柠檬凤爪，只要几步就做好', 'http://img.kaiyanapp.com/40972cdce8f61452a37aa44578582a9d.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=132788&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332713, 1585981985);
INSERT INTO `video` VALUES (982, 4, 5, '5 分钟了解保时捷 911 全系车型', 'http://img.kaiyanapp.com/0c1556957c66688a384f1df795f324d0.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=134549&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606726921, 1585981985);
INSERT INTO `video` VALUES (983, 4, 8, '创意品牌短片：梦幻纯净之蓝', 'http://img.kaiyanapp.com/816cac6421d0abe9276288fcbc2fd1d4.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=135811&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607325977, 1585981985);
INSERT INTO `video` VALUES (984, 4, 6, '创意品牌短片：毛刺植物的细腻触角', 'http://img.kaiyanapp.com/4d1727579949b48becaf1622820cde34.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=137516&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608284982, 1585981985);
INSERT INTO `video` VALUES (985, 4, 7, '蓝莓波纹起司蛋糕', 'http://img.kaiyanapp.com/228013d5532a030e559cbe9ba45e302e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=132006&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (986, 4, 8, '番茄三文鱼焖饭', 'http://img.kaiyanapp.com/276479da2a44b123026b7cd3af7074ca.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=133336&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607164457, 1585981985);
INSERT INTO `video` VALUES (987, 4, 8, '酸甜莓果馅饼', 'http://img.kaiyanapp.com/55cc7ae1180afcc46ee328b0acf31f06.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138554&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607321033, 1585981985);
INSERT INTO `video` VALUES (988, 4, 1, '青柠奶油派', 'http://img.kaiyanapp.com/1d997ce759e30d610a034ff0fc854460.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=147494&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607090661, 1585981985);
INSERT INTO `video` VALUES (989, 4, 5, 'ASMR 甜品教程：红石榴奶油蛋糕', 'http://img.kaiyanapp.com/4acc73419d79b0f8003e68cf7b77d0a1.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138238&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606565089, 1585981985);
INSERT INTO `video` VALUES (990, 4, 4, '柠檬起司蛋糕块', 'http://img.kaiyanapp.com/89e3d9a7f29c6a24c2a6ef29947e5d3b.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=147623&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (991, 4, 5, '草莓馅饼', 'http://img.kaiyanapp.com/2fdf6f9487768114d5569ac9680aa13f.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=132130&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (992, 4, 8, 'ASMR 甜品教程：柠檬马卡龙', 'http://img.kaiyanapp.com/fbd678ee178196ada566475daf96bfee.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138343&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (993, 4, 1, '虾这么做，让人忍不住想连壳都吞下去', 'http://img.kaiyanapp.com/e470952c092e9684ce8c7091c1935ef9.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=161739&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1608458864, 1585981985);
INSERT INTO `video` VALUES (994, 4, 3, 'ASMR 甜品教程：红石榴提拉米苏', 'http://img.kaiyanapp.com/c2f677b84fa7bbf349dd4cb89c98f839.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=133382&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332737, 1585981985);
INSERT INTO `video` VALUES (995, 4, 2, '一个盲目的乐观者「wonderful life」歌词 MV', 'http://img.kaiyanapp.com/3f3f6206f360cd6440faa6ba0d887e61.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=134602&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (996, 4, 5, '内心深处的感受「Deep Down」歌词 MV', 'http://img.kaiyanapp.com/5a02983b15eacf9e02da2306d95a6035.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=126213&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607168967, 1585981985);
INSERT INTO `video` VALUES (997, 4, 1, '诡异少女 Poppy 联手 Diplo「Time Is Up」MV', 'http://img.kaiyanapp.com/441e79faafe0d37c89d874f29685840c.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=124100&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608385400, 1585981985);
INSERT INTO `video` VALUES (998, 4, 8, '4 分钟换装 11 套！Iggy 新单「Started」MV', 'http://img.kaiyanapp.com/56fea0fb06e0aaef14274f86654e40b1.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=159239&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332799, 1585981985);
INSERT INTO `video` VALUES (999, 4, 4, 'T.I. 新作联手 Yo Gotti「Wraith」MV', 'http://img.kaiyanapp.com/883e089fb37ab150571cd93c44091b6b.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=130599&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981985, 1585981985);
INSERT INTO `video` VALUES (1000, 4, 7, '美到维纳斯诞生「More Than That」MV', 'http://img.kaiyanapp.com/c8aa2cecbabc7b9ff218d0905e88049e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=147529&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607323413, 1585981985);
INSERT INTO `video` VALUES (1001, 4, 3, '麻将桌上的嘻哈「Stir Fry」MV', 'http://img.kaiyanapp.com/7ed14840786caaf9335ad1e4e2cdc99d.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=111704&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607332729, 1585981996);
INSERT INTO `video` VALUES (1002, 4, 5, '女子笛子乐团「The Flute Song」MV', 'http://img.kaiyanapp.com/4fd729d2a87e6c4c9bf0a51dc7787e44.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=124109&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606394895, 1585981996);
INSERT INTO `video` VALUES (1003, 4, 8, '撞色复古创意 MV：Bad Ideas', 'http://img.kaiyanapp.com/006c715fa5d3074226cdae38e6b2429d.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140559&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606724277, 1585981996);
INSERT INTO `video` VALUES (1004, 4, 4, '夏日乐悠悠Jonas Brothers 新单「Cool」上线！', 'http://img.kaiyanapp.com/ac7b6780df15c99e4283fccb8c0f743c.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=156240&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1606926550, 1585981996);
INSERT INTO `video` VALUES (1005, 4, 5, '励志追梦动画：别因为恐惧，错失你的梦想', 'http://img.kaiyanapp.com/c864ef3181ffd7fd1ec6f340ada6d8ec.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=144729&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607172621, 1585981996);
INSERT INTO `video` VALUES (1006, 4, 7, '纯真励志短片：小男孩的航天梦，万一实现了呢', 'http://img.kaiyanapp.com/1312e8c20ed09b1a32033d646ad32820.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=137463&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607270372, 1585981996);
INSERT INTO `video` VALUES (1007, 4, 3, '获奖动画短片：失眠的你，需要一次旅行', 'http://img.kaiyanapp.com/ce91d146a2cae6b1f2cb34cd27b4f835.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=144148&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 1, 0, 0, '', 2, 1607251373, 1585981996);
INSERT INTO `video` VALUES (1008, 4, 6, '你的陪伴，是我孤独时光最大的慰藉', 'http://img.kaiyanapp.com/13781c6b1ca6ba88c71024ae3dde4f46.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=153617&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1009, 4, 1, '当你的宝贝们收到他们最爱的狗狗', 'http://img.kaiyanapp.com/16f8f455f335c6f2df37c2dd210a0d91.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=125389&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1010, 4, 4, '跨越五代的记忆', 'http://img.kaiyanapp.com/e3a98b2b3b269695c75767bd85ec21ef.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=121128&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1011, 4, 6, '我失去了主人，但并没有对人性感到失望', 'http://img.kaiyanapp.com/7b228211b2df5eca6dc041eff529f2b7.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=166072&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607327110, 1585981996);
INSERT INTO `video` VALUES (1012, 4, 3, '如果没有别人强大，也请换个方式继续努力', 'http://img.kaiyanapp.com/80dd20b61313c4975ebde94fbd2d5975.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=132043&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1013, 4, 1, '讽刺动画，拒绝假唱从米奇做起', 'http://img.kaiyanapp.com/88a16c0ae429a26388aedaa91cbb92d2.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=158515&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606725341, 1585981996);
INSERT INTO `video` VALUES (1014, 4, 5, '困兽TheTrapped Warrior', 'http://img.kaiyanapp.com/bb4b1a6ae8e48e65ed911b479dc621f7.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=162804&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606394653, 1585981996);
INSERT INTO `video` VALUES (1015, 4, 5, '定格动画 MV：被社交网络杀死的我们', 'http://img.kaiyanapp.com/2b55dd8998f26a576b8169a0823827ba.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=162913&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606993062, 1585981996);
INSERT INTO `video` VALUES (1016, 4, 6, '懒得上班，只想做一只磨磨蹭蹭的蜗牛', 'http://img.kaiyanapp.com/03d9a5d047d9b9c1a397d9cce81a0a70.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=147565&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606721504, 1585981996);
INSERT INTO `video` VALUES (1017, 4, 3, '日本清新女子乐队，送你夏日小情歌', 'http://img.kaiyanapp.com/9ff3d6ffd7a173cc30f212b97662ca1e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=168796&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606581574, 1585981996);
INSERT INTO `video` VALUES (1018, 4, 3, '动画 MV：梦想总要有的，万一实现了呢', 'http://img.kaiyanapp.com/ce84ca0855bdeb52d02f6679e04fa3a8.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136982&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1019, 4, 2, '音乐推荐 | 在夏日结束前来一场恋爱吧', 'http://img.kaiyanapp.com/d132eadbba9d55d1d12d55f034fd3d7d.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=168197&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1608458359, 1585981996);
INSERT INTO `video` VALUES (1020, 4, 5, '音乐推荐 | 时光流逝不停，我们依旧相爱', 'http://img.kaiyanapp.com/45667875f20cffa70715f418e8c25268.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=164302&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606831390, 1585981996);
INSERT INTO `video` VALUES (1021, 4, 3, 'Thirty Seconds To Mars「Walk On Water」MV', 'http://img.kaiyanapp.com/192daf983715e6f346de430ec73374d4.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=116108&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607167166, 1585981996);
INSERT INTO `video` VALUES (1022, 4, 1, '超魔性 MV：当十字绣遇上二次元', 'http://img.kaiyanapp.com/dcfe97655851e7c04a5b7a125516eb09.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=127986&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606717207, 1585981996);
INSERT INTO `video` VALUES (1023, 4, 1, '即便你已离去，你仍拥有我的一切', 'http://img.kaiyanapp.com/186f70f54ca9d8376718ce3168ede87e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=170033&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607318155, 1585981996);
INSERT INTO `video` VALUES (1024, 4, 8, 'Jared Halley 人声翻唱经典歌曲「Africa」', 'http://img.kaiyanapp.com/049ab86842be5c427b4fa2a6e72bc0dc.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=154546&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607953945, 1585981996);
INSERT INTO `video` VALUES (1025, 4, 3, '壁虎是如何战胜重力的？', 'http://img.kaiyanapp.com/0488e118c8491a55b91ae82acd23846c.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138252&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606981521, 1585981996);
INSERT INTO `video` VALUES (1026, 4, 2, '面团做出一朵花，色香味全酥掉渣！', 'http://img.kaiyanapp.com/cb2a1dd2a873e8512c4c75a8d7bad2ca.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=141508&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1027, 4, 7, '韩国催泪广告：失语妈妈唱出生日快乐歌', 'http://img.kaiyanapp.com/81be5853937b98adc605cbff6894ded9.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=147062&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1028, 4, 7, '给宝马摩托车加一个拖车怎么样', 'http://img.kaiyanapp.com/f5b4a69c456d50838534fb369c3afca1.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=144979&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607325933, 1585981996);
INSERT INTO `video` VALUES (1029, 4, 1, '鸡翅新吃法，你绝对想不到！', 'http://img.kaiyanapp.com/ac7a074aec0d14fb367dfa04b806a299.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=122755&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606395495, 1585981996);
INSERT INTO `video` VALUES (1030, 4, 4, '做麻花加点料，瞬间有了海的味道！', 'http://img.kaiyanapp.com/1eaeb6d5d01ba81b89365f4641d3b57a.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=142520&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1031, 4, 8, '猪年揉个猪汤圆，“猪”（诸）事顺利一整年', 'http://img.kaiyanapp.com/2bb9acd018e84ae7aa3a1d6d689dff83.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=150310&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606390465, 1585981996);
INSERT INTO `video` VALUES (1032, 4, 4, '8 个 ins 风拍照姿势，让你在另一半的镜头里超迷人', 'http://img.kaiyanapp.com/e6f66d45457541be295e921974599c15.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=131939&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608097259, 1585981996);
INSERT INTO `video` VALUES (1033, 4, 2, '情侣旅拍教科书：东京是爱情的模样', 'http://img.kaiyanapp.com/f0f4d4b81015e53dfcc6b9990cea6ba7.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=131854&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1034, 4, 5, '这种方法做饼干，最简单！', 'http://img.kaiyanapp.com/6d3c560f1a69a7d60411016119874b6e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136378&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607261222, 1585981996);
INSERT INTO `video` VALUES (1035, 4, 2, '食妞|一人食，是人生的必修课', 'http://img.kaiyanapp.com/0bea771c02a0eeffbb4ff0912b4fbdc8.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=111107&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607318047, 1585981996);
INSERT INTO `video` VALUES (1036, 4, 3, '一个人，一个周末，一餐饭', 'http://img.kaiyanapp.com/89b1d9a59acab2a1f19a29ac564c8450.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=156916&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606832259, 1585981996);
INSERT INTO `video` VALUES (1037, 4, 2, '模范屋主VOL.9《一个人的家》', 'http://img.kaiyanapp.com/83e68000d788ed9006a29107a18a43b2.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=161554&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1038, 4, 2, 'V-log01 一个人如何优雅的吃海底捞', 'http://img.kaiyanapp.com/de0c22c4587659f45bf414fbb3f54987.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=147478&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 2, 0, 0, '', 2, 1608542099, 1585981996);
INSERT INTO `video` VALUES (1039, 4, 1, '5 种方法教你学会独处却不会孤单', 'http://img.kaiyanapp.com/ea165fcc2a97ed41562479a2b83352bd.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=146115&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607168831, 1585981996);
INSERT INTO `video` VALUES (1040, 4, 3, '一个人组成的超牛合唱团！', 'http://img.kaiyanapp.com/df828f4985fa63ff375abb3d77929774.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=121864&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833305, 1585981996);
INSERT INTO `video` VALUES (1041, 4, 2, '「生き甲斐」，来自日本人的幸福公式', 'http://img.kaiyanapp.com/0b22de3eca1591571ba2d468e970deb8.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=164804&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607332822, 1585981996);
INSERT INTO `video` VALUES (1042, 4, 6, '独在异乡，你有多久没有跟家人一起过生日', 'http://img.kaiyanapp.com/c8ea3504705ad9dd38eb2631439ab13d.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140925&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 2, 0, 0, '', 2, 1607161364, 1585981996);
INSERT INTO `video` VALUES (1043, 4, 5, '温馨感人，从天而降的爱情', 'http://img.kaiyanapp.com/9af5a3bf23329d2556e54ccdbf1ce0a7.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=160485&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606565165, 1585981996);
INSERT INTO `video` VALUES (1044, 4, 2, '小柴犬与豆腐的奇妙故事', 'http://img.kaiyanapp.com/ef507f34756a05db6bc2b698e65151c2.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=152480&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 4, 0, 0, 0, 0, '', 2, 1607332728, 1585981996);
INSERT INTO `video` VALUES (1045, 4, 4, '极限竞速Demo直播演示', 'http://img.kaiyanapp.com/175ad91e57b8c9b5a6661bf3b5686387.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=168604&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606395935, 1585981996);
INSERT INTO `video` VALUES (1046, 4, 6, '调色demo', 'http://img.kaiyanapp.com/cce726dc4dbf5525158d867c3d53103e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=122020&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606996627, 1585981996);
INSERT INTO `video` VALUES (1047, 4, 1, '极品飞车19-Demo演示', 'http://img.kaiyanapp.com/adbc63fb07465287ade03dd8883d5cc3.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139362&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607149756, 1585981996);
INSERT INTO `video` VALUES (1048, 4, 5, '《冬焕漫游奇境》片头DEMO', 'http://img.kaiyanapp.com/9849eecc27fe1544ec8c217bb92be28b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=120450&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606724753, 1585981996);
INSERT INTO `video` VALUES (1049, 4, 8, '不想关灯', 'http://img.kaiyanapp.com/a8a582ba3ee233612c1f3fca16cc319a.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=164884&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607167409, 1585981996);
INSERT INTO `video` VALUES (1050, 4, 3, '2019年UCA&UDA大学夏令营开幕式', 'http://img.kaiyanapp.com/0690857edfeacf9c6fc7e2cd92a2ffd7.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=168358&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1051, 4, 3, '丝路基金宣传片视频demo', 'http://img.kaiyanapp.com/e1e0b84453c8a37965a8d76f538761f8.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=165334&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1052, 4, 5, '原曲：Problem - Betta Watch Yo Self ', 'http://img.kaiyanapp.com/c4c9e66fea113b68e4f5e81799e31665.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138140&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606396046, 1585981996);
INSERT INTO `video` VALUES (1053, 4, 4, '你通过代购买过的最不靠谱的东西是什么？', 'http://img.kaiyanapp.com/64d85432305678cba81282dd2d8878af.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139460&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606829186, 1585981996);
INSERT INTO `video` VALUES (1054, 4, 3, '神奇的中国魔力之碗？到底有什么奥妙？', 'http://img.kaiyanapp.com/4d8a631e65d91c01053217fcb081c64d.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=114197&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607000562, 1585981996);
INSERT INTO `video` VALUES (1055, 4, 7, '高铁和动车的区别到底是什么？', 'http://img.kaiyanapp.com/0ea1fb31c53c877f75aa9c8e0131f166.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=109919&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606726843, 1585981996);
INSERT INTO `video` VALUES (1056, 4, 7, '美国惊悚广告：是什么吓走了鬼？', 'http://img.kaiyanapp.com/9f435f5b707d55d16ab416b20d3aaa42.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=170086&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 4, 0, 0, 0, 0, '', 2, 1607325906, 1585981996);
INSERT INTO `video` VALUES (1057, 4, 4, 'ADV 减震基础 Ep.1', 'http://img.kaiyanapp.com/dcddc769cff190c3386a0248418af5fe.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=129917&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1058, 4, 2, 'NASA到底是谁？精神原力来自哪儿？', 'http://img.kaiyanapp.com/302439887c18caae2482dbca633a3720.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138010&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608430869, 1585981996);
INSERT INTO `video` VALUES (1059, 4, 8, '剧透预警！「蜘蛛侠：英雄远征」的彩蛋解析', 'http://img.kaiyanapp.com/1946e78f325775448b6cca9665982572.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=165679&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607318215, 1585981996);
INSERT INTO `video` VALUES (1060, 4, 5, 'VLOG是什么？认证vlogger来说说', 'http://img.kaiyanapp.com/54f6f6073a9e639e32f1dfa42c50b9c3.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=141501&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606831702, 1585981996);
INSERT INTO `video` VALUES (1061, 4, 8, '买护肤品要重金砸在精华上吗', 'http://img.kaiyanapp.com/d2f3e3174998347566dc8113a8934803.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=152414&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607159862, 1585981996);
INSERT INTO `video` VALUES (1062, 4, 7, '口香糖嚼到烂，剩下那坨黏糊糊的是什么？', 'http://img.kaiyanapp.com/968e40c6aafa0b533e53c0e1558e6321.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=124755&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1063, 4, 7, '游戏人间：猫咪公主和它的神秘包裹', 'http://img.kaiyanapp.com/bbfff95282346324b908fed9cfd603d2.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=122980&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1606996748, 1585981996);
INSERT INTO `video` VALUES (1064, 4, 4, '西西第一次滑雪比赛', 'http://img.kaiyanapp.com/211f303293f587420115121d5e9ec4ac.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=148662&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607332742, 1585981996);
INSERT INTO `video` VALUES (1065, 4, 4, '#第一次画画2018.10.28#', 'http://img.kaiyanapp.com/f80bd3366e03580a8a82c9b8ad76c00c.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139024&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1608458095, 1585981996);
INSERT INTO `video` VALUES (1066, 4, 2, 'VLOG 在巴厘岛第一次享受度假', 'http://img.kaiyanapp.com/566b249f325ea0b0d6be3a8be713da8e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=161266&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607169037, 1585981996);
INSERT INTO `video` VALUES (1067, 4, 8, '比特小队：紧张又刺激，停不下来的受虐之旅', 'http://img.kaiyanapp.com/dcffc7fc929c474a7f67cc07e7dbacf8.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=153501&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1068, 4, 4, '0～100岁为你讲述他们「第一次」的故事', 'http://img.kaiyanapp.com/85707567a194174d70a11439b707ecd8.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=154631&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607318967, 1585981996);
INSERT INTO `video` VALUES (1069, 4, 7, '假如给你一台时光机，你要回到哪个年纪？', 'http://img.kaiyanapp.com/b9e3e337527956f08339aa9233817e77.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=159448&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607332743, 1585981996);
INSERT INTO `video` VALUES (1070, 4, 2, '四人行 ：青城后山两日游', 'http://img.kaiyanapp.com/33e2a6d1e3a83d68323fe6ab87a19882.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=170114&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1071, 4, 5, '可爱视频：婴儿第一次发现雪花', 'http://img.kaiyanapp.com/4b9aec69e8c306afeff1b6f1ccc8e3f5.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=112482&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1072, 4, 2, '青秀 青春 青映', 'http://img.kaiyanapp.com/20bead1ff575dd7667d131af693c01f3.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=130523&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606395078, 1585981996);
INSERT INTO `video` VALUES (1073, 4, 3, '思想领袖演讲模板', 'http://img.kaiyanapp.com/31b9af2a26c3d8b090c508990ed6ace6.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=134238&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606395532, 1585981996);
INSERT INTO `video` VALUES (1074, 4, 3, '澳洲创作新人 Ruel ，实力颜值双爆表', 'http://img.kaiyanapp.com/45d54b8ffe638e01c7ab20869bdd3e2e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=170261&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1606993678, 1585981996);
INSERT INTO `video` VALUES (1075, 4, 7, '超多梗！动画恶搞 A 妹「thank u, next」', 'http://img.kaiyanapp.com/38063ca585372955e7a1748d9f4c0ce0.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=150615&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 4, 0, 0, '', 2, 1607166216, 1585981996);
INSERT INTO `video` VALUES (1076, 4, 1, '泰国浪漫搞笑广告：艺术与否，只在一念之间', 'http://img.kaiyanapp.com/49de6c0778c3ead8e3d40349a5c7c6da.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=168438&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606394471, 1585981996);
INSERT INTO `video` VALUES (1077, 4, 2, '数数汽车广告的套路', 'http://img.kaiyanapp.com/48e60e4f96eb9065e3e567c17f986eda.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=127373&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 1, 0, 0, 0, '', 2, 1606833771, 1585981996);
INSERT INTO `video` VALUES (1078, 4, 2, '蒙娜丽莎为何微笑？', 'http://img.kaiyanapp.com/521a39b714fa5d6e4fb95d6df8cd05d8.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=150485&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607323421, 1585981996);
INSERT INTO `video` VALUES (1079, 4, 5, '一旦无路可退，你才有决心面对', 'http://img.kaiyanapp.com/ac0c3d3401e22e9ab166445745a51a07.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=132975&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1080, 4, 6, '超魔性洗脑广告曲：流量之歌', 'http://img.kaiyanapp.com/112ccdacd46ece961a9b4398e80f2598.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=128873&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607787606, 1585981996);
INSERT INTO `video` VALUES (1081, 4, 8, '用 GIF 也可以做出一支音乐录影带', 'http://img.kaiyanapp.com/88cebf3f721997cbf0ebb2aa371ba4dc.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=168081&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606566161, 1585981996);
INSERT INTO `video` VALUES (1082, 4, 5, '生娃前后生活对比', 'http://img.kaiyanapp.com/c570aeaa77a18096a5a62eb24f6f0e65.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=123107&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606831950, 1585981996);
INSERT INTO `video` VALUES (1083, 4, 8, '如何用FinalCut制作出萤火虫/飞蛾', 'http://img.kaiyanapp.com/0bb4d41c5215223852a927351d635c67.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=145316&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1606980874, 1585981996);
INSERT INTO `video` VALUES (1084, 4, 5, '动态的萤火虫：新西兰萤火虫洞的延时', 'http://img.kaiyanapp.com/4d4a4fe11060355352bb14dd5b80f06d.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=147698&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607168481, 1585981996);
INSERT INTO `video` VALUES (1085, 4, 5, 'FinalCutPro不求人时光倒退效果', 'http://img.kaiyanapp.com/679e17c1f106f3bf5dd22256a01d62e5.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=130398&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1086, 4, 5, '瞬间白天变晚上视频中添加下雨后的效果演示', 'http://img.kaiyanapp.com/eeb732ff7a3d1129e275c70b7bfcee22.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=159062&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 7, 0, 0, 0, 0, '', 2, 1607319189, 1585981996);
INSERT INTO `video` VALUES (1087, 4, 8, '据说是台北最美的夜景，可以看到萤火虫', 'http://img.kaiyanapp.com/6a29114542af25d4d6329a58f663173b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=153044&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607079216, 1585981996);
INSERT INTO `video` VALUES (1088, 4, 5, 'Final CutPro不求人竖屏变宽屏', 'http://img.kaiyanapp.com/174ec506a2f3aa93c9aa512f76c15eb1.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=115079&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607332741, 1585981996);
INSERT INTO `video` VALUES (1089, 4, 6, '轻松学会给视频添加转场', 'http://img.kaiyanapp.com/aba2de9a197640296831c6768bb3eb4b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=148330&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607318402, 1585981996);
INSERT INTO `video` VALUES (1090, 4, 1, 'Final Cut Pro不求人滤镜效果', 'http://img.kaiyanapp.com/8379cedf0d846468aeb40519b1269d2c.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=115370&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 2, 0, 0, '', 2, 1608430862, 1585981996);
INSERT INTO `video` VALUES (1091, 4, 8, 'FinalCutPro不求人形状遮罩演示', 'http://img.kaiyanapp.com/d2b43dccda7014c27846b8d61c954117.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=117384&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607332686, 1585981996);
INSERT INTO `video` VALUES (1092, 4, 6, '如何在视频中导出单张图片或单独片段FCP', 'http://img.kaiyanapp.com/082190eca7669bf28e8a6dafe405381b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=162729&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606831872, 1585981996);
INSERT INTO `video` VALUES (1093, 4, 4, '比起被管教，孩子可能更适合做「管教」', 'http://img.kaiyanapp.com/2d9b3df160d8f4eb60cb1f382f0f437d.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=115462&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607319124, 1585981996);
INSERT INTO `video` VALUES (1094, 4, 8, '零距离现场体验多累都值 世界杯游记大收官', 'http://img.kaiyanapp.com/f6b8d71ddb6ed07723c62c3230f63e46.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=120429&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1095, 4, 5, '做一道香辣鸡尖，下酒下饭还下剧，太上头了', 'http://img.kaiyanapp.com/c152d18a82143fc8e6352f2de7e2220b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=168822&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1096, 4, 8, '台风天吃了3顿泡面，今天我要八菜一汤', 'http://img.kaiyanapp.com/e8bc141d2e379a0ab61c22dcf74df410.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=127436&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833737, 1585981996);
INSERT INTO `video` VALUES (1097, 4, 2, '90后只用3天把老房子改造成时尚短租空间', 'http://img.kaiyanapp.com/19efbd38b895c533d99b82daee825756.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=117667&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606395259, 1585981996);
INSERT INTO `video` VALUES (1098, 4, 3, '是时候吃掉你眼前的键盘了', 'http://img.kaiyanapp.com/b204e915436503d9e9ad9c18982ea492.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=160140&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607318954, 1585981996);
INSERT INTO `video` VALUES (1099, 4, 6, '爱长板 爱自由', 'http://img.kaiyanapp.com/3717a86ba77b3f5e34b8ab2c0d59b66c.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=161964&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607083544, 1585981996);
INSERT INTO `video` VALUES (1100, 4, 2, '猫咪们搬新家第一天，一副满意的样子', 'http://img.kaiyanapp.com/e82cbbd8300d0e3619e12cd774de3fe6.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=115266&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606390738, 1585981996);
INSERT INTO `video` VALUES (1101, 4, 1, '宇宙有多大？', 'http://img.kaiyanapp.com/b4ffcf0f98e0ca4f5a402863e3e433a1.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=155212&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1102, 4, 3, '买辆山地车，竟然也能改变人生？', 'http://img.kaiyanapp.com/79751e3d161e227e642c11c851673114.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=132547&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607324086, 1585981996);
INSERT INTO `video` VALUES (1103, 4, 1, 'ASMR 甜品教程：无花果奶油蛋糕', 'http://img.kaiyanapp.com/795e3b37fc619b59b40c8973e25f0964.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138366&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1104, 4, 4, '奶油千层煎饼', 'http://img.kaiyanapp.com/b73375edb695401b26d67cea2a822c7f.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=142479&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607312755, 1585981996);
INSERT INTO `video` VALUES (1105, 4, 3, '巧克力草莓瓶蛋糕', 'http://img.kaiyanapp.com/6670a4683fd70fa507056a7f2d3dc5ad.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=143960&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607165834, 1585981996);
INSERT INTO `video` VALUES (1106, 4, 5, '秋日南瓜小点心', 'http://img.kaiyanapp.com/8b64974caf4abe72ed5a21776aadfbe4.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=134661&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607166803, 1585981996);
INSERT INTO `video` VALUES (1107, 4, 1, '黄油牛奶肉桂卷', 'http://img.kaiyanapp.com/1c31fcb80acfed8753624cd76d5658f4.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=145585&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1108, 4, 2, '甜瓜奶油蛋糕', 'http://img.kaiyanapp.com/7bf24967b79f9afcec37bd91a615c0a6.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140823&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1606994562, 1585981996);
INSERT INTO `video` VALUES (1109, 4, 5, '苹果起司蛋糕', 'http://img.kaiyanapp.com/6dc9cd850651e1d6d2e2a94821bbe8bd.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139965&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607325910, 1585981996);
INSERT INTO `video` VALUES (1110, 4, 3, 'ASMR 耳机福利：酥脆可可泡芙', 'http://img.kaiyanapp.com/a8adfd2045a588682473937a7816b2e9.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=130855&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606832199, 1585981996);
INSERT INTO `video` VALUES (1111, 4, 1, '一千多人都在做的香甜南瓜意面酱', 'http://img.kaiyanapp.com/3faa80f4b628e731fd150f8c85a21d56.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=110754&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606582348, 1585981996);
INSERT INTO `video` VALUES (1112, 4, 7, '芋圆烧仙草|爱上你，因为你咬起来最带劲！', 'http://img.kaiyanapp.com/c179097789db9fc0c9ced60f2e093054.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=117389&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 3, 0, 0, '', 2, 1607166040, 1585981996);
INSERT INTO `video` VALUES (1113, 4, 1, '过鞋瘾 adidas BillupsPE', 'http://img.kaiyanapp.com/f3886fea450d8c7ed55baafc7d426e2c.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=115659&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607316861, 1585981996);
INSERT INTO `video` VALUES (1114, 4, 8, '过鞋瘾 | 李宁专业跑鞋特辑', 'http://img.kaiyanapp.com/4b06c9ccefb2cea344a5f687b78e596b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136421&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833931, 1585981996);
INSERT INTO `video` VALUES (1115, 4, 6, '过鞋瘾 | AIR JORDAN 18', 'http://img.kaiyanapp.com/e4d2b5d13694cde8992afca20f1be2ae.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136413&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1116, 4, 5, '过鞋瘾 | NIKE LEBRON 16', 'http://img.kaiyanapp.com/c13ec1af56c8517f14b3713f60d45e99.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136410&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1117, 4, 7, '鞋会讲科技VOL29PUMA CELL', 'http://img.kaiyanapp.com/69faddffb0e3d9e11cc3fb3c7db288ce.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136429&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606389926, 1585981996);
INSERT INTO `video` VALUES (1118, 4, 2, '鞋会讲科技 adidas Bounce', 'http://img.kaiyanapp.com/75224bc8314b4517412f7b0aa7bbc2e7.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139365&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607332729, 1585981996);
INSERT INTO `video` VALUES (1119, 4, 4, '鞋会讲科技 NIKE ULTRAMAX', 'http://img.kaiyanapp.com/62692c781b265b6ba91759361b13a5b6.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=133443&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607320724, 1585981996);
INSERT INTO `video` VALUES (1120, 4, 1, '鞋会讲科技13 NIKE REACT', 'http://img.kaiyanapp.com/7cb11dfb20605b15236b30ee8d81833b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=113683&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 2, 0, 0, '', 2, 1607165022, 1585981996);
INSERT INTO `video` VALUES (1121, 4, 6, '甜品还是咖啡？一分钟带你领略苦与甜的世界', 'http://img.kaiyanapp.com/6a76a5d82c69e7a83e7c693871f98ef4.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=143546&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607332846, 1585981996);
INSERT INTO `video` VALUES (1122, 4, 5, '最受女生欢迎的 10 款男士香水，人生赢家必备！', 'http://img.kaiyanapp.com/b03b95a225a9836bb8c04972c82c99c9.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=125091&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607162610, 1585981996);
INSERT INTO `video` VALUES (1123, 4, 2, '《神奇动物在哪里2》第三支官方中文预告', 'http://img.kaiyanapp.com/477a6519c9e097f9fc7c303a03548e68.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=117516&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1124, 4, 5, '「神奇动物 2」预告特辑：J.K.罗琳现身解读', 'http://img.kaiyanapp.com/883f654e63f1c4913d6c3728f0c33722.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=132585&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606565826, 1585981996);
INSERT INTO `video` VALUES (1125, 4, 8, '霍格沃茨开学了！「神奇动物 2」预告特辑', 'http://img.kaiyanapp.com/aa7437b05792717ad146d60195cfa388.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=124912&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1126, 4, 7, '小米9拆解：结构简单易量产/做工愈发稳定', 'http://img.kaiyanapp.com/c5875f6d52ed9d9e936d85ad61d9e178.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=151656&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606364810, 1585981996);
INSERT INTO `video` VALUES (1127, 4, 7, '高萌来袭！「乐高大电影 2」预告', 'http://img.kaiyanapp.com/f57e3225fc2ebed33dee9c2f57a954ad.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138576&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606724893, 1585981996);
INSERT INTO `video` VALUES (1128, 4, 7, '崔宇：这里有一份“艺术外卖”！', 'http://img.kaiyanapp.com/3e7c6c0851b5e1c3729348feb6205919.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=160327&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1129, 4, 8, '悬疑惊悚片「忌日快乐 2」最新预告', 'http://img.kaiyanapp.com/44b51cc9a194c725204295312750db84.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=144759&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833509, 1585981996);
INSERT INTO `video` VALUES (1130, 4, 7, '反套路广告：过河「拆」车的男人', 'http://img.kaiyanapp.com/508c2f2f4a9adbbe388b7a1766f29fdc.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=122856&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833341, 1585981996);
INSERT INTO `video` VALUES (1131, 4, 1, '一美惊悚片「玻璃先生」第二支中文预告', 'http://img.kaiyanapp.com/3da9d4391f85f74e11b69d78a1737f5d.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=131506&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1606996938, 1585981996);
INSERT INTO `video` VALUES (1132, 4, 7, '动物也疯狂：醉酒的獾深夜上演大飙车', 'http://img.kaiyanapp.com/01be2a8a6d6e39c7b470fd40599d50e6.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=145908&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607161400, 1585981996);
INSERT INTO `video` VALUES (1133, 4, 5, '当潮人遇到潮车......', 'http://img.kaiyanapp.com/028463749e2ab39dad5578ac602afee3.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=134051&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606726846, 1585981996);
INSERT INTO `video` VALUES (1134, 4, 3, '看见厦门-SEE AMOY', 'http://img.kaiyanapp.com/63070988ad50f745792076ba10add201.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=127838&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607249560, 1585981996);
INSERT INTO `video` VALUES (1135, 4, 4, '「Rick Owens」2019 春夏时装发布', 'http://img.kaiyanapp.com/a2348213fb87e5e04b6624387a144646.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=130345&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607320052, 1585981996);
INSERT INTO `video` VALUES (1136, 4, 4, '时尚掌中宝｜打开周末唤醒爱人的最浪漫方式', 'http://img.kaiyanapp.com/f599d4731497c96b9c195ba6049ae796.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=111112&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607277064, 1585981996);
INSERT INTO `video` VALUES (1137, 4, 2, '偶遇石人殿庙会', 'http://img.kaiyanapp.com/23478eee3609ea37396df19a515acc68.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=132166&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606393384, 1585981996);
INSERT INTO `video` VALUES (1138, 4, 7, '疯狂单板滑雪不走寻常路！大神技巧秀起来！', 'http://img.kaiyanapp.com/7bba7a4c5a68ab07667030616cc420a8.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=143653&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607159104, 1585981996);
INSERT INTO `video` VALUES (1139, 4, 4, '她用轮椅跳了一段舞蹈,所有人都惊呆了', 'http://img.kaiyanapp.com/1dd8c75586e0402fd52449e82f27514f.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=113138&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1140, 4, 7, '《小鬼当家》真。续集来了 | TOPYS', 'http://img.kaiyanapp.com/f042a7665c93084053278f2ce64d69e6.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=143577&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 2, 0, 0, '', 2, 1607167624, 1585981996);
INSERT INTO `video` VALUES (1141, 4, 5, '「Alexander McQueen」2019 春夏时装发布', 'http://img.kaiyanapp.com/64faac1eef8796738b8be5c00e2857fb.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=130223&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606831101, 1585981996);
INSERT INTO `video` VALUES (1142, 4, 8, 'Nicole Kirkland 编舞「Kream」', 'http://img.kaiyanapp.com/e3965724c03dbb12343889d78d5799b6.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=129011&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606579349, 1585981996);
INSERT INTO `video` VALUES (1143, 4, 1, 'Nicole Kirkland 动感编舞 「Horses」', 'http://img.kaiyanapp.com/c4a852d414f271d72ccdc3530d32b5a8.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140954&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1144, 4, 8, 'Nicole Kirkland 编舞「Rich Sex」  ', 'http://img.kaiyanapp.com/aa8e02453f3943cd2ada10e612fcf054.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=114388&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608178409, 1585981996);
INSERT INTO `video` VALUES (1145, 4, 7, 'JIYOUNG 编舞「How Many Times」  ', 'http://img.kaiyanapp.com/ead8147b8c24f25d1c247e2daa9771b0.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=135464&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608385385, 1585981996);
INSERT INTO `video` VALUES (1146, 4, 2, 'HERTZ 编舞「How Many Times」 ', 'http://img.kaiyanapp.com/f1ba2822ab4277b64073f26fabea4b0c.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136131&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607153635, 1585981996);
INSERT INTO `video` VALUES (1147, 4, 5, 'ALL.K 编舞「How Long」 ', 'http://img.kaiyanapp.com/50b286a03bd4ee8d8a18741f9eb10f1f.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=110257&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1148, 4, 7, 'Nicole Kirkland 编舞', 'http://img.kaiyanapp.com/ae7b1753110c3f62e08d6a993604c461.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=142402&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607323486, 1585981996);
INSERT INTO `video` VALUES (1149, 4, 5, 'ALL.K 编舞「Do U Wrong」 ', 'http://img.kaiyanapp.com/c52a5a8fe250df7e9cc734c91dab80f7.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=110101&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608097260, 1585981996);
INSERT INTO `video` VALUES (1150, 4, 4, 'Nicole Kirkland 编舞「Karma」', 'http://img.kaiyanapp.com/bf21eb11dbeb031123feb63b91ad790c.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=142404&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606824549, 1585981996);
INSERT INTO `video` VALUES (1151, 4, 4, 'Nicole Kirkland 编舞「Mama」', 'http://img.kaiyanapp.com/81767fa30de9da2e7bf8efbe5c9d1cd6.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=142400&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1152, 4, 1, 'Nycole | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/b50f4de7b62fc27b3379c7ec74978691.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138529&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1608458683, 1585981996);
INSERT INTO `video` VALUES (1153, 4, 8, 'MEAM | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/f4d36efe75147e364c1da5c57c09e98e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138535&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 5, 0, 0, 0, 0, '', 2, 1607159316, 1585981996);
INSERT INTO `video` VALUES (1154, 4, 6, 'Decenio | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/5133a058bc0e59f5cff85bab912b41dd.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139938&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1155, 4, 4, '米格尔维埃拉 | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/03a1380e36429c347219395cacdae652.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138536&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1156, 4, 5, 'Storytailors | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/a4fcea075acfecfa432b7d879060241e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138078&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1157, 4, 2, 'Sara Maia | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/983a131ae62c20907143c4511c2ed0a1.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138531&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606810153, 1585981996);
INSERT INTO `video` VALUES (1158, 4, 3, 'Sophia Kah | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/bafe3558fbe911fe0b9c260e20c85971.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138075&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607261381, 1585981996);
INSERT INTO `video` VALUES (1159, 4, 6, 'Aucarre | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/23c8049f5aea75d86d1fc4b7babf2a67.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=141267&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1160, 4, 6, 'Carla Pontes | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/6f31efe49def599046c70a1905b913e4.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139936&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607320049, 1585981996);
INSERT INTO `video` VALUES (1161, 4, 8, 'Nuno Baltazar | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/086e42a450edcbd63ac19e30a7e79b24.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138533&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606831829, 1585981996);
INSERT INTO `video` VALUES (1162, 4, 1, '教育公司创始人：孩子能做到成人不能做到的', 'http://img.kaiyanapp.com/4d5cc48bfa2a3d6803b4067d966e343e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139298&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1163, 4, 8, '把美做成一种生意，一条是靠什么成功的？', 'http://img.kaiyanapp.com/e11b39ec2bbb94939b148b8f05aa4737.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138829&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607955115, 1585981996);
INSERT INTO `video` VALUES (1164, 4, 1, '中国消费者是否把节操都献给了二维码？', 'http://img.kaiyanapp.com/edf5a0d7724bc1303bd9be8c144388d2.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=147952&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607332739, 1585981996);
INSERT INTO `video` VALUES (1165, 4, 3, '快节奏里的慢生活，摄影师夫妇开的浪漫花店', 'http://img.kaiyanapp.com/e9063d834e83736c20751c2e8b81b81b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=168654&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1166, 4, 6, '王希：中国游戏缺的是什么？', 'http://img.kaiyanapp.com/78dce5965b24a4d46bed457daf7a43db.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140472&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1167, 4, 3, '没落的企业，通常都是管理过度，领导不足', 'http://img.kaiyanapp.com/219964532b1d6300f592bd9157f30793.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=151110&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606581685, 1585981996);
INSERT INTO `video` VALUES (1168, 4, 5, '我终于找到了健身的终极动力', 'http://img.kaiyanapp.com/5c32876723b58b74d2d175e62f62ebaf.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=167451&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1169, 4, 4, '宝马高管：出行变革中中国会是引领者', 'http://img.kaiyanapp.com/a9d6269fa42da4c79b11c1f05b67d282.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=143285&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607165349, 1585981996);
INSERT INTO `video` VALUES (1170, 4, 1, '弱人工智能时代产品量产的必备要素有这些', 'http://img.kaiyanapp.com/f95b73633fc6a09b86c0204d15816cb3.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=111740&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1171, 4, 2, '俄罗斯电影「买下我」中文预告', 'http://img.kaiyanapp.com/5776abf53c9fa29bb64ceea786cef2c4.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=114001&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1172, 4, 6, '咆哮吧，你就是天生的王者：翻唱「Roar」', 'http://img.kaiyanapp.com/2d096a93e53c9d5f870921a95b9032ee.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=112401&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607319142, 1585981996);
INSERT INTO `video` VALUES (1173, 4, 5, '夏天胃口太好，还得归功于它！', 'http://img.kaiyanapp.com/5717c257588878afbe26413219a0b567.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=114077&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606726691, 1585981996);
INSERT INTO `video` VALUES (1174, 4, 7, '一学就会的舌尖美味：香辣芝麻鸡翅', 'http://img.kaiyanapp.com/f30476023d43e6d5382cd284c148755e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=114545&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607165470, 1585981996);
INSERT INTO `video` VALUES (1175, 4, 7, 'KHS 翻唱「阿拉丁」电影主题曲', 'http://img.kaiyanapp.com/9829932d2590a11b8808a5bbd73f50b5.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=117787&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1176, 4, 6, '8 月 27 日| 去加拿大感受自然的魅力', 'http://img.kaiyanapp.com/5623b93633177cad1aa112cc7f5fb21e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=131515&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 4, 0, 0, 0, 0, '', 2, 1607332821, 1585981996);
INSERT INTO `video` VALUES (1177, 4, 6, '动画 MV：梦想总要有的，万一实现了呢', 'http://img.kaiyanapp.com/ce84ca0855bdeb52d02f6679e04fa3a8.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136982&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607090750, 1585981996);
INSERT INTO `video` VALUES (1178, 4, 5, '创意 LG 品牌短片：探秘银河星系', 'http://img.kaiyanapp.com/ef12150a74480c49d4beacbac67cd8a7.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=148135&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607165081, 1585981996);
INSERT INTO `video` VALUES (1179, 4, 1, '高燃踩点！漫威 DC 女性英雄混剪', 'http://img.kaiyanapp.com/bfe54011d2cbd2df7bbf1415796d66b0.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=152978&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1180, 4, 6, '享饕餮大餐来北京国贸79，满足你的胃！', 'http://img.kaiyanapp.com/c74fa9bd51ad4477dad3af2d99d374d6.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=169739&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607318940, 1585981996);
INSERT INTO `video` VALUES (1181, 4, 2, '史上最「美国」的一条广告', 'http://img.kaiyanapp.com/648b64e4acf1b6950fcfaf520405f3a6.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=35459&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1182, 4, 2, '3 个制作定格的小技巧，新技能 get！', 'http://img.kaiyanapp.com/39085345d65fd57c6c41ca755d5cd719.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=144380&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607165449, 1585981996);
INSERT INTO `video` VALUES (1183, 4, 7, '萌猫可以看到激光哦', 'http://img.kaiyanapp.com/8c7e626a7f29731e6824859dc7d7c3f0.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=110164&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1184, 4, 4, '90 秒学会 5 种超简单创意摄影技巧', 'http://img.kaiyanapp.com/ef07650ee09aac6fb4b73fd0643bf76b.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=153522&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607166019, 1585981996);
INSERT INTO `video` VALUES (1185, 4, 7, '这个夏天，欢迎来柠檬度假村玩！', 'http://img.kaiyanapp.com/61d252054f4a4a4b83fe2f6a831f4fb8.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=166554&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606981527, 1585981996);
INSERT INTO `video` VALUES (1186, 4, 8, '你家的孩子不吃青菜吗？', 'http://img.kaiyanapp.com/21bf6f80158d643123a47bf05a57b3fd.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=114727&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606718368, 1585981996);
INSERT INTO `video` VALUES (1187, 4, 3, '刚出生的小猫咪的第一声啼哭', 'http://img.kaiyanapp.com/1acc2f940eaa3a5d20b71b739e7d9155.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=125414&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833748, 1585981996);
INSERT INTO `video` VALUES (1188, 4, 5, '现实版的超级马里奥跑酷，高手真的在民间', 'http://img.kaiyanapp.com/7664aa1a0b0239a0bf13d32ac554e501.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=146057&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607162452, 1585981996);
INSERT INTO `video` VALUES (1189, 4, 8, '做冰粉真的很头疼，折腾了两个礼拜才做出来', 'http://img.kaiyanapp.com/a9e4b19e32187942891e362d32a50c07.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=120661&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833344, 1585981996);
INSERT INTO `video` VALUES (1190, 4, 5, '巨型草莓恶作剧狗用草莓', 'http://img.kaiyanapp.com/4340402b504a11f4a3070fde7f2f202c.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=132196&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1191, 4, 6, '林间厨房之香酥牛肉派', 'http://img.kaiyanapp.com/5a6a8133cba51af28dc97709b28bcdbd.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136246&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606818780, 1585981996);
INSERT INTO `video` VALUES (1192, 4, 3, '跟汤老湿学英国俚语', 'http://img.kaiyanapp.com/9ac350a5a7c56301d4f92ea7b5319c71.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136493&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1606992597, 1585981996);
INSERT INTO `video` VALUES (1193, 4, 8, '跟詹米多南学北爱尔兰俚语', 'http://img.kaiyanapp.com/fcc159b2e5410dc9eb8c8924dfed0e6f.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138733&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606820643, 1585981996);
INSERT INTO `video` VALUES (1194, 4, 2, '跟亚历山大斯卡斯加德学瑞典俚语', 'http://img.kaiyanapp.com/c9f9f7a8bba55afadd61e6a46ffce90d.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138948&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608385384, 1585981996);
INSERT INTO `video` VALUES (1195, 4, 5, '动作犯罪片「贼王」正式预告', 'http://img.kaiyanapp.com/234b31f477a6c90dbda827020b4ad945.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=111893&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608479050, 1585981996);
INSERT INTO `video` VALUES (1196, 4, 5, '4 个瑜伽动作：让你放松身心 轻松好眠', 'http://img.kaiyanapp.com/ee682f799fe0dcaf7b4581b5791ecff6.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=164060&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606831793, 1585981996);
INSERT INTO `video` VALUES (1197, 4, 6, '吉他教学第2期-右手拨弦小技巧', 'http://img.kaiyanapp.com/1cc21279287432dd387ad2e168cd54e6.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=147164&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607318006, 1585981996);
INSERT INTO `video` VALUES (1198, 4, 3, '请你喝，蓝天白云茶。', 'http://img.kaiyanapp.com/1bcfdfe08f674db149459c6908401536.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=113004&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332720, 1585981996);
INSERT INTO `video` VALUES (1199, 4, 3, '轻松学会给视频添加转场', 'http://img.kaiyanapp.com/aba2de9a197640296831c6768bb3eb4b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=148330&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1608261263, 1585981996);
INSERT INTO `video` VALUES (1200, 4, 4, '如何导出占内存小的高清视频', 'http://img.kaiyanapp.com/9e87018f195666269d0c250df246933f.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=148333&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606832133, 1585981996);
INSERT INTO `video` VALUES (1201, 4, 3, 'pr的视频调色与导出', 'http://img.kaiyanapp.com/073d4a17bf3b6d4ba90af9716b12ab0e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=148317&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607323998, 1585981996);
INSERT INTO `video` VALUES (1202, 4, 3, '水煮肉片最正宗做法，鲜嫩过瘾，好吃还下饭', 'http://img.kaiyanapp.com/d4ad3abbe622df7fdd32508db5b7087b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=112972&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606708254, 1585981996);
INSERT INTO `video` VALUES (1203, 4, 6, '信不信？这道红烧羊肉煲，香气飘了一千公里', 'http://img.kaiyanapp.com/3232258ec4fa4a542726d60749f06f63.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=151279&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833101, 1585981996);
INSERT INTO `video` VALUES (1204, 4, 7, '在青岛吃了这么多美食，这种烤肉你见过吗？', 'http://img.kaiyanapp.com/b0f117f4763da98c8a3e220d49e0849c.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=135417&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1205, 4, 2, '煎蛋新方法，好看好吃像披萨！', 'http://img.kaiyanapp.com/779430a82b29eaad798f5be8750e62e0.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=150407&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1608298858, 1585981996);
INSERT INTO `video` VALUES (1206, 4, 7, '【徐妈妈厨房】红烧玉秃', 'http://img.kaiyanapp.com/4ac92bcaaf3a559e4d8df2feeace3f7b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=131567&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332800, 1585981996);
INSERT INTO `video` VALUES (1207, 4, 6, '2分钟学会孜然羊肉正宗做法，新疆风味！', 'http://img.kaiyanapp.com/9c90b27170d4b00bdc42910eed59099b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=143152&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1208, 4, 1, '炖羊肉这样做，才是吃出了羊肉的精华', 'http://img.kaiyanapp.com/f11d2fb34042ce0363cf0ba0a5bf2c63.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=151416&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332756, 1585981996);
INSERT INTO `video` VALUES (1209, 4, 1, '如何制作世界上最好吃的马铃薯沙拉', 'http://img.kaiyanapp.com/944dde5883d82619ad13a9a49b59b767.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=158075&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 13, 0, 0, '', 2, 1607167959, 1585981996);
INSERT INTO `video` VALUES (1210, 4, 4, '法式经典吐司，高端大气，好看又好吃', 'http://img.kaiyanapp.com/4f12661afdf3711cbe24bcac2aecbada.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=110457&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833695, 1585981996);
INSERT INTO `video` VALUES (1211, 4, 8, '五花肉新做法，这样吃才过瘾！', 'http://img.kaiyanapp.com/6f793297f664d6948040d11ebfdaf65f.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=150535&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1212, 4, 2, '在他的“共享经济王国”里，一切都刚刚好', 'http://img.kaiyanapp.com/0769bfeb188388eb503dffddcc4f184e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=147433&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 1, 0, 0, 0, '', 2, 1607165373, 1585981996);
INSERT INTO `video` VALUES (1213, 4, 2, '房地产数据专家：房价为什么高？大数据知道', 'http://img.kaiyanapp.com/620171bafed69c595b540d170ca222f5.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=151348&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607953498, 1585981996);
INSERT INTO `video` VALUES (1214, 4, 4, '朱竞翔：负担得起的房子', 'http://img.kaiyanapp.com/03487bd9a09e6707f6d3fcfda93608ff.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139444&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1215, 4, 1, '“花园城市”搬回家，花50W造了座小森林', 'http://img.kaiyanapp.com/ce770ee050f60cd59e55b8bb482a5c5b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=167772&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1216, 4, 7, '他在20楼挖池塘，把家改成空中花园', 'http://img.kaiyanapp.com/3cc8ebe54b12095a0c5ac4e1b4a04986.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=114211&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607953512, 1585981996);
INSERT INTO `video` VALUES (1217, 4, 6, '最省心的装修法：用收纳柜装饰家', 'http://img.kaiyanapp.com/87b74f1561581e1ad73b01ca1e0a7ae4.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=152136&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607090144, 1585981996);
INSERT INTO `video` VALUES (1218, 4, 4, '在荒野里寻找真实，那是击穿一切的力量', 'http://img.kaiyanapp.com/70f629d9f5b4d0c1b849604b79bf8c96.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140191&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606724908, 1585981996);
INSERT INTO `video` VALUES (1219, 4, 5, '何健翔：看不见的城市', 'http://img.kaiyanapp.com/7197588e173208602a407b896a30b130.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=154761&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607955097, 1585981996);
INSERT INTO `video` VALUES (1220, 4, 2, '青山周平: 房子不等于「家」', 'http://img.kaiyanapp.com/7cf25417efefb752345631b3082a27b1.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140476&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 1, 0, 0, '', 2, 1607332757, 1585981996);
INSERT INTO `video` VALUES (1221, 4, 8, '马岩松：建筑不是资本的纪念碑', 'http://img.kaiyanapp.com/032683f8e73fbef1da454f47f271c605.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=143744&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1222, 4, 6, '表观遗传学：为什么遗传比我们想象的更强大', 'http://img.kaiyanapp.com/8379b51e6d01b47d896b1e7d497f949c.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=148508&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1223, 4, 4, '谁是苏格拉底？', 'http://img.kaiyanapp.com/285f37ec06a434afba553ea05e7ae388.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=164328&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606890959, 1585981996);
INSERT INTO `video` VALUES (1224, 4, 4, '心理治疗是怎样帮你清除负面情绪的？', 'http://img.kaiyanapp.com/41e143deb7afef5096cf4b4bcb0034e2.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=143049&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332816, 1585981996);
INSERT INTO `video` VALUES (1225, 4, 8, '如何科学地分析你的口水？', 'http://img.kaiyanapp.com/bedda6edeaacee8250b9761de6795d63.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=163550&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606826878, 1585981996);
INSERT INTO `video` VALUES (1226, 4, 2, '为什么泰坦尼克号不会自己浮出水面？', 'http://img.kaiyanapp.com/16eec7c8f5cf8ed70a5a65f1dbb95aed.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138566&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833103, 1585981996);
INSERT INTO `video` VALUES (1227, 4, 7, '一秒治好社恐：朋友的必要性', 'http://img.kaiyanapp.com/1bbba200e3f68040763c2c59d5bfd82a.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=128972&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607324130, 1585981996);
INSERT INTO `video` VALUES (1228, 4, 5, '你所恐惧的，终将使你充满力量', 'http://img.kaiyanapp.com/232ebffaa6daa398d97395eedb441c8e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=112677&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607318248, 1585981996);
INSERT INTO `video` VALUES (1229, 4, 3, '“中国草”的文明之旅，带你感受技艺的温度', 'http://img.kaiyanapp.com/09ab17008bf3bdd40b70a645bb88eed7.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=131948&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606719398, 1585981996);
INSERT INTO `video` VALUES (1230, 4, 8, '假面骑士始祖作，出没于黑暗的《骷髅人》', 'http://img.kaiyanapp.com/081f31eff9e97418c6b09c38ce8f34a5.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=170634&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833757, 1585981996);
INSERT INTO `video` VALUES (1231, 4, 1, '让食物更美味的细菌', 'http://img.kaiyanapp.com/9b6fe59d8784ed6d3bbf8d68526e7158.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140052&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606393826, 1585981996);
INSERT INTO `video` VALUES (1232, 4, 8, '维多利亚贝克汉姆 | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/1e5c69d0f51901ef85c4b9946748404e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=141263&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1233, 4, 2, '2018 维密现场：The Struts「Body Talks」', 'http://img.kaiyanapp.com/681d6cc6e07a1680b25c464f5880f1fd.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140733&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607168215, 1585981996);
INSERT INTO `video` VALUES (1234, 4, 3, '2018 维密现场：Leela James「This Is Me」', 'http://img.kaiyanapp.com/32f2c7d9eb248c6c650a2dd2bef3422d.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140736&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1235, 4, 7, '2019香港维多利亚港跨年烟火秀', 'http://img.kaiyanapp.com/493600c6498d47a90c753374da06298d.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=146460&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607074870, 1585981996);
INSERT INTO `video` VALUES (1236, 4, 3, '2018 维密现场：Shawn Mendes「Lost In Japan」', 'http://img.kaiyanapp.com/62f7dcaa6ecf60713c98f897fadb78ee.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140737&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607125534, 1585981996);
INSERT INTO `video` VALUES (1237, 4, 7, '2018 维密现场：Halsey「Without Me」', 'http://img.kaiyanapp.com/e2a31026b4adfe7a215f981f54a79e3e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140738&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606565723, 1585981996);
INSERT INTO `video` VALUES (1238, 4, 5, '遗憾！这种美食的老手艺，快消失了！', 'http://img.kaiyanapp.com/767a8143849e30d79769b2eed34964ea.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=142986&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1239, 4, 7, '性感内衣的兴与衰：为什么 2019 维密秀被取消', 'http://img.kaiyanapp.com/4f190b909adfb9ed575daf982983162e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=149802&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1240, 4, 2, '耗资千万！香港2019烟火秀震撼维港夜空', 'http://img.kaiyanapp.com/a35d7285607371b52f688edfb603df1b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=148072&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607332572, 1585981996);
INSERT INTO `video` VALUES (1241, 4, 3, '蕾哈娜教你做人系列：惊艳维密现场', 'http://img.kaiyanapp.com/926c1e7de980c371739a504015ab069c.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=150336&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833540, 1585981996);
INSERT INTO `video` VALUES (1242, 4, 8, '水果巧克力起司蛋糕', 'http://img.kaiyanapp.com/70bb6562820fb53d798910e461723bef.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=146919&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606566095, 1585981996);
INSERT INTO `video` VALUES (1243, 4, 4, '南瓜料理之起司蛋糕块', 'http://img.kaiyanapp.com/3242f1f52d5c4b4be7d31cdd1b3524ca.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138727&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608261236, 1585981996);
INSERT INTO `video` VALUES (1244, 4, 6, '奥利奥蓝莓起司蛋糕', 'http://img.kaiyanapp.com/5b5b3575da0c0c62bca441058cd07da8.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139320&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606582660, 1585981996);
INSERT INTO `video` VALUES (1245, 4, 1, '十全菜谱：如何制作南瓜口味的芝士杯子小蛋糕', 'http://img.kaiyanapp.com/60e99895315575513c4d31bd77d22b9c.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=133392&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1606707726, 1585981996);
INSERT INTO `video` VALUES (1246, 4, 8, '抹茶渐变起司蛋糕', 'http://img.kaiyanapp.com/ab7f21651dd6a43cc5363615a6f69e62.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=129196&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607158630, 1585981996);
INSERT INTO `video` VALUES (1247, 4, 5, 'kimi 厨房：水果瓶装蛋糕', 'http://img.kaiyanapp.com/9e8295653b61a3586fe4eb328fcb969b.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=110468&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 1, 0, 0, 0, '', 2, 1606833545, 1585981996);
INSERT INTO `video` VALUES (1248, 4, 2, '林间厨房之香浓芝士猪排堡', 'http://img.kaiyanapp.com/09e4222b28c8af57072d77db05f6f97f.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=137364&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607318699, 1585981996);
INSERT INTO `video` VALUES (1249, 4, 4, '好吃又美味的简易通心粉做法', 'http://img.kaiyanapp.com/8a5bd1de0e6c4a38b7ed1849b107be12.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=130213&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1250, 4, 2, 'ASMR 甜品教程：芒果起司蛋糕', 'http://img.kaiyanapp.com/6d792e24f00d52efb6c8374bf096f1f6.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136776&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1608178469, 1585981996);
INSERT INTO `video` VALUES (1251, 4, 6, '无需烘焙的甜点：无麸质芝士蛋糕', 'http://img.kaiyanapp.com/da80465a113990e4d8714811833a898a.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=116457&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607953954, 1585981996);
INSERT INTO `video` VALUES (1252, 4, 8, '保时捷 911 GT3 RS改装案例', 'http://img.kaiyanapp.com/cc54298c5abef2cda430b2c31dea7e10.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138033&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607320060, 1585981996);
INSERT INTO `video` VALUES (1253, 4, 8, '保时捷 911 GT3 陈震一镜到底', 'http://img.kaiyanapp.com/69652adcfd2c2a8a11e7fadb747da39a.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=124122&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607254135, 1585981996);
INSERT INTO `video` VALUES (1254, 4, 5, '雪中漂移，他和保时捷一起滑雪！', 'http://img.kaiyanapp.com/850f826363c3e73c6a19145ddcfdbbae.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=124866&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606718346, 1585981996);
INSERT INTO `video` VALUES (1255, 4, 2, '极限竞速GTR雨天比赛直播', 'http://img.kaiyanapp.com/f3c34e5903bf8e6f0110b77bbb44d1a8.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=146508&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606726377, 1585981996);
INSERT INTO `video` VALUES (1256, 4, 5, '疯狂的摩托车，上帝见了都要开启吐槽模式', 'http://img.kaiyanapp.com/c260c452d2366629a94ee57ae686437d.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=127423&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608458709, 1585981996);
INSERT INTO `video` VALUES (1257, 4, 5, '对标保时捷，「终极」版捷豹只卖 300 辆', 'http://img.kaiyanapp.com/fa3b8a2ba70998996aa45a071273ae84.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=128266&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 1, 0, 0, 0, '', 2, 1606565198, 1585981996);
INSERT INTO `video` VALUES (1258, 4, 8, '赛道利器911GT3能否俘获贩子的心', 'http://img.kaiyanapp.com/bb34d67763590d06beadd503872bd8e0.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=171352&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1259, 4, 1, '奔驰在曼谷的不眠街头 | 保时捷 919', 'http://img.kaiyanapp.com/69791fc40ba6228a0e230fcb3eabb41a.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=123180&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1260, 4, 7, '2018CHINAGT上海站R7R8', 'http://img.kaiyanapp.com/f21ba93fa0a2405b995c0fbc81c7da84.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=126827&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1261, 4, 1, '椰子700发售前开箱！这配色！这鞋型..', 'http://img.kaiyanapp.com/1b917b8ea70fd2c8ad183e2d07af4561.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=127126&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1262, 4, 6, '拒绝无聊人生「如此疯狂的心」中文预告', 'http://img.kaiyanapp.com/4c786537426eee292d3a5a14f6c786b9.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=120718&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607317964, 1585981996);
INSERT INTO `video` VALUES (1263, 4, 5, '卡梅隆监制！「阿丽塔：战斗天使」预告', 'http://img.kaiyanapp.com/e0334d158447e93e2dfaae71e18a4205.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=137117&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1264, 4, 6, '山田孝之：「客人的笑臉」篇', 'http://img.kaiyanapp.com/7f438227f9590c0f6ae6f1724401e701.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=128599&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833698, 1585981996);
INSERT INTO `video` VALUES (1265, 4, 4, '日本游记：濑户内海', 'http://img.kaiyanapp.com/35153adfb1e77315d6bb4ed7c17e16b5.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=120569&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607319025, 1585981996);
INSERT INTO `video` VALUES (1266, 4, 3, '剪辑/燃向/踩点/转场/鬼畜带着节奏海王', 'http://img.kaiyanapp.com/ffc1f0fd787b3e123cebf77d8fc8baa1.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=154810&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607325471, 1585981996);
INSERT INTO `video` VALUES (1267, 4, 5, '海王来了！杰森·莫玛中国行 Vlog', 'http://img.kaiyanapp.com/0f58860bbdd4d35438cfd2c90828f50c.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139519&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606709986, 1585981996);
INSERT INTO `video` VALUES (1268, 4, 5, '亚洲第一禁欲系酒店，地下挖洞穴供客人裸泳', 'http://img.kaiyanapp.com/87ed9f659535e1e68c6f788cfc2ba6e5.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=163044&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1269, 4, 4, '女骗徒在线敲诈：安妮·海瑟薇「偷心女盗」预告', 'http://img.kaiyanapp.com/d066a9c7241ca8f84cb532e4e056ce54.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=149897&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833120, 1585981996);
INSERT INTO `video` VALUES (1270, 4, 6, '禁书改编！「在黑暗中说的鬼故事」电影预告', 'http://img.kaiyanapp.com/7da4c488a10fa7d1e6532464ce4cea5b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=155855&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608563504, 1585981996);
INSERT INTO `video` VALUES (1271, 4, 3, '是女优，也是作家', 'http://img.kaiyanapp.com/70b57d40ab03bafa380af2ce62866a2a.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=129191&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607323421, 1585981996);
INSERT INTO `video` VALUES (1272, 4, 1, '环境反思动画：拯救刺猬 Harry', 'http://img.kaiyanapp.com/ffd8356390d5eb73e248327b2797b7be.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=137052&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1273, 4, 2, '萌趣动画：吃翔吧，猎人！', 'http://img.kaiyanapp.com/fa74fba90376a4ebb68b277c3b585a8f.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=145110&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606826805, 1585981996);
INSERT INTO `video` VALUES (1274, 4, 6, '意识流短片：猎杀科技', 'http://img.kaiyanapp.com/a01a911cbaafb44eb0621de87b438de9.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=161414&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606719902, 1585981996);
INSERT INTO `video` VALUES (1275, 4, 5, '柏林电影节入围短片：火山岛', 'http://img.kaiyanapp.com/379bfddf5a68ab6f910105805d42e0c2.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=153332&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607312886, 1585981996);
INSERT INTO `video` VALUES (1276, 4, 7, '血色森林：愿猎人的枪声不要打扰自然的生灵', 'http://img.kaiyanapp.com/565b3fc196e5865a2185c344cf2155b4.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=135178&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607318354, 1585981996);
INSERT INTO `video` VALUES (1277, 4, 4, '多人 FPS 游戏「猎杀：对决」预告片', 'http://img.kaiyanapp.com/39b85305d8abbce556abc8a2b9be86f5.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=123027&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607276963, 1585981996);
INSERT INTO `video` VALUES (1278, 4, 2, '狩猎爱好者的天堂：200 英亩豪华狩猎庄园', 'http://img.kaiyanapp.com/2501575b4e929ae8f2368c64d2300f38.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=117342&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607319280, 1585981996);
INSERT INTO `video` VALUES (1279, 4, 5, '杨晓洋：水果猎人', 'http://img.kaiyanapp.com/2205e351f2dcd29e19d006a78b115f5e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=151702&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1280, 4, 8, '韩国公益广告：无家可归的黑狗', 'http://img.kaiyanapp.com/9c242b29cf314c3b1cc151a90798f83e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=128738&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1281, 4, 4, '萌出血：用迷你「奶瓶」给小松鼠喂奶', 'http://img.kaiyanapp.com/fb33b719b6b45a695d40fe56ce4b4b68.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=122296&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606823366, 1585981996);
INSERT INTO `video` VALUES (1282, 4, 7, '一句话选车指南（一）：豪华品牌怎么选？', 'http://img.kaiyanapp.com/2d900b2c4f18664957685415928b1571.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138476&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332538, 1585981996);
INSERT INTO `video` VALUES (1283, 4, 8, '一句话选车指南（三）：国产品牌怎么选？', 'http://img.kaiyanapp.com/7a5d438b5d7e7721fab3db05fb6c1db1.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138737&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1284, 4, 3, '玩自吸的Jeep 1.3T也这么溜', 'http://img.kaiyanapp.com/12853028c4657765bcaeb7e510e0398c.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=158205&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606725509, 1585981996);
INSERT INTO `video` VALUES (1285, 4, 3, '大疆硬核刚Gopro运动相机', 'http://img.kaiyanapp.com/77bd892b77fb6e763f04e91d40b47e96.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=160762&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607325648, 1585981996);
INSERT INTO `video` VALUES (1286, 4, 7, '你以为有台超跑很拉风？', 'http://img.kaiyanapp.com/c67979c05bdfe8147e6804cf1493a133.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=110099&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1287, 4, 4, '趣味测试：哪个是真的？ 肉桂卷绘图挑战！', 'http://img.kaiyanapp.com/d8c3b39c353392f9f7015d661e75fd7d.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=115236&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606401815, 1585981996);
INSERT INTO `video` VALUES (1288, 4, 4, '趣味测试：哪一个是真实的？香蕉画挑战！', 'http://img.kaiyanapp.com/1434e9dffa3f21e8dc8b16d814a5b064.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=115237&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1289, 4, 8, '趣味测试：哪一个是真实的？红辣椒画挑战！', 'http://img.kaiyanapp.com/53344db226cf557674f8cdc9af2d9a02.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=116543&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606726143, 1585981996);
INSERT INTO `video` VALUES (1290, 4, 6, '50 个真相打破你关于澳洲的一切刻板认知', 'http://img.kaiyanapp.com/d2e10c5a77ae3ba05287911be2e3c04d.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=166862&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606830045, 1585981996);
INSERT INTO `video` VALUES (1291, 4, 1, '10万块钱的合资车和自主车，到底差在哪？', 'http://img.kaiyanapp.com/7e629c4c51a06971bc13b690ee20cb7a.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138903&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606566765, 1585981996);
INSERT INTO `video` VALUES (1292, 4, 1, '范大将军怒批阿根廷，再这样就该输汤加了！', 'http://img.kaiyanapp.com/26fd16a9da2406a962895990a6aa8de5.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=164516&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606725683, 1585981996);
INSERT INTO `video` VALUES (1293, 4, 3, '大将军郭：为什么女性更容易焦虑？', 'http://img.kaiyanapp.com/c59cd96c763924ee1ffcd7d5610ad671.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=170364&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1294, 4, 6, 'C罗回归梦剧场，尤文后防大将实力抢戏', 'http://img.kaiyanapp.com/239d39cf6aa6ef7299f4dd0cc0a0b16c.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=134018&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607332796, 1585981996);
INSERT INTO `video` VALUES (1295, 4, 3, '爆笑解毒国足vs菲律宾，里皮回归开门红！', 'http://img.kaiyanapp.com/9dd152caaf56864f7c76a71fcf7f0361.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=163059&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1606996744, 1585981996);
INSERT INTO `video` VALUES (1296, 4, 4, '精灵小仙女闯荡江湖，女扮男装围剿山贼', 'http://img.kaiyanapp.com/9f31028f4e275deef5a65407284c95ba.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=111799&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 1, 0, 0, '', 2, 1607259287, 1585981996);
INSERT INTO `video` VALUES (1297, 4, 8, '爆笑解毒国足大战吉尔吉斯斯坦', 'http://img.kaiyanapp.com/4e1c039745d96d7dfb991f5f95e2bc06.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=145804&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608458612, 1585981996);
INSERT INTO `video` VALUES (1298, 4, 5, '德国队惊现防守大将，最强之人已在阵中？', 'http://img.kaiyanapp.com/500d5c01e9deff5aacb5e1de9771752f.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=164538&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607159277, 1585981996);
INSERT INTO `video` VALUES (1299, 4, 8, '孙兴慜兮进球绝杀，国足球迷你酸了吗？', 'http://img.kaiyanapp.com/a742793650035675f86ad9fd09ebb384.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=156810&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606724596, 1585981996);
INSERT INTO `video` VALUES (1300, 4, 5, '北京老外图鉴——苏丹人的国足梦', 'http://img.kaiyanapp.com/87c0fe7441fb69bbd6168431a44d79b1.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=130119&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 2, 0, 0, '', 2, 1607163716, 1585981996);
INSERT INTO `video` VALUES (1301, 4, 8, '「Take That Shit Off」舞蹈教程', 'http://img.kaiyanapp.com/b3fdbb9914ba62245a41b6b216788a97.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=110390&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606725796, 1585981996);
INSERT INTO `video` VALUES (1302, 4, 6, '「爱·拆」OPPO R17 Pro拆解', 'http://img.kaiyanapp.com/9cea1602e969ec3917469f542d409ce2.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=142189&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607930961, 1585981996);
INSERT INTO `video` VALUES (1303, 4, 4, 'OPPO K3开箱上手：巴萨感觉的配色', 'http://img.kaiyanapp.com/c43bf5131ca538c7b6b9ffff6d7c2503.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=161132&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606708369, 1585981996);
INSERT INTO `video` VALUES (1304, 4, 6, '开眼 x OPPO 欧洲艺术巡游', 'http://img.kaiyanapp.com/d515e8d51412e4772bd384908e9d4aae.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=165180&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833072, 1585981996);
INSERT INTO `video` VALUES (1305, 4, 8, '华为nova5 Pro星耀限定礼盒开箱', 'http://img.kaiyanapp.com/0b2a7de5d1d8df96520004958ea07052.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=164582&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607250687, 1585981996);
INSERT INTO `video` VALUES (1306, 4, 6, 'OPPO K1开箱：性价比千元机？', 'http://img.kaiyanapp.com/27d485d83fd2c6b4bca4f57c0c068796.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=133434&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1307, 4, 2, '「爱·拆」Reno 10倍变焦版拆解', 'http://img.kaiyanapp.com/1ad5d2a34b235eaf145271203a68dc54.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=157102&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607164009, 1585981996);
INSERT INTO `video` VALUES (1308, 4, 1, '宝马 R 1250 系列新车初体验', 'http://img.kaiyanapp.com/0541c7dd96df990048cf6e850dd9d0b3.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=168853&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1309, 4, 7, '领先30年的强大安全技术是真是假？', 'http://img.kaiyanapp.com/8a467fa544075f35db2a65e3fc5b921e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=158313&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833096, 1585981996);
INSERT INTO `video` VALUES (1310, 4, 2, 'Reno手机10倍变焦版体验', 'http://img.kaiyanapp.com/3139f15952bf3fee4807b94309d12b49.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=156813&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607320059, 1585981996);
INSERT INTO `video` VALUES (1311, 4, 3, '《星战》里的R2-D2机器人走进现实啦！', 'http://img.kaiyanapp.com/739b7cfe73d25ef15db43290d4d72e18.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=144020&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608460593, 1585981996);
INSERT INTO `video` VALUES (1312, 4, 7, '《G星情报局》PCPI中国区预选赛集锦', 'http://img.kaiyanapp.com/69f6c59efd1383529e3e4120f27dfd9d.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138256&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1606979145, 1585981996);
INSERT INTO `video` VALUES (1313, 4, 1, '千千小伙伴们DIY日做寿司', 'http://img.kaiyanapp.com/5984c5340ea47ab08431f340401e67c0.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=134265&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332728, 1585981996);
INSERT INTO `video` VALUES (1314, 4, 7, '冲浪锦标赛最后一天', 'http://img.kaiyanapp.com/8f550663d9e5fc7df57dbd3eaf35fd50.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=144568&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607318556, 1585981996);
INSERT INTO `video` VALUES (1315, 4, 4, '这个视频重点是：万圣节“快乐”', 'http://img.kaiyanapp.com/c143f76227cf2388349fd8018c83027e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=135109&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607325646, 1585981996);
INSERT INTO `video` VALUES (1316, 4, 7, '七步料理：韩式煎饼', 'http://img.kaiyanapp.com/dbfa7c68db73ea37fbdc5911725be07e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=130164&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1317, 4, 3, '驾车出行槽点多？他们用脑洞挑战出行难题', 'http://img.kaiyanapp.com/117685905223879e31f305af70613413.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=166277&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608261239, 1585981996);
INSERT INTO `video` VALUES (1318, 4, 8, '第39个粉丝愿望：唱遍巴黎', 'http://img.kaiyanapp.com/db84ebfe9f2c95585c09c96a44bd9180.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=110091&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607320047, 1585981996);
INSERT INTO `video` VALUES (1319, 4, 1, '豆豉瓦片加小鱼，一个你想不到的真香组合！', 'http://img.kaiyanapp.com/095edffd05fa3b4ef19ddd5b426031c4.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136369&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607153925, 1585981996);
INSERT INTO `video` VALUES (1320, 4, 3, '多雷：我就是“别人家的孩子”', 'http://img.kaiyanapp.com/caec77fedfd4ded4ff368692b145fb62.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=147308&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 1, 0, 0, '', 2, 1607164539, 1585981996);
INSERT INTO `video` VALUES (1321, 4, 5, '沙漠中的火人节#2 — 沙尘暴来袭', 'http://img.kaiyanapp.com/df578711e146eb9ca8285c31d1ef006d.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=127641&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1322, 4, 6, '香港这么美，请不要让她流下眼泪', 'http://img.kaiyanapp.com/a2992db7babd5d7a3305de7999e55727.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=169063&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1323, 4, 2, '斯里兰卡冲浪之旅', 'http://img.kaiyanapp.com/91bd19ff2c8005310eb3cb03581215e1.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=145284&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606828889, 1585981996);
INSERT INTO `video` VALUES (1324, 4, 2, '民宿中国行贵州万峰林里最美的十大民宿推荐', 'http://img.kaiyanapp.com/8a3b95bc43d3b640319e2324e4abe37c.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=171551&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607149681, 1585981996);
INSERT INTO `video` VALUES (1325, 4, 2, '暑假旅行攻略：在韩国千万不要做的 11 件事', 'http://img.kaiyanapp.com/228dc3a090248fef286ec21ba69dd153.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=165597&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607953909, 1585981996);
INSERT INTO `video` VALUES (1326, 4, 4, '在班夫滑春雪', 'http://img.kaiyanapp.com/e54c68bf3550423ec214f695cf791ce6.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=159064&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607325469, 1585981996);
INSERT INTO `video` VALUES (1327, 4, 7, '暑假旅行攻略：去日本前必须知道的 10 件事', 'http://img.kaiyanapp.com/2917e26dc8aa92833aba81a1652f3810.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=165582&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606565366, 1585981996);
INSERT INTO `video` VALUES (1328, 4, 4, '4 分钟游泰国，领略暹罗的人文和美景', 'http://img.kaiyanapp.com/50ecc8907f11dc5735b077e6ec1b4dc9.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=124601&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1329, 4, 4, '这样的假期我也想要，情侣同游巴厘岛', 'http://img.kaiyanapp.com/31adcd15945dc160bd50da2d1f15135e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=133955&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1330, 4, 6, '「火人节」全世界艺术家放飞自我的天堂', 'http://img.kaiyanapp.com/a7c8c9d35c70f9ba9cba874abf2373ae.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=171121&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1331, 4, 8, '世界十大旅行必去城市，你去过几个？', 'http://img.kaiyanapp.com/a6ac9f48b6b2e39d6a7db2a46df74b8e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=126129&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1332, 4, 2, 'R&B 新人 Khalid「Better」MV', 'http://img.kaiyanapp.com/9e503bf9aa178d6efa59f2dd0043e822.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136721&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606726615, 1585981996);
INSERT INTO `video` VALUES (1333, 4, 6, 'A 妹根据亲身经历创作歌曲「breathin」MV', 'http://img.kaiyanapp.com/f4e75409a5989493fd7ca806d0ae8e1c.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136144&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1334, 4, 2, '西语版舞女泪「BAGDAD」MV', 'http://img.kaiyanapp.com/ef8185d2de500f4474b85f933b4ccf08.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=141679&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606709128, 1585981996);
INSERT INTO `video` VALUES (1335, 4, 6, '洁匪新曲「Baby」不插电版 MV', 'http://img.kaiyanapp.com/a19bd9980409ea033c1fee985ea64416.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138138&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606725686, 1585981996);
INSERT INTO `video` VALUES (1336, 4, 8, '完美对你来说是什么？「Perfect To Me」MV', 'http://img.kaiyanapp.com/4650b791b570315e3e8197a618216978.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136319&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1337, 4, 2, 'Jay Rock & Tee Grizzley「Shit Real」MV', 'http://img.kaiyanapp.com/cecee2b3940275930190078fc4b87ba0.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140565&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1608522676, 1585981996);
INSERT INTO `video` VALUES (1338, 4, 7, '前五美成员 Dinah Jane 个人首单「Bottled Up」MV', 'http://img.kaiyanapp.com/786f2248cd593f3f1ba9b4ed7a08611c.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136211&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1339, 4, 4, '拉美天后 Shakira「Nada」MV', 'http://img.kaiyanapp.com/3ea56ef13ca33227f7f18718dbb85cc1.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136722&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606396104, 1585981996);
INSERT INTO `video` VALUES (1340, 4, 6, '数一数，Maluma 的床上睡了多少女人？', 'http://img.kaiyanapp.com/5c124c6b79aaaf0a8206f695096390cb.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=121468&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1341, 4, 6, 'Kiiara 绚丽的彩衣「Gloe」MV', 'http://img.kaiyanapp.com/e3c9890f8371bac22ff0a3f461bb814c.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=124110&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607150082, 1585981996);
INSERT INTO `video` VALUES (1342, 4, 7, '广东最“低调”的景点：山水秀丽堪比桂林', 'http://img.kaiyanapp.com/70b449c38a82012f0663502aae159364.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=112849&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 4, 1, 0, 0, 0, '', 2, 1607332667, 1585981996);
INSERT INTO `video` VALUES (1343, 4, 1, '黄山大观', 'http://img.kaiyanapp.com/bb8d47c3461f6a5c5649ffbc75ffefd4.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=168558&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1344, 4, 2, '南澳杨梅坑之旅-深圳最东端的度假胜地', 'http://img.kaiyanapp.com/665ffb3dfe97025e9287fd7cabfb03f2.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=111880&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607159454, 1585981996);
INSERT INTO `video` VALUES (1345, 4, 3, '黄山不一样', 'http://img.kaiyanapp.com/d8b4f78c3fc16d512940b3bbeb05a97d.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=163017&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607325937, 1585981996);
INSERT INTO `video` VALUES (1346, 4, 8, '黄山', 'http://img.kaiyanapp.com/c6faf06ae52a434d7a05080e023bada2.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=141725&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607312880, 1585981996);
INSERT INTO `video` VALUES (1347, 4, 2, '贝多芬：音乐大师也是数学天才', 'http://img.kaiyanapp.com/76b920242f13b7f99d2d93a4218aa943.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=142132&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607276822, 1585981996);
INSERT INTO `video` VALUES (1348, 4, 3, '黄山｜冬雪', 'http://img.kaiyanapp.com/f7fee5d467eb96cce9ec6759d61a2e31.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=145100&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607324166, 1585981996);
INSERT INTO `video` VALUES (1349, 4, 2, '带你体验下值两辆法拉利的奔驰SLR！', 'http://img.kaiyanapp.com/7fd5fb166dd00e6d40d332fa0305ad15.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=123103&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607160115, 1585981996);
INSERT INTO `video` VALUES (1350, 4, 8, '西北第一村——白哈巴，原始的童话世界！', 'http://img.kaiyanapp.com/3410abd22c7900d28eb2e69beed5945c.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=169876&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1351, 4, 7, '这里被誉为日本最幸福的地方，去什么东京！', 'http://img.kaiyanapp.com/ac34bf4ee180b0bf2762305adcec0bd4.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=163698&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606831661, 1585981996);
INSERT INTO `video` VALUES (1352, 4, 3, '浓香四溢的豆豉麻油鸡，是对吃货的极度诱惑', 'http://img.kaiyanapp.com/f5fed0731fd7b183da03ccf7f1e8a033.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=120597&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1353, 4, 8, '快速煲之火鸡胸肉', 'http://img.kaiyanapp.com/4c5efbf0ed407223407632756ed1846b.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138708&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606725244, 1585981996);
INSERT INTO `video` VALUES (1354, 4, 1, '热情芒果奶油蛋糕', 'http://img.kaiyanapp.com/aa16c44eb14e88874cec0c704edcc0b5.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=141077&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1355, 4, 4, '麦旋风提拉米苏蛋糕', 'http://img.kaiyanapp.com/3aa8be8576dc22aecfd7714c95c5409b.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=141078&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607318632, 1585981996);
INSERT INTO `video` VALUES (1356, 4, 3, '布蕾奶油饼干泡芙', 'http://img.kaiyanapp.com/d6b68c35d725db4d027e4e8b01021155.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=144080&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606829643, 1585981996);
INSERT INTO `video` VALUES (1357, 4, 5, '烘焙芝士风味蛋糕', 'http://img.kaiyanapp.com/a89bef541f834c613593fbeda60ad4bd.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138561&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607160381, 1585981996);
INSERT INTO `video` VALUES (1358, 4, 4, 'ASMR 甜品教程：蜂蜜起司蛋糕', 'http://img.kaiyanapp.com/ba53a8d879e6770ac24e3ea692448a80.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138235&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1359, 4, 8, '肉食控专场！软嫩香酥的猪肉料理合集', 'http://img.kaiyanapp.com/c320b978bc203575f1fb06feb27ed88f.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=153644&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607090734, 1585981996);
INSERT INTO `video` VALUES (1360, 4, 3, '夏日小清新：茶香虾仁', 'http://img.kaiyanapp.com/efa48d150bab26315d0e9e2fe99117e2.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=165016&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1361, 4, 2, '戴吉利适合在餐前的一款开胃酒', 'http://img.kaiyanapp.com/a43aa70761bf78489643fcfb9e665c3f.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=112135&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606718103, 1585981996);
INSERT INTO `video` VALUES (1362, 4, 7, '天津人的家常独面筋，绵香烫口谁吃谁喜欢', 'http://img.kaiyanapp.com/f66043e6401c2de6063efc6a2b6a67e7.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=172659&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1363, 4, 2, '「食语集」零厨艺好味道，虾仁青豆蒸滑蛋', 'http://img.kaiyanapp.com/0749bbdbafbace1bc70a467bc20a92c3.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=133142&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1364, 4, 1, '「食语集」鲜鲜滑滑好味道，Q弹虾仁炒滑蛋', 'http://img.kaiyanapp.com/5645e55d67e8cb3cbc2c9c80e71fb23f.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=130231&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1608455518, 1585981996);
INSERT INTO `video` VALUES (1365, 4, 5, '零厨艺，几步就做好的快手家常菜：豉油鸡腿', 'http://img.kaiyanapp.com/557262c5cc27e68addd7b2a1e6f1e4d8.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138877&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607125615, 1585981996);
INSERT INTO `video` VALUES (1366, 4, 2, '《食语集》重庆芋儿鸡，芋儿糯糯鸡肉香！', 'http://img.kaiyanapp.com/abf0fbf3b1d1acafbeb42011d8af94a4.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=127378&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1608458237, 1585981996);
INSERT INTO `video` VALUES (1367, 4, 3, '快手家常菜：豉油口水鸭，不过瘾算我输', 'http://img.kaiyanapp.com/b8741430b1cd0abc28800d03042bc2e9.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139352&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1606999958, 1585981996);
INSERT INTO `video` VALUES (1368, 4, 3, '「食语集」滚滚而来的美味：香煎孜然小土豆', 'http://img.kaiyanapp.com/8343deeceb2129e1f77e882b4ff0837a.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=128401&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332817, 1585981996);
INSERT INTO `video` VALUES (1369, 4, 3, '美美的虾仁蟹黄豆腐，原来一个咸鸭蛋就搞定', 'http://img.kaiyanapp.com/470eddf66c1fb9db8f1c92c68bc0fbcc.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=112395&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607325866, 1585981996);
INSERT INTO `video` VALUES (1370, 4, 5, '吃不到谢霆锋做的菜，我就吃他的锋味月饼！', 'http://img.kaiyanapp.com/30acdfa26366d0c836c70c7c0652763e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=127654&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607276971, 1585981996);
INSERT INTO `video` VALUES (1371, 4, 4, '茄子新吃法，糖酥麻仁茄子，外脆里嫩满口香', 'http://img.kaiyanapp.com/45e76624c22f1ecbc2b33971c09f4fbe.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=133640&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607160377, 1585981996);
INSERT INTO `video` VALUES (1372, 4, 7, '同样是豪宅，女儿奴的家总是那么不一样', 'http://img.kaiyanapp.com/186a974bda998ede76bc58b7a8197040.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=169166&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332589, 1585981996);
INSERT INTO `video` VALUES (1373, 4, 3, '「杀手 6」万圣节礼包预告片', 'http://img.kaiyanapp.com/4cb0d26406c7cbdbe9f2b3cb14e48dfc.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=133355&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 9, 0, 0, 0, 0, '', 2, 1608458637, 1585981996);
INSERT INTO `video` VALUES (1374, 4, 4, '《清新视界第十季》第1期：谷心平', 'http://img.kaiyanapp.com/8f0ef273e7fb0e0fe7904012a3836d85.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=133985&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606718033, 1585981996);
INSERT INTO `video` VALUES (1375, 4, 8, '10 天带你玩转 6 个欧洲国家！', 'http://img.kaiyanapp.com/4a75bbc3096b9a24324fa206e574e8d1.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=148578&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1376, 4, 3, '长泽雅美 KUBOTA「德国拖拉机」篇', 'http://img.kaiyanapp.com/14236fa146cb61c526a7cfa1cfca44ce.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=120580&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1377, 4, 4, '研究出物理界一半公式的科学家居然是社恐！', 'http://img.kaiyanapp.com/f9e172e0d82c628f39b69f3967715fa2.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140299&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606725308, 1585981996);
INSERT INTO `video` VALUES (1378, 4, 1, '【物造东方】全世界最好的家人召唤神器！', 'http://img.kaiyanapp.com/eef6257110c5f65543d1031909e4647f.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=169505&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607153377, 1585981996);
INSERT INTO `video` VALUES (1379, 4, 5, '丹麦反思动画：捕鲸父子的故事', 'http://img.kaiyanapp.com/e2ff287302854bc4f74cd304a63fb748.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=119209&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1380, 4, 6, '《苗岭银饰 响叮当》—— 雷山县银饰  ', 'http://img.kaiyanapp.com/97f111c6a08be4c0fabb809d3f8d1d46.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=128082&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1381, 4, 4, '创意趣味广告：一对好姐妹( • )( • )', 'http://img.kaiyanapp.com/ff3d8b4f36111b51a2e319351926571e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=141773&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833078, 1585981996);
INSERT INTO `video` VALUES (1382, 4, 5, '温柔的忧郁：即便没有光也能照亮你的心', 'http://img.kaiyanapp.com/dc4ce51cd6a9e27cb0316d4d11fc8d22.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=124435&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1383, 4, 8, '青岛印象·雪', 'http://img.kaiyanapp.com/2e6a5acafa2876386ff7e2175c864f41.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=151115&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607322678, 1585981996);
INSERT INTO `video` VALUES (1384, 4, 3, '天冷了，来碗热腾腾的咖喱海鲜炒饭吧！', 'http://img.kaiyanapp.com/35659f2d463f396a3de6b1e5d841c0d9.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=135130&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1385, 4, 5, '没什么秋愁，是一块桂花糕治愈不了的！', 'http://img.kaiyanapp.com/2ff91c01e66c77f91b369a9e305df21b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=172322&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607081263, 1585981996);
INSERT INTO `video` VALUES (1386, 4, 6, '【古法腊肠】冬腊风腌，蓄以御冬', 'http://img.kaiyanapp.com/6ae24177a69a27d67dc23e265a0d4c28.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139807&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606832053, 1585981996);
INSERT INTO `video` VALUES (1387, 4, 7, '男士靴子这样穿才够酷！', 'http://img.kaiyanapp.com/c575883b1fbea2d9020fce434c574e1b.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=146098&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1388, 4, 7, '蒜泥狠！不爱吃五花肉的我，倒戈了', 'http://img.kaiyanapp.com/475bd33f4b5fd3699cc0dfbfec1d9e7d.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136200&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607163249, 1585981996);
INSERT INTO `video` VALUES (1389, 4, 7, '郁闷的下雨天，来一口酸辣粉丝让心情好起来', 'http://img.kaiyanapp.com/d3ec47bf476dd86aac28bef3f0f6e576.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=124961&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607068264, 1585981996);
INSERT INTO `video` VALUES (1390, 4, 3, '荷兰豆荸荠炒香肠，忍不住恋上这味道', 'http://img.kaiyanapp.com/596546c70e0aeda78a40583c8c8fbb6e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=163803&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607073421, 1585981996);
INSERT INTO `video` VALUES (1391, 4, 4, '广州也能吃到极品臭豆腐：下雨生意也火爆！', 'http://img.kaiyanapp.com/e9f7525aa22c72eec52c955c300b079d.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=114783&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1392, 4, 8, '巧克力布丁', 'http://img.kaiyanapp.com/be6dd87ca214e0d66b0c1ad4ceaa98db.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139676&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607084715, 1585981996);
INSERT INTO `video` VALUES (1393, 4, 8, '无需烘焙的甜点：无麸质芝士蛋糕', 'http://img.kaiyanapp.com/da80465a113990e4d8714811833a898a.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=116457&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608181528, 1585981996);
INSERT INTO `video` VALUES (1394, 4, 8, '焦糖布丁的美味之旅', 'http://img.kaiyanapp.com/fbdcd884db3bfb9146acf690ee8f3871.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139968&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 1, 0, 0, 0, '', 2, 1606389999, 1585981996);
INSERT INTO `video` VALUES (1395, 4, 1, '散发着杏仁香气的巧克力夹心薄脆', 'http://img.kaiyanapp.com/8fac2476bf0b922e3bc6183802c5d582.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=116465&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607327576, 1585981996);
INSERT INTO `video` VALUES (1396, 4, 4, 'ASMR 甜品教程：蓝莓奶油芝士蛋挞', 'http://img.kaiyanapp.com/f5f74808db56a079052f8fc463514846.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=116582&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607332716, 1585981996);
INSERT INTO `video` VALUES (1397, 4, 4, '食谱：如何制作南瓜饼', 'http://img.kaiyanapp.com/30e009025c70b51dc4c56bd8f4e41c0c.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=117346&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1608458546, 1585981996);
INSERT INTO `video` VALUES (1398, 4, 6, 'ASMR 甜品教程：焦糖布丁蛋糕', 'http://img.kaiyanapp.com/fadc81ef500b17aaa5dcb56a16bf3c76.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136778&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607318029, 1585981996);
INSERT INTO `video` VALUES (1399, 4, 8, '食谱：如何制作杏仁奶油香蕉吐司', 'http://img.kaiyanapp.com/83641700a485f9a81cce812e8231a9fb.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=117350&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608385213, 1585981996);
INSERT INTO `video` VALUES (1400, 4, 2, '食谱：如何制作爆米花棉花糖蛋糕', 'http://img.kaiyanapp.com/5fc7509c2608e321cbb73796104286f4.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=118341&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607162860, 1585981996);
INSERT INTO `video` VALUES (1401, 4, 2, '少女心满分的凯蒂猫奶酪慕斯蛋糕', 'http://img.kaiyanapp.com/58a1aab2ba17b2807c9ec83d17dbf4cf.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=118936&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1402, 4, 6, '迷幻视觉动画：衍生', 'http://img.kaiyanapp.com/a88051ea8321208bdb818da6a0849c8d.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=114249&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606718774, 1585981996);
INSERT INTO `video` VALUES (1403, 4, 7, '北方人烙大饼，真的很有门道！', 'http://img.kaiyanapp.com/3de748e11693c0371932a8a57b7c7757.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=118624&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1404, 4, 2, '宁静湖畔别墅：舒适度假生活', 'http://img.kaiyanapp.com/5c6e6dd2ff54ad9729bf4d78f4b65781.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=121118&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1405, 4, 4, '说到啪啪啪，多久才算久？', 'http://img.kaiyanapp.com/6e96a95efcaffdb16194e287f296dd9b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=121997&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607319464, 1585981996);
INSERT INTO `video` VALUES (1406, 4, 1, '在太空中啪啪啪是一种什么样的体验？', 'http://img.kaiyanapp.com/06b9200565c4dd09a2dd4d779ee13314.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=122677&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606565133, 1585981996);
INSERT INTO `video` VALUES (1407, 4, 4, '穷游陕西西安，吃到正宗的凉皮小吃！', 'http://img.kaiyanapp.com/7c36d4790ba49769a1fa7358f4e7881f.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=142519&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1408, 4, 2, '14 个关于啪啪啪的酷炫事实', 'http://img.kaiyanapp.com/62a3beb2b17914e512fd51efebe5336e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=145230&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1409, 4, 3, '7 个理由告诉你为什么一定要啪啪啪', 'http://img.kaiyanapp.com/46abf517217f52c1b64f38676e9d3596.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=146161&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606830670, 1585981996);
INSERT INTO `video` VALUES (1410, 4, 4, '「爱，死亡和机器人」第 14 集「知马蓝」', 'http://img.kaiyanapp.com/30c46e290ad7e7b0b2bb22d8f4a801f6.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=154749&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607081050, 1585981996);
INSERT INTO `video` VALUES (1411, 4, 3, '「爱，死亡和机器人」第11集「帮手」', 'http://img.kaiyanapp.com/77662592e4de1e6f143f9f6bb59bff4f.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=155148&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607312870, 1585981996);
INSERT INTO `video` VALUES (1412, 4, 3, '30年前，中国没有人比她更红了', 'http://img.kaiyanapp.com/fa3d8ab6eb656f2e85884c11f656c7b0.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=118032&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606565601, 1585981996);
INSERT INTO `video` VALUES (1413, 4, 4, '她28岁拍下一部禁片，5年后成奥斯卡评委', 'http://img.kaiyanapp.com/0635e36d57cafa70057408db078cc8b2.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=118514&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606988331, 1585981996);
INSERT INTO `video` VALUES (1414, 4, 2, '啪啪啪的时候，你有特别的癖好吗？', 'http://img.kaiyanapp.com/59537fb3478f6987e1f07a91912422ca.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=121761&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607084654, 1585981996);
INSERT INTO `video` VALUES (1415, 4, 5, '视效集锦短片：思维的形状', 'http://img.kaiyanapp.com/382f16a2c400d62fbfa186264809d157.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=125069&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607159477, 1585981996);
INSERT INTO `video` VALUES (1416, 4, 5, '别否认，这就是日常「失控」的你', 'http://img.kaiyanapp.com/ff70db7c34b3d3698e92909e5d8d65e7.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=125620&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606565839, 1585981996);
INSERT INTO `video` VALUES (1417, 4, 2, '关于啪啪啪，你一定不知道的 14 个冷知识', 'http://img.kaiyanapp.com/d3a1e395ddc9da0bea05d4d8b48d6808.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=127968&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833074, 1585981996);
INSERT INTO `video` VALUES (1418, 4, 4, '泰国搞笑广告：媳妇大战婆婆', 'http://img.kaiyanapp.com/f5c641b0808c84b7cc0435d1a5f371f4.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=128508&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 4, 0, 0, 0, 0, '', 2, 1607319466, 1585981996);
INSERT INTO `video` VALUES (1419, 4, 7, '爆笑短片：一个人吃饭如何避免尴尬？', 'http://img.kaiyanapp.com/c772ba5818fd7a54f0bb4b76517d0335.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=131097&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607167394, 1585981996);
INSERT INTO `video` VALUES (1420, 4, 6, '他50岁，不顾妻儿反对，变性为一个女人', 'http://img.kaiyanapp.com/c9acd3b71c3f20484fcf28d731c35248.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=137296&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1608097154, 1585981996);
INSERT INTO `video` VALUES (1421, 4, 2, '搞笑动画：我听不见穷人讲话', 'http://img.kaiyanapp.com/637f193bcd2ff06de82c53cc8d2d6ef0.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=148005&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606395805, 1585981996);
INSERT INTO `video` VALUES (1422, 4, 6, '茄子这样烧，鲜香入味补气血！', 'http://img.kaiyanapp.com/94e4defb221f8450b02c3aeefe6229ac.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=116264&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606718903, 1585981996);
INSERT INTO `video` VALUES (1423, 4, 8, '我想和你好好相处，好像不太可能？', 'http://img.kaiyanapp.com/b6c545d43660065d02900c14dea0eed0.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=121641&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606565655, 1585981996);
INSERT INTO `video` VALUES (1424, 4, 1, '5 分钟了解保时捷 911 全系车型', 'http://img.kaiyanapp.com/0c1556957c66688a384f1df795f324d0.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=134549&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607953920, 1585981996);
INSERT INTO `video` VALUES (1425, 4, 8, '新疆美食-凉皮', 'http://img.kaiyanapp.com/ab8674ff40b09ffee27f1f4564c30a9d.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=134596&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606831163, 1585981996);
INSERT INTO `video` VALUES (1426, 4, 7, '聆听山与水的声音：探索加拿大班夫公园', 'http://img.kaiyanapp.com/61d01c15f5b4e881edbb5e4537d73746.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136121&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607323414, 1585981996);
INSERT INTO `video` VALUES (1427, 4, 1, '创意品牌短片：珠宝的魅力', 'http://img.kaiyanapp.com/bda959b81abfe05d8a0da0c67aea2720.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=137922&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606830029, 1585981996);
INSERT INTO `video` VALUES (1428, 4, 1, '女性亲身解答，钱赚得越多就越不焦虑吗？', 'http://img.kaiyanapp.com/0c3b2b85ec1f53f2902fc6833087dc31.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=141177&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1429, 4, 8, '穷游西安街头：一碗羊杂汤，一份爽口凉皮', 'http://img.kaiyanapp.com/a6823c8620456d905ded42a97005bcf9.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=143512&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606725773, 1585981996);
INSERT INTO `video` VALUES (1430, 4, 5, '青海羊肉串不坑人：9毛9一串！', 'http://img.kaiyanapp.com/06c639f96e76aaa15051438b6074d009.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=146386&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607953503, 1585981996);
INSERT INTO `video` VALUES (1431, 4, 4, '「爱，死亡和机器人」第 10 集「易形」', 'http://img.kaiyanapp.com/ab35a16cbd4a51d5f1279b897383213f.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=154748&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607325340, 1585981996);
INSERT INTO `video` VALUES (1432, 4, 4, '奥比都斯：国王送给王后的礼物成了结婚圣地', 'http://img.kaiyanapp.com/0e6d9c9ad06e432f053bd6e595df44f8.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=117375&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606831215, 1585981996);
INSERT INTO `video` VALUES (1433, 4, 3, '教师节，我们每人给老师做一朵可以吃的玫瑰', 'http://img.kaiyanapp.com/04870deb18b59cec4ba7ce38fef7b2be.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=126307&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1434, 4, 4, '76岁奶奶用8年亲手为自己造房', 'http://img.kaiyanapp.com/96cc521b7bdca760e193d128143f9489.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=148604&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833542, 1585981996);
INSERT INTO `video` VALUES (1435, 4, 5, '镂空的艺术，两个10年的守候！', 'http://img.kaiyanapp.com/2ec4746090e9b615197326c897de77df.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=125866&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607166349, 1585981996);
INSERT INTO `video` VALUES (1436, 4, 3, '恐怖经典翻拍！新版「鬼娃回魂」预告', 'http://img.kaiyanapp.com/f6e35003e7d57fcd3bd13ad8a3a8b2d6.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=157894&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607276820, 1585981996);
INSERT INTO `video` VALUES (1437, 4, 5, '他卖掉别墅住进山洞，引爆争议', 'http://img.kaiyanapp.com/972ee6f5120453b625735aec98d40441.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=141011&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606396273, 1585981996);
INSERT INTO `video` VALUES (1438, 4, 2, 'AR日历了解一下，让你和健忘症说拜拜', 'http://img.kaiyanapp.com/3c8c774529d12dcb38c2d37b98c47d3b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=113900&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607321030, 1585981996);
INSERT INTO `video` VALUES (1439, 4, 7, '养颜早餐香椿千层饼，错过还要等一年！', 'http://img.kaiyanapp.com/189ee205e6e0531e1ad5d1ce6762abb4.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=156189&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607168557, 1585981996);
INSERT INTO `video` VALUES (1440, 4, 6, '16岁少年捐器官救7人，组成一个人篮球队', 'http://img.kaiyanapp.com/34d8752c11fb9abca860c9d05930a521.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=152850&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833612, 1585981996);
INSERT INTO `video` VALUES (1441, 4, 4, '一个数学老师，造了栋土房子，打败日本大师', 'http://img.kaiyanapp.com/3a17dd30794a59e0989fb4b2930d8294.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=134367&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606390777, 1585981996);
INSERT INTO `video` VALUES (1442, 4, 7, '第29集：中国凭什么成为AI大国？', 'http://img.kaiyanapp.com/d0c01f4bffcf98d0da8b1da8dc0962d9.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139396&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 1, 0, 0, '', 2, 1607332848, 1585981996);
INSERT INTO `video` VALUES (1443, 4, 8, '【第7集】AI翻身做主人，为什么不可能？', 'http://img.kaiyanapp.com/13f3b0c367c5f1126578f524accad48d.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=129368&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607158872, 1585981996);
INSERT INTO `video` VALUES (1444, 4, 6, '第36集：AI面前，人人赤裸？', 'http://img.kaiyanapp.com/b8762414c860788f536044e2a2c4b6e4.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=142021&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607325655, 1585981996);
INSERT INTO `video` VALUES (1445, 4, 5, '第27集：有AI，再无人买车？', 'http://img.kaiyanapp.com/2ed04ccc80e646ec4635ad7ef80deb9b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140282&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607090131, 1585981996);
INSERT INTO `video` VALUES (1446, 4, 6, '第31集：AI七大“列强”将瓜分世界？', 'http://img.kaiyanapp.com/d4fe3b8fcf8f1840b3eb2cceb38f1de0.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140257&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833104, 1585981996);
INSERT INTO `video` VALUES (1447, 4, 2, '中国的AI成功的秘诀，美国也得服！', 'http://img.kaiyanapp.com/314cfbbbddef87b47974b502cab2fc8a.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140288&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1448, 4, 2, '第27集：AI是最完美的员工？', 'http://img.kaiyanapp.com/7f0dab9eaf0bed6ac61e1ab97345e6ad.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138486&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607164785, 1585981996);
INSERT INTO `video` VALUES (1449, 4, 3, '第13集：AI工程师，未来最稳妥的职业？', 'http://img.kaiyanapp.com/6c84cd5ccdd3857fc36d645aa9fe62f4.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=132923&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1450, 4, 5, '第30集：未来AI世界，会出现三国争霸吗', 'http://img.kaiyanapp.com/314cfbbbddef87b47974b502cab2fc8a.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139791&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607318591, 1585981996);
INSERT INTO `video` VALUES (1451, 4, 6, '为什么越来越的年轻人不想要孩子？', 'http://img.kaiyanapp.com/5e6cf8dccbfd69bc46911311a3c5ce47.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=128172&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833109, 1585981996);
INSERT INTO `video` VALUES (1452, 4, 3, '水滴之冒险，生命之灵性', 'http://img.kaiyanapp.com/b7522c92fe7d9b2a2ca0266900441aa4.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=148494&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1453, 4, 7, '脑洞大开：发现生活里的乐趣', 'http://img.kaiyanapp.com/62702848579a7363b5a1b406899f6277.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=145939&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1606980148, 1585981996);
INSERT INTO `video` VALUES (1454, 4, 4, '魔幻而绚丽：光线之舞', 'http://img.kaiyanapp.com/afa2513f7b6e47ee81e970588c832736.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=142089&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607276780, 1585981996);
INSERT INTO `video` VALUES (1455, 4, 8, '酷炫作品集锦：浩瀚太空', 'http://img.kaiyanapp.com/a6805a78377e02f692cebafaa4615c80.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=142869&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606364814, 1585981996);
INSERT INTO `video` VALUES (1456, 4, 3, '关于「圆」的奇思妙想', 'http://img.kaiyanapp.com/c5e5557634574371549cf0f8189dbc76.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=134156&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332595, 1585981996);
INSERT INTO `video` VALUES (1457, 4, 6, '黑白创意实验性短片：叠加', 'http://img.kaiyanapp.com/2c2feba5b75d5842e83fd612d06f03f1.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=137956&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606395942, 1585981996);
INSERT INTO `video` VALUES (1458, 4, 7, '迷失东京：朦胧中发现日本之美', 'http://img.kaiyanapp.com/4ada3a5b876c9e1a4d7c972ee38f89b9.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=146868&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606393846, 1585981996);
INSERT INTO `video` VALUES (1459, 4, 3, '夜景摄影短片：动物们的夜生活', 'http://img.kaiyanapp.com/3f881dc6a0c3d65ff90686c9a1c75add.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140121&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1460, 4, 8, '探索物质世界里的奥妙', 'http://img.kaiyanapp.com/879e5cada6557659ea1f29dc0b15cc87.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=133711&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1461, 4, 6, '「英雄联盟」暗黑短片：阿木木的宇宙', 'http://img.kaiyanapp.com/f145ed98a628766b84b3aa876fe40d3f.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=135833&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606994568, 1585981996);
INSERT INTO `video` VALUES (1462, 4, 3, '超级无敌海鲜船！大胃王见到都怕', 'http://img.kaiyanapp.com/9856a6e92bcdcf7a175ef471699f37e8.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=126835&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606832043, 1585981996);
INSERT INTO `video` VALUES (1463, 4, 2, '分身乏术不可能，看杨幂高能演技', 'http://img.kaiyanapp.com/1dbff90e7e84974f8180e4b502e4cc69.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=117582&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607255740, 1585981996);
INSERT INTO `video` VALUES (1464, 4, 8, '为什么金钱买不到快乐？', 'http://img.kaiyanapp.com/371c29e7695ac0b048f1c8550beab894.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=153779&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1606981377, 1585981996);
INSERT INTO `video` VALUES (1465, 4, 1, '大家在吐槽的时候，老外被春晚震惊!', 'http://img.kaiyanapp.com/818fa4fd9367ae0282783d49128827c2.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=149375&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1466, 4, 6, '动物界的智商之最', 'http://img.kaiyanapp.com/e7e518c88463363853a935316bf787ed.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=133402&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1608522613, 1585981996);
INSERT INTO `video` VALUES (1467, 4, 5, '苹果发布会新品预测，有你心仪的 iPhone 么？', 'http://img.kaiyanapp.com/59a6a1918a01a894e1199effd58746e5.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=172407&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607955096, 1585981996);
INSERT INTO `video` VALUES (1468, 4, 2, '最佳俄罗斯失败集锦', 'http://img.kaiyanapp.com/bf617f66b427630db3f11f31db281b07.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=128482&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607953524, 1585981996);
INSERT INTO `video` VALUES (1469, 4, 6, '英伦街头自由滑行，感受轮滑圣地伦敦', 'http://img.kaiyanapp.com/295e0c879862e9c1e5de138cc74831a2.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=159143&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607125538, 1585981996);
INSERT INTO `video` VALUES (1470, 4, 2, '人生何止一串，还有霸气鲍鱼焖鸡煲', 'http://img.kaiyanapp.com/f3792938f13b156a6724dd64755898bd.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=118427&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1606993586, 1585981996);
INSERT INTO `video` VALUES (1471, 4, 8, '葡萄牙人过节癖好多，人手一个锤子见谁砸谁', 'http://img.kaiyanapp.com/e651814cdc3d0bebacc5c6d4d6a55c7a.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=164860&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607090759, 1585981996);
INSERT INTO `video` VALUES (1472, 4, 3, '十里桃花已经开满林芝，还在办公室加班吗？', 'http://img.kaiyanapp.com/b204af5925b2ad4a99f44cf2ff815c7f.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=155409&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1473, 4, 4, '2018年世界花式纸牌大会官方高清版视频', 'http://img.kaiyanapp.com/4401b9973dba3becdddf09efdeee5b20.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=151937&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607158414, 1585981996);
INSERT INTO `video` VALUES (1474, 4, 2, 'SwissPeaks360K值不值得去？', 'http://img.kaiyanapp.com/1c1693444800daca85e7dad785598975.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=128305&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833118, 1585981996);
INSERT INTO `video` VALUES (1475, 4, 5, '长达360公里的超级越野跑瑞士360', 'http://img.kaiyanapp.com/8cdddc27472684f9e4c031ccd5648783.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=127643&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1608458510, 1585981996);
INSERT INTO `video` VALUES (1476, 4, 8, '澳大利亚人把“反串”也变成了艺术？', 'http://img.kaiyanapp.com/25618d874c36bbb81a488d3ba2ced331.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=172547&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606831790, 1585981996);
INSERT INTO `video` VALUES (1477, 4, 1, '航拍潍坊第三十六届国际风筝节', 'http://img.kaiyanapp.com/2714f30eb18b5fad0f9b652757747797.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=158424&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1478, 4, 2, '你可低估了这个城市人民的爱水程度', 'http://img.kaiyanapp.com/d8785a353abb0ebd946102f2e24effac.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=167222&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607848480, 1585981996);
INSERT INTO `video` VALUES (1479, 4, 4, '隐蔽的物：关于“物”的创作方法', 'http://img.kaiyanapp.com/39749040686e4a69653a1fb97b73c848.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=131050&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1480, 4, 3, '2018 第 70 届艾美奖爆笑讽刺短片', 'http://img.kaiyanapp.com/8504cbb0cf87fd8f63ee30ccf7d8f72c.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=127551&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1481, 4, 2, '一只平底锅就能做的极品早餐', 'http://img.kaiyanapp.com/3e4508584553d5257a681371de32c3cd.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=10112&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608542112, 1585981996);
INSERT INTO `video` VALUES (1482, 4, 6, '他坚持45年, 拍摄有趣的灵魂', 'http://img.kaiyanapp.com/f10bceae3d46312f6881b8917bf0dc54.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=110090&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607332528, 1585981996);
INSERT INTO `video` VALUES (1483, 4, 4, '迷幻视觉动画：衍生', 'http://img.kaiyanapp.com/a88051ea8321208bdb818da6a0849c8d.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=114249&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606726957, 1585981996);
INSERT INTO `video` VALUES (1484, 4, 3, '比起打败对手，更难的是战胜自己', 'http://img.kaiyanapp.com/f88b5e2d1b6f1831ff1203faefa7208e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=114409&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1485, 4, 6, '啪啪啪的时候，快乐究竟来自哪里？', 'http://img.kaiyanapp.com/d3986816daf9daac9f03064b83cefd47.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=116661&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1486, 4, 7, '说到啪啪啪，多久才算久？', 'http://img.kaiyanapp.com/6e96a95efcaffdb16194e287f296dd9b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=121997&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 1, 0, 0, '', 2, 1607332795, 1585981996);
INSERT INTO `video` VALUES (1487, 4, 2, '在太空中啪啪啪是一种什么样的体验？', 'http://img.kaiyanapp.com/06b9200565c4dd09a2dd4d779ee13314.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=122677&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606719394, 1585981996);
INSERT INTO `video` VALUES (1488, 4, 2, '2 分钟了解女性「啪啪啪」全过程', 'http://img.kaiyanapp.com/b791ff216f44bf9f336480c95b362cb7.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139529&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1489, 4, 6, '14 个关于啪啪啪的酷炫事实', 'http://img.kaiyanapp.com/62a3beb2b17914e512fd51efebe5336e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=145230&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 1, 0, 0, 0, '', 2, 1607324042, 1585981996);
INSERT INTO `video` VALUES (1490, 4, 8, '7 个理由告诉你为什么一定要啪啪啪', 'http://img.kaiyanapp.com/46abf517217f52c1b64f38676e9d3596.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=146161&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585981996, 1585981996);
INSERT INTO `video` VALUES (1491, 4, 4, '复古港风妆 我真的超爱这个妆！', 'http://img.kaiyanapp.com/464d95f02044a677b2e679820e16c20a.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=142667&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608430901, 1585981996);
INSERT INTO `video` VALUES (1492, 4, 4, '黄绿眼妆，超美牛油果妆容', 'http://img.kaiyanapp.com/6731df2414cf39f6385fb3ffcbb6f3c4.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=135729&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607172624, 1585981996);
INSERT INTO `video` VALUES (1493, 4, 5, '冬日炼瓦色系妆容 可以说很温柔了', 'http://img.kaiyanapp.com/b7da8aae32af91d0f3300c0f63ced22c.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138029&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607090770, 1585981996);
INSERT INTO `video` VALUES (1494, 4, 4, '满满的购物欲！9 月购物分享 + 妆容 ', 'http://img.kaiyanapp.com/ad92be702f21f1b171f1bd9426db6d77.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=132519&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606831708, 1585981996);
INSERT INTO `video` VALUES (1495, 4, 5, '欧美复古红妆容，枫叶的颜色！', 'http://img.kaiyanapp.com/abdb665fc32d36a2550644500c07f383.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=126068&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833713, 1585981996);
INSERT INTO `video` VALUES (1496, 4, 2, '超适合拍照用的闪亮珍珠美艳妆', 'http://img.kaiyanapp.com/59032799ff26ea0b8569dbbcebb304da.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=134340&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 4, 0, 0, 0, 0, '', 2, 1608261272, 1585981996);
INSERT INTO `video` VALUES (1497, 4, 5, '温柔本人！韩剧「内在美」女二李多喜仿妆', 'http://img.kaiyanapp.com/5595369cb2f171ca34edad71f39f6782.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140110&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607164287, 1585981996);
INSERT INTO `video` VALUES (1498, 4, 7, '秋冬新尝试 橘色系蜂蜜黄油妆容', 'http://img.kaiyanapp.com/32c7e8e727ae34d02f9e860fc89995af.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140883&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606582948, 1585981996);
INSERT INTO `video` VALUES (1499, 4, 1, '秋冬新尝试：橘色系蜂蜜黄油妆容', 'http://img.kaiyanapp.com/32c7e8e727ae34d02f9e860fc89995af.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136607&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606726800, 1585981996);
INSERT INTO `video` VALUES (1500, 4, 1, '圣诞妆容第一弹！软妹必备 无敌可爱！', 'http://img.kaiyanapp.com/ec41837db78b913176f54fc990295ae4.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=142669&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607332819, 1585981996);
INSERT INTO `video` VALUES (1501, 4, 6, 'Malafacha | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/b23134d4a1ecd31537ee6e8e9c7184d0.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139246&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585982006, 1585982006);
INSERT INTO `video` VALUES (1502, 4, 7, 'Anuar Lyon | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/5bef17b87074c39770a05afb79f247b6.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139276&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585982006, 1585982006);
INSERT INTO `video` VALUES (1503, 4, 4, 'Rcano | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/6703fc73a139f33670f090ee81e0128e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139248&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606395210, 1585982006);
INSERT INTO `video` VALUES (1504, 4, 6, 'Kris Goyri | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/3b4e09d372527200f76f685e7fadc1ec.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139277&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607153594, 1585982006);
INSERT INTO `video` VALUES (1505, 4, 8, 'Galo Bertin | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/f5d998f4469e634e01eab7f4c1da7e31.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139271&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607270375, 1585982006);
INSERT INTO `video` VALUES (1506, 4, 3, '包 | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/cfe0038de34a66e7486818c67092a7be.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139719&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606564253, 1585982006);
INSERT INTO `video` VALUES (1507, 4, 4, 'Alexa Chung | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/57359761a1e04f3d15afce258228fcbc.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138068&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606394930, 1585982006);
INSERT INTO `video` VALUES (1508, 4, 8, 'Cynthia Buttenklepper | 2019 年春夏秀', 'http://img.kaiyanapp.com/0655a39b160170f396913a0e970422b6.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138889&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606981216, 1585982006);
INSERT INTO `video` VALUES (1509, 4, 6, 'Sankuanz | 2019 年春夏全时装秀', 'http://img.kaiyanapp.com/f1b2460a8ffabce569b7228adc47fc5d.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=141276&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607075104, 1585982006);
INSERT INTO `video` VALUES (1510, 4, 1, 'DM 小姐 | 2019 年春夏全时装秀 ', 'http://img.kaiyanapp.com/0acad7ae42f014e95d9a0a236658bdc2.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138054&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585982006, 1585982006);
INSERT INTO `video` VALUES (1511, 4, 4, '「翻车了吗」收了台3年前的手机', 'http://img.kaiyanapp.com/456a8b2de2d08a4025bc12a83a072450.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=157944&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606721399, 1585982006);
INSERT INTO `video` VALUES (1512, 4, 2, '「Koala Vlog」难得的忙里偷闲', 'http://img.kaiyanapp.com/2571ef502459754e5def7c866987475c.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=165401&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606830447, 1585982006);
INSERT INTO `video` VALUES (1513, 4, 2, 'Koala Vlog-教科书式搭讪小姐姐', 'http://img.kaiyanapp.com/8409467febba2cf5bbaace0a913acc44.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=166800&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607150247, 1585982006);
INSERT INTO `video` VALUES (1514, 4, 4, '最值得推荐的 20 款任天堂 Switch 游戏', 'http://img.kaiyanapp.com/a00ddb91ee9d7ff487a491b150cd3a87.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=122336&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332847, 1585982006);
INSERT INTO `video` VALUES (1515, 4, 4, '「爱·吃」16种辅料煮的泡面是什么味？', 'http://img.kaiyanapp.com/064d70388c520c92eac492879cf587de.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=167648&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607159811, 1585982006);
INSERT INTO `video` VALUES (1516, 4, 3, '新垣结衣：「Life is Your Life.」', 'http://img.kaiyanapp.com/9d887714d1016fbd5a05ceb6664359fa.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=130499&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607149336, 1585982006);
INSERT INTO `video` VALUES (1517, 4, 7, '探壮阔沙漠，访约旦千年古迹', 'http://img.kaiyanapp.com/f518a08cfddbc703480db839e8e3e633.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=136819&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607312501, 1585982006);
INSERT INTO `video` VALUES (1518, 4, 5, '这是一条告别视频，是时候做个了结了', 'http://img.kaiyanapp.com/c2fe84b0fa9ac1a433f2c9fdfeb0c23c.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=135273&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606583058, 1585982006);
INSERT INTO `video` VALUES (1519, 4, 6, '把 PS4 带到户外：构建便携式游戏主机', 'http://img.kaiyanapp.com/9388b0d21ec582c91cc03dd7c3e5d464.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=144057&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606564769, 1585982006);
INSERT INTO `video` VALUES (1520, 4, 8, 'OPPO K1上手：冲小米8青春版来的？', 'http://img.kaiyanapp.com/2d49baece21ac87200c4ba5403908616.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=133981&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607930992, 1585982006);
INSERT INTO `video` VALUES (1521, 4, 1, '用物品演奏音乐：杯子交响曲', 'http://img.kaiyanapp.com/6d1b5ccb0495687252542a727e9964d1.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=118592&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585982006, 1585982006);
INSERT INTO `video` VALUES (1522, 4, 4, '杭三丁', 'http://img.kaiyanapp.com/55e756791709ccbf1b2c597cba8fcc16.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=172037&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606831872, 1585982006);
INSERT INTO `video` VALUES (1523, 4, 2, '掌握这些技巧，西红柿炒鸡蛋会更好吃!', 'http://img.kaiyanapp.com/ee7504030fbfee6b85e0cde4eca7ace3.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=166445&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833117, 1585982006);
INSERT INTO `video` VALUES (1524, 4, 3, '数字交响乐，苹果要“扼住命运的咽喉”？', 'http://img.kaiyanapp.com/ac6449cd491ceece359f248441407f15.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=147910&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606708316, 1585982006);
INSERT INTO `video` VALUES (1525, 4, 7, '章鱼足拍黄瓜', 'http://img.kaiyanapp.com/44b7bad8d4aac84fecd2d034dc5c9b70.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=164562&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607164045, 1585982006);
INSERT INTO `video` VALUES (1526, 4, 3, '一分钟美食：年饭必备的年年有余', 'http://img.kaiyanapp.com/93d92f155f68ae1607135065fccd85b0.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=149260&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607325751, 1585982006);
INSERT INTO `video` VALUES (1527, 4, 1, '交响乐与光之舞：绚丽而璀璨', 'http://img.kaiyanapp.com/e6820f02442b0440b2f1968bf84e0788.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=148136&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606926401, 1585982006);
INSERT INTO `video` VALUES (1528, 4, 8, '神秘的门后世界，一起来探险吧', 'http://img.kaiyanapp.com/21f735d61874bf2f9eff32e44e70c03a.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=144040&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606581663, 1585982006);
INSERT INTO `video` VALUES (1529, 4, 5, '大神历时3个月 动画完美诠释 命运交响曲', 'http://img.kaiyanapp.com/0aeaf72d4d3096c35ffae8129d8a220b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=135728&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585982006, 1585982006);
INSERT INTO `video` VALUES (1530, 4, 2, '怕七大姑八大姨催婚一块雪花酥就能搞定她们', 'http://img.kaiyanapp.com/3ff8f61b62c3c7ddfeeca00b1012ee3b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=149152&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585982006, 1585982006);
INSERT INTO `video` VALUES (1531, 4, 1, '戴建武：未来女人再也不用「生」孩子', 'http://img.kaiyanapp.com/a3234ce59f42a3d00355dabd0f0efcb5.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=140475&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1608458580, 1585982006);
INSERT INTO `video` VALUES (1532, 4, 1, '二十亿年前，我们的老祖先，一口把另一个生物吞进去了', 'http://img.kaiyanapp.com/23d9246a91afd24f9e59968e72e76f68.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=164349&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607160211, 1585982006);
INSERT INTO `video` VALUES (1533, 4, 8, '爱看韩剧的人，更难收获爱情与婚姻？', 'http://img.kaiyanapp.com/42cf4d2dd401beb5c68bac32d439aaba.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=146339&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585982006, 1585982006);
INSERT INTO `video` VALUES (1534, 4, 5, '李铭建：广州真是一座说不清楚的城市', 'http://img.kaiyanapp.com/bc89d55079b93dc0479ee62f5f875f9e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=143288&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607927217, 1585982006);
INSERT INTO `video` VALUES (1535, 4, 6, '北大教授：能和男性平起平坐的女性是花木兰', 'http://img.kaiyanapp.com/c005d71b90d224a71a583e32ce104b6b.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=128833&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 2, 0, 0, '', 2, 1607162580, 1585982006);
INSERT INTO `video` VALUES (1536, 4, 4, '戴锦华：贾斯汀·比伯是如何影响男性文化的', 'http://img.kaiyanapp.com/fb7ca846e8958da096e237e9ff6f0f0a.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=138924&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585982006, 1585982006);
INSERT INTO `video` VALUES (1537, 4, 2, '戴建武：再生医学的目的不是长生不老', 'http://img.kaiyanapp.com/bedf56657e04a7167f17dc35d2af00dd.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=143542&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585982006, 1585982006);
INSERT INTO `video` VALUES (1538, 4, 4, '车品觉VS尤瓦尔·赫拉利：谁敢把人生交给算法？', 'http://img.kaiyanapp.com/e7ad7c2baa9ce0cc68f9239fffedbf13.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=157151&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585982006, 1585982006);
INSERT INTO `video` VALUES (1539, 4, 5, '生物科学家：失明不再是不治之症', 'http://img.kaiyanapp.com/3eaff56543e4cf32ed8f2f04b9927964.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139304&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607256858, 1585982006);
INSERT INTO `video` VALUES (1540, 4, 4, '计算机牛人：淘宝排名的算法有什么问题？', 'http://img.kaiyanapp.com/fce92edb78eb45a571d7bd65b52921fb.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=139862&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606831435, 1585982006);
INSERT INTO `video` VALUES (1541, 4, 1, '魔幻动画：千里寻女记', 'http://img.kaiyanapp.com/fa47d1149b3c02e8b82ddc237523ac15.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=147105&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1606993516, 1585982006);
INSERT INTO `video` VALUES (1542, 4, 7, '父亲节特辑：我的爸爸，是菜鸟妈妈', 'http://img.kaiyanapp.com/6c89325eb74d1e1498f37c13888dc3a8.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=159857&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606831790, 1585982006);
INSERT INTO `video` VALUES (1543, 4, 1, '女儿的化装舞会，苦的都是老妈', 'http://img.kaiyanapp.com/d8382a715bec5eeca8b48def658e19b0.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=160885&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1608284894, 1585982006);
INSERT INTO `video` VALUES (1544, 4, 1, '温馨回忆动画：爸爸，突然就老了', 'http://img.kaiyanapp.com/13dca48a747dadfcaea548e7a9e8ca86.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=143662&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 1, 0, 0, 0, '', 2, 1606822491, 1585982006);
INSERT INTO `video` VALUES (1545, 4, 3, '同一个世界同一种父母，你的父母超多戏', 'http://img.kaiyanapp.com/428cc64c6a0bf1e6cc2eda17bab58fc0.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=157312&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606390786, 1585982006);
INSERT INTO `video` VALUES (1546, 4, 3, '看过《霍比特人》，这间山洞小屋你一定会去', 'http://img.kaiyanapp.com/dbb0cdf0f3e7829968d673306f22de6a.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=120763&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585982006, 1585982006);
INSERT INTO `video` VALUES (1547, 4, 5, '女儿随手涂鸦，被老爸做成了彩色绘本', 'http://img.kaiyanapp.com/1b64cad09acb5cb8a8581b2fb5d4402a.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=151779&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585982006, 1585982006);
INSERT INTO `video` VALUES (1548, 4, 8, '纽约广告节银奖：阳光小美女', 'http://img.kaiyanapp.com/5ec904b8721e946ee117a0a5ae9cb7df.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=146786&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585982006, 1585982006);
INSERT INTO `video` VALUES (1549, 4, 7, '朱丹：女子本弱，为母则强', 'http://img.kaiyanapp.com/fd0ac7f19ba5d8227cacbead9e577746.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=160292&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607916237, 1585982006);
INSERT INTO `video` VALUES (1550, 4, 6, '温馨动画短片：父爱从未缺席，只是你没发现', 'http://img.kaiyanapp.com/c28ca6d99e1030e4dd7600f7b25467d6.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=145633&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607953926, 1585982006);
INSERT INTO `video` VALUES (1551, 4, 3, '入围奥斯卡最佳真人短片：「伊卡洛斯」', 'http://img.kaiyanapp.com/6fe6a8103e574687ebb5ff13b7a0ec12.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=146222&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585982006, 1585982006);
INSERT INTO `video` VALUES (1552, 4, 4, '入围奥斯卡最佳记录短片：「我老爸的遗物」', 'http://img.kaiyanapp.com/b869e00fdb3466e693170788d353b8a4.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=146259&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585982006, 1585982006);
INSERT INTO `video` VALUES (1553, 4, 5, '「权游」虐恋混剪：那些爱情的戳心瞬间', 'http://img.kaiyanapp.com/3af085efa34f26e73c130f2d772c0b79.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=146770&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606725754, 1585982006);
INSERT INTO `video` VALUES (1554, 4, 8, '西西第一次滑雪比赛', 'http://img.kaiyanapp.com/211f303293f587420115121d5e9ec4ac.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=148662&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607325465, 1585982006);
INSERT INTO `video` VALUES (1555, 4, 6, '前方高「污」广告：食色性也', 'http://img.kaiyanapp.com/583078145cc8419d7572045cb288461e.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=149521&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607165961, 1585982006);
INSERT INTO `video` VALUES (1556, 4, 8, '他们花1000万，改造了一个老仓库', 'http://img.kaiyanapp.com/cef61e81b0b1eab590c6c8480ffed1d2.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=25050&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 1, 0, 0, '', 2, 1607162592, 1585982006);
INSERT INTO `video` VALUES (1557, 4, 8, '一炉香，为何如此迷人？', 'http://img.kaiyanapp.com/012a94fa6706fd181bbedda732d36fb1.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=25496&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608458668, 1585982006);
INSERT INTO `video` VALUES (1558, 4, 3, '赤裸的、不停扭动的身体', 'http://img.kaiyanapp.com/67ac74426546612ebaca509b378dc684.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=26063&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585982006, 1585982006);
INSERT INTO `video` VALUES (1559, 4, 8, '《舌尖上的中国》导演告诉你什么最好吃', 'http://img.kaiyanapp.com/b0377cc3f441dde914757982094f8fb3.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=26128&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1606981064, 1585982006);
INSERT INTO `video` VALUES (1560, 4, 5, '比动版《清明上河图》更逆天的视频古画', 'http://img.kaiyanapp.com/07821ea8f6af92e28d1f9a9a374b61fd.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=26182&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1606996806, 1585982006);
INSERT INTO `video` VALUES (1561, 4, 1, '周末沙雕：苍天！我就想吃个 cookie 而已', 'http://img.kaiyanapp.com/5a853deb0241996c04da885289e0e209.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=165785&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606831872, 1585982006);
INSERT INTO `video` VALUES (1562, 4, 2, '水煮牛肉解馋吃不胖', 'http://img.kaiyanapp.com/f0bd4d471dc2a01f9b87871406da6f74.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=160922&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607252301, 1585982006);
INSERT INTO `video` VALUES (1563, 4, 2, '最skr的日料打卡胜地,你还没来pick', 'http://img.kaiyanapp.com/cc5486b388d0fc70140ffe382b450611.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=120889&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606829054, 1585982006);
INSERT INTO `video` VALUES (1564, 4, 5, '忙碌周一，用快手美味晚餐治愈疲惫的一天', 'http://img.kaiyanapp.com/4a0ce703f120622044685cb54d5b9cfa.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=161339&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1606996912, 1585982006);
INSERT INTO `video` VALUES (1565, 4, 3, '图片和实物相符的红烧牛肉面，终于吃上了！', 'http://img.kaiyanapp.com/557029395a37118b14b377b48e796154.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=152518&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1607325975, 1585982006);
INSERT INTO `video` VALUES (1566, 4, 8, '12 道省钱料理！小资又美味', 'http://img.kaiyanapp.com/46d5966076966d32566b976855ab17e4.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=126860&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606395037, 1585982006);
INSERT INTO `video` VALUES (1567, 4, 6, '简单一蒸就好吃，小编看一眼就被馋哭了', 'http://img.kaiyanapp.com/df2c05bd6994bef14ccdb3a041c2f8e2.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=159963&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585982006, 1585982006);
INSERT INTO `video` VALUES (1568, 4, 1, '【原创定格动画】煎饼果子', 'http://img.kaiyanapp.com/a2684eba295227e0e4cd88b5be513099.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=129110&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585982006, 1585982006);
INSERT INTO `video` VALUES (1569, 4, 4, '【创意视觉】我的名字是OTAKUKO', 'http://img.kaiyanapp.com/3cb76a40245d0dd5d0b32e44cac798be.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=168136&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608542104, 1585982006);
INSERT INTO `video` VALUES (1570, 4, 5, '创意定格动画：城市之秋', 'http://img.kaiyanapp.com/f244c13cb755f15e1601d98dd1904520.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=132964&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 3, 0, 0, 0, 0, '', 2, 1607318756, 1585982006);
INSERT INTO `video` VALUES (1571, 4, 3, '催眠必看广告：高级 Spa 级行车体验', 'http://img.kaiyanapp.com/475d5b1402cf656ec3b6b6ed7db610b1.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=145157&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585982006, 1585982006);
INSERT INTO `video` VALUES (1572, 4, 2, '为什么你应该读一读「堂吉柯德」', 'http://img.kaiyanapp.com/b993c5107464202d14204b20d7eee678.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=148207&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608430887, 1585982006);
INSERT INTO `video` VALUES (1573, 4, 6, '这样的架子鼓才好玩，卷起就走，人人学的会', 'http://img.kaiyanapp.com/c6e2c17cb26ccd8041b8fc192607afdb.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=113005&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585982006, 1585982006);
INSERT INTO `video` VALUES (1574, 4, 6, '你还记得上次怦然心动是什么时候，为了谁吗', 'http://img.kaiyanapp.com/a5755fccf4a5e6682ce249d76897349d.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=118677&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585982006, 1585982006);
INSERT INTO `video` VALUES (1575, 4, 8, '驶向荒野第二季番外：回顾车队的前世今生', 'http://img.kaiyanapp.com/f4824c91b754233e0f3ca624f221717c.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=163849&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608563506, 1585982006);
INSERT INTO `video` VALUES (1576, 4, 7, '揭开霸王龙的进化之谜', 'http://img.kaiyanapp.com/a56c4b3cceee205271cd032144cdece9.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=157637&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607332540, 1585982006);
INSERT INTO `video` VALUES (1577, 4, 7, '大货车频繁“吃”人，这些致命盲区不得不防', 'http://img.kaiyanapp.com/32290434671515924f3c79a4b4e8c6cb.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=162068&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606833613, 1585982006);
INSERT INTO `video` VALUES (1578, 4, 5, '横跨千里，12城市空气质量观察', 'http://img.kaiyanapp.com/025011a0d223ae1513761bb5116df050.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=135025&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1607159391, 1585982006);
INSERT INTO `video` VALUES (1579, 4, 8, '占据整个宇宙绝大部分的暗物质到底是什么？', 'http://img.kaiyanapp.com/683f94d42d7cdcf935dafdd06bfd1267.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=164273&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606808527, 1585982006);
INSERT INTO `video` VALUES (1580, 4, 4, '如果人类看不到色彩，地球就得了抑郁症', 'http://img.kaiyanapp.com/dd7d611c6888d0c638d6652a47d901c1.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=170284&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585982006, 1585982006);
INSERT INTO `video` VALUES (1581, 4, 5, '咆哮吧，你就是天生的王者：翻唱「Roar」', 'http://img.kaiyanapp.com/2d096a93e53c9d5f870921a95b9032ee.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=112401&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 2, 0, 0, 0, 0, '', 2, 1608261278, 1585982006);
INSERT INTO `video` VALUES (1582, 4, 7, '一学就会的舌尖美味：香辣芝麻鸡翅', 'http://img.kaiyanapp.com/f30476023d43e6d5382cd284c148755e.png?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=114545&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 1, 0, 0, 0, 0, '', 2, 1606392031, 1585982006);
INSERT INTO `video` VALUES (1583, 4, 4, 'KHS 翻唱「阿拉丁」电影主题曲', 'http://img.kaiyanapp.com/9829932d2590a11b8808a5bbd73f50b5.jpeg?imageMogr2/quality/60/format/jpg', 'http://baobab.kaiyanapp.com/api/v1/playUrl?vid=117787&resourceType=video&editionType=default&source=aliyun&playUrlType=url_oss', '', '', 0, 0, 0, 0, 0, '', 2, 1585982006, 1585982006);
INSERT INTO `video` VALUES (1584, 4, 4, '给自己放个假：亚特兰大清新大宅', 'http://img.kaiyanapp.com/708d92c