import Vue from 'vue'
import Vuex from 'vuex'
import createPersistedState from 'vuex-persistedstate'
import user from '@/api/user'

Vue.use(Vuex)

export default new Vuex.Store({
  state: {
    token: null,
    user: null,
    replyItem: null
  },
  mutations: {
    setToken (state, token) {
      state.token = token
    },
    setUser (state, user) {
      state.user = user
    },
    setReplyItem (state, reply) {
      state.replyItem = reply
    }
  },
  actions: {
    getUser (context) {
      user.info().then(({ code, data }) => {
        if (code === 200) {
          context.commit('setUser', data)
        }
      })
    }
  },
  getters: {
    userinfo: state => {
      return {
        truename: state.user.truename,
        qq: state.user.qq,
        avatar: state.user.avatar,
        nickname: state.user.nickname,
        desc: state.user.desc,
        sex: state.user.sex,
        birthday: state.user.birthday
      }
    }
  },
  modules: {
  },
  plugins: [createPersistedState()]
})
