import Vue from 'vue'
import VueRouter from 'vue-router'
import Home from '../views/Home.vue'

Vue.use(VueRouter)

const routes = [
  {
    path: '/',
    component: Home,
    children: [
      {
        path: '',
        component: () => import('../views/home/home'),
        children: [
          {
            path: '',
            component: () => import('../views/home/index/video_list')
          }
        ]
      },
      {
        path: '/user',
        name: 'user',
        component: () => import('../views/user/user')
      },
      {
        path: '/collect',
        name: 'collect',
        component: () => import('../views/collect/collect')
      },
      {
        path: '/channel',
        name: 'channel',
        component: () => import('../views/channel')
      },
      {
        path: '/release',
        name: 'release',
        component: () => import('../views/release')
      }
    ]
  },
  {
    path: '/essay',
    component: () => import('../views/home/essay/essay')
  },
  {
    path: '/login',
    name: 'login',
    component: () => import('../views/login')
  },
  {
    path: '/register',
    name: 'register',
    component: () => import('../views/register')
  },
  {
    path: '/test',
    name: 'test',
    component: () => import('../views/test')
  },
  {
    path: '/video',
    name: 'video',
    component: () => import('../views/home/index/video_list')
  },
  {
    path: '/settings',
    name: 'settings',
    component: () => import('../views/user/settings')
  },
  {
    path: '/works',
    name: 'works',
    component: () => import('../views/user/works')
  },
  {
    path: '/invite',
    name: 'invite',
    component: () => import('../views/user/invite')
  },
  {
    path: '/user-data',
    name: 'userData',
    component: () => import('../views/user/user-information')
  },
  {
    path: '/comment-reply:item',
    name: 'commentReply',
    component: () => import('../views/home/index/reply')
  }
]

const router = new VueRouter({
  mode: 'history',
  base: process.env.BASE_URL,
  routes
})

export default router
