import Vue from 'vue'
import App from './App.vue'
import router from './router'
import store from './store'
import http from './http'
import './assets/styles/public.css'
import './assets/styles/font-awesome-4.7.0/css/font-awesome.min.css'
import VueAwesomeSwiper from 'vue-awesome-swiper'
import 'swiper/css/swiper.css'
import 'amfe-flexible'
import 'normalize.css'
import {
  Tabbar,
  TabbarItem,
  Tab,
  Tabs,
  Icon,
  List,
  Cell,
  CellGroup,
  PullRefresh,
  NavBar,
  Form,
  Field,
  Button,
  Divider,
  Toast,
  ActionSheet,
  Popup,
  Search,
  Uploader,
  Picker,
  TreeSelect,
  Tag,
  Dialog,
  DatetimePicker,
  Image,
  Lazyload,
  ImagePreview
} from 'vant'

Vue.use(Tabbar)
Vue.use(TabbarItem)
Vue.use(Tab)
Vue.use(Tabs)
Vue.use(Icon)
Vue.use(List)
Vue.use(Cell)
Vue.use(CellGroup)
Vue.use(PullRefresh)
Vue.use(NavBar)
Vue.use(Form)
Vue.use(Field)
Vue.use(Button)
Vue.use(Divider)
Vue.use(ActionSheet)
Vue.use(Popup)
Vue.use(Search)
Vue.use(Uploader)
Vue.use(Picker)
Vue.use(TreeSelect)
Vue.use(Tag)
Vue.use(Dialog)
Vue.use(DatetimePicker)
Vue.use(Image)
Vue.use(Lazyload)

Vue.use(VueAwesomeSwiper)

Vue.config.productionTip = false
Vue.prototype.$http = http
Vue.prototype.$toast = Toast
Vue.prototype.$dialog = Dialog
Vue.prototype.$imagePreview = ImagePreview

new Vue({
  router,
  store,
  render: h => h(App)
}).$mount('#app')
