<?php
	/** @var QSqlTable $objTable */
	/** @var QDatabaseCodeGen $objCodeGen */
	global $_TEMPLATE_SETTINGS;

	$strPropertyName = QCodeGen::DataListPropertyName($objTable);

	$_TEMPLATE_SETTINGS = array(
		'OverwriteFlag' => true,
		'DocrootFlag' => false,
		'DirectorySuffix' => '',
		'TargetDirectory' => __PANEL_GEN__,
		'TargetFileName' => $strPropertyName . 'ListPanelGen.class.php'
	);

	$listCodegenerator = $objCodeGen->GetDataListCodeGenerator($objTable);
	$strListVarName = $objCodeGen->DataListVarName($objTable);
	$options = $objTable->Options;

	// Check codegen settings file to see if we want to use a dialog or a form to edit a record
	$blnUseDialog = (isset($options['EditMode']) && $options['EditMode'] == 'dialog');

	$blnUseFilter = !$listCodegenerator->DataListHasFilter();

	if (isset($objTable->Options['CreateFilter'])) {
		$blnUseFilter = $objTable->Options['CreateFilter'];
	}

?>
<?php print("<?php\n"); ?>

<?php if ($blnUseDialog) { ?>
	include (__DIALOG__ . '/<?= $strPropertyName ?>EditDlg.class.php');
<?php } ?>


/**
 * This is the base list class for the  <?= $strPropertyName ?> class.
 *
 * Do not edit this file, this file is overwritten on any code regenerations. Make any changes you need to the subclass.
 *
 * @package <?= QCodeGen::$ApplicationName; ?>

 * @subpackage PanelBaseObjects
 */
abstract class <?= $strPropertyName ?>ListPanelGen extends QPanel {
<?php include("list_protected_member_variables.tpl.php"); ?>

	public function __construct($objParent, $strControlId = null) {
		parent::__construct($objParent, $strControlId);

<?php if ($blnUseDialog) { ?>
		$this->dlgEdit = new <?= $strPropertyName ?>EditDlg($this);
<?php } ?>
<?php if ($blnUseFilter) { ?>
		$this->CreateFilterPanel();
<?php } ?>
<?= $listCodegenerator->DataListInstantiate($objCodeGen, $objTable); ?>
<?php if ($blnUseFilter) { ?>
		$this-><?= $strListVarName ?>->SetDataBinder('BindData', $this);
<?php } ?>
		$this->CreateButtonPanel();
	}

<?= $listCodegenerator->DataListHelperMethods($objCodeGen, $objTable); ?>


<?php if ($blnUseFilter) { ?>
<?php include("list_createFilter.tpl.php"); ?>
<?php include("list_createDataBinder.tpl.php"); ?>
<?php } ?>


<?php include("list_createButtons.tpl.php"); ?>

<?php include("list_edit_item.tpl.php"); ?>

}
