#Model Connectors and the Model Connector Editor

##Model Connectors
Model connectors are generated by the code generator (in v2, these were called meta-controls). Model Connectors are the glue between a standard user interface element, and the data it represents. They are helper objects the help you edit the data in a table.

You do not need to use Model Connectors at all to use QCubed, but you will find them helpful. As your database grows, they make it easy to wire controls to the data each control represents without having to write, or rewrite a lot of boilerplate code.

Using them is easy, and you can scan through the generated panels to get a good idea of how they work. Generally, you create the Model Connector for a particular table, and then tell it to create controls to edit a particular field in the database. You can make changes to the control, but the Model Connector will also keep a reference to the control.

Later, you can tell the Model Connector to do the following things, and it will automatically handle the data transfer between all the controls you have created, and the database:

* **Load**. Loads a record in the database into the controls, over-writing what is there. Or, it can prepare all the UI to edit a new record.
* **Refresh**. Reload the record into the controls, in case something in the record changed.
* **Save**. Write the changes the user made back into the database.
* **Delete**. Delete the record that was previously loaded.

If you want to add a new control to the Model Connector, or change the behavior of a particular control, you can edit the Model Connector subclass file in your project/includes/connector directory. Be sure to override the **Refresh** and **Update*****Object*** methods there to move data in and out of the control you are creating.

##List Connectors
You will also find List Connectors in the project/includes/connector directory. These provide a default way to list the contents of a table. Like Model Connectors, you can edit the List Connector override file and customize how that is done, and what kind of list object is used.

##The Model Connector Editor
The Model Connector Editor is a pop up dialog that lets you alter the generated code for specific controls in the user interface. You can change a large variety of things, like the name or label of the control, its CSS class, its PHP class, and type specific things like the placeholder in a textbox for example, all without having to edit PHP code.

To bring up the editor, hover over the control you want to edit, and right click on the control with your mouse. Hover over an option to get more information about what each option does, and click on the tabs on top to reveal more options. Save, and then run the code generator to see the results.

The easiest way to get to all your controls is through the Form Drafts link from your start page. From there, click on a listing of a table, and then right-click on the table itself to edit options for how the table is generated. Go back to the Form Drafts and click on the New ... link to see a basic edit form, and then right click on any object you see to edit options for that object. One common thing to do at this point is to right-click on the Id field, and then have it not create a control, since its uncommon to need to show your internal record numbers to your users.

The default configuration.inc.php file makes the Model Connector Editor available to you when your website is in development mode with this code:

```
			define ('__DESIGN_MODE__', true);
```

The settings are saved in the codegne_options.json file, and you can edit this file by hand if needed. For example, if you remove a control from the user interface, the only way to get it back is to edit this file and delete the lines that are removing it, since you cannot see the control to right-click on it.

The changes made will for the most part impact the Model Connector base class that is generated, but may also have effects on the generated panels and List Connectors.

In particular, that the Model Connector is a general purpose connection between your database and your user interface. You don't have to use all the capabilities of a particular Model Connector, and you can create different panels to edit parts of a record, or list a table in different ways. Just remember that the changes you make to the Model Connector will impact **all** the various views that use it.