#Getting Started - Overview
One of QCubed's design philosophies is incremental development. We want to get you a working data-driven website as quickly as possible, and then give you the tools and techniques to incrementally craft this website into your brainchild. Below is an overview of the components and steps needed to get to that point where you have your first version of your website.

##System Configuration
Before you install QCubed, you will need access to an operating system that has the following:

* A Web server (like Apache or Nginx for example)
* PHP or HHVM
* A SQL database

For best results and the easiest development process, you should set up a development computer (like your laptop) that only you can access, and then set up a separate system to deploy your website for your users. You will edit the files directly on your development computer, and then upload those files to your deployment system when you are confident your application is working well.

See the [System Requirements and Configuration](System.md) topic for more information on best practices for configuring a development system and deployment system. 

##Installation
While you can install QCubed by hand, the easiest way to install QCubed is to use Composer, which is a PHP command line application that helps you install PHP libraries and helps you manage versions and dependencies. See the current installation instructions for details on the different ways to get QCubed.

For development purposes, it is probably best to install QCubed in your Document Root directory of the web server that is running on your personal development computer, or a sub-directory of your DocRoot. If your webserver uses Rewrite rules or some other way to do a virtual directory (e.g. /~mydir/...), you can install QCubed in your virtual directory home.

Assuming you installed QCubed using Composer, you will have the following file and folder structure:

* **index.php** - This starts out redirecting to the "Installation" page, which is a wizard that helps you initially configure QCubed.
* **qcubed.inc.php** - This file is an aid to help the system find the various parts of QCubed.
* **project folder** - This folder will contain most of the files that you write for your application. This is where your customizations go. 
	* **assets folder** - The place to put support files, like JavaScript, CSS, etc.
	* **forms folder** - These are code generated default entry points for your application files. Generally, as your application grows, you will move these files out of this folder, and into a location that you want your users to access as the URL entry point for that page.
	* **generated folder** - All the files in this folder are generated by the code generator each time it runs. Do not edit these files, as your edits will be over-written the next time you run codegen.
	* **includes folder** - These are primarily PHP support files that you will edit. Most of these file override class files that are either in the *generated* folder, or in the *vendor* folder.
	* **tmp folder** - A writable location for temporary files generated by QCubed. 
* **vendor folder** - This is the folder that Composer uses to install PHP libraries, including the core QCubed directory. The contents of this folder are entirely under the control of Composer, and you should not normally edit these files. The only exception would be if you find a bug or are proposing a change to QCubed itself, in which case you can edit a file and make a GitHub Pull request.

Many of the Project folders have Readme files in them to further describe the purpose of each individual folder.

##Configuration

###configuration.inc.php
The first file to edit is your `/project/includes/configuration/configuration.inc.php` file. See the comments in that file for details, but the two things you are required to do when just starting are[]():

* Tell QCubed where your document root directory is and how it is installed relative to this directory. 
* Set up the database connector parameters so QCubed can access your SQL database. You will need to specify the name of the database, and the credentials for a database user that can at least do Updates, Inserts and Deletes.

###codegensettings.xml
Depending on what kind of database you are using, you might need to edit this file later on in your development process. It gives you control of specific aspects of the code generation process, and also lets you describe foreign key relationships if you are using a database that does not natively support foreign keys (like MyISAM).

Most likely, you will not need to make any changes to this file when you are first getting started, but you should review the comments there so you can see what is available.

## Creating the Database
SQL Database design is beyond the scope of this document to be sure, but its not as complicated as you might think. If you do not know much about SQL, we recomend you start with a MySQL database, and go through a quick YouTube video tutorial to get the basics. Its actually possible to create a usable QCubed website connected to a SQL database without entering any SQL code at all. Using QCubed is a great way to start learning SQL.

Once you get a database installed, you likely will want to install a database management tool to save you from having to type out all that SQL. There are lots of them out there, both free and open source. *phpmyadmin* and *phppgadmin* are two that work with MySql and Postgresql respectively, and should work well for you since they are free, and both require PHP and a web server, and you need that anyway for QCubed.

Here are the basic steps to get started:

1. Install a database (like MySQL) on your local development computer (if you do not already have one).
1. Install your database management tool. Figure out what the root user and password is for your database and configure your management tool to use that to edit the database. For now, ignore any warnings about using the root user and password (provided this is a personal deveopment computer you are working on and not a public computer!)
1. Create a database, but don't add any tables just yet.
2. Create a new user in your database, and give that user permission to do Inserts, Updates and Deletes.
3. Edit the configuration.inc.php and use the database name, user name and user password in the database connector definition, like this:
```
			define('DB_CONNECTION_1', serialize(array(
				'adapter' => 'MySqli5',
				'server' => 'db',
				'port' => null,
				'database' => 'mynewdatabase',
				'username' => 'myuser',
				'encoding' => 'utf8',
			//	'profiling' => true,
				'profiling' => false,
				'caching' => false,
				'password' => '12345'
				)));
```
4. Using your database management tool, add tables and columns to your database. See the [Database Design](../using/Database.md) document for details on how your database design will impact the functionality of your generated user interface.
5. Run the code generator.

## Codegen
When you are ready to generate your code, bring up the *Start* page in your browser. If QCubed is installed on your local computer in the DocRoot of your webserver, and your webserver is setup to refer to your computer as *localhost*, you would type in the URL:
```localhost://vendor/qcubed/qcubed/assets/php/_devtools/start_page.php```

Click on the *Code Generator* link to start the code generation process. Your web server will need write access to your projects directory to be able to complete the code generation process. Once complete, it will show you a summary of what it did.

Go back to the *Start* page and click on the next link *View Form Drafts*. This will take you to the default forms that were created to edit each of your database tables. 

At this point, you have a working website that lets you create and edit records in your database. You will then start to customize your website, and alter the default behavior to fit your specific requirements.

See the various documents on Using QCubed to explore the customization process.