#Principles of QCubed
Here are some basic principles that guide the development of QCubed:

* **80-20 rule**. QCubed isn't the fastest product out there, but its fast enough for most applications. Because it saves you as a developer a ton of time in initial development and maintenance, it gives you the time to focus on tweaking the parts of your program that need performance increases for a good user experience. Our QQuery library similarly removes the need for writing most SQL, but is not a solution for all SQL situations.
* **Change is good**. Most data drive websites become unwieldy very quickly. Data design is so tightly connected to the user interface that the smallest database changes become big user interface headaches. We use object oriented scaffolding to decouple the data from the user interface as much as possible, so that you can modify your database, and related user interface changes are either automatic, or very easy to implement.
* **Reflect browser state to PHP state**. QCubed uses a number of mechanisms to ensure that whenever the user changes something in the browser, that change is mirrored to the PHP side, and vice-versa. The result of this philosophy is:
	* Programming in QCubed feels very much like programming in a desktop application. Generally, you do not need to worry about Puts and Gets or routers.
	* Most of the time, you only program in PHP. Unless you are creating a custom JavaScript widget, you don't need to program in JavaScript.
	* State from the browser sometimes is not immediately reflected, but delayed until the PHP side asks for the state.
* **Avoid unnecessary dependencies**. We have a couple of depencies on other PHP libraries, but for the most part, we try to avoid requiring other people's code in the core of QCubed. Often, we have found ourselves depending on code that goes stale and is no longer maintained, or simply is no longer state-of-the-art. That said, there is a lot of good code out there written by others, so we encourage the writing of QCubed plugins whenever we want to use 3rd party code.
* **Keep the core simple**. In line with the previous point, we want the core of QCubed to do what it does well and focus on the basics. In the current version (3.0), we have gotten away from that a bit, but hopefully by 4.0 we will be more focused. The idea is that the core should implement and support the current state of the art when dealing with HTML, and the JavaScript we need should be small and have few dependencies. Anything outside of that is welcome, but should go into a plugin or some other kind of add-on code.