// Copyright 2017 The GoReporter Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package engine

import (
	"testing"

	"github.com/json-iterator/go"
)

const structJson = `{"project":"github.com/wgliang/logcool","score":0,"grade":0,"metrics":{"CopyCodeTips":{"name":"CopyCode","description":"Query all duplicate code in the project and give duplicate code locations and rows.","summaries":{"\u0000":{"name":"2","description":"","errors":[{"line_number":22,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/cmd/cmd.go:104,125\n"},{"line_number":22,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/file/file.go:449,470\n"}]},"\u0001":{"name":"6","description":"","errors":[{"line_number":16,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/grok/grok.go:26,41\n"},{"line_number":17,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/split/split.go:26,42\n"},{"line_number":16,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/zeus/zeus.go:25,40\n"},{"line_number":15,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/email/email.go:33,47\n"},{"line_number":15,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/lexec/lexec.go:26,40\n"},{"line_number":15,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/stdout/stdout.go:25,39\n"}]},"\u0002":{"name":"2","description":"","errors":[{"line_number":29,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/filter.go:60,88\n"},{"line_number":29,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/output.go:63,91\n"}]},"\u0003":{"name":"2","description":"","errors":[{"line_number":19,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/collectd/collectd.go:110,128\n"},{"line_number":19,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/stdin/stdin.go:32,50\n"}]}},"weight":0.1,"percentage":92,"error":""},"CountCodeTips":{"name":"CountCode","description":"Count lines and files of go project.","summaries":{"CodeLines":{"name":"CodeLines","description":"2719","errors":null},"CommentLines":{"name":"CommentLines","description":"176","errors":null},"FileCount":{"name":"FileCount","description":"39","errors":null},"TotalLines":{"name":"TotalLines","description":"3404","errors":null}},"weight":0,"percentage":0,"error":""},"CycloTips":{"name":"Cyclo","description":"Computing all [.go] file's cyclo,and as an important indicator of the quality of the code.","summaries":{"github.com/wgliang/logcool":{"name":"github.com/wgliang/logcool","description":"8.00","errors":[{"line_number":8,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/logcool.go:35:1"}]},"github.com/wgliang/logcool/cmd":{"name":"github.com/wgliang/logcool/cmd","description":"2.23","errors":[{"line_number":5,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/cmd/cmd.go:67:1"},{"line_number":5,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/cmd/cmd.go:44:1"},{"line_number":5,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/cmd/cmd.go:104:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/cmd/cmd.go:33:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/cmd/cmd.go:22:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/cmd/cmd_test.go:39:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/cmd/cmd.go:95:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/cmd/cmd.go:85:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/cmd/cmd_test.go:47:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/cmd/cmd_test.go:35:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/cmd/cmd_test.go:31:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/cmd/cmd_test.go:8:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/cmd/cmd_test.go:51:1"}]},"github.com/wgliang/logcool/filter/grok":{"name":"github.com/wgliang/logcool/filter/grok","description":"2.17","errors":[{"line_number":5,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/grok/grok.go:44:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/grok/grok_test.go:25:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/grok/grok_test.go:16:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/grok/grok.go:26:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/grok/grok_test.go:12:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/grok/grok.go:21:1"}]},"github.com/wgliang/logcool/filter/metrics":{"name":"github.com/wgliang/logcool/filter/metrics","description":"2.00","errors":[{"line_number":4,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/metrics/metrics.go:50:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/metrics/metrics_test.go:25:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/metrics/metrics_test.go:16:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/metrics/metrics.go:30:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/metrics/metrics_test.go:12:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/metrics/metrics.go:25:1"}]},"github.com/wgliang/logcool/filter/split":{"name":"github.com/wgliang/logcool/filter/split","description":"1.83","errors":[{"line_number":3,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/split/split.go:45:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/split/split_test.go:25:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/split/split_test.go:16:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/split/split.go:26:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/split/split_test.go:12:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/split/split.go:21:1"}]},"github.com/wgliang/logcool/filter/zeus":{"name":"github.com/wgliang/logcool/filter/zeus","description":"1.83","errors":[{"line_number":3,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/zeus/zeus.go:43:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/zeus/zeus_test.go:25:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/zeus/zeus_test.go:16:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/zeus/zeus.go:25:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/zeus/zeus_test.go:12:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/zeus/zeus.go:20:1"}]},"github.com/wgliang/logcool/input/collectd":{"name":"github.com/wgliang/logcool/input/collectd","description":"1.50","errors":[{"line_number":4,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/collectd/collectd.go:136:1"},{"line_number":3,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/collectd/collectd.go:110:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/collectd/collectd_test.go:24:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/collectd/collectd_test.go:15:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/collectd/collectd.go:184:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/collectd/collectd.go:173:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/collectd/collectd.go:239:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/collectd/collectd.go:131:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/collectd/collectd.go:198:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/collectd/collectd_test.go:11:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/collectd/collectd.go:280:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/collectd/collectd.go:233:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/collectd/collectd.go:105:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/collectd/collectd.go:214:1"}]},"github.com/wgliang/logcool/input/file":{"name":"github.com/wgliang/logcool/input/file","description":"4.89","errors":[{"line_number":17,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/file/file.go:222:1"},{"line_number":11,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/file/file.go:403:1"},{"line_number":10,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/file/file.go:167:1"},{"line_number":7,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/file/file.go:369:1"},{"line_number":6,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/file/file.go:84:1"},{"line_number":5,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/file/file.go:449:1"},{"line_number":5,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/file/file.go:114:1"},{"line_number":4,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/file/file.go:141:1"},{"line_number":3,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/file/file.go:56:1"},{"line_number":3,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/file/file.go:328:1"},{"line_number":3,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/file/file.go:158:1"},{"line_number":3,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/file/file_test.go:24:1"},{"line_number":3,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/file/file.go:355:1"},{"line_number":3,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/file/file.go:340:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/file/file_test.go:15:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/file/file.go:51:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/file/file_test.go:11:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/file/file.go:79:1"}]},"github.com/wgliang/logcool/input/http":{"name":"github.com/wgliang/logcool/input/http","description":"2.33","errors":[{"line_number":4,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/http/http.go:84:1"},{"line_number":4,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/http/http.go:65:1"},{"line_number":3,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/http/http_test.go:13:1"},{"line_number":3,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/http/http.go:35:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/http/http_test.go:32:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/http/http_test.go:41:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/http/http.go:60:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/http/http.go:31:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/http/http_test.go:28:1"}]},"github.com/wgliang/logcool/input/stdin":{"name":"github.com/wgliang/logcool/input/stdin","description":"2.00","errors":[{"line_number":4,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/stdin/stdin.go:57:1"},{"line_number":3,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/stdin/stdin.go:32:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/stdin/stdin_test.go:15:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/stdin/stdin_test.go:24:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/stdin/stdin.go:27:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/stdin/stdin_test.go:11:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/stdin/stdin.go:53:1"}]},"github.com/wgliang/logcool/output/email":{"name":"github.com/wgliang/logcool/output/email","description":"1.86","errors":[{"line_number":4,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/email/email.go:55:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/email/email_test.go:16:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/email/email.go:33:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/email/email_test.go:34:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/email/email.go:28:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/email/email_test.go:12:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/email/email.go:50:1"}]},"github.com/wgliang/logcool/output/lexec":{"name":"github.com/wgliang/logcool/output/lexec","description":"1.83","errors":[{"line_number":3,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/lexec/lexec.go:43:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/lexec/lexec_test.go:29:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/lexec/lexec_test.go:16:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/lexec/lexec.go:26:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/lexec/lexec_test.go:12:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/lexec/lexec.go:21:1"}]},"github.com/wgliang/logcool/output/redis":{"name":"github.com/wgliang/logcool/output/redis","description":"2.44","errors":[{"line_number":7,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/redis/redis.go:72:1"},{"line_number":4,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/redis/redis.go:106:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/redis/redis.go:38:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/redis/redis.go:65:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/redis/redis_test.go:36:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/redis/redis_test.go:17:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/redis/redis.go:60:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/redis/redis.go:33:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/redis/redis_test.go:13:1"}]},"github.com/wgliang/logcool/output/stdout":{"name":"github.com/wgliang/logcool/output/stdout","description":"1.67","errors":[{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/stdout/stdout_test.go:29:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/stdout/stdout_test.go:16:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/stdout/stdout.go:42:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/stdout/stdout.go:25:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/stdout/stdout_test.go:12:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/stdout/stdout.go:20:1"}]},"github.com/wgliang/logcool/utils":{"name":"github.com/wgliang/logcool/utils","description":"2.28","errors":[{"line_number":8,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config.go:160:1"},{"line_number":7,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/input.go:52:1"},{"line_number":7,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/filter.go:60:1"},{"line_number":7,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/output.go:63:1"},{"line_number":6,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/output.go:40:1"},{"line_number":5,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/filter.go:39:1"},{"line_number":5,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/logevent.go:62:1"},{"line_number":4,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/logevent.go:49:1"},{"line_number":4,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config.go:187:1"},{"line_number":4,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config.go:74:1"},{"line_number":4,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/logevent.go:85:1"},{"line_number":3,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/input.go:39:1"},{"line_number":3,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config.go:118:1"},{"line_number":3,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/logevent.go:76:1"},{"line_number":3,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config.go:143:1"},{"line_number":3,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/logevent.go:131:1"},{"line_number":3,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/logevent.go:102:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config.go:209:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/logevent_test.go:42:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/input_test.go:14:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/logevent.go:29:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config_test.go:67:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/logevent.go:118:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/filter_test.go:14:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/logevent_test.go:26:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/output_test.go:14:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config.go:98:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config.go:88:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/logevent_test.go:12:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config_test.go:63:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config_test.go:19:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config_test.go:84:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config_test.go:50:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/logevent.go:37:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config_test.go:33:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config_test.go:37:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config.go:65:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/filter.go:28:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/logevent_test.go:95:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/logevent_test.go:56:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/filter_test.go:10:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config.go:70:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/output.go:29:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/filter.go:33:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/logevent.go:43:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/logevent_test.go:75:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/logevent_test.go:113:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/logevent_test.go:122:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config.go:108:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config_test.go:10:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/input_test.go:10:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/output.go:34:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config.go:113:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/output_test.go:10:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/input.go:28:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config_test.go:26:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/input.go:33:1"}]},"github.com/wgliang/logcool/utils/logo":{"name":"github.com/wgliang/logcool/utils/logo","description":"1.50","errors":[{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/logo/logo.go:24:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/logo/logo.go:39:1"}]}},"weight":0.2,"percentage":96,"error":""},"DeadCodeTips":{"name":"DeadCode","description":"All useless code, or never obsolete obsolete code.","summaries":{},"weight":0.04,"percentage":100,"error":""},"DependGraphTips":{"name":"DependGraph","description":"The dependency graph for all packages in the project helps you optimize the project architecture.","summaries":{"graph":{"name":"graph","description":"\u003c?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?\u003e\n\u003c!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\"\n \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\"\u003e\n\u003c!-- Generated by graphviz version 2.30.1 (20150306.0020)\n --\u003e\n\u003c!-- Title: godep Pages: 1 --\u003e\n\u003csvg width=\"1608pt\" height=\"821pt\"\n viewBox=\"0.00 0.00 1608.00 821.00\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\"\u003e\n\u003cg id=\"graph0\" class=\"graph\" transform=\"scale(1 1) rotate(0) translate(4 817)\"\u003e\n\u003ctitle\u003egodep\u003c/title\u003e\n\u003cpolygon fill=\"white\" stroke=\"white\" points=\"-4,5 -4,-817 1605,-817 1605,5 -4,5\"/\u003e\n\u003c!-- 0 --\u003e\n\u003cg id=\"node1\" class=\"node\"\u003e\u003ctitle\u003e0\u003c/title\u003e\n\u003cellipse fill=\"paleturquoise\" stroke=\"paleturquoise\" cx=\"1430\" cy=\"-473\" rx=\"87.1846\" ry=\"18\"/\u003e\n\u003ctext text-anchor=\"middle\" x=\"1430\" y=\"-469.3\" font-family=\"Times,serif\" font-size=\"14.00\"\u003egolang.org/x/sys/unix\u003c/text\u003e\n\u003c/g\u003e\n\u003c!-- 1 --\u003e\n\u003cg id=\"node2\" class=\"node\"\u003e\u003ctitle\u003e1\u003c/title\u003e\n\u003cellipse fill=\"paleturquoise\" stroke=\"paleturquoise\" cx=\"419\" cy=\"-33\" rx=\"155.173\" ry=\"18\"/\u003e\n\u003ctext text-anchor=\"middle\" x=\"419\" y=\"-29.3\" font-family=\"Times,serif\" font-size=\"14.00\"\u003egithub.com/wgliang/logcool/output/redis\u003c/text\u003e\n\u003c/g\u003e\n\u003c!-- 2 --\u003e\n\u003cg id=\"node3\" class=\"node\"\u003e\u003ctitle\u003e2\u003c/title\u003e\n\u003cellipse fill=\"paleturquoise\" stroke=\"paleturquoise\" cx=\"1084\" cy=\"-307\" rx=\"108.581\" ry=\"18\"/\u003e\n\u003ctext text-anchor=\"middle\" x=\"1084\" y=\"-303.3\" font-family=\"Times,serif\" font-size=\"14.00\"\u003egithub.com/Sirupsen/logrus\u003c/text\u003e\n\u003c/g\u003e\n\u003c!-- 1\u0026#45;\u0026gt;2 --\u003e\n\u003cg id=\"edge1\" class=\"edge\"\u003e\u003ctitle\u003e1\u0026#45;\u0026gt;2\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M551.702,-42.4134C677.012,-53.8131 854.183,-77.0633 908,-120 939.751,-145.331 918.809,-172.138 944,-204 970.872,-237.989 1011.6,-266.379 1042.03,-284.687\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"1040.33,-287.746 1050.72,-289.81 1043.88,-281.716 1040.33,-287.746\"/\u003e\n\u003c/g\u003e\n\u003c!-- 3 --\u003e\n\u003cg id=\"node4\" class=\"node\"\u003e\u003ctitle\u003e3\u003c/title\u003e\n\u003cellipse fill=\"paleturquoise\" stroke=\"paleturquoise\" cx=\"762\" cy=\"-18\" rx=\"129.977\" ry=\"18\"/\u003e\n\u003ctext text-anchor=\"middle\" x=\"762\" y=\"-14.3\" font-family=\"Times,serif\" font-size=\"14.00\"\u003egithub.com/garyburd/redigo/redis\u003c/text\u003e\n\u003c/g\u003e\n\u003c!-- 1\u0026#45;\u0026gt;3 --\u003e\n\u003cg id=\"edge2\" class=\"edge\"\u003e\u003ctitle\u003e1\u0026#45;\u0026gt;3\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M564.615,-26.6386C585.596,-25.7157 607.113,-24.7692 627.854,-23.8568\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"628.132,-27.3481 637.968,-23.4119 627.824,-20.3549 628.132,-27.3481\"/\u003e\n\u003c/g\u003e\n\u003c!-- 4 --\u003e\n\u003cg id=\"node5\" class=\"node\"\u003e\u003ctitle\u003e4\u003c/title\u003e\n\u003cellipse fill=\"paleturquoise\" stroke=\"paleturquoise\" cx=\"762\" cy=\"-357\" rx=\"128.077\" ry=\"18\"/\u003e\n\u003ctext text-anchor=\"middle\" x=\"762\" y=\"-353.3\" font-family=\"Times,serif\" font-size=\"14.00\"\u003egithub.com/wgliang/logcool/utils\u003c/text\u003e\n\u003c/g\u003e\n\u003c!-- 1\u0026#45;\u0026gt;4 --\u003e\n\u003cg id=\"edge3\" class=\"edge\"\u003e\u003ctitle\u003e1\u0026#45;\u0026gt;4\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M553.103,-42.2834C562.94,-46.781 572.09,-52.5799 580,-60 630.949,-107.793 581.899,-152.032 616,-213 644.02,-263.096 694.538,-307.387 727.925,-333.201\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"725.942,-336.09 736.02,-339.358 730.18,-330.519 725.942,-336.09\"/\u003e\n\u003c/g\u003e\n\u003c!-- 2\u0026#45;\u0026gt;0 --\u003e\n\u003cg id=\"edge53\" class=\"edge\"\u003e\u003ctitle\u003e2\u0026#45;\u0026gt;0\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M1170.4,-317.951C1188.5,-321.818 1207.2,-327.019 1224,-334 1293.4,-362.841 1363.59,-417.093 1401.15,-448.614\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"1399.2,-451.554 1409.09,-455.354 1403.73,-446.216 1399.2,-451.554\"/\u003e\n\u003c/g\u003e\n\u003c!-- 30 --\u003e\n\u003cg id=\"node31\" class=\"node\"\u003e\u003ctitle\u003e30\u003c/title\u003e\n\u003cellipse fill=\"paleturquoise\" stroke=\"paleturquoise\" cx=\"1084\" cy=\"-18\" rx=\"139.976\" ry=\"18\"/\u003e\n\u003ctext text-anchor=\"middle\" x=\"1084\" y=\"-14.3\" font-family=\"Times,serif\" font-size=\"14.00\"\u003egithub.com/garyburd/redigo/internal\u003c/text\u003e\n\u003c/g\u003e\n\u003c!-- 3\u0026#45;\u0026gt;30 --\u003e\n\u003cg id=\"edge52\" class=\"edge\"\u003e\u003ctitle\u003e3\u0026#45;\u0026gt;30\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M892.234,-18C905.983,-18 920.046,-18 933.998,-18\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"934.131,-21.5001 944.131,-18 934.131,-14.5001 934.131,-21.5001\"/\u003e\n\u003c/g\u003e\n\u003c!-- 4\u0026#45;\u0026gt;2 --\u003e\n\u003cg id=\"edge7\" class=\"edge\"\u003e\u003ctitle\u003e4\u0026#45;\u0026gt;2\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M848.334,-343.667C893.526,-336.605 948.964,-327.943 994.606,-320.812\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"995.147,-324.27 1004.49,-319.268 994.067,-317.353 995.147,-324.27\"/\u003e\n\u003c/g\u003e\n\u003c!-- 5 --\u003e\n\u003cg id=\"node6\" class=\"node\"\u003e\u003ctitle\u003e5\u003c/title\u003e\n\u003cellipse fill=\"paleturquoise\" stroke=\"paleturquoise\" cx=\"1084\" cy=\"-361\" rx=\"118.879\" ry=\"18\"/\u003e\n\u003ctext text-anchor=\"middle\" x=\"1084\" y=\"-357.3\" font-family=\"Times,serif\" font-size=\"14.00\"\u003egithub.com/codegangsta/inject\u003c/text\u003e\n\u003c/g\u003e\n\u003c!-- 4\u0026#45;\u0026gt;5 --\u003e\n\u003cg id=\"edge8\" class=\"edge\"\u003e\u003ctitle\u003e4\u0026#45;\u0026gt;5\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M889.932,-358.587C911.398,-358.855 933.695,-359.134 955.183,-359.402\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"955.282,-362.904 965.325,-359.529 955.37,-355.904 955.282,-362.904\"/\u003e\n\u003c/g\u003e\n\u003c!-- 8 --\u003e\n\u003cg id=\"node9\" class=\"node\"\u003e\u003ctitle\u003e8\u003c/title\u003e\n\u003cellipse fill=\"paleturquoise\" stroke=\"paleturquoise\" cx=\"1084\" cy=\"-177\" rx=\"95.5831\" ry=\"18\"/\u003e\n\u003ctext text-anchor=\"middle\" x=\"1084\" y=\"-173.3\" font-family=\"Times,serif\" font-size=\"14.00\"\u003egithub.com/golang/glog\u003c/text\u003e\n\u003c/g\u003e\n\u003c!-- 4\u0026#45;\u0026gt;8 --\u003e\n\u003cg id=\"edge9\" class=\"edge\"\u003e\u003ctitle\u003e4\u0026#45;\u0026gt;8\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M794.266,-339.413C852.874,-306.446 979.135,-235.424 1043.51,-199.211\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"1045.55,-202.083 1052.55,-194.13 1042.12,-195.982 1045.55,-202.083\"/\u003e\n\u003c/g\u003e\n\u003c!-- 6 --\u003e\n\u003cg id=\"node7\" class=\"node\"\u003e\u003ctitle\u003e6\u003c/title\u003e\n\u003cellipse fill=\"paleturquoise\" stroke=\"paleturquoise\" cx=\"419\" cy=\"-611\" rx=\"145.674\" ry=\"18\"/\u003e\n\u003ctext text-anchor=\"middle\" x=\"419\" y=\"-607.3\" font-family=\"Times,serif\" font-size=\"14.00\"\u003egithub.com/wgliang/logcool/input/file\u003c/text\u003e\n\u003c/g\u003e\n\u003c!-- 6\u0026#45;\u0026gt;2 --\u003e\n\u003cg id=\"edge4\" class=\"edge\"\u003e\u003ctitle\u003e6\u0026#45;\u0026gt;2\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M549.99,-603.05C561.005,-598.385 571.256,-592.178 580,-584 630.388,-536.873 565.59,-480.104 616,-433 712.149,-343.157 796.265,-453.511 908,-384 931.251,-369.535 920.936,-348.761 944,-334 954.456,-327.308 966.196,-322.205 978.307,-318.326\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"979.464,-321.634 988.081,-315.47 977.5,-314.915 979.464,-321.634\"/\u003e\n\u003c/g\u003e\n\u003c!-- 7 --\u003e\n\u003cg id=\"node8\" class=\"node\"\u003e\u003ctitle\u003e7\u003c/title\u003e\n\u003cellipse fill=\"paleturquoise\" stroke=\"paleturquoise\" cx=\"762\" cy=\"-495\" rx=\"110.48\" ry=\"18\"/\u003e\n\u003ctext text-anchor=\"middle\" x=\"762\" y=\"-491.3\" font-family=\"Times,serif\" font-size=\"14.00\"\u003egithub.com/fsnotify/fsnotify\u003c/text\u003e\n\u003c/g\u003e\n\u003c!-- 6\u0026#45;\u0026gt;7 --\u003e\n\u003cg id=\"edge5\" class=\"edge\"\u003e\u003ctitle\u003e6\u0026#45;\u0026gt;7\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M542.472,-601.372C555.771,-597.168 568.597,-591.525 580,-584 604.695,-567.703 591.776,-544.989 616,-528 628.744,-519.062 643.528,-512.504 658.685,-507.7\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"660.058,-510.946 668.681,-504.789 658.101,-504.225 660.058,-510.946\"/\u003e\n\u003c/g\u003e\n\u003c!-- 6\u0026#45;\u0026gt;4 --\u003e\n\u003cg id=\"edge6\" class=\"edge\"\u003e\u003ctitle\u003e6\u0026#45;\u0026gt;4\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M550.812,-603.337C561.593,-598.6 571.566,-592.298 580,-584 642.513,-522.498 555.253,-453.246 616,-390 623.884,-381.791 633.353,-375.431 643.627,-370.526\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"645.028,-373.734 652.844,-366.581 642.273,-367.299 645.028,-373.734\"/\u003e\n\u003c/g\u003e\n\u003c!-- 7\u0026#45;\u0026gt;0 --\u003e\n\u003cg id=\"edge62\" class=\"edge\"\u003e\u003ctitle\u003e7\u0026#45;\u0026gt;0\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M832.6,-481.12C856.714,-475.67 883.765,-468.831 908,-461 924.494,-455.67 927.003,-449.399 944,-446 1089.41,-416.918 1263.89,-440.527 1358.9,-458.163\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"1358.48,-461.647 1368.96,-460.064 1359.78,-454.768 1358.48,-461.647\"/\u003e\n\u003c/g\u003e\n\u003c!-- 9 --\u003e\n\u003cg id=\"node10\" class=\"node\"\u003e\u003ctitle\u003e9\u003c/title\u003e\n\u003cellipse fill=\"paleturquoise\" stroke=\"paleturquoise\" cx=\"1084\" cy=\"-473\" rx=\"123.478\" ry=\"18\"/\u003e\n\u003ctext text-anchor=\"middle\" x=\"1084\" y=\"-469.3\" font-family=\"Times,serif\" font-size=\"14.00\"\u003egithub.com/shirou/gopsutil/disk\u003c/text\u003e\n\u003c/g\u003e\n\u003c!-- 10 --\u003e\n\u003cg id=\"node11\" class=\"node\"\u003e\u003ctitle\u003e10\u003c/title\u003e\n\u003cellipse fill=\"paleturquoise\" stroke=\"paleturquoise\" cx=\"1430\" cy=\"-642\" rx=\"169.77\" ry=\"18\"/\u003e\n\u003ctext text-anchor=\"middle\" x=\"1430\" y=\"-638.3\" font-family=\"Times,serif\" font-size=\"14.00\"\u003egithub.com/shirou/gopsutil/internal/common\u003c/text\u003e\n\u003c/g\u003e\n\u003c!-- 9\u0026#45;\u0026gt;10 --\u003e\n\u003cg id=\"edge10\" class=\"edge\"\u003e\u003ctitle\u003e9\u0026#45;\u0026gt;10\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M1175.97,-485.045C1192.32,-488.779 1208.94,-493.652 1224,-500 1293.73,-529.386 1363.8,-584.837 1401.25,-617.064\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"1399.33,-620.032 1409.17,-623.956 1403.92,-614.752 1399.33,-620.032\"/\u003e\n\u003c/g\u003e\n\u003c!-- 9\u0026#45;\u0026gt;0 --\u003e\n\u003cg id=\"edge11\" class=\"edge\"\u003e\u003ctitle\u003e9\u0026#45;\u0026gt;0\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M1207.74,-473C1248.74,-473 1293.82,-473 1332.54,-473\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"1332.75,-476.5 1342.75,-473 1332.75,-469.5 1332.75,-476.5\"/\u003e\n\u003c/g\u003e\n\u003c!-- 11 --\u003e\n\u003cg id=\"node12\" class=\"node\"\u003e\u003ctitle\u003e11\u003c/title\u003e\n\u003cellipse fill=\"paleturquoise\" stroke=\"paleturquoise\" cx=\"419\" cy=\"-195\" rx=\"150.574\" ry=\"18\"/\u003e\n\u003ctext text-anchor=\"middle\" x=\"419\" y=\"-191.3\" font-family=\"Times,serif\" font-size=\"14.00\"\u003egithub.com/wgliang/logcool/input/stdin\u003c/text\u003e\n\u003c/g\u003e\n\u003c!-- 11\u0026#45;\u0026gt;2 --\u003e\n\u003cg id=\"edge12\" class=\"edge\"\u003e\u003ctitle\u003e11\u0026#45;\u0026gt;2\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M506.775,-209.64C530.518,-213.646 556.25,-217.989 580,-222 726.483,-246.736 896.958,-275.55 997.095,-292.477\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"996.715,-295.962 1007.16,-294.178 997.882,-289.06 996.715,-295.962\"/\u003e\n\u003c/g\u003e\n\u003c!-- 11\u0026#45;\u0026gt;4 --\u003e\n\u003cg id=\"edge13\" class=\"edge\"\u003e\u003ctitle\u003e11\u0026#45;\u0026gt;4\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M545.264,-204.937C557.62,-209.142 569.464,-214.7 580,-222 606.191,-240.148 592.807,-262.151 616,-284 640.513,-307.093 673.734,-324.532 702.193,-336.565\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"701.061,-339.884 711.642,-340.438 703.717,-333.407 701.061,-339.884\"/\u003e\n\u003c/g\u003e\n\u003c!-- 12 --\u003e\n\u003cg id=\"node13\" class=\"node\"\u003e\u003ctitle\u003e12\u003c/title\u003e\n\u003cellipse fill=\"paleturquoise\" stroke=\"paleturquoise\" cx=\"419\" cy=\"-503\" rx=\"156.772\" ry=\"18\"/\u003e\n\u003ctext text-anchor=\"middle\" x=\"419\" y=\"-499.3\" font-family=\"Times,serif\" font-size=\"14.00\"\u003egithub.com/wgliang/logcool/output/lexec\u003c/text\u003e\n\u003c/g\u003e\n\u003c!-- 12\u0026#45;\u0026gt;4 --\u003e\n\u003cg id=\"edge14\" class=\"edge\"\u003e\u003ctitle\u003e12\u0026#45;\u0026gt;4\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M549.858,-493.047C560.699,-488.751 570.952,-483.179 580,-476 612.459,-450.244 584.283,-416.664 616,-390 625.512,-382.003 636.573,-375.847 648.264,-371.122\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"649.58,-374.368 657.758,-367.632 647.164,-367.798 649.58,-374.368\"/\u003e\n\u003c/g\u003e\n\u003c!-- 13 --\u003e\n\u003cg id=\"node14\" class=\"node\"\u003e\u003ctitle\u003e13\u003c/title\u003e\n\u003cellipse fill=\"paleturquoise\" stroke=\"paleturquoise\" cx=\"419\" cy=\"-557\" rx=\"148.374\" ry=\"18\"/\u003e\n\u003ctext text-anchor=\"middle\" x=\"419\" y=\"-553.3\" font-family=\"Times,serif\" font-size=\"14.00\"\u003egithub.com/wgliang/logcool/filter/zeus\u003c/text\u003e\n\u003c/g\u003e\n\u003c!-- 13\u0026#45;\u0026gt;4 --\u003e\n\u003cg id=\"edge15\" class=\"edge\"\u003e\u003ctitle\u003e13\u0026#45;\u0026gt;4\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M550.618,-548.559C561.369,-543.965 571.392,-537.91 580,-530 627.308,-486.531 569.941,-434.791 616,-390 624.374,-381.856 634.318,-375.56 645.015,-370.713\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"646.645,-373.828 654.588,-366.817 644.006,-367.345 646.645,-373.828\"/\u003e\n\u003c/g\u003e\n\u003c!-- 14 --\u003e\n\u003cg id=\"node15\" class=\"node\"\u003e\u003ctitle\u003e14\u003c/title\u003e\n\u003cellipse fill=\"paleturquoise\" stroke=\"paleturquoise\" cx=\"419\" cy=\"-665\" rx=\"161.372\" ry=\"18\"/\u003e\n\u003ctext text-anchor=\"middle\" x=\"419\" y=\"-661.3\" font-family=\"Times,serif\" font-size=\"14.00\"\u003egithub.com/wgliang/logcool/input/collectd\u003c/text\u003e\n\u003c/g\u003e\n\u003c!-- 14\u0026#45;\u0026gt;2 --\u003e\n\u003cg id=\"edge16\" class=\"edge\"\u003e\u003ctitle\u003e14\u0026#45;\u0026gt;2\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M554.805,-655.189C564.023,-650.755 572.58,-645.118 580,-638 635.732,-584.534 559.977,-521.16 616,-468 711.302,-377.569 804.971,-503.519 908,-422 941.139,-395.78 911.333,-360.806 944,-334 952.819,-326.763 963.008,-321.263 973.781,-317.107\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"975.07,-320.365 983.379,-313.792 972.784,-313.749 975.07,-320.365\"/\u003e\n\u003c/g\u003e\n\u003c!-- 15 --\u003e\n\u003cg id=\"node16\" class=\"node\"\u003e\u003ctitle\u003e15\u003c/title\u003e\n\u003cellipse fill=\"paleturquoise\" stroke=\"paleturquoise\" cx=\"1084\" cy=\"-711\" rx=\"121.578\" ry=\"18\"/\u003e\n\u003ctext text-anchor=\"middle\" x=\"1084\" y=\"-707.3\" font-family=\"Times,serif\" font-size=\"14.00\"\u003egithub.com/shirou/gopsutil/cpu\u003c/text\u003e\n\u003c/g\u003e\n\u003c!-- 14\u0026#45;\u0026gt;15 --\u003e\n\u003cg id=\"edge17\" class=\"edge\"\u003e\u003ctitle\u003e14\u0026#45;\u0026gt;15\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M513.011,-679.678C545.516,-684.312 582.299,-689 616,-692 729.464,-702.1 858.922,-706.836 952.71,-709.054\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"952.74,-712.556 962.818,-709.287 952.901,-705.558 952.74,-712.556\"/\u003e\n\u003c/g\u003e\n\u003c!-- 14\u0026#45;\u0026gt;9 --\u003e\n\u003cg id=\"edge18\" class=\"edge\"\u003e\u003ctitle\u003e14\u0026#45;\u0026gt;9\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M550.522,-654.567C561.097,-650.35 571.113,-644.928 580,-638 611.391,-613.529 583.992,-579.658 616,-556 721.069,-478.34 784.49,-564.614 908,-522 925.726,-515.884 926.519,-506.784 944,-500 956.632,-495.097 970.269,-491.054 983.892,-487.728\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"984.844,-491.1 993.795,-485.43 983.262,-484.281 984.844,-491.1\"/\u003e\n\u003c/g\u003e\n\u003c!-- 16 --\u003e\n\u003cg id=\"node17\" class=\"node\"\u003e\u003ctitle\u003e16\u003c/title\u003e\n\u003cellipse fill=\"paleturquoise\" stroke=\"paleturquoise\" cx=\"1084\" cy=\"-619\" rx=\"123.478\" ry=\"18\"/\u003e\n\u003ctext text-anchor=\"middle\" x=\"1084\" y=\"-615.3\" font-family=\"Times,serif\" font-size=\"14.00\"\u003egithub.com/shirou/gopsutil/host\u003c/text\u003e\n\u003c/g\u003e\n\u003c!-- 14\u0026#45;\u0026gt;16 --\u003e\n\u003cg id=\"edge19\" class=\"edge\"\u003e\u003ctitle\u003e14\u0026#45;\u0026gt;16\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M513.011,-650.322C545.516,-645.688 582.299,-641 616,-638 728.685,-627.97 857.143,-623.229 950.772,-620.992\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"950.949,-624.489 960.865,-620.757 950.787,-617.491 950.949,-624.489\"/\u003e\n\u003c/g\u003e\n\u003c!-- 17 --\u003e\n\u003cg id=\"node18\" class=\"node\"\u003e\u003ctitle\u003e17\u003c/title\u003e\n\u003cellipse fill=\"paleturquoise\" stroke=\"paleturquoise\" cx=\"1084\" cy=\"-527\" rx=\"127.277\" ry=\"18\"/\u003e\n\u003ctext text-anchor=\"middle\" x=\"1084\" y=\"-523.3\" font-family=\"Times,serif\" font-size=\"14.00\"\u003egithub.com/shirou/gopsutil/mem\u003c/text\u003e\n\u003c/g\u003e\n\u003c!-- 14\u0026#45;\u0026gt;17 --\u003e\n\u003cg id=\"edge20\" class=\"edge\"\u003e\u003ctitle\u003e14\u0026#45;\u0026gt;17\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M528.848,-651.763C546.21,-648.193 563.783,-643.684 580,-638 597.273,-631.946 598.805,-624.272 616,-618 650.991,-605.236 868.492,-565.286 993.958,-542.794\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"994.717,-546.214 1003.94,-541.006 993.483,-539.323 994.717,-546.214\"/\u003e\n\u003c/g\u003e\n\u003c!-- 18 --\u003e\n\u003cg id=\"node19\" class=\"node\"\u003e\u003ctitle\u003e18\u003c/title\u003e\n\u003cellipse fill=\"paleturquoise\" stroke=\"paleturquoise\" cx=\"1084\" cy=\"-765\" rx=\"119.679\" ry=\"18\"/\u003e\n\u003ctext text-anchor=\"middle\" x=\"1084\" y=\"-761.3\" font-family=\"Times,serif\" font-size=\"14.00\"\u003egithub.com/shirou/gopsutil/net\u003c/text\u003e\n\u003c/g\u003e\n\u003c!-- 14\u0026#45;\u0026gt;18 --\u003e\n\u003cg id=\"edge21\" class=\"edge\"\u003e\u003ctitle\u003e14\u0026#45;\u0026gt;18\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M529.807,-678.12C546.877,-681.7 564.109,-686.242 580,-692 597.415,-698.31 598.414,-707.182 616,-713 726.333,-749.5 858.486,-761.48 954.006,-764.927\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"953.896,-768.425 964.007,-765.261 954.13,-761.429 953.896,-768.425\"/\u003e\n\u003c/g\u003e\n\u003c!-- 19 --\u003e\n\u003cg id=\"node20\" class=\"node\"\u003e\u003ctitle\u003e19\u003c/title\u003e\n\u003cellipse fill=\"paleturquoise\" stroke=\"paleturquoise\" cx=\"762\" cy=\"-665\" rx=\"135.376\" ry=\"18\"/\u003e\n\u003ctext text-anchor=\"middle\" x=\"762\" y=\"-661.3\" font-family=\"Times,serif\" font-size=\"14.00\"\u003egithub.com/shirou/gopsutil/process\u003c/text\u003e\n\u003c/g\u003e\n\u003c!-- 14\u0026#45;\u0026gt;19 --\u003e\n\u003cg id=\"edge22\" class=\"edge\"\u003e\u003ctitle\u003e14\u0026#45;\u0026gt;19\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M580.515,-665C592.593,-665 604.739,-665 616.708,-665\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"616.715,-668.5 626.715,-665 616.715,-661.5 616.715,-668.5\"/\u003e\n\u003c/g\u003e\n\u003c!-- 14\u0026#45;\u0026gt;4 --\u003e\n\u003cg id=\"edge23\" class=\"edge\"\u003e\u003ctitle\u003e14\u0026#45;\u0026gt;4\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M555.457,-655.287C564.47,-650.818 572.805,-645.147 580,-638 645.629,-572.807 561.431,-507.696 616,-433 635.206,-406.711 666.256,-388.731 694.706,-376.889\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"696.231,-380.049 704.233,-373.105 693.647,-373.543 696.231,-380.049\"/\u003e\n\u003c/g\u003e\n\u003c!-- 15\u0026#45;\u0026gt;10 --\u003e\n\u003cg id=\"edge49\" class=\"edge\"\u003e\u003ctitle\u003e15\u0026#45;\u0026gt;10\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M1157.11,-696.535C1210.27,-685.873 1282.9,-671.305 1339.72,-659.907\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"1340.66,-663.289 1349.78,-657.89 1339.29,-656.425 1340.66,-663.289\"/\u003e\n\u003c/g\u003e\n\u003c!-- 16\u0026#45;\u0026gt;10 --\u003e\n\u003cg id=\"edge24\" class=\"edge\"\u003e\u003ctitle\u003e16\u0026#45;\u0026gt;10\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M1196.69,-626.467C1222,-628.16 1249.3,-629.985 1275.99,-631.77\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"1275.97,-635.276 1286.19,-632.451 1276.44,-628.292 1275.97,-635.276\"/\u003e\n\u003c/g\u003e\n\u003c!-- 17\u0026#45;\u0026gt;10 --\u003e\n\u003cg id=\"edge50\" class=\"edge\"\u003e\u003ctitle\u003e17\u0026#45;\u0026gt;10\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M1134.65,-543.599C1196.37,-564.231 1301.65,-599.428 1368.16,-621.66\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"1367.08,-624.991 1377.68,-624.843 1369.3,-618.353 1367.08,-624.991\"/\u003e\n\u003c/g\u003e\n\u003c!-- 17\u0026#45;\u0026gt;0 --\u003e\n\u003cg id=\"edge51\" class=\"edge\"\u003e\u003ctitle\u003e17\u0026#45;\u0026gt;0\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M1170.03,-513.652C1225.08,-505.011 1296.25,-493.838 1350.05,-485.393\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"1350.89,-488.804 1360.23,-483.796 1349.81,-481.889 1350.89,-488.804\"/\u003e\n\u003c/g\u003e\n\u003c!-- 18\u0026#45;\u0026gt;10 --\u003e\n\u003cg id=\"edge55\" class=\"edge\"\u003e\u003ctitle\u003e18\u0026#45;\u0026gt;10\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M1168.54,-752.234C1187.02,-748.455 1206.35,-743.749 1224,-738 1283.28,-718.69 1347.81,-686.446 1388.32,-664.714\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"1390.21,-667.674 1397.34,-659.838 1386.88,-661.517 1390.21,-667.674\"/\u003e\n\u003c/g\u003e\n\u003c!-- 19\u0026#45;\u0026gt;15 --\u003e\n\u003cg id=\"edge56\" class=\"edge\"\u003e\u003ctitle\u003e19\u0026#45;\u0026gt;15\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M854.699,-678.182C895.905,-684.105 944.552,-691.098 986.329,-697.104\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"985.841,-700.569 996.237,-698.528 986.837,-693.64 985.841,-700.569\"/\u003e\n\u003c/g\u003e\n\u003c!-- 19\u0026#45;\u0026gt;16 --\u003e\n\u003cg id=\"edge57\" class=\"edge\"\u003e\u003ctitle\u003e19\u0026#45;\u0026gt;16\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M854.699,-651.818C895.562,-645.944 943.743,-639.018 985.285,-633.047\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"986.017,-636.477 995.417,-631.59 985.021,-629.549 986.017,-636.477\"/\u003e\n\u003c/g\u003e\n\u003c!-- 19\u0026#45;\u0026gt;10 --\u003e\n\u003cg id=\"edge58\" class=\"edge\"\u003e\u003ctitle\u003e19\u0026#45;\u0026gt;10\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M892.993,-660.511C997.26,-656.91 1144.47,-651.826 1258.24,-647.897\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"1258.57,-651.388 1268.44,-647.545 1258.33,-644.392 1258.57,-651.388\"/\u003e\n\u003c/g\u003e\n\u003c!-- 19\u0026#45;\u0026gt;17 --\u003e\n\u003cg id=\"edge59\" class=\"edge\"\u003e\u003ctitle\u003e19\u0026#45;\u0026gt;17\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M807.953,-647.925C837.733,-635.529 876.892,-617.095 908,-595 926.448,-581.897 924.206,-569.964 944,-559 956.408,-552.127 970.223,-546.728 984.193,-542.486\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"985.215,-545.835 993.875,-539.731 983.299,-539.102 985.215,-545.835\"/\u003e\n\u003c/g\u003e\n\u003c!-- 19\u0026#45;\u0026gt;18 --\u003e\n\u003cg id=\"edge60\" class=\"edge\"\u003e\u003ctitle\u003e19\u0026#45;\u0026gt;18\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M800.04,-682.382C836.109,-698.72 892.826,-722.862 944,-738 959.227,-742.504 975.619,-746.454 991.619,-749.843\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"991.017,-753.293 1001.52,-751.881 992.428,-746.436 991.017,-753.293\"/\u003e\n\u003c/g\u003e\n\u003c!-- 19\u0026#45;\u0026gt;0 --\u003e\n\u003cg id=\"edge61\" class=\"edge\"\u003e\u003ctitle\u003e19\u0026#45;\u0026gt;0\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M798.499,-647.605C834.355,-630.778 891.761,-605.848 944,-592 1065.39,-559.821 1102.49,-585.75 1224,-554 1281.53,-538.966 1344.76,-512.338 1385.56,-493.731\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"1387.05,-496.897 1394.67,-489.538 1384.13,-490.538 1387.05,-496.897\"/\u003e\n\u003c/g\u003e\n\u003c!-- 20 --\u003e\n\u003cg id=\"node21\" class=\"node\"\u003e\u003ctitle\u003e20\u003c/title\u003e\n\u003cellipse fill=\"paleturquoise\" stroke=\"paleturquoise\" cx=\"419\" cy=\"-87\" rx=\"147.574\" ry=\"18\"/\u003e\n\u003ctext text-anchor=\"middle\" x=\"419\" y=\"-83.3\" font-family=\"Times,serif\" font-size=\"14.00\"\u003egithub.com/wgliang/logcool/input/http\u003c/text\u003e\n\u003c/g\u003e\n\u003c!-- 20\u0026#45;\u0026gt;2 --\u003e\n\u003cg id=\"edge25\" class=\"edge\"\u003e\u003ctitle\u003e20\u0026#45;\u0026gt;2\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M512.54,-100.937C534.725,-104.741 558.277,-109.164 580,-114 596.209,-117.609 599.709,-120.78 616,-124 744.226,-149.342 793.778,-95.4574 908,-159 930.382,-171.451 925.557,-186.228 944,-204 975.948,-234.787 1017.31,-264.339 1046.58,-283.83\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"1044.98,-286.966 1055.25,-289.547 1048.83,-281.121 1044.98,-286.966\"/\u003e\n\u003c/g\u003e\n\u003c!-- 20\u0026#45;\u0026gt;8 --\u003e\n\u003cg id=\"edge26\" class=\"edge\"\u003e\u003ctitle\u003e20\u0026#45;\u0026gt;8\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M563.268,-90.7736C661.048,-95.2204 793.163,-104.906 908,-126 948.935,-133.519 993.998,-146.773 1028.14,-157.885\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"1027.33,-161.301 1037.92,-161.105 1029.52,-154.652 1027.33,-161.301\"/\u003e\n\u003c/g\u003e\n\u003c!-- 20\u0026#45;\u0026gt;4 --\u003e\n\u003cg id=\"edge27\" class=\"edge\"\u003e\u003ctitle\u003e20\u0026#45;\u0026gt;4\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M548.249,-95.7127C559.75,-100.199 570.585,-106.156 580,-114 615.971,-143.968 590.782,-173.553 616,-213 647.094,-261.637 697.238,-306.62 729.655,-332.946\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"727.501,-335.704 737.492,-339.228 731.879,-330.242 727.501,-335.704\"/\u003e\n\u003c/g\u003e\n\u003c!-- 21 --\u003e\n\u003cg id=\"node22\" class=\"node\"\u003e\u003ctitle\u003e21\u003c/title\u003e\n\u003cellipse fill=\"paleturquoise\" stroke=\"paleturquoise\" cx=\"762\" cy=\"-186\" rx=\"80.6858\" ry=\"18\"/\u003e\n\u003ctext text-anchor=\"middle\" x=\"762\" y=\"-182.3\" font-family=\"Times,serif\" font-size=\"14.00\"\u003egopkg.in/gomail.v2\u003c/text\u003e\n\u003c/g\u003e\n\u003c!-- 22 --\u003e\n\u003cg id=\"node23\" class=\"node\"\u003e\u003ctitle\u003e22\u003c/title\u003e\n\u003cellipse fill=\"paleturquoise\" stroke=\"paleturquoise\" cx=\"419\" cy=\"-249\" rx=\"147.574\" ry=\"18\"/\u003e\n\u003ctext text-anchor=\"middle\" x=\"419\" y=\"-245.3\" font-family=\"Times,serif\" font-size=\"14.00\"\u003egithub.com/wgliang/logcool/filter/split\u003c/text\u003e\n\u003c/g\u003e\n\u003c!-- 22\u0026#45;\u0026gt;4 --\u003e\n\u003cg id=\"edge28\" class=\"edge\"\u003e\u003ctitle\u003e22\u0026#45;\u0026gt;4\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M521.19,-262.078C540.905,-265.744 561.261,-270.327 580,-276 629.605,-291.018 683.462,-316.385 719.416,-334.735\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"718.118,-338.003 728.61,-339.474 721.325,-331.781 718.118,-338.003\"/\u003e\n\u003c/g\u003e\n\u003c!-- 23 --\u003e\n\u003cg id=\"node24\" class=\"node\"\u003e\u003ctitle\u003e23\u003c/title\u003e\n\u003cellipse fill=\"paleturquoise\" stroke=\"paleturquoise\" cx=\"419\" cy=\"-449\" rx=\"159.472\" ry=\"18\"/\u003e\n\u003ctext text-anchor=\"middle\" x=\"419\" y=\"-445.3\" font-family=\"Times,serif\" font-size=\"14.00\"\u003egithub.com/wgliang/logcool/output/stdout\u003c/text\u003e\n\u003c/g\u003e\n\u003c!-- 23\u0026#45;\u0026gt;4 --\u003e\n\u003cg id=\"edge29\" class=\"edge\"\u003e\u003ctitle\u003e23\u0026#45;\u0026gt;4\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M523.255,-435.394C542.595,-430.893 562.285,-424.92 580,-417 598.258,-408.837 597.851,-398.403 616,-390 631.374,-382.882 648.393,-377.244 665.204,-372.796\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"666.223,-376.149 675.065,-370.313 664.513,-369.361 666.223,-376.149\"/\u003e\n\u003c/g\u003e\n\u003c!-- 24 --\u003e\n\u003cg id=\"node25\" class=\"node\"\u003e\u003ctitle\u003e24\u003c/title\u003e\n\u003cellipse fill=\"paleturquoise\" stroke=\"paleturquoise\" cx=\"419\" cy=\"-719\" rx=\"128.877\" ry=\"18\"/\u003e\n\u003ctext text-anchor=\"middle\" x=\"419\" y=\"-715.3\" font-family=\"Times,serif\" font-size=\"14.00\"\u003egithub.com/wgliang/logcool/cmd\u003c/text\u003e\n\u003c/g\u003e\n\u003c!-- 24\u0026#45;\u0026gt;4 --\u003e\n\u003cg id=\"edge30\" class=\"edge\"\u003e\u003ctitle\u003e24\u0026#45;\u0026gt;4\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M544.013,-714.407C557.443,-709.405 569.881,-702.199 580,-692 651.02,-620.422 564.297,-554.569 616,-468 639.551,-428.567 682.886,-398.216 716.07,-379.296\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"718.09,-382.178 725.135,-374.265 714.693,-376.058 718.09,-382.178\"/\u003e\n\u003c/g\u003e\n\u003c!-- 25 --\u003e\n\u003cg id=\"node26\" class=\"node\"\u003e\u003ctitle\u003e25\u003c/title\u003e\n\u003cellipse fill=\"paleturquoise\" stroke=\"paleturquoise\" cx=\"762\" cy=\"-795\" rx=\"146.474\" ry=\"18\"/\u003e\n\u003ctext text-anchor=\"middle\" x=\"762\" y=\"-791.3\" font-family=\"Times,serif\" font-size=\"14.00\"\u003egithub.com/wgliang/logcool/utils/logo\u003c/text\u003e\n\u003c/g\u003e\n\u003c!-- 24\u0026#45;\u0026gt;25 --\u003e\n\u003cg id=\"edge31\" class=\"edge\"\u003e\u003ctitle\u003e24\u0026#45;\u0026gt;25\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M488.017,-734.333C525.721,-742.816 573.448,-753.528 616,-763 636.746,-767.618 659.168,-772.58 680.035,-777.186\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"679.3,-780.608 689.819,-779.345 680.808,-773.772 679.3,-780.608\"/\u003e\n\u003c/g\u003e\n\u003c!-- 26 --\u003e\n\u003cg id=\"node27\" class=\"node\"\u003e\u003ctitle\u003e26\u003c/title\u003e\n\u003cellipse fill=\"paleturquoise\" stroke=\"paleturquoise\" cx=\"419\" cy=\"-357\" rx=\"148.674\" ry=\"18\"/\u003e\n\u003ctext text-anchor=\"middle\" x=\"419\" y=\"-353.3\" font-family=\"Times,serif\" font-size=\"14.00\"\u003egithub.com/wgliang/logcool/filter/grok\u003c/text\u003e\n\u003c/g\u003e\n\u003c!-- 26\u0026#45;\u0026gt;4 --\u003e\n\u003cg id=\"edge32\" class=\"edge\"\u003e\u003ctitle\u003e26\u0026#45;\u0026gt;4\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M568.08,-357C586.582,-357 605.442,-357 623.769,-357\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"623.89,-360.5 633.89,-357 623.89,-353.5 623.89,-360.5\"/\u003e\n\u003c/g\u003e\n\u003c!-- 27 --\u003e\n\u003cg id=\"node28\" class=\"node\"\u003e\u003ctitle\u003e27\u003c/title\u003e\n\u003cellipse fill=\"paleturquoise\" stroke=\"paleturquoise\" cx=\"419\" cy=\"-141\" rx=\"157.872\" ry=\"18\"/\u003e\n\u003ctext text-anchor=\"middle\" x=\"419\" y=\"-137.3\" font-family=\"Times,serif\" font-size=\"14.00\"\u003egithub.com/wgliang/logcool/output/email\u003c/text\u003e\n\u003c/g\u003e\n\u003c!-- 27\u0026#45;\u0026gt;4 --\u003e\n\u003cg id=\"edge33\" class=\"edge\"\u003e\u003ctitle\u003e27\u0026#45;\u0026gt;4\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M542.98,-152.183C555.972,-156.131 568.587,-161.288 580,-168 602.078,-180.984 598.885,-193.945 616,-213 655.172,-256.613 704.184,-303.917 734.015,-331.978\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"731.842,-334.739 741.532,-339.023 736.629,-329.631 731.842,-334.739\"/\u003e\n\u003c/g\u003e\n\u003c!-- 27\u0026#45;\u0026gt;21 --\u003e\n\u003cg id=\"edge34\" class=\"edge\"\u003e\u003ctitle\u003e27\u0026#45;\u0026gt;21\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M523.237,-154.624C574.28,-161.36 634.903,-169.36 682.159,-175.596\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"681.964,-179.1 692.336,-176.939 682.88,-172.16 681.964,-179.1\"/\u003e\n\u003c/g\u003e\n\u003c!-- 28 --\u003e\n\u003cg id=\"node29\" class=\"node\"\u003e\u003ctitle\u003e28\u003c/title\u003e\n\u003cellipse fill=\"paleturquoise\" stroke=\"paleturquoise\" cx=\"111\" cy=\"-380\" rx=\"110.48\" ry=\"18\"/\u003e\n\u003ctext text-anchor=\"middle\" x=\"111\" y=\"-376.3\" font-family=\"Times,serif\" font-size=\"14.00\"\u003egithub.com/wgliang/logcool\u003c/text\u003e\n\u003c/g\u003e\n\u003c!-- 28\u0026#45;\u0026gt;24 --\u003e\n\u003cg id=\"edge35\" class=\"edge\"\u003e\u003ctitle\u003e28\u0026#45;\u0026gt;24\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M114.574,-398.065C123.344,-452.424 157.318,-615.438 258,-692 267.46,-699.194 278.147,-704.75 289.4,-709.012\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"288.377,-712.361 298.971,-712.296 290.649,-705.74 288.377,-712.361\"/\u003e\n\u003c/g\u003e\n\u003c!-- 28\u0026#45;\u0026gt;26 --\u003e\n\u003cg id=\"edge36\" class=\"edge\"\u003e\u003ctitle\u003e28\u0026#45;\u0026gt;26\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M211.772,-372.501C234.206,-370.815 258.383,-368.997 282.012,-367.221\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"282.389,-370.703 292.099,-366.463 281.864,-363.723 282.389,-370.703\"/\u003e\n\u003c/g\u003e\n\u003c!-- 29 --\u003e\n\u003cg id=\"node30\" class=\"node\"\u003e\u003ctitle\u003e29\u003c/title\u003e\n\u003cellipse fill=\"paleturquoise\" stroke=\"paleturquoise\" cx=\"419\" cy=\"-303\" rx=\"159.472\" ry=\"18\"/\u003e\n\u003ctext text-anchor=\"middle\" x=\"419\" y=\"-299.3\" font-family=\"Times,serif\" font-size=\"14.00\"\u003egithub.com/wgliang/logcool/filter/metrics\u003c/text\u003e\n\u003c/g\u003e\n\u003c!-- 28\u0026#45;\u0026gt;29 --\u003e\n\u003cg id=\"edge37\" class=\"edge\"\u003e\u003ctitle\u003e28\u0026#45;\u0026gt;29\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M154.567,-363.368C183.398,-352.615 222.552,-338.997 258,-330 274.434,-325.829 291.985,-322.127 309.218,-318.903\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"310.108,-322.299 319.318,-317.061 308.852,-315.413 310.108,-322.299\"/\u003e\n\u003c/g\u003e\n\u003c!-- 28\u0026#45;\u0026gt;22 --\u003e\n\u003cg id=\"edge38\" class=\"edge\"\u003e\u003ctitle\u003e28\u0026#45;\u0026gt;22\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M131.04,-362.025C157.37,-338.268 207.405,-296.979 258,-276 270.564,-270.791 284.08,-266.586 297.742,-263.192\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"298.764,-266.547 307.704,-260.861 297.17,-259.731 298.764,-266.547\"/\u003e\n\u003c/g\u003e\n\u003c!-- 28\u0026#45;\u0026gt;13 --\u003e\n\u003cg id=\"edge39\" class=\"edge\"\u003e\u003ctitle\u003e28\u0026#45;\u0026gt;13\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M123.742,-398.119C145.781,-430.484 196.692,-497.845 258,-530 268.33,-535.418 279.504,-539.789 290.979,-543.311\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"290.1,-546.7 300.676,-546.074 292.018,-539.968 290.1,-546.7\"/\u003e\n\u003c/g\u003e\n\u003c!-- 28\u0026#45;\u0026gt;14 --\u003e\n\u003cg id=\"edge40\" class=\"edge\"\u003e\u003ctitle\u003e28\u0026#45;\u0026gt;14\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M116.412,-398.016C129.149,-445.9 170.771,-576.838 258,-638 264.963,-642.882 272.509,-646.988 280.403,-650.434\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"279.23,-653.734 289.816,-654.181 281.82,-647.231 279.23,-653.734\"/\u003e\n\u003c/g\u003e\n\u003c!-- 28\u0026#45;\u0026gt;6 --\u003e\n\u003cg id=\"edge41\" class=\"edge\"\u003e\u003ctitle\u003e28\u0026#45;\u0026gt;6\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M119.169,-398.084C136.331,-438.804 183.941,-537.734 258,-584 267.055,-589.657 276.935,-594.23 287.198,-597.917\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"286.125,-601.249 296.718,-601.06 288.319,-594.601 286.125,-601.249\"/\u003e\n\u003c/g\u003e\n\u003c!-- 28\u0026#45;\u0026gt;20 --\u003e\n\u003cg id=\"edge42\" class=\"edge\"\u003e\u003ctitle\u003e28\u0026#45;\u0026gt;20\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M116.142,-361.795C128.323,-312.756 168.908,-177.335 258,-114 265.839,-108.428 274.432,-103.861 283.44,-100.132\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"284.841,-103.344 292.963,-96.541 282.371,-96.7943 284.841,-103.344\"/\u003e\n\u003c/g\u003e\n\u003c!-- 28\u0026#45;\u0026gt;11 --\u003e\n\u003cg id=\"edge43\" class=\"edge\"\u003e\u003ctitle\u003e28\u0026#45;\u0026gt;11\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M122.821,-361.975C144.078,-328.313 194.768,-256.217 258,-222 267.869,-216.66 278.54,-212.328 289.525,-208.819\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"290.65,-212.136 299.247,-205.944 288.665,-205.424 290.65,-212.136\"/\u003e\n\u003c/g\u003e\n\u003c!-- 28\u0026#45;\u0026gt;27 --\u003e\n\u003cg id=\"edge44\" class=\"edge\"\u003e\u003ctitle\u003e28\u0026#45;\u0026gt;27\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M118.709,-361.847C135.215,-319.95 182.064,-216.399 258,-168 265.934,-162.943 274.521,-158.746 283.456,-155.271\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"284.64,-158.565 292.88,-151.905 282.285,-151.972 284.64,-158.565\"/\u003e\n\u003c/g\u003e\n\u003c!-- 28\u0026#45;\u0026gt;12 --\u003e\n\u003cg id=\"edge45\" class=\"edge\"\u003e\u003ctitle\u003e28\u0026#45;\u0026gt;12\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M132.686,-397.678C159.652,-419.713 209.155,-456.806 258,-476 270.223,-480.803 283.299,-484.752 296.514,-487.999\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"296.101,-491.496 306.634,-490.347 297.684,-484.677 296.101,-491.496\"/\u003e\n\u003c/g\u003e\n\u003c!-- 28\u0026#45;\u0026gt;1 --\u003e\n\u003cg id=\"edge46\" class=\"edge\"\u003e\u003ctitle\u003e28\u0026#45;\u0026gt;1\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M114.358,-361.879C122.582,-306.56 155.332,-138.857 258,-60 264.744,-54.82 272.123,-50.4861 279.892,-46.871\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"281.327,-50.0644 289.178,-42.9496 278.604,-43.6158 281.327,-50.0644\"/\u003e\n\u003c/g\u003e\n\u003c!-- 28\u0026#45;\u0026gt;23 --\u003e\n\u003cg id=\"edge47\" class=\"edge\"\u003e\u003ctitle\u003e28\u0026#45;\u0026gt;23\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M169.743,-395.352C196.513,-402.285 228.8,-410.384 258,-417 280.141,-422.016 304.1,-427.028 326.568,-431.546\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"325.942,-434.99 336.434,-433.518 327.314,-428.126 325.942,-434.99\"/\u003e\n\u003c/g\u003e\n\u003c!-- 28\u0026#45;\u0026gt;4 --\u003e\n\u003cg id=\"edge48\" class=\"edge\"\u003e\u003ctitle\u003e28\u0026#45;\u0026gt;4\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M220.028,-383.292C232.825,-383.583 245.703,-383.832 258,-384 401.098,-385.96 437.281,-394.586 580,-384 610.327,-381.751 643.278,-377.409 672.652,-372.854\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"673.552,-376.255 682.882,-371.237 672.459,-369.341 673.552,-376.255\"/\u003e\n\u003c/g\u003e\n\u003c!-- 29\u0026#45;\u0026gt;4 --\u003e\n\u003cg id=\"edge54\" class=\"edge\"\u003e\u003ctitle\u003e29\u0026#45;\u0026gt;4\u003c/title\u003e\n\u003cpath fill=\"none\" stroke=\"black\" d=\"M512.28,-317.613C559.973,-325.166 618.092,-334.369 666.152,-341.98\"/\u003e\n\u003cpolygon fill=\"black\" stroke=\"black\" points=\"665.823,-345.472 676.247,-343.579 666.918,-338.558 665.823,-345.472\"/\u003e\n\u003c/g\u003e\n\u003c/g\u003e\n\u003c/svg\u003e\n","errors":null}},"weight":0,"percentage":98,"error":""},"DepthTips":{"name":"Depth","description":"Computing all [.go] file's max depth","summaries":{"github.com/wgliang/logcool":{"name":"github.com/wgliang/logcool","description":"0","errors":[{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/logcool.go:35:1"}]},"github.com/wgliang/logcool/cmd":{"name":"github.com/wgliang/logcool/cmd","description":"0","errors":[{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/cmd/cmd.go:67:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/cmd/cmd.go:44:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/cmd/cmd.go:104:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/cmd/cmd.go:33:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/cmd/cmd.go:22:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/cmd/cmd_test.go:39:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/cmd/cmd.go:95:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/cmd/cmd.go:85:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/cmd/cmd_test.go:47:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/cmd/cmd_test.go:35:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/cmd/cmd_test.go:31:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/cmd/cmd_test.go:8:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/cmd/cmd_test.go:51:1"}]},"github.com/wgliang/logcool/filter/grok":{"name":"github.com/wgliang/logcool/filter/grok","description":"0","errors":[{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/grok/grok_test.go:25:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/grok/grok_test.go:16:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/grok/grok.go:44:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/grok/grok.go:26:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/grok/grok_test.go:12:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/grok/grok.go:21:1"}]},"github.com/wgliang/logcool/filter/metrics":{"name":"github.com/wgliang/logcool/filter/metrics","description":"0","errors":[{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/metrics/metrics.go:50:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/metrics/metrics_test.go:25:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/metrics/metrics_test.go:16:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/metrics/metrics.go:30:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/metrics/metrics_test.go:12:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/metrics/metrics.go:25:1"}]},"github.com/wgliang/logcool/filter/split":{"name":"github.com/wgliang/logcool/filter/split","description":"0","errors":[{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/split/split_test.go:25:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/split/split_test.go:16:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/split/split.go:45:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/split/split.go:26:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/split/split_test.go:12:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/split/split.go:21:1"}]},"github.com/wgliang/logcool/filter/zeus":{"name":"github.com/wgliang/logcool/filter/zeus","description":"0","errors":[{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/zeus/zeus_test.go:25:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/zeus/zeus_test.go:16:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/zeus/zeus.go:43:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/zeus/zeus.go:25:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/zeus/zeus_test.go:12:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/filter/zeus/zeus.go:20:1"}]},"github.com/wgliang/logcool/input/collectd":{"name":"github.com/wgliang/logcool/input/collectd","description":"0","errors":[{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/collectd/collectd.go:136:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/collectd/collectd.go:110:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/collectd/collectd_test.go:24:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/collectd/collectd_test.go:15:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/collectd/collectd.go:184:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/collectd/collectd.go:173:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/collectd/collectd.go:239:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/collectd/collectd.go:131:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/collectd/collectd.go:198:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/collectd/collectd_test.go:11:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/collectd/collectd.go:280:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/collectd/collectd.go:233:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/collectd/collectd.go:105:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/collectd/collectd.go:214:1"}]},"github.com/wgliang/logcool/input/file":{"name":"github.com/wgliang/logcool/input/file","description":"0","errors":[{"line_number":6,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/file/file.go:222:1"},{"line_number":5,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/file/file.go:403:1"},{"line_number":4,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/file/file.go:369:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/file/file.go:449:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/file/file.go:328:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/file/file.go:141:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/file/file.go:167:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/file/file.go:158:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/file/file.go:56:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/file/file_test.go:24:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/file/file.go:340:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/file/file.go:84:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/file/file.go:114:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/file/file.go:355:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/file/file_test.go:15:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/file/file.go:51:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/file/file_test.go:11:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/file/file.go:79:1"}]},"github.com/wgliang/logcool/input/http":{"name":"github.com/wgliang/logcool/input/http","description":"0","errors":[{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/http/http.go:84:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/http/http.go:65:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/http/http.go:35:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/http/http_test.go:13:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/http/http_test.go:41:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/http/http_test.go:32:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/http/http.go:60:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/http/http.go:31:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/http/http_test.go:28:1"}]},"github.com/wgliang/logcool/input/stdin":{"name":"github.com/wgliang/logcool/input/stdin","description":"0","errors":[{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/stdin/stdin.go:57:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/stdin/stdin_test.go:15:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/stdin/stdin.go:32:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/stdin/stdin_test.go:24:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/stdin/stdin.go:27:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/stdin/stdin_test.go:11:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/stdin/stdin.go:53:1"}]},"github.com/wgliang/logcool/output/email":{"name":"github.com/wgliang/logcool/output/email","description":"0","errors":[{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/email/email_test.go:16:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/email/email.go:55:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/email/email.go:33:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/email/email_test.go:34:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/email/email.go:28:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/email/email_test.go:12:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/email/email.go:50:1"}]},"github.com/wgliang/logcool/output/lexec":{"name":"github.com/wgliang/logcool/output/lexec","description":"0","errors":[{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/lexec/lexec_test.go:29:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/lexec/lexec_test.go:16:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/lexec/lexec.go:43:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/lexec/lexec.go:26:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/lexec/lexec_test.go:12:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/lexec/lexec.go:21:1"}]},"github.com/wgliang/logcool/output/redis":{"name":"github.com/wgliang/logcool/output/redis","description":"0","errors":[{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/redis/redis.go:106:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/redis/redis.go:38:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/redis/redis.go:72:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/redis/redis.go:65:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/redis/redis_test.go:36:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/redis/redis_test.go:17:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/redis/redis.go:60:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/redis/redis.go:33:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/redis/redis_test.go:13:1"}]},"github.com/wgliang/logcool/output/stdout":{"name":"github.com/wgliang/logcool/output/stdout","description":"0","errors":[{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/stdout/stdout_test.go:29:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/stdout/stdout_test.go:16:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/stdout/stdout.go:42:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/stdout/stdout.go:25:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/stdout/stdout_test.go:12:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/stdout/stdout.go:20:1"}]},"github.com/wgliang/logcool/utils":{"name":"github.com/wgliang/logcool/utils","description":"0","errors":[{"line_number":6,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/output.go:40:1"},{"line_number":4,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/filter.go:39:1"},{"line_number":3,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/input.go:52:1"},{"line_number":3,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/filter.go:60:1"},{"line_number":3,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config.go:74:1"},{"line_number":3,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/output.go:63:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/logevent.go:131:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/logevent.go:102:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config.go:187:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config.go:160:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/logevent.go:62:1"},{"line_number":2,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/logevent.go:76:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config.go:143:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config.go:118:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config.go:209:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/logevent_test.go:95:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/input.go:39:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/logevent.go:49:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/logevent_test.go:26:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config.go:98:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/logevent.go:29:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/logevent.go:85:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/logevent_test.go:42:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/input_test.go:14:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/filter_test.go:14:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/output_test.go:14:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/logevent.go:118:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config_test.go:67:1"},{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config.go:88:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/logevent.go:43:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/logevent.go:37:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/filter.go:28:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/logevent_test.go:113:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config_test.go:33:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config.go:65:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/logevent_test.go:12:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/filter.go:33:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/logevent_test.go:56:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config.go:108:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/logevent_test.go:75:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config_test.go:84:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config.go:70:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/output.go:29:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config_test.go:19:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config_test.go:63:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config_test.go:37:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/filter_test.go:10:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/logevent_test.go:122:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config_test.go:50:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config_test.go:10:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/input_test.go:10:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/output.go:34:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config.go:113:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/output_test.go:10:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/input.go:28:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/config_test.go:26:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/input.go:33:1"}]},"github.com/wgliang/logcool/utils/logo":{"name":"github.com/wgliang/logcool/utils/logo","description":"0","errors":[{"line_number":1,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/logo/logo.go:24:1"},{"line_number":0,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/utils/logo/logo.go:39:1"}]}},"weight":0.2,"percentage":78,"error":""},"ImportPackagesTips":{"name":"ImportPackages","description":"Check the project variables, functions, etc. naming spelling is wrong.","summaries":{"github.com/wgliang/logcool/cmd":{"name":"github.com/wgliang/logcool/cmd","description":"","errors":null},"github.com/wgliang/logcool/filter/grok":{"name":"github.com/wgliang/logcool/filter/grok","description":"","errors":null},"github.com/wgliang/logcool/filter/metrics":{"name":"github.com/wgliang/logcool/filter/metrics","description":"","errors":null},"github.com/wgliang/logcool/filter/split":{"name":"github.com/wgliang/logcool/filter/split","description":"","errors":null},"github.com/wgliang/logcool/filter/zeus":{"name":"github.com/wgliang/logcool/filter/zeus","description":"","errors":null},"github.com/wgliang/logcool/input/collectd":{"name":"github.com/wgliang/logcool/input/collectd","description":"","errors":null},"github.com/wgliang/logcool/input/file":{"name":"github.com/wgliang/logcool/input/file","description":"","errors":null},"github.com/wgliang/logcool/input/http":{"name":"github.com/wgliang/logcool/input/http","description":"","errors":null},"github.com/wgliang/logcool/input/stdin":{"name":"github.com/wgliang/logcool/input/stdin","description":"","errors":null},"github.com/wgliang/logcool/output/email":{"name":"github.com/wgliang/logcool/output/email","description":"","errors":null},"github.com/wgliang/logcool/output/lexec":{"name":"github.com/wgliang/logcool/output/lexec","description":"","errors":null},"github.com/wgliang/logcool/output/redis":{"name":"github.com/wgliang/logcool/output/redis","description":"","errors":null},"github.com/wgliang/logcool/output/stdout":{"name":"github.com/wgliang/logcool/output/stdout","description":"","errors":null},"github.com/wgliang/logcool/utils":{"name":"github.com/wgliang/logcool/utils","description":"","errors":null}},"weight":0,"percentage":50,"error":""},"InterfacerTips":{"name":"Interfacer","description":"Suggests interface types. In other words, it warns about the usage of types that are more specific than necessary.","summaries":{},"weight":0.06,"percentage":100,"error":""},"SimpleTips":{"name":"Simple","description":"All golang code hints that can be optimized and give suggestions for changes.","summaries":{"email":{"name":"email","description":"","errors":[{"line_number":79,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/output/email/email.go:79:2: 'if err != nil { return err }; return nil' can be simplified to 'return err'"}]},"file":{"name":"file","description":"","errors":[{"line_number":150,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/input/file/file.go:150:6: should use !bytes.Equal(raw, ic.sinceLastInfos) instead"}]},"logcool":{"name":"logcool","description":"","errors":[{"line_number":38,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/logcool.go:38:5: should omit comparison to bool constant, can be simplified to *version"},{"line_number":43,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/logcool.go:43:5: should omit comparison to bool constant, can be simplified to *help"},{"line_number":49,"error_string":"/home/agustin/gocode/src/github.com/wgliang/logcool/logcool.go:49:5: should omit comparison to bool constant, can be simplified to *std"}]}},"weight":0.1,"percentage":94,"error":""},"SpellCheckTips":{"name":"SpellCheck","description":"Check the project variables, functions, etc. naming spelling is wrong.","summaries":{},"weight":0.1,"percentage":100,"error":""},"UnitTestTips":{"name":"UnitTest","description":"Run all valid TEST in your golang package.And will measure from both coverage and time-consuming.","summaries":{"github.com/wgliang/logcool/cmd":{"name":"github.com/wgliang/logcool/cmd","description":"{\"is_pass\":true,\"coverage\":\"58.0%\",\"time\":1.077}","errors":null},"github.com/wgliang/logcool/filter/grok":{"name":"github.com/wgliang/logcool/filter/grok","description":"{\"is_pass\":true,\"coverage\":\"80.0%\",\"time\":1.011}","errors":null},"github.com/wgliang/logcool/filter/metrics":{"name":"github.com/wgliang/logcool/filter/metrics","description":"{\"is_pass\":true,\"coverage\":\"88.2%\",\"time\":1.034}","errors":null},"github.com/wgliang/logcool/filter/split":{"name":"github.com/wgliang/logcool/filter/split","description":"{\"is_pass\":true,\"coverage\":\"92.3%\",\"time\":1.05}","errors":null},"github.com/wgliang/logcool/filter/zeus":{"name":"github.com/wgliang/logcool/filter/zeus","description":"{\"is_pass\":true,\"coverage\":\"83.3%\",\"time\":1.032}","errors":null},"github.com/wgliang/logcool/input/collectd":{"name":"github.com/wgliang/logcool/input/collectd","description":"{\"is_pass\":true,\"coverage\":\"92.0%\",\"time\":6.023}","errors":null},"github.com/wgliang/logcool/input/file":{"name":"github.com/wgliang/logcool/input/file","description":"{\"is_pass\":true,\"coverage\":\"9.5%\",\"time\":6.011}","errors":null},"github.com/wgliang/logcool/input/http":{"name":"github.com/wgliang/logcool/input/http","description":"{\"is_pass\":true,\"coverage\":\"81.1%\",\"time\":2.019}","errors":null},"github.com/wgliang/logcool/input/stdin":{"name":"github.com/wgliang/logcool/input/stdin","description":"{\"is_pass\":true,\"coverage\":\"75.0%\",\"time\":6.044}","errors":null},"github.com/wgliang/logcool/output/email":{"name":"github.com/wgliang/logcool/output/email","description":"{\"is_pass\":true,\"coverage\":\"84.0%\",\"time\":6.017}","errors":null},"github.com/wgliang/logcool/output/lexec":{"name":"github.com/wgliang/logcool/output/lexec","description":"{\"is_pass\":true,\"coverage\":\"80.0%\",\"time\":6.015}","errors":null},"github.com/wgliang/logcool/output/redis":{"name":"github.com/wgliang/logcool/output/redis","description":"{\"is_pass\":true,\"coverage\":\"28.2%\",\"time\":1.024}","errors":null},"github.com/wgliang/logcool/output/stdout":{"name":"github.com/wgliang/logcool/output/stdout","description":"{\"is_pass\":true,\"coverage\":\"81.8%\",\"time\":6.017}","errors":null},"github.com/wgliang/logcool/utils":{"name":"github.com/wgliang/logcool/utils","description":"{\"is_pass\":false,\"coverage\":\"0%\",\"time\":0}","errors":null}},"weight":0.4,"percentage":66.67142857142856,"error":""}},"issues":40,"time_stamp":"2017-07-27 11:18:32"}`

func Test_Json2Html(t *testing.T) {
	var r Reporter
	err := jsoniter.Unmarshal([]byte(structJson), &r)
	if err != nil {
		t.Error(err)
	}

	r.ReportFormat = "html"
	r.ReportPath = "./"
	r.HtmlTemplate = DefaultTpl

	if err := r.Render(); err != nil {
		t.Fail()
	}
}

func Test_SaveAsJson(t *testing.T) {
	var r Reporter
	err := jsoniter.Unmarshal([]byte(structJson), &r)
	if err != nil {
		t.Error(err)
	}

	r.ReportFormat = "json"
	r.ReportPath = "./"
	r.HtmlTemplate = DefaultTpl

	if err := r.Render(); err != nil {
		t.Fail()
	}
}

func Test_DisplayAsText(t *testing.T) {
	var r Reporter
	err := jsoniter.Unmarshal([]byte(structJson), &r)
	if err != nil {
		t.Error(err)
	}

	r.ReportFormat = "text"
	r.ReportPath = "./"
	r.HtmlTemplate = DefaultTpl

	if err := r.Render(); err != nil {
		t.Fail()
	}
}
