#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# PyKaldi documentation build configuration file, created by
# sphinx-quickstart on Tue Aug 22 22:34:13 2017.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import os
# import sys
# sys.path.insert(0, os.path.abspath('../kaldi'))

import kaldi

# -- General configuration ------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.autosummary',
    'sphinx.ext.napoleon',
    'sphinx.ext.intersphinx',
    'sphinx.ext.todo',
    'sphinx.ext.viewcode',
    'sphinx.ext.mathjax',
    'sphinx.ext.githubpages'
    # 'sphinxcontrib.doxylink'
    ]

napoleon_use_ivar = True

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = '.rst'

# The master toctree document.
master_doc = 'index'

# The name of the default reST role (builtin or Sphinx extension)
default_role = 'py:obj'

# General information about the project.
project = 'PyKaldi'
copyright = '2017-2018, Doğan Can, Victor Martinez'
author = 'Doğan Can, Victor Martinez'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
version = kaldi.__version__
# The full version, including alpha/beta/rc tags.
release = kaldi.__version__

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This patterns also effect to html_static_path and html_extra_path
exclude_patterns = []

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = True


# -- Options for HTML output ----------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = 'sphinx_rtd_theme'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
# html_theme_options = {
#     'github_user': 'pykaldi',
#     'github_repo': 'pykaldi',
#     'github_banner': True
# }

html_theme_options = {
    'logo_only': True
}

html_logo = "_static/pykaldi-logo-light.png"

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

# html_style_path = '_static/pykaldi-theme.css'
html_context = {
    'css_files': [
        'https://fonts.googleapis.com/css?family=Lato',
        '_static/pykaldi-theme.css'
    ],
}

# Custom sidebar templates, must be a dictionary that maps document names
# to template names.
#
# This is required for the alabaster theme
# refs: http://alabaster.readthedocs.io/en/latest/installation.html#sidebars
# html_sidebars = {
#     '**': [
#         'about.html',
#         'globaltoc.html',
#         'relations.html',  # needs 'show_related': True theme option to display
#         'searchbox.html'
#     ]
# }


autosummary_generate = True

# Order or members in documentation
# autodoc_member_order = 'alphabetical'

# List of autodoc directive flags that should be
# automatically applied to all autodoc directives
autodoc_default_flags = ['members', 'undoc-members', 'inherited-members']

# Append __init__ docstring to class docstring.
autoclass_content = 'both'

# Custom handler for including/excluding members in documentation.
def skip_member_handler(app, what, name, obj, skip, options):
    # Document __init__ methods.
    # if name == "__init__":
    #     return False

    # Skip upcasts.
    if name.startswith("as_"):
        return True
    return None


from sphinx.ext import autodoc

class ConstantDataDocumenter(autodoc.DataDocumenter):
    objtype = "constant"
    directivetype = "data"

    def get_doc(self, encoding=None, ignore=1):
        return []

def setup(app):
    app.connect("autodoc-skip-member", skip_member_handler)
    app.add_autodocumenter(ConstantDataDocumenter)


# -- Options for HTMLHelp output ------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = 'PyKaldiDoc'

# Example configuration for intersphinx: refer to the Python standard library.
intersphinx_mapping = {
    'python': ('https://docs.python.org/', None),
    'numpy': ('http://docs.scipy.org/doc/numpy/', None),
}

# Doxylink configuration for linking to kaldi documentation.
# doxylink = { 'kaldi': ('/home/dogan/tools/kaldi/src/kaldi.tag',
#                        'http://kaldi-asr.org/doc/') }

# -- A patch that prevents Sphinx from cross-referencing ivar tags -------
# See http://stackoverflow.com/a/41184353/3343043

from docutils import nodes
from sphinx.util.docfields import TypedField
from sphinx import addnodes


def patched_make_field(self, types, domain, items, **kw):
    # `kw` catches `env=None` needed for newer sphinx while maintaining
    #  backwards compatibility when passed along further down!

    # type: (List, unicode, Tuple) -> nodes.field
    def handle_item(fieldarg, content):
        par = nodes.paragraph()
        par += addnodes.literal_strong('', fieldarg)  # Patch: this line added
        # par.extend(self.make_xrefs(self.rolename, domain, fieldarg,
        #                           addnodes.literal_strong))
        if fieldarg in types:
            par += nodes.Text(' (')
            # NOTE: using .pop() here to prevent a single type node to be
            # inserted twice into the doctree, which leads to
            # inconsistencies later when references are resolved
            fieldtype = types.pop(fieldarg)
            if len(fieldtype) == 1 and isinstance(fieldtype[0], nodes.Text):
                typename = u''.join(n.astext() for n in fieldtype)
                typename = typename.replace('int', 'python:int')
                typename = typename.replace('long', 'python:long')
                typename = typename.replace('float', 'python:float')
                typename = typename.replace('type', 'python:type')
                par.extend(self.make_xrefs(self.typerolename, domain, typename,
                                           addnodes.literal_emphasis, **kw))
            else:
                par += fieldtype
            par += nodes.Text(')')
        par += nodes.Text(' -- ')
        par += content
        return par

    fieldname = nodes.field_name('', self.label)
    if len(items) == 1 and self.can_collapse:
        fieldarg, content = items[0]
        bodynode = handle_item(fieldarg, content)
    else:
        bodynode = self.list_type()
        for fieldarg, content in items:
            bodynode += nodes.list_item('', handle_item(fieldarg, content))
    fieldbody = nodes.field_body('', bodynode)
    return nodes.field('', fieldname, fieldbody)

TypedField.make_field = patched_make_field


# -- A patch that prevents Sphinx from grouping index entries -------
import re
from sphinx.environment.adapters import indexentries

class IndexEntries(indexentries.IndexEntries):
    def create_index(self, builder, group_entries=False,
                     _fixre=re.compile(r'(.*) ([(][^()]*[)])')):
        return super(IndexEntries, self).create_index(builder, group_entries,
                                                      _fixre)

indexentries.IndexEntries = IndexEntries
