<?php
/**
 * 此事件将在请求支付方的 api 前抛出。
 *
 * Created by PhpStorm
 * User: Alex
 * Date: 2021-08-22 21:14
 * E-mail: <276558492@qq.com>
 */
declare(strict_types=1);

namespace Pudongping\GlobalPay\Events;

class ApiRequestingEvent extends BaseEvent
{

    /**
     * Endpoint
     *
     * @var string
     */
    public $endpoint;

    /**
     * Payload
     *
     * @var array
     */
    public $payload;

    /**
     * Bootstrap
     *
     * ApiRequestingEvent constructor.
     * @param string $driver  支付机构
     * @param string $gateway  支付网关
     * @param string $endpoint  支付的 url endpoint
     * @param array $payload  数据
     */
    public function __construct(string $driver, string $gateway, string $endpoint, array $payload)
    {
        $this->endpoint = $endpoint;
        $this->payload = $payload;

        parent::__construct($driver, $gateway);
    }

}