+++
date = "2015-09-30T10:26:00-04:00"
discipline = "Mezzo-soprano"
lastmod = "2015-09-30T10:26:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1443623033234/presse-wm3.jpg.jpg"
primary_image_credit = "Photo: Nomi Baumgartl"
publishDate = "2015-09-30T10:26:00-04:00"
related_companies = ["scene/companies/bayerische-staatsoper.md","scene/companies/the-metropolitan-opera.md","scene/companies/teatro-alla-scala.md","scene/companies/wiener-staatsoper.md","scene/companies/opra-national-de-paris.md","scene/companies/salzburg-festival.md"]
slug = "waltraud-meier"
title = "Waltraud Meier"
website = "http://www.waltraud-meier.com/"
+++

German mezzo-soprano Waltraud Meier was born in Würzburg. She grew up in a home full of music-making, and as early as her school and college days she already sang in five different choruses. After completing her secondary education, she initially studied English and Romance languages while taking singing lessons at the same time.
 
In 1976 Waltraud Meier decided to concentrate on a singing career and made her debut at the Würzburg Opera as Lola in *Cavalleria Rusticana*. During the following years the mezzo-soprano gained a wide repertoire from regular engagements in Mannheim (1978-1980), Dortmund (1980-1983), Hanover (1983-1984), and Stuttgart (1985-1988). Waltraud Meier made her international debut in 1980 at the Teatro Colón in Buenos Aires as Fricka in *Die Walküre*.
 
With her triumphant success as Kundry in Wagner's *Parsifal* at the 1983 Bayreuth Festival, she launched her international career which took Waltraud Meier to regular appearances at the Royal Opera of Covent Garden, the Metropolitan Opera in New York, La Scala in Milan, the Opéra National de Paris, the Vienna State Opera, and the Bavarian State Opera in Munich. After the singer had set new standards in the role of Kundry from 1983 to 1993 in Bayreuth she moved there into dramatic soprano roles, impressing deeply both critics and the public as Isolde in the legendary *Tristan und Isolde* production staged by Heiner Müller and conducted by Daniel Barenboim between 1993 and 1999. Again in Bayreuth, at the 2000 "Millennium Ring" festival, Meier performed the role of Sieglinde in *Die Walküre* staged by Jürgen Flimm and conducted by Giuseppe Sinopoli. Celebrated in her roles as Kundry, Isolde, Ortrud, Venus, and Sieglinde, Waltraud Meier is today considered as one of the most internationally significant Wagner singers of our time.
 
Also in the Italian and French repertoire the great power of her musical and dramatic expression enjoys worldwide demand in the roles of Eboli, Amneris, and Didon. With her sensational performance as Santuzza under the baton of Riccardo Muti she conquered the Italian audience.
 
Waltraud Meier has collaborated with such significant directors as Jean-Pierre Ponnelle, Luc Bondy, Harry Kupfer, Götz Friedrich, Klaus-Michael Grüber, and Patrice Chéreau. Great directors, above all Daniel Barenboim, Riccardo Muti, Claudio Abbado, James Levine, Zubin Mehta, Christian Thielemann, and Valery Gergiev, have come to appreciate the extraordinary fusion of passion, creativity, and clear intellect in the strength of Waltraud Meier's musical personality.
 
At the Théâtre du Châtelet in Paris the singer gave a triumphant performance in Parsifal (Klaus-Michael Grüber / Semyon Bychkov), as she had done before in 1991 at La Scala under the direction of Riccardo Muti. Her close artistic collaboration with Barenboim and the Berlin State Opera Unter den Linden as well as with the Bavarian State Opera of Munich has taken her on regular tours to Japan, her performances there including *Die Walküre*, *Wozzeck*, *Tristan*, and *Fidelio*. There then followed, to name but a few of the highlights, premieres at the Munich Opera Festival as Didon in *Les Troyens* and new productions at the Salzburg Festival (Isolde) and L'Opéra de la Bastille (Isolde). In Chicago she debuted as Leonore in *Fidelio*, again under the baton of Daniel Barenboim. In this role Waltraud Meier was to give a brilliant performance in both Munich and Milan.
 
Her extremely fruitful collaboration with Patrice Chéreau on Alban Berg's *Wozzeck* brought about the desire for further joint productions. At the opening of the 2007/2008 Scala season Waltraud Meier sang - again with Barenboim - in Chéreau's psychologically deeply profound production of *Tristan and Isolde*.
 
For years Waltraud Meier had close links with the concerns and aims of the West-Eastern-Divan Orchestra with whom she works on many tours.
 
As a singer and artist Waltraud Meier never ceases to seek out new challenges and to venture on new paths. She also concentrates on singing in its purest form, devoting her 2003/2004 season exclusively to recitals and concerts. Since then she commits a large part of her work to this expressive potential.
 
The following years will see Waltraud Meier not only deepen and accentuate her repertoire as a singer and performer, but also expand it with new roles. In the summer of 2010 she appeared as Klytämnestra at the Salzburg Festival. In addition she continued her collaboration with Patrice Chéreau with a staged improvisation of Wagner's *Wesendonck Lieder* at the Louvre Museum.
 
An extensive discography and videography as well as many productions available on DVD testify to the versatility of this unique singer's power of interpretation, musicality, vocal beauty, and art of singing. A highly acclaimed winner of many awards Waltraud Meier was honored with the title of "Kammersängerin" by both the Bavarian State Opera and the Vienna State Opera. She lives in Munich.
