+++
date = "2015-04-23T00:03:00-04:00"
discipline = "Mezzo-soprano"
lastmod = "2015-04-23T00:03:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429761782562/298_Susan_Graham%2C_Onyx%2C_jul12_(c)_B_Ealovega_(may2013)_NEW.jpg.jpg"
primary_image_credit = "Photo: B Ealovega"
publishDate = "2015-04-23T00:03:00-04:00"
related_companies = ["scene/companies/canadian-opera-company.md","scene/companies/the-metropolitan-opera.md"]
slug = "susan-graham"
title = "Susan Graham"
website = "http://susangraham.com/"
[[social_media]]
platform = "Facebook"
template = "social-media"
url = "https://www.facebook.com/MezzoGraham?fref=ts"
[[social_media]]
platform = "Twitter"
template = "social-media"
url = "https://twitter.com/MezzoGraham"
+++

Susan Graham—dubbed “America’s favorite mezzo” by Gramophone magazine—rose to the highest echelon of international artists within just a few years of her professional debut, mastering an astonishing range of repertoire and genres along the way. Her operatic roles span four centuries, from Monteverdi’s Poppea to Sister Helen Prejean in Jake Heggie’s Dead Man Walking, which was written especially for her. Graham won a Grammy Award for her collection of Ives songs, and her recital repertoire is so broad that 14 composers from Purcell to Sondheim are represented on her most recent album, Virgins, Vixens & Viragos. Throughout her career, however, this distinctly American artist has been recognized as one of the foremost exponents of French vocal music; a Texas native, she was awarded the French government’s prestigious “Chevalier de la Legion d'Honneur,” both for her popularity as a performer in France and in honor of her commitment to French music.

The mezzo’s earliest operatic successes were in such “trouser” roles as Cherubino in Mozart’s Le nozze di Figaro. Her technical expertise soon brought mastery of Mozart’s more virtuosic roles, like Sesto in La clemenza di Tito, Idamante in Idomeneo, and Cecilio in Lucio Silla, as well as the title roles of Handel’s Ariodante and Xerxes. She went on to triumph in the iconic Richard Strauss mezzo roles, Octavian in Der Rosenkavalier and the Composer in Ariadne auf Naxos. These brought Graham to prominence on all the world’s major opera stages, including the Metropolitan Opera, Lyric Opera of Chicago, San Francisco Opera, Covent Garden, Paris Opera, La Scala, Bavarian State Opera, Vienna State Opera, the Salzburg Festival, and many more. In addition to creating the role of Sister Helen Prejean in the world premiere production of Dead Man Walking at San Francisco Opera, Graham sang the leading ladies in the Met’s world premieres of John Harbison’s The Great Gatsby and Tobias Picker’s An American Tragedy, and made her Dallas Opera debut as Tina in a new production of The Aspern Papers by Dominick Argento. As Houston Grand Opera’s Lynn Wyatt Great Artist, she launched the past season as Prince Orlofsky in the company’s first staging of Die Fledermaus in 30 years, before heading an all-star cast as Sycorax in the Met’s Baroque pastiche, The Enchanted Island, and making her rapturously received musical theater debut in a new production of Rodgers & Hammerstein’s The King and I at the Théâtre du Châtelet in Paris.

It was in an early Lyon production of Berlioz’s Béatrice et Bénédict that Graham scored particular raves from the international press, and a triumph as Massenet’s Chérubin at Covent Garden sealed her operatic stardom. Further invitations to collaborate on French music were forthcoming from many of that repertoire’s preeminent conductors, including Sir Colin Davis, Charles Dutoit, James Levine, and Seiji Ozawa. New productions of Gluck’s Iphigénie en Tauride, Berlioz’s La damnation de Faust, and Massenet’s Werther were mounted for the mezzo in New York, London, Paris, Chicago, San Francisco, and elsewhere. She recently made title role debuts in Offenbach’s comic masterpieces La belle Hélène and The Grand Duchess of Gerolstein at Santa Fe Opera, and proved herself the standout star of the Met’s star-studded revival of Berlioz’s Les Troyens, which was broadcast live to cinema audiences worldwide in the company’s celebrated Live in HD series. This season, she returns to the Met in the title role of Susan Stroman’s new production of Lehar’s The Merry Widow, before closing the season opposite Bryan Hymel in a new staging of Les Troyens at San Francisco Opera. She also looks forward to headlining gala concerts at Los Angeles Opera and Lyric Opera of Chicago, where she joins Jane Lynch, Renée Fleming, Ramsey Lewis, and others to celebrate the latter company’s 60th anniversary.

Graham’s affinity for French repertoire has not been limited to the opera stage, and serves as the foundation for her extensive concert and recital career. Such great oratorios and symphonic song cycles as Berlioz’s La mort de Cléopâtre and Les nuits d'été, Ravel’s Shéhérazade, and Chausson’s Poème de l’amour et de la mer take her to the world’s leading orchestras, with regular appearances at the New York Philharmonic, Boston Symphony, Orchestre de Paris, and London Symphony. Last season, she joined Bernard Haitink and the Boston Symphony for Shéhérazade in Boston and at Carnegie Hall, and in 2014-15 she sings Berlioz with the Royal Flemish Philharmonic for La mort de Cléopâtre, and undertakes Les nuits d'été with both the London Symphony Orchestra and John Eliot Gardiner’s Orchestre Revolutionnaire et Romantique. Marking her first duo recital tour, the mezzo recently teamed up with soprano Renée Fleming at venues including Disney and Carnegie Hall. This season, she reunites with regular recital partner Malcolm Martineau for a West Coast tour and a season-closing recital in Classical Action’s Michael Palm Series.

Graham’s distinguished discography features all the works described above, as well as solo albums including Un frisson francais, a program of French song recorded with pianist Malcolm Martineau for Onyx; C’est ça la vie, c’est ça l’amour!, an album of 20th-century operetta rarities on Erato; and La belle époque, an award-winning collection of songs by Reynaldo Hahn with pianist Roger Vignoles, from Sony. Among the mezzo’s additional honors are Musical America’s Vocalist of the Year and an Opera News Award.
