+++
date = "2015-09-29T16:29:00-04:00"
discipline = "Soprano"
lastmod = "2015-09-29T16:29:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1649423449/media/2022/04/2021-05-23-Sonia-Yoncheva5291-scaled_umuncm.jpg"
primary_image_credit = "Photo: Gregor Hohenberg / SonyClassical"
publishDate = "2015-09-29T16:29:00-04:00"
related_companies = ["scene/companies/the-metropolitan-opera.md", "scene/companies/bayerische-staatsoper.md", "scene/companies/opra-national-de-paris.md", "scene/companies/staatsoper-berlin.md", "scene/companies/royal-opera-house.md", "scene/companies/wiener-staatsoper.md"]
slug = "sonya-yoncheva"
title = "Sonya Yoncheva"
website = "https://sonyayoncheva.com/"
[[social_media]]
platform = "Facebook"
template = "social-media"
url = "https://www.facebook.com/sonyayonchevaofficial"
[[social_media]]
platform = "Twitter"
template = "social-media"
url = "https://twitter.com/sonyayoncheva"
[[social_media]]
platform = "Instagram"
template = "social-media"
url = "https://www.instagram.com/sonyayoncheva/"
[[social_media]]
platform = "Youtube"
template = "social-media"
url = "https://www.youtube.com/user/TheShlupy"

+++
Superstar soprano Sonya Yoncheva has been heralded as one of the most acclaimed and exciting performers of her generation.

The recipient of the 2021 Opus Klassik as Singer of the Year has become an acclaimed fixture on the most important stages of the world, including the Metropolitan Opera, Royal Opera House, Teatro alla Scala, Bayerische Staatsoper, Berlin State Opera, Wiener Staatsoper, and the Opéra de Paris. Her unforgettable portrayals of iconic roles have received tremendous acclaim from critics and audiences alike.

Sonya Yoncheva’s extensive repertoire includes jewels of the Baroque canon, as well as works by Mozart, Verdi, Tchaikovsky, and Puccini. Celebrated for her distinctly beautiful voice and exceptional dramatic presence, Sonya is equally at home on the concert and recital stage, having performed to critical acclaim in several cities including Paris, Dresden, Baden-Baden, and Munich.

## Current Season

Sonya’s thrilling 2021/22 season includes several iconic title role debuts at the world’s leading opera stages: At the Teatro alla Scala, she performs for the first time the protagonist of Ponchielli’s _La Gioconda_ and of Giordano’s _Fedora_ and at the Staatsoper Hamburg she makes her debut as Puccini’s Manon Lescaut. Other opera appearances include Élisabeth de Valois in a new production of _Don Carlos_ at the Metropolitan Opera, where for the first time in Met history the French version of Verdi’s masterpiece is being performed. Sonya also returns to the title roles of _Tosca_ at Opernhaus Zurich, of _Iolanta_ with the Berliner Philharmoniker at the Festspielhaus Baden-Baden and of _Norma_ at the Gran Teatre del Liceu in Barcelona. She also reprises her celebrated Mimì in _La bohème_ at the Staatsoper Berlin and returns to the Teatro Real of Madrid as Stephana in concert performances of Giordano’s Verismo gem _Siberia_. Sonya’s busy concert schedule includes a tour of her _Rebirth_ programme which leads her to the Victoria Hall of Geneva, the Palau de la Música of Barcelona and the Teatro alla Scala in Milan. She also performs solo concert programmes at the Symfonisk Sal of Aarhus, the Greek National Opera of Athens, the Béla Bartók National Concert Hall of Budapest and for her house debut at the Gran Teatre del Liceu of Barcelona. In recital, she appears at the Metropolitan Opera, the Salle Gaveau of Paris, the Enescu Festival of Bucharest and the Berliner Philharmonie. With the Royal Liverpool Philharmonic Orchestra conducted by Domingo Hindoyan, Sonya sings Martucci’s opulent song-cycle _La canzone dei ricordi_ at the Liverpool Philharmonic Hall.

## Highlights of past seasons

Sonya kicked off her 2020/2021 season at the Staatsoper Berlin, hosting a Rolex _Perpetual Music_ Concert in support of musicians during the challenging period of COVID-19. Following this, the superstar soprano opened the concert season of the Antwerp Symphony Orchestra and of the Würth Philharmoniker presenting arias from _Aida_, _Il trovatore_, _La Wally_, _Le Villi_, _Gianni Schicchi_, _Madama Butterfly_, _Rusalka_, _Manon_ and _Carmen_. In the role of the Roman Diva Tosca, Sonya returned to the Bayerische Staatsoper of Munich, followed by the prestigious Season Inauguration Gala concert of the Teatro alla Scala. Sonya concluded 2020 appearing in “Weihnachten mit dem Bundespräsidenten”, a Christmas concert hosted by the German President and telecast by ZDF on December 24. She began the New Year performing a recital at the dazzling Bad Schussenried monastery within the _Met Stars Live in Concert_ series, streamed worldwide by the Metropolitan Opera. In 2021, she also starred in the title role of _Tosca_ at the Wiener Staatsoper, in _Fauteuils d’Orchestre_ on the French TV channel France 5, in a recital featuring her programme _Ad una Stella_ at the Palau de les Arts in Valencia, in a Zarzuela Concert at the Teatro de la Zarzuela in Madrid, in recital at the ABAO Bilbao, in Duparc’s _L’Invitation au Voyage_ with the NOSPR in Katowice and in the Gala Musiques en fête at the Chorégies d’Orange, telecast on France 3. In summer 2021, Sonya appeared in the Verismo rarity _Siberia_ in a new staging at the Maggio Musicale in Florence, as Violetta in _La traviata_ at the Arena of Verona (telecast by ZDF and 3sat), and in concerts and recitals at the Salzburg Festival, the Munich Opera Festival, the Festival Radio France, the Théâtre du Capitole of Toulouse, the Ljubljana Festival and the St. Alexander Nevsky Square in Sofia.

Engagements of the 2019/2020 season included star turns as Imogene in _Il pirata_ at the Teatro Real of Madrid, as Mimì in _La bohème_ at the Royal Opera House Covent Garden and in the title role of _Médée_ at the Staatsoper Berlin. Sonya also appeared in concert at the Hamburg Elbphilharmonie, the Moscow Tchaikovsky Hall and the Sofia Philharmonic Hall. Following the global lockdown, Sonya returned on stage in summer 2020 for Beethoven’s _9th Symphony_ at the Victoria Hall in Geneva, telecast by Arte, and the prestigious _Concert de Paris_ at the foot of the Eiffel Tower, shown on television all over the world. She subsequently starred in the title role of _La traviata_ in an open-air concert performance at the Cavea del Teatro del Maggio of Florence, in a Puccini Gala in the composer’s hometown Lucca and in a gala concert at the Reggia di Caserta. She also presented her new solo concert program _Renaissance_ at the Salzburg Festival, returned to her home town of Plovdiv for a gala concert titled _Coming Back_ and to the Arena di Verona in a gala concert dedicated to love.

Ms Yoncheva’s starry 2018/2019 engagements led her to the Staatsoper Berlin for her title role debut in a new production of Cherubini’s _Médée_, followed by her return to the Metropolitan Opera for performances as Desdemona in _Otello_ and in the title part of _Iolanta_. Sonya returned to the Festspielhaus Baden-Baden as Desdemona in a new production of _Otello_, a role that she also performed in concert performances with the Berliner Philharmoniker at the Philharmonic Hall of Berlin. She also reprised her acclaimed portrayal of _Tosca_ at the Staatsoper Berlin. Performances on the concert platform included Rossini’s _Stabat Mater_ at the Philharmonie of Paris, gala concerts at the Teatro alla Scala, the Opéra de Paris, the Wiener Staatsoper and the Grafenegg Festival, recitals at the Monte Carlo Opéra, Teatro Real of Madrid, Rosey Concert Hall and Teatro del Lago Frutillar (Chile) as well as solo concerts at the Berliner Philharmonie, The Broad Stage of Santa Monica, Hungarian State Opera in Budapest, Liège Opera House, Teatro del Bicentenario in Guanajuato (Mexico) and Mexico City.

Other past performance highlights include her title role debut in a new production of _Norma_, Antonia in _Les contes d’Hoffmann_ and Micaëla in _Carmen_ at the Royal Opera House, several Metropolitan Opera appearances, featuring her role debut as Tosca in a new production in the 2017/18 season, her house debut as Gilda in _Rigoletto_ and star turns as Luisa Miller, Mimì in _La bohème_, Violetta in _La traviata_, Desdemona in the 2015/16 opening production of _Otello_ and in the Met’s Gala Concert celebrating its 50th Anniversary at Lincoln Center; the title roles of _Iolanta_, _La traviata_ and _Lucia di Lammermoor_ at Opéra de Paris, where she also made her debut as Élisabeth de Valois in a new staging of Verdi’s _Don Carlos_ and appeared as Mimì in a new production of _La bohème_; Mimì and Imogene in the first production of Bellini’s _Il pirata_ at the Teatro alla Scala since Maria Callas’ legendary 1958 performances; the title role in a new _L’incoronazione di Poppea_ at the Salzburg Festival; Violetta at the Staatsoper Berlin, the Palau de les Arts Valencia, Monte Carlo, and the Bayerische Staatsoper; Tatyana in _Eugene Onegin_ at Deutsche Oper Berlin and Marguerite in _Faust_ at the Wiener Staatsoper, the Royal Opera House, and the Festspielhaus Baden-Baden. She was also a featured artist at the annual Adventskonzert in Dresden, broadcast on ZDF in Europe.

Sonya Yoncheva is an alumna of William Christie’s Le Jardin des Voix and has maintained a special focus the Early and Baroque repertory. Past engagements have featured her in several iconic roles, including Phani/Zima (_Les Indes galantes_) and Dido (_Dido and Aeneas_) on tour with William Christie in Europe, Russia and the US; La Fortuna (_L’incoronazione di Poppea_) at the Glyndebourne Festival; Giunone (_Il ritorno d’Ulisse in patria_) at the Teatro Real; Cleopatra (_Giulio Cesare_) in Versailles; and Poppea (_L’incoronazione di Poppea_) and Poppea (_Agrippina_) in Lille and Dijon with conductor Emmanuelle Haïm.

## Education and Accolades

Born in 1981, soprano Sonya Yoncheva graduated with performance degrees in piano and voice in her hometown of Plovdiv, Bulgaria under the tutelage of Nelly Koitcheva. Sonya later obtained her master’s degree in voice at the Conservatory of Geneva, studying with Danielle Borst. Ms. Yoncheva is also the winner of several renowned international competitions, including top prize and the special CultureArte prize at Plácido Domingo’s Operalia competition (2010). She was honored as the Singer of the Year at the 2021 Opus Klassik Awards and the Newcomer of the Year (Singer) at the 2015 ECHO Klassik Awards. Sonya is the winner of the 2019 Readers’ Award of The International Opera Awards. She was named the 2017 medici.tv Artist of the Year, and was featured on a series of live online and archived broadcasts in celebration of this recognition.

Sonya Yoncheva is also a first prizewinner of numerous competitions in her home country of Bulgaria: “Competition for Bulgarian Classical Music” in 2000 and “Competition for German and Austrian Classical Music” in 2001. Sonya and her brother Marin Yonchev were lauded as the Singers of the Year in the 2000 edition of the competition “Hit-1,” produced by Bulgarian National Television. Ms. Yoncheva has collaborated with acclaimed popular artists including Sting and Elvis Costello, and she retains a keen interest in film music, which includes her past collaborations with famed composer Vladimir Cosma.

Sonya records exclusively for Sony Classical, and is featured on a new solo album titled _Rebirth_, released in 2021, on her solo album _Handel_, in addition to _The Verdi Album_ and her debut solo album Paris, _mon amour_, Pergolesi’s _Stabat Mater_ and several recordings on DVD/Blu-Ray. Her discography also includes CD recordings of _Le nozze di Figaro_ (Contessa) for Deutsche Gramophone, Monteverdi’s _L’incoronazione di Poppea_ from the Salzburg Festival and Handel’s _Messiah_ with the world-renowned Mormon Tabernacle Choir.

Sonya Yoncheva became a producer in 2020, creating her company [SY11](https://sy11events.com/) in order to organize her own concerts. Up to the present, the company has organized gala concerts in Plovdiv and Sofia as well as a tour featuring Sonya Yoncheva’s _Rebirth_ tour with stops in Geneva, Barcelona and Brussels.

In November 2021, Sonya Yoncheva became a UNICEF Ambassador in Bulgaria, standing up for children’s rights.

Ms. Yoncheva is also a global ambassador for Rolex.