+++
date = "2015-07-12T16:49:00-06:00"
discipline = "Baritone"
lastmod = "2015-07-12T16:49:00-06:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1436741003761/milnes-acosta.jpg.jpg"
primary_image_credit = "Dario Acosta"
publishDate = "2015-07-12T16:49:00-06:00"
related_companies = ["scene/companies/the-metropolitan-opera.md","scene/companies/lyric-opera-of-chicago.md","scene/companies/teatro-alla-scala.md","scene/companies/royal-opera-house.md","scene/companies/bayerische-staatsoper.md","scene/companies/opra-national-de-paris.md","scene/companies/savannah-voice-festival.md"]
slug = "sherrill-milnes"
title = "Sherrill Milnes"
website = "http://sherrillmilnes.com/"
[[social_media]]
platform = "Facebook"
template = "social-media"
url = "https://www.facebook.com/SherrillMilnes"
[[social_media]]
platform = "Youtube"
template = "social-media"
url = "https://www.youtube.com/channel/UC4bwhBI3n_9DfvnxlASdBFA"
+++

#### Legendary artist, teacher, producer

Sherrill Milnes is universally acclaimed as the foremost operatic baritone of his generation. With his powerful voice, commanding stage presence, and rugged handsomeness, he received the kind of adulation that is usually reserved for tenors. He sang over 650 performances at the Met, where he was honored with sixteen new productions, seven opening nights, and ten national telecasts. As a leading artist in all of the world’s great opera houses, Mr. Milnes performed and recorded with the likes of Domingo, Pavarotti, Caballé, Sutherland, Sills, Horne, Price, and Tebaldi. He is the winner of three Grammy Awards, and the most recorded American singer of his time. In 2008 he received the Opera News Award for Distinguished Achievement.

Driven by his dedication to make the vocal arts vibrant, vital, and entertaining in today’s world, Mr. Milnes continues to give masterclasses, judge competitions, and mentor new generations of singers. With his wife, Maria Zouves, he co-founded and runs the Sherrill Milnes VOICE Programs: VOICExperience Foundation and the Savannah VOICE Festival provide training for aspiring young artists while fostering new audiences for the arts.

#### Early Years

Sherrill Milnes was born on January 10, 1935, and grew up on a dairy farm in Downers Grove, Illinois. Despite a childhood devoted to daily chores, he took voice lessons and studied piano, violin, viola, double bass, clarinet, and tuba. But when it came time for college, he pursued pre-medical studies. After a year and a half, he realized that music was his true calling and enrolled at Drake University where he studied with Andrew White, earning his bachelor’s and master’s degrees in music in the hope of becoming a teacher. Additional graduate studies with Hermanus Baer followed at Northwestern University. During these years, the young baritone supported himself by playing in local jazz bands during college and singing wherever he could at women’s clubs, with local opera groups, in churches and synagogues, and for television and radio commercials. A great opportunity came when he auditioned and was accepted into the Boris Goldovsky Opera Company, an event he has called the “luckiest possible beginning” for his career. He toured throughout the United States with that company – over 100,000 miles by bus – singing in over 300 performances of more than a dozen roles.

#### Career

It is fitting that the career of this artist was launched in his native land, belying the notion that singers must work their way through the small European opera houses before earning the respect of American critics and audiences. It was at the quintessential American house, the New York City Opera, that Mr. Milnes made his first important debut in 1964, as Valentin in Gounod’s *Faust* opposite Norman Treigle as Mephistopheles. It was again in the role of Valentin that Mr. Milnes made his critically acclaimed debut at the Metropolitan Opera on December 22, 1965, an auspicious night that also featured the Met debut of Montserrat Caballé. He was launched to stardom, however, in 1968, when his riveting performance as Miller in Verdi’s *Luisa Miller* literally stopped the show at the Met and immediately made him the dominant baritone of his time.

Mr. Milnes began his international career with a triumphant Macbeth at the Vienna Staatsoper, and in time would conquer all of the great opera capitals of the world, singing at the Royal Opera, Covent Garden; La Scala in Milan; Berlin’s Deutsche Oper; the Paris Opera; the famed Teatro Colon in Buenos Aires; the Liceu in Barcelona; the Bavarian State Opera in Munich; the Salzburg Festival; the Hamburg Opera and Moscow’s Bolshoi Theatre. He also appeared with New York City Opera, San Francisco Opera, Lyric Opera of Chicago, and the opera companies of Pittsburgh, San Diego, Miami, and Denver, among others in the United States. At the Metropolitan Opera, he sang 652 performances from 1965 to 1997, including the Met’s 1991 gala celebrating its 25th anniversary at Lincoln Center, which was released by Deutsche Grammophon on DVD.

Throughout his remarkable career, Mr. Milnes showed an affinity for Verdi, whose works formed the cornerstone of a repertoire of some 70 roles. Those included the lead baritone roles in *Otello, Don Carlo, Aida, La Traviata, Il Trovatore, La Forza del Destino, Luisa Miller, Ernani*, and *Un Ballo in Maschera*, as well as the monumental title roles of *Rigoletto, Simon Boccanegra, Macbeth*, and *Nabucco*, all sung to overwhelming acclaim. He also triumphed as Mozart’s *Don Giovanni*, Escamillo in Bizet’s *Carmen*, Figaro in Rossini’s *Il Barbiere di Siviglia*, Scarpia in Puccini’s *Tosca* and Jack Rance in *La Fanciulla del West*, Ambroise Thomas’s *Hamlet*, Athanaël in Massenet’s *Thaïs*, and the title role of *Henry VIII* by Saint-Saëns, among many others. He continued to expand his vast operatic repertoire to include new roles, including the title role in Verdi’s *Falstaff*, Count Westmoreland in Wolf-Ferrari’s *Sly*, Judge Turpin in Sondheim’s *Sweeney Todd*, the title role in Puccini’s *Gianni Schicchi*, and Ajax in Georges Antheil’s *Transatlantic* (United States premiere).

Mr. Milnes appeared with the great orchestras of North America and Europe, sang on the world’s major recital stages, and performed for every U.S. President from Gerald Ford to George W. Bush. Conducting added another dimension to his multi-faceted career; highlights include the acclaimed recording *Domingo Conducts Milnes! Milnes Conducts Domingo!*, Mendelssohn’s *Elijah* at Carnegie Hall (which marked his New York conducting debut), and *Aida* with Opera Memphis (his operatic conducting debut).

#### Awards

Sherrill Milnes has received numerous honors during his distinguished career, including seven honorary doctoral degrees. He is particularly proud of being named as a Commendatore of the Italian Republic for his long commitment to Italian opera. In 1987 he received New York City’s Seal of Recognition for his rich contribution to the city’s cultural life. He was also chosen by the American Bible Society to receive the 25 millionth copy of its Good News Bible, and in 1993 he organized a benefit concert in Vienna’s famed St. Stephen’s Cathedral for the victims of the Bosnia-Herzegovina War. In September 1996, Mr. Milnes was honored by the French government with the distinguished Chevalier de l’Ordre des Arts et des Lettres, and in 2003 he became a member of the Lincoln Academy, the highest honor awarded by the state of Illinois.

#### Recordings & Autobiography

Sherrill Milnes has the distinction of being the most recorded American opera singer of his time, with a discography encompassing his great opera roles, as well as lieder, oratorio, symphony, and Broadway. His recordings of *Così fan tutte, Aida*, and *La bohème* won Grammy Awards, and his recording of Brahms’s *Four Serious Songs* (with Erich Leinsdorf at the piano), as well as the sacred recording *Amazing Grace*, received Grammy Award nominations. In 1997, Video Arts International (VAI) released two of several live recital albums: *There But For You Go I* and *Kingdom By the Sea*. The baritone is also featured in three music films: *Homage to Verdi*, *Sherrill Milnes: All Star Gala*, and *Sherrill Milnes at Juilliard: An Opera Master Class*, as well as numerous Metropolitan Opera performances in current release. On television, he appeared as himself on Tony Randall’s *Love, Sidney*, and performed multiple times on CBS-TV broadcasts of the Kennedy Center Honors, including segments with Carol Burnett and Victor Borge. The second edition of his autobiography, *American Aria: Encore*, is available from Amadeus Press.

#### Teacher

Sherrill Milnes has worked extensively with young singers throughout his career. He has led masterclasses at the Juilliard and Manhattan Schools in New York City, for the Met Opera’s Lindemann Young Artists Development Program, Lyric Opera of Chicago’s Ryan Opera Center, at major universities and music schools throughout the country, and at the Mozarteum in Salzburg. Mr. Milnes has served as faculty at the Yale School of Music and at Northwestern University, where he is the John Evans Distinguished Professor of Music Emeritus. Additional teaching engagements have brought him to the Tchaikovsky Conservatory in Moscow, Shanghai Conservatory in China, Northern Royal College of Music in Manchester, Israel Vocal Arts Institute in Tel Aviv, and the International Institute of Vocal Arts in Chiari, Italy. He has served as a judge for several international competitions including the BBC Cardiff Singer of the World Competition, and for the Richard Tucker Music Foundation, of which he is a founding board member.

#### The Sherrill Milnes VOICE Programs

In 2000, with Maria Zouves, Mr. Milnes founded VOICExperience, a non-profit foundation designed to train and mentor young singers. Over the years thousands of aspiring artists in Florida, Georgia, Illinois, and New York have benefitted from their dedicated work. As an outgrowth of VOICExperience, in 2013 Mr. Milnes and Ms. Zouves founded the Savannah VOICE Festival, bringing classical vocal excellence to the Savannah, Georgia area through concerts, fully staged operas, educational presentations, and community outreach. With programs ranging from classical music to musical theater and popular song, the Savannah VOICE Festival provides performance opportunities for VOICExperience participants as it builds audiences for the vocal arts.
