+++
date = "2016-01-06T11:26:00-05:00"
discipline = "Director"
lastmod = "2016-01-06T11:26:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1452097547591/2016-01-05---Robert-Lepage.jpg.jpg"
publishDate = "2016-01-06T11:26:00-05:00"
related_companies = ["scene/companies/canadian-opera-company.md","scene/companies/the-metropolitan-opera.md","scene/companies/opra-national-de-paris.md"]
slug = "robert-lepage"
title = "Robert Lepage"
+++

Director, designer, actor, dramatist, playwright, creator, born at Quebec City 12 Dec 1957; Diploma (Conservatoire de Musique et d'art dramatique de Québec [CMQ]) 1978, honorary PhD Arts (Laval) 1994, honorary PhD Lit (McGill) and honorary PhD Lit (Toronto) 1997, honorary LLD (Concordia) 1999.

## Background and Early Life

Lepage, a multilingual and multi-faceted artist of international repute, grew up in Québec City and credits his bilingualism to his early family life. He is also fluent in Spanish and Italian, and knowledgeable in Japanese, German and Swedish.

Lepage, who was interested in geography as a youth and had an isolated adolescence dogged by depression, began his relationship with the stage as a teenager acting in school plays. He studied at the CMQ (1975-78) where one of his teachers was Marc Doré who himself had trained under the renowned French mime Jacques Lecoq. After graduation, Lepage studied in Paris with Alain Knapp who believed that acting, directing and writing were equal partners in the creative experience. This attitude prevailed in Lepage's first professional position with Théâtre Repère in Québec City beginning in 1982, where under Jacques Lessard he learned the concept of Resources - Score - Valuaction - Performance (RSVP) Cycles, which had been introduced to Quebec Theatre from California by choreographers Ann and Lawrence Halprin in the 1960s. Lepage, later Théâtre Repère's artistic co-director (1986-89), also drew influences from the work of Claude Jutra and Denys Arcand, and from his personal life experience. A man of extraordinary energy and vast talent, Lepage has appeared in his own one-man shows and in performances where he played several or all of the characters.

## Professional Achievements

Lepage's first major work with a multimedia approach to theatre was *La Trilogie des dragons* (*The Dragon Trilogy*), which catapulted him to international fame in 1985. Lepage created his own company, Robert Lepage Inc., in 1988.

He was the director of the National Arts Centre (NAC) French language theatre (1989-93), and has directed stage performances around the globe including at the National Theatre (Munich); the Royal National Theatre (London), where he was the first North American to direct a Shakespeare play with *A Midsummer Night's Dream* in 1992; and the Royal Dramatic Theatre (Stockholm).

Lepage's company, Ex Machina (created 1994), exhibited such dynamism and innovation in marrying the arts with technology and incorporating new approaches that he did not want it to be limited by being called a theatre company. Lepage offered his own description: "Ex Machina is thus a multidisciplinary company bringing together actors, writers, set designers, technicians, opera singers, puppeteers, computer graphic designers, video artists, contortionists and musicians. Ex Machina's creative team believes that the performing arts - dance, opera, music - should be mixed with recorded arts - filmmaking, video art and multimedia. That there must be meetings between scientists and playwrights, between set painters and architects, and between artists from Québec and the rest of the world."

1994 also marked Lepage's foray into cinema, in both English and French, which included adaptations of some of his own earlier works. In 1995, he became the founder and artistic director of In Extremis Images Inc in Montréal, and in 1997 Lepage founded La Caserne Dalhousie, a multimedia production centre in Québec City.

In 1999, he was general commissioner of Le Printemps du Québec en France, a mega cultural event showcasing Québec's cultural and artistic output in Paris, and in 2004 he became vice-president of Ex Aqueo Films Inc.

## Productions

Lepage has created for live theatre, cinema, opera and museums as well as rock shows and the circus.

Among his theatre works are: *La Trilogie des dragons* - first version, in which he was co-writer, director and actor, Théâtre Repère, 1985; *Le Polygraphe*, Théâtre Repère, 1987 (co-writer, director, actor), also made into a movie (*Polygraph* in English) in which he was the scriptwriter and director, 1996; *Roméo et Juliette*, the French version of Shakespeare, in which he was co-director, set and costume designer, Théâtre Repère, 1989; Sophie Faucher's *La Casa Azul*, Montréal, Spain, and Austria as director, 2001; *The Dragon's Trilogy* - second generation with a new cast in which he was co-writer and director, Québec, Spain, France, Berlin, and Zagreb (Croatia), 2003; *The Busker's Opera*, inspired by John Gay's *The Beggar's Opera*, director, 2004; *The Andersen Project*, as writer, director, actor in Québec and Denmark, 2005; *Lipsynch*, a nine-hour event first presented at Toronto's Luminato festival, as writer and director, 2007; and *Eonnagata* at Sadler's Wells London as co-designer and performer, 2009.

In 2000 Lepage was the creator of *Métissages*, a temporary exhibit at the Musée de la civilization in Québec. Lepage is celebrated for his numerous collaborations with the Cirque de Soleil, such as *Kà* (2004) and *Totem* (2010), for which he was both creator and director. In 2011, he staged *The Tempest* (in French) with Québec's Huron-Wendat nation using both Aboriginal and non-Aboriginal performers.

Among his films are *Jésus de Montréal* (dir. Arcand) as an actor, 1988; *Le Confessionnal* (released in English as *The Confessional*) as scriptwriter and director, 1995; Nô as scriptwriter and director, 1997; and *La Face Cachée de la Lune* (released in English as *The Far Side of the Moon*) as director, scriptwriter, actor, 2003. He also acted in *L'Audition* and *Dans les Villes* (2005) and *La Belle Empoisonneuse* (2006).

## Opera

In 1993 Lepage began staging full-scale opera productions, the earliest being Bartók's *Bluebeard's Castle* and Schoenberg's *Erwartung* for the Canadian Opera Company (COC). In the early 2000s he was initially approached to direct the entire Ring cycle for the COC, but after lengthy negotiations this did not materialize. Also premiered by Lepage at the COC was *The Nightingale and Other Short Fables* (2009). Lepage's production of Berlioz' *The Damnation of Faust* was first presented in Japan (1999), then at the Opéra National de Paris before appearing at the Metropolitan Opera in New York in 2008. This production used new scenic language that included 3D projections triggered by the performers, thus making each performance truly unique.

Among Lepage's most challenging opera productions have been the complete *Ring Cycle* for the Met, a mammoth project on which Lepage and the Ex Machina team began work in 2006. *Das Rheingold* premiered in 2010 and *Die Walküre* in 2011, with *Siegfried* and *Die Gotterdämmerung* in the 2011-2012 season. All the productions use light, screen projections, animation, 3D and other technologies to bring life, colour and fantastic reality to the sets. As in Faust, the 3D projections interact with live energy from orchestra members as well as from the singers. The Met's live HD presentations in movie theatres have made these works accessible to audiences around the world.

## Awards

Lepage has won a multitude of honours and awards in Canada and abroad, beginning in 1984. Among them are the Grand Prize from the Festival de théâtre des Amériques for *La Trilogie des dragons* (1987); Prix Gémeau for best actor in *La soirée de l'impro*, Montréal, from the Ligue nationale d'improvisation (1988); Chevalier de l'ordre des arts et lettres, Paris (1990); Floyd S. Chalmers Awards (1991 and 1995); Officer de l'Ordre national du Quebec (1999); and the Prix d'honneur from La Société des relations internationales de Québec for the impact of his work outside Quebec (2000). In 2001, he was inducted into Canada's Walk of Fame for his impact on Canada's cultural heritage, and in 2002 he was inducted into France's Légion d'honneur. Other major awards include the Prix Denise Pelletier and the National Theatre School's Gascon Thomas Award (2003); the Institut France-Canada's Prix Samuel de Champlain (2005); and the prestigious Europe Theatre Prize (2007). In 2009 Lepage received the Governor General's Performing Arts Award for outstanding contribution to Canadian cultural life; in 2010 and 2011, he won three Dora Mavor Moore Awards (one for outstanding production and two for outstanding touring production); and in 2011 received the Prix de l'Ordre de la Pléiade, Québec, and was made a Companion of the Order of Canada. In 2013 the Glenn Gould Foundation named Lepage the Laureate of the 10th Glenn Gould Award.
