+++
date = "2015-05-18T15:23:00-04:00"
discipline = "Tenor"
lastmod = "2015-05-18T15:31:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1546831201/media/2019/01/PlacidoDomingo.jpg"
publishDate = "2015-05-18T15:30:00-04:00"
related_companies = ["scene/companies/the-metropolitan-opera.md", "scene/companies/teatro-alla-scala.md", "scene/companies/los-angeles-opera.md", "scene/companies/san-francisco-opera.md", "scene/companies/wiener-staatsoper.md", "scene/companies/staatsoper-berlin.md", "scene/companies/washington-national-opera.md", "scene/companies/dayton-opera.md"]
slug = "plcido-domingo"
title = "Plácido Domingo"
website = "http://www.placidodomingo.com/inhalt.php?id=7486&menu_level=2&id_mnu=9912&id_kunden=1002"
[[social_media]]
platform = "Facebook"
template = "social-media"
url = "https://www.facebook.com/PlacidoDomingo?fref=ts&ref=br_tf"
[[social_media]]
platform = "Twitter"
template = "social-media"
url = "https://twitter.com/PlacidoDomingo"

+++
Years ago, a fan suggested that Plácido Domingo (whose name literally translates as “Placid Sunday”) should use the saying “If I rest, I rust™” as a motto. In fact, Domingo has been incessantly active since the age of sixteen ― and the more he has studied, travelled and performed, the more he has felt fulfilled and the deeper his love of music has become. 

Domingo has been at home on the world’s stages for over half a century: as of the end of 2013, he had sung 3,687 performances of 144 roles, in addition to having conducted 526 performances and made numerous recordings. Few if any performers have ever been able to look back on such a successful and well-documented career – and at the age of seventy-two, he forges ahead with total, unabated commitment.

Domingo’s charm and the extraordinary kindness that he demonstrates towards everyone with whom he comes in contact enthrall thousands year after year. His voice’s exceptionally warm timbre and equally exceptional flexibility combine with his remarkable acting talent and give him what he thinks of as a great opportunity to give pleasure to people throughout the world. 

Plácido Domingo Embil was born in Madrid on 21 January 1941. His father, Plácido Domingo, Sr., and his mother, Pepita Embil, were celebrated performers of zarzuela, the Spanish form of operetta, which Plácido Domingo loves to this day. In 1949 his parents established their own theatre company in Mexico, and the eight-year-old Plácido and his sister followed the parents there. Mexico City remained his home for thirteen years: he went to school there and was enthusiastic about football (soccer) and the corrida (bullfighting). Football has remained one of Domingo’s great passions, mainly as a spectator, although he has occasionally participated in benefit matches. 

He received his first piano lessons when he was eight years old, and thanks to his parents’ ensemble he learned all the basics of musical theatre, including its harsh economic realities. Today, as general director of a major opera company, he looks back with gratitude on that time. 

At the age of fourteen, Plácido was accepted at Mexico’s National Music Conservatory, but he soon faced major difficulties. He married when he was sixteen, and only a year later he became the father of a son, José. His first marriage did not last long, but these early responsibilities explain why he had to begin to work hard at so early an age. He took any job that came his way in the colourful world of music and the theatre. 

Plácido accompanied singers in classy and not-so-classy bars, sang in the musical *The Redhead*, played piano for a travelling ballet troupe, arranged his own music program with a new cultural radio station in Mexico City, accepted small acting roles in television productions of plays by Pirandello, Benavente, García Lorca and Chekhov and compiled background music for radio series. In addition, he trained choruses for zarzuelas and musicals, produced American pop music arrangements for Mexican recordings, and made himself available as a singer of background music. Each of these activities would prove to be of great benefit to him in one way or another later in his life.

Plácido also accompanied his mother on the piano during her solo performances and took on smaller baritone roles in his parents’ company as well as a minor role in the first Mexican production of *My Fair Lady*, which was performed 185 times. And he appeared in 170 performances of *The Merry Widow*. 

Nineteen-fifty-nine was a decisive year: Domingo, only eighteen years old, auditioned as a baritone for the Mexican National Opera. The committee liked his voice very much and the members also allowed him to audition with a tenor aria, which made him realize that he was really a tenor and not a baritone. He was initially engaged to sing small tenor parts, and he debuted that autumn as Borsa in Verdi’s *Rigoletto*. The first leading role followed only two years later, in Monterrey: Alfredo in *La Traviata*. 

At first, however, he sang mainly minor roles, and in November 1961 he made his US debut in Dallas as Arturo in Donizetti’s *Lucia di Lammermoor*. The following year brought important changes: Plácido Domingo married the soprano Marta Ornelas, with whom he had become acquainted at the conservatory. Both moved to Tel Aviv, where they performed with the Hebrew National Opera for three seasons, learning a great deal in the process. At the same time, Marta and their friend Franco Iglesias – a Mexican baritone who also belonged to the ensemble – helped Plácido to overcome a few technical problems in his singing. 

Thus the path for one of the greatest careers in the history of opera was paved. Upon the Domingos’ return from Israel, Marta gave up her singing career to devote herself entirely to raising their two sons (Plácido, Jr., was born in 1965 and Alvaro in 1968) and to her husband’s career. She remains his adviser to this day, and now that the children are grown up Domingo is proud of Marta for having regained a foothold in the opera world as a stage director.

Only six months after his departure from Tel Aviv, Domingo was called to New York: The New York City Opera wanted him for the world première of Alberto Ginastera’s Don Rodrigo, with which the ensemble opened its Lincoln Center residency at the New York State Theater (now David Koch Theater). 

The breakthrough had been achieved, and Plácido Domingo received a wealth of engagements. In 1967 he debuted at the Hamburg State Opera in *Tosca* and at the Vienna State Opera in *Don Carlo*; in 1969 at the Verona Arena in *Turandot*, San Francisco Opera (*La Bohème*), and La Scala in Milan (*Ernani*); in 1970 in his native Madrid (*La Gioconda*) and at the Edinburgh Festival (Beethoven’s *Missa Solemnis*); in 1971 at London’s Royal Opera House, Covent Garden (*Tosca*); in 1972 at the Bavarian State Opera in Munich (*La Bohème*); in 1973 at the Paris Opéra (*Il Trovatore*); and in 1975 at the Salzburg Festival (*Don Carlo*). The audience at the Bayreuth Festival experienced Plácido Domingo for the first time in 1992 when he sang the title role in *Parsifal*. Numerous engagements since then have regularly brought this exceptional performer to virtually all of the world’s great opera houses.

Domingo has neither a favorite opera role nor a favorite opera house, yet he has appeared at the Metropolitan Opera in New York more frequently than at any other theatre. He made his house debut in 1968 as Maurizio in Cilea’s *Adriana Lecouvreur*, and since then he has sung there every season. As of the end of 2012, he had sung over 800 performances with the company at home and on tour, in a total of 46 roles, and to date he has opened the Met’s season no fewer than twenty times, breaking the record set by Caruso. He has also conducted there many times – increasingly so in recent years.

In 1983, in the first edition of his memoirs (original title: *My First Forty Years*), Domingo defended himself against critics who had accused him of taking too many vocal risks by singing too much and singing roles that were not right for his voice. Of course, every singer has successful and less successful evenings. But Domingo – who can look back on many thousands of rehearsals and performances over nearly half a century, and at the highest artistic level – can assert with pride that his decisions were the right ones. His voice has endured in beautiful condition far beyond the average professional lifetime of most singers. He is justifiably proud of having been included in the Guinness Book of Records for the size of his repertoire but also for having received 101 curtain calls after his performance of Verdi’s *Otello* in Vienna. His interpretation of the jealous commander remains unequalled.

His repertoire extends from Rameau’s *Hippolyte et Aricie* (1733) to the world premieres of operas by Ginastera and Anton García Abril; the latter’s work, *Las Divinas Palabras*, inaugurated the restored Teatro Real in Madrid in October 1997. In September 2003, Domingo sang the role of Rasputin at the world premiere of Deborah Drattell’s opera *Nicholas and Alexandra* in Los Angeles, and in Vienna the following July he performed *Goya*, an opera written especially for him by Gian Carlo Menotti (first performance 1986, in Washington). In May 2005 he performed the title role in Alfano’s rarely revived *Cyrano de Bergerac* at the Met. Met audiences also saw him in the title role in the world premiere, in 2007, of *The First Emperor* by the Chinese composer Tan Dun, and in Los Angeles in 2010 Domingo created the role of Pablo Neruda in the world premiere of *Il Postino* by the Mexican composer Daniel Catán. In 2011 he was Neptune in the world premiere production of the Met’s Baroque pastiche opera, *The Enchanted Island*. But well-known works such as *Tosca*, *La Bohème* and *Carmen* have also accompanied Domingo on his path through life, and he has also enjoyed conducting many of these operas. He set a personal record in July 2003 in London when he sang the matinee performance of Leoncavallo’s *Pagliacci* and conducted the evening performance of the same opera. 

His major new roles in recent years have included Siegmund in Wagner’s *Die Walküre* and the title part in the same composer’s *Parsifal*, as well as Gherman in Tchaikovsky’s *The Queen of Spades*. In 2007 Domingo devoted himself to important works of the baroque and early classical eras by giving his first performances as Oreste in Gluck’s *Iphigénie en Tauride* at the Seattle Opera as well as the Met and as Bajazet in Handel’s *Tamerlano* at the Washington National Opera. He has recently been adding several lyric baritone parts to his repertoire: in the course of the 2009-10 season he appeared in the title baritone role of Verdi’s great *Simon Boccanegra* at the Berlin Staatsoper, La Scala, the Metropolitan Ope*Rigoletto* in an on-location worldwide telecast in 2010; in 2012 he added the baritone roles of Athanaël in Massenet’s *Thaïs* and Francesco Foscari in Verdi’s *I Due Foscari*; and in 2013 he increased his baritone repertoire with four more major Verdi roles: Giorgio Germont in *La Traviata*, the title part in Verdi’s *Nabucco*, Giacomo in *Giovanna d’Arco*, and the Count di Luna in *Il Trovatore*.

Fostering the greatest masterpieces of world opera continues to remain Domingo’s foremost concern. As General Director of the Los Angeles Opera (and, until 2011, Washington National Opera), he presents not only classics by Mozart, Verdi, Puccini and others but also more unusual repertoire, including operas by contemporary American composers.

Since 1993 Domingo has promoted highly talented young singers through the Operalia voice competition. Each year, in a different international city, forty pre-selected singers take part and have the opportunity to demonstrate their abilities before an international jury; the 2014 competition will be held in Los Angeles. In March 2002, the Domingo-Cafritz Young Artist Program – another of Domingo’s undertakings to nurture and give opportunities to promising young talents – came into being at the Washington National Opera, and the Domingo-Colburn-Stein Young Artist Program, subsequently founded under the auspices of Los Angeles Opera, has similar goals.

Plácido Domingo has been awarded the Presidential Medal of Freedom in the United States as well as the titles of Commandant of the Legion of Honor in France, Honorary Knight of the British Empire, and both Grande Ufficiale and Cavaliere di Gran Croce of the Order of Merit of the Italian Republic. He has received honorary doctorates from Oxford University and New York University for his lifelong commitment and contribution to music and the arts. In October 2009, King Carl Gustaf of Sweden presented him with the first Birgit Nilsson Prize (at one million dollars, the most generous prize in the world of classical music) for his outstanding achievements in opera; in accepting the award, Domingo said that it would “greatly benefit my annual competition, Operalia.” He has raised millions of dollars through benefit concerts to aid the victims of Mexico’s devastating 1985 earthquake, of the floods caused by Hurricane Paulina in Guerrero and Yucatán, also in Mexico and in El Salvador, and of the victims of Hurricane Katrina in New Orleans, where, in 2009, the stage of the Mahalia Jackson Theatre for the Performing Arts was named for him. In 2006, he conducted Verdi’s *Requiem Mass* in Warsaw, to commemorate the first anniversary of Pope John Paul II’s passing.

Domingo has made more than 100 recordings; many of them are full-length operas, and some operas he has recorded more than once. He also has numerous solo and duet recordings to his credit. Many of his albums have sold over a million copies, and this achievement has garnered several gold and platinum records as well as twelve Grammy awards. In addition, he has made numerous opera videos and collaborated in three famous opera films: *La Traviata* and *Otello* under the direction of Franco Zeffirelli and *Carmen* directed by Francesco Rosi. Domingo was honored with Emmy awards for the television film “Hommage à Sevilla” and for the Met’s Silver Gala. 

Domingo’s strong bond with zarzuela aroused his desire to promote this magical form of Spanish operetta and make it more accessible to an international audience. He appeared in Federico Moreno Torroba’s *Luisa Fernanda* in Milan and Vienna, singing – like his father many years ago – the baritone role of Don Vidal. Luisa Fernanda was also performed by Washington National Opera in 2004, at the Teatro Real in Madrid in 2006 and by Los Angeles Opera in 2007.

Domingo is also interested in light and popular music. In addition, his appearances around the world with his colleagues José Carreras and Luciano Pavarotti in the now legendary Three Tenors concerts were one of the great musical success stories of the 1990s. In August 2006, Domingo, soprano Anna Netrebko and tenor Rolando Villazón were acclaimed by thousands of spectators during a joint concert at Berlin’s outdoor Waldbühne, as were the two zarzuela evenings that he and Villazón presented at the 2007 Salzburg Festival.

Domingo has enjoyed and continues to enjoy the privilege of working with the world’s most famous singers ― from those who were ending their careers when his was beginning to those who are starting out today. He also performs regularly with the most distinguished conductors and stage directors of our time; in particular, the collaboration with important conductors has increasingly strengthened his own work as an opera and concert conductor. For more than thirty years he has been seen on the podiums of most major opera houses, and in 2006 he conducted the opening performance of the newly restored Theater an der Wien, one of Vienna’s historic opera houses. Over time he has increasingly assumed responsibilities in the realm of musical administration, too: In 1992, he was artistic director of the World Exhibition in Seville; he is the former General Director of Washington National Opera; and he is currently General Director of Los Angeles Opera, which, under his guidance, has become one of America’s most significant opera ensembles. 

Even in a very brief overview of his extraordinarily busy life, Domingo does not fail to point out the most terrible incident for him: the 1985 earthquake in Mexico, in which four of his close relatives were killed. He was involved in on-the-scene rescue efforts, and since then he has helped to raise several million dollars for the victims. All in all, however, Plácido Domingo considers himself the happiest person he knows, since he has seen much of the world and has been able to give pleasure to millions through his art. He thinks of his talent and his voice as gifts to be shared, and this is why he is currently working on a book , The Joy of Opera, in which he will convey the greatness of the art he has so devotedly served throughout his long professional life.

Newsweek and other international publications have fittingly described Plácido Domingo as “the King of Opera,” “a true renaissance man in music” and “the greatest operatic artist of modern times.”