+++
date = "2015-05-25T22:01:00-04:00"
discipline = "Soprano"
lastmod = "2015-05-25T22:03:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1549934452/media/2019/02/NinaStemmeNedaNavaee2.jpg"
primary_image_credit = "Neda Navaee"
publishDate = "2015-05-25T22:03:00-04:00"
related_companies = ["scene/companies/the-metropolitan-opera.md", "scene/companies/opernhaus-zurich.md", "scene/companies/bayerische-staatsoper.md", "scene/companies/wiener-staatsoper.md", "scene/companies/opra-national-de-paris.md", "scene/companies/teatro-alla-scala.md", "scene/companies/san-francisco-opera.md", "scene/companies/houston-grand-opera.md", "scene/companies/royal-opera-house.md"]
slug = "nina-stemme"
title = "Nina Stemme"
website = "https://ninastemme.com/"
[[social_media]]
platform = "Facebook"
template = "social-media"
url = "https://www.facebook.com/ninastemme/"

+++
For years, Swedish born Nina Stemme has been considered a leading singer of the most challenging parts in major dramas: Isolde, Brünnhilde and Kundry, Salome and Elektra, Fanciulla and Turandot.

That she initially shied away from these staggering heights of the soprano repertoire is a noteworthy – if not the defining – characteristic of her career. Mozart’s Cherubino is a far cry from Isolde and Turandot, a leap only few have mastered. Nina Stemme made the leap successfully by taking the time a development of this kind requires. When she was offered the part of Isolde, to be performed at the 2003 Glyndebourne Festival, she already had fourteen years of on-stage experience, having first taken lyrical parts such as Cherubino, Pamina, the “Figaro” Countess, Agathe and Eva, before moving on to increasingly lyrical-dramatic roles such as Mimi, Butterfly, Manon Lescaut, Tosca, “Tannhäuser” Elisabeth, Marschallin and Senta.   
  
Isolde would have been the next step, but it was not until she had conferred with Birgit Nilsson that she took the offer. To her surprise, the legendary Wagner singer offered to help her learn her part. Nonetheless, Nina Stemme felt she was not yet ready to sing Isolde. When she did take the stage as Isolde for the first time at Glyndeborne, her performance was met with enthusiasm and she subsequently made a record with Plácido Domingo singing as Tristan and Antonio Pappano as conductor. Even then, she remained cautious: “You are never ready with these gigantic roles”, she said in retrospect in her interview with the “New York Times”.

Respect for the roles and the operas, flexibility, diversity and a level-headed estimation of her voice’s potential – these were the factors that, alongside her voice itself, talent and musicality, made this highly talented singer an artist of global stature. In 1993, she was rewarded when she won Plácido Domingo’s Operalia competition. Whether at the Metropolitan Opera New York, La Scala Milan, the Bayreuth Festival, the Vienna State Opera or the Royal Opera House in London – Nina Stemme has furthered the great tradition of Flagstad and Nilsson at leading opera houses.

It comes as no surprise that she has been lavished with awards: She has been appointed Swedish Court Singer and Austrian “Kammersängerin”, received the “Premio Abbiati” critics’ award (2010), the Laurence Olivier Award for Outstanding Achievement in Opera (2010), the International Opera Award for the Best Female Singer (2013) and the Opera News Award (2013), to name but a few. The German specialist journal “Opernwelt” has crowned her Singer of the Year twice, in 2005 and 2012, and in 2018 she received the largest prize in the history of classical music; The Birgit Nilsson Prize.  
  
It is clear to see how proud Sweden is of Nina Stemme, as is amply demonstrated by a generous list of honours, including the Birgit Nilsson scholarship , winner of Placido Domingos Operalia, “Litteris and Artibus” Royal medal (2008), the Jussi Björling Award (2016), the city of Stockholm’s Saint Eric medal (2017), International Swede of the Year 2018, and an honorary doctorate from the University of Lund, and the Musical Export Prize of Honour, awarded to her by the Swedish government in 2016.

Her special status as a singer of “extreme” roles is also reflected in her list of audio and video recordings. Alongside the “Tristan” recording conducted by Pappano, Nina Stemme’s performance of Isolde has also been documented in the form of a live recording from Berlin under Mark Janowski as well as a television recording of her Glyndebourne performance by Nikolaus Lehnhoff. Her rendition of “Walküre” Brünnhilde is available as an audio recording in St Petersburg under Valery Gergiev as well as a video recording of the La Scala production under Daniel Barenboim. The diversity and bandwidth of her repertoire is manifested in her interpretations of Zemlinsky’s “König Kandaules”, “Aida”, “Jenufa”, “Der Rosenkavalier” and “La Fanciulla del West”.  
  
The 2018 autumn season will begin at the Royal Opera House in London with the three Brünnhilde parts in Richard Wagner’s Der Ring des Nibelungen conducted by Antonio Pappano.