+++
date = "2024-04-29T00:00:00+00:00"
discipline = "Tenor"
lastmod = "2024-04-29T00:00:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1714412555/Nicholas-Phan.jpg"
primary_image_credit = ""
publishDate = "2024-04-29T00:00:00+00:00"
related_companies = ["scene/companies/boston-baroque.md"]
slug = ""
title = ""
website = ""
[[social_media]]
platform = "Facebook"
template = "social-media"
url = "https://www.facebook.com/nicholasphantenor/"
[[social_media]]
platform = "Instagram"
template = "social-media"
url = "https://www.instagram.com/grecchinois/"
[[social_media]]
platform = "YouTube"
template = "social-media"
url = "https://www.youtube.com/user/grecchinois01"
[[social_media]]
platform = "Twitter"
template = "social-media"
url = "https://twitter.com/grecchinois"
+++

Described by the _Boston Globe_ as "one of the world's most remarkable singers," American tenor Nicholas Phan is increasingly recognized as an artist of distinction. An artist with an incredibly diverse repertoire that spans nearly 500 years of music, he performs regularly with the world's leading orchestras and opera companies. Also an avid recitalist, in 2010 he co-founded the Collaborative Arts Institute of Chicago (CAIC) to promote art song and vocal chamber music, where he serves as artistic director.Phan begins the 2023-24 season curating and performing in CAIC's 12th annual Collaborative Works Festival. This year's festival theme, Song of Myself, examines the art of song as an expression of identity, and explores the complexity, multiplicity, and intersectionality of selfhood. Following the festival performances, he joins Portland-based string ensemble Palaver Strings for A Change is Gonna Come, a program he has curated in partnership with the group exploring song as a form of protest. In addition to songs by iconic social activist singer-songwriters like Joni Mitchell, Malvina Reynolds and Pete Seeger, the program features two song cycles composed expressly for Phan: Nico Muhly's _Stranger_ (in a new orchestration) and Errollyn Wallen's _Protest Songs_, a new work, of which he gave the world premiere performance in August.

Song cycles written for Phan feature prominently elsewhere in his 2023-24 performance calendar. He gives the West Coast premiere of Joel Puckett's orchestral song cycle There Was A Child Went Forth with the Berkeley Symphony and the world premiere of _Songs for the Next Generation_, a new song cycle about climate change by Vivian Fung, in a recital at New York's Kaufman Music Center, where he will be artist-in-residence for the entire 2023-24 season.

Other highlights of Phan's season include two returns to the San Francisco Symphony, for Handel's _Messiah_ with Jonathan Cohen and Stravinsky's _Pulcinella_ with Michael Tilson Thomas; performances of Orff's _Carmina Burana_ with the Baltimore Symphony under Jonathon Heyward and Orchestra of St. Luke's with Tito Muñoz at New York's Carnegie Hall; Mozart's Requiem with Jaap Van Zweden leading the New York Philharmonic; and a fully-staged production of Mozart's _Don Giovanni_, with Phan singing the role of Don Ottavio, with Boston Baroque.

A celebrated recording artist, Phan's most recent album, _Stranger: Works for Tenor by Nico Muhly_, was nominated for the 2022 Grammy Award for Best Classical Solo Vocal Album. His previous albums, _Clairières_ and _Gods and Monsters_, were nominated for the same award in 2020 and 2017. He is the first singer of Asian descent to be nominated in the history of the category, which has been awarded by the Recording Academy since 1959. His other previous solo albums _Illuminations_, _A Painted Tale_, _Still Fall the Rain_ and _Winter Words_, made many "best of" lists, including those of the New York Times, New Yorker, Chicago Tribune, WQXR, and the Boston Globe. Phan's continually-growing discography also includes a Grammy-nominated recording of Stravinsky's _Pulcinella_ with Pierre Boulez and the Chicago Symphony, Berlioz' _Roméo et Juliette_ with Michael Tilson Thomas and the San Francisco Symphony, Scarlatti's _La gloria di primavera_ and Handel's _Joseph and his Brethren_ with Philharmonia Baroque, an album of Bach's secular cantatas with Masaaki Suzuki and Bach Collegium Japan, Bach's _St. John Passion_ (in which he sings both the Evangelist and the tenor arias) with Apollo's Fire, and the world premiere recordings of two orchestral song cycles: _The Old Burying Ground_ by Evan Chambers and Elliott Carter's _A Sunbeam's Architecture_.

Sought after as a curator and programmer, in addition to his work as artistic director of CAIC, Phan is the host and creator of _BACH 52_, a web series examining the music of Johann Sebastian Bach. He has created programs for broadcast on WFMT and WQXR and has also served as guest curator for projects with the Philadelphia Chamber Music Society, Bravo! Vail Music Festival, Merola Opera program, Laguna Beach Music Festival, Apollo's Fire, and San Francisco Performances, where he served as the vocal artist-in-residence from 2014-2018. Praised by the Chicago Classical Review as "the kind of thoughtful, intelligent programming that should be a model," Phan's programs often examine themes of identity, highlight unfairly underrepresented voices from history, and strive to underline the relevance of music from all periods to the currents of the present day.

A prolific concert artist, Phan regularly appears with many of the leading orchestras in the world, including the Cleveland Orchestra, New York Philharmonic, Boston Symphony, Chicago Symphony, London Symphony, Bavarian Radio Orchestra, San Francisco Symphony, Los Angeles Philharmonic, Philadelphia Orchestra, National Symphony, Atlanta Symphony, St. Paul Chamber Orchestra, Minnesota Orchestra, Orchestra of St. Luke's, New World Symphony, Philharmonia Baroque, Hong Kong Philharmonic, Boston Baroque, Il Pomo d'oro, Bach Collegium Japan, Les Violons du Roy, Orchestre de la Suisse-Romande, BBC Symphony, English Chamber Orchestra, Strasbourg Philharmonic, Royal Philharmonic, Swedish Radio Symphony, Philharmonia Orchestra of London, Israel Philharmonic and the Lucerne Symphony. He has toured extensively throughout the major concert halls of Europe and has appeared with the Oregon Bach, Ravinia, Marlboro, Edinburgh, Rheingau, Saint-Denis, Music @ Menlo, and Tanglewood festivals, as well as the BBC Proms.  Among the conductors he has worked with are Marin Alsop, Harry Bicket, Herbert Blomstedt, Pierre Boulez, Karina Canellakis, Jonathan Cohen, James Conlon, Alan Curtis, Rafael Frühbeck de Burgos, Charles Dutoit, James Gaffigan, Grant Gershon, Alan Gilbert, Jane Glover, Giancarlo Guerrero, Matthew Halls, Manfred Honeck, Bernard Labadie, Louis Langrée, Cristian Măcelaru, Nicholas McGegan, Zubin Mehta, Riccardo Muti, John Nelson, Yannick Nézet-Séguin, George Petrou, Helmuth Rilling, David Robertson, Esa-Pekka Salonen, Masaaki Suzuki, Michael Tilson Thomas, Bramwell Tovey, Jaap Van Zweden and Franz Welser-Möst.

A passionate proponent of vocal chamber music, he has collaborated with many chamber musicians, including pianists Mitsuko Uchida, Richard Goode, Jeremy Denk, Graham Johnson, Roger Vignoles, Inon Barnatan, Myra Huang, Gabriel Kahane, and Alessio Bax; violinists James Ehnes and Tai Murray; cellist Paul Watkins; the Brooklyn Rider, Jasper and Spektral string quartets; guitarist Eliot Fisk; harpists Bridget Kibbey and Sivan Magen; and horn players Jennifer Montone, Radovan Vlatkovic and Gail Williams. In both recital and chamber concerts, he has been presented by Carnegie Hall, London's Wigmore Hall, San Francisco Performances, Cal Performances, the Aspen Music Festival, the Metropolitan Museum of Art, the Chamber Music Society of Lincoln Center, the Philadelphia Chamber Music Society, Atlanta's Spivey Hall, Boston's Celebrity Series, and the Library of Congress in Washington, DC. Often working to build the vocal chamber repertoire, numerous new song cycles have been composed for him by many of today's pre-eminent composers, including Lembit Beecher, Jake Heggie, Gabriel Kahane, Aaron Jay Kernis, Missy Mazzoli, Joel Puckett, Errollyn Wallen, and Nico Muhly.

Phan's many opera credits include appearances with the Los Angeles Opera, Houston Grand Opera, Glimmerglass Festival, Chicago Opera Theater, Seattle Opera, Portland Opera, Glyndebourne Opera, Maggio Musicale in Florence, Deutsche Oper am Rhein, and Frankfurt Opera. His operatic repertoire includes the title roles in Bernstein's _Candide_, Stravinsky's _Oedipus Rex_ and Handel's _Acis and Galatea_, Almaviva in _Il barbiere di Siviglia_, Nemorino in _L'elisir d'amore_, Fenton in _Falstaff_, Tamino in _Die Zauberflöte_, Don Ottavio in _Don Giovanni_, and Lurcanio in _Ariodante_.

As an educator, Phan served on the voice faculty of the DePaul University School of Music from 2018-2020 and currently serves as a coach on the faculty of the San Francisco Opera Center, where he works with the Adler Fellows. He has guest taught (working as both a voice teacher and a coach) at the Eastman School of Music, San Francisco Conservatory of Music, the University of Michigan School of Music, Theater, and Dance, the Merola Opera Program, and the Lindemann Young Artist Development Program at the Metropolitan Opera. In demand as a master class clinician, he has taught master classes for the Tanglewood Music Center, University of Michigan, San Francisco Conservatory of Music, Oberlin Conservatory, Boston Conservatory, University of Chicago, University of Houston, Longy School of Music, Oregon Bach Festival, American Conservatory Theater, and the San Francisco Girl's Chorus.

Raised in Ann Arbor, MI, Phan is a graduate of the University of Michigan and is the 2012 recipient of the Paul C Boylan Distinguished Alumni Award and the 2018 Christopher Kendall Award. He also studied at the Manhattan School of Music, the Aspen Music Festival and School, and is an alumnus of the Houston Grand Opera Studio.