+++
date = "2018-04-18T10:17:00-04:00"
discipline = "Soprano"
lastmod = "2018-04-18T10:17:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1524060891206/Michele_Capalbo.jpg.jpg"
primary_image_credit = "Leslie Hassler Studio"
publishDate = "2018-04-18T10:17:00-04:00"
related_companies = ["scene/companies/edmonton-opera.md","scene/companies/canadian-opera-company.md","scene/companies/san-francisco-opera.md"]
slug = "michele-capalbo"
title = "Michele Capalbo"
website = "http://www.michelecapalbo.com/index.html"
+++

Rarely is the opera world treated to the talents of a genuine Verdian soprano, Michele Capalbo is that rarity. Whatever the role, Michele’s portrayal of her characters’ emotional and psychological journey are tempered by a remarkable discipline of the bel canto vocal tradition. Her consistently stunning performances make clear Michele’s talents include a devotion to classical singing’s inherent beauty and drama; a commitment that succeeds in creating an authentic emotional connection with audiences. 

The New York Times describes Michele Capalbo as having “a genuine voice, from a lower register she actually uses to high floating pianissimos”. Widely renowned as an interpreter of Verdi and Puccini, Michele excels in capturing both the vulnerability and strength of some of opera’s greatest heroines, a specialty that prompted Opera News to proclaim her “a world-class Aida”. Although Aida has earned Michele the most illustrious praise to date, her impressive performance credits have already taken her to stages across North and South America as well as Europe. She is in demand for starring roles such as Verdi’s Desdemona, Lady Macbeth, Elisabetta, Amelia, and both Leonoras. In the verismo repertoire, her roles include Puccini’s Tosca, Madame Butterfly, Minnie and Manon Lescaut. Michele has been described by Opera News as “A statuesque beauty with strong stage presence” and someone who “may well be the verismo soprano we’ve been waiting for”. 

No stranger to the symphonic stage Michele’s recent worldwide concert performances have included Verdi’s Requiem with the Nashville Symphony Orchestra; Mahler’s 8th Symphony in Bergen, Norway; Poulenc’s Stabat Mater in Florence, Italy; and Beethoven’s 9th with the Vancouver Symphony Orchestra.

Born and raised in Southwestern Ontario, Canada; Michele was drawn to music at an early age. As a child she challenged herself to master the violin and flute and sang in an array of choirs. She was only 8-years old when she made her vocal debut at the Kitchener Kiwanis Festival. At 15, motivated by an inspiring high school music teacher, she continued to develop her natural vocal talents through private study where she was first exposed to dramatic classical singing and began to devour opera recordings. The recordings of Maria Callas, in particular, resonated with this young singer on both an emotional and musical level; and helped her to understand the characteristics of her own blossoming voice. Michele went on to graduate from the University of Western Ontario. After graduation she moved to New York where under the guidance of her teacher Arthur Levy, she worked to hone her tremendous skill in the bel canto and verismo traditions.

Michele’s career was effectively launched when she won the Liederkranz competition in New York after which she was immediately offered her first professional role as Hélène in Les Vêpres Siciliennes. The performance took place in front of tens of thousands in New York City’s Central Park as part of the popular Viva Verdi Series. Her European debut soon followed in the role of Aida with less than a week’s notice at Le Festival de Musique de Strasbourg. Subsequent successes in the title role of *Aida* came at Palacio de Bellas Artes, Mexico; Théâtre du Capitole de Toulouse, France; the Canadian Opera Company and San Francisco Opera.

In addition to a demanding performance schedule, Michele remains an advocate for music education as well as early performance opportunities and as such makes time to coach emerging opera singers through private studies and master classes. She is also called upon to adjudicate vocal competitions where it is her mission to meet each singer where they are in their development while at the same time challenging them to expand their understanding and expectation of their own vocal possibilities.

Her debut recording, the independently produced *Christmastide*, draws on the singers’ fondest childhood memories inspired by the relationship of Mother and Child. The 13-track disc features Verdi’s rarely heard *Ave Maria* for soprano and strings, sacred songs, lullabies and new arrangements of classic carols.

Offstage, Michele enjoys a quiet life filled with a multitude of creative pursuits including painting, gardening, interior design and quilting with vintage silk kimonos, a hobby that was first inspired by a visit to a katagami exhibit at the Seattle Art Museum. However, it is onstage where Michele’s creativity truly shines. She is an artist who acknowledges that music is indeed the language of feelings, and is willing to risk much in the pursuit of those rare musical moments that reveal the human voice at its most captivating.

Michele Capalbo currently lives in the New York area with her husband.
