+++
date = "2017-11-14T18:15:00-05:00"
discipline = "Composer"
lastmod = "2017-11-14T18:15:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510701236976/2017-11-14---Mark-Adamo-in-studio.jpg.jpg"
publishDate = "2017-11-14T18:15:00-05:00"
related_companies = ["scene/companies/the-dallas-opera.md","scene/companies/houston-grand-opera.md","scene/companies/washington-national-opera.md","scene/companies/san-francisco-opera.md","scene/companies/calgary-opera.md","scene/companies/the-banff-centre.md","scene/companies/lyric-opera-of-chicago.md"]
slug = "mark-adamo"
title = "Mark Adamo"
website = "http://www.markadamo.com/"
[[social_media]]
platform = "Facebook"
template = "social-media"
url = "https://www.facebook.com/operamarkadamo/"
+++

American composer-librettist Mark Adamo prepared for the world-première performances in June 2013 of his third full-length opera, *The Gospel of Mary Magdalene*, following a busy season of opera and chamber premières. In May 2012, Fort Worth Opera opened its first production of his second opera, *Lysistrata*; that September, the Constella Festival in Cincinnati opened their season with August Music, for flute duo and string quartet, commissioned by Sir James and Lady Jeanne Galway: in December, Sasha Cooke and the New York Festival of Song introduced *The Racer’s Widow*, a cycle of five American poems for mezzo-soprano, cello, and piano; and, in April 2013, baritone Thomas Hampson and the Jupiter String Quartet introduced Aristotle, after the poem by Billy Collins, in concerts at the Mondavi Center in Davis, California before continuing to Boston and New York under the auspices of the Chamber Music Society of Lincoln Center.

Adamo first attracted national attention with his uniquely celebrated début opera, *Little Women*, after the Alcott novel. Introduced by Houston Grand Opera in 1998 and revived there in 2000, *Little Women* is one of the most frequently performed American operas of the last fifteen years, with more than 80 national and international engagements in cities ranging from New York to Minneapolis, Toronto, Chicago, San Francisco, Adelaide, Perth, Mexico City, Brugges, Banff, Calgary, and Tokyo, where it served as the official U.S. cultural entrant to the 2005 World Expo. The Houston Grand Opera revival (2000) was telecast by PBS/WNET on Great Performances in 2001 and released on CD by Ondine that same year; in fall 2010, Naxos released this performance on DVD and on Blu-ray. (Little Women was the first American opera recorded in high-definition television.) Comparable enthusiasm greeted the début of the larger-scaled *Lysistrata*, Adamo’s second opera, adapted from Aristophanes’ comedy but also including elements from Sophocles’ *Antigone*. *Lysistrata* was commissioned by Houston Grand Opera for its 50th anniversary and introduced in March 2005: its New York City Opera debut in March 2006 led to concert performances by Washington National Opera (May 2006) and Music at the Modern by the Van Cliburn Foundation (May 2007) before the new staging of the work at Fort Worth Opera in spring 2012, which was included on the best-of-2012 lists of both D Magazine and the Fort Worth Star-Telegram.

While Adamo’s principal work continues to be for the opera house, over the past 5 years he has ventured not only into chamber music but also into symphonic and choral composition.  Adamo’s first concerto, *Four Angels*, for harp and orchestra, was commissioned by the National Symphony Orchestra and debuted in June 2007: the Utah Symphony, led by their Music Director Emeritus, Keith Lockhart, presented *Four Angels* in January 2011. In May 2007, Washington’s Eclipse Chamber Orchestra, for which Adamo served as its first composer-in-residence, performed the revised version of Adamo’s *Late Victorians*, a cantata for singing voice, speaking voice, and orchestra: Naxos released *Late Victorians* in 2009 on Eclipse’s all-Adamo CD, which also included Alcott Music, from Little Women, for strings, harp, celesta, and percussion; “Regina Coeli,” an arrangement of the slow movement of *Four Angels* for harp and strings alone; and the Overture to Lysistrata for medium orchestra.  In April of 2010, Harold Rosenbaum’s New York Virtuoso Singers paired six of Adamo’s newly-published choral scores with the complete chamber-choral work of John Corigliano. This concert featured the New York premières of *Cantate Domino* (after Psalm 91,) *Pied Beauty* and *God’s Grandeur* (Gerard Manley Hopkins; commissioned by the Gregg Smith Singers,) *Matewan Music* (Appalachian folk-tune variations,) *Supreme Virtue* (Stephen Mitchell’s translation of the Tao te Ching,) and *The Poet Speaks of Praising* (Rilke: commissioned and introduced by Chanticleer.)

Composer-in-residence at New York City Opera from 2001 through 2006, where he led the VOX: Showcasing American Composers program, Adamo also served as Master Artist at Atlantic Center for the Arts in May 2003.  Since 2007 he has served as the principal teacher of American Lyric Theatre’s Composer-Librettist Development Program in New York, in which he coaches teams of composers and librettists in developing their work for the stage.

Adamo began his education in the Tisch School of the Arts at New York University, where, as a freshman in the Dramatic Writing Program, he received the Paulette Goddard Remarque Scholarship for outstanding undergraduate achievement in playwriting. He went on to earn a Bachelor of Music Degree cum laude in composition in 1990 from the Catholic University of America.  His music is published exclusively by G. Schirmer, Inc.
