+++
date = "2015-05-18T15:20:00-04:00"
discipline = "Mezzo-soprano"
lastmod = "2015-05-18T15:21:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1431976554347/0224_052004_03.jpg.jpg"
primary_image_credit = "Marty Umans"
publishDate = "2015-05-18T15:21:00-04:00"
related_companies = ["scene/companies/the-metropolitan-opera.md","scene/companies/lyric-opera-of-chicago.md","scene/companies/san-francisco-opera.md","scene/companies/oberlin-college-and-conservatory.md","scene/companies/music-academy-of-the-west-voice-program.md"]
slug = "marilyn-horne"
title = "Marilyn Horne"
+++

She has been called the "Star Spangled Singer" and "the Heifetz of singers." In 2002, after a career in which for over four decades Marilyn Horne had dominated her field, Opera News said, “Marilyn Horne – whose face and song have been in the light – in so many places, in so many styles, through so many media, for so many years – may be the most influential singer in American history.”  

Marilyn Horne continues to be one of America’s most beloved artists.  She has received numerous accolades and honors in the arts as well as academia.  Miss Horne was inducted into the American Academy of Arts and Sciences in October 2009 and the next month was honored in Washington, DC as the 2009 recipient of the National Endowment for the Arts Opera Honors.  President Clinton named her a Kennedy Center Honoree in 1995.  In 1992, she received the National Medal of the Arts from President Bush and the Endowment for the Arts.  Miss Horne sang at the Reagan, Bush, and Clinton White Houses and at President Clinton’s inauguration in 1993.  In October of 2000, Miss Horne returned to the town of her birth, Bradford, Pennsylvania, where a street on the public square was named in her honor.  On that occasion, she also presented the opening season gala for the Bradford Creative and Performing Arts Center, where she was presented with the Presidential Medal of Distinction from the University of Pittsburgh at Bradford.  

Now holding her sixteenth year of residency at the University of Oklahoma (Norman), her ninth with the Oberlin Conservatory Marilyn has given master classes for five years at the University of Maryland (College Park), has recently offered first time master classes at the New England Conservatory of Music in Boston, Massachusetts, the Peabody Conservatory of Music in Baltimore, Maryland, at St. Joseph’s College in West Hartford, Connecticut and was part of the inaugural season of a new master class program, Lieder Alive! at the San Francisco Conservatory of Music.

Recent and very special milestones and achievements for Marilyn Horne include being a recipient of the prestigious Opera News Award, the highest honor given within the opera industry, to recognize distinguished contributions from leading figures in the world of opera. In January of 2009 she celebrated her 75th Birthday and the 15th Anniversary of the founding of the Marilyn Horne Foundation with a star-studded Gala concert at Carnegie Hall.  

Among Marilyn Horne's many worldwide prizes are the Commander of the Order of Arts and Letters from France's Ministry of Culture, the Commendatore al Merito della Repubblica Italiana, the Fidelio Gold Medal from the International Association of Opera Directors, and the Covent Garden Silver Medal for Outstanding Service.  Miss Horne's international success in the most difficult of coloratura mezzo-soprano roles led to the revival of many of Rossini’s and Handel's greatest operas.  In an unprecedented move, Marilyn Horne received Italy’s first Rossini Medaglia d’Oro, created especially for her.

Miss Horne celebrated twenty-six years as a leading lady at the Metropolitan Opera, and was honored at the San Francisco Opera for her thirty-nine seasons there in October 1999.  Her many academic awards include numerous honorary doctorates from schools including the Juilliard School, Johns Hopkins University and the San Francisco Conservatory of Music.  In 1999, Miss Horne was inducted into the American Classical Music Hall of Fame.  In 2001, Miss Horne received a President’s Merit Award from the National Academy of Recording Arts and Sciences and was inducted into the Hollywood Bowl Hall of Fame.

Grammy Awards have been presented to Miss Horne for several of her operatic recordings.  These include Handel's *Semele* (Deutsche Grammaphon), *Presenting Marilyn Horne*, *In Concert at the Met with Leontyne Price and Marilyn Horne*, and *Carmen* (conducted by Leonard Bernstein).  In April, 2008, Decca released an 11 CD set entitled *Marilyn Horne, The Complete Decca Recitals*, as well as re-released *Souvenir of a Golden Era* to highlight Miss Horne’s appearance as Host/Narrator for the North American premiere of “Pauline Viardot and Friends,” under the auspices of San Francisco presents, also starring Frederica Von Stade and Vladimir Chernov. Additional releases include a collection of songs of Bernstein, Barber and Bolcom, entitled *I Will Breathe a Mountain*, on BMG and a recording of the songs of Irving Berlin that was released by VAI in 2000. In 2005, BMG-Sony re-released two of Miss Horne’s CDs – *Christmas with the Mormon Tabernacle Choir* and *All Through the Night*, a collection of the world’s most beloved lullabies for children. A two CD compilation entitled *Just for the Record – The Golden Voice of Marilyn Horne*, from Universal Classics, was released for Miss Horne’s 70th birthday celebration in 2004. Also released for this occasion, was Miss Horne’s updated autobiography, *The Song Continues*, written with Jane Scovell from Baskerville Press.

In celebration of her 60th birthday in January of 1994, Miss Horne launched The Marilyn Horne Foundation, dedicated to the art of the vocal recital and presentation of young singers in recital throughout the United States.  In its 16 years, the Foundation introduced over 30,000 students to the vocal recital and classical song through more than 300 education programs across the country, along with full recital appearances in New York City and many cities throughout the nation. In July 2010 the Foundation’s programs became part of the venerable Carnegie Hall. Miss Horne remains Artistic Advisor to her song programs, now The Marilyn Horne Legacy at Carnegie Hall, where, in keeping with the January tradition of Miss Horne’s birthday, a week of recitals and master classes are offered by artists such as Maestro James Levine, Christa Ludwig, Grace Bumbry, Thomas Hampson, Regine Crespin, Warren Jones, Brian Zeger and Martin Katz.

Marilyn Horne is on the faculty at the Music Academy of the West in Santa Barbara, California.  As Vocal Program Director, she teaches public master classes and private lessons to some of the world's most promising young artists.  Miss Horne has been responsible for reviving full length staged opera performances at the Academy with brand new productions of Rossini's *Il Viaggio a Reims* - a smashing success - and Mozart's *Die Zauberflöte* in 1997 and 1998, followed by Handel's rarely performed opera, *Rodelinda* in the summer of 1999, Richard Strauss’s masterpiece, *Ariadne auf Naxos* in the summer of 2000, and Donizetti’s *Don Pasquale* and Debussy’s *Pelléas and Mélisande* (the Peter Brook, 90-minute, two piano version) in 2001.  Productions of Benjamin Britten’s opera *Albert Herring* and Mozart’s great masterpiece, *Le Nozze di Figaro* followed respectively in 2002 and 2003. 2004 brought Nino Rota’s *Il Cappello di Paglia di Firenze*, and Mozart’s classic *Cosi fan Tutte* was presented in 2005.  Rossini’s *Il Viaggio a Reims* made its second appearance in 2006 and Puccini’s *La Bohème* made its Music Academy debut in 2007.  William Bolcom’s *The Wedding*, received high acclaim as the 2008 production and in 2009, Thomas’ *Mignon* received a rare and highly anticipated staging. She since has followed up with the staging of Mozart’s *Don Giovanni* in 2010, Rossini’s *Barber of Seville* in 2011, Stravinsky’s interpretative *The Rake’s Progress* in 2012, a return of *Die Zauberflöte* in 2013, and a production of *Carmen* in 2014, set in Santa Barbara’s own surrounding mountains circa 1850, and heralded as ‘persuasive’ by Opera News magazine. 

Born in Bradford, Pennsylvania, Marilyn Horne began her musical studies with her father and first sang in public at the age of two.  When she was eleven, her family moved to Long Beach, California.  After completing high school at Long Beach Polytechnic, she studied voice with William Vennard and song/recital works with Gwendolyn Koldofsky (her accompanist thereafter for ten years) at the University of Southern California.  During that time, she also participated in master classes with Lotte Lehmann at the Music Academy of the West in Santa Barbara and Cal Tech in Pasadena.  At the age of twenty, she made her operatic debut with the Los Angeles Guild Opera and, at that same age, dubbed the voice of Carmen in the highly successful film of *Carmen Jones* starring Dorothy Dandridge as Carmen.  Her early operatic career included three years at the Gelsenkirchen Municipal Opera, Germany where she sang a wide variety of starring roles.  In 1960, she returned to the U.S. where she presented her sensational debut in Berg's Wozzeck with the San Francisco Opera Company, followed by her Lyric Opera of Chicago debut in 1961. In September of 1999, Miss Horne fulfilled a personal goal of singing in all fifty states with an engagement in Laramie, Wyoming. 

In the year 2000, Marilyn Horne stopped programming classical repertoire in recital, and began to offer programs that reflect her deep and abiding interest and experience, since childhood, in American folk and popular songs.  In collaboration with Tony Award winning pianist, arranger, and conductor Don Pippin, she presents to this day *An Evening of Great American Popular Songs*, which debuted in 2000 at the Bradford Creative and Performing Arts Center. Additional programs in recent years have included *Steppin’ Out with Irving Berlin*, with tenor Robert White and pianist Dick Hyman, which opened the concert series of the Metropolitan Museum of Art in New York City in October 2000 and Stephen Foster: Songs of America, which debuted with the New Jersey Symphony Orchestra for the 2002-03 opening season gala.  Just Between Friends with Barbara Cook, which debuted in spring of 2002 at the Wharton Center, in East Lansing, MI, continues to receive rave reviews, with performances at Symphony Hall, Boston, The Kravis Center in West Palm Beach, Florida, Lehigh University’s Zoellner Arts Center, Clarice Smith Performing Arts Center in College Park, MD, and, most recently, in May 2008 at the Granada Theatre in Santa Barbara, CA. 

Actively dedicated to excellence in vocal art, Miss Horne has ongoing commitments for private teaching and master classes throughout the world - well into the next decade.

