+++
date = "2016-11-08T10:37:00+00:00"
discipline = "Composer"
lastmod = "2016-11-08T11:58:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1478601464090/Kevin_Puts_HS.jpg.jpg"
primary_image_credit = "David White."
publishDate = "2016-11-08T10:38:00+00:00"
related_companies = ["scene/companies/minnesota-opera.md"]
slug = "kevin-puts"
title = "Kevin Puts"
website = "http://www.kevinputs.com/"
[[social_media]]
platform = "Facebook"
template = "social-media"
url = "https://www.facebook.com/KevinPutsMusic"
+++

Winner of the 2012 Pulitzer Prize for his debut opera *Silent Night*, Kevin Puts has been hailed as one of the most important composers of his generation. Critically acclaimed for a richly colored, harmonic, and freshly melodic musical voice that has also been described as “emotional, compelling, and relevant,” his works, which include two operas, four symphonies, and several concertos, have been commissioned, performed, and recorded by leading orchestras, ensembles and soloists throughout the world.

Silent Night was premiered by Minnesota Opera in November 2011, and marked his debut in the genre of opera and vocal works. Commissioned by Minnesota Opera with a libretto by Mark Campbell, the full-length opera is based on the 2005 film *Joyeux Noel*. Heralded as “breathtaking” and “a stunning emotional experience”, Silent Night has since been produced and performed at Opera Philadelphia, Fort Worth Opera, Cincinnati Opera, the Wexford Opera Festival, Calgary Opera, Opera de Montreal, and the Lyric Opera of Kansas City, with upcoming productions at Atlanta Opera, Opera Santa Jose, and Michigan Opera Theatre.

Acclaimed as “thrilling” and “not to be missed,” Mr. Puts' second opera, an adaptation of Richard Condon's novel *The Manchurian Candidate*, also commissioned by Minnesota Opera with a libretto by Mark Campbell, had its world premiere in March 2015. March 2015 also saw the world premiere of Mr. Puts’ song cycle *Of All The Moons*, commissioned by Carnegie Hall and performed by mezzo-soprano Sasha Cooke, which The New York Times called “a showcase for his craftsmanship.”

His newest orchestral work, *The City*, was premiered in Baltimore and New York in April 2016. Co-commissioned by the Baltimore Symphony Orchestra in honor of its 100th anniversary and by Carnegie Hall in honor of its 125th anniversary, the New York Times called it “captivating from the start” and The Baltimore Sun writes that Mr. Puts “never disappoints in terms of orchestral coloring…distinctive lyrical style…and passages of intense melodic fire.”

November 2016 will see international opera star Rénee Fleming and the Eastman School of Music Philharmonia performing the world premiere in New York City of a new work based on the personal letters of Georgia O’Keeffe and commissioned by the Eastman School of Music. In September 2017, Mr. Puts will premiere his first chamber opera, an adaptation of Peter Ackroyd’s gothic novel *The Trial of Elizabeth Cree*, which has been commissioned by Opera Philadelphia with libretto by Mark Campbell.

In August 2015, *Seascapes*, the first entire recording of Mr. Puts’ chamber works, was released by BCMF records through Naxos. Featuring a star-studded list of performers, it features among other works the premier recording of *Seven Seascapes*, commissioned by the Bridgehampton Chamber Music Festival.

In 2013, Mr. Puts’ *Flute Concerto* received its world premiere at the Cabrillo Festival with Adam Walker, Principal Flute of the London Symphony. Called “brilliant” and “a significant addition to the flute concerto repertoire,” it will soon be available on a new recording of Puts’s works performed by the Peabody Symphony Orchestra and conducted by Marin Alsop to be released on the Naxos label in 2016 and which will also include a recording of Puts' Symphony No. 2.

Also in 2013, Mr. Puts’ soaring choral works *To Touch The Sky* and *If I Were A Swan* were performed by the á capella ensemble Conspirare. A recording was released on the Harmonia Mundi label, which also includes a performance of his *Symphony No. 4: From Mission San Juan*, performed by the Baltimore Symphony Orchestra conducted by Marin Alsop. 2013 also saw the world premiere of Mr. Puts’s chamber work *How Wild The Sea* by the Miro Quartet, an “intensely emotional” work for string quartet and chamber orchestra, which was commissioned jointly by the University of Texas at Austin, St. Paul Chamber Orchestra, City Music Cleveland, ProMusica Chamber Orchestra, and the Naples Philharmonic. This premiere followed an earlier heralded and widely performed commission for the Miro Quartet, *Credo*, which was commissioned by Chamber Music Monterey Bay.

His other critically acclaimed works include Arcana, which was commissioned and premiered in 2089 by the string sextet Concertante; *Trio-Sinfonia*, commissioned by Music Accord and premiered in 2007 by the Eroica Trio; *Four Airs*, commissioned by the Music from Angel Fire Festival in 2004; *Three Nocturnes*, commissioned and premiered by the Verdehr Trio in 2004; *Chorus of Lights*, Mr. Puts’ first work for winds, commissioned by the University of Texas Wind Ensemble in 2003; and *Einstein on Mercer Street*, commissioned by the Pittsburgh New Music Ensemble and premiered by bass-baritone Timothy Jones with Kevin Noe conducting in summer 2002.

In April 2008, Jeffrey Kahane and the Los Angeles Chamber Orchestra premiered *Night*, a piano concerto commissioned through the LACO's Sound Investment program. Mr. Puts has since performed the work himself as soloist during the summer of 2010 with Marin Alsop conducting the Cabrillo Festival Orchestra. His *Clarinet Concerto*, received its premiere in 2009 with the clarinetist Bil Jackson and the Colorado Symphony conducted by Jeffrey Kahane. As the Composer-in-Residence for the Fort Worth Symphony, Mr. Puts composed a violin concerto for its concertmaster, Michael Shih, which was premiered in April 2007 with Miguel Harth-Bedoya conducting and later recorded by the orchestra. In 2007, as the American Composer-in-Residence at the Bravo! Vail Valley Music Festival, his *Two Mountain Scenes* was premiered by the New York Philharmonic. Later that summer, his *Symphony No. 4: From Mission San Juan* was premiered at the Cabrillo Festival.  

Mr. Puts' 2005-2006 season included the premieres of three major orchestral works: *Percussion Concerto* for Orange County's Pacific Symphony and the Utah Symphony, premiered and performed by Dame Evelyn Glennie; *Sinfonia Concertante* for five solo instruments and orchestra for the Minnesota Orchestra; and a cello concerto, *Vision*, which was commissioned by the Aspen Music Festival and performed by Yo-Yo Ma in honor of David Zinman's 70th birthday. In 2004, Leonard Slatkin and the Saint Louis Symphony commissioned River's Rush in honor of the opening celebration of the orchestra's 125th anniversary season. Mr. Puts’ *Symphony No. 3: Vespertine* was commissioned though the Meet the Composer "Magnum Opus" project and premiered by the Marin Symphony Orchestra in May 2004.

His earlier commissions include *This Noble Company*, which was commissioned and premiered by the Atlanta Symphony in 2003, and Falling Dream, which was commissioned by the American Composers Orchestra/BMI Foundation and premiered at Carnegie Hall in 2002 with Dennis Russell Davies conducting the American Composers Orchestra at its 25th Anniversary Concert. Mr. Puts’ Symphony No. 2, commissioned as a result of his winning the Barlow International Orchestra Competition, was premiered by the Cincinnati Symphony Orchestra under Paavo Jarvi in 2002 and later performed by the Utah Symphony conducted by Keith Lockhart. In 2001, Millennium Canons, commissioned by the Institute for American Music, was premiered by The Boston Pops and conductor Keith Lockhart, and has subsequently received multiple performances across the U.S. and around the world. Other important early commissions came from the New York Youth Symphony, which premiered his *Concerto for Everyone* at Carnegie Hall in 1999; the Vermont Symphony and Ensemble Kobe (Japan), which co-commissioned *Marimba Concerto* featuring Makoto Nakura; and the National Symphony Orchestra, which commissioned the *Fanfare Continuo* for brass and organ.

In addition to the Pulitzer Prize, Mr. Puts has received numerous honors and awards for composition. These include the 2015 Arts and Letters Award and the 2003 Benjamin H. Danks Award for Excellence in Orchestral Composition, both from the American Academy of Arts and Letters, as well as the Delaware Symphony Orchestra's 2015 Alfred I. duPont Composer's Award; the 2013 Eddie Medora King Award for Composition by the Butler School of Music of the University of Texas at Austin; a 2001 John Simon Guggenheim Memorial Foundation Fellowship; a 2001-2002 Rome Prize from the American Academy in Rome; and the 1999 Barlow International Prize for Orchestral Music. In 1996, Mr. Puts was also named Composer-in-Residence of both Young Concert Artists and the California Symphony. While an undergraduate at the Eastman School of Music, Mr. Puts was awarded a Charles Ives Scholarship from the American Academy of Arts and Letters; the BMI 2001 Carlos Surinach Fund Commission; BMI's 1998 William Schuman Prize; and several grants from BMI and ASCAP.

A native of St. Louis, Missouri, Mr. Puts received both his Bachelor's Degree and his Doctor of Musical Arts Degree from the Eastman School of Music, and his Master's Degree from Yale University. From 1999 to 2005, he taught composition at The University of Texas at Austin. Since 2006, he has been a member of the Composition Faculty at the Peabody Institute, and currently is the Director of the Minnesota Orchestra Composer’s Institute.
