+++
discipline = "Soprano"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1572812052/media/2019/11/Kathryn_Lewek_WEB_SMALL-15_qx7jid.jpg"
primary_image_credit = ""
related_companies = ["scene/companies/welsh-national-opera.md", "scene/companies/english-national-opera.md", "scene/companies/wiener-staatsoper.md", "scene/companies/houston-grand-opera.md", "scene/companies/lyric-opera-of-chicago.md", "scene/companies/teatro-alla-scala.md", "scene/companies/lyric-opera-of-kansas-city.md", "scene/companies/the-metropolitan-opera.md", "scene/companies/royal-opera-house.md", "scene/companies/washington-national-opera.md", "scene/companies/nashville-opera.md"]
slug = "kathryn-lewek"
title = "Kathryn Lewek"
website = "https://www.kathrynlewek.com/"
[[social_media]]
platform = "Facebook"
template = "social-media"
url = "https://www.facebook.com/kathrynleweksoprano/"
[[social_media]]
platform = "Twitter"
template = "social-media"
url = "https://twitter.com/KathrynLewek"

+++
Kathryn Lewek has established herself as one of opera’s most thrilling coloratura sopranos of this generation, performing some of the most vocally challenging roles in the repertoire, joining the top-ranking operatic performers of all time.

Following her “especially brilliant” début as Ginevra in **_Ariodante_** with the Salzburger Pfingstfestspiele in Austria, opposite Cecilia Bartoli, where Ms. Lewek “perform\[ed\] a miracle” and thrilled audiences with “a rich (and richly differentiated) soprano voice \[that\] has not been experienced for a long time” she returned this summer in Barrie Kosky’s new production of **_Orphée aux Enfers_** “ravishingly” singing the “the raunchy, full-throttle” role of Eurydice, once again wowing critics and audiences alike for her versatility as a performer and prompting Opera Wire to exclaim her Artist of the Week and a 5 page spread in Salzburg’s official festival magazine.

This season will include her seventh season as The Metropolitan Opera’s Queen of the Night in **_Die Zauberflöte_,** a role she will also perform in returns to Washington National Opera and Bayerische Staatsoper (Munich). In addition, she will perform Konstanze in **_Die Entführung aus dem Serail_** with the Lyric Opera of Kansas City, the title role in **_Lucia di Lammermoor_** with Opéra de Nice, début the role of Gilda in **_Rigoletto_** with her husband tenor Zach Borichevsky in the role of the Duke for both Nashville Opera and Central City Opera, début the role of Ophelia in Brett Dean’s **_Hamlet_** for the Netherlands Radio Philharmonic Orchestra at The Concertgebouw in Amsterdam, perform the role of Angelica in Handel’s masterpiece **_Orlando_** on tour throughout Europe, and perform a series of solo recitals in US. Future seasons include multiple returns to The Metropolitan Opera, débuts with Teatro alla Scala, Royal Opera House Covent Garden, amongst several other houses yet to be announced. Upcoming new roles include Juliette in **_Romeo et Juliette_**, Cleopatra in Handel’s **_Giulio Cesare_**, the title role in Massenet’s **_Manon_**, all three Heroines in Offenbach’s epic **_Les contes d’Hoffmann,_** and the triple crown roles of the Queens in Donizetti’s trilogy, **_Anna Bolena, Maria Stuarda_**, and **_Roberto Devereux._**

With an impressive history of leading female roles in her career, recent seasons’ engagements have also included role débuts as Teresa in **_Benvenuto Cellini_** with Gran Teatre del Liceu in Barcelona; Konstanze in **_Die Entführung aus dem Serail_** with Deutsche Oper Berlin and subsequently in her house début with the Bayerische Staatsoper (Munich); a reprisal of her performance as Ginevra in **_Ariodante_** with Opera Monte Carlo; the title role of **_Maria Stuarda_** with Edmonton Opera; and Rosina in **_Il barbiere di Siviglia_** and the title role in **_Lucia di Lammermoor_** with Toledo Opera and Opera Carolina. Other notable roles include Angelica in Händel’s **_Orlando_** with The Hobart Baroque in Tasmania; La Fée in **_Cendrillon_** with New Orleans Opera; and Cunegonde in Francesca Zambello’s **_Candide_** in her company début with Glimmerglass Opera. European débuts also include the role of Jessica in the world première of André Tchaikowsky’s **_Kupiec Wenecki (The Merchant of Venice)_** with Bregenzer Festspiele. This production was awarded the International Opera Award 2014 in the category “Best World Première”.

Ms. Lewek’s interpretation of her signature role, a quintessential Mozart villain, has labelled her the current reigning Queen of the Night of the world, with over 250 performances to date, and has garnered international critical acclaim: “Kathryn Lewek, a favorite Queen of the Night these days, nailed her otherworldly coloratura arpeggios to the wall in her ‘Vengeance’ aria, but more impressive to me was the pathos with which she quickly conveyed, in Act 1, the full suffering of a mother whose child has been kidnapped.” She has performed the role in productions of **_Die Zauberflöte_** with The Metropolitan Opera, The Deutsche Oper Berlin, Bregenzer Festspiele, Houston Grand Opera, Lyric Opera of Chicago, Washington National Opera, Wiener Straatsoper, Teatro Real in Madrid, Festival d’Aix-en-Provence, Festival Castell de Peralada, Opera Leipzig, Opera de Toulon, English National Opera, Nashville Opera, Lyric Opera of Kansas City, Welsh National Opera, The Royal Danish Opera, and in concert with the Pacific Symphony, Indianapolis Symphony, and as one of the ten pieces in “Sir Henry’s Magnificent Musical Inspirations” concert with the Royal Philharmonic Orchestra at BBC Proms Classical Music Festival.

Of her Carnegie Hall début in Händel’s **_Messiah_**, _The_ _New York Times_ hailed “Communicative verve and thrilling beauty came together in the soprano Kathryn Lewek. She began ‘Rejoice greatly, O daughter of Zion’ at exhilarating speed, then took her time on the words ‘He shall speak peace,’ lovingly ornamenting the cadence in a way that was both original and entirely subservient to the music.” She has since performed the piece with both the Oratorio Society of New York and Musica Sacra of New York at Carnegie Hall every season since 2012.

Having been widely lauded for her numerous operatic and oratorio performances, Ms. Lewek is also receiving critical acclaim for her decisive interpretations of contemporary art song and vast concert repertoire. Recent concert engagements for Ms. Lewek include Bach’s **_B-minor Mass_** with Soli deo Gloria, **_Carmina Burana_** with Dallas Symphony, **_Celebrating Leonard Bernstein at 100_** for Washington National Opera, Bach’s **_Christmas Oratorio_** with Orchestra symphonique de Montréal, and Haydn’s **_Creation_** under the baton of the illustrious Maestro John Nelson. She frequently performs in Gala concerts and solo recitals across the country in a variety of repertoire, as well as with her husband, tenor Zach Borichevsky, most recently for The Opera Foundation, Rockefeller University, and Messiah College.

Additionally, she enjoyed appearances at Alice Tully Hall at Lincoln Center, on the Perelman Stage at Carnegie Hall, with the Rochester Philharmonic Orchestra, the Santa Barbara Symphony, Toledo Symphony, Music of the Baroque, the Fairfield County Chorale, the Berkshire Choral Festival, the Great Neck Choral Society, Finger Lakes Choral Society, the Greenwich Choral Society, and the Rochester Chamber Orchestra. With these and other orchestras, she performed in Händel’s **_Israel in Egypt_**; Mozart’s **_C-minor Mass_**, **_Krönungmesse (Coronation Mass)_**, and **_Requiem_**; Orff’s **_Carmina Burana_**; Haydn’s **_Missa in tempore belli_** and **_Große Orgelmesse_**; Verdi’s **_Requiem_**, Bach’s **_Magnificat_**, **_Judas Maccabeus_**, and **_Christ lag in Todas Banden_**; Brahm’s **_Requiem_**; Mendelsshon’s **_Elijah_**; Carissimi’s **_Vanitas Vanitatum_**; Monteverdi’s **_Vespro della Beata Vergine 1610_**; and Zelenka’s **_Te Deum_**.

Ms. Lewek has two recordings on the Albany Records label, _Kathryn Lewek sings Cary Ratcliff_, and the collaborative album _Quicksilver_, with the internationally acclaimed guitar and flute duo Nicholas Goluses and Bonita Boyd.

Ms. Lewek began her career as the grand prize winner of the Opera Foundation’s International Vocal Scholarship and was granted a contract with the Deutsche Oper Berlin where she performed roles in thirteen productions. Whilst there she also performed Dolcina in **_Suor Angelica_** with the Deutsches Symphonie Orchester.

She was a double prize winner at the 2013 Operalia World Opera Competition including the highly competitive Audience Favorite Award. Ms. Lewek earned Bachelor of Music and Master of Music degrees in Voice Performance and Literature from the Eastman School of Music, where she was also awarded a Performance Certificate in Voice for her many successes upon the Eastman Theater stage. She was a Music Academy Fellow during the summer of 2009 at the Music Academy of the West in Marilyn Horne’s esteemed vocal program where she was hailed as “…one of those inspiring triumphs from the wings” and was praised for her “strength and radiance.” Ms. Lewek continues her vocal studies with the internationally renowned soprano, Diana Soviero, in New York City.