+++
discipline = "Soprano"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1696185592/JuliaBullock_headshot.jpg"
primary_image_credit = "Photo: Allison Michael Orenstein."
related_companies = ["scene/companies/san-francisco-opera.md", "scene/companies/the-dallas-opera.md", "scene/companies/utah-opera.md", "scene/companies/oper-frankfurt.md", "scene/companies/royal-opera-house.md", "scene/companies/english-national-opera.md", "scene/companies/the-metropolitan-opera.md", "scene/companies/gran-teatre-del-liceu-opera.md", "scene/companies/the-santa-fe-opera.md"]
slug = "julia-bullock"
title = "Julia Bullock"
website = "https://juliabullock.com/"
[[social_media]]
platform = "Instagram"
template = "social-media"
url = "https://www.instagram.com/_juliabullock/"
[[social_media]]
platform = "Facebook"
template = "social-media"
url = "https://www.facebook.com/JuliaBullockSings/"

+++
An American classical singer who "communicates intense, authentic feeling, as if she were singing right from her soul" (_Opera News_), Julia Bullock is "an essential soprano for our times" (_Los Angeles Times_). Combining versatile artistry with a probing intellect and commanding stage presence, she has headlined productions and concerts at preeminent arts institutions around the world. Also in demand as an innovative curator, her past positions include collaborative partner of Esa-Pekka Salonen, 2020–22 Artist-in-Residence of London's Guildhall School, 2019-20 Artist-in-Residence at the San Francisco Symphony, and 2018-19 Artist-in-Residence at New York's Metropolitan Museum of Art. A prominent voice of social consciousness and activism, Bullock is "young, highly successful, [and] politically engaged," with the "ability to inject each note she sings with a sense of grace and urgency, lending her performances the feel of being both of the moment and incredibly timeless" (_Vanity Fair_).

In the 2023-24 season, Bullock looks forward to a number of operatic "firsts." John Adams's and Peter Sellars's oratorio _El Niño_ is the vehicle for her Metropolitan Opera debut, in a new production led by Marin Alsop. Marking Bullock's debut at Barcelona's Gran Teatre del Liceu, she stars opposite Gerald Finley in the European premiere of Adams's opera _Antony & Cleopatra_, before headlining Dutch National Opera's world premiere production of _The Shell Trial_, the climate-themed opera she created in collaboration with Pulitzer Prize-winning composer Ellen Reid, librettist Roxie Perkins and musical director Manoj Kamps. Bullock will present her project _Nativity Reconsidered: El Niño_ – a distilled rendering of the original _El Niño_ – alongside conductor Christian Reif (who also created the new musical arrangement) at the Cincinnati Symphony and on a U.S. tour with the American Modern Opera Company (AMOC), of which Bullock is a founding core member. Over the coming season, she also undertakes a residency as 2023–24 Featured Artist of London's Philharmonia Orchestra and gives recitals in Philadelphia, Baltimore, Providence and at the Park Avenue Armory in New York. 

Bullock has made many key operatic house debuts: at London's Royal Opera House in Handel's _Theodora_; at San Francisco Opera, where she created the leading role of Dame Shirley in the world premiere of John Adams's _Girls of the Golden West_; at Dutch National Opera, in the European premiere of the same work; at Santa Fe Opera as Kitty Oppenheimer in Adams's _Doctor Atomic_; at Festival d'Aix-en-Provence as Anne Trulove in Stravinsky's _The Rake's Progress_; and at the English National Opera, Spain's Teatro Real, and Russia's Perm Opera House and Bolshoi Theatre in the title role of Purcell's _The Indian Queen_. She premiered Michel van der Aa's _Upload_ at Dutch National Opera, before reprising it at Bregenzer Festspiele and New York's Park Avenue Armory, and took part in Opera Theatre of Saint Louis's world premiere of Terence Blanchard's _Fire Shut Up in My Bones_. Her wide-ranging repertoire also encompasses the title roles of Massenet's _Cendrillon_, Ravel's _L'enfant et les sortilèges_ and Janáček's _The Cunning Little Vixen_; Susanna in Mozart's _Le nozze di Figaro_; and Pamina in _The Magic Flute_, which she sang at the 2023 Edinburgh Festival with conductor Maxim Emelyanychev, on tour in South America (in a staged production directed by Peter Brook), and in concert with Gustavo Dudamel and the Los Angeles Philharmonic.

Bullock is similarly distinguished in the concert hall. In summer 2023, she performed Jessie Montgomery's _Five Freedom Songs_ with the Boston Symphony Orchestra at Tanglewood, after helping develop the work, premiering it at Idaho's Sun Valley Music Festival, and touring it to the Virginia Arts Festival, Kansas City Symphony and, with conductor Donald Runnicles, the Grand Teton Music Festival. She made important German orchestra debuts in 2023 with the Bavarian Radio Symphony Orchestra & Chorus and NDR Elbphilharmonie Orchestra, led by Manfred Honeck and Alan Gilbert respectively. With the L.A. Philharmonic and Dudamel, Bullock gave 2019-20 season-opening performances of Barber's _Knoxville: Summer of 1915_, which she reprised for her Saint Paul Chamber Orchestra debut and with the Deutsches Symphonie-Orchester Berlin. As part of her 2019-20 residency with the San Francisco Symphony, she joined the orchestra and Esa-Pekka Salonen for Ravel's _Trois poèmes de Stéphane Mallarmé_ and Britten's _Les Illuminations_, which was also the vehicle for her debuts with the Milwaukee Symphony, Indianapolis Symphony and Philharmonia Orchestra. With Andris Nelsons, she headlined the Bernstein centennial gala that launched the Boston Symphony's 2017-18 season, and she performed Bernstein's music for debuts with the San Francisco Symphony, conducted by Michael Tilson Thomas; at the Hollywood Bowl, with Dudamel and the L.A. Philharmonic; with Japan's NHK Symphony and Paavo Järvi; and with the New York Philharmonic, in open-air concerts led by Gilbert in Vail, Santa Barbara and multiple New York City parks. At the invitation of Sir Simon Rattle, she made debuts with both the Berlin Philharmonic's Karajan Academy, in Kaija Saariaho's _La Passion de Simone_; and the London Symphony Orchestra, in Maurice Délage's song cycle _Quatre poèmes hindous_. Other concert highlights include performances of Adams's _El Niño_ with the L.A. Philharmonic led by the composer himself.

In 2014, Bullock gave her first U.S. recital tour, capped by her debut at the Kennedy Center in Washington, DC. Since then, she has maintained a thriving solo career. After premiering AMOC's staged production of Messiaen's song cycle _Harawi_ at Festival d'Aix-en-Provence, she toured it to Belgium and Germany. In 2019, she joined pianist Cédric Tiberghien for the American, British, Belgian and Russian premieres of _Zauberland_ ("Magic Land"), a new work directed by Katie Mitchell, which juxtaposes Schumann's _Dichterliebe_ with original songs by Bernard Foccroulle and Martin Crimp about displacement and grief in the landscape of the Syrian refugee crisis. This followed Bullock's high-profile 2018 North American recital tour, which featured workshops and local school performances in each city, with dates at New York's Carnegie Hall, the Philadelphia Chamber Music Society, Cal Performances at UC Berkeley and Boston's Celebrity Series. Other solo performance highlights include her 2021 Wigmore Hall recital and 2017 Disney Hall debuts, and appearances at the 2016 Mostly Mozart and Ojai Music festivals, where she collaborated with Roomful of Teeth and the International Contemporary Ensemble (ICE) on Peter Sellars's new staging of _La Passion de Simone_ and on the world premiere of _Josephine Baker: A Portrait_.

_Josephine Baker: A Portrait_ was the original prototype for _Perle Noire: Meditations for Joséphine_. Exploring racism, misogyny and performance as a means to self-empowerment, through the lens of Baker's life, _Perle Noire_ was conceived by Bullock in collaboration with MacArthur "Genius" Fellows Peter Sellars, Tyshawn Sorey and Claudia Rankine. Bullock took this work to Dutch National Opera, Harvard's OBERON and New York's Metropolitan Museum of Art, where it was one of the five thought-provoking programs she curated as its Artist-in-Residence. Besides _Perle Noire_, which marked the first full-length performance on the museum's grand staircase, Bullock's curation at the museum included a performance of Langston Hughes poetry and music settings, featuring various singing and instrumental artists including clarinetist Anthony McGill and the Young People's Chorus of NYC; a new chamber arrangement of _El Niño_ (now titled _Nativity Reconsidered_) at the Cloisters; AMOC's account of Hans Werner Henze's _El Cimarrón_ ("The Runaway Slave"); and _History's Persistent Voice_, a program combining the songs of enslaved people in the United States with new music by Black American women, including the world premieres of Met commissions from Courtney Bryan, Tania León, Allison Loggins-Hull and Jessie Montgomery. The expansion of _History's Persistent Voice_, an ongoing project that commissions b/Black women composers, and features the work of b/Black visual artists and poets, premiered at the San Francisco Symphony in 2022, impressing the San Francisco Chronicle with its "musical beauty and moral force." Plans for future performances are underway in both the U.S. and Europe.

Bullock's growing discography comprises a variety of celebrated recordings. In November 2022, she made her solo album debut on the Nonesuch label with Walking in the Dark. Combining _Knoxville: Summer of 1915_ with an aria from _El Niño_ and songs by Oscar Brown Jr., Connie Converse, Sandy Denny, Billy Taylor, and a traditional spiritual setting by Hall Johnson, the record was recognized with an Opus Klassik award, featured in the New York Times's "Best Classical Music Tracks of 2022," and named among the 20 "Best Albums of 2022" by NPR, which called it "an album that shines, introducing us to an artist curating a career on her own distinctive terms." Bullock also appears on the soundtrack of Amazon Prime Video's 2021 _The Underground Railroad_, composed by Nicholas Britell. Her account of _Quatre poèmes hindous_ with Rattle and the London Symphony Orchestra was captured live on DVD, as was her title role appearance in Sellars's production of _The Indian Queen_ for Sony Classical. Selected as one of the New York Times's "25 Best Musical Tracks of 2018," her starring role in Adams's _Doctor Atomic_, recorded with the composer conducting the BBC Symphony Orchestra, was a nominee for the 2018 Grammy Award for Best Opera Recording. This marked Bullock's second appearance on a Grammy-nominated recording, following her live account of _West Side Story_ with Tilson Thomas and the San Francisco Symphony, a Grammy nominee for Best Musical Theater Album in 2014.

Her other honors include the 2022 Dallas Symphony Orchestra Award of Excellence, 2016 Sphinx Medal of Excellence, a 2015 Leonore Annenberg Arts Fellowship, the 2015 Richard F. Gold Grant from the Shoshana Foundation, Lincoln Center's 2015 Martin E. Segal Award, First Prize at the 2014 Naumburg International Vocal Competition and First Prize at the 2012 Young Concert Artists International Auditions. She was chosen as one of Musical America's 2021 Artists of the Year, WQXR’s “19 for 19” artists to watch in 2019 and _Opera News_'s "18 to Watch in 2018-19"; the _New York Times_ honored her on its "Best Classical Music" list in 2020, 2018 and 2016; and in 2018 she appeared on comparable lists in the _Los Angeles Times_, _Washington Post_ and _Philadelphia Inquirer_.

Bullock is in high demand as a speaker in panels on equity, inclusion and restorative justice in the arts. She has taken part in livestreamed conversations presented by Long Beach Opera, Los Angeles Opera, Music Academy of the West (now Music Academy), Sphinx Organization and others. As well as trying to engage with local communities in each city she visits, she serves on the Advisory Board of Turn The Spotlight, a foundation designed to empower people who have been historically marginalized by institutions, both on stage and behind the scenes, to make a more equitable future in the arts. 

Julia Bullock was born in St. Louis, Missouri, where she joined the artists-in-training program at Opera Theatre of Saint Louis while in high school. She went on to earn her bachelor's degree at the Eastman School of Music, her master's degree in Bard College's Graduate Vocal Arts Program, and her Artist Diploma at New York's Juilliard School. It was there that she first met her husband, conductor Christian Reif, with whom she now lives in Munich. The couple welcomed their first child in fall 2022.