+++
date = "2016-01-06T11:58:00-05:00"
discipline = "Tenor"
lastmod = "2016-01-06T11:58:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1452099343783/2016-01-05---Joseph-Calleja.jpg.jpg"
publishDate = "2016-01-06T11:58:00-05:00"
related_companies = ["scene/companies/the-metropolitan-opera.md","scene/companies/los-angeles-opera.md","scene/companies/lyric-opera-of-chicago.md","scene/companies/deutsche-oper-berlin.md","scene/companies/royal-opera-house.md","scene/companies/wiener-staatsoper.md","scene/companies/gran-teatre-del-liceu.md","scene/companies/bayerische-staatsoper.md","scene/companies/salzburg-festival.md"]
slug = "joseph-calleja"
title = "Joseph Calleja"
website = "http://josephcalleja.com/"
[[social_media]]
platform = "Facebook"
template = "social-media"
url = "https://www.facebook.com/JosephCalleja.tenor/"
[[social_media]]
platform = "Twitter"
template = "social-media"
url = "https://twitter.com/MalteseTenor"
[[social_media]]
platform = "Youtube"
template = "social-media"
url = "https://www.youtube.com/user/JosephCallejaTenor"
+++

Blessed with a golden-age voice that routinely inspires comparisons to “legendary singers from earlier eras: Jussi Björling, Beniamino Gigli, even Enrico Caruso” (Associated Press), Maltese-born Joseph Calleja has quickly become one of the most acclaimed and sought-after tenors today. His expansive discography and frequent appearances on the world’s leading opera and concert stages prompted NPR to hail him as “arguably today’s finest lyric tenor,” and led to his being voted Gramophone magazine’s 2012 Artist of the Year. A Grammy-nominated recording artist for Decca Classics, he recently released his fifth solo album for the label, *Amore*.

Calleja was only 19 when he made his operatic debut as Macduff in Verdi’s *Macbeth* at the Astra Theatre in Malta, shortly before winning an award in the Hans Gabor Belvedere Competition that launched his international career. He went on to win the 1998 Caruso Competition in Milan and was a prize winner in Plácido Domingo’s Operalia in 1999, the year of his U.S. debut at the Spoleto Festival. Since then Calleja has gone on to appear with most of the world’s great opera companies, including the Metropolitan Opera, Los Angeles Opera, Lyric Opera of Chicago, Royal Opera House at Covent Garden, Vienna State Opera, Barcelona’s Gran Teatre del Liceu, Dresden’s Semperoper, the Frankfurt Opera, Deutsche Oper Berlin, and Munich’s Bavarian State Opera. Having sung an impressive 28 leading roles to date, he is noted for his portrayals of Verdi’s Duke of Mantua in *Rigoletto* and Alfredo in *La traviata*; Rodolfo in Puccini’s *La bohème* and B. F. Pinkerton in *Madama Butterfly*; Donizetti’s Edgardo in *Lucia di Lammermoor*, Nemorino in *L’elisir d’amore*, and Leicester in *Maria Stuarda*; the title characters of Gounod’s *Faust* and *Roméo et Juliette*; Tebaldo in Bellini’s *I Capuleti e i Montecchi*; and Don Ottavio in Mozart’s *Don Giovanni*. He also created the role of Lind in the world premiere production of Azio Corghi’s *Isabella* at Pesaro’s Rossini Opera Festival.

Joseph Calleja's 2015-16 season is highlighted by new productions in Munich and Frankfurt, alongside returns to Berlin, New York, and Chicago. The Maltese tenor begins his calendar of performances at the Bayerische Staatsoper where, following three encore performances as Pinkerton in Puccini's *Madama Butterfly* he opens a new production of Boito's *Mefistofele*, singing his first Faust opposite René Pape in the title role. Joseph then makes his role debut as Fernando in three concert performances of Donizetti's *La favorite* at Berlin's Deutsche Oper. The German capital city is also the setting for a trio of performances as Rodolfo in *La Bohème* at the Staatsoper im Schiller Theater in the new year. An additional German engagement comes in the form of a new production of Bizet's *Carmen* in Frankfurt. This also marks his debut in the role of Don José.

In the United States, Joseph graces the stages of the Metropolitan Opera and Lyric Opera of Chicago, beginning with Gounod's *Roméo et Juliette* in the Windy City. At the Met, Joseph reprises his acclaimed account of Gabriele Adorno in Verdi's *Simon Boccanegra*, alongside Plácido Domingo as the eponymous doge.

Joseph is also active on the concert stage in the coming months, with performances in Moscow, London, Orange, and beyond.

Highlights from recent operatic seasons include the title characters in new productions of *Faust* and *Tales of Hoffmann* at the Metropolitan Opera; Alfredo in *La traviata* opposite Renée Fleming, Adorno in *Simon Boccanegra* alongside Plácido Domingo, and another turn in the title role of *Faust* at Covent Garden; new productions of *La bohème*, opposite Anna Netrebko, and *La traviata* at the Lyric Opera of Chicago; *Maria Stuarda* alongside Joyce DiDonato in concerts with the Deutsche Oper Berlin; and a new staging of *Rigoletto* at the Bavarian State Opera. He made his role debut as Riccardo in a new treatment of Verdi’s *Un ballo in maschera* at the Royal Opera House Covent Garden in London and portrayed Ruggero in Rolando Villazón’s staging of Puccini’s *La rondine* at Deutsche Oper Berlin.

Calleja appears extensively in concert throughout the world, singing with leading orchestras at summer festivals, including Salzburg, and in outdoor concerts in front of tens of thousands of people in Malta, Paris, and Munich. He was the featured soloist at the 2011 Nobel Prize Concert in Stockholm, was selected by the Maltese president to perform a private concert for Queen Elizabeth II and Prince Philip, and toured Germany with soprano Anna Netrebko. After co-headlining 2012’s Last Night of the BBC Proms, Calleja returned to the London festival in 2013 for a gala performance at the Royal Albert Hall and an open-air concert marking the Last Night of the Proms in Hyde Park. As a recitalist, he has performed in Japan and throughout Europe.

As an exclusive Decca Classics recording artist since 2003, the tenor boasts an extensive discography that includes complete operas and concert repertoire, as well as five solo albums: The Golden Voice, Tenor Arias, The Maltese Tenor, Be My Love: A Tribute to Mario Lanza, and Amore. His videography enjoys similar success, and it was his portrayal of Alfredo in the Royal Opera House’s DVD/Blu-ray release of *La traviata*, in which he co-stars with Renée Fleming and Thomas Hampson, that earned Calleja his first Grammy nomination. His rendition of the Verdi aria “La donna è mobile” is featured on the soundtrack of No Reservations, a 2007 motion picture starring Catherine Zeta-Jones and Aaron Eckhart. He made his Hollywood debut in 2014’s *The Immigrant*, in which he portrays the legendary tenor Enrico Caruso in a cast with Marion Cotillard, Joaquin Phoenix, and Jeremy Renner.

Calleja has been profiled in New York’s Wall Street Journal and London’s Times, among other newspapers, and has graced covers of magazines such as *Opera News*. An increasingly frequent face on television, he has appeared on such programs as CNN’s Business Traveller, BBC Breakfast, and the *Andrew Marr Show*, and been featured in numerous internationally televised concerts. In 2013, he made his U.S. network television debut performing in a Kennedy Center Honors tribute to preeminent American soprano Martina Arroyo on CBS.

Born in Malta in 1978, Joseph Calleja began singing at the age of 16, first in his church choir and then in formal training with Maltese tenor Paul Asciak. One of his native land’s biggest celebrities, Calleja was selected to serve as Malta’s first cultural ambassador in 2012, and earlier this year he was named a brand ambassador for Air Malta. Calleja recently teamed up with Malta’s Bank of Valletta to form the BOV Joseph Calleja Foundation, which will serve to help children and families in need. Calleja is the recipient of the 2014 International Opera Awards’ Readers’ Award.
