+++
date = "2017-09-24T10:10:00-04:00"
discipline = "Pianist"
lastmod = "2017-09-24T10:10:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506262212684/JL_Holger-Hage_lowres3-1030x685.png.png"
primary_image_credit = "Holger Hage"
publishDate = "2017-09-24T10:10:00-04:00"
related_companies = ["scene/companies/toronto-symphony-orchestra.md"]
slug = "jan-lisiecki"
title = "Jan Lisiecki"
website = "http://www.janlisiecki.com/Jan_Lisiecki___Classical_Piano.html"
[[social_media]]
platform = "Facebook"
template = "social-media"
url = "https://www.facebook.com/lisieckipiano"
[[social_media]]
platform = "Twitter"
template = "social-media"
url = "https://twitter.com/janlisiecki"
+++

Just 22, Canadian pianist Jan Lisiecki has won acclaim for his extraordinary interpretive maturity, distinctive sound, and poetic sensibility. The New York Times has called him “a pianist who makes every note count”. Lisiecki’s insightful interpretations, refined technique, and natural affinity for art give him a musical voice that belies his age.

Jan Lisiecki began piano lessons at the age of five and made his concerto debut four years later, while always rebuffing the label of “child prodigy”. His approach to music is a refreshing combination of dedication, skill, enthusiasm and a realistic perspective on the career of a musician. “I might be lucky to have talent, but it is also about dedication and hard work,” says Jan.

Lisiecki was brought to international attention in 2010, after the Fryderyk Chopin Institute issued a recording of Chopin’s piano concertos, performed live by Jan at age 13 and 14. BBC Music Magazine wrote of the “mature musicality” of his playing and commended the “sensitively distilled” insights of his Chopin interpretations; the release was awarded the prestigious ‘Diapason Découverte’. Confirming his status among the most imaginative and poetic pianists of his generation, Deutsche Grammophon signed an exclusive contract with Jan in 2011, when he was just 15 years old. Lisiecki’s first recording for DG, released in 2012, features Mozart’s Piano Concertos K. 466 and 467. It was followed in 2013 by Chopin’s Etudes Op. 10 and 25, praised by Gramophone magazine for being “played as pure music, given as naturally as breathing”. His third album was released in January 2016 and features Schumann’s works for piano and orchestra, and as ClassicFM wrote, “he may be young but Jan Lisiecki plays Schumann like a legend”. In early 2017, Jan Lisiecki’s rendition of Chopin’s seldom performed works for piano and orchestra with NDR Elbphilharmonie Orchester and Krzysztof Urbański was published by Deutsche Grammophon.

Jan says his aim is to always perform in a way that carries forward the beauty and brilliance of the original work. He has demonstrated that he is capable of rendering compositions remarkably close to the way they were intended. “Going into a concert hall should be like going into a sanctuary. You’re there to have a moment of reflection, hopefully leaving feeling different, refreshed and inspired.”

In March 2013, Lisiecki substituted at short notice for Martha Argerich, performing Beethoven’s Piano Concerto No. 4 in Bologna with the Orchestra Mozart under Claudio Abbado. He crowned that season with a sensational account of Schumann’s Piano Concerto at the BBC Proms. The following year he performed three Mozart concertos in one week with the Philadelphia Orchestra, making his debuts as concerto soloist with the Orchestra Filarmonica della Scala in Milan, Tonhalle Orchestra Zurich, NHK Symphony Orchestra in Tokyo, and with the Deutsches Symphonie-Orchester Berlin. The same season, Jan gave debut recitals at Wigmore Hall, Rome’s Accademia Nazionale di Santa Cecilia, and in San Francisco. The pianist’s development has taken place in company with many of the world’s leading orchestras, including the Orchestre de Paris, New York Philharmonic, and BBC Symphony, at venues such as Suntory Hall, the Kennedy, Lincoln, and Barbican Centres, and Royal Albert Hall. Jan has cultivated relationships with prominent conductors including Sir Antonio Pappano, Yannick Nézet-Séguin, Daniel Harding, and Pinchas Zukerman.

The remarkable 22-year-old musician made his debut in the main auditorium at New York’s Carnegie Hall in January 2016 with Philadelphia Orchestra and Yannick Nézet-Séguin. In its rave review, the New York Times noted that it was an “uncommonly sensitive performance”. Other significant dates in his 2015/16 schedule were performances with the Bamberger Symphoniker in Lucerne, subscription series debuts with the Cleveland Orchestra and San Francisco Symphony Orchestra, and multiple tours, including one of Europe with the Zurich Chamber Orchestra, which Jan lead from the piano.

In the 2016/17 season, Jan will perform extensively across the world. Highlights include a tour with the London Philharmonic Orchestra and Vladimir Jurowski and performing in the opening festival of the new Elbphilharmonie in Hamburg.

Foremost radio and television networks in Europe and North America have extensively broadcast Lisiecki’s performances, he was also the subject of the CBC National News documentary ‘The Reluctant Prodigy’. In 2013 he received the Leonard Bernstein Award at the Schleswig-Holstein Music Festival and was also named as ‘Gramophone magazine’s Young Artist of the Year’.

Jan is involved in charity work, donating his time and performance to such organizations as the David Foster Foundation, the Polish Humanitarian Organization and the Wish Upon a Star Foundation. In 2012 he was named UNICEF Ambassador to Canada having been a National Youth Representative since 2008.
