+++
discipline = "Bass"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1587928711/media/2020/04/IldarAbdrazakov-AntonWelt_ish0mk.png"
primary_image_credit = "Anton Welt"
related_companies = ["scene/companies/gran-teatre-del-liceu.md", "scene/companies/washington-national-opera.md", "scene/companies/san-francisco-opera.md", "scene/companies/los-angeles-opera.md", "scene/companies/wiener-staatsoper.md", "scene/companies/bayerische-staatsoper.md", "scene/companies/staatsoper-berlin.md", "scene/companies/opra-national-de-paris.md", "scene/companies/the-metropolitan-opera.md"]
slug = "ildar-abdrazakov"
title = "Ildar Abdrazakov"
website = "http://ildarabdrazakov.com/"
[[social_media]]
platform = "Facebook"
template = "social-media"
url = "https://www.facebook.com/abdrazakov/"
[[social_media]]
platform = "Instagram"
template = "social-media"
url = "https://www.instagram.com/IldarAbdrazakov/"
[[social_media]]
platform = "Youtube"
template = "social-media"
url = "https://www.youtube.com/channel/UCI93cBbQ_t_Fm6jU_BBvO9g"

+++
Ildar Abdrazakov has established himself as one of opera’s most sought-after basses. Since making his debut at the Teatro alla Scala in Milan in 2001 at 25, the Russian native has become a mainstay at leading houses worldwide, including New York’s Metropolitan Opera, Paris National Opera, the Vienna State Opera and Munich’s Bavarian State Opera. His powerful yet refined voice coupled with his compelling stage presence have prompted critics to hail him as a “sensational bass … who has just about everything – imposing sound, beautiful legato, oodles of finesse” (_The Independent_). Being also an active concert artist, he has performed at London’s BBC Proms and at New York’s Carnegie Hall, as well as with leading international orchestras, including the Chicago Symphony Orchestra and the Vienna Philharmonic.

Ildar Abdrazakov kicks off the 19-20 season as Banquo in Verdi’s **_Macbeth_** at the Metropolitan Opera, where he also returns later to sing Mephistopheles at concert version of Berlioz’s **_La Damnation de Faust_**. In Europe he can be heard as Filippo II in Verdi’s **_Don Carlo_** at Bavarian State Opera and in the co-production of Salzburg Easter Festival and Semperoper Dresden, alongside Anna Netrebko as Elisabetta. On the concert stage, Ildar Abdrazakov is singing solo-recital with Bordeaux National Opera and joins stage in a recital with Rolando Villazón at Vienna State Opera. Moreover, he has a concert with Olga Peretyatko in Saint-Petersburg’s Tinkoff Arena.

Highlight of the 18/19 season was prestigious season opening of the Teatro alla Scala in Milan, where the bass performed title role of Verdi’s **_Attila_**. The production included world-wide TV-Broadcast. In addition, he sang his third solo recital and performed as Don Ruy da Silva in Verdi’s **_Ernani_** at the famous house. Such a triumphant conquest of one of the most demanding opera stages has resulted in the reception of Franco Abbiati Award in the category “The Best Singer”. The same season Ildar Abdrazakov made his debut as an opera director in the production of **_Attila_** at Bashkir State Opera and returned to the Salzburg Festival, singing Verdi’s **_Messa da Requiem_** under the baton of Riccardo Muti. In Salzburg he also launched his first solo-album “Verdi” with Deutsche Grammophon.

Since his house debut in **_Don Giovanni_** (2004) Ildar Abdrazakov has become a mainstay at the Metropolitan Opera. He headlined the gala opening of the company’s 2015-16 season in the title role in a new Sir Richard Eyre production of **_Le nozze di Figaro_**. Previously, he sang the title role in a new staging of Borodin’s **_Prince Igor_** – a performance captured on DVD and Blu-ray by Deutsche Grammophon. Other notable Met productions include his role debut as Henry VIII opposite Anna Netrebko in **_Anna Bolena_**, Dosifey in Mussorgsky’s **_Khovanshchina_**, Escamillo in two productions of **_Carmen_**, and the title role of **_Attila_** under the baton of Riccardo Muti. In the 17/18 season he returned in the title role of **_Le Nozze di Figaro_** and as Assur in Rossini’s **_Semiramide_** and in the 18/19 again to sing in **_Don Giovanni_** but in role of Leporello.

At the Teatro alla Scala in Milan, Ildar Abdrazakov joined Riccardo Muti in concert for the reopening of the theatre in 2004-05, and in the same season he sang Moses in a production of Rossini’s **_Moïse et Pharaon_** that was recorded and released on CD and DVD. In the same role but a new production, led by M° Muti, the bass made his Salzburg Festival debut in 2009. Since then, he returned regularly, singing amongst others Méphistophélès (**_Faust_**) and Mustafà alongside Cecilia Bartoli the Festival’s new production of Rossini’s **_Italiana in Algeri_**. His first appearance at London’s Royal Opera House in 2009 was made with Verdi’s **_Requiem_** in concert with Sir Antonio Pappano. Since then he returned there to sing Don Basilio in Rossini’s **_Il Barbiere di Siviglia_** and Filippo II in Verdi’s **_Don Carlo_**.

The title role in **_Le Nozze di Figaro_** was the vehicle for Abdrazakov’s 1998 house debut at St. Petersburg’s Mariinsky Theatre. Among his other signature roles are both the title role and Leporello in Mozart’s **_Don Giovanni_**, Méphistophélès in Gounod’s **_Faust_** and Berlioz’s **_La damnation de Faust_**, Oroveso in Bellini’s **_Norma_**; Selim in Rossini’s **_Il Turco in Italia_** and Assur in his **_Semiramide_**. The Russian bass is noted for Verdi roles including Walter in **_Luisa Miller_** and the title character in **_Oberto_** and **_Attila_**, as well as Banquo in **_Macbeth_** and Filippo II in **_Don Carlo_**. The French version of this role took Ildar Abdrazakov to the Paris National Opera in 2017/2018, where he also made his triumphant debut in the title role of Mussorgsky’s **_Boris Godunov_**, broadcast live in cinemas all over the world.

Ildar Abdrazakov has appeared with virtually every major opera company in the United States and Europe. Besides those already mentioned, he has sung on the stages of Madrid’s Teatro Real, the Gran Teatro del Liceu in Barcelona, the San Francisco Opera, the Washington National Opera and the Los Angeles Opera. On the concert stage, he has given recitals in Russia, Italy, Japan and the United States, and has performed with orchestras including the Orchestre Metropolitain, the Leipzig Gewandhaus Orchestra, Deutsches Symphony Orchester, the Bavarian Radio Symphony, the Rotterdam Philharmonic, the Orchestre National de France, the Orchestra Filarmonica della Scala and Rome’s Accademia Nazionale di Santa Cecilia. Among the noted conductors with whom he has collaborated are Riccardo Muti, Valery Gergiev, Sir Antonio Pappano, James Levine, Yannick Nézet-Séguin, Gianandrea Noseda, Bertrand de Billy, Riccardo Frizza and Riccardo Chailly. In November and December 2017 Ildar Abdrazakov also had a tour through Europe with Rolando Villazón. The concerts in Prague, Berlin, Baden-Baden, Stuttgart, Munich, Paris and Vienna presented the repertoire of their first joint album “Duets”, featuring duets from Italian and French operas. The album was launched in September 2017 by Deutsche Grammophon.

Ildar Abdrazakov’s debut solo album _Power Players_, a celebration of the great Russian bass roles, was released in early 2014 on Delos, to great critical acclaim. His recording of Verdi’s **_Messa da Requiem_** with Riccardo Muti and the Chicago Symphony Orchestra won a Grammy Award. He also has recorded unpublished arias by Rossini with Riccardo Chailly and the Symphony Orchestra of Milan, as well as Giuseppe Verdi for Decca, and Cherubini’s **_Mass_** with Muti and the Bayerischer Rundfunk for EMI Classics. For Chandos he has recorded Shostakovich’s **_Suite on Verses of Michelangelo_** and Rachmaninoff’s **_The Miserly Knight_**, both with Gianandrea Noseda and the BBC Philharmonic. In early 2017 Abdrazakov signed an exclusive contract with Deutsche Grammophon. His first solo album **_Verdi_** was released in summer 2019. The bass’s DVD releases include **_Moïse et Pharaon_** from La Scala, **_Oberto_** from Bilbao, **_Norma_** from Parma and **_Lucia di Lammermoor_** from the Metropolitan Opera. Marking the Verdi bicentennial, May 2013 saw Abdrazakov’s star turn in the title role of **_Attila_** immortalized on the Mariinsky label’s first DVD/Blu-ray release.

Abdrazakov was born in Ufa, the today’s capital of the republic of Bashkiria in Russia. Both of his parents were artists: his mother was a painter and his late father a director. At age four Abdrazakov began acting in his father’s stage and film productions, and these early experiences inspired him to pursue a career in the arts. Upon graduating from the Ufa State Institute of Arts, he joined the Bashkirian Opera and Ballet Theatre. In the late 1990s he won a string of prestigious vocal competitions: the Moscow Grand Prix named after Irina Arkhipova, the Glinka International Vocal Competition, the Rimsky-Korsakov International Competition, and the International Obraztsova competition. His 2000 win at the Maria Callas International Television Competition in Parma thrust him into the international spotlight and led to his debut at La Scala the following year.

Ildar Abdrazakov has his own foundation, created to support and promote young talented musicians. Since 2018 he is annually organizing festivals in Russia, inviting renowned singers to give concerts and masterclasses there. Since 2014, Ildar Abdrazakov is also Artistic Director of the Elena Obraztsova International Academy of Music.