+++
date = "2019-03-05T22:40:00+00:00"
discipline = "Mezzo-soprano"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1551825223/media/2019/03/vonStadeRobertMillard.jpg"
primary_image_credit = "Robert Millard."
related_companies = ["scene/companies/the-dallas-opera.md", "scene/companies/los-angeles-opera.md", "scene/companies/lyric-opera-of-chicago.md", "scene/companies/wiener-staatsoper.md", "scene/companies/opra-national-de-paris.md", "scene/companies/teatro-alla-scala.md", "scene/companies/royal-opera-house.md", "scene/companies/san-francisco-opera.md", "scene/companies/arizona-opera.md", "scene/companies/opera-philadelphia.md", "scene/companies/san-diego-opera.md", "scene/companies/the-metropolitan-opera.md"]
slug = "frederica-von-stade"
title = "Frederica von Stade"
website = "http://www.fredericavonstade.com/"
[[social_media]]
platform = "Facebook"
template = "social-media"
url = "https://www.facebook.com/Frederica-Von-Stade-64924287649/"

+++
Described by the _New York Times_ as “one of America’s finest artists and singers,” Frederica von Stade continues to be extolled as one of the music world’s most beloved figures. Known to family, friends, and fans by her nickname “Flicka,” the mezzo-soprano has enriched the world of classical music for four and a half decades.

Though she retired from full-time performances in 2010, she continues to make appearances across the United States. The 2018-19 season opens with the world premiere of Lembit Beecher’s _Sky on Swings_ at Opera Philadelphia. Also during the fall, she will perform alongside Susan Graham and the Orchestra of St. Luke’s for the DiMenna Center Benefit in New York City. March marks a return to the San Diego Opera as she portrays Madeline in Jake Heggie’s _Three Decembers_, a role she created a decade ago. In 2017, Ms. von Stade opened the Boston Symphony Orchestra’s season with a tribute to Leonard Bernstein conducted by Andris Nelsons. To open the 2016-17 season, Ms. von Stade sang with Tony award-winning Broadway star Liz Callaway, Daniel Rodriguez, and Matthew Lee Robinson in the New York premiere of the 45-minute cantata _Street Requiem_ – composed in 2014 by Australian’s Kathleen McGuire, Andy Payne and Jonathon Welch – at Carnegie Hall. She made her Arizona Opera debut by joining The 45th Anniversary Sapphire Celebration concert celebrating the company. In January, the mezzo-soprano performed on a gala benefit concert with Sarasota Ballet in Florida. The spring found Ms. von Stade singing with Hawaii Opera Theater in _Three Decembers_ – composed by Jake Heggie based on the play by Terrence McNally – before going to Peabody Conservatory to give a master class.

Ms. von Stade’s career has taken her to the stages of the world’s great opera houses and concert halls. She began at the top, when she received a contract from Sir Rudolf Bing during the Metropolitan Opera auditions, and since her debut in 1970 she has sung nearly all of her great roles with that company. In January 2000, the company celebrated the 30th anniversary of her debut with a new production of _The Merry Widow_ specifically for her, and in 1995, as a celebration of her 25th anniversary, the Metropolitan Opera created for her a new production of _Pelléas et Mélisande_. In addition, Ms. von Stade has appeared with every leading American opera company, including San Francisco Opera, Lyric Opera of Chicago, and Los Angeles Opera. Her career in Europe has been no less spectacular, with new productions mounted for her at Teatro alla Scala, Royal Opera Covent Garden, the Vienna State Opera, and the Paris Opera. She is invited regularly by the finest conductors, among them Claudio Abbado, Charles Dutoit, James Levine, Kurt Masur, Riccardo Muti, Seiji Ozawa, André Previn, Leonard Slatkin, and Michael Tilson Thomas, to appear in concert with the world’s leading orchestras, including the Boston Symphony Orchestra, Chicago Symphony, Cleveland Orchestra, New York Philharmonic, Philadelphia Orchestra, San Francisco Symphony, London Symphony Orchestra, Washington’s National Symphony, and the Orchestra of La Scala.

With impressive versatility, Ms. von Stade has effortlessly traversed an ever-broadening spectrum of musical styles and dramatic characterizations. A noted bel canto specialist, she excelled as the heroines of Rossini’s _La cenerentola_ and _Il barbiere di Siviglia_ and Bellini’s _La sonnambula_. She is an unmatched stylist in the French repertoire: a delectable Mignon or Périchole, a regal Marguerite in Berlioz’ _La damnation de Faust_, and, in one critic’s words, “the Mélisande of one’s dreams.” Her elegant figure and keen imagination have made her the world’s favorite interpreter of the great trouser roles, from Strauss’ Octavian to Mozart’s Sesto, Idamante and – magically, indelibly – Cherubino. Ms. von Stade’s artistry has inspired the revival of neglected works such as Massenet’s _Cherubin_, Thomas’ _Mignon_, Rameau’s _Dardanus_, and Monteverdi’s _Il ritorno d’Ulisse in patria_. Her ability as a singing actress has allowed her to portray wonderful works in operetta and musical theater including the title role in _The Merry Widow_ and Desirée Armfeldt in _A Little Night Music_.

Ms. von Stade enjoys close collaborations with several contemporary composers, including Jake Heggie, Ricky Ian Gordon, and Dominick Argento, among others. She created the role of Tina in The Dallas Opera’s world premiere production of Dominick Argento’s _The Aspern Papers_ (a work written for her), as well as the role of Madame de Merteuil in Conrad Susa’s _Dangerous Liaisons_ and Mrs. Patrick De Rocher in Jake Heggie’s _Dead Man Walking_, both for San Francisco Opera. Ms. von Stade created the role of Myrtle Bledsoe in the world premiere of Ricky Ian Gordon’s _A Coffin in Egypt_ at Houston Grand Opera, a role she later reprised at Opera Philadelphia, The Wallis Annenberg Center for the Performing Arts in Beverly Hills, and with the Chicago Opera Theater. Ms. von Stade will also create the role of Mrs. Edward “Winnie” Flato in the world premiere of Jake Heggie and Terrence McNally’s _Great Scott_directed by Jack O’Brien, with performances at The Dallas Opera and San Diego Opera.

Ms. von Stade’s orchestral repertoire is equally broad, embracing works from the Baroque to those of today’s composers. She has garnered critical and popular acclaim in her vast French repertoire as one of the world’s finest interpreters of Ravel’s _Shéhérazade_, Berlioz’s _Les nuits d’été_, and Canteloube’s _Les chants d’Auvergne_, as well as the orchestrated songs of Debussy and Duparc. She is continually in demand for the symphonic works of the great Austrian and German composers including Mozart and Mahler, as well as the new works of American composers.

It was the American composer Richard Danielpour who in 1998 helped Ms. von Stade to realize an artistic and personal dream when he wrote _Elegies_. The work, scored for orchestra, mezzo-soprano and baritone, is a tribute to Ms. von Stade’s father, Charles von Stade, who was killed in the final days of World War II, and is based on the text of letters Mr. von Stade sent to his wife during the war. It is through these letters that Ms. von Stade came to know her father, who died two months before her birth. In January 1998 the Jacksonville Symphony, led by Roger Nierenberg, offered the world premiere of _Elegies_ with performances in Florida and in New York’s Carnegie Hall. _Elegies_ is available on SONY Classical and has been performed throughout North America and Europe.

Unparalleled in her artistry as a recitalist, Ms. von Stade combines her expressive vocalism and exceptional musicianship with a rare gift for communication, enriching audiences throughout the world. Here, too, her repertoire encompasses a rich variety, from the classical style of Mozart and Haydn to Broadway; from Italian “Arie antiche” to the songs of contemporary composers – who compose especially for her – such as Dominick Argento and Jake Heggie.

She has made over seventy recordings with every major label, including complete operas, aria albums, symphonic works, solo recital programs, and popular crossover albums. Her recordings have garnered six Grammy nominations, two Grand Prix du Disc awards, the Deutsche Schallplattenpreis, Italy’s Premio della Critica Discografica, and “Best of the Year” citations by _Stereo Review_ and _Opera News_. She has enjoyed the distinction of holding simultaneously the first and second places on national sales charts for Angel/EMI’s _Show Boat_ and Telarc’s _The Sound of Music_.

Ms. von Stade appears regularly on television, through numerous PBS and other broadcasts. In 2002 she was seen on national television in a concert with the Mormon Tabernacle Choir as part of the opening ceremonies of the Salt Lake City Winter Olympic Games. In 2001 she participated in the opening of Philadelphia’s Kimmel Center for the Performing Arts performing in a concert together with Sir Elton John, Andre Watts, and the Philadelphia Orchestra. Other highlights of recent television appearances include a gala concert with the San Francisco Symphony to open the 1998-99 season at New York’s Carnegie Hall and a “Live from Lincoln Center” television event opening the 1999 season of the Mostly Mozart Festival, both broadcast throughout North America. She can be seen in “Live from the Met” performances as Cherubino, Hansel, and Idamante, and through PBS broadcasts of her celebration of the art of American song with Thomas Hampson, Marilyn Horne, Dawn Upshaw and Jerry Hadley in a program at New York’s Town Hall titled “I Hear America Singing,” as well as a program with Tyne Daly which included arias, art songs and popular crossover material. Also seen on PBS were a holiday special, “Christmas with Flicka,” shot on location in Salzburg, “A Carnegie Hall Christmas” with Kathleen Battle, and an evening of operatic and musical theater selections with Samuel Ramey and Jerry Hadley titled “Flicka and Friends.” Her recent portrayals in _Dangerous Liaisons_ and _The Aspern Papers_ were broadcast throughout North America. She can also be seen in the Unitel film of the classic Jean-Pierre Ponnelle production of _La cenerentola_.

Ms. von Stade is the holder of honorary doctorates from Yale University, Boston University, the San Francisco Conservatory of Music (which holds a Frederica von Stade Distinguished Chair in Voice), the Georgetown University School of Medicine, and her alma mater, the Mannes School of Music. In 1998 Ms. von Stade was awarded France’s highest honor in the Arts when she was appointed as an officer of _L’Ordre des Arts et des Lettres_, and in 1983 she was honored with an award given at The White House by President Reagan in recognition of her significant contribution to the arts.