+++
date = "2016-08-24T18:02:00+01:00"
discipline = "Soprano"
lastmod = "2016-08-24T18:02:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1581898233/media/2020/02/ElzavandenHeever-DarioAcosta5_nuvimp.jpg"
publishDate = "2016-08-24T18:02:00+01:00"
related_companies = ["scene/companies/canadian-opera-company.md", "scene/companies/the-metropolitan-opera.md", "scene/companies/english-national-opera.md", "scene/companies/san-francisco-opera.md", "scene/companies/lyric-opera-of-chicago.md", "scene/companies/the-dallas-opera.md", "scene/companies/bayerische-staatsoper.md"]
slug = "elza-van-den-heever"
title = "Elza van den Heever"
website = "http://www.elzavandenheever.com/"
[[social_media]]
platform = "Facebook"
template = "social-media"
url = "https://m.facebook.com/profile.php?id=775391559183451"

+++
“Blessed with a plush, dramatic voice capable of formidable power and dazzling high notes …” (Associated Press)

Acclaimed soprano Elza van den Heever brings her signature vocalism and renowned stage presence to celebrated international venues in the 2019/20 season. Her first operatic engagement takes her to Vienna, where she debuts as Julia in a new production by Johannes Erath of Spontini’s _La Vestale_ at the Theater an der Wien. She later returns to The Metropolitan Opera to sing her first Marie in Berg’s _Wozzeck_ opposite baritone Peter Mattei and conducted by the Met’s Music Director Yannick Nézet-Séguin. This production, set to be a highlight of the Met Opera season, will also receive a Live in HD broadcast. 

Returning to Europe, Ms. van den Heever makes her greatly anticipated role debut as Die Kaiserin in Strauss’ _Die Frau ohne Schatten_, singing it first in Paris and then in Rotterdam presented in concert; both performances will be conducted by Mo. Nézet-Séguin. Later in the season, she revisits the role in a staged production at Dutch National Opera. She stars as Leonora in Beethoven’s _Fidelio_ in Paris under the baton of Simone Young, and lastly, sings Elsa von Brabant in Wagner’s _Lohengrin_ at the Opernhaus Zürich.

Additionally, Elza will perform Verdi’s Requiem with the London Philharmonic Orchestra, conducted by Edward Gardner at the Royal Festival Hall; Mahler’s epic Symphony No. 8 at the Bayerische Staatsoper with the Orchestra Academy of the Bayerisches Staatsorchester under the baton of Kirill Petrenko; and Strauss’ _Vier letzte Lieder_ with the Metropolitan Opera Orchestra led by Mo. Nézet-Séguin at Carnegie Hall.

Ms. van den Heever began her 2018/19 season starring as Elsa von Brabant in _Lohengrin_ at the Wiener Staatsoper, followed by a return to the Lyric Opera of Chicago for David McVicar’s production of Strauss’ _Elektra_ in her debut as Chrysothemis. Ms. van den Heever also returned to The Metropolitan Opera stage in the spring of 2019 as Vitellia in Jean-Pierre Ponnelle’s production of Mozart’s _La Clemenza di Tito_, garnering acclaim from critics for her “dramatically flamboyant and vocally powerful” performance (Classical Source). She concluded her operatic season at Oper Frankfurt in the iconic titular role of Bellini’s _Norma_.

Her international concert appearances for the 2018/19 season included a performance with the Orchestre de Chambre de Lausanne, featuring music by Wagner and Strauss with conductor Simone Young. She sang Strauss’ _Vier letzte Lieder_ with the Konzerthausorchester Berlin, and performed with the Symphonieorchester Voralberg under the baton of Kirill Petrenko, in Mahler’s epic Symphony No. 8.

Elza has performed several roles to great acclaim at the Metropolitan Opera, including Elettra in Mozart’s _Idomeneo_, Donna Anna in Mozart’s _Don Giovanni_, and Elisabetta in Donizetti’s _Maria Stuarda_ in her notable Met debut: “\[Elza is\] a vocally burnished and emotionally tempestuous Elizabeth … her voice has penetrating depth and character. She turns flights of coloratura passagework into bursts of jealousy and defiance” (The New York Times).

She was unforgettable in the title role of _Norma_ in a new Christopher Alden-directed production for Opéra National de Bordeaux. Other signature portrayals in Europe have included Ellen Orford in Britten’s _Peter Grimes_ at the English National Opera and Wiener Staatsoper. As Elsa in _Lohengrin_ at the Opernhaus Zürich, she was described as “… sharing more than a first name with the Wagnerian heroine. Her vocal lines are sophisticated, diction impeccable, and her inflection and nuances serve to depict Elsa as a young woman who is at once daring, bold and strong. This is truly wondrous in the second act during the verbal sparring with Ortrud, as well as in the final dramatic scene, in which her defiance is breathtaking” (Forum Opéra).

Ms. van den Heever has also been lauded for her artistry as Desdemona in _Otello_ at Oper Frankfurt, where she received praise for her “… huge voice, full of tenderness and precision” (Frankfurter Rundschau). In addition to Desdemona and Elisabetta di Valois in Verdi’s _Don Carlo_, she has also appeared on the Frankfurt stage as Elsa in _Lohengrin_, Vitellia in _La clemenza di Tito_, Antonia in Offenbach’s _Les contes d’Hoffmann_, and Elettra in _Idomeneo_. She has also performed the role of Elsa (_Lohengrin_) at Munich’s Bayerische Staatsoper, Agathe in Weber’s _Der Freischütz_ at Vienna’s Theater an der Wien, Fiordiligi in Mozart’s _Così fan tutte_ for Opéra National de Paris, and Donna Anna (_Don Giovanni_) as well as Giselda in Verdi’s _I Lombardi_ at Hamburgische Staatsoper. Previous roles at the Opéra National de Bordeaux also include Elettra (_Idomeneo_), Der Komponist in Strauss’ _Ariadne auf Naxos_, the title role in Donizetti’s _Anna Bolena_, and Leonora in Verdi’s _Il trovatore_.

In addition to performances at The Metropolitan Opera across several seasons, Elza’s appearances in North America have included Armida in Handel’s _Rinaldo_ at Lyric Opera of Chicago, Fiordiligi (_Così fan tutte_) and Norma at The Dallas Opera, and Donna Anna (_Don Giovanni_) with Santa Fe Opera. She has also starred as Norma at the Canadian Opera Company. At San Francisco Opera, where she participated in both the Merola Opera Program and the Adler Fellowship, she created the role of Mary Custis Lee in the world premiere of Philip Glass’s _Appomattox_ and sang Donna Anna in the company’s 2007 presentation of _Don Giovanni_, performances that were seen nationwide via the company’s Grand Opera Cinema Series, and broadcast on Northern California’s KQED Public Television.

Ms. van den Heever enjoys a flourishing performance partnership with Michael Tilson Thomas and the San Francisco Symphony, with performances of Strauss’ _Vier letzte Lieder_ and Grammy Award-winning performances of Mahler’s Symphony No. 8 in San Francisco, on tour throughout Europe, and on disc for SFS Media. Ms. van den Heever’s depiction of Ellen Orford for the English National Opera was repeated with Mr. Tilson Thomas and the San Francisco Symphony in June 2014, where she was lauded as “… a brilliant Ellen, deploying her focused, penetrating instrument with urgency upon discovering the Boy’s bruises in Act II, and singing with ineffable beauty and poignancy in the Embroidery Aria” (Opera News).

Ms. van den Heever was born and raised in Johannesburg, South Africa and received her musical training at the San Francisco Conservatory of Music. Winner of the 2008 Seattle Opera International Wagner Competition, she continues to study with soprano and master teacher Sheri Greenawald. A dual citizen of France and South Africa, Ms. van den Heever makes her home in France.