+++
date = "2015-04-07T16:34:00-04:00"
discipline = "Soprano"
lastmod = "2015-04-07T16:34:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428438771523/DianaDamrau-pc-TaniaNiemann.jpg.jpg"
primary_image_credit = "Tania Niemann"
publishDate = "2015-04-07T16:34:00-04:00"
related_companies = ["scene/companies/the-metropolitan-opera.md","scene/companies/bayerische-staatsoper.md","scene/companies/wiener-staatsoper.md","scene/companies/teatro-alla-scala.md","scene/companies/royal-opera-house.md"]
slug = "diana-damrau"
title = "Diana Damrau"
website = "http://diana-damrau.com/"
[[social_media]]
platform = "Facebook"
template = "social-media"
url = "https://www.facebook.com/DianaDamrau"
[[social_media]]
platform = "Twitter"
template = "social-media"
url = "https://twitter.com/DianaDamrau"
+++

<p>
	Acclaimed as the "leading coloratura soprano in the world" (<em>New York Sun</em>), Diana Damrau continues to amaze audiences with her unique voice and arresting stage presence. A regular guest at the most renowned opera companies and concert halls, she was awarded the title <em>Bayerische Kammersängerin</em> in 2007 and named "<em>Best Female Singer</em>" at the 2014 International Opera Awards.
</p>
<p>
	The 2014/15 season sees Diana Damrau performing a broad range of repertoire both on the operatic and concert stages of the world. She begins the season at Theater an der Wien where she stars in a new production of Bizet's <strong><em data-redactor-tag="em">Les pecheurs des perles</em></strong>, followed by her return to the Bayerische Staatsoper for a new production of Donizetti's <strong><em data-redactor-tag="em">Lucia di Lammermoor</em></strong>, a role she reprises for Milan's Teatro alla Scala later in the season. She sings Massenet's <strong><em data-redactor-tag="em">Manon </em></strong>at the Metropolitan Opera and, Adina in Donizetti's <strong><em data-redactor-tag="em">L'elisir d'amore </em></strong>for Zurich Opera before returning to Baden-Baden's Festspielhaus to debut Contessa Almaviva in concert performances of Mozart's <strong><em data-redactor-tag="em">Le nozze di Figaro</em></strong>, recorded for Deutsche Grammophon. Diana Damrau can be heard in concert and recital extensively this season. She sings Belcanto-themed gala concerts amongst other in Prague, Amsterdam, Baden-Baden, Geneva, Munich, Frankfurt and Vienna and appears in recital in Vienna, Milan, Madrid, Paris and Graz. Diana Damrau further joins the Munich Philharmonic Orchestra for their New Year's concerts and appears in concert with the Vienna Philharmonic during the Salzburg Mozart Week as well as at New York's Carnegie Hall for a performance of Brahms' <strong><em data-redactor-tag="em">Requiem.</em></strong>
</p>
<p>
	Over the last seasons, Diana Damrau has extended her repertoire to include some new signature roles such as Philine (<strong><em data-redactor-tag="em">Mignon</em></strong>) and Elvira (<strong><em data-redactor-tag="em">I puritani</em></strong>) with Grand Théâtre de Genève, <strong>Linda di Chamounix</strong> with Gran Teatre del Liceu Barcelona, and <strong><em data-redactor-tag="em">Lucia di Lammermoor</em></strong> and Amina in <strong><em data-redactor-tag="em">La sonnambula </em></strong>for the Metropolitan Opera In 2011, the soprano scored a tremendous success with her rendition of the three soprano roles in <strong><em data-redactor-tag="em">Les contes d'Hoffmann</em></strong> at the Bavarian State Opera. In 2013, she sang Gilda in a new production of <strong><em data-redactor-tag="em">Rigoletto </em></strong>at the Metropolitan Opera New York, where she also made her acclaimed role debut as Verdi's<strong> <em data-redactor-tag="em">La traviata</em></strong>, a role that she also performed in a season-opening new production at Milan's Teatro alla Scala, a new production for Opéra de Paris, as well as performances with the Bayerische Staatsoper, the Royal Opera, Covent Garden and Zurich Opera.
</p>
<p>
	As a member of the ensembles at Mannheim National Theatre and Frankfurt Opera, Diana Damrau began her international career with much-praised guest appearances as Queen of the Night, Zerbinetta and Adele (<strong><em data-redactor-tag="em">Die Fledermaus</em></strong>) in Munich, Berlin and Vienna. Free-lancing since 2002, she took on the female lead in the world premiere of Cerha's <strong><em data-redactor-tag="em">Der Riese vom Steinfeld</em></strong> at Vienna State Opera and was hailed by the critics for her UK debut as Queen of the Night (2003), as well as her spectacular rendition of the title role in Salieri's <strong><em data-redactor-tag="em">L'Europa riconosciuta</em></strong> at the re-opening of Milan's La Scala (2004). Other noteworthy engagements include Gym Instructress/Drunken Woman in the world premiere of Lorin Maazel's <em><strong data-redactor-tag="strong">1984</strong> </em>at Covent Garden, Susanna at La Scala, Konstanze at Vienna's Burgtheater, Zerbinetta at Teatro Real Madrid, Gilda at Semperoper Dresden, Gretel at Covent Garden, Sophie (<strong><em data-redactor-tag="em">Der Rosenkavalier</em></strong>) at Baden-Baden Festival Hall, and her role debuts as Marie (<em>La fille du régiment</em>, San Francisco), Donna Anna (Geneva), Massenet's <strong>Manon</strong>(Vienna), Aminta (Munich), and the world premiere of <strong><em data-redactor-tag="em">A Harlot's Progress</em></strong> at Theater an der Wien.
</p>
<p>
	An audience favourite at New York's Metropolitan Opera, Diana has returned to New York every year since 2005, tackling Zerbinetta, Rosina, Aithra, Konstanze, Gilda, Lucia, Marie, Adèle (<strong><em data-redactor-tag="em">Le comte Ory</em></strong>) and Adina, and causing a sensation by singing both her first Pamina and her last Queen of the Night in a 2007 run of <strong><em data-redactor-tag="em">Die Zauberflöte</em></strong>. In Europe, she has close ties with the Salzburg Festival, where her 2001 debut was followed by appearances as Queen of the Night, Blonde, Konstanze, Fauno, Susanna, and a solo recital in 2014. Diana Damrau works regularly with an illustrious list of conductors includes Riccardo Muti, Zubin Mehta, Lorin Maazel, Sir Colin Davis, Ivor Bolton, Nikolaus Harnoncourt, Kent Nagano, Fabio Luisi, Jérémie Rhorer, Dan Ettinger and Christian Thielemann.
</p>
<p>
	In addition to her achievements in opera, Diana has established herself as one of today's finest lieder singers and gives recitals with pianists like Helmut Deutsch, Julius Drake and Matthias Lademann at renowned venues including Berlin's Philharmonie, Vienna's Musikverein, London's Wigmore Hall, New York's Carnegie Hall, the Salzburg Festival and the Schubertiade Schwarzenberg. Her extraordinary musical partnership with harpist Xavier de Maistre is documented in the form of a CD release (<em>Nuit d'étoiles</em>) and a DVD released in 2013.
</p>
<p>
	Recording exclusively for <em>EMI/Virgin Classics, </em>now <em>Erato</em>, Diana Damrau made her recording debut with <em>Arie di Bravura</em>which received enthusiastic reviews and prestigious awards. Subsequent solo projects include recordings of Mozart arias (<em>Donna</em>), coloratura pieces of the romantic period (<em>COLORaturaS</em>), orchestral songs by Richard Strauss (<em>Poesie</em>, awarded with the <em>ECHO Klassik</em> in 2011) and songs by Franz Liszt. Diana Damrau's discography is rounded off by various opera, concert and recital recordings on different labels. TV broadcasts, most notably from the opening gala of the 2006 Soccer World Cup in Munich, have made her well-known to the general public. In autumn 2013, her album <em>Forever</em> with melodies from operetta, film and musical was released and awarded with an ECHO Klassik in 2014. 2015 sees the release of a Belcanto-themed recording.A documentary on her life, directed by Beatrix Conrad and entitled Diana Damrau – Divine Diva, was first aired on the French-German TV channel arte in February 2011.
</p>
<p>
	A native of Günzburg an der Donau/Germany, Diana Damrau studied voice with Carmen Hanganu at Wurzburg Conservatory and with Hanna Ludwig in Salzburg. She made her professional operatic debut at Würzburg's Mainfrankentheater in 1995.
</p>
