+++
date = "2015-04-07T16:30:00-04:00"
discipline = "Soprano"
lastmod = "2015-04-07T16:31:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428438597000/DeborahVoigt-pc-DarioAcosta.jpg.jpg"
primary_image_credit = "Dario Acosta"
publishDate = "2015-04-07T16:30:00-04:00"
related_companies = ["scene/companies/san-francisco-opera.md","scene/companies/the-metropolitan-opera.md","scene/companies/the-dallas-opera.md"]
slug = "deborah-voigt"
title = "Deborah Voigt"
website = "http://deborahvoigt.com/"
[[social_media]]
platform = "Facebook"
template = "social-media"
url = "https://www.facebook.com/DeborahVoigt"
[[social_media]]
platform = "Twitter"
template = "social-media"
url = "https://twitter.com/debvoigt"
+++

<p>
	Deborah Voigt is increasingly recognized as one of the world's most versatile singers and one of music's most endearing personalities. Through her performances and television appearances, she is known for the singular power and beauty of her voice, as well as for her captivating stage presence. Having made her name as a leading dramatic soprano, she is internationally revered for her performances in the operas of Wagner, Strauss, and more, and is also an active recitalist and performer of Broadway standards and popular songs. Besides boasting an extensive discography, she appears regularly as both performer and host in the Metropolitan Opera's Live in HD series, which is transmitted live to movie theaters around the world.
</p>
<p>
	The 2014-15 season sees one of Voigt's most personal projects come to fruition, with HarperCollins's publication of her candid, funny, and soul-baring memoir <i>Call Me Debbie: True Confessions of a Down-to-Earth Diva</i>. She returns to the opera house, reprising her star turn in Francesca Zambello's <i>Salome</i> for her Dallas Opera debut; making her title role debut in a new staging of <i>The Merry Widow</i> at Michigan Opera Theater; and undertaking the roles of Elisabeth and Venus in <i>Tannhäuser</i> at the Hamburg State Opera—her first time singing both parts in the same production. In concert, she headlines the Las Vegas Philharmonic's opening-night gala and season-closing events at both the Pacific Symphony and the University of Southern Mississippi Symphony, which she joins for An Evening with Deborah Voigt. As WQXR's inaugural Susan W. Rose Artist-in-Residence, she co-hosts the opening-night broadcast of Carnegie Hall Live, hosts the classical station's new fall series The Sopranos with Debbie Voigt; hosts and performs at the New York Public Radio Gala; and co-hosts a number of opera events and masterclasses at WQXR's Jerome L. Greene Performance Space. Meanwhile, as returning Artist-in-Residence at the Washington National Opera, the beloved soprano continues mentoring young singers in the company's Domingo-Cafritz Young Artist Program.
</p>
<p>
	Last season, Voigt hosted the San Francisco benefit concert for Sing With Haiti, <span class="s1">to aid the rebuilding of Haiti's Holy Trinity Music School, destroyed in the earthquake of 2010</span>. Under James Levine's leadership, she made her role debut as Marie in Berg's <i>Wozzeck</i>, opposite Thomas Hampson at the Met. Recitals took her to cities across the U.S., including Boston, Miami, Fort Worth, Kansas City, MO, Palm Desert, Stanford, and Sonoma, and she reprised <i>Voigt Lessons</i>, the one-woman show she developed with award-winning playwright Terrence McNally and director Francesca Zambello, in Boston's<i></i>Celebrity Series. In concert, she collaborated with the Mormon Tabernacle Choir, Orchestre de la Suisse Romande, and Zurich's Tonhalle Orchestra, and made a pair of special guest appearances, duetting with singer-songwriter Rufus Wainwright at London's BBC Proms, and joining Broadway star Kristin Chenoweth for a medley of music and comedy at Carnegie Hall.
</p>
<p>
	Throughout her career, Voigt has given definitive performances of iconic roles in German opera, from Richard Strauss's Ariadne, Salome, Kaiserin (<i>Die</i> <i>Frau ohne Schatten</i>) and Chrysothemis (<i>Elektra</i>) to Wagner's Sieglinde (<i>Die Walküre</i>), Elisabeth (<i>Tannhäuser</i>), and Isolde. She is also noted for starring roles in Strauss's <i>Egyptian Helen</i>, <i>Der Rosenkavalier</i>, and<i>Friedenstag</i>; Wagner's <i>Lohengrin</i>; and Berlioz's <i>Les Troyens</i>, and her portrayals of such popular Italian roles as Tosca, Aida, Amelia (<i>Un ballo in maschera</i>), Leonora (<i>La forza del destino</i>), La Gioconda, and Minnie (<i>La fanciulla del West</i>).
</p>
<p>
	Voigt's extensive discography includes two popular and critically successful solo recordings for EMI Classics: <i>All My Heart: Deborah Voigt Sings American Songs</i> with pianist Brian Zeger, named one of the "Best of the Year" by <i>Opera News</i>magazine, and the <i>Billboard</i> top-five bestseller <i>Obsessions</i>, which presents scenes and arias from operas by Wagner and Strauss. Her recording of Strauss's<i> Egyptian Helen </i>was another <i>Billboard</i> bestseller and was again named one of the best of the year by <i>Opera News</i>. Deutsche Grammophon released a live recording of Voigt's headlining role debut in the 2003 Vienna State Opera <i>Tristan und Isolde</i>, as well as a Blu-ray DVD set of her starring role as Brünnhilde in Robert Lepage's visionary Ring cycle at the Met, which won the Grammy Award for Best Opera Recording of 2013.
</p>
<p>
	A devotee of Broadway and American song, Voigt has given acclaimed performances of popular fare, including benefit concerts for Broadway Cares/Equity Fights AIDS and New York Theatre Workshop. She has sung with Barbara Cook and Dianne Reeves at the Hollywood Bowl, and given performances in Lincoln Center's long-running American Songbook series, singing Broadway and popular standards. In the summer of 2011 Voigt won praise as Annie Oakley at the Glimmerglass Festival in Cooperstown, headlining both Irving Berlin's beloved <i>Annie Get Your Gun</i> and her own <i>Voigt Lessons</i>. Millions of viewers heard Voigt sing "America the Beautiful" on NBC's nationwide broadcast of Macy's Independence Day fireworks show in 2004, and later that year they witnessed her majestic ride down Broadway in Macy's Thanksgiving Day parade. She has also been profiled by many important national media outlets, such as CBS's <i>60 Minutes</i>, <i>Good Morning America</i>, and <i>Vanity Fair</i>.
</p>
<p>
	Voigt studied at California State University at Fullerton. She was a member of San Francisco Opera's Merola Program and won both the Gold Medal in Moscow's International Tchaikovsky Competition and First Prize at Philadelphia's Luciano Pavarotti International Voice Competition. A Chevalier dans l'Ordre des Arts et des Lettres, she was <i>Musical</i> <i>America</i>'s Vocalist of the Year 2003, won a 2007 Opera News Award for distinguished achievement, and in 2009 received an Honorary Doctorate from the University of South Carolina. Known to Twitter fans as a "Dramatic soprano and down-to-earth Diva," Voigt was named by the <i>Los Angeles Times</i> as one of the top 25 cultural tweeters to follow.
</p>
