+++
date = "2015-04-07T16:21:00-04:00"
discipline = "Composer"
lastmod = "2015-04-07T16:21:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1621707175/media/2021/05/Watershed-DeanBurryWatershedArtisticDirector_yhrdun.jpg"
publishDate = "2015-04-07T16:21:00-04:00"
related_companies = ["scene/companies/opera-lyra-ottawa.md", "scene/companies/canadian-opera-company.md", "scene/companies/canadian-childrens-opera-company.md"]
slug = "dean-burry"
title = "Dean Burry"
website = "http://www.deanburry.com/"
[[social_media]]
platform = "Twitter"
template = "social-media"
url = "https://twitter.com/dmburry"

+++
Composer and librettist Dean Burry is a storyteller. In addition to his extensive work in the opera and concert music fields, he has become one of the world’s leading composers of children’s opera, his works receiving performances across Canada, the United States, Europe, China and Brazil. At over 600 performances, his opera _The Brothers Grimm_ is one of the most produced operas of the twenty-first century and his operatic adaptation of J.R.R. Tolkien’s _The Hobbit_ recently received its European premiere to sold out houses in Ljubljana, Slovenia. His recent engagement as Artistic Director of the Canadian Children’s Opera Company saw the organization double in size, and included the creation of the first ever Toronto Festival of Children’s Opera, a European tour of the critically-acclaimed production _Brundibàr_, and a star-studded 50th Anniversary Gala at the Four Seasons Centre for the Performing Arts. In addition to a professorship at the Glenn Gould Professional School in Toronto, Burry is the director of the Opera Creation Lab (Centre for Opera Studies in Italy) in Sulmona, Italy and lectures internationally on opera composition and the Canadian operatic canon. Burry is currently an Assistant Professor at the Dan School of Drama and Music at Queen’s University and Artistic Director of the school’s Music Theatre Creation Program.

Burry was born in St. John’s, Newfoundland, but grew up in the small town of Gander. As both his parents’ families came from small outport communities, he spent a great deal of time by the ocean and out in his father’s boat. Music is in the blood of Newfoundlanders, and it was in this environment that Burry began his own artistic journey. Early piano lessons were not completely satisfying, and it wasn’t until a teacher encouraged his desire for composition, at age 10, that music became a passion. Theatre was another great interest and soon he was writing plays and music for the school drama club. His first produced script, _Good Gods_, won the local drama festival in 1987.

Following high school, Burry began studies as a saxophone major at Mount Allison University in Sackville, New Brunswick. In seeking ways to combine his love of theatre and music, he began composing operas and musicals. In his firsts three years at Mt.A, he wrote, produced and conducted three major dramatic musical works: _The Resurrection_, _Joe and Mary Had a Baby_ and _Unto the Earth: Vignettes of a War_.

Shortly after completing graduate composition studies at the University of Toronto, Burry began working in the box office at the Canadian Opera Company while composing incidental music for small theatrical productions. Working in the box office was the opening he needed to begin immersing himself in the Canadian opera world. Most lunches were spent upstairs in the library or chatting with the Education and Outreach Coordinator. He was able to attend rehearsals and learn a great deal about the ways to create successful opera. In 1997, Burry was hired to create and run the After-school Opera Program; a community program designed to expose children to all the elements of opera. Burry finished his tenure with the program following the seventeenth season in 2015.

In 1998, while working as an educator with the Canadian Opera Company in Toronto, he was commissioned to write _The Brothers Grimm_. The opera was a great success and the first work to put the composer on a national stage. _The Brothers Grimm_ has been seen by over 150,000 school children across Canada, the United States and Europe since 2001. In December 2012, the Canadian Opera Company celebrated the 500th performance of the opera with a fairy tale festival called GrimmFest. The performance coincided with the 200th anniversary of the publication of the Grimm’s work. _The_ _Brothers Grimm_ is believed to be the most performed Canadian opera ever and possibly the most performed 21st century opera.

Other major works include _The Hobbit_ for the Canadian Children’s Opera Company and Sarasota Opera, _The Scorpions’ Sting_ for the Canadian Opera Company, _The Vinland Traveler_ and _Le nez de la sorcière_ for Memorial University of Newfoundland, _Pandora’s Locker_ for The Glenn Gould School, _The Mummers’ Masque_ for Toronto Masque Theatre, the CBC serial radio opera _Baby Kintyre_ (released on the Centredisc and Naxos labels in September, 2014) and _Beacon of Light_ for Rising Tide Theatre.

Burry was the 2011 recipient of the Ontario Arts Foundation’s _Louis Applebaum Composers Award_ for excellence in the field of music for young people. His most recent compositions include _Tempest in a Teacup,_ which premiered in Guiyang, China, _The Bells of Baddeck, The Sword in the Schoolyard_ (VIVA! Youth Singers of Toronto), the song cycle _The Highwayman_ and a Montreal Chamber Music Festival commission of Jacob Two-Two Meets the Hooded Fang featuring renowned Canadian tenor Ben Heppner. He is currently working on the operas _Il Giudizio di Pigmalione_ (COSA Canada) and _Shanawdithit_ (Tapestry Opera and Opera on the Avalon) and _Sea Variations_, a song cycle for Canadian Art Song Project and tenor Michael Colvin.