+++
date = "2015-04-07T16:13:00-04:00"
discipline = "Composer"
lastmod = "2015-04-07T16:13:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428437562630/David-Lang-Photo-Credit-Peter-Serling.jpg.jpg"
primary_image_credit = "Peter Serling"
publishDate = "2015-04-07T16:13:00-04:00"
related_companies = ["scene/companies/soundstreams.md", "scene/companies/american-opera-projects.md"]
slug = "david-lang"
title = "David Lang"
website = "http://davidlangmusic.com/"
[[social_media]]
platform = "Facebook"
template = "social-media"
url = "https://www.facebook.com/pages/David-Lang/142037569238754"
[[social_media]]
platform = "Twitter"
template = "social-media"
url = "https://twitter.com/davidlangmusic"

+++
Passionate, prolific, and complicated, composer David Lang embodies the restless spirit of invention. Lang is at the same time deeply versed in the classical tradition and committed to music that resists categorization, constantly creating new forms.

Lang is one of America’s most performed composers. Many of his works resemble each other only in the fierce intelligence and clarity of vision that inform their structures. His catalogue is extensive, and his opera, orchestra, chamber and solo works are by turns ominous, ethereal, urgent, hypnotic, unsettling and very emotionally direct. Much of his work seeks to expand the definition of virtuosity in music — even the deceptively simple pieces can be fiendishly difficult to play and require incredible concentration by musicians and audiences alike.

Lang’s [simple song #3](http://davidlangmusic.com/music/simple-song-3-from-soundtrack-to-youth), written as part of his [score for Paolo Sorrentino’s acclaimed film YOUTH](http://www.bangonacansound.com/music-from-youth), received many awards nominations in 2016, including the Academy Award and Golden Globe.

His opera [_prisoner of the state _](http://davidlangmusic.com/music/prisoner-of-state)(with libretto by Lang) was co-commissioned by the New York Philharmonic, Rotterdam’s De Doelen Concert Hall, London’s Barbican Centre, Barcelona’s l’Auditori, Bochum Symphony Orchestra, and Bruges’s Concertgebouw, and premiered June 2019 in New York, conducted by Jaap van Zweden. _prisoner of the state_ received its UK premiere in January 2020 with the BBC Symphony. The other European premieres were upended by the Covid-19 pandemic, and are [now re-scheduled for 2023](https://davidlangmusic.com/events-category/prisoner-of-the-state/) beginning May 17 in Bochum, Germany and continuing to De Doelen in Rotterdam (Netherlands) on May 20, the Concertgebouw Bruges (Belgium) on May 23, the Malmö Opera (Sweden) on June 2, and L’Auditori de Barcelona (Spain) on July 22.

Lang’s new chamber opera [_note to a friend_](https://davidlangmusic.com/music/note-to-a-friend/) premieres January 12 at the [Japan Society in New York as part of the 2023 PROTOTYPE Festival.](https://davidlangmusic.com/events/note-to-a-friend-performed-by-theo-bleckmann-and-japan-society-string-quartet/) With music and libretto by Lang, note to a friend combines and reimagines three texts by Japanese novelist Ryunosuke Akutagawa — his story “Death Register,” the last chapter of his “In a Grove,” and his suicide note “Note to a Certain Old Friend” — as a monodrama that addresses the eternal human fascination with death, love, family and suicide. Paris-based director Yoshi Oida leads the world premiere production, which stars Theo Bleckmann; an ensemble of Japanese musicians selected by Tokyo Bunka Kaikan perform the score. _note to a friend_ is a co-commission of Japan Society and Tokyo Bunka Kaikan, where it is performed from February 4–5.

2022 has included several noteworthy premieres. [_sun-centered_](https://davidlangmusic.com/music/sun-centered/) for the Tallis Scholars — a large scale choral work designed to share a program with Antoine Brumel’s monumental Renaissance mass for 12 voices Missa Et ecce terræ motus (“and the Earth moved”); [Song of Songs](https://davidlangmusic.com/music/song-of-songs/), a new evening-length work for Pam Tanowitz Dance, commissioned by the Fisher Center at Bard College and touring internationally in 2023; [_flower, forget me_](https://davidlangmusic.com/music/flower-forget-me/), a song cycle for the noted baritone Benjamin Appl, and [_composition as explanation_](https://davidlangmusic.com/music/composition-as-explanation/), a fully staged reimagination of a 1926 lecture by Gertrude Stein, for the chamber ensemble Eighth Blackbird, directed by the acclaimed Anne Bogart.

Other recent works include [_the writings_](https://davidlangmusic.com/music/writings), commissioned by Carnegie Hall and the Netherlands Kamerkoor, and premiered by Theatre of Voices; [_the mile-long opera_](https://davidlangmusic.com/music/mile-long-opera) co-created with architect Elizabeth Diller and premiered in New York City’s mile-long elevated park The Highline; [_symphony without a hero_](https://davidlangmusic.com/music/symphony-without-hero), commissioned and premiered by the Seattle Symphony; [_the loser_](http://davidlangmusic.com/music/loser), which opened the 2016 Next Wave Festival at the Brooklyn Academy of Music, and for which Lang served as composer, librettist and stage director; [_the public domain_](http://davidlangmusic.com/music/public-domain) for 1000 singers at Lincoln Center’s Mostly Mozart Festival; his chamber opera [_anatomy theater_](http://davidlangmusic.com/music/anatomy-theater) at Los Angeles Opera and at the Prototype Festival in New York; the concerto [_man made_](https://davidlangmusic.com/music/man-made) for the ensemble So Percussion and a consortium of orchestras, including the BBC Symphony and the Los Angeles Philharmonic; [_mountain_](http://davidlangmusic.com/music/mountain), commissioned by the Cincinnati Symphony, [_death speaks_](http://davidlangmusic.com/music/death-speaks), a song cycle based on Schubert, but performed by rock musicians, including Bryce Dessner from The National and Shara Worden from My Brightest Diamond; [_the whisper opera_](http://davidlangmusic.com/music/the-whisper-opera), for the International Contemporary Ensemble and soprano Tony Arnold; and [_love fail_](http://davidlangmusic.com/www.davidlangmusic.com/music/love-fail), an evening-length work for the early music vocal ensemble Anonymous 4, with libretto and staging by Lang.

Lang’s works are performed around the globe by the BBC Symphony, the International Contemporary Ensemble, eighth blackbird, Santa Fe Opera, the New York Philharmonic, the Netherlands Chamber Choir, the Boston Symphony, the Munich Chamber Orchestra, the Kronos Quartet and many others; and at festivals and venues such as Lincoln Center, the Southbank Centre, Carnegie Hall, the Kennedy Center, the Barbican Centre, the Brooklyn Academy of Music, Tanglewood, the BBC Proms, MusicNOW festival, The Munich Biennale, the Settembre Musica Festival, the Sydney 2000 Olympic Arts Festival and the Almeida, Holland, Berlin, Adelaide and Strasbourg Festivals.

His music is used regularly for ballet and modern dance around the world by such choreographers as Twyla Tharp, the Paris Opera Ballet, the New York City Ballet, Susan Marshall, Edouard Lock, La La La Human Steps, The Netherlands Dance Theater, and Benjamin Millepied, who choreographed a new piece by Lang for the LA Dance Project at BAM in 2014.

Lang’s film work includes the score to Paolo Sorrentino’s YOUTH, and for Jonathan Parker’s (Untitled), the music for the award-winning documentary The Woodmans, and the string arrangements for Requiem for a Dream, performed by the Kronos Quartet. His music is also on the soundtrack for Paolo Sorrentino’s Oscar-winning La Grande Bellezza.

Lang is the recipient of numerous honors and awards, including the Pulitzer Prize, an Academy Award and Golden Globe nominations, Musical America’s Composer of the Year, Carnegie Hall’s Debs Composer’s Chair, the Rome Prize, the BMW Music-Theater Prize (Munich), and grants from the Guggenheim Foundation, the Foundation for Contemporary Performance Arts, the National Endowment for the Arts, the New York Foundation for the Arts, and the American Academy of Arts and Letters. In 1999, he received a Bessie Award for his music in choreographer Susan Marshall’s The Most Dangerous Room in the House, performed live by the Bang on a Can All-Stars at the Next Wave Festival of the Brooklyn Academy of Music. [The Carbon Copy Building](http://davidlangmusic.com/music/the-carbon-copy-building) won the 2000 Village Voice OBIE Award for Best New American Work. The recording of [the passing measures on Cantaloupe Records](http://davidlangmusic.com/discography/the-passing-measures) was named one of the best CDs of 2001 by The New Yorker. His CD [pierced on Naxos](http://davidlangmusic.com/discography/pierced) was praised both on the rock music site Pitchfork and in the classical magazine Gramophone, and was called his “most exciting new work in years” by the San Francisco Chronicle. The recording of [the little match girl passion released on Harmonia Mundi](http://davidlangmusic.com/discography/the-little-match-girl-passion), received the 2010 Grammy Award for Best Small Ensemble Performance.

A new recording of _the little match girl passion_ will be released in October 2022. This studio recording features soprano Molly Netter, mezzo Kate Maroney, tenor Gene Stenger, bass-baritone Dashon Burton, percussionist Ian Rosenbaum and Jeffrey Douma, conducter. Produced and supervised by the composer, it will be available in both vinyl and digital formats and will be accompanied with the publication of a new score with essays and notes by Lang and musicians who have performed the piece.

Lang is co-founder and co-artistic director of New York’s legendary music collective [Bang on a Can](http://www.bangonacan.org/). His work has been recorded on the Sony Classical, Harmonia Mundi, Teldec, BMG, Point, Chandos, Argo/Decca, and Cantaloupe labels, among others.

His music is published by [Red Poppy Music](http://www.redpoppymusic.com/) and [G. Ricordi & Co., New York](https://www.ricordi.com/en-US/) (ASCAP) and is is distributed worldwide by the Universal Music Publishing Group.