+++
discipline = "Mezzo-soprano"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1680905464/media/2023/04/CharlotteHellekant_MatsB%C3%A4cker_o4qepc.jpg"
primary_image_credit = "Photo: Mats Bäcker"
related_companies = ["scene/companies/la-monnaie.md", "scene/companies/opernhaus-zurich.md", "scene/companies/opra-national-de-paris.md", "scene/companies/against-the-grain-theatre.md", "scene/companies/staatsoper-berlin.md", "scene/companies/bayerische-staatsoper.md", "scene/companies/the-metropolitan-opera.md"]
slug = "charlotte-hellekant"
title = "Charlotte Hellekant"
website = ""
[[social_media]]
platform = "Instagram"
template = "social-media"
url = "https://www.instagram.com/charlottehellekant/"

+++
A vocally expressive and compelling stage performer with a repertoire ranging from the baroque to contemporary classics, Charlotte Hellekant is one of Scandinavia's leading mezzo-sopranos with a career which is equally successful on both the opera stage and concert platform. She has inspired some of the world’s leading composers to write especially for her. This includes Toshio Hosokawa who created the role of Murasame for her in his acclaimed _Matsukaze_. Subsequently, Hosokawa wrote his monodrama _The Raven_ for her, which she premiered in concert performances with Ensemble Lucilin in Brussels, Amsterdam and Japan. Hellekant also received particular acclaim for her _tour de force_ performance as Sweden’s schizophrenic King Erik XIV - a role also created for her - in Mikko Heiniö’s eponymous opera and most recently she premiered a new work by Stefano Gervasoni, _In die Luft geschrieben_, with Münchner Kammerorchester.

Charlotte Hellekant has made her mark on opera stages on both sides of the Atlantic, most notably at the Metropolitan Opera, Opéra national de Paris and Glyndebourne Festival. Lyric roles include Charlotte (_Werther_) with Deutsche Oper Berlin and _Carmen_ with Royal Swedish Opera, whilst outstanding Handel interpretations include Ino (_Semele_) at the Théâtre des Champs Elysées and Cornelia (_Giulio Cesare_) under Marc Minkowski for Opernhaus Zürich. She appeared as Marguérite in La Fura dels Baus’ spectacular production of _La damnation de Faust_ at Salzburger Festspiele under Sylvain Cambreling and sang the role of Judith in _Duke Bluebeard’s Castle_ in concert at the Bergen Festival under Edward Gardner. 

Other highlights include recent role debuts as Clairon in David Marton’s production of Capriccio at La Monnaie under the baton of Lothar Koenigs and as Charlotte in Höstsonaten for Malmö Opera undert Patrik Ringborg.

Performance highlights in the 2022/23 season include Polina in rescheduled performances of _Pique Dame_ conducted by Nathalie Stutzmann at La Monnaie, a role debut as Jitsuko in Hosokawa’s _Hanjofor_ Bayerische Staatsoper, and performances of Sasha Waltz and Guests’ beautifully choreographed staging of _L’Orfeo_ under the baton of Leonardo Garcia Alarcon at the Teatro Real. 

In concert, Charlotte Hellekant has collaborated with many notable conductors and orchestras, including Christoph von Dohnányi at the BBC Proms, Esa-Pekka Salonen and Philharmonia Orchestra, Jukka-Pekka Saraste and Finnish Radio Symphony Orchestra, and Los Angeles Philharmonic under Gustavo Dudamel. Performance highlights include Mahler’s Symphony No.8 with Utah Symphony (Thierry Fischer) and released on the Reference Records label, Berio’s _Folksongs_ and Canteloube’s _Chants d’Auvergne_ with Norrköping Symphony Orchestra (Martin Fröst) and Janáček’s _Glagolitic Mass_ with the Orquesta y Coro Nacionales de España (Xian Zhang). Other recent successes include Lili Boulanger’s rarely performed cantata _Faust et Hélène_ with Oslo Philharmonic Orchestra (James Gaffigan), _Gurrelieder_ at the Festival de Música de Canarias (Josep Pons) and both Beethoven’s Symphony No.9 and Berg’s _Sieben frühe Lieder_ with Orchestre National de France. 

Extending her craft beyond performing, Charlotte Hellekant created a staged version of _The Raven_ which she performed at the Grand Théâtre de Luxembourg and Théâtre des Bouffes du Nord in Paris. She curated, produced and performed Hedvig Leonora, a celebration of the life of the 17th-century Swedish Regent at Drottningholms Slottsteater. Most recently she created and co-directed a tribute to art, science and innovation - _Festive Gala_ – to mark the post-pandemic re-opening of the Royal Swedish Opera.