+++
date = "2015-05-25T21:33:00-04:00"
discipline = "Mezzo-soprano"
lastmod = "2015-05-25T21:33:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1432603743944/Ceci.jpg.jpg"
primary_image_credit = "Decca/Uli Weber"
publishDate = "2015-05-25T21:33:00-04:00"
related_companies = ["scene/companies/the-metropolitan-opera.md","scene/companies/teatro-alla-scala.md","scene/companies/bayerische-staatsoper.md","scene/companies/royal-opera-house.md","scene/companies/wiener-staatsoper.md","scene/companies/opernhaus-zurich.md"]
slug = "cecilia-bartoli"
title = "Cecilia Bartoli"
website = "http://ceciliabartolionline.com/"
[[social_media]]
platform = "Facebook"
template = "social-media"
url = "https://www.facebook.com/bartolicecilia"
+++

For more than two decades, Cecilia Bartoli has indisputably been one of the leading artists in the field of classical music. Her new opera roles, concert programmes and recording projects – exclusively on Decca – are eagerly awaited all over the world. The enormous success of her solo releases such as *The Vivaldi Album, Italian Arias by Gluck, The Salieri Album, Opera proibita, Maria, Sacrificium* and *Mission* is reflected both in extraordinary sales which have firmly established her as today’s best-selling classical artist –  more than 10 million copies of audio and video releases occupying the international pop charts for well over 100 weeks and garnering numerous “gold” and “platinum” certifications – and in major awards: five Grammys® (USA), ten Echos and a Bambi (Germany), two Classical Brit Awards (UK), the Victoire de la Musique (France) as well as many other prestigious prizes.

Cecilia Bartoli has brought classical music to millions of people all over the world. But beyond this fact, she is especially gratified that the popularity of her projects has kindled discussions that always lead to comprehensive re-evaluation and rediscovery – that of composers who have been passed over and of repertoire which has been forgotten.

Herbert von Karajan, Daniel Barenboim and Nikolaus Harnoncourt were among the first conductors with whom Cecilia Bartoli worked. They noticed her talent at a very early stage, when she had barely completed her vocal studies with her parents in her home-town of Rome. Since then, many further renowned conductors, pianists and orchestras have been her regular partners. In recent years, her work has begun to focus on collaborations with the most significant period-instrument orchestras (Akademie für Alte Musik, Les Arts Florissants, I Barocchisti, Concentus Musicus Wien, Freiburg Baroque Orchestra, Il Giardino Armonico, Basle Chamber Orchestra, Ensemble Matheus, Les Musiciens du Louvre, Orchestra of the Age of Enlightenment and the Zurich period orchestra La Scintilla). Projects with orchestras in which Cecilia Bartoli assumes the overall artistic responsibility have also become increasingly important to her and were crowned by programmes jointly developed and performed with the Vienna Philharmonic Orchestra.

Cecilia Bartoli sings in the most important concert halls of Europe, North America, Asia and Australia. Her stage appearances include prestigious opera houses and festivals such as the Metropolitan Opera in New York, the Royal Opera House Covent Garden in London, La Scala in Milan, the Bavarian State Opera in Munich, the Salzburg Festival, the Zurich Opera House and the Théâtre des Champs Élysées in Paris.

Cecilia Bartoli devoted herself to the early 19th century – the age of Italian Romanticism and bel canto – in 2008 and in particular to the legendary singer Maria Malibran, whose 200th birthday fell on 24 March. To mark the bicentenary, the artist released a new album, *Maria* (Edison Award, Prix Caecilia), and the DVD *Maria* (The Barcelona Concert/Malibran Rediscovered). Rounding off this homage to Maria Malibran and the “Romantic Revolution” were the first complete recording of *La sonnambula* with period instruments and a mezzo-soprano in the title role (with Juan Diego Flórez as Elvino) and a historically informed rendering of *Norma* at the Dortmund Konzerthaus in June 2010, with Cecilia Bartoli in the title role.

Much of the artist’s 2009/10 season was dedicated to a rediscovery of music written for the great Neapolitan castrato stars of the 18th century. The release of the record-breaking solo album Sacrificium in October 2009 was accompanied by concerts featuring this repertoire in all the major European musical capitals.

2010 also saw Decca’s DVD release of the Zurich Opera production of Halévy’s tragicomic opera *Clari*, with Cecilia Bartoli essaying the role created by Maria Malibran and Adam Fischer conducting the period-instrument orchestra La Scintilla. Also released on CD and digital download: *Sospiri*, a collection of intimate arias from Cecilia’s best-loved albums. Autumn 2012 marked the release of *Mission*, showcasing arias and duets by the Italian Baroque composer Agostino Steffani. Cecilia Bartoli’s collaborators in this multi-media project (featuring a special iPad app) include Philippe Jaroussky as well as the Coro della Radiotelevisione Svizzera and the period orchestra I Barocchisti under conductor Diego Fasolis. In conjunction with this rapturously acclaimed project (“With *Mission* she surpasses herself … It’s as though this music had been waiting for an individualist like Bartoli to discover it.” – Frankfurter Allgemeine Zeitung), Cecilia Bartoli, I Barocchisti and Diego Fasolis have undertaken an extensive European tour in 2012–13. Their new recording of the Steffani *Stabat Mater* appeared in September 2013.

In 2012 Cecilia Bartoli became Artistic Director of the Salzburg Whitsun Festival. In her first year, the theme was Cleopatra. In 2013 the festival was subtitled “Sacrifice – Opfer – Victim” and included a new milestone in Cecilia Bartoli’s career: her stage debut as *Norma*, with Giovanni Antonini conducting the Orchestra La Scintilla. The same month, May 2013, brought the audio release of Bellini’s opera starring Cecilia Bartoli and conducted by Antonini.

March 2014 saw the release of two Rossini operas starring Bartoli on DVD/Blu-ray, L*e Comte Ory* and *Otello*. In April she sang Desdemona in the latter opera in her triumphant return to the Paris stage after an absence of more than 20 years. And in October of this year, Decca is issuing St Petersburg, featuring Baroque arias composed for the court of Catherine the Great and two of her predecessors. Rediscovered by Cecilia Bartoli herself in St. Petersburg, these hidden musical treasures of Tsarist Russia also offer the first opportunity to hear the artist singing in Russian. The new project reunites her with I Barocchisti and Diego Fasolis.

Cecilia Bartoli has been awarded the Italian knighthood and is an “Accademico effettivo” of Santa Cecilia, Rome, a French Chevalier des Arts et des Lettres, Chevalier de la Légion d’Honneur and Officier de l’Ordre du Mérite as well as an Honorary Member of the Royal Academy of Music, London and of the Royal Swedish Academy of Music. Most recently, she was given the prestigious Italian prize Bellini d’Oro, a Medalla de Oro al Mérito en las Bellas Artes, one of the highest awards of the Spanish Ministry of Culture, and the Médaille Grand Vermeil de la Ville de Paris. On the occasion of the Handel anniversary year of 2009, Cecilia Bartoli was made an honorary member of the advisory board of the Halle Handel House Foundation, and the following year she received the Halle Handel Prize. Also in 2010, she was awarded the renowned Danish Léonie Sonning Music Prize in Copenhagen, in the presence of Her Majesty Queen Margrethe II, as well as an honorary doctorate by the venerable University College of Dublin. In 2012 she was awarded the Herbert von Karajan Prize in Baden-Baden, together with a rare Swiss Award for Culture, and she was made a Chevalier de l’Ordre du Mérite Culturel by the Principality of Monaco.
