+++
date = "2017-12-04T19:43:00-05:00"
discipline = "Soprano"
lastmod = "2017-12-04T19:43:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1512434040898/IMG_1921.jpg.jpg"
primary_image_credit = "Victor Santiago"
publishDate = "2017-12-04T19:43:00-05:00"
related_companies = ["scene/companies/royal-opera-house.md","scene/companies/bayerische-staatsoper.md","scene/companies/scottish-opera.md","scene/companies/the-metropolitan-opera.md","scene/companies/teatro-alla-scala.md","scene/companies/los-angeles-opera.md","scene/companies/deutsche-oper-berlin.md","scene/companies/wiener-staatsoper.md"]
slug = "carmen-giannattasio"
title = "Carmen Giannattasio"
website = "http://www.carmengiannattasio.com/"
[[social_media]]
platform = "Youtube"
template = "social-media"
url = "https://www.youtube.com/user/CarmenGiannattasioFC"
+++

Hailed by the Telegraph as "the most talented of the younger Italian sopranos", Carmen Giannattasio has blazed a trail across stages the world over. Her unique talent has been in demand worldwide since her career was launched by taking First Prize and the Audience Award at Placido Domingo’s Operalia, Paris in 2002. Her lustrous soprano voice and her dramatic ability gained her immediate critical attention and a reputation as a chameleon, able to adapt her tune and skin to the different heroines she embodies.. It was her performance as Violetta in 2007 at Scottish Opera in *La Traviata* which catapulted her into the limelight with Rupert Christiansen commenting in the Daily Telegraph "…a deeply intelligent and profoundly affecting interpretation in the Cotrubas and Scotto mould."

Since being chosen to front important new bel canto recordings by Opera Rara, who champion rarely performed operas of the 19th century, she has distinguished herself in Rossini’s *La donna del lago*, Donizetti’s *Parisina* and in particular Rossini’s *Ermione* – a performance which has earned her plaudits from leading critics worldwide, with the recording winning the 2011 Gramophone Opera Award. Her recordings with the English label also include Bellini’s *Il Pirata* (2010) and Donizetti’s *Caterina Cornaro* (2011).

It wasn’t only the favour of the critics Carmen Giannattasio won by stepping in at the eleventh hour for John Copley’s production of *La Boheme* at the Royal Opera House, Covent Garden in 2012. This triumphant debut also began a new chapter in her career, starting with her debut at Metropolitan Opera in New York as Leonora in David McVicar’s production of Verdi’s *Il Trovatore* in September of the same year. Following buy an essay performances in two of the world’s leading opera houses, Carmen opened the season at Teatro San Carlo, Naples with a glamorous performance as Violetta in the triumphant production of *La Traviata* directed by renowned Italian/Turkish film director Franz Ozpetek, who described her as: "first class… fiery and sensual".

Carmen’s engagements kept rising over 2013 and the soprano found herself in major venues both at home and abroad. Highlights of 2013 were Mrs Alice in Robert Carsen’s new production of Verdi’s *Falstaff* at La Scala, Milan, Verdi‘s *La Traviata* at Hong Kong Arts Festival, Leonora in Philipp Stolzl’s new production of Verdi’s *Il Trovatore* at Wien Festwochen, Desdemona in Jose Cura’s new production of Verdi’s *Otello* at Teatro Colon of Buenos Aires, Alice in Blakeley’s new production of *Falstaff* at Los Angeles Opera conducted by James Conlon. Giannattasio’s solo performance at the New Year’s concert at La Fenice, Venice under the baton of Diego Matheuz in 2014 was broadcast worldwide, opening a very busy season for the eclectic soprano. Besides a main role in Verdi’s *Requiem* in Valencia Palau de las Artes, *Turandot* (Liu) at Teatro Regio of Turin conducted by P. Steinberg and at Arena of Verona, La Boheme (Mimí), *Il Trovatore* at Teatro La Fenice in Venice and in *Simon Boccanegra* (Amelia) at La Scala, the unstoppable soprano appeared also in *Maria Stuarda* (Elisabetta)  at Deutsche Oper Berlin in concert version, and, in a new production by Moshe Leiser, at the Royal Opera House in London, to critical acclaim.

Her recent schedule has included  Rossini’s *Il Viaggio a Reims* (Madama Cortese), followed by her debut in the title role of Bellini’s *Norma*, presented for the first time in the Middle-east as an highlight of the Al Bustan Festival in Beirut. George Loomis wrote in Opera Magazine: "Giannattasio’s first Norma was a considerable achievement". Her interpretations as Mimí in Götz Friederich’s production of *La Bohème* at the Deutsche Oper and her performance as Liú in Puccini’s *Turandot* at San Carlo in March 2015 were highly praised by critics. 2015 also marks Giannattasio’s debut in Asia where she again performed the title role in *Norma* in Beijing to critical acclaim, warranting her a National Centre of Performing Arts magazine cover and main feature article. In summer 2015 Giannattasio made her debut at Theatre des Champs Elysées in Paris, in Maria Stuarda. In July she played Mimì in *La Bohème* at Hannover’s Open Air Opera, "The Arena of Verona in the north German lowlands" as described by the Prime Minister of Lower Saxony, David McAllister.

2015/16 season has seen Carmen in a new production of *Il Trovatore* by La Fura del Baus at the Nederlandse Opera in Amsterdam, a very successful new production of Pagliacci at the Royal Opera House London under the baton of Sir Antonio Pappano, which has won The Laurence Olivier award and the critical acclaim. A real triumph in *Norma* with Munich Staatsoper, *Pagliacci* at Berlin’s Deutsche Oper in March directed by David Pountney, *Simon Boccanegra* at La Scala under the baton of M. W. Chung.

She has been on tour with Teatro Alla Scala with *Simon Boccanegra* at Moscow’s Bolshoi Theatre,  Asian Arts Center in Shangai, and opened the new Lotte Concert Hall in Seul. Carmen has also opened the Edinburgh Festival with *Stabat Mater* by Rossini conducted by sir Tony Pappano with Accademia di Santa Cecilia.

Carmen has recently sung at Vatican’s Sala Nervi in a special concert broadcasted worldwide by RAI Television in presence of his Holiness Pope Francesco

2016/2017 season she appeared in: a new David McVicar’s production of *Falstaff* conducted by Zubin Mehta at the Wiener Staatsoper, *La Boheme* at Deutsche Oper in Berlin, a new production of *Falstaff* at Teatro alla Scala conducted by Z. Mehta, *La Traviata* at Metropolitan in New York, Te Deum by Bruckner at Maggio Musicale fiorentino conducted by Z. Mehta,  *I Pagliacci* in Dresden.

Her upcoming performances are: *Turandot* at 63th Festival Pucciniano in Torre del Lago, *Falstaff* on Tour with Teatro alla Scala, *Il trovatore* at the Wiener Staatsoper, *I Masnadieri* at Abao in Bilbao, *Pagliacci* at ROH in London, a new production of *Les Vepres Siciliennes* at the Bayerische Staatsoper in Munich, *Mefistofele* at Orange Festival, *I Masnadieri* at the Opera de Montecarlo, a new production of *Tosca* at San Francisco Opera, *Don Carlo* at Teatro di San Carlo in Naples, *Norma* at Bayerische Staatsoper

Carmen Giannattasio is an ambassador for the Italian jewelers Bulgari and is dressed by couturier Antonio Riva. She is also an ambassador for Carthusia, the Italian brand of beauty and bath products based in Capri Island.

In February 2017 Carmen has received the title of Cavaliere dell’Ordine della Stella della Repubblica Italiana.
