+++
discipline = "Soprano"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1667352253/media/2022/11/BrittHewitt_kpdcyq.jpg"
primary_image_credit = ""
related_companies = ["scene/companies/american-opera-projects.md", "scene/companies/the-juilliard-school.md", "scene/companies/experiments-in-opera.md"]
slug = "britt-hewitt"
title = "Britt Hewitt"
website = "https://www.britthewitt.com/"
[[social_media]]
platform = "Instagram"
template = "social-media"
url = "https://www.instagram.com/britt.hew/"
[[social_media]]
platform = "Youtube"
template = "social-media"
url = "https://www.youtube.com/watch?v=UsvMcM3bS5Q"

+++
Britt Hewitt is a New York City based soprano and singer/songwriter. A devoted experimentalist, she can often be found working with composers on new works, writing and producing music of her own, and teaching a small number of students in voice and writing. Hewitt holds a Bachelor of Music from [**The Juilliard School**](https://www.juilliard.edu/), and is a member of the [**New York Songwriters Circle**](https://songwriters-circle.com/).

Hewitt hasn't known a life without music. Her parents recall her penning her own songs at the age of three, and she was always eager to perform from the family coffee table in her hometown of Jacksonville, Florida. She started taking formal lessons in country music singing at the age of eight. By twelve, she was performing for local television, winning competitions, and recording her own music. She was accepted into [**LaVilla Middle School of the Arts**](https://dcps.duvalschools.org/Page/336), where she studied music theory and history, classical and jazz, and musical theatre. Her final year at LaVilla marked her first performance in opera, when the school put together a pastiche program for the Metropolitan Opera's education team.

After her first year studying choral music and musical theatre at [**Douglas Anderson School of the Arts**](https://dcps.duvalschools.org/anderson), Hewitt and her family relocated to Dallas, Texas. She transferred into [**Booker T. Washington High School for the Performing and Visual Arts**](https://dcps.duvalschools.org/anderson), where she continued her studies in choral music, opera, and jazz. There, she performed numerous roles, including Mother in _Hansel and Gretel_, Pamina in _The Magic Flute_, Mother in _Amahl and the Night Visitors_, and Chrissy in the musical _Hair._ Hewitt was also an active member of student government, and went on to become the school's Student Council President. She was also awarded an internship with the [**Dallas Symphony Orchestra**](https://www.dallassymphony.org/), with whom she worked on developing educational programs. At seventeen, Hewitt became an official contestant for [**NBC's The Voice**](https://www.nbc.com/the-voice), though the teams filled up before her audition was scheduled to take place.

In 2016, Hewitt graduated from Booker T. a recipient of one of the two administered Principal's Awards. That fall, she moved to New York City to begin her studies at Juilliard under the tutelage of the late **Sanford Sylvan**, and **William Burden**. During her time there, she performed roles including Miles in _The Turn of the Screw_, the Spirit in the French, English, and American tour of _Dido and Aeneas_, Blanche de la Force in a devised work entitled _There's Blood Between Us_, based on _Dialogues of the Carmelites_, and Mistress Quickly in a devised work based on _Die Lustigen Weiber von Windsor._ Outside of school, in 2018, she joined the New York Songwriters Circle, performed her first showcase at [**The Bitter End** ](https://bitterend.com/#/events)and won second place in the [**NYC Mayor's Office of Media and Entertainment My NYC Song Contest**](https://www1.nyc.gov/site/mome/industries/mynycsong-winners.page)**.** Hewitt was afforded other opportunities in venues such as [**National Sawdust**](https://nationalsawdust.org/), [**Le Château de Versailles**](https://en.chateauversailles.fr/), and [**Holland Park**](https://operahollandpark.com/)**.** She also worked with student composers to develop new works, performed in multiple new music centric recitals, and started her formal music production education and work in the school's [**Center for Innovation in the Arts**](https://www.juilliard.edu/school/academics/center-innovation-arts/center-innovation-arts-courses). She was a [**Gluck Fellow**](https://www.juilliard.edu/juilliard-all/community-engagement-programs/interactive-concerts-and-fellowships), for which she performed at dozens of care centers and hospitals across all New York City boroughs. Her culminating senior recital, _WOMAN_, featured work by female composers from the 20th & 21st centuries, including herself.

Since graduating from Juilliard, Hewitt has worked with virtual and in-person companies and projects to develop new works across the world, including [**The American Opera Project**](https://www.aopopera.org/), [**Opera Harmony**](https://operavision.eu/en/library/performances/digital-opera/opera-harmony)**,** [**National Sawdust**](https://nationalsawdust.org/)**,** and [**Experiments in Opera,**](https://experimentsinopera.com/)**.** For the latter, she will create the title role in [_Everything for Dawn_](https://experimentsinopera.com/portfolio-item/everythingfordawn/), which will be televised and streamed in 2022. She was commissioned by [**The Peace Studio**](https://thepeacestudio.org/day-97/) to translate, produce, and record an original song with Corsican artist [**Petru Canon**](https://m.facebook.com/Petru-Canon-569437700147267/). The resulting work, [_Dì Mi L'Amore_](https://levelmusic.lnk.to/3qd9m7), can be heard during the ending credits of [**Conversations that #OfferPeace**](https://thepeacestudio.org/conversations-that-offerpeace/) with world leaders and renowned artists in collaboration with [**NowThis**](https://www.facebook.com/watch/?v=2712503369023332) and [**PBS All Arts**](https://allarts.org/programs/conversations-that-offerpeace/). For her vocal contributions to work in progress _Faces of God. _she was mentioned in [**Vogue Italy**](https://www.vogue.it/vogue-talents/gallery/danza-e-moda-life-is-a-performance-di-terrence-zhou)**.** In the summers of 2020 and 2021, she studied at Blue Hill, Maine's historic [**Kneisel Hall Chamber Music Festival**](https://kneisel.org/), and was the first vocalist to do so. Hewitt released her debut self-produced EP, [_Unfastened_](https://levelmusic.lnk.to/kf9sQY), in June 2021. She has a small roster of students to which she teaches vocal technique.

When she isn't working in music, Hewitt can be found hiking**,** rewatching Fleabag, or teaching her cat, Rosita, new tricks.