+++
date = "2015-04-06T22:44:00-04:00"
discipline = "Composer"
lastmod = "2015-04-06T22:44:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428374572822/BrianCurrent.jpg.jpg"
publishDate = "2015-04-06T22:44:00-04:00"
related_companies = ["scene/companies/soundstreams.md","scene/companies/the-bicycle-opera-project.md","scene/companies/tapestry-opera.md"]
slug = "brian-current"
title = "Brian Current"
website = "http://www.briancurrent.com/"
[[social_media]]
platform = "Twitter"
template = "social-media"
url = "https://twitter.com/bcurrent"
+++

<p>
	A graduate of McGill University in Montreal and U. C. Berkeley, Brian Current writes music that is brimming with energy – sometimes with the propulsive rhythms of so-called minimalist music, sometimes with a more delicate sense of flux, but almost always with a sense of motion and playfulness about the treatment of time and texture. These features have won him numerous honors, including a Guggenheim Fellowship, the Barlow Prize for Orchestral Music, and Italy's Premio Fedora for his new chamber opera <em>Airline Icarus</em>.
</p>
<p>
	Temporal plasticity is especially compelling in Current's large ensemble scores <em>For the Time Being</em> (1999) and <em>Symphonies in Slanted Time</em> (2005). In the latter, Current explains, the music "is always speeding up or always slowing down. Rather than write music for a steady metronome, I wondered if it were possible to make the change in tempo the normal state of the music... using rejuvenation to create constantly changing textures." He has put these principles to a variety of expressive uses, in such works as the recent <em>Whirling Dervish</em> (2010) or the orchestral tone poem <em>Kazabazua</em> (2002, rev. 2006) which describes the "flow and restlessness" of a partially underground river in the Gatineau hills north of Ottawa.
</p>
<p>
	Current's virtuoso handling of instrumental ensembles stems in part from his work as a conductor, which has placed him at the helm of a dozen or so ensembles and symphony orchestras. Also perhaps linked to his experience on the conductor's podium is a very sensitive, almost tactile treatment of musical texture–the interplay between discrete lines of material or groups of players in the moment of performance. This preoccupation is readily apparent in <em>This Isn't Silence</em> (1998, rev. 2001) which lends its title to a CD of his music released by Centredisques in 2007. It can also be heard in Current's<em>Concertino</em> for flute, string orchestra, and three flutes dispersed around the concert hall. Here, the composer "imagined blanketing the hall of with the sound of flutes positioned at the back of the room. At times they act as distant relatives to the solo line but more often they fill out the sound with tumbling gestures of their own." A similarly imaginative handling of texture can be in Current's 2009 score, <em>Strata.</em>
</p>
<p>
	Combining his activities as composer and conductor, Current has engaged in some astonishing and successful public interventions on behalf of new music. Since 2006, he has been artistic director and conductor of the Royal Conservatory of Music's New Music Ensemble in Toronto. In 2009, he supervised a 12-hour, 200-person installation-performance of James Tenney's <em>In a Large Open Space,</em> which drew an estimated 15,000 people to the opening of the Conservatory's new Koerner Hall. He has also composed a real-time introduction to twentieth-and twenty-first-century music called <em>This Isn't Silence: A Young Person's Guide to New Music for Symphony Orchestra</em> (2008), and in May 2010 he curated a concert series devoted to young composers that was aired on the Canadian Broadcasting Corporation [CBC] Radio 2.
</p>
<p>
	In 2001, Current's score <em>For the Time Being</em> won the Grand Prize in the CBC's National Competition for Young Composers, after which it was honored by the International Rostrum of Composers in Paris and was selected as part of the inaugural concert program for the 2002 Warsaw Autumn Festival. Next month, the Royal Winnipeg Ballet will take on tour a full-evening ballet featuring three of Current's scores alongside works by John Estacio. And later this season, the Kitchener Waterloo Symphony Orchestra will give the world premiere of <em>Whirling Dervish, for Sufi Whirling and Symphony Orchestra,</em> commissioned with funds from the Barlow Endowment.
</p>
<p>
	© Beth Levy, San Francisco Contemporary Music Players
</p>
